/* book.c generated by valac 0.28.0, the Vala compiler
 * generated from book.vala, do not modify */

/*
 * Copyright (C) 2009-2011 Canonical Ltd.
 * Author: Robert Ancell <robert.ancell@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <cairo.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <cairo-ps.h>
#include <zlib.h>
#include <gobject/gvaluecollector.h>


#define TYPE_BOOK (book_get_type ())
#define BOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOK, Book))
#define BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOK, BookClass))
#define IS_BOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOK))
#define IS_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOK))
#define BOOK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOK, BookClass))

typedef struct _Book Book;
typedef struct _BookClass BookClass;
typedef struct _BookPrivate BookPrivate;

#define TYPE_PAGE (page_get_type ())
#define PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE, Page))
#define PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE, PageClass))
#define IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE))
#define IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE))
#define PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE, PageClass))

typedef struct _Page Page;
typedef struct _PageClass PageClass;
#define _page_unref0(var) ((var == NULL) ? NULL : (var = (page_unref (var), NULL)))
#define __g_list_free__page_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__page_unref0_ (var), NULL)))
#define _g_byte_array_unref0(var) ((var == NULL) ? NULL : (var = (g_byte_array_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))

#define TYPE_PS_WRITER (ps_writer_get_type ())
#define PS_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PS_WRITER, PsWriter))
#define PS_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PS_WRITER, PsWriterClass))
#define IS_PS_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PS_WRITER))
#define IS_PS_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PS_WRITER))
#define PS_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PS_WRITER, PsWriterClass))

typedef struct _PsWriter PsWriter;
typedef struct _PsWriterClass PsWriterClass;
typedef struct _PsWriterPrivate PsWriterPrivate;
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _ps_writer_unref0(var) ((var == NULL) ? NULL : (var = (ps_writer_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_PDF_WRITER (pdf_writer_get_type ())
#define PDF_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PDF_WRITER, PDFWriter))
#define PDF_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PDF_WRITER, PDFWriterClass))
#define IS_PDF_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PDF_WRITER))
#define IS_PDF_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PDF_WRITER))
#define PDF_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PDF_WRITER, PDFWriterClass))

typedef struct _PDFWriter PDFWriter;
typedef struct _PDFWriterClass PDFWriterClass;
typedef struct _PDFWriterPrivate PDFWriterPrivate;
#define _pdf_writer_unref0(var) ((var == NULL) ? NULL : (var = (pdf_writer_unref (var), NULL)))
typedef struct _ParamSpecBook ParamSpecBook;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _ParamSpecPDFWriter ParamSpecPDFWriter;
typedef struct _ParamSpecPsWriter ParamSpecPsWriter;

struct _Book {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BookPrivate * priv;
};

struct _BookClass {
	GTypeClass parent_class;
	void (*finalize) (Book *self);
};

struct _BookPrivate {
	GList* pages;
	gboolean needs_saving_;
	GByteArray* jpeg_data;
};

struct _PsWriter {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PsWriterPrivate * priv;
	cairo_surface_t* surface;
	GFileOutputStream* stream;
};

struct _PsWriterClass {
	GTypeClass parent_class;
	void (*finalize) (PsWriter *self);
};

struct _PDFWriter {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PDFWriterPrivate * priv;
	gsize offset;
	GList* object_offsets;
};

struct _PDFWriterClass {
	GTypeClass parent_class;
	void (*finalize) (PDFWriter *self);
};

struct _ParamSpecBook {
	GParamSpec parent_instance;
};

struct _PDFWriterPrivate {
	GFileOutputStream* stream;
};

struct _ParamSpecPDFWriter {
	GParamSpec parent_instance;
};

struct _ParamSpecPsWriter {
	GParamSpec parent_instance;
};


static gpointer book_parent_class = NULL;
static gpointer pdf_writer_parent_class = NULL;
static gpointer ps_writer_parent_class = NULL;

gpointer book_ref (gpointer instance);
void book_unref (gpointer instance);
GParamSpec* param_spec_book (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_book (GValue* value, gpointer v_object);
void value_take_book (GValue* value, gpointer v_object);
gpointer value_get_book (const GValue* value);
GType book_get_type (void) G_GNUC_CONST;
gpointer page_ref (gpointer instance);
void page_unref (gpointer instance);
GParamSpec* param_spec_page (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_page (GValue* value, gpointer v_object);
void value_take_page (GValue* value, gpointer v_object);
gpointer value_get_page (const GValue* value);
GType page_get_type (void) G_GNUC_CONST;
#define BOOK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_BOOK, BookPrivate))
enum  {
	BOOK_DUMMY_PROPERTY
};
static void book_page_changed_cb (Book* self, Page* page);
static void _book_page_changed_cb_page_pixels_changed (Page* _sender, gpointer self);
static void _book_page_changed_cb_page_crop_changed (Page* _sender, gpointer self);
static void _page_unref0_ (gpointer var);
static void _g_list_free__page_unref0_ (GList* self);
Book* book_new (void);
Book* book_construct (GType object_type);
void book_clear (Book* self);
void book_set_needs_saving (Book* self, gboolean value);
void book_append_page (Book* self, Page* page);
void book_move_page (Book* self, Page* page, guint location);
void book_reverse (Book* self);
void book_combine_sides (Book* self);
guint book_get_n_pages (Book* self);
void book_combine_sides_reverse (Book* self);
void book_delete_page (Book* self, Page* page);
Page* book_get_page (Book* self, gint page_number);
guint book_get_page_index (Book* self, Page* page);
static GFile* book_make_indexed_file (Book* self, const gchar* uri, gint i);
static void book_save_multi_file (Book* self, const gchar* type, gint quality, GFile* file, GError** error);
void page_save (Page* self, const gchar* type, gint quality, GFile* file, GError** error);
static void book_save_ps_pdf_surface (Book* self, cairo_surface_t* surface, GdkPixbuf* image, gdouble dpi);
static void book_save_ps (Book* self, GFile* file, GError** error);
gpointer ps_writer_ref (gpointer instance);
void ps_writer_unref (gpointer instance);
GParamSpec* param_spec_ps_writer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_ps_writer (GValue* value, gpointer v_object);
void value_take_ps_writer (GValue* value, gpointer v_object);
gpointer value_get_ps_writer (const GValue* value);
GType ps_writer_get_type (void) G_GNUC_CONST;
PsWriter* ps_writer_new (GFileOutputStream* stream);
PsWriter* ps_writer_construct (GType object_type, GFileOutputStream* stream);
GdkPixbuf* page_get_image (Page* self, gboolean apply_crop);
gint page_get_dpi (Page* self);
static guint8* book_compress_zlib (Book* self, guint8* data, int data_length1, int* result_length1);
static guint8* book_compress_jpeg (Book* self, GdkPixbuf* image, gint quality, gint dpi, int* result_length1);
static gboolean book_write_pixbuf_data (Book* self, guint8* buf, int buf_length1, GError** error);
static gboolean _book_write_pixbuf_data_gdk_pixbuf_save_func (guint8* buf, gsize buf_length1, GError** error, gpointer self);
static void book_save_pdf (Book* self, GFile* file, gint quality, GError** error);
gpointer pdf_writer_ref (gpointer instance);
void pdf_writer_unref (gpointer instance);
GParamSpec* param_spec_pdf_writer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pdf_writer (GValue* value, gpointer v_object);
void value_take_pdf_writer (GValue* value, gpointer v_object);
gpointer value_get_pdf_writer (const GValue* value);
GType pdf_writer_get_type (void) G_GNUC_CONST;
PDFWriter* pdf_writer_new (GFileOutputStream* stream);
PDFWriter* pdf_writer_construct (GType object_type, GFileOutputStream* stream);
void pdf_writer_write_string (PDFWriter* self, const gchar* text);
guint pdf_writer_start_object (PDFWriter* self);
gboolean page_get_is_color (Page* self);
gint page_get_depth (Page* self);
static guint8* _vala_array_dup1 (guint8* self, int length);
static guint8* _vala_array_dup2 (guint8* self, int length);
void pdf_writer_write (PDFWriter* self, guint8* data, int data_length1);
void book_save (Book* self, const gchar* type, gint quality, GFile* file, GError** error);
gboolean book_get_needs_saving (Book* self);
static void g_cclosure_user_marshal_VOID__PAGE (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void book_finalize (Book* obj);
#define PDF_WRITER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PDF_WRITER, PDFWriterPrivate))
enum  {
	PDF_WRITER_DUMMY_PROPERTY
};
static void pdf_writer_finalize (PDFWriter* obj);
enum  {
	PS_WRITER_DUMMY_PROPERTY
};
static cairo_status_t ps_writer_write_cairo_data (PsWriter* self, guint8* data, int data_length1);
static cairo_status_t _ps_writer_write_cairo_data_cairo_write_func_t (gpointer self, guchar* data, int data_length1);
static void ps_writer_finalize (PsWriter* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gpointer _page_ref0 (gpointer self) {
#line 45 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return self ? page_ref (self) : NULL;
#line 247 "book.c"
}


static void _book_page_changed_cb_page_pixels_changed (Page* _sender, gpointer self) {
#line 47 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	book_page_changed_cb ((Book*) self, _sender);
#line 254 "book.c"
}


static void _book_page_changed_cb_page_crop_changed (Page* _sender, gpointer self) {
#line 48 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	book_page_changed_cb ((Book*) self, _sender);
#line 261 "book.c"
}


static void _page_unref0_ (gpointer var) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	(var == NULL) ? NULL : (var = (page_unref (var), NULL));
#line 268 "book.c"
}


static void _g_list_free__page_unref0_ (GList* self) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_list_foreach (self, (GFunc) _page_unref0_, NULL);
#line 14 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_list_free (self);
#line 277 "book.c"
}


Book* book_construct (GType object_type) {
	Book* self = NULL;
#line 38 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self = (Book*) g_type_create_instance (object_type);
#line 40 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	__g_list_free__page_unref0_0 (self->priv->pages);
#line 40 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->priv->pages = NULL;
#line 38 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return self;
#line 291 "book.c"
}


Book* book_new (void) {
#line 38 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return book_construct (TYPE_BOOK);
#line 298 "book.c"
}


void book_clear (Book* self) {
	GList* _tmp0_ = NULL;
#line 52 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (self != NULL);
#line 54 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0_ = self->priv->pages;
#line 308 "book.c"
	{
		GList* page_collection = NULL;
		GList* page_it = NULL;
#line 54 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		page_collection = _tmp0_;
#line 54 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		for (page_it = page_collection; page_it != NULL; page_it = page_it->next) {
#line 316 "book.c"
			Page* _tmp1_ = NULL;
			Page* page = NULL;
#line 54 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			_tmp1_ = _page_ref0 ((Page*) page_it->data);
#line 54 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			page = _tmp1_;
#line 323 "book.c"
			{
				Page* _tmp2_ = NULL;
				guint _tmp3_ = 0U;
				Page* _tmp4_ = NULL;
				guint _tmp5_ = 0U;
#line 56 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp2_ = page;
#line 56 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				g_signal_parse_name ("pixels-changed", TYPE_PAGE, &_tmp3_, NULL, FALSE);
#line 56 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _book_page_changed_cb_page_pixels_changed, self);
#line 57 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp4_ = page;
#line 57 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				g_signal_parse_name ("crop-changed", TYPE_PAGE, &_tmp5_, NULL, FALSE);
#line 57 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _book_page_changed_cb_page_crop_changed, self);
#line 54 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_page_unref0 (page);
#line 343 "book.c"
			}
		}
	}
#line 59 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	__g_list_free__page_unref0_0 (self->priv->pages);
#line 59 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->priv->pages = NULL;
#line 60 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_signal_emit_by_name (self, "cleared");
#line 353 "book.c"
}


static void book_page_changed_cb (Book* self, Page* page) {
#line 63 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (self != NULL);
#line 63 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (page != NULL);
#line 65 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	book_set_needs_saving (self, TRUE);
#line 364 "book.c"
}


void book_append_page (Book* self, Page* page) {
	Page* _tmp0_ = NULL;
	Page* _tmp1_ = NULL;
	Page* _tmp2_ = NULL;
	Page* _tmp3_ = NULL;
	Page* _tmp4_ = NULL;
#line 68 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (self != NULL);
#line 68 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (page != NULL);
#line 70 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0_ = page;
#line 70 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_signal_connect (_tmp0_, "pixels-changed", (GCallback) _book_page_changed_cb_page_pixels_changed, self);
#line 71 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp1_ = page;
#line 71 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_signal_connect (_tmp1_, "crop-changed", (GCallback) _book_page_changed_cb_page_crop_changed, self);
#line 73 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp2_ = page;
#line 73 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp3_ = _page_ref0 (_tmp2_);
#line 73 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->priv->pages = g_list_append (self->priv->pages, _tmp3_);
#line 74 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp4_ = page;
#line 74 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_signal_emit_by_name (self, "page-added", _tmp4_);
#line 75 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	book_set_needs_saving (self, TRUE);
#line 398 "book.c"
}


void book_move_page (Book* self, Page* page, guint location) {
	Page* _tmp0_ = NULL;
	Page* _tmp1_ = NULL;
	Page* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
#line 78 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (self != NULL);
#line 78 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (page != NULL);
#line 80 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0_ = page;
#line 80 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->priv->pages = g_list_remove (self->priv->pages, _tmp0_);
#line 81 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp1_ = page;
#line 81 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp2_ = _page_ref0 (_tmp1_);
#line 81 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp3_ = location;
#line 81 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->priv->pages = g_list_insert (self->priv->pages, _tmp2_, (gint) _tmp3_);
#line 82 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_signal_emit_by_name (self, "reordered");
#line 83 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	book_set_needs_saving (self, TRUE);
#line 427 "book.c"
}


void book_reverse (Book* self) {
	GList* new_pages = NULL;
	GList* _tmp0_ = NULL;
	GList* _tmp4_ = NULL;
#line 86 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (self != NULL);
#line 88 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	new_pages = NULL;
#line 89 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0_ = self->priv->pages;
#line 441 "book.c"
	{
		GList* page_collection = NULL;
		GList* page_it = NULL;
#line 89 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		page_collection = _tmp0_;
#line 89 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		for (page_it = page_collection; page_it != NULL; page_it = page_it->next) {
#line 449 "book.c"
			Page* _tmp1_ = NULL;
			Page* page = NULL;
#line 89 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			_tmp1_ = _page_ref0 ((Page*) page_it->data);
#line 89 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			page = _tmp1_;
#line 456 "book.c"
			{
				Page* _tmp2_ = NULL;
				Page* _tmp3_ = NULL;
#line 90 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp2_ = page;
#line 90 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp3_ = _page_ref0 (_tmp2_);
#line 90 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				new_pages = g_list_prepend (new_pages, _tmp3_);
#line 89 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_page_unref0 (page);
#line 468 "book.c"
			}
		}
	}
#line 91 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp4_ = new_pages;
#line 91 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	new_pages = NULL;
#line 91 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	__g_list_free__page_unref0_0 (self->priv->pages);
#line 91 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->priv->pages = _tmp4_;
#line 93 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_signal_emit_by_name (self, "reordered");
#line 94 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	book_set_needs_saving (self, TRUE);
#line 86 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	__g_list_free__page_unref0_0 (new_pages);
#line 486 "book.c"
}


void book_combine_sides (Book* self) {
	guint n_front = 0U;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	GList* new_pages = NULL;
	GList* _tmp19_ = NULL;
#line 97 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (self != NULL);
#line 99 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0_ = book_get_n_pages (self);
#line 99 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp1_ = _tmp0_;
#line 99 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp2_ = book_get_n_pages (self);
#line 99 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp3_ = _tmp2_;
#line 99 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	n_front = _tmp1_ - (_tmp3_ / 2);
#line 100 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	new_pages = NULL;
#line 512 "book.c"
	{
		gint i = 0;
#line 101 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		i = 0;
#line 517 "book.c"
		{
			gboolean _tmp4_ = FALSE;
#line 101 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			_tmp4_ = TRUE;
#line 101 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			while (TRUE) {
#line 524 "book.c"
				gint _tmp6_ = 0;
				guint _tmp7_ = 0U;
				guint _tmp8_ = 0U;
				gint _tmp9_ = 0;
#line 101 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				if (!_tmp4_) {
#line 531 "book.c"
					gint _tmp5_ = 0;
#line 101 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp5_ = i;
#line 101 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					i = _tmp5_ + 1;
#line 537 "book.c"
				}
#line 101 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp4_ = FALSE;
#line 101 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp6_ = i;
#line 101 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp7_ = book_get_n_pages (self);
#line 101 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp8_ = _tmp7_;
#line 101 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				if (!(((guint) _tmp6_) < _tmp8_)) {
#line 101 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					break;
#line 551 "book.c"
				}
#line 103 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp9_ = i;
#line 103 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				if ((_tmp9_ % 2) == 0) {
#line 557 "book.c"
					GList* _tmp10_ = NULL;
					gint _tmp11_ = 0;
					gconstpointer _tmp12_ = NULL;
					Page* _tmp13_ = NULL;
#line 104 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp10_ = self->priv->pages;
#line 104 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp11_ = i;
#line 104 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp12_ = g_list_nth_data (_tmp10_, (guint) (_tmp11_ / 2));
#line 104 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp13_ = _page_ref0 ((Page*) _tmp12_);
#line 104 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					new_pages = g_list_append (new_pages, _tmp13_);
#line 572 "book.c"
				} else {
					GList* _tmp14_ = NULL;
					guint _tmp15_ = 0U;
					gint _tmp16_ = 0;
					gconstpointer _tmp17_ = NULL;
					Page* _tmp18_ = NULL;
#line 106 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp14_ = self->priv->pages;
#line 106 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp15_ = n_front;
#line 106 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp16_ = i;
#line 106 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp17_ = g_list_nth_data (_tmp14_, _tmp15_ + (_tmp16_ / 2));
#line 106 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp18_ = _page_ref0 ((Page*) _tmp17_);
#line 106 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					new_pages = g_list_append (new_pages, _tmp18_);
#line 591 "book.c"
				}
			}
		}
	}
#line 108 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp19_ = new_pages;
#line 108 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	new_pages = NULL;
#line 108 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	__g_list_free__page_unref0_0 (self->priv->pages);
#line 108 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->priv->pages = _tmp19_;
#line 110 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_signal_emit_by_name (self, "reordered");
#line 111 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	book_set_needs_saving (self, TRUE);
#line 97 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	__g_list_free__page_unref0_0 (new_pages);
#line 610 "book.c"
}


void book_combine_sides_reverse (Book* self) {
	GList* new_pages = NULL;
	GList* _tmp16_ = NULL;
#line 114 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (self != NULL);
#line 116 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	new_pages = NULL;
#line 621 "book.c"
	{
		gint i = 0;
#line 117 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		i = 0;
#line 626 "book.c"
		{
			gboolean _tmp0_ = FALSE;
#line 117 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			_tmp0_ = TRUE;
#line 117 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			while (TRUE) {
#line 633 "book.c"
				gint _tmp2_ = 0;
				guint _tmp3_ = 0U;
				guint _tmp4_ = 0U;
				gint _tmp5_ = 0;
#line 117 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				if (!_tmp0_) {
#line 640 "book.c"
					gint _tmp1_ = 0;
#line 117 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp1_ = i;
#line 117 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					i = _tmp1_ + 1;
#line 646 "book.c"
				}
#line 117 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp0_ = FALSE;
#line 117 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp2_ = i;
#line 117 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp3_ = book_get_n_pages (self);
#line 117 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp4_ = _tmp3_;
#line 117 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				if (!(((guint) _tmp2_) < _tmp4_)) {
#line 117 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					break;
#line 660 "book.c"
				}
#line 119 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp5_ = i;
#line 119 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				if ((_tmp5_ % 2) == 0) {
#line 666 "book.c"
					GList* _tmp6_ = NULL;
					gint _tmp7_ = 0;
					gconstpointer _tmp8_ = NULL;
					Page* _tmp9_ = NULL;
#line 120 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp6_ = self->priv->pages;
#line 120 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp7_ = i;
#line 120 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp8_ = g_list_nth_data (_tmp6_, (guint) (_tmp7_ / 2));
#line 120 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp9_ = _page_ref0 ((Page*) _tmp8_);
#line 120 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					new_pages = g_list_append (new_pages, _tmp9_);
#line 681 "book.c"
				} else {
					GList* _tmp10_ = NULL;
					guint _tmp11_ = 0U;
					guint _tmp12_ = 0U;
					gint _tmp13_ = 0;
					gconstpointer _tmp14_ = NULL;
					Page* _tmp15_ = NULL;
#line 122 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp10_ = self->priv->pages;
#line 122 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp11_ = book_get_n_pages (self);
#line 122 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp12_ = _tmp11_;
#line 122 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp13_ = i;
#line 122 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp14_ = g_list_nth_data (_tmp10_, (_tmp12_ - 1) - (_tmp13_ / 2));
#line 122 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp15_ = _page_ref0 ((Page*) _tmp14_);
#line 122 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					new_pages = g_list_append (new_pages, _tmp15_);
#line 703 "book.c"
				}
			}
		}
	}
#line 124 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp16_ = new_pages;
#line 124 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	new_pages = NULL;
#line 124 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	__g_list_free__page_unref0_0 (self->priv->pages);
#line 124 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->priv->pages = _tmp16_;
#line 126 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_signal_emit_by_name (self, "reordered");
#line 127 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	book_set_needs_saving (self, TRUE);
#line 114 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	__g_list_free__page_unref0_0 (new_pages);
#line 722 "book.c"
}


void book_delete_page (Book* self, Page* page) {
	Page* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	Page* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	Page* _tmp4_ = NULL;
	Page* _tmp5_ = NULL;
#line 130 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (self != NULL);
#line 130 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (page != NULL);
#line 132 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0_ = page;
#line 132 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_signal_parse_name ("pixels-changed", TYPE_PAGE, &_tmp1_, NULL, FALSE);
#line 132 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _book_page_changed_cb_page_pixels_changed, self);
#line 133 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp2_ = page;
#line 133 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_signal_parse_name ("crop-changed", TYPE_PAGE, &_tmp3_, NULL, FALSE);
#line 133 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _book_page_changed_cb_page_crop_changed, self);
#line 134 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp4_ = page;
#line 134 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->priv->pages = g_list_remove (self->priv->pages, _tmp4_);
#line 135 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp5_ = page;
#line 135 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_signal_emit_by_name (self, "page-removed", _tmp5_);
#line 136 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	book_set_needs_saving (self, TRUE);
#line 759 "book.c"
}


Page* book_get_page (Book* self, gint page_number) {
	Page* result = NULL;
	gint _tmp0_ = 0;
	GList* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gconstpointer _tmp6_ = NULL;
	Page* _tmp7_ = NULL;
#line 139 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 141 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0_ = page_number;
#line 141 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (_tmp0_ < 0) {
#line 776 "book.c"
		GList* _tmp1_ = NULL;
		guint _tmp2_ = 0U;
		gint _tmp3_ = 0;
#line 142 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp1_ = self->priv->pages;
#line 142 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp2_ = g_list_length (_tmp1_);
#line 142 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp3_ = page_number;
#line 142 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		page_number = ((gint) _tmp2_) + _tmp3_;
#line 788 "book.c"
	}
#line 143 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp4_ = self->priv->pages;
#line 143 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp5_ = page_number;
#line 143 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp6_ = g_list_nth_data (_tmp4_, (guint) _tmp5_);
#line 143 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp7_ = _page_ref0 ((Page*) _tmp6_);
#line 143 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	result = _tmp7_;
#line 143 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return result;
#line 802 "book.c"
}


guint book_get_page_index (Book* self, Page* page) {
	guint result = 0U;
	GList* _tmp0_ = NULL;
	Page* _tmp1_ = NULL;
	gint _tmp2_ = 0;
#line 146 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 146 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_val_if_fail (page != NULL, 0U);
#line 148 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0_ = self->priv->pages;
#line 148 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp1_ = page;
#line 148 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp2_ = g_list_index (_tmp0_, _tmp1_);
#line 148 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	result = (guint) _tmp2_;
#line 148 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return result;
#line 825 "book.c"
}


static gint string_last_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 930 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 931 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = start_index;
#line 931 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = c;
#line 931 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp2_ = g_utf8_strrchr (((gchar*) self) + _tmp0_, (gssize) (-1), _tmp1_);
#line 931 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 933 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp3_ = _result_;
#line 933 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 850 "book.c"
		gchar* _tmp4_ = NULL;
#line 934 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4_ = _result_;
#line 934 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		result = (gint) (_tmp4_ - ((gchar*) self));
#line 934 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 858 "book.c"
	} else {
#line 936 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		result = -1;
#line 936 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 864 "book.c"
	}
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_ = 0L;
	glong _tmp16_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	gchar* _tmp21_ = NULL;
#line 1230 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1231 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1231 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1231 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1232 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp2_ = start;
#line 1232 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp2_ < ((glong) 0)) {
#line 898 "book.c"
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
#line 1233 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1233 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4_ = start;
#line 1233 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		start = _tmp3_ + _tmp4_;
#line 907 "book.c"
	}
#line 1235 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp5_ = end;
#line 1235 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp5_ < ((glong) 0)) {
#line 913 "book.c"
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
#line 1236 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp6_ = string_length;
#line 1236 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp7_ = end;
#line 1236 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		end = _tmp6_ + _tmp7_;
#line 922 "book.c"
	}
#line 1238 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp9_ = start;
#line 1238 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp9_ >= ((glong) 0)) {
#line 928 "book.c"
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
#line 1238 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp10_ = start;
#line 1238 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp11_ = string_length;
#line 1238 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp10_ <= _tmp11_;
#line 937 "book.c"
	} else {
#line 1238 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp8_ = FALSE;
#line 941 "book.c"
	}
#line 1238 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp8_, NULL);
#line 1239 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp13_ = end;
#line 1239 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp13_ >= ((glong) 0)) {
#line 949 "book.c"
		glong _tmp14_ = 0L;
		glong _tmp15_ = 0L;
#line 1239 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp14_ = end;
#line 1239 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1239 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp12_ = _tmp14_ <= _tmp15_;
#line 958 "book.c"
	} else {
#line 1239 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp12_ = FALSE;
#line 962 "book.c"
	}
#line 1239 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp12_, NULL);
#line 1240 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp16_ = start;
#line 1240 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp17_ = end;
#line 1240 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
#line 1241 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp18_ = start;
#line 1241 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp19_ = end;
#line 1241 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp20_ = start;
#line 1241 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
#line 1241 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	result = _tmp21_;
#line 1241 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	return result;
#line 984 "book.c"
}


static GFile* book_make_indexed_file (Book* self, const gchar* uri, gint i) {
	GFile* result = NULL;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	gchar* basename = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* prefix = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* suffix = NULL;
	gchar* _tmp8_ = NULL;
	gint extension_index = 0;
	const gchar* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint width = 0;
	guint _tmp26_ = 0U;
	guint _tmp27_ = 0U;
	gchar* _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
	gint _tmp30_ = 0;
	gint _tmp31_ = 0;
	gint _tmp32_ = 0;
	gchar* number_format = NULL;
	gint _tmp33_ = 0;
	gchar* _tmp34_ = NULL;
	gchar* filename = NULL;
	const gchar* _tmp35_ = NULL;
	gchar* _tmp36_ = NULL;
	gchar* _tmp37_ = NULL;
	const gchar* _tmp38_ = NULL;
	gint _tmp39_ = 0;
	gchar* _tmp40_ = NULL;
	gchar* _tmp41_ = NULL;
	gchar* _tmp42_ = NULL;
	gchar* _tmp43_ = NULL;
	const gchar* _tmp44_ = NULL;
	gchar* _tmp45_ = NULL;
	gchar* _tmp46_ = NULL;
	const gchar* _tmp47_ = NULL;
	GFile* _tmp48_ = NULL;
#line 151 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 151 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 153 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0_ = book_get_n_pages (self);
#line 153 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp1_ = _tmp0_;
#line 153 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (_tmp1_ == ((guint) 1)) {
#line 1040 "book.c"
		const gchar* _tmp2_ = NULL;
		GFile* _tmp3_ = NULL;
#line 154 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp2_ = uri;
#line 154 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp3_ = g_file_new_for_uri (_tmp2_);
#line 154 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		result = _tmp3_;
#line 154 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		return result;
#line 1051 "book.c"
	}
#line 157 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp4_ = uri;
#line 157 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp5_ = g_path_get_basename (_tmp4_);
#line 157 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	basename = _tmp5_;
#line 158 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp6_ = uri;
#line 158 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp7_ = g_strdup (_tmp6_);
#line 158 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	prefix = _tmp7_;
#line 158 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp8_ = g_strdup ("");
#line 158 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	suffix = _tmp8_;
#line 159 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp9_ = basename;
#line 159 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp10_ = string_last_index_of_char (_tmp9_, (gunichar) '.', 0);
#line 159 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	extension_index = _tmp10_;
#line 160 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp11_ = extension_index;
#line 160 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (_tmp11_ >= 0) {
#line 1079 "book.c"
		const gchar* _tmp12_ = NULL;
		gint _tmp13_ = 0;
		const gchar* _tmp14_ = NULL;
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
		gchar* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		gint _tmp20_ = 0;
		gint _tmp21_ = 0;
		const gchar* _tmp22_ = NULL;
		gint _tmp23_ = 0;
		gint _tmp24_ = 0;
		gchar* _tmp25_ = NULL;
#line 162 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp12_ = basename;
#line 162 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp13_ = extension_index;
#line 162 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp14_ = basename;
#line 162 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp15_ = strlen (_tmp14_);
#line 162 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp16_ = _tmp15_;
#line 162 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp17_ = string_slice (_tmp12_, (glong) _tmp13_, (glong) _tmp16_);
#line 162 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_g_free0 (suffix);
#line 162 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		suffix = _tmp17_;
#line 163 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp18_ = uri;
#line 163 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp19_ = uri;
#line 163 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp20_ = strlen (_tmp19_);
#line 163 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp21_ = _tmp20_;
#line 163 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp22_ = suffix;
#line 163 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp23_ = strlen (_tmp22_);
#line 163 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp24_ = _tmp23_;
#line 163 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp25_ = string_slice (_tmp18_, (glong) 0, (glong) (_tmp21_ - _tmp24_));
#line 163 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_g_free0 (prefix);
#line 163 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		prefix = _tmp25_;
#line 1130 "book.c"
	}
#line 165 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp26_ = book_get_n_pages (self);
#line 165 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp27_ = _tmp26_;
#line 165 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp28_ = g_strdup_printf ("%u", _tmp27_);
#line 165 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp29_ = _tmp28_;
#line 165 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp30_ = strlen (_tmp29_);
#line 165 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp31_ = _tmp30_;
#line 165 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp32_ = _tmp31_;
#line 165 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_free0 (_tmp29_);
#line 165 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	width = _tmp32_;
#line 166 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp33_ = width;
#line 166 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp34_ = g_strdup_printf ("%%0%dd", _tmp33_);
#line 166 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	number_format = _tmp34_;
#line 167 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp35_ = prefix;
#line 167 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp36_ = g_strconcat (_tmp35_, "-", NULL);
#line 167 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp37_ = _tmp36_;
#line 167 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp38_ = number_format;
#line 167 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp39_ = i;
#line 167 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp40_ = g_strdup_printf (_tmp38_, _tmp39_ + 1);
#line 167 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp41_ = _tmp40_;
#line 167 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp42_ = g_strconcat (_tmp37_, _tmp41_, NULL);
#line 167 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp43_ = _tmp42_;
#line 167 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp44_ = suffix;
#line 167 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp45_ = g_strconcat (_tmp43_, _tmp44_, NULL);
#line 167 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp46_ = _tmp45_;
#line 167 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_free0 (_tmp43_);
#line 167 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_free0 (_tmp41_);
#line 167 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_free0 (_tmp37_);
#line 167 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	filename = _tmp46_;
#line 168 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp47_ = filename;
#line 168 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp48_ = g_file_new_for_uri (_tmp47_);
#line 168 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	result = _tmp48_;
#line 168 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_free0 (filename);
#line 168 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_free0 (number_format);
#line 168 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_free0 (suffix);
#line 168 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_free0 (prefix);
#line 168 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_free0 (basename);
#line 168 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return result;
#line 1206 "book.c"
}


static void book_save_multi_file (Book* self, const gchar* type, gint quality, GFile* file, GError** error) {
	GError * _inner_error_ = NULL;
#line 171 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (self != NULL);
#line 171 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (type != NULL);
#line 171 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (file != NULL);
#line 1218 "book.c"
	{
		gint i = 0;
#line 173 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		i = 0;
#line 1223 "book.c"
		{
			gboolean _tmp0_ = FALSE;
#line 173 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			_tmp0_ = TRUE;
#line 173 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			while (TRUE) {
#line 1230 "book.c"
				gint _tmp2_ = 0;
				guint _tmp3_ = 0U;
				guint _tmp4_ = 0U;
				Page* page = NULL;
				gint _tmp5_ = 0;
				Page* _tmp6_ = NULL;
				Page* _tmp7_ = NULL;
				const gchar* _tmp8_ = NULL;
				gint _tmp9_ = 0;
				GFile* _tmp10_ = NULL;
				gchar* _tmp11_ = NULL;
				gchar* _tmp12_ = NULL;
				gint _tmp13_ = 0;
				GFile* _tmp14_ = NULL;
				GFile* _tmp15_ = NULL;
				gint _tmp16_ = 0;
#line 173 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				if (!_tmp0_) {
#line 1249 "book.c"
					gint _tmp1_ = 0;
#line 173 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp1_ = i;
#line 173 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					i = _tmp1_ + 1;
#line 1255 "book.c"
				}
#line 173 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp0_ = FALSE;
#line 173 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp2_ = i;
#line 173 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp3_ = book_get_n_pages (self);
#line 173 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp4_ = _tmp3_;
#line 173 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				if (!(((guint) _tmp2_) < _tmp4_)) {
#line 173 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					break;
#line 1269 "book.c"
				}
#line 175 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp5_ = i;
#line 175 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp6_ = book_get_page (self, _tmp5_);
#line 175 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				page = _tmp6_;
#line 176 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp7_ = page;
#line 176 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp8_ = type;
#line 176 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp9_ = quality;
#line 176 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp10_ = file;
#line 176 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp11_ = g_file_get_uri (_tmp10_);
#line 176 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp12_ = _tmp11_;
#line 176 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp13_ = i;
#line 176 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp14_ = book_make_indexed_file (self, _tmp12_, _tmp13_);
#line 176 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp15_ = _tmp14_;
#line 176 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				page_save (_tmp7_, _tmp8_, _tmp9_, _tmp15_, &_inner_error_);
#line 176 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_g_object_unref0 (_tmp15_);
#line 176 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_g_free0 (_tmp12_);
#line 176 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 176 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					g_propagate_error (error, _inner_error_);
#line 176 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_page_unref0 (page);
#line 176 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					return;
#line 1309 "book.c"
				}
#line 177 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp16_ = i;
#line 177 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				g_signal_emit_by_name (self, "saving", _tmp16_);
#line 173 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_page_unref0 (page);
#line 1317 "book.c"
			}
		}
	}
}


static void book_save_ps_pdf_surface (Book* self, cairo_surface_t* surface, GdkPixbuf* image, gdouble dpi) {
	cairo_t* context = NULL;
	cairo_surface_t* _tmp0_ = NULL;
	cairo_t* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	GdkPixbuf* _tmp4_ = NULL;
	cairo_pattern_t* _tmp5_ = NULL;
#line 181 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (self != NULL);
#line 181 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (surface != NULL);
#line 181 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (image != NULL);
#line 183 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0_ = surface;
#line 183 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp1_ = cairo_create (_tmp0_);
#line 183 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	context = _tmp1_;
#line 184 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp2_ = dpi;
#line 184 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp3_ = dpi;
#line 184 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	cairo_scale (context, 72.0 / _tmp2_, 72.0 / _tmp3_);
#line 185 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp4_ = image;
#line 185 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	gdk_cairo_set_source_pixbuf (context, _tmp4_, (gdouble) 0, (gdouble) 0);
#line 186 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp5_ = cairo_get_source (context);
#line 186 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	cairo_pattern_set_filter (_tmp5_, CAIRO_FILTER_BEST);
#line 187 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	cairo_paint (context);
#line 181 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_cairo_destroy0 (context);
#line 1362 "book.c"
}


static gpointer _cairo_surface_reference0 (gpointer self) {
#line 194 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return self ? cairo_surface_reference (self) : NULL;
#line 1369 "book.c"
}


static void book_save_ps (Book* self, GFile* file, GError** error) {
	GFileOutputStream* stream = NULL;
	GFile* _tmp0_ = NULL;
	GFileOutputStream* _tmp1_ = NULL;
	PsWriter* writer = NULL;
	PsWriter* _tmp2_ = NULL;
	cairo_surface_t* surface = NULL;
	PsWriter* _tmp3_ = NULL;
	cairo_surface_t* _tmp4_ = NULL;
	cairo_surface_t* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
#line 190 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (self != NULL);
#line 190 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (file != NULL);
#line 192 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0_ = file;
#line 192 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp1_ = g_file_replace (_tmp0_, NULL, FALSE, G_FILE_CREATE_NONE, NULL, &_inner_error_);
#line 192 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	stream = _tmp1_;
#line 192 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 192 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_propagate_error (error, _inner_error_);
#line 192 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		return;
#line 1400 "book.c"
	}
#line 193 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp2_ = ps_writer_new (stream);
#line 193 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	writer = _tmp2_;
#line 194 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp3_ = writer;
#line 194 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp4_ = _tmp3_->surface;
#line 194 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp5_ = _cairo_surface_reference0 (_tmp4_);
#line 194 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	surface = _tmp5_;
#line 1414 "book.c"
	{
		gint i = 0;
#line 196 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		i = 0;
#line 1419 "book.c"
		{
			gboolean _tmp6_ = FALSE;
#line 196 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			_tmp6_ = TRUE;
#line 196 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			while (TRUE) {
#line 1426 "book.c"
				gint _tmp8_ = 0;
				guint _tmp9_ = 0U;
				guint _tmp10_ = 0U;
				Page* page = NULL;
				gint _tmp11_ = 0;
				Page* _tmp12_ = NULL;
				GdkPixbuf* image = NULL;
				Page* _tmp13_ = NULL;
				GdkPixbuf* _tmp14_ = NULL;
				gdouble width = 0.0;
				GdkPixbuf* _tmp15_ = NULL;
				gint _tmp16_ = 0;
				gint _tmp17_ = 0;
				Page* _tmp18_ = NULL;
				gint _tmp19_ = 0;
				gint _tmp20_ = 0;
				gdouble height = 0.0;
				GdkPixbuf* _tmp21_ = NULL;
				gint _tmp22_ = 0;
				gint _tmp23_ = 0;
				Page* _tmp24_ = NULL;
				gint _tmp25_ = 0;
				gint _tmp26_ = 0;
				cairo_surface_t* _tmp27_ = NULL;
				gdouble _tmp28_ = 0.0;
				gdouble _tmp29_ = 0.0;
				cairo_surface_t* _tmp30_ = NULL;
				GdkPixbuf* _tmp31_ = NULL;
				Page* _tmp32_ = NULL;
				gint _tmp33_ = 0;
				gint _tmp34_ = 0;
				cairo_surface_t* _tmp35_ = NULL;
				gint _tmp36_ = 0;
#line 196 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				if (!_tmp6_) {
#line 1462 "book.c"
					gint _tmp7_ = 0;
#line 196 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp7_ = i;
#line 196 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					i = _tmp7_ + 1;
#line 1468 "book.c"
				}
#line 196 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp6_ = FALSE;
#line 196 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp8_ = i;
#line 196 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp9_ = book_get_n_pages (self);
#line 196 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp10_ = _tmp9_;
#line 196 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				if (!(((guint) _tmp8_) < _tmp10_)) {
#line 196 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					break;
#line 1482 "book.c"
				}
#line 198 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp11_ = i;
#line 198 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp12_ = book_get_page (self, _tmp11_);
#line 198 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				page = _tmp12_;
#line 199 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp13_ = page;
#line 199 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp14_ = page_get_image (_tmp13_, TRUE);
#line 199 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				image = _tmp14_;
#line 200 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp15_ = image;
#line 200 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp16_ = gdk_pixbuf_get_width (_tmp15_);
#line 200 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp17_ = _tmp16_;
#line 200 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp18_ = page;
#line 200 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp19_ = page_get_dpi (_tmp18_);
#line 200 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp20_ = _tmp19_;
#line 200 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				width = (_tmp17_ * 72.0) / _tmp20_;
#line 201 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp21_ = image;
#line 201 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp22_ = gdk_pixbuf_get_height (_tmp21_);
#line 201 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp23_ = _tmp22_;
#line 201 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp24_ = page;
#line 201 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp25_ = page_get_dpi (_tmp24_);
#line 201 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp26_ = _tmp25_;
#line 201 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				height = (_tmp23_ * 72.0) / _tmp26_;
#line 202 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp27_ = surface;
#line 202 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp28_ = width;
#line 202 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp29_ = height;
#line 202 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				cairo_ps_surface_set_size (_tmp27_, _tmp28_, _tmp29_);
#line 203 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp30_ = surface;
#line 203 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp31_ = image;
#line 203 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp32_ = page;
#line 203 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp33_ = page_get_dpi (_tmp32_);
#line 203 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp34_ = _tmp33_;
#line 203 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				book_save_ps_pdf_surface (self, _tmp30_, _tmp31_, (gdouble) _tmp34_);
#line 204 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp35_ = surface;
#line 204 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				cairo_surface_show_page (_tmp35_);
#line 205 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp36_ = i;
#line 205 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				g_signal_emit_by_name (self, "saving", _tmp36_);
#line 196 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_g_object_unref0 (image);
#line 196 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_page_unref0 (page);
#line 1556 "book.c"
			}
		}
	}
#line 190 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_cairo_surface_destroy0 (surface);
#line 190 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_ps_writer_unref0 (writer);
#line 190 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_object_unref0 (stream);
#line 1566 "book.c"
}


static guint8* book_compress_zlib (Book* self, guint8* data, int data_length1, int* result_length1) {
	guint8* result = NULL;
	z_stream stream = {0};
	guint8* out_data = NULL;
	guint8* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	guint8* _tmp1_ = NULL;
	gint out_data_length1 = 0;
	gint _out_data_size_ = 0;
	guint8* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	guint8* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	z_stream _tmp7_ = {0};
	guint _tmp8_ = 0U;
	guint n_written = 0U;
	guint8* _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	z_stream _tmp11_ = {0};
	guint _tmp12_ = 0U;
	guint _tmp13_ = 0U;
	gint _tmp14_ = 0;
	guint8* _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
#line 209 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 211 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	deflateInit (&stream, (gint) Z_BEST_COMPRESSION);
#line 212 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0_ = data;
#line 212 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0__length1 = data_length1;
#line 212 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp1_ = g_new0 (guint8, _tmp0__length1);
#line 212 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	out_data = _tmp1_;
#line 212 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	out_data_length1 = _tmp0__length1;
#line 212 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_out_data_size_ = out_data_length1;
#line 214 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp2_ = data;
#line 214 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp2__length1 = data_length1;
#line 214 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	stream.next_in = _tmp2_;
#line 214 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	stream.avail_in = _tmp2__length1;
#line 215 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp3_ = out_data;
#line 215 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp3__length1 = out_data_length1;
#line 215 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	stream.next_out = _tmp3_;
#line 215 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	stream.avail_out = _tmp3__length1;
#line 216 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	while (TRUE) {
#line 1628 "book.c"
		z_stream _tmp4_ = {0};
		guint _tmp5_ = 0U;
		gint _tmp6_ = 0;
#line 216 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp4_ = stream;
#line 216 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp5_ = _tmp4_.avail_in;
#line 216 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		if (!(_tmp5_ > ((guint) 0))) {
#line 216 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			break;
#line 1640 "book.c"
		}
#line 218 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp6_ = deflate (&stream, (gint) Z_FINISH);
#line 218 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		if (_tmp6_ == ((gint) Z_STREAM_ERROR)) {
#line 219 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			break;
#line 1648 "book.c"
		}
	}
#line 222 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp7_ = stream;
#line 222 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp8_ = _tmp7_.avail_in;
#line 222 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (_tmp8_ > ((guint) 0)) {
#line 1657 "book.c"
		guint8* _tmp9_ = NULL;
		gint _tmp9__length1 = 0;
#line 223 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp9_ = NULL;
#line 223 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp9__length1 = 0;
#line 223 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		if (result_length1) {
#line 223 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			*result_length1 = _tmp9__length1;
#line 1668 "book.c"
		}
#line 223 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		result = _tmp9_;
#line 223 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		out_data = (g_free (out_data), NULL);
#line 223 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		deflateEnd (&stream);
#line 223 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		return result;
#line 1678 "book.c"
	}
#line 225 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp10_ = data;
#line 225 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp10__length1 = data_length1;
#line 225 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp11_ = stream;
#line 225 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp12_ = _tmp11_.avail_out;
#line 225 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	n_written = _tmp10__length1 - _tmp12_;
#line 226 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp13_ = n_written;
#line 226 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp14_ = (gint) _tmp13_;
#line 226 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	out_data = g_renew (guint8, out_data, (gint) _tmp13_);
#line 226 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	(_tmp14_ > out_data_length1) ? memset (out_data + out_data_length1, 0, sizeof (guint8) * (_tmp14_ - out_data_length1)) : NULL;
#line 226 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	out_data_length1 = _tmp14_;
#line 226 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_out_data_size_ = _tmp14_;
#line 228 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp15_ = out_data;
#line 228 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp15__length1 = out_data_length1;
#line 228 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (result_length1) {
#line 228 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		*result_length1 = _tmp15__length1;
#line 1710 "book.c"
	}
#line 228 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	result = _tmp15_;
#line 228 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	deflateEnd (&stream);
#line 228 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return result;
#line 1718 "book.c"
}


static gboolean _book_write_pixbuf_data_gdk_pixbuf_save_func (guint8* buf, gsize buf_length1, GError** error, gpointer self) {
	gboolean result;
	result = book_write_pixbuf_data ((Book*) self, buf, buf_length1, error);
#line 240 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return result;
#line 1727 "book.c"
}


static guint8* book_compress_jpeg (Book* self, GdkPixbuf* image, gint quality, gint dpi, int* result_length1) {
	guint8* result = NULL;
	GByteArray* _tmp0_ = NULL;
	gchar** keys = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar** _tmp5_ = NULL;
	gint keys_length1 = 0;
	gint _keys_size_ = 0;
	gchar** values = NULL;
	gint _tmp6_ = 0;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gchar* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gchar* _tmp12_ = NULL;
	gchar** _tmp13_ = NULL;
	gint values_length1 = 0;
	gint _values_size_ = 0;
	guint8* data = NULL;
	GByteArray* _tmp15_ = NULL;
	guint8* _tmp16_ = NULL;
	gint _tmp16__length1 = 0;
	gint data_length1 = 0;
	gint _data_size_ = 0;
	guint8* _tmp17_ = NULL;
	gint _tmp17__length1 = 0;
	GError * _inner_error_ = NULL;
#line 233 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 233 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_val_if_fail (image != NULL, NULL);
#line 235 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0_ = g_byte_array_new ();
#line 235 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_byte_array_unref0 (self->priv->jpeg_data);
#line 235 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->priv->jpeg_data = _tmp0_;
#line 236 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp1_ = g_strdup ("quality");
#line 236 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp2_ = g_strdup ("density-unit");
#line 236 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp3_ = g_strdup ("x-density");
#line 236 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp4_ = g_strdup ("y-density");
#line 236 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp5_ = g_new0 (gchar*, 5 + 1);
#line 236 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp5_[0] = _tmp1_;
#line 236 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp5_[1] = _tmp2_;
#line 236 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp5_[2] = _tmp3_;
#line 236 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp5_[3] = _tmp4_;
#line 236 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp5_[4] = NULL;
#line 236 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	keys = _tmp5_;
#line 236 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	keys_length1 = 5;
#line 236 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_keys_size_ = keys_length1;
#line 237 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp6_ = quality;
#line 237 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp7_ = g_strdup_printf ("%d", _tmp6_);
#line 237 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp8_ = g_strdup ("dots-per-inch");
#line 237 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp9_ = dpi;
#line 237 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp10_ = g_strdup_printf ("%d", _tmp9_);
#line 237 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp11_ = dpi;
#line 237 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp12_ = g_strdup_printf ("%d", _tmp11_);
#line 237 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp13_ = g_new0 (gchar*, 5 + 1);
#line 237 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp13_[0] = _tmp7_;
#line 237 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp13_[1] = _tmp8_;
#line 237 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp13_[2] = _tmp10_;
#line 237 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp13_[3] = _tmp12_;
#line 237 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp13_[4] = NULL;
#line 237 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	values = _tmp13_;
#line 237 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	values_length1 = 5;
#line 237 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_values_size_ = values_length1;
#line 1830 "book.c"
	{
		GdkPixbuf* _tmp14_ = NULL;
#line 240 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp14_ = image;
#line 240 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		gdk_pixbuf_save_to_callbackv (_tmp14_, _book_write_pixbuf_data_gdk_pixbuf_save_func, self, "jpeg", keys, values, &_inner_error_);
#line 240 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1839 "book.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
#line 238 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		e = _inner_error_;
#line 238 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_inner_error_ = NULL;
#line 238 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_g_error_free0 (e);
#line 1853 "book.c"
	}
	__finally0:
#line 238 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 238 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
#line 238 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
#line 238 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 238 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_clear_error (&_inner_error_);
#line 238 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		return NULL;
#line 1868 "book.c"
	}
#line 245 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp15_ = self->priv->jpeg_data;
#line 245 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp16_ = _tmp15_->data;
#line 245 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp16__length1 = _tmp15_->len;
#line 245 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp15_->data = NULL;
#line 245 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp15_->len = 0;
#line 245 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	data = _tmp16_;
#line 245 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	data_length1 = _tmp16__length1;
#line 245 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_data_size_ = data_length1;
#line 246 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_byte_array_unref0 (self->priv->jpeg_data);
#line 246 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->priv->jpeg_data = NULL;
#line 248 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp17_ = data;
#line 248 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp17__length1 = data_length1;
#line 248 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (result_length1) {
#line 248 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		*result_length1 = _tmp17__length1;
#line 1898 "book.c"
	}
#line 248 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	result = _tmp17_;
#line 248 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
#line 248 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
#line 248 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return result;
#line 1908 "book.c"
}


static gboolean book_write_pixbuf_data (Book* self, guint8* buf, int buf_length1, GError** error) {
	gboolean result = FALSE;
	GByteArray* _tmp0_ = NULL;
	guint8* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
#line 251 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 253 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0_ = self->priv->jpeg_data;
#line 253 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp1_ = buf;
#line 253 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp1__length1 = buf_length1;
#line 253 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_byte_array_append (_tmp0_, _tmp1_, _tmp1__length1);
#line 254 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	result = TRUE;
#line 254 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return result;
#line 1931 "book.c"
}


static guint8* _vala_array_dup1 (guint8* self, int length) {
#line 459 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return g_memdup (self, length * sizeof (guint8));
#line 1938 "book.c"
}


static guint8* _vala_array_dup2 (guint8* self, int length) {
#line 466 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return g_memdup (self, length * sizeof (guint8));
#line 1945 "book.c"
}


static void book_save_pdf (Book* self, GFile* file, gint quality, GError** error) {
	gchar* id = NULL;
	gchar* _tmp0_ = NULL;
	GFileOutputStream* stream = NULL;
	GFile* _tmp9_ = NULL;
	GFileOutputStream* _tmp10_ = NULL;
	PDFWriter* writer = NULL;
	PDFWriter* _tmp11_ = NULL;
	PDFWriter* _tmp12_ = NULL;
	PDFWriter* _tmp13_ = NULL;
	guint catalog_number = 0U;
	PDFWriter* _tmp14_ = NULL;
	guint _tmp15_ = 0U;
	PDFWriter* _tmp16_ = NULL;
	guint _tmp17_ = 0U;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	PDFWriter* _tmp20_ = NULL;
	PDFWriter* _tmp21_ = NULL;
	PDFWriter* _tmp22_ = NULL;
	guint _tmp23_ = 0U;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	PDFWriter* _tmp26_ = NULL;
	PDFWriter* _tmp27_ = NULL;
	PDFWriter* _tmp28_ = NULL;
	guint pages_number = 0U;
	PDFWriter* _tmp29_ = NULL;
	guint _tmp30_ = 0U;
	PDFWriter* _tmp31_ = NULL;
	guint _tmp32_ = 0U;
	gchar* _tmp33_ = NULL;
	gchar* _tmp34_ = NULL;
	PDFWriter* _tmp35_ = NULL;
	PDFWriter* _tmp36_ = NULL;
	PDFWriter* _tmp37_ = NULL;
	PDFWriter* _tmp48_ = NULL;
	PDFWriter* _tmp49_ = NULL;
	guint _tmp50_ = 0U;
	guint _tmp51_ = 0U;
	gchar* _tmp52_ = NULL;
	gchar* _tmp53_ = NULL;
	PDFWriter* _tmp54_ = NULL;
	PDFWriter* _tmp55_ = NULL;
	PDFWriter* _tmp366_ = NULL;
	guint info_number = 0U;
	PDFWriter* _tmp367_ = NULL;
	guint _tmp368_ = 0U;
	PDFWriter* _tmp369_ = NULL;
	guint _tmp370_ = 0U;
	gchar* _tmp371_ = NULL;
	gchar* _tmp372_ = NULL;
	PDFWriter* _tmp373_ = NULL;
	PDFWriter* _tmp374_ = NULL;
	gchar* _tmp375_ = NULL;
	gchar* _tmp376_ = NULL;
	PDFWriter* _tmp377_ = NULL;
	PDFWriter* _tmp378_ = NULL;
	PDFWriter* _tmp379_ = NULL;
	gsize xref_offset = 0UL;
	PDFWriter* _tmp380_ = NULL;
	gsize _tmp381_ = 0UL;
	PDFWriter* _tmp382_ = NULL;
	PDFWriter* _tmp383_ = NULL;
	PDFWriter* _tmp384_ = NULL;
	GList* _tmp385_ = NULL;
	guint _tmp386_ = 0U;
	gchar* _tmp387_ = NULL;
	gchar* _tmp388_ = NULL;
	PDFWriter* _tmp389_ = NULL;
	PDFWriter* _tmp390_ = NULL;
	GList* _tmp391_ = NULL;
	PDFWriter* _tmp396_ = NULL;
	PDFWriter* _tmp397_ = NULL;
	PDFWriter* _tmp398_ = NULL;
	PDFWriter* _tmp399_ = NULL;
	PDFWriter* _tmp400_ = NULL;
	GList* _tmp401_ = NULL;
	guint _tmp402_ = 0U;
	gchar* _tmp403_ = NULL;
	gchar* _tmp404_ = NULL;
	PDFWriter* _tmp405_ = NULL;
	guint _tmp406_ = 0U;
	gchar* _tmp407_ = NULL;
	gchar* _tmp408_ = NULL;
	PDFWriter* _tmp409_ = NULL;
	guint _tmp410_ = 0U;
	gchar* _tmp411_ = NULL;
	gchar* _tmp412_ = NULL;
	PDFWriter* _tmp413_ = NULL;
	const gchar* _tmp414_ = NULL;
	const gchar* _tmp415_ = NULL;
	gchar* _tmp416_ = NULL;
	gchar* _tmp417_ = NULL;
	PDFWriter* _tmp418_ = NULL;
	PDFWriter* _tmp419_ = NULL;
	PDFWriter* _tmp420_ = NULL;
	gsize _tmp421_ = 0UL;
	gchar* _tmp422_ = NULL;
	gchar* _tmp423_ = NULL;
	PDFWriter* _tmp424_ = NULL;
	GError * _inner_error_ = NULL;
#line 257 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (self != NULL);
#line 257 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (file != NULL);
#line 260 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0_ = g_strdup ("");
#line 260 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	id = _tmp0_;
#line 2059 "book.c"
	{
		gint i = 0;
#line 261 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		i = 0;
#line 2064 "book.c"
		{
			gboolean _tmp1_ = FALSE;
#line 261 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			_tmp1_ = TRUE;
#line 261 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			while (TRUE) {
#line 2071 "book.c"
				gint _tmp3_ = 0;
				const gchar* _tmp4_ = NULL;
				guint32 _tmp5_ = 0U;
				gchar* _tmp6_ = NULL;
				gchar* _tmp7_ = NULL;
				gchar* _tmp8_ = NULL;
#line 261 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				if (!_tmp1_) {
#line 2080 "book.c"
					gint _tmp2_ = 0;
#line 261 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp2_ = i;
#line 261 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					i = _tmp2_ + 1;
#line 2086 "book.c"
				}
#line 261 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp1_ = FALSE;
#line 261 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp3_ = i;
#line 261 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				if (!(_tmp3_ < 4)) {
#line 261 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					break;
#line 2096 "book.c"
				}
#line 262 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp4_ = id;
#line 262 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp5_ = g_random_int ();
#line 262 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp6_ = g_strdup_printf ("%08x", (guint) _tmp5_);
#line 262 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp7_ = _tmp6_;
#line 262 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp8_ = g_strconcat (_tmp4_, _tmp7_, NULL);
#line 262 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_g_free0 (id);
#line 262 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				id = _tmp8_;
#line 262 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_g_free0 (_tmp7_);
#line 2114 "book.c"
			}
		}
	}
#line 264 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp9_ = file;
#line 264 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp10_ = g_file_replace (_tmp9_, NULL, FALSE, G_FILE_CREATE_NONE, NULL, &_inner_error_);
#line 264 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	stream = _tmp10_;
#line 264 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 264 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_propagate_error (error, _inner_error_);
#line 264 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_g_free0 (id);
#line 264 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		return;
#line 2132 "book.c"
	}
#line 265 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp11_ = pdf_writer_new (stream);
#line 265 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	writer = _tmp11_;
#line 268 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp12_ = writer;
#line 268 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp12_, "%PDF-1.3\n");
#line 271 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp13_ = writer;
#line 271 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp13_, "%\xe2\xe3\xcf\xd3\n");
#line 274 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp14_ = writer;
#line 274 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp15_ = pdf_writer_start_object (_tmp14_);
#line 274 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	catalog_number = _tmp15_;
#line 275 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp16_ = writer;
#line 275 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp17_ = catalog_number;
#line 275 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp18_ = g_strdup_printf ("%u 0 obj\n", _tmp17_);
#line 275 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp19_ = _tmp18_;
#line 275 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp16_, _tmp19_);
#line 275 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_free0 (_tmp19_);
#line 276 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp20_ = writer;
#line 276 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp20_, "<<\n");
#line 277 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp21_ = writer;
#line 277 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp21_, "/Type /Catalog\n");
#line 280 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp22_ = writer;
#line 280 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp23_ = catalog_number;
#line 280 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp24_ = g_strdup_printf ("/Pages %u 0 R\n", _tmp23_ + 1);
#line 280 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp25_ = _tmp24_;
#line 280 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp22_, _tmp25_);
#line 280 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_free0 (_tmp25_);
#line 281 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp26_ = writer;
#line 281 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp26_, ">>\n");
#line 282 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp27_ = writer;
#line 282 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp27_, "endobj\n");
#line 300 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp28_ = writer;
#line 300 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp28_, "\n");
#line 301 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp29_ = writer;
#line 301 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp30_ = pdf_writer_start_object (_tmp29_);
#line 301 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pages_number = _tmp30_;
#line 302 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp31_ = writer;
#line 302 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp32_ = pages_number;
#line 302 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp33_ = g_strdup_printf ("%u 0 obj\n", _tmp32_);
#line 302 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp34_ = _tmp33_;
#line 302 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp31_, _tmp34_);
#line 302 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_free0 (_tmp34_);
#line 303 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp35_ = writer;
#line 303 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp35_, "<<\n");
#line 304 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp36_ = writer;
#line 304 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp36_, "/Type /Pages\n");
#line 305 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp37_ = writer;
#line 305 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp37_, "/Kids [");
#line 2226 "book.c"
	{
		gint i = 0;
#line 306 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		i = 0;
#line 2231 "book.c"
		{
			gboolean _tmp38_ = FALSE;
#line 306 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			_tmp38_ = TRUE;
#line 306 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			while (TRUE) {
#line 2238 "book.c"
				gint _tmp40_ = 0;
				guint _tmp41_ = 0U;
				guint _tmp42_ = 0U;
				PDFWriter* _tmp43_ = NULL;
				guint _tmp44_ = 0U;
				gint _tmp45_ = 0;
				gchar* _tmp46_ = NULL;
				gchar* _tmp47_ = NULL;
#line 306 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				if (!_tmp38_) {
#line 2249 "book.c"
					gint _tmp39_ = 0;
#line 306 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp39_ = i;
#line 306 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					i = _tmp39_ + 1;
#line 2255 "book.c"
				}
#line 306 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp38_ = FALSE;
#line 306 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp40_ = i;
#line 306 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp41_ = book_get_n_pages (self);
#line 306 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp42_ = _tmp41_;
#line 306 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				if (!(((guint) _tmp40_) < _tmp42_)) {
#line 306 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					break;
#line 2269 "book.c"
				}
#line 307 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp43_ = writer;
#line 307 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp44_ = pages_number;
#line 307 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp45_ = i;
#line 307 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp46_ = g_strdup_printf (" %u 0 R", (_tmp44_ + 1) + (_tmp45_ * 3));
#line 307 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp47_ = _tmp46_;
#line 307 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp43_, _tmp47_);
#line 307 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_g_free0 (_tmp47_);
#line 2285 "book.c"
			}
		}
	}
#line 308 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp48_ = writer;
#line 308 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp48_, " ]\n");
#line 309 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp49_ = writer;
#line 309 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp50_ = book_get_n_pages (self);
#line 309 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp51_ = _tmp50_;
#line 309 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp52_ = g_strdup_printf ("/Count %u\n", _tmp51_);
#line 309 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp53_ = _tmp52_;
#line 309 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp49_, _tmp53_);
#line 309 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_free0 (_tmp53_);
#line 310 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp54_ = writer;
#line 310 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp54_, ">>\n");
#line 311 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp55_ = writer;
#line 311 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp55_, "endobj\n");
#line 2315 "book.c"
	{
		gint i = 0;
#line 313 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		i = 0;
#line 2320 "book.c"
		{
			gboolean _tmp56_ = FALSE;
#line 313 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			_tmp56_ = TRUE;
#line 313 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			while (TRUE) {
#line 2327 "book.c"
				gint _tmp58_ = 0;
				guint _tmp59_ = 0U;
				guint _tmp60_ = 0U;
				Page* page = NULL;
				gint _tmp61_ = 0;
				Page* _tmp62_ = NULL;
				GdkPixbuf* image = NULL;
				Page* _tmp63_ = NULL;
				GdkPixbuf* _tmp64_ = NULL;
				gint width = 0;
				GdkPixbuf* _tmp65_ = NULL;
				gint _tmp66_ = 0;
				gint _tmp67_ = 0;
				gint height = 0;
				GdkPixbuf* _tmp68_ = NULL;
				gint _tmp69_ = 0;
				gint _tmp70_ = 0;
				guint8* pixels = NULL;
				GdkPixbuf* _tmp71_ = NULL;
				guint8* _tmp72_ = NULL;
				gint pixels_length1 = 0;
				gint _pixels_size_ = 0;
				gdouble page_width = 0.0;
				gint _tmp73_ = 0;
				Page* _tmp74_ = NULL;
				gint _tmp75_ = 0;
				gint _tmp76_ = 0;
				gdouble page_height = 0.0;
				gint _tmp77_ = 0;
				Page* _tmp78_ = NULL;
				gint _tmp79_ = 0;
				gint _tmp80_ = 0;
				gint depth = 0;
				gchar* color_space = NULL;
				gchar* _tmp81_ = NULL;
				gchar* filter = NULL;
				gchar* width_buffer = NULL;
				gchar* _tmp82_ = NULL;
				gint width_buffer_length1 = 0;
				gint _width_buffer_size_ = 0;
				gchar* height_buffer = NULL;
				gchar* _tmp83_ = NULL;
				gint height_buffer_length1 = 0;
				gint _height_buffer_size_ = 0;
				guint8* data = NULL;
				gint data_length1 = 0;
				gint _data_size_ = 0;
				Page* _tmp84_ = NULL;
				gboolean _tmp85_ = FALSE;
				gboolean _tmp86_ = FALSE;
				guint8* compressed_data = NULL;
				guint8* _tmp240_ = NULL;
				gint _tmp240__length1 = 0;
				gint _tmp241_ = 0;
				guint8* _tmp242_ = NULL;
				gint compressed_data_length1 = 0;
				gint _compressed_data_size_ = 0;
				guint8* _tmp243_ = NULL;
				gint _tmp243__length1 = 0;
				PDFWriter* _tmp261_ = NULL;
				guint number = 0U;
				PDFWriter* _tmp262_ = NULL;
				guint _tmp263_ = 0U;
				PDFWriter* _tmp264_ = NULL;
				guint _tmp265_ = 0U;
				gchar* _tmp266_ = NULL;
				gchar* _tmp267_ = NULL;
				PDFWriter* _tmp268_ = NULL;
				PDFWriter* _tmp269_ = NULL;
				PDFWriter* _tmp270_ = NULL;
				guint _tmp271_ = 0U;
				gchar* _tmp272_ = NULL;
				gchar* _tmp273_ = NULL;
				PDFWriter* _tmp274_ = NULL;
				gint _tmp275_ = 0;
				guint _tmp276_ = 0U;
				gchar* _tmp277_ = NULL;
				gchar* _tmp278_ = NULL;
				PDFWriter* _tmp279_ = NULL;
				gdouble _tmp280_ = 0.0;
				gchar* _tmp281_ = NULL;
				gint _tmp281__length1 = 0;
				const gchar* _tmp282_ = NULL;
				gdouble _tmp283_ = 0.0;
				gchar* _tmp284_ = NULL;
				gint _tmp284__length1 = 0;
				const gchar* _tmp285_ = NULL;
				gchar* _tmp286_ = NULL;
				gchar* _tmp287_ = NULL;
				PDFWriter* _tmp288_ = NULL;
				guint _tmp289_ = 0U;
				gchar* _tmp290_ = NULL;
				gchar* _tmp291_ = NULL;
				PDFWriter* _tmp292_ = NULL;
				PDFWriter* _tmp293_ = NULL;
				PDFWriter* _tmp294_ = NULL;
				PDFWriter* _tmp295_ = NULL;
				guint _tmp296_ = 0U;
				PDFWriter* _tmp297_ = NULL;
				guint _tmp298_ = 0U;
				gchar* _tmp299_ = NULL;
				gchar* _tmp300_ = NULL;
				PDFWriter* _tmp301_ = NULL;
				PDFWriter* _tmp302_ = NULL;
				PDFWriter* _tmp303_ = NULL;
				PDFWriter* _tmp304_ = NULL;
				gint _tmp305_ = 0;
				gchar* _tmp306_ = NULL;
				gchar* _tmp307_ = NULL;
				PDFWriter* _tmp308_ = NULL;
				gint _tmp309_ = 0;
				gchar* _tmp310_ = NULL;
				gchar* _tmp311_ = NULL;
				PDFWriter* _tmp312_ = NULL;
				const gchar* _tmp313_ = NULL;
				gchar* _tmp314_ = NULL;
				gchar* _tmp315_ = NULL;
				PDFWriter* _tmp316_ = NULL;
				gint _tmp317_ = 0;
				gchar* _tmp318_ = NULL;
				gchar* _tmp319_ = NULL;
				PDFWriter* _tmp320_ = NULL;
				guint8* _tmp321_ = NULL;
				gint _tmp321__length1 = 0;
				gchar* _tmp322_ = NULL;
				gchar* _tmp323_ = NULL;
				const gchar* _tmp324_ = NULL;
				PDFWriter* _tmp329_ = NULL;
				PDFWriter* _tmp330_ = NULL;
				PDFWriter* _tmp331_ = NULL;
				guint8* _tmp332_ = NULL;
				gint _tmp332__length1 = 0;
				PDFWriter* _tmp333_ = NULL;
				PDFWriter* _tmp334_ = NULL;
				PDFWriter* _tmp335_ = NULL;
				gchar* command = NULL;
				gdouble _tmp336_ = 0.0;
				gchar* _tmp337_ = NULL;
				gint _tmp337__length1 = 0;
				const gchar* _tmp338_ = NULL;
				gdouble _tmp339_ = 0.0;
				gchar* _tmp340_ = NULL;
				gint _tmp340__length1 = 0;
				const gchar* _tmp341_ = NULL;
				gint _tmp342_ = 0;
				gchar* _tmp343_ = NULL;
				PDFWriter* _tmp344_ = NULL;
				PDFWriter* _tmp345_ = NULL;
				guint _tmp346_ = 0U;
				PDFWriter* _tmp347_ = NULL;
				guint _tmp348_ = 0U;
				gchar* _tmp349_ = NULL;
				gchar* _tmp350_ = NULL;
				PDFWriter* _tmp351_ = NULL;
				PDFWriter* _tmp352_ = NULL;
				const gchar* _tmp353_ = NULL;
				gint _tmp354_ = 0;
				gint _tmp355_ = 0;
				gchar* _tmp356_ = NULL;
				gchar* _tmp357_ = NULL;
				PDFWriter* _tmp358_ = NULL;
				PDFWriter* _tmp359_ = NULL;
				PDFWriter* _tmp360_ = NULL;
				const gchar* _tmp361_ = NULL;
				PDFWriter* _tmp362_ = NULL;
				PDFWriter* _tmp363_ = NULL;
				PDFWriter* _tmp364_ = NULL;
				gint _tmp365_ = 0;
#line 313 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				if (!_tmp56_) {
#line 2498 "book.c"
					gint _tmp57_ = 0;
#line 313 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp57_ = i;
#line 313 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					i = _tmp57_ + 1;
#line 2504 "book.c"
				}
#line 313 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp56_ = FALSE;
#line 313 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp58_ = i;
#line 313 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp59_ = book_get_n_pages (self);
#line 313 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp60_ = _tmp59_;
#line 313 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				if (!(((guint) _tmp58_) < _tmp60_)) {
#line 313 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					break;
#line 2518 "book.c"
				}
#line 315 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp61_ = i;
#line 315 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp62_ = book_get_page (self, _tmp61_);
#line 315 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				page = _tmp62_;
#line 316 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp63_ = page;
#line 316 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp64_ = page_get_image (_tmp63_, TRUE);
#line 316 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				image = _tmp64_;
#line 317 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp65_ = image;
#line 317 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp66_ = gdk_pixbuf_get_width (_tmp65_);
#line 317 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp67_ = _tmp66_;
#line 317 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				width = _tmp67_;
#line 318 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp68_ = image;
#line 318 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp69_ = gdk_pixbuf_get_height (_tmp68_);
#line 318 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp70_ = _tmp69_;
#line 318 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				height = _tmp70_;
#line 319 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp71_ = image;
#line 319 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp72_ = gdk_pixbuf_get_pixels (_tmp71_);
#line 319 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pixels = _tmp72_;
#line 319 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pixels_length1 = -1;
#line 319 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_pixels_size_ = pixels_length1;
#line 320 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp73_ = width;
#line 320 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp74_ = page;
#line 320 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp75_ = page_get_dpi (_tmp74_);
#line 320 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp76_ = _tmp75_;
#line 320 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				page_width = (_tmp73_ * 72.0) / _tmp76_;
#line 321 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp77_ = height;
#line 321 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp78_ = page;
#line 321 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp79_ = page_get_dpi (_tmp78_);
#line 321 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp80_ = _tmp79_;
#line 321 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				page_height = (_tmp77_ * 72.0) / _tmp80_;
#line 323 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				depth = 8;
#line 324 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp81_ = g_strdup ("DeviceRGB");
#line 324 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				color_space = _tmp81_;
#line 325 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				filter = NULL;
#line 326 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp82_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
#line 326 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				width_buffer = _tmp82_;
#line 326 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				width_buffer_length1 = G_ASCII_DTOSTR_BUF_SIZE;
#line 326 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_width_buffer_size_ = width_buffer_length1;
#line 327 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp83_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
#line 327 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				height_buffer = _tmp83_;
#line 327 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				height_buffer_length1 = G_ASCII_DTOSTR_BUF_SIZE;
#line 327 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_height_buffer_size_ = height_buffer_length1;
#line 329 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp84_ = page;
#line 329 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp85_ = page_get_is_color (_tmp84_);
#line 329 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp86_ = _tmp85_;
#line 329 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				if (_tmp86_) {
#line 2610 "book.c"
					gchar* _tmp87_ = NULL;
					gint data_length = 0;
					gint _tmp88_ = 0;
					gint _tmp89_ = 0;
					gint _tmp90_ = 0;
					guint8* _tmp91_ = NULL;
#line 331 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					depth = 8;
#line 332 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp87_ = g_strdup ("DeviceRGB");
#line 332 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_g_free0 (color_space);
#line 332 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					color_space = _tmp87_;
#line 333 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp88_ = height;
#line 333 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp89_ = width;
#line 333 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					data_length = (_tmp88_ * _tmp89_) * 3;
#line 334 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp90_ = data_length;
#line 334 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp91_ = g_new0 (guint8, _tmp90_);
#line 334 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					data = (g_free (data), NULL);
#line 334 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					data = _tmp91_;
#line 334 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					data_length1 = _tmp90_;
#line 334 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_data_size_ = data_length1;
#line 2643 "book.c"
					{
						gint row = 0;
#line 335 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						row = 0;
#line 2648 "book.c"
						{
							gboolean _tmp92_ = FALSE;
#line 335 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							_tmp92_ = TRUE;
#line 335 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							while (TRUE) {
#line 2655 "book.c"
								gint _tmp94_ = 0;
								gint _tmp95_ = 0;
								gint in_offset = 0;
								gint _tmp96_ = 0;
								GdkPixbuf* _tmp97_ = NULL;
								gint _tmp98_ = 0;
								gint _tmp99_ = 0;
								gint out_offset = 0;
								gint _tmp100_ = 0;
								gint _tmp101_ = 0;
#line 335 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
								if (!_tmp92_) {
#line 2668 "book.c"
									gint _tmp93_ = 0;
#line 335 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
									_tmp93_ = row;
#line 335 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
									row = _tmp93_ + 1;
#line 2674 "book.c"
								}
#line 335 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
								_tmp92_ = FALSE;
#line 335 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
								_tmp94_ = row;
#line 335 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
								_tmp95_ = height;
#line 335 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
								if (!(_tmp94_ < _tmp95_)) {
#line 335 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
									break;
#line 2686 "book.c"
								}
#line 337 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
								_tmp96_ = row;
#line 337 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
								_tmp97_ = image;
#line 337 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
								_tmp98_ = gdk_pixbuf_get_rowstride (_tmp97_);
#line 337 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
								_tmp99_ = _tmp98_;
#line 337 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
								in_offset = _tmp96_ * _tmp99_;
#line 338 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
								_tmp100_ = row;
#line 338 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
								_tmp101_ = width;
#line 338 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
								out_offset = (_tmp100_ * _tmp101_) * 3;
#line 2704 "book.c"
								{
									gint x = 0;
#line 339 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
									x = 0;
#line 2709 "book.c"
									{
										gboolean _tmp102_ = FALSE;
#line 339 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										_tmp102_ = TRUE;
#line 339 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										while (TRUE) {
#line 2716 "book.c"
											gint _tmp104_ = 0;
											gint _tmp105_ = 0;
											gint in_o = 0;
											gint _tmp106_ = 0;
											gint _tmp107_ = 0;
											gint out_o = 0;
											gint _tmp108_ = 0;
											gint _tmp109_ = 0;
											guint8* _tmp110_ = NULL;
											gint _tmp110__length1 = 0;
											gint _tmp111_ = 0;
											guint8* _tmp112_ = NULL;
											gint _tmp112__length1 = 0;
											gint _tmp113_ = 0;
											guint8 _tmp114_ = 0U;
											guint8 _tmp115_ = 0U;
											guint8* _tmp116_ = NULL;
											gint _tmp116__length1 = 0;
											gint _tmp117_ = 0;
											guint8* _tmp118_ = NULL;
											gint _tmp118__length1 = 0;
											gint _tmp119_ = 0;
											guint8 _tmp120_ = 0U;
											guint8 _tmp121_ = 0U;
											guint8* _tmp122_ = NULL;
											gint _tmp122__length1 = 0;
											gint _tmp123_ = 0;
											guint8* _tmp124_ = NULL;
											gint _tmp124__length1 = 0;
											gint _tmp125_ = 0;
											guint8 _tmp126_ = 0U;
											guint8 _tmp127_ = 0U;
#line 339 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											if (!_tmp102_) {
#line 2751 "book.c"
												gint _tmp103_ = 0;
#line 339 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												_tmp103_ = x;
#line 339 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												x = _tmp103_ + 1;
#line 2757 "book.c"
											}
#line 339 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp102_ = FALSE;
#line 339 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp104_ = x;
#line 339 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp105_ = width;
#line 339 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											if (!(_tmp104_ < _tmp105_)) {
#line 339 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												break;
#line 2769 "book.c"
											}
#line 341 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp106_ = in_offset;
#line 341 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp107_ = x;
#line 341 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											in_o = _tmp106_ + (_tmp107_ * 3);
#line 342 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp108_ = out_offset;
#line 342 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp109_ = x;
#line 342 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											out_o = _tmp108_ + (_tmp109_ * 3);
#line 344 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp110_ = data;
#line 344 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp110__length1 = data_length1;
#line 344 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp111_ = out_o;
#line 344 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp112_ = pixels;
#line 344 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp112__length1 = pixels_length1;
#line 344 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp113_ = in_o;
#line 344 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp114_ = _tmp112_[_tmp113_];
#line 344 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp110_[_tmp111_] = _tmp114_;
#line 344 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp115_ = _tmp110_[_tmp111_];
#line 345 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp116_ = data;
#line 345 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp116__length1 = data_length1;
#line 345 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp117_ = out_o;
#line 345 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp118_ = pixels;
#line 345 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp118__length1 = pixels_length1;
#line 345 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp119_ = in_o;
#line 345 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp120_ = _tmp118_[_tmp119_ + 1];
#line 345 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp116_[_tmp117_ + 1] = _tmp120_;
#line 345 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp121_ = _tmp116_[_tmp117_ + 1];
#line 346 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp122_ = data;
#line 346 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp122__length1 = data_length1;
#line 346 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp123_ = out_o;
#line 346 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp124_ = pixels;
#line 346 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp124__length1 = pixels_length1;
#line 346 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp125_ = in_o;
#line 346 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp126_ = _tmp124_[_tmp125_ + 2];
#line 346 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp122_[_tmp123_ + 2] = _tmp126_;
#line 346 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp127_ = _tmp122_[_tmp123_ + 2];
#line 2837 "book.c"
										}
									}
								}
							}
						}
					}
				} else {
					Page* _tmp128_ = NULL;
					gint _tmp129_ = 0;
					gint _tmp130_ = 0;
#line 350 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp128_ = page;
#line 350 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp129_ = page_get_depth (_tmp128_);
#line 350 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp130_ = _tmp129_;
#line 350 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					if (_tmp130_ == 2) {
#line 2856 "book.c"
						gint shift_count = 0;
						gchar* _tmp131_ = NULL;
						gint data_length = 0;
						gint _tmp132_ = 0;
						gint _tmp133_ = 0;
						gint _tmp134_ = 0;
						guint8* _tmp135_ = NULL;
						gint offset = 0;
#line 352 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						shift_count = 6;
#line 353 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						depth = 2;
#line 354 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_tmp131_ = g_strdup ("DeviceGray");
#line 354 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_g_free0 (color_space);
#line 354 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						color_space = _tmp131_;
#line 355 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_tmp132_ = height;
#line 355 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_tmp133_ = width;
#line 355 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						data_length = _tmp132_ * (((_tmp133_ * 2) + 7) / 8);
#line 356 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_tmp134_ = data_length;
#line 356 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_tmp135_ = g_new0 (guint8, _tmp134_);
#line 356 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						data = (g_free (data), NULL);
#line 356 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						data = _tmp135_;
#line 356 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						data_length1 = _tmp134_;
#line 356 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_data_size_ = data_length1;
#line 357 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						offset = 0;
#line 2895 "book.c"
						{
							gint row = 0;
#line 358 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							row = 0;
#line 2900 "book.c"
							{
								gboolean _tmp136_ = FALSE;
#line 358 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
								_tmp136_ = TRUE;
#line 358 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
								while (TRUE) {
#line 2907 "book.c"
									gint _tmp138_ = 0;
									gint _tmp139_ = 0;
									gint _tmp140_ = 0;
									gint in_offset = 0;
									gint _tmp142_ = 0;
									GdkPixbuf* _tmp143_ = NULL;
									gint _tmp144_ = 0;
									gint _tmp145_ = 0;
#line 358 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
									if (!_tmp136_) {
#line 2918 "book.c"
										gint _tmp137_ = 0;
#line 358 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										_tmp137_ = row;
#line 358 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										row = _tmp137_ + 1;
#line 2924 "book.c"
									}
#line 358 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
									_tmp136_ = FALSE;
#line 358 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
									_tmp138_ = row;
#line 358 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
									_tmp139_ = height;
#line 358 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
									if (!(_tmp138_ < _tmp139_)) {
#line 358 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										break;
#line 2936 "book.c"
									}
#line 361 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
									_tmp140_ = shift_count;
#line 361 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
									if (_tmp140_ != 6) {
#line 2942 "book.c"
										gint _tmp141_ = 0;
#line 363 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										_tmp141_ = offset;
#line 363 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										offset = _tmp141_ + 1;
#line 364 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										shift_count = 6;
#line 2950 "book.c"
									}
#line 367 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
									_tmp142_ = row;
#line 367 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
									_tmp143_ = image;
#line 367 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
									_tmp144_ = gdk_pixbuf_get_rowstride (_tmp143_);
#line 367 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
									_tmp145_ = _tmp144_;
#line 367 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
									in_offset = _tmp142_ * _tmp145_;
#line 2962 "book.c"
									{
										gint x = 0;
#line 368 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										x = 0;
#line 2967 "book.c"
										{
											gboolean _tmp146_ = FALSE;
#line 368 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp146_ = TRUE;
#line 368 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											while (TRUE) {
#line 2974 "book.c"
												gint _tmp148_ = 0;
												gint _tmp149_ = 0;
												gint _tmp150_ = 0;
												guint8 p = 0U;
												guint8* _tmp154_ = NULL;
												gint _tmp154__length1 = 0;
												gint _tmp155_ = 0;
												gint _tmp156_ = 0;
												guint8 _tmp157_ = 0U;
												guint8 _tmp158_ = 0U;
												gint _tmp173_ = 0;
#line 368 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												if (!_tmp146_) {
#line 2988 "book.c"
													gint _tmp147_ = 0;
#line 368 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp147_ = x;
#line 368 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													x = _tmp147_ + 1;
#line 2994 "book.c"
												}
#line 368 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												_tmp146_ = FALSE;
#line 368 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												_tmp148_ = x;
#line 368 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												_tmp149_ = width;
#line 368 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												if (!(_tmp148_ < _tmp149_)) {
#line 368 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													break;
#line 3006 "book.c"
												}
#line 371 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												_tmp150_ = shift_count;
#line 371 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												if (_tmp150_ == 6) {
#line 3012 "book.c"
													guint8* _tmp151_ = NULL;
													gint _tmp151__length1 = 0;
													gint _tmp152_ = 0;
													guint8 _tmp153_ = 0U;
#line 372 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp151_ = data;
#line 372 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp151__length1 = data_length1;
#line 372 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp152_ = offset;
#line 372 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp151_[_tmp152_] = (guint8) 0;
#line 372 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp153_ = _tmp151_[_tmp152_];
#line 3027 "book.c"
												}
#line 375 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												_tmp154_ = pixels;
#line 375 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												_tmp154__length1 = pixels_length1;
#line 375 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												_tmp155_ = in_offset;
#line 375 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												_tmp156_ = x;
#line 375 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												_tmp157_ = _tmp154_[_tmp155_ + (_tmp156_ * 3)];
#line 375 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												p = _tmp157_;
#line 376 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												_tmp158_ = p;
#line 376 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												if (((gint) _tmp158_) >= 192) {
#line 3045 "book.c"
													guint8* _tmp159_ = NULL;
													gint _tmp159__length1 = 0;
													gint _tmp160_ = 0;
													gint _tmp161_ = 0;
													guint8 _tmp162_ = 0U;
#line 377 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp159_ = data;
#line 377 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp159__length1 = data_length1;
#line 377 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp160_ = offset;
#line 377 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp161_ = shift_count;
#line 377 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp159_[_tmp160_] |= (guint8) (3 << _tmp161_);
#line 377 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp162_ = _tmp159_[_tmp160_];
#line 3063 "book.c"
												} else {
													guint8 _tmp163_ = 0U;
#line 378 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp163_ = p;
#line 378 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													if (((gint) _tmp163_) >= 128) {
#line 3070 "book.c"
														guint8* _tmp164_ = NULL;
														gint _tmp164__length1 = 0;
														gint _tmp165_ = 0;
														gint _tmp166_ = 0;
														guint8 _tmp167_ = 0U;
#line 379 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														_tmp164_ = data;
#line 379 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														_tmp164__length1 = data_length1;
#line 379 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														_tmp165_ = offset;
#line 379 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														_tmp166_ = shift_count;
#line 379 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														_tmp164_[_tmp165_] |= (guint8) (2 << _tmp166_);
#line 379 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														_tmp167_ = _tmp164_[_tmp165_];
#line 3088 "book.c"
													} else {
														guint8 _tmp168_ = 0U;
#line 380 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														_tmp168_ = p;
#line 380 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														if (((gint) _tmp168_) >= 64) {
#line 3095 "book.c"
															guint8* _tmp169_ = NULL;
															gint _tmp169__length1 = 0;
															gint _tmp170_ = 0;
															gint _tmp171_ = 0;
															guint8 _tmp172_ = 0U;
#line 381 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
															_tmp169_ = data;
#line 381 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
															_tmp169__length1 = data_length1;
#line 381 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
															_tmp170_ = offset;
#line 381 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
															_tmp171_ = shift_count;
#line 381 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
															_tmp169_[_tmp170_] |= (guint8) (1 << _tmp171_);
#line 381 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
															_tmp172_ = _tmp169_[_tmp170_];
#line 3113 "book.c"
														}
													}
												}
#line 384 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												_tmp173_ = shift_count;
#line 384 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												if (_tmp173_ == 0) {
#line 3121 "book.c"
													gint _tmp174_ = 0;
#line 386 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp174_ = offset;
#line 386 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													offset = _tmp174_ + 1;
#line 387 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													shift_count = 6;
#line 3129 "book.c"
												} else {
													gint _tmp175_ = 0;
#line 390 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp175_ = shift_count;
#line 390 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													shift_count = _tmp175_ - 2;
#line 3136 "book.c"
												}
											}
										}
									}
								}
							}
						}
					} else {
						Page* _tmp176_ = NULL;
						gint _tmp177_ = 0;
						gint _tmp178_ = 0;
#line 394 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_tmp176_ = page;
#line 394 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_tmp177_ = page_get_depth (_tmp176_);
#line 394 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_tmp178_ = _tmp177_;
#line 394 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						if (_tmp178_ == 1) {
#line 3156 "book.c"
							gint mask = 0;
							gchar* _tmp179_ = NULL;
							gint data_length = 0;
							gint _tmp180_ = 0;
							gint _tmp181_ = 0;
							gint _tmp182_ = 0;
							guint8* _tmp183_ = NULL;
							gint offset = 0;
#line 396 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							mask = 0x80;
#line 398 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							depth = 1;
#line 399 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							_tmp179_ = g_strdup ("DeviceGray");
#line 399 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							_g_free0 (color_space);
#line 399 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							color_space = _tmp179_;
#line 400 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							_tmp180_ = height;
#line 400 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							_tmp181_ = width;
#line 400 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							data_length = _tmp180_ * ((_tmp181_ + 7) / 8);
#line 401 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							_tmp182_ = data_length;
#line 401 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							_tmp183_ = g_new0 (guint8, _tmp182_);
#line 401 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							data = (g_free (data), NULL);
#line 401 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							data = _tmp183_;
#line 401 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							data_length1 = _tmp182_;
#line 401 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							_data_size_ = data_length1;
#line 402 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							offset = 0;
#line 3195 "book.c"
							{
								gint row = 0;
#line 403 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
								row = 0;
#line 3200 "book.c"
								{
									gboolean _tmp184_ = FALSE;
#line 403 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
									_tmp184_ = TRUE;
#line 403 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
									while (TRUE) {
#line 3207 "book.c"
										gint _tmp186_ = 0;
										gint _tmp187_ = 0;
										gint _tmp188_ = 0;
										gint in_offset = 0;
										gint _tmp190_ = 0;
										GdkPixbuf* _tmp191_ = NULL;
										gint _tmp192_ = 0;
										gint _tmp193_ = 0;
#line 403 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										if (!_tmp184_) {
#line 3218 "book.c"
											gint _tmp185_ = 0;
#line 403 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp185_ = row;
#line 403 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											row = _tmp185_ + 1;
#line 3224 "book.c"
										}
#line 403 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										_tmp184_ = FALSE;
#line 403 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										_tmp186_ = row;
#line 403 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										_tmp187_ = height;
#line 403 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										if (!(_tmp186_ < _tmp187_)) {
#line 403 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											break;
#line 3236 "book.c"
										}
#line 406 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										_tmp188_ = mask;
#line 406 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										if (_tmp188_ != 0x80) {
#line 3242 "book.c"
											gint _tmp189_ = 0;
#line 408 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp189_ = offset;
#line 408 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											offset = _tmp189_ + 1;
#line 409 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											mask = 0x80;
#line 3250 "book.c"
										}
#line 412 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										_tmp190_ = row;
#line 412 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										_tmp191_ = image;
#line 412 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										_tmp192_ = gdk_pixbuf_get_rowstride (_tmp191_);
#line 412 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										_tmp193_ = _tmp192_;
#line 412 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										in_offset = _tmp190_ * _tmp193_;
#line 3262 "book.c"
										{
											gint x = 0;
#line 413 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											x = 0;
#line 3267 "book.c"
											{
												gboolean _tmp194_ = FALSE;
#line 413 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												_tmp194_ = TRUE;
#line 413 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												while (TRUE) {
#line 3274 "book.c"
													gint _tmp196_ = 0;
													gint _tmp197_ = 0;
													gint _tmp198_ = 0;
													guint8* _tmp202_ = NULL;
													gint _tmp202__length1 = 0;
													gint _tmp203_ = 0;
													gint _tmp204_ = 0;
													guint8 _tmp205_ = 0U;
													gint _tmp210_ = 0;
													gint _tmp211_ = 0;
#line 413 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													if (!_tmp194_) {
#line 3287 "book.c"
														gint _tmp195_ = 0;
#line 413 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														_tmp195_ = x;
#line 413 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														x = _tmp195_ + 1;
#line 3293 "book.c"
													}
#line 413 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp194_ = FALSE;
#line 413 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp196_ = x;
#line 413 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp197_ = width;
#line 413 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													if (!(_tmp196_ < _tmp197_)) {
#line 413 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														break;
#line 3305 "book.c"
													}
#line 416 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp198_ = mask;
#line 416 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													if (_tmp198_ == 0x80) {
#line 3311 "book.c"
														guint8* _tmp199_ = NULL;
														gint _tmp199__length1 = 0;
														gint _tmp200_ = 0;
														guint8 _tmp201_ = 0U;
#line 417 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														_tmp199_ = data;
#line 417 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														_tmp199__length1 = data_length1;
#line 417 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														_tmp200_ = offset;
#line 417 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														_tmp199_[_tmp200_] = (guint8) 0;
#line 417 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														_tmp201_ = _tmp199_[_tmp200_];
#line 3326 "book.c"
													}
#line 420 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp202_ = pixels;
#line 420 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp202__length1 = pixels_length1;
#line 420 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp203_ = in_offset;
#line 420 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp204_ = x;
#line 420 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp205_ = _tmp202_[_tmp203_ + (_tmp204_ * 3)];
#line 420 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													if (((gint) _tmp205_) != 0) {
#line 3340 "book.c"
														guint8* _tmp206_ = NULL;
														gint _tmp206__length1 = 0;
														gint _tmp207_ = 0;
														gint _tmp208_ = 0;
														guint8 _tmp209_ = 0U;
#line 421 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														_tmp206_ = data;
#line 421 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														_tmp206__length1 = data_length1;
#line 421 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														_tmp207_ = offset;
#line 421 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														_tmp208_ = mask;
#line 421 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														_tmp206_[_tmp207_] |= (guint8) _tmp208_;
#line 421 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														_tmp209_ = _tmp206_[_tmp207_];
#line 3358 "book.c"
													}
#line 424 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp210_ = mask;
#line 424 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													mask = _tmp210_ >> 1;
#line 425 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp211_ = mask;
#line 425 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													if (_tmp211_ == 0) {
#line 3368 "book.c"
														gint _tmp212_ = 0;
#line 427 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														_tmp212_ = offset;
#line 427 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														offset = _tmp212_ + 1;
#line 428 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														mask = 0x80;
#line 3376 "book.c"
													}
												}
											}
										}
									}
								}
							}
						} else {
							gchar* _tmp213_ = NULL;
							gint data_length = 0;
							gint _tmp214_ = 0;
							gint _tmp215_ = 0;
							gint _tmp216_ = 0;
							guint8* _tmp217_ = NULL;
#line 435 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							depth = 8;
#line 436 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							_tmp213_ = g_strdup ("DeviceGray");
#line 436 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							_g_free0 (color_space);
#line 436 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							color_space = _tmp213_;
#line 437 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							_tmp214_ = height;
#line 437 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							_tmp215_ = width;
#line 437 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							data_length = _tmp214_ * _tmp215_;
#line 438 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							_tmp216_ = data_length;
#line 438 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							_tmp217_ = g_new0 (guint8, _tmp216_);
#line 438 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							data = (g_free (data), NULL);
#line 438 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							data = _tmp217_;
#line 438 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							data_length1 = _tmp216_;
#line 438 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							_data_size_ = data_length1;
#line 3417 "book.c"
							{
								gint row = 0;
#line 439 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
								row = 0;
#line 3422 "book.c"
								{
									gboolean _tmp218_ = FALSE;
#line 439 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
									_tmp218_ = TRUE;
#line 439 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
									while (TRUE) {
#line 3429 "book.c"
										gint _tmp220_ = 0;
										gint _tmp221_ = 0;
										gint in_offset = 0;
										gint _tmp222_ = 0;
										GdkPixbuf* _tmp223_ = NULL;
										gint _tmp224_ = 0;
										gint _tmp225_ = 0;
										gint out_offset = 0;
										gint _tmp226_ = 0;
										gint _tmp227_ = 0;
#line 439 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										if (!_tmp218_) {
#line 3442 "book.c"
											gint _tmp219_ = 0;
#line 439 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp219_ = row;
#line 439 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											row = _tmp219_ + 1;
#line 3448 "book.c"
										}
#line 439 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										_tmp218_ = FALSE;
#line 439 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										_tmp220_ = row;
#line 439 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										_tmp221_ = height;
#line 439 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										if (!(_tmp220_ < _tmp221_)) {
#line 439 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											break;
#line 3460 "book.c"
										}
#line 441 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										_tmp222_ = row;
#line 441 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										_tmp223_ = image;
#line 441 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										_tmp224_ = gdk_pixbuf_get_rowstride (_tmp223_);
#line 441 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										_tmp225_ = _tmp224_;
#line 441 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										in_offset = _tmp222_ * _tmp225_;
#line 442 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										_tmp226_ = row;
#line 442 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										_tmp227_ = width;
#line 442 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										out_offset = _tmp226_ * _tmp227_;
#line 3478 "book.c"
										{
											gint x = 0;
#line 443 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											x = 0;
#line 3483 "book.c"
											{
												gboolean _tmp228_ = FALSE;
#line 443 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												_tmp228_ = TRUE;
#line 443 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												while (TRUE) {
#line 3490 "book.c"
													gint _tmp230_ = 0;
													gint _tmp231_ = 0;
													guint8* _tmp232_ = NULL;
													gint _tmp232__length1 = 0;
													gint _tmp233_ = 0;
													gint _tmp234_ = 0;
													guint8* _tmp235_ = NULL;
													gint _tmp235__length1 = 0;
													gint _tmp236_ = 0;
													gint _tmp237_ = 0;
													guint8 _tmp238_ = 0U;
													guint8 _tmp239_ = 0U;
#line 443 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													if (!_tmp228_) {
#line 3505 "book.c"
														gint _tmp229_ = 0;
#line 443 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														_tmp229_ = x;
#line 443 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														x = _tmp229_ + 1;
#line 3511 "book.c"
													}
#line 443 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp228_ = FALSE;
#line 443 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp230_ = x;
#line 443 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp231_ = width;
#line 443 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													if (!(_tmp230_ < _tmp231_)) {
#line 443 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														break;
#line 3523 "book.c"
													}
#line 444 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp232_ = data;
#line 444 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp232__length1 = data_length1;
#line 444 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp233_ = out_offset;
#line 444 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp234_ = x;
#line 444 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp235_ = pixels;
#line 444 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp235__length1 = pixels_length1;
#line 444 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp236_ = in_offset;
#line 444 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp237_ = x;
#line 444 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp238_ = _tmp235_[_tmp236_ + (_tmp237_ * 3)];
#line 444 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp232_[_tmp233_ + _tmp234_] = _tmp238_;
#line 444 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp239_ = _tmp232_[_tmp233_ + _tmp234_];
#line 3547 "book.c"
												}
											}
										}
									}
								}
							}
						}
					}
				}
#line 449 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp240_ = data;
#line 449 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp240__length1 = data_length1;
#line 449 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp242_ = book_compress_zlib (self, _tmp240_, _tmp240__length1, &_tmp241_);
#line 449 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				compressed_data = _tmp242_;
#line 449 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				compressed_data_length1 = _tmp241_;
#line 449 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_compressed_data_size_ = compressed_data_length1;
#line 450 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp243_ = compressed_data;
#line 450 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp243__length1 = compressed_data_length1;
#line 450 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				if (_tmp243_ != NULL) {
#line 3575 "book.c"
					gint _tmp244_ = 0;
					const gchar* _tmp257_ = NULL;
#line 453 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp244_ = depth;
#line 453 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					if (_tmp244_ > 1) {
#line 3582 "book.c"
						guint8* jpeg_data = NULL;
						GdkPixbuf* _tmp245_ = NULL;
						gint _tmp246_ = 0;
						Page* _tmp247_ = NULL;
						gint _tmp248_ = 0;
						gint _tmp249_ = 0;
						gint _tmp250_ = 0;
						guint8* _tmp251_ = NULL;
						gint jpeg_data_length1 = 0;
						gint _jpeg_data_size_ = 0;
						guint8* _tmp252_ = NULL;
						gint _tmp252__length1 = 0;
						guint8* _tmp253_ = NULL;
						gint _tmp253__length1 = 0;
#line 455 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_tmp245_ = image;
#line 455 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_tmp246_ = quality;
#line 455 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_tmp247_ = page;
#line 455 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_tmp248_ = page_get_dpi (_tmp247_);
#line 455 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_tmp249_ = _tmp248_;
#line 455 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_tmp251_ = book_compress_jpeg (self, _tmp245_, _tmp246_, _tmp249_, &_tmp250_);
#line 455 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						jpeg_data = _tmp251_;
#line 455 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						jpeg_data_length1 = _tmp250_;
#line 455 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_jpeg_data_size_ = jpeg_data_length1;
#line 456 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_tmp252_ = jpeg_data;
#line 456 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_tmp252__length1 = jpeg_data_length1;
#line 456 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_tmp253_ = compressed_data;
#line 456 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_tmp253__length1 = compressed_data_length1;
#line 456 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						if (_tmp252__length1 < _tmp253__length1) {
#line 3625 "book.c"
							gchar* _tmp254_ = NULL;
							guint8* _tmp255_ = NULL;
							gint _tmp255__length1 = 0;
							guint8* _tmp256_ = NULL;
							gint _tmp256__length1 = 0;
#line 458 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							_tmp254_ = g_strdup ("DCTDecode");
#line 458 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							_g_free0 (filter);
#line 458 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							filter = _tmp254_;
#line 459 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							_tmp255_ = jpeg_data;
#line 459 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							_tmp255__length1 = jpeg_data_length1;
#line 459 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							_tmp256_ = (_tmp255_ != NULL) ? _vala_array_dup1 (_tmp255_, _tmp255__length1) : ((gpointer) _tmp255_);
#line 459 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							_tmp256__length1 = _tmp255__length1;
#line 459 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							data = (g_free (data), NULL);
#line 459 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							data = _tmp256_;
#line 459 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							data_length1 = _tmp256__length1;
#line 459 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							_data_size_ = data_length1;
#line 3653 "book.c"
						}
#line 453 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						jpeg_data = (g_free (jpeg_data), NULL);
#line 3657 "book.c"
					}
#line 463 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp257_ = filter;
#line 463 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					if (_tmp257_ == NULL) {
#line 3663 "book.c"
						gchar* _tmp258_ = NULL;
						guint8* _tmp259_ = NULL;
						gint _tmp259__length1 = 0;
						guint8* _tmp260_ = NULL;
						gint _tmp260__length1 = 0;
#line 465 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_tmp258_ = g_strdup ("FlateDecode");
#line 465 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_g_free0 (filter);
#line 465 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						filter = _tmp258_;
#line 466 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_tmp259_ = compressed_data;
#line 466 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_tmp259__length1 = compressed_data_length1;
#line 466 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_tmp260_ = (_tmp259_ != NULL) ? _vala_array_dup2 (_tmp259_, _tmp259__length1) : ((gpointer) _tmp259_);
#line 466 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_tmp260__length1 = _tmp259__length1;
#line 466 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						data = (g_free (data), NULL);
#line 466 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						data = _tmp260_;
#line 466 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						data_length1 = _tmp260__length1;
#line 466 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_data_size_ = data_length1;
#line 3691 "book.c"
					}
				}
#line 471 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp261_ = writer;
#line 471 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp261_, "\n");
#line 472 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp262_ = writer;
#line 472 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp263_ = pdf_writer_start_object (_tmp262_);
#line 472 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				number = _tmp263_;
#line 473 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp264_ = writer;
#line 473 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp265_ = number;
#line 473 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp266_ = g_strdup_printf ("%u 0 obj\n", _tmp265_);
#line 473 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp267_ = _tmp266_;
#line 473 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp264_, _tmp267_);
#line 473 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_g_free0 (_tmp267_);
#line 474 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp268_ = writer;
#line 474 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp268_, "<<\n");
#line 475 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp269_ = writer;
#line 475 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp269_, "/Type /Page\n");
#line 476 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp270_ = writer;
#line 476 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp271_ = pages_number;
#line 476 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp272_ = g_strdup_printf ("/Parent %u 0 R\n", _tmp271_);
#line 476 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp273_ = _tmp272_;
#line 476 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp270_, _tmp273_);
#line 476 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_g_free0 (_tmp273_);
#line 477 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp274_ = writer;
#line 477 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp275_ = i;
#line 477 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp276_ = number;
#line 477 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp277_ = g_strdup_printf ("/Resources << /XObject << /Im%d %u 0 R >> >>\n", _tmp275_, _tmp276_ + 1);
#line 477 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp278_ = _tmp277_;
#line 477 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp274_, _tmp278_);
#line 477 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_g_free0 (_tmp278_);
#line 478 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp279_ = writer;
#line 478 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp280_ = page_width;
#line 478 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp281_ = width_buffer;
#line 478 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp281__length1 = width_buffer_length1;
#line 478 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp282_ = g_ascii_formatd (_tmp281_, _tmp281__length1, "%.2f", _tmp280_);
#line 478 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp283_ = page_height;
#line 478 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp284_ = height_buffer;
#line 478 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp284__length1 = height_buffer_length1;
#line 478 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp285_ = g_ascii_formatd (_tmp284_, _tmp284__length1, "%.2f", _tmp283_);
#line 478 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp286_ = g_strdup_printf ("/MediaBox [ 0 0 %s %s ]\n", _tmp282_, _tmp285_);
#line 478 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp287_ = _tmp286_;
#line 478 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp279_, _tmp287_);
#line 478 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_g_free0 (_tmp287_);
#line 479 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp288_ = writer;
#line 479 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp289_ = number;
#line 479 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp290_ = g_strdup_printf ("/Contents %u 0 R\n", _tmp289_ + 2);
#line 479 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp291_ = _tmp290_;
#line 479 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp288_, _tmp291_);
#line 479 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_g_free0 (_tmp291_);
#line 480 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp292_ = writer;
#line 480 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp292_, ">>\n");
#line 481 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp293_ = writer;
#line 481 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp293_, "endobj\n");
#line 484 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp294_ = writer;
#line 484 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp294_, "\n");
#line 485 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp295_ = writer;
#line 485 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp296_ = pdf_writer_start_object (_tmp295_);
#line 485 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				number = _tmp296_;
#line 486 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp297_ = writer;
#line 486 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp298_ = number;
#line 486 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp299_ = g_strdup_printf ("%u 0 obj\n", _tmp298_);
#line 486 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp300_ = _tmp299_;
#line 486 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp297_, _tmp300_);
#line 486 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_g_free0 (_tmp300_);
#line 487 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp301_ = writer;
#line 487 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp301_, "<<\n");
#line 488 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp302_ = writer;
#line 488 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp302_, "/Type /XObject\n");
#line 489 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp303_ = writer;
#line 489 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp303_, "/Subtype /Image\n");
#line 490 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp304_ = writer;
#line 490 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp305_ = width;
#line 490 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp306_ = g_strdup_printf ("/Width %d\n", _tmp305_);
#line 490 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp307_ = _tmp306_;
#line 490 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp304_, _tmp307_);
#line 490 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_g_free0 (_tmp307_);
#line 491 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp308_ = writer;
#line 491 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp309_ = height;
#line 491 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp310_ = g_strdup_printf ("/Height %d\n", _tmp309_);
#line 491 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp311_ = _tmp310_;
#line 491 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp308_, _tmp311_);
#line 491 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_g_free0 (_tmp311_);
#line 492 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp312_ = writer;
#line 492 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp313_ = color_space;
#line 492 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp314_ = g_strdup_printf ("/ColorSpace /%s\n", _tmp313_);
#line 492 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp315_ = _tmp314_;
#line 492 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp312_, _tmp315_);
#line 492 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_g_free0 (_tmp315_);
#line 493 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp316_ = writer;
#line 493 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp317_ = depth;
#line 493 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp318_ = g_strdup_printf ("/BitsPerComponent %d\n", _tmp317_);
#line 493 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp319_ = _tmp318_;
#line 493 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp316_, _tmp319_);
#line 493 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_g_free0 (_tmp319_);
#line 494 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp320_ = writer;
#line 494 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp321_ = data;
#line 494 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp321__length1 = data_length1;
#line 494 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp322_ = g_strdup_printf ("/Length %d\n", _tmp321__length1);
#line 494 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp323_ = _tmp322_;
#line 494 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp320_, _tmp323_);
#line 494 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_g_free0 (_tmp323_);
#line 495 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp324_ = filter;
#line 495 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				if (_tmp324_ != NULL) {
#line 3896 "book.c"
					PDFWriter* _tmp325_ = NULL;
					const gchar* _tmp326_ = NULL;
					gchar* _tmp327_ = NULL;
					gchar* _tmp328_ = NULL;
#line 496 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp325_ = writer;
#line 496 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp326_ = filter;
#line 496 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp327_ = g_strdup_printf ("/Filter /%s\n", _tmp326_);
#line 496 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp328_ = _tmp327_;
#line 496 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					pdf_writer_write_string (_tmp325_, _tmp328_);
#line 496 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_g_free0 (_tmp328_);
#line 3913 "book.c"
				}
#line 497 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp329_ = writer;
#line 497 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp329_, ">>\n");
#line 498 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp330_ = writer;
#line 498 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp330_, "stream\n");
#line 499 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp331_ = writer;
#line 499 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp332_ = data;
#line 499 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp332__length1 = data_length1;
#line 499 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write (_tmp331_, _tmp332_, _tmp332__length1);
#line 500 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp333_ = writer;
#line 500 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp333_, "\n");
#line 501 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp334_ = writer;
#line 501 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp334_, "endstream\n");
#line 502 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp335_ = writer;
#line 502 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp335_, "endobj\n");
#line 505 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp336_ = page_width;
#line 505 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp337_ = width_buffer;
#line 505 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp337__length1 = width_buffer_length1;
#line 505 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp338_ = g_ascii_formatd (_tmp337_, _tmp337__length1, "%f", _tmp336_);
#line 505 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp339_ = page_height;
#line 505 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp340_ = height_buffer;
#line 505 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp340__length1 = height_buffer_length1;
#line 505 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp341_ = g_ascii_formatd (_tmp340_, _tmp340__length1, "%f", _tmp339_);
#line 505 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp342_ = i;
#line 505 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp343_ = g_strdup_printf ("q\n%s 0 0 %s 0 0 cm\n/Im%d Do\nQ", _tmp338_, _tmp341_, _tmp342_);
#line 505 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				command = _tmp343_;
#line 506 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp344_ = writer;
#line 506 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp344_, "\n");
#line 507 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp345_ = writer;
#line 507 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp346_ = pdf_writer_start_object (_tmp345_);
#line 507 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				number = _tmp346_;
#line 508 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp347_ = writer;
#line 508 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp348_ = number;
#line 508 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp349_ = g_strdup_printf ("%u 0 obj\n", _tmp348_);
#line 508 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp350_ = _tmp349_;
#line 508 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp347_, _tmp350_);
#line 508 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_g_free0 (_tmp350_);
#line 509 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp351_ = writer;
#line 509 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp351_, "<<\n");
#line 510 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp352_ = writer;
#line 510 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp353_ = command;
#line 510 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp354_ = strlen (_tmp353_);
#line 510 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp355_ = _tmp354_;
#line 510 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp356_ = g_strdup_printf ("/Length %d\n", _tmp355_);
#line 510 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp357_ = _tmp356_;
#line 510 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp352_, _tmp357_);
#line 510 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_g_free0 (_tmp357_);
#line 511 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp358_ = writer;
#line 511 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp358_, ">>\n");
#line 512 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp359_ = writer;
#line 512 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp359_, "stream\n");
#line 513 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp360_ = writer;
#line 513 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp361_ = command;
#line 513 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp360_, _tmp361_);
#line 514 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp362_ = writer;
#line 514 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp362_, "\n");
#line 515 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp363_ = writer;
#line 515 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp363_, "endstream\n");
#line 516 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp364_ = writer;
#line 516 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp364_, "endobj\n");
#line 518 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp365_ = i;
#line 518 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				g_signal_emit_by_name (self, "saving", _tmp365_);
#line 313 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_g_free0 (command);
#line 313 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				compressed_data = (g_free (compressed_data), NULL);
#line 313 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				data = (g_free (data), NULL);
#line 313 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				height_buffer = (g_free (height_buffer), NULL);
#line 313 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				width_buffer = (g_free (width_buffer), NULL);
#line 313 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_g_free0 (filter);
#line 313 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_g_free0 (color_space);
#line 313 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_g_object_unref0 (image);
#line 313 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_page_unref0 (page);
#line 4055 "book.c"
			}
		}
	}
#line 522 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp366_ = writer;
#line 522 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp366_, "\n");
#line 523 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp367_ = writer;
#line 523 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp368_ = pdf_writer_start_object (_tmp367_);
#line 523 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	info_number = _tmp368_;
#line 524 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp369_ = writer;
#line 524 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp370_ = info_number;
#line 524 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp371_ = g_strdup_printf ("%u 0 obj\n", _tmp370_);
#line 524 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp372_ = _tmp371_;
#line 524 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp369_, _tmp372_);
#line 524 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_free0 (_tmp372_);
#line 525 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp373_ = writer;
#line 525 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp373_, "<<\n");
#line 526 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp374_ = writer;
#line 526 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp375_ = g_strdup_printf ("/Creator (Simple Scan %s)\n", VERSION);
#line 526 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp376_ = _tmp375_;
#line 526 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp374_, _tmp376_);
#line 526 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_free0 (_tmp376_);
#line 527 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp377_ = writer;
#line 527 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp377_, ">>\n");
#line 528 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp378_ = writer;
#line 528 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp378_, "endobj\n");
#line 531 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp379_ = writer;
#line 531 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp379_, "\n");
#line 532 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp380_ = writer;
#line 532 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp381_ = _tmp380_->offset;
#line 532 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	xref_offset = _tmp381_;
#line 533 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp382_ = writer;
#line 533 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp382_, "xref\n");
#line 534 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp383_ = writer;
#line 534 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp384_ = writer;
#line 534 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp385_ = _tmp384_->object_offsets;
#line 534 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp386_ = g_list_length (_tmp385_);
#line 534 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp387_ = g_strdup_printf ("0 %zu\n", (gsize) (_tmp386_ + 1));
#line 534 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp388_ = _tmp387_;
#line 534 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp383_, _tmp388_);
#line 534 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_free0 (_tmp388_);
#line 535 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp389_ = writer;
#line 535 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp389_, "0000000000 65535 f \n");
#line 536 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp390_ = writer;
#line 536 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp391_ = _tmp390_->object_offsets;
#line 4141 "book.c"
	{
		GList* offset_collection = NULL;
		GList* offset_it = NULL;
#line 536 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		offset_collection = _tmp391_;
#line 536 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		for (offset_it = offset_collection; offset_it != NULL; offset_it = offset_it->next) {
#line 4149 "book.c"
			guint offset = 0U;
#line 536 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			offset = (guint) ((guintptr) offset_it->data);
#line 4153 "book.c"
			{
				PDFWriter* _tmp392_ = NULL;
				guint _tmp393_ = 0U;
				gchar* _tmp394_ = NULL;
				gchar* _tmp395_ = NULL;
#line 537 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp392_ = writer;
#line 537 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp393_ = offset;
#line 537 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp394_ = g_strdup_printf ("%010zu 00000 n \n", (gsize) _tmp393_);
#line 537 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp395_ = _tmp394_;
#line 537 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp392_, _tmp395_);
#line 537 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_g_free0 (_tmp395_);
#line 4171 "book.c"
			}
		}
	}
#line 540 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp396_ = writer;
#line 540 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp396_, "\n");
#line 541 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp397_ = writer;
#line 541 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp397_, "trailer\n");
#line 542 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp398_ = writer;
#line 542 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp398_, "<<\n");
#line 543 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp399_ = writer;
#line 543 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp400_ = writer;
#line 543 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp401_ = _tmp400_->object_offsets;
#line 543 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp402_ = g_list_length (_tmp401_);
#line 543 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp403_ = g_strdup_printf ("/Size %zu\n", (gsize) (_tmp402_ + 1));
#line 543 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp404_ = _tmp403_;
#line 543 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp399_, _tmp404_);
#line 543 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_free0 (_tmp404_);
#line 544 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp405_ = writer;
#line 544 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp406_ = info_number;
#line 544 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp407_ = g_strdup_printf ("/Info %u 0 R\n", _tmp406_);
#line 544 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp408_ = _tmp407_;
#line 544 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp405_, _tmp408_);
#line 544 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_free0 (_tmp408_);
#line 545 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp409_ = writer;
#line 545 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp410_ = catalog_number;
#line 545 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp411_ = g_strdup_printf ("/Root %u 0 R\n", _tmp410_);
#line 545 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp412_ = _tmp411_;
#line 545 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp409_, _tmp412_);
#line 545 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_free0 (_tmp412_);
#line 546 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp413_ = writer;
#line 546 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp414_ = id;
#line 546 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp415_ = id;
#line 546 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp416_ = g_strdup_printf ("/ID [<%s> <%s>]\n", _tmp414_, _tmp415_);
#line 546 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp417_ = _tmp416_;
#line 546 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp413_, _tmp417_);
#line 546 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_free0 (_tmp417_);
#line 547 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp418_ = writer;
#line 547 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp418_, ">>\n");
#line 548 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp419_ = writer;
#line 548 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp419_, "startxref\n");
#line 549 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp420_ = writer;
#line 549 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp421_ = xref_offset;
#line 549 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp422_ = g_strdup_printf ("%zu\n", _tmp421_);
#line 549 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp423_ = _tmp422_;
#line 549 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp420_, _tmp423_);
#line 549 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_free0 (_tmp423_);
#line 550 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp424_ = writer;
#line 550 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp424_, "%%EOF\n");
#line 257 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_pdf_writer_unref0 (writer);
#line 257 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_object_unref0 (stream);
#line 257 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_free0 (id);
#line 4271 "book.c"
}


void book_save (Book* self, const gchar* type, gint quality, GFile* file, GError** error) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GQuark _tmp3_ = 0U;
#line 555 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	static GQuark _tmp2_label0 = 0;
#line 555 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	static GQuark _tmp2_label1 = 0;
#line 555 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	static GQuark _tmp2_label2 = 0;
#line 555 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	static GQuark _tmp2_label3 = 0;
#line 555 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	static GQuark _tmp2_label4 = 0;
#line 4289 "book.c"
	GError * _inner_error_ = NULL;
#line 553 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (self != NULL);
#line 553 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (type != NULL);
#line 553 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (file != NULL);
#line 555 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0_ = type;
#line 555 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp1_ = _tmp0_;
#line 555 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
#line 555 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (((_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("jpeg")))) || (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("png"))))) || (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("tiff"))))) {
#line 555 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		switch (0) {
#line 4307 "book.c"
			default:
			{
				const gchar* _tmp4_ = NULL;
				gint _tmp5_ = 0;
				GFile* _tmp6_ = NULL;
#line 560 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp4_ = type;
#line 560 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp5_ = quality;
#line 560 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp6_ = file;
#line 560 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				book_save_multi_file (self, _tmp4_, _tmp5_, _tmp6_, &_inner_error_);
#line 560 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 560 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					g_propagate_error (error, _inner_error_);
#line 560 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					return;
#line 4327 "book.c"
				}
#line 561 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				break;
#line 4331 "book.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("ps")))) {
#line 555 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		switch (0) {
#line 4337 "book.c"
			default:
			{
				GFile* _tmp7_ = NULL;
#line 563 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp7_ = file;
#line 563 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				book_save_ps (self, _tmp7_, &_inner_error_);
#line 563 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 563 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					g_propagate_error (error, _inner_error_);
#line 563 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					return;
#line 4351 "book.c"
				}
#line 564 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				break;
#line 4355 "book.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("pdf")))) {
#line 555 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		switch (0) {
#line 4361 "book.c"
			default:
			{
				GFile* _tmp8_ = NULL;
				gint _tmp9_ = 0;
#line 566 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp8_ = file;
#line 566 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp9_ = quality;
#line 566 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				book_save_pdf (self, _tmp8_, _tmp9_, &_inner_error_);
#line 566 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 566 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					g_propagate_error (error, _inner_error_);
#line 566 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					return;
#line 4378 "book.c"
				}
#line 567 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				break;
#line 4382 "book.c"
			}
		}
	}
}


guint book_get_n_pages (Book* self) {
	guint result;
	GList* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
#line 16 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 16 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0_ = self->priv->pages;
#line 16 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp1_ = g_list_length (_tmp0_);
#line 16 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	result = _tmp1_;
#line 16 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return result;
#line 4403 "book.c"
}


gboolean book_get_needs_saving (Book* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 21 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 21 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0_ = self->priv->needs_saving_;
#line 21 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	result = _tmp0_;
#line 21 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return result;
#line 4418 "book.c"
}


void book_set_needs_saving (Book* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 22 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (self != NULL);
#line 24 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0_ = self->priv->needs_saving_;
#line 24 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp1_ = value;
#line 24 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (_tmp0_ == _tmp1_) {
#line 25 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		return;
#line 4436 "book.c"
	}
#line 26 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp2_ = value;
#line 26 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->priv->needs_saving_ = _tmp2_;
#line 27 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_signal_emit_by_name (self, "needs-saving-changed");
#line 4444 "book.c"
}


static void g_cclosure_user_marshal_VOID__PAGE (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__PAGE) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__PAGE callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (n_param_values == 2);
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		data1 = closure->data;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		data2 = param_values->data[0].v_pointer;
#line 4463 "book.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		data1 = param_values->data[0].v_pointer;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		data2 = closure->data;
#line 4469 "book.c"
	}
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	callback = (GMarshalFunc_VOID__PAGE) (marshal_data ? marshal_data : cc->callback);
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	callback (data1, value_get_page (param_values + 1), data2);
#line 4475 "book.c"
}


static void value_book_init (GValue* value) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	value->data[0].v_pointer = NULL;
#line 4482 "book.c"
}


static void value_book_free_value (GValue* value) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (value->data[0].v_pointer) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		book_unref (value->data[0].v_pointer);
#line 4491 "book.c"
	}
}


static void value_book_copy_value (const GValue* src_value, GValue* dest_value) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (src_value->data[0].v_pointer) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		dest_value->data[0].v_pointer = book_ref (src_value->data[0].v_pointer);
#line 4501 "book.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		dest_value->data[0].v_pointer = NULL;
#line 4505 "book.c"
	}
}


static gpointer value_book_peek_pointer (const GValue* value) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return value->data[0].v_pointer;
#line 4513 "book.c"
}


static gchar* value_book_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (collect_values[0].v_pointer) {
#line 4520 "book.c"
		Book* object;
		object = collect_values[0].v_pointer;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		if (object->parent_instance.g_class == NULL) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4527 "book.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4531 "book.c"
		}
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		value->data[0].v_pointer = book_ref (object);
#line 4535 "book.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		value->data[0].v_pointer = NULL;
#line 4539 "book.c"
	}
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return NULL;
#line 4543 "book.c"
}


static gchar* value_book_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Book** object_p;
	object_p = collect_values[0].v_pointer;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (!object_p) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 4554 "book.c"
	}
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (!value->data[0].v_pointer) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		*object_p = NULL;
#line 4560 "book.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		*object_p = value->data[0].v_pointer;
#line 4564 "book.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		*object_p = book_ref (value->data[0].v_pointer);
#line 4568 "book.c"
	}
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return NULL;
#line 4572 "book.c"
}


GParamSpec* param_spec_book (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecBook* spec;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_BOOK), NULL);
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return G_PARAM_SPEC (spec);
#line 4586 "book.c"
}


gpointer value_get_book (const GValue* value) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BOOK), NULL);
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return value->data[0].v_pointer;
#line 4595 "book.c"
}


void value_set_book (GValue* value, gpointer v_object) {
	Book* old;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BOOK));
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	old = value->data[0].v_pointer;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (v_object) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_BOOK));
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		value->data[0].v_pointer = v_object;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		book_ref (value->data[0].v_pointer);
#line 4615 "book.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		value->data[0].v_pointer = NULL;
#line 4619 "book.c"
	}
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (old) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		book_unref (old);
#line 4625 "book.c"
	}
}


void value_take_book (GValue* value, gpointer v_object) {
	Book* old;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BOOK));
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	old = value->data[0].v_pointer;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (v_object) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_BOOK));
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		value->data[0].v_pointer = v_object;
#line 4644 "book.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		value->data[0].v_pointer = NULL;
#line 4648 "book.c"
	}
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (old) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		book_unref (old);
#line 4654 "book.c"
	}
}


static void book_class_init (BookClass * klass) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	book_parent_class = g_type_class_peek_parent (klass);
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	((BookClass *) klass)->finalize = book_finalize;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_type_class_add_private (klass, sizeof (BookPrivate));
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_signal_new ("page_added", TYPE_BOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__PAGE, G_TYPE_NONE, 1, TYPE_PAGE);
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_signal_new ("page_removed", TYPE_BOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__PAGE, G_TYPE_NONE, 1, TYPE_PAGE);
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_signal_new ("reordered", TYPE_BOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_signal_new ("cleared", TYPE_BOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_signal_new ("needs_saving_changed", TYPE_BOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_signal_new ("saving", TYPE_BOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
#line 4678 "book.c"
}


static void book_instance_init (Book * self) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->priv = BOOK_GET_PRIVATE (self);
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->ref_count = 1;
#line 4687 "book.c"
}


static void book_finalize (Book* obj) {
	Book * self;
	GList* _tmp0_ = NULL;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BOOK, Book);
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_signal_handlers_destroy (self);
#line 45 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0_ = self->priv->pages;
#line 4700 "book.c"
	{
		GList* page_collection = NULL;
		GList* page_it = NULL;
#line 45 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		page_collection = _tmp0_;
#line 45 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		for (page_it = page_collection; page_it != NULL; page_it = page_it->next) {
#line 4708 "book.c"
			Page* _tmp1_ = NULL;
			Page* page = NULL;
#line 45 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			_tmp1_ = _page_ref0 ((Page*) page_it->data);
#line 45 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			page = _tmp1_;
#line 4715 "book.c"
			{
				Page* _tmp2_ = NULL;
				guint _tmp3_ = 0U;
				Page* _tmp4_ = NULL;
				guint _tmp5_ = 0U;
#line 47 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp2_ = page;
#line 47 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				g_signal_parse_name ("pixels-changed", TYPE_PAGE, &_tmp3_, NULL, FALSE);
#line 47 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _book_page_changed_cb_page_pixels_changed, self);
#line 48 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp4_ = page;
#line 48 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				g_signal_parse_name ("crop-changed", TYPE_PAGE, &_tmp5_, NULL, FALSE);
#line 48 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _book_page_changed_cb_page_crop_changed, self);
#line 45 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_page_unref0 (page);
#line 4735 "book.c"
			}
		}
	}
#line 14 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	__g_list_free__page_unref0_0 (self->priv->pages);
#line 231 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_byte_array_unref0 (self->priv->jpeg_data);
#line 4743 "book.c"
}


GType book_get_type (void) {
	static volatile gsize book_type_id__volatile = 0;
	if (g_once_init_enter (&book_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_book_init, value_book_free_value, value_book_copy_value, value_book_peek_pointer, "p", value_book_collect_value, "p", value_book_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (BookClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) book_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Book), 0, (GInstanceInitFunc) book_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType book_type_id;
		book_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Book", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&book_type_id__volatile, book_type_id);
	}
	return book_type_id__volatile;
}


gpointer book_ref (gpointer instance) {
	Book* self;
	self = instance;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_atomic_int_inc (&self->ref_count);
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return instance;
#line 4768 "book.c"
}


void book_unref (gpointer instance) {
	Book* self;
	self = instance;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		BOOK_GET_CLASS (self)->finalize (self);
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 4781 "book.c"
	}
}


static gpointer _g_object_ref0 (gpointer self) {
#line 580 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return self ? g_object_ref (self) : NULL;
#line 4789 "book.c"
}


PDFWriter* pdf_writer_construct (GType object_type, GFileOutputStream* stream) {
	PDFWriter* self = NULL;
	GFileOutputStream* _tmp0_ = NULL;
	GFileOutputStream* _tmp1_ = NULL;
#line 578 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_val_if_fail (stream != NULL, NULL);
#line 578 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self = (PDFWriter*) g_type_create_instance (object_type);
#line 580 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0_ = stream;
#line 580 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 580 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_object_unref0 (self->priv->stream);
#line 580 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->priv->stream = _tmp1_;
#line 578 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return self;
#line 4811 "book.c"
}


PDFWriter* pdf_writer_new (GFileOutputStream* stream) {
#line 578 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return pdf_writer_construct (TYPE_PDF_WRITER, stream);
#line 4818 "book.c"
}


void pdf_writer_write (PDFWriter* self, guint8* data, int data_length1) {
	gsize _tmp4_ = 0UL;
	guint8* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	GError * _inner_error_ = NULL;
#line 583 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (self != NULL);
#line 4829 "book.c"
	{
		GFileOutputStream* _tmp0_ = NULL;
		guint8* _tmp1_ = NULL;
		gint _tmp1__length1 = 0;
#line 587 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp0_ = self->priv->stream;
#line 587 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp1_ = data;
#line 587 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp1__length1 = data_length1;
#line 587 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_output_stream_write_all ((GOutputStream*) _tmp0_, _tmp1_, (gsize) _tmp1__length1, NULL, NULL, &_inner_error_);
#line 587 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4844 "book.c"
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
#line 585 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		e = _inner_error_;
#line 585 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_inner_error_ = NULL;
#line 591 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp2_ = e;
#line 591 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp3_ = _tmp2_->message;
#line 591 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_warning ("book.vala:591: Error writing PDF: %s", _tmp3_);
#line 585 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_g_error_free0 (e);
#line 4866 "book.c"
	}
	__finally1:
#line 585 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 585 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 585 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_clear_error (&_inner_error_);
#line 585 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		return;
#line 4877 "book.c"
	}
#line 593 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp4_ = self->offset;
#line 593 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp5_ = data;
#line 593 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp5__length1 = data_length1;
#line 593 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->offset = _tmp4_ + _tmp5__length1;
#line 4887 "book.c"
}


static gchar* string_to_utf8 (const gchar* self, int* result_length1) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gchar* _tmp2_ = NULL;
	gint _result__length1 = 0;
	gint __result__size_ = 0;
	gint _tmp3_ = 0;
	gchar* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gchar* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
#line 1307 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1308 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1308 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1308 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp2_ = g_new0 (gchar, _tmp1_ + 1);
#line 1308 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 1308 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	_result__length1 = _tmp1_ + 1;
#line 1308 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	__result__size_ = _result__length1;
#line 1309 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp3_ = _result__length1;
#line 1309 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	_result__length1 = _tmp3_ - 1;
#line 1310 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp4_ = _result_;
#line 1310 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp4__length1 = _result__length1;
#line 1310 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp5_ = strlen (self);
#line 1310 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp6_ = _tmp5_;
#line 1310 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	memcpy (_tmp4_, self, (gsize) _tmp6_);
#line 1311 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp7_ = _result_;
#line 1311 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp7__length1 = _result__length1;
#line 1311 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	if (result_length1) {
#line 1311 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		*result_length1 = _tmp7__length1;
#line 4942 "book.c"
	}
#line 1311 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	result = _tmp7_;
#line 1311 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	return result;
#line 4948 "book.c"
}


void pdf_writer_write_string (PDFWriter* self, const gchar* text) {
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gchar* _tmp2_ = NULL;
	guint8* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
#line 596 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (self != NULL);
#line 596 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (text != NULL);
#line 598 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0_ = text;
#line 598 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp2_ = string_to_utf8 (_tmp0_, &_tmp1_);
#line 598 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp3_ = (guint8*) _tmp2_;
#line 598 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp3__length1 = (_tmp1_ * sizeof (gchar)) / sizeof (guint8);
#line 598 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write (self, _tmp3_, (_tmp1_ * sizeof (gchar)) / sizeof (guint8));
#line 598 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp3_ = (g_free (_tmp3_), NULL);
#line 4974 "book.c"
}


guint pdf_writer_start_object (PDFWriter* self) {
	guint result = 0U;
	gsize _tmp0_ = 0UL;
	GList* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
#line 601 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 603 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0_ = self->offset;
#line 603 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->object_offsets = g_list_append (self->object_offsets, (gpointer) ((guintptr) ((guint) _tmp0_)));
#line 604 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp1_ = self->object_offsets;
#line 604 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp2_ = g_list_length (_tmp1_);
#line 604 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	result = _tmp2_;
#line 604 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return result;
#line 4997 "book.c"
}


static void value_pdf_writer_init (GValue* value) {
#line 572 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	value->data[0].v_pointer = NULL;
#line 5004 "book.c"
}


static void value_pdf_writer_free_value (GValue* value) {
#line 572 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (value->data[0].v_pointer) {
#line 572 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		pdf_writer_unref (value->data[0].v_pointer);
#line 5013 "book.c"
	}
}


static void value_pdf_writer_copy_value (const GValue* src_value, GValue* dest_value) {
#line 572 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (src_value->data[0].v_pointer) {
#line 572 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		dest_value->data[0].v_pointer = pdf_writer_ref (src_value->data[0].v_pointer);
#line 5023 "book.c"
	} else {
#line 572 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		dest_value->data[0].v_pointer = NULL;
#line 5027 "book.c"
	}
}


static gpointer value_pdf_writer_peek_pointer (const GValue* value) {
#line 572 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return value->data[0].v_pointer;
#line 5035 "book.c"
}


static gchar* value_pdf_writer_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 572 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (collect_values[0].v_pointer) {
#line 5042 "book.c"
		PDFWriter* object;
		object = collect_values[0].v_pointer;
#line 572 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		if (object->parent_instance.g_class == NULL) {
#line 572 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 5049 "book.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 572 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 5053 "book.c"
		}
#line 572 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		value->data[0].v_pointer = pdf_writer_ref (object);
#line 5057 "book.c"
	} else {
#line 572 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		value->data[0].v_pointer = NULL;
#line 5061 "book.c"
	}
#line 572 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return NULL;
#line 5065 "book.c"
}


static gchar* value_pdf_writer_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	PDFWriter** object_p;
	object_p = collect_values[0].v_pointer;
#line 572 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (!object_p) {
#line 572 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 5076 "book.c"
	}
#line 572 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (!value->data[0].v_pointer) {
#line 572 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		*object_p = NULL;
#line 5082 "book.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 572 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		*object_p = value->data[0].v_pointer;
#line 5086 "book.c"
	} else {
#line 572 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		*object_p = pdf_writer_ref (value->data[0].v_pointer);
#line 5090 "book.c"
	}
#line 572 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return NULL;
#line 5094 "book.c"
}


GParamSpec* param_spec_pdf_writer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecPDFWriter* spec;
#line 572 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PDF_WRITER), NULL);
#line 572 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 572 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 572 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return G_PARAM_SPEC (spec);
#line 5108 "book.c"
}


gpointer value_get_pdf_writer (const GValue* value) {
#line 572 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PDF_WRITER), NULL);
#line 572 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return value->data[0].v_pointer;
#line 5117 "book.c"
}


void value_set_pdf_writer (GValue* value, gpointer v_object) {
	PDFWriter* old;
#line 572 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PDF_WRITER));
#line 572 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	old = value->data[0].v_pointer;
#line 572 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (v_object) {
#line 572 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PDF_WRITER));
#line 572 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 572 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		value->data[0].v_pointer = v_object;
#line 572 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		pdf_writer_ref (value->data[0].v_pointer);
#line 5137 "book.c"
	} else {
#line 572 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		value->data[0].v_pointer = NULL;
#line 5141 "book.c"
	}
#line 572 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (old) {
#line 572 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		pdf_writer_unref (old);
#line 5147 "book.c"
	}
}


void value_take_pdf_writer (GValue* value, gpointer v_object) {
	PDFWriter* old;
#line 572 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PDF_WRITER));
#line 572 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	old = value->data[0].v_pointer;
#line 572 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (v_object) {
#line 572 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PDF_WRITER));
#line 572 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 572 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		value->data[0].v_pointer = v_object;
#line 5166 "book.c"
	} else {
#line 572 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		value->data[0].v_pointer = NULL;
#line 5170 "book.c"
	}
#line 572 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (old) {
#line 572 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		pdf_writer_unref (old);
#line 5176 "book.c"
	}
}


static void pdf_writer_class_init (PDFWriterClass * klass) {
#line 572 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_parent_class = g_type_class_peek_parent (klass);
#line 572 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	((PDFWriterClass *) klass)->finalize = pdf_writer_finalize;
#line 572 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_type_class_add_private (klass, sizeof (PDFWriterPrivate));
#line 5188 "book.c"
}


static void pdf_writer_instance_init (PDFWriter * self) {
#line 572 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->priv = PDF_WRITER_GET_PRIVATE (self);
#line 574 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->offset = (gsize) 0;
#line 572 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->ref_count = 1;
#line 5199 "book.c"
}


static void pdf_writer_finalize (PDFWriter* obj) {
	PDFWriter * self;
#line 572 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PDF_WRITER, PDFWriter);
#line 572 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_signal_handlers_destroy (self);
#line 575 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_list_free0 (self->object_offsets);
#line 576 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_object_unref0 (self->priv->stream);
#line 5213 "book.c"
}


GType pdf_writer_get_type (void) {
	static volatile gsize pdf_writer_type_id__volatile = 0;
	if (g_once_init_enter (&pdf_writer_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_pdf_writer_init, value_pdf_writer_free_value, value_pdf_writer_copy_value, value_pdf_writer_peek_pointer, "p", value_pdf_writer_collect_value, "p", value_pdf_writer_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PDFWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pdf_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PDFWriter), 0, (GInstanceInitFunc) pdf_writer_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType pdf_writer_type_id;
		pdf_writer_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PDFWriter", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&pdf_writer_type_id__volatile, pdf_writer_type_id);
	}
	return pdf_writer_type_id__volatile;
}


gpointer pdf_writer_ref (gpointer instance) {
	PDFWriter* self;
	self = instance;
#line 572 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_atomic_int_inc (&self->ref_count);
#line 572 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return instance;
#line 5238 "book.c"
}


void pdf_writer_unref (gpointer instance) {
	PDFWriter* self;
	self = instance;
#line 572 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 572 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		PDF_WRITER_GET_CLASS (self)->finalize (self);
#line 572 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 5251 "book.c"
	}
}


static cairo_status_t _ps_writer_write_cairo_data_cairo_write_func_t (gpointer self, guchar* data, int data_length1) {
	cairo_status_t result;
	result = ps_writer_write_cairo_data ((PsWriter*) self, data, data_length1);
#line 616 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return result;
#line 5261 "book.c"
}


PsWriter* ps_writer_construct (GType object_type, GFileOutputStream* stream) {
	PsWriter* self = NULL;
	GFileOutputStream* _tmp0_ = NULL;
	GFileOutputStream* _tmp1_ = NULL;
	cairo_surface_t* _tmp2_ = NULL;
#line 613 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_val_if_fail (stream != NULL, NULL);
#line 613 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self = (PsWriter*) g_type_create_instance (object_type);
#line 615 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0_ = stream;
#line 615 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 615 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_object_unref0 (self->stream);
#line 615 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->stream = _tmp1_;
#line 616 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp2_ = cairo_ps_surface_create_for_stream (_ps_writer_write_cairo_data_cairo_write_func_t, self, (gdouble) 0, (gdouble) 0);
#line 616 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_cairo_surface_destroy0 (self->surface);
#line 616 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->surface = _tmp2_;
#line 613 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return self;
#line 5290 "book.c"
}


PsWriter* ps_writer_new (GFileOutputStream* stream) {
#line 613 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return ps_writer_construct (TYPE_PS_WRITER, stream);
#line 5297 "book.c"
}


static cairo_status_t ps_writer_write_cairo_data (PsWriter* self, guint8* data, int data_length1) {
	cairo_status_t result = 0;
	GError * _inner_error_ = NULL;
#line 619 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 5306 "book.c"
	{
		GFileOutputStream* _tmp0_ = NULL;
		guint8* _tmp1_ = NULL;
		gint _tmp1__length1 = 0;
#line 623 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp0_ = self->stream;
#line 623 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp1_ = data;
#line 623 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp1__length1 = data_length1;
#line 623 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_output_stream_write_all ((GOutputStream*) _tmp0_, _tmp1_, (gsize) _tmp1__length1, NULL, NULL, &_inner_error_);
#line 623 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 5321 "book.c"
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
#line 621 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		e = _inner_error_;
#line 621 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_inner_error_ = NULL;
#line 627 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp2_ = e;
#line 627 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp3_ = _tmp2_->message;
#line 627 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_warning ("book.vala:627: Error writing data: %s", _tmp3_);
#line 628 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		result = CAIRO_STATUS_WRITE_ERROR;
#line 628 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_g_error_free0 (e);
#line 628 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		return result;
#line 5347 "book.c"
	}
	__finally2:
#line 621 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 621 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 621 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_clear_error (&_inner_error_);
#line 621 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		return 0;
#line 5358 "book.c"
	}
#line 631 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	result = CAIRO_STATUS_SUCCESS;
#line 631 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return result;
#line 5364 "book.c"
}


static void value_ps_writer_init (GValue* value) {
#line 608 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	value->data[0].v_pointer = NULL;
#line 5371 "book.c"
}


static void value_ps_writer_free_value (GValue* value) {
#line 608 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (value->data[0].v_pointer) {
#line 608 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		ps_writer_unref (value->data[0].v_pointer);
#line 5380 "book.c"
	}
}


static void value_ps_writer_copy_value (const GValue* src_value, GValue* dest_value) {
#line 608 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (src_value->data[0].v_pointer) {
#line 608 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		dest_value->data[0].v_pointer = ps_writer_ref (src_value->data[0].v_pointer);
#line 5390 "book.c"
	} else {
#line 608 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		dest_value->data[0].v_pointer = NULL;
#line 5394 "book.c"
	}
}


static gpointer value_ps_writer_peek_pointer (const GValue* value) {
#line 608 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return value->data[0].v_pointer;
#line 5402 "book.c"
}


static gchar* value_ps_writer_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 608 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (collect_values[0].v_pointer) {
#line 5409 "book.c"
		PsWriter* object;
		object = collect_values[0].v_pointer;
#line 608 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		if (object->parent_instance.g_class == NULL) {
#line 608 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 5416 "book.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 608 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 5420 "book.c"
		}
#line 608 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		value->data[0].v_pointer = ps_writer_ref (object);
#line 5424 "book.c"
	} else {
#line 608 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		value->data[0].v_pointer = NULL;
#line 5428 "book.c"
	}
#line 608 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return NULL;
#line 5432 "book.c"
}


static gchar* value_ps_writer_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	PsWriter** object_p;
	object_p = collect_values[0].v_pointer;
#line 608 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (!object_p) {
#line 608 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 5443 "book.c"
	}
#line 608 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (!value->data[0].v_pointer) {
#line 608 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		*object_p = NULL;
#line 5449 "book.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 608 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		*object_p = value->data[0].v_pointer;
#line 5453 "book.c"
	} else {
#line 608 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		*object_p = ps_writer_ref (value->data[0].v_pointer);
#line 5457 "book.c"
	}
#line 608 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return NULL;
#line 5461 "book.c"
}


GParamSpec* param_spec_ps_writer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecPsWriter* spec;
#line 608 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PS_WRITER), NULL);
#line 608 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 608 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 608 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return G_PARAM_SPEC (spec);
#line 5475 "book.c"
}


gpointer value_get_ps_writer (const GValue* value) {
#line 608 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PS_WRITER), NULL);
#line 608 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return value->data[0].v_pointer;
#line 5484 "book.c"
}


void value_set_ps_writer (GValue* value, gpointer v_object) {
	PsWriter* old;
#line 608 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PS_WRITER));
#line 608 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	old = value->data[0].v_pointer;
#line 608 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (v_object) {
#line 608 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PS_WRITER));
#line 608 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 608 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		value->data[0].v_pointer = v_object;
#line 608 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		ps_writer_ref (value->data[0].v_pointer);
#line 5504 "book.c"
	} else {
#line 608 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		value->data[0].v_pointer = NULL;
#line 5508 "book.c"
	}
#line 608 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (old) {
#line 608 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		ps_writer_unref (old);
#line 5514 "book.c"
	}
}


void value_take_ps_writer (GValue* value, gpointer v_object) {
	PsWriter* old;
#line 608 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PS_WRITER));
#line 608 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	old = value->data[0].v_pointer;
#line 608 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (v_object) {
#line 608 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PS_WRITER));
#line 608 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 608 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		value->data[0].v_pointer = v_object;
#line 5533 "book.c"
	} else {
#line 608 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		value->data[0].v_pointer = NULL;
#line 5537 "book.c"
	}
#line 608 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (old) {
#line 608 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		ps_writer_unref (old);
#line 5543 "book.c"
	}
}


static void ps_writer_class_init (PsWriterClass * klass) {
#line 608 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	ps_writer_parent_class = g_type_class_peek_parent (klass);
#line 608 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	((PsWriterClass *) klass)->finalize = ps_writer_finalize;
#line 5553 "book.c"
}


static void ps_writer_instance_init (PsWriter * self) {
#line 608 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->ref_count = 1;
#line 5560 "book.c"
}


static void ps_writer_finalize (PsWriter* obj) {
	PsWriter * self;
#line 608 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PS_WRITER, PsWriter);
#line 608 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_signal_handlers_destroy (self);
#line 610 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_cairo_surface_destroy0 (self->surface);
#line 611 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_object_unref0 (self->stream);
#line 5574 "book.c"
}


GType ps_writer_get_type (void) {
	static volatile gsize ps_writer_type_id__volatile = 0;
	if (g_once_init_enter (&ps_writer_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_ps_writer_init, value_ps_writer_free_value, value_ps_writer_copy_value, value_ps_writer_peek_pointer, "p", value_ps_writer_collect_value, "p", value_ps_writer_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PsWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ps_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PsWriter), 0, (GInstanceInitFunc) ps_writer_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType ps_writer_type_id;
		ps_writer_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PsWriter", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&ps_writer_type_id__volatile, ps_writer_type_id);
	}
	return ps_writer_type_id__volatile;
}


gpointer ps_writer_ref (gpointer instance) {
	PsWriter* self;
	self = instance;
#line 608 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_atomic_int_inc (&self->ref_count);
#line 608 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return instance;
#line 5599 "book.c"
}


void ps_writer_unref (gpointer instance) {
	PsWriter* self;
	self = instance;
#line 608 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 608 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		PS_WRITER_GET_CLASS (self)->finalize (self);
#line 608 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 5612 "book.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



