""" Tray.py

Module that puts Straw in the tray notification area.
"""
__copyright__ = "Copyright (c) 2004-2005 Free Software Foundation, Inc."
__author__ = "Olivier Crete <tester@tester.ca>"
__license__ = """ GNU General Public License

This program is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation; either version 2 of the License, or (at your option) any later
version.

This program is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with
this program; if not, write to the Free Software Foundation, Inc., 59 Temple
Place - Suite 330, Boston, MA 02111-1307, USA. """


import os
import os.path
from xml.sax import saxutils
import pygtk
pygtk.require('2.0')
import gtk
import FeedList
import Event
import utils
import constants
import subscribe
import egg
import egg.trayicon

class Tray:
    def __init__(self, ):
        self.tray = egg.trayicon.TrayIcon(constants.APPNAME);
        self._eventbox = gtk.EventBox()
        self.tray.add(self._eventbox)
        self.connect("drag-data-received", self._on_drag_data_received)
        self._eventbox.drag_dest_set(
            gtk.DEST_DEFAULT_ALL,
            [('_NETSCAPE_URL', 0, 0),('text/uri-list ', 0, 1),('x-url/http', 0, 2)],
            gtk.gdk.ACTION_COPY | gtk.gdk.ACTION_MOVE)
        image = gtk.Image()
        iconfile = os.path.normpath(utils.find_image_dir() + "/straw.png")
        pixbuf = gtk.gdk.pixbuf_new_from_file(iconfile)
        scaled_buf = pixbuf.scale_simple(16,16,gtk.gdk.INTERP_BILINEAR)
        image.set_from_pixbuf(scaled_buf)
        self._eventbox.add(image)

        self._tooltip = gtk.Tooltips()
        self.unread_count = 0
        feedlist = FeedList.get_instance()
        feedlist.signal_connect(Event.AllItemsReadSignal,
                                lambda signal: self._update(feedlist))
        feedlist.signal_connect(Event.ItemReadSignal,
                                      lambda signal: self._update(feedlist))
        feedlist.signal_connect(Event.ItemsAddedSignal,
                                      lambda signal: self._update(feedlist))
        feedlist.signal_connect(Event.FeedsChangedSignal,
                                      lambda signal: self._update(feedlist))
        self.tray.show_all()

    def _update(self,flist):
        uritems = urfeeds = 0
        for ur in [f.number_of_unread for f in flist.flatten_list()]:
            if ur:
                uritems += ur
                urfeeds += 1
        if uritems == self.unread_count:
            return
        self.unread_count = uritems
        if uritems:
            self._tooltip.set_tip(self.tray, _("%d new items")%uritems)
            self.tray.show_all()
        else:
            self.tray.hide()
        return

    def connect(self, event, handler):
        self._eventbox.connect(event, handler)
        return

    def _on_drag_data_received(self, widget, context, x, y, data, info, timestamp):
        if data and data.format == 8:
            url = data.data.split("\n")[0]
            subscribe.show(url="%s" % url)
            context.finish(True, False, timestamp)
        else:
            context.finish(False, False, timestamp)
        return
