/* tracker-backend.c generated by valac 0.12.0, the Vala compiler
 * generated from tracker-backend.vala, do not modify */

/*
 * Copyright (C) 2010, Nokia <ivan.frade@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <string.h>
#include <libtracker-sparql/tracker-sparql.h>
#include <stdlib.h>
#include <libtracker-direct/tracker-direct.h>
#include <libtracker-bus/tracker-bus.h>


#define TRACKER_BACKEND_TYPE_STATUS (tracker_backend_status_get_type ())
#define TRACKER_BACKEND_STATUS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_BACKEND_TYPE_STATUS, TrackerBackendStatus))
#define TRACKER_BACKEND_IS_STATUS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_BACKEND_TYPE_STATUS))
#define TRACKER_BACKEND_STATUS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TRACKER_BACKEND_TYPE_STATUS, TrackerBackendStatusIface))

typedef struct _TrackerBackendStatus TrackerBackendStatus;
typedef struct _TrackerBackendStatusIface TrackerBackendStatusIface;

#define TRACKER_BACKEND_TYPE_STATUS_PROXY (tracker_backend_status_proxy_get_type ())
typedef GDBusProxy TrackerBackendStatusProxy;
typedef GDBusProxyClass TrackerBackendStatusProxyClass;

#define TRACKER_SPARQL_TYPE_BACKEND (tracker_sparql_backend_get_type ())
#define TRACKER_SPARQL_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_BACKEND, TrackerSparqlBackend))
#define TRACKER_SPARQL_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_BACKEND, TrackerSparqlBackendClass))
#define TRACKER_SPARQL_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_BACKEND))
#define TRACKER_SPARQL_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_BACKEND))
#define TRACKER_SPARQL_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_BACKEND, TrackerSparqlBackendClass))

typedef struct _TrackerSparqlBackend TrackerSparqlBackend;
typedef struct _TrackerSparqlBackendClass TrackerSparqlBackendClass;
typedef struct _TrackerSparqlBackendPrivate TrackerSparqlBackendPrivate;

#define TRACKER_SPARQL_BACKEND_TYPE_BACKEND (tracker_sparql_backend_backend_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _TrackerSparqlBackendQueryAsyncData TrackerSparqlBackendQueryAsyncData;
typedef struct _TrackerSparqlBackendUpdateAsyncData TrackerSparqlBackendUpdateAsyncData;
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _TrackerSparqlBackendUpdateArrayAsyncData TrackerSparqlBackendUpdateArrayAsyncData;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _TrackerSparqlBackendUpdateBlankAsyncData TrackerSparqlBackendUpdateBlankAsyncData;
typedef struct _TrackerSparqlBackendLoadAsyncData TrackerSparqlBackendLoadAsyncData;
typedef struct _TrackerSparqlBackendStatisticsAsyncData TrackerSparqlBackendStatisticsAsyncData;
typedef struct _Block1Data Block1Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_main_context_unref0(var) ((var == NULL) ? NULL : (var = (g_main_context_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
#define _g_source_unref0(var) ((var == NULL) ? NULL : (var = (g_source_unref (var), NULL)))
typedef struct _TrackerSparqlBackendGetInternalAsyncData TrackerSparqlBackendGetInternalAsyncData;
typedef struct _TrackerSparqlConnectionGetAsyncData TrackerSparqlConnectionGetAsyncData;
typedef struct _TrackerSparqlConnectionGetDirectAsyncData TrackerSparqlConnectionGetDirectAsyncData;

struct _TrackerBackendStatusIface {
	GTypeInterface parent_iface;
	void (*wait) (TrackerBackendStatus* self, GError** error);
};

struct _TrackerSparqlBackend {
	TrackerSparqlConnection parent_instance;
	TrackerSparqlBackendPrivate * priv;
};

struct _TrackerSparqlBackendClass {
	TrackerSparqlConnectionClass parent_class;
};

struct _TrackerSparqlBackendPrivate {
	TrackerSparqlConnection* direct;
	TrackerSparqlConnection* bus;
};

typedef enum  {
	TRACKER_SPARQL_BACKEND_BACKEND_AUTO,
	TRACKER_SPARQL_BACKEND_BACKEND_DIRECT,
	TRACKER_SPARQL_BACKEND_BACKEND_BUS
} TrackerSparqlBackendBackend;

struct _TrackerSparqlBackendQueryAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerSparqlBackend* self;
	gchar* sparql;
	GCancellable* cancellable;
	TrackerSparqlCursor* result;
	TrackerSparqlCursor* _tmp0_;
	TrackerSparqlCursor* _tmp1_;
	TrackerSparqlCursor* _tmp2_;
	TrackerSparqlCursor* _tmp3_;
	GError * _inner_error_;
};

struct _TrackerSparqlBackendUpdateAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerSparqlBackend* self;
	gchar* sparql;
	gint priority;
	GCancellable* cancellable;
	GError * _inner_error_;
};

struct _TrackerSparqlBackendUpdateArrayAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerSparqlBackend* self;
	gchar** sparql;
	gint sparql_length1;
	gint priority;
	GCancellable* cancellable;
	GPtrArray* result;
	GPtrArray* _tmp0_;
	GPtrArray* _tmp1_;
	GError * _inner_error_;
};

struct _TrackerSparqlBackendUpdateBlankAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerSparqlBackend* self;
	gchar* sparql;
	gint priority;
	GCancellable* cancellable;
	GVariant* result;
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	GError * _inner_error_;
};

struct _TrackerSparqlBackendLoadAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerSparqlBackend* self;
	GFile* file;
	GCancellable* cancellable;
	gchar* _tmp0_;
	gchar* uri;
	GError * _inner_error_;
};

struct _TrackerSparqlBackendStatisticsAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerSparqlBackend* self;
	GCancellable* cancellable;
	TrackerSparqlCursor* result;
	TrackerSparqlCursor* _tmp0_;
	TrackerSparqlCursor* _tmp1_;
	GError * _inner_error_;
};

struct _Block1Data {
	int _ref_count_;
	GMainLoop* loop;
	GAsyncResult* async_result;
};

struct _Block2Data {
	int _ref_count_;
	GError* sparql_error;
	GError* io_error;
	GError* dbus_error;
	GError* spawn_error;
	TrackerSparqlConnection* _result_;
	GMainContext* context;
	gboolean is_direct_only;
	GCancellable* cancellable;
	gpointer _async_data_;
};

struct _TrackerSparqlBackendGetInternalAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	gboolean is_direct_only;
	GCancellable* cancellable;
	TrackerSparqlConnection* result;
	Block2Data* _data2_;
	gboolean _tmp0_;
	TrackerSparqlConnection* _tmp1_;
	TrackerSparqlConnection* _result_;
	GMainContext* _tmp2_;
	GMainContext* _tmp3_;
	GError* _tmp4_;
	GError* _tmp5_;
	GError* _tmp6_;
	GError* _tmp7_;
	TrackerSparqlConnection* _tmp8_;
	GError * _inner_error_;
};

struct _TrackerSparqlConnectionGetAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GCancellable* cancellable;
	TrackerSparqlConnection* result;
	TrackerSparqlConnection* _tmp0_;
	TrackerSparqlConnection* _tmp1_;
	GError * _inner_error_;
};

struct _TrackerSparqlConnectionGetDirectAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GCancellable* cancellable;
	TrackerSparqlConnection* result;
	TrackerSparqlConnection* _tmp0_;
	TrackerSparqlConnection* _tmp1_;
	GError * _inner_error_;
};


static gpointer tracker_sparql_backend_parent_class = NULL;
static gboolean tracker_sparql_backend_direct_only;
static gboolean tracker_sparql_backend_direct_only = FALSE;
static TrackerSparqlConnection* tracker_sparql_backend_singleton;
static TrackerSparqlConnection* tracker_sparql_backend_singleton = NULL;
static gboolean tracker_sparql_backend_log_initialized;
static gboolean tracker_sparql_backend_log_initialized = FALSE;
static GStaticMutex tracker_sparql_backend_door;
static GStaticMutex tracker_sparql_backend_door = {0};

GType tracker_backend_status_proxy_get_type (void) G_GNUC_CONST;
guint tracker_backend_status_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType tracker_backend_status_get_type (void) G_GNUC_CONST;
void tracker_backend_status_wait (TrackerBackendStatus* self, GError** error);
static void tracker_backend_status_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void tracker_backend_status_proxy_wait (TrackerBackendStatus* self, GError** error);
static void tracker_backend_status_proxy_tracker_backend_status_interface_init (TrackerBackendStatusIface* iface);
static void _dbus_tracker_backend_status_wait (TrackerBackendStatus* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void tracker_backend_status_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* tracker_backend_status_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean tracker_backend_status_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _tracker_backend_status_unregister_object (gpointer user_data);
GType tracker_sparql_backend_get_type (void) G_GNUC_CONST;
#define TRACKER_SPARQL_BACKEND_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_SPARQL_TYPE_BACKEND, TrackerSparqlBackendPrivate))
enum  {
	TRACKER_SPARQL_BACKEND_DUMMY_PROPERTY
};
static GType tracker_sparql_backend_backend_get_type (void) G_GNUC_UNUSED;
TrackerSparqlBackend* tracker_sparql_backend_new (GError** error);
TrackerSparqlBackend* tracker_sparql_backend_construct (GType object_type, GError** error);
static gboolean tracker_sparql_backend_load_plugins (TrackerSparqlBackend* self, gboolean direct_only, GError** error);
static TrackerSparqlCursor* tracker_sparql_backend_real_query (TrackerSparqlConnection* base, const gchar* sparql, GCancellable* cancellable, GError** error);
static void tracker_sparql_backend_real_query_async_data_free (gpointer _data);
static void tracker_sparql_backend_real_query_async (TrackerSparqlConnection* base, const gchar* sparql, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tracker_sparql_backend_real_query_async_co (TrackerSparqlBackendQueryAsyncData* data);
static void tracker_sparql_backend_query_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tracker_sparql_backend_real_update (TrackerSparqlConnection* base, const gchar* sparql, gint priority, GCancellable* cancellable, GError** error);
static GVariant* tracker_sparql_backend_real_update_blank (TrackerSparqlConnection* base, const gchar* sparql, gint priority, GCancellable* cancellable, GError** error);
static void tracker_sparql_backend_real_update_async_data_free (gpointer _data);
static void tracker_sparql_backend_real_update_async (TrackerSparqlConnection* base, const gchar* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tracker_sparql_backend_real_update_async_co (TrackerSparqlBackendUpdateAsyncData* data);
static void tracker_sparql_backend_update_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tracker_sparql_backend_real_update_array_async_data_free (gpointer _data);
static void tracker_sparql_backend_real_update_array_async (TrackerSparqlConnection* base, gchar** sparql, int sparql_length1, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gchar** _vala_array_dup1 (gchar** self, int length);
static gboolean tracker_sparql_backend_real_update_array_async_co (TrackerSparqlBackendUpdateArrayAsyncData* data);
static void tracker_sparql_backend_update_array_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tracker_sparql_backend_real_update_blank_async_data_free (gpointer _data);
static void tracker_sparql_backend_real_update_blank_async (TrackerSparqlConnection* base, const gchar* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tracker_sparql_backend_real_update_blank_async_co (TrackerSparqlBackendUpdateBlankAsyncData* data);
static void tracker_sparql_backend_update_blank_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tracker_sparql_backend_real_load (TrackerSparqlConnection* base, GFile* file, GCancellable* cancellable, GError** error);
static void tracker_sparql_backend_real_load_async_data_free (gpointer _data);
static void tracker_sparql_backend_real_load_async (TrackerSparqlConnection* base, GFile* file, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tracker_sparql_backend_real_load_async_co (TrackerSparqlBackendLoadAsyncData* data);
static void tracker_sparql_backend_load_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static TrackerSparqlCursor* tracker_sparql_backend_real_statistics (TrackerSparqlConnection* base, GCancellable* cancellable, GError** error);
static void tracker_sparql_backend_real_statistics_async_data_free (gpointer _data);
static void tracker_sparql_backend_real_statistics_async (TrackerSparqlConnection* base, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tracker_sparql_backend_real_statistics_async_co (TrackerSparqlBackendStatisticsAsyncData* data);
static void tracker_sparql_backend_statistics_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static TrackerSparqlConnection* tracker_sparql_backend_get (gboolean is_direct_only, GCancellable* cancellable, GError** error);
static void tracker_sparql_backend_log_init (void);
TrackerSparqlConnection* tracker_sparql_backend_get_internal (gboolean is_direct_only, GCancellable* cancellable, GError** error);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
void tracker_sparql_backend_get_internal_async (gboolean is_direct_only, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
TrackerSparqlConnection* tracker_sparql_backend_get_internal_finish (GAsyncResult* _res_, GError** error);
static void _lambda2_ (GObject* obj, GAsyncResult* res, Block1Data* _data1_);
static void __lambda2__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void tracker_sparql_backend_get_internal_async_data_free (gpointer _data);
static gboolean tracker_sparql_backend_get_internal_async_co (TrackerSparqlBackendGetInternalAsyncData* data);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
static gboolean _lambda0_ (GIOSchedulerJob* job, Block2Data* _data2_);
static gboolean _lambda1_ (Block2Data* _data2_);
static gboolean __lambda1__gsource_func (gpointer self);
static gboolean __lambda0__gio_scheduler_job_func (GIOSchedulerJob* job, GCancellable* cancellable, gpointer self);
static void tracker_sparql_backend_remove_log_handler (const gchar* log_domain, GLogLevelFlags log_level, const gchar* message);
static void _tracker_sparql_backend_remove_log_handler_glog_func (const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message, gpointer self);
static void tracker_sparql_backend_finalize (GObject* obj);
static void tracker_sparql_connection_get_async_data_free (gpointer _data);
void tracker_sparql_connection_get_async (GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
TrackerSparqlConnection* tracker_sparql_connection_get_finish (GAsyncResult* _res_, GError** error);
static gboolean tracker_sparql_connection_get_async_co (TrackerSparqlConnectionGetAsyncData* data);
static void tracker_sparql_connection_get_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
TrackerSparqlConnection* tracker_sparql_connection_get (GCancellable* cancellable, GError** error);
static void tracker_sparql_connection_get_direct_async_data_free (gpointer _data);
void tracker_sparql_connection_get_direct_async (GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
TrackerSparqlConnection* tracker_sparql_connection_get_direct_finish (GAsyncResult* _res_, GError** error);
static gboolean tracker_sparql_connection_get_direct_async_co (TrackerSparqlConnectionGetDirectAsyncData* data);
static void tracker_sparql_connection_get_direct_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
TrackerSparqlConnection* tracker_sparql_connection_get_direct (GCancellable* cancellable, GError** error);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GDBusArgInfo * const _tracker_backend_status_dbus_arg_info_wait_in[] = {NULL};
static const GDBusArgInfo * const _tracker_backend_status_dbus_arg_info_wait_out[] = {NULL};
static const GDBusMethodInfo _tracker_backend_status_dbus_method_info_wait = {-1, "Wait", (GDBusArgInfo **) (&_tracker_backend_status_dbus_arg_info_wait_in), (GDBusArgInfo **) (&_tracker_backend_status_dbus_arg_info_wait_out)};
static const GDBusMethodInfo * const _tracker_backend_status_dbus_method_info[] = {&_tracker_backend_status_dbus_method_info_wait, NULL};
static const GDBusSignalInfo * const _tracker_backend_status_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _tracker_backend_status_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _tracker_backend_status_dbus_interface_info = {-1, "org.freedesktop.Tracker1.Status", (GDBusMethodInfo **) (&_tracker_backend_status_dbus_method_info), (GDBusSignalInfo **) (&_tracker_backend_status_dbus_signal_info), (GDBusPropertyInfo **) (&_tracker_backend_status_dbus_property_info)};
static const GDBusInterfaceVTable _tracker_backend_status_dbus_interface_vtable = {tracker_backend_status_dbus_interface_method_call, tracker_backend_status_dbus_interface_get_property, tracker_backend_status_dbus_interface_set_property};

void tracker_backend_status_wait (TrackerBackendStatus* self, GError** error) {
	TRACKER_BACKEND_STATUS_GET_INTERFACE (self)->wait (self, error);
}


static void tracker_backend_status_base_init (TrackerBackendStatusIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


GType tracker_backend_status_get_type (void) {
	static volatile gsize tracker_backend_status_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_backend_status_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerBackendStatusIface), (GBaseInitFunc) tracker_backend_status_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType tracker_backend_status_type_id;
		tracker_backend_status_type_id = g_type_register_static (G_TYPE_INTERFACE, "TrackerBackendStatus", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (tracker_backend_status_type_id, G_TYPE_DBUS_PROXY);
		g_type_set_qdata (tracker_backend_status_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) tracker_backend_status_proxy_get_type);
		g_type_set_qdata (tracker_backend_status_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.Tracker1.Status");
		g_type_set_qdata (tracker_backend_status_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) tracker_backend_status_register_object);
		g_once_init_leave (&tracker_backend_status_type_id__volatile, tracker_backend_status_type_id);
	}
	return tracker_backend_status_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (TrackerBackendStatusProxy, tracker_backend_status_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (TRACKER_BACKEND_TYPE_STATUS, tracker_backend_status_proxy_tracker_backend_status_interface_init) )
static void tracker_backend_status_proxy_class_init (TrackerBackendStatusProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = tracker_backend_status_proxy_g_signal;
}


static void tracker_backend_status_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
}


static void tracker_backend_status_proxy_init (TrackerBackendStatusProxy* self) {
}


static void tracker_backend_status_proxy_wait (TrackerBackendStatus* self, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.Tracker1.Status", "Wait");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void tracker_backend_status_proxy_tracker_backend_status_interface_init (TrackerBackendStatusIface* iface) {
	iface->wait = tracker_backend_status_proxy_wait;
}


static void _dbus_tracker_backend_status_wait (TrackerBackendStatus* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, parameters);
	tracker_backend_status_wait (self, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void tracker_backend_status_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Wait") == 0) {
		_dbus_tracker_backend_status_wait (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* tracker_backend_status_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean tracker_backend_status_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


guint tracker_backend_status_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_tracker_backend_status_dbus_interface_info), &_tracker_backend_status_dbus_interface_vtable, data, _tracker_backend_status_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}


static void _tracker_backend_status_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


static GType tracker_sparql_backend_backend_get_type (void) {
	static volatile gsize tracker_sparql_backend_backend_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_backend_backend_type_id__volatile)) {
		static const GEnumValue values[] = {{TRACKER_SPARQL_BACKEND_BACKEND_AUTO, "TRACKER_SPARQL_BACKEND_BACKEND_AUTO", "auto"}, {TRACKER_SPARQL_BACKEND_BACKEND_DIRECT, "TRACKER_SPARQL_BACKEND_BACKEND_DIRECT", "direct"}, {TRACKER_SPARQL_BACKEND_BACKEND_BUS, "TRACKER_SPARQL_BACKEND_BACKEND_BUS", "bus"}, {0, NULL, NULL}};
		GType tracker_sparql_backend_backend_type_id;
		tracker_sparql_backend_backend_type_id = g_enum_register_static ("TrackerSparqlBackendBackend", values);
		g_once_init_leave (&tracker_sparql_backend_backend_type_id__volatile, tracker_sparql_backend_backend_type_id);
	}
	return tracker_sparql_backend_backend_type_id__volatile;
}


TrackerSparqlBackend* tracker_sparql_backend_construct (GType object_type, GError** error) {
	TrackerSparqlBackend * self = NULL;
	TrackerBackendStatus* _tmp0_ = NULL;
	TrackerBackendStatus* status;
	const gchar* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
	self = (TrackerSparqlBackend*) tracker_sparql_connection_construct (object_type);
	_tmp0_ = g_initable_new (TRACKER_BACKEND_TYPE_STATUS_PROXY, NULL, &_inner_error_, "g-flags", G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES | G_DBUS_PROXY_FLAGS_DO_NOT_CONNECT_SIGNALS, "g-name", TRACKER_DBUS_SERVICE, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", TRACKER_DBUS_OBJECT_STATUS, "g-interface-name", "org.freedesktop.Tracker1.Status", NULL);
	status = (TrackerBackendStatus*) _tmp0_;
	if (_inner_error_ != NULL) {
		if ((((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) || (_inner_error_->domain == G_SPAWN_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	g_dbus_proxy_set_default_timeout ((GDBusProxy*) status, G_MAXINT);
	g_debug ("tracker-backend.vala:42: Waiting for service to become available...");
	tracker_backend_status_wait (status, &_inner_error_);
	if (_inner_error_ != NULL) {
		if ((((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) || (_inner_error_->domain == G_SPAWN_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (status);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_object_unref0 (status);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	g_debug ("tracker-backend.vala:44: Service is ready");
	if (tracker_sparql_backend_direct_only) {
		_tmp1_ = "true";
	} else {
		_tmp1_ = "false";
	}
	g_debug ("tracker-backend.vala:47: Constructing connection, direct_only=%s", _tmp1_);
	tracker_sparql_backend_load_plugins (self, tracker_sparql_backend_direct_only, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch0_g_error;
	}
	g_debug ("tracker-backend.vala:49: Backend is ready");
	goto __finally0;
	__catch0_g_error:
	{
		GError * e;
		GError* _tmp2_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, e->message);
		_inner_error_ = _tmp2_;
		_g_error_free0 (e);
		goto __finally0;
	}
	__finally0:
	if (_inner_error_ != NULL) {
		if ((((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) || (_inner_error_->domain == G_SPAWN_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (status);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_object_unref0 (status);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_g_object_unref0 (status);
	return self;
}


TrackerSparqlBackend* tracker_sparql_backend_new (GError** error) {
	return tracker_sparql_backend_construct (TRACKER_SPARQL_TYPE_BACKEND, error);
}


static TrackerSparqlCursor* tracker_sparql_backend_real_query (TrackerSparqlConnection* base, const gchar* sparql, GCancellable* cancellable, GError** error) {
	TrackerSparqlBackend * self;
	TrackerSparqlCursor* result = NULL;
	GError * _inner_error_ = NULL;
	self = (TrackerSparqlBackend*) base;
	g_return_val_if_fail (sparql != NULL, NULL);
	g_return_val_if_fail ((self->priv->bus != NULL) || (self->priv->direct != NULL), NULL);
	g_debug ("tracker-backend.vala:57: %s(): '%s'", "Tracker.Sparql.Backend.query", sparql);
	if (self->priv->direct != NULL) {
		TrackerSparqlCursor* _tmp0_ = NULL;
		TrackerSparqlCursor* _tmp1_;
		_tmp0_ = tracker_sparql_connection_query (self->priv->direct, sparql, cancellable, &_inner_error_);
		_tmp1_ = _tmp0_;
		if (_inner_error_ != NULL) {
			if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) {
				g_propagate_error (error, _inner_error_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		result = _tmp1_;
		return result;
	} else {
		TrackerSparqlCursor* _tmp2_ = NULL;
		TrackerSparqlCursor* _tmp3_;
		_tmp2_ = tracker_sparql_connection_query (self->priv->bus, sparql, cancellable, &_inner_error_);
		_tmp3_ = _tmp2_;
		if (_inner_error_ != NULL) {
			if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) {
				g_propagate_error (error, _inner_error_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		result = _tmp3_;
		return result;
	}
}


static void tracker_sparql_backend_real_query_async_data_free (gpointer _data) {
	TrackerSparqlBackendQueryAsyncData* data;
	data = _data;
	_g_free0 (data->sparql);
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (TrackerSparqlBackendQueryAsyncData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void tracker_sparql_backend_real_query_async (TrackerSparqlConnection* base, const gchar* sparql, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSparqlBackend * self;
	TrackerSparqlBackendQueryAsyncData* _data_;
	self = (TrackerSparqlBackend*) base;
	_data_ = g_slice_new0 (TrackerSparqlBackendQueryAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_sparql_backend_real_query_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_sparql_backend_real_query_async_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->sparql = g_strdup (sparql);
	_data_->cancellable = _g_object_ref0 (cancellable);
	tracker_sparql_backend_real_query_async_co (_data_);
}


static TrackerSparqlCursor* tracker_sparql_backend_real_query_finish (TrackerSparqlConnection* base, GAsyncResult* _res_, GError** error) {
	TrackerSparqlCursor* result;
	TrackerSparqlBackendQueryAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void tracker_sparql_backend_query_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerSparqlBackendQueryAsyncData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	tracker_sparql_backend_real_query_async_co (data);
}


static gboolean tracker_sparql_backend_real_query_async_co (TrackerSparqlBackendQueryAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_return_val_if_fail ((data->self->priv->bus != NULL) || (data->self->priv->direct != NULL), FALSE);
	g_debug ("tracker-backend.vala:67: %s(): '%s'", "Tracker.Sparql.Backend.query_async", data->sparql);
	if (data->self->priv->direct != NULL) {
		data->_state_ = 1;
		tracker_sparql_connection_query_async (data->self->priv->direct, data->sparql, data->cancellable, tracker_sparql_backend_query_async_ready, data);
		return FALSE;
		_state_1:
		data->_tmp0_ = NULL;
		data->_tmp0_ = tracker_sparql_connection_query_finish (data->self->priv->direct, data->_res_, &data->_inner_error_);
		data->_tmp1_ = data->_tmp0_;
		if (data->_inner_error_ != NULL) {
			if (((data->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (data->_inner_error_->domain == G_IO_ERROR)) || (data->_inner_error_->domain == G_DBUS_ERROR)) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
		}
		data->result = data->_tmp1_;
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	} else {
		data->_state_ = 2;
		tracker_sparql_connection_query_async (data->self->priv->bus, data->sparql, data->cancellable, tracker_sparql_backend_query_async_ready, data);
		return FALSE;
		_state_2:
		data->_tmp2_ = NULL;
		data->_tmp2_ = tracker_sparql_connection_query_finish (data->self->priv->bus, data->_res_, &data->_inner_error_);
		data->_tmp3_ = data->_tmp2_;
		if (data->_inner_error_ != NULL) {
			if (((data->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (data->_inner_error_->domain == G_IO_ERROR)) || (data->_inner_error_->domain == G_DBUS_ERROR)) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
		}
		data->result = data->_tmp3_;
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void tracker_sparql_backend_real_update (TrackerSparqlConnection* base, const gchar* sparql, gint priority, GCancellable* cancellable, GError** error) {
	TrackerSparqlBackend * self;
	GError * _inner_error_ = NULL;
	self = (TrackerSparqlBackend*) base;
	g_return_if_fail (sparql != NULL);
	g_return_if_fail (self->priv->bus != NULL);
	g_debug ("tracker-backend.vala:77: %s(priority:%d): '%s'", "Tracker.Sparql.Backend.update", priority, sparql);
	tracker_sparql_connection_update (self->priv->bus, sparql, priority, cancellable, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static GVariant* tracker_sparql_backend_real_update_blank (TrackerSparqlConnection* base, const gchar* sparql, gint priority, GCancellable* cancellable, GError** error) {
	TrackerSparqlBackend * self;
	GVariant* result = NULL;
	GVariant* _tmp0_ = NULL;
	GVariant* _tmp1_;
	GError * _inner_error_ = NULL;
	self = (TrackerSparqlBackend*) base;
	g_return_val_if_fail (sparql != NULL, NULL);
	g_return_val_if_fail (self->priv->bus != NULL, NULL);
	g_debug ("tracker-backend.vala:83: %s(priority:%d): '%s'", "Tracker.Sparql.Backend.update_blank", priority, sparql);
	_tmp0_ = tracker_sparql_connection_update_blank (self->priv->bus, sparql, priority, cancellable, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _tmp1_;
	return result;
}


static void tracker_sparql_backend_real_update_async_data_free (gpointer _data) {
	TrackerSparqlBackendUpdateAsyncData* data;
	data = _data;
	_g_free0 (data->sparql);
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->self);
	g_slice_free (TrackerSparqlBackendUpdateAsyncData, data);
}


static void tracker_sparql_backend_real_update_async (TrackerSparqlConnection* base, const gchar* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSparqlBackend * self;
	TrackerSparqlBackendUpdateAsyncData* _data_;
	self = (TrackerSparqlBackend*) base;
	_data_ = g_slice_new0 (TrackerSparqlBackendUpdateAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_sparql_backend_real_update_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_sparql_backend_real_update_async_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->sparql = g_strdup (sparql);
	_data_->priority = priority;
	_data_->cancellable = _g_object_ref0 (cancellable);
	tracker_sparql_backend_real_update_async_co (_data_);
}


static void tracker_sparql_backend_real_update_finish (TrackerSparqlConnection* base, GAsyncResult* _res_, GError** error) {
	TrackerSparqlBackendUpdateAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void tracker_sparql_backend_update_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerSparqlBackendUpdateAsyncData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	tracker_sparql_backend_real_update_async_co (data);
}


static gboolean tracker_sparql_backend_real_update_async_co (TrackerSparqlBackendUpdateAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_return_val_if_fail (data->self->priv->bus != NULL, FALSE);
	g_debug ("tracker-backend.vala:89: %s(priority:%d): '%s'", "Tracker.Sparql.Backend.update_async", data->priority, data->sparql);
	data->_state_ = 1;
	tracker_sparql_connection_update_async (data->self->priv->bus, data->sparql, data->priority, data->cancellable, tracker_sparql_backend_update_async_ready, data);
	return FALSE;
	_state_1:
	tracker_sparql_connection_update_finish (data->self->priv->bus, data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		if (((data->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (data->_inner_error_->domain == G_IO_ERROR)) || (data->_inner_error_->domain == G_DBUS_ERROR)) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void tracker_sparql_backend_real_update_array_async_data_free (gpointer _data) {
	TrackerSparqlBackendUpdateArrayAsyncData* data;
	data = _data;
	data->sparql = (_vala_array_free (data->sparql, data->sparql_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (data->cancellable);
	_g_ptr_array_unref0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (TrackerSparqlBackendUpdateArrayAsyncData, data);
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


static void tracker_sparql_backend_real_update_array_async (TrackerSparqlConnection* base, gchar** sparql, int sparql_length1, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSparqlBackend * self;
	TrackerSparqlBackendUpdateArrayAsyncData* _data_;
	gchar** _tmp0_;
	self = (TrackerSparqlBackend*) base;
	_data_ = g_slice_new0 (TrackerSparqlBackendUpdateArrayAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_sparql_backend_real_update_array_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_sparql_backend_real_update_array_async_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->sparql = (_tmp0_ = sparql, (_tmp0_ == NULL) ? ((gpointer) _tmp0_) : _vala_array_dup1 (_tmp0_, sparql_length1));
	_data_->sparql_length1 = sparql_length1;
	_data_->priority = priority;
	_data_->cancellable = _g_object_ref0 (cancellable);
	tracker_sparql_backend_real_update_array_async_co (_data_);
}


static GPtrArray* tracker_sparql_backend_real_update_array_finish (TrackerSparqlConnection* base, GAsyncResult* _res_, GError** error) {
	GPtrArray* result;
	TrackerSparqlBackendUpdateArrayAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void tracker_sparql_backend_update_array_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerSparqlBackendUpdateArrayAsyncData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	tracker_sparql_backend_real_update_array_async_co (data);
}


static gboolean tracker_sparql_backend_real_update_array_async_co (TrackerSparqlBackendUpdateArrayAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_return_val_if_fail (data->self->priv->bus != NULL, FALSE);
	data->_state_ = 1;
	tracker_sparql_connection_update_array_async (data->self->priv->bus, data->sparql, data->sparql_length1, data->priority, data->cancellable, tracker_sparql_backend_update_array_async_ready, data);
	return FALSE;
	_state_1:
	data->_tmp0_ = NULL;
	data->_tmp0_ = tracker_sparql_connection_update_array_finish (data->self->priv->bus, data->_res_, &data->_inner_error_);
	data->_tmp1_ = data->_tmp0_;
	if (data->_inner_error_ != NULL) {
		if (((data->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (data->_inner_error_->domain == G_IO_ERROR)) || (data->_inner_error_->domain == G_DBUS_ERROR)) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	data->result = data->_tmp1_;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void tracker_sparql_backend_real_update_blank_async_data_free (gpointer _data) {
	TrackerSparqlBackendUpdateBlankAsyncData* data;
	data = _data;
	_g_free0 (data->sparql);
	_g_object_unref0 (data->cancellable);
	_g_variant_unref0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (TrackerSparqlBackendUpdateBlankAsyncData, data);
}


static void tracker_sparql_backend_real_update_blank_async (TrackerSparqlConnection* base, const gchar* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSparqlBackend * self;
	TrackerSparqlBackendUpdateBlankAsyncData* _data_;
	self = (TrackerSparqlBackend*) base;
	_data_ = g_slice_new0 (TrackerSparqlBackendUpdateBlankAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_sparql_backend_real_update_blank_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_sparql_backend_real_update_blank_async_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->sparql = g_strdup (sparql);
	_data_->priority = priority;
	_data_->cancellable = _g_object_ref0 (cancellable);
	tracker_sparql_backend_real_update_blank_async_co (_data_);
}


static GVariant* tracker_sparql_backend_real_update_blank_finish (TrackerSparqlConnection* base, GAsyncResult* _res_, GError** error) {
	GVariant* result;
	TrackerSparqlBackendUpdateBlankAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void tracker_sparql_backend_update_blank_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerSparqlBackendUpdateBlankAsyncData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	tracker_sparql_backend_real_update_blank_async_co (data);
}


static gboolean tracker_sparql_backend_real_update_blank_async_co (TrackerSparqlBackendUpdateBlankAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_return_val_if_fail (data->self->priv->bus != NULL, FALSE);
	g_debug ("tracker-backend.vala:100: %s(priority:%d): '%s'", "Tracker.Sparql.Backend.update_blank_async", data->priority, data->sparql);
	data->_state_ = 1;
	tracker_sparql_connection_update_blank_async (data->self->priv->bus, data->sparql, data->priority, data->cancellable, tracker_sparql_backend_update_blank_async_ready, data);
	return FALSE;
	_state_1:
	data->_tmp0_ = NULL;
	data->_tmp0_ = tracker_sparql_connection_update_blank_finish (data->self->priv->bus, data->_res_, &data->_inner_error_);
	data->_tmp1_ = data->_tmp0_;
	if (data->_inner_error_ != NULL) {
		if (((data->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (data->_inner_error_->domain == G_IO_ERROR)) || (data->_inner_error_->domain == G_DBUS_ERROR)) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	data->result = data->_tmp1_;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void tracker_sparql_backend_real_load (TrackerSparqlConnection* base, GFile* file, GCancellable* cancellable, GError** error) {
	TrackerSparqlBackend * self;
	gchar* _tmp0_ = NULL;
	gchar* uri;
	GError * _inner_error_ = NULL;
	self = (TrackerSparqlBackend*) base;
	g_return_if_fail (file != NULL);
	g_return_if_fail (self->priv->bus != NULL);
	_tmp0_ = g_file_get_uri (file);
	uri = _tmp0_;
	g_debug ("tracker-backend.vala:107: %s(): '%s'", "Tracker.Sparql.Backend.load", uri);
	tracker_sparql_connection_load (self->priv->bus, file, cancellable, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (uri);
			return;
		} else {
			_g_free0 (uri);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_free0 (uri);
}


static void tracker_sparql_backend_real_load_async_data_free (gpointer _data) {
	TrackerSparqlBackendLoadAsyncData* data;
	data = _data;
	_g_object_unref0 (data->file);
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->self);
	g_slice_free (TrackerSparqlBackendLoadAsyncData, data);
}


static void tracker_sparql_backend_real_load_async (TrackerSparqlConnection* base, GFile* file, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSparqlBackend * self;
	TrackerSparqlBackendLoadAsyncData* _data_;
	self = (TrackerSparqlBackend*) base;
	_data_ = g_slice_new0 (TrackerSparqlBackendLoadAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_sparql_backend_real_load_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_sparql_backend_real_load_async_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->file = _g_object_ref0 (file);
	_data_->cancellable = _g_object_ref0 (cancellable);
	tracker_sparql_backend_real_load_async_co (_data_);
}


static void tracker_sparql_backend_real_load_finish (TrackerSparqlConnection* base, GAsyncResult* _res_, GError** error) {
	TrackerSparqlBackendLoadAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void tracker_sparql_backend_load_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerSparqlBackendLoadAsyncData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	tracker_sparql_backend_real_load_async_co (data);
}


static gboolean tracker_sparql_backend_real_load_async_co (TrackerSparqlBackendLoadAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_return_val_if_fail (data->self->priv->bus != NULL, FALSE);
	data->_tmp0_ = NULL;
	data->_tmp0_ = g_file_get_uri (data->file);
	data->uri = data->_tmp0_;
	g_debug ("tracker-backend.vala:114: %s(): '%s'", "Tracker.Sparql.Backend.load_async", data->uri);
	data->_state_ = 1;
	tracker_sparql_connection_load_async (data->self->priv->bus, data->file, data->cancellable, tracker_sparql_backend_load_async_ready, data);
	return FALSE;
	_state_1:
	tracker_sparql_connection_load_finish (data->self->priv->bus, data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		if (((data->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (data->_inner_error_->domain == G_IO_ERROR)) || (data->_inner_error_->domain == G_DBUS_ERROR)) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_free0 (data->uri);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			_g_free0 (data->uri);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	_g_free0 (data->uri);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static TrackerSparqlCursor* tracker_sparql_backend_real_statistics (TrackerSparqlConnection* base, GCancellable* cancellable, GError** error) {
	TrackerSparqlBackend * self;
	TrackerSparqlCursor* result = NULL;
	TrackerSparqlCursor* _tmp0_ = NULL;
	TrackerSparqlCursor* _tmp1_;
	GError * _inner_error_ = NULL;
	self = (TrackerSparqlBackend*) base;
	g_return_val_if_fail (self->priv->bus != NULL, NULL);
	g_debug ("tracker-backend.vala:120: %s()", "Tracker.Sparql.Backend.statistics");
	_tmp0_ = tracker_sparql_connection_statistics (self->priv->bus, cancellable, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _tmp1_;
	return result;
}


static void tracker_sparql_backend_real_statistics_async_data_free (gpointer _data) {
	TrackerSparqlBackendStatisticsAsyncData* data;
	data = _data;
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (TrackerSparqlBackendStatisticsAsyncData, data);
}


static void tracker_sparql_backend_real_statistics_async (TrackerSparqlConnection* base, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSparqlBackend * self;
	TrackerSparqlBackendStatisticsAsyncData* _data_;
	self = (TrackerSparqlBackend*) base;
	_data_ = g_slice_new0 (TrackerSparqlBackendStatisticsAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_sparql_backend_real_statistics_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_sparql_backend_real_statistics_async_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->cancellable = _g_object_ref0 (cancellable);
	tracker_sparql_backend_real_statistics_async_co (_data_);
}


static TrackerSparqlCursor* tracker_sparql_backend_real_statistics_finish (TrackerSparqlConnection* base, GAsyncResult* _res_, GError** error) {
	TrackerSparqlCursor* result;
	TrackerSparqlBackendStatisticsAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void tracker_sparql_backend_statistics_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerSparqlBackendStatisticsAsyncData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	tracker_sparql_backend_real_statistics_async_co (data);
}


static gboolean tracker_sparql_backend_real_statistics_async_co (TrackerSparqlBackendStatisticsAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_return_val_if_fail (data->self->priv->bus != NULL, FALSE);
	g_debug ("tracker-backend.vala:126: %s()", "Tracker.Sparql.Backend.statistics_async");
	data->_state_ = 1;
	tracker_sparql_connection_statistics_async (data->self->priv->bus, data->cancellable, tracker_sparql_backend_statistics_async_ready, data);
	return FALSE;
	_state_1:
	data->_tmp0_ = NULL;
	data->_tmp0_ = tracker_sparql_connection_statistics_finish (data->self->priv->bus, data->_res_, &data->_inner_error_);
	data->_tmp1_ = data->_tmp0_;
	if (data->_inner_error_ != NULL) {
		if (((data->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (data->_inner_error_->domain == G_IO_ERROR)) || (data->_inner_error_->domain == G_DBUS_ERROR)) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	data->result = data->_tmp1_;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static gboolean tracker_sparql_backend_load_plugins (TrackerSparqlBackend* self, gboolean direct_only, GError** error) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* env_backend;
	TrackerSparqlBackendBackend backend;
	gboolean _tmp5_ = FALSE;
	TrackerSparqlConnection* connection = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = g_getenv ("TRACKER_SPARQL_BACKEND");
	_tmp1_ = g_strdup (_tmp0_);
	env_backend = _tmp1_;
	backend = TRACKER_SPARQL_BACKEND_BACKEND_AUTO;
	if (env_backend != NULL) {
		gint _tmp2_;
		_tmp2_ = g_ascii_strcasecmp (env_backend, "direct");
		if (_tmp2_ == 0) {
			backend = TRACKER_SPARQL_BACKEND_BACKEND_DIRECT;
			g_debug ("tracker-backend.vala:138: Using backend = 'DIRECT'");
		} else {
			gint _tmp3_;
			_tmp3_ = g_ascii_strcasecmp (env_backend, "bus");
			if (_tmp3_ == 0) {
				backend = TRACKER_SPARQL_BACKEND_BACKEND_BUS;
				g_debug ("tracker-backend.vala:141: Using backend = 'BUS'");
			} else {
				g_warning ("tracker-backend.vala:143: Environment variable TRACKER_SPARQL_BACKEND " \
"set to unknown value '%s'", env_backend);
			}
		}
	}
	if (backend == TRACKER_SPARQL_BACKEND_BACKEND_AUTO) {
		gboolean _tmp4_ = FALSE;
		if (direct_only) {
			_tmp4_ = backend == TRACKER_SPARQL_BACKEND_BACKEND_AUTO;
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			backend = TRACKER_SPARQL_BACKEND_BACKEND_DIRECT;
			g_debug ("tracker-backend.vala:150: Using backend = 'DIRECT'");
		} else {
			g_debug ("tracker-backend.vala:152: Using backend = 'AUTO'");
		}
	}
	if (direct_only) {
		_tmp5_ = backend == TRACKER_SPARQL_BACKEND_BACKEND_BUS;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		g_debug ("tracker-backend.vala:157: Backend set in environment contradicts reque" \
"sted connection type, using environment to override");
	}
	switch (backend) {
		case TRACKER_SPARQL_BACKEND_BACKEND_AUTO:
		{
			TrackerDirectConnection* _tmp6_ = NULL;
			TrackerDirectConnection* _tmp7_;
			TrackerBusConnection* _tmp8_ = NULL;
			TrackerBusConnection* _tmp9_;
			TrackerSparqlConnection* _tmp10_;
			_tmp6_ = tracker_direct_connection_new (&_inner_error_);
			_tmp7_ = _tmp6_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					goto __catch1_tracker_sparql_error;
				}
				goto __finally1;
			}
			_g_object_unref0 (self->priv->direct);
			self->priv->direct = (TrackerSparqlConnection*) _tmp7_;
			goto __finally1;
			__catch1_tracker_sparql_error:
			{
				GError * e;
				e = _inner_error_;
				_inner_error_ = NULL;
				g_debug ("tracker-backend.vala:167: Unable to initialize direct backend");
				_g_error_free0 (e);
			}
			__finally1:
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (connection);
				_g_free0 (env_backend);
				return FALSE;
			}
			_tmp8_ = tracker_bus_connection_new (&_inner_error_);
			_tmp9_ = _tmp8_;
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (connection);
				_g_free0 (env_backend);
				return FALSE;
			}
			_g_object_unref0 (self->priv->bus);
			self->priv->bus = (TrackerSparqlConnection*) _tmp9_;
			_tmp10_ = _g_object_ref0 (self->priv->bus);
			_g_object_unref0 (connection);
			connection = _tmp10_;
			break;
		}
		case TRACKER_SPARQL_BACKEND_BACKEND_DIRECT:
		{
			TrackerDirectConnection* _tmp11_ = NULL;
			TrackerDirectConnection* _tmp12_;
			TrackerSparqlConnection* _tmp13_;
			_tmp11_ = tracker_direct_connection_new (&_inner_error_);
			_tmp12_ = _tmp11_;
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (connection);
				_g_free0 (env_backend);
				return FALSE;
			}
			_g_object_unref0 (self->priv->direct);
			self->priv->direct = (TrackerSparqlConnection*) _tmp12_;
			_tmp13_ = _g_object_ref0 (self->priv->direct);
			_g_object_unref0 (connection);
			connection = _tmp13_;
			break;
		}
		case TRACKER_SPARQL_BACKEND_BACKEND_BUS:
		{
			TrackerBusConnection* _tmp14_ = NULL;
			TrackerBusConnection* _tmp15_;
			TrackerSparqlConnection* _tmp16_;
			_tmp14_ = tracker_bus_connection_new (&_inner_error_);
			_tmp15_ = _tmp14_;
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (connection);
				_g_free0 (env_backend);
				return FALSE;
			}
			_g_object_unref0 (self->priv->bus);
			self->priv->bus = (TrackerSparqlConnection*) _tmp15_;
			_tmp16_ = _g_object_ref0 (self->priv->bus);
			_g_object_unref0 (connection);
			connection = _tmp16_;
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	result = connection != NULL;
	_g_object_unref0 (connection);
	_g_free0 (env_backend);
	return result;
}


static TrackerSparqlConnection* tracker_sparql_backend_get (gboolean is_direct_only, GCancellable* cancellable, GError** error) {
	TrackerSparqlConnection* result = NULL;
	TrackerSparqlConnection* _tmp0_;
	TrackerSparqlConnection* _result_;
	GError * _inner_error_ = NULL;
	g_static_mutex_lock (&tracker_sparql_backend_door);
	_tmp0_ = _g_object_ref0 (tracker_sparql_backend_singleton);
	_result_ = _tmp0_;
	if (_result_ == NULL) {
		TrackerSparqlBackend* _tmp1_ = NULL;
		TrackerSparqlBackend* _tmp2_;
		gboolean _tmp3_ = FALSE;
		tracker_sparql_backend_log_init ();
		tracker_sparql_backend_direct_only = is_direct_only;
		_tmp1_ = tracker_sparql_backend_new (&_inner_error_);
		_tmp2_ = _tmp1_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (_result_);
			goto __finally2;
		}
		_g_object_unref0 (_result_);
		_result_ = (TrackerSparqlConnection*) _tmp2_;
		if (cancellable != NULL) {
			gboolean _tmp4_;
			_tmp4_ = g_cancellable_is_cancelled (cancellable);
			_tmp3_ = _tmp4_;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			GError* _tmp5_ = NULL;
			_tmp5_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_CANCELLED, "Operation was cancelled");
			_inner_error_ = _tmp5_;
			_g_object_unref0 (_result_);
			goto __finally2;
		}
		tracker_sparql_backend_singleton = _result_;
		g_object_add_weak_pointer ((GObject*) _result_, (void**) (&tracker_sparql_backend_singleton));
	}
	g_assert (tracker_sparql_backend_direct_only == is_direct_only);
	result = _result_;
	g_static_mutex_unlock (&tracker_sparql_backend_door);
	return result;
	_g_object_unref0 (_result_);
	__finally2:
	g_static_mutex_unlock (&tracker_sparql_backend_door);
	if ((((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) || (_inner_error_->domain == G_SPAWN_ERROR)) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->async_result);
		_g_main_loop_unref0 (_data1_->loop);
		g_slice_free (Block1Data, _data1_);
	}
}


static void _lambda2_ (GObject* obj, GAsyncResult* res, Block1Data* _data1_) {
	GAsyncResult* _tmp0_;
	g_return_if_fail (res != NULL);
	_tmp0_ = _g_object_ref0 (res);
	_g_object_unref0 (_data1_->async_result);
	_data1_->async_result = _tmp0_;
	g_main_loop_quit (_data1_->loop);
}


static void __lambda2__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	_lambda2_ (source_object, res, self);
	block1_data_unref (self);
}


TrackerSparqlConnection* tracker_sparql_backend_get_internal (gboolean is_direct_only, GCancellable* cancellable, GError** error) {
	TrackerSparqlConnection* result = NULL;
	Block1Data* _data1_;
	GMainContext* _tmp0_ = NULL;
	GMainContext* _tmp3_ = NULL;
	GMainContext* context;
	GMainLoop* _tmp4_ = NULL;
	TrackerSparqlConnection* _tmp5_ = NULL;
	TrackerSparqlConnection* _tmp6_;
	GError * _inner_error_ = NULL;
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_tmp0_ = g_main_context_get_thread_default ();
	if (_tmp0_ == NULL) {
		TrackerSparqlConnection* _tmp1_ = NULL;
		TrackerSparqlConnection* _tmp2_;
		_tmp1_ = tracker_sparql_backend_get (is_direct_only, cancellable, &_inner_error_);
		_tmp2_ = _tmp1_;
		if (_inner_error_ != NULL) {
			if ((((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) || (_inner_error_->domain == G_SPAWN_ERROR)) {
				g_propagate_error (error, _inner_error_);
				block1_data_unref (_data1_);
				_data1_ = NULL;
				return NULL;
			} else {
				block1_data_unref (_data1_);
				_data1_ = NULL;
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		result = _tmp2_;
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return result;
	}
	_tmp3_ = g_main_context_new ();
	context = _tmp3_;
	_tmp4_ = g_main_loop_new (context, FALSE);
	_data1_->loop = _tmp4_;
	_data1_->async_result = NULL;
	g_main_context_push_thread_default (context);
	tracker_sparql_backend_get_internal_async (is_direct_only, cancellable, __lambda2__gasync_ready_callback, block1_data_ref (_data1_));
	g_main_loop_run (_data1_->loop);
	g_main_context_pop_thread_default (context);
	_tmp5_ = tracker_sparql_backend_get_internal_finish (_data1_->async_result, &_inner_error_);
	_tmp6_ = _tmp5_;
	if (_inner_error_ != NULL) {
		if ((((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) || (_inner_error_->domain == G_SPAWN_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_main_context_unref0 (context);
			block1_data_unref (_data1_);
			_data1_ = NULL;
			return NULL;
		} else {
			_g_main_context_unref0 (context);
			block1_data_unref (_data1_);
			_data1_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _tmp6_;
	_g_main_context_unref0 (context);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}


static void tracker_sparql_backend_get_internal_async_data_free (gpointer _data) {
	TrackerSparqlBackendGetInternalAsyncData* data;
	data = _data;
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->result);
	g_slice_free (TrackerSparqlBackendGetInternalAsyncData, data);
}


void tracker_sparql_backend_get_internal_async (gboolean is_direct_only, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSparqlBackendGetInternalAsyncData* _data_;
	_data_ = g_slice_new0 (TrackerSparqlBackendGetInternalAsyncData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, tracker_sparql_backend_get_internal_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_sparql_backend_get_internal_async_data_free);
	_data_->is_direct_only = is_direct_only;
	_data_->cancellable = _g_object_ref0 (cancellable);
	tracker_sparql_backend_get_internal_async_co (_data_);
}


TrackerSparqlConnection* tracker_sparql_backend_get_internal_finish (GAsyncResult* _res_, GError** error) {
	TrackerSparqlConnection* result;
	TrackerSparqlBackendGetInternalAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_g_main_context_unref0 (_data2_->context);
		_g_object_unref0 (_data2_->_result_);
		_g_error_free0 (_data2_->spawn_error);
		_g_error_free0 (_data2_->dbus_error);
		_g_error_free0 (_data2_->io_error);
		_g_error_free0 (_data2_->sparql_error);
		_g_object_unref0 (_data2_->cancellable);
		g_slice_free (Block2Data, _data2_);
	}
}


static gpointer _g_main_context_ref0 (gpointer self) {
	return self ? g_main_context_ref (self) : NULL;
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static gboolean _lambda1_ (Block2Data* _data2_) {
	gboolean result = FALSE;
	tracker_sparql_backend_get_internal_async_co (_data2_->_async_data_);
	result = FALSE;
	return result;
}


static gboolean __lambda1__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda1_ (self);
	return result;
}


static gboolean _lambda0_ (GIOSchedulerJob* job, Block2Data* _data2_) {
	gboolean result = FALSE;
	TrackerSparqlConnection* _tmp0_ = NULL;
	TrackerSparqlConnection* _tmp1_;
	GSource* _tmp6_ = NULL;
	GSource* source;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (job != NULL, FALSE);
	_tmp0_ = tracker_sparql_backend_get (_data2_->is_direct_only, _data2_->cancellable, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_IO_ERROR) {
			goto __catch3_g_io_error;
		}
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			goto __catch3_tracker_sparql_error;
		}
		if (_inner_error_->domain == G_DBUS_ERROR) {
			goto __catch3_g_dbus_error;
		}
		if (_inner_error_->domain == G_SPAWN_ERROR) {
			goto __catch3_g_spawn_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_g_object_unref0 (_data2_->_result_);
	_data2_->_result_ = _tmp1_;
	goto __finally3;
	__catch3_g_io_error:
	{
		GError * e_io;
		GError* _tmp2_;
		e_io = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = _g_error_copy0 (e_io);
		_g_error_free0 (_data2_->io_error);
		_data2_->io_error = _tmp2_;
		_g_error_free0 (e_io);
	}
	goto __finally3;
	__catch3_tracker_sparql_error:
	{
		GError * e_spql;
		GError* _tmp3_;
		e_spql = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = _g_error_copy0 (e_spql);
		_g_error_free0 (_data2_->sparql_error);
		_data2_->sparql_error = _tmp3_;
		_g_error_free0 (e_spql);
	}
	goto __finally3;
	__catch3_g_dbus_error:
	{
		GError * e_dbus;
		GError* _tmp4_;
		e_dbus = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = _g_error_copy0 (e_dbus);
		_g_error_free0 (_data2_->dbus_error);
		_data2_->dbus_error = _tmp4_;
		_g_error_free0 (e_dbus);
	}
	goto __finally3;
	__catch3_g_spawn_error:
	{
		GError * e_spawn;
		GError* _tmp5_;
		e_spawn = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = _g_error_copy0 (e_spawn);
		_g_error_free0 (_data2_->spawn_error);
		_data2_->spawn_error = _tmp5_;
		_g_error_free0 (e_spawn);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp6_ = g_idle_source_new ();
	source = _tmp6_;
	g_source_set_callback (source, __lambda1__gsource_func, block2_data_ref (_data2_), block2_data_unref);
	g_source_attach (source, _data2_->context);
	result = FALSE;
	_g_source_unref0 (source);
	return result;
}


static gboolean __lambda0__gio_scheduler_job_func (GIOSchedulerJob* job, GCancellable* cancellable, gpointer self) {
	gboolean result;
	result = _lambda0_ (job, self);
	return result;
}


static gboolean tracker_sparql_backend_get_internal_async_co (TrackerSparqlBackendGetInternalAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_data2_ = g_slice_new0 (Block2Data);
	data->_data2_->_ref_count_ = 1;
	data->_data2_->is_direct_only = data->is_direct_only;
	data->_data2_->cancellable = _g_object_ref0 (data->cancellable);
	data->_data2_->_async_data_ = data;
	data->_tmp0_ = g_static_mutex_trylock (&tracker_sparql_backend_door);
	if (data->_tmp0_) {
		data->_tmp1_ = _g_object_ref0 (tracker_sparql_backend_singleton);
		data->_result_ = data->_tmp1_;
		g_static_mutex_unlock (&tracker_sparql_backend_door);
		if (data->_result_ != NULL) {
			g_assert (tracker_sparql_backend_direct_only == data->_data2_->is_direct_only);
			data->result = data->_result_;
			block2_data_unref (data->_data2_);
			data->_data2_ = NULL;
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
		_g_object_unref0 (data->_result_);
	}
	data->_data2_->sparql_error = NULL;
	data->_data2_->io_error = NULL;
	data->_data2_->dbus_error = NULL;
	data->_data2_->spawn_error = NULL;
	data->_data2_->_result_ = NULL;
	data->_tmp2_ = NULL;
	data->_tmp2_ = g_main_context_get_thread_default ();
	data->_tmp3_ = _g_main_context_ref0 (data->_tmp2_);
	data->_data2_->context = data->_tmp3_;
	g_io_scheduler_push_job (__lambda0__gio_scheduler_job_func, block2_data_ref (data->_data2_), block2_data_unref, G_PRIORITY_DEFAULT, NULL);
	data->_state_ = 1;
	return FALSE;
	_state_1:
	;
	if (data->_data2_->sparql_error != NULL) {
		data->_tmp4_ = _g_error_copy0 (data->_data2_->sparql_error);
		data->_inner_error_ = data->_tmp4_;
		if ((((data->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (data->_inner_error_->domain == G_IO_ERROR)) || (data->_inner_error_->domain == G_DBUS_ERROR)) || (data->_inner_error_->domain == G_SPAWN_ERROR)) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			block2_data_unref (data->_data2_);
			data->_data2_ = NULL;
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			block2_data_unref (data->_data2_);
			data->_data2_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	} else {
		if (data->_data2_->io_error != NULL) {
			data->_tmp5_ = _g_error_copy0 (data->_data2_->io_error);
			data->_inner_error_ = data->_tmp5_;
			if ((((data->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (data->_inner_error_->domain == G_IO_ERROR)) || (data->_inner_error_->domain == G_DBUS_ERROR)) || (data->_inner_error_->domain == G_SPAWN_ERROR)) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				block2_data_unref (data->_data2_);
				data->_data2_ = NULL;
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			} else {
				block2_data_unref (data->_data2_);
				data->_data2_ = NULL;
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
		} else {
			if (data->_data2_->dbus_error != NULL) {
				data->_tmp6_ = _g_error_copy0 (data->_data2_->dbus_error);
				data->_inner_error_ = data->_tmp6_;
				if ((((data->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (data->_inner_error_->domain == G_IO_ERROR)) || (data->_inner_error_->domain == G_DBUS_ERROR)) || (data->_inner_error_->domain == G_SPAWN_ERROR)) {
					g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
					g_error_free (data->_inner_error_);
					block2_data_unref (data->_data2_);
					data->_data2_ = NULL;
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				} else {
					block2_data_unref (data->_data2_);
					data->_data2_ = NULL;
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
					g_clear_error (&data->_inner_error_);
					return FALSE;
				}
			} else {
				if (data->_data2_->spawn_error != NULL) {
					data->_tmp7_ = _g_error_copy0 (data->_data2_->spawn_error);
					data->_inner_error_ = data->_tmp7_;
					if ((((data->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (data->_inner_error_->domain == G_IO_ERROR)) || (data->_inner_error_->domain == G_DBUS_ERROR)) || (data->_inner_error_->domain == G_SPAWN_ERROR)) {
						g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
						g_error_free (data->_inner_error_);
						block2_data_unref (data->_data2_);
						data->_data2_ = NULL;
						if (data->_state_ == 0) {
							g_simple_async_result_complete_in_idle (data->_async_result);
						} else {
							g_simple_async_result_complete (data->_async_result);
						}
						g_object_unref (data->_async_result);
						return FALSE;
					} else {
						block2_data_unref (data->_data2_);
						data->_data2_ = NULL;
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
						g_clear_error (&data->_inner_error_);
						return FALSE;
					}
				} else {
					data->_tmp8_ = _g_object_ref0 (data->_data2_->_result_);
					data->result = data->_tmp8_;
					block2_data_unref (data->_data2_);
					data->_data2_ = NULL;
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			}
		}
	}
	block2_data_unref (data->_data2_);
	data->_data2_ = NULL;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void _tracker_sparql_backend_remove_log_handler_glog_func (const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message, gpointer self) {
	tracker_sparql_backend_remove_log_handler (log_domain, log_levels, message);
}


static void tracker_sparql_backend_log_init (void) {
	gint verbosity;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* env_verbosity;
	GLogLevelFlags remove_levels;
	if (tracker_sparql_backend_log_initialized) {
		return;
	}
	tracker_sparql_backend_log_initialized = TRUE;
	verbosity = 0;
	_tmp0_ = g_getenv ("TRACKER_VERBOSITY");
	_tmp1_ = g_strdup (_tmp0_);
	env_verbosity = _tmp1_;
	if (env_verbosity != NULL) {
		gint _tmp2_;
		_tmp2_ = atoi (env_verbosity);
		verbosity = _tmp2_;
	}
	remove_levels = 0;
	switch (verbosity) {
		case 3:
		{
			break;
		}
		case 2:
		{
			remove_levels = G_LOG_LEVEL_DEBUG;
			break;
		}
		case 1:
		{
			remove_levels = G_LOG_LEVEL_DEBUG | G_LOG_LEVEL_MESSAGE;
			break;
		}
		default:
		case 0:
		{
			remove_levels = (G_LOG_LEVEL_DEBUG | G_LOG_LEVEL_MESSAGE) | G_LOG_LEVEL_INFO;
			break;
		}
	}
	if (remove_levels != 0) {
		g_log_set_handler ("Tracker", remove_levels, _tracker_sparql_backend_remove_log_handler_glog_func, NULL);
	}
	_g_free0 (env_verbosity);
}


static void tracker_sparql_backend_remove_log_handler (const gchar* log_domain, GLogLevelFlags log_level, const gchar* message) {
	g_return_if_fail (message != NULL);
}


static void tracker_sparql_backend_class_init (TrackerSparqlBackendClass * klass) {
	tracker_sparql_backend_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TrackerSparqlBackendPrivate));
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->query = tracker_sparql_backend_real_query;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->query_async = tracker_sparql_backend_real_query_async;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->query_finish = tracker_sparql_backend_real_query_finish;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->update = tracker_sparql_backend_real_update;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->update_blank = tracker_sparql_backend_real_update_blank;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->update_async = tracker_sparql_backend_real_update_async;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->update_finish = tracker_sparql_backend_real_update_finish;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->update_array_async = tracker_sparql_backend_real_update_array_async;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->update_array_finish = tracker_sparql_backend_real_update_array_finish;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->update_blank_async = tracker_sparql_backend_real_update_blank_async;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->update_blank_finish = tracker_sparql_backend_real_update_blank_finish;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->load = tracker_sparql_backend_real_load;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->load_async = tracker_sparql_backend_real_load_async;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->load_finish = tracker_sparql_backend_real_load_finish;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->statistics = tracker_sparql_backend_real_statistics;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->statistics_async = tracker_sparql_backend_real_statistics_async;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->statistics_finish = tracker_sparql_backend_real_statistics_finish;
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_backend_finalize;
}


static void tracker_sparql_backend_instance_init (TrackerSparqlBackend * self) {
	self->priv = TRACKER_SPARQL_BACKEND_GET_PRIVATE (self);
	self->priv->direct = NULL;
	self->priv->bus = NULL;
}


static void tracker_sparql_backend_finalize (GObject* obj) {
	TrackerSparqlBackend * self;
	self = TRACKER_SPARQL_BACKEND (obj);
	_g_object_unref0 (self->priv->direct);
	_g_object_unref0 (self->priv->bus);
	G_OBJECT_CLASS (tracker_sparql_backend_parent_class)->finalize (obj);
}


GType tracker_sparql_backend_get_type (void) {
	static volatile gsize tracker_sparql_backend_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_backend_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlBackend), 0, (GInstanceInitFunc) tracker_sparql_backend_instance_init, NULL };
		GType tracker_sparql_backend_type_id;
		tracker_sparql_backend_type_id = g_type_register_static (TRACKER_SPARQL_TYPE_CONNECTION, "TrackerSparqlBackend", &g_define_type_info, 0);
		g_once_init_leave (&tracker_sparql_backend_type_id__volatile, tracker_sparql_backend_type_id);
	}
	return tracker_sparql_backend_type_id__volatile;
}


static void tracker_sparql_connection_get_async_data_free (gpointer _data) {
	TrackerSparqlConnectionGetAsyncData* data;
	data = _data;
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->result);
	g_slice_free (TrackerSparqlConnectionGetAsyncData, data);
}


void tracker_sparql_connection_get_async (GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSparqlConnectionGetAsyncData* _data_;
	_data_ = g_slice_new0 (TrackerSparqlConnectionGetAsyncData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, tracker_sparql_connection_get_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_sparql_connection_get_async_data_free);
	_data_->cancellable = _g_object_ref0 (cancellable);
	tracker_sparql_connection_get_async_co (_data_);
}


TrackerSparqlConnection* tracker_sparql_connection_get_finish (GAsyncResult* _res_, GError** error) {
	TrackerSparqlConnection* result;
	TrackerSparqlConnectionGetAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void tracker_sparql_connection_get_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerSparqlConnectionGetAsyncData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	tracker_sparql_connection_get_async_co (data);
}


static gboolean tracker_sparql_connection_get_async_co (TrackerSparqlConnectionGetAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_state_ = 1;
	tracker_sparql_backend_get_internal_async (FALSE, data->cancellable, tracker_sparql_connection_get_async_ready, data);
	return FALSE;
	_state_1:
	data->_tmp0_ = NULL;
	data->_tmp0_ = tracker_sparql_backend_get_internal_finish (data->_res_, &data->_inner_error_);
	data->_tmp1_ = data->_tmp0_;
	if (data->_inner_error_ != NULL) {
		if ((((data->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (data->_inner_error_->domain == G_IO_ERROR)) || (data->_inner_error_->domain == G_DBUS_ERROR)) || (data->_inner_error_->domain == G_SPAWN_ERROR)) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	data->result = data->_tmp1_;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


TrackerSparqlConnection* tracker_sparql_connection_get (GCancellable* cancellable, GError** error) {
	TrackerSparqlConnection* result = NULL;
	TrackerSparqlConnection* _tmp0_ = NULL;
	TrackerSparqlConnection* _tmp1_;
	GError * _inner_error_ = NULL;
	_tmp0_ = tracker_sparql_backend_get_internal (FALSE, cancellable, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if ((((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) || (_inner_error_->domain == G_SPAWN_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _tmp1_;
	return result;
}


static void tracker_sparql_connection_get_direct_async_data_free (gpointer _data) {
	TrackerSparqlConnectionGetDirectAsyncData* data;
	data = _data;
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->result);
	g_slice_free (TrackerSparqlConnectionGetDirectAsyncData, data);
}


void tracker_sparql_connection_get_direct_async (GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSparqlConnectionGetDirectAsyncData* _data_;
	_data_ = g_slice_new0 (TrackerSparqlConnectionGetDirectAsyncData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, tracker_sparql_connection_get_direct_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_sparql_connection_get_direct_async_data_free);
	_data_->cancellable = _g_object_ref0 (cancellable);
	tracker_sparql_connection_get_direct_async_co (_data_);
}


TrackerSparqlConnection* tracker_sparql_connection_get_direct_finish (GAsyncResult* _res_, GError** error) {
	TrackerSparqlConnection* result;
	TrackerSparqlConnectionGetDirectAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void tracker_sparql_connection_get_direct_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerSparqlConnectionGetDirectAsyncData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	tracker_sparql_connection_get_direct_async_co (data);
}


static gboolean tracker_sparql_connection_get_direct_async_co (TrackerSparqlConnectionGetDirectAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_state_ = 1;
	tracker_sparql_backend_get_internal_async (TRUE, data->cancellable, tracker_sparql_connection_get_direct_async_ready, data);
	return FALSE;
	_state_1:
	data->_tmp0_ = NULL;
	data->_tmp0_ = tracker_sparql_backend_get_internal_finish (data->_res_, &data->_inner_error_);
	data->_tmp1_ = data->_tmp0_;
	if (data->_inner_error_ != NULL) {
		if ((((data->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (data->_inner_error_->domain == G_IO_ERROR)) || (data->_inner_error_->domain == G_DBUS_ERROR)) || (data->_inner_error_->domain == G_SPAWN_ERROR)) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	data->result = data->_tmp1_;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


TrackerSparqlConnection* tracker_sparql_connection_get_direct (GCancellable* cancellable, GError** error) {
	TrackerSparqlConnection* result = NULL;
	TrackerSparqlConnection* _tmp0_ = NULL;
	TrackerSparqlConnection* _tmp1_;
	GError * _inner_error_ = NULL;
	_tmp0_ = tracker_sparql_backend_get_internal (TRUE, cancellable, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if ((((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) || (_inner_error_->domain == G_SPAWN_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _tmp1_;
	return result;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



