/* tracker-sparql-query.c generated by valac 0.11.4, the Vala compiler
 * generated from tracker-sparql-query.vala, do not modify */

/*
 * Copyright (C) 2008-2010, Nokia
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libtracker-data/tracker-property.h>
#include <libtracker-data/tracker-class.h>
#include <libtracker-data/tracker-data-query.h>
#include <libtracker-data/tracker-data-update.h>
#include <libtracker-data/tracker-data-backup.h>
#include <libtracker-sparql/tracker-sparql.h>
#include <libtracker-data/tracker-db-interface.h>
#include <libtracker-common/tracker-date-time.h>
#include <libtracker-data/tracker-ontologies.h>
#include <libtracker-data/tracker-namespace.h>
#include <libtracker-data/tracker-db-manager.h>
#include <gobject/gvaluecollector.h>


#define TRACKER_SPARQL_TYPE_VARIABLE_STATE (tracker_sparql_variable_state_get_type ())

#define TRACKER_SPARQL_TYPE_DATA_TABLE (tracker_sparql_data_table_get_type ())
#define TRACKER_SPARQL_DATA_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_DATA_TABLE, TrackerSparqlDataTable))
#define TRACKER_SPARQL_DATA_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_DATA_TABLE, TrackerSparqlDataTableClass))
#define TRACKER_SPARQL_IS_DATA_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_DATA_TABLE))
#define TRACKER_SPARQL_IS_DATA_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_DATA_TABLE))
#define TRACKER_SPARQL_DATA_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_DATA_TABLE, TrackerSparqlDataTableClass))

typedef struct _TrackerSparqlDataTable TrackerSparqlDataTable;
typedef struct _TrackerSparqlDataTableClass TrackerSparqlDataTableClass;
typedef struct _TrackerSparqlDataTablePrivate TrackerSparqlDataTablePrivate;

#define TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE (tracker_sparql_predicate_variable_get_type ())
#define TRACKER_SPARQL_PREDICATE_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE, TrackerSparqlPredicateVariable))
#define TRACKER_SPARQL_PREDICATE_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE, TrackerSparqlPredicateVariableClass))
#define TRACKER_SPARQL_IS_PREDICATE_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE))
#define TRACKER_SPARQL_IS_PREDICATE_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE))
#define TRACKER_SPARQL_PREDICATE_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE, TrackerSparqlPredicateVariableClass))

typedef struct _TrackerSparqlPredicateVariable TrackerSparqlPredicateVariable;
typedef struct _TrackerSparqlPredicateVariableClass TrackerSparqlPredicateVariableClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TRACKER_SPARQL_TYPE_DATA_BINDING (tracker_sparql_data_binding_get_type ())
#define TRACKER_SPARQL_DATA_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_DATA_BINDING, TrackerSparqlDataBinding))
#define TRACKER_SPARQL_DATA_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_DATA_BINDING, TrackerSparqlDataBindingClass))
#define TRACKER_SPARQL_IS_DATA_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_DATA_BINDING))
#define TRACKER_SPARQL_IS_DATA_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_DATA_BINDING))
#define TRACKER_SPARQL_DATA_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_DATA_BINDING, TrackerSparqlDataBindingClass))

typedef struct _TrackerSparqlDataBinding TrackerSparqlDataBinding;
typedef struct _TrackerSparqlDataBindingClass TrackerSparqlDataBindingClass;
typedef struct _TrackerSparqlDataBindingPrivate TrackerSparqlDataBindingPrivate;

#define TRACKER_SPARQL_TYPE_LITERAL_BINDING (tracker_sparql_literal_binding_get_type ())
#define TRACKER_SPARQL_LITERAL_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_LITERAL_BINDING, TrackerSparqlLiteralBinding))
#define TRACKER_SPARQL_LITERAL_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_LITERAL_BINDING, TrackerSparqlLiteralBindingClass))
#define TRACKER_SPARQL_IS_LITERAL_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_LITERAL_BINDING))
#define TRACKER_SPARQL_IS_LITERAL_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_LITERAL_BINDING))
#define TRACKER_SPARQL_LITERAL_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_LITERAL_BINDING, TrackerSparqlLiteralBindingClass))

typedef struct _TrackerSparqlLiteralBinding TrackerSparqlLiteralBinding;
typedef struct _TrackerSparqlLiteralBindingClass TrackerSparqlLiteralBindingClass;
typedef struct _TrackerSparqlLiteralBindingPrivate TrackerSparqlLiteralBindingPrivate;

#define TRACKER_SPARQL_TYPE_VARIABLE_BINDING (tracker_sparql_variable_binding_get_type ())
#define TRACKER_SPARQL_VARIABLE_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING, TrackerSparqlVariableBinding))
#define TRACKER_SPARQL_VARIABLE_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_VARIABLE_BINDING, TrackerSparqlVariableBindingClass))
#define TRACKER_SPARQL_IS_VARIABLE_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING))
#define TRACKER_SPARQL_IS_VARIABLE_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_VARIABLE_BINDING))
#define TRACKER_SPARQL_VARIABLE_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING, TrackerSparqlVariableBindingClass))

typedef struct _TrackerSparqlVariableBinding TrackerSparqlVariableBinding;
typedef struct _TrackerSparqlVariableBindingClass TrackerSparqlVariableBindingClass;
typedef struct _TrackerSparqlVariableBindingPrivate TrackerSparqlVariableBindingPrivate;

#define TRACKER_SPARQL_TYPE_VARIABLE (tracker_sparql_variable_get_type ())
#define TRACKER_SPARQL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_VARIABLE, TrackerSparqlVariable))
#define TRACKER_SPARQL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_VARIABLE, TrackerSparqlVariableClass))
#define TRACKER_SPARQL_IS_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_VARIABLE))
#define TRACKER_SPARQL_IS_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_VARIABLE))
#define TRACKER_SPARQL_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_VARIABLE, TrackerSparqlVariableClass))

typedef struct _TrackerSparqlVariable TrackerSparqlVariable;
typedef struct _TrackerSparqlVariableClass TrackerSparqlVariableClass;

#define TRACKER_SPARQL_TYPE_VARIABLE_BINDING_LIST (tracker_sparql_variable_binding_list_get_type ())
#define TRACKER_SPARQL_VARIABLE_BINDING_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING_LIST, TrackerSparqlVariableBindingList))
#define TRACKER_SPARQL_VARIABLE_BINDING_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_VARIABLE_BINDING_LIST, TrackerSparqlVariableBindingListClass))
#define TRACKER_SPARQL_IS_VARIABLE_BINDING_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING_LIST))
#define TRACKER_SPARQL_IS_VARIABLE_BINDING_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_VARIABLE_BINDING_LIST))
#define TRACKER_SPARQL_VARIABLE_BINDING_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING_LIST, TrackerSparqlVariableBindingListClass))

typedef struct _TrackerSparqlVariableBindingList TrackerSparqlVariableBindingList;
typedef struct _TrackerSparqlVariableBindingListClass TrackerSparqlVariableBindingListClass;
typedef struct _TrackerSparqlVariableBindingListPrivate TrackerSparqlVariableBindingListPrivate;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _TrackerSparqlVariablePrivate TrackerSparqlVariablePrivate;

#define TRACKER_SPARQL_TYPE_CONTEXT (tracker_sparql_context_get_type ())
#define TRACKER_SPARQL_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_CONTEXT, TrackerSparqlContext))
#define TRACKER_SPARQL_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_CONTEXT, TrackerSparqlContextClass))
#define TRACKER_SPARQL_IS_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_CONTEXT))
#define TRACKER_SPARQL_IS_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_CONTEXT))
#define TRACKER_SPARQL_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_CONTEXT, TrackerSparqlContextClass))

typedef struct _TrackerSparqlContext TrackerSparqlContext;
typedef struct _TrackerSparqlContextClass TrackerSparqlContextClass;
typedef struct _TrackerSparqlContextPrivate TrackerSparqlContextPrivate;

#define TRACKER_SPARQL_TYPE_QUERY (tracker_sparql_query_get_type ())
#define TRACKER_SPARQL_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_QUERY, TrackerSparqlQuery))
#define TRACKER_SPARQL_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_QUERY, TrackerSparqlQueryClass))
#define TRACKER_SPARQL_IS_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_QUERY))
#define TRACKER_SPARQL_IS_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_QUERY))
#define TRACKER_SPARQL_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_QUERY, TrackerSparqlQueryClass))

typedef struct _TrackerSparqlQuery TrackerSparqlQuery;
typedef struct _TrackerSparqlQueryClass TrackerSparqlQueryClass;
#define _tracker_sparql_context_unref0(var) ((var == NULL) ? NULL : (var = (tracker_sparql_context_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _TrackerSparqlQueryPrivate TrackerSparqlQueryPrivate;

#define TRACKER_SPARQL_TYPE_EXPRESSION (tracker_sparql_expression_get_type ())
#define TRACKER_SPARQL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_EXPRESSION, TrackerSparqlExpression))
#define TRACKER_SPARQL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_EXPRESSION, TrackerSparqlExpressionClass))
#define TRACKER_SPARQL_IS_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_EXPRESSION))
#define TRACKER_SPARQL_IS_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_EXPRESSION))
#define TRACKER_SPARQL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_EXPRESSION, TrackerSparqlExpressionClass))

typedef struct _TrackerSparqlExpression TrackerSparqlExpression;
typedef struct _TrackerSparqlExpressionClass TrackerSparqlExpressionClass;

#define TRACKER_SPARQL_TYPE_PATTERN (tracker_sparql_pattern_get_type ())
#define TRACKER_SPARQL_PATTERN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_PATTERN, TrackerSparqlPattern))
#define TRACKER_SPARQL_PATTERN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_PATTERN, TrackerSparqlPatternClass))
#define TRACKER_SPARQL_IS_PATTERN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_PATTERN))
#define TRACKER_SPARQL_IS_PATTERN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_PATTERN))
#define TRACKER_SPARQL_PATTERN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_PATTERN, TrackerSparqlPatternClass))

typedef struct _TrackerSparqlPattern TrackerSparqlPattern;
typedef struct _TrackerSparqlPatternClass TrackerSparqlPatternClass;
typedef struct _TrackerSparqlParamSpecContext TrackerSparqlParamSpecContext;

#define TRACKER_SPARQL_TYPE_SELECT_CONTEXT (tracker_sparql_select_context_get_type ())
#define TRACKER_SPARQL_SELECT_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContext))
#define TRACKER_SPARQL_SELECT_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContextClass))
#define TRACKER_SPARQL_IS_SELECT_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_SELECT_CONTEXT))
#define TRACKER_SPARQL_IS_SELECT_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_SELECT_CONTEXT))
#define TRACKER_SPARQL_SELECT_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContextClass))

typedef struct _TrackerSparqlSelectContext TrackerSparqlSelectContext;
typedef struct _TrackerSparqlSelectContextClass TrackerSparqlSelectContextClass;
typedef struct _TrackerSparqlSelectContextPrivate TrackerSparqlSelectContextPrivate;

#define TRACKER_TYPE_SPARQL_SCANNER (tracker_sparql_scanner_get_type ())
#define TRACKER_SPARQL_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_SPARQL_SCANNER, TrackerSparqlScanner))
#define TRACKER_SPARQL_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_SPARQL_SCANNER, TrackerSparqlScannerClass))
#define TRACKER_IS_SPARQL_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_SPARQL_SCANNER))
#define TRACKER_IS_SPARQL_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_SPARQL_SCANNER))
#define TRACKER_SPARQL_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_SPARQL_SCANNER, TrackerSparqlScannerClass))

typedef struct _TrackerSparqlScanner TrackerSparqlScanner;
typedef struct _TrackerSparqlScannerClass TrackerSparqlScannerClass;

#define TRACKER_SPARQL_QUERY_TYPE_TOKEN_INFO (tracker_sparql_query_token_info_get_type ())

#define TRACKER_TYPE_SPARQL_TOKEN_TYPE (tracker_sparql_token_type_get_type ())

#define TRACKER_TYPE_SOURCE_LOCATION (tracker_source_location_get_type ())
typedef struct _TrackerSourceLocation TrackerSourceLocation;
typedef struct _TrackerSparqlQueryTokenInfo TrackerSparqlQueryTokenInfo;
#define _g_checksum_free0(var) ((var == NULL) ? NULL : (var = (g_checksum_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_builder_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _TrackerSparqlPatternPrivate TrackerSparqlPatternPrivate;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

typedef enum  {
	TRACKER_SPARQL_VARIABLE_STATE_NONE,
	TRACKER_SPARQL_VARIABLE_STATE_BOUND,
	TRACKER_SPARQL_VARIABLE_STATE_OPTIONAL
} TrackerSparqlVariableState;

struct _TrackerSparqlDataTable {
	GObject parent_instance;
	TrackerSparqlDataTablePrivate * priv;
	gchar* sql_db_tablename;
	gchar* sql_query_tablename;
	TrackerSparqlPredicateVariable* predicate_variable;
};

struct _TrackerSparqlDataTableClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlDataBinding {
	GObject parent_instance;
	TrackerSparqlDataBindingPrivate * priv;
	TrackerPropertyType data_type;
	TrackerSparqlDataTable* table;
	gchar* sql_db_column_name;
};

struct _TrackerSparqlDataBindingClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlDataBindingPrivate {
	gchar* _sql_expression;
};

struct _TrackerSparqlLiteralBinding {
	TrackerSparqlDataBinding parent_instance;
	TrackerSparqlLiteralBindingPrivate * priv;
	gboolean is_fts_match;
	gchar* literal;
};

struct _TrackerSparqlLiteralBindingClass {
	TrackerSparqlDataBindingClass parent_class;
};

struct _TrackerSparqlVariableBinding {
	TrackerSparqlDataBinding parent_instance;
	TrackerSparqlVariableBindingPrivate * priv;
	TrackerSparqlVariable* variable;
	gboolean maybe_null;
	gboolean in_simple_optional;
	TrackerClass* type;
};

struct _TrackerSparqlVariableBindingClass {
	TrackerSparqlDataBindingClass parent_class;
};

struct _TrackerSparqlVariableBindingList {
	GObject parent_instance;
	TrackerSparqlVariableBindingListPrivate * priv;
	GList* list;
};

struct _TrackerSparqlVariableBindingListClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlVariable {
	GObject parent_instance;
	TrackerSparqlVariablePrivate * priv;
	TrackerSparqlVariableBinding* binding;
};

struct _TrackerSparqlVariableClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlVariablePrivate {
	gchar* _name;
	gint _index;
	gchar* _sql_expression;
	gchar* sql_identifier;
};

struct _TrackerSparqlContext {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TrackerSparqlContextPrivate * priv;
	TrackerSparqlQuery* query;
	TrackerSparqlContext* parent_context;
	GHashTable* var_set;
	GHashTable* var_map;
	GHashTable* select_var_set;
	GHashTable* predicate_variable_map;
	gboolean scalar_subquery;
};

struct _TrackerSparqlContextClass {
	GTypeClass parent_class;
	void (*finalize) (TrackerSparqlContext *self);
};

struct _TrackerSparqlQuery {
	GObject parent_instance;
	TrackerSparqlQueryPrivate * priv;
	TrackerSparqlExpression* expression;
	TrackerSparqlPattern* pattern;
	GList* bindings;
	TrackerSparqlContext* context;
	gint last_var_index;
};

struct _TrackerSparqlQueryClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlParamSpecContext {
	GParamSpec parent_instance;
};

struct _TrackerSparqlSelectContext {
	TrackerSparqlContext parent_instance;
	TrackerSparqlSelectContextPrivate * priv;
	TrackerPropertyType type;
	TrackerPropertyType* types;
	gint types_length1;
	gint _types_size_;
	gchar** variable_names;
	gint variable_names_length1;
	gint _variable_names_size_;
};

struct _TrackerSparqlSelectContextClass {
	TrackerSparqlContextClass parent_class;
};

typedef enum  {
	TRACKER_SPARQL_TOKEN_TYPE_NONE,
	TRACKER_SPARQL_TOKEN_TYPE_A,
	TRACKER_SPARQL_TOKEN_TYPE_AS,
	TRACKER_SPARQL_TOKEN_TYPE_ASC,
	TRACKER_SPARQL_TOKEN_TYPE_ASK,
	TRACKER_SPARQL_TOKEN_TYPE_ATBASE,
	TRACKER_SPARQL_TOKEN_TYPE_ATPREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_AVG,
	TRACKER_SPARQL_TOKEN_TYPE_BASE,
	TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE,
	TRACKER_SPARQL_TOKEN_TYPE_BOUND,
	TRACKER_SPARQL_TOKEN_TYPE_BY,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACKET,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS,
	TRACKER_SPARQL_TOKEN_TYPE_COLON,
	TRACKER_SPARQL_TOKEN_TYPE_COMMA,
	TRACKER_SPARQL_TOKEN_TYPE_CONSTRUCT,
	TRACKER_SPARQL_TOKEN_TYPE_COUNT,
	TRACKER_SPARQL_TOKEN_TYPE_DATA,
	TRACKER_SPARQL_TOKEN_TYPE_DATATYPE,
	TRACKER_SPARQL_TOKEN_TYPE_DECIMAL,
	TRACKER_SPARQL_TOKEN_TYPE_DELETE,
	TRACKER_SPARQL_TOKEN_TYPE_DESC,
	TRACKER_SPARQL_TOKEN_TYPE_DESCRIBE,
	TRACKER_SPARQL_TOKEN_TYPE_DISTINCT,
	TRACKER_SPARQL_TOKEN_TYPE_DIV,
	TRACKER_SPARQL_TOKEN_TYPE_DOT,
	TRACKER_SPARQL_TOKEN_TYPE_DOUBLE,
	TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX,
	TRACKER_SPARQL_TOKEN_TYPE_DROP,
	TRACKER_SPARQL_TOKEN_TYPE_EOF,
	TRACKER_SPARQL_TOKEN_TYPE_EXISTS,
	TRACKER_SPARQL_TOKEN_TYPE_FALSE,
	TRACKER_SPARQL_TOKEN_TYPE_FILTER,
	TRACKER_SPARQL_TOKEN_TYPE_FROM,
	TRACKER_SPARQL_TOKEN_TYPE_GRAPH,
	TRACKER_SPARQL_TOKEN_TYPE_GROUP,
	TRACKER_SPARQL_TOKEN_TYPE_GROUP_CONCAT,
	TRACKER_SPARQL_TOKEN_TYPE_IF,
	TRACKER_SPARQL_TOKEN_TYPE_INSERT,
	TRACKER_SPARQL_TOKEN_TYPE_INTEGER,
	TRACKER_SPARQL_TOKEN_TYPE_INTO,
	TRACKER_SPARQL_TOKEN_TYPE_IRI_REF,
	TRACKER_SPARQL_TOKEN_TYPE_ISBLANK,
	TRACKER_SPARQL_TOKEN_TYPE_ISIRI,
	TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL,
	TRACKER_SPARQL_TOKEN_TYPE_ISURI,
	TRACKER_SPARQL_TOKEN_TYPE_LANG,
	TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES,
	TRACKER_SPARQL_TOKEN_TYPE_LIMIT,
	TRACKER_SPARQL_TOKEN_TYPE_MAX,
	TRACKER_SPARQL_TOKEN_TYPE_MIN,
	TRACKER_SPARQL_TOKEN_TYPE_MINUS,
	TRACKER_SPARQL_TOKEN_TYPE_NAMED,
	TRACKER_SPARQL_TOKEN_TYPE_NOT,
	TRACKER_SPARQL_TOKEN_TYPE_OFFSET,
	TRACKER_SPARQL_TOKEN_TYPE_OP_AND,
	TRACKER_SPARQL_TOKEN_TYPE_OP_EQ,
	TRACKER_SPARQL_TOKEN_TYPE_OP_GE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_GT,
	TRACKER_SPARQL_TOKEN_TYPE_OP_LE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_LT,
	TRACKER_SPARQL_TOKEN_TYPE_OP_NE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_NEG,
	TRACKER_SPARQL_TOKEN_TYPE_OP_OR,
	TRACKER_SPARQL_TOKEN_TYPE_OP_IN,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS,
	TRACKER_SPARQL_TOKEN_TYPE_OPTIONAL,
	TRACKER_SPARQL_TOKEN_TYPE_ORDER,
	TRACKER_SPARQL_TOKEN_TYPE_PLUS,
	TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_PREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_REDUCED,
	TRACKER_SPARQL_TOKEN_TYPE_REGEX,
	TRACKER_SPARQL_TOKEN_TYPE_SAMETERM,
	TRACKER_SPARQL_TOKEN_TYPE_SELECT,
	TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON,
	TRACKER_SPARQL_TOKEN_TYPE_SILENT,
	TRACKER_SPARQL_TOKEN_TYPE_STAR,
	TRACKER_SPARQL_TOKEN_TYPE_STR,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2,
	TRACKER_SPARQL_TOKEN_TYPE_SUM,
	TRACKER_SPARQL_TOKEN_TYPE_TRUE,
	TRACKER_SPARQL_TOKEN_TYPE_UNION,
	TRACKER_SPARQL_TOKEN_TYPE_VAR,
	TRACKER_SPARQL_TOKEN_TYPE_WHERE,
	TRACKER_SPARQL_TOKEN_TYPE_WITH
} TrackerSparqlTokenType;

struct _TrackerSourceLocation {
	gchar* pos;
	gint line;
	gint column;
};

struct _TrackerSparqlQueryTokenInfo {
	TrackerSparqlTokenType type;
	TrackerSourceLocation begin;
	TrackerSourceLocation end;
};

struct _TrackerSparqlQueryPrivate {
	TrackerSparqlScanner* scanner;
	TrackerSparqlQueryTokenInfo* tokens;
	gint tokens_length1;
	gint _tokens_size_;
	gint index;
	gint size;
	gchar* query_string;
	gboolean update_extensions;
	gchar* current_graph;
	gchar* current_subject;
	gboolean current_subject_is_var;
	gchar* current_predicate;
	gboolean current_predicate_is_var;
	gboolean silent;
	GHashTable* prefix_map;
	gboolean delete_statements;
	gint bnodeid;
	guchar* base_uuid;
	gint base_uuid_length1;
	gint _base_uuid_size_;
	GHashTable* blank_nodes;
	gboolean _no_cache;
	gboolean anon_blank_node_open;
};

struct _TrackerSparqlPattern {
	GObject parent_instance;
	TrackerSparqlPatternPrivate * priv;
	gchar* current_graph;
};

struct _TrackerSparqlPatternClass {
	GObjectClass parent_class;
};


static gpointer tracker_sparql_data_table_parent_class = NULL;
static gpointer tracker_sparql_data_binding_parent_class = NULL;
static gpointer tracker_sparql_literal_binding_parent_class = NULL;
static gpointer tracker_sparql_variable_binding_parent_class = NULL;
static gpointer tracker_sparql_variable_binding_list_parent_class = NULL;
static gpointer tracker_sparql_variable_parent_class = NULL;
static gpointer tracker_sparql_context_parent_class = NULL;
static gpointer tracker_sparql_select_context_parent_class = NULL;
static gpointer tracker_sparql_query_parent_class = NULL;

GType tracker_sparql_variable_state_get_type (void) G_GNUC_CONST;
GType tracker_sparql_data_table_get_type (void) G_GNUC_CONST;
GType tracker_sparql_predicate_variable_get_type (void) G_GNUC_CONST;
enum  {
	TRACKER_SPARQL_DATA_TABLE_DUMMY_PROPERTY
};
TrackerSparqlDataTable* tracker_sparql_data_table_new (void);
TrackerSparqlDataTable* tracker_sparql_data_table_construct (GType object_type);
static void tracker_sparql_data_table_finalize (GObject* obj);
GType tracker_sparql_data_binding_get_type (void) G_GNUC_CONST;
#define TRACKER_SPARQL_DATA_BINDING_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_SPARQL_TYPE_DATA_BINDING, TrackerSparqlDataBindingPrivate))
enum  {
	TRACKER_SPARQL_DATA_BINDING_DUMMY_PROPERTY,
	TRACKER_SPARQL_DATA_BINDING_SQL_EXPRESSION
};
gchar* tracker_sparql_data_binding_get_extra_sql_expression (TrackerSparqlDataBinding* self, const gchar* suffix);
TrackerSparqlDataBinding* tracker_sparql_data_binding_construct (GType object_type);
const gchar* tracker_sparql_data_binding_get_sql_expression (TrackerSparqlDataBinding* self);
void tracker_sparql_data_binding_set_sql_expression (TrackerSparqlDataBinding* self, const gchar* value);
static void tracker_sparql_data_binding_finalize (GObject* obj);
static void _vala_tracker_sparql_data_binding_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_tracker_sparql_data_binding_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType tracker_sparql_literal_binding_get_type (void) G_GNUC_CONST;
enum  {
	TRACKER_SPARQL_LITERAL_BINDING_DUMMY_PROPERTY
};
TrackerSparqlLiteralBinding* tracker_sparql_literal_binding_new (void);
TrackerSparqlLiteralBinding* tracker_sparql_literal_binding_construct (GType object_type);
static void tracker_sparql_literal_binding_finalize (GObject* obj);
GType tracker_sparql_variable_binding_get_type (void) G_GNUC_CONST;
GType tracker_sparql_variable_get_type (void) G_GNUC_CONST;
enum  {
	TRACKER_SPARQL_VARIABLE_BINDING_DUMMY_PROPERTY
};
TrackerSparqlVariableBinding* tracker_sparql_variable_binding_new (void);
TrackerSparqlVariableBinding* tracker_sparql_variable_binding_construct (GType object_type);
static void tracker_sparql_variable_binding_finalize (GObject* obj);
GType tracker_sparql_variable_binding_list_get_type (void) G_GNUC_CONST;
enum  {
	TRACKER_SPARQL_VARIABLE_BINDING_LIST_DUMMY_PROPERTY
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
TrackerSparqlVariableBindingList* tracker_sparql_variable_binding_list_new (void);
TrackerSparqlVariableBindingList* tracker_sparql_variable_binding_list_construct (GType object_type);
static void tracker_sparql_variable_binding_list_finalize (GObject* obj);
#define TRACKER_SPARQL_VARIABLE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_SPARQL_TYPE_VARIABLE, TrackerSparqlVariablePrivate))
enum  {
	TRACKER_SPARQL_VARIABLE_DUMMY_PROPERTY,
	TRACKER_SPARQL_VARIABLE_NAME,
	TRACKER_SPARQL_VARIABLE_INDEX,
	TRACKER_SPARQL_VARIABLE_SQL_EXPRESSION
};
TrackerSparqlVariable* tracker_sparql_variable_new (const gchar* name, gint index);
TrackerSparqlVariable* tracker_sparql_variable_construct (GType object_type, const gchar* name, gint index);
static void tracker_sparql_variable_set_name (TrackerSparqlVariable* self, const gchar* value);
static void tracker_sparql_variable_set_index (TrackerSparqlVariable* self, gint value);
static void tracker_sparql_variable_set_sql_expression (TrackerSparqlVariable* self, const gchar* value);
gchar* tracker_sparql_variable_get_extra_sql_expression (TrackerSparqlVariable* self, const gchar* suffix);
gboolean tracker_sparql_variable_equal (TrackerSparqlVariable* a, TrackerSparqlVariable* b);
gint tracker_sparql_variable_get_index (TrackerSparqlVariable* self);
guint tracker_sparql_variable_hash (TrackerSparqlVariable* variable);
const gchar* tracker_sparql_variable_get_name (TrackerSparqlVariable* self);
const gchar* tracker_sparql_variable_get_sql_expression (TrackerSparqlVariable* self);
static void tracker_sparql_variable_finalize (GObject* obj);
static void _vala_tracker_sparql_variable_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_tracker_sparql_variable_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
gpointer tracker_sparql_context_ref (gpointer instance);
void tracker_sparql_context_unref (gpointer instance);
GParamSpec* tracker_sparql_param_spec_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void tracker_sparql_value_set_context (GValue* value, gpointer v_object);
void tracker_sparql_value_take_context (GValue* value, gpointer v_object);
gpointer tracker_sparql_value_get_context (const GValue* value);
GType tracker_sparql_context_get_type (void) G_GNUC_CONST;
GType tracker_sparql_query_get_type (void) G_GNUC_CONST;
enum  {
	TRACKER_SPARQL_CONTEXT_DUMMY_PROPERTY
};
TrackerSparqlContext* tracker_sparql_context_new (TrackerSparqlQuery* query, TrackerSparqlContext* parent_context);
TrackerSparqlContext* tracker_sparql_context_construct (GType object_type, TrackerSparqlQuery* query, TrackerSparqlContext* parent_context);
static guint _tracker_sparql_variable_hash_ghash_func (gconstpointer key);
static gboolean _tracker_sparql_variable_equal_gequal_func (gconstpointer a, gconstpointer b);
TrackerSparqlContext* tracker_sparql_context_new_subquery (TrackerSparqlQuery* query, TrackerSparqlContext* parent_context);
TrackerSparqlContext* tracker_sparql_context_construct_subquery (GType object_type, TrackerSparqlQuery* query, TrackerSparqlContext* parent_context);
TrackerSparqlVariable* tracker_sparql_context_get_variable (TrackerSparqlContext* self, const gchar* name);
GType tracker_sparql_expression_get_type (void) G_GNUC_CONST;
GType tracker_sparql_pattern_get_type (void) G_GNUC_CONST;
static void tracker_sparql_context_finalize (TrackerSparqlContext* obj);
GType tracker_sparql_select_context_get_type (void) G_GNUC_CONST;
enum  {
	TRACKER_SPARQL_SELECT_CONTEXT_DUMMY_PROPERTY
};
TrackerSparqlSelectContext* tracker_sparql_select_context_new (TrackerSparqlQuery* query, TrackerSparqlContext* parent_context);
TrackerSparqlSelectContext* tracker_sparql_select_context_construct (GType object_type, TrackerSparqlQuery* query, TrackerSparqlContext* parent_context);
TrackerSparqlSelectContext* tracker_sparql_select_context_new_subquery (TrackerSparqlQuery* query, TrackerSparqlContext* parent_context);
TrackerSparqlSelectContext* tracker_sparql_select_context_construct_subquery (GType object_type, TrackerSparqlQuery* query, TrackerSparqlContext* parent_context);
static void tracker_sparql_select_context_finalize (TrackerSparqlContext* obj);
GType tracker_sparql_scanner_get_type (void) G_GNUC_CONST;
static GType tracker_sparql_query_token_info_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
GType tracker_sparql_token_type_get_type (void) G_GNUC_CONST;
GType tracker_source_location_get_type (void) G_GNUC_CONST;
TrackerSourceLocation* tracker_source_location_dup (const TrackerSourceLocation* self);
void tracker_source_location_free (TrackerSourceLocation* self);
static TrackerSparqlQueryTokenInfo* tracker_sparql_query_token_info_dup (const TrackerSparqlQueryTokenInfo* self);
static void tracker_sparql_query_token_info_free (TrackerSparqlQueryTokenInfo* self);
#define TRACKER_SPARQL_QUERY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_SPARQL_TYPE_QUERY, TrackerSparqlQueryPrivate))
enum  {
	TRACKER_SPARQL_QUERY_DUMMY_PROPERTY,
	TRACKER_SPARQL_QUERY_NO_CACHE
};
#define TRACKER_SPARQL_QUERY_BUFFER_SIZE 32
#define TRACKER_SPARQL_QUERY_FN_NS "http://www.w3.org/2005/xpath-functions#"
TrackerSparqlQuery* tracker_sparql_query_new (const gchar* query);
TrackerSparqlQuery* tracker_sparql_query_construct (GType object_type, const gchar* query);
void tracker_sparql_query_set_no_cache (TrackerSparqlQuery* self, gboolean value);
void uuid_generate (guchar* uuid);
TrackerSparqlExpression* tracker_sparql_expression_new (TrackerSparqlQuery* query);
TrackerSparqlExpression* tracker_sparql_expression_construct (GType object_type, TrackerSparqlQuery* query);
TrackerSparqlPattern* tracker_sparql_pattern_new (TrackerSparqlQuery* query);
TrackerSparqlPattern* tracker_sparql_pattern_construct (GType object_type, TrackerSparqlQuery* query);
TrackerSparqlQuery* tracker_sparql_query_new_update (const gchar* query);
TrackerSparqlQuery* tracker_sparql_query_construct_update (GType object_type, const gchar* query);
static gchar* tracker_sparql_query_get_uuid_for_name (TrackerSparqlQuery* self, guchar* base_uuid, int base_uuid_length1, const gchar* name);
gchar* tracker_sparql_query_generate_bnodeid (TrackerSparqlQuery* self, const gchar* user_bnodeid);
gboolean tracker_sparql_query_next (TrackerSparqlQuery* self, GError** error);
TrackerSparqlTokenType tracker_sparql_scanner_read_token (TrackerSparqlScanner* self, TrackerSourceLocation* token_begin, TrackerSourceLocation* token_end, GError** error);
TrackerSparqlTokenType tracker_sparql_query_current (TrackerSparqlQuery* self);
TrackerSparqlTokenType tracker_sparql_query_last (TrackerSparqlQuery* self);
gboolean tracker_sparql_query_accept (TrackerSparqlQuery* self, TrackerSparqlTokenType type, GError** error);
GError* tracker_sparql_query_get_error (TrackerSparqlQuery* self, const gchar* msg);
GError* tracker_sparql_query_get_internal_error (TrackerSparqlQuery* self, const gchar* msg);
gboolean tracker_sparql_query_expect (TrackerSparqlQuery* self, TrackerSparqlTokenType type, GError** error);
const gchar* tracker_sparql_token_type_to_string (TrackerSparqlTokenType self);
void tracker_sparql_query_get_location (TrackerSparqlQuery* self, TrackerSourceLocation* result);
void tracker_sparql_query_set_location (TrackerSparqlQuery* self, TrackerSourceLocation* location);
void tracker_sparql_scanner_seek (TrackerSparqlScanner* self, TrackerSourceLocation* location);
gchar* tracker_sparql_query_get_last_string (TrackerSparqlQuery* self, gint strip);
static void tracker_sparql_query_parse_prologue (TrackerSparqlQuery* self, GError** error);
static void tracker_sparql_query_prepare_execute (TrackerSparqlQuery* self, GError** error);
TrackerSparqlScanner* tracker_sparql_scanner_new (gchar* input, gsize len);
TrackerSparqlScanner* tracker_sparql_scanner_construct (GType object_type, gchar* input, gsize len);
TrackerDBCursor* tracker_sparql_query_execute_cursor (TrackerSparqlQuery* self, gboolean threadsafe, GError** error);
static TrackerDBCursor* tracker_sparql_query_execute_select_cursor (TrackerSparqlQuery* self, gboolean threadsafe, GError** error);
static TrackerDBCursor* tracker_sparql_query_execute_ask_cursor (TrackerSparqlQuery* self, gboolean threadsafe, GError** error);
GVariant* tracker_sparql_query_execute_update (TrackerSparqlQuery* self, gboolean blank, GError** error);
static void tracker_sparql_query_execute_insert_or_delete (TrackerSparqlQuery* self, GVariantBuilder* update_blank_nodes, GError** error);
static TrackerDBStatement* tracker_sparql_query_prepare_for_exec (TrackerSparqlQuery* self, const gchar* sql, GError** error);
gboolean tracker_sparql_query_get_no_cache (TrackerSparqlQuery* self);
static TrackerDBCursor* tracker_sparql_query_exec_sql_cursor (TrackerSparqlQuery* self, const gchar* sql, TrackerPropertyType* types, int types_length1, gchar** variable_names, int variable_names_length1, gboolean threadsafe, GError** error);
static gchar* tracker_sparql_query_get_select_query (TrackerSparqlQuery* self, TrackerSparqlSelectContext** context, GError** error);
TrackerSparqlSelectContext* tracker_sparql_pattern_translate_select (TrackerSparqlPattern* self, GString* sql, gboolean subquery, gboolean scalar_subquery, GError** error);
static gchar* tracker_sparql_query_get_ask_query (TrackerSparqlQuery* self, GError** error);
TrackerSparqlContext* tracker_sparql_pattern_translate_group_graph_pattern (TrackerSparqlPattern* self, GString* sql, GError** error);
static void tracker_sparql_query_parse_from_or_into_param (TrackerSparqlQuery* self, GError** error);
gchar* tracker_sparql_query_resolve_prefixed_name (TrackerSparqlQuery* self, const gchar* prefix, const gchar* local_name, GError** error);
static void tracker_sparql_query_skip_braces (TrackerSparqlQuery* self, GError** error);
void tracker_sparql_expression_append_expression_as_string (GString* sql, const gchar* expression, TrackerPropertyType type);
static void tracker_sparql_query_parse_construct_triples_block (TrackerSparqlQuery* self, GHashTable* var_value_map, GError** error);
static GVariant* _variant_new1 (GHashTable* value);
static gchar* tracker_sparql_query_parse_construct_var_or_term (TrackerSparqlQuery* self, GHashTable* var_value_map, GError** error);
static void tracker_sparql_query_parse_construct_property_list_not_empty (TrackerSparqlQuery* self, GHashTable* var_value_map, GError** error);
gchar* tracker_sparql_expression_parse_string_literal (TrackerSparqlExpression* self, TrackerPropertyType* type, GError** error);
static void tracker_sparql_query_parse_construct_object_list (TrackerSparqlQuery* self, GHashTable* var_value_map, GError** error);
static void tracker_sparql_query_parse_construct_object (TrackerSparqlQuery* self, GHashTable* var_value_map, GError** error);
static void tracker_sparql_query_finalize (GObject* obj);
static void _vala_tracker_sparql_query_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_tracker_sparql_query_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GType tracker_sparql_variable_state_get_type (void) {
	static volatile gsize tracker_sparql_variable_state_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_variable_state_type_id__volatile)) {
		static const GEnumValue values[] = {{TRACKER_SPARQL_VARIABLE_STATE_NONE, "TRACKER_SPARQL_VARIABLE_STATE_NONE", "none"}, {TRACKER_SPARQL_VARIABLE_STATE_BOUND, "TRACKER_SPARQL_VARIABLE_STATE_BOUND", "bound"}, {TRACKER_SPARQL_VARIABLE_STATE_OPTIONAL, "TRACKER_SPARQL_VARIABLE_STATE_OPTIONAL", "optional"}, {0, NULL, NULL}};
		GType tracker_sparql_variable_state_type_id;
		tracker_sparql_variable_state_type_id = g_enum_register_static ("TrackerSparqlVariableState", values);
		g_once_init_leave (&tracker_sparql_variable_state_type_id__volatile, tracker_sparql_variable_state_type_id);
	}
	return tracker_sparql_variable_state_type_id__volatile;
}


TrackerSparqlDataTable* tracker_sparql_data_table_construct (GType object_type) {
	TrackerSparqlDataTable * self = NULL;
	self = (TrackerSparqlDataTable*) g_object_new (object_type, NULL);
	return self;
}


TrackerSparqlDataTable* tracker_sparql_data_table_new (void) {
	return tracker_sparql_data_table_construct (TRACKER_SPARQL_TYPE_DATA_TABLE);
}


static void tracker_sparql_data_table_class_init (TrackerSparqlDataTableClass * klass) {
	tracker_sparql_data_table_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_data_table_finalize;
}


static void tracker_sparql_data_table_instance_init (TrackerSparqlDataTable * self) {
}


static void tracker_sparql_data_table_finalize (GObject* obj) {
	TrackerSparqlDataTable * self;
	self = TRACKER_SPARQL_DATA_TABLE (obj);
	_g_free0 (self->sql_db_tablename);
	_g_free0 (self->sql_query_tablename);
	_g_object_unref0 (self->predicate_variable);
	G_OBJECT_CLASS (tracker_sparql_data_table_parent_class)->finalize (obj);
}


GType tracker_sparql_data_table_get_type (void) {
	static volatile gsize tracker_sparql_data_table_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_data_table_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlDataTableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_data_table_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlDataTable), 0, (GInstanceInitFunc) tracker_sparql_data_table_instance_init, NULL };
		GType tracker_sparql_data_table_type_id;
		tracker_sparql_data_table_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerSparqlDataTable", &g_define_type_info, 0);
		g_once_init_leave (&tracker_sparql_data_table_type_id__volatile, tracker_sparql_data_table_type_id);
	}
	return tracker_sparql_data_table_type_id__volatile;
}


gchar* tracker_sparql_data_binding_get_extra_sql_expression (TrackerSparqlDataBinding* self, const gchar* suffix) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (suffix != NULL, NULL);
	_tmp0_ = g_strdup_printf ("\"%s\".\"%s:%s\"", self->table->sql_query_tablename, self->sql_db_column_name, suffix);
	result = _tmp0_;
	return result;
}


TrackerSparqlDataBinding* tracker_sparql_data_binding_construct (GType object_type) {
	TrackerSparqlDataBinding * self = NULL;
	self = (TrackerSparqlDataBinding*) g_object_new (object_type, NULL);
	return self;
}


const gchar* tracker_sparql_data_binding_get_sql_expression (TrackerSparqlDataBinding* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->_sql_expression == NULL) {
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		_tmp0_ = g_strdup_printf ("\"%s\".\"%s\"", self->table->sql_query_tablename, self->sql_db_column_name);
		_tmp1_ = _tmp0_;
		_g_free0 (self->priv->_sql_expression);
		self->priv->_sql_expression = _tmp1_;
	}
	result = self->priv->_sql_expression;
	return result;
}


void tracker_sparql_data_binding_set_sql_expression (TrackerSparqlDataBinding* self, const gchar* value) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_sql_expression);
	self->priv->_sql_expression = _tmp1_;
	g_object_notify ((GObject *) self, "sql-expression");
}


static void tracker_sparql_data_binding_class_init (TrackerSparqlDataBindingClass * klass) {
	tracker_sparql_data_binding_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TrackerSparqlDataBindingPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_tracker_sparql_data_binding_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_tracker_sparql_data_binding_set_property;
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_data_binding_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_SPARQL_DATA_BINDING_SQL_EXPRESSION, g_param_spec_string ("sql-expression", "sql-expression", "sql-expression", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void tracker_sparql_data_binding_instance_init (TrackerSparqlDataBinding * self) {
	self->priv = TRACKER_SPARQL_DATA_BINDING_GET_PRIVATE (self);
}


static void tracker_sparql_data_binding_finalize (GObject* obj) {
	TrackerSparqlDataBinding * self;
	self = TRACKER_SPARQL_DATA_BINDING (obj);
	_g_object_unref0 (self->table);
	_g_free0 (self->sql_db_column_name);
	_g_free0 (self->priv->_sql_expression);
	G_OBJECT_CLASS (tracker_sparql_data_binding_parent_class)->finalize (obj);
}


GType tracker_sparql_data_binding_get_type (void) {
	static volatile gsize tracker_sparql_data_binding_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_data_binding_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlDataBindingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_data_binding_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlDataBinding), 0, (GInstanceInitFunc) tracker_sparql_data_binding_instance_init, NULL };
		GType tracker_sparql_data_binding_type_id;
		tracker_sparql_data_binding_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerSparqlDataBinding", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&tracker_sparql_data_binding_type_id__volatile, tracker_sparql_data_binding_type_id);
	}
	return tracker_sparql_data_binding_type_id__volatile;
}


static void _vala_tracker_sparql_data_binding_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TrackerSparqlDataBinding * self;
	self = TRACKER_SPARQL_DATA_BINDING (object);
	switch (property_id) {
		case TRACKER_SPARQL_DATA_BINDING_SQL_EXPRESSION:
		g_value_set_string (value, tracker_sparql_data_binding_get_sql_expression (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_tracker_sparql_data_binding_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TrackerSparqlDataBinding * self;
	self = TRACKER_SPARQL_DATA_BINDING (object);
	switch (property_id) {
		case TRACKER_SPARQL_DATA_BINDING_SQL_EXPRESSION:
		tracker_sparql_data_binding_set_sql_expression (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


TrackerSparqlLiteralBinding* tracker_sparql_literal_binding_construct (GType object_type) {
	TrackerSparqlLiteralBinding * self = NULL;
	self = (TrackerSparqlLiteralBinding*) tracker_sparql_data_binding_construct (object_type);
	return self;
}


TrackerSparqlLiteralBinding* tracker_sparql_literal_binding_new (void) {
	return tracker_sparql_literal_binding_construct (TRACKER_SPARQL_TYPE_LITERAL_BINDING);
}


static void tracker_sparql_literal_binding_class_init (TrackerSparqlLiteralBindingClass * klass) {
	tracker_sparql_literal_binding_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_literal_binding_finalize;
}


static void tracker_sparql_literal_binding_instance_init (TrackerSparqlLiteralBinding * self) {
}


static void tracker_sparql_literal_binding_finalize (GObject* obj) {
	TrackerSparqlLiteralBinding * self;
	self = TRACKER_SPARQL_LITERAL_BINDING (obj);
	_g_free0 (self->literal);
	G_OBJECT_CLASS (tracker_sparql_literal_binding_parent_class)->finalize (obj);
}


GType tracker_sparql_literal_binding_get_type (void) {
	static volatile gsize tracker_sparql_literal_binding_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_literal_binding_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlLiteralBindingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_literal_binding_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlLiteralBinding), 0, (GInstanceInitFunc) tracker_sparql_literal_binding_instance_init, NULL };
		GType tracker_sparql_literal_binding_type_id;
		tracker_sparql_literal_binding_type_id = g_type_register_static (TRACKER_SPARQL_TYPE_DATA_BINDING, "TrackerSparqlLiteralBinding", &g_define_type_info, 0);
		g_once_init_leave (&tracker_sparql_literal_binding_type_id__volatile, tracker_sparql_literal_binding_type_id);
	}
	return tracker_sparql_literal_binding_type_id__volatile;
}


TrackerSparqlVariableBinding* tracker_sparql_variable_binding_construct (GType object_type) {
	TrackerSparqlVariableBinding * self = NULL;
	self = (TrackerSparqlVariableBinding*) tracker_sparql_data_binding_construct (object_type);
	return self;
}


TrackerSparqlVariableBinding* tracker_sparql_variable_binding_new (void) {
	return tracker_sparql_variable_binding_construct (TRACKER_SPARQL_TYPE_VARIABLE_BINDING);
}


static void tracker_sparql_variable_binding_class_init (TrackerSparqlVariableBindingClass * klass) {
	tracker_sparql_variable_binding_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_variable_binding_finalize;
}


static void tracker_sparql_variable_binding_instance_init (TrackerSparqlVariableBinding * self) {
}


static void tracker_sparql_variable_binding_finalize (GObject* obj) {
	TrackerSparqlVariableBinding * self;
	self = TRACKER_SPARQL_VARIABLE_BINDING (obj);
	_g_object_unref0 (self->type);
	G_OBJECT_CLASS (tracker_sparql_variable_binding_parent_class)->finalize (obj);
}


GType tracker_sparql_variable_binding_get_type (void) {
	static volatile gsize tracker_sparql_variable_binding_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_variable_binding_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlVariableBindingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_variable_binding_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlVariableBinding), 0, (GInstanceInitFunc) tracker_sparql_variable_binding_instance_init, NULL };
		GType tracker_sparql_variable_binding_type_id;
		tracker_sparql_variable_binding_type_id = g_type_register_static (TRACKER_SPARQL_TYPE_DATA_BINDING, "TrackerSparqlVariableBinding", &g_define_type_info, 0);
		g_once_init_leave (&tracker_sparql_variable_binding_type_id__volatile, tracker_sparql_variable_binding_type_id);
	}
	return tracker_sparql_variable_binding_type_id__volatile;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


TrackerSparqlVariableBindingList* tracker_sparql_variable_binding_list_construct (GType object_type) {
	TrackerSparqlVariableBindingList * self = NULL;
	self = (TrackerSparqlVariableBindingList*) g_object_new (object_type, NULL);
	return self;
}


TrackerSparqlVariableBindingList* tracker_sparql_variable_binding_list_new (void) {
	return tracker_sparql_variable_binding_list_construct (TRACKER_SPARQL_TYPE_VARIABLE_BINDING_LIST);
}


static void tracker_sparql_variable_binding_list_class_init (TrackerSparqlVariableBindingListClass * klass) {
	tracker_sparql_variable_binding_list_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_variable_binding_list_finalize;
}


static void tracker_sparql_variable_binding_list_instance_init (TrackerSparqlVariableBindingList * self) {
}


static void tracker_sparql_variable_binding_list_finalize (GObject* obj) {
	TrackerSparqlVariableBindingList * self;
	self = TRACKER_SPARQL_VARIABLE_BINDING_LIST (obj);
	__g_list_free__g_object_unref0_0 (self->list);
	G_OBJECT_CLASS (tracker_sparql_variable_binding_list_parent_class)->finalize (obj);
}


GType tracker_sparql_variable_binding_list_get_type (void) {
	static volatile gsize tracker_sparql_variable_binding_list_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_variable_binding_list_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlVariableBindingListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_variable_binding_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlVariableBindingList), 0, (GInstanceInitFunc) tracker_sparql_variable_binding_list_instance_init, NULL };
		GType tracker_sparql_variable_binding_list_type_id;
		tracker_sparql_variable_binding_list_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerSparqlVariableBindingList", &g_define_type_info, 0);
		g_once_init_leave (&tracker_sparql_variable_binding_list_type_id__volatile, tracker_sparql_variable_binding_list_type_id);
	}
	return tracker_sparql_variable_binding_list_type_id__volatile;
}


TrackerSparqlVariable* tracker_sparql_variable_construct (GType object_type, const gchar* name, gint index) {
	TrackerSparqlVariable * self = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	g_return_val_if_fail (name != NULL, NULL);
	self = (TrackerSparqlVariable*) g_object_new (object_type, NULL);
	tracker_sparql_variable_set_name (self, name);
	tracker_sparql_variable_set_index (self, index);
	_tmp0_ = g_strdup_printf ("%d_u", index);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->sql_identifier);
	self->priv->sql_identifier = _tmp1_;
	_tmp2_ = g_strdup_printf ("\"%s\"", self->priv->sql_identifier);
	_tmp3_ = _tmp2_;
	tracker_sparql_variable_set_sql_expression (self, _tmp3_);
	_g_free0 (_tmp3_);
	return self;
}


TrackerSparqlVariable* tracker_sparql_variable_new (const gchar* name, gint index) {
	return tracker_sparql_variable_construct (TRACKER_SPARQL_TYPE_VARIABLE, name, index);
}


gchar* tracker_sparql_variable_get_extra_sql_expression (TrackerSparqlVariable* self, const gchar* suffix) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (suffix != NULL, NULL);
	_tmp0_ = g_strdup_printf ("\"%s:%s\"", self->priv->sql_identifier, suffix);
	result = _tmp0_;
	return result;
}


gboolean tracker_sparql_variable_equal (TrackerSparqlVariable* a, TrackerSparqlVariable* b) {
	gboolean result = FALSE;
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	result = a->priv->_index == b->priv->_index;
	return result;
}


guint tracker_sparql_variable_hash (TrackerSparqlVariable* variable) {
	guint result = 0U;
	g_return_val_if_fail (variable != NULL, 0U);
	result = (guint) variable->priv->_index;
	return result;
}


const gchar* tracker_sparql_variable_get_name (TrackerSparqlVariable* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_name;
	return result;
}


static void tracker_sparql_variable_set_name (TrackerSparqlVariable* self, const gchar* value) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp1_;
	g_object_notify ((GObject *) self, "name");
}


gint tracker_sparql_variable_get_index (TrackerSparqlVariable* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_index;
	return result;
}


static void tracker_sparql_variable_set_index (TrackerSparqlVariable* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_index = value;
	g_object_notify ((GObject *) self, "index");
}


const gchar* tracker_sparql_variable_get_sql_expression (TrackerSparqlVariable* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_sql_expression;
	return result;
}


static void tracker_sparql_variable_set_sql_expression (TrackerSparqlVariable* self, const gchar* value) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_sql_expression);
	self->priv->_sql_expression = _tmp1_;
	g_object_notify ((GObject *) self, "sql-expression");
}


static void tracker_sparql_variable_class_init (TrackerSparqlVariableClass * klass) {
	tracker_sparql_variable_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TrackerSparqlVariablePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_tracker_sparql_variable_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_tracker_sparql_variable_set_property;
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_variable_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_SPARQL_VARIABLE_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_SPARQL_VARIABLE_INDEX, g_param_spec_int ("index", "index", "index", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_SPARQL_VARIABLE_SQL_EXPRESSION, g_param_spec_string ("sql-expression", "sql-expression", "sql-expression", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void tracker_sparql_variable_instance_init (TrackerSparqlVariable * self) {
	self->priv = TRACKER_SPARQL_VARIABLE_GET_PRIVATE (self);
}


static void tracker_sparql_variable_finalize (GObject* obj) {
	TrackerSparqlVariable * self;
	self = TRACKER_SPARQL_VARIABLE (obj);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_sql_expression);
	_g_object_unref0 (self->binding);
	_g_free0 (self->priv->sql_identifier);
	G_OBJECT_CLASS (tracker_sparql_variable_parent_class)->finalize (obj);
}


GType tracker_sparql_variable_get_type (void) {
	static volatile gsize tracker_sparql_variable_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_variable_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlVariableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_variable_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlVariable), 0, (GInstanceInitFunc) tracker_sparql_variable_instance_init, NULL };
		GType tracker_sparql_variable_type_id;
		tracker_sparql_variable_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerSparqlVariable", &g_define_type_info, 0);
		g_once_init_leave (&tracker_sparql_variable_type_id__volatile, tracker_sparql_variable_type_id);
	}
	return tracker_sparql_variable_type_id__volatile;
}


static void _vala_tracker_sparql_variable_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TrackerSparqlVariable * self;
	self = TRACKER_SPARQL_VARIABLE (object);
	switch (property_id) {
		case TRACKER_SPARQL_VARIABLE_NAME:
		g_value_set_string (value, tracker_sparql_variable_get_name (self));
		break;
		case TRACKER_SPARQL_VARIABLE_INDEX:
		g_value_set_int (value, tracker_sparql_variable_get_index (self));
		break;
		case TRACKER_SPARQL_VARIABLE_SQL_EXPRESSION:
		g_value_set_string (value, tracker_sparql_variable_get_sql_expression (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_tracker_sparql_variable_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TrackerSparqlVariable * self;
	self = TRACKER_SPARQL_VARIABLE (object);
	switch (property_id) {
		case TRACKER_SPARQL_VARIABLE_NAME:
		tracker_sparql_variable_set_name (self, g_value_get_string (value));
		break;
		case TRACKER_SPARQL_VARIABLE_INDEX:
		tracker_sparql_variable_set_index (self, g_value_get_int (value));
		break;
		case TRACKER_SPARQL_VARIABLE_SQL_EXPRESSION:
		tracker_sparql_variable_set_sql_expression (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static gpointer _tracker_sparql_context_ref0 (gpointer self) {
	return self ? tracker_sparql_context_ref (self) : NULL;
}


static guint _tracker_sparql_variable_hash_ghash_func (gconstpointer key) {
	guint result;
	result = tracker_sparql_variable_hash (key);
	return result;
}


static gboolean _tracker_sparql_variable_equal_gequal_func (gconstpointer a, gconstpointer b) {
	gboolean result;
	result = tracker_sparql_variable_equal (a, b);
	return result;
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


TrackerSparqlContext* tracker_sparql_context_construct (GType object_type, TrackerSparqlQuery* query, TrackerSparqlContext* parent_context) {
	TrackerSparqlContext* self = NULL;
	TrackerSparqlContext* _tmp0_;
	TrackerSparqlContext* _tmp1_;
	GHashTable* _tmp2_ = NULL;
	GHashTable* _tmp3_;
	g_return_val_if_fail (query != NULL, NULL);
	self = (TrackerSparqlContext*) g_type_create_instance (object_type);
	self->query = query;
	_tmp0_ = _tracker_sparql_context_ref0 (parent_context);
	_tmp1_ = _tmp0_;
	_tracker_sparql_context_unref0 (self->parent_context);
	self->parent_context = _tmp1_;
	_tmp2_ = g_hash_table_new_full (_tracker_sparql_variable_hash_ghash_func, _tracker_sparql_variable_equal_gequal_func, g_object_unref, NULL);
	_tmp3_ = _tmp2_;
	_g_hash_table_unref0 (self->var_set);
	self->var_set = _tmp3_;
	if (parent_context == NULL) {
		GHashTable* _tmp4_ = NULL;
		GHashTable* _tmp5_;
		GHashTable* _tmp6_ = NULL;
		GHashTable* _tmp7_;
		GHashTable* _tmp8_ = NULL;
		GHashTable* _tmp9_;
		_tmp4_ = g_hash_table_new_full (_tracker_sparql_variable_hash_ghash_func, _tracker_sparql_variable_equal_gequal_func, g_object_unref, NULL);
		_tmp5_ = _tmp4_;
		_g_hash_table_unref0 (self->select_var_set);
		self->select_var_set = _tmp5_;
		_tmp6_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_object_unref);
		_tmp7_ = _tmp6_;
		_g_hash_table_unref0 (self->var_map);
		self->var_map = _tmp7_;
		_tmp8_ = g_hash_table_new_full (_tracker_sparql_variable_hash_ghash_func, _tracker_sparql_variable_equal_gequal_func, g_object_unref, g_object_unref);
		_tmp9_ = _tmp8_;
		_g_hash_table_unref0 (self->predicate_variable_map);
		self->predicate_variable_map = _tmp9_;
	} else {
		GHashTable* _tmp10_;
		GHashTable* _tmp11_;
		GHashTable* _tmp12_;
		GHashTable* _tmp13_;
		GHashTable* _tmp14_;
		GHashTable* _tmp15_;
		_tmp10_ = _g_hash_table_ref0 (parent_context->select_var_set);
		_tmp11_ = _tmp10_;
		_g_hash_table_unref0 (self->select_var_set);
		self->select_var_set = _tmp11_;
		_tmp12_ = _g_hash_table_ref0 (parent_context->var_map);
		_tmp13_ = _tmp12_;
		_g_hash_table_unref0 (self->var_map);
		self->var_map = _tmp13_;
		_tmp14_ = _g_hash_table_ref0 (parent_context->predicate_variable_map);
		_tmp15_ = _tmp14_;
		_g_hash_table_unref0 (self->predicate_variable_map);
		self->predicate_variable_map = _tmp15_;
	}
	return self;
}


TrackerSparqlContext* tracker_sparql_context_new (TrackerSparqlQuery* query, TrackerSparqlContext* parent_context) {
	return tracker_sparql_context_construct (TRACKER_SPARQL_TYPE_CONTEXT, query, parent_context);
}


TrackerSparqlContext* tracker_sparql_context_construct_subquery (GType object_type, TrackerSparqlQuery* query, TrackerSparqlContext* parent_context) {
	TrackerSparqlContext* self = NULL;
	TrackerSparqlContext* _tmp0_;
	TrackerSparqlContext* _tmp1_;
	GHashTable* _tmp2_ = NULL;
	GHashTable* _tmp3_;
	GHashTable* _tmp4_ = NULL;
	GHashTable* _tmp5_;
	GHashTable* _tmp6_;
	GHashTable* _tmp7_;
	GHashTable* _tmp8_ = NULL;
	GHashTable* _tmp9_;
	g_return_val_if_fail (query != NULL, NULL);
	g_return_val_if_fail (parent_context != NULL, NULL);
	self = (TrackerSparqlContext*) g_type_create_instance (object_type);
	self->query = query;
	_tmp0_ = _tracker_sparql_context_ref0 (parent_context);
	_tmp1_ = _tmp0_;
	_tracker_sparql_context_unref0 (self->parent_context);
	self->parent_context = _tmp1_;
	_tmp2_ = g_hash_table_new_full (_tracker_sparql_variable_hash_ghash_func, _tracker_sparql_variable_equal_gequal_func, g_object_unref, NULL);
	_tmp3_ = _tmp2_;
	_g_hash_table_unref0 (self->var_set);
	self->var_set = _tmp3_;
	_tmp4_ = g_hash_table_new_full (_tracker_sparql_variable_hash_ghash_func, _tracker_sparql_variable_equal_gequal_func, g_object_unref, NULL);
	_tmp5_ = _tmp4_;
	_g_hash_table_unref0 (self->select_var_set);
	self->select_var_set = _tmp5_;
	_tmp6_ = _g_hash_table_ref0 (parent_context->var_map);
	_tmp7_ = _tmp6_;
	_g_hash_table_unref0 (self->var_map);
	self->var_map = _tmp7_;
	_tmp8_ = g_hash_table_new_full (_tracker_sparql_variable_hash_ghash_func, _tracker_sparql_variable_equal_gequal_func, g_object_unref, g_object_unref);
	_tmp9_ = _tmp8_;
	_g_hash_table_unref0 (self->predicate_variable_map);
	self->predicate_variable_map = _tmp9_;
	self->scalar_subquery = TRUE;
	return self;
}


TrackerSparqlContext* tracker_sparql_context_new_subquery (TrackerSparqlQuery* query, TrackerSparqlContext* parent_context) {
	return tracker_sparql_context_construct_subquery (TRACKER_SPARQL_TYPE_CONTEXT, query, parent_context);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


TrackerSparqlVariable* tracker_sparql_context_get_variable (TrackerSparqlContext* self, const gchar* name) {
	TrackerSparqlVariable* result = NULL;
	gconstpointer _tmp0_ = NULL;
	TrackerSparqlVariable* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = g_hash_table_lookup (self->var_map, name);
	_result_ = (TrackerSparqlVariable*) _tmp0_;
	if (_result_ == NULL) {
		TrackerSparqlVariable* _tmp1_ = NULL;
		TrackerSparqlVariable* variable;
		gchar* _tmp2_;
		TrackerSparqlVariable* _tmp3_;
		self->query->last_var_index = self->query->last_var_index + 1;
		_tmp1_ = tracker_sparql_variable_new (name, self->query->last_var_index);
		variable = _tmp1_;
		_tmp2_ = g_strdup (name);
		_tmp3_ = _g_object_ref0 (variable);
		g_hash_table_insert (self->var_map, _tmp2_, _tmp3_);
		_result_ = variable;
		_g_object_unref0 (variable);
	}
	result = _result_;
	return result;
}


static void tracker_sparql_value_context_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void tracker_sparql_value_context_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		tracker_sparql_context_unref (value->data[0].v_pointer);
	}
}


static void tracker_sparql_value_context_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = tracker_sparql_context_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer tracker_sparql_value_context_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* tracker_sparql_value_context_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		TrackerSparqlContext* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = tracker_sparql_context_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* tracker_sparql_value_context_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	TrackerSparqlContext** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = tracker_sparql_context_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* tracker_sparql_param_spec_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	TrackerSparqlParamSpecContext* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TRACKER_SPARQL_TYPE_CONTEXT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer tracker_sparql_value_get_context (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_SPARQL_TYPE_CONTEXT), NULL);
	return value->data[0].v_pointer;
}


void tracker_sparql_value_set_context (GValue* value, gpointer v_object) {
	TrackerSparqlContext* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_SPARQL_TYPE_CONTEXT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_SPARQL_TYPE_CONTEXT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		tracker_sparql_context_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tracker_sparql_context_unref (old);
	}
}


void tracker_sparql_value_take_context (GValue* value, gpointer v_object) {
	TrackerSparqlContext* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_SPARQL_TYPE_CONTEXT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_SPARQL_TYPE_CONTEXT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tracker_sparql_context_unref (old);
	}
}


static void tracker_sparql_context_class_init (TrackerSparqlContextClass * klass) {
	tracker_sparql_context_parent_class = g_type_class_peek_parent (klass);
	TRACKER_SPARQL_CONTEXT_CLASS (klass)->finalize = tracker_sparql_context_finalize;
}


static void tracker_sparql_context_instance_init (TrackerSparqlContext * self) {
	self->ref_count = 1;
}


static void tracker_sparql_context_finalize (TrackerSparqlContext* obj) {
	TrackerSparqlContext * self;
	self = TRACKER_SPARQL_CONTEXT (obj);
	_tracker_sparql_context_unref0 (self->parent_context);
	_g_hash_table_unref0 (self->var_set);
	_g_hash_table_unref0 (self->var_map);
	_g_hash_table_unref0 (self->select_var_set);
	_g_hash_table_unref0 (self->predicate_variable_map);
}


GType tracker_sparql_context_get_type (void) {
	static volatile gsize tracker_sparql_context_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_context_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { tracker_sparql_value_context_init, tracker_sparql_value_context_free_value, tracker_sparql_value_context_copy_value, tracker_sparql_value_context_peek_pointer, "p", tracker_sparql_value_context_collect_value, "p", tracker_sparql_value_context_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlContextClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_context_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlContext), 0, (GInstanceInitFunc) tracker_sparql_context_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType tracker_sparql_context_type_id;
		tracker_sparql_context_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TrackerSparqlContext", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&tracker_sparql_context_type_id__volatile, tracker_sparql_context_type_id);
	}
	return tracker_sparql_context_type_id__volatile;
}


gpointer tracker_sparql_context_ref (gpointer instance) {
	TrackerSparqlContext* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void tracker_sparql_context_unref (gpointer instance) {
	TrackerSparqlContext* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		TRACKER_SPARQL_CONTEXT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


TrackerSparqlSelectContext* tracker_sparql_select_context_construct (GType object_type, TrackerSparqlQuery* query, TrackerSparqlContext* parent_context) {
	TrackerSparqlSelectContext* self = NULL;
	g_return_val_if_fail (query != NULL, NULL);
	self = (TrackerSparqlSelectContext*) tracker_sparql_context_construct (object_type, query, parent_context);
	return self;
}


TrackerSparqlSelectContext* tracker_sparql_select_context_new (TrackerSparqlQuery* query, TrackerSparqlContext* parent_context) {
	return tracker_sparql_select_context_construct (TRACKER_SPARQL_TYPE_SELECT_CONTEXT, query, parent_context);
}


TrackerSparqlSelectContext* tracker_sparql_select_context_construct_subquery (GType object_type, TrackerSparqlQuery* query, TrackerSparqlContext* parent_context) {
	TrackerSparqlSelectContext* self = NULL;
	g_return_val_if_fail (query != NULL, NULL);
	g_return_val_if_fail (parent_context != NULL, NULL);
	self = (TrackerSparqlSelectContext*) tracker_sparql_context_construct_subquery (object_type, query, parent_context);
	return self;
}


TrackerSparqlSelectContext* tracker_sparql_select_context_new_subquery (TrackerSparqlQuery* query, TrackerSparqlContext* parent_context) {
	return tracker_sparql_select_context_construct_subquery (TRACKER_SPARQL_TYPE_SELECT_CONTEXT, query, parent_context);
}


static void tracker_sparql_select_context_class_init (TrackerSparqlSelectContextClass * klass) {
	tracker_sparql_select_context_parent_class = g_type_class_peek_parent (klass);
	TRACKER_SPARQL_CONTEXT_CLASS (klass)->finalize = tracker_sparql_select_context_finalize;
}


static void tracker_sparql_select_context_instance_init (TrackerSparqlSelectContext * self) {
	TrackerPropertyType* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	_tmp0_ = g_new0 (TrackerPropertyType, 0);
	self->types = _tmp0_;
	self->types_length1 = 0;
	self->_types_size_ = self->types_length1;
	_tmp1_ = g_new0 (gchar*, 0 + 1);
	self->variable_names = _tmp1_;
	self->variable_names_length1 = 0;
	self->_variable_names_size_ = self->variable_names_length1;
}


static void tracker_sparql_select_context_finalize (TrackerSparqlContext* obj) {
	TrackerSparqlSelectContext * self;
	self = TRACKER_SPARQL_SELECT_CONTEXT (obj);
	self->types = (g_free (self->types), NULL);
	self->variable_names = (_vala_array_free (self->variable_names, self->variable_names_length1, (GDestroyNotify) g_free), NULL);
	TRACKER_SPARQL_CONTEXT_CLASS (tracker_sparql_select_context_parent_class)->finalize (obj);
}


GType tracker_sparql_select_context_get_type (void) {
	static volatile gsize tracker_sparql_select_context_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_select_context_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlSelectContextClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_select_context_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlSelectContext), 0, (GInstanceInitFunc) tracker_sparql_select_context_instance_init, NULL };
		GType tracker_sparql_select_context_type_id;
		tracker_sparql_select_context_type_id = g_type_register_static (TRACKER_SPARQL_TYPE_CONTEXT, "TrackerSparqlSelectContext", &g_define_type_info, 0);
		g_once_init_leave (&tracker_sparql_select_context_type_id__volatile, tracker_sparql_select_context_type_id);
	}
	return tracker_sparql_select_context_type_id__volatile;
}


TrackerSparqlQuery* tracker_sparql_query_construct (GType object_type, const gchar* query) {
	TrackerSparqlQuery * self = NULL;
	TrackerSparqlQueryTokenInfo* _tmp0_ = NULL;
	TrackerSparqlQueryTokenInfo* _tmp1_;
	GHashTable* _tmp2_ = NULL;
	GHashTable* _tmp3_;
	guchar* _tmp4_ = NULL;
	guchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	TrackerSparqlExpression* _tmp8_ = NULL;
	TrackerSparqlExpression* _tmp9_;
	TrackerSparqlPattern* _tmp10_ = NULL;
	TrackerSparqlPattern* _tmp11_;
	g_return_val_if_fail (query != NULL, NULL);
	self = (TrackerSparqlQuery*) g_object_new (object_type, NULL);
	tracker_sparql_query_set_no_cache (self, FALSE);
	_tmp0_ = g_new0 (TrackerSparqlQueryTokenInfo, TRACKER_SPARQL_QUERY_BUFFER_SIZE);
	_tmp1_ = _tmp0_;
	self->priv->tokens = (g_free (self->priv->tokens), NULL);
	self->priv->tokens_length1 = TRACKER_SPARQL_QUERY_BUFFER_SIZE;
	self->priv->_tokens_size_ = self->priv->tokens_length1;
	self->priv->tokens = _tmp1_;
	_tmp2_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_free);
	_tmp3_ = _tmp2_;
	_g_hash_table_unref0 (self->priv->prefix_map);
	self->priv->prefix_map = _tmp3_;
	_tmp4_ = g_new0 (guchar, 16);
	_tmp5_ = _tmp4_;
	self->priv->base_uuid = (g_free (self->priv->base_uuid), NULL);
	self->priv->base_uuid_length1 = 16;
	self->priv->_base_uuid_size_ = self->priv->base_uuid_length1;
	self->priv->base_uuid = _tmp5_;
	uuid_generate (self->priv->base_uuid);
	_tmp6_ = g_strdup (query);
	_tmp7_ = _tmp6_;
	_g_free0 (self->priv->query_string);
	self->priv->query_string = _tmp7_;
	_tmp8_ = tracker_sparql_expression_new (self);
	_tmp9_ = _tmp8_;
	_g_object_unref0 (self->expression);
	self->expression = _tmp9_;
	_tmp10_ = tracker_sparql_pattern_new (self);
	_tmp11_ = _tmp10_;
	_g_object_unref0 (self->pattern);
	self->pattern = _tmp11_;
	return self;
}


TrackerSparqlQuery* tracker_sparql_query_new (const gchar* query) {
	return tracker_sparql_query_construct (TRACKER_SPARQL_TYPE_QUERY, query);
}


TrackerSparqlQuery* tracker_sparql_query_construct_update (GType object_type, const gchar* query) {
	TrackerSparqlQuery * self = NULL;
	g_return_val_if_fail (query != NULL, NULL);
	self = (TrackerSparqlQuery*) tracker_sparql_query_construct (object_type, query);
	self->priv->update_extensions = TRUE;
	return self;
}


TrackerSparqlQuery* tracker_sparql_query_new_update (const gchar* query) {
	return tracker_sparql_query_construct_update (TRACKER_SPARQL_TYPE_QUERY, query);
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	gint _tmp0_;
	glong string_length;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	string_length = (glong) _tmp0_;
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp1_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp1_;
	return result;
}


static gchar* tracker_sparql_query_get_uuid_for_name (TrackerSparqlQuery* self, guchar* base_uuid, int base_uuid_length1, const gchar* name) {
	gchar* result = NULL;
	GChecksum* _tmp0_ = NULL;
	GChecksum* checksum;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* sha1;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = g_checksum_new (G_CHECKSUM_SHA1);
	checksum = _tmp0_;
	g_checksum_update (checksum, base_uuid, (gsize) 16);
	g_checksum_update (checksum, (guchar*) name, (gsize) (-1));
	_tmp1_ = g_checksum_get_string (checksum);
	_tmp2_ = g_strdup (_tmp1_);
	sha1 = _tmp2_;
	_tmp3_ = string_substring (sha1, (glong) 8, (glong) (-1));
	_tmp4_ = _tmp3_;
	_tmp5_ = string_substring (sha1, (glong) 12, (glong) (-1));
	_tmp6_ = _tmp5_;
	_tmp7_ = string_substring (sha1, (glong) 16, (glong) (-1));
	_tmp8_ = _tmp7_;
	_tmp9_ = string_substring (sha1, (glong) 20, (glong) (-1));
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strdup_printf ("urn:uuid:%.8s-%.4s-%.4s-%.4s-%.12s", sha1, _tmp4_, _tmp6_, _tmp8_, _tmp10_);
	result = (_tmp12_ = _tmp11_, _g_free0 (_tmp10_), _g_free0 (_tmp8_), _g_free0 (_tmp6_), _g_free0 (_tmp4_), _tmp12_);
	_g_free0 (sha1);
	_g_checksum_free0 (checksum);
	return result;
}


gchar* tracker_sparql_query_generate_bnodeid (TrackerSparqlQuery* self, const gchar* user_bnodeid) {
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (user_bnodeid == NULL) {
		gchar* _tmp0_ = NULL;
		self->priv->bnodeid = self->priv->bnodeid + 1;
		_tmp0_ = g_strdup_printf (":%d", self->priv->bnodeid);
		result = _tmp0_;
		return result;
	} else {
		gchar* uri;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		uri = NULL;
		if (self->priv->blank_nodes != NULL) {
			gconstpointer _tmp1_ = NULL;
			gchar* _tmp2_;
			gchar* _tmp3_;
			_tmp1_ = g_hash_table_lookup (self->priv->blank_nodes, user_bnodeid);
			_tmp2_ = g_strdup ((const gchar*) _tmp1_);
			_tmp3_ = _tmp2_;
			_g_free0 (uri);
			uri = _tmp3_;
			if (uri != NULL) {
				result = uri;
				return result;
			}
		}
		_tmp4_ = tracker_sparql_query_get_uuid_for_name (self, self->priv->base_uuid, self->priv->base_uuid_length1, user_bnodeid);
		_tmp5_ = _tmp4_;
		_g_free0 (uri);
		uri = _tmp5_;
		if (self->priv->blank_nodes != NULL) {
			gchar* _tmp11_;
			gchar* _tmp12_;
			while (TRUE) {
				gint _tmp6_;
				guchar* _tmp7_ = NULL;
				gint new_base_uuid_length1;
				gint _new_base_uuid_size_;
				guchar* _tmp8_;
				guchar* new_base_uuid;
				gchar* _tmp9_ = NULL;
				gchar* _tmp10_;
				_tmp6_ = tracker_data_query_resource_id (uri);
				if (!(_tmp6_ > 0)) {
					break;
				}
				_tmp7_ = g_new0 (guchar, 16);
				_tmp8_ = _tmp7_;
				new_base_uuid_length1 = 16;
				_new_base_uuid_size_ = new_base_uuid_length1;
				new_base_uuid = _tmp8_;
				uuid_generate (new_base_uuid);
				_tmp9_ = tracker_sparql_query_get_uuid_for_name (self, new_base_uuid, new_base_uuid_length1, user_bnodeid);
				_tmp10_ = _tmp9_;
				_g_free0 (uri);
				uri = _tmp10_;
				new_base_uuid = (g_free (new_base_uuid), NULL);
			}
			_tmp11_ = g_strdup (user_bnodeid);
			_tmp12_ = g_strdup (uri);
			g_hash_table_insert (self->priv->blank_nodes, _tmp11_, _tmp12_);
		}
		result = uri;
		return result;
	}
}


gboolean tracker_sparql_query_next (TrackerSparqlQuery* self, GError** error) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	self->priv->index = (self->priv->index + 1) % TRACKER_SPARQL_QUERY_BUFFER_SIZE;
	self->priv->size--;
	if (self->priv->size <= 0) {
		TrackerSourceLocation begin = {0};
		TrackerSourceLocation end = {0};
		TrackerSourceLocation _tmp0_ = {0};
		TrackerSourceLocation _tmp1_ = {0};
		TrackerSparqlTokenType _tmp2_;
		TrackerSparqlTokenType type;
		_tmp2_ = tracker_sparql_scanner_read_token (self->priv->scanner, &_tmp0_, &_tmp1_, &_inner_error_);
		begin = _tmp0_;
		end = _tmp1_;
		type = _tmp2_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		self->priv->tokens[self->priv->index].type = type;
		self->priv->tokens[self->priv->index].begin = begin;
		self->priv->tokens[self->priv->index].end = end;
		self->priv->size = 1;
	}
	result = self->priv->tokens[self->priv->index].type != TRACKER_SPARQL_TOKEN_TYPE_EOF;
	return result;
}


TrackerSparqlTokenType tracker_sparql_query_current (TrackerSparqlQuery* self) {
	TrackerSparqlTokenType result = 0;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->tokens[self->priv->index].type;
	return result;
}


TrackerSparqlTokenType tracker_sparql_query_last (TrackerSparqlQuery* self) {
	TrackerSparqlTokenType result = 0;
	gint last_index;
	g_return_val_if_fail (self != NULL, 0);
	last_index = ((self->priv->index + TRACKER_SPARQL_QUERY_BUFFER_SIZE) - 1) % TRACKER_SPARQL_QUERY_BUFFER_SIZE;
	result = self->priv->tokens[last_index].type;
	return result;
}


gboolean tracker_sparql_query_accept (TrackerSparqlQuery* self, TrackerSparqlTokenType type, GError** error) {
	gboolean result = FALSE;
	TrackerSparqlTokenType _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = tracker_sparql_query_current (self);
	if (_tmp0_ == type) {
		tracker_sparql_query_next (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


GError* tracker_sparql_query_get_error (TrackerSparqlQuery* self, const gchar* msg) {
	GError* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GError* _tmp2_ = NULL;
	GError* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (msg != NULL, NULL);
	_tmp0_ = g_strdup_printf ("%d.%d: syntax error, %s", self->priv->tokens[self->priv->index].begin.line, self->priv->tokens[self->priv->index].begin.column, msg);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_PARSE, _tmp1_);
	result = (_tmp3_ = _tmp2_, _g_free0 (_tmp1_), _tmp3_);
	return result;
}


GError* tracker_sparql_query_get_internal_error (TrackerSparqlQuery* self, const gchar* msg) {
	GError* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GError* _tmp2_ = NULL;
	GError* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (msg != NULL, NULL);
	_tmp0_ = g_strdup_printf ("%d.%d: %s", self->priv->tokens[self->priv->index].begin.line, self->priv->tokens[self->priv->index].begin.column, msg);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, _tmp1_);
	result = (_tmp3_ = _tmp2_, _g_free0 (_tmp1_), _tmp3_);
	return result;
}


gboolean tracker_sparql_query_expect (TrackerSparqlQuery* self, TrackerSparqlTokenType type, GError** error) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	GError* _tmp5_ = NULL;
	GError* _tmp6_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = tracker_sparql_query_accept (self, type, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	if (_tmp1_) {
		result = TRUE;
		return result;
	}
	_tmp2_ = tracker_sparql_token_type_to_string (type);
	_tmp3_ = g_strdup_printf ("expected %s", _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = tracker_sparql_query_get_error (self, _tmp4_);
	_inner_error_ = (_tmp6_ = _tmp5_, _g_free0 (_tmp4_), _tmp6_);
	if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
}


void tracker_sparql_query_get_location (TrackerSparqlQuery* self, TrackerSourceLocation* result) {
	g_return_if_fail (self != NULL);
	*result = self->priv->tokens[self->priv->index].begin;
	return;
}


void tracker_sparql_query_set_location (TrackerSparqlQuery* self, TrackerSourceLocation* location) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	tracker_sparql_scanner_seek (self->priv->scanner, location);
	self->priv->size = 0;
	self->priv->index = 0;
	tracker_sparql_query_next (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			goto __catch2_tracker_sparql_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	goto __finally2;
	__catch2_tracker_sparql_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_critical ("internal error: next in set_location failed");
		_g_error_free0 (e);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


gchar* tracker_sparql_query_get_last_string (TrackerSparqlQuery* self, gint strip) {
	gchar* result = NULL;
	gint last_index;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	last_index = ((self->priv->index + TRACKER_SPARQL_QUERY_BUFFER_SIZE) - 1) % TRACKER_SPARQL_QUERY_BUFFER_SIZE;
	_tmp0_ = g_strndup ((const gchar*) (self->priv->tokens[last_index].begin.pos + strip), (self->priv->tokens[last_index].end.pos - self->priv->tokens[last_index].begin.pos) - (2 * strip));
	result = _tmp0_;
	return result;
}


static void tracker_sparql_query_parse_prologue (TrackerSparqlQuery* self, GError** error) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_BASE, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (_tmp1_) {
		tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	while (TRUE) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		gchar* _tmp4_;
		gchar* ns;
		gboolean _tmp5_;
		gboolean _tmp6_;
		gchar* _tmp9_ = NULL;
		gchar* uri;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp2_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PREFIX, &_inner_error_);
		_tmp3_ = _tmp2_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		if (!_tmp3_) {
			break;
		}
		_tmp4_ = g_strdup ("");
		ns = _tmp4_;
		_tmp5_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error_);
		_tmp6_ = _tmp5_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (ns);
				return;
			} else {
				_g_free0 (ns);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		if (_tmp6_) {
			gchar* _tmp7_ = NULL;
			gchar* _tmp8_;
			_tmp7_ = tracker_sparql_query_get_last_string (self, 0);
			_tmp8_ = _tmp7_;
			_g_free0 (ns);
			ns = _tmp8_;
		}
		tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (ns);
				return;
			} else {
				_g_free0 (ns);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (ns);
				return;
			} else {
				_g_free0 (ns);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp9_ = tracker_sparql_query_get_last_string (self, 1);
		uri = _tmp9_;
		_tmp10_ = g_strdup (ns);
		_tmp11_ = g_strdup (uri);
		g_hash_table_insert (self->priv->prefix_map, _tmp10_, _tmp11_);
		_g_free0 (uri);
		_g_free0 (ns);
	}
}


static void tracker_sparql_query_prepare_execute (TrackerSparqlQuery* self, GError** error) {
	gint _tmp0_;
	TrackerSparqlScanner* _tmp1_ = NULL;
	TrackerSparqlScanner* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gint _tmp5_;
	TrackerNamespace** _tmp6_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_assert (!self->priv->update_extensions);
	_tmp0_ = strlen (self->priv->query_string);
	_tmp1_ = tracker_sparql_scanner_new ((gchar*) self->priv->query_string, (gsize) ((glong) _tmp0_));
	_tmp2_ = _tmp1_;
	_g_object_unref0 (self->priv->scanner);
	self->priv->scanner = _tmp2_;
	tracker_sparql_query_next (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp3_ = g_strdup ("fn");
	_tmp4_ = g_strdup (TRACKER_SPARQL_QUERY_FN_NS);
	g_hash_table_insert (self->priv->prefix_map, _tmp3_, _tmp4_);
	_tmp6_ = tracker_ontologies_get_namespaces (&_tmp5_);
	{
		TrackerNamespace** ns_collection;
		int ns_collection_length1;
		int ns_it;
		ns_collection = _tmp6_;
		ns_collection_length1 = _tmp5_;
		for (ns_it = 0; ns_it < _tmp5_; ns_it = ns_it + 1) {
			TrackerNamespace* _tmp7_;
			TrackerNamespace* ns;
			_tmp7_ = _g_object_ref0 (ns_collection[ns_it]);
			ns = _tmp7_;
			{
				const gchar* _tmp8_ = NULL;
				const gchar* _tmp10_ = NULL;
				gchar* _tmp11_;
				const gchar* _tmp12_ = NULL;
				gchar* _tmp13_;
				_tmp8_ = tracker_namespace_get_prefix (ns);
				if (_tmp8_ == NULL) {
					const gchar* _tmp9_ = NULL;
					_tmp9_ = tracker_namespace_get_uri (ns);
					g_critical ("Namespace does not specify a prefix: %s", _tmp9_);
					_g_object_unref0 (ns);
					continue;
				}
				_tmp10_ = tracker_namespace_get_prefix (ns);
				_tmp11_ = g_strdup (_tmp10_);
				_tmp12_ = tracker_namespace_get_uri (ns);
				_tmp13_ = g_strdup (_tmp12_);
				g_hash_table_insert (self->priv->prefix_map, _tmp11_, _tmp13_);
				_g_object_unref0 (ns);
			}
		}
	}
	tracker_sparql_query_parse_prologue (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


TrackerDBCursor* tracker_sparql_query_execute_cursor (TrackerSparqlQuery* self, gboolean threadsafe, GError** error) {
	TrackerDBCursor* result = NULL;
	TrackerSparqlTokenType _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	tracker_sparql_query_prepare_execute (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp0_ = tracker_sparql_query_current (self);
	switch (_tmp0_) {
		case TRACKER_SPARQL_TOKEN_TYPE_SELECT:
		{
			TrackerDBCursor* _tmp1_ = NULL;
			TrackerDBCursor* _tmp2_;
			_tmp1_ = tracker_sparql_query_execute_select_cursor (self, threadsafe, &_inner_error_);
			_tmp2_ = _tmp1_;
			if (_inner_error_ != NULL) {
				if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
					g_propagate_error (error, _inner_error_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			result = _tmp2_;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_CONSTRUCT:
		{
			GError* _tmp3_ = NULL;
			_tmp3_ = tracker_sparql_query_get_internal_error (self, "CONSTRUCT is not supported");
			_inner_error_ = _tmp3_;
			if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
				g_propagate_error (error, _inner_error_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		case TRACKER_SPARQL_TOKEN_TYPE_DESCRIBE:
		{
			GError* _tmp4_ = NULL;
			_tmp4_ = tracker_sparql_query_get_internal_error (self, "DESCRIBE is not supported");
			_inner_error_ = _tmp4_;
			if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
				g_propagate_error (error, _inner_error_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		case TRACKER_SPARQL_TOKEN_TYPE_ASK:
		{
			TrackerDBCursor* _tmp5_ = NULL;
			TrackerDBCursor* _tmp6_;
			_tmp5_ = tracker_sparql_query_execute_ask_cursor (self, threadsafe, &_inner_error_);
			_tmp6_ = _tmp5_;
			if (_inner_error_ != NULL) {
				if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
					g_propagate_error (error, _inner_error_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			result = _tmp6_;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_INSERT:
		case TRACKER_SPARQL_TOKEN_TYPE_DELETE:
		case TRACKER_SPARQL_TOKEN_TYPE_DROP:
		{
			GError* _tmp7_ = NULL;
			_tmp7_ = tracker_sparql_query_get_error (self, "INSERT and DELETE are not supported in query mode");
			_inner_error_ = _tmp7_;
			if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
				g_propagate_error (error, _inner_error_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		default:
		{
			GError* _tmp8_ = NULL;
			_tmp8_ = tracker_sparql_query_get_error (self, "expected SELECT or ASK");
			_inner_error_ = _tmp8_;
			if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
				g_propagate_error (error, _inner_error_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
}


GVariant* tracker_sparql_query_execute_update (TrackerSparqlQuery* self, gboolean blank, GError** error) {
	GVariant* result = NULL;
	GVariant* _result_;
	gint _tmp0_;
	TrackerSparqlScanner* _tmp1_ = NULL;
	TrackerSparqlScanner* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gint _tmp5_;
	TrackerNamespace** _tmp6_ = NULL;
	GVariantBuilder* ublank_nodes;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = NULL;
	g_assert (self->priv->update_extensions);
	_tmp0_ = strlen (self->priv->query_string);
	_tmp1_ = tracker_sparql_scanner_new ((gchar*) self->priv->query_string, (gsize) ((glong) _tmp0_));
	_tmp2_ = _tmp1_;
	_g_object_unref0 (self->priv->scanner);
	self->priv->scanner = _tmp2_;
	tracker_sparql_query_next (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_variant_unref0 (_result_);
		return NULL;
	}
	_tmp3_ = g_strdup ("fn");
	_tmp4_ = g_strdup (TRACKER_SPARQL_QUERY_FN_NS);
	g_hash_table_insert (self->priv->prefix_map, _tmp3_, _tmp4_);
	_tmp6_ = tracker_ontologies_get_namespaces (&_tmp5_);
	{
		TrackerNamespace** ns_collection;
		int ns_collection_length1;
		int ns_it;
		ns_collection = _tmp6_;
		ns_collection_length1 = _tmp5_;
		for (ns_it = 0; ns_it < _tmp5_; ns_it = ns_it + 1) {
			TrackerNamespace* _tmp7_;
			TrackerNamespace* ns;
			_tmp7_ = _g_object_ref0 (ns_collection[ns_it]);
			ns = _tmp7_;
			{
				const gchar* _tmp8_ = NULL;
				const gchar* _tmp10_ = NULL;
				gchar* _tmp11_;
				const gchar* _tmp12_ = NULL;
				gchar* _tmp13_;
				_tmp8_ = tracker_namespace_get_prefix (ns);
				if (_tmp8_ == NULL) {
					const gchar* _tmp9_ = NULL;
					_tmp9_ = tracker_namespace_get_uri (ns);
					g_critical ("Namespace does not specify a prefix: %s", _tmp9_);
					_g_object_unref0 (ns);
					continue;
				}
				_tmp10_ = tracker_namespace_get_prefix (ns);
				_tmp11_ = g_strdup (_tmp10_);
				_tmp12_ = tracker_namespace_get_uri (ns);
				_tmp13_ = g_strdup (_tmp12_);
				g_hash_table_insert (self->priv->prefix_map, _tmp11_, _tmp13_);
				_g_object_unref0 (ns);
			}
		}
	}
	tracker_sparql_query_parse_prologue (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_variant_unref0 (_result_);
		return NULL;
	}
	ublank_nodes = NULL;
	if (blank) {
		GVariantBuilder* _tmp14_ = NULL;
		GVariantBuilder* _tmp15_;
		_tmp14_ = g_variant_builder_new ((GVariantType*) "aaa{ss}");
		_tmp15_ = _tmp14_;
		_g_variant_builder_unref0 (ublank_nodes);
		ublank_nodes = _tmp15_;
	}
	while (TRUE) {
		TrackerSparqlTokenType _tmp16_;
		TrackerSparqlTokenType _tmp17_;
		_tmp16_ = tracker_sparql_query_current (self);
		if (!(_tmp16_ != TRACKER_SPARQL_TOKEN_TYPE_EOF)) {
			break;
		}
		_tmp17_ = tracker_sparql_query_current (self);
		switch (_tmp17_) {
			case TRACKER_SPARQL_TOKEN_TYPE_WITH:
			case TRACKER_SPARQL_TOKEN_TYPE_INSERT:
			case TRACKER_SPARQL_TOKEN_TYPE_DELETE:
			{
				if (blank) {
					g_variant_builder_open (ublank_nodes, (GVariantType*) "aa{ss}");
					tracker_sparql_query_execute_insert_or_delete (self, ublank_nodes, &_inner_error_);
					if (_inner_error_ != NULL) {
						g_propagate_error (error, _inner_error_);
						_g_variant_builder_unref0 (ublank_nodes);
						_g_variant_unref0 (_result_);
						return NULL;
					}
					g_variant_builder_close (ublank_nodes);
				} else {
					tracker_sparql_query_execute_insert_or_delete (self, NULL, &_inner_error_);
					if (_inner_error_ != NULL) {
						g_propagate_error (error, _inner_error_);
						_g_variant_builder_unref0 (ublank_nodes);
						_g_variant_unref0 (_result_);
						return NULL;
					}
				}
				break;
			}
			case TRACKER_SPARQL_TOKEN_TYPE_DROP:
			{
				GError* _tmp18_ = NULL;
				_tmp18_ = tracker_sparql_query_get_internal_error (self, "DROP GRAPH is not supported");
				_inner_error_ = _tmp18_;
				g_propagate_error (error, _inner_error_);
				_g_variant_builder_unref0 (ublank_nodes);
				_g_variant_unref0 (_result_);
				return NULL;
			}
			case TRACKER_SPARQL_TOKEN_TYPE_SELECT:
			case TRACKER_SPARQL_TOKEN_TYPE_CONSTRUCT:
			case TRACKER_SPARQL_TOKEN_TYPE_DESCRIBE:
			case TRACKER_SPARQL_TOKEN_TYPE_ASK:
			{
				GError* _tmp19_ = NULL;
				_tmp19_ = tracker_sparql_query_get_error (self, "SELECT, CONSTRUCT, DESCRIBE, and ASK are not supported in update mode");
				_inner_error_ = _tmp19_;
				g_propagate_error (error, _inner_error_);
				_g_variant_builder_unref0 (ublank_nodes);
				_g_variant_unref0 (_result_);
				return NULL;
			}
			default:
			{
				GError* _tmp20_ = NULL;
				_tmp20_ = tracker_sparql_query_get_error (self, "expected INSERT or DELETE");
				_inner_error_ = _tmp20_;
				g_propagate_error (error, _inner_error_);
				_g_variant_builder_unref0 (ublank_nodes);
				_g_variant_unref0 (_result_);
				return NULL;
			}
		}
		tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_variant_builder_unref0 (ublank_nodes);
			_g_variant_unref0 (_result_);
			return NULL;
		}
	}
	if (blank) {
		GVariant* _tmp21_ = NULL;
		GVariant* _tmp22_;
		_tmp21_ = g_variant_builder_end (ublank_nodes);
		_tmp22_ = g_variant_ref_sink (_tmp21_);
		_g_variant_unref0 (_result_);
		_result_ = _tmp22_;
	}
	result = _result_;
	_g_variant_builder_unref0 (ublank_nodes);
	return result;
}


static TrackerDBStatement* tracker_sparql_query_prepare_for_exec (TrackerSparqlQuery* self, const gchar* sql, GError** error) {
	TrackerDBStatement* result = NULL;
	TrackerDBInterface* _tmp0_ = NULL;
	TrackerDBInterface* _tmp1_;
	TrackerDBInterface* iface;
	TrackerDBStatementCacheType _tmp2_ = 0;
	TrackerDBStatement* _tmp3_ = NULL;
	TrackerDBStatement* stmt;
	gint i;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sql != NULL, NULL);
	_tmp0_ = tracker_db_manager_get_db_interface ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	iface = _tmp1_;
	if (self->priv->_no_cache) {
		_tmp2_ = TRACKER_DB_STATEMENT_CACHE_TYPE_NONE;
	} else {
		_tmp2_ = TRACKER_DB_STATEMENT_CACHE_TYPE_SELECT;
	}
	_tmp3_ = tracker_db_interface_create_statement (iface, _tmp2_, &_inner_error_, "%s", sql);
	stmt = _tmp3_;
	if (_inner_error_ != NULL) {
		if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iface);
			return NULL;
		} else {
			_g_object_unref0 (iface);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	i = 0;
	{
		GList* binding_collection;
		GList* binding_it;
		binding_collection = self->bindings;
		for (binding_it = binding_collection; binding_it != NULL; binding_it = binding_it->next) {
			TrackerSparqlLiteralBinding* _tmp4_;
			TrackerSparqlLiteralBinding* binding;
			_tmp4_ = _g_object_ref0 ((TrackerSparqlLiteralBinding*) binding_it->data);
			binding = _tmp4_;
			{
				if (((TrackerSparqlDataBinding*) binding)->data_type == TRACKER_PROPERTY_TYPE_BOOLEAN) {
					gboolean _tmp5_ = FALSE;
					if (g_strcmp0 (binding->literal, "true") == 0) {
						_tmp5_ = TRUE;
					} else {
						_tmp5_ = g_strcmp0 (binding->literal, "1") == 0;
					}
					if (_tmp5_) {
						tracker_db_statement_bind_int (stmt, i, 1);
					} else {
						gboolean _tmp6_ = FALSE;
						if (g_strcmp0 (binding->literal, "false") == 0) {
							_tmp6_ = TRUE;
						} else {
							_tmp6_ = g_strcmp0 (binding->literal, "0") == 0;
						}
						if (_tmp6_) {
							tracker_db_statement_bind_int (stmt, i, 0);
						} else {
							gchar* _tmp7_ = NULL;
							gchar* _tmp8_;
							GError* _tmp9_ = NULL;
							GError* _tmp10_;
							_tmp7_ = g_strdup_printf ("`%s' is not a valid boolean", binding->literal);
							_tmp8_ = _tmp7_;
							_tmp9_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_TYPE, _tmp8_);
							_inner_error_ = (_tmp10_ = _tmp9_, _g_free0 (_tmp8_), _tmp10_);
							if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
								g_propagate_error (error, _inner_error_);
								_g_object_unref0 (binding);
								_g_object_unref0 (stmt);
								_g_object_unref0 (iface);
								return NULL;
							} else {
								_g_object_unref0 (binding);
								_g_object_unref0 (stmt);
								_g_object_unref0 (iface);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return NULL;
							}
						}
					}
				} else {
					if (((TrackerSparqlDataBinding*) binding)->data_type == TRACKER_PROPERTY_TYPE_DATETIME) {
						gint _tmp11_;
						gint _tmp12_;
						_tmp11_ = tracker_string_to_date (binding->literal, NULL, &_inner_error_);
						_tmp12_ = _tmp11_;
						if (_inner_error_ != NULL) {
							if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
								g_propagate_error (error, _inner_error_);
								_g_object_unref0 (binding);
								_g_object_unref0 (stmt);
								_g_object_unref0 (iface);
								return NULL;
							} else {
								_g_object_unref0 (binding);
								_g_object_unref0 (stmt);
								_g_object_unref0 (iface);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return NULL;
							}
						}
						tracker_db_statement_bind_int (stmt, i, _tmp12_);
					} else {
						if (((TrackerSparqlDataBinding*) binding)->data_type == TRACKER_PROPERTY_TYPE_INTEGER) {
							gint _tmp13_;
							_tmp13_ = atoi (binding->literal);
							tracker_db_statement_bind_int (stmt, i, _tmp13_);
						} else {
							tracker_db_statement_bind_text (stmt, i, binding->literal);
						}
					}
				}
				i++;
				_g_object_unref0 (binding);
			}
		}
	}
	result = stmt;
	_g_object_unref0 (iface);
	return result;
}


static TrackerDBCursor* tracker_sparql_query_exec_sql_cursor (TrackerSparqlQuery* self, const gchar* sql, TrackerPropertyType* types, int types_length1, gchar** variable_names, int variable_names_length1, gboolean threadsafe, GError** error) {
	TrackerDBCursor* result = NULL;
	TrackerDBStatement* _tmp0_ = NULL;
	TrackerDBStatement* stmt;
	TrackerDBCursor* _tmp1_ = NULL;
	TrackerDBCursor* _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sql != NULL, NULL);
	_tmp0_ = tracker_sparql_query_prepare_for_exec (self, sql, &_inner_error_);
	stmt = _tmp0_;
	if (_inner_error_ != NULL) {
		if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp1_ = tracker_db_statement_start_sparql_cursor (stmt, types, types_length1, variable_names, variable_names_length1, threadsafe, &_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (stmt);
			return NULL;
		} else {
			_g_object_unref0 (stmt);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _tmp2_;
	_g_object_unref0 (stmt);
	return result;
}


static gchar* tracker_sparql_query_get_select_query (TrackerSparqlQuery* self, TrackerSparqlSelectContext** context, GError** error) {
	TrackerSparqlSelectContext* _context = NULL;
	gchar* result = NULL;
	GString* _tmp0_ = NULL;
	GString* sql;
	TrackerSparqlSelectContext* _tmp1_ = NULL;
	TrackerSparqlSelectContext* _tmp2_;
	TrackerSparqlSelectContext* _tmp3_;
	gchar* _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_string_new ("");
	sql = _tmp0_;
	_tmp1_ = tracker_sparql_pattern_translate_select (self->pattern, sql, FALSE, FALSE, &_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_string_free0 (sql);
			return NULL;
		} else {
			_g_string_free0 (sql);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp3_ = _tmp2_;
	_tracker_sparql_context_unref0 (_context);
	_context = _tmp3_;
	tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_EOF, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_string_free0 (sql);
			return NULL;
		} else {
			_g_string_free0 (sql);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp4_ = g_strdup (sql->str);
	result = _tmp4_;
	_g_string_free0 (sql);
	if (context) {
		*context = _context;
	} else {
		_tracker_sparql_context_unref0 (_context);
	}
	return result;
}


static TrackerDBCursor* tracker_sparql_query_execute_select_cursor (TrackerSparqlQuery* self, gboolean threadsafe, GError** error) {
	TrackerDBCursor* result = NULL;
	TrackerSparqlSelectContext* context;
	TrackerSparqlSelectContext* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* sql;
	TrackerDBCursor* _tmp2_ = NULL;
	TrackerDBCursor* _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	context = NULL;
	_tmp1_ = tracker_sparql_query_get_select_query (self, &_tmp0_, &_inner_error_);
	_tracker_sparql_context_unref0 (context);
	context = _tmp0_;
	sql = _tmp1_;
	if (_inner_error_ != NULL) {
		if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_tracker_sparql_context_unref0 (context);
			return NULL;
		} else {
			_tracker_sparql_context_unref0 (context);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp2_ = tracker_sparql_query_exec_sql_cursor (self, sql, context->types, context->types_length1, context->variable_names, context->variable_names_length1, TRUE, &_inner_error_);
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (sql);
			_tracker_sparql_context_unref0 (context);
			return NULL;
		} else {
			_g_free0 (sql);
			_tracker_sparql_context_unref0 (context);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _tmp3_;
	_g_free0 (sql);
	_tracker_sparql_context_unref0 (context);
	return result;
}


static gchar* tracker_sparql_query_get_ask_query (TrackerSparqlQuery* self, GError** error) {
	gchar* result = NULL;
	GString* _tmp0_ = NULL;
	GString* pattern_sql;
	GString* _tmp1_ = NULL;
	GString* sql;
	TrackerSparqlContext* _tmp2_ = NULL;
	TrackerSparqlContext* _tmp3_;
	TrackerSparqlContext* _tmp4_;
	TrackerSparqlContext* _tmp5_;
	TrackerSparqlContext* _tmp6_;
	gchar* _tmp7_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_string_new ("");
	pattern_sql = _tmp0_;
	_tmp1_ = g_string_new ("");
	sql = _tmp1_;
	g_string_append (sql, "SELECT ");
	tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_ASK, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_string_free0 (sql);
			_g_string_free0 (pattern_sql);
			return NULL;
		} else {
			_g_string_free0 (sql);
			_g_string_free0 (pattern_sql);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	g_string_append (sql, "COUNT(1) > 0");
	tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_WHERE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_string_free0 (sql);
			_g_string_free0 (pattern_sql);
			return NULL;
		} else {
			_g_string_free0 (sql);
			_g_string_free0 (pattern_sql);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp2_ = tracker_sparql_pattern_translate_group_graph_pattern (self->pattern, pattern_sql, &_inner_error_);
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_string_free0 (sql);
			_g_string_free0 (pattern_sql);
			return NULL;
		} else {
			_g_string_free0 (sql);
			_g_string_free0 (pattern_sql);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp4_ = _tmp3_;
	_tracker_sparql_context_unref0 (self->context);
	self->context = _tmp4_;
	g_string_append (sql, " FROM (");
	g_string_append (sql, pattern_sql->str);
	g_string_append (sql, ")");
	_tmp5_ = _tracker_sparql_context_ref0 (self->context->parent_context);
	_tmp6_ = _tmp5_;
	_tracker_sparql_context_unref0 (self->context);
	self->context = _tmp6_;
	_tmp7_ = g_strdup (sql->str);
	result = _tmp7_;
	_g_string_free0 (sql);
	_g_string_free0 (pattern_sql);
	return result;
}


static TrackerDBCursor* tracker_sparql_query_execute_ask_cursor (TrackerSparqlQuery* self, gboolean threadsafe, GError** error) {
	TrackerDBCursor* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	TrackerPropertyType* _tmp3_ = NULL;
	TrackerPropertyType* _tmp4_;
	gint _tmp4__length1;
	gchar* _tmp5_;
	gchar** _tmp6_ = NULL;
	gchar** _tmp7_;
	gint _tmp7__length1;
	TrackerDBCursor* _tmp8_ = NULL;
	TrackerDBCursor* _tmp9_;
	TrackerDBCursor* _tmp10_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = tracker_sparql_query_get_ask_query (self, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp2_ = _tmp1_;
	_tmp3_ = g_new0 (TrackerPropertyType, 1);
	_tmp3_[0] = TRACKER_PROPERTY_TYPE_BOOLEAN;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 1;
	_tmp5_ = g_strdup ("result");
	_tmp6_ = g_new0 (gchar*, 1 + 1);
	_tmp6_[0] = _tmp5_;
	_tmp7_ = _tmp6_;
	_tmp7__length1 = 1;
	_tmp8_ = tracker_sparql_query_exec_sql_cursor (self, _tmp2_, _tmp4_, 1, _tmp7_, 1, TRUE, &_inner_error_);
	_tmp10_ = (_tmp9_ = _tmp8_, _tmp7_ = (_vala_array_free (_tmp7_, _tmp7__length1, (GDestroyNotify) g_free), NULL), _tmp4_ = (g_free (_tmp4_), NULL), _g_free0 (_tmp2_), _tmp9_);
	if (_inner_error_ != NULL) {
		if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _tmp10_;
	return result;
}


static void tracker_sparql_query_parse_from_or_into_param (TrackerSparqlQuery* self, GError** error) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (_tmp1_) {
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		_tmp2_ = tracker_sparql_query_get_last_string (self, 1);
		_tmp3_ = _tmp2_;
		_g_free0 (self->priv->current_graph);
		self->priv->current_graph = _tmp3_;
	} else {
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp4_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error_);
		_tmp5_ = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		if (_tmp5_) {
			gchar* _tmp6_ = NULL;
			gchar* ns;
			gchar* _tmp7_ = NULL;
			gchar* _tmp8_;
			gchar* _tmp9_ = NULL;
			gchar* _tmp10_;
			gchar* _tmp11_ = NULL;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			_tmp6_ = tracker_sparql_query_get_last_string (self, 0);
			ns = _tmp6_;
			tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (ns);
					return;
				} else {
					_g_free0 (ns);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			_tmp7_ = tracker_sparql_query_get_last_string (self, 0);
			_tmp8_ = _tmp7_;
			_tmp9_ = string_substring (_tmp8_, (glong) 1, (glong) (-1));
			_tmp10_ = _tmp9_;
			_tmp11_ = tracker_sparql_query_resolve_prefixed_name (self, ns, _tmp10_, &_inner_error_);
			_tmp13_ = (_tmp12_ = _tmp11_, _g_free0 (_tmp10_), _g_free0 (_tmp8_), _tmp12_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (ns);
					return;
				} else {
					_g_free0 (ns);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			_tmp14_ = _tmp13_;
			_g_free0 (self->priv->current_graph);
			self->priv->current_graph = _tmp14_;
			_g_free0 (ns);
		} else {
			gchar* _tmp15_ = NULL;
			gchar* _tmp16_;
			gchar* _tmp17_ = NULL;
			gchar* _tmp18_;
			gchar* _tmp19_ = NULL;
			gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			_tmp15_ = tracker_sparql_query_get_last_string (self, 0);
			_tmp16_ = _tmp15_;
			_tmp17_ = string_substring (_tmp16_, (glong) 1, (glong) (-1));
			_tmp18_ = _tmp17_;
			_tmp19_ = tracker_sparql_query_resolve_prefixed_name (self, "", _tmp18_, &_inner_error_);
			_tmp21_ = (_tmp20_ = _tmp19_, _g_free0 (_tmp18_), _g_free0 (_tmp16_), _tmp20_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			_tmp22_ = _tmp21_;
			_g_free0 (self->priv->current_graph);
			self->priv->current_graph = _tmp22_;
		}
	}
}


static GVariant* _variant_new1 (GHashTable* value) {
	GVariantBuilder _tmp56_;
	GHashTableIter _tmp57_;
	gpointer _tmp58_;
	gpointer _tmp59_;
	g_hash_table_iter_init (&_tmp57_, value);
	g_variant_builder_init (&_tmp56_, G_VARIANT_TYPE ("a{ss}"));
	while (g_hash_table_iter_next (&_tmp57_, &_tmp58_, &_tmp59_)) {
		gchar* _key;
		gchar* _value;
		_key = (gchar*) _tmp58_;
		_value = (gchar*) _tmp59_;
		g_variant_builder_add (&_tmp56_, "{?*}", g_variant_new_string (_key), g_variant_new_string (_value));
	}
	return g_variant_ref_sink (g_variant_builder_end (&_tmp56_));
}


static void tracker_sparql_query_execute_insert_or_delete (TrackerSparqlQuery* self, GVariantBuilder* update_blank_nodes, GError** error) {
	gboolean blank;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean delete_statements = FALSE;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp15_ = FALSE;
	gboolean data;
	GString* _tmp18_ = NULL;
	GString* pattern_sql;
	GString* _tmp19_ = NULL;
	GString* sql;
	TrackerSourceLocation _tmp20_ = {0};
	TrackerSourceLocation _tmp21_ = {0};
	TrackerSourceLocation template_location;
	TrackerSourceLocation _tmp34_ = {0};
	TrackerSourceLocation _tmp35_ = {0};
	TrackerSourceLocation after_where;
	gboolean first;
	GList* _tmp36_ = NULL;
	TrackerDBCursor* _tmp43_ = NULL;
	TrackerDBCursor* cursor;
	GList* _tmp60_;
	TrackerSparqlContext* _tmp61_;
	TrackerSparqlContext* _tmp62_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	blank = TRUE;
	_tmp0_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_WITH, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	if (_tmp1_) {
		tracker_sparql_query_parse_from_or_into_param (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return;
		}
	} else {
		gchar* _tmp2_;
		_tmp2_ = NULL;
		_g_free0 (self->priv->current_graph);
		self->priv->current_graph = _tmp2_;
	}
	_tmp3_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_INSERT, &_inner_error_);
	_tmp4_ = _tmp3_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	if (_tmp4_) {
		gboolean _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_ = FALSE;
		delete_statements = FALSE;
		_tmp5_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_SILENT, &_inner_error_);
		_tmp6_ = _tmp5_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return;
		}
		self->priv->silent = _tmp6_;
		if (self->priv->current_graph == NULL) {
			gboolean _tmp8_;
			gboolean _tmp9_;
			_tmp8_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_INTO, &_inner_error_);
			_tmp9_ = _tmp8_;
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				return;
			}
			_tmp7_ = _tmp9_;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			tracker_sparql_query_parse_from_or_into_param (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				return;
			}
		}
	} else {
		gboolean _tmp10_;
		gboolean _tmp11_;
		gboolean _tmp12_ = FALSE;
		tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_DELETE, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return;
		}
		delete_statements = TRUE;
		blank = FALSE;
		_tmp10_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_SILENT, &_inner_error_);
		_tmp11_ = _tmp10_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return;
		}
		self->priv->silent = _tmp11_;
		if (self->priv->current_graph == NULL) {
			gboolean _tmp13_;
			gboolean _tmp14_;
			_tmp13_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_FROM, &_inner_error_);
			_tmp14_ = _tmp13_;
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				return;
			}
			_tmp12_ = _tmp14_;
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			tracker_sparql_query_parse_from_or_into_param (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				return;
			}
		}
	}
	if (self->priv->current_graph == NULL) {
		gboolean _tmp16_;
		gboolean _tmp17_;
		_tmp16_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DATA, &_inner_error_);
		_tmp17_ = _tmp16_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return;
		}
		_tmp15_ = _tmp17_;
	} else {
		_tmp15_ = FALSE;
	}
	data = _tmp15_;
	_tmp18_ = g_string_new ("");
	pattern_sql = _tmp18_;
	_tmp19_ = g_string_new ("");
	sql = _tmp19_;
	_tmp21_ = (tracker_sparql_query_get_location (self, &_tmp20_), _tmp20_);
	template_location = _tmp21_;
	if (!data) {
		gboolean _tmp22_;
		gboolean _tmp23_;
		tracker_sparql_query_skip_braces (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_string_free0 (sql);
			_g_string_free0 (pattern_sql);
			return;
		}
		_tmp22_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_WHERE, &_inner_error_);
		_tmp23_ = _tmp22_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_string_free0 (sql);
			_g_string_free0 (pattern_sql);
			return;
		}
		if (_tmp23_) {
			gchar* _tmp24_;
			gchar* _tmp25_;
			TrackerSparqlContext* _tmp26_ = NULL;
			TrackerSparqlContext* _tmp27_;
			TrackerSparqlContext* _tmp28_;
			gchar* _tmp29_;
			_tmp24_ = g_strdup (self->priv->current_graph);
			_tmp25_ = _tmp24_;
			_g_free0 (self->pattern->current_graph);
			self->pattern->current_graph = _tmp25_;
			_tmp26_ = tracker_sparql_pattern_translate_group_graph_pattern (self->pattern, pattern_sql, &_inner_error_);
			_tmp27_ = _tmp26_;
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_string_free0 (sql);
				_g_string_free0 (pattern_sql);
				return;
			}
			_tmp28_ = _tmp27_;
			_tracker_sparql_context_unref0 (self->context);
			self->context = _tmp28_;
			_tmp29_ = NULL;
			_g_free0 (self->pattern->current_graph);
			self->pattern->current_graph = _tmp29_;
		} else {
			TrackerSparqlContext* _tmp30_ = NULL;
			TrackerSparqlContext* _tmp31_;
			_tmp30_ = tracker_sparql_context_new (self, NULL);
			_tmp31_ = _tmp30_;
			_tracker_sparql_context_unref0 (self->context);
			self->context = _tmp31_;
			g_string_append (pattern_sql, "SELECT 1");
		}
	} else {
		TrackerSparqlContext* _tmp32_ = NULL;
		TrackerSparqlContext* _tmp33_;
		_tmp32_ = tracker_sparql_context_new (self, NULL);
		_tmp33_ = _tmp32_;
		_tracker_sparql_context_unref0 (self->context);
		self->context = _tmp33_;
		g_string_append (pattern_sql, "SELECT 1");
	}
	_tmp35_ = (tracker_sparql_query_get_location (self, &_tmp34_), _tmp34_);
	after_where = _tmp35_;
	g_string_append (sql, "SELECT ");
	first = TRUE;
	_tmp36_ = g_hash_table_get_keys (self->context->var_set);
	{
		GList* variable_collection;
		GList* variable_it;
		variable_collection = _tmp36_;
		for (variable_it = variable_collection; variable_it != NULL; variable_it = variable_it->next) {
			TrackerSparqlVariable* variable;
			variable = (TrackerSparqlVariable*) variable_it->data;
			{
				const gchar* _tmp42_ = NULL;
				if (!first) {
					g_string_append (sql, ", ");
				} else {
					first = FALSE;
				}
				if (variable->binding == NULL) {
					const gchar* _tmp37_ = NULL;
					gchar* _tmp38_ = NULL;
					gchar* _tmp39_;
					GError* _tmp40_ = NULL;
					GError* _tmp41_;
					_tmp37_ = tracker_sparql_variable_get_name (variable);
					_tmp38_ = g_strdup_printf ("use of undefined variable `%s'", _tmp37_);
					_tmp39_ = _tmp38_;
					_tmp40_ = tracker_sparql_query_get_error (self, _tmp39_);
					_inner_error_ = (_tmp41_ = _tmp40_, _g_free0 (_tmp39_), _tmp41_);
					g_propagate_error (error, _inner_error_);
					_g_list_free0 (variable_collection);
					_g_string_free0 (sql);
					_g_string_free0 (pattern_sql);
					return;
				}
				_tmp42_ = tracker_sparql_variable_get_sql_expression (variable);
				tracker_sparql_expression_append_expression_as_string (sql, _tmp42_, ((TrackerSparqlDataBinding*) variable->binding)->data_type);
			}
		}
		_g_list_free0 (variable_collection);
	}
	if (first) {
		g_string_append (sql, "1");
	}
	g_string_append (sql, " FROM (");
	g_string_append (sql, pattern_sql->str);
	g_string_append (sql, ")");
	_tmp43_ = tracker_sparql_query_exec_sql_cursor (self, sql->str, NULL, 0, NULL, 0, FALSE, &_inner_error_);
	cursor = _tmp43_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_string_free0 (sql);
		_g_string_free0 (pattern_sql);
		return;
	}
	self->priv->delete_statements = delete_statements;
	while (TRUE) {
		gboolean _tmp44_;
		gboolean _tmp45_;
		GHashTable* _tmp46_ = NULL;
		GHashTable* _tmp47_;
		GHashTable* _tmp48_ = NULL;
		GHashTable* var_value_map;
		gint var_idx;
		GList* _tmp49_ = NULL;
		gboolean _tmp55_ = FALSE;
		_tmp44_ = tracker_sparql_cursor_next ((TrackerSparqlCursor*) cursor, NULL, &_inner_error_);
		_tmp45_ = _tmp44_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (cursor);
			_g_string_free0 (sql);
			_g_string_free0 (pattern_sql);
			return;
		}
		if (!_tmp45_) {
			break;
		}
		uuid_generate (self->priv->base_uuid);
		_tmp46_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_free);
		_tmp47_ = _tmp46_;
		_g_hash_table_unref0 (self->priv->blank_nodes);
		self->priv->blank_nodes = _tmp47_;
		_tmp48_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_free);
		var_value_map = _tmp48_;
		var_idx = 0;
		_tmp49_ = g_hash_table_get_keys (self->context->var_set);
		{
			GList* variable_collection;
			GList* variable_it;
			variable_collection = _tmp49_;
			for (variable_it = variable_collection; variable_it != NULL; variable_it = variable_it->next) {
				TrackerSparqlVariable* variable;
				variable = (TrackerSparqlVariable*) variable_it->data;
				{
					const gchar* _tmp50_ = NULL;
					gchar* _tmp51_;
					gint _tmp52_;
					const gchar* _tmp53_ = NULL;
					gchar* _tmp54_;
					_tmp50_ = tracker_sparql_variable_get_name (variable);
					_tmp51_ = g_strdup (_tmp50_);
					_tmp52_ = var_idx;
					var_idx = _tmp52_ + 1;
					_tmp53_ = tracker_sparql_cursor_get_string ((TrackerSparqlCursor*) cursor, _tmp52_, NULL);
					_tmp54_ = g_strdup (_tmp53_);
					g_hash_table_insert (var_value_map, _tmp51_, _tmp54_);
				}
			}
			_g_list_free0 (variable_collection);
		}
		tracker_sparql_query_set_location (self, &template_location);
		tracker_sparql_query_parse_construct_triples_block (self, var_value_map, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_hash_table_unref0 (var_value_map);
			_g_object_unref0 (cursor);
			_g_string_free0 (sql);
			_g_string_free0 (pattern_sql);
			return;
		}
		if (blank) {
			_tmp55_ = update_blank_nodes != NULL;
		} else {
			_tmp55_ = FALSE;
		}
		if (_tmp55_) {
			g_variant_builder_add_value (update_blank_nodes, _variant_new1 (self->priv->blank_nodes));
		}
		tracker_data_update_buffer_might_flush (&_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_hash_table_unref0 (var_value_map);
			_g_object_unref0 (cursor);
			_g_string_free0 (sql);
			_g_string_free0 (pattern_sql);
			return;
		}
		_g_hash_table_unref0 (var_value_map);
	}
	if (!data) {
		tracker_sparql_query_set_location (self, &after_where);
	}
	tracker_data_update_buffer_flush (&_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (cursor);
		_g_string_free0 (sql);
		_g_string_free0 (pattern_sql);
		return;
	}
	_tmp60_ = NULL;
	__g_list_free__g_object_unref0_0 (self->bindings);
	self->bindings = _tmp60_;
	_tmp61_ = _tracker_sparql_context_ref0 (self->context->parent_context);
	_tmp62_ = _tmp61_;
	_tracker_sparql_context_unref0 (self->context);
	self->context = _tmp62_;
	_g_object_unref0 (cursor);
	_g_string_free0 (sql);
	_g_string_free0 (pattern_sql);
}


gchar* tracker_sparql_query_resolve_prefixed_name (TrackerSparqlQuery* self, const gchar* prefix, const gchar* local_name, GError** error) {
	gchar* result = NULL;
	gconstpointer _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* ns;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (prefix != NULL, NULL);
	g_return_val_if_fail (local_name != NULL, NULL);
	_tmp0_ = g_hash_table_lookup (self->priv->prefix_map, prefix);
	_tmp1_ = g_strdup ((const gchar*) _tmp0_);
	ns = _tmp1_;
	if (ns == NULL) {
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		GError* _tmp4_ = NULL;
		GError* _tmp5_;
		_tmp2_ = g_strdup_printf ("use of undefined prefix `%s'", prefix);
		_tmp3_ = _tmp2_;
		_tmp4_ = tracker_sparql_query_get_error (self, _tmp3_);
		_inner_error_ = (_tmp5_ = _tmp4_, _g_free0 (_tmp3_), _tmp5_);
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (ns);
			return NULL;
		} else {
			_g_free0 (ns);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = g_strconcat (ns, local_name, NULL);
	_g_free0 (ns);
	return result;
}


static void tracker_sparql_query_skip_braces (TrackerSparqlQuery* self, GError** error) {
	gint n_braces;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	n_braces = 1;
	while (TRUE) {
		gboolean _tmp0_;
		gboolean _tmp1_;
		if (!(n_braces > 0)) {
			break;
		}
		_tmp0_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE, &_inner_error_);
		_tmp1_ = _tmp0_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		if (_tmp1_) {
			n_braces++;
		} else {
			gboolean _tmp2_;
			gboolean _tmp3_;
			_tmp2_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE, &_inner_error_);
			_tmp3_ = _tmp2_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			if (_tmp3_) {
				n_braces--;
			} else {
				TrackerSparqlTokenType _tmp4_;
				_tmp4_ = tracker_sparql_query_current (self);
				if (_tmp4_ == TRACKER_SPARQL_TOKEN_TYPE_EOF) {
					GError* _tmp5_ = NULL;
					_tmp5_ = tracker_sparql_query_get_error (self, "unexpected end of query, expected }");
					_inner_error_ = _tmp5_;
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				} else {
					tracker_sparql_query_next (self, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							return;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
				}
			}
		}
	}
}


static void tracker_sparql_query_parse_construct_triples_block (TrackerSparqlQuery* self, GHashTable* var_value_map, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (var_value_map != NULL);
	tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	while (TRUE) {
		TrackerSparqlTokenType _tmp0_;
		gboolean _tmp1_;
		gboolean _tmp2_;
		_tmp0_ = tracker_sparql_query_current (self);
		if (!(_tmp0_ != TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE)) {
			break;
		}
		_tmp1_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_GRAPH, &_inner_error_);
		_tmp2_ = _tmp1_;
		if (_inner_error_ != NULL) {
			if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		if (_tmp2_) {
			gchar* _tmp3_;
			gchar* old_graph;
			gchar* _tmp4_ = NULL;
			gchar* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			_tmp3_ = g_strdup (self->priv->current_graph);
			old_graph = _tmp3_;
			_tmp4_ = tracker_sparql_query_parse_construct_var_or_term (self, var_value_map, &_inner_error_);
			_tmp5_ = _tmp4_;
			if (_inner_error_ != NULL) {
				if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (old_graph);
					return;
				} else {
					_g_free0 (old_graph);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			_tmp6_ = _tmp5_;
			_g_free0 (self->priv->current_graph);
			self->priv->current_graph = _tmp6_;
			tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE, &_inner_error_);
			if (_inner_error_ != NULL) {
				if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (old_graph);
					return;
				} else {
					_g_free0 (old_graph);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			while (TRUE) {
				TrackerSparqlTokenType _tmp7_;
				gchar* _tmp8_ = NULL;
				gchar* _tmp9_;
				gchar* _tmp10_;
				gboolean _tmp11_;
				gboolean _tmp12_;
				_tmp7_ = tracker_sparql_query_current (self);
				if (!(_tmp7_ != TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE)) {
					break;
				}
				_tmp8_ = tracker_sparql_query_parse_construct_var_or_term (self, var_value_map, &_inner_error_);
				_tmp9_ = _tmp8_;
				if (_inner_error_ != NULL) {
					if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (old_graph);
						return;
					} else {
						_g_free0 (old_graph);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				_tmp10_ = _tmp9_;
				_g_free0 (self->priv->current_subject);
				self->priv->current_subject = _tmp10_;
				tracker_sparql_query_parse_construct_property_list_not_empty (self, var_value_map, &_inner_error_);
				if (_inner_error_ != NULL) {
					if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (old_graph);
						return;
					} else {
						_g_free0 (old_graph);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				_tmp11_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOT, &_inner_error_);
				_tmp12_ = _tmp11_;
				if (_inner_error_ != NULL) {
					if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (old_graph);
						return;
					} else {
						_g_free0 (old_graph);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				if (!_tmp12_) {
					break;
				}
			}
			tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE, &_inner_error_);
			if (_inner_error_ != NULL) {
				if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (old_graph);
					return;
				} else {
					_g_free0 (old_graph);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			_tmp13_ = g_strdup (old_graph);
			_tmp14_ = _tmp13_;
			_g_free0 (self->priv->current_graph);
			self->priv->current_graph = _tmp14_;
			_g_free0 (old_graph);
		} else {
			gchar* _tmp15_ = NULL;
			gchar* _tmp16_;
			gchar* _tmp17_;
			gboolean _tmp18_ = FALSE;
			gboolean _tmp19_;
			gboolean _tmp20_;
			_tmp15_ = tracker_sparql_query_parse_construct_var_or_term (self, var_value_map, &_inner_error_);
			_tmp16_ = _tmp15_;
			if (_inner_error_ != NULL) {
				if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			_tmp17_ = _tmp16_;
			_g_free0 (self->priv->current_subject);
			self->priv->current_subject = _tmp17_;
			tracker_sparql_query_parse_construct_property_list_not_empty (self, var_value_map, &_inner_error_);
			if (_inner_error_ != NULL) {
				if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			_tmp19_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOT, &_inner_error_);
			_tmp20_ = _tmp19_;
			if (_inner_error_ != NULL) {
				if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			if (!_tmp20_) {
				TrackerSparqlTokenType _tmp21_;
				_tmp21_ = tracker_sparql_query_current (self);
				_tmp18_ = _tmp21_ != TRACKER_SPARQL_TOKEN_TYPE_GRAPH;
			} else {
				_tmp18_ = FALSE;
			}
			if (_tmp18_) {
				break;
			}
		}
	}
	tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static gchar* tracker_sparql_query_parse_construct_var_or_term (TrackerSparqlQuery* self, GHashTable* var_value_map, GError** error) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* _result_;
	TrackerSparqlTokenType _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (var_value_map != NULL, NULL);
	_tmp0_ = g_strdup ("");
	_result_ = _tmp0_;
	_tmp1_ = tracker_sparql_query_current (self);
	if (_tmp1_ == TRACKER_SPARQL_TOKEN_TYPE_VAR) {
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		gconstpointer _tmp6_ = NULL;
		gchar* _tmp7_;
		gchar* _tmp8_;
		tracker_sparql_query_next (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (_result_);
				return NULL;
			} else {
				_g_free0 (_result_);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp2_ = tracker_sparql_query_get_last_string (self, 0);
		_tmp3_ = _tmp2_;
		_tmp4_ = string_substring (_tmp3_, (glong) 1, (glong) (-1));
		_tmp5_ = _tmp4_;
		_tmp6_ = g_hash_table_lookup (var_value_map, _tmp5_);
		_tmp7_ = g_strdup ((const gchar*) _tmp6_);
		_tmp8_ = _tmp7_;
		_g_free0 (_result_);
		_result_ = _tmp8_;
		_g_free0 (_tmp5_);
		_g_free0 (_tmp3_);
	} else {
		TrackerSparqlTokenType _tmp9_;
		_tmp9_ = tracker_sparql_query_current (self);
		if (_tmp9_ == TRACKER_SPARQL_TOKEN_TYPE_IRI_REF) {
			gchar* _tmp10_ = NULL;
			gchar* _tmp11_;
			tracker_sparql_query_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (_result_);
					return NULL;
				} else {
					_g_free0 (_result_);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp10_ = tracker_sparql_query_get_last_string (self, 1);
			_tmp11_ = _tmp10_;
			_g_free0 (_result_);
			_result_ = _tmp11_;
		} else {
			TrackerSparqlTokenType _tmp12_;
			_tmp12_ = tracker_sparql_query_current (self);
			if (_tmp12_ == TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX) {
				gchar* _tmp13_ = NULL;
				gchar* ns;
				gchar* _tmp14_ = NULL;
				gchar* _tmp15_;
				gchar* _tmp16_ = NULL;
				gchar* _tmp17_;
				gchar* _tmp18_ = NULL;
				gchar* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				tracker_sparql_query_next (self, &_inner_error_);
				if (_inner_error_ != NULL) {
					if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (_result_);
						return NULL;
					} else {
						_g_free0 (_result_);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp13_ = tracker_sparql_query_get_last_string (self, 0);
				ns = _tmp13_;
				tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
				if (_inner_error_ != NULL) {
					if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (ns);
						_g_free0 (_result_);
						return NULL;
					} else {
						_g_free0 (ns);
						_g_free0 (_result_);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp14_ = tracker_sparql_query_get_last_string (self, 0);
				_tmp15_ = _tmp14_;
				_tmp16_ = string_substring (_tmp15_, (glong) 1, (glong) (-1));
				_tmp17_ = _tmp16_;
				_tmp18_ = tracker_sparql_query_resolve_prefixed_name (self, ns, _tmp17_, &_inner_error_);
				_tmp20_ = (_tmp19_ = _tmp18_, _g_free0 (_tmp17_), _g_free0 (_tmp15_), _tmp19_);
				if (_inner_error_ != NULL) {
					if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (ns);
						_g_free0 (_result_);
						return NULL;
					} else {
						_g_free0 (ns);
						_g_free0 (_result_);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp21_ = _tmp20_;
				_g_free0 (_result_);
				_result_ = _tmp21_;
				_g_free0 (ns);
			} else {
				TrackerSparqlTokenType _tmp22_;
				_tmp22_ = tracker_sparql_query_current (self);
				if (_tmp22_ == TRACKER_SPARQL_TOKEN_TYPE_COLON) {
					gchar* _tmp23_ = NULL;
					gchar* _tmp24_;
					gchar* _tmp25_ = NULL;
					gchar* _tmp26_;
					gchar* _tmp27_ = NULL;
					gchar* _tmp28_;
					gchar* _tmp29_;
					gchar* _tmp30_;
					tracker_sparql_query_next (self, &_inner_error_);
					if (_inner_error_ != NULL) {
						if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (_result_);
							return NULL;
						} else {
							_g_free0 (_result_);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_tmp23_ = tracker_sparql_query_get_last_string (self, 0);
					_tmp24_ = _tmp23_;
					_tmp25_ = string_substring (_tmp24_, (glong) 1, (glong) (-1));
					_tmp26_ = _tmp25_;
					_tmp27_ = tracker_sparql_query_resolve_prefixed_name (self, "", _tmp26_, &_inner_error_);
					_tmp29_ = (_tmp28_ = _tmp27_, _g_free0 (_tmp26_), _g_free0 (_tmp24_), _tmp28_);
					if (_inner_error_ != NULL) {
						if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (_result_);
							return NULL;
						} else {
							_g_free0 (_result_);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_tmp30_ = _tmp29_;
					_g_free0 (_result_);
					_result_ = _tmp30_;
				} else {
					gboolean _tmp31_;
					gboolean _tmp32_;
					_tmp31_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE, &_inner_error_);
					_tmp32_ = _tmp31_;
					if (_inner_error_ != NULL) {
						if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (_result_);
							return NULL;
						} else {
							_g_free0 (_result_);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					if (_tmp32_) {
						gchar* _tmp33_ = NULL;
						gchar* _tmp34_;
						gchar* _tmp35_ = NULL;
						gchar* _tmp36_;
						gchar* _tmp37_ = NULL;
						gchar* _tmp38_;
						tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
						if (_inner_error_ != NULL) {
							if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
								g_propagate_error (error, _inner_error_);
								_g_free0 (_result_);
								return NULL;
							} else {
								_g_free0 (_result_);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return NULL;
							}
						}
						_tmp33_ = tracker_sparql_query_get_last_string (self, 0);
						_tmp34_ = _tmp33_;
						_tmp35_ = string_substring (_tmp34_, (glong) 1, (glong) (-1));
						_tmp36_ = _tmp35_;
						_tmp37_ = tracker_sparql_query_generate_bnodeid (self, _tmp36_);
						_tmp38_ = _tmp37_;
						_g_free0 (_result_);
						_result_ = _tmp38_;
						_g_free0 (_tmp36_);
						_g_free0 (_tmp34_);
					} else {
						TrackerSparqlTokenType _tmp39_;
						_tmp39_ = tracker_sparql_query_current (self);
						if (_tmp39_ == TRACKER_SPARQL_TOKEN_TYPE_MINUS) {
							gboolean _tmp40_ = FALSE;
							gboolean _tmp41_ = FALSE;
							TrackerSparqlTokenType _tmp42_;
							tracker_sparql_query_next (self, &_inner_error_);
							if (_inner_error_ != NULL) {
								if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
									g_propagate_error (error, _inner_error_);
									_g_free0 (_result_);
									return NULL;
								} else {
									_g_free0 (_result_);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return NULL;
								}
							}
							_tmp42_ = tracker_sparql_query_current (self);
							if (_tmp42_ == TRACKER_SPARQL_TOKEN_TYPE_INTEGER) {
								_tmp41_ = TRUE;
							} else {
								TrackerSparqlTokenType _tmp43_;
								_tmp43_ = tracker_sparql_query_current (self);
								_tmp41_ = _tmp43_ == TRACKER_SPARQL_TOKEN_TYPE_DECIMAL;
							}
							if (_tmp41_) {
								_tmp40_ = TRUE;
							} else {
								TrackerSparqlTokenType _tmp44_;
								_tmp44_ = tracker_sparql_query_current (self);
								_tmp40_ = _tmp44_ == TRACKER_SPARQL_TOKEN_TYPE_DOUBLE;
							}
							if (_tmp40_) {
								gchar* _tmp45_ = NULL;
								gchar* _tmp46_;
								gchar* _tmp47_;
								tracker_sparql_query_next (self, &_inner_error_);
								if (_inner_error_ != NULL) {
									if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
										g_propagate_error (error, _inner_error_);
										_g_free0 (_result_);
										return NULL;
									} else {
										_g_free0 (_result_);
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return NULL;
									}
								}
								_tmp45_ = tracker_sparql_query_get_last_string (self, 0);
								_tmp46_ = _tmp45_;
								_tmp47_ = g_strconcat ("-", _tmp46_, NULL);
								_g_free0 (_result_);
								_result_ = _tmp47_;
								_g_free0 (_tmp46_);
							} else {
								GError* _tmp48_ = NULL;
								_tmp48_ = tracker_sparql_query_get_error (self, "expected variable or term");
								_inner_error_ = _tmp48_;
								if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
									g_propagate_error (error, _inner_error_);
									_g_free0 (_result_);
									return NULL;
								} else {
									_g_free0 (_result_);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return NULL;
								}
							}
						} else {
							TrackerSparqlTokenType _tmp49_;
							_tmp49_ = tracker_sparql_query_current (self);
							if (_tmp49_ == TRACKER_SPARQL_TOKEN_TYPE_INTEGER) {
								gchar* _tmp50_ = NULL;
								gchar* _tmp51_;
								tracker_sparql_query_next (self, &_inner_error_);
								if (_inner_error_ != NULL) {
									if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
										g_propagate_error (error, _inner_error_);
										_g_free0 (_result_);
										return NULL;
									} else {
										_g_free0 (_result_);
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return NULL;
									}
								}
								_tmp50_ = tracker_sparql_query_get_last_string (self, 0);
								_tmp51_ = _tmp50_;
								_g_free0 (_result_);
								_result_ = _tmp51_;
							} else {
								TrackerSparqlTokenType _tmp52_;
								_tmp52_ = tracker_sparql_query_current (self);
								if (_tmp52_ == TRACKER_SPARQL_TOKEN_TYPE_DECIMAL) {
									gchar* _tmp53_ = NULL;
									gchar* _tmp54_;
									tracker_sparql_query_next (self, &_inner_error_);
									if (_inner_error_ != NULL) {
										if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
											g_propagate_error (error, _inner_error_);
											_g_free0 (_result_);
											return NULL;
										} else {
											_g_free0 (_result_);
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
											g_clear_error (&_inner_error_);
											return NULL;
										}
									}
									_tmp53_ = tracker_sparql_query_get_last_string (self, 0);
									_tmp54_ = _tmp53_;
									_g_free0 (_result_);
									_result_ = _tmp54_;
								} else {
									TrackerSparqlTokenType _tmp55_;
									_tmp55_ = tracker_sparql_query_current (self);
									if (_tmp55_ == TRACKER_SPARQL_TOKEN_TYPE_DOUBLE) {
										gchar* _tmp56_ = NULL;
										gchar* _tmp57_;
										tracker_sparql_query_next (self, &_inner_error_);
										if (_inner_error_ != NULL) {
											if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
												g_propagate_error (error, _inner_error_);
												_g_free0 (_result_);
												return NULL;
											} else {
												_g_free0 (_result_);
												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
												g_clear_error (&_inner_error_);
												return NULL;
											}
										}
										_tmp56_ = tracker_sparql_query_get_last_string (self, 0);
										_tmp57_ = _tmp56_;
										_g_free0 (_result_);
										_result_ = _tmp57_;
									} else {
										TrackerSparqlTokenType _tmp58_;
										_tmp58_ = tracker_sparql_query_current (self);
										if (_tmp58_ == TRACKER_SPARQL_TOKEN_TYPE_TRUE) {
											gchar* _tmp59_;
											gchar* _tmp60_;
											tracker_sparql_query_next (self, &_inner_error_);
											if (_inner_error_ != NULL) {
												if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
													g_propagate_error (error, _inner_error_);
													_g_free0 (_result_);
													return NULL;
												} else {
													_g_free0 (_result_);
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
													g_clear_error (&_inner_error_);
													return NULL;
												}
											}
											_tmp59_ = g_strdup ("true");
											_tmp60_ = _tmp59_;
											_g_free0 (_result_);
											_result_ = _tmp60_;
										} else {
											TrackerSparqlTokenType _tmp61_;
											_tmp61_ = tracker_sparql_query_current (self);
											if (_tmp61_ == TRACKER_SPARQL_TOKEN_TYPE_FALSE) {
												gchar* _tmp62_;
												gchar* _tmp63_;
												tracker_sparql_query_next (self, &_inner_error_);
												if (_inner_error_ != NULL) {
													if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
														g_propagate_error (error, _inner_error_);
														_g_free0 (_result_);
														return NULL;
													} else {
														_g_free0 (_result_);
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
														g_clear_error (&_inner_error_);
														return NULL;
													}
												}
												_tmp62_ = g_strdup ("false");
												_tmp63_ = _tmp62_;
												_g_free0 (_result_);
												_result_ = _tmp63_;
											} else {
												TrackerSparqlTokenType _tmp64_;
												_tmp64_ = tracker_sparql_query_current (self);
												if (_tmp64_ == TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1) {
													gchar* _tmp65_ = NULL;
													gchar* _tmp66_;
													gchar* _tmp67_;
													_tmp65_ = tracker_sparql_expression_parse_string_literal (self->expression, NULL, &_inner_error_);
													_tmp66_ = _tmp65_;
													if (_inner_error_ != NULL) {
														if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
															g_propagate_error (error, _inner_error_);
															_g_free0 (_result_);
															return NULL;
														} else {
															_g_free0 (_result_);
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
															g_clear_error (&_inner_error_);
															return NULL;
														}
													}
													_tmp67_ = _tmp66_;
													_g_free0 (_result_);
													_result_ = _tmp67_;
												} else {
													TrackerSparqlTokenType _tmp68_;
													_tmp68_ = tracker_sparql_query_current (self);
													if (_tmp68_ == TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2) {
														gchar* _tmp69_ = NULL;
														gchar* _tmp70_;
														gchar* _tmp71_;
														_tmp69_ = tracker_sparql_expression_parse_string_literal (self->expression, NULL, &_inner_error_);
														_tmp70_ = _tmp69_;
														if (_inner_error_ != NULL) {
															if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
																g_propagate_error (error, _inner_error_);
																_g_free0 (_result_);
																return NULL;
															} else {
																_g_free0 (_result_);
																g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																g_clear_error (&_inner_error_);
																return NULL;
															}
														}
														_tmp71_ = _tmp70_;
														_g_free0 (_result_);
														_result_ = _tmp71_;
													} else {
														TrackerSparqlTokenType _tmp72_;
														_tmp72_ = tracker_sparql_query_current (self);
														if (_tmp72_ == TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1) {
															gchar* _tmp73_ = NULL;
															gchar* _tmp74_;
															gchar* _tmp75_;
															_tmp73_ = tracker_sparql_expression_parse_string_literal (self->expression, NULL, &_inner_error_);
															_tmp74_ = _tmp73_;
															if (_inner_error_ != NULL) {
																if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
																	g_propagate_error (error, _inner_error_);
																	_g_free0 (_result_);
																	return NULL;
																} else {
																	_g_free0 (_result_);
																	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																	g_clear_error (&_inner_error_);
																	return NULL;
																}
															}
															_tmp75_ = _tmp74_;
															_g_free0 (_result_);
															_result_ = _tmp75_;
														} else {
															TrackerSparqlTokenType _tmp76_;
															_tmp76_ = tracker_sparql_query_current (self);
															if (_tmp76_ == TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2) {
																gchar* _tmp77_ = NULL;
																gchar* _tmp78_;
																gchar* _tmp79_;
																_tmp77_ = tracker_sparql_expression_parse_string_literal (self->expression, NULL, &_inner_error_);
																_tmp78_ = _tmp77_;
																if (_inner_error_ != NULL) {
																	if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
																		g_propagate_error (error, _inner_error_);
																		_g_free0 (_result_);
																		return NULL;
																	} else {
																		_g_free0 (_result_);
																		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																		g_clear_error (&_inner_error_);
																		return NULL;
																	}
																}
																_tmp79_ = _tmp78_;
																_g_free0 (_result_);
																_result_ = _tmp79_;
															} else {
																TrackerSparqlTokenType _tmp80_;
																_tmp80_ = tracker_sparql_query_current (self);
																if (_tmp80_ == TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET) {
																	gchar* _tmp82_ = NULL;
																	gchar* _tmp83_;
																	gchar* _tmp84_;
																	gchar* old_subject;
																	gboolean old_subject_is_var;
																	gchar* _tmp85_;
																	gchar* _tmp86_;
																	gchar* _tmp87_;
																	gchar* _tmp88_;
																	if (self->priv->anon_blank_node_open) {
																		GError* _tmp81_ = NULL;
																		_tmp81_ = tracker_sparql_query_get_error (self, "no support for nested anonymous blank nodes");
																		_inner_error_ = _tmp81_;
																		if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
																			g_propagate_error (error, _inner_error_);
																			_g_free0 (_result_);
																			return NULL;
																		} else {
																			_g_free0 (_result_);
																			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																			g_clear_error (&_inner_error_);
																			return NULL;
																		}
																	}
																	self->priv->anon_blank_node_open = TRUE;
																	tracker_sparql_query_next (self, &_inner_error_);
																	if (_inner_error_ != NULL) {
																		if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
																			g_propagate_error (error, _inner_error_);
																			_g_free0 (_result_);
																			return NULL;
																		} else {
																			_g_free0 (_result_);
																			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																			g_clear_error (&_inner_error_);
																			return NULL;
																		}
																	}
																	_tmp82_ = tracker_sparql_query_generate_bnodeid (self, NULL);
																	_tmp83_ = _tmp82_;
																	_g_free0 (_result_);
																	_result_ = _tmp83_;
																	_tmp84_ = g_strdup (self->priv->current_subject);
																	old_subject = _tmp84_;
																	old_subject_is_var = self->priv->current_subject_is_var;
																	_tmp85_ = g_strdup (_result_);
																	_tmp86_ = _tmp85_;
																	_g_free0 (self->priv->current_subject);
																	self->priv->current_subject = _tmp86_;
																	tracker_sparql_query_parse_construct_property_list_not_empty (self, var_value_map, &_inner_error_);
																	if (_inner_error_ != NULL) {
																		if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
																			g_propagate_error (error, _inner_error_);
																			_g_free0 (old_subject);
																			_g_free0 (_result_);
																			return NULL;
																		} else {
																			_g_free0 (old_subject);
																			_g_free0 (_result_);
																			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																			g_clear_error (&_inner_error_);
																			return NULL;
																		}
																	}
																	tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACKET, &_inner_error_);
																	if (_inner_error_ != NULL) {
																		if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
																			g_propagate_error (error, _inner_error_);
																			_g_free0 (old_subject);
																			_g_free0 (_result_);
																			return NULL;
																		} else {
																			_g_free0 (old_subject);
																			_g_free0 (_result_);
																			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																			g_clear_error (&_inner_error_);
																			return NULL;
																		}
																	}
																	self->priv->anon_blank_node_open = FALSE;
																	_tmp87_ = g_strdup (old_subject);
																	_tmp88_ = _tmp87_;
																	_g_free0 (self->priv->current_subject);
																	self->priv->current_subject = _tmp88_;
																	self->priv->current_subject_is_var = old_subject_is_var;
																	_g_free0 (old_subject);
																} else {
																	GError* _tmp89_ = NULL;
																	_tmp89_ = tracker_sparql_query_get_error (self, "expected variable or term");
																	_inner_error_ = _tmp89_;
																	if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
																		g_propagate_error (error, _inner_error_);
																		_g_free0 (_result_);
																		return NULL;
																	} else {
																		_g_free0 (_result_);
																		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																		g_clear_error (&_inner_error_);
																		return NULL;
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	result = _result_;
	return result;
}


static void tracker_sparql_query_parse_construct_property_list_not_empty (TrackerSparqlQuery* self, GHashTable* var_value_map, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (var_value_map != NULL);
	while (TRUE) {
		gchar* _tmp0_;
		gchar* old_predicate;
		gchar* _tmp1_;
		TrackerSparqlTokenType _tmp2_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		gboolean _tmp38_;
		gboolean _tmp39_;
		_tmp0_ = g_strdup (self->priv->current_predicate);
		old_predicate = _tmp0_;
		_tmp1_ = NULL;
		_g_free0 (self->priv->current_predicate);
		self->priv->current_predicate = _tmp1_;
		_tmp2_ = tracker_sparql_query_current (self);
		if (_tmp2_ == TRACKER_SPARQL_TOKEN_TYPE_VAR) {
			gchar* _tmp3_ = NULL;
			gchar* _tmp4_;
			gchar* _tmp5_ = NULL;
			gchar* _tmp6_;
			gconstpointer _tmp7_ = NULL;
			gchar* _tmp8_;
			gchar* _tmp9_;
			self->priv->current_predicate_is_var = TRUE;
			tracker_sparql_query_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (old_predicate);
					return;
				} else {
					_g_free0 (old_predicate);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			_tmp3_ = tracker_sparql_query_get_last_string (self, 0);
			_tmp4_ = _tmp3_;
			_tmp5_ = string_substring (_tmp4_, (glong) 1, (glong) (-1));
			_tmp6_ = _tmp5_;
			_tmp7_ = g_hash_table_lookup (var_value_map, _tmp6_);
			_tmp8_ = g_strdup ((const gchar*) _tmp7_);
			_tmp9_ = _tmp8_;
			_g_free0 (self->priv->current_predicate);
			self->priv->current_predicate = _tmp9_;
			_g_free0 (_tmp6_);
			_g_free0 (_tmp4_);
		} else {
			TrackerSparqlTokenType _tmp10_;
			_tmp10_ = tracker_sparql_query_current (self);
			if (_tmp10_ == TRACKER_SPARQL_TOKEN_TYPE_IRI_REF) {
				gchar* _tmp11_ = NULL;
				gchar* _tmp12_;
				tracker_sparql_query_next (self, &_inner_error_);
				if (_inner_error_ != NULL) {
					if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (old_predicate);
						return;
					} else {
						_g_free0 (old_predicate);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				_tmp11_ = tracker_sparql_query_get_last_string (self, 1);
				_tmp12_ = _tmp11_;
				_g_free0 (self->priv->current_predicate);
				self->priv->current_predicate = _tmp12_;
			} else {
				TrackerSparqlTokenType _tmp13_;
				_tmp13_ = tracker_sparql_query_current (self);
				if (_tmp13_ == TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX) {
					gchar* _tmp14_ = NULL;
					gchar* ns;
					gchar* _tmp15_ = NULL;
					gchar* _tmp16_;
					gchar* _tmp17_ = NULL;
					gchar* _tmp18_;
					gchar* _tmp19_ = NULL;
					gchar* _tmp20_;
					gchar* _tmp21_;
					gchar* _tmp22_;
					tracker_sparql_query_next (self, &_inner_error_);
					if (_inner_error_ != NULL) {
						if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (old_predicate);
							return;
						} else {
							_g_free0 (old_predicate);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					_tmp14_ = tracker_sparql_query_get_last_string (self, 0);
					ns = _tmp14_;
					tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
					if (_inner_error_ != NULL) {
						if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (ns);
							_g_free0 (old_predicate);
							return;
						} else {
							_g_free0 (ns);
							_g_free0 (old_predicate);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					_tmp15_ = tracker_sparql_query_get_last_string (self, 0);
					_tmp16_ = _tmp15_;
					_tmp17_ = string_substring (_tmp16_, (glong) 1, (glong) (-1));
					_tmp18_ = _tmp17_;
					_tmp19_ = tracker_sparql_query_resolve_prefixed_name (self, ns, _tmp18_, &_inner_error_);
					_tmp21_ = (_tmp20_ = _tmp19_, _g_free0 (_tmp18_), _g_free0 (_tmp16_), _tmp20_);
					if (_inner_error_ != NULL) {
						if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (ns);
							_g_free0 (old_predicate);
							return;
						} else {
							_g_free0 (ns);
							_g_free0 (old_predicate);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					_tmp22_ = _tmp21_;
					_g_free0 (self->priv->current_predicate);
					self->priv->current_predicate = _tmp22_;
					_g_free0 (ns);
				} else {
					TrackerSparqlTokenType _tmp23_;
					_tmp23_ = tracker_sparql_query_current (self);
					if (_tmp23_ == TRACKER_SPARQL_TOKEN_TYPE_COLON) {
						gchar* _tmp24_ = NULL;
						gchar* _tmp25_;
						gchar* _tmp26_ = NULL;
						gchar* _tmp27_;
						gchar* _tmp28_ = NULL;
						gchar* _tmp29_;
						gchar* _tmp30_;
						gchar* _tmp31_;
						tracker_sparql_query_next (self, &_inner_error_);
						if (_inner_error_ != NULL) {
							if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
								g_propagate_error (error, _inner_error_);
								_g_free0 (old_predicate);
								return;
							} else {
								_g_free0 (old_predicate);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
						}
						_tmp24_ = tracker_sparql_query_get_last_string (self, 0);
						_tmp25_ = _tmp24_;
						_tmp26_ = string_substring (_tmp25_, (glong) 1, (glong) (-1));
						_tmp27_ = _tmp26_;
						_tmp28_ = tracker_sparql_query_resolve_prefixed_name (self, "", _tmp27_, &_inner_error_);
						_tmp30_ = (_tmp29_ = _tmp28_, _g_free0 (_tmp27_), _g_free0 (_tmp25_), _tmp29_);
						if (_inner_error_ != NULL) {
							if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
								g_propagate_error (error, _inner_error_);
								_g_free0 (old_predicate);
								return;
							} else {
								_g_free0 (old_predicate);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
						}
						_tmp31_ = _tmp30_;
						_g_free0 (self->priv->current_predicate);
						self->priv->current_predicate = _tmp31_;
					} else {
						TrackerSparqlTokenType _tmp32_;
						_tmp32_ = tracker_sparql_query_current (self);
						if (_tmp32_ == TRACKER_SPARQL_TOKEN_TYPE_A) {
							gchar* _tmp33_;
							gchar* _tmp34_;
							tracker_sparql_query_next (self, &_inner_error_);
							if (_inner_error_ != NULL) {
								if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
									g_propagate_error (error, _inner_error_);
									_g_free0 (old_predicate);
									return;
								} else {
									_g_free0 (old_predicate);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
							}
							_tmp33_ = g_strdup ("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
							_tmp34_ = _tmp33_;
							_g_free0 (self->priv->current_predicate);
							self->priv->current_predicate = _tmp34_;
						} else {
							GError* _tmp35_ = NULL;
							_tmp35_ = tracker_sparql_query_get_error (self, "expected non-empty property list");
							_inner_error_ = _tmp35_;
							if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
								g_propagate_error (error, _inner_error_);
								_g_free0 (old_predicate);
								return;
							} else {
								_g_free0 (old_predicate);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
						}
					}
				}
			}
		}
		tracker_sparql_query_parse_construct_object_list (self, var_value_map, &_inner_error_);
		if (_inner_error_ != NULL) {
			if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (old_predicate);
				return;
			} else {
				_g_free0 (old_predicate);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp36_ = g_strdup (old_predicate);
		_tmp37_ = _tmp36_;
		_g_free0 (self->priv->current_predicate);
		self->priv->current_predicate = _tmp37_;
		_tmp38_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON, &_inner_error_);
		_tmp39_ = _tmp38_;
		if (_inner_error_ != NULL) {
			if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (old_predicate);
				return;
			} else {
				_g_free0 (old_predicate);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		if (_tmp39_) {
			_g_free0 (old_predicate);
			continue;
		}
		_g_free0 (old_predicate);
		break;
	}
}


static void tracker_sparql_query_parse_construct_object_list (TrackerSparqlQuery* self, GHashTable* var_value_map, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (var_value_map != NULL);
	while (TRUE) {
		gboolean _tmp0_;
		gboolean _tmp1_;
		tracker_sparql_query_parse_construct_object (self, var_value_map, &_inner_error_);
		if (_inner_error_ != NULL) {
			if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp0_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
		_tmp1_ = _tmp0_;
		if (_inner_error_ != NULL) {
			if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		if (_tmp1_) {
			continue;
		}
		break;
	}
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static void tracker_sparql_query_parse_construct_object (TrackerSparqlQuery* self, GHashTable* var_value_map, GError** error) {
	gchar* _tmp0_ = NULL;
	gchar* object;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (var_value_map != NULL);
	_tmp0_ = tracker_sparql_query_parse_construct_var_or_term (self, var_value_map, &_inner_error_);
	object = _tmp0_;
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (self->priv->current_subject == NULL) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = self->priv->current_predicate == NULL;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = object == NULL;
	}
	if (_tmp1_) {
		_g_free0 (object);
		return;
	}
	if (self->priv->delete_statements) {
		tracker_data_delete_statement (self->priv->current_graph, self->priv->current_subject, self->priv->current_predicate, object, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				goto __catch3_tracker_sparql_error;
			}
			if (_inner_error_->domain == TRACKER_DATE_ERROR) {
				goto __catch3_tracker_date_error;
			}
			_g_free0 (object);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	} else {
		tracker_data_insert_statement (self->priv->current_graph, self->priv->current_subject, self->priv->current_predicate, object, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				goto __catch3_tracker_sparql_error;
			}
			if (_inner_error_->domain == TRACKER_DATE_ERROR) {
				goto __catch3_tracker_date_error;
			}
			_g_free0 (object);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally3;
	__catch3_tracker_sparql_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		if (!self->priv->silent) {
			GError* _tmp3_;
			_tmp3_ = _g_error_copy0 (e);
			_inner_error_ = _tmp3_;
			_g_error_free0 (e);
			goto __finally3;
		}
		_g_error_free0 (e);
	}
	goto __finally3;
	__catch3_tracker_date_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		if (!self->priv->silent) {
			GError* _tmp4_ = NULL;
			_tmp4_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_TYPE, e->message);
			_inner_error_ = _tmp4_;
			_g_error_free0 (e);
			goto __finally3;
		}
		_g_error_free0 (e);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (object);
			return;
		} else {
			_g_free0 (object);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_free0 (object);
}


gboolean tracker_sparql_query_get_no_cache (TrackerSparqlQuery* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_no_cache;
	return result;
}


void tracker_sparql_query_set_no_cache (TrackerSparqlQuery* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_no_cache = value;
	g_object_notify ((GObject *) self, "no-cache");
}


static TrackerSparqlQueryTokenInfo* tracker_sparql_query_token_info_dup (const TrackerSparqlQueryTokenInfo* self) {
	TrackerSparqlQueryTokenInfo* dup;
	dup = g_new0 (TrackerSparqlQueryTokenInfo, 1);
	memcpy (dup, self, sizeof (TrackerSparqlQueryTokenInfo));
	return dup;
}


static void tracker_sparql_query_token_info_free (TrackerSparqlQueryTokenInfo* self) {
	g_free (self);
}


static GType tracker_sparql_query_token_info_get_type (void) {
	static volatile gsize tracker_sparql_query_token_info_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_query_token_info_type_id__volatile)) {
		GType tracker_sparql_query_token_info_type_id;
		tracker_sparql_query_token_info_type_id = g_boxed_type_register_static ("TrackerSparqlQueryTokenInfo", (GBoxedCopyFunc) tracker_sparql_query_token_info_dup, (GBoxedFreeFunc) tracker_sparql_query_token_info_free);
		g_once_init_leave (&tracker_sparql_query_token_info_type_id__volatile, tracker_sparql_query_token_info_type_id);
	}
	return tracker_sparql_query_token_info_type_id__volatile;
}


static void tracker_sparql_query_class_init (TrackerSparqlQueryClass * klass) {
	tracker_sparql_query_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TrackerSparqlQueryPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_tracker_sparql_query_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_tracker_sparql_query_set_property;
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_query_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_SPARQL_QUERY_NO_CACHE, g_param_spec_boolean ("no-cache", "no-cache", "no-cache", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void tracker_sparql_query_instance_init (TrackerSparqlQuery * self) {
	self->priv = TRACKER_SPARQL_QUERY_GET_PRIVATE (self);
	self->priv->bnodeid = 0;
	self->priv->anon_blank_node_open = FALSE;
}


static void tracker_sparql_query_finalize (GObject* obj) {
	TrackerSparqlQuery * self;
	self = TRACKER_SPARQL_QUERY (obj);
	_g_object_unref0 (self->priv->scanner);
	self->priv->tokens = (g_free (self->priv->tokens), NULL);
	_g_free0 (self->priv->query_string);
	_g_object_unref0 (self->expression);
	_g_object_unref0 (self->pattern);
	_g_free0 (self->priv->current_graph);
	_g_free0 (self->priv->current_subject);
	_g_free0 (self->priv->current_predicate);
	_g_hash_table_unref0 (self->priv->prefix_map);
	__g_list_free__g_object_unref0_0 (self->bindings);
	_tracker_sparql_context_unref0 (self->context);
	self->priv->base_uuid = (g_free (self->priv->base_uuid), NULL);
	_g_hash_table_unref0 (self->priv->blank_nodes);
	G_OBJECT_CLASS (tracker_sparql_query_parent_class)->finalize (obj);
}


GType tracker_sparql_query_get_type (void) {
	static volatile gsize tracker_sparql_query_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_query_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlQueryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_query_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlQuery), 0, (GInstanceInitFunc) tracker_sparql_query_instance_init, NULL };
		GType tracker_sparql_query_type_id;
		tracker_sparql_query_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerSparqlQuery", &g_define_type_info, 0);
		g_once_init_leave (&tracker_sparql_query_type_id__volatile, tracker_sparql_query_type_id);
	}
	return tracker_sparql_query_type_id__volatile;
}


static void _vala_tracker_sparql_query_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TrackerSparqlQuery * self;
	self = TRACKER_SPARQL_QUERY (object);
	switch (property_id) {
		case TRACKER_SPARQL_QUERY_NO_CACHE:
		g_value_set_boolean (value, tracker_sparql_query_get_no_cache (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_tracker_sparql_query_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TrackerSparqlQuery * self;
	self = TRACKER_SPARQL_QUERY (object);
	switch (property_id) {
		case TRACKER_SPARQL_QUERY_NO_CACHE:
		tracker_sparql_query_set_no_cache (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



