/* tracker-sparql-scanner.c generated by valac 0.14.1, the Vala compiler
 * generated from tracker-sparql-scanner.vala, do not modify */

/*
 * Copyright (C) 2009, Nokia
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libtracker-sparql/tracker-sparql.h>
#include <stdlib.h>
#include <string.h>


#define TRACKER_TYPE_SPARQL_SCANNER (tracker_sparql_scanner_get_type ())
#define TRACKER_SPARQL_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_SPARQL_SCANNER, TrackerSparqlScanner))
#define TRACKER_SPARQL_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_SPARQL_SCANNER, TrackerSparqlScannerClass))
#define TRACKER_IS_SPARQL_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_SPARQL_SCANNER))
#define TRACKER_IS_SPARQL_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_SPARQL_SCANNER))
#define TRACKER_SPARQL_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_SPARQL_SCANNER, TrackerSparqlScannerClass))

typedef struct _TrackerSparqlScanner TrackerSparqlScanner;
typedef struct _TrackerSparqlScannerClass TrackerSparqlScannerClass;
typedef struct _TrackerSparqlScannerPrivate TrackerSparqlScannerPrivate;

#define TRACKER_TYPE_SOURCE_LOCATION (tracker_source_location_get_type ())
typedef struct _TrackerSourceLocation TrackerSourceLocation;

#define TRACKER_TYPE_SPARQL_TOKEN_TYPE (tracker_sparql_token_type_get_type ())

struct _TrackerSparqlScanner {
	GObject parent_instance;
	TrackerSparqlScannerPrivate * priv;
};

struct _TrackerSparqlScannerClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlScannerPrivate {
	gchar* current;
	gchar* end;
	gint line;
	gint column;
};

struct _TrackerSourceLocation {
	gchar* pos;
	gint line;
	gint column;
};

typedef enum  {
	TRACKER_SPARQL_TOKEN_TYPE_NONE,
	TRACKER_SPARQL_TOKEN_TYPE_A,
	TRACKER_SPARQL_TOKEN_TYPE_AS,
	TRACKER_SPARQL_TOKEN_TYPE_ASC,
	TRACKER_SPARQL_TOKEN_TYPE_ASK,
	TRACKER_SPARQL_TOKEN_TYPE_ATBASE,
	TRACKER_SPARQL_TOKEN_TYPE_ATPREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_AVG,
	TRACKER_SPARQL_TOKEN_TYPE_BASE,
	TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE,
	TRACKER_SPARQL_TOKEN_TYPE_BOUND,
	TRACKER_SPARQL_TOKEN_TYPE_BY,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACKET,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS,
	TRACKER_SPARQL_TOKEN_TYPE_COALESCE,
	TRACKER_SPARQL_TOKEN_TYPE_COLON,
	TRACKER_SPARQL_TOKEN_TYPE_COMMA,
	TRACKER_SPARQL_TOKEN_TYPE_CONSTRUCT,
	TRACKER_SPARQL_TOKEN_TYPE_COUNT,
	TRACKER_SPARQL_TOKEN_TYPE_DATA,
	TRACKER_SPARQL_TOKEN_TYPE_DATATYPE,
	TRACKER_SPARQL_TOKEN_TYPE_DECIMAL,
	TRACKER_SPARQL_TOKEN_TYPE_DELETE,
	TRACKER_SPARQL_TOKEN_TYPE_DESC,
	TRACKER_SPARQL_TOKEN_TYPE_DESCRIBE,
	TRACKER_SPARQL_TOKEN_TYPE_DISTINCT,
	TRACKER_SPARQL_TOKEN_TYPE_DIV,
	TRACKER_SPARQL_TOKEN_TYPE_DOT,
	TRACKER_SPARQL_TOKEN_TYPE_DOUBLE,
	TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX,
	TRACKER_SPARQL_TOKEN_TYPE_DROP,
	TRACKER_SPARQL_TOKEN_TYPE_EOF,
	TRACKER_SPARQL_TOKEN_TYPE_EXISTS,
	TRACKER_SPARQL_TOKEN_TYPE_FALSE,
	TRACKER_SPARQL_TOKEN_TYPE_FILTER,
	TRACKER_SPARQL_TOKEN_TYPE_FROM,
	TRACKER_SPARQL_TOKEN_TYPE_GRAPH,
	TRACKER_SPARQL_TOKEN_TYPE_GROUP,
	TRACKER_SPARQL_TOKEN_TYPE_GROUP_CONCAT,
	TRACKER_SPARQL_TOKEN_TYPE_HAVING,
	TRACKER_SPARQL_TOKEN_TYPE_IF,
	TRACKER_SPARQL_TOKEN_TYPE_INSERT,
	TRACKER_SPARQL_TOKEN_TYPE_INTEGER,
	TRACKER_SPARQL_TOKEN_TYPE_INTO,
	TRACKER_SPARQL_TOKEN_TYPE_IRI_REF,
	TRACKER_SPARQL_TOKEN_TYPE_ISBLANK,
	TRACKER_SPARQL_TOKEN_TYPE_ISIRI,
	TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL,
	TRACKER_SPARQL_TOKEN_TYPE_ISURI,
	TRACKER_SPARQL_TOKEN_TYPE_LANG,
	TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES,
	TRACKER_SPARQL_TOKEN_TYPE_LIMIT,
	TRACKER_SPARQL_TOKEN_TYPE_MAX,
	TRACKER_SPARQL_TOKEN_TYPE_MIN,
	TRACKER_SPARQL_TOKEN_TYPE_MINUS,
	TRACKER_SPARQL_TOKEN_TYPE_NAMED,
	TRACKER_SPARQL_TOKEN_TYPE_NOT,
	TRACKER_SPARQL_TOKEN_TYPE_NULL,
	TRACKER_SPARQL_TOKEN_TYPE_OFFSET,
	TRACKER_SPARQL_TOKEN_TYPE_OP_AND,
	TRACKER_SPARQL_TOKEN_TYPE_OP_EQ,
	TRACKER_SPARQL_TOKEN_TYPE_OP_GE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_GT,
	TRACKER_SPARQL_TOKEN_TYPE_OP_LE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_LT,
	TRACKER_SPARQL_TOKEN_TYPE_OP_NE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_NEG,
	TRACKER_SPARQL_TOKEN_TYPE_OP_OR,
	TRACKER_SPARQL_TOKEN_TYPE_OP_IN,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS,
	TRACKER_SPARQL_TOKEN_TYPE_OPTIONAL,
	TRACKER_SPARQL_TOKEN_TYPE_OR,
	TRACKER_SPARQL_TOKEN_TYPE_ORDER,
	TRACKER_SPARQL_TOKEN_TYPE_PLUS,
	TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_PREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_REDUCED,
	TRACKER_SPARQL_TOKEN_TYPE_REGEX,
	TRACKER_SPARQL_TOKEN_TYPE_REPLACE,
	TRACKER_SPARQL_TOKEN_TYPE_SAMETERM,
	TRACKER_SPARQL_TOKEN_TYPE_SELECT,
	TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON,
	TRACKER_SPARQL_TOKEN_TYPE_SILENT,
	TRACKER_SPARQL_TOKEN_TYPE_STAR,
	TRACKER_SPARQL_TOKEN_TYPE_STR,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2,
	TRACKER_SPARQL_TOKEN_TYPE_SUM,
	TRACKER_SPARQL_TOKEN_TYPE_TRUE,
	TRACKER_SPARQL_TOKEN_TYPE_UNION,
	TRACKER_SPARQL_TOKEN_TYPE_VAR,
	TRACKER_SPARQL_TOKEN_TYPE_WHERE,
	TRACKER_SPARQL_TOKEN_TYPE_WITH
} TrackerSparqlTokenType;


static gpointer tracker_sparql_scanner_parent_class = NULL;

GType tracker_sparql_scanner_get_type (void) G_GNUC_CONST;
#define TRACKER_SPARQL_SCANNER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_TYPE_SPARQL_SCANNER, TrackerSparqlScannerPrivate))
enum  {
	TRACKER_SPARQL_SCANNER_DUMMY_PROPERTY
};
TrackerSparqlScanner* tracker_sparql_scanner_new (gchar* input, gsize len);
TrackerSparqlScanner* tracker_sparql_scanner_construct (GType object_type, gchar* input, gsize len);
GType tracker_source_location_get_type (void) G_GNUC_CONST;
TrackerSourceLocation* tracker_source_location_dup (const TrackerSourceLocation* self);
void tracker_source_location_free (TrackerSourceLocation* self);
void tracker_sparql_scanner_seek (TrackerSparqlScanner* self, TrackerSourceLocation* location);
GType tracker_sparql_token_type_get_type (void) G_GNUC_CONST;
static TrackerSparqlTokenType tracker_sparql_scanner_get_identifier_or_keyword (TrackerSparqlScanner* self, gchar* begin, gint len);
static gboolean tracker_sparql_scanner_matches (TrackerSparqlScanner* self, gchar* begin, const gchar* keyword);
static TrackerSparqlTokenType tracker_sparql_scanner_read_number (TrackerSparqlScanner* self);
static gboolean tracker_sparql_scanner_is_pn_char (TrackerSparqlScanner* self, gchar c);
static gboolean tracker_sparql_scanner_is_pn_local_char (TrackerSparqlScanner* self, gchar c);
static gboolean tracker_sparql_scanner_is_varname_char (TrackerSparqlScanner* self, gchar c);
TrackerSparqlTokenType tracker_sparql_scanner_read_token (TrackerSparqlScanner* self, TrackerSourceLocation* token_begin, TrackerSourceLocation* token_end, GError** error);
static void tracker_sparql_scanner_space (TrackerSparqlScanner* self);
void tracker_source_location_init (TrackerSourceLocation *self, gchar* pos, gint line, gint column);
static gboolean tracker_sparql_scanner_whitespace (TrackerSparqlScanner* self);
static gboolean tracker_sparql_scanner_comment (TrackerSparqlScanner* self);
static void tracker_sparql_scanner_finalize (GObject* obj);
const gchar* tracker_sparql_token_type_to_string (TrackerSparqlTokenType self);


TrackerSparqlScanner* tracker_sparql_scanner_construct (GType object_type, gchar* input, gsize len) {
	TrackerSparqlScanner * self = NULL;
	gchar* _tmp0_;
	gchar* begin;
	gsize _tmp1_;
#line 27 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	self = (TrackerSparqlScanner*) g_object_new (object_type, NULL);
#line 28 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp0_ = input;
#line 28 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	begin = _tmp0_;
#line 29 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp1_ = len;
#line 29 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	self->priv->end = begin + _tmp1_;
#line 31 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	self->priv->current = begin;
#line 33 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	self->priv->line = 1;
#line 34 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	self->priv->column = 1;
#line 27 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	return self;
#line 223 "tracker-sparql-scanner.c"
}


TrackerSparqlScanner* tracker_sparql_scanner_new (gchar* input, gsize len) {
#line 27 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	return tracker_sparql_scanner_construct (TRACKER_TYPE_SPARQL_SCANNER, input, len);
#line 230 "tracker-sparql-scanner.c"
}


void tracker_sparql_scanner_seek (TrackerSparqlScanner* self, TrackerSourceLocation* location) {
	TrackerSourceLocation _tmp0_;
	gchar* _tmp1_;
	TrackerSourceLocation _tmp2_;
	gint _tmp3_;
	TrackerSourceLocation _tmp4_;
	gint _tmp5_;
#line 37 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	g_return_if_fail (self != NULL);
#line 37 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	g_return_if_fail (location != NULL);
#line 38 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp0_ = *location;
#line 38 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp1_ = _tmp0_.pos;
#line 38 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	self->priv->current = _tmp1_;
#line 39 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp2_ = *location;
#line 39 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp3_ = _tmp2_.line;
#line 39 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	self->priv->line = _tmp3_;
#line 40 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp4_ = *location;
#line 40 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp5_ = _tmp4_.column;
#line 40 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	self->priv->column = _tmp5_;
#line 263 "tracker-sparql-scanner.c"
}


static TrackerSparqlTokenType tracker_sparql_scanner_get_identifier_or_keyword (TrackerSparqlScanner* self, gchar* begin, gint len) {
	TrackerSparqlTokenType result = 0;
	gint _tmp0_;
#line 43 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 44 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp0_ = len;
#line 44 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	switch (_tmp0_) {
#line 44 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case 1:
#line 278 "tracker-sparql-scanner.c"
		{
			gchar* _tmp1_;
			gchar _tmp2_;
#line 46 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp1_ = begin;
#line 46 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp2_ = _tmp1_[0];
#line 46 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			switch (_tmp2_) {
#line 46 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'A':
#line 46 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'a':
#line 292 "tracker-sparql-scanner.c"
				{
#line 49 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					result = TRACKER_SPARQL_TOKEN_TYPE_A;
#line 49 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					return result;
#line 298 "tracker-sparql-scanner.c"
				}
				default:
#line 46 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				break;
#line 303 "tracker-sparql-scanner.c"
			}
#line 51 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			break;
#line 307 "tracker-sparql-scanner.c"
		}
#line 44 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case 2:
#line 311 "tracker-sparql-scanner.c"
		{
			gchar* _tmp3_;
			gchar _tmp4_;
#line 53 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp3_ = begin;
#line 53 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp4_ = _tmp3_[0];
#line 53 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			switch (_tmp4_) {
#line 53 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'A':
#line 53 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'a':
#line 325 "tracker-sparql-scanner.c"
				{
					gchar* _tmp5_;
					gboolean _tmp6_ = FALSE;
#line 56 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp5_ = begin;
#line 56 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp6_ = tracker_sparql_scanner_matches (self, _tmp5_, "AS");
#line 56 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp6_) {
#line 56 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_AS;
#line 56 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 339 "tracker-sparql-scanner.c"
					}
#line 57 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 343 "tracker-sparql-scanner.c"
				}
#line 53 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'B':
#line 53 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'b':
#line 349 "tracker-sparql-scanner.c"
				{
					gchar* _tmp7_;
					gboolean _tmp8_ = FALSE;
#line 60 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp7_ = begin;
#line 60 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp8_ = tracker_sparql_scanner_matches (self, _tmp7_, "BY");
#line 60 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp8_) {
#line 60 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_BY;
#line 60 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 363 "tracker-sparql-scanner.c"
					}
#line 61 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 367 "tracker-sparql-scanner.c"
				}
#line 53 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'i':
#line 53 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'I':
#line 373 "tracker-sparql-scanner.c"
				{
					gchar* _tmp9_;
					gchar _tmp10_;
#line 64 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp9_ = begin;
#line 64 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp10_ = _tmp9_[1];
#line 64 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					switch (_tmp10_) {
#line 64 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'F':
#line 64 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'f':
#line 387 "tracker-sparql-scanner.c"
						{
							gchar* _tmp11_;
							gboolean _tmp12_ = FALSE;
#line 67 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp11_ = begin;
#line 67 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp12_ = tracker_sparql_scanner_matches (self, _tmp11_, "IF");
#line 67 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp12_) {
#line 67 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_IF;
#line 67 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 401 "tracker-sparql-scanner.c"
							}
#line 68 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 405 "tracker-sparql-scanner.c"
						}
#line 64 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'N':
#line 64 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'n':
#line 411 "tracker-sparql-scanner.c"
						{
							gchar* _tmp13_;
							gboolean _tmp14_ = FALSE;
#line 71 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp13_ = begin;
#line 71 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp14_ = tracker_sparql_scanner_matches (self, _tmp13_, "IN");
#line 71 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp14_) {
#line 71 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_OP_IN;
#line 71 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 425 "tracker-sparql-scanner.c"
							}
#line 72 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 429 "tracker-sparql-scanner.c"
						}
						default:
#line 64 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 434 "tracker-sparql-scanner.c"
					}
#line 74 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 438 "tracker-sparql-scanner.c"
				}
#line 53 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'O':
#line 53 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'o':
#line 444 "tracker-sparql-scanner.c"
				{
					gchar* _tmp15_;
					gboolean _tmp16_ = FALSE;
#line 77 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp15_ = begin;
#line 77 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp16_ = tracker_sparql_scanner_matches (self, _tmp15_, "OR");
#line 77 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp16_) {
#line 77 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_OR;
#line 77 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 458 "tracker-sparql-scanner.c"
					}
#line 78 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 462 "tracker-sparql-scanner.c"
				}
				default:
#line 53 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				break;
#line 467 "tracker-sparql-scanner.c"
			}
#line 80 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			break;
#line 471 "tracker-sparql-scanner.c"
		}
#line 44 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case 3:
#line 475 "tracker-sparql-scanner.c"
		{
			gchar* _tmp17_;
			gchar _tmp18_;
#line 82 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp17_ = begin;
#line 82 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp18_ = _tmp17_[0];
#line 82 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			switch (_tmp18_) {
#line 82 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'A':
#line 82 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'a':
#line 489 "tracker-sparql-scanner.c"
				{
					gchar* _tmp19_;
					gchar _tmp20_;
#line 85 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp19_ = begin;
#line 85 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp20_ = _tmp19_[1];
#line 85 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					switch (_tmp20_) {
#line 85 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'S':
#line 85 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 's':
#line 503 "tracker-sparql-scanner.c"
						{
							gchar* _tmp21_;
							gchar _tmp22_;
#line 88 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp21_ = begin;
#line 88 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp22_ = _tmp21_[2];
#line 88 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							switch (_tmp22_) {
#line 88 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								case 'C':
#line 88 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								case 'c':
#line 517 "tracker-sparql-scanner.c"
								{
									gchar* _tmp23_;
									gboolean _tmp24_ = FALSE;
#line 91 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp23_ = begin;
#line 91 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp24_ = tracker_sparql_scanner_matches (self, _tmp23_, "ASC");
#line 91 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									if (_tmp24_) {
#line 91 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										result = TRACKER_SPARQL_TOKEN_TYPE_ASC;
#line 91 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										return result;
#line 531 "tracker-sparql-scanner.c"
									}
#line 92 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									break;
#line 535 "tracker-sparql-scanner.c"
								}
#line 88 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								case 'K':
#line 88 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								case 'k':
#line 541 "tracker-sparql-scanner.c"
								{
									gchar* _tmp25_;
									gboolean _tmp26_ = FALSE;
#line 95 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp25_ = begin;
#line 95 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp26_ = tracker_sparql_scanner_matches (self, _tmp25_, "ASK");
#line 95 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									if (_tmp26_) {
#line 95 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										result = TRACKER_SPARQL_TOKEN_TYPE_ASK;
#line 95 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										return result;
#line 555 "tracker-sparql-scanner.c"
									}
#line 96 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									break;
#line 559 "tracker-sparql-scanner.c"
								}
								default:
#line 88 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								break;
#line 564 "tracker-sparql-scanner.c"
							}
#line 98 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 568 "tracker-sparql-scanner.c"
						}
#line 85 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'V':
#line 85 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'v':
#line 574 "tracker-sparql-scanner.c"
						{
							gchar* _tmp27_;
							gboolean _tmp28_ = FALSE;
#line 101 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp27_ = begin;
#line 101 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp28_ = tracker_sparql_scanner_matches (self, _tmp27_, "AVG");
#line 101 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp28_) {
#line 101 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_AVG;
#line 101 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 588 "tracker-sparql-scanner.c"
							}
#line 102 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 592 "tracker-sparql-scanner.c"
						}
						default:
#line 85 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 597 "tracker-sparql-scanner.c"
					}
#line 104 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 601 "tracker-sparql-scanner.c"
				}
#line 82 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'M':
#line 82 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'm':
#line 607 "tracker-sparql-scanner.c"
				{
					gchar* _tmp29_;
					gchar _tmp30_;
#line 107 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp29_ = begin;
#line 107 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp30_ = _tmp29_[1];
#line 107 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					switch (_tmp30_) {
#line 107 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'A':
#line 107 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'a':
#line 621 "tracker-sparql-scanner.c"
						{
							gchar* _tmp31_;
							gboolean _tmp32_ = FALSE;
#line 110 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp31_ = begin;
#line 110 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp32_ = tracker_sparql_scanner_matches (self, _tmp31_, "MAX");
#line 110 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp32_) {
#line 110 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_MAX;
#line 110 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 635 "tracker-sparql-scanner.c"
							}
#line 111 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 639 "tracker-sparql-scanner.c"
						}
#line 107 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'I':
#line 107 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'i':
#line 645 "tracker-sparql-scanner.c"
						{
							gchar* _tmp33_;
							gboolean _tmp34_ = FALSE;
#line 114 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp33_ = begin;
#line 114 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp34_ = tracker_sparql_scanner_matches (self, _tmp33_, "MIN");
#line 114 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp34_) {
#line 114 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_MIN;
#line 114 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 659 "tracker-sparql-scanner.c"
							}
#line 115 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 663 "tracker-sparql-scanner.c"
						}
						default:
#line 107 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 668 "tracker-sparql-scanner.c"
					}
#line 117 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 672 "tracker-sparql-scanner.c"
				}
#line 82 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'N':
#line 82 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'n':
#line 678 "tracker-sparql-scanner.c"
				{
					gchar* _tmp35_;
					gboolean _tmp36_ = FALSE;
#line 120 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp35_ = begin;
#line 120 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp36_ = tracker_sparql_scanner_matches (self, _tmp35_, "NOT");
#line 120 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp36_) {
#line 120 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_NOT;
#line 120 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 692 "tracker-sparql-scanner.c"
					}
#line 121 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 696 "tracker-sparql-scanner.c"
				}
#line 82 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'S':
#line 82 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 's':
#line 702 "tracker-sparql-scanner.c"
				{
					gchar* _tmp37_;
					gchar _tmp38_;
#line 124 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp37_ = begin;
#line 124 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp38_ = _tmp37_[1];
#line 124 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					switch (_tmp38_) {
#line 124 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'T':
#line 124 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 't':
#line 716 "tracker-sparql-scanner.c"
						{
							gchar* _tmp39_;
							gboolean _tmp40_ = FALSE;
#line 127 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp39_ = begin;
#line 127 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp40_ = tracker_sparql_scanner_matches (self, _tmp39_, "STR");
#line 127 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp40_) {
#line 127 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_STR;
#line 127 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 730 "tracker-sparql-scanner.c"
							}
#line 128 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 734 "tracker-sparql-scanner.c"
						}
#line 124 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'U':
#line 124 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'u':
#line 740 "tracker-sparql-scanner.c"
						{
							gchar* _tmp41_;
							gboolean _tmp42_ = FALSE;
#line 131 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp41_ = begin;
#line 131 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp42_ = tracker_sparql_scanner_matches (self, _tmp41_, "SUM");
#line 131 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp42_) {
#line 131 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_SUM;
#line 131 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 754 "tracker-sparql-scanner.c"
							}
#line 132 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 758 "tracker-sparql-scanner.c"
						}
						default:
#line 124 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 763 "tracker-sparql-scanner.c"
					}
#line 134 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 767 "tracker-sparql-scanner.c"
				}
				default:
#line 82 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				break;
#line 772 "tracker-sparql-scanner.c"
			}
#line 136 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			break;
#line 776 "tracker-sparql-scanner.c"
		}
#line 44 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case 4:
#line 780 "tracker-sparql-scanner.c"
		{
			gchar* _tmp43_;
			gchar _tmp44_;
#line 138 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp43_ = begin;
#line 138 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp44_ = _tmp43_[0];
#line 138 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			switch (_tmp44_) {
#line 138 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'B':
#line 138 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'b':
#line 794 "tracker-sparql-scanner.c"
				{
					gchar* _tmp45_;
					gboolean _tmp46_ = FALSE;
#line 141 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp45_ = begin;
#line 141 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp46_ = tracker_sparql_scanner_matches (self, _tmp45_, "BASE");
#line 141 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp46_) {
#line 141 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_BASE;
#line 141 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 808 "tracker-sparql-scanner.c"
					}
#line 142 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 812 "tracker-sparql-scanner.c"
				}
#line 138 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'D':
#line 138 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'd':
#line 818 "tracker-sparql-scanner.c"
				{
					gchar* _tmp47_;
					gchar _tmp48_;
#line 145 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp47_ = begin;
#line 145 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp48_ = _tmp47_[1];
#line 145 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					switch (_tmp48_) {
#line 145 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'A':
#line 145 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'a':
#line 832 "tracker-sparql-scanner.c"
						{
							gchar* _tmp49_;
							gboolean _tmp50_ = FALSE;
#line 148 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp49_ = begin;
#line 148 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp50_ = tracker_sparql_scanner_matches (self, _tmp49_, "DATA");
#line 148 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp50_) {
#line 148 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_DATA;
#line 148 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 846 "tracker-sparql-scanner.c"
							}
#line 149 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 850 "tracker-sparql-scanner.c"
						}
#line 145 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'E':
#line 145 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'e':
#line 856 "tracker-sparql-scanner.c"
						{
							gchar* _tmp51_;
							gboolean _tmp52_ = FALSE;
#line 152 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp51_ = begin;
#line 152 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp52_ = tracker_sparql_scanner_matches (self, _tmp51_, "DESC");
#line 152 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp52_) {
#line 152 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_DESC;
#line 152 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 870 "tracker-sparql-scanner.c"
							}
#line 153 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 874 "tracker-sparql-scanner.c"
						}
#line 145 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'R':
#line 145 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'r':
#line 880 "tracker-sparql-scanner.c"
						{
							gchar* _tmp53_;
							gboolean _tmp54_ = FALSE;
#line 156 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp53_ = begin;
#line 156 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp54_ = tracker_sparql_scanner_matches (self, _tmp53_, "DROP");
#line 156 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp54_) {
#line 156 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_DROP;
#line 156 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 894 "tracker-sparql-scanner.c"
							}
#line 157 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 898 "tracker-sparql-scanner.c"
						}
						default:
#line 145 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 903 "tracker-sparql-scanner.c"
					}
#line 159 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 907 "tracker-sparql-scanner.c"
				}
#line 138 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'F':
#line 138 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'f':
#line 913 "tracker-sparql-scanner.c"
				{
					gchar* _tmp55_;
					gboolean _tmp56_ = FALSE;
#line 162 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp55_ = begin;
#line 162 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp56_ = tracker_sparql_scanner_matches (self, _tmp55_, "FROM");
#line 162 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp56_) {
#line 162 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_FROM;
#line 162 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 927 "tracker-sparql-scanner.c"
					}
#line 163 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 931 "tracker-sparql-scanner.c"
				}
#line 138 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'I':
#line 138 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'i':
#line 937 "tracker-sparql-scanner.c"
				{
					gchar* _tmp57_;
					gboolean _tmp58_ = FALSE;
#line 166 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp57_ = begin;
#line 166 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp58_ = tracker_sparql_scanner_matches (self, _tmp57_, "INTO");
#line 166 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp58_) {
#line 166 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_INTO;
#line 166 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 951 "tracker-sparql-scanner.c"
					}
#line 167 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 955 "tracker-sparql-scanner.c"
				}
#line 138 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'L':
#line 138 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'l':
#line 961 "tracker-sparql-scanner.c"
				{
					gchar* _tmp59_;
					gboolean _tmp60_ = FALSE;
#line 170 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp59_ = begin;
#line 170 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp60_ = tracker_sparql_scanner_matches (self, _tmp59_, "LANG");
#line 170 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp60_) {
#line 170 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_LANG;
#line 170 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 975 "tracker-sparql-scanner.c"
					}
#line 171 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 979 "tracker-sparql-scanner.c"
				}
#line 138 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'N':
#line 138 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'n':
#line 985 "tracker-sparql-scanner.c"
				{
					gchar* _tmp61_;
					gboolean _tmp62_ = FALSE;
#line 174 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp61_ = begin;
#line 174 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp62_ = tracker_sparql_scanner_matches (self, _tmp61_, "NULL");
#line 174 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp62_) {
#line 174 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_NULL;
#line 174 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 999 "tracker-sparql-scanner.c"
					}
#line 175 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1003 "tracker-sparql-scanner.c"
				}
#line 138 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'T':
#line 138 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 't':
#line 1009 "tracker-sparql-scanner.c"
				{
					gchar* _tmp63_;
					gboolean _tmp64_ = FALSE;
#line 178 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp63_ = begin;
#line 178 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp64_ = tracker_sparql_scanner_matches (self, _tmp63_, "TRUE");
#line 178 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp64_) {
#line 178 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_TRUE;
#line 178 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1023 "tracker-sparql-scanner.c"
					}
#line 179 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1027 "tracker-sparql-scanner.c"
				}
#line 138 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'W':
#line 138 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'w':
#line 1033 "tracker-sparql-scanner.c"
				{
					gchar* _tmp65_;
					gboolean _tmp66_ = FALSE;
#line 182 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp65_ = begin;
#line 182 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp66_ = tracker_sparql_scanner_matches (self, _tmp65_, "WITH");
#line 182 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp66_) {
#line 182 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_WITH;
#line 182 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1047 "tracker-sparql-scanner.c"
					}
#line 183 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1051 "tracker-sparql-scanner.c"
				}
				default:
#line 138 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				break;
#line 1056 "tracker-sparql-scanner.c"
			}
#line 185 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			break;
#line 1060 "tracker-sparql-scanner.c"
		}
#line 44 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case 5:
#line 1064 "tracker-sparql-scanner.c"
		{
			gchar* _tmp67_;
			gchar _tmp68_;
#line 187 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp67_ = begin;
#line 187 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp68_ = _tmp67_[0];
#line 187 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			switch (_tmp68_) {
#line 187 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'B':
#line 187 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'b':
#line 1078 "tracker-sparql-scanner.c"
				{
					gchar* _tmp69_;
					gboolean _tmp70_ = FALSE;
#line 190 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp69_ = begin;
#line 190 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp70_ = tracker_sparql_scanner_matches (self, _tmp69_, "BOUND");
#line 190 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp70_) {
#line 190 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_BOUND;
#line 190 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1092 "tracker-sparql-scanner.c"
					}
#line 191 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1096 "tracker-sparql-scanner.c"
				}
#line 187 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'C':
#line 187 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'c':
#line 1102 "tracker-sparql-scanner.c"
				{
					gchar* _tmp71_;
					gboolean _tmp72_ = FALSE;
#line 194 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp71_ = begin;
#line 194 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp72_ = tracker_sparql_scanner_matches (self, _tmp71_, "COUNT");
#line 194 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp72_) {
#line 194 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_COUNT;
#line 194 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1116 "tracker-sparql-scanner.c"
					}
#line 195 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1120 "tracker-sparql-scanner.c"
				}
#line 187 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'G':
#line 187 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'g':
#line 1126 "tracker-sparql-scanner.c"
				{
					gchar* _tmp73_;
					gchar _tmp74_;
#line 198 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp73_ = begin;
#line 198 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp74_ = _tmp73_[2];
#line 198 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					switch (_tmp74_) {
#line 198 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'A':
#line 198 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'a':
#line 1140 "tracker-sparql-scanner.c"
						{
							gchar* _tmp75_;
							gboolean _tmp76_ = FALSE;
#line 201 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp75_ = begin;
#line 201 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp76_ = tracker_sparql_scanner_matches (self, _tmp75_, "GRAPH");
#line 201 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp76_) {
#line 201 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_GRAPH;
#line 201 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 1154 "tracker-sparql-scanner.c"
							}
#line 202 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 1158 "tracker-sparql-scanner.c"
						}
#line 198 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'O':
#line 198 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'o':
#line 1164 "tracker-sparql-scanner.c"
						{
							gchar* _tmp77_;
							gboolean _tmp78_ = FALSE;
#line 205 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp77_ = begin;
#line 205 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp78_ = tracker_sparql_scanner_matches (self, _tmp77_, "GROUP");
#line 205 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp78_) {
#line 205 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_GROUP;
#line 205 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 1178 "tracker-sparql-scanner.c"
							}
#line 206 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 1182 "tracker-sparql-scanner.c"
						}
						default:
#line 198 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 1187 "tracker-sparql-scanner.c"
					}
#line 208 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1191 "tracker-sparql-scanner.c"
				}
#line 187 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'L':
#line 187 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'l':
#line 1197 "tracker-sparql-scanner.c"
				{
					gchar* _tmp79_;
					gboolean _tmp80_ = FALSE;
#line 211 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp79_ = begin;
#line 211 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp80_ = tracker_sparql_scanner_matches (self, _tmp79_, "LIMIT");
#line 211 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp80_) {
#line 211 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_LIMIT;
#line 211 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1211 "tracker-sparql-scanner.c"
					}
#line 212 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1215 "tracker-sparql-scanner.c"
				}
#line 187 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'N':
#line 187 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'n':
#line 1221 "tracker-sparql-scanner.c"
				{
					gchar* _tmp81_;
					gboolean _tmp82_ = FALSE;
#line 215 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp81_ = begin;
#line 215 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp82_ = tracker_sparql_scanner_matches (self, _tmp81_, "NAMED");
#line 215 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp82_) {
#line 215 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_NAMED;
#line 215 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1235 "tracker-sparql-scanner.c"
					}
#line 216 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1239 "tracker-sparql-scanner.c"
				}
#line 187 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'O':
#line 187 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'o':
#line 1245 "tracker-sparql-scanner.c"
				{
					gchar* _tmp83_;
					gboolean _tmp84_ = FALSE;
#line 219 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp83_ = begin;
#line 219 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp84_ = tracker_sparql_scanner_matches (self, _tmp83_, "ORDER");
#line 219 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp84_) {
#line 219 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_ORDER;
#line 219 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1259 "tracker-sparql-scanner.c"
					}
#line 220 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1263 "tracker-sparql-scanner.c"
				}
#line 187 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'R':
#line 187 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'r':
#line 1269 "tracker-sparql-scanner.c"
				{
					gchar* _tmp85_;
					gboolean _tmp86_ = FALSE;
#line 223 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp85_ = begin;
#line 223 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp86_ = tracker_sparql_scanner_matches (self, _tmp85_, "REGEX");
#line 223 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp86_) {
#line 223 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_REGEX;
#line 223 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1283 "tracker-sparql-scanner.c"
					}
#line 224 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1287 "tracker-sparql-scanner.c"
				}
#line 187 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'U':
#line 187 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'u':
#line 1293 "tracker-sparql-scanner.c"
				{
					gchar* _tmp87_;
					gboolean _tmp88_ = FALSE;
#line 227 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp87_ = begin;
#line 227 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp88_ = tracker_sparql_scanner_matches (self, _tmp87_, "UNION");
#line 227 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp88_) {
#line 227 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_UNION;
#line 227 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1307 "tracker-sparql-scanner.c"
					}
#line 228 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1311 "tracker-sparql-scanner.c"
				}
#line 187 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'W':
#line 187 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'w':
#line 1317 "tracker-sparql-scanner.c"
				{
					gchar* _tmp89_;
					gboolean _tmp90_ = FALSE;
#line 231 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp89_ = begin;
#line 231 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp90_ = tracker_sparql_scanner_matches (self, _tmp89_, "WHERE");
#line 231 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp90_) {
#line 231 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_WHERE;
#line 231 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1331 "tracker-sparql-scanner.c"
					}
#line 232 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1335 "tracker-sparql-scanner.c"
				}
#line 187 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'F':
#line 187 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'f':
#line 1341 "tracker-sparql-scanner.c"
				{
					gchar* _tmp91_;
					gboolean _tmp92_ = FALSE;
#line 235 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp91_ = begin;
#line 235 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp92_ = tracker_sparql_scanner_matches (self, _tmp91_, "FALSE");
#line 235 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp92_) {
#line 235 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_FALSE;
#line 235 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1355 "tracker-sparql-scanner.c"
					}
#line 236 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1359 "tracker-sparql-scanner.c"
				}
#line 187 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'I':
#line 187 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'i':
#line 1365 "tracker-sparql-scanner.c"
				{
					gchar* _tmp93_;
					gchar _tmp94_;
#line 239 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp93_ = begin;
#line 239 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp94_ = _tmp93_[1];
#line 239 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					switch (_tmp94_) {
#line 239 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'S':
#line 239 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 's':
#line 1379 "tracker-sparql-scanner.c"
						{
							gchar* _tmp95_;
							gchar _tmp96_;
#line 242 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp95_ = begin;
#line 242 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp96_ = _tmp95_[2];
#line 242 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							switch (_tmp96_) {
#line 242 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								case 'I':
#line 242 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								case 'i':
#line 1393 "tracker-sparql-scanner.c"
								{
									gchar* _tmp97_;
									gboolean _tmp98_ = FALSE;
#line 245 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp97_ = begin;
#line 245 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp98_ = tracker_sparql_scanner_matches (self, _tmp97_, "ISIRI");
#line 245 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									if (_tmp98_) {
#line 245 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										result = TRACKER_SPARQL_TOKEN_TYPE_ISIRI;
#line 245 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										return result;
#line 1407 "tracker-sparql-scanner.c"
									}
#line 246 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									break;
#line 1411 "tracker-sparql-scanner.c"
								}
#line 242 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								case 'U':
#line 242 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								case 'u':
#line 1417 "tracker-sparql-scanner.c"
								{
									gchar* _tmp99_;
									gboolean _tmp100_ = FALSE;
#line 249 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp99_ = begin;
#line 249 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp100_ = tracker_sparql_scanner_matches (self, _tmp99_, "ISURI");
#line 249 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									if (_tmp100_) {
#line 249 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										result = TRACKER_SPARQL_TOKEN_TYPE_ISURI;
#line 249 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										return result;
#line 1431 "tracker-sparql-scanner.c"
									}
#line 250 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									break;
#line 1435 "tracker-sparql-scanner.c"
								}
								default:
#line 242 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								break;
#line 1440 "tracker-sparql-scanner.c"
							}
#line 252 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 1444 "tracker-sparql-scanner.c"
						}
						default:
#line 239 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 1449 "tracker-sparql-scanner.c"
					}
#line 254 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1453 "tracker-sparql-scanner.c"
				}
				default:
#line 187 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				break;
#line 1458 "tracker-sparql-scanner.c"
			}
#line 256 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			break;
#line 1462 "tracker-sparql-scanner.c"
		}
#line 44 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case 6:
#line 1466 "tracker-sparql-scanner.c"
		{
			gchar* _tmp101_;
			gchar _tmp102_;
#line 258 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp101_ = begin;
#line 258 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp102_ = _tmp101_[0];
#line 258 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			switch (_tmp102_) {
#line 258 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'D':
#line 258 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'd':
#line 1480 "tracker-sparql-scanner.c"
				{
					gchar* _tmp103_;
					gboolean _tmp104_ = FALSE;
#line 261 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp103_ = begin;
#line 261 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp104_ = tracker_sparql_scanner_matches (self, _tmp103_, "DELETE");
#line 261 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp104_) {
#line 261 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_DELETE;
#line 261 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1494 "tracker-sparql-scanner.c"
					}
#line 262 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1498 "tracker-sparql-scanner.c"
				}
#line 258 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'E':
#line 258 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'e':
#line 1504 "tracker-sparql-scanner.c"
				{
					gchar* _tmp105_;
					gboolean _tmp106_ = FALSE;
#line 265 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp105_ = begin;
#line 265 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp106_ = tracker_sparql_scanner_matches (self, _tmp105_, "EXISTS");
#line 265 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp106_) {
#line 265 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_EXISTS;
#line 265 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1518 "tracker-sparql-scanner.c"
					}
#line 266 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1522 "tracker-sparql-scanner.c"
				}
#line 258 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'F':
#line 258 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'f':
#line 1528 "tracker-sparql-scanner.c"
				{
					gchar* _tmp107_;
					gboolean _tmp108_ = FALSE;
#line 269 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp107_ = begin;
#line 269 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp108_ = tracker_sparql_scanner_matches (self, _tmp107_, "FILTER");
#line 269 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp108_) {
#line 269 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_FILTER;
#line 269 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1542 "tracker-sparql-scanner.c"
					}
#line 270 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1546 "tracker-sparql-scanner.c"
				}
#line 258 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'H':
#line 258 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'h':
#line 1552 "tracker-sparql-scanner.c"
				{
					gchar* _tmp109_;
					gboolean _tmp110_ = FALSE;
#line 273 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp109_ = begin;
#line 273 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp110_ = tracker_sparql_scanner_matches (self, _tmp109_, "HAVING");
#line 273 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp110_) {
#line 273 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_HAVING;
#line 273 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1566 "tracker-sparql-scanner.c"
					}
#line 274 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1570 "tracker-sparql-scanner.c"
				}
#line 258 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'I':
#line 258 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'i':
#line 1576 "tracker-sparql-scanner.c"
				{
					gchar* _tmp111_;
					gboolean _tmp112_ = FALSE;
#line 277 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp111_ = begin;
#line 277 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp112_ = tracker_sparql_scanner_matches (self, _tmp111_, "INSERT");
#line 277 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp112_) {
#line 277 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_INSERT;
#line 277 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1590 "tracker-sparql-scanner.c"
					}
#line 278 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1594 "tracker-sparql-scanner.c"
				}
#line 258 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'O':
#line 258 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'o':
#line 1600 "tracker-sparql-scanner.c"
				{
					gchar* _tmp113_;
					gboolean _tmp114_ = FALSE;
#line 281 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp113_ = begin;
#line 281 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp114_ = tracker_sparql_scanner_matches (self, _tmp113_, "OFFSET");
#line 281 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp114_) {
#line 281 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_OFFSET;
#line 281 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1614 "tracker-sparql-scanner.c"
					}
#line 282 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1618 "tracker-sparql-scanner.c"
				}
#line 258 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'P':
#line 258 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'p':
#line 1624 "tracker-sparql-scanner.c"
				{
					gchar* _tmp115_;
					gboolean _tmp116_ = FALSE;
#line 285 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp115_ = begin;
#line 285 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp116_ = tracker_sparql_scanner_matches (self, _tmp115_, "PREFIX");
#line 285 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp116_) {
#line 285 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_PREFIX;
#line 285 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1638 "tracker-sparql-scanner.c"
					}
#line 286 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1642 "tracker-sparql-scanner.c"
				}
#line 258 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'S':
#line 258 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 's':
#line 1648 "tracker-sparql-scanner.c"
				{
					gchar* _tmp117_;
					gchar _tmp118_;
#line 289 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp117_ = begin;
#line 289 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp118_ = _tmp117_[1];
#line 289 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					switch (_tmp118_) {
#line 289 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'E':
#line 289 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'e':
#line 1662 "tracker-sparql-scanner.c"
						{
							gchar* _tmp119_;
							gboolean _tmp120_ = FALSE;
#line 292 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp119_ = begin;
#line 292 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp120_ = tracker_sparql_scanner_matches (self, _tmp119_, "SELECT");
#line 292 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp120_) {
#line 292 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_SELECT;
#line 292 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 1676 "tracker-sparql-scanner.c"
							}
#line 293 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 1680 "tracker-sparql-scanner.c"
						}
#line 289 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'I':
#line 289 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'i':
#line 1686 "tracker-sparql-scanner.c"
						{
							gchar* _tmp121_;
							gboolean _tmp122_ = FALSE;
#line 296 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp121_ = begin;
#line 296 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp122_ = tracker_sparql_scanner_matches (self, _tmp121_, "SILENT");
#line 296 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp122_) {
#line 296 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_SILENT;
#line 296 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 1700 "tracker-sparql-scanner.c"
							}
#line 297 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 1704 "tracker-sparql-scanner.c"
						}
						default:
#line 289 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 1709 "tracker-sparql-scanner.c"
					}
#line 299 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1713 "tracker-sparql-scanner.c"
				}
				default:
#line 258 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				break;
#line 1718 "tracker-sparql-scanner.c"
			}
#line 301 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			break;
#line 1722 "tracker-sparql-scanner.c"
		}
#line 44 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case 7:
#line 1726 "tracker-sparql-scanner.c"
		{
			gchar* _tmp123_;
			gchar _tmp124_;
#line 303 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp123_ = begin;
#line 303 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp124_ = _tmp123_[0];
#line 303 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			switch (_tmp124_) {
#line 303 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'R':
#line 303 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'r':
#line 1740 "tracker-sparql-scanner.c"
				{
					gchar* _tmp125_;
					gchar _tmp126_;
#line 306 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp125_ = begin;
#line 306 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp126_ = _tmp125_[2];
#line 306 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					switch (_tmp126_) {
#line 306 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'D':
#line 306 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'd':
#line 1754 "tracker-sparql-scanner.c"
						{
							gchar* _tmp127_;
							gboolean _tmp128_ = FALSE;
#line 309 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp127_ = begin;
#line 309 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp128_ = tracker_sparql_scanner_matches (self, _tmp127_, "REDUCED");
#line 309 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp128_) {
#line 309 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_REDUCED;
#line 309 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 1768 "tracker-sparql-scanner.c"
							}
#line 310 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 1772 "tracker-sparql-scanner.c"
						}
#line 306 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'P':
#line 306 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'p':
#line 1778 "tracker-sparql-scanner.c"
						{
							gchar* _tmp129_;
							gboolean _tmp130_ = FALSE;
#line 313 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp129_ = begin;
#line 313 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp130_ = tracker_sparql_scanner_matches (self, _tmp129_, "REPLACE");
#line 313 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp130_) {
#line 313 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_REPLACE;
#line 313 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 1792 "tracker-sparql-scanner.c"
							}
#line 314 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 1796 "tracker-sparql-scanner.c"
						}
						default:
#line 306 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 1801 "tracker-sparql-scanner.c"
					}
#line 316 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1805 "tracker-sparql-scanner.c"
				}
#line 303 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'I':
#line 303 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'i':
#line 1811 "tracker-sparql-scanner.c"
				{
					gchar* _tmp131_;
					gboolean _tmp132_ = FALSE;
#line 319 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp131_ = begin;
#line 319 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp132_ = tracker_sparql_scanner_matches (self, _tmp131_, "ISBLANK");
#line 319 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp132_) {
#line 319 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_ISBLANK;
#line 319 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1825 "tracker-sparql-scanner.c"
					}
#line 320 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1829 "tracker-sparql-scanner.c"
				}
				default:
#line 303 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				break;
#line 1834 "tracker-sparql-scanner.c"
			}
#line 322 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			break;
#line 1838 "tracker-sparql-scanner.c"
		}
#line 44 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case 8:
#line 1842 "tracker-sparql-scanner.c"
		{
			gchar* _tmp133_;
			gchar _tmp134_;
#line 324 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp133_ = begin;
#line 324 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp134_ = _tmp133_[0];
#line 324 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			switch (_tmp134_) {
#line 324 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'C':
#line 324 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'c':
#line 1856 "tracker-sparql-scanner.c"
				{
					gchar* _tmp135_;
					gboolean _tmp136_ = FALSE;
#line 327 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp135_ = begin;
#line 327 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp136_ = tracker_sparql_scanner_matches (self, _tmp135_, "COALESCE");
#line 327 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp136_) {
#line 327 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_COALESCE;
#line 327 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1870 "tracker-sparql-scanner.c"
					}
#line 328 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1874 "tracker-sparql-scanner.c"
				}
#line 324 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'D':
#line 324 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'd':
#line 1880 "tracker-sparql-scanner.c"
				{
					gchar* _tmp137_;
					gchar _tmp138_;
#line 331 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp137_ = begin;
#line 331 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp138_ = _tmp137_[1];
#line 331 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					switch (_tmp138_) {
#line 331 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'A':
#line 331 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'a':
#line 1894 "tracker-sparql-scanner.c"
						{
							gchar* _tmp139_;
							gboolean _tmp140_ = FALSE;
#line 334 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp139_ = begin;
#line 334 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp140_ = tracker_sparql_scanner_matches (self, _tmp139_, "DATATYPE");
#line 334 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp140_) {
#line 334 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_DATATYPE;
#line 334 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 1908 "tracker-sparql-scanner.c"
							}
#line 335 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 1912 "tracker-sparql-scanner.c"
						}
#line 331 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'E':
#line 331 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'e':
#line 1918 "tracker-sparql-scanner.c"
						{
							gchar* _tmp141_;
							gboolean _tmp142_ = FALSE;
#line 338 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp141_ = begin;
#line 338 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp142_ = tracker_sparql_scanner_matches (self, _tmp141_, "DESCRIBE");
#line 338 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp142_) {
#line 338 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_DESCRIBE;
#line 338 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 1932 "tracker-sparql-scanner.c"
							}
#line 339 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 1936 "tracker-sparql-scanner.c"
						}
#line 331 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'I':
#line 331 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'i':
#line 1942 "tracker-sparql-scanner.c"
						{
							gchar* _tmp143_;
							gboolean _tmp144_ = FALSE;
#line 342 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp143_ = begin;
#line 342 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp144_ = tracker_sparql_scanner_matches (self, _tmp143_, "DISTINCT");
#line 342 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp144_) {
#line 342 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_DISTINCT;
#line 342 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 1956 "tracker-sparql-scanner.c"
							}
#line 343 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 1960 "tracker-sparql-scanner.c"
						}
						default:
#line 331 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 1965 "tracker-sparql-scanner.c"
					}
#line 345 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1969 "tracker-sparql-scanner.c"
				}
#line 324 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'O':
#line 324 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'o':
#line 1975 "tracker-sparql-scanner.c"
				{
					gchar* _tmp145_;
					gboolean _tmp146_ = FALSE;
#line 348 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp145_ = begin;
#line 348 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp146_ = tracker_sparql_scanner_matches (self, _tmp145_, "OPTIONAL");
#line 348 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp146_) {
#line 348 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_OPTIONAL;
#line 348 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1989 "tracker-sparql-scanner.c"
					}
#line 349 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1993 "tracker-sparql-scanner.c"
				}
#line 324 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'S':
#line 324 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 's':
#line 1999 "tracker-sparql-scanner.c"
				{
					gchar* _tmp147_;
					gboolean _tmp148_ = FALSE;
#line 352 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp147_ = begin;
#line 352 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp148_ = tracker_sparql_scanner_matches (self, _tmp147_, "SAMETERM");
#line 352 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp148_) {
#line 352 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_SAMETERM;
#line 352 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 2013 "tracker-sparql-scanner.c"
					}
#line 353 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 2017 "tracker-sparql-scanner.c"
				}
				default:
#line 324 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				break;
#line 2022 "tracker-sparql-scanner.c"
			}
#line 355 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			break;
#line 2026 "tracker-sparql-scanner.c"
		}
#line 44 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case 9:
#line 2030 "tracker-sparql-scanner.c"
		{
			gchar* _tmp149_;
			gchar _tmp150_;
#line 357 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp149_ = begin;
#line 357 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp150_ = _tmp149_[0];
#line 357 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			switch (_tmp150_) {
#line 357 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'C':
#line 357 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'c':
#line 2044 "tracker-sparql-scanner.c"
				{
					gchar* _tmp151_;
					gboolean _tmp152_ = FALSE;
#line 360 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp151_ = begin;
#line 360 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp152_ = tracker_sparql_scanner_matches (self, _tmp151_, "CONSTRUCT");
#line 360 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp152_) {
#line 360 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_CONSTRUCT;
#line 360 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 2058 "tracker-sparql-scanner.c"
					}
#line 361 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 2062 "tracker-sparql-scanner.c"
				}
#line 357 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'I':
#line 357 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'i':
#line 2068 "tracker-sparql-scanner.c"
				{
					gchar* _tmp153_;
					gboolean _tmp154_ = FALSE;
#line 364 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp153_ = begin;
#line 364 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp154_ = tracker_sparql_scanner_matches (self, _tmp153_, "ISLITERAL");
#line 364 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp154_) {
#line 364 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL;
#line 364 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 2082 "tracker-sparql-scanner.c"
					}
#line 365 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 2086 "tracker-sparql-scanner.c"
				}
				default:
#line 357 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				break;
#line 2091 "tracker-sparql-scanner.c"
			}
#line 367 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			break;
#line 2095 "tracker-sparql-scanner.c"
		}
#line 44 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case 11:
#line 2099 "tracker-sparql-scanner.c"
		{
			gchar* _tmp155_;
			gboolean _tmp156_ = FALSE;
#line 369 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp155_ = begin;
#line 369 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp156_ = tracker_sparql_scanner_matches (self, _tmp155_, "LANGMATCHES");
#line 369 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			if (_tmp156_) {
#line 369 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				result = TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES;
#line 369 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				return result;
#line 2113 "tracker-sparql-scanner.c"
			}
#line 370 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			break;
#line 2117 "tracker-sparql-scanner.c"
		}
#line 44 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case 12:
#line 2121 "tracker-sparql-scanner.c"
		{
			gchar* _tmp157_;
			gboolean _tmp158_ = FALSE;
#line 372 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp157_ = begin;
#line 372 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp158_ = tracker_sparql_scanner_matches (self, _tmp157_, "GROUP_CONCAT");
#line 372 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			if (_tmp158_) {
#line 372 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				result = TRACKER_SPARQL_TOKEN_TYPE_GROUP_CONCAT;
#line 372 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				return result;
#line 2135 "tracker-sparql-scanner.c"
			}
#line 373 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			break;
#line 2139 "tracker-sparql-scanner.c"
		}
		default:
#line 44 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		break;
#line 2144 "tracker-sparql-scanner.c"
	}
#line 375 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	result = TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX;
#line 375 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	return result;
#line 2150 "tracker-sparql-scanner.c"
}


static TrackerSparqlTokenType tracker_sparql_scanner_read_number (TrackerSparqlScanner* self) {
	TrackerSparqlTokenType result = 0;
	TrackerSparqlTokenType type;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp7_;
	gboolean _tmp10_;
	gboolean _tmp14_;
	gboolean _tmp32_ = FALSE;
	gboolean _tmp33_ = FALSE;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gboolean _tmp38_;
	gboolean _tmp42_;
	gboolean _tmp52_ = FALSE;
	gchar* _tmp53_;
	gchar* _tmp54_;
	gboolean _tmp58_;
	gchar* _tmp79_;
	gchar* _tmp80_;
#line 378 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 379 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	type = TRACKER_SPARQL_TOKEN_TYPE_INTEGER;
#line 382 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp3_ = self->priv->current;
#line 382 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp4_ = self->priv->end;
#line 382 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp3_ < (_tmp4_ - 2)) {
#line 2187 "tracker-sparql-scanner.c"
		gchar* _tmp5_;
		gchar _tmp6_;
#line 382 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp5_ = self->priv->current;
#line 382 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp6_ = _tmp5_[0];
#line 382 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp2_ = _tmp6_ == '0';
#line 2196 "tracker-sparql-scanner.c"
	} else {
#line 382 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp2_ = FALSE;
#line 2200 "tracker-sparql-scanner.c"
	}
#line 382 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp7_ = _tmp2_;
#line 382 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp7_) {
#line 2206 "tracker-sparql-scanner.c"
		gchar* _tmp8_;
		gchar _tmp9_;
#line 383 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp8_ = self->priv->current;
#line 383 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp9_ = _tmp8_[1];
#line 383 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp1_ = _tmp9_ == 'x';
#line 2215 "tracker-sparql-scanner.c"
	} else {
#line 382 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp1_ = FALSE;
#line 2219 "tracker-sparql-scanner.c"
	}
#line 382 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp10_ = _tmp1_;
#line 382 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp10_) {
#line 2225 "tracker-sparql-scanner.c"
		gchar* _tmp11_;
		gchar _tmp12_;
		gboolean _tmp13_ = FALSE;
#line 383 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp11_ = self->priv->current;
#line 383 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp12_ = _tmp11_[2];
#line 383 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp13_ = g_ascii_isxdigit (_tmp12_);
#line 383 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp0_ = _tmp13_;
#line 2237 "tracker-sparql-scanner.c"
	} else {
#line 382 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp0_ = FALSE;
#line 2241 "tracker-sparql-scanner.c"
	}
#line 382 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp14_ = _tmp0_;
#line 382 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp14_) {
#line 2247 "tracker-sparql-scanner.c"
		gchar* _tmp15_;
#line 385 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp15_ = self->priv->current;
#line 385 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		self->priv->current = _tmp15_ + 2;
#line 386 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		while (TRUE) {
#line 2255 "tracker-sparql-scanner.c"
			gboolean _tmp16_ = FALSE;
			gchar* _tmp17_;
			gchar* _tmp18_;
			gboolean _tmp22_;
			gchar* _tmp23_;
#line 386 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp17_ = self->priv->current;
#line 386 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp18_ = self->priv->end;
#line 386 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			if (_tmp17_ < _tmp18_) {
#line 2267 "tracker-sparql-scanner.c"
				gchar* _tmp19_;
				gchar _tmp20_;
				gboolean _tmp21_ = FALSE;
#line 386 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp19_ = self->priv->current;
#line 386 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp20_ = _tmp19_[0];
#line 386 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp21_ = g_ascii_isxdigit (_tmp20_);
#line 386 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp16_ = _tmp21_;
#line 2279 "tracker-sparql-scanner.c"
			} else {
#line 386 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp16_ = FALSE;
#line 2283 "tracker-sparql-scanner.c"
			}
#line 386 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp22_ = _tmp16_;
#line 386 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			if (!_tmp22_) {
#line 386 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				break;
#line 2291 "tracker-sparql-scanner.c"
			}
#line 387 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp23_ = self->priv->current;
#line 387 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			self->priv->current = _tmp23_ + 1;
#line 2297 "tracker-sparql-scanner.c"
		}
	} else {
#line 391 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		while (TRUE) {
#line 2302 "tracker-sparql-scanner.c"
			gboolean _tmp24_ = FALSE;
			gchar* _tmp25_;
			gchar* _tmp26_;
			gboolean _tmp30_;
			gchar* _tmp31_;
#line 391 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp25_ = self->priv->current;
#line 391 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp26_ = self->priv->end;
#line 391 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			if (_tmp25_ < _tmp26_) {
#line 2314 "tracker-sparql-scanner.c"
				gchar* _tmp27_;
				gchar _tmp28_;
				gboolean _tmp29_ = FALSE;
#line 391 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp27_ = self->priv->current;
#line 391 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp28_ = _tmp27_[0];
#line 391 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp29_ = g_ascii_isdigit (_tmp28_);
#line 391 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp24_ = _tmp29_;
#line 2326 "tracker-sparql-scanner.c"
			} else {
#line 391 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp24_ = FALSE;
#line 2330 "tracker-sparql-scanner.c"
			}
#line 391 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp30_ = _tmp24_;
#line 391 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			if (!_tmp30_) {
#line 391 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				break;
#line 2338 "tracker-sparql-scanner.c"
			}
#line 392 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp31_ = self->priv->current;
#line 392 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			self->priv->current = _tmp31_ + 1;
#line 2344 "tracker-sparql-scanner.c"
		}
	}
#line 397 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp34_ = self->priv->current;
#line 397 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp35_ = self->priv->end;
#line 397 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp34_ < (_tmp35_ - 1)) {
#line 2353 "tracker-sparql-scanner.c"
		gchar* _tmp36_;
		gchar _tmp37_;
#line 397 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp36_ = self->priv->current;
#line 397 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp37_ = _tmp36_[0];
#line 397 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp33_ = _tmp37_ == '.';
#line 2362 "tracker-sparql-scanner.c"
	} else {
#line 397 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp33_ = FALSE;
#line 2366 "tracker-sparql-scanner.c"
	}
#line 397 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp38_ = _tmp33_;
#line 397 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp38_) {
#line 2372 "tracker-sparql-scanner.c"
		gchar* _tmp39_;
		gchar _tmp40_;
		gboolean _tmp41_ = FALSE;
#line 397 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp39_ = self->priv->current;
#line 397 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp40_ = _tmp39_[1];
#line 397 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp41_ = g_ascii_isdigit (_tmp40_);
#line 397 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp32_ = _tmp41_;
#line 2384 "tracker-sparql-scanner.c"
	} else {
#line 397 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp32_ = FALSE;
#line 2388 "tracker-sparql-scanner.c"
	}
#line 397 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp42_ = _tmp32_;
#line 397 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp42_) {
#line 2394 "tracker-sparql-scanner.c"
		gchar* _tmp43_;
#line 398 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		type = TRACKER_SPARQL_TOKEN_TYPE_DOUBLE;
#line 399 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp43_ = self->priv->current;
#line 399 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		self->priv->current = _tmp43_ + 1;
#line 400 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		while (TRUE) {
#line 2404 "tracker-sparql-scanner.c"
			gboolean _tmp44_ = FALSE;
			gchar* _tmp45_;
			gchar* _tmp46_;
			gboolean _tmp50_;
			gchar* _tmp51_;
#line 400 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp45_ = self->priv->current;
#line 400 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp46_ = self->priv->end;
#line 400 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			if (_tmp45_ < _tmp46_) {
#line 2416 "tracker-sparql-scanner.c"
				gchar* _tmp47_;
				gchar _tmp48_;
				gboolean _tmp49_ = FALSE;
#line 400 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp47_ = self->priv->current;
#line 400 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp48_ = _tmp47_[0];
#line 400 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp49_ = g_ascii_isdigit (_tmp48_);
#line 400 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp44_ = _tmp49_;
#line 2428 "tracker-sparql-scanner.c"
			} else {
#line 400 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp44_ = FALSE;
#line 2432 "tracker-sparql-scanner.c"
			}
#line 400 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp50_ = _tmp44_;
#line 400 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			if (!_tmp50_) {
#line 400 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				break;
#line 2440 "tracker-sparql-scanner.c"
			}
#line 401 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp51_ = self->priv->current;
#line 401 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			self->priv->current = _tmp51_ + 1;
#line 2446 "tracker-sparql-scanner.c"
		}
	}
#line 406 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp53_ = self->priv->current;
#line 406 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp54_ = self->priv->end;
#line 406 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp53_ < _tmp54_) {
#line 2455 "tracker-sparql-scanner.c"
		gchar* _tmp55_;
		gchar _tmp56_;
		gchar _tmp57_ = '\0';
#line 406 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp55_ = self->priv->current;
#line 406 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp56_ = _tmp55_[0];
#line 406 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp57_ = g_ascii_tolower (_tmp56_);
#line 406 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp52_ = _tmp57_ == 'e';
#line 2467 "tracker-sparql-scanner.c"
	} else {
#line 406 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp52_ = FALSE;
#line 2471 "tracker-sparql-scanner.c"
	}
#line 406 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp58_ = _tmp52_;
#line 406 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp58_) {
#line 2477 "tracker-sparql-scanner.c"
		gchar* _tmp59_;
		gboolean _tmp60_ = FALSE;
		gchar* _tmp61_;
		gchar* _tmp62_;
		gboolean _tmp69_;
#line 407 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		type = TRACKER_SPARQL_TOKEN_TYPE_DOUBLE;
#line 408 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp59_ = self->priv->current;
#line 408 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		self->priv->current = _tmp59_ + 1;
#line 409 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp61_ = self->priv->current;
#line 409 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp62_ = self->priv->end;
#line 409 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		if (_tmp61_ < _tmp62_) {
#line 2495 "tracker-sparql-scanner.c"
			gboolean _tmp63_ = FALSE;
			gchar* _tmp64_;
			gchar _tmp65_;
			gboolean _tmp68_;
#line 409 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp64_ = self->priv->current;
#line 409 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp65_ = _tmp64_[0];
#line 409 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			if (_tmp65_ == '+') {
#line 409 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp63_ = TRUE;
#line 2508 "tracker-sparql-scanner.c"
			} else {
				gchar* _tmp66_;
				gchar _tmp67_;
#line 409 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp66_ = self->priv->current;
#line 409 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp67_ = _tmp66_[0];
#line 409 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp63_ = _tmp67_ == '-';
#line 2518 "tracker-sparql-scanner.c"
			}
#line 409 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp68_ = _tmp63_;
#line 409 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp60_ = _tmp68_;
#line 2524 "tracker-sparql-scanner.c"
		} else {
#line 409 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp60_ = FALSE;
#line 2528 "tracker-sparql-scanner.c"
		}
#line 409 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp69_ = _tmp60_;
#line 409 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		if (_tmp69_) {
#line 2534 "tracker-sparql-scanner.c"
			gchar* _tmp70_;
#line 410 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp70_ = self->priv->current;
#line 410 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			self->priv->current = _tmp70_ + 1;
#line 2540 "tracker-sparql-scanner.c"
		}
#line 412 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		while (TRUE) {
#line 2544 "tracker-sparql-scanner.c"
			gboolean _tmp71_ = FALSE;
			gchar* _tmp72_;
			gchar* _tmp73_;
			gboolean _tmp77_;
			gchar* _tmp78_;
#line 412 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp72_ = self->priv->current;
#line 412 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp73_ = self->priv->end;
#line 412 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			if (_tmp72_ < _tmp73_) {
#line 2556 "tracker-sparql-scanner.c"
				gchar* _tmp74_;
				gchar _tmp75_;
				gboolean _tmp76_ = FALSE;
#line 412 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp74_ = self->priv->current;
#line 412 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp75_ = _tmp74_[0];
#line 412 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp76_ = g_ascii_isdigit (_tmp75_);
#line 412 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp71_ = _tmp76_;
#line 2568 "tracker-sparql-scanner.c"
			} else {
#line 412 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp71_ = FALSE;
#line 2572 "tracker-sparql-scanner.c"
			}
#line 412 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp77_ = _tmp71_;
#line 412 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			if (!_tmp77_) {
#line 412 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				break;
#line 2580 "tracker-sparql-scanner.c"
			}
#line 413 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp78_ = self->priv->current;
#line 413 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			self->priv->current = _tmp78_ + 1;
#line 2586 "tracker-sparql-scanner.c"
		}
	}
#line 418 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp79_ = self->priv->current;
#line 418 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp80_ = self->priv->end;
#line 418 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp79_ < _tmp80_) {
#line 2595 "tracker-sparql-scanner.c"
		gchar* _tmp81_;
		gchar _tmp82_;
#line 419 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp81_ = self->priv->current;
#line 419 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp82_ = _tmp81_[0];
#line 419 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		switch (_tmp82_) {
#line 419 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			case 'l':
#line 419 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			case 'L':
#line 2608 "tracker-sparql-scanner.c"
			{
				TrackerSparqlTokenType _tmp83_;
#line 422 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp83_ = type;
#line 422 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				if (_tmp83_ == TRACKER_SPARQL_TOKEN_TYPE_INTEGER) {
#line 2615 "tracker-sparql-scanner.c"
					gchar* _tmp84_;
					gboolean _tmp85_ = FALSE;
					gchar* _tmp86_;
					gchar* _tmp87_;
					gboolean _tmp91_;
#line 423 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp84_ = self->priv->current;
#line 423 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					self->priv->current = _tmp84_ + 1;
#line 424 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp86_ = self->priv->current;
#line 424 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp87_ = self->priv->end;
#line 424 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp86_ < _tmp87_) {
#line 2631 "tracker-sparql-scanner.c"
						gchar* _tmp88_;
						gchar _tmp89_;
						gchar _tmp90_ = '\0';
#line 424 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp88_ = self->priv->current;
#line 424 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp89_ = _tmp88_[0];
#line 424 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp90_ = g_ascii_tolower (_tmp89_);
#line 424 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp85_ = _tmp90_ == 'l';
#line 2643 "tracker-sparql-scanner.c"
					} else {
#line 424 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp85_ = FALSE;
#line 2647 "tracker-sparql-scanner.c"
					}
#line 424 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp91_ = _tmp85_;
#line 424 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp91_) {
#line 2653 "tracker-sparql-scanner.c"
						gchar* _tmp92_;
#line 425 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp92_ = self->priv->current;
#line 425 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp92_ + 1;
#line 2659 "tracker-sparql-scanner.c"
					}
				}
#line 428 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				break;
#line 2664 "tracker-sparql-scanner.c"
			}
#line 419 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			case 'u':
#line 419 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			case 'U':
#line 2670 "tracker-sparql-scanner.c"
			{
				TrackerSparqlTokenType _tmp93_;
#line 431 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp93_ = type;
#line 431 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				if (_tmp93_ == TRACKER_SPARQL_TOKEN_TYPE_INTEGER) {
#line 2677 "tracker-sparql-scanner.c"
					gchar* _tmp94_;
					gboolean _tmp95_ = FALSE;
					gchar* _tmp96_;
					gchar* _tmp97_;
					gboolean _tmp101_;
#line 432 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp94_ = self->priv->current;
#line 432 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					self->priv->current = _tmp94_ + 1;
#line 433 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp96_ = self->priv->current;
#line 433 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp97_ = self->priv->end;
#line 433 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp96_ < _tmp97_) {
#line 2693 "tracker-sparql-scanner.c"
						gchar* _tmp98_;
						gchar _tmp99_;
						gchar _tmp100_ = '\0';
#line 433 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp98_ = self->priv->current;
#line 433 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp99_ = _tmp98_[0];
#line 433 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp100_ = g_ascii_tolower (_tmp99_);
#line 433 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp95_ = _tmp100_ == 'l';
#line 2705 "tracker-sparql-scanner.c"
					} else {
#line 433 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp95_ = FALSE;
#line 2709 "tracker-sparql-scanner.c"
					}
#line 433 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp101_ = _tmp95_;
#line 433 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp101_) {
#line 2715 "tracker-sparql-scanner.c"
						gchar* _tmp102_;
						gboolean _tmp103_ = FALSE;
						gchar* _tmp104_;
						gchar* _tmp105_;
						gboolean _tmp109_;
#line 434 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp102_ = self->priv->current;
#line 434 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp102_ + 1;
#line 435 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp104_ = self->priv->current;
#line 435 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp105_ = self->priv->end;
#line 435 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp104_ < _tmp105_) {
#line 2731 "tracker-sparql-scanner.c"
							gchar* _tmp106_;
							gchar _tmp107_;
							gchar _tmp108_ = '\0';
#line 435 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp106_ = self->priv->current;
#line 435 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp107_ = _tmp106_[0];
#line 435 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp108_ = g_ascii_tolower (_tmp107_);
#line 435 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp103_ = _tmp108_ == 'l';
#line 2743 "tracker-sparql-scanner.c"
						} else {
#line 435 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp103_ = FALSE;
#line 2747 "tracker-sparql-scanner.c"
						}
#line 435 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp109_ = _tmp103_;
#line 435 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp109_) {
#line 2753 "tracker-sparql-scanner.c"
							gchar* _tmp110_;
#line 436 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp110_ = self->priv->current;
#line 436 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							self->priv->current = _tmp110_ + 1;
#line 2759 "tracker-sparql-scanner.c"
						}
					}
				}
#line 440 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				break;
#line 2765 "tracker-sparql-scanner.c"
			}
#line 419 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			case 'f':
#line 419 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			case 'F':
#line 419 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			case 'd':
#line 419 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			case 'D':
#line 2775 "tracker-sparql-scanner.c"
			{
				gchar* _tmp111_;
#line 445 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				type = TRACKER_SPARQL_TOKEN_TYPE_DOUBLE;
#line 446 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp111_ = self->priv->current;
#line 446 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				self->priv->current = _tmp111_ + 1;
#line 447 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				break;
#line 2786 "tracker-sparql-scanner.c"
			}
			default:
#line 419 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			break;
#line 2791 "tracker-sparql-scanner.c"
		}
	}
#line 451 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	result = type;
#line 451 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	return result;
#line 2798 "tracker-sparql-scanner.c"
}


static gboolean tracker_sparql_scanner_is_pn_char (TrackerSparqlScanner* self, gchar c) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gchar _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp5_;
	gboolean _tmp7_;
#line 454 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 455 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp2_ = c;
#line 455 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp3_ = g_ascii_isalnum (_tmp2_);
#line 455 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp3_) {
#line 455 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp1_ = TRUE;
#line 2820 "tracker-sparql-scanner.c"
	} else {
		gchar _tmp4_;
#line 455 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp4_ = c;
#line 455 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp1_ = _tmp4_ == '_';
#line 2827 "tracker-sparql-scanner.c"
	}
#line 455 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp5_ = _tmp1_;
#line 455 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp5_) {
#line 455 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp0_ = TRUE;
#line 2835 "tracker-sparql-scanner.c"
	} else {
		gchar _tmp6_;
#line 455 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp6_ = c;
#line 455 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp0_ = _tmp6_ == '-';
#line 2842 "tracker-sparql-scanner.c"
	}
#line 455 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp7_ = _tmp0_;
#line 455 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	result = _tmp7_;
#line 455 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	return result;
#line 2850 "tracker-sparql-scanner.c"
}


static gboolean tracker_sparql_scanner_is_pn_local_char (TrackerSparqlScanner* self, gchar c) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp6_;
	gboolean _tmp8_;
	gboolean _tmp10_;
#line 458 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 459 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp3_ = c;
#line 459 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp4_ = g_ascii_isalnum (_tmp3_);
#line 459 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp4_) {
#line 459 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp2_ = TRUE;
#line 2874 "tracker-sparql-scanner.c"
	} else {
		gchar _tmp5_;
#line 459 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp5_ = c;
#line 459 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp2_ = _tmp5_ == '_';
#line 2881 "tracker-sparql-scanner.c"
	}
#line 459 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp6_ = _tmp2_;
#line 459 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp6_) {
#line 459 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp1_ = TRUE;
#line 2889 "tracker-sparql-scanner.c"
	} else {
		gchar _tmp7_;
#line 459 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp7_ = c;
#line 459 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp1_ = _tmp7_ == '-';
#line 2896 "tracker-sparql-scanner.c"
	}
#line 459 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp8_ = _tmp1_;
#line 459 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp8_) {
#line 459 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp0_ = TRUE;
#line 2904 "tracker-sparql-scanner.c"
	} else {
		gchar _tmp9_;
#line 459 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp9_ = c;
#line 459 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp0_ = _tmp9_ == '.';
#line 2911 "tracker-sparql-scanner.c"
	}
#line 459 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp10_ = _tmp0_;
#line 459 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	result = _tmp10_;
#line 459 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	return result;
#line 2919 "tracker-sparql-scanner.c"
}


static gboolean tracker_sparql_scanner_is_varname_char (TrackerSparqlScanner* self, gchar c) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gchar _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp4_;
#line 462 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 463 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp1_ = c;
#line 463 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp2_ = g_ascii_isalnum (_tmp1_);
#line 463 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp2_) {
#line 463 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp0_ = TRUE;
#line 2939 "tracker-sparql-scanner.c"
	} else {
		gchar _tmp3_;
#line 463 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp3_ = c;
#line 463 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp0_ = _tmp3_ == '_';
#line 2946 "tracker-sparql-scanner.c"
	}
#line 463 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp4_ = _tmp0_;
#line 463 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	result = _tmp4_;
#line 463 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	return result;
#line 2954 "tracker-sparql-scanner.c"
}


TrackerSparqlTokenType tracker_sparql_scanner_read_token (TrackerSparqlScanner* self, TrackerSourceLocation* token_begin, TrackerSourceLocation* token_end, GError** error) {
	TrackerSourceLocation _vala_token_begin = {0};
	TrackerSourceLocation _vala_token_end = {0};
	TrackerSparqlTokenType result = 0;
	TrackerSparqlTokenType type = 0;
	gchar* _tmp0_;
	gchar* begin;
	gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	TrackerSourceLocation _tmp4_ = {0};
	gint token_length_in_chars;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gint _tmp321_;
	gchar* _tmp327_;
	gint _tmp328_;
	gint _tmp329_;
	TrackerSourceLocation _tmp330_ = {0};
	GError * _inner_error_ = NULL;
#line 466 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 467 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	tracker_sparql_scanner_space (self);
#line 470 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp0_ = self->priv->current;
#line 470 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	begin = _tmp0_;
#line 471 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp1_ = begin;
#line 471 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp2_ = self->priv->line;
#line 471 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp3_ = self->priv->column;
#line 471 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	tracker_source_location_init (&_tmp4_, _tmp1_, _tmp2_, _tmp3_);
#line 471 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_vala_token_begin = _tmp4_;
#line 473 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	token_length_in_chars = -1;
#line 475 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp5_ = self->priv->current;
#line 475 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp6_ = self->priv->end;
#line 475 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp5_ >= _tmp6_) {
#line 476 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		type = TRACKER_SPARQL_TOKEN_TYPE_EOF;
#line 3006 "tracker-sparql-scanner.c"
	} else {
		gchar* _tmp7_;
		gchar _tmp8_;
		gboolean _tmp9_ = FALSE;
#line 477 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp7_ = self->priv->current;
#line 477 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp8_ = _tmp7_[0];
#line 477 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp9_ = g_ascii_isalpha (_tmp8_);
#line 477 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		if (_tmp9_) {
#line 3019 "tracker-sparql-scanner.c"
			gint len;
			gchar* _tmp19_;
			gint _tmp20_;
			TrackerSparqlTokenType _tmp21_ = 0;
#line 479 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			len = 0;
#line 480 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			while (TRUE) {
#line 3028 "tracker-sparql-scanner.c"
				gboolean _tmp10_ = FALSE;
				gchar* _tmp11_;
				gchar* _tmp12_;
				gboolean _tmp16_;
				gchar* _tmp17_;
				gint _tmp18_;
#line 480 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp11_ = self->priv->current;
#line 480 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp12_ = self->priv->end;
#line 480 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				if (_tmp11_ < _tmp12_) {
#line 3041 "tracker-sparql-scanner.c"
					gchar* _tmp13_;
					gchar _tmp14_;
					gboolean _tmp15_ = FALSE;
#line 480 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp13_ = self->priv->current;
#line 480 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp14_ = _tmp13_[0];
#line 480 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp15_ = tracker_sparql_scanner_is_pn_char (self, _tmp14_);
#line 480 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp10_ = _tmp15_;
#line 3053 "tracker-sparql-scanner.c"
				} else {
#line 480 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp10_ = FALSE;
#line 3057 "tracker-sparql-scanner.c"
				}
#line 480 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp16_ = _tmp10_;
#line 480 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				if (!_tmp16_) {
#line 480 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 3065 "tracker-sparql-scanner.c"
				}
#line 481 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp17_ = self->priv->current;
#line 481 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				self->priv->current = _tmp17_ + 1;
#line 482 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp18_ = len;
#line 482 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				len = _tmp18_ + 1;
#line 3075 "tracker-sparql-scanner.c"
			}
#line 484 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp19_ = begin;
#line 484 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp20_ = len;
#line 484 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp21_ = tracker_sparql_scanner_get_identifier_or_keyword (self, _tmp19_, _tmp20_);
#line 484 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			type = _tmp21_;
#line 3085 "tracker-sparql-scanner.c"
		} else {
			gchar* _tmp22_;
			gchar _tmp23_;
			gboolean _tmp24_ = FALSE;
#line 485 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp22_ = self->priv->current;
#line 485 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp23_ = _tmp22_[0];
#line 485 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp24_ = g_ascii_isdigit (_tmp23_);
#line 485 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			if (_tmp24_) {
#line 3098 "tracker-sparql-scanner.c"
				TrackerSparqlTokenType _tmp25_ = 0;
#line 486 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp25_ = tracker_sparql_scanner_read_number (self);
#line 486 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				type = _tmp25_;
#line 3104 "tracker-sparql-scanner.c"
			} else {
				gchar* _tmp26_;
				gchar _tmp27_;
#line 488 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp26_ = self->priv->current;
#line 488 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp27_ = _tmp26_[0];
#line 488 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				switch (_tmp27_) {
#line 488 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '{':
#line 3116 "tracker-sparql-scanner.c"
					{
						gchar* _tmp28_;
#line 490 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE;
#line 491 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp28_ = self->priv->current;
#line 491 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp28_ + 1;
#line 492 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 3127 "tracker-sparql-scanner.c"
					}
#line 488 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '}':
#line 3131 "tracker-sparql-scanner.c"
					{
						gchar* _tmp29_;
#line 494 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE;
#line 495 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp29_ = self->priv->current;
#line 495 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp29_ + 1;
#line 496 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 3142 "tracker-sparql-scanner.c"
					}
#line 488 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '(':
#line 3146 "tracker-sparql-scanner.c"
					{
						gchar* _tmp30_;
#line 498 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS;
#line 499 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp30_ = self->priv->current;
#line 499 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp30_ + 1;
#line 500 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 3157 "tracker-sparql-scanner.c"
					}
#line 488 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case ')':
#line 3161 "tracker-sparql-scanner.c"
					{
						gchar* _tmp31_;
#line 502 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS;
#line 503 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp31_ = self->priv->current;
#line 503 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp31_ + 1;
#line 504 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 3172 "tracker-sparql-scanner.c"
					}
#line 488 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '[':
#line 3176 "tracker-sparql-scanner.c"
					{
						gchar* _tmp32_;
#line 506 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET;
#line 507 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp32_ = self->priv->current;
#line 507 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp32_ + 1;
#line 508 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 3187 "tracker-sparql-scanner.c"
					}
#line 488 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case ']':
#line 3191 "tracker-sparql-scanner.c"
					{
						gchar* _tmp33_;
#line 510 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACKET;
#line 511 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp33_ = self->priv->current;
#line 511 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp33_ + 1;
#line 512 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 3202 "tracker-sparql-scanner.c"
					}
#line 488 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '.':
#line 3206 "tracker-sparql-scanner.c"
					{
						gchar* _tmp34_;
#line 514 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_DOT;
#line 515 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp34_ = self->priv->current;
#line 515 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp34_ + 1;
#line 516 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 3217 "tracker-sparql-scanner.c"
					}
#line 488 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case ':':
#line 3221 "tracker-sparql-scanner.c"
					{
						gchar* _tmp35_;
						gchar* _tmp44_;
						gchar _tmp45_;
#line 518 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_COLON;
#line 519 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp35_ = self->priv->current;
#line 519 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp35_ + 1;
#line 520 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						while (TRUE) {
#line 3234 "tracker-sparql-scanner.c"
							gboolean _tmp36_ = FALSE;
							gchar* _tmp37_;
							gchar* _tmp38_;
							gboolean _tmp42_;
							gchar* _tmp43_;
#line 520 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp37_ = self->priv->current;
#line 520 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp38_ = self->priv->end;
#line 520 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp37_ < _tmp38_) {
#line 3246 "tracker-sparql-scanner.c"
								gchar* _tmp39_;
								gchar _tmp40_;
								gboolean _tmp41_ = FALSE;
#line 520 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp39_ = self->priv->current;
#line 520 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp40_ = _tmp39_[0];
#line 520 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp41_ = tracker_sparql_scanner_is_pn_local_char (self, _tmp40_);
#line 520 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp36_ = _tmp41_;
#line 3258 "tracker-sparql-scanner.c"
							} else {
#line 520 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp36_ = FALSE;
#line 3262 "tracker-sparql-scanner.c"
							}
#line 520 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp42_ = _tmp36_;
#line 520 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (!_tmp42_) {
#line 520 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								break;
#line 3270 "tracker-sparql-scanner.c"
							}
#line 521 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp43_ = self->priv->current;
#line 521 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							self->priv->current = _tmp43_ + 1;
#line 3276 "tracker-sparql-scanner.c"
						}
#line 523 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp44_ = self->priv->current;
#line 523 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp45_ = _tmp44_[-1];
#line 523 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp45_ == '.') {
#line 3284 "tracker-sparql-scanner.c"
							gchar* _tmp46_;
#line 525 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp46_ = self->priv->current;
#line 525 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							self->priv->current = _tmp46_ - 1;
#line 3290 "tracker-sparql-scanner.c"
						}
#line 527 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 3294 "tracker-sparql-scanner.c"
					}
#line 488 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case ',':
#line 3298 "tracker-sparql-scanner.c"
					{
						gchar* _tmp47_;
#line 529 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_COMMA;
#line 530 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp47_ = self->priv->current;
#line 530 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp47_ + 1;
#line 531 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 3309 "tracker-sparql-scanner.c"
					}
#line 488 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case ';':
#line 3313 "tracker-sparql-scanner.c"
					{
						gchar* _tmp48_;
#line 533 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON;
#line 534 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp48_ = self->priv->current;
#line 534 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp48_ + 1;
#line 535 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 3324 "tracker-sparql-scanner.c"
					}
#line 488 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '?':
#line 488 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '$':
#line 3330 "tracker-sparql-scanner.c"
					{
						gchar* _tmp49_;
#line 538 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_NONE;
#line 539 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp49_ = self->priv->current;
#line 539 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp49_ + 1;
#line 540 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						while (TRUE) {
#line 3341 "tracker-sparql-scanner.c"
							gboolean _tmp50_ = FALSE;
							gchar* _tmp51_;
							gchar* _tmp52_;
							gboolean _tmp56_;
							gchar* _tmp57_;
#line 540 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp51_ = self->priv->current;
#line 540 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp52_ = self->priv->end;
#line 540 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp51_ < _tmp52_) {
#line 3353 "tracker-sparql-scanner.c"
								gchar* _tmp53_;
								gchar _tmp54_;
								gboolean _tmp55_ = FALSE;
#line 540 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp53_ = self->priv->current;
#line 540 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp54_ = _tmp53_[0];
#line 540 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp55_ = tracker_sparql_scanner_is_varname_char (self, _tmp54_);
#line 540 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp50_ = _tmp55_;
#line 3365 "tracker-sparql-scanner.c"
							} else {
#line 540 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp50_ = FALSE;
#line 3369 "tracker-sparql-scanner.c"
							}
#line 540 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp56_ = _tmp50_;
#line 540 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (!_tmp56_) {
#line 540 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								break;
#line 3377 "tracker-sparql-scanner.c"
							}
#line 541 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							type = TRACKER_SPARQL_TOKEN_TYPE_VAR;
#line 542 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp57_ = self->priv->current;
#line 542 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							self->priv->current = _tmp57_ + 1;
#line 3385 "tracker-sparql-scanner.c"
						}
#line 544 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 3389 "tracker-sparql-scanner.c"
					}
#line 488 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '@':
#line 3393 "tracker-sparql-scanner.c"
					{
						gchar* _tmp58_;
						gboolean _tmp59_ = FALSE;
						gchar* _tmp60_;
						gchar* _tmp61_;
						gint _tmp62_;
						gint _tmp63_;
						gboolean _tmp66_;
#line 546 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_NONE;
#line 547 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp58_ = self->priv->current;
#line 547 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp58_ + 1;
#line 548 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp60_ = self->priv->current;
#line 548 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp61_ = self->priv->end;
#line 548 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp62_ = strlen ("prefix");
#line 548 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp63_ = _tmp62_;
#line 548 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp60_ < (_tmp61_ - _tmp63_)) {
#line 3418 "tracker-sparql-scanner.c"
							gchar* _tmp64_;
							gboolean _tmp65_ = FALSE;
#line 548 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp64_ = self->priv->current;
#line 548 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp65_ = tracker_sparql_scanner_matches (self, _tmp64_, "PREFIX");
#line 548 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp59_ = _tmp65_;
#line 3427 "tracker-sparql-scanner.c"
						} else {
#line 548 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp59_ = FALSE;
#line 3431 "tracker-sparql-scanner.c"
						}
#line 548 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp66_ = _tmp59_;
#line 548 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp66_) {
#line 3437 "tracker-sparql-scanner.c"
							gchar* _tmp67_;
							gint _tmp68_;
							gint _tmp69_;
#line 549 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							type = TRACKER_SPARQL_TOKEN_TYPE_ATPREFIX;
#line 550 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp67_ = self->priv->current;
#line 550 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp68_ = strlen ("prefix");
#line 550 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp69_ = _tmp68_;
#line 550 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							self->priv->current = _tmp67_ + _tmp69_;
#line 3451 "tracker-sparql-scanner.c"
						} else {
							gboolean _tmp70_ = FALSE;
							gchar* _tmp71_;
							gchar* _tmp72_;
							gint _tmp73_;
							gint _tmp74_;
							gboolean _tmp77_;
#line 551 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp71_ = self->priv->current;
#line 551 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp72_ = self->priv->end;
#line 551 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp73_ = strlen ("base");
#line 551 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp74_ = _tmp73_;
#line 551 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp71_ < (_tmp72_ - _tmp74_)) {
#line 3469 "tracker-sparql-scanner.c"
								gchar* _tmp75_;
								gboolean _tmp76_ = FALSE;
#line 551 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp75_ = self->priv->current;
#line 551 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp76_ = tracker_sparql_scanner_matches (self, _tmp75_, "BASE");
#line 551 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp70_ = _tmp76_;
#line 3478 "tracker-sparql-scanner.c"
							} else {
#line 551 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp70_ = FALSE;
#line 3482 "tracker-sparql-scanner.c"
							}
#line 551 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp77_ = _tmp70_;
#line 551 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp77_) {
#line 3488 "tracker-sparql-scanner.c"
								gchar* _tmp78_;
								gint _tmp79_;
								gint _tmp80_;
#line 552 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								type = TRACKER_SPARQL_TOKEN_TYPE_ATBASE;
#line 553 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp78_ = self->priv->current;
#line 553 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp79_ = strlen ("base");
#line 553 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp80_ = _tmp79_;
#line 553 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								self->priv->current = _tmp78_ + _tmp80_;
#line 3502 "tracker-sparql-scanner.c"
							}
						}
#line 555 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 3507 "tracker-sparql-scanner.c"
					}
#line 488 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '|':
#line 3511 "tracker-sparql-scanner.c"
					{
						gchar* _tmp81_;
						gchar* _tmp82_;
						gchar* _tmp83_;
#line 557 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_NONE;
#line 558 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp81_ = self->priv->current;
#line 558 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp81_ + 1;
#line 559 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp82_ = self->priv->current;
#line 559 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp83_ = self->priv->end;
#line 559 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp82_ < _tmp83_) {
#line 3528 "tracker-sparql-scanner.c"
							gchar* _tmp84_;
							gchar _tmp85_;
#line 560 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp84_ = self->priv->current;
#line 560 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp85_ = _tmp84_[0];
#line 560 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							switch (_tmp85_) {
#line 560 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								case '|':
#line 3539 "tracker-sparql-scanner.c"
								{
									gchar* _tmp86_;
#line 562 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									type = TRACKER_SPARQL_TOKEN_TYPE_OP_OR;
#line 563 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp86_ = self->priv->current;
#line 563 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									self->priv->current = _tmp86_ + 1;
#line 564 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									break;
#line 3550 "tracker-sparql-scanner.c"
								}
								default:
#line 560 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								break;
#line 3555 "tracker-sparql-scanner.c"
							}
						}
#line 567 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 3560 "tracker-sparql-scanner.c"
					}
#line 488 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '&':
#line 3564 "tracker-sparql-scanner.c"
					{
						gchar* _tmp87_;
						gchar* _tmp88_;
						gchar* _tmp89_;
#line 569 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_NONE;
#line 570 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp87_ = self->priv->current;
#line 570 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp87_ + 1;
#line 571 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp88_ = self->priv->current;
#line 571 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp89_ = self->priv->end;
#line 571 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp88_ < _tmp89_) {
#line 3581 "tracker-sparql-scanner.c"
							gchar* _tmp90_;
							gchar _tmp91_;
#line 572 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp90_ = self->priv->current;
#line 572 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp91_ = _tmp90_[0];
#line 572 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							switch (_tmp91_) {
#line 572 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								case '&':
#line 3592 "tracker-sparql-scanner.c"
								{
									gchar* _tmp92_;
#line 574 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									type = TRACKER_SPARQL_TOKEN_TYPE_OP_AND;
#line 575 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp92_ = self->priv->current;
#line 575 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									self->priv->current = _tmp92_ + 1;
#line 576 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									break;
#line 3603 "tracker-sparql-scanner.c"
								}
								default:
#line 572 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								break;
#line 3608 "tracker-sparql-scanner.c"
							}
						}
#line 579 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 3613 "tracker-sparql-scanner.c"
					}
#line 488 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '=':
#line 3617 "tracker-sparql-scanner.c"
					{
						gchar* _tmp93_;
#line 581 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_OP_EQ;
#line 582 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp93_ = self->priv->current;
#line 582 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp93_ + 1;
#line 583 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 3628 "tracker-sparql-scanner.c"
					}
#line 488 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '<':
#line 3632 "tracker-sparql-scanner.c"
					{
						gchar* _tmp94_;
						gchar* _tmp95_;
						gchar* _tmp96_;
#line 585 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_OP_LT;
#line 586 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp94_ = self->priv->current;
#line 586 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp94_ + 1;
#line 587 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp95_ = self->priv->current;
#line 587 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp96_ = self->priv->end;
#line 587 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp95_ < _tmp96_) {
#line 3649 "tracker-sparql-scanner.c"
							gboolean _tmp112_ = FALSE;
							gchar* _tmp113_;
							gchar* _tmp114_;
							gboolean _tmp117_;
							gchar* _tmp120_;
							gchar _tmp121_;
#line 589 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							while (TRUE) {
#line 3658 "tracker-sparql-scanner.c"
								gboolean _tmp97_ = FALSE;
								gchar* _tmp98_;
								gchar* _tmp99_;
								gboolean _tmp102_;
								gboolean _tmp103_ = FALSE;
								gchar* _tmp104_;
								gchar _tmp105_;
								gboolean _tmp108_;
								gchar* _tmp109_;
								gchar _tmp110_;
#line 589 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp98_ = self->priv->current;
#line 589 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp99_ = self->priv->end;
#line 589 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								if (_tmp98_ < _tmp99_) {
#line 3675 "tracker-sparql-scanner.c"
									gchar* _tmp100_;
									gchar _tmp101_;
#line 589 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp100_ = self->priv->current;
#line 589 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp101_ = _tmp100_[0];
#line 589 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp97_ = _tmp101_ != '>';
#line 3684 "tracker-sparql-scanner.c"
								} else {
#line 589 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp97_ = FALSE;
#line 3688 "tracker-sparql-scanner.c"
								}
#line 589 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp102_ = _tmp97_;
#line 589 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								if (!_tmp102_) {
#line 589 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									break;
#line 3696 "tracker-sparql-scanner.c"
								}
#line 590 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp104_ = self->priv->current;
#line 590 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp105_ = _tmp104_[0];
#line 590 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								if (((gint) _tmp105_) >= 0x00) {
#line 3704 "tracker-sparql-scanner.c"
									gchar* _tmp106_;
									gchar _tmp107_;
#line 590 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp106_ = self->priv->current;
#line 590 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp107_ = _tmp106_[0];
#line 590 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp103_ = ((gint) _tmp107_) < 0x20;
#line 3713 "tracker-sparql-scanner.c"
								} else {
#line 590 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp103_ = FALSE;
#line 3717 "tracker-sparql-scanner.c"
								}
#line 590 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp108_ = _tmp103_;
#line 590 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								if (_tmp108_) {
#line 592 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									break;
#line 3725 "tracker-sparql-scanner.c"
								}
#line 594 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp109_ = self->priv->current;
#line 594 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp110_ = _tmp109_[0];
#line 594 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								switch (_tmp110_) {
#line 594 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case '<':
#line 594 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case '>':
#line 594 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case '"':
#line 594 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case ' ':
#line 594 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case '{':
#line 594 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case '}':
#line 594 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case '|':
#line 594 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case '^':
#line 594 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case '`':
#line 594 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case '\\':
#line 3753 "tracker-sparql-scanner.c"
									{
#line 606 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										break;
#line 3757 "tracker-sparql-scanner.c"
									}
									default:
									{
										gchar* _tmp111_;
#line 608 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp111_ = self->priv->current;
#line 608 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										self->priv->current = _tmp111_ + 1;
#line 609 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										continue;
#line 3768 "tracker-sparql-scanner.c"
									}
								}
#line 611 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								break;
#line 3773 "tracker-sparql-scanner.c"
							}
#line 613 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp113_ = self->priv->current;
#line 613 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp114_ = self->priv->end;
#line 613 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp113_ < _tmp114_) {
#line 3781 "tracker-sparql-scanner.c"
								gchar* _tmp115_;
								gchar _tmp116_;
#line 613 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp115_ = self->priv->current;
#line 613 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp116_ = _tmp115_[0];
#line 613 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp112_ = _tmp116_ == '>';
#line 3790 "tracker-sparql-scanner.c"
							} else {
#line 613 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp112_ = FALSE;
#line 3794 "tracker-sparql-scanner.c"
							}
#line 613 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp117_ = _tmp112_;
#line 613 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp117_) {
#line 3800 "tracker-sparql-scanner.c"
								gchar* _tmp118_;
#line 614 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								type = TRACKER_SPARQL_TOKEN_TYPE_IRI_REF;
#line 615 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp118_ = self->priv->current;
#line 615 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								self->priv->current = _tmp118_ + 1;
#line 616 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								break;
#line 3810 "tracker-sparql-scanner.c"
							} else {
								gchar* _tmp119_;
#line 618 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp119_ = begin;
#line 618 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								self->priv->current = _tmp119_ + 1;
#line 3817 "tracker-sparql-scanner.c"
							}
#line 620 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp120_ = self->priv->current;
#line 620 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp121_ = _tmp120_[0];
#line 620 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							switch (_tmp121_) {
#line 620 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								case '=':
#line 3827 "tracker-sparql-scanner.c"
								{
									gchar* _tmp122_;
#line 622 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									type = TRACKER_SPARQL_TOKEN_TYPE_OP_LE;
#line 623 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp122_ = self->priv->current;
#line 623 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									self->priv->current = _tmp122_ + 1;
#line 624 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									break;
#line 3838 "tracker-sparql-scanner.c"
								}
								default:
#line 620 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								break;
#line 3843 "tracker-sparql-scanner.c"
							}
						}
#line 627 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 3848 "tracker-sparql-scanner.c"
					}
#line 488 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '>':
#line 3852 "tracker-sparql-scanner.c"
					{
						gchar* _tmp123_;
						gboolean _tmp124_ = FALSE;
						gchar* _tmp125_;
						gchar* _tmp126_;
						gboolean _tmp129_;
#line 629 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_OP_GT;
#line 630 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp123_ = self->priv->current;
#line 630 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp123_ + 1;
#line 631 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp125_ = self->priv->current;
#line 631 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp126_ = self->priv->end;
#line 631 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp125_ < _tmp126_) {
#line 3871 "tracker-sparql-scanner.c"
							gchar* _tmp127_;
							gchar _tmp128_;
#line 631 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp127_ = self->priv->current;
#line 631 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp128_ = _tmp127_[0];
#line 631 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp124_ = _tmp128_ == '=';
#line 3880 "tracker-sparql-scanner.c"
						} else {
#line 631 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp124_ = FALSE;
#line 3884 "tracker-sparql-scanner.c"
						}
#line 631 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp129_ = _tmp124_;
#line 631 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp129_) {
#line 3890 "tracker-sparql-scanner.c"
							gchar* _tmp130_;
#line 632 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							type = TRACKER_SPARQL_TOKEN_TYPE_OP_GE;
#line 633 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp130_ = self->priv->current;
#line 633 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							self->priv->current = _tmp130_ + 1;
#line 3898 "tracker-sparql-scanner.c"
						}
#line 635 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 3902 "tracker-sparql-scanner.c"
					}
#line 488 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '!':
#line 3906 "tracker-sparql-scanner.c"
					{
						gchar* _tmp131_;
						gboolean _tmp132_ = FALSE;
						gchar* _tmp133_;
						gchar* _tmp134_;
						gboolean _tmp137_;
#line 637 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_OP_NEG;
#line 638 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp131_ = self->priv->current;
#line 638 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp131_ + 1;
#line 639 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp133_ = self->priv->current;
#line 639 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp134_ = self->priv->end;
#line 639 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp133_ < _tmp134_) {
#line 3925 "tracker-sparql-scanner.c"
							gchar* _tmp135_;
							gchar _tmp136_;
#line 639 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp135_ = self->priv->current;
#line 639 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp136_ = _tmp135_[0];
#line 639 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp132_ = _tmp136_ == '=';
#line 3934 "tracker-sparql-scanner.c"
						} else {
#line 639 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp132_ = FALSE;
#line 3938 "tracker-sparql-scanner.c"
						}
#line 639 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp137_ = _tmp132_;
#line 639 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp137_) {
#line 3944 "tracker-sparql-scanner.c"
							gchar* _tmp138_;
#line 640 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							type = TRACKER_SPARQL_TOKEN_TYPE_OP_NE;
#line 641 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp138_ = self->priv->current;
#line 641 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							self->priv->current = _tmp138_ + 1;
#line 3952 "tracker-sparql-scanner.c"
						}
#line 643 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 3956 "tracker-sparql-scanner.c"
					}
#line 488 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '+':
#line 3960 "tracker-sparql-scanner.c"
					{
						gchar* _tmp139_;
#line 645 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_PLUS;
#line 646 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp139_ = self->priv->current;
#line 646 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp139_ + 1;
#line 647 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 3971 "tracker-sparql-scanner.c"
					}
#line 488 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '-':
#line 3975 "tracker-sparql-scanner.c"
					{
						gchar* _tmp140_;
#line 649 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_MINUS;
#line 650 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp140_ = self->priv->current;
#line 650 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp140_ + 1;
#line 651 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 3986 "tracker-sparql-scanner.c"
					}
#line 488 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '*':
#line 3990 "tracker-sparql-scanner.c"
					{
						gchar* _tmp141_;
#line 653 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_STAR;
#line 654 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp141_ = self->priv->current;
#line 654 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp141_ + 1;
#line 655 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 4001 "tracker-sparql-scanner.c"
					}
#line 488 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '/':
#line 4005 "tracker-sparql-scanner.c"
					{
						gchar* _tmp142_;
#line 657 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_DIV;
#line 658 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp142_ = self->priv->current;
#line 658 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp142_ + 1;
#line 659 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 4016 "tracker-sparql-scanner.c"
					}
#line 488 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '\'':
#line 488 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '"':
#line 4022 "tracker-sparql-scanner.c"
					{
						gboolean _tmp143_ = FALSE;
						gboolean _tmp144_ = FALSE;
						gchar* _tmp145_;
						gchar* _tmp146_;
						gboolean _tmp151_;
						gboolean _tmp156_;
						gchar* _tmp220_;
						gchar _tmp221_;
						gchar* _tmp222_;
						gboolean _tmp284_ = FALSE;
						gchar* _tmp285_;
						gchar* _tmp286_;
						gboolean _tmp289_;
#line 662 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp145_ = self->priv->current;
#line 662 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp146_ = self->priv->end;
#line 662 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp145_ < (_tmp146_ - 6)) {
#line 4043 "tracker-sparql-scanner.c"
							gchar* _tmp147_;
							gchar _tmp148_;
							gchar* _tmp149_;
							gchar _tmp150_;
#line 662 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp147_ = begin;
#line 662 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp148_ = _tmp147_[1];
#line 662 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp149_ = begin;
#line 662 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp150_ = _tmp149_[0];
#line 662 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp144_ = _tmp148_ == _tmp150_;
#line 4058 "tracker-sparql-scanner.c"
						} else {
#line 662 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp144_ = FALSE;
#line 4062 "tracker-sparql-scanner.c"
						}
#line 662 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp151_ = _tmp144_;
#line 662 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp151_) {
#line 4068 "tracker-sparql-scanner.c"
							gchar* _tmp152_;
							gchar _tmp153_;
							gchar* _tmp154_;
							gchar _tmp155_;
#line 662 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp152_ = begin;
#line 662 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp153_ = _tmp152_[2];
#line 662 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp154_ = begin;
#line 662 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp155_ = _tmp154_[0];
#line 662 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp143_ = _tmp153_ == _tmp155_;
#line 4083 "tracker-sparql-scanner.c"
						} else {
#line 662 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp143_ = FALSE;
#line 4087 "tracker-sparql-scanner.c"
						}
#line 662 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp156_ = _tmp143_;
#line 662 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp156_) {
#line 4093 "tracker-sparql-scanner.c"
							gchar* _tmp157_;
							gchar _tmp158_;
							gchar* _tmp159_;
							gboolean _tmp199_ = FALSE;
							gboolean _tmp200_ = FALSE;
							gchar* _tmp201_;
							gchar _tmp202_;
							gchar* _tmp203_;
							gchar _tmp204_;
							gboolean _tmp209_;
							gboolean _tmp214_;
#line 663 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp157_ = begin;
#line 663 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp158_ = _tmp157_[0];
#line 663 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp158_ == '\'') {
#line 664 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								type = TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1;
#line 4113 "tracker-sparql-scanner.c"
							} else {
#line 666 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								type = TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2;
#line 4117 "tracker-sparql-scanner.c"
							}
#line 669 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							token_length_in_chars = 6;
#line 670 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp159_ = self->priv->current;
#line 670 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							self->priv->current = _tmp159_ + 3;
#line 671 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							while (TRUE) {
#line 4127 "tracker-sparql-scanner.c"
								gchar* _tmp160_;
								gchar* _tmp161_;
								gboolean _tmp162_ = FALSE;
								gboolean _tmp163_ = FALSE;
								gchar* _tmp164_;
								gchar _tmp165_;
								gchar* _tmp166_;
								gchar _tmp167_;
								gboolean _tmp172_;
								gboolean _tmp177_;
#line 671 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp160_ = self->priv->current;
#line 671 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp161_ = self->priv->end;
#line 671 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								if (!(_tmp160_ < (_tmp161_ - 4))) {
#line 671 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									break;
#line 4146 "tracker-sparql-scanner.c"
								}
#line 672 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp164_ = self->priv->current;
#line 672 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp165_ = _tmp164_[0];
#line 672 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp166_ = begin;
#line 672 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp167_ = _tmp166_[0];
#line 672 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								if (_tmp165_ == _tmp167_) {
#line 4158 "tracker-sparql-scanner.c"
									gchar* _tmp168_;
									gchar _tmp169_;
									gchar* _tmp170_;
									gchar _tmp171_;
#line 672 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp168_ = self->priv->current;
#line 672 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp169_ = _tmp168_[1];
#line 672 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp170_ = begin;
#line 672 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp171_ = _tmp170_[0];
#line 672 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp163_ = _tmp169_ == _tmp171_;
#line 4173 "tracker-sparql-scanner.c"
								} else {
#line 672 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp163_ = FALSE;
#line 4177 "tracker-sparql-scanner.c"
								}
#line 672 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp172_ = _tmp163_;
#line 672 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								if (_tmp172_) {
#line 4183 "tracker-sparql-scanner.c"
									gchar* _tmp173_;
									gchar _tmp174_;
									gchar* _tmp175_;
									gchar _tmp176_;
#line 672 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp173_ = self->priv->current;
#line 672 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp174_ = _tmp173_[2];
#line 672 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp175_ = begin;
#line 672 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp176_ = _tmp175_[0];
#line 672 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp162_ = _tmp174_ == _tmp176_;
#line 4198 "tracker-sparql-scanner.c"
								} else {
#line 672 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp162_ = FALSE;
#line 4202 "tracker-sparql-scanner.c"
								}
#line 672 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp177_ = _tmp162_;
#line 672 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								if (_tmp177_) {
#line 673 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									break;
#line 4210 "tracker-sparql-scanner.c"
								} else {
									gchar* _tmp178_;
									gchar _tmp179_;
#line 674 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp178_ = self->priv->current;
#line 674 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp179_ = _tmp178_[0];
#line 674 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									if (_tmp179_ == '\n') {
#line 4220 "tracker-sparql-scanner.c"
										gchar* _tmp180_;
										gint _tmp181_;
#line 675 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp180_ = self->priv->current;
#line 675 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										self->priv->current = _tmp180_ + 1;
#line 676 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp181_ = self->priv->line;
#line 676 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										self->priv->line = _tmp181_ + 1;
#line 677 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										self->priv->column = 1;
#line 678 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										token_length_in_chars = 3;
#line 4235 "tracker-sparql-scanner.c"
									} else {
										gchar* _tmp182_;
										gchar _tmp183_;
#line 679 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp182_ = self->priv->current;
#line 679 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp183_ = _tmp182_[0];
#line 679 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										if (((gint) ((guchar) _tmp183_)) <= 0x7f) {
#line 4245 "tracker-sparql-scanner.c"
											gchar* _tmp184_;
											gint _tmp185_;
#line 681 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											_tmp184_ = self->priv->current;
#line 681 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											self->priv->current = _tmp184_ + 1;
#line 682 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											_tmp185_ = token_length_in_chars;
#line 682 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											token_length_in_chars = _tmp185_ + 1;
#line 4256 "tracker-sparql-scanner.c"
										} else {
											gchar* _tmp186_;
											gchar* _tmp187_;
											gchar* _tmp188_;
											gunichar _tmp189_ = 0U;
											gunichar u;
											gunichar _tmp190_;
#line 684 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											_tmp186_ = self->priv->current;
#line 684 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											_tmp187_ = self->priv->end;
#line 684 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											_tmp188_ = self->priv->current;
#line 684 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											_tmp189_ = g_utf8_get_char_validated ((const gchar*) _tmp186_, (gssize) ((glong) (_tmp187_ - _tmp188_)));
#line 684 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											u = _tmp189_;
#line 685 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											_tmp190_ = u;
#line 685 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											if (_tmp190_ != ((gunichar) (-1))) {
#line 4278 "tracker-sparql-scanner.c"
												gchar* _tmp191_;
												gunichar _tmp192_;
												gint _tmp193_ = 0;
												gint _tmp194_;
#line 686 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
												_tmp191_ = self->priv->current;
#line 686 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
												_tmp192_ = u;
#line 686 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
												_tmp193_ = g_unichar_to_utf8 (_tmp192_, NULL);
#line 686 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
												self->priv->current = _tmp191_ + _tmp193_;
#line 687 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
												_tmp194_ = token_length_in_chars;
#line 687 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
												token_length_in_chars = _tmp194_ + 1;
#line 4295 "tracker-sparql-scanner.c"
											} else {
												gint _tmp195_;
												gint _tmp196_;
												gint _tmp197_;
												GError* _tmp198_;
#line 689 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
												_tmp195_ = self->priv->line;
#line 689 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
												_tmp196_ = self->priv->column;
#line 689 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
												_tmp197_ = token_length_in_chars;
#line 689 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
												_tmp198_ = g_error_new (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_PARSE, "%d.%d: invalid UTF-8 character", _tmp195_, _tmp196_ + _tmp197_);
#line 689 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
												_inner_error_ = _tmp198_;
#line 689 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 689 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
													g_propagate_error (error, _inner_error_);
#line 689 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
													return 0;
#line 4317 "tracker-sparql-scanner.c"
												} else {
#line 689 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 689 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
													g_clear_error (&_inner_error_);
#line 689 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
													return 0;
#line 4325 "tracker-sparql-scanner.c"
												}
											}
										}
									}
								}
							}
#line 693 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp201_ = self->priv->current;
#line 693 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp202_ = _tmp201_[0];
#line 693 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp203_ = begin;
#line 693 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp204_ = _tmp203_[0];
#line 693 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp202_ == _tmp204_) {
#line 4342 "tracker-sparql-scanner.c"
								gchar* _tmp205_;
								gchar _tmp206_;
								gchar* _tmp207_;
								gchar _tmp208_;
#line 693 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp205_ = self->priv->current;
#line 693 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp206_ = _tmp205_[1];
#line 693 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp207_ = begin;
#line 693 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp208_ = _tmp207_[0];
#line 693 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp200_ = _tmp206_ == _tmp208_;
#line 4357 "tracker-sparql-scanner.c"
							} else {
#line 693 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp200_ = FALSE;
#line 4361 "tracker-sparql-scanner.c"
							}
#line 693 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp209_ = _tmp200_;
#line 693 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp209_) {
#line 4367 "tracker-sparql-scanner.c"
								gchar* _tmp210_;
								gchar _tmp211_;
								gchar* _tmp212_;
								gchar _tmp213_;
#line 693 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp210_ = self->priv->current;
#line 693 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp211_ = _tmp210_[2];
#line 693 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp212_ = begin;
#line 693 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp213_ = _tmp212_[0];
#line 693 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp199_ = _tmp211_ == _tmp213_;
#line 4382 "tracker-sparql-scanner.c"
							} else {
#line 693 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp199_ = FALSE;
#line 4386 "tracker-sparql-scanner.c"
							}
#line 693 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp214_ = _tmp199_;
#line 693 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp214_) {
#line 4392 "tracker-sparql-scanner.c"
								gchar* _tmp215_;
#line 694 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp215_ = self->priv->current;
#line 694 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								self->priv->current = _tmp215_ + 3;
#line 4398 "tracker-sparql-scanner.c"
							} else {
								gint _tmp216_;
								gint _tmp217_;
								gint _tmp218_;
								GError* _tmp219_;
#line 696 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp216_ = self->priv->line;
#line 696 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp217_ = self->priv->column;
#line 696 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp218_ = token_length_in_chars;
#line 696 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp219_ = g_error_new (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_PARSE, "%d.%d: syntax error, expected \"\"\"", _tmp216_, _tmp217_ + _tmp218_);
#line 696 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_inner_error_ = _tmp219_;
#line 696 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 696 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									g_propagate_error (error, _inner_error_);
#line 696 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									return 0;
#line 4420 "tracker-sparql-scanner.c"
								} else {
#line 696 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 696 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									g_clear_error (&_inner_error_);
#line 696 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									return 0;
#line 4428 "tracker-sparql-scanner.c"
								}
							}
#line 698 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 4433 "tracker-sparql-scanner.c"
						}
#line 701 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp220_ = begin;
#line 701 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp221_ = _tmp220_[0];
#line 701 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp221_ == '\'') {
#line 702 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							type = TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1;
#line 4443 "tracker-sparql-scanner.c"
						} else {
#line 704 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							type = TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2;
#line 4447 "tracker-sparql-scanner.c"
						}
#line 707 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						token_length_in_chars = 2;
#line 708 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp222_ = self->priv->current;
#line 708 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp222_ + 1;
#line 709 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						while (TRUE) {
#line 4457 "tracker-sparql-scanner.c"
							gboolean _tmp223_ = FALSE;
							gchar* _tmp224_;
							gchar* _tmp225_;
							gboolean _tmp230_;
							gchar* _tmp231_;
							gchar _tmp232_;
#line 709 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp224_ = self->priv->current;
#line 709 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp225_ = self->priv->end;
#line 709 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp224_ < _tmp225_) {
#line 4470 "tracker-sparql-scanner.c"
								gchar* _tmp226_;
								gchar _tmp227_;
								gchar* _tmp228_;
								gchar _tmp229_;
#line 709 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp226_ = self->priv->current;
#line 709 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp227_ = _tmp226_[0];
#line 709 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp228_ = begin;
#line 709 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp229_ = _tmp228_[0];
#line 709 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp223_ = _tmp227_ != _tmp229_;
#line 4485 "tracker-sparql-scanner.c"
							} else {
#line 709 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp223_ = FALSE;
#line 4489 "tracker-sparql-scanner.c"
							}
#line 709 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp230_ = _tmp223_;
#line 709 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (!_tmp230_) {
#line 709 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								break;
#line 4497 "tracker-sparql-scanner.c"
							}
#line 710 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp231_ = self->priv->current;
#line 710 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp232_ = _tmp231_[0];
#line 710 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp232_ == '\\') {
#line 4505 "tracker-sparql-scanner.c"
								gchar* _tmp233_;
								gint _tmp234_;
								gchar* _tmp235_;
								gchar* _tmp236_;
								gchar* _tmp237_;
								gchar _tmp238_;
#line 711 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp233_ = self->priv->current;
#line 711 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								self->priv->current = _tmp233_ + 1;
#line 712 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp234_ = token_length_in_chars;
#line 712 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								token_length_in_chars = _tmp234_ + 1;
#line 713 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp235_ = self->priv->current;
#line 713 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp236_ = self->priv->end;
#line 713 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								if (_tmp235_ >= _tmp236_) {
#line 714 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									break;
#line 4528 "tracker-sparql-scanner.c"
								}
#line 717 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp237_ = self->priv->current;
#line 717 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp238_ = _tmp237_[0];
#line 717 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								switch (_tmp238_) {
#line 717 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case '\'':
#line 717 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case '"':
#line 717 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case '\\':
#line 717 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case 'b':
#line 717 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case 'f':
#line 717 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case 'n':
#line 717 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case 'r':
#line 717 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case 't':
#line 4552 "tracker-sparql-scanner.c"
									{
										gchar* _tmp239_;
										gint _tmp240_;
#line 726 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp239_ = self->priv->current;
#line 726 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										self->priv->current = _tmp239_ + 1;
#line 727 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp240_ = token_length_in_chars;
#line 727 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										token_length_in_chars = _tmp240_ + 1;
#line 728 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										break;
#line 4566 "tracker-sparql-scanner.c"
									}
#line 717 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case 'u':
#line 4570 "tracker-sparql-scanner.c"
									{
										gchar* _tmp258_;
										gint _tmp259_;
										{
											gint i;
#line 730 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											i = 0;
#line 4578 "tracker-sparql-scanner.c"
											{
												gboolean _tmp241_;
#line 730 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
												_tmp241_ = TRUE;
#line 730 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
												while (TRUE) {
#line 4585 "tracker-sparql-scanner.c"
													gboolean _tmp242_;
													gint _tmp244_;
													gboolean _tmp245_ = FALSE;
													gchar* _tmp246_;
													gint _tmp247_;
													gchar* _tmp248_;
													gboolean _tmp253_;
#line 730 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
													_tmp242_ = _tmp241_;
#line 730 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
													if (!_tmp242_) {
#line 4597 "tracker-sparql-scanner.c"
														gint _tmp243_;
#line 730 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
														_tmp243_ = i;
#line 730 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
														i = _tmp243_ + 1;
#line 4603 "tracker-sparql-scanner.c"
													}
#line 730 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
													_tmp241_ = FALSE;
#line 730 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
													_tmp244_ = i;
#line 730 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
													if (!(_tmp244_ < 4)) {
#line 730 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
														break;
#line 4613 "tracker-sparql-scanner.c"
													}
#line 731 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
													_tmp246_ = self->priv->current;
#line 731 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
													_tmp247_ = i;
#line 731 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
													_tmp248_ = self->priv->end;
#line 731 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
													if (((_tmp246_ + _tmp247_) + 1) >= _tmp248_) {
#line 731 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
														_tmp245_ = TRUE;
#line 4625 "tracker-sparql-scanner.c"
													} else {
														gchar* _tmp249_;
														gint _tmp250_;
														gchar _tmp251_;
														gboolean _tmp252_ = FALSE;
#line 731 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
														_tmp249_ = self->priv->current;
#line 731 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
														_tmp250_ = i;
#line 731 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
														_tmp251_ = _tmp249_[_tmp250_ + 1];
#line 731 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
														_tmp252_ = g_ascii_isxdigit (_tmp251_);
#line 731 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
														_tmp245_ = !_tmp252_;
#line 4641 "tracker-sparql-scanner.c"
													}
#line 731 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
													_tmp253_ = _tmp245_;
#line 731 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
													if (_tmp253_) {
#line 4647 "tracker-sparql-scanner.c"
														gint _tmp254_;
														gint _tmp255_;
														gint _tmp256_;
														GError* _tmp257_;
#line 732 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
														_tmp254_ = self->priv->line;
#line 732 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
														_tmp255_ = self->priv->column;
#line 732 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
														_tmp256_ = token_length_in_chars;
#line 732 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
														_tmp257_ = g_error_new (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_PARSE, "%d.%d: invalid escape sequence", _tmp254_, _tmp255_ + _tmp256_);
#line 732 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
														_inner_error_ = _tmp257_;
#line 732 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 732 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
															g_propagate_error (error, _inner_error_);
#line 732 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
															return 0;
#line 4668 "tracker-sparql-scanner.c"
														} else {
#line 732 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 732 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
															g_clear_error (&_inner_error_);
#line 732 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
															return 0;
#line 4676 "tracker-sparql-scanner.c"
														}
													}
												}
											}
										}
#line 735 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp258_ = self->priv->current;
#line 735 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										self->priv->current = _tmp258_ + 5;
#line 736 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp259_ = token_length_in_chars;
#line 736 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										token_length_in_chars = _tmp259_ + 5;
#line 737 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										break;
#line 4692 "tracker-sparql-scanner.c"
									}
									default:
									{
										gint _tmp260_;
										gint _tmp261_;
										gint _tmp262_;
										GError* _tmp263_;
#line 739 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp260_ = self->priv->line;
#line 739 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp261_ = self->priv->column;
#line 739 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp262_ = token_length_in_chars;
#line 739 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp263_ = g_error_new (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_PARSE, "%d.%d: invalid escape sequence", _tmp260_, _tmp261_ + _tmp262_);
#line 739 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_inner_error_ = _tmp263_;
#line 739 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 739 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											g_propagate_error (error, _inner_error_);
#line 739 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											return 0;
#line 4716 "tracker-sparql-scanner.c"
										} else {
#line 739 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 739 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											g_clear_error (&_inner_error_);
#line 739 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											return 0;
#line 4724 "tracker-sparql-scanner.c"
										}
									}
								}
							} else {
								gchar* _tmp264_;
								gchar _tmp265_;
#line 741 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp264_ = self->priv->current;
#line 741 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp265_ = _tmp264_[0];
#line 741 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								if (_tmp265_ == '\n') {
#line 742 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									break;
#line 4739 "tracker-sparql-scanner.c"
								} else {
									gchar* _tmp266_;
									gchar _tmp267_;
#line 743 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp266_ = self->priv->current;
#line 743 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp267_ = _tmp266_[0];
#line 743 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									if (((gint) ((guchar) _tmp267_)) <= 0x7f) {
#line 4749 "tracker-sparql-scanner.c"
										gchar* _tmp268_;
										gint _tmp269_;
#line 745 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp268_ = self->priv->current;
#line 745 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										self->priv->current = _tmp268_ + 1;
#line 746 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp269_ = token_length_in_chars;
#line 746 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										token_length_in_chars = _tmp269_ + 1;
#line 4760 "tracker-sparql-scanner.c"
									} else {
										gchar* _tmp270_;
										gchar* _tmp271_;
										gchar* _tmp272_;
										gunichar _tmp273_ = 0U;
										gunichar u;
										gunichar _tmp274_;
#line 748 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp270_ = self->priv->current;
#line 748 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp271_ = self->priv->end;
#line 748 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp272_ = self->priv->current;
#line 748 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp273_ = g_utf8_get_char_validated ((const gchar*) _tmp270_, (gssize) ((glong) (_tmp271_ - _tmp272_)));
#line 748 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										u = _tmp273_;
#line 749 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp274_ = u;
#line 749 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										if (_tmp274_ != ((gunichar) (-1))) {
#line 4782 "tracker-sparql-scanner.c"
											gchar* _tmp275_;
											gunichar _tmp276_;
											gint _tmp277_ = 0;
											gint _tmp278_;
#line 750 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											_tmp275_ = self->priv->current;
#line 750 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											_tmp276_ = u;
#line 750 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											_tmp277_ = g_unichar_to_utf8 (_tmp276_, NULL);
#line 750 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											self->priv->current = _tmp275_ + _tmp277_;
#line 751 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											_tmp278_ = token_length_in_chars;
#line 751 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											token_length_in_chars = _tmp278_ + 1;
#line 4799 "tracker-sparql-scanner.c"
										} else {
											gchar* _tmp279_;
											gint _tmp280_;
											gint _tmp281_;
											gint _tmp282_;
											GError* _tmp283_;
#line 753 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											_tmp279_ = self->priv->current;
#line 753 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											self->priv->current = _tmp279_ + 1;
#line 754 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											_tmp280_ = self->priv->line;
#line 754 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											_tmp281_ = self->priv->column;
#line 754 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											_tmp282_ = token_length_in_chars;
#line 754 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											_tmp283_ = g_error_new (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_PARSE, "%d.%d: invalid UTF-8 character", _tmp280_, _tmp281_ + _tmp282_);
#line 754 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											_inner_error_ = _tmp283_;
#line 754 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 754 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
												g_propagate_error (error, _inner_error_);
#line 754 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
												return 0;
#line 4826 "tracker-sparql-scanner.c"
											} else {
#line 754 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 754 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
												g_clear_error (&_inner_error_);
#line 754 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
												return 0;
#line 4834 "tracker-sparql-scanner.c"
											}
										}
									}
								}
							}
						}
#line 758 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp285_ = self->priv->current;
#line 758 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp286_ = self->priv->end;
#line 758 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp285_ < _tmp286_) {
#line 4847 "tracker-sparql-scanner.c"
							gchar* _tmp287_;
							gchar _tmp288_;
#line 758 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp287_ = self->priv->current;
#line 758 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp288_ = _tmp287_[0];
#line 758 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp284_ = _tmp288_ != '\n';
#line 4856 "tracker-sparql-scanner.c"
						} else {
#line 758 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp284_ = FALSE;
#line 4860 "tracker-sparql-scanner.c"
						}
#line 758 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp289_ = _tmp284_;
#line 758 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp289_) {
#line 4866 "tracker-sparql-scanner.c"
							gchar* _tmp290_;
#line 759 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp290_ = self->priv->current;
#line 759 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							self->priv->current = _tmp290_ + 1;
#line 4872 "tracker-sparql-scanner.c"
						} else {
							gint _tmp291_;
							gint _tmp292_;
							gint _tmp293_;
							gchar* _tmp294_;
							gchar _tmp295_;
							GError* _tmp296_;
#line 761 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp291_ = self->priv->line;
#line 761 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp292_ = self->priv->column;
#line 761 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp293_ = token_length_in_chars;
#line 761 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp294_ = begin;
#line 761 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp295_ = _tmp294_[0];
#line 761 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp296_ = g_error_new (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_PARSE, "%d.%d: syntax error, expected %c", _tmp291_, _tmp292_ + _tmp293_, _tmp295_);
#line 761 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_inner_error_ = _tmp296_;
#line 761 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 761 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								g_propagate_error (error, _inner_error_);
#line 761 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return 0;
#line 4900 "tracker-sparql-scanner.c"
							} else {
#line 761 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 761 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								g_clear_error (&_inner_error_);
#line 761 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return 0;
#line 4908 "tracker-sparql-scanner.c"
							}
						}
#line 763 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 4913 "tracker-sparql-scanner.c"
					}
#line 488 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '^':
#line 4917 "tracker-sparql-scanner.c"
					{
						gboolean _tmp297_ = FALSE;
						gchar* _tmp298_;
						gchar* _tmp299_;
						gboolean _tmp304_;
#line 765 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_NONE;
#line 766 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp298_ = self->priv->current;
#line 766 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp299_ = self->priv->end;
#line 766 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp298_ < (_tmp299_ - 2)) {
#line 4931 "tracker-sparql-scanner.c"
							gchar* _tmp300_;
							gchar _tmp301_;
							gchar* _tmp302_;
							gchar _tmp303_;
#line 766 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp300_ = self->priv->current;
#line 766 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp301_ = _tmp300_[0];
#line 766 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp302_ = self->priv->current;
#line 766 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp303_ = _tmp302_[1];
#line 766 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp297_ = _tmp301_ == _tmp303_;
#line 4946 "tracker-sparql-scanner.c"
						} else {
#line 766 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp297_ = FALSE;
#line 4950 "tracker-sparql-scanner.c"
						}
#line 766 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp304_ = _tmp297_;
#line 766 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp304_) {
#line 4956 "tracker-sparql-scanner.c"
							gchar* _tmp305_;
#line 767 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							type = TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX;
#line 768 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp305_ = self->priv->current;
#line 768 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							self->priv->current = _tmp305_ + 2;
#line 4964 "tracker-sparql-scanner.c"
						} else {
							gint _tmp306_;
							gint _tmp307_;
							GError* _tmp308_;
#line 770 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp306_ = self->priv->line;
#line 770 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp307_ = self->priv->column;
#line 770 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp308_ = g_error_new (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_PARSE, "%d.%d: syntax error, unexpected character", _tmp306_, _tmp307_);
#line 770 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_inner_error_ = _tmp308_;
#line 770 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 770 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								g_propagate_error (error, _inner_error_);
#line 770 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return 0;
#line 4983 "tracker-sparql-scanner.c"
							} else {
#line 770 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 770 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								g_clear_error (&_inner_error_);
#line 770 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return 0;
#line 4991 "tracker-sparql-scanner.c"
							}
						}
#line 772 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 4996 "tracker-sparql-scanner.c"
					}
#line 488 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '_':
#line 5000 "tracker-sparql-scanner.c"
					{
						gchar* _tmp309_;
#line 774 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE;
#line 775 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp309_ = self->priv->current;
#line 775 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp309_ + 1;
#line 776 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 5011 "tracker-sparql-scanner.c"
					}
					default:
					{
						gchar* _tmp310_;
						gchar* _tmp311_;
						gchar* _tmp312_;
						gunichar _tmp313_ = 0U;
						gunichar u;
						gunichar _tmp314_;
#line 778 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp310_ = self->priv->current;
#line 778 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp311_ = self->priv->end;
#line 778 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp312_ = self->priv->current;
#line 778 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp313_ = g_utf8_get_char_validated ((const gchar*) _tmp310_, (gssize) ((glong) (_tmp311_ - _tmp312_)));
#line 778 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						u = _tmp313_;
#line 779 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp314_ = u;
#line 779 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp314_ != ((gunichar) (-1))) {
#line 5035 "tracker-sparql-scanner.c"
							gint _tmp315_;
							gint _tmp316_;
							GError* _tmp317_;
#line 780 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp315_ = self->priv->line;
#line 780 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp316_ = self->priv->column;
#line 780 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp317_ = g_error_new (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_PARSE, "%d.%d: syntax error, unexpected character", _tmp315_, _tmp316_);
#line 780 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_inner_error_ = _tmp317_;
#line 780 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 780 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								g_propagate_error (error, _inner_error_);
#line 780 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return 0;
#line 5053 "tracker-sparql-scanner.c"
							} else {
#line 780 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 780 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								g_clear_error (&_inner_error_);
#line 780 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return 0;
#line 5061 "tracker-sparql-scanner.c"
							}
						} else {
							gint _tmp318_;
							gint _tmp319_;
							GError* _tmp320_;
#line 782 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp318_ = self->priv->line;
#line 782 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp319_ = self->priv->column;
#line 782 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp320_ = g_error_new (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_PARSE, "%d.%d: invalid UTF-8 character", _tmp318_, _tmp319_);
#line 782 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_inner_error_ = _tmp320_;
#line 782 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 782 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								g_propagate_error (error, _inner_error_);
#line 782 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return 0;
#line 5081 "tracker-sparql-scanner.c"
							} else {
#line 782 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 782 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								g_clear_error (&_inner_error_);
#line 782 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return 0;
#line 5089 "tracker-sparql-scanner.c"
							}
						}
					}
				}
			}
		}
	}
#line 787 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp321_ = token_length_in_chars;
#line 787 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp321_ < 0) {
#line 5101 "tracker-sparql-scanner.c"
		gint _tmp322_;
		gchar* _tmp323_;
		gchar* _tmp324_;
#line 788 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp322_ = self->priv->column;
#line 788 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp323_ = self->priv->current;
#line 788 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp324_ = begin;
#line 788 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		self->priv->column = _tmp322_ + ((gint) (_tmp323_ - _tmp324_));
#line 5113 "tracker-sparql-scanner.c"
	} else {
		gint _tmp325_;
		gint _tmp326_;
#line 790 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp325_ = self->priv->column;
#line 790 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp326_ = token_length_in_chars;
#line 790 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		self->priv->column = _tmp325_ + _tmp326_;
#line 5123 "tracker-sparql-scanner.c"
	}
#line 793 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp327_ = self->priv->current;
#line 793 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp328_ = self->priv->line;
#line 793 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp329_ = self->priv->column;
#line 793 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	tracker_source_location_init (&_tmp330_, _tmp327_, _tmp328_, _tmp329_ - 1);
#line 793 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_vala_token_end = _tmp330_;
#line 795 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	result = type;
#line 795 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (token_begin) {
#line 795 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		*token_begin = _vala_token_begin;
#line 5141 "tracker-sparql-scanner.c"
	}
#line 795 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (token_end) {
#line 795 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		*token_end = _vala_token_end;
#line 5147 "tracker-sparql-scanner.c"
	}
#line 795 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	return result;
#line 5151 "tracker-sparql-scanner.c"
}


static gboolean tracker_sparql_scanner_matches (TrackerSparqlScanner* self, gchar* begin, const gchar* keyword) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* keyword_array;
#line 798 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 798 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	g_return_val_if_fail (keyword != NULL, FALSE);
#line 799 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp0_ = keyword;
#line 799 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	keyword_array = _tmp0_;
#line 5167 "tracker-sparql-scanner.c"
	{
		gint i;
#line 800 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		i = 0;
#line 5172 "tracker-sparql-scanner.c"
		{
			gboolean _tmp1_;
#line 800 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp1_ = TRUE;
#line 800 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			while (TRUE) {
#line 5179 "tracker-sparql-scanner.c"
				gboolean _tmp2_;
				gchar* _tmp4_;
				gint _tmp5_;
				gchar _tmp6_;
				gchar* _tmp7_;
				gint _tmp8_;
				gchar _tmp9_;
				gchar _tmp10_ = '\0';
				gchar* _tmp11_;
				gint _tmp12_;
				gchar _tmp13_;
#line 800 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp2_ = _tmp1_;
#line 800 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				if (!_tmp2_) {
#line 5195 "tracker-sparql-scanner.c"
					gint _tmp3_;
#line 800 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp3_ = i;
#line 800 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					i = _tmp3_ + 1;
#line 5201 "tracker-sparql-scanner.c"
				}
#line 800 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp1_ = FALSE;
#line 800 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp4_ = keyword_array;
#line 800 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp5_ = i;
#line 800 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp6_ = _tmp4_[_tmp5_];
#line 800 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				if (!(((gint) _tmp6_) != 0)) {
#line 800 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 5215 "tracker-sparql-scanner.c"
				}
#line 801 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp7_ = begin;
#line 801 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp8_ = i;
#line 801 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp9_ = _tmp7_[_tmp8_];
#line 801 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp10_ = g_ascii_toupper (_tmp9_);
#line 801 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp11_ = keyword_array;
#line 801 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp12_ = i;
#line 801 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp13_ = _tmp11_[_tmp12_];
#line 801 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				if (_tmp10_ != _tmp13_) {
#line 802 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					result = FALSE;
#line 802 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					return result;
#line 5237 "tracker-sparql-scanner.c"
				}
			}
		}
	}
#line 805 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	result = TRUE;
#line 805 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	return result;
#line 5246 "tracker-sparql-scanner.c"
}


static gboolean tracker_sparql_scanner_whitespace (TrackerSparqlScanner* self) {
	gboolean result = FALSE;
	gboolean found;
#line 808 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 809 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	found = FALSE;
#line 810 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	while (TRUE) {
#line 5259 "tracker-sparql-scanner.c"
		gboolean _tmp0_ = FALSE;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gboolean _tmp6_;
		gchar* _tmp7_;
		gchar _tmp8_;
		gchar* _tmp10_;
		gint _tmp11_;
#line 810 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp1_ = self->priv->current;
#line 810 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp2_ = self->priv->end;
#line 810 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		if (_tmp1_ < _tmp2_) {
#line 5274 "tracker-sparql-scanner.c"
			gchar* _tmp3_;
			gchar _tmp4_;
			gboolean _tmp5_ = FALSE;
#line 810 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp3_ = self->priv->current;
#line 810 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp4_ = _tmp3_[0];
#line 810 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp5_ = g_ascii_isspace (_tmp4_);
#line 810 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp0_ = _tmp5_;
#line 5286 "tracker-sparql-scanner.c"
		} else {
#line 810 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp0_ = FALSE;
#line 5290 "tracker-sparql-scanner.c"
		}
#line 810 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp6_ = _tmp0_;
#line 810 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		if (!_tmp6_) {
#line 810 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			break;
#line 5298 "tracker-sparql-scanner.c"
		}
#line 811 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp7_ = self->priv->current;
#line 811 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp8_ = _tmp7_[0];
#line 811 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		if (_tmp8_ == '\n') {
#line 5306 "tracker-sparql-scanner.c"
			gint _tmp9_;
#line 812 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp9_ = self->priv->line;
#line 812 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			self->priv->line = _tmp9_ + 1;
#line 813 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			self->priv->column = 0;
#line 5314 "tracker-sparql-scanner.c"
		}
#line 815 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		found = TRUE;
#line 816 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp10_ = self->priv->current;
#line 816 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		self->priv->current = _tmp10_ + 1;
#line 817 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp11_ = self->priv->column;
#line 817 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		self->priv->column = _tmp11_ + 1;
#line 5326 "tracker-sparql-scanner.c"
	}
#line 819 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	result = found;
#line 819 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	return result;
#line 5332 "tracker-sparql-scanner.c"
}


static gboolean tracker_sparql_scanner_comment (TrackerSparqlScanner* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp5_;
#line 822 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 823 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp1_ = self->priv->current;
#line 823 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp2_ = self->priv->end;
#line 823 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp1_ >= _tmp2_) {
#line 823 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp0_ = TRUE;
#line 5352 "tracker-sparql-scanner.c"
	} else {
		gchar* _tmp3_;
		gchar _tmp4_;
#line 823 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp3_ = self->priv->current;
#line 823 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp4_ = _tmp3_[0];
#line 823 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp0_ = _tmp4_ != '#';
#line 5362 "tracker-sparql-scanner.c"
	}
#line 823 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp5_ = _tmp0_;
#line 823 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp5_) {
#line 824 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		result = FALSE;
#line 824 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		return result;
#line 5372 "tracker-sparql-scanner.c"
	}
#line 829 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	while (TRUE) {
#line 5376 "tracker-sparql-scanner.c"
		gboolean _tmp6_ = FALSE;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gboolean _tmp11_;
		gchar* _tmp12_;
#line 829 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp7_ = self->priv->current;
#line 829 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp8_ = self->priv->end;
#line 829 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		if (_tmp7_ < _tmp8_) {
#line 5388 "tracker-sparql-scanner.c"
			gchar* _tmp9_;
			gchar _tmp10_;
#line 829 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp9_ = self->priv->current;
#line 829 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp10_ = _tmp9_[0];
#line 829 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp6_ = _tmp10_ != '\n';
#line 5397 "tracker-sparql-scanner.c"
		} else {
#line 829 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp6_ = FALSE;
#line 5401 "tracker-sparql-scanner.c"
		}
#line 829 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp11_ = _tmp6_;
#line 829 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		if (!_tmp11_) {
#line 829 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			break;
#line 5409 "tracker-sparql-scanner.c"
		}
#line 830 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp12_ = self->priv->current;
#line 830 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		self->priv->current = _tmp12_ + 1;
#line 5415 "tracker-sparql-scanner.c"
	}
#line 833 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	result = TRUE;
#line 833 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	return result;
#line 5421 "tracker-sparql-scanner.c"
}


static void tracker_sparql_scanner_space (TrackerSparqlScanner* self) {
#line 836 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	g_return_if_fail (self != NULL);
#line 837 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	while (TRUE) {
#line 5430 "tracker-sparql-scanner.c"
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gboolean _tmp3_;
#line 837 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp1_ = tracker_sparql_scanner_whitespace (self);
#line 837 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		if (_tmp1_) {
#line 837 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp0_ = TRUE;
#line 5440 "tracker-sparql-scanner.c"
		} else {
			gboolean _tmp2_ = FALSE;
#line 837 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp2_ = tracker_sparql_scanner_comment (self);
#line 837 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp0_ = _tmp2_;
#line 5447 "tracker-sparql-scanner.c"
		}
#line 837 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp3_ = _tmp0_;
#line 837 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		if (!_tmp3_) {
#line 837 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			break;
#line 5455 "tracker-sparql-scanner.c"
		}
	}
}


static void tracker_sparql_scanner_class_init (TrackerSparqlScannerClass * klass) {
#line 20 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	tracker_sparql_scanner_parent_class = g_type_class_peek_parent (klass);
#line 20 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	g_type_class_add_private (klass, sizeof (TrackerSparqlScannerPrivate));
#line 20 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_scanner_finalize;
#line 5468 "tracker-sparql-scanner.c"
}


static void tracker_sparql_scanner_instance_init (TrackerSparqlScanner * self) {
#line 20 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	self->priv = TRACKER_SPARQL_SCANNER_GET_PRIVATE (self);
#line 5475 "tracker-sparql-scanner.c"
}


static void tracker_sparql_scanner_finalize (GObject* obj) {
	TrackerSparqlScanner * self;
#line 20 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	self = TRACKER_SPARQL_SCANNER (obj);
#line 20 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	G_OBJECT_CLASS (tracker_sparql_scanner_parent_class)->finalize (obj);
#line 5485 "tracker-sparql-scanner.c"
}


GType tracker_sparql_scanner_get_type (void) {
	static volatile gsize tracker_sparql_scanner_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_scanner_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlScannerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_scanner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlScanner), 0, (GInstanceInitFunc) tracker_sparql_scanner_instance_init, NULL };
		GType tracker_sparql_scanner_type_id;
		tracker_sparql_scanner_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerSparqlScanner", &g_define_type_info, 0);
		g_once_init_leave (&tracker_sparql_scanner_type_id__volatile, tracker_sparql_scanner_type_id);
	}
	return tracker_sparql_scanner_type_id__volatile;
}


void tracker_source_location_init (TrackerSourceLocation *self, gchar* pos, gint line, gint column) {
	gchar* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
#line 850 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	memset (self, 0, sizeof (TrackerSourceLocation));
#line 851 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp0_ = pos;
#line 851 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	(*self).pos = _tmp0_;
#line 852 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp1_ = line;
#line 852 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	(*self).line = _tmp1_;
#line 853 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp2_ = column;
#line 853 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	(*self).column = _tmp2_;
#line 5519 "tracker-sparql-scanner.c"
}


TrackerSourceLocation* tracker_source_location_dup (const TrackerSourceLocation* self) {
	TrackerSourceLocation* dup;
#line 845 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	dup = g_new0 (TrackerSourceLocation, 1);
#line 845 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	memcpy (dup, self, sizeof (TrackerSourceLocation));
#line 845 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	return dup;
#line 5531 "tracker-sparql-scanner.c"
}


void tracker_source_location_free (TrackerSourceLocation* self) {
#line 845 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	g_free (self);
#line 5538 "tracker-sparql-scanner.c"
}


GType tracker_source_location_get_type (void) {
	static volatile gsize tracker_source_location_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_source_location_type_id__volatile)) {
		GType tracker_source_location_type_id;
		tracker_source_location_type_id = g_boxed_type_register_static ("TrackerSourceLocation", (GBoxedCopyFunc) tracker_source_location_dup, (GBoxedFreeFunc) tracker_source_location_free);
		g_once_init_leave (&tracker_source_location_type_id__volatile, tracker_source_location_type_id);
	}
	return tracker_source_location_type_id__volatile;
}


const gchar* tracker_sparql_token_type_to_string (TrackerSparqlTokenType self) {
	const gchar* result = NULL;
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	switch (self) {
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_A:
#line 5559 "tracker-sparql-scanner.c"
		{
#line 959 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`a'";
#line 959 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5565 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_AS:
#line 5569 "tracker-sparql-scanner.c"
		{
#line 960 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`AS'";
#line 960 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5575 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ASC:
#line 5579 "tracker-sparql-scanner.c"
		{
#line 961 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`ASC'";
#line 961 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5585 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ASK:
#line 5589 "tracker-sparql-scanner.c"
		{
#line 962 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`ASK'";
#line 962 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5595 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ATBASE:
#line 5599 "tracker-sparql-scanner.c"
		{
#line 963 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`@base'";
#line 963 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5605 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ATPREFIX:
#line 5609 "tracker-sparql-scanner.c"
		{
#line 964 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`@prefix'";
#line 964 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5615 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_AVG:
#line 5619 "tracker-sparql-scanner.c"
		{
#line 965 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`AVG'";
#line 965 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5625 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_BASE:
#line 5629 "tracker-sparql-scanner.c"
		{
#line 966 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`BASE'";
#line 966 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5635 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE:
#line 5639 "tracker-sparql-scanner.c"
		{
#line 967 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "blank node";
#line 967 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5645 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_BOUND:
#line 5649 "tracker-sparql-scanner.c"
		{
#line 968 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`BOUND'";
#line 968 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5655 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_BY:
#line 5659 "tracker-sparql-scanner.c"
		{
#line 969 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`BY'";
#line 969 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5665 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE:
#line 5669 "tracker-sparql-scanner.c"
		{
#line 970 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`}'";
#line 970 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5675 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACKET:
#line 5679 "tracker-sparql-scanner.c"
		{
#line 971 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`]'";
#line 971 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5685 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS:
#line 5689 "tracker-sparql-scanner.c"
		{
#line 972 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`)'";
#line 972 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5695 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_COALESCE:
#line 5699 "tracker-sparql-scanner.c"
		{
#line 973 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`COALESCE'";
#line 973 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5705 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_COLON:
#line 5709 "tracker-sparql-scanner.c"
		{
#line 974 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`:'";
#line 974 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5715 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_COMMA:
#line 5719 "tracker-sparql-scanner.c"
		{
#line 975 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`,'";
#line 975 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5725 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_CONSTRUCT:
#line 5729 "tracker-sparql-scanner.c"
		{
#line 976 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`CONSTRUCT'";
#line 976 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5735 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_COUNT:
#line 5739 "tracker-sparql-scanner.c"
		{
#line 977 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`COUNT'";
#line 977 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5745 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DATATYPE:
#line 5749 "tracker-sparql-scanner.c"
		{
#line 978 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`DATATYPE'";
#line 978 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5755 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DECIMAL:
#line 5759 "tracker-sparql-scanner.c"
		{
#line 979 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`DECIMAL'";
#line 979 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5765 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DELETE:
#line 5769 "tracker-sparql-scanner.c"
		{
#line 980 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`DELETE'";
#line 980 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5775 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DESC:
#line 5779 "tracker-sparql-scanner.c"
		{
#line 981 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`DESC'";
#line 981 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5785 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DESCRIBE:
#line 5789 "tracker-sparql-scanner.c"
		{
#line 982 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`DESCRIBE'";
#line 982 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5795 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DISTINCT:
#line 5799 "tracker-sparql-scanner.c"
		{
#line 983 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`DISTINCT'";
#line 983 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5805 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DOUBLE:
#line 5809 "tracker-sparql-scanner.c"
		{
#line 984 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`DOUBLE'";
#line 984 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5815 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX:
#line 5819 "tracker-sparql-scanner.c"
		{
#line 985 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`^^'";
#line 985 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5825 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DROP:
#line 5829 "tracker-sparql-scanner.c"
		{
#line 986 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`DROP'";
#line 986 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5835 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_EOF:
#line 5839 "tracker-sparql-scanner.c"
		{
#line 987 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "end of file";
#line 987 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5845 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_EXISTS:
#line 5849 "tracker-sparql-scanner.c"
		{
#line 988 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`EXISTS'";
#line 988 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5855 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_FALSE:
#line 5859 "tracker-sparql-scanner.c"
		{
#line 989 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`false'";
#line 989 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5865 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_FILTER:
#line 5869 "tracker-sparql-scanner.c"
		{
#line 990 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`FILTER'";
#line 990 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5875 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_FROM:
#line 5879 "tracker-sparql-scanner.c"
		{
#line 991 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`FROM'";
#line 991 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5885 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_GRAPH:
#line 5889 "tracker-sparql-scanner.c"
		{
#line 992 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`GRAPH'";
#line 992 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5895 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_GROUP:
#line 5899 "tracker-sparql-scanner.c"
		{
#line 993 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`GROUP'";
#line 993 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5905 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_GROUP_CONCAT:
#line 5909 "tracker-sparql-scanner.c"
		{
#line 994 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`GROUP_CONCAT'";
#line 994 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5915 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_HAVING:
#line 5919 "tracker-sparql-scanner.c"
		{
#line 995 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`HAVING'";
#line 995 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5925 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_IF:
#line 5929 "tracker-sparql-scanner.c"
		{
#line 996 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`IF'";
#line 996 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5935 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_INSERT:
#line 5939 "tracker-sparql-scanner.c"
		{
#line 997 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`INSERT'";
#line 997 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5945 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_INTEGER:
#line 5949 "tracker-sparql-scanner.c"
		{
#line 998 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`INTEGER'";
#line 998 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5955 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_INTO:
#line 5959 "tracker-sparql-scanner.c"
		{
#line 999 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`INTO'";
#line 999 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5965 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_IRI_REF:
#line 5969 "tracker-sparql-scanner.c"
		{
#line 1000 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "IRI reference";
#line 1000 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5975 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ISBLANK:
#line 5979 "tracker-sparql-scanner.c"
		{
#line 1001 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`ISBLANK'";
#line 1001 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5985 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ISIRI:
#line 5989 "tracker-sparql-scanner.c"
		{
#line 1002 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`ISIRI'";
#line 1002 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5995 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL:
#line 5999 "tracker-sparql-scanner.c"
		{
#line 1003 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`ISLITERAL'";
#line 1003 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6005 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ISURI:
#line 6009 "tracker-sparql-scanner.c"
		{
#line 1004 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`ISURI'";
#line 1004 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6015 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_LANG:
#line 6019 "tracker-sparql-scanner.c"
		{
#line 1005 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`LANG'";
#line 1005 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6025 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES:
#line 6029 "tracker-sparql-scanner.c"
		{
#line 1006 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`LANGMATCHES'";
#line 1006 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6035 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_LIMIT:
#line 6039 "tracker-sparql-scanner.c"
		{
#line 1007 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`LIMIT'";
#line 1007 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6045 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_MAX:
#line 6049 "tracker-sparql-scanner.c"
		{
#line 1008 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`MAX'";
#line 1008 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6055 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_MIN:
#line 6059 "tracker-sparql-scanner.c"
		{
#line 1009 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`MIN'";
#line 1009 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6065 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_MINUS:
#line 6069 "tracker-sparql-scanner.c"
		{
#line 1010 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`-'";
#line 1010 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6075 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_NAMED:
#line 6079 "tracker-sparql-scanner.c"
		{
#line 1011 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`NAMED'";
#line 1011 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6085 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_NOT:
#line 6089 "tracker-sparql-scanner.c"
		{
#line 1012 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`NOT'";
#line 1012 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6095 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OFFSET:
#line 6099 "tracker-sparql-scanner.c"
		{
#line 1013 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`OFFSET'";
#line 1013 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6105 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OP_AND:
#line 6109 "tracker-sparql-scanner.c"
		{
#line 1014 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`&&'";
#line 1014 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6115 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OP_EQ:
#line 6119 "tracker-sparql-scanner.c"
		{
#line 1015 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`='";
#line 1015 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6125 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OP_GE:
#line 6129 "tracker-sparql-scanner.c"
		{
#line 1016 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`>='";
#line 1016 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6135 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OP_GT:
#line 6139 "tracker-sparql-scanner.c"
		{
#line 1017 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`>'";
#line 1017 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6145 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OP_LE:
#line 6149 "tracker-sparql-scanner.c"
		{
#line 1018 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`<='";
#line 1018 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6155 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OP_LT:
#line 6159 "tracker-sparql-scanner.c"
		{
#line 1019 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`<'";
#line 1019 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6165 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OP_NE:
#line 6169 "tracker-sparql-scanner.c"
		{
#line 1020 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`!='";
#line 1020 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6175 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OP_NEG:
#line 6179 "tracker-sparql-scanner.c"
		{
#line 1021 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`!'";
#line 1021 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6185 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OP_OR:
#line 6189 "tracker-sparql-scanner.c"
		{
#line 1022 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`||'";
#line 1022 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6195 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OP_IN:
#line 6199 "tracker-sparql-scanner.c"
		{
#line 1023 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`IN'";
#line 1023 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6205 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE:
#line 6209 "tracker-sparql-scanner.c"
		{
#line 1024 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`{'";
#line 1024 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6215 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET:
#line 6219 "tracker-sparql-scanner.c"
		{
#line 1025 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`['";
#line 1025 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6225 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS:
#line 6229 "tracker-sparql-scanner.c"
		{
#line 1026 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`('";
#line 1026 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6235 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OPTIONAL:
#line 6239 "tracker-sparql-scanner.c"
		{
#line 1027 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`OPTIONAL'";
#line 1027 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6245 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OR:
#line 6249 "tracker-sparql-scanner.c"
		{
#line 1028 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`OR'";
#line 1028 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6255 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ORDER:
#line 6259 "tracker-sparql-scanner.c"
		{
#line 1029 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`ORDER'";
#line 1029 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6265 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_PLUS:
#line 6269 "tracker-sparql-scanner.c"
		{
#line 1030 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`+'";
#line 1030 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6275 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX:
#line 6279 "tracker-sparql-scanner.c"
		{
#line 1031 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "prefixed name";
#line 1031 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6285 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_PREFIX:
#line 6289 "tracker-sparql-scanner.c"
		{
#line 1032 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`PREFIX'";
#line 1032 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6295 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_REDUCED:
#line 6299 "tracker-sparql-scanner.c"
		{
#line 1033 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`REDUCED'";
#line 1033 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6305 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_REGEX:
#line 6309 "tracker-sparql-scanner.c"
		{
#line 1034 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`REGEX'";
#line 1034 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6315 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_REPLACE:
#line 6319 "tracker-sparql-scanner.c"
		{
#line 1035 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`REPLACE'";
#line 1035 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6325 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_SAMETERM:
#line 6329 "tracker-sparql-scanner.c"
		{
#line 1036 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`SAMETERM'";
#line 1036 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6335 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_SELECT:
#line 6339 "tracker-sparql-scanner.c"
		{
#line 1037 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`SELECT'";
#line 1037 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6345 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON:
#line 6349 "tracker-sparql-scanner.c"
		{
#line 1038 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`;'";
#line 1038 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6355 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_SILENT:
#line 6359 "tracker-sparql-scanner.c"
		{
#line 1039 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`SILENT'";
#line 1039 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6365 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STAR:
#line 6369 "tracker-sparql-scanner.c"
		{
#line 1040 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`*'";
#line 1040 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6375 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STR:
#line 6379 "tracker-sparql-scanner.c"
		{
#line 1041 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`STR'";
#line 1041 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6385 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1:
#line 6389 "tracker-sparql-scanner.c"
		{
#line 1042 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "string literal";
#line 1042 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6395 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2:
#line 6399 "tracker-sparql-scanner.c"
		{
#line 1043 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "string literal";
#line 1043 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6405 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1:
#line 6409 "tracker-sparql-scanner.c"
		{
#line 1044 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "string literal";
#line 1044 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6415 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2:
#line 6419 "tracker-sparql-scanner.c"
		{
#line 1045 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "string literal";
#line 1045 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6425 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_SUM:
#line 6429 "tracker-sparql-scanner.c"
		{
#line 1046 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`SUM'";
#line 1046 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6435 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_TRUE:
#line 6439 "tracker-sparql-scanner.c"
		{
#line 1047 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`true'";
#line 1047 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6445 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_UNION:
#line 6449 "tracker-sparql-scanner.c"
		{
#line 1048 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`UNION'";
#line 1048 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6455 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_VAR:
#line 6459 "tracker-sparql-scanner.c"
		{
#line 1049 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "variable";
#line 1049 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6465 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_WHERE:
#line 6469 "tracker-sparql-scanner.c"
		{
#line 1050 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`WHERE'";
#line 1050 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6475 "tracker-sparql-scanner.c"
		}
#line 958 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_WITH:
#line 6479 "tracker-sparql-scanner.c"
		{
#line 1051 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`WITH'";
#line 1051 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6485 "tracker-sparql-scanner.c"
		}
		default:
		{
#line 1052 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "unknown token";
#line 1052 "/home/juerg/Code/tracker/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6493 "tracker-sparql-scanner.c"
		}
	}
}


GType tracker_sparql_token_type_get_type (void) {
	static volatile gsize tracker_sparql_token_type_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_token_type_type_id__volatile)) {
		static const GEnumValue values[] = {{TRACKER_SPARQL_TOKEN_TYPE_NONE, "TRACKER_SPARQL_TOKEN_TYPE_NONE", "none"}, {TRACKER_SPARQL_TOKEN_TYPE_A, "TRACKER_SPARQL_TOKEN_TYPE_A", "a"}, {TRACKER_SPARQL_TOKEN_TYPE_AS, "TRACKER_SPARQL_TOKEN_TYPE_AS", "as"}, {TRACKER_SPARQL_TOKEN_TYPE_ASC, "TRACKER_SPARQL_TOKEN_TYPE_ASC", "asc"}, {TRACKER_SPARQL_TOKEN_TYPE_ASK, "TRACKER_SPARQL_TOKEN_TYPE_ASK", "ask"}, {TRACKER_SPARQL_TOKEN_TYPE_ATBASE, "TRACKER_SPARQL_TOKEN_TYPE_ATBASE", "atbase"}, {TRACKER_SPARQL_TOKEN_TYPE_ATPREFIX, "TRACKER_SPARQL_TOKEN_TYPE_ATPREFIX", "atprefix"}, {TRACKER_SPARQL_TOKEN_TYPE_AVG, "TRACKER_SPARQL_TOKEN_TYPE_AVG", "avg"}, {TRACKER_SPARQL_TOKEN_TYPE_BASE, "TRACKER_SPARQL_TOKEN_TYPE_BASE", "base"}, {TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE, "TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE", "blank-node"}, {TRACKER_SPARQL_TOKEN_TYPE_BOUND, "TRACKER_SPARQL_TOKEN_TYPE_BOUND", "bound"}, {TRACKER_SPARQL_TOKEN_TYPE_BY, "TRACKER_SPARQL_TOKEN_TYPE_BY", "by"}, {TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE, "TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE", "close-brace"}, {TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACKET, "TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACKET", "close-bracket"}, {TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, "TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS", "close-parens"}, {TRACKER_SPARQL_TOKEN_TYPE_COALESCE, "TRACKER_SPARQL_TOKEN_TYPE_COALESCE", "coalesce"}, {TRACKER_SPARQL_TOKEN_TYPE_COLON, "TRACKER_SPARQL_TOKEN_TYPE_COLON", "colon"}, {TRACKER_SPARQL_TOKEN_TYPE_COMMA, "TRACKER_SPARQL_TOKEN_TYPE_COMMA", "comma"}, {TRACKER_SPARQL_TOKEN_TYPE_CONSTRUCT, "TRACKER_SPARQL_TOKEN_TYPE_CONSTRUCT", "construct"}, {TRACKER_SPARQL_TOKEN_TYPE_COUNT, "TRACKER_SPARQL_TOKEN_TYPE_COUNT", "count"}, {TRACKER_SPARQL_TOKEN_TYPE_DATA, "TRACKER_SPARQL_TOKEN_TYPE_DATA", "data"}, {TRACKER_SPARQL_TOKEN_TYPE_DATATYPE, "TRACKER_SPARQL_TOKEN_TYPE_DATATYPE", "datatype"}, {TRACKER_SPARQL_TOKEN_TYPE_DECIMAL, "TRACKER_SPARQL_TOKEN_TYPE_DECIMAL", "decimal"}, {TRACKER_SPARQL_TOKEN_TYPE_DELETE, "TRACKER_SPARQL_TOKEN_TYPE_DELETE", "delete"}, {TRACKER_SPARQL_TOKEN_TYPE_DESC, "TRACKER_SPARQL_TOKEN_TYPE_DESC", "desc"}, {TRACKER_SPARQL_TOKEN_TYPE_DESCRIBE, "TRACKER_SPARQL_TOKEN_TYPE_DESCRIBE", "describe"}, {TRACKER_SPARQL_TOKEN_TYPE_DISTINCT, "TRACKER_SPARQL_TOKEN_TYPE_DISTINCT", "distinct"}, {TRACKER_SPARQL_TOKEN_TYPE_DIV, "TRACKER_SPARQL_TOKEN_TYPE_DIV", "div"}, {TRACKER_SPARQL_TOKEN_TYPE_DOT, "TRACKER_SPARQL_TOKEN_TYPE_DOT", "dot"}, {TRACKER_SPARQL_TOKEN_TYPE_DOUBLE, "TRACKER_SPARQL_TOKEN_TYPE_DOUBLE", "double"}, {TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX, "TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX", "double-circumflex"}, {TRACKER_SPARQL_TOKEN_TYPE_DROP, "TRACKER_SPARQL_TOKEN_TYPE_DROP", "drop"}, {TRACKER_SPARQL_TOKEN_TYPE_EOF, "TRACKER_SPARQL_TOKEN_TYPE_EOF", "eof"}, {TRACKER_SPARQL_TOKEN_TYPE_EXISTS, "TRACKER_SPARQL_TOKEN_TYPE_EXISTS", "exists"}, {TRACKER_SPARQL_TOKEN_TYPE_FALSE, "TRACKER_SPARQL_TOKEN_TYPE_FALSE", "false"}, {TRACKER_SPARQL_TOKEN_TYPE_FILTER, "TRACKER_SPARQL_TOKEN_TYPE_FILTER", "filter"}, {TRACKER_SPARQL_TOKEN_TYPE_FROM, "TRACKER_SPARQL_TOKEN_TYPE_FROM", "from"}, {TRACKER_SPARQL_TOKEN_TYPE_GRAPH, "TRACKER_SPARQL_TOKEN_TYPE_GRAPH", "graph"}, {TRACKER_SPARQL_TOKEN_TYPE_GROUP, "TRACKER_SPARQL_TOKEN_TYPE_GROUP", "group"}, {TRACKER_SPARQL_TOKEN_TYPE_GROUP_CONCAT, "TRACKER_SPARQL_TOKEN_TYPE_GROUP_CONCAT", "group-concat"}, {TRACKER_SPARQL_TOKEN_TYPE_HAVING, "TRACKER_SPARQL_TOKEN_TYPE_HAVING", "having"}, {TRACKER_SPARQL_TOKEN_TYPE_IF, "TRACKER_SPARQL_TOKEN_TYPE_IF", "if"}, {TRACKER_SPARQL_TOKEN_TYPE_INSERT, "TRACKER_SPARQL_TOKEN_TYPE_INSERT", "insert"}, {TRACKER_SPARQL_TOKEN_TYPE_INTEGER, "TRACKER_SPARQL_TOKEN_TYPE_INTEGER", "integer"}, {TRACKER_SPARQL_TOKEN_TYPE_INTO, "TRACKER_SPARQL_TOKEN_TYPE_INTO", "into"}, {TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, "TRACKER_SPARQL_TOKEN_TYPE_IRI_REF", "iri-ref"}, {TRACKER_SPARQL_TOKEN_TYPE_ISBLANK, "TRACKER_SPARQL_TOKEN_TYPE_ISBLANK", "isblank"}, {TRACKER_SPARQL_TOKEN_TYPE_ISIRI, "TRACKER_SPARQL_TOKEN_TYPE_ISIRI", "isiri"}, {TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL, "TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL", "isliteral"}, {TRACKER_SPARQL_TOKEN_TYPE_ISURI, "TRACKER_SPARQL_TOKEN_TYPE_ISURI", "isuri"}, {TRACKER_SPARQL_TOKEN_TYPE_LANG, "TRACKER_SPARQL_TOKEN_TYPE_LANG", "lang"}, {TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES, "TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES", "langmatches"}, {TRACKER_SPARQL_TOKEN_TYPE_LIMIT, "TRACKER_SPARQL_TOKEN_TYPE_LIMIT", "limit"}, {TRACKER_SPARQL_TOKEN_TYPE_MAX, "TRACKER_SPARQL_TOKEN_TYPE_MAX", "max"}, {TRACKER_SPARQL_TOKEN_TYPE_MIN, "TRACKER_SPARQL_TOKEN_TYPE_MIN", "min"}, {TRACKER_SPARQL_TOKEN_TYPE_MINUS, "TRACKER_SPARQL_TOKEN_TYPE_MINUS", "minus"}, {TRACKER_SPARQL_TOKEN_TYPE_NAMED, "TRACKER_SPARQL_TOKEN_TYPE_NAMED", "named"}, {TRACKER_SPARQL_TOKEN_TYPE_NOT, "TRACKER_SPARQL_TOKEN_TYPE_NOT", "not"}, {TRACKER_SPARQL_TOKEN_TYPE_NULL, "TRACKER_SPARQL_TOKEN_TYPE_NULL", "null"}, {TRACKER_SPARQL_TOKEN_TYPE_OFFSET, "TRACKER_SPARQL_TOKEN_TYPE_OFFSET", "offset"}, {TRACKER_SPARQL_TOKEN_TYPE_OP_AND, "TRACKER_SPARQL_TOKEN_TYPE_OP_AND", "op-and"}, {TRACKER_SPARQL_TOKEN_TYPE_OP_EQ, "TRACKER_SPARQL_TOKEN_TYPE_OP_EQ", "op-eq"}, {TRACKER_SPARQL_TOKEN_TYPE_OP_GE, "TRACKER_SPARQL_TOKEN_TYPE_OP_GE", "op-ge"}, {TRACKER_SPARQL_TOKEN_TYPE_OP_GT, "TRACKER_SPARQL_TOKEN_TYPE_OP_GT", "op-gt"}, {TRACKER_SPARQL_TOKEN_TYPE_OP_LE, "TRACKER_SPARQL_TOKEN_TYPE_OP_LE", "op-le"}, {TRACKER_SPARQL_TOKEN_TYPE_OP_LT, "TRACKER_SPARQL_TOKEN_TYPE_OP_LT", "op-lt"}, {TRACKER_SPARQL_TOKEN_TYPE_OP_NE, "TRACKER_SPARQL_TOKEN_TYPE_OP_NE", "op-ne"}, {TRACKER_SPARQL_TOKEN_TYPE_OP_NEG, "TRACKER_SPARQL_TOKEN_TYPE_OP_NEG", "op-neg"}, {TRACKER_SPARQL_TOKEN_TYPE_OP_OR, "TRACKER_SPARQL_TOKEN_TYPE_OP_OR", "op-or"}, {TRACKER_SPARQL_TOKEN_TYPE_OP_IN, "TRACKER_SPARQL_TOKEN_TYPE_OP_IN", "op-in"}, {TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE, "TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE", "open-brace"}, {TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET, "TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET", "open-bracket"}, {TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, "TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS", "open-parens"}, {TRACKER_SPARQL_TOKEN_TYPE_OPTIONAL, "TRACKER_SPARQL_TOKEN_TYPE_OPTIONAL", "optional"}, {TRACKER_SPARQL_TOKEN_TYPE_OR, "TRACKER_SPARQL_TOKEN_TYPE_OR", "or"}, {TRACKER_SPARQL_TOKEN_TYPE_ORDER, "TRACKER_SPARQL_TOKEN_TYPE_ORDER", "order"}, {TRACKER_SPARQL_TOKEN_TYPE_PLUS, "TRACKER_SPARQL_TOKEN_TYPE_PLUS", "plus"}, {TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, "TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX", "pn-prefix"}, {TRACKER_SPARQL_TOKEN_TYPE_PREFIX, "TRACKER_SPARQL_TOKEN_TYPE_PREFIX", "prefix"}, {TRACKER_SPARQL_TOKEN_TYPE_REDUCED, "TRACKER_SPARQL_TOKEN_TYPE_REDUCED", "reduced"}, {TRACKER_SPARQL_TOKEN_TYPE_REGEX, "TRACKER_SPARQL_TOKEN_TYPE_REGEX", "regex"}, {TRACKER_SPARQL_TOKEN_TYPE_REPLACE, "TRACKER_SPARQL_TOKEN_TYPE_REPLACE", "replace"}, {TRACKER_SPARQL_TOKEN_TYPE_SAMETERM, "TRACKER_SPARQL_TOKEN_TYPE_SAMETERM", "sameterm"}, {TRACKER_SPARQL_TOKEN_TYPE_SELECT, "TRACKER_SPARQL_TOKEN_TYPE_SELECT", "select"}, {TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON, "TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON", "semicolon"}, {TRACKER_SPARQL_TOKEN_TYPE_SILENT, "TRACKER_SPARQL_TOKEN_TYPE_SILENT", "silent"}, {TRACKER_SPARQL_TOKEN_TYPE_STAR, "TRACKER_SPARQL_TOKEN_TYPE_STAR", "star"}, {TRACKER_SPARQL_TOKEN_TYPE_STR, "TRACKER_SPARQL_TOKEN_TYPE_STR", "str"}, {TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1, "TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1", "string-literal1"}, {TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2, "TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2", "string-literal2"}, {TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1, "TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1", "string-literal-long1"}, {TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2, "TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2", "string-literal-long2"}, {TRACKER_SPARQL_TOKEN_TYPE_SUM, "TRACKER_SPARQL_TOKEN_TYPE_SUM", "sum"}, {TRACKER_SPARQL_TOKEN_TYPE_TRUE, "TRACKER_SPARQL_TOKEN_TYPE_TRUE", "true"}, {TRACKER_SPARQL_TOKEN_TYPE_UNION, "TRACKER_SPARQL_TOKEN_TYPE_UNION", "union"}, {TRACKER_SPARQL_TOKEN_TYPE_VAR, "TRACKER_SPARQL_TOKEN_TYPE_VAR", "var"}, {TRACKER_SPARQL_TOKEN_TYPE_WHERE, "TRACKER_SPARQL_TOKEN_TYPE_WHERE", "where"}, {TRACKER_SPARQL_TOKEN_TYPE_WITH, "TRACKER_SPARQL_TOKEN_TYPE_WITH", "with"}, {0, NULL, NULL}};
		GType tracker_sparql_token_type_type_id;
		tracker_sparql_token_type_type_id = g_enum_register_static ("TrackerSparqlTokenType", values);
		g_once_init_leave (&tracker_sparql_token_type_type_id__volatile, tracker_sparql_token_type_type_id);
	}
	return tracker_sparql_token_type_type_id__volatile;
}



