/* tracker-result-store.c generated by valac 0.14.1, the Vala compiler
 * generated from tracker-result-store.vala, do not modify */

/**/
/* Copyright 2010, Carlos Garnacho <carlos@lanedo.com>*/
/**/
/* This program is free software; you can redistribute it and/or*/
/* modify it under the terms of the GNU General Public License*/
/* as published by the Free Software Foundation; either version 2*/
/* of the License, or (at your option) any later version.*/
/**/
/* This program is distributed in the hope that it will be useful,*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/* GNU General Public License for more details.*/
/**/
/* You should have received a copy of the GNU General Public License*/
/* along with this program; if not, write to the Free Software*/
/* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA*/
/* 02110-1301, USA.*/
/**/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <libtracker-sparql/tracker-sparql.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <gdk/gdk.h>
#include <stdarg.h>
#include <gobject/gvaluecollector.h>


#define TRACKER_TYPE_RESULT_STORE (tracker_result_store_get_type ())
#define TRACKER_RESULT_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_RESULT_STORE, TrackerResultStore))
#define TRACKER_RESULT_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_RESULT_STORE, TrackerResultStoreClass))
#define TRACKER_IS_RESULT_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_RESULT_STORE))
#define TRACKER_IS_RESULT_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_RESULT_STORE))
#define TRACKER_RESULT_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_RESULT_STORE, TrackerResultStoreClass))

typedef struct _TrackerResultStore TrackerResultStore;
typedef struct _TrackerResultStoreClass TrackerResultStoreClass;
typedef struct _TrackerResultStorePrivate TrackerResultStorePrivate;

#define TRACKER_RESULT_STORE_TYPE_QUERY_DATA (tracker_result_store_query_data_get_type ())

#define TRACKER_QUERY_TYPE_TYPE (tracker_query_type_get_type ())

#define TRACKER_QUERY_TYPE_MATCH (tracker_query_match_get_type ())
typedef struct _TrackerResultStoreQueryData TrackerResultStoreQueryData;

#define TRACKER_RESULT_STORE_TYPE_CATEGORY_NODE (tracker_result_store_category_node_get_type ())
#define TRACKER_RESULT_STORE_CATEGORY_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_RESULT_STORE_TYPE_CATEGORY_NODE, TrackerResultStoreCategoryNode))
#define TRACKER_RESULT_STORE_CATEGORY_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_RESULT_STORE_TYPE_CATEGORY_NODE, TrackerResultStoreCategoryNodeClass))
#define TRACKER_RESULT_STORE_IS_CATEGORY_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_RESULT_STORE_TYPE_CATEGORY_NODE))
#define TRACKER_RESULT_STORE_IS_CATEGORY_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_RESULT_STORE_TYPE_CATEGORY_NODE))
#define TRACKER_RESULT_STORE_CATEGORY_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_RESULT_STORE_TYPE_CATEGORY_NODE, TrackerResultStoreCategoryNodeClass))

typedef struct _TrackerResultStoreCategoryNode TrackerResultStoreCategoryNode;
typedef struct _TrackerResultStoreCategoryNodeClass TrackerResultStoreCategoryNodeClass;

#define TRACKER_RESULT_STORE_TYPE_OPERATION (tracker_result_store_operation_get_type ())
#define TRACKER_RESULT_STORE_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_RESULT_STORE_TYPE_OPERATION, TrackerResultStoreOperation))
#define TRACKER_RESULT_STORE_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_RESULT_STORE_TYPE_OPERATION, TrackerResultStoreOperationClass))
#define TRACKER_RESULT_STORE_IS_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_RESULT_STORE_TYPE_OPERATION))
#define TRACKER_RESULT_STORE_IS_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_RESULT_STORE_TYPE_OPERATION))
#define TRACKER_RESULT_STORE_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_RESULT_STORE_TYPE_OPERATION, TrackerResultStoreOperationClass))

typedef struct _TrackerResultStoreOperation TrackerResultStoreOperation;
typedef struct _TrackerResultStoreOperationClass TrackerResultStoreOperationClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _TrackerResultStoreOperationPrivate TrackerResultStoreOperationPrivate;

#define TRACKER_TYPE_QUERY (tracker_query_get_type ())
#define TRACKER_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_QUERY, TrackerQuery))
#define TRACKER_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_QUERY, TrackerQueryClass))
#define TRACKER_IS_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_QUERY))
#define TRACKER_IS_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_QUERY))
#define TRACKER_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_QUERY, TrackerQueryClass))

typedef struct _TrackerQuery TrackerQuery;
typedef struct _TrackerQueryClass TrackerQueryClass;
#define _tracker_query_unref0(var) ((var == NULL) ? NULL : (var = (tracker_query_unref (var), NULL)))
typedef struct _TrackerResultStoreCategoryNodePrivate TrackerResultStoreCategoryNodePrivate;

#define TRACKER_RESULT_STORE_TYPE_RESULT_NODE (tracker_result_store_result_node_get_type ())
typedef struct _TrackerResultStoreResultNode TrackerResultStoreResultNode;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))
typedef struct _TrackerResultStoreLoadOperationData TrackerResultStoreLoadOperationData;
#define _tracker_result_store_category_node_unref0(var) ((var == NULL) ? NULL : (var = (tracker_result_store_category_node_unref (var), NULL)))
typedef struct _TrackerResultStoreLoadCategoryData TrackerResultStoreLoadCategoryData;
#define _gtk_icon_info_free0(var) ((var == NULL) ? NULL : (var = (gtk_icon_info_free (var), NULL)))
typedef struct _TrackerResultStoreFetchThumbnailData TrackerResultStoreFetchThumbnailData;
typedef struct _TrackerResultStoreParamSpecCategoryNode TrackerResultStoreParamSpecCategoryNode;

struct _TrackerResultStore {
	GObject parent_instance;
	TrackerResultStorePrivate * priv;
};

struct _TrackerResultStoreClass {
	GObjectClass parent_class;
};

typedef enum  {
	TRACKER_QUERY_TYPE_ALL,
	TRACKER_QUERY_TYPE_CONTACTS,
	TRACKER_QUERY_TYPE_APPLICATIONS,
	TRACKER_QUERY_TYPE_MUSIC,
	TRACKER_QUERY_TYPE_IMAGES,
	TRACKER_QUERY_TYPE_VIDEOS,
	TRACKER_QUERY_TYPE_DOCUMENTS,
	TRACKER_QUERY_TYPE_MAIL,
	TRACKER_QUERY_TYPE_CALENDAR,
	TRACKER_QUERY_TYPE_FOLDERS,
	TRACKER_QUERY_TYPE_BOOKMARKS
} TrackerQueryType;

typedef enum  {
	TRACKER_QUERY_MATCH_NONE,
	TRACKER_QUERY_MATCH_FTS,
	TRACKER_QUERY_MATCH_FTS_INDIRECT,
	TRACKER_QUERY_MATCH_TITLES,
	TRACKER_QUERY_MATCH_TITLES_INDIRECT
} TrackerQueryMatch;

struct _TrackerResultStoreQueryData {
	TrackerQueryType type;
	TrackerQueryMatch match;
	gchar** args;
	gint args_length1;
	gint _args_size_;
};

struct _TrackerResultStorePrivate {
	GCancellable* cancellable;
	TrackerResultStoreQueryData* queries;
	gint queries_length1;
	gint _queries_size_;
	GPtrArray* categories;
	GPtrArray* running_operations;
	GPtrArray* delayed_operations;
	gint n_extra_columns;
	gint n_columns;
	gint timestamp;
	gint _icon_size;
	gchar* _search_term;
	gboolean _active;
};

struct _TrackerResultStoreOperation {
	GObject parent_instance;
	TrackerResultStoreOperationPrivate * priv;
	TrackerResultStoreCategoryNode* node;
	gint offset;
};

struct _TrackerResultStoreOperationClass {
	GObjectClass parent_class;
};

struct _TrackerResultStoreResultNode {
	gchar** values;
	gint values_length1;
	gint _values_size_;
	GdkPixbuf* pixbuf;
};

struct _TrackerResultStoreCategoryNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TrackerResultStoreCategoryNodePrivate * priv;
	TrackerQueryType type;
	TrackerResultStoreQueryData* query;
	TrackerResultStoreResultNode* results;
	gint results_length1;
	gint _results_size_;
	GdkPixbuf* pixbuf;
	gint count;
};

struct _TrackerResultStoreCategoryNodeClass {
	GTypeClass parent_class;
	void (*finalize) (TrackerResultStoreCategoryNode *self);
};

struct _TrackerResultStoreLoadOperationData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerResultStore* self;
	TrackerResultStoreOperation* op;
	GCancellable* cancellable;
	TrackerQuery* query;
	TrackerSparqlCursor* cursor;
	gint i;
	GCancellable* _tmp0_;
	TrackerQuery* _tmp1_;
	TrackerQuery* _tmp2_;
	const gchar* _tmp3_;
	TrackerQuery* _tmp4_;
	TrackerQuery* _tmp5_;
	TrackerResultStoreOperation* _tmp6_;
	gint _tmp7_;
	TrackerQuery* _tmp8_;
	TrackerResultStoreOperation* _tmp9_;
	TrackerResultStoreCategoryNode* _tmp10_;
	TrackerResultStoreQueryData* _tmp11_;
	TrackerQueryType _tmp12_;
	TrackerResultStoreOperation* _tmp13_;
	TrackerResultStoreCategoryNode* _tmp14_;
	TrackerResultStoreQueryData* _tmp15_;
	TrackerQueryMatch _tmp16_;
	TrackerResultStoreOperation* _tmp17_;
	TrackerResultStoreCategoryNode* _tmp18_;
	TrackerResultStoreQueryData* _tmp19_;
	gchar** _tmp20_;
	gint _tmp20__length1;
	GCancellable* _tmp21_;
	TrackerSparqlCursor* _tmp22_;
	TrackerSparqlCursor* _tmp23_;
	TrackerResultStoreOperation* _tmp24_;
	gint _tmp25_;
	gboolean _tmp26_;
	gboolean _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	TrackerResultStoreOperation* _tmp30_;
	gint _tmp31_;
	TrackerResultStoreResultNode* _result_;
	GtkTreeIter iter;
	GtkTreePath* path;
	gboolean b;
	gint j;
	TrackerSparqlCursor* _tmp32_;
	GCancellable* _tmp33_;
	gboolean _tmp34_;
	gboolean _tmp35_;
	GError* ge;
	GError* _tmp36_;
	const gchar* _tmp37_;
	gboolean _tmp38_;
	TrackerResultStoreOperation* _tmp39_;
	TrackerResultStoreCategoryNode* _tmp40_;
	TrackerResultStoreResultNode* _tmp41_;
	gint _tmp41__length1;
	gint _tmp42_;
	gboolean _tmp43_;
	gboolean _tmp44_;
	gint _tmp45_;
	gint _tmp46_;
	gint _tmp47_;
	gint _tmp48_;
	gint _tmp49_;
	TrackerSparqlCursor* _tmp50_;
	gint _tmp51_;
	const gchar* _tmp52_;
	gchar* _tmp53_;
	gchar* s;
	const gchar* _tmp54_;
	TrackerResultStoreResultNode* _tmp55_;
	gchar** _tmp56_;
	gint _tmp56__length1;
	gint _tmp57_;
	const gchar* _tmp58_;
	gchar* _tmp59_;
	gchar* _tmp60_;
	TrackerResultStoreResultNode* _tmp61_;
	gchar** _tmp62_;
	gint _tmp62__length1;
	gint _tmp63_;
	gchar* _tmp64_;
	TrackerResultStoreResultNode* _tmp65_;
	gchar** _tmp66_;
	gint _tmp66__length1;
	gint _tmp67_;
	TrackerSparqlCursor* _tmp68_;
	gint _tmp69_;
	const gchar* _tmp70_;
	gchar* _tmp71_;
	gchar* _tmp72_;
	GtkTreeIter _tmp73_;
	gint _tmp74_;
	TrackerResultStoreOperation* _tmp75_;
	TrackerResultStoreCategoryNode* _tmp76_;
	TrackerResultStoreResultNode* _tmp77_;
	gint _tmp78_;
	void* _tmp79_;
	GtkTreeIter _tmp80_;
	GtkTreePath* _tmp81_;
	GtkTreePath* _tmp82_;
	GtkTreeIter _tmp83_;
	GPtrArray* _tmp84_;
	TrackerResultStoreOperation* _tmp85_;
	GError* ie;
	GError* _tmp86_;
	const gchar* _tmp87_;
	GPtrArray* _tmp88_;
	gint _tmp89_;
	gint _tmp90_;
	TrackerResultStoreOperation* next_to_start;
	GPtrArray* _tmp91_;
	GPtrArray* _tmp92_;
	gint _tmp93_;
	gint _tmp94_;
	gconstpointer _tmp95_;
	TrackerResultStoreOperation* _tmp96_;
	GPtrArray* _tmp97_;
	TrackerResultStoreOperation* _tmp98_;
	GPtrArray* _tmp99_;
	TrackerResultStoreOperation* _tmp100_;
	TrackerResultStoreOperation* _tmp101_;
	TrackerResultStoreOperation* _tmp102_;
	GCancellable* _tmp103_;
	GPtrArray* _tmp104_;
	gint _tmp105_;
	gint _tmp106_;
	GError * _inner_error_;
};

struct _TrackerResultStoreLoadCategoryData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerResultStore* self;
	TrackerResultStoreQueryData* query_data;
	GCancellable* cancellable;
	guint count;
	GCancellable* _tmp0_;
	TrackerQuery* _tmp1_;
	TrackerQuery* query;
	TrackerQuery* _tmp2_;
	const gchar* _tmp3_;
	TrackerQuery* _tmp4_;
	TrackerResultStoreQueryData* _tmp5_;
	TrackerQueryType _tmp6_;
	TrackerResultStoreQueryData* _tmp7_;
	TrackerQueryMatch _tmp8_;
	GCancellable* _tmp9_;
	guint _tmp10_;
	guint _tmp11_;
	GError* ie;
	GError* _tmp12_;
	const gchar* _tmp13_;
	guint _tmp14_;
	TrackerResultStoreCategoryNode* cat;
	TrackerResultStoreResultNode* res;
	gint i;
	GtkTreeIter iter;
	GtkTreePath* path;
	TrackerResultStoreCategoryNode* _tmp15_;
	TrackerResultStoreCategoryNode* _tmp16_;
	TrackerResultStoreQueryData* _tmp17_;
	TrackerQueryType _tmp18_;
	TrackerResultStoreCategoryNode* _tmp19_;
	TrackerResultStoreQueryData* _tmp20_;
	TrackerResultStoreCategoryNode* _tmp21_;
	guint _tmp22_;
	gint _tmp23_;
	GPtrArray* _tmp24_;
	TrackerResultStoreCategoryNode* _tmp25_;
	TrackerResultStoreCategoryNode* _tmp26_;
	GtkTreeIter _tmp27_;
	gint _tmp28_;
	TrackerResultStoreCategoryNode* _tmp29_;
	TrackerResultStoreQueryData* _tmp30_;
	gint _tmp30__length1;
	GtkTreeIter _tmp31_;
	GtkTreePath* _tmp32_;
	GtkTreePath* _tmp33_;
	GtkTreeIter _tmp34_;
	gboolean _tmp35_;
	gboolean _tmp36_;
	gint _tmp37_;
	gint _tmp38_;
	guint _tmp39_;
	TrackerResultStoreCategoryNode* _tmp40_;
	TrackerResultStoreResultNode* _tmp41_;
	gint _tmp41__length1;
	gint _tmp42_;
	TrackerResultStoreResultNode* _tmp43_;
	gint _tmp44_;
	gchar** _tmp45_;
	TrackerResultStoreResultNode* _tmp46_;
	gint _tmp47_;
	void* _tmp48_;
	GtkTreeIter _tmp49_;
	GtkTreePath* _tmp50_;
	TrackerResultStoreCategoryNode* _tmp51_;
	gint _tmp52_;
	GtkTreePath* _tmp53_;
	GtkTreeIter _tmp54_;
	TrackerResultStoreQueryData* _tmp55_;
	gint _tmp55__length1;
	GtkTreeIter _tmp56_;
	GtkTreePath* _tmp57_;
	GtkTreePath* _tmp58_;
	GtkTreeIter _tmp59_;
	GPtrArray* _tmp60_;
	gint _tmp61_;
	gint _tmp62_;
	GError * _inner_error_;
};

struct _TrackerResultStoreFetchThumbnailData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerResultStore* self;
	GtkTreeIter iter;
	GFile* file;
	GFileInfo* info;
	TrackerResultStoreResultNode* _result_;
	gchar* thumb_path;
	GdkPixbuf* pixbuf;
	GtkTreeIter _tmp0_;
	void* _tmp1_;
	TrackerResultStoreResultNode* _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	const gchar* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	GCancellable* _tmp7_;
	GFileInfo* _tmp8_;
	GFileInfo* _tmp9_;
	GError* ie;
	GError* _tmp10_;
	const gchar* _tmp11_;
	GFileInfo* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	GdkPixbuf* _tmp19_;
	GdkPixbuf* _tmp20_;
	GIcon* icon;
	GtkIconInfo* icon_info;
	GFileInfo* _tmp21_;
	GObject* _tmp22_;
	GIcon* _tmp23_;
	GIcon* _tmp24_;
	GdkScreen* _tmp25_;
	GtkIconTheme* _tmp26_;
	GtkIconTheme* _tmp27_;
	GtkIconTheme* theme;
	GtkIconTheme* _tmp28_;
	GIcon* _tmp29_;
	gint _tmp30_;
	GtkIconInfo* _tmp31_;
	GtkIconInfo* _tmp32_;
	GtkIconInfo* _tmp33_;
	GdkPixbuf* _tmp34_;
	GdkPixbuf* _tmp35_;
	GError* e;
	GError* _tmp36_;
	const gchar* _tmp37_;
	GdkPixbuf* _tmp38_;
	GtkTreePath* path;
	TrackerResultStoreResultNode* _tmp39_;
	GdkPixbuf* _tmp40_;
	GdkPixbuf* _tmp41_;
	GtkTreeIter _tmp42_;
	GtkTreePath* _tmp43_;
	GtkTreePath* _tmp44_;
	GtkTreeIter _tmp45_;
	GError * _inner_error_;
};

struct _TrackerResultStoreParamSpecCategoryNode {
	GParamSpec parent_instance;
};


static gpointer tracker_result_store_parent_class = NULL;
static gpointer tracker_result_store_category_node_parent_class = NULL;
static gpointer tracker_result_store_operation_parent_class = NULL;
static GtkTreeModelIface* tracker_result_store_gtk_tree_model_parent_iface = NULL;

GType tracker_result_store_get_type (void) G_GNUC_CONST;
static GType tracker_result_store_query_data_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
GType tracker_query_type_get_type (void) G_GNUC_CONST;
GType tracker_query_match_get_type (void) G_GNUC_CONST;
static TrackerResultStoreQueryData* tracker_result_store_query_data_dup (const TrackerResultStoreQueryData* self);
static void tracker_result_store_query_data_free (TrackerResultStoreQueryData* self);
static void tracker_result_store_query_data_copy (const TrackerResultStoreQueryData* self, TrackerResultStoreQueryData* dest);
static void tracker_result_store_query_data_destroy (TrackerResultStoreQueryData* self);
static gpointer tracker_result_store_category_node_ref (gpointer instance);
static void tracker_result_store_category_node_unref (gpointer instance);
static GParamSpec* tracker_result_store_param_spec_category_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void tracker_result_store_value_set_category_node (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void tracker_result_store_value_take_category_node (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer tracker_result_store_value_get_category_node (const GValue* value) G_GNUC_UNUSED;
static GType tracker_result_store_category_node_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GType tracker_result_store_operation_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define TRACKER_RESULT_STORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_TYPE_RESULT_STORE, TrackerResultStorePrivate))
enum  {
	TRACKER_RESULT_STORE_DUMMY_PROPERTY,
	TRACKER_RESULT_STORE_ICON_SIZE,
	TRACKER_RESULT_STORE_SEARCH_TERM,
	TRACKER_RESULT_STORE_ACTIVE
};
static void _vala_TrackerResultStoreQueryData_array_free (TrackerResultStoreQueryData* array, gint array_length);
static TrackerResultStoreOperation* tracker_result_store_find_operation (TrackerResultStore* self, GPtrArray* array, TrackerResultStoreCategoryNode* node, gint offset);
static void tracker_result_store_load_operation_data_free (gpointer _data);
static void tracker_result_store_load_operation (TrackerResultStore* self, TrackerResultStoreOperation* op, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void tracker_result_store_load_operation_finish (TrackerResultStore* self, GAsyncResult* _res_);
static gboolean tracker_result_store_load_operation_co (TrackerResultStoreLoadOperationData* _data_);
gpointer tracker_query_ref (gpointer instance);
void tracker_query_unref (gpointer instance);
GParamSpec* tracker_param_spec_query (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void tracker_value_set_query (GValue* value, gpointer v_object);
void tracker_value_take_query (GValue* value, gpointer v_object);
gpointer tracker_value_get_query (const GValue* value);
GType tracker_query_get_type (void) G_GNUC_CONST;
TrackerQuery* tracker_query_new (void);
TrackerQuery* tracker_query_construct (GType object_type);
void tracker_query_set_criteria (TrackerQuery* self, const gchar* value);
void tracker_query_set_limit (TrackerQuery* self, guint value);
void tracker_query_set_offset (TrackerQuery* self, guint value);
void tracker_query_perform_async (TrackerQuery* self, TrackerQueryType query_type, TrackerQueryMatch match_type, gchar** args, int args_length1, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
TrackerSparqlCursor* tracker_query_perform_finish (TrackerQuery* self, GAsyncResult* _res_, GError** error);
static GType tracker_result_store_result_node_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static TrackerResultStoreResultNode* tracker_result_store_result_node_dup (const TrackerResultStoreResultNode* self);
static void tracker_result_store_result_node_free (TrackerResultStoreResultNode* self);
static void tracker_result_store_result_node_copy (const TrackerResultStoreResultNode* self, TrackerResultStoreResultNode* dest);
static void tracker_result_store_result_node_destroy (TrackerResultStoreResultNode* self);
static void tracker_result_store_load_operation_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tracker_result_store_set_active (TrackerResultStore* self, gboolean value);
static void tracker_result_store_add_operation (TrackerResultStore* self, TrackerResultStoreCategoryNode* cat, gint offset);
static TrackerResultStoreOperation* tracker_result_store_operation_new (void);
static TrackerResultStoreOperation* tracker_result_store_operation_construct (GType object_type);
static void tracker_result_store_load_category_data_free (gpointer _data);
static void tracker_result_store_load_category (TrackerResultStore* self, TrackerResultStoreQueryData* query_data, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void tracker_result_store_load_category_finish (TrackerResultStore* self, GAsyncResult* _res_);
static gboolean tracker_result_store_load_category_co (TrackerResultStoreLoadCategoryData* _data_);
void tracker_query_get_count_async (TrackerQuery* self, TrackerQueryType query_type, TrackerQueryMatch match_type, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
guint tracker_query_get_count_finish (TrackerQuery* self, GAsyncResult* _res_, GError** error);
static void tracker_result_store_load_category_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static TrackerResultStoreCategoryNode* tracker_result_store_category_node_new (void);
static TrackerResultStoreCategoryNode* tracker_result_store_category_node_construct (GType object_type);
static void tracker_result_store_clear_results (TrackerResultStore* self);
static gint tracker_result_store_find_nth_category_index (TrackerResultStore* self, TrackerResultStoreCategoryNode* node, gint n);
static gint tracker_result_store_filled_categories_count (TrackerResultStore* self);
static GType tracker_result_store_real_get_column_type (GtkTreeModel* base, gint index_);
static GtkTreeModelFlags tracker_result_store_real_get_flags (GtkTreeModel* base);
static gboolean tracker_result_store_real_get_iter (GtkTreeModel* base, GtkTreeIter* iter, GtkTreePath* path);
static gint tracker_result_store_real_get_n_columns (GtkTreeModel* base);
static GtkTreePath* tracker_result_store_real_get_path (GtkTreeModel* base, GtkTreeIter* iter);
static void tracker_result_store_fetch_thumbnail_data_free (gpointer _data);
static void tracker_result_store_fetch_thumbnail (TrackerResultStore* self, GtkTreeIter* iter, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void tracker_result_store_fetch_thumbnail_finish (TrackerResultStore* self, GAsyncResult* _res_);
static gboolean tracker_result_store_fetch_thumbnail_co (TrackerResultStoreFetchThumbnailData* _data_);
static void tracker_result_store_fetch_thumbnail_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gint tracker_result_store_get_icon_size (TrackerResultStore* self);
static void tracker_result_store_real_get_value (GtkTreeModel* base, GtkTreeIter* iter, gint column, GValue* value);
GdkPixbuf* tracker_pixbuf_new_from_name (GtkIconTheme* theme, const gchar* name, gint size);
static gboolean tracker_result_store_real_iter_children (GtkTreeModel* base, GtkTreeIter* iter, GtkTreeIter* parent);
static gboolean tracker_result_store_real_iter_has_child (GtkTreeModel* base, GtkTreeIter* iter);
static gint tracker_result_store_real_iter_n_children (GtkTreeModel* base, GtkTreeIter* iter);
static gboolean tracker_result_store_real_iter_next (GtkTreeModel* base, GtkTreeIter* iter);
static gboolean tracker_result_store_real_iter_nth_child (GtkTreeModel* base, GtkTreeIter* iter, GtkTreeIter* parent, gint n);
static gboolean tracker_result_store_real_iter_parent (GtkTreeModel* base, GtkTreeIter* iter, GtkTreeIter* child);
static void tracker_result_store_real_ref_node (GtkTreeModel* base, GtkTreeIter* iter);
static void tracker_result_store_real_unref_node (GtkTreeModel* base, GtkTreeIter* iter);
static void tracker_result_store_theme_changed (TrackerResultStore* self, GtkIconTheme* theme);
TrackerResultStore* tracker_result_store_new (gint _n_columns);
TrackerResultStore* tracker_result_store_construct (GType object_type, gint _n_columns);
static void _tracker_result_store_category_node_unref0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
void tracker_result_store_set_icon_size (TrackerResultStore* self, gint value);
static void _tracker_result_store_theme_changed_gtk_icon_theme_changed (GtkIconTheme* _sender, gpointer self);
void tracker_result_store_add_query (TrackerResultStore* self, TrackerQueryType type, TrackerQueryMatch match, ...);
static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value);
static gchar** _vala_array_dup3 (gchar** self, int length);
static void _vala_array_add3 (TrackerResultStoreQueryData** array, int* length, int* size, const TrackerResultStoreQueryData* value);
gboolean tracker_result_store_has_results (TrackerResultStore* self);
void tracker_result_store_cancel_search (TrackerResultStore* self);
const gchar* tracker_result_store_get_search_term (TrackerResultStore* self);
void tracker_result_store_set_search_term (TrackerResultStore* self, const gchar* value);
gboolean tracker_result_store_get_active (TrackerResultStore* self);
enum  {
	TRACKER_RESULT_STORE_CATEGORY_NODE_DUMMY_PROPERTY
};
static void _vala_TrackerResultStoreResultNode_array_free (TrackerResultStoreResultNode* array, gint array_length);
static void tracker_result_store_category_node_finalize (TrackerResultStoreCategoryNode* obj);
enum  {
	TRACKER_RESULT_STORE_OPERATION_DUMMY_PROPERTY
};
static void tracker_result_store_operation_finalize (GObject* obj);
static gchar** _vala_array_dup4 (gchar** self, int length);
static gchar** _vala_array_dup5 (gchar** self, int length);
static void tracker_result_store_finalize (GObject* obj);
static void _vala_tracker_result_store_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_tracker_result_store_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void _vala_TrackerResultStoreQueryData_array_free (TrackerResultStoreQueryData* array, gint array_length) {
#line 44 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	if (array != NULL) {
#line 614 "tracker-result-store.c"
		int i;
#line 44 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 44 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			tracker_result_store_query_data_destroy (&array[i]);
#line 620 "tracker-result-store.c"
		}
	}
#line 44 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	g_free (array);
#line 625 "tracker-result-store.c"
}


static gint g_ptr_array_get_length (GPtrArray* self) {
	gint result;
	guint _tmp0_;
#line 4060 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 4060 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp0_ = self->len;
#line 4060 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	result = (gint) _tmp0_;
#line 4060 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	return result;
#line 640 "tracker-result-store.c"
}


static void g_ptr_array_set_length (GPtrArray* self, gint value) {
	gint _tmp0_;
#line 4061 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	g_return_if_fail (self != NULL);
#line 4061 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp0_ = value;
#line 4061 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	g_ptr_array_set_size (self, _tmp0_);
#line 652 "tracker-result-store.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 69 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	return self ? g_object_ref (self) : NULL;
#line 659 "tracker-result-store.c"
}


static TrackerResultStoreOperation* tracker_result_store_find_operation (TrackerResultStore* self, GPtrArray* array, TrackerResultStoreCategoryNode* node, gint offset) {
	TrackerResultStoreOperation* result = NULL;
	TrackerResultStoreOperation* op = NULL;
	gint i = 0;
#line 64 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 64 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	g_return_val_if_fail (array != NULL, NULL);
#line 64 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	g_return_val_if_fail (node != NULL, NULL);
#line 673 "tracker-result-store.c"
	{
		gboolean _tmp0_;
#line 68 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		i = 0;
#line 68 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp0_ = TRUE;
#line 68 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		while (TRUE) {
#line 682 "tracker-result-store.c"
			gboolean _tmp1_;
			gint _tmp3_;
			GPtrArray* _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			GPtrArray* _tmp7_;
			gint _tmp8_;
			gconstpointer _tmp9_ = NULL;
			TrackerResultStoreOperation* _tmp10_;
			gboolean _tmp11_ = FALSE;
			TrackerResultStoreOperation* _tmp12_;
			TrackerResultStoreCategoryNode* _tmp13_;
			TrackerResultStoreCategoryNode* _tmp14_;
			gboolean _tmp18_;
#line 68 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp1_ = _tmp0_;
#line 68 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			if (!_tmp1_) {
#line 701 "tracker-result-store.c"
				gint _tmp2_;
#line 68 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tmp2_ = i;
#line 68 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				i = _tmp2_ + 1;
#line 707 "tracker-result-store.c"
			}
#line 68 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp0_ = FALSE;
#line 68 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp3_ = i;
#line 68 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp4_ = array;
#line 68 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp5_ = g_ptr_array_get_length (_tmp4_);
#line 68 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp6_ = _tmp5_;
#line 68 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			if (!(_tmp3_ < _tmp6_)) {
#line 68 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				break;
#line 723 "tracker-result-store.c"
			}
#line 69 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp7_ = array;
#line 69 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp8_ = i;
#line 69 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp9_ = g_ptr_array_index (_tmp7_, (guint) _tmp8_);
#line 69 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp10_ = _g_object_ref0 ((TrackerResultStoreOperation*) _tmp9_);
#line 69 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_g_object_unref0 (op);
#line 69 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			op = _tmp10_;
#line 71 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp12_ = op;
#line 71 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp13_ = _tmp12_->node;
#line 71 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp14_ = node;
#line 71 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			if (_tmp13_ == _tmp14_) {
#line 745 "tracker-result-store.c"
				TrackerResultStoreOperation* _tmp15_;
				gint _tmp16_;
				gint _tmp17_;
#line 72 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tmp15_ = op;
#line 72 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tmp16_ = _tmp15_->offset;
#line 72 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tmp17_ = offset;
#line 72 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tmp11_ = _tmp16_ == _tmp17_;
#line 757 "tracker-result-store.c"
			} else {
#line 71 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tmp11_ = FALSE;
#line 761 "tracker-result-store.c"
			}
#line 71 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp18_ = _tmp11_;
#line 71 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			if (_tmp18_) {
#line 73 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				result = op;
#line 73 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				return result;
#line 771 "tracker-result-store.c"
			}
		}
	}
#line 77 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	result = NULL;
#line 77 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_g_object_unref0 (op);
#line 77 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	return result;
#line 781 "tracker-result-store.c"
}


static void tracker_result_store_load_operation_data_free (gpointer _data) {
	TrackerResultStoreLoadOperationData* _data_;
	_data_ = _data;
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_g_object_unref0 (_data_->op);
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_g_object_unref0 (_data_->cancellable);
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_g_object_unref0 (_data_->self);
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	g_slice_free (TrackerResultStoreLoadOperationData, _data_);
#line 796 "tracker-result-store.c"
}


static void tracker_result_store_load_operation (TrackerResultStore* self, TrackerResultStoreOperation* op, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerResultStoreLoadOperationData* _data_;
	TrackerResultStore* _tmp0_;
	TrackerResultStoreOperation* _tmp1_;
	TrackerResultStoreOperation* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_data_ = g_slice_new0 (TrackerResultStoreLoadOperationData);
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_result_store_load_operation);
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_result_store_load_operation_data_free);
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_data_->self = _tmp0_;
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp1_ = op;
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_data_->op = _tmp2_;
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp3_ = cancellable;
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_data_->cancellable = _tmp4_;
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	tracker_result_store_load_operation_co (_data_);
#line 831 "tracker-result-store.c"
}


static void tracker_result_store_load_operation_finish (TrackerResultStore* self, GAsyncResult* _res_) {
	TrackerResultStoreLoadOperationData* _data_;
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 839 "tracker-result-store.c"
}


static void tracker_result_store_load_operation_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerResultStoreLoadOperationData* _data_;
#line 93 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_data_ = _user_data_;
#line 93 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_data_->_source_object_ = source_object;
#line 93 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_data_->_res_ = _res_;
#line 93 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	tracker_result_store_load_operation_co (_data_);
#line 853 "tracker-result-store.c"
}


static gboolean tracker_result_store_load_operation_co (TrackerResultStoreLoadOperationData* _data_) {
#line 80 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	switch (_data_->_state_) {
#line 80 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		case 0:
#line 862 "tracker-result-store.c"
		goto _state_0;
#line 80 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		case 1:
#line 866 "tracker-result-store.c"
		goto _state_1;
#line 80 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		case 2:
#line 870 "tracker-result-store.c"
		goto _state_2;
		default:
#line 80 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		g_assert_not_reached ();
#line 875 "tracker-result-store.c"
	}
	_state_0:
#line 82 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_data_->cursor = NULL;
#line 880 "tracker-result-store.c"
	{
#line 86 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp0_ = _data_->cancellable;
#line 86 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		g_cancellable_set_error_if_cancelled (_data_->_tmp0_, &_data_->_inner_error_);
#line 86 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		if (_data_->_inner_error_ != NULL) {
#line 86 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			if (_data_->_inner_error_->domain == G_IO_ERROR) {
#line 890 "tracker-result-store.c"
				goto __catch6_g_io_error;
			}
#line 86 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_g_object_unref0 (_data_->cursor);
#line 86 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tracker_query_unref0 (_data_->query);
#line 86 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 86 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			g_clear_error (&_data_->_inner_error_);
#line 86 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			return FALSE;
#line 903 "tracker-result-store.c"
		}
#line 88 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp1_ = tracker_query_new ();
#line 88 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tracker_query_unref0 (_data_->query);
#line 88 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->query = _data_->_tmp1_;
#line 89 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp2_ = _data_->query;
#line 89 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp3_ = _data_->self->priv->_search_term;
#line 89 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		tracker_query_set_criteria (_data_->_tmp2_, _data_->_tmp3_);
#line 90 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp4_ = _data_->query;
#line 90 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		tracker_query_set_limit (_data_->_tmp4_, (guint) 100);
#line 91 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp5_ = _data_->query;
#line 91 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp6_ = _data_->op;
#line 91 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp7_ = _data_->_tmp6_->offset;
#line 91 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		tracker_query_set_offset (_data_->_tmp5_, (guint) _data_->_tmp7_);
#line 93 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp8_ = _data_->query;
#line 93 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp9_ = _data_->op;
#line 93 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp10_ = _data_->_tmp9_->node;
#line 93 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp11_ = _data_->_tmp10_->query;
#line 93 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp12_ = (*_data_->_tmp11_).type;
#line 93 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp13_ = _data_->op;
#line 93 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp14_ = _data_->_tmp13_->node;
#line 93 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp15_ = _data_->_tmp14_->query;
#line 93 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp16_ = (*_data_->_tmp15_).match;
#line 93 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp17_ = _data_->op;
#line 93 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp18_ = _data_->_tmp17_->node;
#line 93 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp19_ = _data_->_tmp18_->query;
#line 93 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp20_ = (*_data_->_tmp19_).args;
#line 93 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp20__length1 = (*_data_->_tmp19_).args_length1;
#line 93 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp21_ = _data_->cancellable;
#line 93 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_state_ = 1;
#line 93 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		tracker_query_perform_async (_data_->_tmp8_, _data_->_tmp12_, _data_->_tmp16_, _data_->_tmp20_, _data_->_tmp20__length1, _data_->_tmp21_, tracker_result_store_load_operation_ready, _data_);
#line 93 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		return FALSE;
#line 965 "tracker-result-store.c"
		_state_1:
#line 93 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp22_ = NULL;
#line 93 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp22_ = tracker_query_perform_finish (_data_->_tmp8_, _data_->_res_, &_data_->_inner_error_);
#line 93 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp23_ = _data_->_tmp22_;
#line 93 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		if (_data_->_inner_error_ != NULL) {
#line 93 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			if (_data_->_inner_error_->domain == G_IO_ERROR) {
#line 977 "tracker-result-store.c"
				goto __catch6_g_io_error;
			}
#line 93 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_g_object_unref0 (_data_->cursor);
#line 93 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tracker_query_unref0 (_data_->query);
#line 93 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 93 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			g_clear_error (&_data_->_inner_error_);
#line 93 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			return FALSE;
#line 990 "tracker-result-store.c"
		}
#line 93 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_g_object_unref0 (_data_->cursor);
#line 93 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->cursor = _data_->_tmp23_;
#line 996 "tracker-result-store.c"
		{
#line 95 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_data_->_tmp24_ = _data_->op;
#line 95 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_data_->_tmp25_ = _data_->_tmp24_->offset;
#line 95 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_data_->i = _data_->_tmp25_;
#line 95 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_data_->_tmp26_ = TRUE;
#line 95 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			while (TRUE) {
#line 95 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_data_->_tmp27_ = _data_->_tmp26_;
#line 95 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				if (!_data_->_tmp27_) {
#line 95 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					_data_->_tmp28_ = _data_->i;
#line 95 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					_data_->i = _data_->_tmp28_ + 1;
#line 1016 "tracker-result-store.c"
				}
#line 95 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_data_->_tmp26_ = FALSE;
#line 95 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_data_->_tmp29_ = _data_->i;
#line 95 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_data_->_tmp30_ = _data_->op;
#line 95 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_data_->_tmp31_ = _data_->_tmp30_->offset;
#line 95 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				if (!(_data_->_tmp29_ < (_data_->_tmp31_ + 100))) {
#line 95 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					break;
#line 1030 "tracker-result-store.c"
				}
#line 99 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_data_->b = FALSE;
#line 1034 "tracker-result-store.c"
				{
#line 103 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					_data_->_tmp32_ = _data_->cursor;
#line 103 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					_data_->_tmp33_ = _data_->cancellable;
#line 103 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					_data_->_state_ = 2;
#line 103 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					tracker_sparql_cursor_next_async (_data_->_tmp32_, _data_->_tmp33_, tracker_result_store_load_operation_ready, _data_);
#line 103 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					return FALSE;
#line 1046 "tracker-result-store.c"
					_state_2:
#line 103 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					_data_->_tmp34_ = FALSE;
#line 103 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					_data_->_tmp34_ = tracker_sparql_cursor_next_finish (_data_->_tmp32_, _data_->_res_, &_data_->_inner_error_);
#line 103 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					_data_->_tmp35_ = _data_->_tmp34_;
#line 103 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					if (_data_->_inner_error_ != NULL) {
#line 1056 "tracker-result-store.c"
						goto __catch7_g_error;
					}
#line 103 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					_data_->b = _data_->_tmp35_;
#line 1061 "tracker-result-store.c"
				}
				goto __finally7;
				__catch7_g_error:
				{
#line 102 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					_data_->ge = _data_->_inner_error_;
#line 102 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					_data_->_inner_error_ = NULL;
#line 105 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					_data_->_tmp36_ = _data_->ge;
#line 105 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					_data_->_tmp37_ = _data_->_tmp36_->message;
#line 105 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					g_warning ("tracker-result-store.vala:105: Could not fetch row: %s\n", _data_->_tmp37_);
#line 102 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					_g_error_free0 (_data_->ge);
#line 1078 "tracker-result-store.c"
				}
				__finally7:
#line 102 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				if (_data_->_inner_error_ != NULL) {
#line 102 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					_gtk_tree_path_free0 (_data_->path);
#line 102 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					if (_data_->_inner_error_->domain == G_IO_ERROR) {
#line 1087 "tracker-result-store.c"
						goto __catch6_g_io_error;
					}
#line 102 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					_gtk_tree_path_free0 (_data_->path);
#line 102 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					_g_object_unref0 (_data_->cursor);
#line 102 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					_tracker_query_unref0 (_data_->query);
#line 102 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 102 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					g_clear_error (&_data_->_inner_error_);
#line 102 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					return FALSE;
#line 1102 "tracker-result-store.c"
				}
#line 108 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_data_->_tmp38_ = _data_->b;
#line 108 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				if (!_data_->_tmp38_) {
#line 109 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					_gtk_tree_path_free0 (_data_->path);
#line 109 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					break;
#line 1112 "tracker-result-store.c"
				}
#line 112 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_data_->_tmp39_ = _data_->op;
#line 112 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_data_->_tmp40_ = _data_->_tmp39_->node;
#line 112 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_data_->_tmp41_ = _data_->_tmp40_->results;
#line 112 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_data_->_tmp41__length1 = _data_->_tmp40_->results_length1;
#line 112 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_data_->_tmp42_ = _data_->i;
#line 112 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_data_->_result_ = &_data_->_tmp41_[_data_->_tmp42_];
#line 1126 "tracker-result-store.c"
				{
#line 114 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					_data_->j = 0;
#line 114 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					_data_->_tmp43_ = TRUE;
#line 114 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					while (TRUE) {
#line 114 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
						_data_->_tmp44_ = _data_->_tmp43_;
#line 114 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
						if (!_data_->_tmp44_) {
#line 114 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
							_data_->_tmp45_ = _data_->j;
#line 114 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
							_data_->j = _data_->_tmp45_ + 1;
#line 1142 "tracker-result-store.c"
						}
#line 114 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
						_data_->_tmp43_ = FALSE;
#line 114 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
						_data_->_tmp46_ = _data_->j;
#line 114 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
						_data_->_tmp47_ = _data_->self->priv->n_columns;
#line 114 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
						if (!(_data_->_tmp46_ < _data_->_tmp47_)) {
#line 114 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
							break;
#line 1154 "tracker-result-store.c"
						}
#line 115 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
						_data_->_tmp48_ = _data_->j;
#line 115 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
						_data_->_tmp49_ = _data_->self->priv->n_columns;
#line 115 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
						if (_data_->_tmp48_ == (_data_->_tmp49_ - 1)) {
#line 116 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
							_data_->_tmp50_ = _data_->cursor;
#line 116 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
							_data_->_tmp51_ = _data_->j;
#line 116 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
							_data_->_tmp52_ = NULL;
#line 116 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
							_data_->_tmp52_ = tracker_sparql_cursor_get_string (_data_->_tmp50_, _data_->_tmp51_, NULL);
#line 116 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
							_data_->_tmp53_ = g_strdup (_data_->_tmp52_);
#line 116 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
							_data_->s = _data_->_tmp53_;
#line 118 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
							_data_->_tmp54_ = _data_->s;
#line 118 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
							if (_data_->_tmp54_ != NULL) {
#line 119 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
								_data_->_tmp55_ = _data_->_result_;
#line 119 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
								_data_->_tmp56_ = (*_data_->_tmp55_).values;
#line 119 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
								_data_->_tmp56__length1 = (*_data_->_tmp55_).values_length1;
#line 119 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
								_data_->_tmp57_ = _data_->j;
#line 119 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
								_data_->_tmp58_ = _data_->s;
#line 119 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
								_data_->_tmp59_ = NULL;
#line 119 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
								_data_->_tmp59_ = g_markup_escape_text (_data_->_tmp58_, (gssize) (-1));
#line 119 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
								_g_free0 (_data_->_tmp56_[_data_->_tmp57_]);
#line 119 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
								_data_->_tmp56_[_data_->_tmp57_] = _data_->_tmp59_;
#line 119 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
								_data_->_tmp60_ = _data_->_tmp56_[_data_->_tmp57_];
#line 1198 "tracker-result-store.c"
							} else {
#line 121 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
								_data_->_tmp61_ = _data_->_result_;
#line 121 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
								_data_->_tmp62_ = (*_data_->_tmp61_).values;
#line 121 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
								_data_->_tmp62__length1 = (*_data_->_tmp61_).values_length1;
#line 121 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
								_data_->_tmp63_ = _data_->j;
#line 121 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
								_g_free0 (_data_->_tmp62_[_data_->_tmp63_]);
#line 121 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
								_data_->_tmp62_[_data_->_tmp63_] = NULL;
#line 121 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
								_data_->_tmp64_ = _data_->_tmp62_[_data_->_tmp63_];
#line 1214 "tracker-result-store.c"
							}
#line 115 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
							_g_free0 (_data_->s);
#line 1218 "tracker-result-store.c"
						} else {
#line 123 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
							_data_->_tmp65_ = _data_->_result_;
#line 123 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
							_data_->_tmp66_ = (*_data_->_tmp65_).values;
#line 123 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
							_data_->_tmp66__length1 = (*_data_->_tmp65_).values_length1;
#line 123 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
							_data_->_tmp67_ = _data_->j;
#line 123 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
							_data_->_tmp68_ = _data_->cursor;
#line 123 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
							_data_->_tmp69_ = _data_->j;
#line 123 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
							_data_->_tmp70_ = NULL;
#line 123 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
							_data_->_tmp70_ = tracker_sparql_cursor_get_string (_data_->_tmp68_, _data_->_tmp69_, NULL);
#line 123 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
							_data_->_tmp71_ = g_strdup (_data_->_tmp70_);
#line 123 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
							_g_free0 (_data_->_tmp66_[_data_->_tmp67_]);
#line 123 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
							_data_->_tmp66_[_data_->_tmp67_] = _data_->_tmp71_;
#line 123 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
							_data_->_tmp72_ = _data_->_tmp66_[_data_->_tmp67_];
#line 1244 "tracker-result-store.c"
						}
					}
				}
#line 128 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				memset (&_data_->_tmp73_, 0, sizeof (GtkTreeIter));
#line 128 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				memset (&_data_->_tmp73_, 0, sizeof (GtkTreeIter));
#line 128 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_data_->iter = _data_->_tmp73_;
#line 129 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_data_->_tmp74_ = _data_->self->priv->timestamp;
#line 129 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_data_->iter.stamp = _data_->_tmp74_;
#line 130 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_data_->_tmp75_ = _data_->op;
#line 130 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_data_->_tmp76_ = _data_->_tmp75_->node;
#line 130 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_data_->iter.user_data = _data_->_tmp76_;
#line 131 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_data_->_tmp77_ = _data_->_result_;
#line 131 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_data_->iter.user_data2 = _data_->_tmp77_;
#line 132 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_data_->_tmp78_ = _data_->i;
#line 132 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_data_->_tmp79_ = NULL;
#line 132 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_data_->_tmp79_ = GINT_TO_POINTER (_data_->_tmp78_);
#line 132 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_data_->iter.user_data3 = _data_->_tmp79_;
#line 134 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_data_->_tmp80_ = _data_->iter;
#line 134 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_data_->_tmp81_ = NULL;
#line 134 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_data_->_tmp81_ = gtk_tree_model_get_path ((GtkTreeModel*) _data_->self, &_data_->_tmp80_);
#line 134 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_gtk_tree_path_free0 (_data_->path);
#line 134 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_data_->path = _data_->_tmp81_;
#line 135 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_data_->_tmp82_ = _data_->path;
#line 135 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_data_->_tmp83_ = _data_->iter;
#line 135 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				gtk_tree_model_row_changed ((GtkTreeModel*) _data_->self, _data_->_tmp82_, &_data_->_tmp83_);
#line 95 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_gtk_tree_path_free0 (_data_->path);
#line 1294 "tracker-result-store.c"
			}
		}
#line 138 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp84_ = _data_->self->priv->running_operations;
#line 138 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp85_ = _data_->op;
#line 138 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		g_ptr_array_remove (_data_->_tmp84_, _data_->_tmp85_);
#line 1303 "tracker-result-store.c"
	}
	goto __finally6;
	__catch6_g_io_error:
	{
#line 85 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->ie = _data_->_inner_error_;
#line 85 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_inner_error_ = NULL;
#line 140 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp86_ = _data_->ie;
#line 140 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp87_ = _data_->_tmp86_->message;
#line 140 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		g_warning ("tracker-result-store.vala:140: Could not load items: %s\n", _data_->_tmp87_);
#line 141 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_g_error_free0 (_data_->ie);
#line 141 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_g_object_unref0 (_data_->cursor);
#line 141 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tracker_query_unref0 (_data_->query);
#line 141 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		if (_data_->_state_ == 0) {
#line 141 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1328 "tracker-result-store.c"
		} else {
#line 141 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1332 "tracker-result-store.c"
		}
#line 141 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		g_object_unref (_data_->_async_result);
#line 141 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		return FALSE;
#line 1338 "tracker-result-store.c"
	}
	__finally6:
#line 85 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	if (_data_->_inner_error_ != NULL) {
#line 85 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_g_object_unref0 (_data_->cursor);
#line 85 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tracker_query_unref0 (_data_->query);
#line 85 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 85 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		g_clear_error (&_data_->_inner_error_);
#line 85 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		return FALSE;
#line 1353 "tracker-result-store.c"
	}
#line 144 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_data_->_tmp88_ = _data_->self->priv->delayed_operations;
#line 144 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_data_->_tmp89_ = g_ptr_array_get_length (_data_->_tmp88_);
#line 144 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_data_->_tmp90_ = _data_->_tmp89_;
#line 144 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	if (_data_->_tmp90_ > 0) {
#line 148 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp91_ = _data_->self->priv->delayed_operations;
#line 148 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp92_ = _data_->self->priv->delayed_operations;
#line 148 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp93_ = g_ptr_array_get_length (_data_->_tmp92_);
#line 148 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp94_ = _data_->_tmp93_;
#line 148 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp95_ = NULL;
#line 148 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp95_ = g_ptr_array_index (_data_->_tmp91_, (guint) (_data_->_tmp94_ - 1));
#line 148 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp96_ = _g_object_ref0 ((TrackerResultStoreOperation*) _data_->_tmp95_);
#line 148 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_g_object_unref0 (_data_->next_to_start);
#line 148 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->next_to_start = _data_->_tmp96_;
#line 149 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp97_ = _data_->self->priv->delayed_operations;
#line 149 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp98_ = _data_->next_to_start;
#line 149 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		g_ptr_array_remove (_data_->_tmp97_, _data_->_tmp98_);
#line 150 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp99_ = _data_->self->priv->running_operations;
#line 150 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp100_ = _data_->next_to_start;
#line 150 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp101_ = _g_object_ref0 (_data_->_tmp100_);
#line 150 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		g_ptr_array_add (_data_->_tmp99_, _data_->_tmp101_);
#line 152 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp102_ = _data_->next_to_start;
#line 152 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp103_ = _data_->cancellable;
#line 152 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		tracker_result_store_load_operation (_data_->self, _data_->_tmp102_, _data_->_tmp103_, NULL, NULL);
#line 144 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_g_object_unref0 (_data_->next_to_start);
#line 1403 "tracker-result-store.c"
	} else {
#line 153 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp104_ = _data_->self->priv->running_operations;
#line 153 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp105_ = g_ptr_array_get_length (_data_->_tmp104_);
#line 153 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp106_ = _data_->_tmp105_;
#line 153 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		if (_data_->_tmp106_ == 0) {
#line 155 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			tracker_result_store_set_active (_data_->self, FALSE);
#line 1415 "tracker-result-store.c"
		}
	}
#line 80 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_g_object_unref0 (_data_->cursor);
#line 80 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tracker_query_unref0 (_data_->query);
#line 80 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	if (_data_->_state_ == 0) {
#line 80 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1426 "tracker-result-store.c"
	} else {
#line 80 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1430 "tracker-result-store.c"
	}
#line 80 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	g_object_unref (_data_->_async_result);
#line 80 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	return FALSE;
#line 1436 "tracker-result-store.c"
}


static gpointer _tracker_result_store_category_node_ref0 (gpointer self) {
#line 163 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	return self ? tracker_result_store_category_node_ref (self) : NULL;
#line 1443 "tracker-result-store.c"
}


static void tracker_result_store_add_operation (TrackerResultStore* self, TrackerResultStoreCategoryNode* cat, gint offset) {
	TrackerResultStoreOperation* _tmp0_;
	TrackerResultStoreOperation* op;
	TrackerResultStoreOperation* old = NULL;
	TrackerResultStoreOperation* _tmp1_;
	TrackerResultStoreCategoryNode* _tmp2_;
	TrackerResultStoreCategoryNode* _tmp3_;
	TrackerResultStoreOperation* _tmp4_;
	gint _tmp5_;
	GPtrArray* _tmp6_;
	TrackerResultStoreCategoryNode* _tmp7_;
	gint _tmp8_;
	TrackerResultStoreOperation* _tmp9_ = NULL;
	TrackerResultStoreOperation* _tmp10_;
	gboolean _tmp11_;
	GPtrArray* _tmp12_;
	TrackerResultStoreCategoryNode* _tmp13_;
	gint _tmp14_;
	TrackerResultStoreOperation* _tmp15_ = NULL;
	TrackerResultStoreOperation* _tmp16_;
	GPtrArray* _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
#line 159 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	g_return_if_fail (self != NULL);
#line 159 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	g_return_if_fail (cat != NULL);
#line 160 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp0_ = tracker_result_store_operation_new ();
#line 160 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	op = _tmp0_;
#line 163 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp1_ = op;
#line 163 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp2_ = cat;
#line 163 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp3_ = _tracker_result_store_category_node_ref0 (_tmp2_);
#line 163 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tracker_result_store_category_node_unref0 (_tmp1_->node);
#line 163 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp1_->node = _tmp3_;
#line 164 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp4_ = op;
#line 164 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp5_ = offset;
#line 164 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp4_->offset = _tmp5_;
#line 166 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp6_ = self->priv->running_operations;
#line 166 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp7_ = cat;
#line 166 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp8_ = offset;
#line 166 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp9_ = tracker_result_store_find_operation (self, _tmp6_, _tmp7_, _tmp8_);
#line 166 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp10_ = _tmp9_;
#line 166 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp11_ = _tmp10_ != NULL;
#line 166 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_g_object_unref0 (_tmp10_);
#line 166 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	if (_tmp11_) {
#line 168 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_g_object_unref0 (old);
#line 168 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_g_object_unref0 (op);
#line 168 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		return;
#line 1516 "tracker-result-store.c"
	}
#line 174 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp12_ = self->priv->delayed_operations;
#line 174 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp13_ = cat;
#line 174 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp14_ = offset;
#line 174 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp15_ = tracker_result_store_find_operation (self, _tmp12_, _tmp13_, _tmp14_);
#line 174 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_g_object_unref0 (old);
#line 174 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	old = _tmp15_;
#line 176 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp16_ = old;
#line 176 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	if (_tmp16_ != NULL) {
#line 1534 "tracker-result-store.c"
		GPtrArray* _tmp17_;
		TrackerResultStoreOperation* _tmp18_;
#line 177 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp17_ = self->priv->delayed_operations;
#line 177 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp18_ = old;
#line 177 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		g_ptr_array_remove (_tmp17_, _tmp18_);
#line 1543 "tracker-result-store.c"
	}
#line 180 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	tracker_result_store_set_active (self, TRUE);
#line 184 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp19_ = self->priv->running_operations;
#line 184 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp20_ = g_ptr_array_get_length (_tmp19_);
#line 184 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp21_ = _tmp20_;
#line 184 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	if (_tmp21_ < 2) {
#line 1555 "tracker-result-store.c"
		GPtrArray* _tmp22_;
		TrackerResultStoreOperation* _tmp23_;
		TrackerResultStoreOperation* _tmp24_;
		TrackerResultStoreOperation* _tmp25_;
		GCancellable* _tmp26_;
#line 185 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp22_ = self->priv->running_operations;
#line 185 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp23_ = op;
#line 185 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp24_ = _g_object_ref0 (_tmp23_);
#line 185 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		g_ptr_array_add (_tmp22_, _tmp24_);
#line 188 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp25_ = op;
#line 188 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp26_ = self->priv->cancellable;
#line 188 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		tracker_result_store_load_operation (self, _tmp25_, _tmp26_, NULL, NULL);
#line 1575 "tracker-result-store.c"
	} else {
		GPtrArray* _tmp27_;
		TrackerResultStoreOperation* _tmp28_;
		TrackerResultStoreOperation* _tmp29_;
#line 191 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp27_ = self->priv->delayed_operations;
#line 191 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp28_ = op;
#line 191 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp29_ = _g_object_ref0 (_tmp28_);
#line 191 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		g_ptr_array_add (_tmp27_, _tmp29_);
#line 1588 "tracker-result-store.c"
	}
#line 159 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_g_object_unref0 (old);
#line 159 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_g_object_unref0 (op);
#line 1594 "tracker-result-store.c"
}


static void tracker_result_store_load_category_data_free (gpointer _data) {
	TrackerResultStoreLoadCategoryData* _data_;
	_data_ = _data;
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_g_object_unref0 (_data_->cancellable);
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_g_object_unref0 (_data_->self);
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	g_slice_free (TrackerResultStoreLoadCategoryData, _data_);
#line 1607 "tracker-result-store.c"
}


static void tracker_result_store_load_category (TrackerResultStore* self, TrackerResultStoreQueryData* query_data, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerResultStoreLoadCategoryData* _data_;
	TrackerResultStore* _tmp0_;
	TrackerResultStoreQueryData* _tmp1_;
	GCancellable* _tmp2_;
	GCancellable* _tmp3_;
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_data_ = g_slice_new0 (TrackerResultStoreLoadCategoryData);
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_result_store_load_category);
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_result_store_load_category_data_free);
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_data_->self = _tmp0_;
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp1_ = query_data;
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_data_->query_data = _tmp1_;
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp2_ = cancellable;
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_data_->cancellable = _tmp3_;
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	tracker_result_store_load_category_co (_data_);
#line 1639 "tracker-result-store.c"
}


static void tracker_result_store_load_category_finish (TrackerResultStore* self, GAsyncResult* _res_) {
	TrackerResultStoreLoadCategoryData* _data_;
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 1647 "tracker-result-store.c"
}


static void tracker_result_store_load_category_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerResultStoreLoadCategoryData* _data_;
#line 204 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_data_ = _user_data_;
#line 204 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_data_->_source_object_ = source_object;
#line 204 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_data_->_res_ = _res_;
#line 204 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	tracker_result_store_load_category_co (_data_);
#line 1661 "tracker-result-store.c"
}


static gboolean tracker_result_store_load_category_co (TrackerResultStoreLoadCategoryData* _data_) {
#line 195 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	switch (_data_->_state_) {
#line 195 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		case 0:
#line 1670 "tracker-result-store.c"
		goto _state_0;
#line 195 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		case 1:
#line 1674 "tracker-result-store.c"
		goto _state_1;
		default:
#line 195 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		g_assert_not_reached ();
#line 1679 "tracker-result-store.c"
	}
	_state_0:
#line 196 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_data_->count = (guint) 0;
#line 1684 "tracker-result-store.c"
	{
#line 199 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp0_ = _data_->cancellable;
#line 199 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		g_cancellable_set_error_if_cancelled (_data_->_tmp0_, &_data_->_inner_error_);
#line 199 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		if (_data_->_inner_error_ != NULL) {
#line 199 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			if (_data_->_inner_error_->domain == G_IO_ERROR) {
#line 1694 "tracker-result-store.c"
				goto __catch8_g_io_error;
			}
#line 199 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 199 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			g_clear_error (&_data_->_inner_error_);
#line 199 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			return FALSE;
#line 1703 "tracker-result-store.c"
		}
#line 201 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp1_ = tracker_query_new ();
#line 201 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->query = _data_->_tmp1_;
#line 202 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp2_ = _data_->query;
#line 202 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp3_ = _data_->self->priv->_search_term;
#line 202 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		tracker_query_set_criteria (_data_->_tmp2_, _data_->_tmp3_);
#line 204 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp4_ = _data_->query;
#line 204 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp5_ = _data_->query_data;
#line 204 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp6_ = (*_data_->_tmp5_).type;
#line 204 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp7_ = _data_->query_data;
#line 204 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp8_ = (*_data_->_tmp7_).match;
#line 204 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp9_ = _data_->cancellable;
#line 204 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_state_ = 1;
#line 204 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		tracker_query_get_count_async (_data_->_tmp4_, _data_->_tmp6_, _data_->_tmp8_, _data_->_tmp9_, tracker_result_store_load_category_ready, _data_);
#line 204 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		return FALSE;
#line 1733 "tracker-result-store.c"
		_state_1:
#line 204 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp10_ = 0U;
#line 204 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp10_ = tracker_query_get_count_finish (_data_->_tmp4_, _data_->_res_, &_data_->_inner_error_);
#line 204 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp11_ = _data_->_tmp10_;
#line 204 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		if (_data_->_inner_error_ != NULL) {
#line 204 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tracker_query_unref0 (_data_->query);
#line 204 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			if (_data_->_inner_error_->domain == G_IO_ERROR) {
#line 1747 "tracker-result-store.c"
				goto __catch8_g_io_error;
			}
#line 204 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tracker_query_unref0 (_data_->query);
#line 204 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 204 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			g_clear_error (&_data_->_inner_error_);
#line 204 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			return FALSE;
#line 1758 "tracker-result-store.c"
		}
#line 204 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->count = _data_->_tmp11_;
#line 198 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tracker_query_unref0 (_data_->query);
#line 1764 "tracker-result-store.c"
	}
	goto __finally8;
	__catch8_g_io_error:
	{
#line 198 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->ie = _data_->_inner_error_;
#line 198 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_inner_error_ = NULL;
#line 206 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp12_ = _data_->ie;
#line 206 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp13_ = _data_->_tmp12_->message;
#line 206 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		g_warning ("tracker-result-store.vala:206: Could not get count: %s\n", _data_->_tmp13_);
#line 207 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_g_error_free0 (_data_->ie);
#line 207 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		if (_data_->_state_ == 0) {
#line 207 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1785 "tracker-result-store.c"
		} else {
#line 207 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1789 "tracker-result-store.c"
		}
#line 207 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		g_object_unref (_data_->_async_result);
#line 207 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		return FALSE;
#line 1795 "tracker-result-store.c"
	}
	__finally8:
#line 198 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	if (_data_->_inner_error_ != NULL) {
#line 198 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 198 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		g_clear_error (&_data_->_inner_error_);
#line 198 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		return FALSE;
#line 1806 "tracker-result-store.c"
	}
#line 210 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_data_->_tmp14_ = _data_->count;
#line 210 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	if (_data_->_tmp14_ != ((guint) 0)) {
#line 218 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp15_ = tracker_result_store_category_node_new ();
#line 218 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tracker_result_store_category_node_unref0 (_data_->cat);
#line 218 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->cat = _data_->_tmp15_;
#line 219 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp16_ = _data_->cat;
#line 219 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp17_ = _data_->query_data;
#line 219 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp18_ = (*_data_->_tmp17_).type;
#line 219 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp16_->type = _data_->_tmp18_;
#line 220 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp19_ = _data_->cat;
#line 220 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp20_ = _data_->query_data;
#line 220 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp19_->query = _data_->_tmp20_;
#line 221 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp21_ = _data_->cat;
#line 221 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp22_ = _data_->count;
#line 221 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp23_ = 0;
#line 221 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp23_ = (gint) _data_->_tmp22_;
#line 221 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp21_->results = g_renew (TrackerResultStoreResultNode, _data_->_tmp21_->results, (gint) _data_->_tmp22_);
#line 221 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		(_data_->_tmp23_ > _data_->_tmp21_->results_length1) ? memset (_data_->_tmp21_->results + _data_->_tmp21_->results_length1, 0, sizeof (TrackerResultStoreResultNode) * (_data_->_tmp23_ - _data_->_tmp21_->results_length1)) : NULL;
#line 221 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp21_->results_length1 = _data_->_tmp23_;
#line 221 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp21_->_results_size_ = _data_->_tmp23_;
#line 222 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp24_ = _data_->self->priv->categories;
#line 222 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp25_ = _data_->cat;
#line 222 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp26_ = _tracker_result_store_category_node_ref0 (_data_->_tmp25_);
#line 222 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		g_ptr_array_add (_data_->_tmp24_, _data_->_tmp26_);
#line 224 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		memset (&_data_->_tmp27_, 0, sizeof (GtkTreeIter));
#line 224 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		memset (&_data_->_tmp27_, 0, sizeof (GtkTreeIter));
#line 224 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->iter = _data_->_tmp27_;
#line 225 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp28_ = _data_->self->priv->timestamp;
#line 225 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->iter.stamp = _data_->_tmp28_;
#line 226 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp29_ = _data_->cat;
#line 226 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->iter.user_data = _data_->_tmp29_;
#line 228 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp30_ = _data_->self->priv->queries;
#line 228 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp30__length1 = _data_->self->priv->queries_length1;
#line 228 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		if (_data_->_tmp30__length1 > 1) {
#line 229 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_data_->_tmp31_ = _data_->iter;
#line 229 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_data_->_tmp32_ = NULL;
#line 229 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_data_->_tmp32_ = gtk_tree_model_get_path ((GtkTreeModel*) _data_->self, &_data_->_tmp31_);
#line 229 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_gtk_tree_path_free0 (_data_->path);
#line 229 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_data_->path = _data_->_tmp32_;
#line 230 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_data_->_tmp33_ = _data_->path;
#line 230 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_data_->_tmp34_ = _data_->iter;
#line 230 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			gtk_tree_model_row_inserted ((GtkTreeModel*) _data_->self, _data_->_tmp33_, &_data_->_tmp34_);
#line 1892 "tracker-result-store.c"
		}
		{
#line 233 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_data_->i = 0;
#line 233 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_data_->_tmp35_ = TRUE;
#line 233 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			while (TRUE) {
#line 233 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_data_->_tmp36_ = _data_->_tmp35_;
#line 233 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				if (!_data_->_tmp36_) {
#line 233 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					_data_->_tmp37_ = _data_->i;
#line 233 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					_data_->i = _data_->_tmp37_ + 1;
#line 1909 "tracker-result-store.c"
				}
#line 233 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_data_->_tmp35_ = FALSE;
#line 233 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_data_->_tmp38_ = _data_->i;
#line 233 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_data_->_tmp39_ = _data_->count;
#line 233 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				if (!(((guint) _data_->_tmp38_) < _data_->_tmp39_)) {
#line 233 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					break;
#line 1921 "tracker-result-store.c"
				}
#line 234 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_data_->_tmp40_ = _data_->cat;
#line 234 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_data_->_tmp41_ = _data_->_tmp40_->results;
#line 234 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_data_->_tmp41__length1 = _data_->_tmp40_->results_length1;
#line 234 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_data_->_tmp42_ = _data_->i;
#line 234 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_data_->res = &_data_->_tmp41_[_data_->_tmp42_];
#line 235 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_data_->_tmp43_ = _data_->res;
#line 235 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_data_->_tmp44_ = _data_->self->priv->n_columns;
#line 235 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_data_->_tmp45_ = NULL;
#line 235 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_data_->_tmp45_ = g_new0 (gchar*, _data_->_tmp44_ + 1);
#line 235 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				(*_data_->_tmp43_).values = (_vala_array_free ((*_data_->_tmp43_).values, (*_data_->_tmp43_).values_length1, (GDestroyNotify) g_free), NULL);
#line 235 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				(*_data_->_tmp43_).values = _data_->_tmp45_;
#line 235 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				(*_data_->_tmp43_).values_length1 = _data_->_tmp44_;
#line 235 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				(*_data_->_tmp43_)._values_size_ = (*_data_->_tmp43_).values_length1;
#line 237 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_data_->_tmp46_ = _data_->res;
#line 237 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_data_->iter.user_data2 = _data_->_tmp46_;
#line 238 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_data_->_tmp47_ = _data_->i;
#line 238 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_data_->_tmp48_ = NULL;
#line 238 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_data_->_tmp48_ = GINT_TO_POINTER (_data_->_tmp47_);
#line 238 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_data_->iter.user_data3 = _data_->_tmp48_;
#line 239 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_data_->_tmp49_ = _data_->iter;
#line 239 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_data_->_tmp50_ = NULL;
#line 239 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_data_->_tmp50_ = gtk_tree_model_get_path ((GtkTreeModel*) _data_->self, &_data_->_tmp49_);
#line 239 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_gtk_tree_path_free0 (_data_->path);
#line 239 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_data_->path = _data_->_tmp50_;
#line 241 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_data_->_tmp51_ = _data_->cat;
#line 241 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_data_->_tmp52_ = _data_->_tmp51_->count;
#line 241 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_data_->_tmp51_->count = _data_->_tmp52_ + 1;
#line 242 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_data_->_tmp53_ = _data_->path;
#line 242 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_data_->_tmp54_ = _data_->iter;
#line 242 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				gtk_tree_model_row_inserted ((GtkTreeModel*) _data_->self, _data_->_tmp53_, &_data_->_tmp54_);
#line 1983 "tracker-result-store.c"
			}
		}
#line 245 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp55_ = _data_->self->priv->queries;
#line 245 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp55__length1 = _data_->self->priv->queries_length1;
#line 245 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		if (_data_->_tmp55__length1 > 1) {
#line 246 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_data_->iter.user_data2 = NULL;
#line 247 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_data_->iter.user_data3 = NULL;
#line 248 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_data_->_tmp56_ = _data_->iter;
#line 248 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_data_->_tmp57_ = NULL;
#line 248 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_data_->_tmp57_ = gtk_tree_model_get_path ((GtkTreeModel*) _data_->self, &_data_->_tmp56_);
#line 248 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_gtk_tree_path_free0 (_data_->path);
#line 248 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_data_->path = _data_->_tmp57_;
#line 250 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_data_->_tmp58_ = _data_->path;
#line 250 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_data_->_tmp59_ = _data_->iter;
#line 250 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			gtk_tree_model_row_changed ((GtkTreeModel*) _data_->self, _data_->_tmp58_, &_data_->_tmp59_);
#line 2012 "tracker-result-store.c"
		}
#line 210 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_gtk_tree_path_free0 (_data_->path);
#line 210 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tracker_result_store_category_node_unref0 (_data_->cat);
#line 2018 "tracker-result-store.c"
	}
#line 254 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_data_->_tmp60_ = _data_->self->priv->running_operations;
#line 254 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_data_->_tmp61_ = g_ptr_array_get_length (_data_->_tmp60_);
#line 254 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_data_->_tmp62_ = _data_->_tmp61_;
#line 254 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	if (_data_->_tmp62_ == 0) {
#line 255 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		tracker_result_store_set_active (_data_->self, FALSE);
#line 2030 "tracker-result-store.c"
	}
#line 195 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	if (_data_->_state_ == 0) {
#line 195 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2036 "tracker-result-store.c"
	} else {
#line 195 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2040 "tracker-result-store.c"
	}
#line 195 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	g_object_unref (_data_->_async_result);
#line 195 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	return FALSE;
#line 2046 "tracker-result-store.c"
}


static void tracker_result_store_clear_results (TrackerResultStore* self) {
	gint j = 0;
#line 259 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	g_return_if_fail (self != NULL);
#line 262 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	while (TRUE) {
#line 2056 "tracker-result-store.c"
		GPtrArray* _tmp0_;
		gint _tmp1_;
		gint _tmp2_;
		GPtrArray* _tmp3_;
		gconstpointer _tmp4_ = NULL;
		TrackerResultStoreCategoryNode* _tmp5_;
		TrackerResultStoreCategoryNode* cat;
		GtkTreeIter iter = {0};
		GtkTreePath* path = NULL;
		TrackerResultStoreCategoryNode* _tmp6_;
		TrackerResultStoreResultNode* _tmp7_;
		gint _tmp7__length1;
		GtkTreeIter _tmp8_ = {0};
		gint _tmp9_;
		TrackerResultStoreCategoryNode* _tmp10_;
		TrackerResultStoreQueryData* _tmp27_;
		gint _tmp27__length1;
		GPtrArray* _tmp31_;
		TrackerResultStoreCategoryNode* _tmp32_;
#line 262 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp0_ = self->priv->categories;
#line 262 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp1_ = g_ptr_array_get_length (_tmp0_);
#line 262 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp2_ = _tmp1_;
#line 262 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		if (!(_tmp2_ > 0)) {
#line 262 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			break;
#line 2086 "tracker-result-store.c"
		}
#line 263 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp3_ = self->priv->categories;
#line 263 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp4_ = g_ptr_array_index (_tmp3_, (guint) 0);
#line 263 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp5_ = _tracker_result_store_category_node_ref0 ((TrackerResultStoreCategoryNode*) _tmp4_);
#line 263 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		cat = _tmp5_;
#line 267 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp6_ = cat;
#line 267 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp7_ = _tmp6_->results;
#line 267 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp7__length1 = _tmp6_->results_length1;
#line 267 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		if (_tmp7__length1 == 0) {
#line 268 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_gtk_tree_path_free0 (path);
#line 268 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tracker_result_store_category_node_unref0 (cat);
#line 268 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			continue;
#line 2110 "tracker-result-store.c"
		}
#line 271 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		memset (&_tmp8_, 0, sizeof (GtkTreeIter));
#line 271 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		iter = _tmp8_;
#line 272 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp9_ = self->priv->timestamp;
#line 272 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		iter.stamp = _tmp9_;
#line 273 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp10_ = cat;
#line 273 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		iter.user_data = _tmp10_;
#line 2124 "tracker-result-store.c"
		{
			TrackerResultStoreCategoryNode* _tmp11_;
			gint _tmp12_;
			gboolean _tmp13_;
#line 275 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp11_ = cat;
#line 275 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp12_ = _tmp11_->count;
#line 275 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			j = _tmp12_ - 1;
#line 275 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp13_ = TRUE;
#line 275 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			while (TRUE) {
#line 2139 "tracker-result-store.c"
				gboolean _tmp14_;
				gint _tmp16_;
				TrackerResultStoreCategoryNode* _tmp17_;
				TrackerResultStoreResultNode* _tmp18_;
				gint _tmp18__length1;
				gint _tmp19_;
				gint _tmp20_;
				void* _tmp21_ = NULL;
				GtkTreeIter _tmp22_;
				GtkTreePath* _tmp23_ = NULL;
				GtkTreePath* _tmp24_;
				TrackerResultStoreCategoryNode* _tmp25_;
				gint _tmp26_;
#line 275 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tmp14_ = _tmp13_;
#line 275 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				if (!_tmp14_) {
#line 2157 "tracker-result-store.c"
					gint _tmp15_;
#line 275 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					_tmp15_ = j;
#line 275 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					j = _tmp15_ - 1;
#line 2163 "tracker-result-store.c"
				}
#line 275 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tmp13_ = FALSE;
#line 275 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tmp16_ = j;
#line 275 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				if (!(_tmp16_ >= 0)) {
#line 275 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					break;
#line 2173 "tracker-result-store.c"
				}
#line 276 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tmp17_ = cat;
#line 276 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tmp18_ = _tmp17_->results;
#line 276 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tmp18__length1 = _tmp17_->results_length1;
#line 276 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tmp19_ = j;
#line 276 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				iter.user_data2 = &_tmp18_[_tmp19_];
#line 277 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tmp20_ = j;
#line 277 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tmp21_ = GINT_TO_POINTER (_tmp20_);
#line 277 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				iter.user_data3 = _tmp21_;
#line 278 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tmp22_ = iter;
#line 278 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tmp23_ = gtk_tree_model_get_path ((GtkTreeModel*) self, &_tmp22_);
#line 278 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_gtk_tree_path_free0 (path);
#line 278 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				path = _tmp23_;
#line 280 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tmp24_ = path;
#line 280 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				gtk_tree_model_row_deleted ((GtkTreeModel*) self, _tmp24_);
#line 281 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tmp25_ = cat;
#line 281 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tmp26_ = _tmp25_->count;
#line 281 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tmp25_->count = _tmp26_ - 1;
#line 2209 "tracker-result-store.c"
			}
		}
#line 284 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp27_ = self->priv->queries;
#line 284 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp27__length1 = self->priv->queries_length1;
#line 284 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		if (_tmp27__length1 > 1) {
#line 2218 "tracker-result-store.c"
			GtkTreeIter _tmp28_;
			GtkTreePath* _tmp29_ = NULL;
			GtkTreePath* _tmp30_;
#line 285 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			iter.user_data2 = NULL;
#line 286 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			iter.user_data3 = NULL;
#line 287 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp28_ = iter;
#line 287 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp29_ = gtk_tree_model_get_path ((GtkTreeModel*) self, &_tmp28_);
#line 287 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_gtk_tree_path_free0 (path);
#line 287 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			path = _tmp29_;
#line 289 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp30_ = path;
#line 289 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			gtk_tree_model_row_deleted ((GtkTreeModel*) self, _tmp30_);
#line 2238 "tracker-result-store.c"
		}
#line 292 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp31_ = self->priv->categories;
#line 292 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp32_ = cat;
#line 292 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		g_ptr_array_remove (_tmp31_, _tmp32_);
#line 262 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_gtk_tree_path_free0 (path);
#line 262 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tracker_result_store_category_node_unref0 (cat);
#line 2250 "tracker-result-store.c"
	}
}


static gint tracker_result_store_find_nth_category_index (TrackerResultStore* self, TrackerResultStoreCategoryNode* node, gint n) {
	gint result = 0;
	gint i = 0;
	TrackerResultStoreCategoryNode* _tmp0_;
#line 332 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 335 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp0_ = node;
#line 335 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	if (_tmp0_ == NULL) {
#line 2265 "tracker-result-store.c"
		gint _tmp1_;
#line 337 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp1_ = n;
#line 337 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		result = _tmp1_;
#line 337 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		return result;
#line 2273 "tracker-result-store.c"
	}
	{
		gboolean _tmp2_;
#line 340 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		i = 0;
#line 340 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp2_ = TRUE;
#line 340 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		while (TRUE) {
#line 2283 "tracker-result-store.c"
			gboolean _tmp3_;
			gint _tmp5_;
			GPtrArray* _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			TrackerResultStoreCategoryNode* cat = NULL;
			GPtrArray* _tmp9_;
			gint _tmp10_;
			gconstpointer _tmp11_ = NULL;
			TrackerResultStoreCategoryNode* _tmp12_;
			TrackerResultStoreCategoryNode* _tmp13_;
			TrackerResultStoreCategoryNode* _tmp14_;
#line 340 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp3_ = _tmp2_;
#line 340 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			if (!_tmp3_) {
#line 2300 "tracker-result-store.c"
				gint _tmp4_;
#line 340 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tmp4_ = i;
#line 340 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				i = _tmp4_ + 1;
#line 2306 "tracker-result-store.c"
			}
#line 340 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp2_ = FALSE;
#line 340 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp5_ = i;
#line 340 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp6_ = self->priv->categories;
#line 340 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp7_ = g_ptr_array_get_length (_tmp6_);
#line 340 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp8_ = _tmp7_;
#line 340 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			if (!(_tmp5_ < _tmp8_)) {
#line 340 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				break;
#line 2322 "tracker-result-store.c"
			}
#line 343 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp9_ = self->priv->categories;
#line 343 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp10_ = i;
#line 343 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp11_ = g_ptr_array_index (_tmp9_, (guint) _tmp10_);
#line 343 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp12_ = _tracker_result_store_category_node_ref0 ((TrackerResultStoreCategoryNode*) _tmp11_);
#line 343 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tracker_result_store_category_node_unref0 (cat);
#line 343 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			cat = _tmp12_;
#line 345 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp13_ = cat;
#line 345 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp14_ = node;
#line 345 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			if (_tmp13_ == _tmp14_) {
#line 2342 "tracker-result-store.c"
				gint _tmp15_;
				gint _tmp16_;
#line 346 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tmp15_ = i;
#line 346 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tmp16_ = n;
#line 346 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				result = _tmp15_ + _tmp16_;
#line 346 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tracker_result_store_category_node_unref0 (cat);
#line 346 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				return result;
#line 2355 "tracker-result-store.c"
			}
#line 340 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tracker_result_store_category_node_unref0 (cat);
#line 2359 "tracker-result-store.c"
		}
	}
#line 350 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	result = -1;
#line 350 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	return result;
#line 2366 "tracker-result-store.c"
}


static gint tracker_result_store_filled_categories_count (TrackerResultStore* self) {
	gint result = 0;
	gint i = 0;
	gint n;
#line 353 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 354 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	n = 0;
#line 2378 "tracker-result-store.c"
	{
		gboolean _tmp0_;
#line 356 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		i = 0;
#line 356 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp0_ = TRUE;
#line 356 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		while (TRUE) {
#line 2387 "tracker-result-store.c"
			gboolean _tmp1_;
			gint _tmp3_;
			GPtrArray* _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			TrackerResultStoreCategoryNode* cat = NULL;
			GPtrArray* _tmp7_;
			gint _tmp8_;
			gconstpointer _tmp9_ = NULL;
			TrackerResultStoreCategoryNode* _tmp10_;
			TrackerResultStoreCategoryNode* _tmp11_;
			gint _tmp12_;
#line 356 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp1_ = _tmp0_;
#line 356 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			if (!_tmp1_) {
#line 2404 "tracker-result-store.c"
				gint _tmp2_;
#line 356 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tmp2_ = i;
#line 356 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				i = _tmp2_ + 1;
#line 2410 "tracker-result-store.c"
			}
#line 356 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp0_ = FALSE;
#line 356 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp3_ = i;
#line 356 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp4_ = self->priv->categories;
#line 356 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp5_ = g_ptr_array_get_length (_tmp4_);
#line 356 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp6_ = _tmp5_;
#line 356 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			if (!(_tmp3_ < _tmp6_)) {
#line 356 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				break;
#line 2426 "tracker-result-store.c"
			}
#line 359 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp7_ = self->priv->categories;
#line 359 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp8_ = i;
#line 359 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp9_ = g_ptr_array_index (_tmp7_, (guint) _tmp8_);
#line 359 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp10_ = _tracker_result_store_category_node_ref0 ((TrackerResultStoreCategoryNode*) _tmp9_);
#line 359 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tracker_result_store_category_node_unref0 (cat);
#line 359 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			cat = _tmp10_;
#line 361 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp11_ = cat;
#line 361 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp12_ = _tmp11_->count;
#line 361 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			if (_tmp12_ > 0) {
#line 2446 "tracker-result-store.c"
				gint _tmp13_;
#line 362 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tmp13_ = n;
#line 362 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				n = _tmp13_ + 1;
#line 2452 "tracker-result-store.c"
			}
#line 356 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tracker_result_store_category_node_unref0 (cat);
#line 2456 "tracker-result-store.c"
		}
	}
#line 366 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	result = n;
#line 366 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	return result;
#line 2463 "tracker-result-store.c"
}


static GType tracker_result_store_real_get_column_type (GtkTreeModel* base, gint index_) {
	TrackerResultStore * self;
	GType result = 0UL;
	gint _tmp0_;
	gint _tmp1_;
#line 369 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	self = (TrackerResultStore*) base;
#line 370 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp0_ = index_;
#line 370 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp1_ = self->priv->n_columns;
#line 370 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	if (_tmp0_ == _tmp1_) {
#line 371 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		result = GDK_TYPE_PIXBUF;
#line 371 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		return result;
#line 2484 "tracker-result-store.c"
	} else {
		gint _tmp2_;
		gint _tmp3_;
#line 372 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp2_ = index_;
#line 372 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp3_ = self->priv->n_columns;
#line 372 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		if (_tmp2_ == (_tmp3_ + 1)) {
#line 373 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			result = TRACKER_QUERY_TYPE_TYPE;
#line 373 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			return result;
#line 2498 "tracker-result-store.c"
		} else {
#line 375 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			result = G_TYPE_STRING;
#line 375 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			return result;
#line 2504 "tracker-result-store.c"
		}
	}
}


static GtkTreeModelFlags tracker_result_store_real_get_flags (GtkTreeModel* base) {
	TrackerResultStore * self;
	GtkTreeModelFlags result = 0;
	GtkTreeModelFlags flags = 0;
	TrackerResultStoreQueryData* _tmp0_;
	gint _tmp0__length1;
#line 379 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	self = (TrackerResultStore*) base;
#line 382 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	flags = GTK_TREE_MODEL_ITERS_PERSIST;
#line 384 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp0_ = self->priv->queries;
#line 384 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp0__length1 = self->priv->queries_length1;
#line 384 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	if (_tmp0__length1 == 1) {
#line 2526 "tracker-result-store.c"
		GtkTreeModelFlags _tmp1_;
#line 385 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp1_ = flags;
#line 385 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		flags = _tmp1_ | GTK_TREE_MODEL_LIST_ONLY;
#line 2532 "tracker-result-store.c"
	}
#line 388 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	result = flags;
#line 388 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	return result;
#line 2538 "tracker-result-store.c"
}


static gboolean tracker_result_store_real_get_iter (GtkTreeModel* base, GtkTreeIter* iter, GtkTreePath* path) {
	TrackerResultStore * self;
	GtkTreeIter _vala_iter = {0};
	gboolean result = FALSE;
	GtkTreePath* _tmp0_;
	gint* _tmp1_ = NULL;
	gint* indices;
	gint indices_length1;
	gint _indices_size_;
	TrackerResultStoreCategoryNode* cat = NULL;
	gint i;
	TrackerResultStoreQueryData* _tmp2_;
	gint _tmp2__length1;
	gint _tmp22_;
	TrackerResultStoreCategoryNode* _tmp23_;
	GtkTreePath* _tmp24_;
	gint _tmp25_ = 0;
	gint _tmp26_;
#line 391 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	self = (TrackerResultStore*) base;
#line 391 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	g_return_val_if_fail (path != NULL, FALSE);
#line 392 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp0_ = path;
#line 392 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp1_ = gtk_tree_path_get_indices (_tmp0_);
#line 392 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	indices = _tmp1_;
#line 392 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	indices_length1 = -1;
#line 392 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_indices_size_ = indices_length1;
#line 394 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	i = 0;
#line 396 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp2_ = self->priv->queries;
#line 396 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp2__length1 = self->priv->queries_length1;
#line 396 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	if (_tmp2__length1 > 1) {
#line 2582 "tracker-result-store.c"
		gint* _tmp3_;
		gint _tmp3__length1;
		gint _tmp4_;
		gint _tmp5_;
		GPtrArray* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		GPtrArray* _tmp9_;
		gint* _tmp10_;
		gint _tmp10__length1;
		gint _tmp11_;
		gint _tmp12_;
		gconstpointer _tmp13_ = NULL;
		TrackerResultStoreCategoryNode* _tmp14_;
		gint _tmp15_;
#line 397 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp3_ = indices;
#line 397 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp3__length1 = indices_length1;
#line 397 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp4_ = i;
#line 397 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp5_ = _tmp3_[_tmp4_];
#line 397 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp6_ = self->priv->categories;
#line 397 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp7_ = g_ptr_array_get_length (_tmp6_);
#line 397 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp8_ = _tmp7_;
#line 397 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		if (_tmp5_ >= _tmp8_) {
#line 398 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_vala_iter.stamp = 0;
#line 399 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			result = FALSE;
#line 399 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tracker_result_store_category_node_unref0 (cat);
#line 399 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			if (iter) {
#line 399 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				*iter = _vala_iter;
#line 2624 "tracker-result-store.c"
			}
#line 399 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			return result;
#line 2628 "tracker-result-store.c"
		}
#line 402 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp9_ = self->priv->categories;
#line 402 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp10_ = indices;
#line 402 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp10__length1 = indices_length1;
#line 402 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp11_ = i;
#line 402 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp12_ = _tmp10_[_tmp11_];
#line 402 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp13_ = g_ptr_array_index (_tmp9_, (guint) _tmp12_);
#line 402 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp14_ = _tracker_result_store_category_node_ref0 ((TrackerResultStoreCategoryNode*) _tmp13_);
#line 402 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tracker_result_store_category_node_unref0 (cat);
#line 402 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		cat = _tmp14_;
#line 403 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp15_ = i;
#line 403 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		i = _tmp15_ + 1;
#line 2652 "tracker-result-store.c"
	} else {
		GPtrArray* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		GPtrArray* _tmp19_;
		gconstpointer _tmp20_ = NULL;
		TrackerResultStoreCategoryNode* _tmp21_;
#line 405 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp16_ = self->priv->categories;
#line 405 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp17_ = g_ptr_array_get_length (_tmp16_);
#line 405 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp18_ = _tmp17_;
#line 405 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		if (_tmp18_ == 0) {
#line 406 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_vala_iter.stamp = 0;
#line 407 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			result = FALSE;
#line 407 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tracker_result_store_category_node_unref0 (cat);
#line 407 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			if (iter) {
#line 407 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				*iter = _vala_iter;
#line 2678 "tracker-result-store.c"
			}
#line 407 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			return result;
#line 2682 "tracker-result-store.c"
		}
#line 410 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp19_ = self->priv->categories;
#line 410 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp20_ = g_ptr_array_index (_tmp19_, (guint) 0);
#line 410 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp21_ = _tracker_result_store_category_node_ref0 ((TrackerResultStoreCategoryNode*) _tmp20_);
#line 410 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tracker_result_store_category_node_unref0 (cat);
#line 410 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		cat = _tmp21_;
#line 2694 "tracker-result-store.c"
	}
#line 413 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp22_ = self->priv->timestamp;
#line 413 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_vala_iter.stamp = _tmp22_;
#line 414 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp23_ = cat;
#line 414 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_vala_iter.user_data = _tmp23_;
#line 416 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp24_ = path;
#line 416 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp25_ = gtk_tree_path_get_depth (_tmp24_);
#line 416 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp26_ = i;
#line 416 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	if (_tmp25_ == (_tmp26_ + 1)) {
#line 2712 "tracker-result-store.c"
		gint* _tmp27_;
		gint _tmp27__length1;
		gint _tmp28_;
		gint _tmp29_;
		TrackerResultStoreCategoryNode* _tmp30_;
		gint _tmp31_;
		TrackerResultStoreCategoryNode* _tmp32_;
		TrackerResultStoreResultNode* _tmp33_;
		gint _tmp33__length1;
		gint* _tmp34_;
		gint _tmp34__length1;
		gint _tmp35_;
		gint _tmp36_;
		gint* _tmp37_;
		gint _tmp37__length1;
		gint _tmp38_;
		gint _tmp39_;
		void* _tmp40_ = NULL;
#line 418 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp27_ = indices;
#line 418 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp27__length1 = indices_length1;
#line 418 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp28_ = i;
#line 418 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp29_ = _tmp27_[_tmp28_];
#line 418 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp30_ = cat;
#line 418 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp31_ = _tmp30_->count;
#line 418 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		if (_tmp29_ >= _tmp31_) {
#line 419 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_vala_iter.stamp = 0;
#line 420 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			result = FALSE;
#line 420 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tracker_result_store_category_node_unref0 (cat);
#line 420 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			if (iter) {
#line 420 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				*iter = _vala_iter;
#line 2755 "tracker-result-store.c"
			}
#line 420 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			return result;
#line 2759 "tracker-result-store.c"
		}
#line 423 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp32_ = cat;
#line 423 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp33_ = _tmp32_->results;
#line 423 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp33__length1 = _tmp32_->results_length1;
#line 423 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp34_ = indices;
#line 423 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp34__length1 = indices_length1;
#line 423 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp35_ = i;
#line 423 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp36_ = _tmp34_[_tmp35_];
#line 423 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_vala_iter.user_data2 = &_tmp33_[_tmp36_];
#line 424 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp37_ = indices;
#line 424 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp37__length1 = indices_length1;
#line 424 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp38_ = i;
#line 424 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp39_ = _tmp37_[_tmp38_];
#line 424 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp40_ = GINT_TO_POINTER (_tmp39_);
#line 424 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_vala_iter.user_data3 = _tmp40_;
#line 2789 "tracker-result-store.c"
	}
#line 427 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	result = TRUE;
#line 427 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tracker_result_store_category_node_unref0 (cat);
#line 427 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	if (iter) {
#line 427 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		*iter = _vala_iter;
#line 2799 "tracker-result-store.c"
	}
#line 427 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	return result;
#line 2803 "tracker-result-store.c"
}


static gint tracker_result_store_real_get_n_columns (GtkTreeModel* base) {
	TrackerResultStore * self;
	gint result = 0;
	gint _tmp0_;
	gint _tmp1_;
#line 430 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	self = (TrackerResultStore*) base;
#line 431 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp0_ = self->priv->n_columns;
#line 431 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp1_ = self->priv->n_extra_columns;
#line 431 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	result = _tmp0_ + _tmp1_;
#line 431 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	return result;
#line 2822 "tracker-result-store.c"
}


static GtkTreePath* tracker_result_store_real_get_path (GtkTreeModel* base, GtkTreeIter* iter) {
	TrackerResultStore * self;
	GtkTreePath* result = NULL;
	GtkTreePath* _tmp0_;
	GtkTreePath* path;
	TrackerResultStoreCategoryNode* cat = NULL;
	gint i = 0;
	TrackerResultStoreQueryData* _tmp1_;
	gint _tmp1__length1;
	GtkTreeIter _tmp18_;
	void* _tmp19_;
#line 435 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	self = (TrackerResultStore*) base;
#line 435 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	g_return_val_if_fail (iter != NULL, NULL);
#line 439 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp0_ = gtk_tree_path_new ();
#line 439 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	path = _tmp0_;
#line 443 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp1_ = self->priv->queries;
#line 443 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp1__length1 = self->priv->queries_length1;
#line 443 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	if (_tmp1__length1 > 1) {
#line 2851 "tracker-result-store.c"
		{
			gboolean _tmp2_;
#line 444 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			i = 0;
#line 444 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp2_ = TRUE;
#line 444 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			while (TRUE) {
#line 2860 "tracker-result-store.c"
				gboolean _tmp3_;
				gint _tmp5_;
				GPtrArray* _tmp6_;
				gint _tmp7_;
				gint _tmp8_;
				GPtrArray* _tmp9_;
				gint _tmp10_;
				gconstpointer _tmp11_ = NULL;
				TrackerResultStoreCategoryNode* _tmp12_;
				TrackerResultStoreCategoryNode* _tmp13_;
				GtkTreeIter _tmp14_;
				void* _tmp15_;
#line 444 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tmp3_ = _tmp2_;
#line 444 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				if (!_tmp3_) {
#line 2877 "tracker-result-store.c"
					gint _tmp4_;
#line 444 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					_tmp4_ = i;
#line 444 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					i = _tmp4_ + 1;
#line 2883 "tracker-result-store.c"
				}
#line 444 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tmp2_ = FALSE;
#line 444 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tmp5_ = i;
#line 444 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tmp6_ = self->priv->categories;
#line 444 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tmp7_ = g_ptr_array_get_length (_tmp6_);
#line 444 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tmp8_ = _tmp7_;
#line 444 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				if (!(_tmp5_ < _tmp8_)) {
#line 444 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					break;
#line 2899 "tracker-result-store.c"
				}
#line 445 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tmp9_ = self->priv->categories;
#line 445 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tmp10_ = i;
#line 445 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tmp11_ = g_ptr_array_index (_tmp9_, (guint) _tmp10_);
#line 445 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tmp12_ = _tracker_result_store_category_node_ref0 ((TrackerResultStoreCategoryNode*) _tmp11_);
#line 445 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tracker_result_store_category_node_unref0 (cat);
#line 445 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				cat = _tmp12_;
#line 447 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tmp13_ = cat;
#line 447 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tmp14_ = *iter;
#line 447 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tmp15_ = _tmp14_.user_data;
#line 447 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				if (_tmp13_ == _tmp15_) {
#line 2921 "tracker-result-store.c"
					GtkTreePath* _tmp16_;
					gint _tmp17_;
#line 448 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					_tmp16_ = path;
#line 448 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					_tmp17_ = i;
#line 448 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					gtk_tree_path_append_index (_tmp16_, _tmp17_);
#line 449 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					break;
#line 2932 "tracker-result-store.c"
				}
			}
		}
	}
#line 454 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp18_ = *iter;
#line 454 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp19_ = _tmp18_.user_data2;
#line 454 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	if (_tmp19_ != NULL) {
#line 2943 "tracker-result-store.c"
		GtkTreePath* _tmp20_;
		GtkTreeIter _tmp21_;
		void* _tmp22_;
#line 455 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp20_ = path;
#line 455 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp21_ = *iter;
#line 455 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp22_ = _tmp21_.user_data3;
#line 455 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		gtk_tree_path_append_index (_tmp20_, (gint) ((glong) _tmp22_));
#line 2955 "tracker-result-store.c"
	}
#line 458 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	result = path;
#line 458 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tracker_result_store_category_node_unref0 (cat);
#line 458 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	return result;
#line 2963 "tracker-result-store.c"
}


static void tracker_result_store_fetch_thumbnail_data_free (gpointer _data) {
	TrackerResultStoreFetchThumbnailData* _data_;
	_data_ = _data;
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_g_object_unref0 (_data_->self);
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	g_slice_free (TrackerResultStoreFetchThumbnailData, _data_);
#line 2974 "tracker-result-store.c"
}


static void tracker_result_store_fetch_thumbnail (TrackerResultStore* self, GtkTreeIter* iter, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerResultStoreFetchThumbnailData* _data_;
	TrackerResultStore* _tmp0_;
	GtkTreeIter _tmp1_;
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_data_ = g_slice_new0 (TrackerResultStoreFetchThumbnailData);
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_result_store_fetch_thumbnail);
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_result_store_fetch_thumbnail_data_free);
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_data_->self = _tmp0_;
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp1_ = *iter;
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_data_->iter = _tmp1_;
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	tracker_result_store_fetch_thumbnail_co (_data_);
#line 2998 "tracker-result-store.c"
}


static void tracker_result_store_fetch_thumbnail_finish (TrackerResultStore* self, GAsyncResult* _res_) {
	TrackerResultStoreFetchThumbnailData* _data_;
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 3006 "tracker-result-store.c"
}


static void tracker_result_store_fetch_thumbnail_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerResultStoreFetchThumbnailData* _data_;
#line 474 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_data_ = _user_data_;
#line 474 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_data_->_source_object_ = source_object;
#line 474 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_data_->_res_ = _res_;
#line 474 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	tracker_result_store_fetch_thumbnail_co (_data_);
#line 3020 "tracker-result-store.c"
}


static gboolean tracker_result_store_fetch_thumbnail_co (TrackerResultStoreFetchThumbnailData* _data_) {
#line 461 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	switch (_data_->_state_) {
#line 461 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		case 0:
#line 3029 "tracker-result-store.c"
		goto _state_0;
#line 461 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		case 1:
#line 3033 "tracker-result-store.c"
		goto _state_1;
		default:
#line 461 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		g_assert_not_reached ();
#line 3038 "tracker-result-store.c"
	}
	_state_0:
#line 466 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_data_->pixbuf = NULL;
#line 468 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_data_->_tmp0_ = _data_->iter;
#line 468 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_data_->_tmp1_ = _data_->_tmp0_.user_data2;
#line 468 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_data_->_result_ = _data_->_tmp1_;
#line 471 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_data_->_tmp2_ = _data_->_result_;
#line 471 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_data_->_tmp3_ = (*_data_->_tmp2_).values;
#line 471 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_data_->_tmp3__length1 = (*_data_->_tmp2_).values_length1;
#line 471 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_data_->_tmp4_ = _data_->_tmp3_[1];
#line 471 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_data_->_tmp5_ = NULL;
#line 471 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_data_->_tmp5_ = g_file_new_for_uri (_data_->_tmp4_);
#line 471 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_g_object_unref0 (_data_->file);
#line 471 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_data_->file = _data_->_tmp5_;
#line 3065 "tracker-result-store.c"
	{
#line 474 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp6_ = _data_->file;
#line 474 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp7_ = _data_->self->priv->cancellable;
#line 474 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_state_ = 1;
#line 474 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		g_file_query_info_async (_data_->_tmp6_, "thumbnail::path,standard::icon", G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, _data_->_tmp7_, tracker_result_store_fetch_thumbnail_ready, _data_);
#line 474 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		return FALSE;
#line 3077 "tracker-result-store.c"
		_state_1:
#line 474 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp8_ = NULL;
#line 474 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp8_ = g_file_query_info_finish (_data_->_tmp6_, _data_->_res_, &_data_->_inner_error_);
#line 474 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp9_ = _data_->_tmp8_;
#line 474 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		if (_data_->_inner_error_ != NULL) {
#line 3087 "tracker-result-store.c"
			goto __catch9_g_error;
		}
#line 474 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_g_object_unref0 (_data_->info);
#line 474 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->info = _data_->_tmp9_;
#line 3094 "tracker-result-store.c"
	}
	goto __finally9;
	__catch9_g_error:
	{
#line 473 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->ie = _data_->_inner_error_;
#line 473 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_inner_error_ = NULL;
#line 479 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp10_ = _data_->ie;
#line 479 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp11_ = _data_->_tmp10_->message;
#line 479 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		g_warning ("tracker-result-store.vala:479: Could not get thumbnail: %s", _data_->_tmp11_);
#line 480 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_g_error_free0 (_data_->ie);
#line 480 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_g_object_unref0 (_data_->pixbuf);
#line 480 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_g_free0 (_data_->thumb_path);
#line 480 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_g_object_unref0 (_data_->info);
#line 480 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_g_object_unref0 (_data_->file);
#line 480 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		if (_data_->_state_ == 0) {
#line 480 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3123 "tracker-result-store.c"
		} else {
#line 480 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 3127 "tracker-result-store.c"
		}
#line 480 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		g_object_unref (_data_->_async_result);
#line 480 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		return FALSE;
#line 3133 "tracker-result-store.c"
	}
	__finally9:
#line 473 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	if (_data_->_inner_error_ != NULL) {
#line 473 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_g_object_unref0 (_data_->pixbuf);
#line 473 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_g_free0 (_data_->thumb_path);
#line 473 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_g_object_unref0 (_data_->info);
#line 473 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_g_object_unref0 (_data_->file);
#line 473 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 473 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		g_clear_error (&_data_->_inner_error_);
#line 473 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		return FALSE;
#line 3152 "tracker-result-store.c"
	}
#line 483 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_data_->_tmp12_ = _data_->info;
#line 483 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_data_->_tmp13_ = NULL;
#line 483 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_data_->_tmp13_ = g_file_info_get_attribute_byte_string (_data_->_tmp12_, "thumbnail::path");
#line 483 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_data_->_tmp14_ = g_strdup (_data_->_tmp13_);
#line 483 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_g_free0 (_data_->thumb_path);
#line 483 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_data_->thumb_path = _data_->_tmp14_;
#line 3166 "tracker-result-store.c"
	{
#line 486 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp15_ = _data_->thumb_path;
#line 486 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		if (_data_->_tmp15_ != NULL) {
#line 487 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_data_->_tmp16_ = _data_->thumb_path;
#line 487 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_data_->_tmp17_ = _data_->self->priv->_icon_size;
#line 487 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_data_->_tmp18_ = _data_->self->priv->_icon_size;
#line 487 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_data_->_tmp19_ = gdk_pixbuf_new_from_file_at_size (_data_->_tmp16_, _data_->_tmp17_, _data_->_tmp18_, &_data_->_inner_error_);
#line 487 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_data_->_tmp20_ = _data_->_tmp19_;
#line 487 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			if (_data_->_inner_error_ != NULL) {
#line 3184 "tracker-result-store.c"
				goto __catch10_g_error;
			}
#line 487 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_g_object_unref0 (_data_->pixbuf);
#line 487 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_data_->pixbuf = _data_->_tmp20_;
#line 3191 "tracker-result-store.c"
		} else {
#line 492 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_data_->_tmp21_ = _data_->info;
#line 492 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_data_->_tmp22_ = NULL;
#line 492 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_data_->_tmp22_ = g_file_info_get_attribute_object (_data_->_tmp21_, "standard::icon");
#line 492 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_data_->_tmp23_ = _g_object_ref0 (G_ICON (_data_->_tmp22_));
#line 492 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_g_object_unref0 (_data_->icon);
#line 492 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_data_->icon = _data_->_tmp23_;
#line 494 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_data_->_tmp24_ = _data_->icon;
#line 494 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			if (_data_->_tmp24_ == NULL) {
#line 495 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_gtk_icon_info_free0 (_data_->icon_info);
#line 495 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_g_object_unref0 (_data_->icon);
#line 495 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_g_object_unref0 (_data_->pixbuf);
#line 495 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_g_free0 (_data_->thumb_path);
#line 495 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_g_object_unref0 (_data_->info);
#line 495 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_g_object_unref0 (_data_->file);
#line 495 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				if (_data_->_state_ == 0) {
#line 495 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3225 "tracker-result-store.c"
				} else {
#line 495 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					g_simple_async_result_complete (_data_->_async_result);
#line 3229 "tracker-result-store.c"
				}
#line 495 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				g_object_unref (_data_->_async_result);
#line 495 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				return FALSE;
#line 3235 "tracker-result-store.c"
			}
#line 498 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_data_->_tmp25_ = NULL;
#line 498 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_data_->_tmp25_ = gdk_screen_get_default ();
#line 498 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_data_->_tmp26_ = NULL;
#line 498 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_data_->_tmp26_ = gtk_icon_theme_get_for_screen (_data_->_tmp25_);
#line 498 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_data_->_tmp27_ = _g_object_ref0 (_data_->_tmp26_);
#line 498 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_data_->theme = _data_->_tmp27_;
#line 499 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_data_->_tmp28_ = _data_->theme;
#line 499 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_data_->_tmp29_ = _data_->icon;
#line 499 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_data_->_tmp30_ = _data_->self->priv->_icon_size;
#line 499 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_data_->_tmp31_ = NULL;
#line 499 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_data_->_tmp31_ = gtk_icon_theme_lookup_by_gicon (_data_->_tmp28_, _data_->_tmp29_, _data_->_tmp30_, 0);
#line 499 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_gtk_icon_info_free0 (_data_->icon_info);
#line 499 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_data_->icon_info = _data_->_tmp31_;
#line 501 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_data_->_tmp32_ = _data_->icon_info;
#line 501 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			if (_data_->_tmp32_ == NULL) {
#line 502 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_g_object_unref0 (_data_->theme);
#line 502 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_gtk_icon_info_free0 (_data_->icon_info);
#line 502 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_g_object_unref0 (_data_->icon);
#line 502 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_g_object_unref0 (_data_->pixbuf);
#line 502 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_g_free0 (_data_->thumb_path);
#line 502 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_g_object_unref0 (_data_->info);
#line 502 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_g_object_unref0 (_data_->file);
#line 502 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				if (_data_->_state_ == 0) {
#line 502 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3285 "tracker-result-store.c"
				} else {
#line 502 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					g_simple_async_result_complete (_data_->_async_result);
#line 3289 "tracker-result-store.c"
				}
#line 502 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				g_object_unref (_data_->_async_result);
#line 502 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				return FALSE;
#line 3295 "tracker-result-store.c"
			}
#line 505 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_data_->_tmp33_ = _data_->icon_info;
#line 505 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_data_->_tmp34_ = NULL;
#line 505 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_data_->_tmp34_ = gtk_icon_info_load_icon (_data_->_tmp33_, &_data_->_inner_error_);
#line 505 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_data_->_tmp35_ = _data_->_tmp34_;
#line 505 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			if (_data_->_inner_error_ != NULL) {
#line 505 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_g_object_unref0 (_data_->theme);
#line 505 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_gtk_icon_info_free0 (_data_->icon_info);
#line 505 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_g_object_unref0 (_data_->icon);
#line 3313 "tracker-result-store.c"
				goto __catch10_g_error;
			}
#line 505 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_g_object_unref0 (_data_->pixbuf);
#line 505 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_data_->pixbuf = _data_->_tmp35_;
#line 486 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_g_object_unref0 (_data_->theme);
#line 486 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_gtk_icon_info_free0 (_data_->icon_info);
#line 486 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_g_object_unref0 (_data_->icon);
#line 3326 "tracker-result-store.c"
		}
	}
	goto __finally10;
	__catch10_g_error:
	{
#line 485 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->e = _data_->_inner_error_;
#line 485 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_inner_error_ = NULL;
#line 508 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp36_ = _data_->e;
#line 508 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp37_ = _data_->_tmp36_->message;
#line 508 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		g_warning ("tracker-result-store.vala:508: Could not get icon pixbuf: %s\n", _data_->_tmp37_);
#line 485 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_g_error_free0 (_data_->e);
#line 3344 "tracker-result-store.c"
	}
	__finally10:
#line 485 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	if (_data_->_inner_error_ != NULL) {
#line 485 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_g_object_unref0 (_data_->pixbuf);
#line 485 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_g_free0 (_data_->thumb_path);
#line 485 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_g_object_unref0 (_data_->info);
#line 485 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_g_object_unref0 (_data_->file);
#line 485 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 485 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		g_clear_error (&_data_->_inner_error_);
#line 485 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		return FALSE;
#line 3363 "tracker-result-store.c"
	}
#line 511 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_data_->_tmp38_ = _data_->pixbuf;
#line 511 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	if (_data_->_tmp38_ != NULL) {
#line 514 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp39_ = _data_->_result_;
#line 514 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp40_ = _data_->pixbuf;
#line 514 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp41_ = _g_object_ref0 (_data_->_tmp40_);
#line 514 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_g_object_unref0 ((*_data_->_tmp39_).pixbuf);
#line 514 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		(*_data_->_tmp39_).pixbuf = _data_->_tmp41_;
#line 515 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp42_ = _data_->iter;
#line 515 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp43_ = NULL;
#line 515 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp43_ = gtk_tree_model_get_path ((GtkTreeModel*) _data_->self, &_data_->_tmp42_);
#line 515 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_gtk_tree_path_free0 (_data_->path);
#line 515 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->path = _data_->_tmp43_;
#line 516 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp44_ = _data_->path;
#line 516 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_data_->_tmp45_ = _data_->iter;
#line 516 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		gtk_tree_model_row_changed ((GtkTreeModel*) _data_->self, _data_->_tmp44_, &_data_->_tmp45_);
#line 511 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_gtk_tree_path_free0 (_data_->path);
#line 3397 "tracker-result-store.c"
	}
#line 461 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_g_object_unref0 (_data_->pixbuf);
#line 461 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_g_free0 (_data_->thumb_path);
#line 461 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_g_object_unref0 (_data_->info);
#line 461 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_g_object_unref0 (_data_->file);
#line 461 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	if (_data_->_state_ == 0) {
#line 461 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3411 "tracker-result-store.c"
	} else {
#line 461 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 3415 "tracker-result-store.c"
	}
#line 461 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	g_object_unref (_data_->_async_result);
#line 461 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	return FALSE;
#line 3421 "tracker-result-store.c"
}


static void tracker_result_store_real_get_value (GtkTreeModel* base, GtkTreeIter* iter, gint column, GValue* value) {
	TrackerResultStore * self;
	GValue _vala_value = {0};
	TrackerResultStoreCategoryNode* cat = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GtkTreeIter _tmp3_;
	void* _tmp4_;
	TrackerResultStoreCategoryNode* _tmp5_;
	gint _tmp6_;
	GType _tmp7_ = 0UL;
	gint _tmp8_;
	gint _tmp9_;
	GtkTreeIter _tmp12_;
	void* _tmp13_;
#line 520 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	self = (TrackerResultStore*) base;
#line 520 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	g_return_if_fail (iter != NULL);
#line 523 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp0_ = column;
#line 523 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp1_ = self->priv->n_columns;
#line 523 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp2_ = self->priv->n_extra_columns;
#line 523 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	if (_tmp0_ >= (_tmp1_ + _tmp2_)) {
#line 524 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tracker_result_store_category_node_unref0 (cat);
#line 524 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		if (value) {
#line 524 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			*value = _vala_value;
#line 3459 "tracker-result-store.c"
		} else {
#line 524 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			G_IS_VALUE (&_vala_value) ? (g_value_unset (&_vala_value), NULL) : NULL;
#line 3463 "tracker-result-store.c"
		}
#line 524 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		return;
#line 3467 "tracker-result-store.c"
	}
#line 527 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp3_ = *iter;
#line 527 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp4_ = _tmp3_.user_data;
#line 527 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp5_ = _tracker_result_store_category_node_ref0 (TRACKER_RESULT_STORE_CATEGORY_NODE (_tmp4_));
#line 527 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tracker_result_store_category_node_unref0 (cat);
#line 527 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	cat = _tmp5_;
#line 528 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp6_ = column;
#line 528 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp7_ = gtk_tree_model_get_column_type ((GtkTreeModel*) self, _tmp6_);
#line 528 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	g_value_init (&_vala_value, _tmp7_);
#line 530 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp8_ = column;
#line 530 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp9_ = self->priv->n_columns;
#line 530 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	if (_tmp8_ == (_tmp9_ + 1)) {
#line 3491 "tracker-result-store.c"
		TrackerResultStoreCategoryNode* _tmp10_;
		TrackerQueryType _tmp11_;
#line 532 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp10_ = cat;
#line 532 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp11_ = _tmp10_->type;
#line 532 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		g_value_set_enum (&_vala_value, (gint) _tmp11_);
#line 533 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tracker_result_store_category_node_unref0 (cat);
#line 533 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		if (value) {
#line 533 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			*value = _vala_value;
#line 3506 "tracker-result-store.c"
		} else {
#line 533 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			G_IS_VALUE (&_vala_value) ? (g_value_unset (&_vala_value), NULL) : NULL;
#line 3510 "tracker-result-store.c"
		}
#line 533 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		return;
#line 3514 "tracker-result-store.c"
	}
#line 536 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp12_ = *iter;
#line 536 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp13_ = _tmp12_.user_data2;
#line 536 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	if (_tmp13_ == NULL) {
#line 3522 "tracker-result-store.c"
		gint _tmp14_;
		gint _tmp15_;
#line 537 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp14_ = column;
#line 537 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp15_ = self->priv->n_columns;
#line 537 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		if (_tmp14_ == _tmp15_) {
#line 3531 "tracker-result-store.c"
			GdkPixbuf* pixbuf = NULL;
			TrackerResultStoreCategoryNode* _tmp16_;
			GdkPixbuf* _tmp17_;
			GdkPixbuf* _tmp18_;
			GdkPixbuf* _tmp19_;
			GdkPixbuf* _tmp50_;
#line 540 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp16_ = cat;
#line 540 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp17_ = _tmp16_->pixbuf;
#line 540 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp18_ = _g_object_ref0 (_tmp17_);
#line 540 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_g_object_unref0 (pixbuf);
#line 540 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			pixbuf = _tmp18_;
#line 542 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp19_ = pixbuf;
#line 542 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			if (_tmp19_ == NULL) {
#line 3552 "tracker-result-store.c"
				GdkScreen* _tmp20_ = NULL;
				GtkIconTheme* _tmp21_ = NULL;
				GtkIconTheme* _tmp22_;
				GtkIconTheme* theme;
				gint _tmp23_;
				gint size;
				TrackerResultStoreCategoryNode* _tmp24_;
				TrackerQueryType _tmp25_;
#line 543 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tmp20_ = gdk_screen_get_default ();
#line 543 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tmp21_ = gtk_icon_theme_get_for_screen (_tmp20_);
#line 543 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tmp22_ = _g_object_ref0 (_tmp21_);
#line 543 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				theme = _tmp22_;
#line 544 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tmp23_ = self->priv->_icon_size;
#line 544 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				size = _tmp23_;
#line 546 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tmp24_ = cat;
#line 546 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tmp25_ = _tmp24_->type;
#line 546 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				switch (_tmp25_) {
#line 546 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					case TRACKER_QUERY_TYPE_APPLICATIONS:
#line 3581 "tracker-result-store.c"
					{
						GtkIconTheme* _tmp26_;
						gint _tmp27_;
						GdkPixbuf* _tmp28_ = NULL;
#line 548 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
						_tmp26_ = theme;
#line 548 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
						_tmp27_ = size;
#line 548 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
						_tmp28_ = tracker_pixbuf_new_from_name (_tmp26_, "package-x-generic", _tmp27_);
#line 548 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
						_g_object_unref0 (pixbuf);
#line 548 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
						pixbuf = _tmp28_;
#line 549 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
						break;
#line 3598 "tracker-result-store.c"
					}
#line 546 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					case TRACKER_QUERY_TYPE_MUSIC:
#line 3602 "tracker-result-store.c"
					{
						GtkIconTheme* _tmp29_;
						gint _tmp30_;
						GdkPixbuf* _tmp31_ = NULL;
#line 551 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
						_tmp29_ = theme;
#line 551 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
						_tmp30_ = size;
#line 551 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
						_tmp31_ = tracker_pixbuf_new_from_name (_tmp29_, "audio-x-generic", _tmp30_);
#line 551 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
						_g_object_unref0 (pixbuf);
#line 551 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
						pixbuf = _tmp31_;
#line 552 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
						break;
#line 3619 "tracker-result-store.c"
					}
#line 546 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					case TRACKER_QUERY_TYPE_IMAGES:
#line 3623 "tracker-result-store.c"
					{
						GtkIconTheme* _tmp32_;
						gint _tmp33_;
						GdkPixbuf* _tmp34_ = NULL;
#line 554 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
						_tmp32_ = theme;
#line 554 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
						_tmp33_ = size;
#line 554 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
						_tmp34_ = tracker_pixbuf_new_from_name (_tmp32_, "image-x-generic", _tmp33_);
#line 554 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
						_g_object_unref0 (pixbuf);
#line 554 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
						pixbuf = _tmp34_;
#line 555 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
						break;
#line 3640 "tracker-result-store.c"
					}
#line 546 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					case TRACKER_QUERY_TYPE_VIDEOS:
#line 3644 "tracker-result-store.c"
					{
						GtkIconTheme* _tmp35_;
						gint _tmp36_;
						GdkPixbuf* _tmp37_ = NULL;
#line 557 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
						_tmp35_ = theme;
#line 557 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
						_tmp36_ = size;
#line 557 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
						_tmp37_ = tracker_pixbuf_new_from_name (_tmp35_, "video-x-generic", _tmp36_);
#line 557 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
						_g_object_unref0 (pixbuf);
#line 557 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
						pixbuf = _tmp37_;
#line 558 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
						break;
#line 3661 "tracker-result-store.c"
					}
#line 546 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					case TRACKER_QUERY_TYPE_DOCUMENTS:
#line 3665 "tracker-result-store.c"
					{
						GtkIconTheme* _tmp38_;
						gint _tmp39_;
						GdkPixbuf* _tmp40_ = NULL;
#line 560 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
						_tmp38_ = theme;
#line 560 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
						_tmp39_ = size;
#line 560 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
						_tmp40_ = tracker_pixbuf_new_from_name (_tmp38_, "x-office-presentation", _tmp39_);
#line 560 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
						_g_object_unref0 (pixbuf);
#line 560 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
						pixbuf = _tmp40_;
#line 561 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
						break;
#line 3682 "tracker-result-store.c"
					}
#line 546 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					case TRACKER_QUERY_TYPE_MAIL:
#line 3686 "tracker-result-store.c"
					{
						GtkIconTheme* _tmp41_;
						gint _tmp42_;
						GdkPixbuf* _tmp43_ = NULL;
#line 563 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
						_tmp41_ = theme;
#line 563 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
						_tmp42_ = size;
#line 563 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
						_tmp43_ = tracker_pixbuf_new_from_name (_tmp41_, "emblem-mail", _tmp42_);
#line 563 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
						_g_object_unref0 (pixbuf);
#line 563 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
						pixbuf = _tmp43_;
#line 564 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
						break;
#line 3703 "tracker-result-store.c"
					}
#line 546 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					case TRACKER_QUERY_TYPE_FOLDERS:
#line 3707 "tracker-result-store.c"
					{
						GtkIconTheme* _tmp44_;
						gint _tmp45_;
						GdkPixbuf* _tmp46_ = NULL;
#line 566 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
						_tmp44_ = theme;
#line 566 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
						_tmp45_ = size;
#line 566 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
						_tmp46_ = tracker_pixbuf_new_from_name (_tmp44_, "folder", _tmp45_);
#line 566 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
						_g_object_unref0 (pixbuf);
#line 566 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
						pixbuf = _tmp46_;
#line 567 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
						break;
#line 3724 "tracker-result-store.c"
					}
#line 546 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					case TRACKER_QUERY_TYPE_BOOKMARKS:
#line 3728 "tracker-result-store.c"
					{
						GtkIconTheme* _tmp47_;
						gint _tmp48_;
						GdkPixbuf* _tmp49_ = NULL;
#line 569 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
						_tmp47_ = theme;
#line 569 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
						_tmp48_ = size;
#line 569 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
						_tmp49_ = tracker_pixbuf_new_from_name (_tmp47_, "web-browser", _tmp48_);
#line 569 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
						_g_object_unref0 (pixbuf);
#line 569 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
						pixbuf = _tmp49_;
#line 570 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
						break;
#line 3745 "tracker-result-store.c"
					}
					default:
#line 546 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					break;
#line 3750 "tracker-result-store.c"
				}
#line 542 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_g_object_unref0 (theme);
#line 3754 "tracker-result-store.c"
			}
#line 574 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp50_ = pixbuf;
#line 574 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			g_value_set_object (&_vala_value, (GObject*) _tmp50_);
#line 537 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_g_object_unref0 (pixbuf);
#line 3762 "tracker-result-store.c"
		}
	} else {
		TrackerResultStoreResultNode* _result_ = NULL;
		gint n_node = 0;
		GtkTreeIter _tmp51_;
		void* _tmp52_;
		GtkTreeIter _tmp53_;
		void* _tmp54_;
		TrackerResultStoreResultNode* _tmp55_;
		gchar** _tmp56_;
		gint _tmp56__length1;
		const gchar* _tmp57_;
#line 580 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp51_ = *iter;
#line 580 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp52_ = _tmp51_.user_data2;
#line 580 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_result_ = _tmp52_;
#line 581 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp53_ = *iter;
#line 581 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp54_ = _tmp53_.user_data3;
#line 581 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		n_node = (gint) ((glong) _tmp54_);
#line 583 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp55_ = _result_;
#line 583 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp56_ = (*_tmp55_).values;
#line 583 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp56__length1 = (*_tmp55_).values_length1;
#line 583 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp57_ = _tmp56_[0];
#line 583 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		if (_tmp57_ != NULL) {
#line 3797 "tracker-result-store.c"
			gint _tmp58_;
			gint _tmp59_;
#line 584 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp58_ = column;
#line 584 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp59_ = self->priv->n_columns;
#line 584 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			if (_tmp58_ == _tmp59_) {
#line 3806 "tracker-result-store.c"
				TrackerResultStoreResultNode* _tmp60_;
				GdkPixbuf* _tmp61_;
#line 585 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tmp60_ = _result_;
#line 585 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tmp61_ = (*_tmp60_).pixbuf;
#line 585 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				if (_tmp61_ != NULL) {
#line 3815 "tracker-result-store.c"
					TrackerResultStoreResultNode* _tmp62_;
					GdkPixbuf* _tmp63_;
#line 586 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					_tmp62_ = _result_;
#line 586 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					_tmp63_ = (*_tmp62_).pixbuf;
#line 586 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					g_value_set_object (&_vala_value, (GObject*) _tmp63_);
#line 3824 "tracker-result-store.c"
				} else {
					TrackerResultStoreQueryData* _tmp64_;
					gint _tmp64__length1;
#line 587 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					_tmp64_ = self->priv->queries;
#line 587 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					_tmp64__length1 = self->priv->queries_length1;
#line 587 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					if (_tmp64__length1 == 1) {
#line 3834 "tracker-result-store.c"
						GtkTreeIter _tmp65_;
#line 588 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
						_tmp65_ = *iter;
#line 588 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
						tracker_result_store_fetch_thumbnail (self, &_tmp65_, NULL, NULL);
#line 3840 "tracker-result-store.c"
					}
				}
			} else {
				TrackerResultStoreResultNode* _tmp66_;
				gchar** _tmp67_;
				gint _tmp67__length1;
				gint _tmp68_;
				const gchar* _tmp69_;
#line 591 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tmp66_ = _result_;
#line 591 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tmp67_ = (*_tmp66_).values;
#line 591 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tmp67__length1 = (*_tmp66_).values_length1;
#line 591 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tmp68_ = column;
#line 591 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tmp69_ = _tmp67_[_tmp68_];
#line 591 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				g_value_set_string (&_vala_value, _tmp69_);
#line 3861 "tracker-result-store.c"
			}
		} else {
			gint _tmp70_;
			gint _tmp71_;
			TrackerResultStoreCategoryNode* _tmp72_;
			gint _tmp73_;
#line 594 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp70_ = n_node;
#line 594 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			n_node = _tmp70_ / 100;
#line 595 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp71_ = n_node;
#line 595 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			n_node = _tmp71_ * 100;
#line 597 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp72_ = cat;
#line 597 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp73_ = n_node;
#line 597 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			tracker_result_store_add_operation (self, _tmp72_, _tmp73_);
#line 3882 "tracker-result-store.c"
		}
	}
#line 520 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tracker_result_store_category_node_unref0 (cat);
#line 520 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	if (value) {
#line 520 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		*value = _vala_value;
#line 3891 "tracker-result-store.c"
	} else {
#line 520 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		G_IS_VALUE (&_vala_value) ? (g_value_unset (&_vala_value), NULL) : NULL;
#line 3895 "tracker-result-store.c"
	}
}


static gboolean tracker_result_store_real_iter_children (GtkTreeModel* base, GtkTreeIter* iter, GtkTreeIter* parent) {
	TrackerResultStore * self;
	GtkTreeIter _vala_iter = {0};
	gboolean result = FALSE;
	TrackerResultStoreCategoryNode* cat = NULL;
	GtkTreeIter* _tmp0_;
	GtkTreeIter* _tmp18_;
	void* _tmp19_;
	GtkTreeIter* _tmp20_;
	void* _tmp21_;
	TrackerResultStoreCategoryNode* _tmp22_;
	TrackerResultStoreCategoryNode* _tmp23_;
	TrackerResultStoreResultNode* _tmp24_;
	gint _tmp24__length1;
	gint _tmp25_;
	TrackerResultStoreCategoryNode* _tmp26_;
	TrackerResultStoreCategoryNode* _tmp27_;
	TrackerResultStoreResultNode* _tmp28_;
	gint _tmp28__length1;
	void* _tmp29_ = NULL;
#line 602 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	self = (TrackerResultStore*) base;
#line 605 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp0_ = parent;
#line 605 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	if (_tmp0_ == NULL) {
#line 3926 "tracker-result-store.c"
		GPtrArray* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		TrackerResultStoreQueryData* _tmp4_;
		gint _tmp4__length1;
#line 606 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp1_ = self->priv->categories;
#line 606 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp2_ = g_ptr_array_get_length (_tmp1_);
#line 606 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp3_ = _tmp2_;
#line 606 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		if (_tmp3_ == 0) {
#line 607 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_vala_iter.stamp = 0;
#line 608 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			result = FALSE;
#line 608 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tracker_result_store_category_node_unref0 (cat);
#line 608 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			if (iter) {
#line 608 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				*iter = _vala_iter;
#line 3950 "tracker-result-store.c"
			}
#line 608 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			return result;
#line 3954 "tracker-result-store.c"
		}
#line 611 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp4_ = self->priv->queries;
#line 611 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp4__length1 = self->priv->queries_length1;
#line 611 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		if (_tmp4__length1 > 1) {
#line 3962 "tracker-result-store.c"
			gint i = 0;
			gint _tmp5_ = 0;
			GPtrArray* _tmp6_;
			gint _tmp7_;
			gconstpointer _tmp8_ = NULL;
			TrackerResultStoreCategoryNode* _tmp9_;
			gint _tmp10_;
			TrackerResultStoreCategoryNode* _tmp11_;
#line 614 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp5_ = tracker_result_store_find_nth_category_index (self, NULL, 0);
#line 614 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			i = _tmp5_;
#line 615 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp6_ = self->priv->categories;
#line 615 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp7_ = i;
#line 615 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp8_ = g_ptr_array_index (_tmp6_, (guint) _tmp7_);
#line 615 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp9_ = _tracker_result_store_category_node_ref0 ((TrackerResultStoreCategoryNode*) _tmp8_);
#line 615 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tracker_result_store_category_node_unref0 (cat);
#line 615 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			cat = _tmp9_;
#line 616 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp10_ = self->priv->timestamp;
#line 616 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_vala_iter.stamp = _tmp10_;
#line 617 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp11_ = cat;
#line 617 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_vala_iter.user_data = _tmp11_;
#line 618 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			result = TRUE;
#line 618 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tracker_result_store_category_node_unref0 (cat);
#line 618 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			if (iter) {
#line 618 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				*iter = _vala_iter;
#line 4003 "tracker-result-store.c"
			}
#line 618 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			return result;
#line 4007 "tracker-result-store.c"
		} else {
			gint _tmp12_;
			GPtrArray* _tmp13_;
			gconstpointer _tmp14_ = NULL;
			TrackerResultStoreCategoryNode* _tmp15_;
			TrackerResultStoreResultNode* _tmp16_;
			gint _tmp16__length1;
			void* _tmp17_ = NULL;
#line 620 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp12_ = self->priv->timestamp;
#line 620 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_vala_iter.stamp = _tmp12_;
#line 621 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp13_ = self->priv->categories;
#line 621 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp14_ = g_ptr_array_index (_tmp13_, (guint) 0);
#line 621 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_vala_iter.user_data = (TrackerResultStoreCategoryNode*) _tmp14_;
#line 622 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp15_ = cat;
#line 622 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp16_ = _tmp15_->results;
#line 622 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp16__length1 = _tmp15_->results_length1;
#line 622 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_vala_iter.user_data2 = &_tmp16_[0];
#line 623 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp17_ = GINT_TO_POINTER (0);
#line 623 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_vala_iter.user_data3 = _tmp17_;
#line 624 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			result = TRUE;
#line 624 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tracker_result_store_category_node_unref0 (cat);
#line 624 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			if (iter) {
#line 624 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				*iter = _vala_iter;
#line 4046 "tracker-result-store.c"
			}
#line 624 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			return result;
#line 4050 "tracker-result-store.c"
		}
	}
#line 628 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp18_ = parent;
#line 628 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp19_ = (*_tmp18_).user_data2;
#line 628 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	if (_tmp19_ != NULL) {
#line 629 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_vala_iter.stamp = 0;
#line 630 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		result = FALSE;
#line 630 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tracker_result_store_category_node_unref0 (cat);
#line 630 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		if (iter) {
#line 630 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			*iter = _vala_iter;
#line 4069 "tracker-result-store.c"
		}
#line 630 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		return result;
#line 4073 "tracker-result-store.c"
	}
#line 633 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp20_ = parent;
#line 633 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp21_ = (*_tmp20_).user_data;
#line 633 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp22_ = _tracker_result_store_category_node_ref0 (TRACKER_RESULT_STORE_CATEGORY_NODE (_tmp21_));
#line 633 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tracker_result_store_category_node_unref0 (cat);
#line 633 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	cat = _tmp22_;
#line 635 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp23_ = cat;
#line 635 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp24_ = _tmp23_->results;
#line 635 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp24__length1 = _tmp23_->results_length1;
#line 635 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	if (_tmp24__length1 <= 0) {
#line 636 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_vala_iter.stamp = 0;
#line 637 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		result = FALSE;
#line 637 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tracker_result_store_category_node_unref0 (cat);
#line 637 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		if (iter) {
#line 637 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			*iter = _vala_iter;
#line 4103 "tracker-result-store.c"
		}
#line 637 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		return result;
#line 4107 "tracker-result-store.c"
	}
#line 640 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp25_ = self->priv->timestamp;
#line 640 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_vala_iter.stamp = _tmp25_;
#line 641 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp26_ = cat;
#line 641 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_vala_iter.user_data = _tmp26_;
#line 642 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp27_ = cat;
#line 642 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp28_ = _tmp27_->results;
#line 642 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp28__length1 = _tmp27_->results_length1;
#line 642 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_vala_iter.user_data2 = &_tmp28_[0];
#line 643 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp29_ = GINT_TO_POINTER (0);
#line 643 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_vala_iter.user_data3 = _tmp29_;
#line 645 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	result = TRUE;
#line 645 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tracker_result_store_category_node_unref0 (cat);
#line 645 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	if (iter) {
#line 645 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		*iter = _vala_iter;
#line 4137 "tracker-result-store.c"
	}
#line 645 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	return result;
#line 4141 "tracker-result-store.c"
}


static gboolean tracker_result_store_real_iter_has_child (GtkTreeModel* base, GtkTreeIter* iter) {
	TrackerResultStore * self;
	gboolean result = FALSE;
	GtkTreeIter _tmp0_;
	void* _tmp1_;
#line 648 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	self = (TrackerResultStore*) base;
#line 648 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	g_return_val_if_fail (iter != NULL, FALSE);
#line 649 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp0_ = *iter;
#line 649 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp1_ = _tmp0_.user_data2;
#line 649 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	if (_tmp1_ == NULL) {
#line 4160 "tracker-result-store.c"
		TrackerResultStoreCategoryNode* cat = NULL;
		GtkTreeIter _tmp2_;
		void* _tmp3_;
		TrackerResultStoreCategoryNode* _tmp4_;
		TrackerResultStoreCategoryNode* _tmp5_;
		gint _tmp6_;
#line 652 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp2_ = *iter;
#line 652 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp3_ = _tmp2_.user_data;
#line 652 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp4_ = _tracker_result_store_category_node_ref0 (TRACKER_RESULT_STORE_CATEGORY_NODE (_tmp3_));
#line 652 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tracker_result_store_category_node_unref0 (cat);
#line 652 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		cat = _tmp4_;
#line 653 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp5_ = cat;
#line 653 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp6_ = _tmp5_->count;
#line 653 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		result = _tmp6_ > 0;
#line 653 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tracker_result_store_category_node_unref0 (cat);
#line 653 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		return result;
#line 4187 "tracker-result-store.c"
	}
#line 656 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	result = FALSE;
#line 656 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	return result;
#line 4193 "tracker-result-store.c"
}


static gint tracker_result_store_real_iter_n_children (GtkTreeModel* base, GtkTreeIter* iter) {
	TrackerResultStore * self;
	gint result = 0;
	GtkTreeIter* _tmp0_;
	GtkTreeIter* _tmp11_;
	void* _tmp12_;
	GtkTreeIter* _tmp13_;
	void* _tmp14_;
	TrackerResultStoreCategoryNode* _tmp15_;
	TrackerResultStoreCategoryNode* cat;
	TrackerResultStoreCategoryNode* _tmp16_;
	gint _tmp17_;
#line 659 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	self = (TrackerResultStore*) base;
#line 660 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp0_ = iter;
#line 660 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	if (_tmp0_ == NULL) {
#line 4215 "tracker-result-store.c"
		TrackerResultStoreQueryData* _tmp1_;
		gint _tmp1__length1;
#line 661 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp1_ = self->priv->queries;
#line 661 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp1__length1 = self->priv->queries_length1;
#line 661 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		if (_tmp1__length1 > 1) {
#line 4224 "tracker-result-store.c"
			GPtrArray* _tmp2_;
			gint _tmp3_;
			gint _tmp4_;
#line 662 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp2_ = self->priv->categories;
#line 662 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp3_ = g_ptr_array_get_length (_tmp2_);
#line 662 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp4_ = _tmp3_;
#line 662 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			result = _tmp4_ - 1;
#line 662 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			return result;
#line 4238 "tracker-result-store.c"
		} else {
			GPtrArray* _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
#line 663 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp5_ = self->priv->categories;
#line 663 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp6_ = g_ptr_array_get_length (_tmp5_);
#line 663 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp7_ = _tmp6_;
#line 663 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			if (_tmp7_ > 0) {
#line 4251 "tracker-result-store.c"
				GPtrArray* _tmp8_;
				gconstpointer _tmp9_ = NULL;
				gint _tmp10_;
#line 664 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tmp8_ = self->priv->categories;
#line 664 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tmp9_ = g_ptr_array_index (_tmp8_, (guint) 0);
#line 664 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tmp10_ = ((TrackerResultStoreCategoryNode*) _tmp9_)->count;
#line 664 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				result = _tmp10_;
#line 664 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				return result;
#line 4265 "tracker-result-store.c"
			} else {
#line 666 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				result = -1;
#line 666 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				return result;
#line 4271 "tracker-result-store.c"
			}
		}
	}
#line 670 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp11_ = iter;
#line 670 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp12_ = (*_tmp11_).user_data2;
#line 670 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	if (_tmp12_ != NULL) {
#line 672 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		result = -1;
#line 672 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		return result;
#line 4285 "tracker-result-store.c"
	}
#line 675 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp13_ = iter;
#line 675 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp14_ = (*_tmp13_).user_data;
#line 675 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp15_ = _tracker_result_store_category_node_ref0 (TRACKER_RESULT_STORE_CATEGORY_NODE (_tmp14_));
#line 675 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	cat = _tmp15_;
#line 677 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp16_ = cat;
#line 677 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp17_ = _tmp16_->count;
#line 677 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	result = _tmp17_;
#line 677 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tracker_result_store_category_node_unref0 (cat);
#line 677 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	return result;
#line 4305 "tracker-result-store.c"
}


static gboolean tracker_result_store_real_iter_next (GtkTreeModel* base, GtkTreeIter* iter) {
	TrackerResultStore * self;
	gboolean result = FALSE;
	TrackerResultStoreCategoryNode* cat = NULL;
	gint i = 0;
	GtkTreeIter _tmp0_;
	void* _tmp1_;
	TrackerResultStoreCategoryNode* _tmp2_;
	GtkTreeIter _tmp3_;
	void* _tmp4_;
#line 680 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	self = (TrackerResultStore*) base;
#line 680 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	g_return_val_if_fail (iter != NULL, FALSE);
#line 684 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp0_ = *iter;
#line 684 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp1_ = _tmp0_.user_data;
#line 684 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp2_ = _tracker_result_store_category_node_ref0 (TRACKER_RESULT_STORE_CATEGORY_NODE (_tmp1_));
#line 684 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tracker_result_store_category_node_unref0 (cat);
#line 684 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	cat = _tmp2_;
#line 686 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp3_ = *iter;
#line 686 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp4_ = _tmp3_.user_data2;
#line 686 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	if (_tmp4_ == NULL) {
#line 4339 "tracker-result-store.c"
		TrackerResultStoreCategoryNode* _tmp5_;
		gint _tmp6_ = 0;
		gboolean _tmp7_ = FALSE;
		gint _tmp8_;
		gboolean _tmp13_;
		gint _tmp14_;
		GPtrArray* _tmp15_;
		gint _tmp16_;
		gconstpointer _tmp17_ = NULL;
#line 687 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp5_ = cat;
#line 687 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp6_ = tracker_result_store_find_nth_category_index (self, _tmp5_, 1);
#line 687 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		i = _tmp6_;
#line 689 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp8_ = i;
#line 689 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		if (_tmp8_ < 0) {
#line 689 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp7_ = TRUE;
#line 4361 "tracker-result-store.c"
		} else {
			gint _tmp9_;
			GPtrArray* _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
#line 689 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp9_ = i;
#line 689 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp10_ = self->priv->categories;
#line 689 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp11_ = g_ptr_array_get_length (_tmp10_);
#line 689 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp12_ = _tmp11_;
#line 689 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp7_ = _tmp9_ >= _tmp12_;
#line 4377 "tracker-result-store.c"
		}
#line 689 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp13_ = _tmp7_;
#line 689 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		if (_tmp13_) {
#line 690 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			(*iter).stamp = 0;
#line 691 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			result = FALSE;
#line 691 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tracker_result_store_category_node_unref0 (cat);
#line 691 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			return result;
#line 4391 "tracker-result-store.c"
		}
#line 694 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp14_ = self->priv->timestamp;
#line 694 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		(*iter).stamp = _tmp14_;
#line 695 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp15_ = self->priv->categories;
#line 695 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp16_ = i;
#line 695 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp17_ = g_ptr_array_index (_tmp15_, (guint) _tmp16_);
#line 695 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		(*iter).user_data = (TrackerResultStoreCategoryNode*) _tmp17_;
#line 697 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		result = TRUE;
#line 697 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tracker_result_store_category_node_unref0 (cat);
#line 697 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		return result;
#line 4411 "tracker-result-store.c"
	} else {
		GtkTreeIter _tmp18_;
		void* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		TrackerResultStoreCategoryNode* _tmp22_;
		gint _tmp23_;
		TrackerResultStoreCategoryNode* _tmp24_;
		TrackerResultStoreResultNode* _tmp25_;
		gint _tmp25__length1;
		gint _tmp26_;
		gint _tmp27_;
		void* _tmp28_ = NULL;
#line 700 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp18_ = *iter;
#line 700 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp19_ = _tmp18_.user_data3;
#line 700 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		i = (gint) ((glong) _tmp19_);
#line 701 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp20_ = i;
#line 701 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		i = _tmp20_ + 1;
#line 703 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp21_ = i;
#line 703 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp22_ = cat;
#line 703 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp23_ = _tmp22_->count;
#line 703 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		if (_tmp21_ >= _tmp23_) {
#line 704 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			(*iter).stamp = 0;
#line 705 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			result = FALSE;
#line 705 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tracker_result_store_category_node_unref0 (cat);
#line 705 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			return result;
#line 4451 "tracker-result-store.c"
		}
#line 708 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp24_ = cat;
#line 708 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp25_ = _tmp24_->results;
#line 708 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp25__length1 = _tmp24_->results_length1;
#line 708 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp26_ = i;
#line 708 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		(*iter).user_data2 = &_tmp25_[_tmp26_];
#line 709 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp27_ = i;
#line 709 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp28_ = GINT_TO_POINTER (_tmp27_);
#line 709 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		(*iter).user_data3 = _tmp28_;
#line 711 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		result = TRUE;
#line 711 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tracker_result_store_category_node_unref0 (cat);
#line 711 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		return result;
#line 4475 "tracker-result-store.c"
	}
#line 680 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tracker_result_store_category_node_unref0 (cat);
#line 4479 "tracker-result-store.c"
}


static gboolean tracker_result_store_real_iter_nth_child (GtkTreeModel* base, GtkTreeIter* iter, GtkTreeIter* parent, gint n) {
	TrackerResultStore * self;
	GtkTreeIter _vala_iter = {0};
	gboolean result = FALSE;
	TrackerResultStoreCategoryNode* cat = NULL;
	GtkTreeIter* _tmp0_;
#line 715 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	self = (TrackerResultStore*) base;
#line 718 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp0_ = parent;
#line 718 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	if (_tmp0_ != NULL) {
#line 4495 "tracker-result-store.c"
		GtkTreeIter* _tmp1_;
		void* _tmp2_;
		TrackerResultStoreCategoryNode* _tmp3_;
		gint _tmp4_;
		TrackerResultStoreCategoryNode* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		TrackerResultStoreCategoryNode* _tmp8_;
		TrackerResultStoreCategoryNode* _tmp9_;
		TrackerResultStoreResultNode* _tmp10_;
		gint _tmp10__length1;
		gint _tmp11_;
		gint _tmp12_;
		void* _tmp13_ = NULL;
#line 719 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp1_ = parent;
#line 719 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp2_ = (*_tmp1_).user_data;
#line 719 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp3_ = _tracker_result_store_category_node_ref0 (TRACKER_RESULT_STORE_CATEGORY_NODE (_tmp2_));
#line 719 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tracker_result_store_category_node_unref0 (cat);
#line 719 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		cat = _tmp3_;
#line 721 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp4_ = n;
#line 721 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp5_ = cat;
#line 721 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp6_ = _tmp5_->count;
#line 721 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		if (_tmp4_ >= _tmp6_) {
#line 722 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_vala_iter.stamp = 0;
#line 723 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			result = FALSE;
#line 723 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tracker_result_store_category_node_unref0 (cat);
#line 723 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			if (iter) {
#line 723 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				*iter = _vala_iter;
#line 4538 "tracker-result-store.c"
			}
#line 723 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			return result;
#line 4542 "tracker-result-store.c"
		}
#line 726 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp7_ = self->priv->timestamp;
#line 726 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_vala_iter.stamp = _tmp7_;
#line 727 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp8_ = cat;
#line 727 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_vala_iter.user_data = _tmp8_;
#line 728 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp9_ = cat;
#line 728 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp10_ = _tmp9_->results;
#line 728 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp10__length1 = _tmp9_->results_length1;
#line 728 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp11_ = n;
#line 728 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_vala_iter.user_data2 = &_tmp10_[_tmp11_];
#line 729 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp12_ = n;
#line 729 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp13_ = GINT_TO_POINTER (_tmp12_);
#line 729 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_vala_iter.user_data3 = _tmp13_;
#line 730 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		result = TRUE;
#line 730 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tracker_result_store_category_node_unref0 (cat);
#line 730 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		if (iter) {
#line 730 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			*iter = _vala_iter;
#line 4576 "tracker-result-store.c"
		}
#line 730 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		return result;
#line 4580 "tracker-result-store.c"
	} else {
		gint index = 0;
		TrackerResultStoreQueryData* _tmp14_;
		gint _tmp14__length1;
		GPtrArray* _tmp24_;
		gint _tmp25_;
		gconstpointer _tmp26_ = NULL;
		TrackerResultStoreCategoryNode* _tmp27_;
		gint _tmp28_;
		TrackerResultStoreCategoryNode* _tmp29_;
		TrackerResultStoreQueryData* _tmp30_;
		gint _tmp30__length1;
#line 734 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp14_ = self->priv->queries;
#line 734 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp14__length1 = self->priv->queries_length1;
#line 734 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		if (_tmp14__length1 > 1) {
#line 4599 "tracker-result-store.c"
			gint _tmp15_;
			gint _tmp16_ = 0;
			gboolean _tmp17_ = FALSE;
			gint _tmp18_;
			gboolean _tmp23_;
#line 735 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp15_ = n;
#line 735 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp16_ = tracker_result_store_find_nth_category_index (self, NULL, _tmp15_);
#line 735 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			index = _tmp16_;
#line 737 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp18_ = index;
#line 737 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			if (_tmp18_ < 0) {
#line 737 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tmp17_ = TRUE;
#line 4617 "tracker-result-store.c"
			} else {
				gint _tmp19_;
				GPtrArray* _tmp20_;
				gint _tmp21_;
				gint _tmp22_;
#line 737 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tmp19_ = index;
#line 737 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tmp20_ = self->priv->categories;
#line 737 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tmp21_ = g_ptr_array_get_length (_tmp20_);
#line 737 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tmp22_ = _tmp21_;
#line 737 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tmp17_ = _tmp19_ >= _tmp22_;
#line 4633 "tracker-result-store.c"
			}
#line 737 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp23_ = _tmp17_;
#line 737 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			if (_tmp23_) {
#line 738 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_vala_iter.stamp = 0;
#line 739 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				result = FALSE;
#line 739 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tracker_result_store_category_node_unref0 (cat);
#line 739 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				if (iter) {
#line 739 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					*iter = _vala_iter;
#line 4649 "tracker-result-store.c"
				}
#line 739 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				return result;
#line 4653 "tracker-result-store.c"
			}
		} else {
#line 742 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			index = 0;
#line 4658 "tracker-result-store.c"
		}
#line 745 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp24_ = self->priv->categories;
#line 745 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp25_ = index;
#line 745 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp26_ = g_ptr_array_index (_tmp24_, (guint) _tmp25_);
#line 745 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp27_ = _tracker_result_store_category_node_ref0 ((TrackerResultStoreCategoryNode*) _tmp26_);
#line 745 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tracker_result_store_category_node_unref0 (cat);
#line 745 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		cat = _tmp27_;
#line 746 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp28_ = self->priv->timestamp;
#line 746 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_vala_iter.stamp = _tmp28_;
#line 747 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp29_ = cat;
#line 747 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_vala_iter.user_data = _tmp29_;
#line 749 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp30_ = self->priv->queries;
#line 749 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp30__length1 = self->priv->queries_length1;
#line 749 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		if (_tmp30__length1 > 1) {
#line 4686 "tracker-result-store.c"
			TrackerResultStoreCategoryNode* _tmp31_;
			TrackerResultStoreResultNode* _tmp32_;
			gint _tmp32__length1;
			void* _tmp33_ = NULL;
#line 750 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp31_ = cat;
#line 750 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp32_ = _tmp31_->results;
#line 750 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp32__length1 = _tmp31_->results_length1;
#line 750 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_vala_iter.user_data2 = &_tmp32_[0];
#line 751 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp33_ = GINT_TO_POINTER (0);
#line 751 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_vala_iter.user_data3 = _tmp33_;
#line 4703 "tracker-result-store.c"
		}
#line 754 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		result = TRUE;
#line 754 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tracker_result_store_category_node_unref0 (cat);
#line 754 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		if (iter) {
#line 754 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			*iter = _vala_iter;
#line 4713 "tracker-result-store.c"
		}
#line 754 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		return result;
#line 4717 "tracker-result-store.c"
	}
#line 715 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tracker_result_store_category_node_unref0 (cat);
#line 715 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	if (iter) {
#line 715 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		*iter = _vala_iter;
#line 4725 "tracker-result-store.c"
	}
}


static gboolean tracker_result_store_real_iter_parent (GtkTreeModel* base, GtkTreeIter* iter, GtkTreeIter* child) {
	TrackerResultStore * self;
	GtkTreeIter _vala_iter = {0};
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	TrackerResultStoreQueryData* _tmp1_;
	gint _tmp1__length1;
	gboolean _tmp4_;
#line 758 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	self = (TrackerResultStore*) base;
#line 758 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	g_return_val_if_fail (child != NULL, FALSE);
#line 759 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp1_ = self->priv->queries;
#line 759 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp1__length1 = self->priv->queries_length1;
#line 759 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	if (_tmp1__length1 > 1) {
#line 4748 "tracker-result-store.c"
		GtkTreeIter _tmp2_;
		void* _tmp3_;
#line 760 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp2_ = *child;
#line 760 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp3_ = _tmp2_.user_data2;
#line 760 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp0_ = _tmp3_ != NULL;
#line 4757 "tracker-result-store.c"
	} else {
#line 759 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp0_ = FALSE;
#line 4761 "tracker-result-store.c"
	}
#line 759 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp4_ = _tmp0_;
#line 759 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	if (_tmp4_) {
#line 4767 "tracker-result-store.c"
		gint _tmp5_;
		GtkTreeIter _tmp6_;
		void* _tmp7_;
#line 762 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp5_ = self->priv->timestamp;
#line 762 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_vala_iter.stamp = _tmp5_;
#line 763 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp6_ = *child;
#line 763 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp7_ = _tmp6_.user_data;
#line 763 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_vala_iter.user_data = _tmp7_;
#line 764 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_vala_iter.user_data2 = NULL;
#line 765 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_vala_iter.user_data3 = NULL;
#line 766 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		result = TRUE;
#line 766 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		if (iter) {
#line 766 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			*iter = _vala_iter;
#line 4791 "tracker-result-store.c"
		}
#line 766 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		return result;
#line 4795 "tracker-result-store.c"
	}
#line 769 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_vala_iter.stamp = 0;
#line 770 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	result = FALSE;
#line 770 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	if (iter) {
#line 770 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		*iter = _vala_iter;
#line 4805 "tracker-result-store.c"
	}
#line 770 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	return result;
#line 4809 "tracker-result-store.c"
}


static void tracker_result_store_real_ref_node (GtkTreeModel* base, GtkTreeIter* iter) {
	TrackerResultStore * self;
#line 773 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	self = (TrackerResultStore*) base;
#line 773 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	g_return_if_fail (iter != NULL);
#line 4819 "tracker-result-store.c"
}


static void tracker_result_store_real_unref_node (GtkTreeModel* base, GtkTreeIter* iter) {
	TrackerResultStore * self;
#line 776 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	self = (TrackerResultStore*) base;
#line 776 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	g_return_if_fail (iter != NULL);
#line 4829 "tracker-result-store.c"
}


static void tracker_result_store_theme_changed (TrackerResultStore* self, GtkIconTheme* theme) {
	GtkTreeIter iter = {0};
	gint i = 0;
	gint j = 0;
	GtkTreeIter _tmp0_ = {0};
	gint _tmp1_;
#line 779 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	g_return_if_fail (self != NULL);
#line 779 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	g_return_if_fail (theme != NULL);
#line 783 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	memset (&_tmp0_, 0, sizeof (GtkTreeIter));
#line 783 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	iter = _tmp0_;
#line 784 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp1_ = self->priv->timestamp;
#line 784 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	iter.stamp = _tmp1_;
#line 4851 "tracker-result-store.c"
	{
		gboolean _tmp2_;
#line 786 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		i = 0;
#line 786 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp2_ = TRUE;
#line 786 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		while (TRUE) {
#line 4860 "tracker-result-store.c"
			gboolean _tmp3_;
			gint _tmp5_;
			GPtrArray* _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			GPtrArray* _tmp9_;
			gint _tmp10_;
			gconstpointer _tmp11_ = NULL;
			TrackerResultStoreCategoryNode* _tmp12_;
			TrackerResultStoreCategoryNode* cat;
			TrackerResultStoreCategoryNode* _tmp13_;
#line 786 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp3_ = _tmp2_;
#line 786 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			if (!_tmp3_) {
#line 4876 "tracker-result-store.c"
				gint _tmp4_;
#line 786 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tmp4_ = i;
#line 786 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				i = _tmp4_ + 1;
#line 4882 "tracker-result-store.c"
			}
#line 786 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp2_ = FALSE;
#line 786 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp5_ = i;
#line 786 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp6_ = self->priv->categories;
#line 786 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp7_ = g_ptr_array_get_length (_tmp6_);
#line 786 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp8_ = _tmp7_;
#line 786 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			if (!(_tmp5_ < _tmp8_)) {
#line 786 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				break;
#line 4898 "tracker-result-store.c"
			}
#line 787 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp9_ = self->priv->categories;
#line 787 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp10_ = i;
#line 787 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp11_ = g_ptr_array_index (_tmp9_, (guint) _tmp10_);
#line 787 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp12_ = _tracker_result_store_category_node_ref0 ((TrackerResultStoreCategoryNode*) _tmp11_);
#line 787 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			cat = _tmp12_;
#line 789 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp13_ = cat;
#line 789 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			iter.user_data = _tmp13_;
#line 4914 "tracker-result-store.c"
			{
				TrackerResultStoreCategoryNode* _tmp14_;
				gint _tmp15_;
				gboolean _tmp16_;
#line 791 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tmp14_ = cat;
#line 791 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tmp15_ = _tmp14_->count;
#line 791 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				j = _tmp15_ - 1;
#line 791 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tmp16_ = TRUE;
#line 791 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				while (TRUE) {
#line 4929 "tracker-result-store.c"
					gboolean _tmp17_;
					gint _tmp19_;
					TrackerResultStoreCategoryNode* _tmp20_;
					TrackerResultStoreResultNode* _tmp21_;
					gint _tmp21__length1;
					gint _tmp22_;
					TrackerResultStoreResultNode _tmp23_;
					TrackerResultStoreResultNode _tmp24_ = {0};
					TrackerResultStoreResultNode _result_;
					TrackerResultStoreCategoryNode* _tmp25_;
					TrackerResultStoreResultNode* _tmp26_;
					gint _tmp26__length1;
					gint _tmp27_;
					gint _tmp28_;
					void* _tmp29_ = NULL;
					TrackerResultStoreResultNode _tmp30_;
					GdkPixbuf* _tmp31_;
#line 791 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					_tmp17_ = _tmp16_;
#line 791 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					if (!_tmp17_) {
#line 4951 "tracker-result-store.c"
						gint _tmp18_;
#line 791 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
						_tmp18_ = j;
#line 791 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
						j = _tmp18_ - 1;
#line 4957 "tracker-result-store.c"
					}
#line 791 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					_tmp16_ = FALSE;
#line 791 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					_tmp19_ = j;
#line 791 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					if (!(_tmp19_ >= 0)) {
#line 791 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
						break;
#line 4967 "tracker-result-store.c"
					}
#line 792 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					_tmp20_ = cat;
#line 792 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					_tmp21_ = _tmp20_->results;
#line 792 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					_tmp21__length1 = _tmp20_->results_length1;
#line 792 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					_tmp22_ = j;
#line 792 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					_tmp23_ = _tmp21_[_tmp22_];
#line 792 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					tracker_result_store_result_node_copy (&_tmp23_, &_tmp24_);
#line 792 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					_result_ = _tmp24_;
#line 794 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					_tmp25_ = cat;
#line 794 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					_tmp26_ = _tmp25_->results;
#line 794 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					_tmp26__length1 = _tmp25_->results_length1;
#line 794 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					_tmp27_ = j;
#line 794 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					iter.user_data2 = &_tmp26_[_tmp27_];
#line 795 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					_tmp28_ = j;
#line 795 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					_tmp29_ = GINT_TO_POINTER (_tmp28_);
#line 795 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					iter.user_data3 = _tmp29_;
#line 797 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					_tmp30_ = _result_;
#line 797 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					_tmp31_ = _tmp30_.pixbuf;
#line 797 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					if (_tmp31_ != NULL) {
#line 5005 "tracker-result-store.c"
						GtkTreeIter _tmp32_;
#line 798 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
						_tmp32_ = iter;
#line 798 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
						tracker_result_store_fetch_thumbnail (self, &_tmp32_, NULL, NULL);
#line 5011 "tracker-result-store.c"
					}
#line 791 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					tracker_result_store_result_node_destroy (&_result_);
#line 5015 "tracker-result-store.c"
				}
			}
#line 786 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tracker_result_store_category_node_unref0 (cat);
#line 5020 "tracker-result-store.c"
		}
	}
}


static void _tracker_result_store_category_node_unref0_ (gpointer var) {
#line 805 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	(var == NULL) ? NULL : (var = (tracker_result_store_category_node_unref (var), NULL));
#line 5029 "tracker-result-store.c"
}


static void _g_object_unref0_ (gpointer var) {
#line 806 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 5036 "tracker-result-store.c"
}


static void _tracker_result_store_theme_changed_gtk_icon_theme_changed (GtkIconTheme* _sender, gpointer self) {
#line 814 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	tracker_result_store_theme_changed (self, _sender);
#line 5043 "tracker-result-store.c"
}


TrackerResultStore* tracker_result_store_construct (GType object_type, gint _n_columns) {
	TrackerResultStore * self = NULL;
	GPtrArray* _tmp0_;
	GPtrArray* _tmp1_;
	GPtrArray* _tmp2_;
	gint _tmp3_;
	GdkScreen* _tmp4_ = NULL;
	GtkIconTheme* _tmp5_ = NULL;
	GtkIconTheme* _tmp6_;
	GtkIconTheme* theme;
#line 804 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	self = (TrackerResultStore*) g_object_new (object_type, NULL);
#line 805 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp0_ = g_ptr_array_new_with_free_func (_tracker_result_store_category_node_unref0_);
#line 805 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_g_ptr_array_unref0 (self->priv->categories);
#line 805 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	self->priv->categories = _tmp0_;
#line 806 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp1_ = g_ptr_array_new_with_free_func (_g_object_unref0_);
#line 806 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_g_ptr_array_unref0 (self->priv->running_operations);
#line 806 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	self->priv->running_operations = _tmp1_;
#line 807 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp2_ = g_ptr_array_new_with_free_func (_g_object_unref0_);
#line 807 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_g_ptr_array_unref0 (self->priv->delayed_operations);
#line 807 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	self->priv->delayed_operations = _tmp2_;
#line 809 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp3_ = _n_columns;
#line 809 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	self->priv->n_columns = _tmp3_;
#line 810 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	self->priv->timestamp = 1;
#line 811 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	tracker_result_store_set_icon_size (self, 24);
#line 813 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp4_ = gdk_screen_get_default ();
#line 813 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp5_ = gtk_icon_theme_get_for_screen (_tmp4_);
#line 813 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 813 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	theme = _tmp6_;
#line 814 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	g_signal_connect_object (theme, "changed", (GCallback) _tracker_result_store_theme_changed_gtk_icon_theme_changed, self, 0);
#line 804 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_g_object_unref0 (theme);
#line 804 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	return self;
#line 5099 "tracker-result-store.c"
}


TrackerResultStore* tracker_result_store_new (gint _n_columns) {
#line 804 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	return tracker_result_store_construct (TRACKER_TYPE_RESULT_STORE, _n_columns);
#line 5106 "tracker-result-store.c"
}


static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value) {
#line 827 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	if ((*length) == (*size)) {
#line 827 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 827 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 5117 "tracker-result-store.c"
	}
#line 827 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	(*array)[(*length)++] = value;
#line 827 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	(*array)[*length] = NULL;
#line 5123 "tracker-result-store.c"
}


static gchar** _vala_array_dup3 (gchar** self, int length) {
	gchar** result;
	int i;
#line 839 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	result = g_new0 (gchar*, length + 1);
#line 839 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	for (i = 0; i < length; i++) {
#line 5134 "tracker-result-store.c"
		gchar* _tmp0_;
#line 839 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp0_ = g_strdup (self[i]);
#line 839 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		result[i] = _tmp0_;
#line 5140 "tracker-result-store.c"
	}
#line 839 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	return result;
#line 5144 "tracker-result-store.c"
}


static void _vala_array_add3 (TrackerResultStoreQueryData** array, int* length, int* size, const TrackerResultStoreQueryData* value) {
#line 841 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	if ((*length) == (*size)) {
#line 841 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 841 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		*array = g_renew (TrackerResultStoreQueryData, *array, *size);
#line 5155 "tracker-result-store.c"
	}
#line 841 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	(*array)[(*length)++] = *value;
#line 5159 "tracker-result-store.c"
}


void tracker_result_store_add_query (TrackerResultStore* self, TrackerQueryType type, TrackerQueryMatch match, ...) {
	va_list l = {0};
	gchar* str;
	gchar** args;
	gint args_length1;
	gint _args_size_;
	TrackerResultStoreQueryData query_data = {0};
	gchar** _tmp9_;
	gint _tmp9__length1;
	gint _tmp10_;
	TrackerResultStoreQueryData _tmp11_ = {0};
	TrackerQueryType _tmp12_;
	TrackerQueryMatch _tmp13_;
	gchar** _tmp14_;
	gint _tmp14__length1;
	gchar** _tmp15_;
	gint _tmp15__length1;
	TrackerResultStoreQueryData* _tmp16_;
	gint _tmp16__length1;
	TrackerResultStoreQueryData _tmp17_;
	TrackerResultStoreQueryData _tmp18_ = {0};
#line 817 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	g_return_if_fail (self != NULL);
#line 818 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	va_start (l, match);
#line 819 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	str = NULL;
#line 820 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	args = NULL;
#line 820 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	args_length1 = 0;
#line 820 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_args_size_ = args_length1;
#line 5196 "tracker-result-store.c"
	{
		gboolean _tmp0_;
#line 823 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp0_ = TRUE;
#line 823 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		while (TRUE) {
#line 5203 "tracker-result-store.c"
			gboolean _tmp1_;
			const gchar* _tmp3_ = NULL;
			gchar* _tmp4_;
			const gchar* _tmp5_;
#line 823 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp1_ = _tmp0_;
#line 823 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			if (!_tmp1_) {
#line 5212 "tracker-result-store.c"
				const gchar* _tmp2_;
#line 829 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tmp2_ = str;
#line 829 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				if (!(_tmp2_ != NULL)) {
#line 829 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
					break;
#line 5220 "tracker-result-store.c"
				}
			}
#line 823 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp0_ = FALSE;
#line 824 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp3_ = va_arg (l, gchar*);
#line 824 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp4_ = g_strdup (_tmp3_);
#line 824 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_g_free0 (str);
#line 824 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			str = _tmp4_;
#line 826 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp5_ = str;
#line 826 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			if (_tmp5_ != NULL) {
#line 5237 "tracker-result-store.c"
				gchar** _tmp6_;
				gint _tmp6__length1;
				const gchar* _tmp7_;
				gchar* _tmp8_;
#line 827 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tmp6_ = args;
#line 827 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tmp6__length1 = args_length1;
#line 827 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tmp7_ = str;
#line 827 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tmp8_ = g_strdup (_tmp7_);
#line 827 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_vala_array_add2 (&args, &args_length1, &_args_size_, _tmp8_);
#line 5252 "tracker-result-store.c"
			}
		}
	}
#line 831 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp9_ = args;
#line 831 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp9__length1 = args_length1;
#line 831 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp10_ = self->priv->n_columns;
#line 831 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	if (_tmp9__length1 != _tmp10_) {
#line 832 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		g_warning ("tracker-result-store.vala:832: Arguments and number of columns doesn't" \
" match");
#line 833 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		tracker_result_store_query_data_destroy (&query_data);
#line 833 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
#line 833 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_g_free0 (str);
#line 833 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		va_end (l);
#line 833 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		return;
#line 5276 "tracker-result-store.c"
	}
#line 836 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	memset (&_tmp11_, 0, sizeof (TrackerResultStoreQueryData));
#line 836 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	tracker_result_store_query_data_destroy (&query_data);
#line 836 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	query_data = _tmp11_;
#line 837 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp12_ = type;
#line 837 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	query_data.type = _tmp12_;
#line 838 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp13_ = match;
#line 838 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	query_data.match = _tmp13_;
#line 839 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp14_ = args;
#line 839 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp14__length1 = args_length1;
#line 839 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp15_ = (_tmp14_ != NULL) ? _vala_array_dup3 (_tmp14_, _tmp14__length1) : ((gpointer) _tmp14_);
#line 839 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp15__length1 = _tmp14__length1;
#line 839 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	query_data.args = (_vala_array_free (query_data.args, query_data.args_length1, (GDestroyNotify) g_free), NULL);
#line 839 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	query_data.args = _tmp15_;
#line 839 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	query_data.args_length1 = _tmp15__length1;
#line 839 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	query_data._args_size_ = query_data.args_length1;
#line 841 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp16_ = self->priv->queries;
#line 841 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp16__length1 = self->priv->queries_length1;
#line 841 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp17_ = query_data;
#line 841 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	tracker_result_store_query_data_copy (&_tmp17_, &_tmp18_);
#line 841 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_vala_array_add3 (&self->priv->queries, &self->priv->queries_length1, &self->priv->_queries_size_, &_tmp18_);
#line 817 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	tracker_result_store_query_data_destroy (&query_data);
#line 817 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
#line 817 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_g_free0 (str);
#line 817 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	va_end (l);
#line 5326 "tracker-result-store.c"
}


gboolean tracker_result_store_has_results (TrackerResultStore* self) {
	gboolean result = FALSE;
	gint _tmp0_ = 0;
#line 844 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 845 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp0_ = tracker_result_store_filled_categories_count (self);
#line 845 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	result = _tmp0_ > 0;
#line 845 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	return result;
#line 5341 "tracker-result-store.c"
}


void tracker_result_store_cancel_search (TrackerResultStore* self) {
	GCancellable* _tmp0_;
#line 848 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	g_return_if_fail (self != NULL);
#line 849 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp0_ = self->priv->cancellable;
#line 849 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	if (_tmp0_ != NULL) {
#line 5353 "tracker-result-store.c"
		GCancellable* _tmp1_;
#line 850 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp1_ = self->priv->cancellable;
#line 850 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		g_cancellable_cancel (_tmp1_);
#line 851 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_g_object_unref0 (self->priv->cancellable);
#line 851 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		self->priv->cancellable = NULL;
#line 5363 "tracker-result-store.c"
	}
#line 854 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	tracker_result_store_clear_results (self);
#line 5367 "tracker-result-store.c"
}


gint tracker_result_store_get_icon_size (TrackerResultStore* self) {
	gint result;
	gint _tmp0_;
#line 60 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 60 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp0_ = self->priv->_icon_size;
#line 60 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	result = _tmp0_;
#line 60 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	return result;
#line 5382 "tracker-result-store.c"
}


void tracker_result_store_set_icon_size (TrackerResultStore* self, gint value) {
	gint _tmp0_;
#line 61 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	g_return_if_fail (self != NULL);
#line 61 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp0_ = value;
#line 61 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	self->priv->_icon_size = _tmp0_;
#line 61 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	g_object_notify ((GObject *) self, "icon-size");
#line 5396 "tracker-result-store.c"
}


const gchar* tracker_result_store_get_search_term (TrackerResultStore* self) {
	const gchar* result;
	const gchar* _tmp0_;
#line 298 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 299 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp0_ = self->priv->_search_term;
#line 299 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	result = _tmp0_;
#line 299 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	return result;
#line 5411 "tracker-result-store.c"
}


void tracker_result_store_set_search_term (TrackerResultStore* self, const gchar* value) {
	gint i = 0;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GCancellable* _tmp2_;
	GCancellable* _tmp4_;
	GPtrArray* _tmp5_;
	GPtrArray* _tmp6_;
	GPtrArray* _tmp7_;
	gint _tmp8_;
#line 301 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	g_return_if_fail (self != NULL);
#line 304 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp0_ = value;
#line 304 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 304 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_g_free0 (self->priv->_search_term);
#line 304 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	self->priv->_search_term = _tmp1_;
#line 306 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp2_ = self->priv->cancellable;
#line 306 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	if (_tmp2_ != NULL) {
#line 5439 "tracker-result-store.c"
		GCancellable* _tmp3_;
#line 307 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp3_ = self->priv->cancellable;
#line 307 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		g_cancellable_cancel (_tmp3_);
#line 308 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_g_object_unref0 (self->priv->cancellable);
#line 308 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		self->priv->cancellable = NULL;
#line 5449 "tracker-result-store.c"
	}
#line 311 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp4_ = g_cancellable_new ();
#line 311 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_g_object_unref0 (self->priv->cancellable);
#line 311 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	self->priv->cancellable = _tmp4_;
#line 313 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	tracker_result_store_clear_results (self);
#line 314 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	tracker_result_store_set_active (self, TRUE);
#line 316 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp5_ = g_ptr_array_new_with_free_func (_tracker_result_store_category_node_unref0_);
#line 316 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_g_ptr_array_unref0 (self->priv->categories);
#line 316 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	self->priv->categories = _tmp5_;
#line 317 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp6_ = g_ptr_array_new_with_free_func (_g_object_unref0_);
#line 317 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_g_ptr_array_unref0 (self->priv->running_operations);
#line 317 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	self->priv->running_operations = _tmp6_;
#line 318 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp7_ = g_ptr_array_new_with_free_func (_g_object_unref0_);
#line 318 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_g_ptr_array_unref0 (self->priv->delayed_operations);
#line 318 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	self->priv->delayed_operations = _tmp7_;
#line 319 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp8_ = self->priv->timestamp;
#line 319 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	self->priv->timestamp = _tmp8_ + 1;
#line 5483 "tracker-result-store.c"
	{
		gboolean _tmp9_;
#line 321 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		i = 0;
#line 321 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp9_ = TRUE;
#line 321 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		while (TRUE) {
#line 5492 "tracker-result-store.c"
			gboolean _tmp10_;
			gint _tmp12_;
			TrackerResultStoreQueryData* _tmp13_;
			gint _tmp13__length1;
			TrackerResultStoreQueryData* _tmp14_;
			gint _tmp14__length1;
			gint _tmp15_;
			GCancellable* _tmp16_;
#line 321 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp10_ = _tmp9_;
#line 321 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			if (!_tmp10_) {
#line 5505 "tracker-result-store.c"
				gint _tmp11_;
#line 321 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				_tmp11_ = i;
#line 321 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				i = _tmp11_ + 1;
#line 5511 "tracker-result-store.c"
			}
#line 321 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp9_ = FALSE;
#line 321 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp12_ = i;
#line 321 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp13_ = self->priv->queries;
#line 321 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp13__length1 = self->priv->queries_length1;
#line 321 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			if (!(_tmp12_ < _tmp13__length1)) {
#line 321 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
				break;
#line 5525 "tracker-result-store.c"
			}
#line 322 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp14_ = self->priv->queries;
#line 322 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp14__length1 = self->priv->queries_length1;
#line 322 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp15_ = i;
#line 322 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			_tmp16_ = self->priv->cancellable;
#line 322 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			tracker_result_store_load_category (self, &_tmp14_[_tmp15_], _tmp16_, NULL, NULL);
#line 5537 "tracker-result-store.c"
		}
	}
#line 301 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	g_object_notify ((GObject *) self, "search-term");
#line 5542 "tracker-result-store.c"
}


gboolean tracker_result_store_get_active (TrackerResultStore* self) {
	gboolean result;
	gboolean _tmp0_;
#line 328 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 328 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp0_ = self->priv->_active;
#line 328 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	result = _tmp0_;
#line 328 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	return result;
#line 5557 "tracker-result-store.c"
}


static void tracker_result_store_set_active (TrackerResultStore* self, gboolean value) {
	gboolean _tmp0_;
#line 329 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	g_return_if_fail (self != NULL);
#line 329 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp0_ = value;
#line 329 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	self->priv->_active = _tmp0_;
#line 329 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	g_object_notify ((GObject *) self, "active");
#line 5571 "tracker-result-store.c"
}


static void _vala_TrackerResultStoreResultNode_array_free (TrackerResultStoreResultNode* array, gint array_length) {
#line 33 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	if (array != NULL) {
#line 5578 "tracker-result-store.c"
		int i;
#line 33 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 33 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			tracker_result_store_result_node_destroy (&array[i]);
#line 5584 "tracker-result-store.c"
		}
	}
#line 33 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	g_free (array);
#line 5589 "tracker-result-store.c"
}


static TrackerResultStoreCategoryNode* tracker_result_store_category_node_construct (GType object_type) {
	TrackerResultStoreCategoryNode* self = NULL;
#line 30 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	self = (TrackerResultStoreCategoryNode*) g_type_create_instance (object_type);
#line 30 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	return self;
#line 5599 "tracker-result-store.c"
}


static TrackerResultStoreCategoryNode* tracker_result_store_category_node_new (void) {
#line 30 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	return tracker_result_store_category_node_construct (TRACKER_RESULT_STORE_TYPE_CATEGORY_NODE);
#line 5606 "tracker-result-store.c"
}


static void tracker_result_store_value_category_node_init (GValue* value) {
#line 30 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	value->data[0].v_pointer = NULL;
#line 5613 "tracker-result-store.c"
}


static void tracker_result_store_value_category_node_free_value (GValue* value) {
#line 30 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	if (value->data[0].v_pointer) {
#line 30 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		tracker_result_store_category_node_unref (value->data[0].v_pointer);
#line 5622 "tracker-result-store.c"
	}
}


static void tracker_result_store_value_category_node_copy_value (const GValue* src_value, GValue* dest_value) {
#line 30 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	if (src_value->data[0].v_pointer) {
#line 30 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		dest_value->data[0].v_pointer = tracker_result_store_category_node_ref (src_value->data[0].v_pointer);
#line 5632 "tracker-result-store.c"
	} else {
#line 30 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		dest_value->data[0].v_pointer = NULL;
#line 5636 "tracker-result-store.c"
	}
}


static gpointer tracker_result_store_value_category_node_peek_pointer (const GValue* value) {
#line 30 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	return value->data[0].v_pointer;
#line 5644 "tracker-result-store.c"
}


static gchar* tracker_result_store_value_category_node_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 30 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	if (collect_values[0].v_pointer) {
#line 5651 "tracker-result-store.c"
		TrackerResultStoreCategoryNode* object;
		object = collect_values[0].v_pointer;
#line 30 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		if (object->parent_instance.g_class == NULL) {
#line 30 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 5658 "tracker-result-store.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 30 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 5662 "tracker-result-store.c"
		}
#line 30 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		value->data[0].v_pointer = tracker_result_store_category_node_ref (object);
#line 5666 "tracker-result-store.c"
	} else {
#line 30 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		value->data[0].v_pointer = NULL;
#line 5670 "tracker-result-store.c"
	}
#line 30 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	return NULL;
#line 5674 "tracker-result-store.c"
}


static gchar* tracker_result_store_value_category_node_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	TrackerResultStoreCategoryNode** object_p;
	object_p = collect_values[0].v_pointer;
#line 30 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	if (!object_p) {
#line 30 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 5685 "tracker-result-store.c"
	}
#line 30 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	if (!value->data[0].v_pointer) {
#line 30 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		*object_p = NULL;
#line 5691 "tracker-result-store.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 30 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		*object_p = value->data[0].v_pointer;
#line 5695 "tracker-result-store.c"
	} else {
#line 30 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		*object_p = tracker_result_store_category_node_ref (value->data[0].v_pointer);
#line 5699 "tracker-result-store.c"
	}
#line 30 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	return NULL;
#line 5703 "tracker-result-store.c"
}


static GParamSpec* tracker_result_store_param_spec_category_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	TrackerResultStoreParamSpecCategoryNode* spec;
#line 30 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TRACKER_RESULT_STORE_TYPE_CATEGORY_NODE), NULL);
#line 30 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 30 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 30 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	return G_PARAM_SPEC (spec);
#line 5717 "tracker-result-store.c"
}


static gpointer tracker_result_store_value_get_category_node (const GValue* value) {
#line 30 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_RESULT_STORE_TYPE_CATEGORY_NODE), NULL);
#line 30 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	return value->data[0].v_pointer;
#line 5726 "tracker-result-store.c"
}


static void tracker_result_store_value_set_category_node (GValue* value, gpointer v_object) {
	TrackerResultStoreCategoryNode* old;
#line 30 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_RESULT_STORE_TYPE_CATEGORY_NODE));
#line 30 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	old = value->data[0].v_pointer;
#line 30 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	if (v_object) {
#line 30 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_RESULT_STORE_TYPE_CATEGORY_NODE));
#line 30 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 30 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		value->data[0].v_pointer = v_object;
#line 30 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		tracker_result_store_category_node_ref (value->data[0].v_pointer);
#line 5746 "tracker-result-store.c"
	} else {
#line 30 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		value->data[0].v_pointer = NULL;
#line 5750 "tracker-result-store.c"
	}
#line 30 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	if (old) {
#line 30 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		tracker_result_store_category_node_unref (old);
#line 5756 "tracker-result-store.c"
	}
}


static void tracker_result_store_value_take_category_node (GValue* value, gpointer v_object) {
	TrackerResultStoreCategoryNode* old;
#line 30 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_RESULT_STORE_TYPE_CATEGORY_NODE));
#line 30 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	old = value->data[0].v_pointer;
#line 30 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	if (v_object) {
#line 30 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_RESULT_STORE_TYPE_CATEGORY_NODE));
#line 30 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 30 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		value->data[0].v_pointer = v_object;
#line 5775 "tracker-result-store.c"
	} else {
#line 30 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		value->data[0].v_pointer = NULL;
#line 5779 "tracker-result-store.c"
	}
#line 30 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	if (old) {
#line 30 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		tracker_result_store_category_node_unref (old);
#line 5785 "tracker-result-store.c"
	}
}


static void tracker_result_store_category_node_class_init (TrackerResultStoreCategoryNodeClass * klass) {
#line 30 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	tracker_result_store_category_node_parent_class = g_type_class_peek_parent (klass);
#line 30 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	TRACKER_RESULT_STORE_CATEGORY_NODE_CLASS (klass)->finalize = tracker_result_store_category_node_finalize;
#line 5795 "tracker-result-store.c"
}


static void tracker_result_store_category_node_instance_init (TrackerResultStoreCategoryNode * self) {
#line 30 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	self->ref_count = 1;
#line 5802 "tracker-result-store.c"
}


static void tracker_result_store_category_node_finalize (TrackerResultStoreCategoryNode* obj) {
	TrackerResultStoreCategoryNode * self;
#line 30 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	self = TRACKER_RESULT_STORE_CATEGORY_NODE (obj);
#line 33 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	self->results = (_vala_TrackerResultStoreResultNode_array_free (self->results, self->results_length1), NULL);
#line 34 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_g_object_unref0 (self->pixbuf);
#line 5814 "tracker-result-store.c"
}


static GType tracker_result_store_category_node_get_type (void) {
	static volatile gsize tracker_result_store_category_node_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_result_store_category_node_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { tracker_result_store_value_category_node_init, tracker_result_store_value_category_node_free_value, tracker_result_store_value_category_node_copy_value, tracker_result_store_value_category_node_peek_pointer, "p", tracker_result_store_value_category_node_collect_value, "p", tracker_result_store_value_category_node_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (TrackerResultStoreCategoryNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_result_store_category_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerResultStoreCategoryNode), 0, (GInstanceInitFunc) tracker_result_store_category_node_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType tracker_result_store_category_node_type_id;
		tracker_result_store_category_node_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TrackerResultStoreCategoryNode", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&tracker_result_store_category_node_type_id__volatile, tracker_result_store_category_node_type_id);
	}
	return tracker_result_store_category_node_type_id__volatile;
}


static gpointer tracker_result_store_category_node_ref (gpointer instance) {
	TrackerResultStoreCategoryNode* self;
	self = instance;
#line 30 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	g_atomic_int_inc (&self->ref_count);
#line 30 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	return instance;
#line 5839 "tracker-result-store.c"
}


static void tracker_result_store_category_node_unref (gpointer instance) {
	TrackerResultStoreCategoryNode* self;
	self = instance;
#line 30 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 30 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		TRACKER_RESULT_STORE_CATEGORY_NODE_GET_CLASS (self)->finalize (self);
#line 30 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 5852 "tracker-result-store.c"
	}
}


static TrackerResultStoreOperation* tracker_result_store_operation_construct (GType object_type) {
	TrackerResultStoreOperation * self = NULL;
#line 47 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	self = (TrackerResultStoreOperation*) g_object_new (object_type, NULL);
#line 47 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	return self;
#line 5863 "tracker-result-store.c"
}


static TrackerResultStoreOperation* tracker_result_store_operation_new (void) {
#line 47 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	return tracker_result_store_operation_construct (TRACKER_RESULT_STORE_TYPE_OPERATION);
#line 5870 "tracker-result-store.c"
}


static void tracker_result_store_operation_class_init (TrackerResultStoreOperationClass * klass) {
#line 47 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	tracker_result_store_operation_parent_class = g_type_class_peek_parent (klass);
#line 47 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	G_OBJECT_CLASS (klass)->finalize = tracker_result_store_operation_finalize;
#line 5879 "tracker-result-store.c"
}


static void tracker_result_store_operation_instance_init (TrackerResultStoreOperation * self) {
}


static void tracker_result_store_operation_finalize (GObject* obj) {
	TrackerResultStoreOperation * self;
#line 47 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	self = TRACKER_RESULT_STORE_OPERATION (obj);
#line 48 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tracker_result_store_category_node_unref0 (self->node);
#line 47 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	G_OBJECT_CLASS (tracker_result_store_operation_parent_class)->finalize (obj);
#line 5895 "tracker-result-store.c"
}


static GType tracker_result_store_operation_get_type (void) {
	static volatile gsize tracker_result_store_operation_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_result_store_operation_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerResultStoreOperationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_result_store_operation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerResultStoreOperation), 0, (GInstanceInitFunc) tracker_result_store_operation_instance_init, NULL };
		GType tracker_result_store_operation_type_id;
		tracker_result_store_operation_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerResultStoreOperation", &g_define_type_info, 0);
		g_once_init_leave (&tracker_result_store_operation_type_id__volatile, tracker_result_store_operation_type_id);
	}
	return tracker_result_store_operation_type_id__volatile;
}


static gchar** _vala_array_dup4 (gchar** self, int length) {
	gchar** result;
	int i;
#line 25 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	result = g_new0 (gchar*, length + 1);
#line 25 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	for (i = 0; i < length; i++) {
#line 5918 "tracker-result-store.c"
		gchar* _tmp0_;
#line 25 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp0_ = g_strdup (self[i]);
#line 25 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		result[i] = _tmp0_;
#line 5924 "tracker-result-store.c"
	}
#line 25 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	return result;
#line 5928 "tracker-result-store.c"
}


static void tracker_result_store_result_node_copy (const TrackerResultStoreResultNode* self, TrackerResultStoreResultNode* dest) {
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	GdkPixbuf* _tmp2_;
	GdkPixbuf* _tmp3_;
#line 25 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp0_ = (*self).values;
#line 25 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp0__length1 = (*self).values_length1;
#line 25 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup4 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
#line 25 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp1__length1 = _tmp0__length1;
#line 25 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	(*dest).values = (_vala_array_free ((*dest).values, (*dest).values_length1, (GDestroyNotify) g_free), NULL);
#line 25 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	(*dest).values = _tmp1_;
#line 25 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	(*dest).values_length1 = _tmp1__length1;
#line 25 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	(*dest)._values_size_ = (*dest).values_length1;
#line 25 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp2_ = (*self).pixbuf;
#line 25 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 25 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_g_object_unref0 ((*dest).pixbuf);
#line 25 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	(*dest).pixbuf = _tmp3_;
#line 5963 "tracker-result-store.c"
}


static void tracker_result_store_result_node_destroy (TrackerResultStoreResultNode* self) {
#line 26 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	(*self).values = (_vala_array_free ((*self).values, (*self).values_length1, (GDestroyNotify) g_free), NULL);
#line 27 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_g_object_unref0 ((*self).pixbuf);
#line 5972 "tracker-result-store.c"
}


static TrackerResultStoreResultNode* tracker_result_store_result_node_dup (const TrackerResultStoreResultNode* self) {
	TrackerResultStoreResultNode* dup;
#line 25 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	dup = g_new0 (TrackerResultStoreResultNode, 1);
#line 25 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	tracker_result_store_result_node_copy (self, dup);
#line 25 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	return dup;
#line 5984 "tracker-result-store.c"
}


static void tracker_result_store_result_node_free (TrackerResultStoreResultNode* self) {
#line 25 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	tracker_result_store_result_node_destroy (self);
#line 25 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	g_free (self);
#line 5993 "tracker-result-store.c"
}


static GType tracker_result_store_result_node_get_type (void) {
	static volatile gsize tracker_result_store_result_node_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_result_store_result_node_type_id__volatile)) {
		GType tracker_result_store_result_node_type_id;
		tracker_result_store_result_node_type_id = g_boxed_type_register_static ("TrackerResultStoreResultNode", (GBoxedCopyFunc) tracker_result_store_result_node_dup, (GBoxedFreeFunc) tracker_result_store_result_node_free);
		g_once_init_leave (&tracker_result_store_result_node_type_id__volatile, tracker_result_store_result_node_type_id);
	}
	return tracker_result_store_result_node_type_id__volatile;
}


static gchar** _vala_array_dup5 (gchar** self, int length) {
	gchar** result;
	int i;
#line 38 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	result = g_new0 (gchar*, length + 1);
#line 38 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	for (i = 0; i < length; i++) {
#line 6015 "tracker-result-store.c"
		gchar* _tmp0_;
#line 38 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		_tmp0_ = g_strdup (self[i]);
#line 38 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		result[i] = _tmp0_;
#line 6021 "tracker-result-store.c"
	}
#line 38 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	return result;
#line 6025 "tracker-result-store.c"
}


static void tracker_result_store_query_data_copy (const TrackerResultStoreQueryData* self, TrackerResultStoreQueryData* dest) {
	TrackerQueryType _tmp0_;
	TrackerQueryMatch _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** _tmp3_;
	gint _tmp3__length1;
#line 38 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp0_ = (*self).type;
#line 38 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	(*dest).type = _tmp0_;
#line 38 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp1_ = (*self).match;
#line 38 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	(*dest).match = _tmp1_;
#line 38 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp2_ = (*self).args;
#line 38 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp2__length1 = (*self).args_length1;
#line 38 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup5 (_tmp2_, _tmp2__length1) : ((gpointer) _tmp2_);
#line 38 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_tmp3__length1 = _tmp2__length1;
#line 38 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	(*dest).args = (_vala_array_free ((*dest).args, (*dest).args_length1, (GDestroyNotify) g_free), NULL);
#line 38 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	(*dest).args = _tmp3_;
#line 38 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	(*dest).args_length1 = _tmp3__length1;
#line 38 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	(*dest)._args_size_ = (*dest).args_length1;
#line 6060 "tracker-result-store.c"
}


static void tracker_result_store_query_data_destroy (TrackerResultStoreQueryData* self) {
#line 41 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	(*self).args = (_vala_array_free ((*self).args, (*self).args_length1, (GDestroyNotify) g_free), NULL);
#line 6067 "tracker-result-store.c"
}


static TrackerResultStoreQueryData* tracker_result_store_query_data_dup (const TrackerResultStoreQueryData* self) {
	TrackerResultStoreQueryData* dup;
#line 38 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	dup = g_new0 (TrackerResultStoreQueryData, 1);
#line 38 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	tracker_result_store_query_data_copy (self, dup);
#line 38 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	return dup;
#line 6079 "tracker-result-store.c"
}


static void tracker_result_store_query_data_free (TrackerResultStoreQueryData* self) {
#line 38 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	tracker_result_store_query_data_destroy (self);
#line 38 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	g_free (self);
#line 6088 "tracker-result-store.c"
}


static GType tracker_result_store_query_data_get_type (void) {
	static volatile gsize tracker_result_store_query_data_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_result_store_query_data_type_id__volatile)) {
		GType tracker_result_store_query_data_type_id;
		tracker_result_store_query_data_type_id = g_boxed_type_register_static ("TrackerResultStoreQueryData", (GBoxedCopyFunc) tracker_result_store_query_data_dup, (GBoxedFreeFunc) tracker_result_store_query_data_free);
		g_once_init_leave (&tracker_result_store_query_data_type_id__volatile, tracker_result_store_query_data_type_id);
	}
	return tracker_result_store_query_data_type_id__volatile;
}


static void tracker_result_store_class_init (TrackerResultStoreClass * klass) {
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	tracker_result_store_parent_class = g_type_class_peek_parent (klass);
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	g_type_class_add_private (klass, sizeof (TrackerResultStorePrivate));
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_tracker_result_store_get_property;
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_tracker_result_store_set_property;
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	G_OBJECT_CLASS (klass)->finalize = tracker_result_store_finalize;
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_RESULT_STORE_ICON_SIZE, g_param_spec_int ("icon-size", "icon-size", "icon-size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_RESULT_STORE_SEARCH_TERM, g_param_spec_string ("search-term", "search-term", "search-term", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_RESULT_STORE_ACTIVE, g_param_spec_boolean ("active", "active", "active", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 6120 "tracker-result-store.c"
}


static void tracker_result_store_gtk_tree_model_interface_init (GtkTreeModelIface * iface) {
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	tracker_result_store_gtk_tree_model_parent_iface = g_type_interface_peek_parent (iface);
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	iface->get_column_type = (GType (*)(GtkTreeModel*, gint)) tracker_result_store_real_get_column_type;
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	iface->get_flags = (GtkTreeModelFlags (*)(GtkTreeModel*)) tracker_result_store_real_get_flags;
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	iface->get_iter = (gboolean (*)(GtkTreeModel*, GtkTreeIter*, GtkTreePath*)) tracker_result_store_real_get_iter;
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	iface->get_n_columns = (gint (*)(GtkTreeModel*)) tracker_result_store_real_get_n_columns;
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	iface->get_path = (GtkTreePath* (*)(GtkTreeModel*, GtkTreeIter*)) tracker_result_store_real_get_path;
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	iface->get_value = (void (*)(GtkTreeModel*, GtkTreeIter*, gint, GValue*)) tracker_result_store_real_get_value;
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	iface->iter_children = (gboolean (*)(GtkTreeModel*, GtkTreeIter*, GtkTreeIter*)) tracker_result_store_real_iter_children;
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	iface->iter_has_child = (gboolean (*)(GtkTreeModel*, GtkTreeIter*)) tracker_result_store_real_iter_has_child;
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	iface->iter_n_children = (gint (*)(GtkTreeModel*, GtkTreeIter*)) tracker_result_store_real_iter_n_children;
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	iface->iter_next = (gboolean (*)(GtkTreeModel*, GtkTreeIter*)) tracker_result_store_real_iter_next;
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	iface->iter_nth_child = (gboolean (*)(GtkTreeModel*, GtkTreeIter*, GtkTreeIter*, gint)) tracker_result_store_real_iter_nth_child;
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	iface->iter_parent = (gboolean (*)(GtkTreeModel*, GtkTreeIter*, GtkTreeIter*)) tracker_result_store_real_iter_parent;
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	iface->ref_node = (void (*)(GtkTreeModel*, GtkTreeIter*)) tracker_result_store_real_ref_node;
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	iface->unref_node = (void (*)(GtkTreeModel*, GtkTreeIter*)) tracker_result_store_real_unref_node;
#line 6155 "tracker-result-store.c"
}


static void tracker_result_store_instance_init (TrackerResultStore * self) {
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	self->priv = TRACKER_RESULT_STORE_GET_PRIVATE (self);
#line 55 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	self->priv->n_extra_columns = 2;
#line 6164 "tracker-result-store.c"
}


static void tracker_result_store_finalize (GObject* obj) {
	TrackerResultStore * self;
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	self = TRACKER_RESULT_STORE (obj);
#line 23 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_g_object_unref0 (self->priv->cancellable);
#line 44 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	self->priv->queries = (_vala_TrackerResultStoreQueryData_array_free (self->priv->queries, self->priv->queries_length1), NULL);
#line 45 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_g_ptr_array_unref0 (self->priv->categories);
#line 52 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_g_ptr_array_unref0 (self->priv->running_operations);
#line 53 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_g_ptr_array_unref0 (self->priv->delayed_operations);
#line 296 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	_g_free0 (self->priv->_search_term);
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	G_OBJECT_CLASS (tracker_result_store_parent_class)->finalize (obj);
#line 6186 "tracker-result-store.c"
}


GType tracker_result_store_get_type (void) {
	static volatile gsize tracker_result_store_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_result_store_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerResultStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_result_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerResultStore), 0, (GInstanceInitFunc) tracker_result_store_instance_init, NULL };
		static const GInterfaceInfo gtk_tree_model_info = { (GInterfaceInitFunc) tracker_result_store_gtk_tree_model_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType tracker_result_store_type_id;
		tracker_result_store_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerResultStore", &g_define_type_info, 0);
		g_type_add_interface_static (tracker_result_store_type_id, GTK_TYPE_TREE_MODEL, &gtk_tree_model_info);
		g_once_init_leave (&tracker_result_store_type_id__volatile, tracker_result_store_type_id);
	}
	return tracker_result_store_type_id__volatile;
}


static void _vala_tracker_result_store_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TrackerResultStore * self;
	self = TRACKER_RESULT_STORE (object);
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	switch (property_id) {
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		case TRACKER_RESULT_STORE_ICON_SIZE:
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		g_value_set_int (value, tracker_result_store_get_icon_size (self));
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		break;
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		case TRACKER_RESULT_STORE_SEARCH_TERM:
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		g_value_set_string (value, tracker_result_store_get_search_term (self));
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		break;
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		case TRACKER_RESULT_STORE_ACTIVE:
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		g_value_set_boolean (value, tracker_result_store_get_active (self));
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		break;
#line 6227 "tracker-result-store.c"
		default:
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		break;
#line 6233 "tracker-result-store.c"
	}
}


static void _vala_tracker_result_store_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TrackerResultStore * self;
	self = TRACKER_RESULT_STORE (object);
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
	switch (property_id) {
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		case TRACKER_RESULT_STORE_ICON_SIZE:
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		tracker_result_store_set_icon_size (self, g_value_get_int (value));
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		break;
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		case TRACKER_RESULT_STORE_SEARCH_TERM:
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		tracker_result_store_set_search_term (self, g_value_get_string (value));
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		break;
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		case TRACKER_RESULT_STORE_ACTIVE:
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		tracker_result_store_set_active (self, g_value_get_boolean (value));
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		break;
#line 6261 "tracker-result-store.c"
		default:
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 22 "/home/juerg/Code/tracker/tracker/src/tracker-needle/tracker-result-store.vala"
		break;
#line 6267 "tracker-result-store.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



