/* tracker-store.c generated by valac 0.13.4.8-6faa4, the Vala compiler
 * generated from tracker-store.vala, do not modify */

/*
 * Copyright (C) 2009-2011, Nokia <ivan.frade@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 *
 * Author: Philip Van Hoof <philip@codeminded.be>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <libtracker-data/tracker-db-interface.h>
#include <libtracker-data/tracker-data-query.h>
#include <libtracker-data/tracker-data-update.h>
#include <libtracker-data/tracker-data-backup.h>
#include <libtracker-data/tracker-db-manager.h>
#include <libtracker-data/tracker-db-interface-sqlite.h>
#include <tracker-store/tracker-events.h>
#include <gobject/gvaluecollector.h>


#define TRACKER_TYPE_STORE (tracker_store_get_type ())
#define TRACKER_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_STORE, TrackerStore))
#define TRACKER_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_STORE, TrackerStoreClass))
#define TRACKER_IS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_STORE))
#define TRACKER_IS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_STORE))
#define TRACKER_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_STORE, TrackerStoreClass))

typedef struct _TrackerStore TrackerStore;
typedef struct _TrackerStoreClass TrackerStoreClass;
typedef struct _TrackerStorePrivate TrackerStorePrivate;

#define TRACKER_STORE_TYPE_PRIORITY (tracker_store_priority_get_type ())

#define TRACKER_STORE_TYPE_TASK_TYPE (tracker_store_task_type_get_type ())

#define TRACKER_STORE_TYPE_TASK (tracker_store_task_get_type ())
#define TRACKER_STORE_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_STORE_TYPE_TASK, TrackerStoreTask))
#define TRACKER_STORE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_STORE_TYPE_TASK, TrackerStoreTaskClass))
#define TRACKER_STORE_IS_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_STORE_TYPE_TASK))
#define TRACKER_STORE_IS_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_STORE_TYPE_TASK))
#define TRACKER_STORE_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_STORE_TYPE_TASK, TrackerStoreTaskClass))

typedef struct _TrackerStoreTask TrackerStoreTask;
typedef struct _TrackerStoreTaskClass TrackerStoreTaskClass;
#define _tracker_store_task_unref0(var) ((var == NULL) ? NULL : (var = (tracker_store_task_unref (var), NULL)))

#define TRACKER_STORE_TYPE_QUERY_TASK (tracker_store_query_task_get_type ())
#define TRACKER_STORE_QUERY_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_STORE_TYPE_QUERY_TASK, TrackerStoreQueryTask))
#define TRACKER_STORE_QUERY_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_STORE_TYPE_QUERY_TASK, TrackerStoreQueryTaskClass))
#define TRACKER_STORE_IS_QUERY_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_STORE_TYPE_QUERY_TASK))
#define TRACKER_STORE_IS_QUERY_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_STORE_TYPE_QUERY_TASK))
#define TRACKER_STORE_QUERY_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_STORE_TYPE_QUERY_TASK, TrackerStoreQueryTaskClass))

typedef struct _TrackerStoreQueryTask TrackerStoreQueryTask;
typedef struct _TrackerStoreQueryTaskClass TrackerStoreQueryTaskClass;
typedef struct _Block7Data Block7Data;
typedef struct _TrackerStoreTaskPrivate TrackerStoreTaskPrivate;
typedef struct _TrackerStoreQueryTaskPrivate TrackerStoreQueryTaskPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TRACKER_STORE_TYPE_UPDATE_TASK (tracker_store_update_task_get_type ())
#define TRACKER_STORE_UPDATE_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_STORE_TYPE_UPDATE_TASK, TrackerStoreUpdateTask))
#define TRACKER_STORE_UPDATE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_STORE_TYPE_UPDATE_TASK, TrackerStoreUpdateTaskClass))
#define TRACKER_STORE_IS_UPDATE_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_STORE_TYPE_UPDATE_TASK))
#define TRACKER_STORE_IS_UPDATE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_STORE_TYPE_UPDATE_TASK))
#define TRACKER_STORE_UPDATE_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_STORE_TYPE_UPDATE_TASK, TrackerStoreUpdateTaskClass))

typedef struct _TrackerStoreUpdateTask TrackerStoreUpdateTask;
typedef struct _TrackerStoreUpdateTaskClass TrackerStoreUpdateTaskClass;
typedef struct _TrackerStoreUpdateTaskPrivate TrackerStoreUpdateTaskPrivate;
typedef struct _Block8Data Block8Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

#define TRACKER_STORE_TYPE_TURTLE_TASK (tracker_store_turtle_task_get_type ())
#define TRACKER_STORE_TURTLE_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_STORE_TYPE_TURTLE_TASK, TrackerStoreTurtleTask))
#define TRACKER_STORE_TURTLE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_STORE_TYPE_TURTLE_TASK, TrackerStoreTurtleTaskClass))
#define TRACKER_STORE_IS_TURTLE_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_STORE_TYPE_TURTLE_TASK))
#define TRACKER_STORE_IS_TURTLE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_STORE_TYPE_TURTLE_TASK))
#define TRACKER_STORE_TURTLE_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_STORE_TYPE_TURTLE_TASK, TrackerStoreTurtleTaskClass))

typedef struct _TrackerStoreTurtleTask TrackerStoreTurtleTask;
typedef struct _TrackerStoreTurtleTaskClass TrackerStoreTurtleTaskClass;
typedef struct _TrackerStoreTurtleTaskPrivate TrackerStoreTurtleTaskPrivate;
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_queue_free0(var) ((var == NULL) ? NULL : (var = (g_queue_free (var), NULL)))
#define _g_thread_pool_free0(var) ((var == NULL) ? NULL : (var = (g_thread_pool_free (var, FALSE, TRUE), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _TrackerStoreSparqlQueryData TrackerStoreSparqlQueryData;
typedef struct _TrackerStoreSparqlUpdateData TrackerStoreSparqlUpdateData;
typedef struct _TrackerStoreSparqlUpdateBlankData TrackerStoreSparqlUpdateBlankData;
typedef struct _TrackerStoreQueueTurtleImportData TrackerStoreQueueTurtleImportData;
typedef struct _TrackerStorePauseData TrackerStorePauseData;
typedef struct _TrackerStoreParamSpecTask TrackerStoreParamSpecTask;
typedef struct _TrackerParamSpecStore TrackerParamSpecStore;

struct _TrackerStore {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TrackerStorePrivate * priv;
};

struct _TrackerStoreClass {
	GTypeClass parent_class;
	void (*finalize) (TrackerStore *self);
};

typedef enum  {
	TRACKER_STORE_PRIORITY_HIGH,
	TRACKER_STORE_PRIORITY_LOW,
	TRACKER_STORE_PRIORITY_TURTLE,
	TRACKER_STORE_PRIORITY_N_PRIORITIES
} TrackerStorePriority;

typedef enum  {
	TRACKER_STORE_TASK_TYPE_QUERY,
	TRACKER_STORE_TASK_TYPE_UPDATE,
	TRACKER_STORE_TASK_TYPE_UPDATE_BLANK,
	TRACKER_STORE_TASK_TYPE_TURTLE
} TrackerStoreTaskType;

struct _Block7Data {
	int _ref_count_;
	TrackerStoreQueryTask* query_task;
};

struct _TrackerStoreTask {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TrackerStoreTaskPrivate * priv;
	TrackerStoreTaskType type;
	gchar* client_id;
	GError* error;
	GSourceFunc callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
};

struct _TrackerStoreTaskClass {
	GTypeClass parent_class;
	void (*finalize) (TrackerStoreTask *self);
};

typedef void (*TrackerStoreSparqlQueryInThread) (TrackerDBCursor* cursor, void* user_data, GError** error);
struct _TrackerStoreQueryTask {
	TrackerStoreTask parent_instance;
	TrackerStoreQueryTaskPrivate * priv;
	gchar* query;
	GCancellable* cancellable;
	guint watchdog_id;
	TrackerStoreSparqlQueryInThread in_thread;
	gpointer in_thread_target;
	GDestroyNotify in_thread_target_destroy_notify;
};

struct _TrackerStoreQueryTaskClass {
	TrackerStoreTaskClass parent_class;
};

struct _TrackerStoreUpdateTask {
	TrackerStoreTask parent_instance;
	TrackerStoreUpdateTaskPrivate * priv;
	gchar* query;
	GVariant* blank_nodes;
	TrackerStorePriority priority;
};

struct _TrackerStoreUpdateTaskClass {
	TrackerStoreTaskClass parent_class;
};

struct _Block8Data {
	int _ref_count_;
	TrackerStoreTask* task;
};

struct _TrackerStoreTurtleTask {
	TrackerStoreTask parent_instance;
	TrackerStoreTurtleTaskPrivate * priv;
	gchar* path;
};

struct _TrackerStoreTurtleTaskClass {
	TrackerStoreTaskClass parent_class;
};

struct _TrackerStoreSparqlQueryData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	gchar* sparql;
	TrackerStorePriority priority;
	TrackerStoreSparqlQueryInThread in_thread;
	gpointer in_thread_target;
	gchar* client_id;
	TrackerStoreQueryTask* _tmp0_;
	TrackerStoreQueryTask* task;
	TrackerStoreQueryTask* _tmp1_;
	TrackerStoreQueryTask* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	TrackerStoreQueryTask* _tmp5_;
	GCancellable* _tmp6_;
	TrackerStoreQueryTask* _tmp7_;
	TrackerStoreSparqlQueryInThread _tmp8_;
	void* _tmp8__target;
	TrackerStoreQueryTask* _tmp9_;
	TrackerStoreQueryTask* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	TrackerStorePriority _tmp13_;
	GQueue* _tmp14_;
	TrackerStoreQueryTask* _tmp15_;
	TrackerStoreTask* _tmp16_;
	TrackerStoreQueryTask* _tmp17_;
	GError* _tmp18_;
	TrackerStoreQueryTask* _tmp19_;
	GError* _tmp20_;
	GError* _tmp21_;
	GError * _inner_error_;
};

struct _TrackerStoreSparqlUpdateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	gchar* sparql;
	TrackerStorePriority priority;
	gchar* client_id;
	TrackerStoreUpdateTask* _tmp0_;
	TrackerStoreUpdateTask* task;
	TrackerStoreUpdateTask* _tmp1_;
	TrackerStoreUpdateTask* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	TrackerStoreUpdateTask* _tmp5_;
	TrackerStorePriority _tmp6_;
	TrackerStoreUpdateTask* _tmp7_;
	TrackerStoreUpdateTask* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	TrackerStorePriority _tmp11_;
	GQueue* _tmp12_;
	TrackerStoreUpdateTask* _tmp13_;
	TrackerStoreTask* _tmp14_;
	TrackerStoreUpdateTask* _tmp15_;
	GError* _tmp16_;
	TrackerStoreUpdateTask* _tmp17_;
	GError* _tmp18_;
	GError* _tmp19_;
	GError * _inner_error_;
};

struct _TrackerStoreSparqlUpdateBlankData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	gchar* sparql;
	TrackerStorePriority priority;
	gchar* client_id;
	GVariant* result;
	TrackerStoreUpdateTask* _tmp0_;
	TrackerStoreUpdateTask* task;
	TrackerStoreUpdateTask* _tmp1_;
	TrackerStoreUpdateTask* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	TrackerStoreUpdateTask* _tmp5_;
	TrackerStorePriority _tmp6_;
	TrackerStoreUpdateTask* _tmp7_;
	TrackerStoreUpdateTask* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	TrackerStorePriority _tmp11_;
	GQueue* _tmp12_;
	TrackerStoreUpdateTask* _tmp13_;
	TrackerStoreTask* _tmp14_;
	TrackerStoreUpdateTask* _tmp15_;
	GError* _tmp16_;
	TrackerStoreUpdateTask* _tmp17_;
	GError* _tmp18_;
	GError* _tmp19_;
	TrackerStoreUpdateTask* _tmp20_;
	GVariant* _tmp21_;
	GVariant* _tmp22_;
	GError * _inner_error_;
};

struct _TrackerStoreQueueTurtleImportData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GFile* file;
	gchar* client_id;
	TrackerStoreTurtleTask* _tmp0_;
	TrackerStoreTurtleTask* task;
	TrackerStoreTurtleTask* _tmp1_;
	TrackerStoreTurtleTask* _tmp2_;
	GFile* _tmp3_;
	gchar* _tmp4_;
	TrackerStoreTurtleTask* _tmp5_;
	TrackerStoreTurtleTask* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	GQueue* _tmp9_;
	TrackerStoreTurtleTask* _tmp10_;
	TrackerStoreTask* _tmp11_;
	TrackerStoreTurtleTask* _tmp12_;
	GError* _tmp13_;
	TrackerStoreTurtleTask* _tmp14_;
	GError* _tmp15_;
	GError* _tmp16_;
	GError * _inner_error_;
};

struct _TrackerStorePauseData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	gboolean _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gint _tmp4_;
	GThreadPool* _tmp5_;
	GThreadPool* _tmp6_;
	GError* e;
	GError* _tmp7_;
	const gchar* _tmp8_;
	gboolean _tmp9_;
	GError * _inner_error_;
};

struct _TrackerStoreParamSpecTask {
	GParamSpec parent_instance;
};

struct _TrackerParamSpecStore {
	GParamSpec parent_instance;
};


static gpointer tracker_store_parent_class = NULL;
static GQueue* tracker_store_query_queues[3];
static GQueue* tracker_store_query_queues[3] = {0};
static GQueue* tracker_store_update_queues[3];
static GQueue* tracker_store_update_queues[3] = {0};
static gint tracker_store_n_queries_running;
static gint tracker_store_n_queries_running = 0;
static gboolean tracker_store_update_running;
static gboolean tracker_store_update_running = FALSE;
static GThreadPool* tracker_store_update_pool;
static GThreadPool* tracker_store_update_pool = NULL;
static GThreadPool* tracker_store_query_pool;
static GThreadPool* tracker_store_query_pool = NULL;
static GThreadPool* tracker_store_checkpoint_pool;
static GThreadPool* tracker_store_checkpoint_pool = NULL;
static GPtrArray* tracker_store_running_tasks;
static GPtrArray* tracker_store_running_tasks = NULL;
static gint tracker_store_max_task_time;
static gint tracker_store_max_task_time = 0;
static gboolean tracker_store_active;
static gboolean tracker_store_active = FALSE;
static GSourceFunc tracker_store_active_callback;
static gpointer tracker_store_active_callback_target;
static GDestroyNotify tracker_store_active_callback_target_destroy_notify;
static GSourceFunc tracker_store_active_callback = NULL;
static gpointer tracker_store_active_callback_target = NULL;
static GDestroyNotify tracker_store_active_callback_target_destroy_notify = NULL;
static gint tracker_store_checkpointing;
static gint tracker_store_checkpointing = 0;
static gpointer tracker_store_task_parent_class = NULL;
static gpointer tracker_store_query_task_parent_class = NULL;
static gpointer tracker_store_update_task_parent_class = NULL;
static gpointer tracker_store_turtle_task_parent_class = NULL;

gpointer tracker_store_ref (gpointer instance);
void tracker_store_unref (gpointer instance);
GParamSpec* tracker_param_spec_store (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void tracker_value_set_store (GValue* value, gpointer v_object);
void tracker_value_take_store (GValue* value, gpointer v_object);
gpointer tracker_value_get_store (const GValue* value);
GType tracker_store_get_type (void) G_GNUC_CONST;
enum  {
	TRACKER_STORE_DUMMY_PROPERTY
};
GType tracker_store_priority_get_type (void) G_GNUC_CONST;
static GType tracker_store_task_type_get_type (void) G_GNUC_UNUSED;
static gpointer tracker_store_task_ref (gpointer instance);
static void tracker_store_task_unref (gpointer instance);
static GParamSpec* tracker_store_param_spec_task (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void tracker_store_value_set_task (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void tracker_store_value_take_task (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer tracker_store_value_get_task (const GValue* value) G_GNUC_UNUSED;
static GType tracker_store_task_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define TRACKER_STORE_MAX_CONCURRENT_QUERIES 2
#define TRACKER_STORE_MAX_TASK_TIME 30
static void tracker_store_sched (void);
static GType tracker_store_query_task_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (Block7Data* _data7_);
static gboolean ____lambda0_ (Block7Data* _data7_);
static gboolean _____lambda0__gsource_func (gpointer self);
static TrackerDataCommitType tracker_store_commit_type (TrackerStoreTask* task);
static GType tracker_store_update_task_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static gboolean tracker_store_task_finish_cb (TrackerStoreTask* task);
static void tracker_store_pool_dispatch_cb (TrackerStoreTask* task);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (Block8Data* _data8_);
static void tracker_store_wal_hook (gint n_pages);
static void _tracker_store_wal_hook_tracker_db_wal_callback (gint n_pages);
static GType tracker_store_turtle_task_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static gboolean __lambda1_ (Block8Data* _data8_);
static gboolean ___lambda1__gsource_func (gpointer self);
void tracker_store_wal_checkpoint (void);
static void tracker_store_checkpoint_dispatch_cb (gboolean task);
void tracker_store_init (void);
static void _tracker_store_task_unref0_ (gpointer var);
static void _tracker_store_pool_dispatch_cb_gfunc (gconstpointer data, gpointer self);
static void _tracker_store_checkpoint_dispatch_cb_gfunc (gconstpointer data, gpointer self);
void tracker_store_shutdown (void);
static void tracker_store_sparql_query_data_free (gpointer _data);
void tracker_store_sparql_query (const gchar* sparql, TrackerStorePriority priority, TrackerStoreSparqlQueryInThread in_thread, void* in_thread_target, const gchar* client_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_store_sparql_query_finish (GAsyncResult* _res_, GError** error);
static gboolean tracker_store_sparql_query_co (TrackerStoreSparqlQueryData* _data_);
static TrackerStoreQueryTask* tracker_store_query_task_new (void);
static TrackerStoreQueryTask* tracker_store_query_task_construct (GType object_type);
static gboolean _tracker_store_sparql_query_co_gsource_func (gpointer self);
static void tracker_store_sparql_update_data_free (gpointer _data);
void tracker_store_sparql_update (const gchar* sparql, TrackerStorePriority priority, const gchar* client_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_store_sparql_update_finish (GAsyncResult* _res_, GError** error);
static gboolean tracker_store_sparql_update_co (TrackerStoreSparqlUpdateData* _data_);
static TrackerStoreUpdateTask* tracker_store_update_task_new (void);
static TrackerStoreUpdateTask* tracker_store_update_task_construct (GType object_type);
static gboolean _tracker_store_sparql_update_co_gsource_func (gpointer self);
static void tracker_store_sparql_update_blank_data_free (gpointer _data);
void tracker_store_sparql_update_blank (const gchar* sparql, TrackerStorePriority priority, const gchar* client_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
GVariant* tracker_store_sparql_update_blank_finish (GAsyncResult* _res_, GError** error);
static gboolean tracker_store_sparql_update_blank_co (TrackerStoreSparqlUpdateBlankData* _data_);
static gboolean _tracker_store_sparql_update_blank_co_gsource_func (gpointer self);
static void tracker_store_queue_turtle_import_data_free (gpointer _data);
void tracker_store_queue_turtle_import (GFile* file, const gchar* client_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_store_queue_turtle_import_finish (GAsyncResult* _res_, GError** error);
static gboolean tracker_store_queue_turtle_import_co (TrackerStoreQueueTurtleImportData* _data_);
static TrackerStoreTurtleTask* tracker_store_turtle_task_new (void);
static TrackerStoreTurtleTask* tracker_store_turtle_task_construct (GType object_type);
static gboolean _tracker_store_queue_turtle_import_co_gsource_func (gpointer self);
guint tracker_store_get_queue_size (TrackerStore* self);
void tracker_store_unreg_batches (const gchar* client_id);
static void tracker_store_pause_data_free (gpointer _data);
void tracker_store_pause (GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_store_pause_finish (GAsyncResult* _res_);
static gboolean tracker_store_pause_co (TrackerStorePauseData* _data_);
static gboolean _tracker_store_pause_co_gsource_func (gpointer self);
void tracker_store_resume (void);
TrackerStore* tracker_store_new (void);
TrackerStore* tracker_store_construct (GType object_type);
enum  {
	TRACKER_STORE_TASK_DUMMY_PROPERTY
};
static TrackerStoreTask* tracker_store_task_construct (GType object_type);
static void tracker_store_task_finalize (TrackerStoreTask* obj);
enum  {
	TRACKER_STORE_QUERY_TASK_DUMMY_PROPERTY
};
static void tracker_store_query_task_finalize (TrackerStoreTask* obj);
enum  {
	TRACKER_STORE_UPDATE_TASK_DUMMY_PROPERTY
};
static void tracker_store_update_task_finalize (TrackerStoreTask* obj);
enum  {
	TRACKER_STORE_TURTLE_TASK_DUMMY_PROPERTY
};
static void tracker_store_turtle_task_finalize (TrackerStoreTask* obj);
static void tracker_store_finalize (TrackerStore* obj);


GType tracker_store_priority_get_type (void) {
	static volatile gsize tracker_store_priority_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_store_priority_type_id__volatile)) {
		static const GEnumValue values[] = {{TRACKER_STORE_PRIORITY_HIGH, "TRACKER_STORE_PRIORITY_HIGH", "high"}, {TRACKER_STORE_PRIORITY_LOW, "TRACKER_STORE_PRIORITY_LOW", "low"}, {TRACKER_STORE_PRIORITY_TURTLE, "TRACKER_STORE_PRIORITY_TURTLE", "turtle"}, {TRACKER_STORE_PRIORITY_N_PRIORITIES, "TRACKER_STORE_PRIORITY_N_PRIORITIES", "n-priorities"}, {0, NULL, NULL}};
		GType tracker_store_priority_type_id;
		tracker_store_priority_type_id = g_enum_register_static ("TrackerStorePriority", values);
		g_once_init_leave (&tracker_store_priority_type_id__volatile, tracker_store_priority_type_id);
	}
	return tracker_store_priority_type_id__volatile;
}


static GType tracker_store_task_type_get_type (void) {
	static volatile gsize tracker_store_task_type_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_store_task_type_type_id__volatile)) {
		static const GEnumValue values[] = {{TRACKER_STORE_TASK_TYPE_QUERY, "TRACKER_STORE_TASK_TYPE_QUERY", "query"}, {TRACKER_STORE_TASK_TYPE_UPDATE, "TRACKER_STORE_TASK_TYPE_UPDATE", "update"}, {TRACKER_STORE_TASK_TYPE_UPDATE_BLANK, "TRACKER_STORE_TASK_TYPE_UPDATE_BLANK", "update-blank"}, {TRACKER_STORE_TASK_TYPE_TURTLE, "TRACKER_STORE_TASK_TYPE_TURTLE", "turtle"}, {0, NULL, NULL}};
		GType tracker_store_task_type_type_id;
		tracker_store_task_type_type_id = g_enum_register_static ("TrackerStoreTaskType", values);
		g_once_init_leave (&tracker_store_task_type_type_id__volatile, tracker_store_task_type_type_id);
	}
	return tracker_store_task_type_type_id__volatile;
}


static gpointer _tracker_store_task_ref0 (gpointer self) {
#line 103 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	return self ? tracker_store_task_ref (self) : NULL;
#line 530 "tracker-store.c"
}


static Block7Data* block7_data_ref (Block7Data* _data7_) {
#line 105 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	g_atomic_int_inc (&_data7_->_ref_count_);
#line 105 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	return _data7_;
#line 539 "tracker-store.c"
}


static void block7_data_unref (Block7Data* _data7_) {
#line 105 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
#line 105 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_tracker_store_task_unref0 (_data7_->query_task);
#line 105 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		g_slice_free (Block7Data, _data7_);
#line 550 "tracker-store.c"
	}
}


static gboolean ____lambda0_ (Block7Data* _data7_) {
	gboolean result = FALSE;
	TrackerStoreQueryTask* _tmp0_;
	GCancellable* _tmp1_;
#line 108 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_tmp0_ = _data7_->query_task;
#line 108 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_tmp1_ = _tmp0_->cancellable;
#line 108 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	g_cancellable_cancel (_tmp1_);
#line 109 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	result = FALSE;
#line 109 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	return result;
#line 569 "tracker-store.c"
}


static gboolean _____lambda0__gsource_func (gpointer self) {
	gboolean result;
	result = ____lambda0_ (self);
#line 107 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	return result;
#line 578 "tracker-store.c"
}


static void tracker_store_sched (void) {
	TrackerStoreTask* task;
	gboolean _tmp0_;
	gboolean _tmp23_;
	GError * _inner_error_ = NULL;
#line 86 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	task = NULL;
#line 88 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_tmp0_ = tracker_store_active;
#line 88 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	if (!_tmp0_) {
#line 89 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_tracker_store_task_unref0 (task);
#line 89 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		return;
#line 597 "tracker-store.c"
	}
#line 92 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	while (TRUE) {
#line 601 "tracker-store.c"
		gint _tmp1_;
		TrackerStoreTask* _tmp10_;
		GPtrArray* _tmp11_;
		TrackerStoreTask* _tmp12_;
		TrackerStoreTask* _tmp13_;
		gint _tmp14_;
		gint _tmp20_;
#line 92 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_tmp1_ = tracker_store_n_queries_running;
#line 92 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		if (!(_tmp1_ < TRACKER_STORE_MAX_CONCURRENT_QUERIES)) {
#line 92 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			break;
#line 615 "tracker-store.c"
		}
		{
			gint i;
#line 93 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			i = 0;
#line 621 "tracker-store.c"
			{
				gboolean _tmp2_;
#line 93 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp2_ = TRUE;
#line 93 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				while (TRUE) {
#line 628 "tracker-store.c"
					gboolean _tmp3_;
					gint _tmp5_;
					gint _tmp6_;
					GQueue* _tmp7_;
					gpointer _tmp8_ = NULL;
					TrackerStoreTask* _tmp9_;
#line 93 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					_tmp3_ = _tmp2_;
#line 93 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					if (!_tmp3_) {
#line 639 "tracker-store.c"
						gint _tmp4_;
#line 93 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
						_tmp4_ = i;
#line 93 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
						i = _tmp4_ + 1;
#line 645 "tracker-store.c"
					}
#line 93 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					_tmp2_ = FALSE;
#line 93 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					_tmp5_ = i;
#line 93 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					if (!(_tmp5_ < ((gint) TRACKER_STORE_PRIORITY_N_PRIORITIES))) {
#line 93 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
						break;
#line 655 "tracker-store.c"
					}
#line 94 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					_tmp6_ = i;
#line 94 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					_tmp7_ = tracker_store_query_queues[_tmp6_];
#line 94 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					_tmp8_ = g_queue_pop_head (_tmp7_);
#line 94 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					_tracker_store_task_unref0 (task);
#line 94 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					task = (TrackerStoreTask*) _tmp8_;
#line 95 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					_tmp9_ = task;
#line 95 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					if (_tmp9_ != NULL) {
#line 96 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
						break;
#line 673 "tracker-store.c"
					}
				}
			}
		}
#line 99 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_tmp10_ = task;
#line 99 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		if (_tmp10_ == NULL) {
#line 101 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			break;
#line 684 "tracker-store.c"
		}
#line 103 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_tmp11_ = tracker_store_running_tasks;
#line 103 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_tmp12_ = task;
#line 103 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_tmp13_ = _tracker_store_task_ref0 (_tmp12_);
#line 103 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		g_ptr_array_add (_tmp11_, _tmp13_);
#line 105 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_tmp14_ = tracker_store_max_task_time;
#line 105 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		if (_tmp14_ != 0) {
#line 698 "tracker-store.c"
			Block7Data* _data7_;
			TrackerStoreTask* _tmp15_;
			TrackerStoreQueryTask* _tmp16_;
			TrackerStoreQueryTask* _tmp17_;
			gint _tmp18_;
			guint _tmp19_ = 0U;
#line 105 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			_data7_ = g_slice_new0 (Block7Data);
#line 105 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			_data7_->_ref_count_ = 1;
#line 106 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			_tmp15_ = task;
#line 106 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			_tmp16_ = _tracker_store_task_ref0 (TRACKER_STORE_QUERY_TASK (_tmp15_));
#line 106 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			_data7_->query_task = _tmp16_;
#line 107 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			_tmp17_ = _data7_->query_task;
#line 107 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			_tmp18_ = tracker_store_max_task_time;
#line 107 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			_tmp19_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) _tmp18_, _____lambda0__gsource_func, block7_data_ref (_data7_), block7_data_unref);
#line 107 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			_tmp17_->watchdog_id = _tmp19_;
#line 105 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			block7_data_unref (_data7_);
#line 105 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			_data7_ = NULL;
#line 727 "tracker-store.c"
		}
#line 113 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_tmp20_ = tracker_store_n_queries_running;
#line 113 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_n_queries_running = _tmp20_ + 1;
#line 733 "tracker-store.c"
		{
			GThreadPool* _tmp21_;
			TrackerStoreTask* _tmp22_;
#line 115 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			_tmp21_ = tracker_store_query_pool;
#line 115 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			_tmp22_ = task;
#line 115 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			g_thread_pool_push (_tmp21_, _tmp22_, &_inner_error_);
#line 115 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			if (_inner_error_ != NULL) {
#line 745 "tracker-store.c"
				goto __catch18_g_error;
			}
		}
		goto __finally18;
		__catch18_g_error:
		{
			GError* e = NULL;
#line 114 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			e = _inner_error_;
#line 114 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			_inner_error_ = NULL;
#line 114 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			_g_error_free0 (e);
#line 759 "tracker-store.c"
		}
		__finally18:
#line 114 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		if (_inner_error_ != NULL) {
#line 114 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			_tracker_store_task_unref0 (task);
#line 114 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 114 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			g_clear_error (&_inner_error_);
#line 114 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			return;
#line 772 "tracker-store.c"
		}
	}
#line 121 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_tmp23_ = tracker_store_update_running;
#line 121 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	if (!_tmp23_) {
#line 779 "tracker-store.c"
		TrackerStoreTask* _tmp32_;
		{
			gint i;
#line 122 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			i = 0;
#line 785 "tracker-store.c"
			{
				gboolean _tmp24_;
#line 122 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp24_ = TRUE;
#line 122 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				while (TRUE) {
#line 792 "tracker-store.c"
					gboolean _tmp25_;
					gint _tmp27_;
					gint _tmp28_;
					GQueue* _tmp29_;
					gpointer _tmp30_ = NULL;
					TrackerStoreTask* _tmp31_;
#line 122 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					_tmp25_ = _tmp24_;
#line 122 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					if (!_tmp25_) {
#line 803 "tracker-store.c"
						gint _tmp26_;
#line 122 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
						_tmp26_ = i;
#line 122 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
						i = _tmp26_ + 1;
#line 809 "tracker-store.c"
					}
#line 122 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					_tmp24_ = FALSE;
#line 122 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					_tmp27_ = i;
#line 122 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					if (!(_tmp27_ < ((gint) TRACKER_STORE_PRIORITY_N_PRIORITIES))) {
#line 122 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
						break;
#line 819 "tracker-store.c"
					}
#line 123 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					_tmp28_ = i;
#line 123 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					_tmp29_ = tracker_store_update_queues[_tmp28_];
#line 123 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					_tmp30_ = g_queue_pop_head (_tmp29_);
#line 123 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					_tracker_store_task_unref0 (task);
#line 123 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					task = (TrackerStoreTask*) _tmp30_;
#line 124 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					_tmp31_ = task;
#line 124 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					if (_tmp31_ != NULL) {
#line 125 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
						break;
#line 837 "tracker-store.c"
					}
				}
			}
		}
#line 128 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_tmp32_ = task;
#line 128 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		if (_tmp32_ != NULL) {
#line 129 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			tracker_store_update_running = TRUE;
#line 848 "tracker-store.c"
			{
				GThreadPool* _tmp33_;
				TrackerStoreTask* _tmp34_;
#line 131 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp33_ = tracker_store_update_pool;
#line 131 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp34_ = task;
#line 131 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				g_thread_pool_push (_tmp33_, _tmp34_, &_inner_error_);
#line 131 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				if (_inner_error_ != NULL) {
#line 860 "tracker-store.c"
					goto __catch19_g_error;
				}
			}
			goto __finally19;
			__catch19_g_error:
			{
				GError* e = NULL;
#line 130 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				e = _inner_error_;
#line 130 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_inner_error_ = NULL;
#line 130 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_g_error_free0 (e);
#line 874 "tracker-store.c"
			}
			__finally19:
#line 130 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			if (_inner_error_ != NULL) {
#line 130 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tracker_store_task_unref0 (task);
#line 130 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 130 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				g_clear_error (&_inner_error_);
#line 130 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				return;
#line 887 "tracker-store.c"
			}
		}
	}
#line 85 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_tracker_store_task_unref0 (task);
#line 893 "tracker-store.c"
}


static TrackerDataCommitType tracker_store_commit_type (TrackerStoreTask* task) {
	TrackerDataCommitType result = 0;
	TrackerStoreTask* _tmp0_;
	TrackerStoreTaskType _tmp1_;
#line 139 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	g_return_val_if_fail (task != NULL, 0);
#line 140 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_tmp0_ = task;
#line 140 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_tmp1_ = _tmp0_->type;
#line 140 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	switch (_tmp1_) {
#line 140 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		case TRACKER_STORE_TASK_TYPE_UPDATE:
#line 140 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		case TRACKER_STORE_TASK_TYPE_UPDATE_BLANK:
#line 913 "tracker-store.c"
		{
			TrackerStoreTask* _tmp2_;
			TrackerStorePriority _tmp3_;
#line 143 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			_tmp2_ = task;
#line 143 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			_tmp3_ = TRACKER_STORE_UPDATE_TASK (_tmp2_)->priority;
#line 143 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			if (_tmp3_ == TRACKER_STORE_PRIORITY_HIGH) {
#line 144 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				result = TRACKER_DATA_COMMIT_REGULAR;
#line 144 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				return result;
#line 927 "tracker-store.c"
			} else {
				GQueue* _tmp4_;
				guint _tmp5_ = 0U;
#line 145 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp4_ = tracker_store_update_queues[TRACKER_STORE_PRIORITY_LOW];
#line 145 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp5_ = g_queue_get_length (_tmp4_);
#line 145 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				if (_tmp5_ > ((guint) 0)) {
#line 146 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					result = TRACKER_DATA_COMMIT_BATCH;
#line 146 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					return result;
#line 941 "tracker-store.c"
				} else {
#line 148 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					result = TRACKER_DATA_COMMIT_BATCH_LAST;
#line 148 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					return result;
#line 947 "tracker-store.c"
				}
			}
		}
#line 140 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		case TRACKER_STORE_TASK_TYPE_TURTLE:
#line 953 "tracker-store.c"
		{
			GQueue* _tmp6_;
			guint _tmp7_ = 0U;
#line 151 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			_tmp6_ = tracker_store_update_queues[TRACKER_STORE_PRIORITY_TURTLE];
#line 151 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			_tmp7_ = g_queue_get_length (_tmp6_);
#line 151 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			if (_tmp7_ > ((guint) 0)) {
#line 152 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				result = TRACKER_DATA_COMMIT_BATCH;
#line 152 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				return result;
#line 967 "tracker-store.c"
			} else {
#line 154 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				result = TRACKER_DATA_COMMIT_BATCH_LAST;
#line 154 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				return result;
#line 973 "tracker-store.c"
			}
		}
		default:
		{
#line 157 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			g_warn_if_reached ();
#line 158 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			result = TRACKER_DATA_COMMIT_REGULAR;
#line 158 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			return result;
#line 984 "tracker-store.c"
		}
	}
}


static gpointer _g_error_copy0 (gpointer self) {
#line 170 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	return self ? g_error_copy (self) : NULL;
#line 993 "tracker-store.c"
}


static gboolean tracker_store_task_finish_cb (TrackerStoreTask* task) {
	gboolean result = FALSE;
	TrackerStoreTask* _tmp0_;
	TrackerStoreTaskType _tmp1_;
	gboolean _tmp39_ = FALSE;
	gboolean _tmp40_ = FALSE;
	gint _tmp41_;
	gboolean _tmp43_;
	gboolean _tmp45_;
	GError * _inner_error_ = NULL;
#line 162 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	g_return_val_if_fail (task != NULL, FALSE);
#line 163 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_tmp0_ = task;
#line 163 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_tmp1_ = _tmp0_->type;
#line 163 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	if (_tmp1_ == TRACKER_STORE_TASK_TYPE_QUERY) {
#line 1015 "tracker-store.c"
		TrackerStoreTask* _tmp2_;
		TrackerStoreQueryTask* _tmp3_;
		TrackerStoreQueryTask* query_task;
		TrackerStoreTask* _tmp4_;
		GError* _tmp5_;
		TrackerStoreTask* _tmp11_;
		GSourceFunc _tmp12_;
		void* _tmp12__target;
		TrackerStoreTask* _tmp13_;
		GPtrArray* _tmp14_;
		TrackerStoreTask* _tmp15_;
		gint _tmp16_;
#line 164 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_tmp2_ = task;
#line 164 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_tmp3_ = _tracker_store_task_ref0 (TRACKER_STORE_QUERY_TASK (_tmp2_));
#line 164 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		query_task = _tmp3_;
#line 166 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_tmp4_ = task;
#line 166 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_tmp5_ = _tmp4_->error;
#line 166 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		if (_tmp5_ == NULL) {
#line 1040 "tracker-store.c"
			{
				TrackerStoreQueryTask* _tmp6_;
				GCancellable* _tmp7_;
#line 168 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp6_ = query_task;
#line 168 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp7_ = _tmp6_->cancellable;
#line 168 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				g_cancellable_set_error_if_cancelled (_tmp7_, &_inner_error_);
#line 168 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				if (_inner_error_ != NULL) {
#line 1052 "tracker-store.c"
					goto __catch20_g_error;
				}
			}
			goto __finally20;
			__catch20_g_error:
			{
				GError* e = NULL;
				TrackerStoreTask* _tmp8_;
				GError* _tmp9_;
				GError* _tmp10_;
#line 167 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				e = _inner_error_;
#line 167 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_inner_error_ = NULL;
#line 170 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp8_ = task;
#line 170 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp9_ = e;
#line 170 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp10_ = _g_error_copy0 (_tmp9_);
#line 170 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_g_error_free0 (_tmp8_->error);
#line 170 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp8_->error = _tmp10_;
#line 167 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_g_error_free0 (e);
#line 1079 "tracker-store.c"
			}
			__finally20:
#line 167 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			if (_inner_error_ != NULL) {
#line 167 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tracker_store_task_unref0 (query_task);
#line 167 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 167 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				g_clear_error (&_inner_error_);
#line 167 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				return FALSE;
#line 1092 "tracker-store.c"
			}
		}
#line 174 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_tmp11_ = task;
#line 174 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_tmp12_ = _tmp11_->callback;
#line 174 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_tmp12__target = _tmp11_->callback_target;
#line 174 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_tmp12_ (_tmp12__target);
#line 175 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_tmp13_ = task;
#line 175 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_g_error_free0 (_tmp13_->error);
#line 175 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_tmp13_->error = NULL;
#line 177 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_tmp14_ = tracker_store_running_tasks;
#line 177 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_tmp15_ = task;
#line 177 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		g_ptr_array_remove (_tmp14_, _tmp15_);
#line 178 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_tmp16_ = tracker_store_n_queries_running;
#line 178 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_n_queries_running = _tmp16_ - 1;
#line 163 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_tracker_store_task_unref0 (query_task);
#line 1121 "tracker-store.c"
	} else {
		gboolean _tmp17_ = FALSE;
		TrackerStoreTask* _tmp18_;
		TrackerStoreTaskType _tmp19_;
		gboolean _tmp22_;
#line 179 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_tmp18_ = task;
#line 179 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_tmp19_ = _tmp18_->type;
#line 179 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		if (_tmp19_ == TRACKER_STORE_TASK_TYPE_UPDATE) {
#line 179 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			_tmp17_ = TRUE;
#line 1135 "tracker-store.c"
		} else {
			TrackerStoreTask* _tmp20_;
			TrackerStoreTaskType _tmp21_;
#line 179 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			_tmp20_ = task;
#line 179 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			_tmp21_ = _tmp20_->type;
#line 179 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			_tmp17_ = _tmp21_ == TRACKER_STORE_TASK_TYPE_UPDATE_BLANK;
#line 1145 "tracker-store.c"
		}
#line 179 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_tmp22_ = _tmp17_;
#line 179 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		if (_tmp22_) {
#line 1151 "tracker-store.c"
			TrackerStoreTask* _tmp23_;
			GError* _tmp24_;
			TrackerStoreTask* _tmp27_;
			GSourceFunc _tmp28_;
			void* _tmp28__target;
			TrackerStoreTask* _tmp29_;
#line 180 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			_tmp23_ = task;
#line 180 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			_tmp24_ = _tmp23_->error;
#line 180 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			if (_tmp24_ == NULL) {
#line 1164 "tracker-store.c"
				TrackerStoreTask* _tmp25_;
				TrackerDataCommitType _tmp26_ = 0;
#line 181 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp25_ = task;
#line 181 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp26_ = tracker_store_commit_type (_tmp25_);
#line 181 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				tracker_data_notify_transaction (_tmp26_);
#line 1173 "tracker-store.c"
			}
#line 184 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			_tmp27_ = task;
#line 184 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			_tmp28_ = _tmp27_->callback;
#line 184 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			_tmp28__target = _tmp27_->callback_target;
#line 184 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			_tmp28_ (_tmp28__target);
#line 185 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			_tmp29_ = task;
#line 185 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			_g_error_free0 (_tmp29_->error);
#line 185 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			_tmp29_->error = NULL;
#line 187 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			tracker_store_update_running = FALSE;
#line 1191 "tracker-store.c"
		} else {
			TrackerStoreTask* _tmp30_;
			TrackerStoreTaskType _tmp31_;
#line 188 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			_tmp30_ = task;
#line 188 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			_tmp31_ = _tmp30_->type;
#line 188 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			if (_tmp31_ == TRACKER_STORE_TASK_TYPE_TURTLE) {
#line 1201 "tracker-store.c"
				TrackerStoreTask* _tmp32_;
				GError* _tmp33_;
				TrackerStoreTask* _tmp36_;
				GSourceFunc _tmp37_;
				void* _tmp37__target;
				TrackerStoreTask* _tmp38_;
#line 189 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp32_ = task;
#line 189 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp33_ = _tmp32_->error;
#line 189 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				if (_tmp33_ == NULL) {
#line 1214 "tracker-store.c"
					TrackerStoreTask* _tmp34_;
					TrackerDataCommitType _tmp35_ = 0;
#line 190 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					_tmp34_ = task;
#line 190 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					_tmp35_ = tracker_store_commit_type (_tmp34_);
#line 190 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					tracker_data_notify_transaction (_tmp35_);
#line 1223 "tracker-store.c"
				}
#line 193 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp36_ = task;
#line 193 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp37_ = _tmp36_->callback;
#line 193 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp37__target = _tmp36_->callback_target;
#line 193 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp37_ (_tmp37__target);
#line 194 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp38_ = task;
#line 194 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_g_error_free0 (_tmp38_->error);
#line 194 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp38_->error = NULL;
#line 196 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				tracker_store_update_running = FALSE;
#line 1241 "tracker-store.c"
			}
		}
	}
#line 199 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_tmp41_ = tracker_store_n_queries_running;
#line 199 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	if (_tmp41_ == 0) {
#line 1249 "tracker-store.c"
		gboolean _tmp42_;
#line 199 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_tmp42_ = tracker_store_update_running;
#line 199 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_tmp40_ = !_tmp42_;
#line 1255 "tracker-store.c"
	} else {
#line 199 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_tmp40_ = FALSE;
#line 1259 "tracker-store.c"
	}
#line 199 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_tmp43_ = _tmp40_;
#line 199 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	if (_tmp43_) {
#line 1265 "tracker-store.c"
		GSourceFunc _tmp44_;
		void* _tmp44__target;
#line 199 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_tmp44_ = tracker_store_active_callback;
#line 199 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_tmp44__target = tracker_store_active_callback_target;
#line 199 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_tmp39_ = _tmp44_ != NULL;
#line 1274 "tracker-store.c"
	} else {
#line 199 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_tmp39_ = FALSE;
#line 1278 "tracker-store.c"
	}
#line 199 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_tmp45_ = _tmp39_;
#line 199 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	if (_tmp45_) {
#line 1284 "tracker-store.c"
		GSourceFunc _tmp46_;
		void* _tmp46__target;
#line 200 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_tmp46_ = tracker_store_active_callback;
#line 200 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_tmp46__target = tracker_store_active_callback_target;
#line 200 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_tmp46_ (_tmp46__target);
#line 1293 "tracker-store.c"
	}
#line 203 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_sched ();
#line 205 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	result = FALSE;
#line 205 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	return result;
#line 1301 "tracker-store.c"
}


static Block8Data* block8_data_ref (Block8Data* _data8_) {
#line 208 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	g_atomic_int_inc (&_data8_->_ref_count_);
#line 208 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	return _data8_;
#line 1310 "tracker-store.c"
}


static void block8_data_unref (Block8Data* _data8_) {
#line 208 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
#line 208 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_tracker_store_task_unref0 (_data8_->task);
#line 208 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		g_slice_free (Block8Data, _data8_);
#line 1321 "tracker-store.c"
	}
}


static gpointer _g_object_ref0 (gpointer self) {
#line 217 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	return self ? g_object_ref (self) : NULL;
#line 1329 "tracker-store.c"
}


static void _tracker_store_wal_hook_tracker_db_wal_callback (gint n_pages) {
#line 218 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_wal_hook (n_pages);
#line 1336 "tracker-store.c"
}


static gboolean __lambda1_ (Block8Data* _data8_) {
	gboolean result = FALSE;
	TrackerStoreTask* _tmp0_;
#line 246 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_tmp0_ = _data8_->task;
#line 246 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_task_finish_cb (_tmp0_);
#line 247 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	result = FALSE;
#line 247 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	return result;
#line 1351 "tracker-store.c"
}


static gboolean ___lambda1__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda1_ (self);
#line 245 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	return result;
#line 1360 "tracker-store.c"
}


static void tracker_store_pool_dispatch_cb (TrackerStoreTask* task) {
	Block8Data* _data8_;
	TrackerStoreTask* _tmp0_;
	TrackerStoreTask* _tmp1_;
	GError * _inner_error_ = NULL;
#line 208 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	g_return_if_fail (task != NULL);
#line 208 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data8_ = g_slice_new0 (Block8Data);
#line 208 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data8_->_ref_count_ = 1;
#line 208 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_tmp0_ = task;
#line 208 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_tmp1_ = _tracker_store_task_ref0 (_tmp0_);
#line 208 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data8_->task = _tmp1_;
#line 1381 "tracker-store.c"
	{
		TrackerStoreTask* _tmp2_;
		TrackerStoreTaskType _tmp3_;
#line 210 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_tmp2_ = _data8_->task;
#line 210 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_tmp3_ = _tmp2_->type;
#line 210 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		if (_tmp3_ == TRACKER_STORE_TASK_TYPE_QUERY) {
#line 1391 "tracker-store.c"
			TrackerStoreTask* _tmp4_;
			TrackerStoreQueryTask* _tmp5_;
			TrackerStoreQueryTask* query_task;
			TrackerStoreQueryTask* _tmp6_;
			const gchar* _tmp7_;
			TrackerDBCursor* _tmp8_ = NULL;
			TrackerDBCursor* cursor;
			TrackerStoreQueryTask* _tmp9_;
			TrackerStoreSparqlQueryInThread _tmp10_;
			void* _tmp10__target;
			TrackerDBCursor* _tmp11_;
#line 211 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			_tmp4_ = _data8_->task;
#line 211 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			_tmp5_ = _tracker_store_task_ref0 (TRACKER_STORE_QUERY_TASK (_tmp4_));
#line 211 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			query_task = _tmp5_;
#line 213 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			_tmp6_ = query_task;
#line 213 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			_tmp7_ = _tmp6_->query;
#line 213 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			_tmp8_ = tracker_data_query_sparql_cursor (_tmp7_, &_inner_error_);
#line 213 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			cursor = _tmp8_;
#line 213 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			if (_inner_error_ != NULL) {
#line 213 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tracker_store_task_unref0 (query_task);
#line 1421 "tracker-store.c"
				goto __catch21_g_error;
			}
#line 215 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			_tmp9_ = query_task;
#line 215 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			_tmp10_ = _tmp9_->in_thread;
#line 215 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			_tmp10__target = _tmp9_->in_thread_target;
#line 215 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			_tmp11_ = cursor;
#line 215 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			_tmp10_ (_tmp11_, _tmp10__target, &_inner_error_);
#line 215 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			if (_inner_error_ != NULL) {
#line 215 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_g_object_unref0 (cursor);
#line 215 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tracker_store_task_unref0 (query_task);
#line 1440 "tracker-store.c"
				goto __catch21_g_error;
			}
#line 210 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			_g_object_unref0 (cursor);
#line 210 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			_tracker_store_task_unref0 (query_task);
#line 1447 "tracker-store.c"
		} else {
			TrackerDBInterface* _tmp12_ = NULL;
			TrackerDBInterface* _tmp13_;
			TrackerDBInterface* iface;
			TrackerDBInterface* _tmp14_;
			TrackerStoreTask* _tmp15_;
			TrackerStoreTaskType _tmp16_;
#line 217 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			_tmp12_ = tracker_db_manager_get_db_interface ();
#line 217 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			_tmp13_ = _g_object_ref0 (_tmp12_);
#line 217 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			iface = _tmp13_;
#line 218 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			_tmp14_ = iface;
#line 218 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			tracker_db_interface_sqlite_wal_hook (_tmp14_, _tracker_store_wal_hook_tracker_db_wal_callback);
#line 220 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			_tmp15_ = _data8_->task;
#line 220 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			_tmp16_ = _tmp15_->type;
#line 220 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			if (_tmp16_ == TRACKER_STORE_TASK_TYPE_UPDATE) {
#line 1471 "tracker-store.c"
				TrackerStoreTask* _tmp17_;
				TrackerStoreUpdateTask* _tmp18_;
				TrackerStoreUpdateTask* update_task;
				TrackerStoreUpdateTask* _tmp19_;
				const gchar* _tmp20_;
#line 221 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp17_ = _data8_->task;
#line 221 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp18_ = _tracker_store_task_ref0 (TRACKER_STORE_UPDATE_TASK (_tmp17_));
#line 221 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				update_task = _tmp18_;
#line 223 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp19_ = update_task;
#line 223 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp20_ = _tmp19_->query;
#line 223 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				tracker_data_update_sparql (_tmp20_, &_inner_error_);
#line 223 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				if (_inner_error_ != NULL) {
#line 223 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					_tracker_store_task_unref0 (update_task);
#line 223 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					_g_object_unref0 (iface);
#line 1495 "tracker-store.c"
					goto __catch21_g_error;
				}
#line 220 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tracker_store_task_unref0 (update_task);
#line 1500 "tracker-store.c"
			} else {
				TrackerStoreTask* _tmp21_;
				TrackerStoreTaskType _tmp22_;
#line 224 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp21_ = _data8_->task;
#line 224 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp22_ = _tmp21_->type;
#line 224 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				if (_tmp22_ == TRACKER_STORE_TASK_TYPE_UPDATE_BLANK) {
#line 1510 "tracker-store.c"
					TrackerStoreTask* _tmp23_;
					TrackerStoreUpdateTask* _tmp24_;
					TrackerStoreUpdateTask* update_task;
					TrackerStoreUpdateTask* _tmp25_;
					const gchar* _tmp26_;
					GVariant* _tmp27_ = NULL;
					GVariant* _tmp28_;
					TrackerStoreUpdateTask* _tmp29_;
#line 225 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					_tmp23_ = _data8_->task;
#line 225 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					_tmp24_ = _tracker_store_task_ref0 (TRACKER_STORE_UPDATE_TASK (_tmp23_));
#line 225 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					update_task = _tmp24_;
#line 227 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					_tmp25_ = update_task;
#line 227 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					_tmp26_ = _tmp25_->query;
#line 227 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					_tmp27_ = tracker_data_update_sparql_blank (_tmp26_, &_inner_error_);
#line 227 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					_tmp28_ = _tmp27_;
#line 227 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					if (_inner_error_ != NULL) {
#line 227 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
						_tracker_store_task_unref0 (update_task);
#line 227 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
						_g_object_unref0 (iface);
#line 1539 "tracker-store.c"
						goto __catch21_g_error;
					}
#line 227 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					_tmp29_ = update_task;
#line 227 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					_g_variant_unref0 (_tmp29_->blank_nodes);
#line 227 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					_tmp29_->blank_nodes = _tmp28_;
#line 224 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					_tracker_store_task_unref0 (update_task);
#line 1550 "tracker-store.c"
				} else {
					TrackerStoreTask* _tmp30_;
					TrackerStoreTaskType _tmp31_;
#line 228 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					_tmp30_ = _data8_->task;
#line 228 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					_tmp31_ = _tmp30_->type;
#line 228 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					if (_tmp31_ == TRACKER_STORE_TASK_TYPE_TURTLE) {
#line 1560 "tracker-store.c"
						TrackerStoreTask* _tmp32_;
						TrackerStoreTurtleTask* _tmp33_;
						TrackerStoreTurtleTask* turtle_task;
						TrackerStoreTurtleTask* _tmp34_;
						const gchar* _tmp35_;
						GFile* _tmp36_ = NULL;
						GFile* file;
#line 229 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
						_tmp32_ = _data8_->task;
#line 229 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
						_tmp33_ = _tracker_store_task_ref0 (TRACKER_STORE_TURTLE_TASK (_tmp32_));
#line 229 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
						turtle_task = _tmp33_;
#line 231 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
						_tmp34_ = turtle_task;
#line 231 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
						_tmp35_ = _tmp34_->path;
#line 231 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
						_tmp36_ = g_file_new_for_path (_tmp35_);
#line 231 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
						file = _tmp36_;
#line 233 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
						tracker_events_freeze ();
#line 1584 "tracker-store.c"
						{
							GFile* _tmp37_;
#line 235 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
							_tmp37_ = file;
#line 235 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
							tracker_data_load_turtle_file (_tmp37_, &_inner_error_);
#line 235 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
							if (_inner_error_ != NULL) {
#line 1593 "tracker-store.c"
								goto __finally22;
							}
						}
						__finally22:
						{
#line 237 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
							tracker_events_reset_pending ();
#line 1601 "tracker-store.c"
						}
#line 234 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
						if (_inner_error_ != NULL) {
#line 234 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
							_g_object_unref0 (file);
#line 234 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
							_tracker_store_task_unref0 (turtle_task);
#line 234 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
							_g_object_unref0 (iface);
#line 1611 "tracker-store.c"
							goto __catch21_g_error;
						}
#line 228 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
						_g_object_unref0 (file);
#line 228 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
						_tracker_store_task_unref0 (turtle_task);
#line 1618 "tracker-store.c"
					}
				}
			}
#line 210 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			_g_object_unref0 (iface);
#line 1624 "tracker-store.c"
		}
	}
	goto __finally21;
	__catch21_g_error:
	{
		GError* e = NULL;
		TrackerStoreTask* _tmp38_;
		GError* _tmp39_;
		GError* _tmp40_;
#line 209 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		e = _inner_error_;
#line 209 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_inner_error_ = NULL;
#line 242 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_tmp38_ = _data8_->task;
#line 242 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_tmp39_ = e;
#line 242 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_tmp40_ = _g_error_copy0 (_tmp39_);
#line 242 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_g_error_free0 (_tmp38_->error);
#line 242 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_tmp38_->error = _tmp40_;
#line 209 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_g_error_free0 (e);
#line 1650 "tracker-store.c"
	}
	__finally21:
#line 209 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	if (_inner_error_ != NULL) {
#line 209 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		block8_data_unref (_data8_);
#line 209 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_data8_ = NULL;
#line 209 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 209 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		g_clear_error (&_inner_error_);
#line 209 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		return;
#line 1665 "tracker-store.c"
	}
#line 245 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda1__gsource_func, block8_data_ref (_data8_), block8_data_unref);
#line 208 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	block8_data_unref (_data8_);
#line 208 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data8_ = NULL;
#line 1673 "tracker-store.c"
}


void tracker_store_wal_checkpoint (void) {
	GError * _inner_error_ = NULL;
	{
		TrackerDBInterface* _tmp0_ = NULL;
		TrackerDBInterface* _tmp1_;
		TrackerDBInterface* iface;
#line 253 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		g_debug ("Checkpointing database...");
#line 254 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_tmp0_ = tracker_db_manager_get_db_interface ();
#line 254 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 254 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		iface = _tmp1_;
#line 255 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		tracker_db_interface_execute_query (iface, &_inner_error_, "PRAGMA wal_checkpoint");
#line 255 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		if (_inner_error_ != NULL) {
#line 255 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			_g_object_unref0 (iface);
#line 1697 "tracker-store.c"
			goto __catch23_g_error;
		}
#line 256 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		g_debug ("Checkpointing complete...");
#line 252 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_g_object_unref0 (iface);
#line 1704 "tracker-store.c"
	}
	goto __finally23;
	__catch23_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
#line 252 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		e = _inner_error_;
#line 252 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_inner_error_ = NULL;
#line 258 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_tmp2_ = e;
#line 258 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_tmp3_ = _tmp2_->message;
#line 258 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		g_warning ("%s", _tmp3_);
#line 252 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_g_error_free0 (e);
#line 1724 "tracker-store.c"
	}
	__finally23:
#line 252 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	if (_inner_error_ != NULL) {
#line 252 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 252 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		g_clear_error (&_inner_error_);
#line 252 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		return;
#line 1735 "tracker-store.c"
	}
}


static void tracker_store_wal_hook (gint n_pages) {
	gint _tmp0_;
	gint _tmp1_;
	GError * _inner_error_ = NULL;
#line 267 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_tmp0_ = n_pages;
#line 267 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	g_debug ("WAL: %d pages", _tmp0_);
#line 269 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_tmp1_ = n_pages;
#line 269 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	if (_tmp1_ >= 10000) {
#line 272 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_wal_checkpoint ();
#line 1754 "tracker-store.c"
	} else {
		gint _tmp2_;
#line 273 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_tmp2_ = n_pages;
#line 273 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		if (_tmp2_ >= 1000) {
#line 1761 "tracker-store.c"
			gboolean _tmp3_ = FALSE;
#line 274 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			_tmp3_ = g_atomic_int_compare_and_exchange ((volatile gint *) (&tracker_store_checkpointing), 0, 1);
#line 274 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			if (_tmp3_) {
#line 1767 "tracker-store.c"
				{
					GThreadPool* _tmp4_;
#line 277 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					_tmp4_ = tracker_store_checkpoint_pool;
#line 277 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					g_thread_pool_push (_tmp4_, GINT_TO_POINTER (TRUE), &_inner_error_);
#line 277 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					if (_inner_error_ != NULL) {
#line 1776 "tracker-store.c"
						goto __catch24_g_error;
					}
				}
				goto __finally24;
				__catch24_g_error:
				{
					GError* e = NULL;
					GError* _tmp5_;
					const gchar* _tmp6_;
#line 276 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					e = _inner_error_;
#line 276 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					_inner_error_ = NULL;
#line 279 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					_tmp5_ = e;
#line 279 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					_tmp6_ = _tmp5_->message;
#line 279 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					g_warning ("%s", _tmp6_);
#line 280 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					g_atomic_int_set ((volatile gint *) (&tracker_store_checkpointing), 0);
#line 276 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					_g_error_free0 (e);
#line 1800 "tracker-store.c"
				}
				__finally24:
#line 276 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				if (_inner_error_ != NULL) {
#line 276 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 276 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					g_clear_error (&_inner_error_);
#line 276 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					return;
#line 1811 "tracker-store.c"
				}
			}
		}
	}
}


static void tracker_store_checkpoint_dispatch_cb (gboolean task) {
#line 289 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_wal_checkpoint ();
#line 290 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	g_atomic_int_set ((volatile gint *) (&tracker_store_checkpointing), 0);
#line 1824 "tracker-store.c"
}


static void _tracker_store_task_unref0_ (gpointer var) {
#line 301 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	(var == NULL) ? NULL : (var = (tracker_store_task_unref (var), NULL));
#line 1831 "tracker-store.c"
}


static void _tracker_store_pool_dispatch_cb_gfunc (gconstpointer data, gpointer self) {
#line 309 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_pool_dispatch_cb (data);
#line 1838 "tracker-store.c"
}


static void _tracker_store_checkpoint_dispatch_cb_gfunc (gconstpointer data, gpointer self) {
#line 311 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_checkpoint_dispatch_cb (data);
#line 1845 "tracker-store.c"
}


void tracker_store_init (void) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* max_task_time_env;
	const gchar* _tmp2_;
	GPtrArray* _tmp5_;
	GError * _inner_error_ = NULL;
#line 294 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_tmp0_ = g_getenv ("TRACKER_STORE_MAX_TASK_TIME");
#line 294 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 294 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	max_task_time_env = _tmp1_;
#line 295 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_tmp2_ = max_task_time_env;
#line 295 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	if (_tmp2_ != NULL) {
#line 1866 "tracker-store.c"
		const gchar* _tmp3_;
		gint _tmp4_ = 0;
#line 296 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_tmp3_ = max_task_time_env;
#line 296 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_tmp4_ = atoi (_tmp3_);
#line 296 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_max_task_time = _tmp4_;
#line 1875 "tracker-store.c"
	} else {
#line 298 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_max_task_time = TRACKER_STORE_MAX_TASK_TIME;
#line 1879 "tracker-store.c"
	}
#line 301 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_tmp5_ = g_ptr_array_new_with_free_func (_tracker_store_task_unref0_);
#line 301 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_g_ptr_array_unref0 (tracker_store_running_tasks);
#line 301 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_running_tasks = _tmp5_;
#line 1887 "tracker-store.c"
	{
		gint i;
#line 303 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		i = 0;
#line 1892 "tracker-store.c"
		{
			gboolean _tmp6_;
#line 303 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			_tmp6_ = TRUE;
#line 303 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			while (TRUE) {
#line 1899 "tracker-store.c"
				gboolean _tmp7_;
				gint _tmp9_;
				gint _tmp10_;
				GQueue* _tmp11_;
				GQueue* _tmp12_;
				gint _tmp13_;
				GQueue* _tmp14_;
				GQueue* _tmp15_;
#line 303 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp7_ = _tmp6_;
#line 303 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				if (!_tmp7_) {
#line 1912 "tracker-store.c"
					gint _tmp8_;
#line 303 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					_tmp8_ = i;
#line 303 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					i = _tmp8_ + 1;
#line 1918 "tracker-store.c"
				}
#line 303 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp6_ = FALSE;
#line 303 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp9_ = i;
#line 303 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				if (!(_tmp9_ < ((gint) TRACKER_STORE_PRIORITY_N_PRIORITIES))) {
#line 303 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					break;
#line 1928 "tracker-store.c"
				}
#line 304 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp10_ = i;
#line 304 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp11_ = g_queue_new ();
#line 304 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_g_queue_free0 (tracker_store_query_queues[_tmp10_]);
#line 304 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				tracker_store_query_queues[_tmp10_] = _tmp11_;
#line 304 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp12_ = tracker_store_query_queues[_tmp10_];
#line 305 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp13_ = i;
#line 305 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp14_ = g_queue_new ();
#line 305 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_g_queue_free0 (tracker_store_update_queues[_tmp13_]);
#line 305 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				tracker_store_update_queues[_tmp13_] = _tmp14_;
#line 305 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp15_ = tracker_store_update_queues[_tmp13_];
#line 1950 "tracker-store.c"
			}
		}
	}
	{
		GThreadPool* _tmp16_;
		GThreadPool* _tmp17_;
		GThreadPool* _tmp18_;
		GThreadPool* _tmp19_;
		GThreadPool* _tmp20_;
		GThreadPool* _tmp21_;
#line 309 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_tmp16_ = g_thread_pool_new (_tracker_store_pool_dispatch_cb_gfunc, NULL, 1, TRUE, &_inner_error_);
#line 309 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_tmp17_ = _tmp16_;
#line 309 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		if (_inner_error_ != NULL) {
#line 1967 "tracker-store.c"
			goto __catch25_g_error;
		}
#line 309 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_g_thread_pool_free0 (tracker_store_update_pool);
#line 309 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_update_pool = _tmp17_;
#line 310 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_tmp18_ = g_thread_pool_new (_tracker_store_pool_dispatch_cb_gfunc, NULL, TRACKER_STORE_MAX_CONCURRENT_QUERIES, TRUE, &_inner_error_);
#line 310 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_tmp19_ = _tmp18_;
#line 310 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		if (_inner_error_ != NULL) {
#line 1980 "tracker-store.c"
			goto __catch25_g_error;
		}
#line 310 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_g_thread_pool_free0 (tracker_store_query_pool);
#line 310 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_query_pool = _tmp19_;
#line 311 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_tmp20_ = g_thread_pool_new (_tracker_store_checkpoint_dispatch_cb_gfunc, NULL, 1, TRUE, &_inner_error_);
#line 311 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_tmp21_ = _tmp20_;
#line 311 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		if (_inner_error_ != NULL) {
#line 1993 "tracker-store.c"
			goto __catch25_g_error;
		}
#line 311 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_g_thread_pool_free0 (tracker_store_checkpoint_pool);
#line 311 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_checkpoint_pool = _tmp21_;
#line 2000 "tracker-store.c"
	}
	goto __finally25;
	__catch25_g_error:
	{
		GError* e = NULL;
		GError* _tmp22_;
		const gchar* _tmp23_;
#line 308 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		e = _inner_error_;
#line 308 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_inner_error_ = NULL;
#line 313 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_tmp22_ = e;
#line 313 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_tmp23_ = _tmp22_->message;
#line 313 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		g_warning ("%s", _tmp23_);
#line 308 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_g_error_free0 (e);
#line 2020 "tracker-store.c"
	}
	__finally25:
#line 308 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	if (_inner_error_ != NULL) {
#line 308 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_g_free0 (max_task_time_env);
#line 308 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 308 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		g_clear_error (&_inner_error_);
#line 308 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		return;
#line 2033 "tracker-store.c"
	}
#line 319 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	g_thread_pool_set_max_idle_time ((guint) (15 * 1000));
#line 320 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	g_thread_pool_set_max_unused_threads (2);
#line 293 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (max_task_time_env);
#line 2041 "tracker-store.c"
}


void tracker_store_shutdown (void) {
#line 324 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_g_thread_pool_free0 (tracker_store_query_pool);
#line 324 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_query_pool = NULL;
#line 325 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_g_thread_pool_free0 (tracker_store_update_pool);
#line 325 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_update_pool = NULL;
#line 326 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_g_thread_pool_free0 (tracker_store_checkpoint_pool);
#line 326 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_checkpoint_pool = NULL;
#line 2058 "tracker-store.c"
	{
		gint i;
#line 328 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		i = 0;
#line 2063 "tracker-store.c"
		{
			gboolean _tmp0_;
#line 328 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			_tmp0_ = TRUE;
#line 328 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			while (TRUE) {
#line 2070 "tracker-store.c"
				gboolean _tmp1_;
				gint _tmp3_;
				gint _tmp4_;
				GQueue* _tmp5_;
				gint _tmp6_;
				GQueue* _tmp7_;
#line 328 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp1_ = _tmp0_;
#line 328 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				if (!_tmp1_) {
#line 2081 "tracker-store.c"
					gint _tmp2_;
#line 328 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					_tmp2_ = i;
#line 328 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					i = _tmp2_ + 1;
#line 2087 "tracker-store.c"
				}
#line 328 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp0_ = FALSE;
#line 328 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp3_ = i;
#line 328 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				if (!(_tmp3_ < ((gint) TRACKER_STORE_PRIORITY_N_PRIORITIES))) {
#line 328 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					break;
#line 2097 "tracker-store.c"
				}
#line 329 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp4_ = i;
#line 329 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_g_queue_free0 (tracker_store_query_queues[_tmp4_]);
#line 329 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				tracker_store_query_queues[_tmp4_] = NULL;
#line 329 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp5_ = tracker_store_query_queues[_tmp4_];
#line 330 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp6_ = i;
#line 330 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_g_queue_free0 (tracker_store_update_queues[_tmp6_]);
#line 330 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				tracker_store_update_queues[_tmp6_] = NULL;
#line 330 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp7_ = tracker_store_update_queues[_tmp6_];
#line 2115 "tracker-store.c"
			}
		}
	}
}


static void tracker_store_sparql_query_data_free (gpointer _data) {
	TrackerStoreSparqlQueryData* _data_;
	_data_ = _data;
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (_data_->sparql);
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (_data_->client_id);
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	g_slice_free (TrackerStoreSparqlQueryData, _data_);
#line 2131 "tracker-store.c"
}


void tracker_store_sparql_query (const gchar* sparql, TrackerStorePriority priority, TrackerStoreSparqlQueryInThread in_thread, void* in_thread_target, const gchar* client_id, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerStoreSparqlQueryData* _data_;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	TrackerStorePriority _tmp2_;
	TrackerStoreSparqlQueryInThread _tmp3_;
	void* _tmp3__target;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_ = g_slice_new0 (TrackerStoreSparqlQueryData);
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, tracker_store_sparql_query);
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_store_sparql_query_data_free);
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_tmp0_ = sparql;
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->sparql = _tmp1_;
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_tmp2_ = priority;
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->priority = _tmp2_;
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_tmp3_ = in_thread;
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_tmp3__target = in_thread_target;
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->in_thread = _tmp3_;
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->in_thread_target = _tmp3__target;
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_tmp4_ = client_id;
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_tmp5_ = g_strdup (_tmp4_);
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->client_id = _tmp5_;
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_sparql_query_co (_data_);
#line 2176 "tracker-store.c"
}


void tracker_store_sparql_query_finish (GAsyncResult* _res_, GError** error) {
	TrackerStoreSparqlQueryData* _data_;
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		return;
#line 2186 "tracker-store.c"
	}
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 2190 "tracker-store.c"
}


static gboolean _tracker_store_sparql_query_co_gsource_func (gpointer self) {
	gboolean result;
	result = tracker_store_sparql_query_co (self);
#line 340 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	return result;
#line 2199 "tracker-store.c"
}


static gboolean tracker_store_sparql_query_co (TrackerStoreSparqlQueryData* _data_) {
#line 334 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	switch (_data_->_state_) {
#line 334 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		case 0:
#line 2208 "tracker-store.c"
		goto _state_0;
#line 334 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		case 1:
#line 2212 "tracker-store.c"
		goto _state_1;
		default:
#line 334 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		g_assert_not_reached ();
#line 2217 "tracker-store.c"
	}
	_state_0:
#line 335 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp0_ = tracker_store_query_task_new ();
#line 335 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->task = _data_->_tmp0_;
#line 336 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp1_ = _data_->task;
#line 336 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp1_)->type = TRACKER_STORE_TASK_TYPE_QUERY;
#line 337 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp2_ = _data_->task;
#line 337 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp3_ = _data_->sparql;
#line 337 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp4_ = g_strdup (_data_->_tmp3_);
#line 337 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (_data_->_tmp2_->query);
#line 337 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp2_->query = _data_->_tmp4_;
#line 338 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp5_ = _data_->task;
#line 338 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp6_ = g_cancellable_new ();
#line 338 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_g_object_unref0 (_data_->_tmp5_->cancellable);
#line 338 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp5_->cancellable = _data_->_tmp6_;
#line 339 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp7_ = _data_->task;
#line 339 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp8_ = _data_->in_thread;
#line 339 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp8__target = _data_->in_thread_target;
#line 339 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	(_data_->_tmp7_->in_thread_target_destroy_notify == NULL) ? NULL : (_data_->_tmp7_->in_thread_target_destroy_notify (_data_->_tmp7_->in_thread_target), NULL);
#line 339 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp7_->in_thread = NULL;
#line 339 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp7_->in_thread_target = NULL;
#line 339 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp7_->in_thread_target_destroy_notify = NULL;
#line 339 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp7_->in_thread = _data_->_tmp8_;
#line 339 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp7_->in_thread_target = _data_->_tmp8__target;
#line 339 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp7_->in_thread_target_destroy_notify = NULL;
#line 340 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp9_ = _data_->task;
#line 340 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	(((TrackerStoreTask*) _data_->_tmp9_)->callback_target_destroy_notify == NULL) ? NULL : (((TrackerStoreTask*) _data_->_tmp9_)->callback_target_destroy_notify (((TrackerStoreTask*) _data_->_tmp9_)->callback_target), NULL);
#line 340 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp9_)->callback = NULL;
#line 340 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp9_)->callback_target = NULL;
#line 340 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp9_)->callback_target_destroy_notify = NULL;
#line 340 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp9_)->callback = _tracker_store_sparql_query_co_gsource_func;
#line 340 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp9_)->callback_target = _data_;
#line 340 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp9_)->callback_target_destroy_notify = NULL;
#line 341 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp10_ = _data_->task;
#line 341 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp11_ = _data_->client_id;
#line 341 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp12_ = g_strdup (_data_->_tmp11_);
#line 341 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (((TrackerStoreTask*) _data_->_tmp10_)->client_id);
#line 341 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp10_)->client_id = _data_->_tmp12_;
#line 343 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp13_ = _data_->priority;
#line 343 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp14_ = tracker_store_query_queues[_data_->_tmp13_];
#line 343 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp15_ = _data_->task;
#line 343 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp16_ = _tracker_store_task_ref0 ((TrackerStoreTask*) _data_->_tmp15_);
#line 343 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	g_queue_push_tail (_data_->_tmp14_, _data_->_tmp16_);
#line 345 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_sched ();
#line 347 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_state_ = 1;
#line 347 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	return FALSE;
#line 2308 "tracker-store.c"
	_state_1:
	;
#line 349 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp17_ = _data_->task;
#line 349 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp18_ = ((TrackerStoreTask*) _data_->_tmp17_)->error;
#line 349 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	if (_data_->_tmp18_ != NULL) {
#line 350 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp19_ = _data_->task;
#line 350 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp20_ = ((TrackerStoreTask*) _data_->_tmp19_)->error;
#line 350 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp21_ = _g_error_copy0 (_data_->_tmp20_);
#line 350 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_data_->_inner_error_ = _data_->_tmp21_;
#line 350 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 350 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		g_error_free (_data_->_inner_error_);
#line 350 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_tracker_store_task_unref0 (_data_->task);
#line 350 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		if (_data_->_state_ == 0) {
#line 350 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2335 "tracker-store.c"
		} else {
#line 350 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 2339 "tracker-store.c"
		}
#line 350 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		g_object_unref (_data_->_async_result);
#line 350 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		return FALSE;
#line 2345 "tracker-store.c"
	}
#line 334 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_tracker_store_task_unref0 (_data_->task);
#line 334 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	if (_data_->_state_ == 0) {
#line 334 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2353 "tracker-store.c"
	} else {
#line 334 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2357 "tracker-store.c"
	}
#line 334 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	g_object_unref (_data_->_async_result);
#line 334 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	return FALSE;
#line 2363 "tracker-store.c"
}


static void tracker_store_sparql_update_data_free (gpointer _data) {
	TrackerStoreSparqlUpdateData* _data_;
	_data_ = _data;
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (_data_->sparql);
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (_data_->client_id);
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	g_slice_free (TrackerStoreSparqlUpdateData, _data_);
#line 2376 "tracker-store.c"
}


void tracker_store_sparql_update (const gchar* sparql, TrackerStorePriority priority, const gchar* client_id, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerStoreSparqlUpdateData* _data_;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	TrackerStorePriority _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_ = g_slice_new0 (TrackerStoreSparqlUpdateData);
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, tracker_store_sparql_update);
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_store_sparql_update_data_free);
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_tmp0_ = sparql;
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->sparql = _tmp1_;
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_tmp2_ = priority;
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->priority = _tmp2_;
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_tmp3_ = client_id;
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->client_id = _tmp4_;
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_sparql_update_co (_data_);
#line 2411 "tracker-store.c"
}


void tracker_store_sparql_update_finish (GAsyncResult* _res_, GError** error) {
	TrackerStoreSparqlUpdateData* _data_;
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		return;
#line 2421 "tracker-store.c"
	}
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 2425 "tracker-store.c"
}


static gboolean _tracker_store_sparql_update_co_gsource_func (gpointer self) {
	gboolean result;
	result = tracker_store_sparql_update_co (self);
#line 359 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	return result;
#line 2434 "tracker-store.c"
}


static gboolean tracker_store_sparql_update_co (TrackerStoreSparqlUpdateData* _data_) {
#line 354 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	switch (_data_->_state_) {
#line 354 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		case 0:
#line 2443 "tracker-store.c"
		goto _state_0;
#line 354 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		case 1:
#line 2447 "tracker-store.c"
		goto _state_1;
		default:
#line 354 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		g_assert_not_reached ();
#line 2452 "tracker-store.c"
	}
	_state_0:
#line 355 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp0_ = tracker_store_update_task_new ();
#line 355 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->task = _data_->_tmp0_;
#line 356 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp1_ = _data_->task;
#line 356 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp1_)->type = TRACKER_STORE_TASK_TYPE_UPDATE;
#line 357 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp2_ = _data_->task;
#line 357 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp3_ = _data_->sparql;
#line 357 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp4_ = g_strdup (_data_->_tmp3_);
#line 357 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (_data_->_tmp2_->query);
#line 357 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp2_->query = _data_->_tmp4_;
#line 358 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp5_ = _data_->task;
#line 358 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp6_ = _data_->priority;
#line 358 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp5_->priority = _data_->_tmp6_;
#line 359 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp7_ = _data_->task;
#line 359 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	(((TrackerStoreTask*) _data_->_tmp7_)->callback_target_destroy_notify == NULL) ? NULL : (((TrackerStoreTask*) _data_->_tmp7_)->callback_target_destroy_notify (((TrackerStoreTask*) _data_->_tmp7_)->callback_target), NULL);
#line 359 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp7_)->callback = NULL;
#line 359 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp7_)->callback_target = NULL;
#line 359 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp7_)->callback_target_destroy_notify = NULL;
#line 359 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp7_)->callback = _tracker_store_sparql_update_co_gsource_func;
#line 359 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp7_)->callback_target = _data_;
#line 359 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp7_)->callback_target_destroy_notify = NULL;
#line 360 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp8_ = _data_->task;
#line 360 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp9_ = _data_->client_id;
#line 360 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp10_ = g_strdup (_data_->_tmp9_);
#line 360 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (((TrackerStoreTask*) _data_->_tmp8_)->client_id);
#line 360 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp8_)->client_id = _data_->_tmp10_;
#line 362 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp11_ = _data_->priority;
#line 362 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp12_ = tracker_store_update_queues[_data_->_tmp11_];
#line 362 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp13_ = _data_->task;
#line 362 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp14_ = _tracker_store_task_ref0 ((TrackerStoreTask*) _data_->_tmp13_);
#line 362 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	g_queue_push_tail (_data_->_tmp12_, _data_->_tmp14_);
#line 364 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_sched ();
#line 366 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_state_ = 1;
#line 366 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	return FALSE;
#line 2521 "tracker-store.c"
	_state_1:
	;
#line 368 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp15_ = _data_->task;
#line 368 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp16_ = ((TrackerStoreTask*) _data_->_tmp15_)->error;
#line 368 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	if (_data_->_tmp16_ != NULL) {
#line 369 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp17_ = _data_->task;
#line 369 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp18_ = ((TrackerStoreTask*) _data_->_tmp17_)->error;
#line 369 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp19_ = _g_error_copy0 (_data_->_tmp18_);
#line 369 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_data_->_inner_error_ = _data_->_tmp19_;
#line 369 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 369 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		g_error_free (_data_->_inner_error_);
#line 369 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_tracker_store_task_unref0 (_data_->task);
#line 369 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		if (_data_->_state_ == 0) {
#line 369 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2548 "tracker-store.c"
		} else {
#line 369 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 2552 "tracker-store.c"
		}
#line 369 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		g_object_unref (_data_->_async_result);
#line 369 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		return FALSE;
#line 2558 "tracker-store.c"
	}
#line 354 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_tracker_store_task_unref0 (_data_->task);
#line 354 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	if (_data_->_state_ == 0) {
#line 354 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2566 "tracker-store.c"
	} else {
#line 354 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2570 "tracker-store.c"
	}
#line 354 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	g_object_unref (_data_->_async_result);
#line 354 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	return FALSE;
#line 2576 "tracker-store.c"
}


static void tracker_store_sparql_update_blank_data_free (gpointer _data) {
	TrackerStoreSparqlUpdateBlankData* _data_;
	_data_ = _data;
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (_data_->sparql);
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (_data_->client_id);
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_g_variant_unref0 (_data_->result);
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	g_slice_free (TrackerStoreSparqlUpdateBlankData, _data_);
#line 2591 "tracker-store.c"
}


void tracker_store_sparql_update_blank (const gchar* sparql, TrackerStorePriority priority, const gchar* client_id, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerStoreSparqlUpdateBlankData* _data_;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	TrackerStorePriority _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_ = g_slice_new0 (TrackerStoreSparqlUpdateBlankData);
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, tracker_store_sparql_update_blank);
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_store_sparql_update_blank_data_free);
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_tmp0_ = sparql;
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->sparql = _tmp1_;
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_tmp2_ = priority;
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->priority = _tmp2_;
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_tmp3_ = client_id;
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->client_id = _tmp4_;
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_sparql_update_blank_co (_data_);
#line 2626 "tracker-store.c"
}


GVariant* tracker_store_sparql_update_blank_finish (GAsyncResult* _res_, GError** error) {
	GVariant* result;
	TrackerStoreSparqlUpdateBlankData* _data_;
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		return NULL;
#line 2637 "tracker-store.c"
	}
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	result = _data_->result;
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->result = NULL;
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	return result;
#line 2647 "tracker-store.c"
}


static gboolean _tracker_store_sparql_update_blank_co_gsource_func (gpointer self) {
	gboolean result;
	result = tracker_store_sparql_update_blank_co (self);
#line 378 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	return result;
#line 2656 "tracker-store.c"
}


static gpointer _g_variant_ref0 (gpointer self) {
#line 391 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	return self ? g_variant_ref (self) : NULL;
#line 2663 "tracker-store.c"
}


static gboolean tracker_store_sparql_update_blank_co (TrackerStoreSparqlUpdateBlankData* _data_) {
#line 373 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	switch (_data_->_state_) {
#line 373 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		case 0:
#line 2672 "tracker-store.c"
		goto _state_0;
#line 373 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		case 1:
#line 2676 "tracker-store.c"
		goto _state_1;
		default:
#line 373 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		g_assert_not_reached ();
#line 2681 "tracker-store.c"
	}
	_state_0:
#line 374 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp0_ = tracker_store_update_task_new ();
#line 374 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->task = _data_->_tmp0_;
#line 375 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp1_ = _data_->task;
#line 375 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp1_)->type = TRACKER_STORE_TASK_TYPE_UPDATE_BLANK;
#line 376 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp2_ = _data_->task;
#line 376 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp3_ = _data_->sparql;
#line 376 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp4_ = g_strdup (_data_->_tmp3_);
#line 376 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (_data_->_tmp2_->query);
#line 376 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp2_->query = _data_->_tmp4_;
#line 377 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp5_ = _data_->task;
#line 377 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp6_ = _data_->priority;
#line 377 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp5_->priority = _data_->_tmp6_;
#line 378 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp7_ = _data_->task;
#line 378 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	(((TrackerStoreTask*) _data_->_tmp7_)->callback_target_destroy_notify == NULL) ? NULL : (((TrackerStoreTask*) _data_->_tmp7_)->callback_target_destroy_notify (((TrackerStoreTask*) _data_->_tmp7_)->callback_target), NULL);
#line 378 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp7_)->callback = NULL;
#line 378 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp7_)->callback_target = NULL;
#line 378 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp7_)->callback_target_destroy_notify = NULL;
#line 378 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp7_)->callback = _tracker_store_sparql_update_blank_co_gsource_func;
#line 378 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp7_)->callback_target = _data_;
#line 378 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp7_)->callback_target_destroy_notify = NULL;
#line 379 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp8_ = _data_->task;
#line 379 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp9_ = _data_->client_id;
#line 379 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp10_ = g_strdup (_data_->_tmp9_);
#line 379 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (((TrackerStoreTask*) _data_->_tmp8_)->client_id);
#line 379 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp8_)->client_id = _data_->_tmp10_;
#line 381 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp11_ = _data_->priority;
#line 381 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp12_ = tracker_store_update_queues[_data_->_tmp11_];
#line 381 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp13_ = _data_->task;
#line 381 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp14_ = _tracker_store_task_ref0 ((TrackerStoreTask*) _data_->_tmp13_);
#line 381 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	g_queue_push_tail (_data_->_tmp12_, _data_->_tmp14_);
#line 383 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_sched ();
#line 385 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_state_ = 1;
#line 385 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	return FALSE;
#line 2750 "tracker-store.c"
	_state_1:
	;
#line 387 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp15_ = _data_->task;
#line 387 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp16_ = ((TrackerStoreTask*) _data_->_tmp15_)->error;
#line 387 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	if (_data_->_tmp16_ != NULL) {
#line 388 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp17_ = _data_->task;
#line 388 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp18_ = ((TrackerStoreTask*) _data_->_tmp17_)->error;
#line 388 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp19_ = _g_error_copy0 (_data_->_tmp18_);
#line 388 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_data_->_inner_error_ = _data_->_tmp19_;
#line 388 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 388 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		g_error_free (_data_->_inner_error_);
#line 388 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_tracker_store_task_unref0 (_data_->task);
#line 388 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		if (_data_->_state_ == 0) {
#line 388 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2777 "tracker-store.c"
		} else {
#line 388 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 2781 "tracker-store.c"
		}
#line 388 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		g_object_unref (_data_->_async_result);
#line 388 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		return FALSE;
#line 2787 "tracker-store.c"
	}
#line 391 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp20_ = _data_->task;
#line 391 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp21_ = _data_->_tmp20_->blank_nodes;
#line 391 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp22_ = _g_variant_ref0 (_data_->_tmp21_);
#line 391 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->result = _data_->_tmp22_;
#line 391 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_tracker_store_task_unref0 (_data_->task);
#line 391 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	if (_data_->_state_ == 0) {
#line 391 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2803 "tracker-store.c"
	} else {
#line 391 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2807 "tracker-store.c"
	}
#line 391 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	g_object_unref (_data_->_async_result);
#line 391 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	return FALSE;
#line 373 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_tracker_store_task_unref0 (_data_->task);
#line 373 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	if (_data_->_state_ == 0) {
#line 373 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2819 "tracker-store.c"
	} else {
#line 373 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2823 "tracker-store.c"
	}
#line 373 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	g_object_unref (_data_->_async_result);
#line 373 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	return FALSE;
#line 2829 "tracker-store.c"
}


static void tracker_store_queue_turtle_import_data_free (gpointer _data) {
	TrackerStoreQueueTurtleImportData* _data_;
	_data_ = _data;
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_g_object_unref0 (_data_->file);
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (_data_->client_id);
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	g_slice_free (TrackerStoreQueueTurtleImportData, _data_);
#line 2842 "tracker-store.c"
}


void tracker_store_queue_turtle_import (GFile* file, const gchar* client_id, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerStoreQueueTurtleImportData* _data_;
	GFile* _tmp0_;
	GFile* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_ = g_slice_new0 (TrackerStoreQueueTurtleImportData);
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, tracker_store_queue_turtle_import);
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_store_queue_turtle_import_data_free);
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_tmp0_ = file;
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->file = _tmp1_;
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_tmp2_ = client_id;
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->client_id = _tmp3_;
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_queue_turtle_import_co (_data_);
#line 2872 "tracker-store.c"
}


void tracker_store_queue_turtle_import_finish (GAsyncResult* _res_, GError** error) {
	TrackerStoreQueueTurtleImportData* _data_;
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		return;
#line 2882 "tracker-store.c"
	}
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 2886 "tracker-store.c"
}


static gboolean _tracker_store_queue_turtle_import_co_gsource_func (gpointer self) {
	gboolean result;
	result = tracker_store_queue_turtle_import_co (self);
#line 398 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	return result;
#line 2895 "tracker-store.c"
}


static gboolean tracker_store_queue_turtle_import_co (TrackerStoreQueueTurtleImportData* _data_) {
#line 394 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	switch (_data_->_state_) {
#line 394 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		case 0:
#line 2904 "tracker-store.c"
		goto _state_0;
#line 394 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		case 1:
#line 2908 "tracker-store.c"
		goto _state_1;
		default:
#line 394 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		g_assert_not_reached ();
#line 2913 "tracker-store.c"
	}
	_state_0:
#line 395 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp0_ = tracker_store_turtle_task_new ();
#line 395 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->task = _data_->_tmp0_;
#line 396 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp1_ = _data_->task;
#line 396 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp1_)->type = TRACKER_STORE_TASK_TYPE_TURTLE;
#line 397 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp2_ = _data_->task;
#line 397 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp3_ = _data_->file;
#line 397 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp4_ = NULL;
#line 397 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp4_ = g_file_get_path (_data_->_tmp3_);
#line 397 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (_data_->_tmp2_->path);
#line 397 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp2_->path = _data_->_tmp4_;
#line 398 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp5_ = _data_->task;
#line 398 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	(((TrackerStoreTask*) _data_->_tmp5_)->callback_target_destroy_notify == NULL) ? NULL : (((TrackerStoreTask*) _data_->_tmp5_)->callback_target_destroy_notify (((TrackerStoreTask*) _data_->_tmp5_)->callback_target), NULL);
#line 398 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp5_)->callback = NULL;
#line 398 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp5_)->callback_target = NULL;
#line 398 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp5_)->callback_target_destroy_notify = NULL;
#line 398 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp5_)->callback = _tracker_store_queue_turtle_import_co_gsource_func;
#line 398 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp5_)->callback_target = _data_;
#line 398 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp5_)->callback_target_destroy_notify = NULL;
#line 399 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp6_ = _data_->task;
#line 399 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp7_ = _data_->client_id;
#line 399 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp8_ = g_strdup (_data_->_tmp7_);
#line 399 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (((TrackerStoreTask*) _data_->_tmp6_)->client_id);
#line 399 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp6_)->client_id = _data_->_tmp8_;
#line 401 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp9_ = tracker_store_update_queues[TRACKER_STORE_PRIORITY_TURTLE];
#line 401 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp10_ = _data_->task;
#line 401 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp11_ = _tracker_store_task_ref0 ((TrackerStoreTask*) _data_->_tmp10_);
#line 401 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	g_queue_push_tail (_data_->_tmp9_, _data_->_tmp11_);
#line 403 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_sched ();
#line 405 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_state_ = 1;
#line 405 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	return FALSE;
#line 2976 "tracker-store.c"
	_state_1:
	;
#line 407 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp12_ = _data_->task;
#line 407 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp13_ = ((TrackerStoreTask*) _data_->_tmp12_)->error;
#line 407 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	if (_data_->_tmp13_ != NULL) {
#line 408 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp14_ = _data_->task;
#line 408 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp15_ = ((TrackerStoreTask*) _data_->_tmp14_)->error;
#line 408 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp16_ = _g_error_copy0 (_data_->_tmp15_);
#line 408 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_data_->_inner_error_ = _data_->_tmp16_;
#line 408 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 408 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		g_error_free (_data_->_inner_error_);
#line 408 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_tracker_store_task_unref0 (_data_->task);
#line 408 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		if (_data_->_state_ == 0) {
#line 408 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3003 "tracker-store.c"
		} else {
#line 408 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 3007 "tracker-store.c"
		}
#line 408 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		g_object_unref (_data_->_async_result);
#line 408 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		return FALSE;
#line 3013 "tracker-store.c"
	}
#line 394 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_tracker_store_task_unref0 (_data_->task);
#line 394 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	if (_data_->_state_ == 0) {
#line 394 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3021 "tracker-store.c"
	} else {
#line 394 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 3025 "tracker-store.c"
	}
#line 394 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	g_object_unref (_data_->_async_result);
#line 394 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	return FALSE;
#line 3031 "tracker-store.c"
}


guint tracker_store_get_queue_size (TrackerStore* self) {
	guint result = 0U;
	guint _result_;
#line 412 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 413 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_result_ = (guint) 0;
#line 3042 "tracker-store.c"
	{
		gint i;
#line 415 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		i = 0;
#line 3047 "tracker-store.c"
		{
			gboolean _tmp0_;
#line 415 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			_tmp0_ = TRUE;
#line 415 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			while (TRUE) {
#line 3054 "tracker-store.c"
				gboolean _tmp1_;
				gint _tmp3_;
				guint _tmp4_;
				gint _tmp5_;
				GQueue* _tmp6_;
				guint _tmp7_ = 0U;
				guint _tmp8_;
				gint _tmp9_;
				GQueue* _tmp10_;
				guint _tmp11_ = 0U;
#line 415 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp1_ = _tmp0_;
#line 415 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				if (!_tmp1_) {
#line 3069 "tracker-store.c"
					gint _tmp2_;
#line 415 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					_tmp2_ = i;
#line 415 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					i = _tmp2_ + 1;
#line 3075 "tracker-store.c"
				}
#line 415 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp0_ = FALSE;
#line 415 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp3_ = i;
#line 415 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				if (!(_tmp3_ < ((gint) TRACKER_STORE_PRIORITY_N_PRIORITIES))) {
#line 415 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					break;
#line 3085 "tracker-store.c"
				}
#line 416 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp4_ = _result_;
#line 416 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp5_ = i;
#line 416 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp6_ = tracker_store_query_queues[_tmp5_];
#line 416 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp7_ = g_queue_get_length (_tmp6_);
#line 416 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_result_ = _tmp4_ + _tmp7_;
#line 417 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp8_ = _result_;
#line 417 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp9_ = i;
#line 417 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp10_ = tracker_store_update_queues[_tmp9_];
#line 417 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp11_ = g_queue_get_length (_tmp10_);
#line 417 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_result_ = _tmp8_ + _tmp11_;
#line 3107 "tracker-store.c"
			}
		}
	}
#line 419 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	result = _result_;
#line 419 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	return result;
#line 3115 "tracker-store.c"
}


static gint g_ptr_array_get_length (GPtrArray* self) {
	gint result;
	guint _tmp0_;
#line 4045 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 4045 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp0_ = self->len;
#line 4045 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	result = (gint) _tmp0_;
#line 4045 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	return result;
#line 3130 "tracker-store.c"
}


static void g_ptr_array_set_length (GPtrArray* self, gint value) {
	gint _tmp0_;
#line 4046 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	g_return_if_fail (self != NULL);
#line 4046 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp0_ = value;
#line 4046 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	g_ptr_array_set_size (self, _tmp0_);
#line 3142 "tracker-store.c"
}


void tracker_store_unreg_batches (const gchar* client_id) {
	GList* list = NULL;
	GList* cur = NULL;
	GQueue* queue = NULL;
#line 422 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	g_return_if_fail (client_id != NULL);
#line 3152 "tracker-store.c"
	{
		gint i;
#line 426 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		i = 0;
#line 3157 "tracker-store.c"
		{
			gboolean _tmp0_;
#line 426 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			_tmp0_ = TRUE;
#line 426 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			while (TRUE) {
#line 3164 "tracker-store.c"
				gboolean _tmp1_;
				gint _tmp3_;
				GPtrArray* _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
				GPtrArray* _tmp7_;
				gint _tmp8_;
				gconstpointer _tmp9_ = NULL;
				TrackerStoreQueryTask* task;
				gboolean _tmp10_ = FALSE;
				gboolean _tmp11_ = FALSE;
				TrackerStoreQueryTask* _tmp12_;
				gboolean _tmp16_;
				gboolean _tmp19_;
#line 426 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp1_ = _tmp0_;
#line 426 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				if (!_tmp1_) {
#line 3183 "tracker-store.c"
					gint _tmp2_;
#line 426 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					_tmp2_ = i;
#line 426 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					i = _tmp2_ + 1;
#line 3189 "tracker-store.c"
				}
#line 426 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp0_ = FALSE;
#line 426 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp3_ = i;
#line 426 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp4_ = tracker_store_running_tasks;
#line 426 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp5_ = g_ptr_array_get_length (_tmp4_);
#line 426 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp6_ = _tmp5_;
#line 426 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				if (!(_tmp3_ < _tmp6_)) {
#line 426 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					break;
#line 3205 "tracker-store.c"
				}
#line 427 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp7_ = tracker_store_running_tasks;
#line 427 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp8_ = i;
#line 427 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp9_ = g_ptr_array_index (_tmp7_, (guint) _tmp8_);
#line 427 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				task = TRACKER_STORE_IS_QUERY_TASK ((TrackerStoreTask*) _tmp9_) ? ((TrackerStoreQueryTask*) ((TrackerStoreTask*) _tmp9_)) : NULL;
#line 428 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp12_ = task;
#line 428 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				if (_tmp12_ != NULL) {
#line 3219 "tracker-store.c"
					TrackerStoreQueryTask* _tmp13_;
					const gchar* _tmp14_;
					const gchar* _tmp15_;
#line 428 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					_tmp13_ = task;
#line 428 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					_tmp14_ = ((TrackerStoreTask*) _tmp13_)->client_id;
#line 428 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					_tmp15_ = client_id;
#line 428 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					_tmp11_ = g_strcmp0 (_tmp14_, _tmp15_) == 0;
#line 3231 "tracker-store.c"
				} else {
#line 428 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					_tmp11_ = FALSE;
#line 3235 "tracker-store.c"
				}
#line 428 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp16_ = _tmp11_;
#line 428 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				if (_tmp16_) {
#line 3241 "tracker-store.c"
					TrackerStoreQueryTask* _tmp17_;
					GCancellable* _tmp18_;
#line 428 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					_tmp17_ = task;
#line 428 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					_tmp18_ = _tmp17_->cancellable;
#line 428 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					_tmp10_ = _tmp18_ != NULL;
#line 3250 "tracker-store.c"
				} else {
#line 428 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					_tmp10_ = FALSE;
#line 3254 "tracker-store.c"
				}
#line 428 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp19_ = _tmp10_;
#line 428 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				if (_tmp19_) {
#line 3260 "tracker-store.c"
					TrackerStoreQueryTask* _tmp20_;
					GCancellable* _tmp21_;
#line 429 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					_tmp20_ = task;
#line 429 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					_tmp21_ = _tmp20_->cancellable;
#line 429 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					g_cancellable_cancel (_tmp21_);
#line 3269 "tracker-store.c"
				}
			}
		}
	}
	{
		gint i;
#line 433 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		i = 0;
#line 3278 "tracker-store.c"
		{
			gboolean _tmp22_;
#line 433 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			_tmp22_ = TRUE;
#line 433 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			while (TRUE) {
#line 3285 "tracker-store.c"
				gboolean _tmp23_;
				gint _tmp25_;
				gint _tmp26_;
				GQueue* _tmp27_;
				GQueue* _tmp28_;
				GList* _tmp29_;
				gint _tmp48_;
				GQueue* _tmp49_;
				GQueue* _tmp50_;
				GList* _tmp51_;
#line 433 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp23_ = _tmp22_;
#line 433 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				if (!_tmp23_) {
#line 3300 "tracker-store.c"
					gint _tmp24_;
#line 433 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					_tmp24_ = i;
#line 433 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					i = _tmp24_ + 1;
#line 3306 "tracker-store.c"
				}
#line 433 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp22_ = FALSE;
#line 433 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp25_ = i;
#line 433 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				if (!(_tmp25_ < ((gint) TRACKER_STORE_PRIORITY_N_PRIORITIES))) {
#line 433 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					break;
#line 3316 "tracker-store.c"
				}
#line 434 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp26_ = i;
#line 434 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp27_ = tracker_store_query_queues[_tmp26_];
#line 434 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				queue = _tmp27_;
#line 435 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp28_ = queue;
#line 435 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp29_ = _tmp28_->head;
#line 435 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				list = _tmp29_;
#line 436 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				while (TRUE) {
#line 3332 "tracker-store.c"
					GList* _tmp30_;
					GList* _tmp31_;
					GList* _tmp32_;
					GList* _tmp33_;
					GList* _tmp34_;
					gconstpointer _tmp35_;
					TrackerStoreTask* task;
					gboolean _tmp36_ = FALSE;
					TrackerStoreTask* _tmp37_;
					gboolean _tmp41_;
#line 436 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					_tmp30_ = list;
#line 436 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					if (!(_tmp30_ != NULL)) {
#line 436 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
						break;
#line 3349 "tracker-store.c"
					}
#line 437 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					_tmp31_ = list;
#line 437 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					cur = _tmp31_;
#line 438 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					_tmp32_ = list;
#line 438 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					_tmp33_ = _tmp32_->next;
#line 438 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					list = _tmp33_;
#line 439 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					_tmp34_ = cur;
#line 439 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					_tmp35_ = _tmp34_->data;
#line 439 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					task = (TrackerStoreTask*) _tmp35_;
#line 441 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					_tmp37_ = task;
#line 441 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					if (_tmp37_ != NULL) {
#line 3371 "tracker-store.c"
						TrackerStoreTask* _tmp38_;
						const gchar* _tmp39_;
						const gchar* _tmp40_;
#line 441 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
						_tmp38_ = task;
#line 441 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
						_tmp39_ = _tmp38_->client_id;
#line 441 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
						_tmp40_ = client_id;
#line 441 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
						_tmp36_ = g_strcmp0 (_tmp39_, _tmp40_) == 0;
#line 3383 "tracker-store.c"
					} else {
#line 441 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
						_tmp36_ = FALSE;
#line 3387 "tracker-store.c"
					}
#line 441 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					_tmp41_ = _tmp36_;
#line 441 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					if (_tmp41_) {
#line 3393 "tracker-store.c"
						GQueue* _tmp42_;
						GList* _tmp43_;
						TrackerStoreTask* _tmp44_;
						GError* _tmp45_;
						TrackerStoreTask* _tmp46_;
						GSourceFunc _tmp47_;
						void* _tmp47__target;
#line 442 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
						_tmp42_ = queue;
#line 442 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
						_tmp43_ = cur;
#line 442 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
						g_queue_delete_link (_tmp42_, _tmp43_);
#line 444 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
						_tmp44_ = task;
#line 444 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
						_tmp45_ = g_error_new_literal (G_DBUS_ERROR, G_DBUS_ERROR_FAILED, "Client disappeared");
#line 444 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
						_g_error_free0 (_tmp44_->error);
#line 444 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
						_tmp44_->error = _tmp45_;
#line 445 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
						_tmp46_ = task;
#line 445 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
						_tmp47_ = _tmp46_->callback;
#line 445 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
						_tmp47__target = _tmp46_->callback_target;
#line 445 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
						_tmp47_ (_tmp47__target);
#line 3423 "tracker-store.c"
					}
				}
#line 449 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp48_ = i;
#line 449 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp49_ = tracker_store_update_queues[_tmp48_];
#line 449 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				queue = _tmp49_;
#line 450 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp50_ = queue;
#line 450 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				_tmp51_ = _tmp50_->head;
#line 450 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				list = _tmp51_;
#line 451 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
				while (TRUE) {
#line 3440 "tracker-store.c"
					GList* _tmp52_;
					GList* _tmp53_;
					GList* _tmp54_;
					GList* _tmp55_;
					GList* _tmp56_;
					gconstpointer _tmp57_;
					TrackerStoreTask* task;
					gboolean _tmp58_ = FALSE;
					TrackerStoreTask* _tmp59_;
					gboolean _tmp63_;
#line 451 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					_tmp52_ = list;
#line 451 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					if (!(_tmp52_ != NULL)) {
#line 451 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
						break;
#line 3457 "tracker-store.c"
					}
#line 452 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					_tmp53_ = list;
#line 452 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					cur = _tmp53_;
#line 453 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					_tmp54_ = list;
#line 453 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					_tmp55_ = _tmp54_->next;
#line 453 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					list = _tmp55_;
#line 454 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					_tmp56_ = cur;
#line 454 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					_tmp57_ = _tmp56_->data;
#line 454 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					task = (TrackerStoreTask*) _tmp57_;
#line 456 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					_tmp59_ = task;
#line 456 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					if (_tmp59_ != NULL) {
#line 3479 "tracker-store.c"
						TrackerStoreTask* _tmp60_;
						const gchar* _tmp61_;
						const gchar* _tmp62_;
#line 456 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
						_tmp60_ = task;
#line 456 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
						_tmp61_ = _tmp60_->client_id;
#line 456 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
						_tmp62_ = client_id;
#line 456 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
						_tmp58_ = g_strcmp0 (_tmp61_, _tmp62_) == 0;
#line 3491 "tracker-store.c"
					} else {
#line 456 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
						_tmp58_ = FALSE;
#line 3495 "tracker-store.c"
					}
#line 456 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					_tmp63_ = _tmp58_;
#line 456 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
					if (_tmp63_) {
#line 3501 "tracker-store.c"
						GQueue* _tmp64_;
						GList* _tmp65_;
						TrackerStoreTask* _tmp66_;
						GError* _tmp67_;
						TrackerStoreTask* _tmp68_;
						GSourceFunc _tmp69_;
						void* _tmp69__target;
#line 457 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
						_tmp64_ = queue;
#line 457 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
						_tmp65_ = cur;
#line 457 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
						g_queue_delete_link (_tmp64_, _tmp65_);
#line 459 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
						_tmp66_ = task;
#line 459 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
						_tmp67_ = g_error_new_literal (G_DBUS_ERROR, G_DBUS_ERROR_FAILED, "Client disappeared");
#line 459 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
						_g_error_free0 (_tmp66_->error);
#line 459 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
						_tmp66_->error = _tmp67_;
#line 460 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
						_tmp68_ = task;
#line 460 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
						_tmp69_ = _tmp68_->callback;
#line 460 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
						_tmp69__target = _tmp68_->callback_target;
#line 460 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
						_tmp69_ (_tmp69__target);
#line 3531 "tracker-store.c"
					}
				}
			}
		}
	}
#line 465 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_sched ();
#line 3539 "tracker-store.c"
}


static void tracker_store_pause_data_free (gpointer _data) {
	TrackerStorePauseData* _data_;
	_data_ = _data;
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	g_slice_free (TrackerStorePauseData, _data_);
#line 3548 "tracker-store.c"
}


void tracker_store_pause (GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerStorePauseData* _data_;
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_ = g_slice_new0 (TrackerStorePauseData);
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, tracker_store_pause);
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_store_pause_data_free);
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_pause_co (_data_);
#line 3562 "tracker-store.c"
}


void tracker_store_pause_finish (GAsyncResult* _res_) {
	TrackerStorePauseData* _data_;
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 3570 "tracker-store.c"
}


static gboolean _tracker_store_pause_co_gsource_func (gpointer self) {
	gboolean result;
	result = tracker_store_pause_co (self);
#line 472 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	return result;
#line 3579 "tracker-store.c"
}


static gboolean tracker_store_pause_co (TrackerStorePauseData* _data_) {
#line 468 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	switch (_data_->_state_) {
#line 468 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		case 0:
#line 3588 "tracker-store.c"
		goto _state_0;
#line 468 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		case 1:
#line 3592 "tracker-store.c"
		goto _state_1;
		default:
#line 468 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		g_assert_not_reached ();
#line 3597 "tracker-store.c"
	}
	_state_0:
#line 469 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_active = FALSE;
#line 471 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp1_ = tracker_store_n_queries_running;
#line 471 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	if (_data_->_tmp1_ > 0) {
#line 471 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp0_ = TRUE;
#line 3608 "tracker-store.c"
	} else {
#line 471 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp2_ = tracker_store_update_running;
#line 471 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp0_ = _data_->_tmp2_;
#line 3614 "tracker-store.c"
	}
#line 471 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp3_ = _data_->_tmp0_;
#line 471 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	if (_data_->_tmp3_) {
#line 472 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		(tracker_store_active_callback_target_destroy_notify == NULL) ? NULL : (tracker_store_active_callback_target_destroy_notify (tracker_store_active_callback_target), NULL);
#line 472 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_active_callback = NULL;
#line 472 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_active_callback_target = NULL;
#line 472 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_active_callback_target_destroy_notify = NULL;
#line 472 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_active_callback = _tracker_store_pause_co_gsource_func;
#line 472 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_active_callback_target = _data_;
#line 472 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_active_callback_target_destroy_notify = NULL;
#line 473 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_data_->_state_ = 1;
#line 473 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		return FALSE;
#line 3638 "tracker-store.c"
		_state_1:
		;
#line 474 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		(tracker_store_active_callback_target_destroy_notify == NULL) ? NULL : (tracker_store_active_callback_target_destroy_notify (tracker_store_active_callback_target), NULL);
#line 474 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_active_callback = NULL;
#line 474 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_active_callback_target = NULL;
#line 474 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_active_callback_target_destroy_notify = NULL;
#line 474 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_active_callback = NULL;
#line 474 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_active_callback_target = NULL;
#line 474 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_active_callback_target_destroy_notify = NULL;
#line 3655 "tracker-store.c"
	}
#line 477 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp4_ = 0;
#line 477 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp4_ = g_atomic_int_get ((volatile gint *) (&tracker_store_checkpointing));
#line 477 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	if (_data_->_tmp4_ != 0) {
#line 479 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_g_thread_pool_free0 (tracker_store_checkpoint_pool);
#line 479 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_checkpoint_pool = NULL;
#line 3667 "tracker-store.c"
		{
#line 481 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			_data_->_tmp5_ = g_thread_pool_new (_tracker_store_checkpoint_dispatch_cb_gfunc, NULL, 1, TRUE, &_data_->_inner_error_);
#line 481 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			_data_->_tmp6_ = _data_->_tmp5_;
#line 481 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			if (_data_->_inner_error_ != NULL) {
#line 3675 "tracker-store.c"
				goto __catch26_g_error;
			}
#line 481 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			_g_thread_pool_free0 (tracker_store_checkpoint_pool);
#line 481 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			tracker_store_checkpoint_pool = _data_->_tmp6_;
#line 3682 "tracker-store.c"
		}
		goto __finally26;
		__catch26_g_error:
		{
#line 480 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			_data_->e = _data_->_inner_error_;
#line 480 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			_data_->_inner_error_ = NULL;
#line 483 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			_data_->_tmp7_ = _data_->e;
#line 483 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			_data_->_tmp8_ = _data_->_tmp7_->message;
#line 483 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			g_warning ("%s", _data_->_tmp8_);
#line 480 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			_g_error_free0 (_data_->e);
#line 3699 "tracker-store.c"
		}
		__finally26:
#line 480 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		if (_data_->_inner_error_ != NULL) {
#line 480 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 480 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			g_clear_error (&_data_->_inner_error_);
#line 480 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			return FALSE;
#line 3710 "tracker-store.c"
		}
	}
#line 487 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp9_ = tracker_store_active;
#line 487 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	if (_data_->_tmp9_) {
#line 488 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_sched ();
#line 3719 "tracker-store.c"
	}
#line 468 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	if (_data_->_state_ == 0) {
#line 468 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3725 "tracker-store.c"
	} else {
#line 468 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 3729 "tracker-store.c"
	}
#line 468 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	g_object_unref (_data_->_async_result);
#line 468 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	return FALSE;
#line 3735 "tracker-store.c"
}


void tracker_store_resume (void) {
#line 493 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_active = TRUE;
#line 495 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_sched ();
#line 3744 "tracker-store.c"
}


TrackerStore* tracker_store_construct (GType object_type) {
	TrackerStore* self = NULL;
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	self = (TrackerStore*) g_type_create_instance (object_type);
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	return self;
#line 3754 "tracker-store.c"
}


TrackerStore* tracker_store_new (void) {
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	return tracker_store_construct (TRACKER_TYPE_STORE);
#line 3761 "tracker-store.c"
}


static TrackerStoreTask* tracker_store_task_construct (GType object_type) {
	TrackerStoreTask* self = NULL;
#line 55 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	self = (TrackerStoreTask*) g_type_create_instance (object_type);
#line 55 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	return self;
#line 3771 "tracker-store.c"
}


static void tracker_store_value_task_init (GValue* value) {
#line 55 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	value->data[0].v_pointer = NULL;
#line 3778 "tracker-store.c"
}


static void tracker_store_value_task_free_value (GValue* value) {
#line 55 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	if (value->data[0].v_pointer) {
#line 55 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_task_unref (value->data[0].v_pointer);
#line 3787 "tracker-store.c"
	}
}


static void tracker_store_value_task_copy_value (const GValue* src_value, GValue* dest_value) {
#line 55 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	if (src_value->data[0].v_pointer) {
#line 55 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		dest_value->data[0].v_pointer = tracker_store_task_ref (src_value->data[0].v_pointer);
#line 3797 "tracker-store.c"
	} else {
#line 55 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		dest_value->data[0].v_pointer = NULL;
#line 3801 "tracker-store.c"
	}
}


static gpointer tracker_store_value_task_peek_pointer (const GValue* value) {
#line 55 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	return value->data[0].v_pointer;
#line 3809 "tracker-store.c"
}


static gchar* tracker_store_value_task_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 55 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	if (collect_values[0].v_pointer) {
#line 3816 "tracker-store.c"
		TrackerStoreTask* object;
		object = collect_values[0].v_pointer;
#line 55 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		if (object->parent_instance.g_class == NULL) {
#line 55 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3823 "tracker-store.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 55 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3827 "tracker-store.c"
		}
#line 55 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		value->data[0].v_pointer = tracker_store_task_ref (object);
#line 3831 "tracker-store.c"
	} else {
#line 55 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		value->data[0].v_pointer = NULL;
#line 3835 "tracker-store.c"
	}
#line 55 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	return NULL;
#line 3839 "tracker-store.c"
}


static gchar* tracker_store_value_task_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	TrackerStoreTask** object_p;
	object_p = collect_values[0].v_pointer;
#line 55 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	if (!object_p) {
#line 55 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 3850 "tracker-store.c"
	}
#line 55 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	if (!value->data[0].v_pointer) {
#line 55 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		*object_p = NULL;
#line 3856 "tracker-store.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 55 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		*object_p = value->data[0].v_pointer;
#line 3860 "tracker-store.c"
	} else {
#line 55 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		*object_p = tracker_store_task_ref (value->data[0].v_pointer);
#line 3864 "tracker-store.c"
	}
#line 55 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	return NULL;
#line 3868 "tracker-store.c"
}


static GParamSpec* tracker_store_param_spec_task (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	TrackerStoreParamSpecTask* spec;
#line 55 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TRACKER_STORE_TYPE_TASK), NULL);
#line 55 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 55 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 55 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	return G_PARAM_SPEC (spec);
#line 3882 "tracker-store.c"
}


static gpointer tracker_store_value_get_task (const GValue* value) {
#line 55 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_STORE_TYPE_TASK), NULL);
#line 55 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	return value->data[0].v_pointer;
#line 3891 "tracker-store.c"
}


static void tracker_store_value_set_task (GValue* value, gpointer v_object) {
	TrackerStoreTask* old;
#line 55 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_STORE_TYPE_TASK));
#line 55 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	old = value->data[0].v_pointer;
#line 55 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	if (v_object) {
#line 55 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_STORE_TYPE_TASK));
#line 55 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 55 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		value->data[0].v_pointer = v_object;
#line 55 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_task_ref (value->data[0].v_pointer);
#line 3911 "tracker-store.c"
	} else {
#line 55 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		value->data[0].v_pointer = NULL;
#line 3915 "tracker-store.c"
	}
#line 55 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	if (old) {
#line 55 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_task_unref (old);
#line 3921 "tracker-store.c"
	}
}


static void tracker_store_value_take_task (GValue* value, gpointer v_object) {
	TrackerStoreTask* old;
#line 55 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_STORE_TYPE_TASK));
#line 55 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	old = value->data[0].v_pointer;
#line 55 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	if (v_object) {
#line 55 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_STORE_TYPE_TASK));
#line 55 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 55 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		value->data[0].v_pointer = v_object;
#line 3940 "tracker-store.c"
	} else {
#line 55 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		value->data[0].v_pointer = NULL;
#line 3944 "tracker-store.c"
	}
#line 55 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	if (old) {
#line 55 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_task_unref (old);
#line 3950 "tracker-store.c"
	}
}


static void tracker_store_task_class_init (TrackerStoreTaskClass * klass) {
#line 55 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_task_parent_class = g_type_class_peek_parent (klass);
#line 55 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	TRACKER_STORE_TASK_CLASS (klass)->finalize = tracker_store_task_finalize;
#line 3960 "tracker-store.c"
}


static void tracker_store_task_instance_init (TrackerStoreTask * self) {
#line 55 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	self->ref_count = 1;
#line 3967 "tracker-store.c"
}


static void tracker_store_task_finalize (TrackerStoreTask* obj) {
	TrackerStoreTask * self;
#line 55 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	self = TRACKER_STORE_TASK (obj);
#line 57 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (self->client_id);
#line 58 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_g_error_free0 (self->error);
#line 59 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	(self->callback_target_destroy_notify == NULL) ? NULL : (self->callback_target_destroy_notify (self->callback_target), NULL);
#line 59 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	self->callback = NULL;
#line 59 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	self->callback_target = NULL;
#line 59 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	self->callback_target_destroy_notify = NULL;
#line 3987 "tracker-store.c"
}


static GType tracker_store_task_get_type (void) {
	static volatile gsize tracker_store_task_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_store_task_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { tracker_store_value_task_init, tracker_store_value_task_free_value, tracker_store_value_task_copy_value, tracker_store_value_task_peek_pointer, "p", tracker_store_value_task_collect_value, "p", tracker_store_value_task_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (TrackerStoreTaskClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_store_task_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerStoreTask), 0, (GInstanceInitFunc) tracker_store_task_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType tracker_store_task_type_id;
		tracker_store_task_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TrackerStoreTask", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&tracker_store_task_type_id__volatile, tracker_store_task_type_id);
	}
	return tracker_store_task_type_id__volatile;
}


static gpointer tracker_store_task_ref (gpointer instance) {
	TrackerStoreTask* self;
	self = instance;
#line 55 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	g_atomic_int_inc (&self->ref_count);
#line 55 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	return instance;
#line 4012 "tracker-store.c"
}


static void tracker_store_task_unref (gpointer instance) {
	TrackerStoreTask* self;
	self = instance;
#line 55 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 55 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		TRACKER_STORE_TASK_GET_CLASS (self)->finalize (self);
#line 55 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 4025 "tracker-store.c"
	}
}


static TrackerStoreQueryTask* tracker_store_query_task_construct (GType object_type) {
	TrackerStoreQueryTask* self = NULL;
#line 62 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	self = (TrackerStoreQueryTask*) tracker_store_task_construct (object_type);
#line 62 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	return self;
#line 4036 "tracker-store.c"
}


static TrackerStoreQueryTask* tracker_store_query_task_new (void) {
#line 62 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	return tracker_store_query_task_construct (TRACKER_STORE_TYPE_QUERY_TASK);
#line 4043 "tracker-store.c"
}


static void tracker_store_query_task_class_init (TrackerStoreQueryTaskClass * klass) {
#line 62 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_query_task_parent_class = g_type_class_peek_parent (klass);
#line 62 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	TRACKER_STORE_TASK_CLASS (klass)->finalize = tracker_store_query_task_finalize;
#line 4052 "tracker-store.c"
}


static void tracker_store_query_task_instance_init (TrackerStoreQueryTask * self) {
}


static void tracker_store_query_task_finalize (TrackerStoreTask* obj) {
	TrackerStoreQueryTask * self;
	guint _tmp0_;
#line 62 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	self = TRACKER_STORE_QUERY_TASK (obj);
#line 69 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_tmp0_ = self->watchdog_id;
#line 69 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	if (_tmp0_ > ((guint) 0)) {
#line 4069 "tracker-store.c"
		guint _tmp1_;
#line 70 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		_tmp1_ = self->watchdog_id;
#line 70 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		g_source_remove (_tmp1_);
#line 4075 "tracker-store.c"
	}
#line 63 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (self->query);
#line 64 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_g_object_unref0 (self->cancellable);
#line 66 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	(self->in_thread_target_destroy_notify == NULL) ? NULL : (self->in_thread_target_destroy_notify (self->in_thread_target), NULL);
#line 66 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	self->in_thread = NULL;
#line 66 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	self->in_thread_target = NULL;
#line 66 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	self->in_thread_target_destroy_notify = NULL;
#line 62 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	TRACKER_STORE_TASK_CLASS (tracker_store_query_task_parent_class)->finalize (obj);
#line 4091 "tracker-store.c"
}


static GType tracker_store_query_task_get_type (void) {
	static volatile gsize tracker_store_query_task_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_store_query_task_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerStoreQueryTaskClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_store_query_task_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerStoreQueryTask), 0, (GInstanceInitFunc) tracker_store_query_task_instance_init, NULL };
		GType tracker_store_query_task_type_id;
		tracker_store_query_task_type_id = g_type_register_static (TRACKER_STORE_TYPE_TASK, "TrackerStoreQueryTask", &g_define_type_info, 0);
		g_once_init_leave (&tracker_store_query_task_type_id__volatile, tracker_store_query_task_type_id);
	}
	return tracker_store_query_task_type_id__volatile;
}


static TrackerStoreUpdateTask* tracker_store_update_task_construct (GType object_type) {
	TrackerStoreUpdateTask* self = NULL;
#line 75 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	self = (TrackerStoreUpdateTask*) tracker_store_task_construct (object_type);
#line 75 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	return self;
#line 4113 "tracker-store.c"
}


static TrackerStoreUpdateTask* tracker_store_update_task_new (void) {
#line 75 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	return tracker_store_update_task_construct (TRACKER_STORE_TYPE_UPDATE_TASK);
#line 4120 "tracker-store.c"
}


static void tracker_store_update_task_class_init (TrackerStoreUpdateTaskClass * klass) {
#line 75 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_update_task_parent_class = g_type_class_peek_parent (klass);
#line 75 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	TRACKER_STORE_TASK_CLASS (klass)->finalize = tracker_store_update_task_finalize;
#line 4129 "tracker-store.c"
}


static void tracker_store_update_task_instance_init (TrackerStoreUpdateTask * self) {
}


static void tracker_store_update_task_finalize (TrackerStoreTask* obj) {
	TrackerStoreUpdateTask * self;
#line 75 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	self = TRACKER_STORE_UPDATE_TASK (obj);
#line 76 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (self->query);
#line 77 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_g_variant_unref0 (self->blank_nodes);
#line 75 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	TRACKER_STORE_TASK_CLASS (tracker_store_update_task_parent_class)->finalize (obj);
#line 4147 "tracker-store.c"
}


static GType tracker_store_update_task_get_type (void) {
	static volatile gsize tracker_store_update_task_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_store_update_task_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerStoreUpdateTaskClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_store_update_task_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerStoreUpdateTask), 0, (GInstanceInitFunc) tracker_store_update_task_instance_init, NULL };
		GType tracker_store_update_task_type_id;
		tracker_store_update_task_type_id = g_type_register_static (TRACKER_STORE_TYPE_TASK, "TrackerStoreUpdateTask", &g_define_type_info, 0);
		g_once_init_leave (&tracker_store_update_task_type_id__volatile, tracker_store_update_task_type_id);
	}
	return tracker_store_update_task_type_id__volatile;
}


static TrackerStoreTurtleTask* tracker_store_turtle_task_construct (GType object_type) {
	TrackerStoreTurtleTask* self = NULL;
#line 81 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	self = (TrackerStoreTurtleTask*) tracker_store_task_construct (object_type);
#line 81 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	return self;
#line 4169 "tracker-store.c"
}


static TrackerStoreTurtleTask* tracker_store_turtle_task_new (void) {
#line 81 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	return tracker_store_turtle_task_construct (TRACKER_STORE_TYPE_TURTLE_TASK);
#line 4176 "tracker-store.c"
}


static void tracker_store_turtle_task_class_init (TrackerStoreTurtleTaskClass * klass) {
#line 81 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_turtle_task_parent_class = g_type_class_peek_parent (klass);
#line 81 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	TRACKER_STORE_TASK_CLASS (klass)->finalize = tracker_store_turtle_task_finalize;
#line 4185 "tracker-store.c"
}


static void tracker_store_turtle_task_instance_init (TrackerStoreTurtleTask * self) {
}


static void tracker_store_turtle_task_finalize (TrackerStoreTask* obj) {
	TrackerStoreTurtleTask * self;
#line 81 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	self = TRACKER_STORE_TURTLE_TASK (obj);
#line 82 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (self->path);
#line 81 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	TRACKER_STORE_TASK_CLASS (tracker_store_turtle_task_parent_class)->finalize (obj);
#line 4201 "tracker-store.c"
}


static GType tracker_store_turtle_task_get_type (void) {
	static volatile gsize tracker_store_turtle_task_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_store_turtle_task_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerStoreTurtleTaskClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_store_turtle_task_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerStoreTurtleTask), 0, (GInstanceInitFunc) tracker_store_turtle_task_instance_init, NULL };
		GType tracker_store_turtle_task_type_id;
		tracker_store_turtle_task_type_id = g_type_register_static (TRACKER_STORE_TYPE_TASK, "TrackerStoreTurtleTask", &g_define_type_info, 0);
		g_once_init_leave (&tracker_store_turtle_task_type_id__volatile, tracker_store_turtle_task_type_id);
	}
	return tracker_store_turtle_task_type_id__volatile;
}


static void tracker_value_store_init (GValue* value) {
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	value->data[0].v_pointer = NULL;
#line 4220 "tracker-store.c"
}


static void tracker_value_store_free_value (GValue* value) {
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	if (value->data[0].v_pointer) {
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_unref (value->data[0].v_pointer);
#line 4229 "tracker-store.c"
	}
}


static void tracker_value_store_copy_value (const GValue* src_value, GValue* dest_value) {
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	if (src_value->data[0].v_pointer) {
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		dest_value->data[0].v_pointer = tracker_store_ref (src_value->data[0].v_pointer);
#line 4239 "tracker-store.c"
	} else {
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		dest_value->data[0].v_pointer = NULL;
#line 4243 "tracker-store.c"
	}
}


static gpointer tracker_value_store_peek_pointer (const GValue* value) {
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	return value->data[0].v_pointer;
#line 4251 "tracker-store.c"
}


static gchar* tracker_value_store_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	if (collect_values[0].v_pointer) {
#line 4258 "tracker-store.c"
		TrackerStore* object;
		object = collect_values[0].v_pointer;
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		if (object->parent_instance.g_class == NULL) {
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4265 "tracker-store.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4269 "tracker-store.c"
		}
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		value->data[0].v_pointer = tracker_store_ref (object);
#line 4273 "tracker-store.c"
	} else {
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		value->data[0].v_pointer = NULL;
#line 4277 "tracker-store.c"
	}
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	return NULL;
#line 4281 "tracker-store.c"
}


static gchar* tracker_value_store_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	TrackerStore** object_p;
	object_p = collect_values[0].v_pointer;
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	if (!object_p) {
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 4292 "tracker-store.c"
	}
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	if (!value->data[0].v_pointer) {
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		*object_p = NULL;
#line 4298 "tracker-store.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		*object_p = value->data[0].v_pointer;
#line 4302 "tracker-store.c"
	} else {
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		*object_p = tracker_store_ref (value->data[0].v_pointer);
#line 4306 "tracker-store.c"
	}
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	return NULL;
#line 4310 "tracker-store.c"
}


GParamSpec* tracker_param_spec_store (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	TrackerParamSpecStore* spec;
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TRACKER_TYPE_STORE), NULL);
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	return G_PARAM_SPEC (spec);
#line 4324 "tracker-store.c"
}


gpointer tracker_value_get_store (const GValue* value) {
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TYPE_STORE), NULL);
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	return value->data[0].v_pointer;
#line 4333 "tracker-store.c"
}


void tracker_value_set_store (GValue* value, gpointer v_object) {
	TrackerStore* old;
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TYPE_STORE));
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	old = value->data[0].v_pointer;
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	if (v_object) {
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_TYPE_STORE));
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		value->data[0].v_pointer = v_object;
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_ref (value->data[0].v_pointer);
#line 4353 "tracker-store.c"
	} else {
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		value->data[0].v_pointer = NULL;
#line 4357 "tracker-store.c"
	}
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	if (old) {
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_unref (old);
#line 4363 "tracker-store.c"
	}
}


void tracker_value_take_store (GValue* value, gpointer v_object) {
	TrackerStore* old;
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TYPE_STORE));
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	old = value->data[0].v_pointer;
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	if (v_object) {
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_TYPE_STORE));
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		value->data[0].v_pointer = v_object;
#line 4382 "tracker-store.c"
	} else {
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		value->data[0].v_pointer = NULL;
#line 4386 "tracker-store.c"
	}
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	if (old) {
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_unref (old);
#line 4392 "tracker-store.c"
	}
}


static void tracker_store_class_init (TrackerStoreClass * klass) {
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_parent_class = g_type_class_peek_parent (klass);
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	TRACKER_STORE_CLASS (klass)->finalize = tracker_store_finalize;
#line 4402 "tracker-store.c"
}


static void tracker_store_instance_init (TrackerStore * self) {
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	self->ref_count = 1;
#line 4409 "tracker-store.c"
}


static void tracker_store_finalize (TrackerStore* obj) {
	TrackerStore * self;
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	self = TRACKER_STORE (obj);
#line 4417 "tracker-store.c"
}


GType tracker_store_get_type (void) {
	static volatile gsize tracker_store_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_store_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { tracker_value_store_init, tracker_value_store_free_value, tracker_value_store_copy_value, tracker_value_store_peek_pointer, "p", tracker_value_store_collect_value, "p", tracker_value_store_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (TrackerStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerStore), 0, (GInstanceInitFunc) tracker_store_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType tracker_store_type_id;
		tracker_store_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TrackerStore", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&tracker_store_type_id__volatile, tracker_store_type_id);
	}
	return tracker_store_type_id__volatile;
}


gpointer tracker_store_ref (gpointer instance) {
	TrackerStore* self;
	self = instance;
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	g_atomic_int_inc (&self->ref_count);
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	return instance;
#line 4442 "tracker-store.c"
}


void tracker_store_unref (gpointer instance) {
	TrackerStore* self;
	self = instance;
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		TRACKER_STORE_GET_CLASS (self)->finalize (self);
#line 22 "/home/martyn/Source/tracker/src/tracker-store/tracker-store.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 4455 "tracker-store.c"
	}
}



