/* tracker-utils.c generated by valac 0.13.4.8-6faa4, the Vala compiler
 * generated from tracker-utils.vala, do not modify */

/**/
/* Copyright 2010, Martyn Russell <martyn@lanedo.com>*/
/**/
/* This program is free software; you can redistribute it and/or*/
/* modify it under the terms of the GNU General Public License*/
/* as published by the Free Software Foundation; either version 2*/
/* of the License, or (at your option) any later version.*/
/**/
/* This program is distributed in the hope that it will be useful,*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/* GNU General Public License for more details.*/
/**/
/* You should have received a copy of the GNU General Public License*/
/* along with this program; if not, write to the Free Software*/
/* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA*/
/* 02110-1301, USA.*/
/**/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <gio/gio.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))



#define secs_per_day ((60 * 60) * 24)
gchar* tracker_time_format_from_iso8601 (const gchar* s);
gchar* tracker_time_format_from_seconds (const gchar* seconds_str);
GdkPixbuf* tracker_pixbuf_new_from_file (GtkIconTheme* theme, const gchar* filename, gint size, gboolean is_image);
GdkPixbuf* tracker_pixbuf_new_from_name (GtkIconTheme* theme, const gchar* name, gint size);
static gint _vala_array_length (gpointer array);


static gchar* g_time_format (struct tm *self, const gchar* format) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* buffer;
	gint buffer_length1;
	gint _buffer_size_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gint _tmp3__length1;
	gchar* _tmp4_;
#line 2440 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	g_return_val_if_fail (format != NULL, NULL);
#line 2441 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp0_ = g_new0 (gchar, 64);
#line 2441 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	buffer = _tmp0_;
#line 2441 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	buffer_length1 = 64;
#line 2441 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_buffer_size_ = buffer_length1;
#line 2442 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp1_ = buffer;
#line 2442 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp1__length1 = buffer_length1;
#line 2442 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp2_ = format;
#line 2442 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	strftime (_tmp1_, _tmp1__length1, _tmp2_, &(*self));
#line 2443 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp3_ = buffer;
#line 2443 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp3__length1 = buffer_length1;
#line 2443 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp4_ = g_strdup ((const gchar*) _tmp3_);
#line 2443 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	result = _tmp4_;
#line 2443 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	buffer = (g_free (buffer), NULL);
#line 2443 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	return result;
#line 93 "tracker-utils.c"
}


gchar* tracker_time_format_from_iso8601 (const gchar* s) {
	gchar* result = NULL;
	struct tm t = {0};
	const gchar* _tmp0_;
	GTimeVal tv_now = {0};
	GTimeVal tv_then = {0};
	const gchar* _tmp1_;
	GTimeVal _tmp2_;
	glong _tmp3_;
	GTimeVal _tmp4_;
	glong _tmp5_;
	glong diff_sec;
	glong _tmp6_;
	glong diff_days;
	glong _tmp7_;
	glong _tmp8_ = 0L;
	glong diff_days_abs;
	glong _tmp9_;
	glong _tmp12_;
#line 24 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	g_return_val_if_fail (s != NULL, NULL);
#line 25 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	memset (&t, 0, sizeof (struct tm));
#line 26 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp0_ = s;
#line 26 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	strptime (_tmp0_, "%FT%T", &t);
#line 28 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	g_get_current_time (&tv_now);
#line 29 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	g_get_current_time (&tv_now);
#line 31 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	g_get_current_time (&tv_then);
#line 32 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp1_ = s;
#line 32 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	g_time_val_from_iso8601 (_tmp1_, &tv_then);
#line 34 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp2_ = tv_now;
#line 34 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp3_ = _tmp2_.tv_sec;
#line 34 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp4_ = tv_then;
#line 34 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp5_ = _tmp4_.tv_sec;
#line 34 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	diff_sec = _tmp3_ - _tmp5_;
#line 35 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp6_ = diff_sec;
#line 35 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	diff_days = _tmp6_ / secs_per_day;
#line 36 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp7_ = diff_days;
#line 36 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp8_ = labs (_tmp7_);
#line 36 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	diff_days_abs = _tmp8_;
#line 41 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp9_ = diff_days_abs;
#line 41 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	if (_tmp9_ > ((glong) 7)) {
#line 158 "tracker-utils.c"
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
#line 44 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp10_ = _ ("%x");
#line 44 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp11_ = g_time_format (&t, _tmp10_);
#line 44 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		result = _tmp11_;
#line 44 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		return result;
#line 169 "tracker-utils.c"
	}
#line 47 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp12_ = diff_days_abs;
#line 47 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	if (_tmp12_ == ((glong) 0)) {
#line 175 "tracker-utils.c"
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_;
#line 48 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp13_ = _ ("Today");
#line 48 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp14_ = g_strdup (_tmp13_);
#line 48 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		result = _tmp14_;
#line 48 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		return result;
#line 186 "tracker-utils.c"
	} else {
		gboolean future;
		glong _tmp15_;
		glong _tmp16_;
#line 50 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		future = FALSE;
#line 52 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp15_ = diff_days;
#line 52 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		if (_tmp15_ < ((glong) 0)) {
#line 53 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			future = TRUE;
#line 199 "tracker-utils.c"
		}
#line 55 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp16_ = diff_days;
#line 55 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		if (_tmp16_ <= ((glong) 1)) {
#line 205 "tracker-utils.c"
			gboolean _tmp17_;
#line 56 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp17_ = future;
#line 56 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			if (_tmp17_) {
#line 211 "tracker-utils.c"
				const gchar* _tmp18_ = NULL;
				gchar* _tmp19_;
#line 57 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
				_tmp18_ = _ ("Tomorrow");
#line 57 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
				_tmp19_ = g_strdup (_tmp18_);
#line 57 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
				result = _tmp19_;
#line 57 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
				return result;
#line 222 "tracker-utils.c"
			} else {
				const gchar* _tmp20_ = NULL;
				gchar* _tmp21_;
#line 59 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
				_tmp20_ = _ ("Yesterday");
#line 59 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
				_tmp21_ = g_strdup (_tmp20_);
#line 59 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
				result = _tmp21_;
#line 59 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
				return result;
#line 234 "tracker-utils.c"
			}
		} else {
			gboolean _tmp22_;
#line 61 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp22_ = future;
#line 61 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			if (_tmp22_) {
#line 242 "tracker-utils.c"
				glong _tmp23_;
				const gchar* _tmp24_ = NULL;
				glong _tmp25_;
				gchar* _tmp26_ = NULL;
#line 63 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
				_tmp23_ = diff_days_abs;
#line 63 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
				_tmp24_ = ngettext ("%ld day from now", "%ld days from now", (gulong) _tmp23_);
#line 63 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
				_tmp25_ = diff_days_abs;
#line 63 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
				_tmp26_ = g_strdup_printf (_tmp24_, _tmp25_);
#line 63 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
				result = _tmp26_;
#line 63 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
				return result;
#line 259 "tracker-utils.c"
			} else {
				glong _tmp27_;
				const gchar* _tmp28_ = NULL;
				glong _tmp29_;
				gchar* _tmp30_ = NULL;
#line 66 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
				_tmp27_ = diff_days_abs;
#line 66 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
				_tmp28_ = ngettext ("%ld day ago", "%ld days ago", (gulong) _tmp27_);
#line 66 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
				_tmp29_ = diff_days_abs;
#line 66 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
				_tmp30_ = g_strdup_printf (_tmp28_, _tmp29_);
#line 66 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
				result = _tmp30_;
#line 66 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
				return result;
#line 277 "tracker-utils.c"
			}
		}
	}
}


gchar* tracker_time_format_from_seconds (const gchar* seconds_str) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gint _tmp1_ = 0;
	gdouble seconds;
	gdouble total = 0.0;
	gint d = 0;
	gint h = 0;
	gint m = 0;
	gint s = 0;
	gdouble _tmp2_;
	gdouble _tmp5_;
	gdouble _tmp6_;
	gdouble _tmp7_;
	gdouble _tmp8_;
	gdouble _tmp9_;
	gdouble _tmp10_;
	gdouble _tmp11_;
	GString* _tmp12_;
	GString* output;
	gint _tmp13_;
	gint _tmp18_;
	gint _tmp23_;
	const gchar* _tmp31_ = NULL;
	gint _tmp32_;
	GString* _tmp33_;
	const gchar* _tmp34_;
	gint _tmp35_;
	gchar* _tmp36_ = NULL;
	gchar* _tmp37_;
	GString* _tmp38_;
	gssize _tmp39_;
	GString* _tmp42_;
	const gchar* _tmp43_;
	gchar* _tmp44_;
	gchar* str;
	const gchar* _tmp45_;
	const gchar* _tmp46_ = NULL;
	gchar* _tmp47_;
#line 72 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	g_return_val_if_fail (seconds_str != NULL, NULL);
#line 73 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp0_ = seconds_str;
#line 73 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp1_ = atoi (_tmp0_);
#line 73 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	seconds = (gdouble) _tmp1_;
#line 77 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp2_ = seconds;
#line 77 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	if (_tmp2_ == 0.0) {
#line 335 "tracker-utils.c"
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
#line 78 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp3_ = _ ("Less than one second");
#line 78 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp4_ = g_strdup (_tmp3_);
#line 78 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		result = _tmp4_;
#line 78 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		return result;
#line 346 "tracker-utils.c"
	}
#line 81 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp5_ = seconds;
#line 81 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	total = _tmp5_;
#line 82 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp6_ = total;
#line 82 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	s = ((gint) _tmp6_) % 60;
#line 83 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp7_ = total;
#line 83 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	total = _tmp7_ / 60;
#line 84 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp8_ = total;
#line 84 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	m = ((gint) _tmp8_) % 60;
#line 85 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp9_ = total;
#line 85 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	total = _tmp9_ / 60;
#line 86 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp10_ = total;
#line 86 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	h = ((gint) _tmp10_) % 24;
#line 87 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp11_ = total;
#line 87 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	d = ((gint) _tmp11_) / 24;
#line 89 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp12_ = g_string_new ("");
#line 89 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	output = _tmp12_;
#line 91 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp13_ = d;
#line 91 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	if (_tmp13_ > 0) {
#line 384 "tracker-utils.c"
		GString* _tmp14_;
		gint _tmp15_;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_;
#line 92 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp14_ = output;
#line 92 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp15_ = d;
#line 92 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp16_ = g_strdup_printf (" %dd", _tmp15_);
#line 92 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp17_ = _tmp16_;
#line 92 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		g_string_append (_tmp14_, _tmp17_);
#line 92 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_g_free0 (_tmp17_);
#line 401 "tracker-utils.c"
	}
#line 95 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp18_ = h;
#line 95 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	if (_tmp18_ > 0) {
#line 407 "tracker-utils.c"
		GString* _tmp19_;
		gint _tmp20_;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_;
#line 96 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp19_ = output;
#line 96 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp20_ = h;
#line 96 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp21_ = g_strdup_printf (" %.2d", _tmp20_);
#line 96 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp22_ = _tmp21_;
#line 96 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		g_string_append (_tmp19_, _tmp22_);
#line 96 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_g_free0 (_tmp22_);
#line 424 "tracker-utils.c"
	}
#line 99 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp23_ = m;
#line 99 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	if (_tmp23_ > 0) {
#line 430 "tracker-utils.c"
		const gchar* _tmp24_ = NULL;
		gint _tmp25_;
		GString* _tmp26_;
		const gchar* _tmp27_;
		gint _tmp28_;
		gchar* _tmp29_ = NULL;
		gchar* _tmp30_;
#line 100 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp25_ = h;
#line 100 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		if (_tmp25_ > 0) {
#line 100 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp24_ = ":";
#line 444 "tracker-utils.c"
		} else {
#line 100 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp24_ = "";
#line 448 "tracker-utils.c"
		}
#line 100 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp26_ = output;
#line 100 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp27_ = _tmp24_;
#line 100 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp28_ = m;
#line 100 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp29_ = g_strdup_printf ("%s%.2d", _tmp27_, _tmp28_);
#line 100 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp30_ = _tmp29_;
#line 100 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		g_string_append (_tmp26_, _tmp30_);
#line 100 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_g_free0 (_tmp30_);
#line 464 "tracker-utils.c"
	}
#line 104 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp32_ = m;
#line 104 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	if (_tmp32_ > 0) {
#line 104 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp31_ = ":";
#line 472 "tracker-utils.c"
	} else {
#line 104 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp31_ = "0:";
#line 476 "tracker-utils.c"
	}
#line 104 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp33_ = output;
#line 104 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp34_ = _tmp31_;
#line 104 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp35_ = s;
#line 104 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp36_ = g_strdup_printf ("%s%.2d", _tmp34_, _tmp35_);
#line 104 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp37_ = _tmp36_;
#line 104 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	g_string_append (_tmp33_, _tmp37_);
#line 104 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_g_free0 (_tmp37_);
#line 106 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp38_ = output;
#line 106 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp39_ = _tmp38_->len;
#line 106 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	if (_tmp39_ < ((gssize) 1)) {
#line 498 "tracker-utils.c"
		const gchar* _tmp40_ = NULL;
		gchar* _tmp41_;
#line 107 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp40_ = _ ("Less than one second");
#line 107 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp41_ = g_strdup (_tmp40_);
#line 107 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		result = _tmp41_;
#line 107 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_g_string_free0 (output);
#line 107 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		return result;
#line 511 "tracker-utils.c"
	}
#line 110 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp42_ = output;
#line 110 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp43_ = _tmp42_->str;
#line 110 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp44_ = g_strdup (_tmp43_);
#line 110 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	str = _tmp44_;
#line 112 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp45_ = str;
#line 112 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp46_ = g_strchug (_tmp45_);
#line 112 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp47_ = g_strdup (_tmp46_);
#line 112 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	result = _tmp47_;
#line 112 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_g_free0 (str);
#line 112 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_g_string_free0 (output);
#line 112 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	return result;
#line 535 "tracker-utils.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 118 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	return self ? g_object_ref (self) : NULL;
#line 542 "tracker-utils.c"
}


GdkPixbuf* tracker_pixbuf_new_from_file (GtkIconTheme* theme, const gchar* filename, gint size, gboolean is_image) {
	GdkPixbuf* result = NULL;
	const gchar* _tmp0_;
	GFile* _tmp1_ = NULL;
	GFile* file;
	GdkPixbuf* _tmp2_;
	GdkPixbuf* pixbuf;
	gboolean _tmp3_;
	GFile* _tmp17_;
	gboolean _tmp18_ = FALSE;
	GdkPixbuf* _tmp50_;
	GtkIconTheme* _tmp51_;
	gint _tmp52_;
	GdkPixbuf* _tmp53_ = NULL;
	GError * _inner_error_ = NULL;
#line 115 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	g_return_val_if_fail (theme != NULL, NULL);
#line 115 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	g_return_val_if_fail (filename != NULL, NULL);
#line 117 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp0_ = filename;
#line 117 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp1_ = g_file_new_for_uri (_tmp0_);
#line 117 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	file = _tmp1_;
#line 118 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp2_ = _g_object_ref0 (GDK_IS_PIXBUF (NULL) ? ((GdkPixbuf*) NULL) : NULL);
#line 118 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	pixbuf = _tmp2_;
#line 120 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp3_ = is_image;
#line 120 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	if (_tmp3_) {
#line 579 "tracker-utils.c"
		GdkPixbuf* _tmp16_;
		{
			GFile* _tmp4_;
			gchar* _tmp5_ = NULL;
			gchar* _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			GdkPixbuf* _tmp9_;
			GdkPixbuf* _tmp10_;
			GdkPixbuf* _tmp11_;
#line 122 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp4_ = file;
#line 122 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp5_ = g_file_get_path (_tmp4_);
#line 122 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp6_ = _tmp5_;
#line 122 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp7_ = size;
#line 122 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp8_ = size;
#line 122 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp9_ = gdk_pixbuf_new_from_file_at_size (_tmp6_, _tmp7_, _tmp8_, &_inner_error_);
#line 122 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp10_ = _tmp9_;
#line 122 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_g_free0 (_tmp6_);
#line 122 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp11_ = _tmp10_;
#line 122 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			if (_inner_error_ != NULL) {
#line 610 "tracker-utils.c"
				goto __catch15_g_error;
			}
#line 122 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_g_object_unref0 (pixbuf);
#line 122 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			pixbuf = _tmp11_;
#line 617 "tracker-utils.c"
		}
		goto __finally15;
		__catch15_g_error:
		{
			GError* e = NULL;
			GError* _tmp12_;
			const gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
#line 121 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			e = _inner_error_;
#line 121 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_inner_error_ = NULL;
#line 124 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp12_ = e;
#line 124 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp13_ = _tmp12_->message;
#line 124 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp14_ = g_strconcat ("Error loading icon pixbuf: ", _tmp13_, NULL);
#line 124 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp15_ = _tmp14_;
#line 124 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			g_warning ("tracker-utils.vala:124: %s", _tmp15_);
#line 124 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_g_free0 (_tmp15_);
#line 121 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_g_error_free0 (e);
#line 645 "tracker-utils.c"
		}
		__finally15:
#line 121 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		if (_inner_error_ != NULL) {
#line 121 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_g_object_unref0 (pixbuf);
#line 121 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_g_object_unref0 (file);
#line 121 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 121 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			g_clear_error (&_inner_error_);
#line 121 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			return NULL;
#line 660 "tracker-utils.c"
		}
#line 127 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp16_ = pixbuf;
#line 127 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		if (_tmp16_ != NULL) {
#line 128 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			result = pixbuf;
#line 128 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_g_object_unref0 (file);
#line 128 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			return result;
#line 672 "tracker-utils.c"
		}
	}
#line 132 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp17_ = file;
#line 132 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp18_ = g_file_query_exists (_tmp17_, NULL);
#line 132 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	if (_tmp18_) {
#line 681 "tracker-utils.c"
		{
			GFile* _tmp19_;
			GFileInfo* _tmp20_ = NULL;
			GFileInfo* file_info;
			GFileInfo* _tmp21_;
#line 134 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp19_ = file;
#line 134 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp20_ = g_file_query_info (_tmp19_, "standard::icon", G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
#line 134 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			file_info = _tmp20_;
#line 134 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			if (_inner_error_ != NULL) {
#line 695 "tracker-utils.c"
				goto __catch16_g_error;
			}
#line 138 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp21_ = file_info;
#line 138 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			if (_tmp21_ != NULL) {
#line 702 "tracker-utils.c"
				GFileInfo* _tmp22_;
				GIcon* _tmp23_ = NULL;
				GIcon* _tmp24_;
				GIcon* icon;
#line 139 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
				_tmp22_ = file_info;
#line 139 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
				_tmp23_ = g_file_info_get_icon (_tmp22_);
#line 139 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
				_tmp24_ = _g_object_ref0 (_tmp23_);
#line 139 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
				icon = _tmp24_;
#line 715 "tracker-utils.c"
				{
					GIcon* _tmp25_;
#line 142 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
					_tmp25_ = icon;
#line 142 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
					if (G_IS_FILE_ICON (_tmp25_)) {
#line 722 "tracker-utils.c"
						GIcon* _tmp26_;
						GFile* _tmp27_ = NULL;
						gchar* _tmp28_ = NULL;
						gchar* _tmp29_;
						GdkPixbuf* _tmp30_;
						GdkPixbuf* _tmp31_;
						GdkPixbuf* _tmp32_;
#line 143 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
						_tmp26_ = icon;
#line 143 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
						_tmp27_ = g_file_icon_get_file (G_FILE_ICON (_tmp26_));
#line 143 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
						_tmp28_ = g_file_get_path (_tmp27_);
#line 143 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
						_tmp29_ = _tmp28_;
#line 143 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
						_tmp30_ = gdk_pixbuf_new_from_file (_tmp29_, &_inner_error_);
#line 143 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
						_tmp31_ = _tmp30_;
#line 143 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
						_g_free0 (_tmp29_);
#line 143 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
						_tmp32_ = _tmp31_;
#line 143 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
						if (_inner_error_ != NULL) {
#line 748 "tracker-utils.c"
							goto __catch17_g_error;
						}
#line 143 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
						_g_object_unref0 (pixbuf);
#line 143 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
						pixbuf = _tmp32_;
#line 755 "tracker-utils.c"
					} else {
						GIcon* _tmp33_;
#line 144 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
						_tmp33_ = icon;
#line 144 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
						if (G_IS_THEMED_ICON (_tmp33_)) {
#line 762 "tracker-utils.c"
							GtkIconTheme* _tmp34_;
							GIcon* _tmp35_;
							gchar** _tmp36_;
							gchar** _tmp37_ = NULL;
							const gchar* _tmp38_;
							gint _tmp39_;
							GdkPixbuf* _tmp40_ = NULL;
							GdkPixbuf* _tmp41_;
#line 145 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
							_tmp34_ = theme;
#line 145 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
							_tmp35_ = icon;
#line 145 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
							_tmp37_ = _tmp36_ = g_themed_icon_get_names (G_THEMED_ICON (_tmp35_));
#line 145 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
							_tmp38_ = _tmp37_[0];
#line 145 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
							_tmp39_ = size;
#line 145 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
							_tmp40_ = gtk_icon_theme_load_icon (_tmp34_, _tmp38_, _tmp39_, GTK_ICON_LOOKUP_USE_BUILTIN, &_inner_error_);
#line 145 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
							_tmp41_ = _tmp40_;
#line 145 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
							if (_inner_error_ != NULL) {
#line 787 "tracker-utils.c"
								goto __catch17_g_error;
							}
#line 145 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
							_g_object_unref0 (pixbuf);
#line 145 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
							pixbuf = _tmp41_;
#line 794 "tracker-utils.c"
						}
					}
				}
				goto __finally17;
				__catch17_g_error:
				{
					GError* e = NULL;
					GError* _tmp42_;
					const gchar* _tmp43_;
					gchar* _tmp44_;
					gchar* _tmp45_;
#line 141 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
					e = _inner_error_;
#line 141 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
					_inner_error_ = NULL;
#line 148 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
					_tmp42_ = e;
#line 148 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
					_tmp43_ = _tmp42_->message;
#line 148 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
					_tmp44_ = g_strconcat ("Error loading icon pixbuf: ", _tmp43_, NULL);
#line 148 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
					_tmp45_ = _tmp44_;
#line 148 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
					g_warning ("tracker-utils.vala:148: %s", _tmp45_);
#line 148 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
					_g_free0 (_tmp45_);
#line 141 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
					_g_error_free0 (e);
#line 824 "tracker-utils.c"
				}
				__finally17:
#line 141 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
				if (_inner_error_ != NULL) {
#line 141 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
					_g_object_unref0 (icon);
#line 141 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
					_g_object_unref0 (file_info);
#line 833 "tracker-utils.c"
					goto __catch16_g_error;
				}
#line 138 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
				_g_object_unref0 (icon);
#line 838 "tracker-utils.c"
			}
#line 133 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_g_object_unref0 (file_info);
#line 842 "tracker-utils.c"
		}
		goto __finally16;
		__catch16_g_error:
		{
			GError* e = NULL;
			GError* _tmp46_;
			const gchar* _tmp47_;
			gchar* _tmp48_;
			gchar* _tmp49_;
#line 133 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			e = _inner_error_;
#line 133 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_inner_error_ = NULL;
#line 152 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp46_ = e;
#line 152 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp47_ = _tmp46_->message;
#line 152 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp48_ = g_strconcat ("Error looking up file for pixbuf: ", _tmp47_, NULL);
#line 152 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp49_ = _tmp48_;
#line 152 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			g_warning ("tracker-utils.vala:152: %s", _tmp49_);
#line 152 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_g_free0 (_tmp49_);
#line 133 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_g_error_free0 (e);
#line 870 "tracker-utils.c"
		}
		__finally16:
#line 133 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		if (_inner_error_ != NULL) {
#line 133 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_g_object_unref0 (pixbuf);
#line 133 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			_g_object_unref0 (file);
#line 133 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 133 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			g_clear_error (&_inner_error_);
#line 133 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
			return NULL;
#line 885 "tracker-utils.c"
		}
	}
#line 156 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp50_ = pixbuf;
#line 156 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	if (_tmp50_ != NULL) {
#line 157 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		result = pixbuf;
#line 157 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_g_object_unref0 (file);
#line 157 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		return result;
#line 898 "tracker-utils.c"
	}
#line 160 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp51_ = theme;
#line 160 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp52_ = size;
#line 160 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp53_ = tracker_pixbuf_new_from_name (_tmp51_, "text-x-generic", _tmp52_);
#line 160 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	result = _tmp53_;
#line 160 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_g_object_unref0 (pixbuf);
#line 160 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_g_object_unref0 (file);
#line 160 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	return result;
#line 914 "tracker-utils.c"
}


GdkPixbuf* tracker_pixbuf_new_from_name (GtkIconTheme* theme, const gchar* name, gint size) {
	GdkPixbuf* result = NULL;
	GdkPixbuf* _tmp0_;
	GdkPixbuf* pixbuf;
	GError * _inner_error_ = NULL;
#line 163 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	g_return_val_if_fail (theme != NULL, NULL);
#line 163 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 165 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp0_ = _g_object_ref0 (GDK_IS_PIXBUF (NULL) ? ((GdkPixbuf*) NULL) : NULL);
#line 165 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	pixbuf = _tmp0_;
#line 931 "tracker-utils.c"
	{
		GtkIconTheme* _tmp1_;
		const gchar* _tmp2_;
		gint _tmp3_;
		GdkPixbuf* _tmp4_ = NULL;
		GdkPixbuf* _tmp5_;
#line 168 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp1_ = theme;
#line 168 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp2_ = name;
#line 168 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp3_ = size;
#line 168 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp4_ = gtk_icon_theme_load_icon (_tmp1_, _tmp2_, _tmp3_, GTK_ICON_LOOKUP_USE_BUILTIN, &_inner_error_);
#line 168 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp5_ = _tmp4_;
#line 168 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		if (_inner_error_ != NULL) {
#line 950 "tracker-utils.c"
			goto __catch18_g_error;
		}
#line 168 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_g_object_unref0 (pixbuf);
#line 168 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		pixbuf = _tmp5_;
#line 957 "tracker-utils.c"
	}
	goto __finally18;
	__catch18_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp6_;
		GError* _tmp7_;
		const gchar* _tmp8_;
#line 167 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		e = _inner_error_;
#line 167 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_inner_error_ = NULL;
#line 170 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp6_ = name;
#line 170 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp7_ = e;
#line 170 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp8_ = _tmp7_->message;
#line 170 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		g_warning ("tracker-utils.vala:170: Could not load default icon pixbuf from theme " \
"for '%s': %s", _tmp6_, _tmp8_);
#line 167 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_g_error_free0 (e);
#line 980 "tracker-utils.c"
	}
	__finally18:
#line 167 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	if (_inner_error_ != NULL) {
#line 167 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		_g_object_unref0 (pixbuf);
#line 167 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 167 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		g_clear_error (&_inner_error_);
#line 167 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
		return NULL;
#line 993 "tracker-utils.c"
	}
#line 173 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	result = pixbuf;
#line 173 "/home/martyn/Source/tracker/src/tracker-needle/tracker-utils.vala"
	return result;
#line 999 "tracker-utils.c"
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



