/* tracker-tags-view.c generated by valac 0.14.2, the Vala compiler
 * generated from tracker-tags-view.vala, do not modify */

/*
 * Copyright (C) 2011, Martyn Russell <martyn@lanedo.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <libtracker-sparql/tracker-sparql.h>
#include <glib/gi18n-lib.h>
#include <pango/pango.h>
#include <gobject/gvaluecollector.h>


#define TYPE_TAG_DATA (tag_data_get_type ())
#define TAG_DATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAG_DATA, TagData))
#define TAG_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAG_DATA, TagDataClass))
#define IS_TAG_DATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAG_DATA))
#define IS_TAG_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAG_DATA))
#define TAG_DATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAG_DATA, TagDataClass))

typedef struct _TagData TagData;
typedef struct _TagDataClass TagDataClass;
typedef struct _TagDataPrivate TagDataPrivate;

#define TYPE_TRACKER_TAGS_VIEW (tracker_tags_view_get_type ())
#define TRACKER_TAGS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRACKER_TAGS_VIEW, TrackerTagsView))
#define TRACKER_TAGS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRACKER_TAGS_VIEW, TrackerTagsViewClass))
#define IS_TRACKER_TAGS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRACKER_TAGS_VIEW))
#define IS_TRACKER_TAGS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRACKER_TAGS_VIEW))
#define TRACKER_TAGS_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRACKER_TAGS_VIEW, TrackerTagsViewClass))

typedef struct _TrackerTagsView TrackerTagsView;
typedef struct _TrackerTagsViewClass TrackerTagsViewClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecTagData ParamSpecTagData;
typedef struct _TrackerTagsViewPrivate TrackerTagsViewPrivate;
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))
#define _tag_data_unref0(var) ((var == NULL) ? NULL : (var = (tag_data_unref (var), NULL)))
#define __g_list_free__tag_data_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__tag_data_unref0_ (var), NULL)))

#define TRACKER_TAGS_VIEW_TYPE_COL (tracker_tags_view_col_get_type ())

#define TRACKER_TAGS_VIEW_TYPE_SELECTION (tracker_tags_view_selection_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))
typedef struct _TrackerTagsViewModelToggleRowData TrackerTagsViewModelToggleRowData;
typedef struct _Block2Data Block2Data;
typedef struct _TrackerTagsViewRemoveTagData TrackerTagsViewRemoveTagData;
typedef struct _TrackerTagsViewAddTagData TrackerTagsViewAddTagData;
typedef struct _Block3Data Block3Data;
typedef struct _TrackerTagsViewQueryTagsForFilesData TrackerTagsViewQueryTagsForFilesData;
typedef struct _TrackerTagsViewQueryTagsData TrackerTagsViewQueryTagsData;
typedef struct _TrackerTagsViewQueryFilesForTagIdData TrackerTagsViewQueryFilesForTagIdData;

struct _TagData {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TagDataPrivate * priv;
	TrackerTagsView* tv;
	GCancellable* cancellable;
	gchar* tag_id;
	GtkTreeIter iter;
	gint items;
	gboolean update;
	gboolean selected;
};

struct _TagDataClass {
	GTypeClass parent_class;
	void (*finalize) (TagData *self);
};

struct _ParamSpecTagData {
	GParamSpec parent_instance;
};

struct _TrackerTagsView {
	GtkVBox parent_instance;
	TrackerTagsViewPrivate * priv;
};

struct _TrackerTagsViewClass {
	GtkVBoxClass parent_class;
};

struct _TrackerTagsViewPrivate {
	TrackerSparqlConnection* connection;
	GCancellable* cancellable;
	GList* tag_data_requests;
	GList* files;
	GtkListStore* store;
	GtkVBox* vbox;
	GtkLabel* label;
	GtkEntry* entry;
	GtkButton* button_add;
	GtkButton* button_remove;
	GtkScrolledWindow* scrolled_window;
	GtkTreeView* view;
};

typedef enum  {
	TRACKER_TAGS_VIEW_COL_SELECTION,
	TRACKER_TAGS_VIEW_COL_TAG_ID,
	TRACKER_TAGS_VIEW_COL_TAG_NAME,
	TRACKER_TAGS_VIEW_COL_TAG_COUNT,
	TRACKER_TAGS_VIEW_COL_TAG_COUNT_VALUE,
	TRACKER_TAGS_VIEW_COL_N_COLUMNS
} TrackerTagsViewCol;

typedef enum  {
	TRACKER_TAGS_VIEW_SELECTION_INCONSISTENT = -1,
	TRACKER_TAGS_VIEW_SELECTION_FALSE = 0,
	TRACKER_TAGS_VIEW_SELECTION_TRUE = 1
} TrackerTagsViewSelection;

struct _Block1Data {
	int _ref_count_;
	TrackerTagsView * self;
	GtkMessageDialog* msg;
};

struct _TrackerTagsViewModelToggleRowData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerTagsView* self;
	GtkTreePath* path;
	GtkTreeModel* model;
	GtkTreeIter iter;
	gchar* id;
	gchar* tag;
	gint selection;
	GtkTreeView* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* _tmp2_;
	GtkTreeModel* _tmp3_;
	GtkTreePath* _tmp4_;
	GtkTreeIter _tmp5_;
	gboolean _tmp6_;
	GtkTreeModel* _tmp7_;
	GtkTreeIter _tmp8_;
	TrackerTagsViewSelection _tmp9_;
	gint _tmp10_;
	TrackerTagsViewSelection _tmp11_;
	gint new_value;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* tag_escaped;
	gchar* _tmp14_;
	gchar* filter;
	gchar* query;
	TagData* td;
	gint _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	const gchar* _tmp22_;
	GtkTreeIter _tmp23_;
	TagData* _tmp24_;
	TagData* _tmp25_;
	TagData* _tmp26_;
	TagData* _tmp27_;
	TrackerSparqlConnection* _tmp28_;
	GtkEntry* _tmp29_;
	const gchar* _tmp30_;
	GtkTreeIter _tmp31_;
	gint _tmp32_;
	TagData* _tmp33_;
	TagData* _tmp34_;
	TagData* _tmp35_;
	TrackerSparqlConnection* _tmp36_;
	const gchar* _tmp37_;
	TagData* _tmp38_;
	GCancellable* _tmp39_;
	TagData* _tmp40_;
	GtkEntry* _tmp41_;
	GError* e;
	GError* _tmp42_;
	const gchar* _tmp43_;
	const gchar* _tmp44_;
	GError* _tmp45_;
	TagData* _tmp46_;
	GtkEntry* _tmp47_;
	GError * _inner_error_;
};

struct _Block2Data {
	int _ref_count_;
	TrackerTagsView * self;
	GtkTreeIter found_iter;
	gboolean found;
	gchar* tag;
};

struct _TrackerTagsViewRemoveTagData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerTagsView* self;
	TagData* td;
	TrackerSparqlConnection* _tmp0_;
	TagData* _tmp1_;
	const gchar* _tmp2_;
	TagData* _tmp3_;
	TagData* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* query;
	TrackerSparqlConnection* _tmp7_;
	const gchar* _tmp8_;
	TagData* _tmp9_;
	GCancellable* _tmp10_;
	GtkListStore* _tmp11_;
	TagData* _tmp12_;
	GtkTreeIter _tmp13_;
	GError* e;
	GError* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	GError* _tmp17_;
	TagData* _tmp18_;
	GError * _inner_error_;
};

struct _TrackerTagsViewAddTagData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerTagsView* self;
	gchar* tag;
	gchar* query;
	TrackerSparqlConnection* _tmp0_;
	const gchar* _tmp1_;
	GtkEntry* _tmp2_;
	gboolean _tmp3_;
	GList* _tmp4_;
	GList* _tmp5_;
	guint _tmp6_;
	gboolean _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* filter;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* tag_escaped;
	GList* _tmp12_;
	GList* url_collection;
	GList* url_it;
	gchar* _tmp13_;
	gchar* url;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	const gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* tag_label_escaped;
	const gchar* _tmp30_;
	const gchar* _tmp31_;
	gchar* _tmp32_;
	GList* _tmp33_;
	guint _tmp34_;
	TagData* _tmp35_;
	TagData* td;
	TagData* _tmp36_;
	TagData* _tmp37_;
	TrackerSparqlConnection* _tmp38_;
	const gchar* _tmp39_;
	TagData* _tmp40_;
	GCancellable* _tmp41_;
	TagData* _tmp42_;
	GtkEntry* _tmp43_;
	GError* e;
	GError* _tmp44_;
	const gchar* _tmp45_;
	const gchar* _tmp46_;
	GError* _tmp47_;
	TagData* _tmp48_;
	GtkEntry* _tmp49_;
	GError * _inner_error_;
};

struct _Block3Data {
	int _ref_count_;
	TrackerTagsView * self;
	GtkListStore* store;
};

struct _TrackerTagsViewQueryTagsForFilesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerTagsView* self;
	GList* _tmp0_;
	gchar* _tmp1_;
	gchar* files_filter;
	GList* _tmp2_;
	GList* url_collection;
	GList* url_it;
	gchar* _tmp3_;
	gchar* url;
	const gchar* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* query;
	TrackerSparqlConnection* _tmp16_;
	const gchar* _tmp17_;
	TrackerSparqlCursor* _tmp18_;
	TrackerSparqlCursor* cursor;
	TrackerSparqlCursor* _tmp19_;
	gboolean _tmp20_;
	gboolean _tmp21_;
	TrackerSparqlCursor* _tmp22_;
	const gchar* _tmp23_;
	const gchar* id;
	TrackerSparqlCursor* _tmp24_;
	const gchar* _tmp25_;
	const gchar* label;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	GtkTreeIter iter;
	const gchar* _tmp28_;
	GtkTreeIter _tmp29_;
	gboolean _tmp30_;
	GtkListStore* _tmp31_;
	GtkTreeIter _tmp32_;
	GError* e;
	GError* _tmp33_;
	const gchar* _tmp34_;
	const gchar* _tmp35_;
	GError* _tmp36_;
	GError * _inner_error_;
};

struct _TrackerTagsViewQueryTagsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerTagsView* self;
	gchar* _tmp0_;
	gchar* query;
	GtkListStore* _tmp1_;
	TrackerSparqlConnection* _tmp2_;
	const gchar* _tmp3_;
	TrackerSparqlCursor* _tmp4_;
	TrackerSparqlCursor* cursor;
	TrackerSparqlCursor* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	TrackerSparqlCursor* _tmp8_;
	const gchar* _tmp9_;
	const gchar* id;
	TrackerSparqlCursor* _tmp10_;
	const gchar* _tmp11_;
	const gchar* label;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	GtkTreeIter iter;
	GtkListStore* _tmp14_;
	GtkTreeIter _tmp15_;
	GtkListStore* _tmp16_;
	GtkTreeIter _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	GtkTreeIter _tmp21_;
	TagData* _tmp22_;
	TagData* td;
	TagData* _tmp23_;
	TagData* _tmp24_;
	TagData* _tmp25_;
	GError* e;
	GError* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	GError* _tmp29_;
	GError * _inner_error_;
};

struct _TrackerTagsViewQueryFilesForTagIdData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerTagsView* self;
	TagData* td;
	TrackerSparqlConnection* _tmp0_;
	TagData* _tmp1_;
	const gchar* _tmp2_;
	TagData* _tmp3_;
	TagData* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* query;
	TrackerSparqlConnection* _tmp7_;
	const gchar* _tmp8_;
	TagData* _tmp9_;
	GCancellable* _tmp10_;
	TrackerSparqlCursor* _tmp11_;
	TrackerSparqlCursor* cursor;
	guint has_tag_in_selection;
	guint files_with_tag;
	GList* _tmp12_;
	guint _tmp13_;
	guint files_selected;
	TrackerSparqlCursor* _tmp14_;
	gboolean _tmp15_;
	gboolean _tmp16_;
	guint _tmp17_;
	GList* _tmp18_;
	GList* url_collection;
	GList* url_it;
	gchar* _tmp19_;
	gchar* url;
	TrackerSparqlCursor* _tmp20_;
	const gchar* _tmp21_;
	const gchar* url_returned;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	guint _tmp27_;
	guint _tmp28_;
	guint _tmp29_;
	guint _tmp30_;
	guint _tmp31_;
	GtkListStore* _tmp32_;
	TagData* _tmp33_;
	GtkTreeIter _tmp34_;
	guint _tmp35_;
	guint _tmp36_;
	GtkListStore* _tmp37_;
	TagData* _tmp38_;
	GtkTreeIter _tmp39_;
	GtkListStore* _tmp40_;
	TagData* _tmp41_;
	GtkTreeIter _tmp42_;
	guint _tmp43_;
	gchar* _tmp44_;
	gchar* str;
	GtkListStore* _tmp45_;
	TagData* _tmp46_;
	GtkTreeIter _tmp47_;
	const gchar* _tmp48_;
	guint _tmp49_;
	GError* e;
	GError* _tmp50_;
	const gchar* _tmp51_;
	const gchar* _tmp52_;
	GError* _tmp53_;
	TagData* _tmp54_;
	GError * _inner_error_;
};


static gpointer tag_data_parent_class = NULL;
static gpointer tracker_tags_view_parent_class = NULL;

gpointer tag_data_ref (gpointer instance);
void tag_data_unref (gpointer instance);
GParamSpec* param_spec_tag_data (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_tag_data (GValue* value, gpointer v_object);
void value_take_tag_data (GValue* value, gpointer v_object);
gpointer value_get_tag_data (const GValue* value);
GType tag_data_get_type (void) G_GNUC_CONST;
GType tracker_tags_view_get_type (void) G_GNUC_CONST;
enum  {
	TAG_DATA_DUMMY_PROPERTY
};
TagData* tag_data_new (const gchar* _tag_id, GtkTreeIter* _iter, gboolean _update, gboolean _selected, gint _items, TrackerTagsView* _tv);
TagData* tag_data_construct (GType object_type, const gchar* _tag_id, GtkTreeIter* _iter, gboolean _update, gboolean _selected, gint _items, TrackerTagsView* _tv);
static void tag_data_finalize (TagData* obj);
#define TRACKER_TAGS_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TRACKER_TAGS_VIEW, TrackerTagsViewPrivate))
enum  {
	TRACKER_TAGS_VIEW_DUMMY_PROPERTY
};
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
static void _tag_data_unref0_ (gpointer var);
static void _g_list_free__tag_data_unref0_ (GList* self);
static GType tracker_tags_view_col_get_type (void) G_GNUC_UNUSED;
static GType tracker_tags_view_selection_get_type (void) G_GNUC_UNUSED;
#define TRACKER_TAGS_VIEW_UI_FILE "tracker-needle.ui"
TrackerTagsView* tracker_tags_view_new (GList* _files);
TrackerTagsView* tracker_tags_view_construct (GType object_type, GList* _files);
static void tracker_tags_view_create_ui (TrackerTagsView* self);
void tracker_tags_view_hide_label (TrackerTagsView* self);
void tracker_tags_view_set_files (TrackerTagsView* self, GList* _files);
static void tracker_tags_view_update_for_files (TrackerTagsView* self);
static void tracker_tags_view_show_error_dialog (TrackerTagsView* self, const gchar* action, GError* e);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static void __lambda1_ (Block1Data* _data1_);
static void ___lambda1__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
void tracker_tags_view_button_remove_clicked_cb (GtkButton* source, TrackerTagsView* self);
static void tracker_tags_view_remove_tag (TrackerTagsView* self, TagData* td, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void tracker_tags_view_remove_tag_finish (TrackerTagsView* self, GAsyncResult* _res_);
void tracker_tags_view_button_add_clicked_cb (GtkButton* source, TrackerTagsView* self);
static void tracker_tags_view_add_tag (TrackerTagsView* self, const gchar* tag, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void tracker_tags_view_add_tag_finish (TrackerTagsView* self, GAsyncResult* _res_);
void tracker_tags_view_entry_tag_activated_cb (GtkEntry* source, TrackerTagsView* self);
void tracker_tags_view_entry_tag_changed_cb (GtkEditable* source, TrackerTagsView* self);
static gboolean tracker_tags_view_find_tag (TrackerTagsView* self, const gchar* tag, GtkTreeIter* iter);
void tracker_tags_view_treeview_tags_cell_toggled_cb (GtkCellRendererToggle* source, const gchar* path_string, TrackerTagsView* self);
static void tracker_tags_view_model_toggle_row (TrackerTagsView* self, GtkTreePath* path, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void tracker_tags_view_model_toggle_row_finish (TrackerTagsView* self, GAsyncResult* _res_);
void tracker_tags_view_treeview_tags_row_selected_cb (GtkTreeSelection* selection, TrackerTagsView* self);
void tracker_tags_view_treeview_tags_row_activated_cb (GtkTreeView* source, GtkTreePath* path, GtkTreeViewColumn* column, TrackerTagsView* self);
static void tracker_tags_view_treeview_tags_toggle_cell_data_func (GtkCellLayout* layout, GtkCellRenderer* cell, GtkTreeModel* model, GtkTreeIter* iter, TrackerTagsView* self);
static void _tracker_tags_view_entry_tag_changed_cb_gtk_editable_changed (GtkEditable* _sender, gpointer self);
static void _tracker_tags_view_button_add_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _tracker_tags_view_button_remove_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _tracker_tags_view_treeview_tags_cell_toggled_cb_gtk_cell_renderer_toggle_toggled (GtkCellRendererToggle* _sender, const gchar* path, gpointer self);
static void _tracker_tags_view_treeview_tags_toggle_cell_data_func_gtk_cell_layout_data_func (GtkCellLayout* cell_layout, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter, gpointer self);
static void _tracker_tags_view_treeview_tags_row_selected_cb_gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self);
static void _tracker_tags_view_treeview_tags_row_activated_cb_gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self);
static void tracker_tags_view_query_tags (TrackerTagsView* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void tracker_tags_view_query_tags_finish (TrackerTagsView* self, GAsyncResult* _res_);
static void tracker_tags_view_query_tags_for_files (TrackerTagsView* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void tracker_tags_view_query_tags_for_files_finish (TrackerTagsView* self, GAsyncResult* _res_);
static void tracker_tags_view_model_toggle_row_data_free (gpointer _data);
static gboolean tracker_tags_view_model_toggle_row_co (TrackerTagsViewModelToggleRowData* _data_);
static gchar* tracker_tags_view_sparql_get_escaped_string (TrackerTagsView* self, const gchar* str);
static gchar* tracker_tags_view_sparql_get_filter_string (TrackerTagsView* self, const gchar* tag);
static void tracker_tags_view_query_files_for_tag_id (TrackerTagsView* self, TagData* td, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void tracker_tags_view_query_files_for_tag_id_finish (TrackerTagsView* self, GAsyncResult* _res_);
static void tracker_tags_view_model_toggle_row_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tracker_tags_view_update_tag_data (TrackerTagsView* self, TagData* td);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
static gboolean __lambda0_ (Block2Data* _data2_, GtkTreeModel* model, GtkTreePath* path, GtkTreeIter* foreach_iter);
static gboolean ___lambda0__gtk_tree_model_foreach_func (GtkTreeModel* model, GtkTreePath* path, GtkTreeIter* iter, gpointer self);
static void tracker_tags_view_remove_tag_data_free (gpointer _data);
static gboolean tracker_tags_view_remove_tag_co (TrackerTagsViewRemoveTagData* _data_);
static void tracker_tags_view_remove_tag_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tracker_tags_view_add_tag_data_free (gpointer _data);
static gboolean tracker_tags_view_add_tag_co (TrackerTagsViewAddTagData* _data_);
static void tracker_tags_view_add_tag_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tracker_tags_view_untoggle_all (TrackerTagsView* self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (Block3Data* _data3_);
static gboolean __lambda2_ (Block3Data* _data3_, GtkTreeModel* model, GtkTreePath* path, GtkTreeIter* foreach_iter);
static gboolean ___lambda2__gtk_tree_model_foreach_func (GtkTreeModel* model, GtkTreePath* path, GtkTreeIter* iter, gpointer self);
static void tracker_tags_view_query_tags_for_files_data_free (gpointer _data);
static gboolean tracker_tags_view_query_tags_for_files_co (TrackerTagsViewQueryTagsForFilesData* _data_);
static void tracker_tags_view_query_tags_for_files_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tracker_tags_view_query_tags_data_free (gpointer _data);
static gboolean tracker_tags_view_query_tags_co (TrackerTagsViewQueryTagsData* _data_);
static void tracker_tags_view_query_tags_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tracker_tags_view_query_files_for_tag_id_data_free (gpointer _data);
static gboolean tracker_tags_view_query_files_for_tag_id_co (TrackerTagsViewQueryFilesForTagIdData* _data_);
static void tracker_tags_view_query_files_for_tag_id_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tracker_tags_view_finalize (GObject* obj);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


TagData* tag_data_construct (GType object_type, const gchar* _tag_id, GtkTreeIter* _iter, gboolean _update, gboolean _selected, gint _items, TrackerTagsView* _tv) {
	TagData* self = NULL;
	TrackerTagsView* _tmp0_;
	TrackerTagsView* _tmp1_;
	GCancellable* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	GtkTreeIter* _tmp5_;
	gint _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	g_return_val_if_fail (_tv != NULL, NULL);
	self = (TagData*) g_type_create_instance (object_type);
	g_debug ("tracker-tags-view.vala:33: Creating tag data");
	_tmp0_ = _tv;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->tv);
	self->tv = _tmp1_;
	_tmp2_ = g_cancellable_new ();
	_g_object_unref0 (self->cancellable);
	self->cancellable = _tmp2_;
	_tmp3_ = _tag_id;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (self->tag_id);
	self->tag_id = _tmp4_;
	_tmp5_ = _iter;
	if (_tmp5_ != NULL) {
		GtkTreeIter* _tmp6_;
		_tmp6_ = _iter;
		self->iter = *_tmp6_;
	}
	_tmp7_ = _items;
	self->items = _tmp7_;
	_tmp8_ = _update;
	self->update = _tmp8_;
	_tmp9_ = _selected;
	self->selected = _tmp9_;
	return self;
}


TagData* tag_data_new (const gchar* _tag_id, GtkTreeIter* _iter, gboolean _update, gboolean _selected, gint _items, TrackerTagsView* _tv) {
	return tag_data_construct (TYPE_TAG_DATA, _tag_id, _iter, _update, _selected, _items, _tv);
}


static void value_tag_data_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_tag_data_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		tag_data_unref (value->data[0].v_pointer);
	}
}


static void value_tag_data_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = tag_data_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_tag_data_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_tag_data_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		TagData* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = tag_data_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_tag_data_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	TagData** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = tag_data_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_tag_data (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecTagData* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_TAG_DATA), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_tag_data (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TAG_DATA), NULL);
	return value->data[0].v_pointer;
}


void value_set_tag_data (GValue* value, gpointer v_object) {
	TagData* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TAG_DATA));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TAG_DATA));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		tag_data_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tag_data_unref (old);
	}
}


void value_take_tag_data (GValue* value, gpointer v_object) {
	TagData* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TAG_DATA));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TAG_DATA));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tag_data_unref (old);
	}
}


static void tag_data_class_init (TagDataClass * klass) {
	tag_data_parent_class = g_type_class_peek_parent (klass);
	TAG_DATA_CLASS (klass)->finalize = tag_data_finalize;
}


static void tag_data_instance_init (TagData * self) {
	self->ref_count = 1;
}


static void tag_data_finalize (TagData* obj) {
	TagData * self;
	GCancellable* _tmp0_;
	self = TAG_DATA (obj);
	_tmp0_ = self->cancellable;
	if (_tmp0_ != NULL) {
		GCancellable* _tmp1_;
		_tmp1_ = self->cancellable;
		g_cancellable_cancel (_tmp1_);
		_g_object_unref0 (self->cancellable);
		self->cancellable = NULL;
	}
	_g_object_unref0 (self->tv);
	_g_object_unref0 (self->cancellable);
	_g_free0 (self->tag_id);
}


GType tag_data_get_type (void) {
	static volatile gsize tag_data_type_id__volatile = 0;
	if (g_once_init_enter (&tag_data_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_tag_data_init, value_tag_data_free_value, value_tag_data_copy_value, value_tag_data_peek_pointer, "p", value_tag_data_collect_value, "p", value_tag_data_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (TagDataClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tag_data_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TagData), 0, (GInstanceInitFunc) tag_data_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType tag_data_type_id;
		tag_data_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TagData", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&tag_data_type_id__volatile, tag_data_type_id);
	}
	return tag_data_type_id__volatile;
}


gpointer tag_data_ref (gpointer instance) {
	TagData* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void tag_data_unref (gpointer instance) {
	TagData* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		TAG_DATA_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


static gpointer _tag_data_ref0 (gpointer self) {
	return self ? tag_data_ref (self) : NULL;
}


static void _tag_data_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (tag_data_unref (var), NULL));
}


static void _g_list_free__tag_data_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _tag_data_unref0_, NULL);
	g_list_free (self);
}


static GType tracker_tags_view_col_get_type (void) {
	static volatile gsize tracker_tags_view_col_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_tags_view_col_type_id__volatile)) {
		static const GEnumValue values[] = {{TRACKER_TAGS_VIEW_COL_SELECTION, "TRACKER_TAGS_VIEW_COL_SELECTION", "selection"}, {TRACKER_TAGS_VIEW_COL_TAG_ID, "TRACKER_TAGS_VIEW_COL_TAG_ID", "tag-id"}, {TRACKER_TAGS_VIEW_COL_TAG_NAME, "TRACKER_TAGS_VIEW_COL_TAG_NAME", "tag-name"}, {TRACKER_TAGS_VIEW_COL_TAG_COUNT, "TRACKER_TAGS_VIEW_COL_TAG_COUNT", "tag-count"}, {TRACKER_TAGS_VIEW_COL_TAG_COUNT_VALUE, "TRACKER_TAGS_VIEW_COL_TAG_COUNT_VALUE", "tag-count-value"}, {TRACKER_TAGS_VIEW_COL_N_COLUMNS, "TRACKER_TAGS_VIEW_COL_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType tracker_tags_view_col_type_id;
		tracker_tags_view_col_type_id = g_enum_register_static ("TrackerTagsViewCol", values);
		g_once_init_leave (&tracker_tags_view_col_type_id__volatile, tracker_tags_view_col_type_id);
	}
	return tracker_tags_view_col_type_id__volatile;
}


static GType tracker_tags_view_selection_get_type (void) {
	static volatile gsize tracker_tags_view_selection_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_tags_view_selection_type_id__volatile)) {
		static const GEnumValue values[] = {{TRACKER_TAGS_VIEW_SELECTION_INCONSISTENT, "TRACKER_TAGS_VIEW_SELECTION_INCONSISTENT", "inconsistent"}, {TRACKER_TAGS_VIEW_SELECTION_FALSE, "TRACKER_TAGS_VIEW_SELECTION_FALSE", "false"}, {TRACKER_TAGS_VIEW_SELECTION_TRUE, "TRACKER_TAGS_VIEW_SELECTION_TRUE", "true"}, {0, NULL, NULL}};
		GType tracker_tags_view_selection_type_id;
		tracker_tags_view_selection_type_id = g_enum_register_static ("TrackerTagsViewSelection", values);
		g_once_init_leave (&tracker_tags_view_selection_type_id__volatile, tracker_tags_view_selection_type_id);
	}
	return tracker_tags_view_selection_type_id__volatile;
}


TrackerTagsView* tracker_tags_view_construct (GType object_type, GList* _files) {
	TrackerTagsView * self = NULL;
	GList* _tmp4_;
	GCancellable* _tmp7_;
	GtkListStore* _tmp8_;
	GError * _inner_error_ = NULL;
	self = (TrackerTagsView*) g_object_new (object_type, NULL);
	{
		TrackerSparqlConnection* _tmp0_ = NULL;
		TrackerSparqlConnection* _tmp1_;
		_tmp0_ = tracker_sparql_connection_get (NULL, &_inner_error_);
		_tmp1_ = _tmp0_;
		if (_inner_error_ != NULL) {
			goto __catch13_g_error;
		}
		_g_object_unref0 (self->priv->connection);
		self->priv->connection = _tmp1_;
	}
	goto __finally13;
	__catch13_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("tracker-tags-view.vala:94: Could not get Sparql connection: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally13:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp4_ = _files;
	if (_tmp4_ != NULL) {
		GList* _tmp5_;
		GList* _tmp6_ = NULL;
		_tmp5_ = _files;
		_tmp6_ = g_list_copy (_tmp5_);
		__g_list_free__g_free0_0 (self->priv->files);
		self->priv->files = _tmp6_;
	} else {
		__g_list_free__g_free0_0 (self->priv->files);
		self->priv->files = NULL;
	}
	_tmp7_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = _tmp7_;
	_tmp8_ = gtk_list_store_new ((gint) TRACKER_TAGS_VIEW_COL_N_COLUMNS, G_TYPE_INT, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_INT);
	_g_object_unref0 (self->priv->store);
	self->priv->store = _tmp8_;
	tracker_tags_view_create_ui (self);
	return self;
}


TrackerTagsView* tracker_tags_view_new (GList* _files) {
	return tracker_tags_view_construct (TYPE_TRACKER_TAGS_VIEW, _files);
}


void tracker_tags_view_hide_label (TrackerTagsView* self) {
	GtkLabel* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->label;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
}


void tracker_tags_view_set_files (TrackerTagsView* self, GList* _files) {
	GList* _tmp0_;
	GList* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->files;
	if (_tmp0_ != NULL) {
		GList* _tmp1_;
		_tmp1_ = self->priv->files;
		{
			GList* url_collection = NULL;
			GList* url_it = NULL;
			url_collection = _tmp1_;
			for (url_it = url_collection; url_it != NULL; url_it = url_it->next) {
				gchar* _tmp2_;
				gchar* url = NULL;
				_tmp2_ = g_strdup ((const gchar*) url_it->data);
				url = _tmp2_;
				{
					_g_free0 (url);
					url = NULL;
					_g_free0 (url);
				}
			}
		}
		__g_list_free__g_free0_0 (self->priv->files);
		self->priv->files = NULL;
	}
	_tmp3_ = _files;
	if (_tmp3_ != NULL) {
		GList* _tmp4_;
		_tmp4_ = _files;
		{
			GList* url_collection = NULL;
			GList* url_it = NULL;
			url_collection = _tmp4_;
			for (url_it = url_collection; url_it != NULL; url_it = url_it->next) {
				gchar* _tmp5_;
				gchar* url = NULL;
				_tmp5_ = g_strdup ((const gchar*) url_it->data);
				url = _tmp5_;
				{
					const gchar* _tmp6_;
					gchar* _tmp7_;
					_tmp6_ = url;
					_tmp7_ = g_strdup (_tmp6_);
					self->priv->files = g_list_prepend (self->priv->files, _tmp7_);
					_g_free0 (url);
				}
			}
		}
		self->priv->files = g_list_reverse (self->priv->files);
	}
	tracker_tags_view_update_for_files (self);
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->self);
		_g_object_unref0 (_data1_->msg);
		g_slice_free (Block1Data, _data1_);
	}
}


static void __lambda1_ (Block1Data* _data1_) {
	TrackerTagsView * self;
	self = _data1_->self;
	gtk_widget_destroy ((GtkWidget*) _data1_->msg);
}


static void ___lambda1__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	__lambda1_ (self);
}


static void tracker_tags_view_show_error_dialog (TrackerTagsView* self, const gchar* action, GError* e) {
	Block1Data* _data1_;
	const gchar* _tmp0_ = NULL;
	GError* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* str;
	const gchar* _tmp8_;
	GtkMessageDialog* _tmp9_;
	GtkMessageDialog* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp1_ = e;
	_tmp2_ = _tmp1_->message;
	if (_tmp2_ != NULL) {
		GError* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		_tmp0_ = _tmp4_;
	} else {
		const gchar* _tmp5_ = NULL;
		_tmp5_ = _ ("No error was given");
		_tmp0_ = _tmp5_;
	}
	_tmp6_ = _tmp0_;
	_tmp7_ = g_strdup (_tmp6_);
	str = _tmp7_;
	_tmp8_ = action;
	_tmp9_ = (GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, "%s", _tmp8_);
	_tmp10_ = g_object_ref_sink (_tmp9_);
	_data1_->msg = _tmp10_;
	gtk_message_dialog_format_secondary_text (_data1_->msg, "%s", str);
	g_signal_connect_data ((GtkDialog*) _data1_->msg, "response", (GCallback) ___lambda1__gtk_dialog_response, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	gtk_dialog_run ((GtkDialog*) _data1_->msg);
	_g_free0 (str);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}


void tracker_tags_view_button_remove_clicked_cb (GtkButton* source, TrackerTagsView* self) {
	GtkTreeIter iter = {0};
	GtkTreeModel* model = NULL;
	GtkTreeView* _tmp0_;
	GtkTreeSelection* _tmp1_ = NULL;
	GtkTreeSelection* _tmp2_;
	GtkTreeSelection* selection;
	GtkTreeSelection* _tmp3_;
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeIter _tmp5_ = {0};
	gboolean _tmp6_ = FALSE;
	GtkTreeModel* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	g_debug ("tracker-tags-view.vala:181: Remove clicked");
	_tmp0_ = self->priv->view;
	_tmp1_ = gtk_tree_view_get_selection (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	selection = _tmp2_;
	_tmp3_ = selection;
	_tmp6_ = gtk_tree_selection_get_selected (_tmp3_, &_tmp4_, &_tmp5_);
	_g_object_unref0 (model);
	_tmp7_ = _g_object_ref0 (_tmp4_);
	model = _tmp7_;
	iter = _tmp5_;
	if (_tmp6_) {
		gchar* id = NULL;
		GtkTreeModel* _tmp8_;
		GtkTreeIter _tmp9_;
		const gchar* _tmp10_;
		GtkTreeIter _tmp11_;
		TagData* _tmp12_;
		TagData* td;
		TagData* _tmp13_;
		TagData* _tmp14_;
		TagData* _tmp15_;
		_tmp8_ = model;
		_tmp9_ = iter;
		gtk_tree_model_get (_tmp8_, &_tmp9_, TRACKER_TAGS_VIEW_COL_TAG_ID, &id, -1, -1);
		_tmp10_ = id;
		_tmp11_ = iter;
		_tmp12_ = tag_data_new (_tmp10_, &_tmp11_, FALSE, TRUE, 1, self);
		td = _tmp12_;
		_tmp13_ = td;
		_tmp14_ = _tag_data_ref0 (_tmp13_);
		self->priv->tag_data_requests = g_list_prepend (self->priv->tag_data_requests, _tmp14_);
		_tmp15_ = td;
		tracker_tags_view_remove_tag (self, _tmp15_, NULL, NULL);
		_tag_data_unref0 (td);
		_g_free0 (id);
	}
	_g_object_unref0 (selection);
	_g_object_unref0 (model);
}


void tracker_tags_view_button_add_clicked_cb (GtkButton* source, TrackerTagsView* self) {
	GtkEntry* _tmp0_;
	const gchar* _tmp1_ = NULL;
	const gchar* tag;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	g_debug ("tracker-tags-view.vala:202: Add clicked");
	_tmp0_ = self->priv->entry;
	_tmp1_ = gtk_entry_get_text (_tmp0_);
	tag = _tmp1_;
	tracker_tags_view_add_tag (self, tag, NULL, NULL);
}


void tracker_tags_view_entry_tag_activated_cb (GtkEntry* source, TrackerTagsView* self) {
	GtkButton* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	g_debug ("tracker-tags-view.vala:209: Entry activated");
	_tmp0_ = self->priv->button_add;
	gtk_widget_activate (GTK_WIDGET (_tmp0_));
}


void tracker_tags_view_entry_tag_changed_cb (GtkEditable* source, TrackerTagsView* self) {
	GtkEntry* _tmp0_;
	const gchar* _tmp1_ = NULL;
	const gchar* tag;
	GtkTreeIter iter = {0};
	const gchar* _tmp2_;
	GtkTreeIter _tmp3_ = {0};
	gboolean _tmp4_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	g_debug ("tracker-tags-view.vala:215: Entry changed");
	_tmp0_ = self->priv->entry;
	_tmp1_ = gtk_entry_get_text (_tmp0_);
	tag = _tmp1_;
	_tmp2_ = tag;
	_tmp4_ = tracker_tags_view_find_tag (self, _tmp2_, &_tmp3_);
	iter = _tmp3_;
	if (_tmp4_) {
		GtkButton* _tmp5_;
		_tmp5_ = self->priv->button_add;
		gtk_widget_set_sensitive (GTK_WIDGET (_tmp5_), FALSE);
	} else {
		gboolean _tmp6_ = FALSE;
		const gchar* _tmp7_;
		GtkButton* _tmp9_;
		gboolean _tmp10_;
		_tmp7_ = tag;
		if (_tmp7_ != NULL) {
			const gchar* _tmp8_;
			_tmp8_ = tag;
			_tmp6_ = g_strcmp0 (_tmp8_, "") != 0;
		} else {
			_tmp6_ = FALSE;
		}
		_tmp9_ = self->priv->button_add;
		_tmp10_ = _tmp6_;
		gtk_widget_set_sensitive (GTK_WIDGET (_tmp9_), _tmp10_);
	}
}


void tracker_tags_view_treeview_tags_cell_toggled_cb (GtkCellRendererToggle* source, const gchar* path_string, TrackerTagsView* self) {
	const gchar* _tmp0_;
	GtkTreePath* _tmp1_;
	GtkTreePath* path;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	g_return_if_fail (path_string != NULL);
	g_debug ("tracker-tags-view.vala:229: Treeview row cell toggled");
	_tmp0_ = path_string;
	_tmp1_ = gtk_tree_path_new_from_string (_tmp0_);
	path = _tmp1_;
	tracker_tags_view_model_toggle_row (self, path, NULL, NULL);
	_gtk_tree_path_free0 (path);
}


void tracker_tags_view_treeview_tags_row_selected_cb (GtkTreeSelection* selection, TrackerTagsView* self) {
	GtkTreeIter iter = {0};
	GtkTreeModel* model = NULL;
	GtkTreeSelection* _tmp0_;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeIter _tmp2_ = {0};
	gboolean _tmp3_ = FALSE;
	GtkTreeModel* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (selection != NULL);
	g_debug ("tracker-tags-view.vala:236: Treeview row selected");
	_tmp0_ = selection;
	_tmp3_ = gtk_tree_selection_get_selected (_tmp0_, &_tmp1_, &_tmp2_);
	_g_object_unref0 (model);
	_tmp4_ = _g_object_ref0 (_tmp1_);
	model = _tmp4_;
	iter = _tmp2_;
	if (_tmp3_) {
		GtkButton* _tmp5_;
		_tmp5_ = self->priv->button_remove;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp5_, TRUE);
	} else {
		GtkButton* _tmp6_;
		_tmp6_ = self->priv->button_remove;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp6_, FALSE);
	}
	_g_object_unref0 (model);
}


void tracker_tags_view_treeview_tags_row_activated_cb (GtkTreeView* source, GtkTreePath* path, GtkTreeViewColumn* column, TrackerTagsView* self) {
	GtkTreePath* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (column != NULL);
	g_debug ("tracker-tags-view.vala:250: Treeview row activated");
	_tmp0_ = path;
	tracker_tags_view_model_toggle_row (self, _tmp0_, NULL, NULL);
}


static void tracker_tags_view_treeview_tags_toggle_cell_data_func (GtkCellLayout* layout, GtkCellRenderer* cell, GtkTreeModel* model, GtkTreeIter* iter, TrackerTagsView* self) {
	gint selection = 0;
	GtkTreeModel* _tmp0_;
	GtkTreeIter _tmp1_;
	GtkCellRenderer* _tmp2_;
	GtkCellRenderer* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (layout != NULL);
	g_return_if_fail (cell != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = model;
	_tmp1_ = *iter;
	gtk_tree_model_get (_tmp0_, &_tmp1_, TRACKER_TAGS_VIEW_COL_SELECTION, &selection, -1, -1);
	_tmp2_ = cell;
	gtk_cell_renderer_toggle_set_active (GTK_CELL_RENDERER_TOGGLE (_tmp2_), selection == ((gint) TRACKER_TAGS_VIEW_SELECTION_TRUE));
	_tmp3_ = cell;
	g_object_set (GTK_CELL_RENDERER_TOGGLE (_tmp3_), "inconsistent", selection == ((gint) TRACKER_TAGS_VIEW_SELECTION_INCONSISTENT), NULL);
}


static void _tracker_tags_view_entry_tag_changed_cb_gtk_editable_changed (GtkEditable* _sender, gpointer self) {
	tracker_tags_view_entry_tag_changed_cb (_sender, self);
}


static void _tracker_tags_view_button_add_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	tracker_tags_view_button_add_clicked_cb (_sender, self);
}


static void _tracker_tags_view_button_remove_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	tracker_tags_view_button_remove_clicked_cb (_sender, self);
}


static void _tracker_tags_view_treeview_tags_cell_toggled_cb_gtk_cell_renderer_toggle_toggled (GtkCellRendererToggle* _sender, const gchar* path, gpointer self) {
	tracker_tags_view_treeview_tags_cell_toggled_cb (_sender, path, self);
}


static void _tracker_tags_view_treeview_tags_toggle_cell_data_func_gtk_cell_layout_data_func (GtkCellLayout* cell_layout, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter, gpointer self) {
	tracker_tags_view_treeview_tags_toggle_cell_data_func (cell_layout, cell, tree_model, iter, self);
}


static void _tracker_tags_view_treeview_tags_row_selected_cb_gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self) {
	tracker_tags_view_treeview_tags_row_selected_cb (_sender, self);
}


static void _tracker_tags_view_treeview_tags_row_activated_cb_gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self) {
	tracker_tags_view_treeview_tags_row_activated_cb (_sender, path, column, self);
}


static void tracker_tags_view_create_ui (TrackerTagsView* self) {
	GtkBuilder* _tmp0_;
	GtkBuilder* builder;
	GObject* _tmp6_ = NULL;
	GtkVBox* _tmp7_;
	GObject* _tmp8_ = NULL;
	GtkLabel* _tmp9_;
	GObject* _tmp10_ = NULL;
	GtkEntry* _tmp11_;
	GObject* _tmp12_ = NULL;
	GtkButton* _tmp13_;
	GObject* _tmp14_ = NULL;
	GtkButton* _tmp15_;
	GObject* _tmp16_ = NULL;
	GtkScrolledWindow* _tmp17_;
	GObject* _tmp18_ = NULL;
	GtkTreeView* _tmp19_;
	GtkEntry* _tmp20_;
	GtkButton* _tmp21_;
	GtkButton* _tmp22_;
	GtkTreeViewColumn* col = NULL;
	GtkCellRenderer* renderer = NULL;
	GtkCellRendererToggle* _tmp23_;
	GtkCellRenderer* _tmp24_;
	GtkCellRenderer* _tmp25_;
	GtkCellRenderer* _tmp26_;
	GtkCellRenderer* _tmp27_;
	GtkCellRenderer* _tmp28_;
	GtkTreeViewColumn* _tmp29_;
	GtkTreeViewColumn* _tmp30_;
	GtkTreeViewColumn* _tmp31_;
	GtkTreeViewColumn* _tmp32_;
	GtkTreeViewColumn* _tmp33_;
	GtkTreeViewColumn* _tmp34_;
	GtkTreeViewColumn* _tmp35_;
	GtkCellRenderer* _tmp36_;
	GtkTreeViewColumn* _tmp37_;
	GtkCellRenderer* _tmp38_;
	GtkTreeView* _tmp39_;
	GtkTreeViewColumn* _tmp40_;
	GtkCellRendererText* _tmp41_;
	GtkCellRenderer* _tmp42_;
	GtkCellRenderer* _tmp43_;
	GtkCellRenderer* _tmp44_;
	GtkCellRenderer* _tmp45_;
	GtkCellRenderer* _tmp46_;
	GtkTreeViewColumn* _tmp47_;
	GtkTreeViewColumn* _tmp48_;
	GtkTreeViewColumn* _tmp49_;
	const gchar* _tmp50_ = NULL;
	GtkTreeViewColumn* _tmp51_;
	GtkTreeViewColumn* _tmp52_;
	GtkTreeViewColumn* _tmp53_;
	GtkTreeViewColumn* _tmp54_;
	GtkCellRenderer* _tmp55_;
	GtkTreeViewColumn* _tmp56_;
	GtkCellRenderer* _tmp57_;
	GtkTreeView* _tmp58_;
	GtkTreeViewColumn* _tmp59_;
	GtkCellRendererText* _tmp60_;
	GtkCellRenderer* _tmp61_;
	GtkCellRenderer* _tmp62_;
	GtkCellRenderer* _tmp63_;
	GtkTreeViewColumn* _tmp64_;
	GtkTreeViewColumn* _tmp65_;
	GtkTreeViewColumn* _tmp66_;
	GtkTreeViewColumn* _tmp67_;
	GtkTreeViewColumn* _tmp68_;
	GtkTreeViewColumn* _tmp69_;
	GtkTreeViewColumn* _tmp70_;
	GtkCellRenderer* _tmp71_;
	GtkTreeViewColumn* _tmp72_;
	GtkCellRenderer* _tmp73_;
	GtkTreeView* _tmp74_;
	GtkTreeViewColumn* _tmp75_;
	GtkTreeView* _tmp76_;
	GtkTreeSelection* _tmp77_ = NULL;
	GtkTreeSelection* _tmp78_;
	GtkTreeSelection* selection;
	GtkListStore* _tmp79_;
	GtkTreeModel* _tmp80_;
	GtkTreeModel* model;
	GtkTreeSortable* _tmp81_;
	GtkTreeSortable* sortable;
	GtkTreeView* _tmp82_;
	GtkTreeView* _tmp83_;
	GtkVBox* _tmp84_;
	GtkVBox* _tmp85_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_builder_new ();
	builder = _tmp0_;
	{
		g_debug ("tracker-tags-view.vala:267: Trying to use UI file:'%s'", SRCDIR TRACKER_TAGS_VIEW_UI_FILE);
		gtk_builder_add_from_file (builder, SRCDIR TRACKER_TAGS_VIEW_UI_FILE, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch14_g_error;
		}
	}
	goto __finally14;
	__catch14_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_debug ("tracker-tags-view.vala:272: Trying to use UI file:'%s'", TRACKER_UI_DIR TRACKER_TAGS_VIEW_UI_FILE);
			gtk_builder_add_from_file (builder, TRACKER_UI_DIR TRACKER_TAGS_VIEW_UI_FILE, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch15_g_error;
			}
		}
		goto __finally15;
		__catch15_g_error:
		{
			GError* e = NULL;
			GError* _tmp1_;
			const gchar* _tmp2_;
			GtkMessageDialog* _tmp3_;
			GtkMessageDialog* _tmp4_;
			GtkMessageDialog* msg;
			GtkMessageDialog* _tmp5_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp1_ = e;
			_tmp2_ = _tmp1_->message;
			_tmp3_ = (GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_CANCEL, "Failed to load UI file, %s\n", _tmp2_);
			_tmp4_ = g_object_ref_sink (_tmp3_);
			msg = _tmp4_;
			_tmp5_ = msg;
			gtk_dialog_run ((GtkDialog*) _tmp5_);
			gtk_main_quit ();
			_g_object_unref0 (msg);
			_g_error_free0 (e);
		}
		__finally15:
		if (_inner_error_ != NULL) {
			_g_error_free0 (e);
			_g_error_free0 (e);
			_g_object_unref0 (builder);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_error_free0 (e);
	}
	__finally14:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp6_ = gtk_builder_get_object (builder, "vbox_tags");
	_tmp7_ = _g_object_ref0 (GTK_IS_VBOX (_tmp6_) ? ((GtkVBox*) _tmp6_) : NULL);
	_g_object_unref0 (self->priv->vbox);
	self->priv->vbox = _tmp7_;
	_tmp8_ = gtk_builder_get_object (builder, "label_tag");
	_tmp9_ = _g_object_ref0 (GTK_IS_LABEL (_tmp8_) ? ((GtkLabel*) _tmp8_) : NULL);
	_g_object_unref0 (self->priv->label);
	self->priv->label = _tmp9_;
	_tmp10_ = gtk_builder_get_object (builder, "entry_tag");
	_tmp11_ = _g_object_ref0 (GTK_IS_ENTRY (_tmp10_) ? ((GtkEntry*) _tmp10_) : NULL);
	_g_object_unref0 (self->priv->entry);
	self->priv->entry = _tmp11_;
	_tmp12_ = gtk_builder_get_object (builder, "button_add");
	_tmp13_ = _g_object_ref0 (GTK_IS_BUTTON (_tmp12_) ? ((GtkButton*) _tmp12_) : NULL);
	_g_object_unref0 (self->priv->button_add);
	self->priv->button_add = _tmp13_;
	_tmp14_ = gtk_builder_get_object (builder, "button_remove");
	_tmp15_ = _g_object_ref0 (GTK_IS_BUTTON (_tmp14_) ? ((GtkButton*) _tmp14_) : NULL);
	_g_object_unref0 (self->priv->button_remove);
	self->priv->button_remove = _tmp15_;
	_tmp16_ = gtk_builder_get_object (builder, "scrolled_window_tags");
	_tmp17_ = _g_object_ref0 (GTK_IS_SCROLLED_WINDOW (_tmp16_) ? ((GtkScrolledWindow*) _tmp16_) : NULL);
	_g_object_unref0 (self->priv->scrolled_window);
	self->priv->scrolled_window = _tmp17_;
	_tmp18_ = gtk_builder_get_object (builder, "treeview_tags");
	_tmp19_ = _g_object_ref0 (GTK_IS_TREE_VIEW (_tmp18_) ? ((GtkTreeView*) _tmp18_) : NULL);
	_g_object_unref0 (self->priv->view);
	self->priv->view = _tmp19_;
	_tmp20_ = self->priv->entry;
	g_signal_connect_object (GTK_EDITABLE (_tmp20_), "changed", (GCallback) _tracker_tags_view_entry_tag_changed_cb_gtk_editable_changed, self, 0);
	_tmp21_ = self->priv->button_add;
	g_signal_connect_object (_tmp21_, "clicked", (GCallback) _tracker_tags_view_button_add_clicked_cb_gtk_button_clicked, self, 0);
	_tmp22_ = self->priv->button_remove;
	g_signal_connect_object (_tmp22_, "clicked", (GCallback) _tracker_tags_view_button_remove_clicked_cb_gtk_button_clicked, self, 0);
	_tmp23_ = (GtkCellRendererToggle*) gtk_cell_renderer_toggle_new ();
	_tmp24_ = (GtkCellRenderer*) g_object_ref_sink (_tmp23_);
	_g_object_unref0 (renderer);
	renderer = _tmp24_;
	_tmp25_ = renderer;
	g_object_set (_tmp25_, "xpad", (guint) 5, NULL);
	_tmp26_ = renderer;
	g_object_set (_tmp26_, "ypad", (guint) 5, NULL);
	_tmp27_ = renderer;
	g_signal_connect_object (GTK_CELL_RENDERER_TOGGLE (_tmp27_), "toggled", (GCallback) _tracker_tags_view_treeview_tags_cell_toggled_cb_gtk_cell_renderer_toggle_toggled, self, 0);
	_tmp28_ = renderer;
	gtk_cell_renderer_toggle_set_radio (GTK_CELL_RENDERER_TOGGLE (_tmp28_), FALSE);
	_tmp29_ = gtk_tree_view_column_new ();
	_tmp30_ = g_object_ref_sink (_tmp29_);
	_g_object_unref0 (col);
	col = _tmp30_;
	_tmp31_ = col;
	gtk_tree_view_column_set_title (_tmp31_, "-");
	_tmp32_ = col;
	gtk_tree_view_column_set_resizable (_tmp32_, FALSE);
	_tmp33_ = col;
	gtk_tree_view_column_set_sizing (_tmp33_, GTK_TREE_VIEW_COLUMN_FIXED);
	_tmp34_ = col;
	gtk_tree_view_column_set_fixed_width (_tmp34_, 25);
	_tmp35_ = col;
	_tmp36_ = renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp35_, _tmp36_, FALSE);
	_tmp37_ = col;
	_tmp38_ = renderer;
	gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) _tmp37_, _tmp38_, _tracker_tags_view_treeview_tags_toggle_cell_data_func_gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
	_tmp39_ = self->priv->view;
	_tmp40_ = col;
	gtk_tree_view_append_column (_tmp39_, _tmp40_);
	_tmp41_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_tmp42_ = (GtkCellRenderer*) g_object_ref_sink (_tmp41_);
	_g_object_unref0 (renderer);
	renderer = _tmp42_;
	_tmp43_ = renderer;
	g_object_set (_tmp43_, "xpad", (guint) 5, NULL);
	_tmp44_ = renderer;
	g_object_set (_tmp44_, "ypad", (guint) 5, NULL);
	_tmp45_ = renderer;
	g_object_set (GTK_CELL_RENDERER_TEXT (_tmp45_), "ellipsize", PANGO_ELLIPSIZE_END, NULL);
	_tmp46_ = renderer;
	g_object_set (GTK_CELL_RENDERER_TEXT (_tmp46_), "ellipsize-set", TRUE, NULL);
	_tmp47_ = gtk_tree_view_column_new ();
	_tmp48_ = g_object_ref_sink (_tmp47_);
	_g_object_unref0 (col);
	col = _tmp48_;
	_tmp49_ = col;
	_tmp50_ = _ ("Name");
	gtk_tree_view_column_set_title (_tmp49_, _tmp50_);
	_tmp51_ = col;
	gtk_tree_view_column_set_resizable (_tmp51_, TRUE);
	_tmp52_ = col;
	gtk_tree_view_column_set_sizing (_tmp52_, GTK_TREE_VIEW_COLUMN_AUTOSIZE);
	_tmp53_ = col;
	gtk_tree_view_column_set_expand (_tmp53_, TRUE);
	_tmp54_ = col;
	_tmp55_ = renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp54_, _tmp55_, TRUE);
	_tmp56_ = col;
	_tmp57_ = renderer;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp56_, _tmp57_, "text", (gint) TRACKER_TAGS_VIEW_COL_TAG_NAME);
	_tmp58_ = self->priv->view;
	_tmp59_ = col;
	gtk_tree_view_append_column (_tmp58_, _tmp59_);
	_tmp60_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_tmp61_ = (GtkCellRenderer*) g_object_ref_sink (_tmp60_);
	_g_object_unref0 (renderer);
	renderer = _tmp61_;
	_tmp62_ = renderer;
	g_object_set (_tmp62_, "xpad", (guint) 5, NULL);
	_tmp63_ = renderer;
	g_object_set (_tmp63_, "ypad", (guint) 5, NULL);
	_tmp64_ = gtk_tree_view_column_new ();
	_tmp65_ = g_object_ref_sink (_tmp64_);
	_g_object_unref0 (col);
	col = _tmp65_;
	_tmp66_ = col;
	gtk_tree_view_column_set_title (_tmp66_, "-");
	_tmp67_ = col;
	gtk_tree_view_column_set_resizable (_tmp67_, FALSE);
	_tmp68_ = col;
	gtk_tree_view_column_set_sizing (_tmp68_, GTK_TREE_VIEW_COLUMN_FIXED);
	_tmp69_ = col;
	gtk_tree_view_column_set_fixed_width (_tmp69_, 50);
	_tmp70_ = col;
	_tmp71_ = renderer;
	gtk_cell_layout_pack_end ((GtkCellLayout*) _tmp70_, _tmp71_, FALSE);
	_tmp72_ = col;
	_tmp73_ = renderer;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp72_, _tmp73_, "text", (gint) TRACKER_TAGS_VIEW_COL_TAG_COUNT);
	_tmp74_ = self->priv->view;
	_tmp75_ = col;
	gtk_tree_view_append_column (_tmp74_, _tmp75_);
	_tmp76_ = self->priv->view;
	_tmp77_ = gtk_tree_view_get_selection (_tmp76_);
	_tmp78_ = _g_object_ref0 (_tmp77_);
	selection = _tmp78_;
	g_signal_connect_object (selection, "changed", (GCallback) _tracker_tags_view_treeview_tags_row_selected_cb_gtk_tree_selection_changed, self, 0);
	_tmp79_ = self->priv->store;
	_tmp80_ = _g_object_ref0 (GTK_IS_TREE_MODEL (_tmp79_) ? ((GtkTreeModel*) _tmp79_) : NULL);
	model = _tmp80_;
	_tmp81_ = _g_object_ref0 (GTK_IS_TREE_SORTABLE (model) ? ((GtkTreeSortable*) model) : NULL);
	sortable = _tmp81_;
	_tmp82_ = self->priv->view;
	gtk_tree_view_set_model (_tmp82_, model);
	_tmp83_ = self->priv->view;
	g_signal_connect_object (_tmp83_, "row-activated", (GCallback) _tracker_tags_view_treeview_tags_row_activated_cb_gtk_tree_view_row_activated, self, 0);
	gtk_tree_sortable_set_sort_column_id (sortable, 2, GTK_SORT_ASCENDING);
	_tmp84_ = self->priv->vbox;
	gtk_widget_unparent ((GtkWidget*) _tmp84_);
	_tmp85_ = self->priv->vbox;
	gtk_box_pack_start ((GtkBox*) GTK_VBOX (self), (GtkWidget*) _tmp85_, TRUE, TRUE, (guint) 0);
	tracker_tags_view_update_for_files (self);
	tracker_tags_view_query_tags (self, NULL, NULL);
	_g_object_unref0 (sortable);
	_g_object_unref0 (model);
	_g_object_unref0 (selection);
	_g_object_unref0 (renderer);
	_g_object_unref0 (col);
	_g_object_unref0 (builder);
}


static void tracker_tags_view_update_for_files (TrackerTagsView* self) {
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->files;
	if (_tmp0_ != NULL) {
		GList* _tmp1_;
		guint _tmp2_ = 0U;
		const gchar* _tmp3_ = NULL;
		GList* _tmp4_;
		guint _tmp5_ = 0U;
		gchar* _tmp6_ = NULL;
		gchar* str;
		GtkLabel* _tmp7_;
		const gchar* _tmp8_;
		GtkVBox* _tmp9_;
		_tmp1_ = self->priv->files;
		_tmp2_ = g_list_length (_tmp1_);
		_tmp3_ = g_dngettext (NULL, "_Set the tags you want to associate with the %d selected item:", "_Set the tags you want to associate with the %d selected items:", (gulong) _tmp2_);
		_tmp4_ = self->priv->files;
		_tmp5_ = g_list_length (_tmp4_);
		_tmp6_ = g_strdup_printf (_tmp3_, _tmp5_);
		str = _tmp6_;
		_tmp7_ = self->priv->label;
		_tmp8_ = str;
		gtk_label_set_text_with_mnemonic (_tmp7_, _tmp8_);
		_tmp9_ = self->priv->vbox;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp9_, TRUE);
		_g_free0 (str);
	} else {
		GtkLabel* _tmp10_;
		const gchar* _tmp11_ = NULL;
		GtkVBox* _tmp12_;
		_tmp10_ = self->priv->label;
		_tmp11_ = _ ("No items currently selected");
		gtk_label_set_text (_tmp10_, _tmp11_);
		_tmp12_ = self->priv->vbox;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp12_, FALSE);
	}
	tracker_tags_view_query_tags_for_files (self, NULL, NULL);
}


static void tracker_tags_view_model_toggle_row_data_free (gpointer _data) {
	TrackerTagsViewModelToggleRowData* _data_;
	_data_ = _data;
	_gtk_tree_path_free0 (_data_->path);
	_g_object_unref0 (_data_->self);
	g_slice_free (TrackerTagsViewModelToggleRowData, _data_);
}


static gpointer _gtk_tree_path_copy0 (gpointer self) {
	return self ? gtk_tree_path_copy (self) : NULL;
}


static void tracker_tags_view_model_toggle_row (TrackerTagsView* self, GtkTreePath* path, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerTagsViewModelToggleRowData* _data_;
	TrackerTagsView* _tmp0_;
	GtkTreePath* _tmp1_;
	GtkTreePath* _tmp2_;
	_data_ = g_slice_new0 (TrackerTagsViewModelToggleRowData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_tags_view_model_toggle_row);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_tags_view_model_toggle_row_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = path;
	_tmp2_ = _gtk_tree_path_copy0 (_tmp1_);
	_data_->path = _tmp2_;
	tracker_tags_view_model_toggle_row_co (_data_);
}


static void tracker_tags_view_model_toggle_row_finish (TrackerTagsView* self, GAsyncResult* _res_) {
	TrackerTagsViewModelToggleRowData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void tracker_tags_view_model_toggle_row_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerTagsViewModelToggleRowData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tracker_tags_view_model_toggle_row_co (_data_);
}


static gboolean tracker_tags_view_model_toggle_row_co (TrackerTagsViewModelToggleRowData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->view;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = gtk_tree_view_get_model (_data_->_tmp0_);
	_data_->_tmp2_ = _g_object_ref0 (_data_->_tmp1_);
	_g_object_unref0 (_data_->model);
	_data_->model = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->model;
	_data_->_tmp4_ = _data_->path;
	memset (&_data_->_tmp5_, 0, sizeof (GtkTreeIter));
	_data_->_tmp6_ = FALSE;
	_data_->_tmp6_ = gtk_tree_model_get_iter (_data_->_tmp3_, &_data_->_tmp5_, _data_->_tmp4_);
	_data_->iter = _data_->_tmp5_;
	if (_data_->_tmp6_ == FALSE) {
		_g_free0 (_data_->tag);
		_g_free0 (_data_->id);
		_g_object_unref0 (_data_->model);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp7_ = _data_->model;
	_data_->_tmp8_ = _data_->iter;
	gtk_tree_model_get (_data_->_tmp7_, &_data_->_tmp8_, TRACKER_TAGS_VIEW_COL_SELECTION, &_data_->selection, TRACKER_TAGS_VIEW_COL_TAG_ID, &_data_->id, TRACKER_TAGS_VIEW_COL_TAG_NAME, &_data_->tag, -1, -1);
	_data_->_tmp10_ = _data_->selection;
	if (_data_->_tmp10_ == ((gint) TRACKER_TAGS_VIEW_SELECTION_FALSE)) {
		_data_->_tmp9_ = TRACKER_TAGS_VIEW_SELECTION_TRUE;
	} else {
		_data_->_tmp9_ = TRACKER_TAGS_VIEW_SELECTION_FALSE;
	}
	_data_->_tmp11_ = _data_->_tmp9_;
	_data_->new_value = (gint) _data_->_tmp11_;
	_data_->_tmp12_ = _data_->tag;
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = tracker_tags_view_sparql_get_escaped_string (_data_->self, _data_->_tmp12_);
	_data_->tag_escaped = _data_->_tmp13_;
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = tracker_tags_view_sparql_get_filter_string (_data_->self, NULL);
	_data_->filter = _data_->_tmp14_;
	_data_->query = NULL;
	_data_->_tmp15_ = _data_->new_value;
	if (_data_->_tmp15_ != ((gint) TRACKER_TAGS_VIEW_SELECTION_FALSE)) {
		_data_->_tmp16_ = _data_->tag_escaped;
		_data_->_tmp17_ = _data_->filter;
		_data_->_tmp18_ = NULL;
		_data_->_tmp18_ = g_strdup_printf ("INSERT {\n" \
"			           ?urn nao:hasTag ?label\n" \
"			         } WHERE {\n" \
"			           ?urn nie:url ?f .\n" \
"			           ?label nao:prefLabel %s .\n" \
"			           %s\n" \
"			         }", _data_->_tmp16_, _data_->_tmp17_);
		_g_free0 (_data_->query);
		_data_->query = _data_->_tmp18_;
	} else {
		_data_->_tmp19_ = _data_->tag_escaped;
		_data_->_tmp20_ = _data_->filter;
		_data_->_tmp21_ = NULL;
		_data_->_tmp21_ = g_strdup_printf ("DELETE {\n" \
"			           ?urn nao:hasTag ?label\n" \
"			         } WHERE {\n" \
"			           ?urn nie:url ?f .\n" \
"			           ?label nao:prefLabel %s .\n" \
"			           %s\n" \
"			         }", _data_->_tmp19_, _data_->_tmp20_);
		_g_free0 (_data_->query);
		_data_->query = _data_->_tmp21_;
		_data_->_tmp22_ = _data_->id;
		_data_->_tmp23_ = _data_->iter;
		_data_->_tmp24_ = tag_data_new (_data_->_tmp22_, &_data_->_tmp23_, FALSE, TRUE, 1, _data_->self);
		_tag_data_unref0 (_data_->td);
		_data_->td = _data_->_tmp24_;
		_data_->_tmp25_ = _data_->td;
		_data_->_tmp26_ = _tag_data_ref0 (_data_->_tmp25_);
		_data_->self->priv->tag_data_requests = g_list_prepend (_data_->self->priv->tag_data_requests, _data_->_tmp26_);
		_data_->_tmp27_ = _data_->td;
		tracker_tags_view_query_files_for_tag_id (_data_->self, _data_->_tmp27_, NULL, NULL);
	}
	_g_free0 (_data_->filter);
	_data_->filter = NULL;
	_g_free0 (_data_->tag_escaped);
	_data_->tag_escaped = NULL;
	_data_->_tmp28_ = _data_->self->priv->connection;
	if (_data_->_tmp28_ == NULL) {
		g_warning ("tracker-tags-view.vala:450: Can't update tags, no SPARQL connection av" \
"ailable");
		_tag_data_unref0 (_data_->td);
		_g_free0 (_data_->query);
		_g_free0 (_data_->filter);
		_g_free0 (_data_->tag_escaped);
		_g_free0 (_data_->tag);
		_g_free0 (_data_->id);
		_g_object_unref0 (_data_->model);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_debug ("tracker-tags-view.vala:454: Updating tags for uris");
	_data_->_tmp29_ = _data_->self->priv->entry;
	gtk_widget_set_sensitive ((GtkWidget*) _data_->_tmp29_, FALSE);
	_data_->_tmp30_ = _data_->id;
	_data_->_tmp31_ = _data_->iter;
	_data_->_tmp32_ = _data_->new_value;
	_data_->_tmp33_ = tag_data_new (_data_->_tmp30_, &_data_->_tmp31_, TRUE, _data_->_tmp32_ != ((gint) TRACKER_TAGS_VIEW_SELECTION_FALSE), 1, _data_->self);
	_tag_data_unref0 (_data_->td);
	_data_->td = _data_->_tmp33_;
	_data_->_tmp34_ = _data_->td;
	_data_->_tmp35_ = _tag_data_ref0 (_data_->_tmp34_);
	_data_->self->priv->tag_data_requests = g_list_prepend (_data_->self->priv->tag_data_requests, _data_->_tmp35_);
	{
		_data_->_tmp36_ = _data_->self->priv->connection;
		_data_->_tmp37_ = _data_->query;
		_data_->_tmp38_ = _data_->td;
		_data_->_tmp39_ = _data_->_tmp38_->cancellable;
		_data_->_state_ = 1;
		tracker_sparql_connection_update_async (_data_->_tmp36_, _data_->_tmp37_, G_PRIORITY_DEFAULT, _data_->_tmp39_, tracker_tags_view_model_toggle_row_ready, _data_);
		return FALSE;
		_state_1:
		tracker_sparql_connection_update_finish (_data_->_tmp36_, _data_->_res_, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			goto __catch16_g_error;
		}
		g_debug ("tracker-tags-view.vala:464: Updated tags");
		_data_->_tmp40_ = _data_->td;
		tracker_tags_view_update_tag_data (_data_->self, _data_->_tmp40_);
		_data_->_tmp41_ = _data_->self->priv->entry;
		gtk_entry_set_text (_data_->_tmp41_, "");
	}
	goto __finally16;
	__catch16_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp42_ = _data_->e;
		_data_->_tmp43_ = _data_->_tmp42_->message;
		g_warning ("tracker-tags-view.vala:469: Could not run Sparql update query: %s", _data_->_tmp43_);
		_data_->_tmp44_ = NULL;
		_data_->_tmp44_ = _ ("Could not update tags");
		_data_->_tmp45_ = _data_->e;
		tracker_tags_view_show_error_dialog (_data_->self, _data_->_tmp44_, _data_->_tmp45_);
		_g_error_free0 (_data_->e);
	}
	__finally16:
	if (_data_->_inner_error_ != NULL) {
		_tag_data_unref0 (_data_->td);
		_g_free0 (_data_->query);
		_g_free0 (_data_->filter);
		_g_free0 (_data_->tag_escaped);
		_g_free0 (_data_->tag);
		_g_free0 (_data_->id);
		_g_object_unref0 (_data_->model);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->_tmp46_ = _data_->td;
	_data_->self->priv->tag_data_requests = g_list_remove (_data_->self->priv->tag_data_requests, _data_->_tmp46_);
	_tag_data_unref0 (_data_->td);
	_data_->td = NULL;
	_data_->_tmp47_ = _data_->self->priv->entry;
	gtk_widget_set_sensitive ((GtkWidget*) _data_->_tmp47_, TRUE);
	_tag_data_unref0 (_data_->td);
	_g_free0 (_data_->query);
	_g_free0 (_data_->filter);
	_g_free0 (_data_->tag_escaped);
	_g_free0 (_data_->tag);
	_g_free0 (_data_->id);
	_g_object_unref0 (_data_->model);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_g_object_unref0 (_data2_->self);
		_g_free0 (_data2_->tag);
		g_slice_free (Block2Data, _data2_);
	}
}


static gboolean __lambda0_ (Block2Data* _data2_, GtkTreeModel* model, GtkTreePath* path, GtkTreeIter* foreach_iter) {
	TrackerTagsView * self;
	gboolean result = FALSE;
	gchar* foreach_tag = NULL;
	GtkTreeModel* _tmp0_;
	GtkTreeIter _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gboolean _tmp6_;
	self = _data2_->self;
	g_return_val_if_fail (model != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	g_return_val_if_fail (foreach_iter != NULL, FALSE);
	_tmp0_ = model;
	_tmp1_ = *foreach_iter;
	gtk_tree_model_get (_tmp0_, &_tmp1_, TRACKER_TAGS_VIEW_COL_TAG_NAME, &foreach_tag, -1, -1);
	_tmp3_ = foreach_tag;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = foreach_tag;
		_tmp5_ = _data2_->tag;
		_tmp2_ = g_strcmp0 (_tmp4_, _tmp5_) == 0;
	} else {
		_tmp2_ = FALSE;
	}
	_tmp6_ = _tmp2_;
	if (_tmp6_) {
		GtkTreeIter _tmp7_;
		_data2_->found = TRUE;
		_tmp7_ = *foreach_iter;
		_data2_->found_iter = _tmp7_;
		result = TRUE;
		_g_free0 (foreach_tag);
		return result;
	}
	result = FALSE;
	_g_free0 (foreach_tag);
	return result;
}


static gboolean ___lambda0__gtk_tree_model_foreach_func (GtkTreeModel* model, GtkTreePath* path, GtkTreeIter* iter, gpointer self) {
	gboolean result;
	result = __lambda0_ (self, model, path, iter);
	return result;
}


static gboolean tracker_tags_view_find_tag (TrackerTagsView* self, const gchar* tag, GtkTreeIter* iter) {
	GtkTreeIter _vala_iter = {0};
	gboolean result = FALSE;
	Block2Data* _data2_;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GtkTreeIter _tmp2_ = {0};
	GtkTreeIter _tmp3_;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	gboolean _tmp7_;
	GtkTreeView* _tmp8_;
	GtkTreeModel* _tmp9_ = NULL;
	GtkTreeModel* _tmp10_;
	GtkTreeModel* model;
	GtkTreeModel* _tmp11_;
	gboolean _tmp12_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tag != NULL, FALSE);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = tag;
	_tmp1_ = g_strdup (_tmp0_);
	_data2_->tag = _tmp1_;
	_tmp2_.stamp = 0;
	_data2_->found_iter = _tmp2_;
	_tmp3_ = _data2_->found_iter;
	_vala_iter = _tmp3_;
	_tmp5_ = _data2_->tag;
	if (_tmp5_ == NULL) {
		_tmp4_ = TRUE;
	} else {
		const gchar* _tmp6_;
		_tmp6_ = _data2_->tag;
		_tmp4_ = g_strcmp0 (_tmp6_, "") == 0;
	}
	_tmp7_ = _tmp4_;
	if (_tmp7_) {
		result = FALSE;
		block2_data_unref (_data2_);
		_data2_ = NULL;
		if (iter) {
			*iter = _vala_iter;
		}
		return result;
	}
	_tmp8_ = self->priv->view;
	_tmp9_ = gtk_tree_view_get_model (_tmp8_);
	_tmp10_ = _g_object_ref0 (_tmp9_);
	model = _tmp10_;
	_data2_->found = FALSE;
	_tmp11_ = model;
	gtk_tree_model_foreach (_tmp11_, ___lambda0__gtk_tree_model_foreach_func, _data2_);
	_tmp12_ = _data2_->found;
	if (_tmp12_ == TRUE) {
		GtkTreeIter _tmp13_;
		_tmp13_ = _data2_->found_iter;
		_vala_iter = _tmp13_;
		result = TRUE;
		_g_object_unref0 (model);
		block2_data_unref (_data2_);
		_data2_ = NULL;
		if (iter) {
			*iter = _vala_iter;
		}
		return result;
	}
	result = FALSE;
	_g_object_unref0 (model);
	block2_data_unref (_data2_);
	_data2_ = NULL;
	if (iter) {
		*iter = _vala_iter;
	}
	return result;
}


static void tracker_tags_view_remove_tag_data_free (gpointer _data) {
	TrackerTagsViewRemoveTagData* _data_;
	_data_ = _data;
	_tag_data_unref0 (_data_->td);
	_g_object_unref0 (_data_->self);
	g_slice_free (TrackerTagsViewRemoveTagData, _data_);
}


static void tracker_tags_view_remove_tag (TrackerTagsView* self, TagData* td, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerTagsViewRemoveTagData* _data_;
	TrackerTagsView* _tmp0_;
	TagData* _tmp1_;
	TagData* _tmp2_;
	_data_ = g_slice_new0 (TrackerTagsViewRemoveTagData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_tags_view_remove_tag);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_tags_view_remove_tag_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = td;
	_tmp2_ = _tag_data_ref0 (_tmp1_);
	_data_->td = _tmp2_;
	tracker_tags_view_remove_tag_co (_data_);
}


static void tracker_tags_view_remove_tag_finish (TrackerTagsView* self, GAsyncResult* _res_) {
	TrackerTagsViewRemoveTagData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void tracker_tags_view_remove_tag_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerTagsViewRemoveTagData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tracker_tags_view_remove_tag_co (_data_);
}


static gboolean tracker_tags_view_remove_tag_co (TrackerTagsViewRemoveTagData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->connection;
	if (_data_->_tmp0_ == NULL) {
		_data_->_tmp1_ = _data_->td;
		_data_->_tmp2_ = _data_->_tmp1_->tag_id;
		g_warning ("tracker-tags-view.vala:515: Can't remove tag '%s', no SPARQL connectio" \
"n available", _data_->_tmp2_);
		_data_->_tmp3_ = _data_->td;
		_data_->self->priv->tag_data_requests = g_list_remove (_data_->self->priv->tag_data_requests, _data_->_tmp3_);
		_data_->td = NULL;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = _data_->td;
	_data_->_tmp5_ = _data_->_tmp4_->tag_id;
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = g_strdup_printf ("DELETE { <%s> a rdfs:Resource }", _data_->_tmp5_);
	_data_->query = _data_->_tmp6_;
	{
		_data_->_tmp7_ = _data_->self->priv->connection;
		_data_->_tmp8_ = _data_->query;
		_data_->_tmp9_ = _data_->td;
		_data_->_tmp10_ = _data_->_tmp9_->cancellable;
		_data_->_state_ = 1;
		tracker_sparql_connection_update_async (_data_->_tmp7_, _data_->_tmp8_, G_PRIORITY_DEFAULT, _data_->_tmp10_, tracker_tags_view_remove_tag_ready, _data_);
		return FALSE;
		_state_1:
		tracker_sparql_connection_update_finish (_data_->_tmp7_, _data_->_res_, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			goto __catch17_g_error;
		}
		g_debug ("tracker-tags-view.vala:526: Tag removed");
		_data_->_tmp11_ = _data_->self->priv->store;
		_data_->_tmp12_ = _data_->td;
		_data_->_tmp13_ = _data_->_tmp12_->iter;
		gtk_list_store_remove (_data_->_tmp11_, &_data_->_tmp13_);
	}
	goto __finally17;
	__catch17_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp14_ = _data_->e;
		_data_->_tmp15_ = _data_->_tmp14_->message;
		g_warning ("tracker-tags-view.vala:529: Could not run Sparql update query: %s", _data_->_tmp15_);
		_data_->_tmp16_ = NULL;
		_data_->_tmp16_ = _ ("Could not remove tag");
		_data_->_tmp17_ = _data_->e;
		tracker_tags_view_show_error_dialog (_data_->self, _data_->_tmp16_, _data_->_tmp17_);
		_g_error_free0 (_data_->e);
	}
	__finally17:
	if (_data_->_inner_error_ != NULL) {
		_g_free0 (_data_->query);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->_tmp18_ = _data_->td;
	_data_->self->priv->tag_data_requests = g_list_remove (_data_->self->priv->tag_data_requests, _data_->_tmp18_);
	_data_->td = NULL;
	_g_free0 (_data_->query);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void tracker_tags_view_add_tag_data_free (gpointer _data) {
	TrackerTagsViewAddTagData* _data_;
	_data_ = _data;
	_g_free0 (_data_->tag);
	_g_object_unref0 (_data_->self);
	g_slice_free (TrackerTagsViewAddTagData, _data_);
}


static void tracker_tags_view_add_tag (TrackerTagsView* self, const gchar* tag, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerTagsViewAddTagData* _data_;
	TrackerTagsView* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	_data_ = g_slice_new0 (TrackerTagsViewAddTagData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_tags_view_add_tag);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_tags_view_add_tag_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = tag;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->tag = _tmp2_;
	tracker_tags_view_add_tag_co (_data_);
}


static void tracker_tags_view_add_tag_finish (TrackerTagsView* self, GAsyncResult* _res_) {
	TrackerTagsViewAddTagData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void tracker_tags_view_add_tag_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerTagsViewAddTagData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tracker_tags_view_add_tag_co (_data_);
}


static gboolean tracker_tags_view_add_tag_co (TrackerTagsViewAddTagData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->query = NULL;
	_data_->_tmp0_ = _data_->self->priv->connection;
	if (_data_->_tmp0_ == NULL) {
		_data_->_tmp1_ = _data_->tag;
		g_warning ("tracker-tags-view.vala:541: Can't add tag '%s', no SPARQL connection a" \
"vailable", _data_->_tmp1_);
		_g_free0 (_data_->query);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = _data_->self->priv->entry;
	gtk_widget_set_sensitive ((GtkWidget*) _data_->_tmp2_, FALSE);
	_data_->_tmp4_ = _data_->self->priv->files;
	if (_data_->_tmp4_ != NULL) {
		_data_->_tmp5_ = _data_->self->priv->files;
		_data_->_tmp6_ = 0U;
		_data_->_tmp6_ = g_list_length (_data_->_tmp5_);
		_data_->_tmp3_ = _data_->_tmp6_ > ((guint) 0);
	} else {
		_data_->_tmp3_ = FALSE;
	}
	_data_->_tmp7_ = _data_->_tmp3_;
	if (_data_->_tmp7_) {
		_data_->_tmp8_ = g_strdup ("");
		_g_free0 (_data_->query);
		_data_->query = _data_->_tmp8_;
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = tracker_tags_view_sparql_get_filter_string (_data_->self, NULL);
		_data_->filter = _data_->_tmp9_;
		_data_->_tmp10_ = _data_->tag;
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = tracker_tags_view_sparql_get_escaped_string (_data_->self, _data_->_tmp10_);
		_data_->tag_escaped = _data_->_tmp11_;
		_data_->_tmp12_ = _data_->self->priv->files;
		{
			_data_->url_collection = _data_->_tmp12_;
			_data_->url_it = NULL;
			for (_data_->url_it = _data_->url_collection; _data_->url_it != NULL; _data_->url_it = _data_->url_it->next) {
				_data_->_tmp13_ = g_strdup ((const gchar*) _data_->url_it->data);
				_data_->url = _data_->_tmp13_;
				{
					_data_->_tmp14_ = _data_->query;
					_data_->_tmp15_ = _data_->url;
					_data_->_tmp16_ = _data_->url;
					_data_->_tmp17_ = NULL;
					_data_->_tmp17_ = g_strdup_printf ("INSERT {\n" \
"				            _:file a nie:DataObject ;\n" \
"				             nie:url '%s'\n" \
"				          } WHERE {\n" \
"				            OPTIONAL {\n" \
"				               ?file a nie:DataObject ;\n" \
"				               nie:url '%s'\n" \
"				            } .\n" \
"				            FILTER (!bound(?file))\n" \
"				          }", _data_->_tmp15_, _data_->_tmp16_);
					_data_->_tmp18_ = _data_->_tmp17_;
					_data_->_tmp19_ = g_strconcat (_data_->_tmp14_, _data_->_tmp18_, NULL);
					_g_free0 (_data_->query);
					_data_->query = _data_->_tmp19_;
					_g_free0 (_data_->_tmp18_);
					_g_free0 (_data_->url);
				}
			}
		}
		_data_->_tmp20_ = _data_->query;
		_data_->_tmp21_ = _data_->tag_escaped;
		_data_->_tmp22_ = _data_->tag_escaped;
		_data_->_tmp23_ = _data_->tag_escaped;
		_data_->_tmp24_ = _data_->filter;
		_data_->_tmp25_ = NULL;
		_data_->_tmp25_ = g_strdup_printf ("INSERT {\n" \
"			            _:tag a nao:Tag;\n" \
"			            nao:prefLabel %s .\n" \
"			          } WHERE {\n" \
"			            OPTIONAL {\n" \
"			              ?tag a nao:Tag ;\n" \
"			              nao:prefLabel %s\n" \
"			            } .\n" \
"			            FILTER (!bound(?tag))\n" \
"			          }\n" \
"			          INSERT {\n" \
"			            ?urn nao:hasTag ?label\n" \
"			          } WHERE {\n" \
"			            ?urn nie:url ?f .\n" \
"			            ?label nao:prefLabel %s\n" \
"			            %s\n" \
"			          }", _data_->_tmp21_, _data_->_tmp22_, _data_->_tmp23_, _data_->_tmp24_);
		_data_->_tmp26_ = _data_->_tmp25_;
		_data_->_tmp27_ = g_strconcat (_data_->_tmp20_, _data_->_tmp26_, NULL);
		_g_free0 (_data_->query);
		_data_->query = _data_->_tmp27_;
		_g_free0 (_data_->_tmp26_);
		_g_free0 (_data_->tag_escaped);
		_g_free0 (_data_->filter);
	} else {
		_data_->_tmp28_ = _data_->tag;
		_data_->_tmp29_ = NULL;
		_data_->_tmp29_ = tracker_tags_view_sparql_get_escaped_string (_data_->self, _data_->_tmp28_);
		_data_->tag_label_escaped = _data_->_tmp29_;
		_data_->_tmp30_ = _data_->tag_label_escaped;
		_data_->_tmp31_ = _data_->tag_label_escaped;
		_data_->_tmp32_ = NULL;
		_data_->_tmp32_ = g_strdup_printf ("INSERT {\n" \
"			           _:tag a nao:Tag ;\n" \
"			           nao:prefLabel %s .\n" \
"			         } WHERE {\n" \
"			           OPTIONAL {\n" \
"			             ?tag a nao:Tag ;\n" \
"			             nao:prefLabel %s\n" \
"			           } .\n" \
"			           FILTER (!bound(?tag))\n" \
"			         }", _data_->_tmp30_, _data_->_tmp31_);
		_g_free0 (_data_->query);
		_data_->query = _data_->_tmp32_;
		_g_free0 (_data_->tag_label_escaped);
	}
	_data_->_tmp33_ = _data_->self->priv->files;
	_data_->_tmp34_ = 0U;
	_data_->_tmp34_ = g_list_length (_data_->_tmp33_);
	_data_->_tmp35_ = tag_data_new (NULL, NULL, FALSE, TRUE, (gint) _data_->_tmp34_, _data_->self);
	_data_->td = _data_->_tmp35_;
	_data_->_tmp36_ = _data_->td;
	_data_->_tmp37_ = _tag_data_ref0 (_data_->_tmp36_);
	_data_->self->priv->tag_data_requests = g_list_prepend (_data_->self->priv->tag_data_requests, _data_->_tmp37_);
	{
		_data_->_tmp38_ = _data_->self->priv->connection;
		_data_->_tmp39_ = _data_->query;
		_data_->_tmp40_ = _data_->td;
		_data_->_tmp41_ = _data_->_tmp40_->cancellable;
		_data_->_state_ = 1;
		tracker_sparql_connection_update_async (_data_->_tmp38_, _data_->_tmp39_, G_PRIORITY_DEFAULT, _data_->_tmp41_, tracker_tags_view_add_tag_ready, _data_);
		return FALSE;
		_state_1:
		tracker_sparql_connection_update_finish (_data_->_tmp38_, _data_->_res_, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			goto __catch18_g_error;
		}
		g_debug ("tracker-tags-view.vala:604: Updated tags");
		_data_->_tmp42_ = _data_->td;
		tracker_tags_view_update_tag_data (_data_->self, _data_->_tmp42_);
		_data_->_tmp43_ = _data_->self->priv->entry;
		gtk_entry_set_text (_data_->_tmp43_, "");
	}
	goto __finally18;
	__catch18_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp44_ = _data_->e;
		_data_->_tmp45_ = _data_->_tmp44_->message;
		g_warning ("tracker-tags-view.vala:610: Could not run Sparql update query: %s", _data_->_tmp45_);
		_data_->_tmp46_ = NULL;
		_data_->_tmp46_ = _ ("Could not update tags");
		_data_->_tmp47_ = _data_->e;
		tracker_tags_view_show_error_dialog (_data_->self, _data_->_tmp46_, _data_->_tmp47_);
		_g_error_free0 (_data_->e);
	}
	__finally18:
	if (_data_->_inner_error_ != NULL) {
		_tag_data_unref0 (_data_->td);
		_g_free0 (_data_->query);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->_tmp48_ = _data_->td;
	_data_->self->priv->tag_data_requests = g_list_remove (_data_->self->priv->tag_data_requests, _data_->_tmp48_);
	_tag_data_unref0 (_data_->td);
	_data_->td = NULL;
	_data_->_tmp49_ = _data_->self->priv->entry;
	gtk_widget_set_sensitive ((GtkWidget*) _data_->_tmp49_, TRUE);
	_tag_data_unref0 (_data_->td);
	_g_free0 (_data_->query);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void tracker_tags_view_update_tag_data (TrackerTagsView* self, TagData* td) {
	GtkEntry* _tmp0_;
	const gchar* _tmp1_ = NULL;
	const gchar* tag;
	TagData* _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (td != NULL);
	_tmp0_ = self->priv->entry;
	_tmp1_ = gtk_entry_get_text (_tmp0_);
	tag = _tmp1_;
	_tmp2_ = td;
	_tmp3_ = _tmp2_->update;
	if (_tmp3_ == FALSE) {
		GtkTreeIter iter = {0};
		GtkListStore* _tmp4_;
		GtkTreeIter _tmp5_ = {0};
		GtkListStore* _tmp6_;
		GtkTreeIter _tmp7_;
		TagData* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		TagData* _tmp11_;
		gint _tmp12_;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_;
		TagData* _tmp15_;
		gint _tmp16_;
		g_debug ("tracker-tags-view.vala:626: Setting tag selection state to ON (new)");
		_tmp4_ = self->priv->store;
		gtk_list_store_append (_tmp4_, &_tmp5_);
		iter = _tmp5_;
		_tmp6_ = self->priv->store;
		_tmp7_ = iter;
		_tmp8_ = td;
		_tmp9_ = _tmp8_->tag_id;
		_tmp10_ = tag;
		_tmp11_ = td;
		_tmp12_ = _tmp11_->items;
		_tmp13_ = g_strdup_printf ("%d", _tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = td;
		_tmp16_ = _tmp15_->items;
		gtk_list_store_set (_tmp6_, &_tmp7_, TRACKER_TAGS_VIEW_COL_TAG_ID, _tmp9_, TRACKER_TAGS_VIEW_COL_TAG_NAME, _tmp10_, TRACKER_TAGS_VIEW_COL_TAG_COUNT, _tmp14_, TRACKER_TAGS_VIEW_COL_TAG_COUNT_VALUE, _tmp16_, TRACKER_TAGS_VIEW_COL_SELECTION, TRACKER_TAGS_VIEW_SELECTION_TRUE, -1, -1);
		_g_free0 (_tmp14_);
	} else {
		TagData* _tmp17_;
		gboolean _tmp18_;
		_tmp17_ = td;
		_tmp18_ = _tmp17_->selected;
		if (_tmp18_ == TRUE) {
			GtkListStore* _tmp19_;
			TagData* _tmp20_;
			GtkTreeIter _tmp21_;
			TagData* _tmp22_;
			TagData* _tmp23_;
			TagData* _tmp24_;
			g_debug ("tracker-tags-view.vala:637: Setting tag selection state to ON");
			_tmp19_ = self->priv->store;
			_tmp20_ = td;
			_tmp21_ = _tmp20_->iter;
			gtk_list_store_set (_tmp19_, &_tmp21_, TRACKER_TAGS_VIEW_COL_SELECTION, TRACKER_TAGS_VIEW_SELECTION_TRUE, -1, -1);
			_tmp22_ = td;
			_tmp23_ = _tag_data_ref0 (_tmp22_);
			self->priv->tag_data_requests = g_list_prepend (self->priv->tag_data_requests, _tmp23_);
			_tmp24_ = td;
			tracker_tags_view_query_files_for_tag_id (self, _tmp24_, NULL, NULL);
		} else {
			GtkListStore* _tmp25_;
			TagData* _tmp26_;
			GtkTreeIter _tmp27_;
			TagData* _tmp28_;
			TagData* _tmp29_;
			TagData* _tmp30_;
			g_debug ("tracker-tags-view.vala:644: Setting tag selection state to FALSE");
			_tmp25_ = self->priv->store;
			_tmp26_ = td;
			_tmp27_ = _tmp26_->iter;
			gtk_list_store_set (_tmp25_, &_tmp27_, TRACKER_TAGS_VIEW_COL_SELECTION, TRACKER_TAGS_VIEW_SELECTION_FALSE, -1, -1);
			_tmp28_ = td;
			_tmp29_ = _tag_data_ref0 (_tmp28_);
			self->priv->tag_data_requests = g_list_prepend (self->priv->tag_data_requests, _tmp29_);
			_tmp30_ = td;
			tracker_tags_view_query_files_for_tag_id (self, _tmp30_, NULL, NULL);
		}
	}
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (Block3Data* _data3_) {
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		_g_object_unref0 (_data3_->self);
		_g_object_unref0 (_data3_->store);
		g_slice_free (Block3Data, _data3_);
	}
}


static gboolean __lambda2_ (Block3Data* _data3_, GtkTreeModel* model, GtkTreePath* path, GtkTreeIter* foreach_iter) {
	TrackerTagsView * self;
	gboolean result = FALSE;
	GtkTreeIter _tmp0_;
	self = _data3_->self;
	g_return_val_if_fail (model != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	g_return_val_if_fail (foreach_iter != NULL, FALSE);
	_tmp0_ = *foreach_iter;
	gtk_list_store_set (_data3_->store, &_tmp0_, TRACKER_TAGS_VIEW_COL_SELECTION, TRACKER_TAGS_VIEW_SELECTION_FALSE, -1, -1);
	result = FALSE;
	return result;
}


static gboolean ___lambda2__gtk_tree_model_foreach_func (GtkTreeModel* model, GtkTreePath* path, GtkTreeIter* iter, gpointer self) {
	gboolean result;
	result = __lambda2_ (self, model, path, iter);
	return result;
}


static void tracker_tags_view_untoggle_all (TrackerTagsView* self) {
	Block3Data* _data3_;
	GtkTreeView* _tmp0_;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeModel* _tmp2_;
	GtkTreeModel* model;
	GtkListStore* _tmp3_;
	g_return_if_fail (self != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = self->priv->view;
	_tmp1_ = gtk_tree_view_get_model (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	model = _tmp2_;
	_tmp3_ = _g_object_ref0 (GTK_LIST_STORE (model));
	_data3_->store = _tmp3_;
	gtk_tree_model_foreach (model, ___lambda2__gtk_tree_model_foreach_func, _data3_);
	_g_object_unref0 (model);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}


static void tracker_tags_view_query_tags_for_files_data_free (gpointer _data) {
	TrackerTagsViewQueryTagsForFilesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (TrackerTagsViewQueryTagsForFilesData, _data_);
}


static void tracker_tags_view_query_tags_for_files (TrackerTagsView* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerTagsViewQueryTagsForFilesData* _data_;
	TrackerTagsView* _tmp0_;
	_data_ = g_slice_new0 (TrackerTagsViewQueryTagsForFilesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_tags_view_query_tags_for_files);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_tags_view_query_tags_for_files_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	tracker_tags_view_query_tags_for_files_co (_data_);
}


static void tracker_tags_view_query_tags_for_files_finish (TrackerTagsView* self, GAsyncResult* _res_) {
	TrackerTagsViewQueryTagsForFilesData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void tracker_tags_view_query_tags_for_files_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerTagsViewQueryTagsForFilesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tracker_tags_view_query_tags_for_files_co (_data_);
}


static gboolean tracker_tags_view_query_tags_for_files_co (TrackerTagsViewQueryTagsForFilesData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	tracker_tags_view_untoggle_all (_data_->self);
	_data_->_tmp0_ = _data_->self->priv->files;
	if (_data_->_tmp0_ == NULL) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = g_strdup ("");
	_data_->files_filter = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->self->priv->files;
	{
		_data_->url_collection = _data_->_tmp2_;
		_data_->url_it = NULL;
		for (_data_->url_it = _data_->url_collection; _data_->url_it != NULL; _data_->url_it = _data_->url_it->next) {
			_data_->_tmp3_ = g_strdup ((const gchar*) _data_->url_it->data);
			_data_->url = _data_->_tmp3_;
			{
				_data_->_tmp4_ = _data_->files_filter;
				_data_->_tmp5_ = strlen (_data_->_tmp4_);
				_data_->_tmp6_ = _data_->_tmp5_;
				if (_data_->_tmp6_ > 0) {
					_data_->_tmp7_ = _data_->files_filter;
					_data_->_tmp8_ = g_strconcat (_data_->_tmp7_, ",", NULL);
					_g_free0 (_data_->files_filter);
					_data_->files_filter = _data_->_tmp8_;
				}
				_data_->_tmp9_ = _data_->files_filter;
				_data_->_tmp10_ = _data_->url;
				_data_->_tmp11_ = NULL;
				_data_->_tmp11_ = g_strdup_printf ("'%s'", _data_->_tmp10_);
				_data_->_tmp12_ = _data_->_tmp11_;
				_data_->_tmp13_ = g_strconcat (_data_->_tmp9_, _data_->_tmp12_, NULL);
				_g_free0 (_data_->files_filter);
				_data_->files_filter = _data_->_tmp13_;
				_g_free0 (_data_->_tmp12_);
				_g_free0 (_data_->url);
			}
		}
	}
	_data_->_tmp14_ = _data_->files_filter;
	_data_->_tmp15_ = NULL;
	_data_->_tmp15_ = g_strdup_printf ("select ?tag nao:prefLabel(?tag) WHERE { ?urn nao:hasTag ?tag . FILTER(" \
"nie:url(?urn) IN (%s)) } ORDER BY (?tag)", _data_->_tmp14_);
	_data_->query = _data_->_tmp15_;
	g_debug ("tracker-tags-view.vala:683: Getting tags for files selected...");
	{
		_data_->_tmp16_ = _data_->self->priv->connection;
		_data_->_tmp17_ = _data_->query;
		_data_->_state_ = 1;
		tracker_sparql_connection_query_async (_data_->_tmp16_, _data_->_tmp17_, NULL, tracker_tags_view_query_tags_for_files_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp18_ = NULL;
		_data_->_tmp18_ = tracker_sparql_connection_query_finish (_data_->_tmp16_, _data_->_res_, &_data_->_inner_error_);
		_data_->cursor = _data_->_tmp18_;
		if (_data_->_inner_error_ != NULL) {
			goto __catch19_g_error;
		}
		while (TRUE) {
			_data_->_tmp19_ = _data_->cursor;
			_data_->_state_ = 2;
			tracker_sparql_cursor_next_async (_data_->_tmp19_, NULL, tracker_tags_view_query_tags_for_files_ready, _data_);
			return FALSE;
			_state_2:
			_data_->_tmp20_ = FALSE;
			_data_->_tmp20_ = tracker_sparql_cursor_next_finish (_data_->_tmp19_, _data_->_res_, &_data_->_inner_error_);
			_data_->_tmp21_ = _data_->_tmp20_;
			if (_data_->_inner_error_ != NULL) {
				_g_object_unref0 (_data_->cursor);
				goto __catch19_g_error;
			}
			if (!_data_->_tmp21_) {
				break;
			}
			g_debug ("tracker-tags-view.vala:689: Toggling tags...");
			_data_->_tmp22_ = _data_->cursor;
			_data_->_tmp23_ = NULL;
			_data_->_tmp23_ = tracker_sparql_cursor_get_string (_data_->_tmp22_, 0, NULL);
			_data_->id = _data_->_tmp23_;
			_data_->_tmp24_ = _data_->cursor;
			_data_->_tmp25_ = NULL;
			_data_->_tmp25_ = tracker_sparql_cursor_get_string (_data_->_tmp24_, 1, NULL);
			_data_->label = _data_->_tmp25_;
			_data_->_tmp26_ = _data_->id;
			_data_->_tmp27_ = _data_->label;
			g_debug ("tracker-tags-view.vala:694:   Enabling tag:'%s', label:'%s'", _data_->_tmp26_, _data_->_tmp27_);
			_data_->_tmp28_ = _data_->label;
			memset (&_data_->_tmp29_, 0, sizeof (GtkTreeIter));
			_data_->_tmp30_ = FALSE;
			_data_->_tmp30_ = tracker_tags_view_find_tag (_data_->self, _data_->_tmp28_, &_data_->_tmp29_);
			_data_->iter = _data_->_tmp29_;
			if (_data_->_tmp30_) {
				_data_->_tmp31_ = _data_->self->priv->store;
				_data_->_tmp32_ = _data_->iter;
				gtk_list_store_set (_data_->_tmp31_, &_data_->_tmp32_, TRACKER_TAGS_VIEW_COL_SELECTION, TRACKER_TAGS_VIEW_SELECTION_TRUE, -1, -1);
			}
		}
		_g_object_unref0 (_data_->cursor);
	}
	goto __finally19;
	__catch19_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp33_ = _data_->e;
		_data_->_tmp34_ = _data_->_tmp33_->message;
		g_warning ("tracker-tags-view.vala:704: Could not run Sparql query: %s", _data_->_tmp34_);
		_data_->_tmp35_ = NULL;
		_data_->_tmp35_ = _ ("Could not retrieve tags for the current selection");
		_data_->_tmp36_ = _data_->e;
		tracker_tags_view_show_error_dialog (_data_->self, _data_->_tmp35_, _data_->_tmp36_);
		_g_error_free0 (_data_->e);
	}
	__finally19:
	if (_data_->_inner_error_ != NULL) {
		_g_free0 (_data_->query);
		_g_free0 (_data_->files_filter);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_g_free0 (_data_->query);
	_g_free0 (_data_->files_filter);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void tracker_tags_view_query_tags_data_free (gpointer _data) {
	TrackerTagsViewQueryTagsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (TrackerTagsViewQueryTagsData, _data_);
}


static void tracker_tags_view_query_tags (TrackerTagsView* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerTagsViewQueryTagsData* _data_;
	TrackerTagsView* _tmp0_;
	_data_ = g_slice_new0 (TrackerTagsViewQueryTagsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_tags_view_query_tags);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_tags_view_query_tags_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	tracker_tags_view_query_tags_co (_data_);
}


static void tracker_tags_view_query_tags_finish (TrackerTagsView* self, GAsyncResult* _res_) {
	TrackerTagsViewQueryTagsData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void tracker_tags_view_query_tags_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerTagsViewQueryTagsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tracker_tags_view_query_tags_co (_data_);
}


static gboolean tracker_tags_view_query_tags_co (TrackerTagsViewQueryTagsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_strdup ("SELECT ?urn ?label WHERE { ?urn a nao:Tag ; nao:prefLabel ?label . } O" \
"RDER BY ?label");
	_data_->query = _data_->_tmp0_;
	g_debug ("tracker-tags-view.vala:713: Clearing tags in store");
	_data_->_tmp1_ = _data_->self->priv->store;
	gtk_list_store_clear (_data_->_tmp1_);
	{
		_data_->_tmp2_ = _data_->self->priv->connection;
		_data_->_tmp3_ = _data_->query;
		_data_->_state_ = 1;
		tracker_sparql_connection_query_async (_data_->_tmp2_, _data_->_tmp3_, NULL, tracker_tags_view_query_tags_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = tracker_sparql_connection_query_finish (_data_->_tmp2_, _data_->_res_, &_data_->_inner_error_);
		_data_->cursor = _data_->_tmp4_;
		if (_data_->_inner_error_ != NULL) {
			goto __catch20_g_error;
		}
		while (TRUE) {
			_data_->_tmp5_ = _data_->cursor;
			_data_->_state_ = 2;
			tracker_sparql_cursor_next_async (_data_->_tmp5_, NULL, tracker_tags_view_query_tags_ready, _data_);
			return FALSE;
			_state_2:
			_data_->_tmp6_ = FALSE;
			_data_->_tmp6_ = tracker_sparql_cursor_next_finish (_data_->_tmp5_, _data_->_res_, &_data_->_inner_error_);
			_data_->_tmp7_ = _data_->_tmp6_;
			if (_data_->_inner_error_ != NULL) {
				_g_object_unref0 (_data_->cursor);
				goto __catch20_g_error;
			}
			if (!_data_->_tmp7_) {
				break;
			}
			g_debug ("tracker-tags-view.vala:721: Adding all tags...");
			_data_->_tmp8_ = _data_->cursor;
			_data_->_tmp9_ = NULL;
			_data_->_tmp9_ = tracker_sparql_cursor_get_string (_data_->_tmp8_, 0, NULL);
			_data_->id = _data_->_tmp9_;
			_data_->_tmp10_ = _data_->cursor;
			_data_->_tmp11_ = NULL;
			_data_->_tmp11_ = tracker_sparql_cursor_get_string (_data_->_tmp10_, 1, NULL);
			_data_->label = _data_->_tmp11_;
			_data_->_tmp12_ = _data_->id;
			_data_->_tmp13_ = _data_->label;
			g_debug ("tracker-tags-view.vala:726:   Adding tag id:'%s' with label:'%s' to st" \
"ore", _data_->_tmp12_, _data_->_tmp13_);
			_data_->_tmp14_ = _data_->self->priv->store;
			memset (&_data_->_tmp15_, 0, sizeof (GtkTreeIter));
			gtk_list_store_append (_data_->_tmp14_, &_data_->_tmp15_);
			_data_->iter = _data_->_tmp15_;
			_data_->_tmp16_ = _data_->self->priv->store;
			_data_->_tmp17_ = _data_->iter;
			_data_->_tmp18_ = _data_->id;
			_data_->_tmp19_ = _data_->label;
			gtk_list_store_set (_data_->_tmp16_, &_data_->_tmp17_, TRACKER_TAGS_VIEW_COL_TAG_ID, _data_->_tmp18_, TRACKER_TAGS_VIEW_COL_TAG_NAME, _data_->_tmp19_, TRACKER_TAGS_VIEW_COL_SELECTION, TRACKER_TAGS_VIEW_SELECTION_FALSE, -1, -1);
			_data_->_tmp20_ = _data_->id;
			_data_->_tmp21_ = _data_->iter;
			_data_->_tmp22_ = tag_data_new (_data_->_tmp20_, &_data_->_tmp21_, FALSE, TRUE, 1, _data_->self);
			_data_->td = _data_->_tmp22_;
			_data_->_tmp23_ = _data_->td;
			_data_->_tmp24_ = _tag_data_ref0 (_data_->_tmp23_);
			_data_->self->priv->tag_data_requests = g_list_prepend (_data_->self->priv->tag_data_requests, _data_->_tmp24_);
			_data_->_tmp25_ = _data_->td;
			tracker_tags_view_query_files_for_tag_id (_data_->self, _data_->_tmp25_, NULL, NULL);
			_tag_data_unref0 (_data_->td);
		}
		_g_object_unref0 (_data_->cursor);
	}
	goto __finally20;
	__catch20_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp26_ = _data_->e;
		_data_->_tmp27_ = _data_->_tmp26_->message;
		g_warning ("tracker-tags-view.vala:743: Could not run Sparql query: %s", _data_->_tmp27_);
		_data_->_tmp28_ = NULL;
		_data_->_tmp28_ = _ ("Could not add tag");
		_data_->_tmp29_ = _data_->e;
		tracker_tags_view_show_error_dialog (_data_->self, _data_->_tmp28_, _data_->_tmp29_);
		_g_error_free0 (_data_->e);
	}
	__finally20:
	if (_data_->_inner_error_ != NULL) {
		_g_free0 (_data_->query);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_g_free0 (_data_->query);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void tracker_tags_view_query_files_for_tag_id_data_free (gpointer _data) {
	TrackerTagsViewQueryFilesForTagIdData* _data_;
	_data_ = _data;
	_tag_data_unref0 (_data_->td);
	_g_object_unref0 (_data_->self);
	g_slice_free (TrackerTagsViewQueryFilesForTagIdData, _data_);
}


static void tracker_tags_view_query_files_for_tag_id (TrackerTagsView* self, TagData* td, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerTagsViewQueryFilesForTagIdData* _data_;
	TrackerTagsView* _tmp0_;
	TagData* _tmp1_;
	TagData* _tmp2_;
	_data_ = g_slice_new0 (TrackerTagsViewQueryFilesForTagIdData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_tags_view_query_files_for_tag_id);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_tags_view_query_files_for_tag_id_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = td;
	_tmp2_ = _tag_data_ref0 (_tmp1_);
	_data_->td = _tmp2_;
	tracker_tags_view_query_files_for_tag_id_co (_data_);
}


static void tracker_tags_view_query_files_for_tag_id_finish (TrackerTagsView* self, GAsyncResult* _res_) {
	TrackerTagsViewQueryFilesForTagIdData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void tracker_tags_view_query_files_for_tag_id_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerTagsViewQueryFilesForTagIdData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tracker_tags_view_query_files_for_tag_id_co (_data_);
}


static gboolean tracker_tags_view_query_files_for_tag_id_co (TrackerTagsViewQueryFilesForTagIdData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->connection;
	if (_data_->_tmp0_ == NULL) {
		_data_->_tmp1_ = _data_->td;
		_data_->_tmp2_ = _data_->_tmp1_->tag_id;
		g_warning ("tracker-tags-view.vala:750: Can't query files for tag id '%s', no SPAR" \
"QL connection available", _data_->_tmp2_);
		_data_->_tmp3_ = _data_->td;
		_data_->self->priv->tag_data_requests = g_list_remove (_data_->self->priv->tag_data_requests, _data_->_tmp3_);
		_data_->td = NULL;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = _data_->td;
	_data_->_tmp5_ = _data_->_tmp4_->tag_id;
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = g_strdup_printf ("SELECT ?url WHERE { ?urn a rdfs:Resource ; nie:url ?url ; nao:hasTag <" \
"%s> . }", _data_->_tmp5_);
	_data_->query = _data_->_tmp6_;
	{
		_data_->_tmp7_ = _data_->self->priv->connection;
		_data_->_tmp8_ = _data_->query;
		_data_->_tmp9_ = _data_->td;
		_data_->_tmp10_ = _data_->_tmp9_->cancellable;
		_data_->_state_ = 1;
		tracker_sparql_connection_query_async (_data_->_tmp7_, _data_->_tmp8_, _data_->_tmp10_, tracker_tags_view_query_files_for_tag_id_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = tracker_sparql_connection_query_finish (_data_->_tmp7_, _data_->_res_, &_data_->_inner_error_);
		_data_->cursor = _data_->_tmp11_;
		if (_data_->_inner_error_ != NULL) {
			goto __catch21_g_error;
		}
		_data_->has_tag_in_selection = (guint) 0;
		_data_->files_with_tag = (guint) 0;
		_data_->_tmp12_ = _data_->self->priv->files;
		_data_->_tmp13_ = 0U;
		_data_->_tmp13_ = g_list_length (_data_->_tmp12_);
		_data_->files_selected = _data_->_tmp13_;
		while (TRUE) {
			_data_->_tmp14_ = _data_->cursor;
			_data_->_state_ = 2;
			tracker_sparql_cursor_next_async (_data_->_tmp14_, NULL, tracker_tags_view_query_files_for_tag_id_ready, _data_);
			return FALSE;
			_state_2:
			_data_->_tmp15_ = FALSE;
			_data_->_tmp15_ = tracker_sparql_cursor_next_finish (_data_->_tmp14_, _data_->_res_, &_data_->_inner_error_);
			_data_->_tmp16_ = _data_->_tmp15_;
			if (_data_->_inner_error_ != NULL) {
				_g_object_unref0 (_data_->cursor);
				goto __catch21_g_error;
			}
			if (!_data_->_tmp16_) {
				break;
			}
			_data_->_tmp17_ = _data_->files_with_tag;
			_data_->files_with_tag = _data_->_tmp17_ + 1;
			_data_->_tmp18_ = _data_->self->priv->files;
			{
				_data_->url_collection = _data_->_tmp18_;
				_data_->url_it = NULL;
				for (_data_->url_it = _data_->url_collection; _data_->url_it != NULL; _data_->url_it = _data_->url_it->next) {
					_data_->_tmp19_ = g_strdup ((const gchar*) _data_->url_it->data);
					_data_->url = _data_->_tmp19_;
					{
						_data_->_tmp20_ = _data_->cursor;
						_data_->_tmp21_ = NULL;
						_data_->_tmp21_ = tracker_sparql_cursor_get_string (_data_->_tmp20_, 0, NULL);
						_data_->url_returned = _data_->_tmp21_;
						_data_->_tmp22_ = _data_->url;
						_data_->_tmp23_ = _data_->url_returned;
						g_debug ("tracker-tags-view.vala:771: --> '%s' vs '%s'", _data_->_tmp22_, _data_->_tmp23_);
						_data_->_tmp24_ = _data_->url_returned;
						if (_data_->_tmp24_ == NULL) {
							_g_free0 (_data_->url);
							continue;
						}
						_data_->_tmp25_ = _data_->url_returned;
						_data_->_tmp26_ = _data_->url;
						if (g_strcmp0 (_data_->_tmp25_, _data_->_tmp26_) == 0) {
							_data_->_tmp27_ = _data_->has_tag_in_selection;
							_data_->has_tag_in_selection = _data_->_tmp27_ + 1;
							_g_free0 (_data_->url);
							break;
						}
						_g_free0 (_data_->url);
					}
				}
			}
		}
		_data_->_tmp28_ = _data_->has_tag_in_selection;
		_data_->_tmp29_ = _data_->files_with_tag;
		_data_->_tmp30_ = _data_->files_selected;
		g_debug ("tracker-tags-view.vala:784: Querying files with tag, in selection:%ld," \
" in total:%ld, selected:%ld", (glong) _data_->_tmp28_, (glong) _data_->_tmp29_, (glong) _data_->_tmp30_);
		_data_->_tmp31_ = _data_->has_tag_in_selection;
		if (_data_->_tmp31_ == ((guint) 0)) {
			_data_->_tmp32_ = _data_->self->priv->store;
			_data_->_tmp33_ = _data_->td;
			_data_->_tmp34_ = _data_->_tmp33_->iter;
			gtk_list_store_set (_data_->_tmp32_, &_data_->_tmp34_, TRACKER_TAGS_VIEW_COL_SELECTION, TRACKER_TAGS_VIEW_SELECTION_FALSE, -1, -1);
		} else {
			_data_->_tmp35_ = _data_->files_selected;
			_data_->_tmp36_ = _data_->has_tag_in_selection;
			if (_data_->_tmp35_ != _data_->_tmp36_) {
				_data_->_tmp37_ = _data_->self->priv->store;
				_data_->_tmp38_ = _data_->td;
				_data_->_tmp39_ = _data_->_tmp38_->iter;
				gtk_list_store_set (_data_->_tmp37_, &_data_->_tmp39_, TRACKER_TAGS_VIEW_COL_SELECTION, TRACKER_TAGS_VIEW_SELECTION_INCONSISTENT, -1, -1);
			} else {
				_data_->_tmp40_ = _data_->self->priv->store;
				_data_->_tmp41_ = _data_->td;
				_data_->_tmp42_ = _data_->_tmp41_->iter;
				gtk_list_store_set (_data_->_tmp40_, &_data_->_tmp42_, TRACKER_TAGS_VIEW_COL_SELECTION, TRACKER_TAGS_VIEW_SELECTION_TRUE, -1, -1);
			}
		}
		_data_->_tmp43_ = _data_->files_with_tag;
		_data_->_tmp44_ = NULL;
		_data_->_tmp44_ = g_strdup_printf ("%ld", (glong) _data_->_tmp43_);
		_data_->str = _data_->_tmp44_;
		_data_->_tmp45_ = _data_->self->priv->store;
		_data_->_tmp46_ = _data_->td;
		_data_->_tmp47_ = _data_->_tmp46_->iter;
		_data_->_tmp48_ = _data_->str;
		_data_->_tmp49_ = _data_->files_with_tag;
		gtk_list_store_set (_data_->_tmp45_, &_data_->_tmp47_, TRACKER_TAGS_VIEW_COL_TAG_COUNT, _data_->_tmp48_, TRACKER_TAGS_VIEW_COL_TAG_COUNT_VALUE, _data_->_tmp49_, -1, -1);
		g_debug ("tracker-tags-view.vala:798: Tags for file updated");
		_g_free0 (_data_->str);
		_g_object_unref0 (_data_->cursor);
	}
	goto __finally21;
	__catch21_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp50_ = _data_->e;
		_data_->_tmp51_ = _data_->_tmp50_->message;
		g_warning ("tracker-tags-view.vala:800: Could not run Sparql query: %s", _data_->_tmp51_);
		_data_->_tmp52_ = NULL;
		_data_->_tmp52_ = _ ("Could not update tags for file");
		_data_->_tmp53_ = _data_->e;
		tracker_tags_view_show_error_dialog (_data_->self, _data_->_tmp52_, _data_->_tmp53_);
		_g_error_free0 (_data_->e);
	}
	__finally21:
	if (_data_->_inner_error_ != NULL) {
		_g_free0 (_data_->query);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->_tmp54_ = _data_->td;
	_data_->self->priv->tag_data_requests = g_list_remove (_data_->self->priv->tag_data_requests, _data_->_tmp54_);
	_data_->td = NULL;
	_g_free0 (_data_->query);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gchar* tracker_tags_view_sparql_get_filter_string (TrackerTagsView* self, const gchar* tag) {
	gchar* result = NULL;
	GList* _tmp0_;
	GList* _tmp1_;
	guint _tmp2_ = 0U;
	gchar* _tmp3_;
	gchar* filter;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	gboolean _tmp7_;
	gboolean first;
	GList* _tmp10_;
	gboolean _tmp20_ = FALSE;
	const gchar* _tmp21_;
	gboolean _tmp23_;
	const gchar* _tmp29_;
	gchar* _tmp30_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->files;
	_tmp1_ = self->priv->files;
	_tmp2_ = g_list_length (_tmp1_);
	g_return_val_if_fail ((_tmp0_ != NULL) && (_tmp2_ > ((guint) 0)), NULL);
	_tmp3_ = g_strdup ("FILTER (");
	filter = _tmp3_;
	_tmp5_ = tag;
	if (_tmp5_ != NULL) {
		const gchar* _tmp6_;
		_tmp6_ = tag;
		_tmp4_ = g_strcmp0 (_tmp6_, "") != 0;
	} else {
		_tmp4_ = FALSE;
	}
	_tmp7_ = _tmp4_;
	if (_tmp7_) {
		const gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp8_ = filter;
		_tmp9_ = g_strconcat (_tmp8_, "(", NULL);
		_g_free0 (filter);
		filter = _tmp9_;
	}
	first = TRUE;
	_tmp10_ = self->priv->files;
	{
		GList* url_collection = NULL;
		GList* url_it = NULL;
		url_collection = _tmp10_;
		for (url_it = url_collection; url_it != NULL; url_it = url_it->next) {
			gchar* _tmp11_;
			gchar* url = NULL;
			_tmp11_ = g_strdup ((const gchar*) url_it->data);
			url = _tmp11_;
			{
				gboolean _tmp12_;
				const gchar* _tmp15_;
				const gchar* _tmp16_;
				gchar* _tmp17_ = NULL;
				gchar* _tmp18_;
				gchar* _tmp19_;
				_tmp12_ = first;
				if (!_tmp12_) {
					const gchar* _tmp13_;
					gchar* _tmp14_;
					_tmp13_ = filter;
					_tmp14_ = g_strconcat (_tmp13_, " || ", NULL);
					_g_free0 (filter);
					filter = _tmp14_;
				}
				_tmp15_ = filter;
				_tmp16_ = url;
				_tmp17_ = g_strdup_printf ("?f = \"%s\"", _tmp16_);
				_tmp18_ = _tmp17_;
				_tmp19_ = g_strconcat (_tmp15_, _tmp18_, NULL);
				_g_free0 (filter);
				filter = _tmp19_;
				_g_free0 (_tmp18_);
				first = FALSE;
				_g_free0 (url);
			}
		}
	}
	_tmp21_ = tag;
	if (_tmp21_ != NULL) {
		const gchar* _tmp22_;
		_tmp22_ = tag;
		_tmp20_ = g_strcmp0 (_tmp22_, "") != 0;
	} else {
		_tmp20_ = FALSE;
	}
	_tmp23_ = _tmp20_;
	if (_tmp23_) {
		const gchar* _tmp24_;
		const gchar* _tmp25_;
		gchar* _tmp26_ = NULL;
		gchar* _tmp27_;
		gchar* _tmp28_;
		_tmp24_ = filter;
		_tmp25_ = tag;
		_tmp26_ = g_strdup_printf (") && ?t = <%s>", _tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = g_strconcat (_tmp24_, _tmp27_, NULL);
		_g_free0 (filter);
		filter = _tmp28_;
		_g_free0 (_tmp27_);
	}
	_tmp29_ = filter;
	_tmp30_ = g_strconcat (_tmp29_, ")", NULL);
	_g_free0 (filter);
	filter = _tmp30_;
	result = filter;
	return result;
}


static gchar* tracker_tags_view_sparql_get_escaped_string (TrackerTagsView* self, const gchar* str) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* escaped;
	gchar* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (str != NULL, NULL);
	_tmp0_ = str;
	_tmp1_ = tracker_sparql_escape_string (_tmp0_);
	escaped = _tmp1_;
	_tmp2_ = g_strdup_printf ("\"%s\"", escaped);
	result = _tmp2_;
	_g_free0 (escaped);
	return result;
}


static void tracker_tags_view_class_init (TrackerTagsViewClass * klass) {
	tracker_tags_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TrackerTagsViewPrivate));
	G_OBJECT_CLASS (klass)->finalize = tracker_tags_view_finalize;
}


static void tracker_tags_view_instance_init (TrackerTagsView * self) {
	self->priv = TRACKER_TAGS_VIEW_GET_PRIVATE (self);
}


static void tracker_tags_view_finalize (GObject* obj) {
	TrackerTagsView * self;
	GCancellable* _tmp0_;
	GList* _tmp2_;
	GList* _tmp5_;
	self = TRACKER_TAGS_VIEW (obj);
	_tmp0_ = self->priv->cancellable;
	if (_tmp0_ != NULL) {
		GCancellable* _tmp1_;
		_tmp1_ = self->priv->cancellable;
		g_cancellable_cancel (_tmp1_);
		_g_object_unref0 (self->priv->cancellable);
		self->priv->cancellable = NULL;
	}
	_tmp2_ = self->priv->files;
	if (_tmp2_ != NULL) {
		GList* _tmp3_;
		_tmp3_ = self->priv->files;
		{
			GList* url_collection = NULL;
			GList* url_it = NULL;
			url_collection = _tmp3_;
			for (url_it = url_collection; url_it != NULL; url_it = url_it->next) {
				gchar* _tmp4_;
				gchar* url = NULL;
				_tmp4_ = g_strdup ((const gchar*) url_it->data);
				url = _tmp4_;
				{
					_g_free0 (url);
					url = NULL;
					_g_free0 (url);
				}
			}
		}
		__g_list_free__g_free0_0 (self->priv->files);
		self->priv->files = NULL;
	}
	_tmp5_ = self->priv->tag_data_requests;
	if (_tmp5_ != NULL) {
		GList* _tmp6_;
		_tmp6_ = self->priv->tag_data_requests;
		{
			GList* td_collection = NULL;
			GList* td_it = NULL;
			td_collection = _tmp6_;
			for (td_it = td_collection; td_it != NULL; td_it = td_it->next) {
				TagData* _tmp7_;
				TagData* td = NULL;
				_tmp7_ = _tag_data_ref0 ((TagData*) td_it->data);
				td = _tmp7_;
				{
					_tag_data_unref0 (td);
					td = NULL;
					_tag_data_unref0 (td);
				}
			}
		}
		__g_list_free__tag_data_unref0_0 (self->priv->tag_data_requests);
		self->priv->tag_data_requests = NULL;
	}
	_g_object_unref0 (self->priv->connection);
	_g_object_unref0 (self->priv->cancellable);
	__g_list_free__tag_data_unref0_0 (self->priv->tag_data_requests);
	__g_list_free__g_free0_0 (self->priv->files);
	_g_object_unref0 (self->priv->store);
	_g_object_unref0 (self->priv->vbox);
	_g_object_unref0 (self->priv->label);
	_g_object_unref0 (self->priv->entry);
	_g_object_unref0 (self->priv->button_add);
	_g_object_unref0 (self->priv->button_remove);
	_g_object_unref0 (self->priv->scrolled_window);
	_g_object_unref0 (self->priv->view);
	G_OBJECT_CLASS (tracker_tags_view_parent_class)->finalize (obj);
}


GType tracker_tags_view_get_type (void) {
	static volatile gsize tracker_tags_view_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_tags_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerTagsViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_tags_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerTagsView), 0, (GInstanceInitFunc) tracker_tags_view_instance_init, NULL };
		GType tracker_tags_view_type_id;
		tracker_tags_view_type_id = g_type_register_static (GTK_TYPE_VBOX, "TrackerTagsView", &g_define_type_info, 0);
		g_once_init_leave (&tracker_tags_view_type_id__volatile, tracker_tags_view_type_id);
	}
	return tracker_tags_view_type_id__volatile;
}



