/* tracker-metadata-tile.c generated by valac 0.11.1, the Vala compiler
 * generated from tracker-metadata-tile.gs, do not modify */


#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <pango/pango.h>
#include <gio/gio.h>
#include <gio/gdesktopappinfo.h>
#include <gdk-pixbuf/gdk-pixdata.h>


#define TYPE_TRACKER_METADATA_TILE (tracker_metadata_tile_get_type ())
#define TRACKER_METADATA_TILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRACKER_METADATA_TILE, TrackerMetadataTile))
#define TRACKER_METADATA_TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRACKER_METADATA_TILE, TrackerMetadataTileClass))
#define IS_TRACKER_METADATA_TILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRACKER_METADATA_TILE))
#define IS_TRACKER_METADATA_TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRACKER_METADATA_TILE))
#define TRACKER_METADATA_TILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRACKER_METADATA_TILE, TrackerMetadataTileClass))

typedef struct _TrackerMetadataTile TrackerMetadataTile;
typedef struct _TrackerMetadataTileClass TrackerMetadataTileClass;
typedef struct _TrackerMetadataTilePrivate TrackerMetadataTilePrivate;

#define TYPE_CATEGORIES (categories_get_type ())

#define TYPE_TRACKER_RESULT_GRID (tracker_result_grid_get_type ())
#define TRACKER_RESULT_GRID(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRACKER_RESULT_GRID, TrackerResultGrid))
#define TRACKER_RESULT_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRACKER_RESULT_GRID, TrackerResultGridClass))
#define IS_TRACKER_RESULT_GRID(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRACKER_RESULT_GRID))
#define IS_TRACKER_RESULT_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRACKER_RESULT_GRID))
#define TRACKER_RESULT_GRID_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRACKER_RESULT_GRID, TrackerResultGridClass))

typedef struct _TrackerResultGrid TrackerResultGrid;
typedef struct _TrackerResultGridClass TrackerResultGridClass;

#define TYPE_TRACKER_QUERY (tracker_query_get_type ())
#define TRACKER_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRACKER_QUERY, TrackerQuery))
#define TRACKER_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRACKER_QUERY, TrackerQueryClass))
#define IS_TRACKER_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRACKER_QUERY))
#define IS_TRACKER_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRACKER_QUERY))
#define TRACKER_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRACKER_QUERY, TrackerQueryClass))

typedef struct _TrackerQuery TrackerQuery;
typedef struct _TrackerQueryClass TrackerQueryClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _TrackerResultGridPrivate TrackerResultGridPrivate;

#define TYPE_RESULT_COLUMNS (result_columns_get_type ())

typedef enum  {
	CATEGORIES_Application,
	CATEGORIES_Contact,
	CATEGORIES_Email,
	CATEGORIES_EmailAttachment,
	CATEGORIES_File,
	CATEGORIES_Folder,
	CATEGORIES_Audio,
	CATEGORIES_Video,
	CATEGORIES_Image,
	CATEGORIES_Document,
	CATEGORIES_Text,
	CATEGORIES_Development,
	CATEGORIES_Web,
	CATEGORIES_WebHistory
} Categories;

struct _TrackerMetadataTile {
	GtkEventBox parent_instance;
	TrackerMetadataTilePrivate * priv;
	gchar* uri;
	Categories category;
	GtkImage* image;
	GtkLinkButton* name_link;
	GtkLinkButton* path_link;
	GtkTable* table;
	GtkLabel* name_label;
	GtkLabel* path_label;
	GtkLabel* info_label1;
	GtkLabel* info_value1;
	GtkLabel* info_label2;
	GtkLabel* info_value2;
	GtkLabel* info_label3;
	GtkLabel* info_value3;
	GtkLabel* info_label4;
	GtkLabel* info_value4;
	GtkLabel* info_label5;
	GtkLabel* info_value5;
	GtkLabel* info_label6;
	GtkLabel* info_value6;
};

struct _TrackerMetadataTileClass {
	GtkEventBoxClass parent_class;
};

struct _TrackerMetadataTilePrivate {
	TrackerResultGrid* _result_grid;
	TrackerQuery* _Query;
};

struct _TrackerResultGrid {
	GtkScrolledWindow parent_instance;
	TrackerResultGridPrivate * priv;
	GtkListStore* store;
	GtkIconView* iconview;
};

struct _TrackerResultGridClass {
	GtkScrolledWindowClass parent_class;
};

typedef enum  {
	RESULT_COLUMNS_Id,
	RESULT_COLUMNS_Uri,
	RESULT_COLUMNS_Icon,
	RESULT_COLUMNS_DisplayName,
	RESULT_COLUMNS_Mime,
	RESULT_COLUMNS_Category,
	RESULT_COLUMNS_Snippet,
	RESULT_COLUMNS_IsDirectory,
	RESULT_COLUMNS_Path,
	RESULT_COLUMNS_NumOfCols
} ResultColumns;


static gpointer tracker_metadata_tile_parent_class = NULL;

GType tracker_metadata_tile_get_type (void) G_GNUC_CONST;
GType categories_get_type (void) G_GNUC_CONST;
GType tracker_result_grid_get_type (void) G_GNUC_CONST;
GType tracker_query_get_type (void) G_GNUC_CONST;
#define TRACKER_METADATA_TILE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TRACKER_METADATA_TILE, TrackerMetadataTilePrivate))
enum  {
	TRACKER_METADATA_TILE_DUMMY_PROPERTY,
	TRACKER_METADATA_TILE_QUERY,
	TRACKER_METADATA_TILE_RESULT_GRID
};
static gboolean tracker_metadata_tile_expose (TrackerMetadataTile* self, GdkEventExpose* e);
static void tracker_metadata_tile_AttachToTable (TrackerMetadataTile* self, GtkLabel* lab, gint l, gint r, gint t, gint b, gboolean e);
static GtkLabel* tracker_metadata_tile_CreateLabel (TrackerMetadataTile* self, const gchar* s, gboolean e);
void tracker_metadata_tile_ClearLabels (TrackerMetadataTile* self);
void tracker_metadata_tile_SetLabelValue (TrackerMetadataTile* self, GtkLabel* label, const gchar* val);
void tracker_metadata_tile_SetLabelSizeValue (TrackerMetadataTile* self, GtkLabel* label, gint64 size);
gchar* tracker_utils_FormatFileSize (gint64 size);
void tracker_metadata_tile_SetLabelUrnValue (TrackerMetadataTile* self, GtkLabel* label, const gchar* val);
static Categories tracker_metadata_tile_GetCategory (TrackerMetadataTile* self, const gchar* uri);
TrackerQuery* tracker_metadata_tile_get_Query (TrackerMetadataTile* self);
gchar** tracker_query_Query (TrackerQuery* self, const gchar* sparql, int* result_length1, int* result_length2);
static void tracker_metadata_tile_DisplayFileDetails (TrackerMetadataTile* self, const gchar* uri, const gchar* mime);
static void tracker_metadata_tile_DisplayImageDetails (TrackerMetadataTile* self, const gchar* uri);
static void tracker_metadata_tile_DisplayAudioDetails (TrackerMetadataTile* self, const gchar* uri);
static void tracker_metadata_tile_DisplayVideoDetails (TrackerMetadataTile* self, const gchar* uri);
static void tracker_metadata_tile_DisplayEmailDetails (TrackerMetadataTile* self, const gchar* uri);
static void tracker_metadata_tile_DisplayDocumentDetails (TrackerMetadataTile* self, const gchar* uri);
static void tracker_metadata_tile_DisplayApplicationDetails (TrackerMetadataTile* self, const gchar* uri);
void tracker_metadata_tile_LoadUri (TrackerMetadataTile* self, GtkTreePath* path);
GType result_columns_get_type (void) G_GNUC_CONST;
TrackerMetadataTile* tracker_metadata_tile_new (void);
TrackerMetadataTile* tracker_metadata_tile_construct (GType object_type);
void tracker_metadata_tile_set_Query (TrackerMetadataTile* self, TrackerQuery* value);
TrackerResultGrid* tracker_metadata_tile_get_ResultGrid (TrackerMetadataTile* self);
void tracker_metadata_tile_set_ResultGrid (TrackerMetadataTile* self, TrackerResultGrid* value);
static void _lambda6_ (GtkTreePath* path, TrackerMetadataTile* self);
static void __lambda6__tracker_result_grid_selection_changed (TrackerResultGrid* _sender, GtkTreePath* path, gpointer self);
static GObject * tracker_metadata_tile_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gboolean _tracker_metadata_tile_expose_gtk_widget_expose_event (TrackerMetadataTile* _sender, GdkEventExpose* event, gpointer self);
static void tracker_metadata_tile_finalize (GObject* obj);
static void _vala_tracker_metadata_tile_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_tracker_metadata_tile_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean tracker_metadata_tile_expose (TrackerMetadataTile* self, GdkEventExpose* e) {
	gboolean result = FALSE;
	cairo_t* _tmp0_ = NULL;
	cairo_t* cr;
	GtkStyle* _tmp1_ = NULL;
	GtkStyle* _tmp2_;
	GtkStyle* style;
	GdkColor step1;
	GdkColor step2;
	gdouble w = 0.0;
	gdouble h = 0.0;
	cairo_pattern_t* _tmp3_ = NULL;
	cairo_pattern_t* pat;
	gboolean _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = gdk_cairo_create ((GdkDrawable*) ((GtkWidget*) self)->window);
	cr = _tmp0_;
	_tmp1_ = gtk_widget_get_style ((GtkWidget*) self);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	style = _tmp2_;
	step1 = style->bg[GTK_STATE_NORMAL];
	step2 = style->bg[GTK_STATE_SELECTED];
	w = (gdouble) ((GtkWidget*) self)->allocation.width;
	h = (gdouble) ((GtkWidget*) self)->allocation.height;
	cairo_set_operator (cr, CAIRO_OPERATOR_SOURCE);
	gdk_cairo_set_source_color (cr, &step1);
	cairo_paint (cr);
	cairo_move_to (cr, (gdouble) 0, (gdouble) 0);
	cairo_set_line_width (cr, 1.0);
	cairo_set_operator (cr, CAIRO_OPERATOR_OVER);
	_tmp3_ = cairo_pattern_create_linear (0.0, 0.0, 0.0, h);
	pat = _tmp3_;
	cairo_pattern_add_color_stop_rgba (pat, 0.0, step2.red / 65535.0, step2.green / 65535.0, step2.blue / 65535.0, 0.05);
	cairo_pattern_add_color_stop_rgba (pat, 1.0, step2.red / 65535.0, step2.green / 65535.0, step2.blue / 65535.0, 0.5);
	cairo_rectangle (cr, (gdouble) 0, (gdouble) 0, w, h);
	cairo_set_source (cr, pat);
	cairo_fill (cr);
	cairo_set_source_rgba (cr, step2.red / 65535.0, step2.green / 65535.0, step2.blue / 65535.0, 0.7);
	cairo_move_to (cr, (gdouble) 0, (gdouble) 0);
	cairo_line_to (cr, w, (gdouble) 0);
	cairo_stroke (cr);
	cairo_set_source_rgba (cr, 1.0, 1.0, 1.0, 0.5);
	cairo_move_to (cr, (gdouble) 0, (gdouble) 1);
	cairo_line_to (cr, w, (gdouble) 1);
	cairo_stroke (cr);
	_tmp4_ = GTK_WIDGET_CLASS (tracker_metadata_tile_parent_class)->expose_event ((GtkWidget*) GTK_EVENT_BOX (self), e);
	result = _tmp4_;
	_cairo_pattern_destroy0 (pat);
	_g_object_unref0 (style);
	_cairo_destroy0 (cr);
	return result;
}


static void tracker_metadata_tile_AttachToTable (TrackerMetadataTile* self, GtkLabel* lab, gint l, gint r, gint t, gint b, gboolean e) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (lab != NULL);
	if (e == TRUE) {
		gtk_table_attach (self->table, (GtkWidget*) lab, (guint) l, (guint) r, (guint) t, (guint) b, GTK_FILL | GTK_EXPAND, GTK_FILL, (guint) 0, (guint) 0);
	} else {
		gtk_table_attach (self->table, (GtkWidget*) lab, (guint) l, (guint) r, (guint) t, (guint) b, GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
	}
}


static GtkLabel* tracker_metadata_tile_CreateLabel (TrackerMetadataTile* self, const gchar* s, gboolean e) {
	GtkLabel* result = NULL;
	GtkLabel* _tmp0_ = NULL;
	GtkLabel* l;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (s != NULL, NULL);
	_tmp0_ = (GtkLabel*) gtk_label_new (s);
	l = g_object_ref_sink (_tmp0_);
	g_object_set ((GtkMisc*) l, "xalign", (gfloat) 0, NULL);
	gtk_label_set_use_markup (l, TRUE);
	if (e == TRUE) {
		gtk_label_set_ellipsize (l, PANGO_ELLIPSIZE_END);
	}
	result = l;
	return result;
}


void tracker_metadata_tile_ClearLabels (TrackerMetadataTile* self) {
	g_return_if_fail (self != NULL);
	gtk_label_set_text (self->info_value1, "");
	gtk_label_set_text (self->info_value2, "");
	gtk_label_set_text (self->info_value3, "");
	gtk_label_set_text (self->info_value4, "");
	gtk_label_set_text (self->info_value5, "");
	gtk_label_set_text (self->info_value6, "");
	gtk_label_set_text (self->info_label1, "Type:");
	gtk_label_set_text (self->info_label4, "");
	gtk_label_set_text (self->info_label5, "");
	gtk_label_set_text (self->info_label6, "");
	gtk_link_button_set_uri (self->name_link, "");
	gtk_button_set_label ((GtkButton*) self->name_link, "");
	gtk_link_button_set_uri (self->path_link, "");
	gtk_button_set_label ((GtkButton*) self->path_link, "");
	gtk_widget_set_sensitive ((GtkWidget*) self->name_link, FALSE);
	gtk_widget_show ((GtkWidget*) self->name_link);
	gtk_widget_set_sensitive ((GtkWidget*) self->path_link, FALSE);
	gtk_widget_show ((GtkWidget*) self->path_link);
	gtk_widget_show ((GtkWidget*) self->name_label);
	gtk_widget_show ((GtkWidget*) self->path_label);
	gtk_widget_show ((GtkWidget*) self->info_label1);
	gtk_widget_show ((GtkWidget*) self->info_label2);
	gtk_widget_show ((GtkWidget*) self->info_label3);
}


void tracker_metadata_tile_SetLabelValue (TrackerMetadataTile* self, GtkLabel* label, const gchar* val) {
	gchar* _tmp0_ = NULL;
	gchar* val1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (label != NULL);
	g_return_if_fail (val != NULL);
	_tmp0_ = g_strdup_printf ("<b>%s</b>", val);
	val1 = _tmp0_;
	gtk_label_set_markup (label, val1);
	g_object_set ((GtkMisc*) label, "xalign", (gfloat) 0, NULL);
	_g_free0 (val1);
}


void tracker_metadata_tile_SetLabelSizeValue (TrackerMetadataTile* self, GtkLabel* label, gint64 size) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* val1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (label != NULL);
	_tmp0_ = tracker_utils_FormatFileSize (size);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("<b>%s</b>", _tmp1_);
	val1 = (_tmp3_ = _tmp2_, _g_free0 (_tmp1_), _tmp3_);
	gtk_label_set_markup (label, val1);
	g_object_set ((GtkMisc*) label, "xalign", (gfloat) 0, NULL);
	_g_free0 (val1);
}


void tracker_metadata_tile_SetLabelUrnValue (TrackerMetadataTile* self, GtkLabel* label, const gchar* val) {
	gchar* _tmp0_;
	gchar* value;
	gchar** _tmp1_;
	gchar** _tmp2_ = NULL;
	gint values_length1;
	gint _values_size_;
	gchar** _tmp3_;
	gchar** values;
	gchar** _tmp7_;
	gchar** _tmp8_ = NULL;
	gint escapes_length1;
	gint _escapes_size_;
	gchar** _tmp9_;
	gchar** escapes;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp15_ = NULL;
	gchar* val1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (label != NULL);
	g_return_if_fail (val != NULL);
	_tmp0_ = g_strdup (val);
	value = _tmp0_;
	_tmp2_ = _tmp1_ = g_strsplit (val, ":", 0);
	_tmp3_ = _tmp2_;
	values_length1 = _vala_array_length (_tmp1_);
	_values_size_ = values_length1;
	values = _tmp3_;
	{
		gchar** s_collection;
		int s_collection_length1;
		int s_it;
		s_collection = values;
		s_collection_length1 = values_length1;
		for (s_it = 0; s_it < values_length1; s_it = s_it + 1) {
			gchar* _tmp4_;
			gchar* s;
			_tmp4_ = g_strdup (s_collection[s_it]);
			s = _tmp4_;
			{
				gchar* _tmp5_;
				gchar* _tmp6_;
				_tmp5_ = g_strdup (s);
				_tmp6_ = _tmp5_;
				_g_free0 (value);
				value = _tmp6_;
				_g_free0 (s);
			}
		}
	}
	_tmp8_ = _tmp7_ = g_strsplit (value, "%20", 0);
	_tmp9_ = _tmp8_;
	escapes_length1 = _vala_array_length (_tmp7_);
	_escapes_size_ = escapes_length1;
	escapes = _tmp9_;
	_tmp10_ = g_strdup ("");
	_tmp11_ = _tmp10_;
	_g_free0 (value);
	value = _tmp11_;
	{
		gchar** s_collection;
		int s_collection_length1;
		int s_it;
		s_collection = escapes;
		s_collection_length1 = escapes_length1;
		for (s_it = 0; s_it < escapes_length1; s_it = s_it + 1) {
			gchar* _tmp12_;
			gchar* s;
			_tmp12_ = g_strdup (s_collection[s_it]);
			s = _tmp12_;
			{
				gchar* _tmp13_;
				gchar* _tmp14_;
				_tmp13_ = g_strconcat (s, " ", NULL);
				_tmp14_ = g_strconcat (value, _tmp13_, NULL);
				_g_free0 (value);
				value = _tmp14_;
				_g_free0 (_tmp13_);
				_g_free0 (s);
			}
		}
	}
	_tmp15_ = g_strdup_printf ("<b>%s</b>", value);
	val1 = _tmp15_;
	gtk_label_set_markup (label, val1);
	g_object_set ((GtkMisc*) label, "xalign", (gfloat) 0, NULL);
	_g_free0 (val1);
	escapes = (_vala_array_free (escapes, escapes_length1, (GDestroyNotify) g_free), NULL);
	values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (value);
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr (self, needle);
	result = _tmp0_ != NULL;
	return result;
}


static Categories tracker_metadata_tile_GetCategory (TrackerMetadataTile* self, const gchar* uri) {
	Categories result = 0;
	gchar* _tmp0_ = NULL;
	gchar* query;
	gint _tmp1_;
	gint _tmp2_;
	gchar** _tmp3_ = NULL;
	gint results_length1;
	gint results_length2;
	gchar** _tmp4_;
	gchar** results;
	gchar* _tmp5_;
	gchar* res;
	gboolean _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	gboolean _tmp14_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (uri != NULL, 0);
	_tmp0_ = g_strdup_printf ("SELECT rdf:type(?s) WHERE { ?s nie:url \"%s\" }", uri);
	query = _tmp0_;
	_tmp3_ = tracker_query_Query (self->priv->_Query, query, &_tmp1_, &_tmp2_);
	_tmp4_ = _tmp3_;
	results_length1 = _tmp1_;
	results_length2 = _tmp2_;
	results = _tmp4_;
	_tmp5_ = g_strdup ("");
	res = _tmp5_;
	if (results == NULL) {
		g_print ("Query result is null!\n");
	} else {
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp6_ = g_strdup (results[0]);
		_tmp7_ = _tmp6_;
		_g_free0 (res);
		res = _tmp7_;
	}
	_tmp8_ = string_contains (res, "nfo#Video");
	if (_tmp8_) {
		result = CATEGORIES_Video;
		_g_free0 (res);
		results = (_vala_array_free (results, results_length1 * results_length2, (GDestroyNotify) g_free), NULL);
		_g_free0 (query);
		return result;
	}
	_tmp9_ = string_contains (res, "nfo#Image");
	if (_tmp9_) {
		result = CATEGORIES_Image;
		_g_free0 (res);
		results = (_vala_array_free (results, results_length1 * results_length2, (GDestroyNotify) g_free), NULL);
		_g_free0 (query);
		return result;
	}
	_tmp10_ = string_contains (res, "nfo#Audio");
	if (_tmp10_) {
		result = CATEGORIES_Audio;
		_g_free0 (res);
		results = (_vala_array_free (results, results_length1 * results_length2, (GDestroyNotify) g_free), NULL);
		_g_free0 (query);
		return result;
	}
	_tmp11_ = string_contains (res, "nmo#Email");
	if (_tmp11_) {
		result = CATEGORIES_Email;
		_g_free0 (res);
		results = (_vala_array_free (results, results_length1 * results_length2, (GDestroyNotify) g_free), NULL);
		_g_free0 (query);
		return result;
	}
	_tmp12_ = string_contains (res, "nfo#Document");
	if (_tmp12_) {
		result = CATEGORIES_Document;
		_g_free0 (res);
		results = (_vala_array_free (results, results_length1 * results_length2, (GDestroyNotify) g_free), NULL);
		_g_free0 (query);
		return result;
	}
	_tmp13_ = string_contains (res, "nfo#Software");
	if (_tmp13_) {
		result = CATEGORIES_Application;
		_g_free0 (res);
		results = (_vala_array_free (results, results_length1 * results_length2, (GDestroyNotify) g_free), NULL);
		_g_free0 (query);
		return result;
	}
	_tmp14_ = string_contains (res, "nfo#Folder");
	if (_tmp14_) {
		result = CATEGORIES_Folder;
		_g_free0 (res);
		results = (_vala_array_free (results, results_length1 * results_length2, (GDestroyNotify) g_free), NULL);
		_g_free0 (query);
		return result;
	}
	result = CATEGORIES_File;
	_g_free0 (res);
	results = (_vala_array_free (results, results_length1 * results_length2, (GDestroyNotify) g_free), NULL);
	_g_free0 (query);
	return result;
}


static void tracker_metadata_tile_DisplayFileDetails (TrackerMetadataTile* self, const gchar* uri, const gchar* mime) {
	GFile* _tmp0_ = NULL;
	GFile* file;
	GFile* _tmp1_ = NULL;
	GFile* displaypath;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	GtkLabel* link_label;
	GtkWidget* _tmp6_ = NULL;
	GtkLabel* _tmp7_;
	GtkLabel* _tmp8_;
	GtkWidget* _tmp9_ = NULL;
	GtkLabel* _tmp10_;
	GtkLabel* _tmp11_;
	GFileInfo* _tmp12_ = NULL;
	GFileInfo* info;
	gint64 _tmp13_;
	const gchar* _tmp14_ = NULL;
	GTimeVal tm = {0};
	GTimeVal _tmp15_ = {0};
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_;
	gchar* val3;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	g_return_if_fail (mime != NULL);
	_tmp0_ = g_file_new_for_uri (uri);
	file = _tmp0_;
	_tmp1_ = g_file_get_parent (file);
	displaypath = _tmp1_;
	gtk_link_button_set_uri (self->name_link, uri);
	_tmp2_ = g_file_get_uri (displaypath);
	_tmp3_ = _tmp2_;
	gtk_link_button_set_uri (self->path_link, _tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = g_file_get_parse_name (displaypath);
	_tmp5_ = _tmp4_;
	gtk_button_set_label ((GtkButton*) self->path_link, _tmp5_);
	_g_free0 (_tmp5_);
	link_label = NULL;
	_tmp6_ = gtk_bin_get_child ((GtkBin*) self->path_link);
	_tmp7_ = _g_object_ref0 (GTK_LABEL (_tmp6_));
	_tmp8_ = _tmp7_;
	_g_object_unref0 (link_label);
	link_label = _tmp8_;
	gtk_label_set_ellipsize (link_label, PANGO_ELLIPSIZE_MIDDLE);
	_tmp9_ = gtk_bin_get_child ((GtkBin*) self->name_link);
	_tmp10_ = _g_object_ref0 (GTK_LABEL (_tmp9_));
	_tmp11_ = _tmp10_;
	_g_object_unref0 (link_label);
	link_label = _tmp11_;
	gtk_label_set_ellipsize (link_label, PANGO_ELLIPSIZE_MIDDLE);
	if (mime != NULL) {
		tracker_metadata_tile_SetLabelValue (self, self->info_value1, mime);
	}
	_tmp12_ = g_file_query_info (file, "standard::size,time::modified,standard::display-name", G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
	info = _tmp12_;
	if (_inner_error_ != NULL) {
		goto __catch9_g_error;
	}
	_tmp13_ = g_file_info_get_size (info);
	tracker_metadata_tile_SetLabelSizeValue (self, self->info_value2, _tmp13_);
	_tmp14_ = g_file_info_get_display_name (info);
	gtk_button_set_label ((GtkButton*) self->name_link, _tmp14_);
	g_file_info_get_modification_time (info, &_tmp15_);
	tm = _tmp15_;
	_tmp16_ = g_time_val_to_iso8601 (&tm);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_strdup_printf ("<b>%s</b>", _tmp17_);
	val3 = (_tmp19_ = _tmp18_, _g_free0 (_tmp17_), _tmp19_);
	gtk_label_set_markup (self->info_value3, val3);
	_g_free0 (val3);
	_g_object_unref0 (info);
	goto __finally9;
	__catch9_g_error:
	{
		GError * e;
		gchar* _tmp20_ = NULL;
		gchar* filepath;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp20_ = g_file_get_basename (file);
		filepath = _tmp20_;
		gtk_button_set_label ((GtkButton*) self->name_link, filepath);
		g_print ("Could not get file info for %s\n", uri);
		_g_free0 (filepath);
		_g_error_free0 (e);
	}
	__finally9:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (link_label);
		_g_object_unref0 (displaypath);
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (link_label);
	_g_object_unref0 (displaypath);
	_g_object_unref0 (file);
}


static void tracker_metadata_tile_DisplayImageDetails (TrackerMetadataTile* self, const gchar* uri) {
	gchar* _tmp0_ = NULL;
	gchar* query;
	gint _tmp1_;
	gint _tmp2_;
	gchar** _tmp3_ = NULL;
	gint _result__length1;
	gint _result__length2;
	gchar** _tmp4_;
	gchar** _result_;
	gboolean _tmp5_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	_tmp0_ = g_strdup_printf ("SELECT nfo:height(?s) nfo:width(?s) WHERE { ?s nie:url \"%s\" }", uri);
	query = _tmp0_;
	_tmp3_ = tracker_query_Query (self->priv->_Query, query, &_tmp1_, &_tmp2_);
	_tmp4_ = _tmp3_;
	_result__length1 = _tmp1_;
	_result__length2 = _tmp2_;
	_result_ = _tmp4_;
	gtk_label_set_text (self->info_label4, "Height:");
	gtk_label_set_text (self->info_label5, "Width:");
	if (_result_ == NULL) {
		_tmp5_ = TRUE;
	} else {
		_tmp5_ = _result_[0] == NULL;
	}
	if (_tmp5_) {
		_result_ = (_vala_array_free (_result_, _result__length1 * _result__length2, (GDestroyNotify) g_free), NULL);
		_g_free0 (query);
		return;
	}
	tracker_metadata_tile_SetLabelValue (self, self->info_value4, _result_[0]);
	tracker_metadata_tile_SetLabelValue (self, self->info_value5, _result_[1]);
	_result_ = (_vala_array_free (_result_, _result__length1 * _result__length2, (GDestroyNotify) g_free), NULL);
	_g_free0 (query);
}


static void tracker_metadata_tile_DisplayAudioDetails (TrackerMetadataTile* self, const gchar* uri) {
	gchar* _tmp0_ = NULL;
	gchar* query;
	gint _tmp1_;
	gint _tmp2_;
	gchar** _tmp3_ = NULL;
	gint _result__length1;
	gint _result__length2;
	gchar** _tmp4_;
	gchar** _result_;
	gboolean _tmp5_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	_tmp0_ = g_strdup_printf ("SELECT nie:title(?s) nmm:performer(?s) nmm:musicAlbum(?s) WHERE { ?s n" \
"ie:url \"%s\" }", uri);
	query = _tmp0_;
	_tmp3_ = tracker_query_Query (self->priv->_Query, query, &_tmp1_, &_tmp2_);
	_tmp4_ = _tmp3_;
	_result__length1 = _tmp1_;
	_result__length2 = _tmp2_;
	_result_ = _tmp4_;
	gtk_label_set_text (self->info_label4, "Title:");
	gtk_label_set_text (self->info_label5, "Artist:");
	gtk_label_set_text (self->info_label6, "Album:");
	if (_result_ == NULL) {
		_tmp5_ = TRUE;
	} else {
		_tmp5_ = _result_[0] == NULL;
	}
	if (_tmp5_) {
		_result_ = (_vala_array_free (_result_, _result__length1 * _result__length2, (GDestroyNotify) g_free), NULL);
		_g_free0 (query);
		return;
	}
	tracker_metadata_tile_SetLabelValue (self, self->info_value4, _result_[0]);
	tracker_metadata_tile_SetLabelUrnValue (self, self->info_value5, _result_[1]);
	tracker_metadata_tile_SetLabelUrnValue (self, self->info_value6, _result_[2]);
	_result_ = (_vala_array_free (_result_, _result__length1 * _result__length2, (GDestroyNotify) g_free), NULL);
	_g_free0 (query);
}


static void tracker_metadata_tile_DisplayVideoDetails (TrackerMetadataTile* self, const gchar* uri) {
	gchar* _tmp0_ = NULL;
	gchar* query;
	gint _tmp1_;
	gint _tmp2_;
	gchar** _tmp3_ = NULL;
	gint _result__length1;
	gint _result__length2;
	gchar** _tmp4_;
	gchar** _result_;
	gboolean _tmp5_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	_tmp0_ = g_strdup_printf ("SELECT nfo:height(?s) nfo:width(?s) nfo:duration (?s) WHERE { ?s nie:u" \
"rl \"%s\" }", uri);
	query = _tmp0_;
	_tmp3_ = tracker_query_Query (self->priv->_Query, query, &_tmp1_, &_tmp2_);
	_tmp4_ = _tmp3_;
	_result__length1 = _tmp1_;
	_result__length2 = _tmp2_;
	_result_ = _tmp4_;
	gtk_label_set_text (self->info_label4, "Height:");
	gtk_label_set_text (self->info_label5, "Width:");
	gtk_label_set_text (self->info_label6, "Duration:");
	if (_result_ == NULL) {
		_tmp5_ = TRUE;
	} else {
		_tmp5_ = _result_[0] == NULL;
	}
	if (_tmp5_) {
		_result_ = (_vala_array_free (_result_, _result__length1 * _result__length2, (GDestroyNotify) g_free), NULL);
		_g_free0 (query);
		return;
	}
	tracker_metadata_tile_SetLabelValue (self, self->info_value4, _result_[0]);
	tracker_metadata_tile_SetLabelValue (self, self->info_value5, _result_[1]);
	tracker_metadata_tile_SetLabelValue (self, self->info_value6, _result_[2]);
	_result_ = (_vala_array_free (_result_, _result__length1 * _result__length2, (GDestroyNotify) g_free), NULL);
	_g_free0 (query);
}


static void tracker_metadata_tile_DisplayEmailDetails (TrackerMetadataTile* self, const gchar* uri) {
	gchar* _tmp0_ = NULL;
	gchar* query;
	gint _tmp1_;
	gint _tmp2_;
	gchar** _tmp3_ = NULL;
	gint _result__length1;
	gint _result__length2;
	gchar** _tmp4_;
	gchar** _result_;
	gboolean _tmp5_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	_tmp0_ = g_strdup_printf ("SELECT nmo:messageSubject(?e) nco:fullname(?s) nmo:receivedDate(?e) WH" \
"ERE { ?e nie:url \"%s\" ; nmo:from ?s }", uri);
	query = _tmp0_;
	_tmp3_ = tracker_query_Query (self->priv->_Query, query, &_tmp1_, &_tmp2_);
	_tmp4_ = _tmp3_;
	_result__length1 = _tmp1_;
	_result__length2 = _tmp2_;
	_result_ = _tmp4_;
	gtk_widget_hide ((GtkWidget*) self->name_label);
	gtk_widget_hide ((GtkWidget*) self->name_link);
	gtk_widget_hide ((GtkWidget*) self->path_link);
	gtk_widget_hide ((GtkWidget*) self->path_label);
	gtk_widget_hide ((GtkWidget*) self->info_label2);
	gtk_label_set_text (self->info_label1, "Subject:");
	gtk_label_set_text (self->info_label4, "From:");
	gtk_label_set_text (self->info_label3, "Received:");
	if (_result_ == NULL) {
		_tmp5_ = TRUE;
	} else {
		_tmp5_ = _result_[0] == NULL;
	}
	if (_tmp5_) {
		_result_ = (_vala_array_free (_result_, _result__length1 * _result__length2, (GDestroyNotify) g_free), NULL);
		_g_free0 (query);
		return;
	}
	tracker_metadata_tile_SetLabelValue (self, self->info_value1, _result_[0]);
	tracker_metadata_tile_SetLabelValue (self, self->info_value4, _result_[1]);
	tracker_metadata_tile_SetLabelValue (self, self->info_value3, _result_[2]);
	_result_ = (_vala_array_free (_result_, _result__length1 * _result__length2, (GDestroyNotify) g_free), NULL);
	_g_free0 (query);
}


static void tracker_metadata_tile_DisplayDocumentDetails (TrackerMetadataTile* self, const gchar* uri) {
	gchar* _tmp0_ = NULL;
	gchar* query;
	gint _tmp1_;
	gint _tmp2_;
	gchar** _tmp3_ = NULL;
	gint _result__length1;
	gint _result__length2;
	gchar** _tmp4_;
	gchar** _result_;
	gboolean _tmp5_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	_tmp0_ = g_strdup_printf ("SELECT nie:title(?s) nco:fullname(?c) nfo:pageCount(?s) WHERE { ?s nie" \
":url \"%s\" ; nco:creator ?c }", uri);
	query = _tmp0_;
	_tmp3_ = tracker_query_Query (self->priv->_Query, query, &_tmp1_, &_tmp2_);
	_tmp4_ = _tmp3_;
	_result__length1 = _tmp1_;
	_result__length2 = _tmp2_;
	_result_ = _tmp4_;
	gtk_label_set_text (self->info_label4, "Title:");
	gtk_label_set_text (self->info_label5, "Author:");
	gtk_label_set_text (self->info_label6, "Page count:");
	if (_result_ == NULL) {
		_tmp5_ = TRUE;
	} else {
		_tmp5_ = _result_[0] == NULL;
	}
	if (_tmp5_) {
		_result_ = (_vala_array_free (_result_, _result__length1 * _result__length2, (GDestroyNotify) g_free), NULL);
		_g_free0 (query);
		return;
	}
	tracker_metadata_tile_SetLabelValue (self, self->info_value4, _result_[0]);
	tracker_metadata_tile_SetLabelValue (self, self->info_value5, _result_[1]);
	tracker_metadata_tile_SetLabelValue (self, self->info_value6, _result_[2]);
	_result_ = (_vala_array_free (_result_, _result__length1 * _result__length2, (GDestroyNotify) g_free), NULL);
	_g_free0 (query);
}


static void tracker_metadata_tile_DisplayApplicationDetails (TrackerMetadataTile* self, const gchar* uri) {
	GAppInfo* app_info;
	GFile* _tmp0_ = NULL;
	GFile* file;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	GDesktopAppInfo* _tmp3_ = NULL;
	GAppInfo* _tmp4_;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* description;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	app_info = NULL;
	_tmp0_ = g_file_new_for_uri (uri);
	file = _tmp0_;
	_tmp1_ = g_file_get_path (file);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_desktop_app_info_new_from_filename (_tmp2_);
	_tmp4_ = (GAppInfo*) _tmp3_;
	_g_object_unref0 (app_info);
	app_info = _tmp4_;
	_g_free0 (_tmp2_);
	if (app_info == NULL) {
		tracker_metadata_tile_DisplayFileDetails (self, uri, "");
		_g_object_unref0 (file);
		_g_object_unref0 (app_info);
		return;
	}
	gtk_widget_set_sensitive ((GtkWidget*) self->path_link, FALSE);
	gtk_widget_hide ((GtkWidget*) self->path_label);
	gtk_widget_hide ((GtkWidget*) self->info_label2);
	gtk_widget_hide ((GtkWidget*) self->info_label3);
	gtk_link_button_set_uri (self->name_link, uri);
	_tmp5_ = g_app_info_get_display_name (app_info);
	gtk_button_set_label ((GtkButton*) self->name_link, _tmp5_);
	gtk_label_set_text (self->info_label1, "Description:");
	_tmp6_ = g_app_info_get_description (app_info);
	_tmp7_ = g_strdup (_tmp6_);
	description = _tmp7_;
	if (description != NULL) {
		tracker_metadata_tile_SetLabelValue (self, self->info_value1, description);
	}
	_g_free0 (description);
	_g_object_unref0 (file);
	_g_object_unref0 (app_info);
}


void tracker_metadata_tile_LoadUri (TrackerMetadataTile* self, GtkTreePath* path) {
	GtkTreeIter iter = {0};
	const gchar* id;
	const gchar* uri;
	const gchar* mime;
	GdkPixbuf* icon;
	GtkTreeIter _tmp0_ = {0};
	Categories _tmp1_;
	Categories cat;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	tracker_metadata_tile_ClearLabels (self);
	if (path == NULL) {
		gtk_image_set_from_icon_name (self->image, "text-x-generic", GTK_ICON_SIZE_DIALOG);
		return;
	}
	gtk_widget_set_sensitive ((GtkWidget*) self->name_link, TRUE);
	gtk_widget_set_sensitive ((GtkWidget*) self->path_link, TRUE);
	id = NULL;
	uri = NULL;
	mime = NULL;
	icon = NULL;
	gtk_tree_model_get_iter ((GtkTreeModel*) self->priv->_result_grid->store, &_tmp0_, path);
	iter = _tmp0_;
	gtk_tree_model_get ((GtkTreeModel*) self->priv->_result_grid->store, &iter, RESULT_COLUMNS_Id, &id, RESULT_COLUMNS_Uri, &uri, RESULT_COLUMNS_Mime, &mime, RESULT_COLUMNS_Icon, &icon, -1);
	gtk_image_set_from_pixbuf (self->image, icon);
	_tmp1_ = tracker_metadata_tile_GetCategory (self, uri);
	cat = _tmp1_;
	if (cat != CATEGORIES_Application) {
		_tmp2_ = cat != CATEGORIES_Email;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		tracker_metadata_tile_DisplayFileDetails (self, uri, mime);
	}
	switch (cat) {
		case CATEGORIES_Audio:
		{
			tracker_metadata_tile_DisplayAudioDetails (self, uri);
			break;
		}
		case CATEGORIES_Video:
		{
			tracker_metadata_tile_DisplayVideoDetails (self, uri);
			break;
		}
		case CATEGORIES_Image:
		{
			tracker_metadata_tile_DisplayImageDetails (self, uri);
			break;
		}
		case CATEGORIES_Email:
		{
			tracker_metadata_tile_DisplayEmailDetails (self, uri);
			break;
		}
		case CATEGORIES_Document:
		{
			tracker_metadata_tile_DisplayDocumentDetails (self, uri);
			break;
		}
		case CATEGORIES_Application:
		{
			tracker_metadata_tile_DisplayApplicationDetails (self, uri);
			break;
		}
		default:
		{
			_g_object_unref0 (icon);
			return;
			break;
		}
	}
	_g_object_unref0 (icon);
}


TrackerMetadataTile* tracker_metadata_tile_construct (GType object_type) {
	TrackerMetadataTile * self = NULL;
	self = (TrackerMetadataTile*) g_object_new (object_type, NULL);
	return self;
}


TrackerMetadataTile* tracker_metadata_tile_new (void) {
	return tracker_metadata_tile_construct (TYPE_TRACKER_METADATA_TILE);
}


TrackerQuery* tracker_metadata_tile_get_Query (TrackerMetadataTile* self) {
	TrackerQuery* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_Query;
	return result;
}


void tracker_metadata_tile_set_Query (TrackerMetadataTile* self, TrackerQuery* value) {
	g_return_if_fail (self != NULL);
	self->priv->_Query = value;
	g_object_notify ((GObject *) self, "Query");
}


TrackerResultGrid* tracker_metadata_tile_get_ResultGrid (TrackerMetadataTile* self) {
	TrackerResultGrid* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_result_grid;
	return result;
}


static void _lambda6_ (GtkTreePath* path, TrackerMetadataTile* self) {
	tracker_metadata_tile_LoadUri (self, path);
}


static void __lambda6__tracker_result_grid_selection_changed (TrackerResultGrid* _sender, GtkTreePath* path, gpointer self) {
	_lambda6_ (path, self);
}


void tracker_metadata_tile_set_ResultGrid (TrackerMetadataTile* self, TrackerResultGrid* value) {
	g_return_if_fail (self != NULL);
	if (value != NULL) {
		TrackerResultGrid* _tmp0_;
		TrackerResultGrid* _tmp1_;
		_tmp0_ = _g_object_ref0 (value);
		_tmp1_ = _tmp0_;
		_g_object_unref0 (self->priv->_result_grid);
		self->priv->_result_grid = _tmp1_;
		g_signal_connect_object (self->priv->_result_grid, "selection-changed", (GCallback) __lambda6__tracker_result_grid_selection_changed, self, 0);
	}
	g_object_notify ((GObject *) self, "ResultGrid");
}


static gboolean _tracker_metadata_tile_expose_gtk_widget_expose_event (TrackerMetadataTile* _sender, GdkEventExpose* event, gpointer self) {
	gboolean result;
	result = tracker_metadata_tile_expose (self, event);
	return result;
}


static GObject * tracker_metadata_tile_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	TrackerMetadataTile * self;
	GtkTable* _tmp0_ = NULL;
	GtkTable* _tmp1_;
	GtkImage* _tmp2_ = NULL;
	GtkImage* _tmp3_;
	GtkLinkButton* _tmp4_ = NULL;
	GtkLinkButton* _tmp5_;
	GtkLabel* _tmp6_ = NULL;
	GtkLabel* _tmp7_;
	GtkLinkButton* _tmp8_ = NULL;
	GtkLinkButton* _tmp9_;
	GtkLabel* _tmp10_ = NULL;
	GtkLabel* _tmp11_;
	GtkLabel* _tmp12_ = NULL;
	GtkLabel* _tmp13_;
	GtkLabel* _tmp14_ = NULL;
	GtkLabel* _tmp15_;
	GtkLabel* _tmp16_ = NULL;
	GtkLabel* _tmp17_;
	GtkLabel* _tmp18_ = NULL;
	GtkLabel* _tmp19_;
	GtkLabel* _tmp20_ = NULL;
	GtkLabel* _tmp21_;
	GtkLabel* _tmp22_ = NULL;
	GtkLabel* _tmp23_;
	GtkLabel* _tmp24_ = NULL;
	GtkLabel* _tmp25_;
	GtkLabel* _tmp26_ = NULL;
	GtkLabel* _tmp27_;
	GtkLabel* _tmp28_ = NULL;
	GtkLabel* _tmp29_;
	GtkLabel* _tmp30_ = NULL;
	GtkLabel* _tmp31_;
	GtkLabel* _tmp32_ = NULL;
	GtkLabel* _tmp33_;
	GtkLabel* _tmp34_ = NULL;
	GtkLabel* _tmp35_;
	parent_class = G_OBJECT_CLASS (tracker_metadata_tile_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = TRACKER_METADATA_TILE (obj);
	gtk_widget_set_app_paintable ((GtkWidget*) self, TRUE);
	g_signal_connect_object ((GtkWidget*) self, "expose-event", (GCallback) _tracker_metadata_tile_expose_gtk_widget_expose_event, self, 0);
	gtk_container_set_border_width ((GtkContainer*) self, (guint) 0);
	_tmp0_ = (GtkTable*) gtk_table_new ((guint) 5, (guint) 7, FALSE);
	_tmp1_ = g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->table);
	self->table = _tmp1_;
	gtk_table_set_col_spacings (self->table, (guint) 3);
	gtk_table_set_row_spacings (self->table, (guint) 3);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) self->table);
	_tmp2_ = (GtkImage*) gtk_image_new_from_icon_name ("text-x-generic", GTK_ICON_SIZE_DIALOG);
	_tmp3_ = g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->image);
	self->image = _tmp3_;
	gtk_image_set_pixel_size (self->image, 75);
	gtk_table_attach (self->table, (GtkWidget*) self->image, (guint) 0, (guint) 1, (guint) 0, (guint) 5, GTK_FILL, GTK_FILL, (guint) 12, (guint) 0);
	_tmp4_ = (GtkLinkButton*) gtk_link_button_new ("");
	_tmp5_ = g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->name_link);
	self->name_link = _tmp5_;
	g_object_set ((GtkButton*) self->name_link, "xalign", (gfloat) 0, NULL);
	_tmp6_ = tracker_metadata_tile_CreateLabel (self, "Name:", FALSE);
	_tmp7_ = _tmp6_;
	_g_object_unref0 (self->name_label);
	self->name_label = _tmp7_;
	tracker_metadata_tile_AttachToTable (self, self->name_label, 1, 2, 0, 1, FALSE);
	gtk_table_attach (self->table, (GtkWidget*) self->name_link, (guint) 2, (guint) 3, (guint) 0, (guint) 1, GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
	_tmp8_ = (GtkLinkButton*) gtk_link_button_new ("");
	_tmp9_ = g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->path_link);
	self->path_link = _tmp9_;
	g_object_set ((GtkButton*) self->path_link, "xalign", (gfloat) 0, NULL);
	_tmp10_ = tracker_metadata_tile_CreateLabel (self, "Folder:", FALSE);
	_tmp11_ = _tmp10_;
	_g_object_unref0 (self->path_label);
	self->path_label = _tmp11_;
	tracker_metadata_tile_AttachToTable (self, self->path_label, 3, 4, 0, 1, FALSE);
	gtk_table_attach (self->table, (GtkWidget*) self->path_link, (guint) 4, (guint) 7, (guint) 0, (guint) 1, GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
	_tmp12_ = tracker_metadata_tile_CreateLabel (self, "Type:", FALSE);
	_tmp13_ = _tmp12_;
	_g_object_unref0 (self->info_label1);
	self->info_label1 = _tmp13_;
	tracker_metadata_tile_AttachToTable (self, self->info_label1, 1, 2, 1, 2, FALSE);
	_tmp14_ = tracker_metadata_tile_CreateLabel (self, "-", TRUE);
	_tmp15_ = _tmp14_;
	_g_object_unref0 (self->info_value1);
	self->info_value1 = _tmp15_;
	tracker_metadata_tile_AttachToTable (self, self->info_value1, 2, 3, 1, 2, TRUE);
	_tmp16_ = tracker_metadata_tile_CreateLabel (self, "Size:", FALSE);
	_tmp17_ = _tmp16_;
	_g_object_unref0 (self->info_label2);
	self->info_label2 = _tmp17_;
	tracker_metadata_tile_AttachToTable (self, self->info_label2, 3, 4, 1, 2, FALSE);
	_tmp18_ = tracker_metadata_tile_CreateLabel (self, "-", TRUE);
	_tmp19_ = _tmp18_;
	_g_object_unref0 (self->info_value2);
	self->info_value2 = _tmp19_;
	tracker_metadata_tile_AttachToTable (self, self->info_value2, 4, 5, 1, 2, TRUE);
	_tmp20_ = tracker_metadata_tile_CreateLabel (self, "Modified:", FALSE);
	_tmp21_ = _tmp20_;
	_g_object_unref0 (self->info_label3);
	self->info_label3 = _tmp21_;
	tracker_metadata_tile_AttachToTable (self, self->info_label3, 5, 6, 1, 2, FALSE);
	_tmp22_ = tracker_metadata_tile_CreateLabel (self, "-", TRUE);
	_tmp23_ = _tmp22_;
	_g_object_unref0 (self->info_value3);
	self->info_value3 = _tmp23_;
	tracker_metadata_tile_AttachToTable (self, self->info_value3, 6, 7, 1, 2, TRUE);
	_tmp24_ = tracker_metadata_tile_CreateLabel (self, "", FALSE);
	_tmp25_ = _tmp24_;
	_g_object_unref0 (self->info_label4);
	self->info_label4 = _tmp25_;
	tracker_metadata_tile_AttachToTable (self, self->info_label4, 1, 2, 2, 3, FALSE);
	_tmp26_ = tracker_metadata_tile_CreateLabel (self, "-", TRUE);
	_tmp27_ = _tmp26_;
	_g_object_unref0 (self->info_value4);
	self->info_value4 = _tmp27_;
	tracker_metadata_tile_AttachToTable (self, self->info_value4, 2, 3, 2, 3, TRUE);
	_tmp28_ = tracker_metadata_tile_CreateLabel (self, "", FALSE);
	_tmp29_ = _tmp28_;
	_g_object_unref0 (self->info_label5);
	self->info_label5 = _tmp29_;
	tracker_metadata_tile_AttachToTable (self, self->info_label5, 3, 4, 2, 3, FALSE);
	_tmp30_ = tracker_metadata_tile_CreateLabel (self, "-", TRUE);
	_tmp31_ = _tmp30_;
	_g_object_unref0 (self->info_value5);
	self->info_value5 = _tmp31_;
	tracker_metadata_tile_AttachToTable (self, self->info_value5, 4, 5, 2, 3, TRUE);
	_tmp32_ = tracker_metadata_tile_CreateLabel (self, "", FALSE);
	_tmp33_ = _tmp32_;
	_g_object_unref0 (self->info_label6);
	self->info_label6 = _tmp33_;
	tracker_metadata_tile_AttachToTable (self, self->info_label6, 5, 6, 2, 3, FALSE);
	_tmp34_ = tracker_metadata_tile_CreateLabel (self, "-", TRUE);
	_tmp35_ = _tmp34_;
	_g_object_unref0 (self->info_value6);
	self->info_value6 = _tmp35_;
	tracker_metadata_tile_AttachToTable (self, self->info_value6, 6, 7, 2, 3, TRUE);
	tracker_metadata_tile_ClearLabels (self);
	return obj;
}


static void tracker_metadata_tile_class_init (TrackerMetadataTileClass * klass) {
	tracker_metadata_tile_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TrackerMetadataTilePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_tracker_metadata_tile_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_tracker_metadata_tile_set_property;
	G_OBJECT_CLASS (klass)->constructor = tracker_metadata_tile_constructor;
	G_OBJECT_CLASS (klass)->finalize = tracker_metadata_tile_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_METADATA_TILE_QUERY, g_param_spec_object ("Query", "Query", "Query", TYPE_TRACKER_QUERY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_METADATA_TILE_RESULT_GRID, g_param_spec_object ("ResultGrid", "ResultGrid", "ResultGrid", TYPE_TRACKER_RESULT_GRID, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void tracker_metadata_tile_instance_init (TrackerMetadataTile * self) {
	self->priv = TRACKER_METADATA_TILE_GET_PRIVATE (self);
}


static void tracker_metadata_tile_finalize (GObject* obj) {
	TrackerMetadataTile * self;
	self = TRACKER_METADATA_TILE (obj);
	_g_free0 (self->uri);
	_g_object_unref0 (self->image);
	_g_object_unref0 (self->name_link);
	_g_object_unref0 (self->path_link);
	_g_object_unref0 (self->table);
	_g_object_unref0 (self->name_label);
	_g_object_unref0 (self->path_label);
	_g_object_unref0 (self->info_label1);
	_g_object_unref0 (self->info_value1);
	_g_object_unref0 (self->info_label2);
	_g_object_unref0 (self->info_value2);
	_g_object_unref0 (self->info_label3);
	_g_object_unref0 (self->info_value3);
	_g_object_unref0 (self->info_label4);
	_g_object_unref0 (self->info_value4);
	_g_object_unref0 (self->info_label5);
	_g_object_unref0 (self->info_value5);
	_g_object_unref0 (self->info_label6);
	_g_object_unref0 (self->info_value6);
	_g_object_unref0 (self->priv->_result_grid);
	G_OBJECT_CLASS (tracker_metadata_tile_parent_class)->finalize (obj);
}


GType tracker_metadata_tile_get_type (void) {
	static volatile gsize tracker_metadata_tile_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_metadata_tile_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerMetadataTileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_metadata_tile_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerMetadataTile), 0, (GInstanceInitFunc) tracker_metadata_tile_instance_init, NULL };
		GType tracker_metadata_tile_type_id;
		tracker_metadata_tile_type_id = g_type_register_static (GTK_TYPE_EVENT_BOX, "TrackerMetadataTile", &g_define_type_info, 0);
		g_once_init_leave (&tracker_metadata_tile_type_id__volatile, tracker_metadata_tile_type_id);
	}
	return tracker_metadata_tile_type_id__volatile;
}


static void _vala_tracker_metadata_tile_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TrackerMetadataTile * self;
	self = TRACKER_METADATA_TILE (object);
	switch (property_id) {
		case TRACKER_METADATA_TILE_QUERY:
		g_value_set_object (value, tracker_metadata_tile_get_Query (self));
		break;
		case TRACKER_METADATA_TILE_RESULT_GRID:
		g_value_set_object (value, tracker_metadata_tile_get_ResultGrid (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_tracker_metadata_tile_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TrackerMetadataTile * self;
	self = TRACKER_METADATA_TILE (object);
	switch (property_id) {
		case TRACKER_METADATA_TILE_QUERY:
		tracker_metadata_tile_set_Query (self, g_value_get_object (value));
		break;
		case TRACKER_METADATA_TILE_RESULT_GRID:
		tracker_metadata_tile_set_ResultGrid (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



