/* test-class-signal.c generated by valac 0.11.1, the Vala compiler
 * generated from test-class-signal.vala, do not modify */

/*
 * Copyright (C) 2008, Nokia <ivan.frade@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <dbus/dbus-glib.h>
#include <libtracker-sparql/tracker-sparql.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus.h>
#include <gobject/gvaluecollector.h>


#define TYPE_EVENT (event_get_type ())
typedef struct _Event Event;

#define TYPE_RESOURCES (resources_get_type ())
#define RESOURCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RESOURCES, Resources))
#define IS_RESOURCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RESOURCES))
#define RESOURCES_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_RESOURCES, ResourcesIface))

typedef struct _Resources Resources;
typedef struct _ResourcesIface ResourcesIface;
typedef struct _DBusObjectVTable _DBusObjectVTable;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ResourcesDBusProxy ResourcesDBusProxy;
typedef DBusGProxyClass ResourcesDBusProxyClass;
typedef struct _ResourcesDBusProxySparqlUpdateAsyncData ResourcesDBusProxySparqlUpdateAsyncData;

#define TYPE_TEST_APP (test_app_get_type ())
#define TEST_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEST_APP, TestApp))
#define TEST_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEST_APP, TestAppClass))
#define IS_TEST_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEST_APP))
#define IS_TEST_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEST_APP))
#define TEST_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEST_APP, TestAppClass))

typedef struct _TestApp TestApp;
typedef struct _TestAppClass TestAppClass;
typedef struct _TestAppPrivate TestAppPrivate;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _dbus_g_connection_unref0(var) ((var == NULL) ? NULL : (var = (dbus_g_connection_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _test_app_unref0(var) ((var == NULL) ? NULL : (var = (test_app_unref (var), NULL)))
typedef struct _TestAppOnGraphUpdatedReceivedAsyncData TestAppOnGraphUpdatedReceivedAsyncData;
typedef struct _ParamSpecTestApp ParamSpecTestApp;

struct _Event {
	gint graph_id;
	gint subject_id;
	gint pred_id;
	gint object_id;
};

struct _ResourcesIface {
	GTypeInterface parent_iface;
	void (*sparql_update_async) (Resources* self, const gchar* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*sparql_update_finish) (Resources* self, GAsyncResult* _res_, GError** error);
};

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};

struct _ResourcesDBusProxy {
	DBusGProxy parent_instance;
	gboolean disposed;
};

struct _ResourcesDBusProxySparqlUpdateAsyncData {
	GAsyncReadyCallback _callback_;
	gpointer _user_data_;
	DBusPendingCall* pending;
};

struct _TestApp {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TestAppPrivate * priv;
};

struct _TestAppClass {
	GTypeClass parent_class;
	void (*finalize) (TestApp *self);
};

struct _TestAppPrivate {
	gint res;
	GMainLoop* loop;
	gboolean initialized;
	TrackerSparqlConnection* signal_con;
	TrackerSparqlConnection* con;
	gint total_signals_seen;
};

struct _TestAppOnGraphUpdatedReceivedAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TestApp* self;
	gchar* dels_query;
	gchar* ins_query;
	TrackerSparqlCursor* cursor1;
	TrackerSparqlCursor* cursor2;
	TrackerSparqlCursor* _tmp0_;
	TrackerSparqlCursor* _tmp1_;
	TrackerSparqlCursor* _tmp2_;
	TrackerSparqlCursor* _tmp3_;
	TrackerSparqlCursor* _tmp4_;
	TrackerSparqlCursor* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	GError * e;
	GError * _inner_error_;
};

struct _ParamSpecTestApp {
	GParamSpec parent_instance;
};


static gpointer test_app_parent_class = NULL;
static DBusGConnection* test_app_dbus_connection;
static DBusGConnection* test_app_dbus_connection = NULL;
static Resources* test_app_resources_object;
static Resources* test_app_resources_object = NULL;

#define max_signals 10
#define title_data "title"
GType event_get_type (void) G_GNUC_CONST;
Event* event_dup (const Event* self);
void event_free (Event* self);
Resources* resources_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
GType resources_get_type (void) G_GNUC_CONST;
void resources_sparql_update_async (Resources* self, const gchar* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
void resources_sparql_update_finish (Resources* self, GAsyncResult* _res_, GError** error);
static void g_cclosure_user_marshal_VOID__STRING_POINTER_INT_POINTER_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);
static void _vala_dbus_unregister_object (gpointer connection, GObject* object);
void resources_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _resources_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult resources_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_resources_introspect (Resources* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_resources_property_get_all (Resources* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_resources_sparql_update_async (Resources* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_resources_sparql_update_async_ready (GObject * source_object, GAsyncResult * _res_, gpointer * _user_data_);
static void _dbus_resources_graph_updated (GObject* _sender, const gchar* class_name, Event* deletes, int deletes_length1, Event* inserts, int inserts_length1, DBusConnection* _connection);
GType resources_dbus_proxy_get_type (void) G_GNUC_CONST;
static void _vala_Event_array_free (Event* array, gint array_length);
static void _dbus_handle_resources_graph_updated (Resources* self, DBusConnection* connection, DBusMessage* message);
DBusHandlerResult resources_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
enum  {
	RESOURCES_DBUS_PROXY_DUMMY_PROPERTY
};
static void resources_dbus_proxy_sparql_update_async_async (Resources* self, const gchar* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void resources_dbus_proxy_sparql_update_async_ready (DBusPendingCall* pending, void* user_data);
static void resources_dbus_proxy_sparql_update_async_finish (Resources* self, GAsyncResult* _res_, GError** error);
static void resources_dbus_proxy_resources__interface_init (ResourcesIface* iface);
static void _vala_resources_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_resources_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
gpointer test_app_ref (gpointer instance);
void test_app_unref (gpointer instance);
GParamSpec* param_spec_test_app (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_test_app (GValue* value, gpointer v_object);
void value_take_test_app (GValue* value, gpointer v_object);
gpointer value_get_test_app (const GValue* value);
GType test_app_get_type (void) G_GNUC_CONST;
#define TEST_APP_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TEST_APP, TestAppPrivate))
enum  {
	TEST_APP_DUMMY_PROPERTY
};
TestApp* test_app_new (void);
TestApp* test_app_construct (GType object_type);
static void test_app_on_graph_updated_received (TestApp* self, const gchar* class_name, Event* deletes, int deletes_length1, Event* inserts, int inserts_length1);
static void _test_app_on_graph_updated_received_resources_graph_updated (Resources* _sender, const gchar* class_name, Event* deletes, int deletes_length1, Event* inserts, int inserts_length1, gpointer self);
static GString* test_app_build_title_query (TestApp* self, const gchar* class_name, Event* ids, int ids_length1);
static gint test_app_iter_cursor (TestApp* self, const gchar* kind, TrackerSparqlCursor* cursor);
static void test_app_on_graph_updated_received_async_data_free (gpointer _data);
static void test_app_on_graph_updated_received_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void test_app_on_graph_updated_received_async (TestApp* self, const gchar* dels_query, const gchar* ins_query, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void test_app_on_graph_updated_received_finish (TestApp* self, GAsyncResult* _res_);
static gboolean test_app_on_graph_updated_received_async_co (TestAppOnGraphUpdatedReceivedAsyncData* data);
static void test_app_insert_data (TestApp* self);
static gboolean test_app_in_mainloop (TestApp* self);
gint test_app_run (TestApp* self);
static gboolean _test_app_in_mainloop_gsource_func (gpointer self);
static void test_app_finalize (TestApp* obj);
gint _vala_main (gchar** args, int args_length1);

static const DBusObjectPathVTable _resources_dbus_path_vtable = {_resources_dbus_unregister, resources_dbus_message};
static const _DBusObjectVTable _resources_dbus_vtable = {resources_dbus_register_object};

void event_copy (const Event* self, Event* dest) {
	dest->graph_id = self->graph_id;
	dest->subject_id = self->subject_id;
	dest->pred_id = self->pred_id;
	dest->object_id = self->object_id;
}


void event_destroy (Event* self) {
}


Event* event_dup (const Event* self) {
	Event* dup;
	dup = g_new0 (Event, 1);
	event_copy (self, dup);
	return dup;
}


void event_free (Event* self) {
	event_destroy (self);
	g_free (self);
}


GType event_get_type (void) {
	static volatile gsize event_type_id__volatile = 0;
	if (g_once_init_enter (&event_type_id__volatile)) {
		GType event_type_id;
		event_type_id = g_boxed_type_register_static ("Event", (GBoxedCopyFunc) event_dup, (GBoxedFreeFunc) event_free);
		g_once_init_leave (&event_type_id__volatile, event_type_id);
	}
	return event_type_id__volatile;
}


void resources_sparql_update_async (Resources* self, const gchar* query, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RESOURCES_GET_INTERFACE (self)->sparql_update_async (self, query, _callback_, _user_data_);
}


void resources_sparql_update_finish (Resources* self, GAsyncResult* _res_, GError** error) {
	RESOURCES_GET_INTERFACE (self)->sparql_update_finish (self, _res_, error);
}


static void g_cclosure_user_marshal_VOID__STRING_POINTER_INT_POINTER_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_POINTER_INT_POINTER_INT) (gpointer data1, const char* arg_1, gpointer arg_2, gint arg_3, gpointer arg_4, gint arg_5, gpointer data2);
	register GMarshalFunc_VOID__STRING_POINTER_INT_POINTER_INT callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 6);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_POINTER_INT_POINTER_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_pointer (param_values + 2), g_value_get_int (param_values + 3), g_value_get_pointer (param_values + 4), g_value_get_int (param_values + 5), data2);
}


static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	if (vtable) {
		vtable->register_object (connection, path, object);
	} else {
		g_warning ("Object does not implement any D-Bus interface");
	}
}


static void _vala_dbus_unregister_object (gpointer connection, GObject* object) {
	char* path;
	path = g_object_steal_data ((GObject*) object, "dbus_object_path");
	dbus_connection_unregister_object_path (connection, path);
	g_free (path);
}


void _resources_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_resources_introspect (Resources* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.Tracker1.Resources\">\n  <method name=\"SparqlUpdate\">\n    <arg name=\"query\" type=\"s\" direction=\"in\"/>\n  </method>\n  <signal name=\"GraphUpdated\">\n    <arg name=\"class_name\" type=\"s\"/>\n    <arg name=\"deletes\" type=\"a(iiii)\"/>\n    <arg name=\"inserts\" type=\"a(iiii)\"/>\n  </signal>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_resources_property_get_all (Resources* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp0_;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp0_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp0_);
	if (strcmp (interface_name, "org.freedesktop.Tracker1.Resources") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_resources_sparql_update_async (Resources* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	gchar* query = NULL;
	const char* _tmp1_;
	gpointer * _user_data_;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp1_);
	dbus_message_iter_next (&iter);
	query = g_strdup (_tmp1_);
	_user_data_ = g_new0 (gpointer, 2);
	_user_data_[0] = dbus_connection_ref (connection);
	_user_data_[1] = dbus_message_ref (message);
	resources_sparql_update_async (self, query, (GAsyncReadyCallback) _dbus_resources_sparql_update_async_ready, _user_data_);
	_g_free0 (query);
	return DBUS_HANDLER_RESULT_HANDLED;
}


static void _dbus_resources_sparql_update_async_ready (GObject * source_object, GAsyncResult * _res_, gpointer * _user_data_) {
	DBusConnection * connection;
	DBusMessage * message;
	DBusMessageIter iter;
	GError* error;
	DBusMessage* reply;
	connection = _user_data_[0];
	message = _user_data_[1];
	error = NULL;
	resources_sparql_update_finish ((Resources*) source_object, _res_, &error);
	if (error) {
		if (error->domain == TRACKER_SPARQL_ERROR) {
			switch (error->code) {
				case TRACKER_SPARQL_ERROR_PARSE:
				reply = dbus_message_new_error (message, "org.freedesktop.Tracker1.SparqlError.Parse", error->message);
				break;
				case TRACKER_SPARQL_ERROR_UNKNOWN_CLASS:
				reply = dbus_message_new_error (message, "org.freedesktop.Tracker1.SparqlError.UnknownClass", error->message);
				break;
				case TRACKER_SPARQL_ERROR_UNKNOWN_PROPERTY:
				reply = dbus_message_new_error (message, "org.freedesktop.Tracker1.SparqlError.UnknownProperty", error->message);
				break;
				case TRACKER_SPARQL_ERROR_TYPE:
				reply = dbus_message_new_error (message, "org.freedesktop.Tracker1.SparqlError.Type", error->message);
				break;
				case TRACKER_SPARQL_ERROR_CONSTRAINT:
				reply = dbus_message_new_error (message, "org.freedesktop.Tracker1.SparqlError.Constraint", error->message);
				break;
				case TRACKER_SPARQL_ERROR_NO_SPACE:
				reply = dbus_message_new_error (message, "org.freedesktop.Tracker1.SparqlError.NoSpace", error->message);
				break;
				case TRACKER_SPARQL_ERROR_INTERNAL:
				reply = dbus_message_new_error (message, "org.freedesktop.Tracker1.SparqlError.Internal", error->message);
				break;
				case TRACKER_SPARQL_ERROR_UNSUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.Tracker1.SparqlError.Unsupported", error->message);
				break;
			}
		} else if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	dbus_connection_send (connection, reply, NULL);
	dbus_message_unref (reply);
	dbus_connection_unref (connection);
	dbus_message_unref (message);
	g_free (_user_data_);
}


DBusHandlerResult resources_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_resources_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		result = _dbus_resources_property_get_all (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.Tracker1.Resources", "SparqlUpdate")) {
		result = _dbus_resources_sparql_update_async (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static void _dbus_resources_graph_updated (GObject* _sender, const gchar* class_name, Event* deletes, int deletes_length1, Event* inserts, int inserts_length1, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	const char* _tmp2_;
	Event* _tmp3_;
	DBusMessageIter _tmp4_;
	int _tmp5_;
	Event* _tmp11_;
	DBusMessageIter _tmp12_;
	int _tmp13_;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "org.freedesktop.Tracker1.Resources", "GraphUpdated");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp2_ = class_name;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp2_);
	_tmp3_ = deletes;
	dbus_message_iter_open_container (&_iter, DBUS_TYPE_ARRAY, "(iiii)", &_tmp4_);
	for (_tmp5_ = 0; _tmp5_ < deletes_length1; _tmp5_++) {
		DBusMessageIter _tmp6_;
		dbus_int32_t _tmp7_;
		dbus_int32_t _tmp8_;
		dbus_int32_t _tmp9_;
		dbus_int32_t _tmp10_;
		dbus_message_iter_open_container (&_tmp4_, DBUS_TYPE_STRUCT, NULL, &_tmp6_);
		_tmp7_ = (*_tmp3_).graph_id;
		dbus_message_iter_append_basic (&_tmp6_, DBUS_TYPE_INT32, &_tmp7_);
		_tmp8_ = (*_tmp3_).subject_id;
		dbus_message_iter_append_basic (&_tmp6_, DBUS_TYPE_INT32, &_tmp8_);
		_tmp9_ = (*_tmp3_).pred_id;
		dbus_message_iter_append_basic (&_tmp6_, DBUS_TYPE_INT32, &_tmp9_);
		_tmp10_ = (*_tmp3_).object_id;
		dbus_message_iter_append_basic (&_tmp6_, DBUS_TYPE_INT32, &_tmp10_);
		dbus_message_iter_close_container (&_tmp4_, &_tmp6_);
		_tmp3_++;
	}
	dbus_message_iter_close_container (&_iter, &_tmp4_);
	_tmp11_ = inserts;
	dbus_message_iter_open_container (&_iter, DBUS_TYPE_ARRAY, "(iiii)", &_tmp12_);
	for (_tmp13_ = 0; _tmp13_ < inserts_length1; _tmp13_++) {
		DBusMessageIter _tmp14_;
		dbus_int32_t _tmp15_;
		dbus_int32_t _tmp16_;
		dbus_int32_t _tmp17_;
		dbus_int32_t _tmp18_;
		dbus_message_iter_open_container (&_tmp12_, DBUS_TYPE_STRUCT, NULL, &_tmp14_);
		_tmp15_ = (*_tmp11_).graph_id;
		dbus_message_iter_append_basic (&_tmp14_, DBUS_TYPE_INT32, &_tmp15_);
		_tmp16_ = (*_tmp11_).subject_id;
		dbus_message_iter_append_basic (&_tmp14_, DBUS_TYPE_INT32, &_tmp16_);
		_tmp17_ = (*_tmp11_).pred_id;
		dbus_message_iter_append_basic (&_tmp14_, DBUS_TYPE_INT32, &_tmp17_);
		_tmp18_ = (*_tmp11_).object_id;
		dbus_message_iter_append_basic (&_tmp14_, DBUS_TYPE_INT32, &_tmp18_);
		dbus_message_iter_close_container (&_tmp12_, &_tmp14_);
		_tmp11_++;
	}
	dbus_message_iter_close_container (&_iter, &_tmp12_);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


void resources_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_resources_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
	g_signal_connect (object, "graph-updated", (GCallback) _dbus_resources_graph_updated, connection);
}


static void resources_base_init (ResourcesIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("graph_updated", TYPE_RESOURCES, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_POINTER_INT_POINTER_INT, G_TYPE_NONE, 5, G_TYPE_STRING, G_TYPE_POINTER, G_TYPE_INT, G_TYPE_POINTER, G_TYPE_INT);
		g_type_set_qdata (TYPE_RESOURCES, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_resources_dbus_vtable));
	}
}


GType resources_get_type (void) {
	static volatile gsize resources_type_id__volatile = 0;
	if (g_once_init_enter (&resources_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ResourcesIface), (GBaseInitFunc) resources_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType resources_type_id;
		resources_type_id = g_type_register_static (G_TYPE_INTERFACE, "Resources", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (resources_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (resources_type_id, g_quark_from_string ("ValaDBusInterfaceProxyType"), &resources_dbus_proxy_get_type);
		g_once_init_leave (&resources_type_id__volatile, resources_type_id);
	}
	return resources_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (ResourcesDBusProxy, resources_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_RESOURCES, resources_dbus_proxy_resources__interface_init) );
Resources* resources_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	Resources* self;
	self = g_object_new (resources_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "org.freedesktop.Tracker1.Resources", NULL);
	return self;
}


static GObject* resources_dbus_proxy_construct (GType gtype, guint n_properties, GObjectConstructParam* properties) {
	GObject* self;
	DBusGConnection *connection;
	char* path;
	char* filter;
	self = G_OBJECT_CLASS (resources_dbus_proxy_parent_class)->constructor (gtype, n_properties, properties);
	g_object_get (self, "connection", &connection, NULL);
	g_object_get (self, "path", &path, NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), resources_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	dbus_g_connection_unref (connection);
	g_free (path);
	g_free (filter);
	return self;
}


static void _vala_Event_array_free (Event* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			event_destroy (&array[i]);
		}
	}
	g_free (array);
}


static void _dbus_handle_resources_graph_updated (Resources* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	gchar* class_name = NULL;
	const char* _tmp0_;
	Event* deletes = NULL;
	int deletes_length1;
	Event* _tmp1_;
	int _tmp1__length;
	int _tmp1__size;
	int _tmp1__length1;
	DBusMessageIter _tmp2_;
	Event* inserts = NULL;
	int inserts_length1;
	Event* _tmp9_;
	int _tmp9__length;
	int _tmp9__size;
	int _tmp9__length1;
	DBusMessageIter _tmp10_;
	DBusMessage* reply;
	if (strcmp (dbus_message_get_signature (message), "sa(iiii)a(iiii)")) {
		return;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp0_);
	dbus_message_iter_next (&iter);
	class_name = g_strdup (_tmp0_);
	deletes_length1 = 0;
	_tmp1_ = g_new (Event, 5);
	_tmp1__length = 0;
	_tmp1__size = 4;
	_tmp1__length1 = 0;
	dbus_message_iter_recurse (&iter, &_tmp2_);
	for (; dbus_message_iter_get_arg_type (&_tmp2_); _tmp1__length1++) {
		Event _tmp3_;
		DBusMessageIter _tmp4_;
		dbus_int32_t _tmp5_;
		dbus_int32_t _tmp6_;
		dbus_int32_t _tmp7_;
		dbus_int32_t _tmp8_;
		if (_tmp1__size == _tmp1__length) {
			_tmp1__size = 2 * _tmp1__size;
			_tmp1_ = g_renew (Event, _tmp1_, _tmp1__size + 1);
		}
		dbus_message_iter_recurse (&_tmp2_, &_tmp4_);
		dbus_message_iter_get_basic (&_tmp4_, &_tmp5_);
		dbus_message_iter_next (&_tmp4_);
		_tmp3_.graph_id = _tmp5_;
		dbus_message_iter_get_basic (&_tmp4_, &_tmp6_);
		dbus_message_iter_next (&_tmp4_);
		_tmp3_.subject_id = _tmp6_;
		dbus_message_iter_get_basic (&_tmp4_, &_tmp7_);
		dbus_message_iter_next (&_tmp4_);
		_tmp3_.pred_id = _tmp7_;
		dbus_message_iter_get_basic (&_tmp4_, &_tmp8_);
		dbus_message_iter_next (&_tmp4_);
		_tmp3_.object_id = _tmp8_;
		dbus_message_iter_next (&_tmp2_);
		_tmp1_[_tmp1__length++] = _tmp3_;
	}
	deletes_length1 = _tmp1__length1;
	dbus_message_iter_next (&iter);
	deletes = _tmp1_;
	inserts_length1 = 0;
	_tmp9_ = g_new (Event, 5);
	_tmp9__length = 0;
	_tmp9__size = 4;
	_tmp9__length1 = 0;
	dbus_message_iter_recurse (&iter, &_tmp10_);
	for (; dbus_message_iter_get_arg_type (&_tmp10_); _tmp9__length1++) {
		Event _tmp11_;
		DBusMessageIter _tmp12_;
		dbus_int32_t _tmp13_;
		dbus_int32_t _tmp14_;
		dbus_int32_t _tmp15_;
		dbus_int32_t _tmp16_;
		if (_tmp9__size == _tmp9__length) {
			_tmp9__size = 2 * _tmp9__size;
			_tmp9_ = g_renew (Event, _tmp9_, _tmp9__size + 1);
		}
		dbus_message_iter_recurse (&_tmp10_, &_tmp12_);
		dbus_message_iter_get_basic (&_tmp12_, &_tmp13_);
		dbus_message_iter_next (&_tmp12_);
		_tmp11_.graph_id = _tmp13_;
		dbus_message_iter_get_basic (&_tmp12_, &_tmp14_);
		dbus_message_iter_next (&_tmp12_);
		_tmp11_.subject_id = _tmp14_;
		dbus_message_iter_get_basic (&_tmp12_, &_tmp15_);
		dbus_message_iter_next (&_tmp12_);
		_tmp11_.pred_id = _tmp15_;
		dbus_message_iter_get_basic (&_tmp12_, &_tmp16_);
		dbus_message_iter_next (&_tmp12_);
		_tmp11_.object_id = _tmp16_;
		dbus_message_iter_next (&_tmp10_);
		_tmp9_[_tmp9__length++] = _tmp11_;
	}
	inserts_length1 = _tmp9__length1;
	dbus_message_iter_next (&iter);
	inserts = _tmp9_;
	g_signal_emit_by_name (self, "graph-updated", class_name, deletes, deletes_length1, inserts, inserts_length1);
	_g_free0 (class_name);
	deletes = (_vala_Event_array_free (deletes, deletes_length1), NULL);
	inserts = (_vala_Event_array_free (inserts, inserts_length1), NULL);
}


DBusHandlerResult resources_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
		if (dbus_message_is_signal (message, "org.freedesktop.Tracker1.Resources", "GraphUpdated")) {
			_dbus_handle_resources_graph_updated (user_data, connection, message);
		}
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void resources_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	if (((ResourcesDBusProxy*) self)->disposed) {
		return;
	}
	((ResourcesDBusProxy*) self)->disposed = TRUE;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), resources_dbus_proxy_filter, self);
	G_OBJECT_CLASS (resources_dbus_proxy_parent_class)->dispose (self);
}


static void resources_dbus_proxy_class_init (ResourcesDBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->constructor = resources_dbus_proxy_construct;
	G_OBJECT_CLASS (klass)->dispose = resources_dbus_proxy_dispose;
	G_OBJECT_CLASS (klass)->get_property = _vala_resources_dbus_proxy_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_resources_dbus_proxy_set_property;
}


static void resources_dbus_proxy_init (ResourcesDBusProxy* self) {
}


static void resources_dbus_proxy_sparql_update_async_async (Resources* self, const gchar* query, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DBusGConnection *_connection;
	DBusMessage *_message;
	DBusPendingCall *_pending;
	DBusMessageIter _iter;
	const char* _tmp17_;
	ResourcesDBusProxySparqlUpdateAsyncData* _data_;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.Tracker1.Resources", "SparqlUpdate");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp17_ = query;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp17_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_connection_send_with_reply (dbus_g_connection_get_connection (_connection), _message, &_pending, -1);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	_data_ = g_slice_new0 (ResourcesDBusProxySparqlUpdateAsyncData);
	_data_->_callback_ = _callback_;
	_data_->_user_data_ = _user_data_;
	_data_->pending = _pending;
	dbus_pending_call_set_notify (_pending, resources_dbus_proxy_sparql_update_async_ready, _data_, NULL);
}


static void resources_dbus_proxy_sparql_update_async_ready (DBusPendingCall* pending, void* user_data) {
	ResourcesDBusProxySparqlUpdateAsyncData* _data_;
	GObject * _obj_;
	GSimpleAsyncResult * _res_;
	_data_ = user_data;
	_obj_ = g_object_newv (G_TYPE_OBJECT, 0, NULL);
	_res_ = g_simple_async_result_new (_obj_, _data_->_callback_, _data_->_user_data_, _data_);
	g_simple_async_result_complete (_res_);
	g_object_unref (_obj_);
	g_object_unref (_res_);
	g_slice_free (ResourcesDBusProxySparqlUpdateAsyncData, _data_);
	dbus_pending_call_unref (pending);
}


static void resources_dbus_proxy_sparql_update_async_finish (Resources* self, GAsyncResult* _res_, GError** error) {
	ResourcesDBusProxySparqlUpdateAsyncData* _data_;
	DBusError _dbus_error;
	DBusMessage *_reply;
	DBusMessageIter _iter;
	_data_ = g_simple_async_result_get_source_tag ((GSimpleAsyncResult *) _res_);
	dbus_error_init (&_dbus_error);
	_reply = dbus_pending_call_steal_reply (_data_->pending);
	dbus_set_error_from_message (&_dbus_error, _reply);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain = 0;
		gint _ecode = 0;
		if (strstr (_dbus_error.name, "org.freedesktop.Tracker1.SparqlError") == _dbus_error.name) {
			const char* _tmp18_;
			_edomain = TRACKER_SPARQL_ERROR;
			_tmp18_ = _dbus_error.name + 37;
			if (strcmp (_tmp18_, "Parse") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_PARSE;
			} else if (strcmp (_tmp18_, "UnknownClass") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_UNKNOWN_CLASS;
			} else if (strcmp (_tmp18_, "UnknownProperty") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_UNKNOWN_PROPERTY;
			} else if (strcmp (_tmp18_, "Type") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_TYPE;
			} else if (strcmp (_tmp18_, "Constraint") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_CONSTRAINT;
			} else if (strcmp (_tmp18_, "NoSpace") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_NO_SPACE;
			} else if (strcmp (_tmp18_, "Internal") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_INTERNAL;
			} else if (strcmp (_tmp18_, "Unsupported") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_UNSUPPORTED;
			}
		} else if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp19_;
			_edomain = DBUS_GERROR;
			_tmp19_ = _dbus_error.name + 27;
			if (strcmp (_tmp19_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp19_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp19_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp19_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp19_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp19_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp19_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp19_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp19_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp19_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp19_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp19_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp19_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp19_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp19_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp19_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp19_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp19_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp19_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp19_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp19_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp19_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp19_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp19_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp19_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp19_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp19_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp19_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp19_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp19_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp19_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp19_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp19_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static void resources_dbus_proxy_resources__interface_init (ResourcesIface* iface) {
	iface->sparql_update_async = resources_dbus_proxy_sparql_update_async_async;
	iface->sparql_update_finish = resources_dbus_proxy_sparql_update_async_finish;
}


static void _vala_resources_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
}


static void _vala_resources_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _test_app_on_graph_updated_received_resources_graph_updated (Resources* _sender, const gchar* class_name, Event* deletes, int deletes_length1, Event* inserts, int inserts_length1, gpointer self) {
	test_app_on_graph_updated_received (self, class_name, deletes, deletes_length1, inserts, inserts_length1);
}


TestApp* test_app_construct (GType object_type) {
	TestApp* self = NULL;
	TrackerSparqlConnection* _tmp0_ = NULL;
	TrackerSparqlConnection* _tmp1_;
	TrackerSparqlConnection* _tmp2_;
	TrackerSparqlConnection* _tmp3_;
	TrackerSparqlConnection* _tmp4_;
	DBusGConnection* _tmp5_ = NULL;
	DBusGConnection* _tmp6_;
	DBusGConnection* _tmp7_;
	DBusGProxy* _tmp8_ = NULL;
	Resources* _tmp9_;
	GError * _inner_error_ = NULL;
	self = (TestApp*) g_type_create_instance (object_type);
	g_return_val_if_fail (!self->priv->initialized, NULL);
	_tmp0_ = tracker_sparql_connection_get (NULL, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		goto __catch0_g_error;
	}
	_tmp2_ = _tmp1_;
	_g_object_unref0 (self->priv->con);
	self->priv->con = _tmp2_;
	_tmp3_ = _g_object_ref0 (self->priv->con);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (self->priv->signal_con);
	self->priv->signal_con = _tmp4_;
	_tmp5_ = dbus_g_bus_get (DBUS_BUS_SESSION, &_inner_error_);
	_tmp6_ = _tmp5_;
	if (_inner_error_ != NULL) {
		goto __catch0_g_error;
	}
	_tmp7_ = _tmp6_;
	_dbus_g_connection_unref0 (test_app_dbus_connection);
	test_app_dbus_connection = _tmp7_;
	_tmp8_ = dbus_g_proxy_new_for_name (test_app_dbus_connection, "org.freedesktop.Tracker1", "/org/freedesktop/Tracker1/Resources", "org.freedesktop.Tracker1.Resources");
	_tmp9_ = resources_dbus_proxy_new (test_app_dbus_connection, "org.freedesktop.Tracker1", "/org/freedesktop/Tracker1/Resources");
	_g_object_unref0 (test_app_resources_object);
	test_app_resources_object = _tmp9_;
	g_signal_connect (test_app_resources_object, "graph-updated", (GCallback) _test_app_on_graph_updated_received_resources_graph_updated, self);
	goto __finally0;
	__catch0_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("test-class-signal.vala:69: Could not connect to D-Bus service: %s", e->message);
		self->priv->initialized = FALSE;
		self->priv->res = -1;
		_g_error_free0 (e);
		return self;
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	self->priv->initialized = TRUE;
	return self;
}


TestApp* test_app_new (void) {
	return test_app_construct (TYPE_TEST_APP);
}


static GString* test_app_build_title_query (TestApp* self, const gchar* class_name, Event* ids, int ids_length1) {
	GString* result = NULL;
	gboolean first;
	GString* _tmp0_ = NULL;
	GString* builder;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (class_name != NULL, NULL);
	first = TRUE;
	_tmp0_ = g_string_new ("SELECT ?r ?t { ?r a <");
	builder = _tmp0_;
	g_string_append (builder, class_name);
	g_string_append (builder, ">; nie:title ?t . FILTER (tracker:id (?r) IN (");
	{
		Event* event_collection;
		int event_collection_length1;
		int event_it;
		event_collection = ids;
		event_collection_length1 = ids_length1;
		for (event_it = 0; event_it < ids_length1; event_it = event_it + 1) {
			Event _tmp1_;
			Event _tmp2_ = {0};
			Event event;
			_tmp1_ = (event_copy (&event_collection[event_it], &_tmp2_), _tmp2_);
			event = _tmp1_;
			{
				if (first) {
					g_string_append_printf (builder, "%d", event.subject_id);
				} else {
					g_string_append_printf (builder, " , %d", event.subject_id);
				}
				first = FALSE;
				event_destroy (&event);
			}
		}
	}
	g_string_append (builder, ")) }");
	result = builder;
	return result;
}


static gint test_app_iter_cursor (TestApp* self, const gchar* kind, TrackerSparqlCursor* cursor) {
	gint result = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (kind != NULL, 0);
	g_return_val_if_fail (cursor != NULL, 0);
	while (TRUE) {
		gboolean _tmp0_;
		gboolean _tmp1_;
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		gchar* resource;
		const gchar* _tmp4_ = NULL;
		_tmp0_ = tracker_sparql_cursor_next (cursor, NULL, &_inner_error_);
		_tmp1_ = _tmp0_;
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
		if (!_tmp1_) {
			break;
		}
		_tmp2_ = tracker_sparql_cursor_get_string (cursor, 0, NULL);
		_tmp3_ = g_strdup (_tmp2_);
		resource = _tmp3_;
		_tmp4_ = tracker_sparql_cursor_get_string (cursor, 1, NULL);
		g_print ("%s <%s> nie:title '%s'\n", kind, resource, _tmp4_);
		self->priv->total_signals_seen++;
		if (self->priv->total_signals_seen >= (max_signals * 2)) {
			g_main_loop_quit (self->priv->loop);
		}
		_g_free0 (resource);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("test-class-signal.vala:116: Couldn't iterate query results: %s", e->message);
		self->priv->res = -1;
		result = -1;
		_g_error_free0 (e);
		return result;
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = 0;
	return result;
}


static void test_app_on_graph_updated_received_async_data_free (gpointer _data) {
	TestAppOnGraphUpdatedReceivedAsyncData* data;
	data = _data;
	_g_free0 (data->dels_query);
	_g_free0 (data->ins_query);
	_test_app_unref0 (data->self);
	g_slice_free (TestAppOnGraphUpdatedReceivedAsyncData, data);
}


static gpointer _test_app_ref0 (gpointer self) {
	return self ? test_app_ref (self) : NULL;
}


static void test_app_on_graph_updated_received_async (TestApp* self, const gchar* dels_query, const gchar* ins_query, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TestAppOnGraphUpdatedReceivedAsyncData* _data_;
	_data_ = g_slice_new0 (TestAppOnGraphUpdatedReceivedAsyncData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, test_app_on_graph_updated_received_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, test_app_on_graph_updated_received_async_data_free);
	_data_->self = _test_app_ref0 (self);
	_data_->dels_query = g_strdup (dels_query);
	_data_->ins_query = g_strdup (ins_query);
	test_app_on_graph_updated_received_async_co (_data_);
}


static void test_app_on_graph_updated_received_finish (TestApp* self, GAsyncResult* _res_) {
	TestAppOnGraphUpdatedReceivedAsyncData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void test_app_on_graph_updated_received_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TestAppOnGraphUpdatedReceivedAsyncData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	test_app_on_graph_updated_received_async_co (data);
}


static gboolean test_app_on_graph_updated_received_async_co (TestAppOnGraphUpdatedReceivedAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_state_ = 1;
	tracker_sparql_connection_query_async (data->self->priv->signal_con, data->dels_query, NULL, test_app_on_graph_updated_received_async_ready, data);
	return FALSE;
	_state_1:
	data->_tmp0_ = NULL;
	data->_tmp0_ = tracker_sparql_connection_query_finish (data->self->priv->signal_con, data->_res_, &data->_inner_error_);
	data->_tmp1_ = data->_tmp0_;
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->cursor2);
		_g_object_unref0 (data->cursor1);
		goto __catch2_g_error;
	}
	data->_tmp2_ = data->_tmp1_;
	_g_object_unref0 (data->cursor1);
	data->cursor1 = data->_tmp2_;
	data->_state_ = 2;
	tracker_sparql_connection_query_async (data->self->priv->signal_con, data->ins_query, NULL, test_app_on_graph_updated_received_async_ready, data);
	return FALSE;
	_state_2:
	data->_tmp3_ = NULL;
	data->_tmp3_ = tracker_sparql_connection_query_finish (data->self->priv->signal_con, data->_res_, &data->_inner_error_);
	data->_tmp4_ = data->_tmp3_;
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->cursor2);
		_g_object_unref0 (data->cursor1);
		goto __catch2_g_error;
	}
	data->_tmp5_ = data->_tmp4_;
	_g_object_unref0 (data->cursor2);
	data->cursor2 = data->_tmp5_;
	data->_tmp6_ = test_app_iter_cursor (data->self, "delete of: ", data->cursor1);
	data->self->priv->res = data->_tmp6_;
	if (data->self->priv->res != (-1)) {
		data->_tmp7_ = test_app_iter_cursor (data->self, "insert of: ", data->cursor2);
		data->self->priv->res = data->_tmp7_;
	}
	_g_object_unref0 (data->cursor2);
	_g_object_unref0 (data->cursor1);
	goto __finally2;
	__catch2_g_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		g_warning ("test-class-signal.vala:135: Couldn't iterate query results: %s", data->e->message);
		data->self->priv->res = -1;
		_g_error_free0 (data->e);
	}
	__finally2:
	if (data->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void test_app_on_graph_updated_received (TestApp* self, const gchar* class_name, Event* deletes, int deletes_length1, Event* inserts, int inserts_length1) {
	GString* _tmp0_ = NULL;
	GString* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* dels_qry;
	GString* _tmp4_ = NULL;
	GString* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* ins_qry;
	g_return_if_fail (self != NULL);
	g_return_if_fail (class_name != NULL);
	_tmp0_ = test_app_build_title_query (self, class_name, deletes, deletes_length1);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup (_tmp1_->str);
	dels_qry = (_tmp3_ = _tmp2_, _g_string_free0 (_tmp1_), _tmp3_);
	_tmp4_ = test_app_build_title_query (self, class_name, deletes, deletes_length1);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup (_tmp5_->str);
	ins_qry = (_tmp7_ = _tmp6_, _g_string_free0 (_tmp5_), _tmp7_);
	test_app_on_graph_updated_received_async (self, dels_qry, ins_qry, NULL, NULL);
	_g_free0 (ins_qry);
	_g_free0 (dels_qry);
}


static void test_app_insert_data (TestApp* self) {
	gint i = 0;
	g_return_if_fail (self != NULL);
	{
		gboolean _tmp0_;
		i = 0;
		_tmp0_ = TRUE;
		while (TRUE) {
			gchar* _tmp1_ = NULL;
			gchar* upqry;
			if (!_tmp0_) {
				i++;
			}
			_tmp0_ = FALSE;
			if (!(i <= max_signals)) {
				break;
			}
			_tmp1_ = g_strdup_printf ("DELETE { <%d> a rdfs:Resource } INSERT { <%d> a nmm:MusicPiece ; nie:t" \
"itle '%s %d' }", i, i, title_data, i);
			upqry = _tmp1_;
			resources_sparql_update_async (test_app_resources_object, upqry, NULL, NULL);
			_g_free0 (upqry);
		}
	}
}


static gboolean test_app_in_mainloop (TestApp* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	test_app_insert_data (self);
	result = FALSE;
	return result;
}


static gboolean _test_app_in_mainloop_gsource_func (gpointer self) {
	gboolean result;
	result = test_app_in_mainloop (self);
	return result;
}


gint test_app_run (TestApp* self) {
	gint result = 0;
	GMainLoop* _tmp0_ = NULL;
	GMainLoop* _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_main_loop_new (NULL, FALSE);
	_tmp1_ = _tmp0_;
	_g_main_loop_unref0 (self->priv->loop);
	self->priv->loop = _tmp1_;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _test_app_in_mainloop_gsource_func, test_app_ref (self), test_app_unref);
	g_main_loop_run (self->priv->loop);
	result = self->priv->res;
	return result;
}


static void value_test_app_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_test_app_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		test_app_unref (value->data[0].v_pointer);
	}
}


static void value_test_app_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = test_app_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_test_app_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_test_app_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		TestApp* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = test_app_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_test_app_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	TestApp** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = test_app_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_test_app (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecTestApp* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_TEST_APP), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_test_app (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TEST_APP), NULL);
	return value->data[0].v_pointer;
}


void value_set_test_app (GValue* value, gpointer v_object) {
	TestApp* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TEST_APP));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TEST_APP));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		test_app_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		test_app_unref (old);
	}
}


void value_take_test_app (GValue* value, gpointer v_object) {
	TestApp* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TEST_APP));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TEST_APP));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		test_app_unref (old);
	}
}


static void test_app_class_init (TestAppClass * klass) {
	test_app_parent_class = g_type_class_peek_parent (klass);
	TEST_APP_CLASS (klass)->finalize = test_app_finalize;
	g_type_class_add_private (klass, sizeof (TestAppPrivate));
}


static void test_app_instance_init (TestApp * self) {
	self->priv = TEST_APP_GET_PRIVATE (self);
	self->priv->res = -1;
	self->priv->initialized = FALSE;
	self->priv->total_signals_seen = 0;
	self->ref_count = 1;
}


static void test_app_finalize (TestApp* obj) {
	TestApp * self;
	self = TEST_APP (obj);
	_g_main_loop_unref0 (self->priv->loop);
	_g_object_unref0 (self->priv->signal_con);
	_g_object_unref0 (self->priv->con);
}


GType test_app_get_type (void) {
	static volatile gsize test_app_type_id__volatile = 0;
	if (g_once_init_enter (&test_app_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_test_app_init, value_test_app_free_value, value_test_app_copy_value, value_test_app_peek_pointer, "p", value_test_app_collect_value, "p", value_test_app_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (TestAppClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) test_app_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TestApp), 0, (GInstanceInitFunc) test_app_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType test_app_type_id;
		test_app_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TestApp", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&test_app_type_id__volatile, test_app_type_id);
	}
	return test_app_type_id__volatile;
}


gpointer test_app_ref (gpointer instance) {
	TestApp* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void test_app_unref (gpointer instance) {
	TestApp* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		TEST_APP_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	TestApp* _tmp0_ = NULL;
	TestApp* app;
	gint _tmp1_;
	_tmp0_ = test_app_new ();
	app = _tmp0_;
	_tmp1_ = test_app_run (app);
	result = _tmp1_;
	_test_app_unref0 (app);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _vala_main (argv, argc);
}



