/* tracker-sparql-query.c generated by valac 0.36.4, the Vala compiler
 * generated from tracker-sparql-query.vala, do not modify */

/*
 * Copyright (C) 2008-2010, Nokia
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "libtracker-data/tracker-property.h"
#include "libtracker-data/tracker-class.h"
#include "libtracker-data/tracker-data-manager.h"
#include "libtracker-data/tracker-db-interface.h"
#include "libtracker-data/tracker-data-backup.h"
#include "libtracker-data/tracker-data-query.h"
#include "libtracker-sparql/tracker-sparql.h"
#include "libtracker-common/tracker-date-time.h"
#include "libtracker-data/tracker-ontologies.h"
#include "libtracker-data/tracker-namespace.h"
#include <float.h>
#include <math.h>
#include "libtracker-data/tracker-data-update.h"
#include <gobject/gvaluecollector.h>


#define TRACKER_SPARQL_TYPE_VARIABLE_STATE (tracker_sparql_variable_state_get_type ())

#define TRACKER_SPARQL_TYPE_UPDATE_TYPE (tracker_sparql_update_type_get_type ())

#define TRACKER_SPARQL_TYPE_DATA_TABLE (tracker_sparql_data_table_get_type ())
#define TRACKER_SPARQL_DATA_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_DATA_TABLE, TrackerSparqlDataTable))
#define TRACKER_SPARQL_DATA_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_DATA_TABLE, TrackerSparqlDataTableClass))
#define TRACKER_SPARQL_IS_DATA_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_DATA_TABLE))
#define TRACKER_SPARQL_IS_DATA_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_DATA_TABLE))
#define TRACKER_SPARQL_DATA_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_DATA_TABLE, TrackerSparqlDataTableClass))

typedef struct _TrackerSparqlDataTable TrackerSparqlDataTable;
typedef struct _TrackerSparqlDataTableClass TrackerSparqlDataTableClass;
typedef struct _TrackerSparqlDataTablePrivate TrackerSparqlDataTablePrivate;

#define TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE (tracker_sparql_predicate_variable_get_type ())
#define TRACKER_SPARQL_PREDICATE_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE, TrackerSparqlPredicateVariable))
#define TRACKER_SPARQL_PREDICATE_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE, TrackerSparqlPredicateVariableClass))
#define TRACKER_SPARQL_IS_PREDICATE_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE))
#define TRACKER_SPARQL_IS_PREDICATE_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE))
#define TRACKER_SPARQL_PREDICATE_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE, TrackerSparqlPredicateVariableClass))

typedef struct _TrackerSparqlPredicateVariable TrackerSparqlPredicateVariable;
typedef struct _TrackerSparqlPredicateVariableClass TrackerSparqlPredicateVariableClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TRACKER_SPARQL_TYPE_DATA_BINDING (tracker_sparql_data_binding_get_type ())
#define TRACKER_SPARQL_DATA_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_DATA_BINDING, TrackerSparqlDataBinding))
#define TRACKER_SPARQL_DATA_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_DATA_BINDING, TrackerSparqlDataBindingClass))
#define TRACKER_SPARQL_IS_DATA_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_DATA_BINDING))
#define TRACKER_SPARQL_IS_DATA_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_DATA_BINDING))
#define TRACKER_SPARQL_DATA_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_DATA_BINDING, TrackerSparqlDataBindingClass))

typedef struct _TrackerSparqlDataBinding TrackerSparqlDataBinding;
typedef struct _TrackerSparqlDataBindingClass TrackerSparqlDataBindingClass;
typedef struct _TrackerSparqlDataBindingPrivate TrackerSparqlDataBindingPrivate;

#define TRACKER_SPARQL_TYPE_LITERAL_BINDING (tracker_sparql_literal_binding_get_type ())
#define TRACKER_SPARQL_LITERAL_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_LITERAL_BINDING, TrackerSparqlLiteralBinding))
#define TRACKER_SPARQL_LITERAL_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_LITERAL_BINDING, TrackerSparqlLiteralBindingClass))
#define TRACKER_SPARQL_IS_LITERAL_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_LITERAL_BINDING))
#define TRACKER_SPARQL_IS_LITERAL_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_LITERAL_BINDING))
#define TRACKER_SPARQL_LITERAL_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_LITERAL_BINDING, TrackerSparqlLiteralBindingClass))

typedef struct _TrackerSparqlLiteralBinding TrackerSparqlLiteralBinding;
typedef struct _TrackerSparqlLiteralBindingClass TrackerSparqlLiteralBindingClass;
typedef struct _TrackerSparqlLiteralBindingPrivate TrackerSparqlLiteralBindingPrivate;

#define TRACKER_SPARQL_TYPE_VARIABLE_BINDING (tracker_sparql_variable_binding_get_type ())
#define TRACKER_SPARQL_VARIABLE_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING, TrackerSparqlVariableBinding))
#define TRACKER_SPARQL_VARIABLE_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_VARIABLE_BINDING, TrackerSparqlVariableBindingClass))
#define TRACKER_SPARQL_IS_VARIABLE_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING))
#define TRACKER_SPARQL_IS_VARIABLE_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_VARIABLE_BINDING))
#define TRACKER_SPARQL_VARIABLE_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING, TrackerSparqlVariableBindingClass))

typedef struct _TrackerSparqlVariableBinding TrackerSparqlVariableBinding;
typedef struct _TrackerSparqlVariableBindingClass TrackerSparqlVariableBindingClass;
typedef struct _TrackerSparqlVariableBindingPrivate TrackerSparqlVariableBindingPrivate;

#define TRACKER_SPARQL_TYPE_VARIABLE (tracker_sparql_variable_get_type ())
#define TRACKER_SPARQL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_VARIABLE, TrackerSparqlVariable))
#define TRACKER_SPARQL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_VARIABLE, TrackerSparqlVariableClass))
#define TRACKER_SPARQL_IS_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_VARIABLE))
#define TRACKER_SPARQL_IS_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_VARIABLE))
#define TRACKER_SPARQL_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_VARIABLE, TrackerSparqlVariableClass))

typedef struct _TrackerSparqlVariable TrackerSparqlVariable;
typedef struct _TrackerSparqlVariableClass TrackerSparqlVariableClass;

#define TRACKER_SPARQL_TYPE_VARIABLE_BINDING_LIST (tracker_sparql_variable_binding_list_get_type ())
#define TRACKER_SPARQL_VARIABLE_BINDING_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING_LIST, TrackerSparqlVariableBindingList))
#define TRACKER_SPARQL_VARIABLE_BINDING_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_VARIABLE_BINDING_LIST, TrackerSparqlVariableBindingListClass))
#define TRACKER_SPARQL_IS_VARIABLE_BINDING_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING_LIST))
#define TRACKER_SPARQL_IS_VARIABLE_BINDING_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_VARIABLE_BINDING_LIST))
#define TRACKER_SPARQL_VARIABLE_BINDING_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING_LIST, TrackerSparqlVariableBindingListClass))

typedef struct _TrackerSparqlVariableBindingList TrackerSparqlVariableBindingList;
typedef struct _TrackerSparqlVariableBindingListClass TrackerSparqlVariableBindingListClass;
typedef struct _TrackerSparqlVariableBindingListPrivate TrackerSparqlVariableBindingListPrivate;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _TrackerSparqlVariablePrivate TrackerSparqlVariablePrivate;

#define TRACKER_SPARQL_TYPE_CONTEXT (tracker_sparql_context_get_type ())
#define TRACKER_SPARQL_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_CONTEXT, TrackerSparqlContext))
#define TRACKER_SPARQL_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_CONTEXT, TrackerSparqlContextClass))
#define TRACKER_SPARQL_IS_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_CONTEXT))
#define TRACKER_SPARQL_IS_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_CONTEXT))
#define TRACKER_SPARQL_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_CONTEXT, TrackerSparqlContextClass))

typedef struct _TrackerSparqlContext TrackerSparqlContext;
typedef struct _TrackerSparqlContextClass TrackerSparqlContextClass;
typedef struct _TrackerSparqlContextPrivate TrackerSparqlContextPrivate;

#define TRACKER_SPARQL_TYPE_QUERY (tracker_sparql_query_get_type ())
#define TRACKER_SPARQL_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_QUERY, TrackerSparqlQuery))
#define TRACKER_SPARQL_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_QUERY, TrackerSparqlQueryClass))
#define TRACKER_SPARQL_IS_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_QUERY))
#define TRACKER_SPARQL_IS_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_QUERY))
#define TRACKER_SPARQL_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_QUERY, TrackerSparqlQueryClass))

typedef struct _TrackerSparqlQuery TrackerSparqlQuery;
typedef struct _TrackerSparqlQueryClass TrackerSparqlQueryClass;
#define _tracker_sparql_context_unref0(var) ((var == NULL) ? NULL : (var = (tracker_sparql_context_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _TrackerSparqlQueryPrivate TrackerSparqlQueryPrivate;

#define TRACKER_SPARQL_TYPE_EXPRESSION (tracker_sparql_expression_get_type ())
#define TRACKER_SPARQL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_EXPRESSION, TrackerSparqlExpression))
#define TRACKER_SPARQL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_EXPRESSION, TrackerSparqlExpressionClass))
#define TRACKER_SPARQL_IS_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_EXPRESSION))
#define TRACKER_SPARQL_IS_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_EXPRESSION))
#define TRACKER_SPARQL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_EXPRESSION, TrackerSparqlExpressionClass))

typedef struct _TrackerSparqlExpression TrackerSparqlExpression;
typedef struct _TrackerSparqlExpressionClass TrackerSparqlExpressionClass;

#define TRACKER_SPARQL_TYPE_PATTERN (tracker_sparql_pattern_get_type ())
#define TRACKER_SPARQL_PATTERN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_PATTERN, TrackerSparqlPattern))
#define TRACKER_SPARQL_PATTERN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_PATTERN, TrackerSparqlPatternClass))
#define TRACKER_SPARQL_IS_PATTERN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_PATTERN))
#define TRACKER_SPARQL_IS_PATTERN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_PATTERN))
#define TRACKER_SPARQL_PATTERN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_PATTERN, TrackerSparqlPatternClass))

typedef struct _TrackerSparqlPattern TrackerSparqlPattern;
typedef struct _TrackerSparqlPatternClass TrackerSparqlPatternClass;
typedef struct _TrackerSparqlParamSpecContext TrackerSparqlParamSpecContext;

#define TRACKER_SPARQL_TYPE_SELECT_CONTEXT (tracker_sparql_select_context_get_type ())
#define TRACKER_SPARQL_SELECT_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContext))
#define TRACKER_SPARQL_SELECT_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContextClass))
#define TRACKER_SPARQL_IS_SELECT_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_SELECT_CONTEXT))
#define TRACKER_SPARQL_IS_SELECT_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_SELECT_CONTEXT))
#define TRACKER_SPARQL_SELECT_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContextClass))

typedef struct _TrackerSparqlSelectContext TrackerSparqlSelectContext;
typedef struct _TrackerSparqlSelectContextClass TrackerSparqlSelectContextClass;
typedef struct _TrackerSparqlSelectContextPrivate TrackerSparqlSelectContextPrivate;

#define TRACKER_SPARQL_TYPE_SOLUTION (tracker_sparql_solution_get_type ())
#define TRACKER_SPARQL_SOLUTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_SOLUTION, TrackerSparqlSolution))
#define TRACKER_SPARQL_SOLUTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_SOLUTION, TrackerSparqlSolutionClass))
#define TRACKER_SPARQL_IS_SOLUTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_SOLUTION))
#define TRACKER_SPARQL_IS_SOLUTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_SOLUTION))
#define TRACKER_SPARQL_SOLUTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_SOLUTION, TrackerSparqlSolutionClass))

typedef struct _TrackerSparqlSolution TrackerSparqlSolution;
typedef struct _TrackerSparqlSolutionClass TrackerSparqlSolutionClass;
typedef struct _TrackerSparqlSolutionPrivate TrackerSparqlSolutionPrivate;
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _TrackerSparqlParamSpecSolution TrackerSparqlParamSpecSolution;

#define TRACKER_TYPE_SPARQL_SCANNER (tracker_sparql_scanner_get_type ())
#define TRACKER_SPARQL_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_SPARQL_SCANNER, TrackerSparqlScanner))
#define TRACKER_SPARQL_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_SPARQL_SCANNER, TrackerSparqlScannerClass))
#define TRACKER_IS_SPARQL_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_SPARQL_SCANNER))
#define TRACKER_IS_SPARQL_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_SPARQL_SCANNER))
#define TRACKER_SPARQL_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_SPARQL_SCANNER, TrackerSparqlScannerClass))

typedef struct _TrackerSparqlScanner TrackerSparqlScanner;
typedef struct _TrackerSparqlScannerClass TrackerSparqlScannerClass;

#define TRACKER_SPARQL_QUERY_TYPE_TOKEN_INFO (tracker_sparql_query_token_info_get_type ())

#define TRACKER_TYPE_SPARQL_TOKEN_TYPE (tracker_sparql_token_type_get_type ())

#define TRACKER_TYPE_SOURCE_LOCATION (tracker_source_location_get_type ())
typedef struct _TrackerSourceLocation TrackerSourceLocation;
typedef struct _TrackerSparqlQueryTokenInfo TrackerSparqlQueryTokenInfo;
#define _g_checksum_free0(var) ((var == NULL) ? NULL : (var = (g_checksum_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_builder_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _tracker_source_location_free0(var) ((var == NULL) ? NULL : (var = (tracker_source_location_free (var), NULL)))
typedef struct _TrackerSparqlPatternPrivate TrackerSparqlPatternPrivate;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _tracker_sparql_solution_unref0(var) ((var == NULL) ? NULL : (var = (tracker_sparql_solution_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	TRACKER_SPARQL_VARIABLE_STATE_NONE,
	TRACKER_SPARQL_VARIABLE_STATE_BOUND,
	TRACKER_SPARQL_VARIABLE_STATE_OPTIONAL
} TrackerSparqlVariableState;

typedef enum  {
	TRACKER_SPARQL_UPDATE_TYPE_DELETE,
	TRACKER_SPARQL_UPDATE_TYPE_INSERT,
	TRACKER_SPARQL_UPDATE_TYPE_UPDATE
} TrackerSparqlUpdateType;

struct _TrackerSparqlDataTable {
	GObject parent_instance;
	TrackerSparqlDataTablePrivate * priv;
	gchar* sql_db_tablename;
	gchar* sql_query_tablename;
	TrackerSparqlPredicateVariable* predicate_variable;
};

struct _TrackerSparqlDataTableClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlDataBinding {
	GObject parent_instance;
	TrackerSparqlDataBindingPrivate * priv;
	TrackerPropertyType data_type;
	TrackerSparqlDataTable* table;
	gchar* sql_db_column_name;
};

struct _TrackerSparqlDataBindingClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlDataBindingPrivate {
	gchar* _sql_expression;
};

struct _TrackerSparqlLiteralBinding {
	TrackerSparqlDataBinding parent_instance;
	TrackerSparqlLiteralBindingPrivate * priv;
	gboolean is_fts_match;
	gchar* literal;
};

struct _TrackerSparqlLiteralBindingClass {
	TrackerSparqlDataBindingClass parent_class;
};

struct _TrackerSparqlVariableBinding {
	TrackerSparqlDataBinding parent_instance;
	TrackerSparqlVariableBindingPrivate * priv;
	TrackerSparqlVariable* variable;
	gboolean maybe_null;
	gboolean in_simple_optional;
	TrackerClass* type;
};

struct _TrackerSparqlVariableBindingClass {
	TrackerSparqlDataBindingClass parent_class;
};

struct _TrackerSparqlVariableBindingList {
	GObject parent_instance;
	TrackerSparqlVariableBindingListPrivate * priv;
	GList* list;
};

struct _TrackerSparqlVariableBindingListClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlVariable {
	GObject parent_instance;
	TrackerSparqlVariablePrivate * priv;
	TrackerSparqlVariableBinding* binding;
};

struct _TrackerSparqlVariableClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlVariablePrivate {
	gchar* _name;
	gint _index;
	gchar* _sql_expression;
	gchar* sql_identifier;
};

struct _TrackerSparqlContext {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TrackerSparqlContextPrivate * priv;
	TrackerSparqlQuery* query;
	TrackerSparqlContext* parent_context;
	GHashTable* var_set;
	GHashTable* var_map;
	GHashTable* select_var_set;
	GHashTable* predicate_variable_map;
	gboolean scalar_subquery;
	gboolean need_binding_expression;
};

struct _TrackerSparqlContextClass {
	GTypeClass parent_class;
	void (*finalize) (TrackerSparqlContext *self);
};

struct _TrackerSparqlQuery {
	GObject parent_instance;
	TrackerSparqlQueryPrivate * priv;
	TrackerSparqlExpression* expression;
	TrackerSparqlPattern* pattern;
	GList* bindings;
	TrackerSparqlContext* context;
	TrackerDataManager* manager;
	gint last_var_index;
};

struct _TrackerSparqlQueryClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlParamSpecContext {
	GParamSpec parent_instance;
};

struct _TrackerSparqlSelectContext {
	TrackerSparqlContext parent_instance;
	TrackerSparqlSelectContextPrivate * priv;
	TrackerPropertyType type;
	TrackerPropertyType* types;
	gint types_length1;
	gint _types_size_;
	gchar** variable_names;
	gint variable_names_length1;
	gint _variable_names_size_;
};

struct _TrackerSparqlSelectContextClass {
	TrackerSparqlContextClass parent_class;
};

struct _TrackerSparqlSolution {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TrackerSparqlSolutionPrivate * priv;
	GHashTable* hash;
	GPtrArray* values;
	gint solution_index;
};

struct _TrackerSparqlSolutionClass {
	GTypeClass parent_class;
	void (*finalize) (TrackerSparqlSolution *self);
};

struct _TrackerSparqlParamSpecSolution {
	GParamSpec parent_instance;
};

typedef enum  {
	TRACKER_SPARQL_TOKEN_TYPE_NONE,
	TRACKER_SPARQL_TOKEN_TYPE_A,
	TRACKER_SPARQL_TOKEN_TYPE_ABS,
	TRACKER_SPARQL_TOKEN_TYPE_AS,
	TRACKER_SPARQL_TOKEN_TYPE_ASC,
	TRACKER_SPARQL_TOKEN_TYPE_ASK,
	TRACKER_SPARQL_TOKEN_TYPE_ATBASE,
	TRACKER_SPARQL_TOKEN_TYPE_ATPREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_AVG,
	TRACKER_SPARQL_TOKEN_TYPE_BASE,
	TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE,
	TRACKER_SPARQL_TOKEN_TYPE_BIND,
	TRACKER_SPARQL_TOKEN_TYPE_BOUND,
	TRACKER_SPARQL_TOKEN_TYPE_BY,
	TRACKER_SPARQL_TOKEN_TYPE_CEIL,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACKET,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS,
	TRACKER_SPARQL_TOKEN_TYPE_COALESCE,
	TRACKER_SPARQL_TOKEN_TYPE_COLON,
	TRACKER_SPARQL_TOKEN_TYPE_CONCAT,
	TRACKER_SPARQL_TOKEN_TYPE_CONTAINS,
	TRACKER_SPARQL_TOKEN_TYPE_COMMA,
	TRACKER_SPARQL_TOKEN_TYPE_CONSTRUCT,
	TRACKER_SPARQL_TOKEN_TYPE_COUNT,
	TRACKER_SPARQL_TOKEN_TYPE_DATA,
	TRACKER_SPARQL_TOKEN_TYPE_DATATYPE,
	TRACKER_SPARQL_TOKEN_TYPE_DAY,
	TRACKER_SPARQL_TOKEN_TYPE_DECIMAL,
	TRACKER_SPARQL_TOKEN_TYPE_DELETE,
	TRACKER_SPARQL_TOKEN_TYPE_DESC,
	TRACKER_SPARQL_TOKEN_TYPE_DESCRIBE,
	TRACKER_SPARQL_TOKEN_TYPE_DISTINCT,
	TRACKER_SPARQL_TOKEN_TYPE_DIV,
	TRACKER_SPARQL_TOKEN_TYPE_DOT,
	TRACKER_SPARQL_TOKEN_TYPE_DOUBLE,
	TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX,
	TRACKER_SPARQL_TOKEN_TYPE_DROP,
	TRACKER_SPARQL_TOKEN_TYPE_ENCODE_FOR_URI,
	TRACKER_SPARQL_TOKEN_TYPE_EOF,
	TRACKER_SPARQL_TOKEN_TYPE_EXISTS,
	TRACKER_SPARQL_TOKEN_TYPE_FALSE,
	TRACKER_SPARQL_TOKEN_TYPE_FILTER,
	TRACKER_SPARQL_TOKEN_TYPE_FLOOR,
	TRACKER_SPARQL_TOKEN_TYPE_FROM,
	TRACKER_SPARQL_TOKEN_TYPE_GRAPH,
	TRACKER_SPARQL_TOKEN_TYPE_GROUP,
	TRACKER_SPARQL_TOKEN_TYPE_GROUP_CONCAT,
	TRACKER_SPARQL_TOKEN_TYPE_HAVING,
	TRACKER_SPARQL_TOKEN_TYPE_HOURS,
	TRACKER_SPARQL_TOKEN_TYPE_IF,
	TRACKER_SPARQL_TOKEN_TYPE_INSERT,
	TRACKER_SPARQL_TOKEN_TYPE_INTEGER,
	TRACKER_SPARQL_TOKEN_TYPE_INTO,
	TRACKER_SPARQL_TOKEN_TYPE_IRI_REF,
	TRACKER_SPARQL_TOKEN_TYPE_ISBLANK,
	TRACKER_SPARQL_TOKEN_TYPE_ISIRI,
	TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL,
	TRACKER_SPARQL_TOKEN_TYPE_ISURI,
	TRACKER_SPARQL_TOKEN_TYPE_LANG,
	TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES,
	TRACKER_SPARQL_TOKEN_TYPE_LCASE,
	TRACKER_SPARQL_TOKEN_TYPE_LIMIT,
	TRACKER_SPARQL_TOKEN_TYPE_MAX,
	TRACKER_SPARQL_TOKEN_TYPE_MD5,
	TRACKER_SPARQL_TOKEN_TYPE_MIN,
	TRACKER_SPARQL_TOKEN_TYPE_MINUS,
	TRACKER_SPARQL_TOKEN_TYPE_MINUTES,
	TRACKER_SPARQL_TOKEN_TYPE_MONTH,
	TRACKER_SPARQL_TOKEN_TYPE_NAMED,
	TRACKER_SPARQL_TOKEN_TYPE_NOT,
	TRACKER_SPARQL_TOKEN_TYPE_NOW,
	TRACKER_SPARQL_TOKEN_TYPE_NULL,
	TRACKER_SPARQL_TOKEN_TYPE_OFFSET,
	TRACKER_SPARQL_TOKEN_TYPE_OP_AND,
	TRACKER_SPARQL_TOKEN_TYPE_OP_EQ,
	TRACKER_SPARQL_TOKEN_TYPE_OP_GE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_GT,
	TRACKER_SPARQL_TOKEN_TYPE_OP_LE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_LT,
	TRACKER_SPARQL_TOKEN_TYPE_OP_NE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_NEG,
	TRACKER_SPARQL_TOKEN_TYPE_OP_OR,
	TRACKER_SPARQL_TOKEN_TYPE_OP_IN,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS,
	TRACKER_SPARQL_TOKEN_TYPE_OPTIONAL,
	TRACKER_SPARQL_TOKEN_TYPE_OR,
	TRACKER_SPARQL_TOKEN_TYPE_ORDER,
	TRACKER_SPARQL_TOKEN_TYPE_PLUS,
	TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_PREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_RAND,
	TRACKER_SPARQL_TOKEN_TYPE_REDUCED,
	TRACKER_SPARQL_TOKEN_TYPE_REGEX,
	TRACKER_SPARQL_TOKEN_TYPE_REPLACE,
	TRACKER_SPARQL_TOKEN_TYPE_ROUND,
	TRACKER_SPARQL_TOKEN_TYPE_SAMETERM,
	TRACKER_SPARQL_TOKEN_TYPE_SECONDS,
	TRACKER_SPARQL_TOKEN_TYPE_SELECT,
	TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON,
	TRACKER_SPARQL_TOKEN_TYPE_SHA1,
	TRACKER_SPARQL_TOKEN_TYPE_SHA256,
	TRACKER_SPARQL_TOKEN_TYPE_SHA512,
	TRACKER_SPARQL_TOKEN_TYPE_SILENT,
	TRACKER_SPARQL_TOKEN_TYPE_STAR,
	TRACKER_SPARQL_TOKEN_TYPE_STR,
	TRACKER_SPARQL_TOKEN_TYPE_STRAFTER,
	TRACKER_SPARQL_TOKEN_TYPE_STRBEFORE,
	TRACKER_SPARQL_TOKEN_TYPE_STRENDS,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2,
	TRACKER_SPARQL_TOKEN_TYPE_STRLEN,
	TRACKER_SPARQL_TOKEN_TYPE_STRSTARTS,
	TRACKER_SPARQL_TOKEN_TYPE_SUBSTR,
	TRACKER_SPARQL_TOKEN_TYPE_SUM,
	TRACKER_SPARQL_TOKEN_TYPE_TRUE,
	TRACKER_SPARQL_TOKEN_TYPE_UCASE,
	TRACKER_SPARQL_TOKEN_TYPE_UNION,
	TRACKER_SPARQL_TOKEN_TYPE_VAR,
	TRACKER_SPARQL_TOKEN_TYPE_WHERE,
	TRACKER_SPARQL_TOKEN_TYPE_WITH,
	TRACKER_SPARQL_TOKEN_TYPE_YEAR
} TrackerSparqlTokenType;

struct _TrackerSourceLocation {
	gchar* pos;
	gint line;
	gint column;
};

struct _TrackerSparqlQueryTokenInfo {
	TrackerSparqlTokenType type;
	TrackerSourceLocation begin;
	TrackerSourceLocation end;
};

struct _TrackerSparqlQueryPrivate {
	TrackerSparqlScanner* scanner;
	TrackerSparqlQueryTokenInfo* tokens;
	gint tokens_length1;
	gint _tokens_size_;
	gint index;
	gint size;
	gchar* query_string;
	gboolean update_extensions;
	gchar* current_graph;
	gchar* current_subject;
	gboolean current_subject_is_var;
	gchar* current_predicate;
	gboolean current_predicate_is_var;
	gboolean silent;
	GHashTable* prefix_map;
	gint bnodeid;
	guchar* base_uuid;
	gint base_uuid_length1;
	gint _base_uuid_size_;
	GHashTable* blank_nodes;
	gboolean _no_cache;
	gboolean anon_blank_node_open;
};

struct _TrackerSparqlPattern {
	GObject parent_instance;
	TrackerSparqlPatternPrivate * priv;
	gchar* current_graph;
	TrackerSparqlVariable* fts_subject;
	gchar** fts_variables;
	gint fts_variables_length1;
	gint _fts_variables_size_;
	GString* match_str;
	gboolean queries_fts_data;
};

struct _TrackerSparqlPatternClass {
	GObjectClass parent_class;
};


static gpointer tracker_sparql_data_table_parent_class = NULL;
static gpointer tracker_sparql_data_binding_parent_class = NULL;
static gpointer tracker_sparql_literal_binding_parent_class = NULL;
static gpointer tracker_sparql_variable_binding_parent_class = NULL;
static gpointer tracker_sparql_variable_binding_list_parent_class = NULL;
static gpointer tracker_sparql_variable_parent_class = NULL;
static gpointer tracker_sparql_context_parent_class = NULL;
static gpointer tracker_sparql_select_context_parent_class = NULL;
static gpointer tracker_sparql_solution_parent_class = NULL;
static gpointer tracker_sparql_query_parent_class = NULL;

GType tracker_sparql_variable_state_get_type (void) G_GNUC_CONST;
GType tracker_sparql_update_type_get_type (void) G_GNUC_CONST;
GType tracker_sparql_data_table_get_type (void) G_GNUC_CONST;
GType tracker_sparql_predicate_variable_get_type (void) G_GNUC_CONST;
enum  {
	TRACKER_SPARQL_DATA_TABLE_DUMMY_PROPERTY
};
TrackerSparqlDataTable* tracker_sparql_data_table_new (void);
TrackerSparqlDataTable* tracker_sparql_data_table_construct (GType object_type);
static void tracker_sparql_data_table_finalize (GObject * obj);
GType tracker_sparql_data_binding_get_type (void) G_GNUC_CONST;
#define TRACKER_SPARQL_DATA_BINDING_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_SPARQL_TYPE_DATA_BINDING, TrackerSparqlDataBindingPrivate))
enum  {
	TRACKER_SPARQL_DATA_BINDING_DUMMY_PROPERTY,
	TRACKER_SPARQL_DATA_BINDING_SQL_EXPRESSION
};
gchar* tracker_sparql_data_binding_get_extra_sql_expression (TrackerSparqlDataBinding* self, const gchar* suffix);
TrackerSparqlDataBinding* tracker_sparql_data_binding_construct (GType object_type);
const gchar* tracker_sparql_data_binding_get_sql_expression (TrackerSparqlDataBinding* self);
void tracker_sparql_data_binding_set_sql_expression (TrackerSparqlDataBinding* self, const gchar* value);
static void tracker_sparql_data_binding_finalize (GObject * obj);
static void _vala_tracker_sparql_data_binding_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_tracker_sparql_data_binding_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType tracker_sparql_literal_binding_get_type (void) G_GNUC_CONST;
enum  {
	TRACKER_SPARQL_LITERAL_BINDING_DUMMY_PROPERTY
};
TrackerSparqlLiteralBinding* tracker_sparql_literal_binding_new (void);
TrackerSparqlLiteralBinding* tracker_sparql_literal_binding_construct (GType object_type);
static void tracker_sparql_literal_binding_finalize (GObject * obj);
GType tracker_sparql_variable_binding_get_type (void) G_GNUC_CONST;
GType tracker_sparql_variable_get_type (void) G_GNUC_CONST;
enum  {
	TRACKER_SPARQL_VARIABLE_BINDING_DUMMY_PROPERTY
};
TrackerSparqlVariableBinding* tracker_sparql_variable_binding_new (void);
TrackerSparqlVariableBinding* tracker_sparql_variable_binding_construct (GType object_type);
static void tracker_sparql_variable_binding_finalize (GObject * obj);
GType tracker_sparql_variable_binding_list_get_type (void) G_GNUC_CONST;
enum  {
	TRACKER_SPARQL_VARIABLE_BINDING_LIST_DUMMY_PROPERTY
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
TrackerSparqlVariableBindingList* tracker_sparql_variable_binding_list_new (void);
TrackerSparqlVariableBindingList* tracker_sparql_variable_binding_list_construct (GType object_type);
static void tracker_sparql_variable_binding_list_finalize (GObject * obj);
#define TRACKER_SPARQL_VARIABLE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_SPARQL_TYPE_VARIABLE, TrackerSparqlVariablePrivate))
enum  {
	TRACKER_SPARQL_VARIABLE_DUMMY_PROPERTY,
	TRACKER_SPARQL_VARIABLE_NAME,
	TRACKER_SPARQL_VARIABLE_INDEX,
	TRACKER_SPARQL_VARIABLE_SQL_EXPRESSION
};
TrackerSparqlVariable* tracker_sparql_variable_new (const gchar* name, gint index);
TrackerSparqlVariable* tracker_sparql_variable_construct (GType object_type, const gchar* name, gint index);
static void tracker_sparql_variable_set_name (TrackerSparqlVariable* self, const gchar* value);
static void tracker_sparql_variable_set_index (TrackerSparqlVariable* self, gint value);
static void tracker_sparql_variable_set_sql_expression (TrackerSparqlVariable* self, const gchar* value);
gchar* tracker_sparql_variable_get_extra_sql_expression (TrackerSparqlVariable* self, const gchar* suffix);
gboolean tracker_sparql_variable_equal (TrackerSparqlVariable* a, TrackerSparqlVariable* b);
gint tracker_sparql_variable_get_index (TrackerSparqlVariable* self);
guint tracker_sparql_variable_hash (TrackerSparqlVariable* variable);
const gchar* tracker_sparql_variable_get_name (TrackerSparqlVariable* self);
const gchar* tracker_sparql_variable_get_sql_expression (TrackerSparqlVariable* self);
static void tracker_sparql_variable_finalize (GObject * obj);
static void _vala_tracker_sparql_variable_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_tracker_sparql_variable_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
gpointer tracker_sparql_context_ref (gpointer instance);
void tracker_sparql_context_unref (gpointer instance);
GParamSpec* tracker_sparql_param_spec_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void tracker_sparql_value_set_context (GValue* value, gpointer v_object);
void tracker_sparql_value_take_context (GValue* value, gpointer v_object);
gpointer tracker_sparql_value_get_context (const GValue* value);
GType tracker_sparql_context_get_type (void) G_GNUC_CONST;
GType tracker_sparql_query_get_type (void) G_GNUC_CONST;
enum  {
	TRACKER_SPARQL_CONTEXT_DUMMY_PROPERTY
};
TrackerSparqlContext* tracker_sparql_context_new (TrackerSparqlQuery* query, TrackerSparqlContext* parent_context);
TrackerSparqlContext* tracker_sparql_context_construct (GType object_type, TrackerSparqlQuery* query, TrackerSparqlContext* parent_context);
static guint _tracker_sparql_variable_hash_ghash_func (gconstpointer key);
static gboolean _tracker_sparql_variable_equal_gequal_func (gconstpointer a, gconstpointer b);
TrackerSparqlContext* tracker_sparql_context_new_subquery (TrackerSparqlQuery* query, TrackerSparqlContext* parent_context);
TrackerSparqlContext* tracker_sparql_context_construct_subquery (GType object_type, TrackerSparqlQuery* query, TrackerSparqlContext* parent_context);
TrackerSparqlVariable* tracker_sparql_context_get_variable (TrackerSparqlContext* self, const gchar* name);
GType tracker_sparql_expression_get_type (void) G_GNUC_CONST;
GType tracker_sparql_pattern_get_type (void) G_GNUC_CONST;
static void tracker_sparql_context_finalize (TrackerSparqlContext * obj);
GType tracker_sparql_select_context_get_type (void) G_GNUC_CONST;
enum  {
	TRACKER_SPARQL_SELECT_CONTEXT_DUMMY_PROPERTY
};
TrackerSparqlSelectContext* tracker_sparql_select_context_new (TrackerSparqlQuery* query, TrackerSparqlContext* parent_context);
TrackerSparqlSelectContext* tracker_sparql_select_context_construct (GType object_type, TrackerSparqlQuery* query, TrackerSparqlContext* parent_context);
TrackerSparqlSelectContext* tracker_sparql_select_context_new_subquery (TrackerSparqlQuery* query, TrackerSparqlContext* parent_context);
TrackerSparqlSelectContext* tracker_sparql_select_context_construct_subquery (GType object_type, TrackerSparqlQuery* query, TrackerSparqlContext* parent_context);
static void tracker_sparql_select_context_finalize (TrackerSparqlContext * obj);
gpointer tracker_sparql_solution_ref (gpointer instance);
void tracker_sparql_solution_unref (gpointer instance);
GParamSpec* tracker_sparql_param_spec_solution (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void tracker_sparql_value_set_solution (GValue* value, gpointer v_object);
void tracker_sparql_value_take_solution (GValue* value, gpointer v_object);
gpointer tracker_sparql_value_get_solution (const GValue* value);
GType tracker_sparql_solution_get_type (void) G_GNUC_CONST;
enum  {
	TRACKER_SPARQL_SOLUTION_DUMMY_PROPERTY
};
TrackerSparqlSolution* tracker_sparql_solution_new (void);
TrackerSparqlSolution* tracker_sparql_solution_construct (GType object_type);
static void _g_free0_ (gpointer var);
gchar* tracker_sparql_solution_lookup (TrackerSparqlSolution* self, const gchar* variable_name);
static void tracker_sparql_solution_finalize (TrackerSparqlSolution * obj);
GType tracker_sparql_scanner_get_type (void) G_GNUC_CONST;
static GType tracker_sparql_query_token_info_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
GType tracker_sparql_token_type_get_type (void) G_GNUC_CONST;
GType tracker_source_location_get_type (void) G_GNUC_CONST;
TrackerSourceLocation* tracker_source_location_dup (const TrackerSourceLocation* self);
void tracker_source_location_free (TrackerSourceLocation* self);
static TrackerSparqlQueryTokenInfo* tracker_sparql_query_token_info_dup (const TrackerSparqlQueryTokenInfo* self);
static void tracker_sparql_query_token_info_free (TrackerSparqlQueryTokenInfo* self);
#define TRACKER_SPARQL_QUERY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_SPARQL_TYPE_QUERY, TrackerSparqlQueryPrivate))
enum  {
	TRACKER_SPARQL_QUERY_DUMMY_PROPERTY,
	TRACKER_SPARQL_QUERY_NO_CACHE
};
#define TRACKER_SPARQL_QUERY_BUFFER_SIZE 32
#define TRACKER_SPARQL_QUERY_FN_NS "http://www.w3.org/2005/xpath-functions#"
TrackerSparqlQuery* tracker_sparql_query_new (TrackerDataManager* manager, const gchar* query);
TrackerSparqlQuery* tracker_sparql_query_construct (GType object_type, TrackerDataManager* manager, const gchar* query);
void tracker_sparql_query_set_no_cache (TrackerSparqlQuery* self, gboolean value);
void uuid_generate (guchar* uuid);
TrackerSparqlExpression* tracker_sparql_expression_new (TrackerSparqlQuery* query);
TrackerSparqlExpression* tracker_sparql_expression_construct (GType object_type, TrackerSparqlQuery* query);
TrackerSparqlPattern* tracker_sparql_pattern_new (TrackerSparqlQuery* query);
TrackerSparqlPattern* tracker_sparql_pattern_construct (GType object_type, TrackerSparqlQuery* query);
TrackerSparqlQuery* tracker_sparql_query_new_update (TrackerDataManager* manager, const gchar* query);
TrackerSparqlQuery* tracker_sparql_query_construct_update (GType object_type, TrackerDataManager* manager, const gchar* query);
static gchar* tracker_sparql_query_get_uuid_for_name (TrackerSparqlQuery* self, guchar* base_uuid, int base_uuid_length1, const gchar* name);
gchar* tracker_sparql_query_generate_bnodeid (TrackerSparqlQuery* self, const gchar* user_bnodeid);
gboolean tracker_sparql_query_next (TrackerSparqlQuery* self, GError** error);
TrackerSparqlTokenType tracker_sparql_scanner_read_token (TrackerSparqlScanner* self, TrackerSourceLocation* token_begin, TrackerSourceLocation* token_end, GError** error);
TrackerSparqlTokenType tracker_sparql_query_current (TrackerSparqlQuery* self);
TrackerSparqlTokenType tracker_sparql_query_last (TrackerSparqlQuery* self);
gboolean tracker_sparql_query_accept (TrackerSparqlQuery* self, TrackerSparqlTokenType type, GError** error);
void tracker_sparql_query_optional (TrackerSparqlQuery* self, TrackerSparqlTokenType type, GError** error);
GError* tracker_sparql_query_get_error (TrackerSparqlQuery* self, const gchar* msg);
GError* tracker_sparql_query_get_internal_error (TrackerSparqlQuery* self, const gchar* msg);
gboolean tracker_sparql_query_expect (TrackerSparqlQuery* self, TrackerSparqlTokenType type, GError** error);
const gchar* tracker_sparql_token_type_to_string (TrackerSparqlTokenType self);
void tracker_sparql_query_get_location (TrackerSparqlQuery* self, TrackerSourceLocation* result);
void tracker_sparql_query_set_location (TrackerSparqlQuery* self, TrackerSourceLocation* location);
void tracker_sparql_scanner_seek (TrackerSparqlScanner* self, TrackerSourceLocation* location);
gchar* tracker_sparql_query_get_last_string (TrackerSparqlQuery* self, gint strip);
static void tracker_sparql_query_parse_prologue (TrackerSparqlQuery* self, GError** error);
static void tracker_sparql_query_prepare_execute (TrackerSparqlQuery* self, GError** error);
TrackerSparqlScanner* tracker_sparql_scanner_new (gchar* input, gsize len);
TrackerSparqlScanner* tracker_sparql_scanner_construct (GType object_type, gchar* input, gsize len);
TrackerDBCursor* tracker_sparql_query_execute_cursor (TrackerSparqlQuery* self, GError** error);
static TrackerDBCursor* tracker_sparql_query_execute_select_cursor (TrackerSparqlQuery* self, GError** error);
static TrackerDBCursor* tracker_sparql_query_execute_ask_cursor (TrackerSparqlQuery* self, GError** error);
GVariant* tracker_sparql_query_execute_update (TrackerSparqlQuery* self, gboolean blank, GError** error);
static void tracker_sparql_query_execute_insert_delete (TrackerSparqlQuery* self, GVariantBuilder* update_blank_nodes, GError** error);
static TrackerDBStatement* tracker_sparql_query_prepare_for_exec (TrackerSparqlQuery* self, TrackerDBInterface* iface, const gchar* sql, GError** error);
gboolean tracker_sparql_query_get_no_cache (TrackerSparqlQuery* self);
static TrackerDBCursor* tracker_sparql_query_exec_sql_cursor (TrackerSparqlQuery* self, TrackerDBInterface* iface, const gchar* sql, TrackerPropertyType* types, int types_length1, gchar** variable_names, int variable_names_length1, GError** error);
static gchar* tracker_sparql_query_get_select_query (TrackerSparqlQuery* self, TrackerSparqlSelectContext* * context, GError** error);
TrackerSparqlSelectContext* tracker_sparql_pattern_translate_select (TrackerSparqlPattern* self, GString* sql, gboolean subquery, gboolean scalar_subquery, GError** error);
static gchar* tracker_sparql_query_get_ask_query (TrackerSparqlQuery* self, GError** error);
TrackerSparqlContext* tracker_sparql_pattern_translate_group_graph_pattern (TrackerSparqlPattern* self, GString* sql, GError** error);
static void tracker_sparql_query_parse_from_or_into_param (TrackerSparqlQuery* self, GError** error);
gchar* tracker_sparql_query_resolve_prefixed_name (TrackerSparqlQuery* self, const gchar* prefix, const gchar* local_name, GError** error);
static void tracker_sparql_query_skip_braces (TrackerSparqlQuery* self, GError** error);
static gint tracker_sparql_query_quad_data_unbound_var_count (TrackerSparqlQuery* self, GError** error);
void tracker_sparql_expression_append_expression_as_string (GString* sql, const gchar* expression, TrackerPropertyType type);
static void tracker_sparql_query_parse_construct_triples_block (TrackerSparqlQuery* self, TrackerSparqlSolution* var_value_map, TrackerSparqlUpdateType type, GError** error);
static GVariant* _variant_new1 (GHashTable* value);
static gchar* tracker_sparql_query_parse_construct_var_or_term (TrackerSparqlQuery* self, TrackerSparqlSolution* var_value_map, TrackerSparqlUpdateType type, gboolean* is_null, GError** error);
static void tracker_sparql_query_parse_construct_property_list_not_empty (TrackerSparqlQuery* self, TrackerSparqlSolution* var_value_map, TrackerSparqlUpdateType type, GError** error);
gchar* tracker_sparql_expression_parse_string_literal (TrackerSparqlExpression* self, TrackerPropertyType* type, GError** error);
static void tracker_sparql_query_parse_construct_object_list (TrackerSparqlQuery* self, TrackerSparqlSolution* var_value_map, TrackerSparqlUpdateType type, GError** error);
static void tracker_sparql_query_parse_construct_object (TrackerSparqlQuery* self, TrackerSparqlSolution* var_value_map, TrackerSparqlUpdateType type, GError** error);
static void tracker_sparql_query_finalize (GObject * obj);
static void _vala_tracker_sparql_query_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_tracker_sparql_query_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GType tracker_sparql_variable_state_get_type (void) {
	static volatile gsize tracker_sparql_variable_state_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_variable_state_type_id__volatile)) {
		static const GEnumValue values[] = {{TRACKER_SPARQL_VARIABLE_STATE_NONE, "TRACKER_SPARQL_VARIABLE_STATE_NONE", "none"}, {TRACKER_SPARQL_VARIABLE_STATE_BOUND, "TRACKER_SPARQL_VARIABLE_STATE_BOUND", "bound"}, {TRACKER_SPARQL_VARIABLE_STATE_OPTIONAL, "TRACKER_SPARQL_VARIABLE_STATE_OPTIONAL", "optional"}, {0, NULL, NULL}};
		GType tracker_sparql_variable_state_type_id;
		tracker_sparql_variable_state_type_id = g_enum_register_static ("TrackerSparqlVariableState", values);
		g_once_init_leave (&tracker_sparql_variable_state_type_id__volatile, tracker_sparql_variable_state_type_id);
	}
	return tracker_sparql_variable_state_type_id__volatile;
}


GType tracker_sparql_update_type_get_type (void) {
	static volatile gsize tracker_sparql_update_type_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_update_type_type_id__volatile)) {
		static const GEnumValue values[] = {{TRACKER_SPARQL_UPDATE_TYPE_DELETE, "TRACKER_SPARQL_UPDATE_TYPE_DELETE", "delete"}, {TRACKER_SPARQL_UPDATE_TYPE_INSERT, "TRACKER_SPARQL_UPDATE_TYPE_INSERT", "insert"}, {TRACKER_SPARQL_UPDATE_TYPE_UPDATE, "TRACKER_SPARQL_UPDATE_TYPE_UPDATE", "update"}, {0, NULL, NULL}};
		GType tracker_sparql_update_type_type_id;
		tracker_sparql_update_type_type_id = g_enum_register_static ("TrackerSparqlUpdateType", values);
		g_once_init_leave (&tracker_sparql_update_type_type_id__volatile, tracker_sparql_update_type_type_id);
	}
	return tracker_sparql_update_type_type_id__volatile;
}


TrackerSparqlDataTable* tracker_sparql_data_table_construct (GType object_type) {
	TrackerSparqlDataTable * self = NULL;
#line 34 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self = (TrackerSparqlDataTable*) g_object_new (object_type, NULL);
#line 34 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return self;
#line 803 "tracker-sparql-query.c"
}


TrackerSparqlDataTable* tracker_sparql_data_table_new (void) {
#line 34 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return tracker_sparql_data_table_construct (TRACKER_SPARQL_TYPE_DATA_TABLE);
#line 810 "tracker-sparql-query.c"
}


static void tracker_sparql_data_table_class_init (TrackerSparqlDataTableClass * klass) {
#line 34 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	tracker_sparql_data_table_parent_class = g_type_class_peek_parent (klass);
#line 34 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_data_table_finalize;
#line 819 "tracker-sparql-query.c"
}


static void tracker_sparql_data_table_instance_init (TrackerSparqlDataTable * self) {
}


static void tracker_sparql_data_table_finalize (GObject * obj) {
	TrackerSparqlDataTable * self;
#line 34 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_SPARQL_TYPE_DATA_TABLE, TrackerSparqlDataTable);
#line 35 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_free0 (self->sql_db_tablename);
#line 36 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_free0 (self->sql_query_tablename);
#line 37 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_object_unref0 (self->predicate_variable);
#line 34 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	G_OBJECT_CLASS (tracker_sparql_data_table_parent_class)->finalize (obj);
#line 839 "tracker-sparql-query.c"
}


GType tracker_sparql_data_table_get_type (void) {
	static volatile gsize tracker_sparql_data_table_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_data_table_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlDataTableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_data_table_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlDataTable), 0, (GInstanceInitFunc) tracker_sparql_data_table_instance_init, NULL };
		GType tracker_sparql_data_table_type_id;
		tracker_sparql_data_table_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerSparqlDataTable", &g_define_type_info, 0);
		g_once_init_leave (&tracker_sparql_data_table_type_id__volatile, tracker_sparql_data_table_type_id);
	}
	return tracker_sparql_data_table_type_id__volatile;
}


gchar* tracker_sparql_data_binding_get_extra_sql_expression (TrackerSparqlDataBinding* self, const gchar* suffix) {
	gchar* result = NULL;
	TrackerSparqlDataTable* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
#line 56 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 56 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (suffix != NULL, NULL);
#line 57 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = self->table;
#line 57 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = _tmp0_->sql_query_tablename;
#line 57 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp2_ = self->sql_db_column_name;
#line 57 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp3_ = suffix;
#line 57 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp4_ = g_strdup_printf ("\"%s\".\"%s:%s\"", _tmp1_, _tmp2_, _tmp3_);
#line 57 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	result = _tmp4_;
#line 57 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return result;
#line 880 "tracker-sparql-query.c"
}


TrackerSparqlDataBinding* tracker_sparql_data_binding_construct (GType object_type) {
	TrackerSparqlDataBinding * self = NULL;
#line 40 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self = (TrackerSparqlDataBinding*) g_object_new (object_type, NULL);
#line 40 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return self;
#line 890 "tracker-sparql-query.c"
}


const gchar* tracker_sparql_data_binding_get_sql_expression (TrackerSparqlDataBinding* self) {
	const gchar* result;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	const gchar* _tmp7_;
#line 45 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 46 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = self->priv->_sql_expression;
#line 46 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (_tmp1_ == NULL) {
#line 905 "tracker-sparql-query.c"
		TrackerSparqlDataTable* _tmp2_;
#line 46 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp2_ = self->table;
#line 46 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp0_ = _tmp2_ != NULL;
#line 911 "tracker-sparql-query.c"
	} else {
#line 46 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp0_ = FALSE;
#line 915 "tracker-sparql-query.c"
	}
#line 46 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (_tmp0_) {
#line 919 "tracker-sparql-query.c"
		TrackerSparqlDataTable* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
#line 47 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp3_ = self->table;
#line 47 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp4_ = _tmp3_->sql_query_tablename;
#line 47 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp5_ = self->sql_db_column_name;
#line 47 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp6_ = g_strdup_printf ("\"%s\".\"%s\"", _tmp4_, _tmp5_);
#line 47 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_free0 (self->priv->_sql_expression);
#line 47 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		self->priv->_sql_expression = _tmp6_;
#line 936 "tracker-sparql-query.c"
	}
#line 49 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp7_ = self->priv->_sql_expression;
#line 49 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	result = _tmp7_;
#line 49 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return result;
#line 944 "tracker-sparql-query.c"
}


void tracker_sparql_data_binding_set_sql_expression (TrackerSparqlDataBinding* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 51 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_if_fail (self != NULL);
#line 52 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = value;
#line 52 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 52 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_free0 (self->priv->_sql_expression);
#line 52 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->priv->_sql_expression = _tmp1_;
#line 51 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_object_notify ((GObject *) self, "sql-expression");
#line 963 "tracker-sparql-query.c"
}


static void tracker_sparql_data_binding_class_init (TrackerSparqlDataBindingClass * klass) {
#line 40 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	tracker_sparql_data_binding_parent_class = g_type_class_peek_parent (klass);
#line 40 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_type_class_add_private (klass, sizeof (TrackerSparqlDataBindingPrivate));
#line 40 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_tracker_sparql_data_binding_get_property;
#line 40 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_tracker_sparql_data_binding_set_property;
#line 40 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_data_binding_finalize;
#line 40 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_SPARQL_DATA_BINDING_SQL_EXPRESSION, g_param_spec_string ("sql-expression", "sql-expression", "sql-expression", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 980 "tracker-sparql-query.c"
}


static void tracker_sparql_data_binding_instance_init (TrackerSparqlDataBinding * self) {
#line 40 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->priv = TRACKER_SPARQL_DATA_BINDING_GET_PRIVATE (self);
#line 987 "tracker-sparql-query.c"
}


static void tracker_sparql_data_binding_finalize (GObject * obj) {
	TrackerSparqlDataBinding * self;
#line 40 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_SPARQL_TYPE_DATA_BINDING, TrackerSparqlDataBinding);
#line 42 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_object_unref0 (self->table);
#line 43 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_free0 (self->sql_db_column_name);
#line 55 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_free0 (self->priv->_sql_expression);
#line 40 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	G_OBJECT_CLASS (tracker_sparql_data_binding_parent_class)->finalize (obj);
#line 1003 "tracker-sparql-query.c"
}


GType tracker_sparql_data_binding_get_type (void) {
	static volatile gsize tracker_sparql_data_binding_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_data_binding_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlDataBindingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_data_binding_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlDataBinding), 0, (GInstanceInitFunc) tracker_sparql_data_binding_instance_init, NULL };
		GType tracker_sparql_data_binding_type_id;
		tracker_sparql_data_binding_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerSparqlDataBinding", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&tracker_sparql_data_binding_type_id__volatile, tracker_sparql_data_binding_type_id);
	}
	return tracker_sparql_data_binding_type_id__volatile;
}


static void _vala_tracker_sparql_data_binding_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TrackerSparqlDataBinding * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TRACKER_SPARQL_TYPE_DATA_BINDING, TrackerSparqlDataBinding);
#line 40 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	switch (property_id) {
#line 40 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		case TRACKER_SPARQL_DATA_BINDING_SQL_EXPRESSION:
#line 40 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		g_value_set_string (value, tracker_sparql_data_binding_get_sql_expression (self));
#line 40 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		break;
#line 1030 "tracker-sparql-query.c"
		default:
#line 40 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 40 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		break;
#line 1036 "tracker-sparql-query.c"
	}
}


static void _vala_tracker_sparql_data_binding_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TrackerSparqlDataBinding * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TRACKER_SPARQL_TYPE_DATA_BINDING, TrackerSparqlDataBinding);
#line 40 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	switch (property_id) {
#line 40 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		case TRACKER_SPARQL_DATA_BINDING_SQL_EXPRESSION:
#line 40 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		tracker_sparql_data_binding_set_sql_expression (self, g_value_get_string (value));
#line 40 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		break;
#line 1052 "tracker-sparql-query.c"
		default:
#line 40 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 40 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		break;
#line 1058 "tracker-sparql-query.c"
	}
}


TrackerSparqlLiteralBinding* tracker_sparql_literal_binding_construct (GType object_type) {
	TrackerSparqlLiteralBinding * self = NULL;
#line 62 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self = (TrackerSparqlLiteralBinding*) tracker_sparql_data_binding_construct (object_type);
#line 62 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return self;
#line 1069 "tracker-sparql-query.c"
}


TrackerSparqlLiteralBinding* tracker_sparql_literal_binding_new (void) {
#line 62 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return tracker_sparql_literal_binding_construct (TRACKER_SPARQL_TYPE_LITERAL_BINDING);
#line 1076 "tracker-sparql-query.c"
}


static void tracker_sparql_literal_binding_class_init (TrackerSparqlLiteralBindingClass * klass) {
#line 62 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	tracker_sparql_literal_binding_parent_class = g_type_class_peek_parent (klass);
#line 62 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_literal_binding_finalize;
#line 1085 "tracker-sparql-query.c"
}


static void tracker_sparql_literal_binding_instance_init (TrackerSparqlLiteralBinding * self) {
}


static void tracker_sparql_literal_binding_finalize (GObject * obj) {
	TrackerSparqlLiteralBinding * self;
#line 62 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_SPARQL_TYPE_LITERAL_BINDING, TrackerSparqlLiteralBinding);
#line 64 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_free0 (self->literal);
#line 62 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	G_OBJECT_CLASS (tracker_sparql_literal_binding_parent_class)->finalize (obj);
#line 1101 "tracker-sparql-query.c"
}


GType tracker_sparql_literal_binding_get_type (void) {
	static volatile gsize tracker_sparql_literal_binding_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_literal_binding_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlLiteralBindingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_literal_binding_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlLiteralBinding), 0, (GInstanceInitFunc) tracker_sparql_literal_binding_instance_init, NULL };
		GType tracker_sparql_literal_binding_type_id;
		tracker_sparql_literal_binding_type_id = g_type_register_static (TRACKER_SPARQL_TYPE_DATA_BINDING, "TrackerSparqlLiteralBinding", &g_define_type_info, 0);
		g_once_init_leave (&tracker_sparql_literal_binding_type_id__volatile, tracker_sparql_literal_binding_type_id);
	}
	return tracker_sparql_literal_binding_type_id__volatile;
}


TrackerSparqlVariableBinding* tracker_sparql_variable_binding_construct (GType object_type) {
	TrackerSparqlVariableBinding * self = NULL;
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self = (TrackerSparqlVariableBinding*) tracker_sparql_data_binding_construct (object_type);
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return self;
#line 1123 "tracker-sparql-query.c"
}


TrackerSparqlVariableBinding* tracker_sparql_variable_binding_new (void) {
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return tracker_sparql_variable_binding_construct (TRACKER_SPARQL_TYPE_VARIABLE_BINDING);
#line 1130 "tracker-sparql-query.c"
}


static void tracker_sparql_variable_binding_class_init (TrackerSparqlVariableBindingClass * klass) {
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	tracker_sparql_variable_binding_parent_class = g_type_class_peek_parent (klass);
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_variable_binding_finalize;
#line 1139 "tracker-sparql-query.c"
}


static void tracker_sparql_variable_binding_instance_init (TrackerSparqlVariableBinding * self) {
}


static void tracker_sparql_variable_binding_finalize (GObject * obj) {
	TrackerSparqlVariableBinding * self;
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_SPARQL_TYPE_VARIABLE_BINDING, TrackerSparqlVariableBinding);
#line 73 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_object_unref0 (self->type);
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	G_OBJECT_CLASS (tracker_sparql_variable_binding_parent_class)->finalize (obj);
#line 1155 "tracker-sparql-query.c"
}


GType tracker_sparql_variable_binding_get_type (void) {
	static volatile gsize tracker_sparql_variable_binding_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_variable_binding_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlVariableBindingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_variable_binding_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlVariableBinding), 0, (GInstanceInitFunc) tracker_sparql_variable_binding_instance_init, NULL };
		GType tracker_sparql_variable_binding_type_id;
		tracker_sparql_variable_binding_type_id = g_type_register_static (TRACKER_SPARQL_TYPE_DATA_BINDING, "TrackerSparqlVariableBinding", &g_define_type_info, 0);
		g_once_init_leave (&tracker_sparql_variable_binding_type_id__volatile, tracker_sparql_variable_binding_type_id);
	}
	return tracker_sparql_variable_binding_type_id__volatile;
}


static void _g_object_unref0_ (gpointer var) {
#line 77 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 1174 "tracker-sparql-query.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 77 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 77 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_list_free (self);
#line 1183 "tracker-sparql-query.c"
}


TrackerSparqlVariableBindingList* tracker_sparql_variable_binding_list_construct (GType object_type) {
	TrackerSparqlVariableBindingList * self = NULL;
#line 76 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self = (TrackerSparqlVariableBindingList*) g_object_new (object_type, NULL);
#line 76 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return self;
#line 1193 "tracker-sparql-query.c"
}


TrackerSparqlVariableBindingList* tracker_sparql_variable_binding_list_new (void) {
#line 76 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return tracker_sparql_variable_binding_list_construct (TRACKER_SPARQL_TYPE_VARIABLE_BINDING_LIST);
#line 1200 "tracker-sparql-query.c"
}


static void tracker_sparql_variable_binding_list_class_init (TrackerSparqlVariableBindingListClass * klass) {
#line 76 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	tracker_sparql_variable_binding_list_parent_class = g_type_class_peek_parent (klass);
#line 76 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_variable_binding_list_finalize;
#line 1209 "tracker-sparql-query.c"
}


static void tracker_sparql_variable_binding_list_instance_init (TrackerSparqlVariableBindingList * self) {
}


static void tracker_sparql_variable_binding_list_finalize (GObject * obj) {
	TrackerSparqlVariableBindingList * self;
#line 76 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_SPARQL_TYPE_VARIABLE_BINDING_LIST, TrackerSparqlVariableBindingList);
#line 77 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	__g_list_free__g_object_unref0_0 (self->list);
#line 76 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	G_OBJECT_CLASS (tracker_sparql_variable_binding_list_parent_class)->finalize (obj);
#line 1225 "tracker-sparql-query.c"
}


GType tracker_sparql_variable_binding_list_get_type (void) {
	static volatile gsize tracker_sparql_variable_binding_list_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_variable_binding_list_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlVariableBindingListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_variable_binding_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlVariableBindingList), 0, (GInstanceInitFunc) tracker_sparql_variable_binding_list_instance_init, NULL };
		GType tracker_sparql_variable_binding_list_type_id;
		tracker_sparql_variable_binding_list_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerSparqlVariableBindingList", &g_define_type_info, 0);
		g_once_init_leave (&tracker_sparql_variable_binding_list_type_id__volatile, tracker_sparql_variable_binding_list_type_id);
	}
	return tracker_sparql_variable_binding_list_type_id__volatile;
}


TrackerSparqlVariable* tracker_sparql_variable_construct (GType object_type, const gchar* name, gint index) {
	TrackerSparqlVariable * self = NULL;
	const gchar* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
#line 87 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 87 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self = (TrackerSparqlVariable*) g_object_new (object_type, NULL);
#line 88 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = name;
#line 88 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	tracker_sparql_variable_set_name (self, _tmp0_);
#line 89 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = index;
#line 89 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	tracker_sparql_variable_set_index (self, _tmp1_);
#line 90 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp2_ = index;
#line 90 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp3_ = g_strdup_printf ("%d_u", _tmp2_);
#line 90 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_free0 (self->priv->sql_identifier);
#line 90 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->priv->sql_identifier = _tmp3_;
#line 91 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp4_ = self->priv->sql_identifier;
#line 91 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp5_ = g_strdup_printf ("\"%s\"", _tmp4_);
#line 91 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp6_ = _tmp5_;
#line 91 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	tracker_sparql_variable_set_sql_expression (self, _tmp6_);
#line 91 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_free0 (_tmp6_);
#line 87 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return self;
#line 1282 "tracker-sparql-query.c"
}


TrackerSparqlVariable* tracker_sparql_variable_new (const gchar* name, gint index) {
#line 87 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return tracker_sparql_variable_construct (TRACKER_SPARQL_TYPE_VARIABLE, name, index);
#line 1289 "tracker-sparql-query.c"
}


gchar* tracker_sparql_variable_get_extra_sql_expression (TrackerSparqlVariable* self, const gchar* suffix) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
#line 94 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 94 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (suffix != NULL, NULL);
#line 95 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = self->priv->sql_identifier;
#line 95 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = suffix;
#line 95 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp2_ = g_strdup_printf ("\"%s:%s\"", _tmp0_, _tmp1_);
#line 95 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	result = _tmp2_;
#line 95 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return result;
#line 1312 "tracker-sparql-query.c"
}


gboolean tracker_sparql_variable_equal (TrackerSparqlVariable* a, TrackerSparqlVariable* b) {
	gboolean result = FALSE;
	TrackerSparqlVariable* _tmp0_;
	gint _tmp1_;
	TrackerSparqlVariable* _tmp2_;
	gint _tmp3_;
#line 98 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (a != NULL, FALSE);
#line 98 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (b != NULL, FALSE);
#line 99 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = a;
#line 99 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = _tmp0_->priv->_index;
#line 99 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp2_ = b;
#line 99 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp3_ = _tmp2_->priv->_index;
#line 99 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	result = _tmp1_ == _tmp3_;
#line 99 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return result;
#line 1338 "tracker-sparql-query.c"
}


guint tracker_sparql_variable_hash (TrackerSparqlVariable* variable) {
	guint result = 0U;
	TrackerSparqlVariable* _tmp0_;
	gint _tmp1_;
#line 102 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (variable != NULL, 0U);
#line 103 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = variable;
#line 103 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = _tmp0_->priv->_index;
#line 103 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	result = (guint) _tmp1_;
#line 103 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return result;
#line 1356 "tracker-sparql-query.c"
}


const gchar* tracker_sparql_variable_get_name (TrackerSparqlVariable* self) {
	const gchar* result;
	const gchar* _tmp0_;
#line 81 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 81 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = self->priv->_name;
#line 81 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	result = _tmp0_;
#line 81 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return result;
#line 1371 "tracker-sparql-query.c"
}


static void tracker_sparql_variable_set_name (TrackerSparqlVariable* self, const gchar* value) {
#line 81 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_if_fail (self != NULL);
#line 81 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (g_strcmp0 (value, tracker_sparql_variable_get_name (self)) != 0) {
#line 1380 "tracker-sparql-query.c"
		const gchar* _tmp0_;
		gchar* _tmp1_;
#line 81 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp0_ = value;
#line 81 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp1_ = g_strdup (_tmp0_);
#line 81 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_free0 (self->priv->_name);
#line 81 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		self->priv->_name = _tmp1_;
#line 81 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		g_object_notify ((GObject *) self, "name");
#line 1393 "tracker-sparql-query.c"
	}
}


gint tracker_sparql_variable_get_index (TrackerSparqlVariable* self) {
	gint result;
	gint _tmp0_;
#line 82 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 82 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = self->priv->_index;
#line 82 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	result = _tmp0_;
#line 82 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return result;
#line 1409 "tracker-sparql-query.c"
}


static void tracker_sparql_variable_set_index (TrackerSparqlVariable* self, gint value) {
#line 82 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_if_fail (self != NULL);
#line 82 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (tracker_sparql_variable_get_index (self) != value) {
#line 1418 "tracker-sparql-query.c"
		gint _tmp0_;
#line 82 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp0_ = value;
#line 82 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		self->priv->_index = _tmp0_;
#line 82 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		g_object_notify ((GObject *) self, "index");
#line 1426 "tracker-sparql-query.c"
	}
}


const gchar* tracker_sparql_variable_get_sql_expression (TrackerSparqlVariable* self) {
	const gchar* result;
	const gchar* _tmp0_;
#line 83 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 83 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = self->priv->_sql_expression;
#line 83 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	result = _tmp0_;
#line 83 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return result;
#line 1442 "tracker-sparql-query.c"
}


static void tracker_sparql_variable_set_sql_expression (TrackerSparqlVariable* self, const gchar* value) {
#line 83 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_if_fail (self != NULL);
#line 83 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (g_strcmp0 (value, tracker_sparql_variable_get_sql_expression (self)) != 0) {
#line 1451 "tracker-sparql-query.c"
		const gchar* _tmp0_;
		gchar* _tmp1_;
#line 83 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp0_ = value;
#line 83 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp1_ = g_strdup (_tmp0_);
#line 83 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_free0 (self->priv->_sql_expression);
#line 83 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		self->priv->_sql_expression = _tmp1_;
#line 83 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		g_object_notify ((GObject *) self, "sql-expression");
#line 1464 "tracker-sparql-query.c"
	}
}


static void tracker_sparql_variable_class_init (TrackerSparqlVariableClass * klass) {
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	tracker_sparql_variable_parent_class = g_type_class_peek_parent (klass);
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_type_class_add_private (klass, sizeof (TrackerSparqlVariablePrivate));
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_tracker_sparql_variable_get_property;
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_tracker_sparql_variable_set_property;
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_variable_finalize;
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_SPARQL_VARIABLE_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_SPARQL_VARIABLE_INDEX, g_param_spec_int ("index", "index", "index", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_SPARQL_VARIABLE_SQL_EXPRESSION, g_param_spec_string ("sql-expression", "sql-expression", "sql-expression", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1486 "tracker-sparql-query.c"
}


static void tracker_sparql_variable_instance_init (TrackerSparqlVariable * self) {
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->priv = TRACKER_SPARQL_VARIABLE_GET_PRIVATE (self);
#line 1493 "tracker-sparql-query.c"
}


static void tracker_sparql_variable_finalize (GObject * obj) {
	TrackerSparqlVariable * self;
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_SPARQL_TYPE_VARIABLE, TrackerSparqlVariable);
#line 81 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_free0 (self->priv->_name);
#line 83 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_free0 (self->priv->_sql_expression);
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_object_unref0 (self->binding);
#line 85 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_free0 (self->priv->sql_identifier);
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	G_OBJECT_CLASS (tracker_sparql_variable_parent_class)->finalize (obj);
#line 1511 "tracker-sparql-query.c"
}


GType tracker_sparql_variable_get_type (void) {
	static volatile gsize tracker_sparql_variable_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_variable_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlVariableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_variable_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlVariable), 0, (GInstanceInitFunc) tracker_sparql_variable_instance_init, NULL };
		GType tracker_sparql_variable_type_id;
		tracker_sparql_variable_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerSparqlVariable", &g_define_type_info, 0);
		g_once_init_leave (&tracker_sparql_variable_type_id__volatile, tracker_sparql_variable_type_id);
	}
	return tracker_sparql_variable_type_id__volatile;
}


static void _vala_tracker_sparql_variable_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TrackerSparqlVariable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TRACKER_SPARQL_TYPE_VARIABLE, TrackerSparqlVariable);
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	switch (property_id) {
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		case TRACKER_SPARQL_VARIABLE_NAME:
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		g_value_set_string (value, tracker_sparql_variable_get_name (self));
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		break;
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		case TRACKER_SPARQL_VARIABLE_INDEX:
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		g_value_set_int (value, tracker_sparql_variable_get_index (self));
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		break;
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		case TRACKER_SPARQL_VARIABLE_SQL_EXPRESSION:
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		g_value_set_string (value, tracker_sparql_variable_get_sql_expression (self));
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		break;
#line 1550 "tracker-sparql-query.c"
		default:
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		break;
#line 1556 "tracker-sparql-query.c"
	}
}


static void _vala_tracker_sparql_variable_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TrackerSparqlVariable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TRACKER_SPARQL_TYPE_VARIABLE, TrackerSparqlVariable);
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	switch (property_id) {
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		case TRACKER_SPARQL_VARIABLE_NAME:
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		tracker_sparql_variable_set_name (self, g_value_get_string (value));
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		break;
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		case TRACKER_SPARQL_VARIABLE_INDEX:
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		tracker_sparql_variable_set_index (self, g_value_get_int (value));
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		break;
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		case TRACKER_SPARQL_VARIABLE_SQL_EXPRESSION:
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		tracker_sparql_variable_set_sql_expression (self, g_value_get_string (value));
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		break;
#line 1584 "tracker-sparql-query.c"
		default:
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		break;
#line 1590 "tracker-sparql-query.c"
	}
}


static gpointer _tracker_sparql_context_ref0 (gpointer self) {
#line 127 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return self ? tracker_sparql_context_ref (self) : NULL;
#line 1598 "tracker-sparql-query.c"
}


static guint _tracker_sparql_variable_hash_ghash_func (gconstpointer key) {
	guint result;
	result = tracker_sparql_variable_hash ((TrackerSparqlVariable*) key);
#line 128 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return result;
#line 1607 "tracker-sparql-query.c"
}


static gboolean _tracker_sparql_variable_equal_gequal_func (gconstpointer a, gconstpointer b) {
	gboolean result;
	result = tracker_sparql_variable_equal ((TrackerSparqlVariable*) a, (TrackerSparqlVariable*) b);
#line 128 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return result;
#line 1616 "tracker-sparql-query.c"
}


static gpointer _g_hash_table_ref0 (gpointer self) {
#line 135 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return self ? g_hash_table_ref (self) : NULL;
#line 1623 "tracker-sparql-query.c"
}


TrackerSparqlContext* tracker_sparql_context_construct (GType object_type, TrackerSparqlQuery* query, TrackerSparqlContext* parent_context) {
	TrackerSparqlContext* self = NULL;
	TrackerSparqlQuery* _tmp0_;
	TrackerSparqlContext* _tmp1_;
	TrackerSparqlContext* _tmp2_;
	GDestroyNotify _tmp3_;
	GHashTable* _tmp4_;
	TrackerSparqlContext* _tmp5_;
#line 125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (query != NULL, NULL);
#line 125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self = (TrackerSparqlContext*) g_type_create_instance (object_type);
#line 126 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = query;
#line 126 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->query = _tmp0_;
#line 127 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = parent_context;
#line 127 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp2_ = _tracker_sparql_context_ref0 (_tmp1_);
#line 127 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tracker_sparql_context_unref0 (self->parent_context);
#line 127 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->parent_context = _tmp2_;
#line 128 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp3_ = g_object_unref;
#line 128 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp4_ = g_hash_table_new_full (_tracker_sparql_variable_hash_ghash_func, _tracker_sparql_variable_equal_gequal_func, _tmp3_, NULL);
#line 128 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_hash_table_unref0 (self->var_set);
#line 128 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->var_set = _tmp4_;
#line 130 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp5_ = parent_context;
#line 130 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (_tmp5_ == NULL) {
#line 1663 "tracker-sparql-query.c"
		GDestroyNotify _tmp6_;
		GHashTable* _tmp7_;
		GHashFunc _tmp8_;
		GEqualFunc _tmp9_;
		GDestroyNotify _tmp10_;
		GDestroyNotify _tmp11_;
		GHashTable* _tmp12_;
		GDestroyNotify _tmp13_;
		GDestroyNotify _tmp14_;
		GHashTable* _tmp15_;
#line 131 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp6_ = g_object_unref;
#line 131 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp7_ = g_hash_table_new_full (_tracker_sparql_variable_hash_ghash_func, _tracker_sparql_variable_equal_gequal_func, _tmp6_, NULL);
#line 131 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_hash_table_unref0 (self->select_var_set);
#line 131 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		self->select_var_set = _tmp7_;
#line 132 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp8_ = g_str_hash;
#line 132 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp9_ = g_str_equal;
#line 132 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp10_ = g_free;
#line 132 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp11_ = g_object_unref;
#line 132 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp12_ = g_hash_table_new_full (_tmp8_, _tmp9_, _tmp10_, _tmp11_);
#line 132 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_hash_table_unref0 (self->var_map);
#line 132 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		self->var_map = _tmp12_;
#line 133 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp13_ = g_object_unref;
#line 133 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp14_ = g_object_unref;
#line 133 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp15_ = g_hash_table_new_full (_tracker_sparql_variable_hash_ghash_func, _tracker_sparql_variable_equal_gequal_func, _tmp13_, _tmp14_);
#line 133 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_hash_table_unref0 (self->predicate_variable_map);
#line 133 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		self->predicate_variable_map = _tmp15_;
#line 1706 "tracker-sparql-query.c"
	} else {
		TrackerSparqlContext* _tmp16_;
		GHashTable* _tmp17_;
		GHashTable* _tmp18_;
		TrackerSparqlContext* _tmp19_;
		GHashTable* _tmp20_;
		GHashTable* _tmp21_;
		TrackerSparqlContext* _tmp22_;
		GHashTable* _tmp23_;
		GHashTable* _tmp24_;
#line 135 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp16_ = parent_context;
#line 135 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp17_ = _tmp16_->select_var_set;
#line 135 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp18_ = _g_hash_table_ref0 (_tmp17_);
#line 135 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_hash_table_unref0 (self->select_var_set);
#line 135 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		self->select_var_set = _tmp18_;
#line 136 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp19_ = parent_context;
#line 136 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp20_ = _tmp19_->var_map;
#line 136 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp21_ = _g_hash_table_ref0 (_tmp20_);
#line 136 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_hash_table_unref0 (self->var_map);
#line 136 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		self->var_map = _tmp21_;
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp22_ = parent_context;
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp23_ = _tmp22_->predicate_variable_map;
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp24_ = _g_hash_table_ref0 (_tmp23_);
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_hash_table_unref0 (self->predicate_variable_map);
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		self->predicate_variable_map = _tmp24_;
#line 1747 "tracker-sparql-query.c"
	}
#line 125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return self;
#line 1751 "tracker-sparql-query.c"
}


TrackerSparqlContext* tracker_sparql_context_new (TrackerSparqlQuery* query, TrackerSparqlContext* parent_context) {
#line 125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return tracker_sparql_context_construct (TRACKER_SPARQL_TYPE_CONTEXT, query, parent_context);
#line 1758 "tracker-sparql-query.c"
}


TrackerSparqlContext* tracker_sparql_context_construct_subquery (GType object_type, TrackerSparqlQuery* query, TrackerSparqlContext* parent_context) {
	TrackerSparqlContext* self = NULL;
	TrackerSparqlQuery* _tmp0_;
	TrackerSparqlContext* _tmp1_;
	TrackerSparqlContext* _tmp2_;
	GDestroyNotify _tmp3_;
	GHashTable* _tmp4_;
	GDestroyNotify _tmp5_;
	GHashTable* _tmp6_;
	TrackerSparqlContext* _tmp7_;
	GHashTable* _tmp8_;
	GHashTable* _tmp9_;
	GDestroyNotify _tmp10_;
	GDestroyNotify _tmp11_;
	GHashTable* _tmp12_;
#line 141 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (query != NULL, NULL);
#line 141 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (parent_context != NULL, NULL);
#line 141 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self = (TrackerSparqlContext*) g_type_create_instance (object_type);
#line 142 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = query;
#line 142 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->query = _tmp0_;
#line 143 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = parent_context;
#line 143 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp2_ = _tracker_sparql_context_ref0 (_tmp1_);
#line 143 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tracker_sparql_context_unref0 (self->parent_context);
#line 143 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->parent_context = _tmp2_;
#line 144 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp3_ = g_object_unref;
#line 144 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp4_ = g_hash_table_new_full (_tracker_sparql_variable_hash_ghash_func, _tracker_sparql_variable_equal_gequal_func, _tmp3_, NULL);
#line 144 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_hash_table_unref0 (self->var_set);
#line 144 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->var_set = _tmp4_;
#line 146 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp5_ = g_object_unref;
#line 146 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp6_ = g_hash_table_new_full (_tracker_sparql_variable_hash_ghash_func, _tracker_sparql_variable_equal_gequal_func, _tmp5_, NULL);
#line 146 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_hash_table_unref0 (self->select_var_set);
#line 146 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->select_var_set = _tmp6_;
#line 147 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp7_ = parent_context;
#line 147 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp8_ = _tmp7_->var_map;
#line 147 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp9_ = _g_hash_table_ref0 (_tmp8_);
#line 147 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_hash_table_unref0 (self->var_map);
#line 147 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->var_map = _tmp9_;
#line 148 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp10_ = g_object_unref;
#line 148 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp11_ = g_object_unref;
#line 148 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp12_ = g_hash_table_new_full (_tracker_sparql_variable_hash_ghash_func, _tracker_sparql_variable_equal_gequal_func, _tmp10_, _tmp11_);
#line 148 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_hash_table_unref0 (self->predicate_variable_map);
#line 148 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->predicate_variable_map = _tmp12_;
#line 149 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->scalar_subquery = TRUE;
#line 141 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return self;
#line 1835 "tracker-sparql-query.c"
}


TrackerSparqlContext* tracker_sparql_context_new_subquery (TrackerSparqlQuery* query, TrackerSparqlContext* parent_context) {
#line 141 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return tracker_sparql_context_construct_subquery (TRACKER_SPARQL_TYPE_CONTEXT, query, parent_context);
#line 1842 "tracker-sparql-query.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 156 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return self ? g_object_ref (self) : NULL;
#line 1849 "tracker-sparql-query.c"
}


TrackerSparqlVariable* tracker_sparql_context_get_variable (TrackerSparqlContext* self, const gchar* name) {
	TrackerSparqlVariable* result = NULL;
	TrackerSparqlVariable* _result_ = NULL;
	GHashTable* _tmp0_;
	const gchar* _tmp1_;
	gconstpointer _tmp2_;
	TrackerSparqlVariable* _tmp3_;
	TrackerSparqlVariable* _tmp16_;
#line 152 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 152 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 153 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = self->var_map;
#line 153 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = name;
#line 153 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp2_ = g_hash_table_lookup (_tmp0_, _tmp1_);
#line 153 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_result_ = (TrackerSparqlVariable*) _tmp2_;
#line 154 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp3_ = _result_;
#line 154 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (_tmp3_ == NULL) {
#line 1877 "tracker-sparql-query.c"
		TrackerSparqlVariable* variable = NULL;
		const gchar* _tmp4_;
		TrackerSparqlQuery* _tmp5_;
		TrackerSparqlQuery* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		TrackerSparqlVariable* _tmp9_;
		GHashTable* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		TrackerSparqlVariable* _tmp13_;
		TrackerSparqlVariable* _tmp14_;
		TrackerSparqlVariable* _tmp15_;
#line 155 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp4_ = name;
#line 155 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp5_ = self->query;
#line 155 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp6_ = self->query;
#line 155 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp7_ = _tmp6_->last_var_index;
#line 155 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp6_->last_var_index = _tmp7_ + 1;
#line 155 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp8_ = _tmp6_->last_var_index;
#line 155 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp9_ = tracker_sparql_variable_new (_tmp4_, _tmp8_);
#line 155 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		variable = _tmp9_;
#line 156 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp10_ = self->var_map;
#line 156 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp11_ = name;
#line 156 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp12_ = g_strdup (_tmp11_);
#line 156 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp13_ = variable;
#line 156 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp14_ = _g_object_ref0 (_tmp13_);
#line 156 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		g_hash_table_insert (_tmp10_, _tmp12_, _tmp14_);
#line 158 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp15_ = variable;
#line 158 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_result_ = _tmp15_;
#line 154 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_object_unref0 (variable);
#line 1925 "tracker-sparql-query.c"
	}
#line 160 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp16_ = _result_;
#line 160 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	result = _tmp16_;
#line 160 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return result;
#line 1933 "tracker-sparql-query.c"
}


static void tracker_sparql_value_context_init (GValue* value) {
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	value->data[0].v_pointer = NULL;
#line 1940 "tracker-sparql-query.c"
}


static void tracker_sparql_value_context_free_value (GValue* value) {
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (value->data[0].v_pointer) {
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		tracker_sparql_context_unref (value->data[0].v_pointer);
#line 1949 "tracker-sparql-query.c"
	}
}


static void tracker_sparql_value_context_copy_value (const GValue* src_value, GValue* dest_value) {
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (src_value->data[0].v_pointer) {
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		dest_value->data[0].v_pointer = tracker_sparql_context_ref (src_value->data[0].v_pointer);
#line 1959 "tracker-sparql-query.c"
	} else {
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1963 "tracker-sparql-query.c"
	}
}


static gpointer tracker_sparql_value_context_peek_pointer (const GValue* value) {
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return value->data[0].v_pointer;
#line 1971 "tracker-sparql-query.c"
}


static gchar* tracker_sparql_value_context_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (collect_values[0].v_pointer) {
#line 1978 "tracker-sparql-query.c"
		TrackerSparqlContext * object;
		object = collect_values[0].v_pointer;
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (object->parent_instance.g_class == NULL) {
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1985 "tracker-sparql-query.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1989 "tracker-sparql-query.c"
		}
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		value->data[0].v_pointer = tracker_sparql_context_ref (object);
#line 1993 "tracker-sparql-query.c"
	} else {
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		value->data[0].v_pointer = NULL;
#line 1997 "tracker-sparql-query.c"
	}
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return NULL;
#line 2001 "tracker-sparql-query.c"
}


static gchar* tracker_sparql_value_context_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	TrackerSparqlContext ** object_p;
	object_p = collect_values[0].v_pointer;
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (!object_p) {
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2012 "tracker-sparql-query.c"
	}
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (!value->data[0].v_pointer) {
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		*object_p = NULL;
#line 2018 "tracker-sparql-query.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		*object_p = value->data[0].v_pointer;
#line 2022 "tracker-sparql-query.c"
	} else {
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		*object_p = tracker_sparql_context_ref (value->data[0].v_pointer);
#line 2026 "tracker-sparql-query.c"
	}
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return NULL;
#line 2030 "tracker-sparql-query.c"
}


GParamSpec* tracker_sparql_param_spec_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	TrackerSparqlParamSpecContext* spec;
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TRACKER_SPARQL_TYPE_CONTEXT), NULL);
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return G_PARAM_SPEC (spec);
#line 2044 "tracker-sparql-query.c"
}


gpointer tracker_sparql_value_get_context (const GValue* value) {
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_SPARQL_TYPE_CONTEXT), NULL);
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return value->data[0].v_pointer;
#line 2053 "tracker-sparql-query.c"
}


void tracker_sparql_value_set_context (GValue* value, gpointer v_object) {
	TrackerSparqlContext * old;
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_SPARQL_TYPE_CONTEXT));
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	old = value->data[0].v_pointer;
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (v_object) {
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_SPARQL_TYPE_CONTEXT));
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		value->data[0].v_pointer = v_object;
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		tracker_sparql_context_ref (value->data[0].v_pointer);
#line 2073 "tracker-sparql-query.c"
	} else {
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		value->data[0].v_pointer = NULL;
#line 2077 "tracker-sparql-query.c"
	}
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (old) {
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		tracker_sparql_context_unref (old);
#line 2083 "tracker-sparql-query.c"
	}
}


void tracker_sparql_value_take_context (GValue* value, gpointer v_object) {
	TrackerSparqlContext * old;
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_SPARQL_TYPE_CONTEXT));
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	old = value->data[0].v_pointer;
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (v_object) {
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_SPARQL_TYPE_CONTEXT));
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		value->data[0].v_pointer = v_object;
#line 2102 "tracker-sparql-query.c"
	} else {
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		value->data[0].v_pointer = NULL;
#line 2106 "tracker-sparql-query.c"
	}
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (old) {
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		tracker_sparql_context_unref (old);
#line 2112 "tracker-sparql-query.c"
	}
}


static void tracker_sparql_context_class_init (TrackerSparqlContextClass * klass) {
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	tracker_sparql_context_parent_class = g_type_class_peek_parent (klass);
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	((TrackerSparqlContextClass *) klass)->finalize = tracker_sparql_context_finalize;
#line 2122 "tracker-sparql-query.c"
}


static void tracker_sparql_context_instance_init (TrackerSparqlContext * self) {
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->ref_count = 1;
#line 2129 "tracker-sparql-query.c"
}


static void tracker_sparql_context_finalize (TrackerSparqlContext * obj) {
	TrackerSparqlContext * self;
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_SPARQL_TYPE_CONTEXT, TrackerSparqlContext);
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_signal_handlers_destroy (self);
#line 110 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tracker_sparql_context_unref0 (self->parent_context);
#line 113 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_hash_table_unref0 (self->var_set);
#line 115 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_hash_table_unref0 (self->var_map);
#line 117 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_hash_table_unref0 (self->select_var_set);
#line 120 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_hash_table_unref0 (self->predicate_variable_map);
#line 2149 "tracker-sparql-query.c"
}


GType tracker_sparql_context_get_type (void) {
	static volatile gsize tracker_sparql_context_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_context_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { tracker_sparql_value_context_init, tracker_sparql_value_context_free_value, tracker_sparql_value_context_copy_value, tracker_sparql_value_context_peek_pointer, "p", tracker_sparql_value_context_collect_value, "p", tracker_sparql_value_context_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlContextClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_context_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlContext), 0, (GInstanceInitFunc) tracker_sparql_context_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType tracker_sparql_context_type_id;
		tracker_sparql_context_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TrackerSparqlContext", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&tracker_sparql_context_type_id__volatile, tracker_sparql_context_type_id);
	}
	return tracker_sparql_context_type_id__volatile;
}


gpointer tracker_sparql_context_ref (gpointer instance) {
	TrackerSparqlContext * self;
	self = instance;
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_atomic_int_inc (&self->ref_count);
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return instance;
#line 2174 "tracker-sparql-query.c"
}


void tracker_sparql_context_unref (gpointer instance) {
	TrackerSparqlContext * self;
	self = instance;
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		TRACKER_SPARQL_CONTEXT_GET_CLASS (self)->finalize (self);
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2187 "tracker-sparql-query.c"
	}
}


TrackerSparqlSelectContext* tracker_sparql_select_context_construct (GType object_type, TrackerSparqlQuery* query, TrackerSparqlContext* parent_context) {
	TrackerSparqlSelectContext* self = NULL;
	TrackerSparqlQuery* _tmp0_;
	TrackerSparqlContext* _tmp1_;
#line 169 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (query != NULL, NULL);
#line 170 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = query;
#line 170 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = parent_context;
#line 170 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self = (TrackerSparqlSelectContext*) tracker_sparql_context_construct (object_type, _tmp0_, _tmp1_);
#line 169 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return self;
#line 2206 "tracker-sparql-query.c"
}


TrackerSparqlSelectContext* tracker_sparql_select_context_new (TrackerSparqlQuery* query, TrackerSparqlContext* parent_context) {
#line 169 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return tracker_sparql_select_context_construct (TRACKER_SPARQL_TYPE_SELECT_CONTEXT, query, parent_context);
#line 2213 "tracker-sparql-query.c"
}


TrackerSparqlSelectContext* tracker_sparql_select_context_construct_subquery (GType object_type, TrackerSparqlQuery* query, TrackerSparqlContext* parent_context) {
	TrackerSparqlSelectContext* self = NULL;
	TrackerSparqlQuery* _tmp0_;
	TrackerSparqlContext* _tmp1_;
#line 173 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (query != NULL, NULL);
#line 173 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (parent_context != NULL, NULL);
#line 174 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = query;
#line 174 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = parent_context;
#line 174 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self = (TrackerSparqlSelectContext*) tracker_sparql_context_construct_subquery (object_type, _tmp0_, _tmp1_);
#line 173 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return self;
#line 2233 "tracker-sparql-query.c"
}


TrackerSparqlSelectContext* tracker_sparql_select_context_new_subquery (TrackerSparqlQuery* query, TrackerSparqlContext* parent_context) {
#line 173 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return tracker_sparql_select_context_construct_subquery (TRACKER_SPARQL_TYPE_SELECT_CONTEXT, query, parent_context);
#line 2240 "tracker-sparql-query.c"
}


static void tracker_sparql_select_context_class_init (TrackerSparqlSelectContextClass * klass) {
#line 164 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	tracker_sparql_select_context_parent_class = g_type_class_peek_parent (klass);
#line 164 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	((TrackerSparqlContextClass *) klass)->finalize = tracker_sparql_select_context_finalize;
#line 2249 "tracker-sparql-query.c"
}


static void tracker_sparql_select_context_instance_init (TrackerSparqlSelectContext * self) {
	TrackerPropertyType* _tmp0_;
	gchar** _tmp1_;
#line 166 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = g_new0 (TrackerPropertyType, 0);
#line 166 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->types = _tmp0_;
#line 166 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->types_length1 = 0;
#line 166 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->_types_size_ = self->types_length1;
#line 167 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = g_new0 (gchar*, 0 + 1);
#line 167 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->variable_names = _tmp1_;
#line 167 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->variable_names_length1 = 0;
#line 167 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->_variable_names_size_ = self->variable_names_length1;
#line 2272 "tracker-sparql-query.c"
}


static void tracker_sparql_select_context_finalize (TrackerSparqlContext * obj) {
	TrackerSparqlSelectContext * self;
#line 164 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContext);
#line 166 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->types = (g_free (self->types), NULL);
#line 167 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->variable_names = (_vala_array_free (self->variable_names, self->variable_names_length1, (GDestroyNotify) g_free), NULL);
#line 164 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	TRACKER_SPARQL_CONTEXT_CLASS (tracker_sparql_select_context_parent_class)->finalize (obj);
#line 2286 "tracker-sparql-query.c"
}


GType tracker_sparql_select_context_get_type (void) {
	static volatile gsize tracker_sparql_select_context_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_select_context_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlSelectContextClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_select_context_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlSelectContext), 0, (GInstanceInitFunc) tracker_sparql_select_context_instance_init, NULL };
		GType tracker_sparql_select_context_type_id;
		tracker_sparql_select_context_type_id = g_type_register_static (TRACKER_SPARQL_TYPE_CONTEXT, "TrackerSparqlSelectContext", &g_define_type_info, 0);
		g_once_init_leave (&tracker_sparql_select_context_type_id__volatile, tracker_sparql_select_context_type_id);
	}
	return tracker_sparql_select_context_type_id__volatile;
}


static void _g_free0_ (gpointer var) {
#line 184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	var = (g_free (var), NULL);
#line 2305 "tracker-sparql-query.c"
}


TrackerSparqlSolution* tracker_sparql_solution_construct (GType object_type) {
	TrackerSparqlSolution* self = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GPtrArray* _tmp3_;
#line 183 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self = (TrackerSparqlSolution*) g_type_create_instance (object_type);
#line 184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = g_str_hash;
#line 184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = g_str_equal;
#line 184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, NULL);
#line 184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_hash_table_unref0 (self->hash);
#line 184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->hash = _tmp2_;
#line 185 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp3_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
#line 185 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_ptr_array_unref0 (self->values);
#line 185 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->values = _tmp3_;
#line 183 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return self;
#line 2335 "tracker-sparql-query.c"
}


TrackerSparqlSolution* tracker_sparql_solution_new (void) {
#line 183 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return tracker_sparql_solution_construct (TRACKER_SPARQL_TYPE_SOLUTION);
#line 2342 "tracker-sparql-query.c"
}


gchar* tracker_sparql_solution_lookup (TrackerSparqlSolution* self, const gchar* variable_name) {
	gchar* result = NULL;
	gint variable_index = 0;
	GHashTable* _tmp0_;
	const gchar* _tmp1_;
	gconstpointer _tmp2_ = NULL;
	gboolean _tmp3_;
	GPtrArray* _tmp4_;
	gint _tmp5_;
	GHashTable* _tmp6_;
	guint _tmp7_;
	gint _tmp8_;
	gconstpointer _tmp9_;
	gchar* _tmp10_;
#line 188 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 188 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (variable_name != NULL, NULL);
#line 190 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = self->hash;
#line 190 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = variable_name;
#line 190 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp3_ = g_hash_table_lookup_extended (_tmp0_, _tmp1_, NULL, &_tmp2_);
#line 190 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	variable_index = _tmp2_;
#line 190 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (!_tmp3_) {
#line 191 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		result = NULL;
#line 191 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		return result;
#line 2378 "tracker-sparql-query.c"
	}
#line 193 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp4_ = self->values;
#line 193 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp5_ = self->solution_index;
#line 193 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp6_ = self->hash;
#line 193 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp7_ = g_hash_table_size (_tmp6_);
#line 193 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp8_ = variable_index;
#line 193 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp9_ = g_ptr_array_index (_tmp4_, (_tmp5_ * _tmp7_) + _tmp8_);
#line 193 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp10_ = g_strdup ((const gchar*) _tmp9_);
#line 193 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	result = _tmp10_;
#line 193 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return result;
#line 2398 "tracker-sparql-query.c"
}


static void tracker_sparql_value_solution_init (GValue* value) {
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	value->data[0].v_pointer = NULL;
#line 2405 "tracker-sparql-query.c"
}


static void tracker_sparql_value_solution_free_value (GValue* value) {
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (value->data[0].v_pointer) {
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		tracker_sparql_solution_unref (value->data[0].v_pointer);
#line 2414 "tracker-sparql-query.c"
	}
}


static void tracker_sparql_value_solution_copy_value (const GValue* src_value, GValue* dest_value) {
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (src_value->data[0].v_pointer) {
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		dest_value->data[0].v_pointer = tracker_sparql_solution_ref (src_value->data[0].v_pointer);
#line 2424 "tracker-sparql-query.c"
	} else {
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2428 "tracker-sparql-query.c"
	}
}


static gpointer tracker_sparql_value_solution_peek_pointer (const GValue* value) {
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return value->data[0].v_pointer;
#line 2436 "tracker-sparql-query.c"
}


static gchar* tracker_sparql_value_solution_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (collect_values[0].v_pointer) {
#line 2443 "tracker-sparql-query.c"
		TrackerSparqlSolution * object;
		object = collect_values[0].v_pointer;
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (object->parent_instance.g_class == NULL) {
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2450 "tracker-sparql-query.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2454 "tracker-sparql-query.c"
		}
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		value->data[0].v_pointer = tracker_sparql_solution_ref (object);
#line 2458 "tracker-sparql-query.c"
	} else {
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		value->data[0].v_pointer = NULL;
#line 2462 "tracker-sparql-query.c"
	}
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return NULL;
#line 2466 "tracker-sparql-query.c"
}


static gchar* tracker_sparql_value_solution_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	TrackerSparqlSolution ** object_p;
	object_p = collect_values[0].v_pointer;
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (!object_p) {
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2477 "tracker-sparql-query.c"
	}
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (!value->data[0].v_pointer) {
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		*object_p = NULL;
#line 2483 "tracker-sparql-query.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		*object_p = value->data[0].v_pointer;
#line 2487 "tracker-sparql-query.c"
	} else {
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		*object_p = tracker_sparql_solution_ref (value->data[0].v_pointer);
#line 2491 "tracker-sparql-query.c"
	}
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return NULL;
#line 2495 "tracker-sparql-query.c"
}


GParamSpec* tracker_sparql_param_spec_solution (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	TrackerSparqlParamSpecSolution* spec;
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TRACKER_SPARQL_TYPE_SOLUTION), NULL);
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return G_PARAM_SPEC (spec);
#line 2509 "tracker-sparql-query.c"
}


gpointer tracker_sparql_value_get_solution (const GValue* value) {
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_SPARQL_TYPE_SOLUTION), NULL);
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return value->data[0].v_pointer;
#line 2518 "tracker-sparql-query.c"
}


void tracker_sparql_value_set_solution (GValue* value, gpointer v_object) {
	TrackerSparqlSolution * old;
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_SPARQL_TYPE_SOLUTION));
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	old = value->data[0].v_pointer;
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (v_object) {
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_SPARQL_TYPE_SOLUTION));
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		value->data[0].v_pointer = v_object;
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		tracker_sparql_solution_ref (value->data[0].v_pointer);
#line 2538 "tracker-sparql-query.c"
	} else {
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		value->data[0].v_pointer = NULL;
#line 2542 "tracker-sparql-query.c"
	}
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (old) {
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		tracker_sparql_solution_unref (old);
#line 2548 "tracker-sparql-query.c"
	}
}


void tracker_sparql_value_take_solution (GValue* value, gpointer v_object) {
	TrackerSparqlSolution * old;
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_SPARQL_TYPE_SOLUTION));
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	old = value->data[0].v_pointer;
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (v_object) {
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_SPARQL_TYPE_SOLUTION));
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		value->data[0].v_pointer = v_object;
#line 2567 "tracker-sparql-query.c"
	} else {
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		value->data[0].v_pointer = NULL;
#line 2571 "tracker-sparql-query.c"
	}
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (old) {
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		tracker_sparql_solution_unref (old);
#line 2577 "tracker-sparql-query.c"
	}
}


static void tracker_sparql_solution_class_init (TrackerSparqlSolutionClass * klass) {
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	tracker_sparql_solution_parent_class = g_type_class_peek_parent (klass);
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	((TrackerSparqlSolutionClass *) klass)->finalize = tracker_sparql_solution_finalize;
#line 2587 "tracker-sparql-query.c"
}


static void tracker_sparql_solution_instance_init (TrackerSparqlSolution * self) {
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->ref_count = 1;
#line 2594 "tracker-sparql-query.c"
}


static void tracker_sparql_solution_finalize (TrackerSparqlSolution * obj) {
	TrackerSparqlSolution * self;
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_SPARQL_TYPE_SOLUTION, TrackerSparqlSolution);
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_signal_handlers_destroy (self);
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_hash_table_unref0 (self->hash);
#line 180 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_ptr_array_unref0 (self->values);
#line 2608 "tracker-sparql-query.c"
}


GType tracker_sparql_solution_get_type (void) {
	static volatile gsize tracker_sparql_solution_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_solution_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { tracker_sparql_value_solution_init, tracker_sparql_value_solution_free_value, tracker_sparql_value_solution_copy_value, tracker_sparql_value_solution_peek_pointer, "p", tracker_sparql_value_solution_collect_value, "p", tracker_sparql_value_solution_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlSolutionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_solution_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlSolution), 0, (GInstanceInitFunc) tracker_sparql_solution_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType tracker_sparql_solution_type_id;
		tracker_sparql_solution_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TrackerSparqlSolution", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&tracker_sparql_solution_type_id__volatile, tracker_sparql_solution_type_id);
	}
	return tracker_sparql_solution_type_id__volatile;
}


gpointer tracker_sparql_solution_ref (gpointer instance) {
	TrackerSparqlSolution * self;
	self = instance;
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_atomic_int_inc (&self->ref_count);
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return instance;
#line 2633 "tracker-sparql-query.c"
}


void tracker_sparql_solution_unref (gpointer instance) {
	TrackerSparqlSolution * self;
	self = instance;
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		TRACKER_SPARQL_SOLUTION_GET_CLASS (self)->finalize (self);
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2646 "tracker-sparql-query.c"
	}
}


TrackerSparqlQuery* tracker_sparql_query_construct (GType object_type, TrackerDataManager* manager, const gchar* query) {
	TrackerSparqlQuery * self = NULL;
	TrackerSparqlQueryTokenInfo* _tmp0_;
	GHashFunc _tmp1_;
	GEqualFunc _tmp2_;
	GDestroyNotify _tmp3_;
	GDestroyNotify _tmp4_;
	GHashTable* _tmp5_;
	guchar* _tmp6_;
	guchar* _tmp7_;
	gint _tmp7__length1;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	TrackerDataManager* _tmp10_;
	TrackerDataManager* _tmp11_;
	TrackerSparqlExpression* _tmp12_;
	TrackerSparqlPattern* _tmp13_;
#line 252 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (manager != NULL, NULL);
#line 252 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (query != NULL, NULL);
#line 252 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self = (TrackerSparqlQuery*) g_object_new (object_type, NULL);
#line 253 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	tracker_sparql_query_set_no_cache (self, FALSE);
#line 254 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = g_new0 (TrackerSparqlQueryTokenInfo, TRACKER_SPARQL_QUERY_BUFFER_SIZE);
#line 254 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->priv->tokens = (g_free (self->priv->tokens), NULL);
#line 254 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->priv->tokens = _tmp0_;
#line 254 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->priv->tokens_length1 = TRACKER_SPARQL_QUERY_BUFFER_SIZE;
#line 254 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->priv->_tokens_size_ = self->priv->tokens_length1;
#line 255 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = g_str_hash;
#line 255 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp2_ = g_str_equal;
#line 255 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp3_ = g_free;
#line 255 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp4_ = g_free;
#line 255 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp5_ = g_hash_table_new_full (_tmp1_, _tmp2_, _tmp3_, _tmp4_);
#line 255 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_hash_table_unref0 (self->priv->prefix_map);
#line 255 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->priv->prefix_map = _tmp5_;
#line 257 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp6_ = g_new0 (guchar, 16);
#line 257 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->priv->base_uuid = (g_free (self->priv->base_uuid), NULL);
#line 257 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->priv->base_uuid = _tmp6_;
#line 257 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->priv->base_uuid_length1 = 16;
#line 257 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->priv->_base_uuid_size_ = self->priv->base_uuid_length1;
#line 258 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp7_ = self->priv->base_uuid;
#line 258 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp7__length1 = self->priv->base_uuid_length1;
#line 258 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	uuid_generate (_tmp7_);
#line 260 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp8_ = query;
#line 260 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp9_ = g_strdup (_tmp8_);
#line 260 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_free0 (self->priv->query_string);
#line 260 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->priv->query_string = _tmp9_;
#line 261 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp10_ = manager;
#line 261 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp11_ = _g_object_ref0 (_tmp10_);
#line 261 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_object_unref0 (self->manager);
#line 261 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->manager = _tmp11_;
#line 263 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp12_ = tracker_sparql_expression_new (self);
#line 263 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_object_unref0 (self->expression);
#line 263 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->expression = _tmp12_;
#line 264 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp13_ = tracker_sparql_pattern_new (self);
#line 264 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_object_unref0 (self->pattern);
#line 264 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->pattern = _tmp13_;
#line 252 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return self;
#line 2746 "tracker-sparql-query.c"
}


TrackerSparqlQuery* tracker_sparql_query_new (TrackerDataManager* manager, const gchar* query) {
#line 252 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return tracker_sparql_query_construct (TRACKER_SPARQL_TYPE_QUERY, manager, query);
#line 2753 "tracker-sparql-query.c"
}


TrackerSparqlQuery* tracker_sparql_query_construct_update (GType object_type, TrackerDataManager* manager, const gchar* query) {
	TrackerSparqlQuery * self = NULL;
	TrackerDataManager* _tmp0_;
	const gchar* _tmp1_;
#line 267 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (manager != NULL, NULL);
#line 267 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (query != NULL, NULL);
#line 268 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = manager;
#line 268 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = query;
#line 268 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self = (TrackerSparqlQuery*) tracker_sparql_query_construct (object_type, _tmp0_, _tmp1_);
#line 269 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->priv->update_extensions = TRUE;
#line 267 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return self;
#line 2775 "tracker-sparql-query.c"
}


TrackerSparqlQuery* tracker_sparql_query_new_update (TrackerDataManager* manager, const gchar* query) {
#line 267 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return tracker_sparql_query_construct_update (TRACKER_SPARQL_TYPE_QUERY, manager, query);
#line 2782 "tracker-sparql-query.c"
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
#line 1322 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 1322 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp1_ = maxlen;
#line 1322 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
#line 1322 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	end = _tmp2_;
#line 1323 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp3_ = end;
#line 1323 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 2805 "tracker-sparql-query.c"
		glong _tmp4_;
#line 1324 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp4_ = maxlen;
#line 1324 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		result = _tmp4_;
#line 1324 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		return result;
#line 2813 "tracker-sparql-query.c"
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
#line 1326 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp5_ = end;
#line 1326 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp6_ = str;
#line 1326 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		result = (glong) (_tmp5_ - _tmp6_);
#line 1326 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		return result;
#line 2825 "tracker-sparql-query.c"
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	glong _tmp8_;
	glong _tmp14_;
	glong _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	gchar* _tmp22_;
#line 1333 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1335 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp1_ = offset;
#line 1335 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp1_ >= ((glong) 0)) {
#line 2849 "tracker-sparql-query.c"
		glong _tmp2_;
#line 1335 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp2_ = len;
#line 1335 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp2_ >= ((glong) 0);
#line 2855 "tracker-sparql-query.c"
	} else {
#line 1335 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 2859 "tracker-sparql-query.c"
	}
#line 1335 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp0_) {
#line 2863 "tracker-sparql-query.c"
		glong _tmp3_;
		glong _tmp4_;
		glong _tmp5_;
#line 1337 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp3_ = offset;
#line 1337 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp4_ = len;
#line 1337 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
#line 1337 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		string_length = _tmp5_;
#line 2875 "tracker-sparql-query.c"
	} else {
		gint _tmp6_;
		gint _tmp7_;
#line 1339 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp6_ = strlen (self);
#line 1339 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp7_ = _tmp6_;
#line 1339 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp7_;
#line 2885 "tracker-sparql-query.c"
	}
#line 1342 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp8_ = offset;
#line 1342 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp8_ < ((glong) 0)) {
#line 2891 "tracker-sparql-query.c"
		glong _tmp9_;
		glong _tmp10_;
		glong _tmp11_;
#line 1343 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp9_ = string_length;
#line 1343 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp10_ = offset;
#line 1343 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		offset = _tmp9_ + _tmp10_;
#line 1344 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp11_ = offset;
#line 1344 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
#line 2905 "tracker-sparql-query.c"
	} else {
		glong _tmp12_;
		glong _tmp13_;
#line 1346 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp12_ = offset;
#line 1346 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp13_ = string_length;
#line 1346 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
#line 2915 "tracker-sparql-query.c"
	}
#line 1348 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp14_ = len;
#line 1348 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp14_ < ((glong) 0)) {
#line 2921 "tracker-sparql-query.c"
		glong _tmp15_;
		glong _tmp16_;
#line 1349 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1349 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp16_ = offset;
#line 1349 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		len = _tmp15_ - _tmp16_;
#line 2930 "tracker-sparql-query.c"
	}
#line 1351 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp17_ = offset;
#line 1351 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp18_ = len;
#line 1351 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp19_ = string_length;
#line 1351 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
#line 1352 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp20_ = offset;
#line 1352 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp21_ = len;
#line 1352 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
#line 1352 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	result = _tmp22_;
#line 1352 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	return result;
#line 2950 "tracker-sparql-query.c"
}


static gchar* tracker_sparql_query_get_uuid_for_name (TrackerSparqlQuery* self, guchar* base_uuid, int base_uuid_length1, const gchar* name) {
	gchar* result = NULL;
	GChecksum* checksum = NULL;
	GChecksum* _tmp0_;
	guchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* sha1 = NULL;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
#line 272 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 272 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = g_checksum_new (G_CHECKSUM_SHA1);
#line 273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	checksum = _tmp0_;
#line 275 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = base_uuid;
#line 275 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1__length1 = base_uuid_length1;
#line 275 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_checksum_update (checksum, _tmp1_, (gsize) 16);
#line 278 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp2_ = name;
#line 278 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_checksum_update (checksum, (guchar*) _tmp2_, (gsize) -1);
#line 280 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp3_ = g_checksum_get_string (checksum);
#line 280 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 280 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	sha1 = _tmp4_;
#line 283 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp5_ = string_substring (sha1, (glong) 8, (glong) -1);
#line 283 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp6_ = _tmp5_;
#line 283 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp7_ = string_substring (sha1, (glong) 12, (glong) -1);
#line 283 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp8_ = _tmp7_;
#line 283 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp9_ = string_substring (sha1, (glong) 16, (glong) -1);
#line 283 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp10_ = _tmp9_;
#line 283 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp11_ = string_substring (sha1, (glong) 20, (glong) -1);
#line 283 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp12_ = _tmp11_;
#line 283 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp13_ = g_strdup_printf ("urn:uuid:%.8s-%.4s-%.4s-%.4s-%.12s", sha1, _tmp6_, _tmp8_, _tmp10_, _tmp12_);
#line 283 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp14_ = _tmp13_;
#line 283 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_free0 (_tmp12_);
#line 283 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_free0 (_tmp10_);
#line 283 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_free0 (_tmp8_);
#line 283 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_free0 (_tmp6_);
#line 283 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	result = _tmp14_;
#line 283 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_free0 (sha1);
#line 283 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_checksum_free0 (checksum);
#line 283 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return result;
#line 3034 "tracker-sparql-query.c"
}


gchar* tracker_sparql_query_generate_bnodeid (TrackerSparqlQuery* self, const gchar* user_bnodeid) {
	gchar* result = NULL;
	const gchar* _tmp0_;
#line 287 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 289 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = user_bnodeid;
#line 289 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (_tmp0_ == NULL) {
#line 3047 "tracker-sparql-query.c"
		gint _tmp1_;
		gint _tmp2_;
		gchar* _tmp3_;
#line 290 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp1_ = self->priv->bnodeid;
#line 290 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		self->priv->bnodeid = _tmp1_ + 1;
#line 290 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp2_ = self->priv->bnodeid;
#line 290 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp3_ = g_strdup_printf (":%d", _tmp2_);
#line 290 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		result = _tmp3_;
#line 290 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		return result;
#line 3063 "tracker-sparql-query.c"
	} else {
		gchar* uri = NULL;
		GHashTable* _tmp4_;
		guchar* _tmp10_;
		gint _tmp10__length1;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		GHashTable* _tmp13_;
#line 292 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		uri = NULL;
#line 294 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp4_ = self->priv->blank_nodes;
#line 294 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (_tmp4_ != NULL) {
#line 3078 "tracker-sparql-query.c"
			GHashTable* _tmp5_;
			const gchar* _tmp6_;
			gconstpointer _tmp7_;
			gchar* _tmp8_;
			const gchar* _tmp9_;
#line 295 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp5_ = self->priv->blank_nodes;
#line 295 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp6_ = user_bnodeid;
#line 295 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp7_ = g_hash_table_lookup (_tmp5_, _tmp6_);
#line 295 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp8_ = g_strdup ((const gchar*) _tmp7_);
#line 295 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_free0 (uri);
#line 295 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			uri = _tmp8_;
#line 296 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp9_ = uri;
#line 296 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (_tmp9_ != NULL) {
#line 297 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				result = uri;
#line 297 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return result;
#line 3104 "tracker-sparql-query.c"
			}
		}
#line 301 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp10_ = self->priv->base_uuid;
#line 301 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp10__length1 = self->priv->base_uuid_length1;
#line 301 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp11_ = user_bnodeid;
#line 301 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp12_ = tracker_sparql_query_get_uuid_for_name (self, _tmp10_, _tmp10__length1, _tmp11_);
#line 301 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_free0 (uri);
#line 301 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		uri = _tmp12_;
#line 303 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp13_ = self->priv->blank_nodes;
#line 303 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (_tmp13_ != NULL) {
#line 3123 "tracker-sparql-query.c"
			TrackerDBInterface* iface = NULL;
			TrackerDataManager* _tmp14_;
			TrackerDBInterface* _tmp15_;
			TrackerDBInterface* _tmp16_;
			GHashTable* _tmp26_;
			const gchar* _tmp27_;
			gchar* _tmp28_;
			const gchar* _tmp29_;
			gchar* _tmp30_;
#line 304 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp14_ = self->manager;
#line 304 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp15_ = tracker_data_manager_get_db_interface (_tmp14_);
#line 304 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp16_ = _g_object_ref0 (_tmp15_);
#line 304 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			iface = _tmp16_;
#line 305 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			while (TRUE) {
#line 3143 "tracker-sparql-query.c"
				TrackerDataManager* _tmp17_;
				TrackerDBInterface* _tmp18_;
				const gchar* _tmp19_;
				gint _tmp20_;
				guchar* new_base_uuid = NULL;
				guchar* _tmp21_;
				gint new_base_uuid_length1;
				gint _new_base_uuid_size_;
				guchar* _tmp22_;
				gint _tmp22__length1;
				guchar* _tmp23_;
				gint _tmp23__length1;
				const gchar* _tmp24_;
				gchar* _tmp25_;
#line 305 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp17_ = self->manager;
#line 305 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp18_ = iface;
#line 305 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp19_ = uri;
#line 305 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp20_ = tracker_data_query_resource_id (_tmp17_, _tmp18_, _tmp19_);
#line 305 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if (!(_tmp20_ > 0)) {
#line 305 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					break;
#line 3170 "tracker-sparql-query.c"
				}
#line 307 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp21_ = g_new0 (guchar, 16);
#line 307 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				new_base_uuid = _tmp21_;
#line 307 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				new_base_uuid_length1 = 16;
#line 307 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_new_base_uuid_size_ = new_base_uuid_length1;
#line 308 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp22_ = new_base_uuid;
#line 308 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp22__length1 = new_base_uuid_length1;
#line 308 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				uuid_generate (_tmp22_);
#line 309 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp23_ = new_base_uuid;
#line 309 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp23__length1 = new_base_uuid_length1;
#line 309 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp24_ = user_bnodeid;
#line 309 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp25_ = tracker_sparql_query_get_uuid_for_name (self, _tmp23_, _tmp23__length1, _tmp24_);
#line 309 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_free0 (uri);
#line 309 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				uri = _tmp25_;
#line 305 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				new_base_uuid = (g_free (new_base_uuid), NULL);
#line 3200 "tracker-sparql-query.c"
			}
#line 312 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp26_ = self->priv->blank_nodes;
#line 312 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp27_ = user_bnodeid;
#line 312 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp28_ = g_strdup (_tmp27_);
#line 312 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp29_ = uri;
#line 312 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp30_ = g_strdup (_tmp29_);
#line 312 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_hash_table_insert (_tmp26_, _tmp28_, _tmp30_);
#line 303 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_object_unref0 (iface);
#line 3216 "tracker-sparql-query.c"
		}
#line 315 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		result = uri;
#line 315 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		return result;
#line 3222 "tracker-sparql-query.c"
	}
}


gboolean tracker_sparql_query_next (TrackerSparqlQuery* self, GError** error) {
	gboolean result = FALSE;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	TrackerSparqlQueryTokenInfo* _tmp18_;
	gint _tmp18__length1;
	gint _tmp19_;
	TrackerSparqlQueryTokenInfo _tmp20_;
	TrackerSparqlTokenType _tmp21_;
	GError * _inner_error_ = NULL;
#line 319 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 320 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = self->priv->index;
#line 320 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->priv->index = (_tmp0_ + 1) % TRACKER_SPARQL_QUERY_BUFFER_SIZE;
#line 321 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = self->priv->size;
#line 321 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->priv->size = _tmp1_ - 1;
#line 322 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp2_ = self->priv->size;
#line 322 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (_tmp2_ <= 0) {
#line 3252 "tracker-sparql-query.c"
		TrackerSourceLocation begin = {0};
		TrackerSourceLocation end = {0};
		TrackerSparqlTokenType type = 0;
		TrackerSparqlScanner* _tmp3_;
		TrackerSourceLocation _tmp4_ = {0};
		TrackerSourceLocation _tmp5_ = {0};
		TrackerSparqlTokenType _tmp6_;
		TrackerSparqlQueryTokenInfo* _tmp9_;
		gint _tmp9__length1;
		gint _tmp10_;
		TrackerSparqlTokenType _tmp11_;
		TrackerSparqlQueryTokenInfo* _tmp12_;
		gint _tmp12__length1;
		gint _tmp13_;
		TrackerSourceLocation _tmp14_;
		TrackerSparqlQueryTokenInfo* _tmp15_;
		gint _tmp15__length1;
		gint _tmp16_;
		TrackerSourceLocation _tmp17_;
#line 324 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp3_ = self->priv->scanner;
#line 324 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp6_ = tracker_sparql_scanner_read_token (_tmp3_, &_tmp4_, &_tmp5_, &_inner_error_);
#line 324 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		begin = _tmp4_;
#line 324 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		end = _tmp5_;
#line 324 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		type = _tmp6_;
#line 324 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 324 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 3286 "tracker-sparql-query.c"
				gboolean _tmp7_ = FALSE;
#line 324 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 324 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return _tmp7_;
#line 3292 "tracker-sparql-query.c"
			} else {
				gboolean _tmp8_ = FALSE;
#line 324 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 324 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_clear_error (&_inner_error_);
#line 324 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return _tmp8_;
#line 3301 "tracker-sparql-query.c"
			}
		}
#line 325 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp9_ = self->priv->tokens;
#line 325 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp9__length1 = self->priv->tokens_length1;
#line 325 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp10_ = self->priv->index;
#line 325 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp11_ = type;
#line 325 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp9_[_tmp10_].type = _tmp11_;
#line 326 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp12_ = self->priv->tokens;
#line 326 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp12__length1 = self->priv->tokens_length1;
#line 326 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp13_ = self->priv->index;
#line 326 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp14_ = begin;
#line 326 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp12_[_tmp13_].begin = _tmp14_;
#line 327 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp15_ = self->priv->tokens;
#line 327 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp15__length1 = self->priv->tokens_length1;
#line 327 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp16_ = self->priv->index;
#line 327 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp17_ = end;
#line 327 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp15_[_tmp16_].end = _tmp17_;
#line 328 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		self->priv->size = 1;
#line 3336 "tracker-sparql-query.c"
	}
#line 330 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp18_ = self->priv->tokens;
#line 330 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp18__length1 = self->priv->tokens_length1;
#line 330 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp19_ = self->priv->index;
#line 330 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp20_ = _tmp18_[_tmp19_];
#line 330 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp21_ = _tmp20_.type;
#line 330 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	result = _tmp21_ != TRACKER_SPARQL_TOKEN_TYPE_EOF;
#line 330 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return result;
#line 3352 "tracker-sparql-query.c"
}


TrackerSparqlTokenType tracker_sparql_query_current (TrackerSparqlQuery* self) {
	TrackerSparqlTokenType result = 0;
	TrackerSparqlQueryTokenInfo* _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_;
	TrackerSparqlQueryTokenInfo _tmp2_;
	TrackerSparqlTokenType _tmp3_;
#line 333 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 334 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = self->priv->tokens;
#line 334 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0__length1 = self->priv->tokens_length1;
#line 334 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = self->priv->index;
#line 334 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp2_ = _tmp0_[_tmp1_];
#line 334 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp3_ = _tmp2_.type;
#line 334 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	result = _tmp3_;
#line 334 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return result;
#line 3379 "tracker-sparql-query.c"
}


TrackerSparqlTokenType tracker_sparql_query_last (TrackerSparqlQuery* self) {
	TrackerSparqlTokenType result = 0;
	gint last_index = 0;
	gint _tmp0_;
	TrackerSparqlQueryTokenInfo* _tmp1_;
	gint _tmp1__length1;
	TrackerSparqlQueryTokenInfo _tmp2_;
	TrackerSparqlTokenType _tmp3_;
#line 337 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 338 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = self->priv->index;
#line 338 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	last_index = ((_tmp0_ + TRACKER_SPARQL_QUERY_BUFFER_SIZE) - 1) % TRACKER_SPARQL_QUERY_BUFFER_SIZE;
#line 339 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = self->priv->tokens;
#line 339 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1__length1 = self->priv->tokens_length1;
#line 339 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp2_ = _tmp1_[last_index];
#line 339 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp3_ = _tmp2_.type;
#line 339 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	result = _tmp3_;
#line 339 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return result;
#line 3409 "tracker-sparql-query.c"
}


gboolean tracker_sparql_query_accept (TrackerSparqlQuery* self, TrackerSparqlTokenType type, GError** error) {
	gboolean result = FALSE;
	TrackerSparqlTokenType _tmp0_;
	TrackerSparqlTokenType _tmp1_;
	GError * _inner_error_ = NULL;
#line 342 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 343 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = tracker_sparql_query_current (self);
#line 343 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = type;
#line 343 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (_tmp0_ == _tmp1_) {
#line 344 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		tracker_sparql_query_next (self, &_inner_error_);
#line 344 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 344 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 3432 "tracker-sparql-query.c"
				gboolean _tmp2_ = FALSE;
#line 344 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 344 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return _tmp2_;
#line 3438 "tracker-sparql-query.c"
			} else {
				gboolean _tmp3_ = FALSE;
#line 344 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 344 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_clear_error (&_inner_error_);
#line 344 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return _tmp3_;
#line 3447 "tracker-sparql-query.c"
			}
		}
#line 345 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		result = TRUE;
#line 345 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		return result;
#line 3454 "tracker-sparql-query.c"
	}
#line 347 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	result = FALSE;
#line 347 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return result;
#line 3460 "tracker-sparql-query.c"
}


void tracker_sparql_query_optional (TrackerSparqlQuery* self, TrackerSparqlTokenType type, GError** error) {
	TrackerSparqlTokenType _tmp0_;
	TrackerSparqlTokenType _tmp1_;
	GError * _inner_error_ = NULL;
#line 350 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_if_fail (self != NULL);
#line 351 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = tracker_sparql_query_current (self);
#line 351 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = type;
#line 351 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (_tmp0_ == _tmp1_) {
#line 352 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		tracker_sparql_query_next (self, &_inner_error_);
#line 352 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 352 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 352 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 352 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 3486 "tracker-sparql-query.c"
			} else {
#line 352 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 352 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_clear_error (&_inner_error_);
#line 352 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 3494 "tracker-sparql-query.c"
			}
		}
	}
}


GError* tracker_sparql_query_get_error (TrackerSparqlQuery* self, const gchar* msg) {
	GError* result = NULL;
	TrackerSparqlQueryTokenInfo* _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_;
	TrackerSparqlQueryTokenInfo _tmp2_;
	TrackerSourceLocation _tmp3_;
	gint _tmp4_;
	TrackerSparqlQueryTokenInfo* _tmp5_;
	gint _tmp5__length1;
	gint _tmp6_;
	TrackerSparqlQueryTokenInfo _tmp7_;
	TrackerSourceLocation _tmp8_;
	gint _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	GError* _tmp13_;
	GError* _tmp14_;
#line 355 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 355 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (msg != NULL, NULL);
#line 356 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = self->priv->tokens;
#line 356 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0__length1 = self->priv->tokens_length1;
#line 356 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = self->priv->index;
#line 356 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp2_ = _tmp0_[_tmp1_];
#line 356 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp3_ = _tmp2_.begin;
#line 356 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp4_ = _tmp3_.line;
#line 356 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp5_ = self->priv->tokens;
#line 356 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp5__length1 = self->priv->tokens_length1;
#line 356 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp6_ = self->priv->index;
#line 356 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp7_ = _tmp5_[_tmp6_];
#line 356 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp8_ = _tmp7_.begin;
#line 356 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp9_ = _tmp8_.column;
#line 356 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp10_ = msg;
#line 356 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp11_ = g_strdup_printf ("%d.%d: syntax error, %s", _tmp4_, _tmp9_, _tmp10_);
#line 356 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp12_ = _tmp11_;
#line 356 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp13_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_PARSE, _tmp12_);
#line 356 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp14_ = _tmp13_;
#line 356 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_free0 (_tmp12_);
#line 356 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	result = _tmp14_;
#line 356 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return result;
#line 3564 "tracker-sparql-query.c"
}


GError* tracker_sparql_query_get_internal_error (TrackerSparqlQuery* self, const gchar* msg) {
	GError* result = NULL;
	TrackerSparqlQueryTokenInfo* _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_;
	TrackerSparqlQueryTokenInfo _tmp2_;
	TrackerSourceLocation _tmp3_;
	gint _tmp4_;
	TrackerSparqlQueryTokenInfo* _tmp5_;
	gint _tmp5__length1;
	gint _tmp6_;
	TrackerSparqlQueryTokenInfo _tmp7_;
	TrackerSourceLocation _tmp8_;
	gint _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	GError* _tmp13_;
	GError* _tmp14_;
#line 359 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 359 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (msg != NULL, NULL);
#line 360 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = self->priv->tokens;
#line 360 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0__length1 = self->priv->tokens_length1;
#line 360 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = self->priv->index;
#line 360 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp2_ = _tmp0_[_tmp1_];
#line 360 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp3_ = _tmp2_.begin;
#line 360 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp4_ = _tmp3_.line;
#line 360 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp5_ = self->priv->tokens;
#line 360 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp5__length1 = self->priv->tokens_length1;
#line 360 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp6_ = self->priv->index;
#line 360 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp7_ = _tmp5_[_tmp6_];
#line 360 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp8_ = _tmp7_.begin;
#line 360 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp9_ = _tmp8_.column;
#line 360 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp10_ = msg;
#line 360 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp11_ = g_strdup_printf ("%d.%d: %s", _tmp4_, _tmp9_, _tmp10_);
#line 360 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp12_ = _tmp11_;
#line 360 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp13_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, _tmp12_);
#line 360 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp14_ = _tmp13_;
#line 360 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_free0 (_tmp12_);
#line 360 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	result = _tmp14_;
#line 360 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return result;
#line 3631 "tracker-sparql-query.c"
}


gboolean tracker_sparql_query_expect (TrackerSparqlQuery* self, TrackerSparqlTokenType type, GError** error) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	TrackerSparqlTokenType _tmp1_;
	gboolean _tmp2_;
	TrackerSparqlTokenType _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GError* _tmp9_;
	GError* _tmp10_;
	GError * _inner_error_ = NULL;
#line 363 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 364 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = type;
#line 364 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp2_ = tracker_sparql_query_accept (self, _tmp1_, &_inner_error_);
#line 364 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = _tmp2_;
#line 364 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 364 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 3659 "tracker-sparql-query.c"
			gboolean _tmp3_ = FALSE;
#line 364 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_propagate_error (error, _inner_error_);
#line 364 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return _tmp3_;
#line 3665 "tracker-sparql-query.c"
		} else {
			gboolean _tmp4_ = FALSE;
#line 364 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 364 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_clear_error (&_inner_error_);
#line 364 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return _tmp4_;
#line 3674 "tracker-sparql-query.c"
		}
	}
#line 364 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (_tmp0_) {
#line 365 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		result = TRUE;
#line 365 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		return result;
#line 3683 "tracker-sparql-query.c"
	}
#line 368 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp5_ = type;
#line 368 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp6_ = tracker_sparql_token_type_to_string (_tmp5_);
#line 368 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp7_ = g_strdup_printf ("expected %s", _tmp6_);
#line 368 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp8_ = _tmp7_;
#line 368 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp9_ = tracker_sparql_query_get_error (self, _tmp8_);
#line 368 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp10_ = _tmp9_;
#line 368 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_free0 (_tmp8_);
#line 368 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_inner_error_ = _tmp10_;
#line 368 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 3703 "tracker-sparql-query.c"
		gboolean _tmp11_ = FALSE;
#line 368 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		g_propagate_error (error, _inner_error_);
#line 368 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		return _tmp11_;
#line 3709 "tracker-sparql-query.c"
	} else {
		gboolean _tmp12_ = FALSE;
#line 368 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 368 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		g_clear_error (&_inner_error_);
#line 368 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		return _tmp12_;
#line 3718 "tracker-sparql-query.c"
	}
}


void tracker_sparql_query_get_location (TrackerSparqlQuery* self, TrackerSourceLocation* result) {
	TrackerSparqlQueryTokenInfo* _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_;
	TrackerSparqlQueryTokenInfo _tmp2_;
	TrackerSourceLocation _tmp3_;
#line 371 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_if_fail (self != NULL);
#line 372 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = self->priv->tokens;
#line 372 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0__length1 = self->priv->tokens_length1;
#line 372 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = self->priv->index;
#line 372 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp2_ = _tmp0_[_tmp1_];
#line 372 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp3_ = _tmp2_.begin;
#line 372 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	*result = _tmp3_;
#line 372 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return;
#line 3745 "tracker-sparql-query.c"
}


void tracker_sparql_query_set_location (TrackerSparqlQuery* self, TrackerSourceLocation* location) {
	TrackerSparqlScanner* _tmp0_;
	TrackerSourceLocation _tmp1_;
	GError * _inner_error_ = NULL;
#line 375 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_if_fail (self != NULL);
#line 375 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_if_fail (location != NULL);
#line 376 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = self->priv->scanner;
#line 376 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = *location;
#line 376 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	tracker_sparql_scanner_seek (_tmp0_, &_tmp1_);
#line 377 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->priv->size = 0;
#line 378 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->priv->index = 0;
#line 3767 "tracker-sparql-query.c"
	{
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		tracker_sparql_query_next (self, &_inner_error_);
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 3775 "tracker-sparql-query.c"
				goto __catch2_tracker_sparql_error;
			}
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_clear_error (&_inner_error_);
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return;
#line 3784 "tracker-sparql-query.c"
		}
	}
	goto __finally2;
	__catch2_tracker_sparql_error:
	{
		GError* e = NULL;
#line 379 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		e = _inner_error_;
#line 379 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_inner_error_ = NULL;
#line 383 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		g_critical ("internal error: next in set_location failed");
#line 379 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_error_free0 (e);
#line 3799 "tracker-sparql-query.c"
	}
	__finally2:
#line 379 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 379 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 379 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		g_clear_error (&_inner_error_);
#line 379 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		return;
#line 3810 "tracker-sparql-query.c"
	}
}


gchar* tracker_sparql_query_get_last_string (TrackerSparqlQuery* self, gint strip) {
	gchar* result = NULL;
	gint last_index = 0;
	gint _tmp0_;
	TrackerSparqlQueryTokenInfo* _tmp1_;
	gint _tmp1__length1;
	TrackerSparqlQueryTokenInfo _tmp2_;
	TrackerSourceLocation _tmp3_;
	gchar* _tmp4_;
	gint _tmp5_;
	TrackerSparqlQueryTokenInfo* _tmp6_;
	gint _tmp6__length1;
	TrackerSparqlQueryTokenInfo _tmp7_;
	TrackerSourceLocation _tmp8_;
	gchar* _tmp9_;
	TrackerSparqlQueryTokenInfo* _tmp10_;
	gint _tmp10__length1;
	TrackerSparqlQueryTokenInfo _tmp11_;
	TrackerSourceLocation _tmp12_;
	gchar* _tmp13_;
	gint _tmp14_;
	gchar* _tmp15_;
#line 387 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 388 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = self->priv->index;
#line 388 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	last_index = ((_tmp0_ + TRACKER_SPARQL_QUERY_BUFFER_SIZE) - 1) % TRACKER_SPARQL_QUERY_BUFFER_SIZE;
#line 389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = self->priv->tokens;
#line 389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1__length1 = self->priv->tokens_length1;
#line 389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp2_ = _tmp1_[last_index];
#line 389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp3_ = _tmp2_.begin;
#line 389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp4_ = _tmp3_.pos;
#line 389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp5_ = strip;
#line 389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp6_ = self->priv->tokens;
#line 389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp6__length1 = self->priv->tokens_length1;
#line 389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp7_ = _tmp6_[last_index];
#line 389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp8_ = _tmp7_.end;
#line 389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp9_ = _tmp8_.pos;
#line 389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp10_ = self->priv->tokens;
#line 389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp10__length1 = self->priv->tokens_length1;
#line 389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp11_ = _tmp10_[last_index];
#line 389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp12_ = _tmp11_.begin;
#line 389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp13_ = _tmp12_.pos;
#line 389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp14_ = strip;
#line 389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp15_ = string_substring ((const gchar*) (_tmp4_ + _tmp5_), (glong) 0, (glong) ((gint) ((_tmp9_ - _tmp13_) - (2 * _tmp14_))));
#line 389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	result = _tmp15_;
#line 389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return result;
#line 3883 "tracker-sparql-query.c"
}


static void tracker_sparql_query_parse_prologue (TrackerSparqlQuery* self, GError** error) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
#line 392 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_if_fail (self != NULL);
#line 393 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_BASE, &_inner_error_);
#line 393 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = _tmp1_;
#line 393 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 393 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 393 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_propagate_error (error, _inner_error_);
#line 393 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return;
#line 3905 "tracker-sparql-query.c"
		} else {
#line 393 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 393 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_clear_error (&_inner_error_);
#line 393 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return;
#line 3913 "tracker-sparql-query.c"
		}
	}
#line 393 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (_tmp0_) {
#line 394 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error_);
#line 394 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 394 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 394 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 394 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 3928 "tracker-sparql-query.c"
			} else {
#line 394 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 394 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_clear_error (&_inner_error_);
#line 394 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 3936 "tracker-sparql-query.c"
			}
		}
	}
#line 396 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	while (TRUE) {
#line 3942 "tracker-sparql-query.c"
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_;
		gchar* ns = NULL;
		gchar* _tmp4_;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_;
		gchar* uri = NULL;
		gchar* _tmp8_;
		GHashTable* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
#line 396 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp3_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PREFIX, &_inner_error_);
#line 396 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp2_ = _tmp3_;
#line 396 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 396 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 396 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 396 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 3968 "tracker-sparql-query.c"
			} else {
#line 396 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 396 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_clear_error (&_inner_error_);
#line 396 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 3976 "tracker-sparql-query.c"
			}
		}
#line 396 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (!_tmp2_) {
#line 396 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			break;
#line 3983 "tracker-sparql-query.c"
		}
#line 397 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp4_ = g_strdup ("");
#line 397 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		ns = _tmp4_;
#line 398 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp6_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error_);
#line 398 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp5_ = _tmp6_;
#line 398 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 398 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 398 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 398 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_free0 (ns);
#line 398 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 4003 "tracker-sparql-query.c"
			} else {
#line 398 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_free0 (ns);
#line 398 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 398 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_clear_error (&_inner_error_);
#line 398 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 4013 "tracker-sparql-query.c"
			}
		}
#line 398 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (_tmp5_) {
#line 4018 "tracker-sparql-query.c"
			gchar* _tmp7_;
#line 399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp7_ = tracker_sparql_query_get_last_string (self, 0);
#line 399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_free0 (ns);
#line 399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			ns = _tmp7_;
#line 4026 "tracker-sparql-query.c"
		}
#line 401 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
#line 401 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 401 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 401 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 401 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_free0 (ns);
#line 401 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 4040 "tracker-sparql-query.c"
			} else {
#line 401 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_free0 (ns);
#line 401 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 401 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_clear_error (&_inner_error_);
#line 401 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 4050 "tracker-sparql-query.c"
			}
		}
#line 402 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error_);
#line 402 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 402 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 402 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 402 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_free0 (ns);
#line 402 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 4065 "tracker-sparql-query.c"
			} else {
#line 402 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_free0 (ns);
#line 402 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 402 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_clear_error (&_inner_error_);
#line 402 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 4075 "tracker-sparql-query.c"
			}
		}
#line 403 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp8_ = tracker_sparql_query_get_last_string (self, 1);
#line 403 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		uri = _tmp8_;
#line 404 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp9_ = self->priv->prefix_map;
#line 404 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp10_ = ns;
#line 404 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp11_ = g_strdup (_tmp10_);
#line 404 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp12_ = uri;
#line 404 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp13_ = g_strdup (_tmp12_);
#line 404 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		g_hash_table_insert (_tmp9_, _tmp11_, _tmp13_);
#line 396 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_free0 (uri);
#line 396 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_free0 (ns);
#line 4098 "tracker-sparql-query.c"
	}
}


static void tracker_sparql_query_prepare_execute (TrackerSparqlQuery* self, GError** error) {
	gboolean _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	TrackerSparqlScanner* _tmp5_;
	GHashTable* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	TrackerOntologies* ontologies = NULL;
	TrackerDataManager* _tmp9_;
	TrackerOntologies* _tmp10_;
	TrackerOntologies* _tmp11_;
	TrackerOntologies* _tmp12_;
	gint _tmp13_;
	TrackerNamespace** _tmp14_;
	GError * _inner_error_ = NULL;
#line 408 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_if_fail (self != NULL);
#line 409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = self->priv->update_extensions;
#line 409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_vala_assert (!_tmp0_, "!update_extensions");
#line 411 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = self->priv->query_string;
#line 411 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp2_ = self->priv->query_string;
#line 411 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp3_ = strlen (_tmp2_);
#line 411 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp4_ = _tmp3_;
#line 411 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp5_ = tracker_sparql_scanner_new ((gchar*) _tmp1_, (gsize) ((glong) _tmp4_));
#line 411 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_object_unref0 (self->priv->scanner);
#line 411 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->priv->scanner = _tmp5_;
#line 412 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	tracker_sparql_query_next (self, &_inner_error_);
#line 412 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 412 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 412 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_propagate_error (error, _inner_error_);
#line 412 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return;
#line 4151 "tracker-sparql-query.c"
		} else {
#line 412 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 412 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_clear_error (&_inner_error_);
#line 412 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return;
#line 4159 "tracker-sparql-query.c"
		}
	}
#line 415 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp6_ = self->priv->prefix_map;
#line 415 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp7_ = g_strdup ("fn");
#line 415 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp8_ = g_strdup (TRACKER_SPARQL_QUERY_FN_NS);
#line 415 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_hash_table_insert (_tmp6_, _tmp7_, _tmp8_);
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp9_ = self->manager;
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp10_ = tracker_data_manager_get_ontologies (_tmp9_);
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp11_ = _g_object_ref0 (_tmp10_);
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	ontologies = _tmp11_;
#line 418 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp12_ = ontologies;
#line 418 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp14_ = tracker_ontologies_get_namespaces (_tmp12_, &_tmp13_);
#line 4182 "tracker-sparql-query.c"
	{
		TrackerNamespace** ns_collection = NULL;
		gint ns_collection_length1 = 0;
		gint _ns_collection_size_ = 0;
		gint ns_it = 0;
#line 418 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		ns_collection = _tmp14_;
#line 418 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		ns_collection_length1 = _tmp13_;
#line 418 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		for (ns_it = 0; ns_it < _tmp13_; ns_it = ns_it + 1) {
#line 4194 "tracker-sparql-query.c"
			TrackerNamespace* _tmp15_;
			TrackerNamespace* ns = NULL;
#line 418 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp15_ = _g_object_ref0 (ns_collection[ns_it]);
#line 418 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			ns = _tmp15_;
#line 4201 "tracker-sparql-query.c"
			{
				TrackerNamespace* _tmp16_;
				const gchar* _tmp17_;
				const gchar* _tmp18_;
				GHashTable* _tmp22_;
				TrackerNamespace* _tmp23_;
				const gchar* _tmp24_;
				const gchar* _tmp25_;
				gchar* _tmp26_;
				TrackerNamespace* _tmp27_;
				const gchar* _tmp28_;
				const gchar* _tmp29_;
				gchar* _tmp30_;
#line 419 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp16_ = ns;
#line 419 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp17_ = tracker_namespace_get_prefix (_tmp16_);
#line 419 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp18_ = _tmp17_;
#line 419 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if (_tmp18_ == NULL) {
#line 4223 "tracker-sparql-query.c"
					TrackerNamespace* _tmp19_;
					const gchar* _tmp20_;
					const gchar* _tmp21_;
#line 420 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp19_ = ns;
#line 420 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp20_ = tracker_namespace_get_uri (_tmp19_);
#line 420 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp21_ = _tmp20_;
#line 420 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_critical ("Namespace does not specify a prefix: %s", _tmp21_);
#line 421 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_object_unref0 (ns);
#line 421 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					continue;
#line 4239 "tracker-sparql-query.c"
				}
#line 423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp22_ = self->priv->prefix_map;
#line 423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp23_ = ns;
#line 423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp24_ = tracker_namespace_get_prefix (_tmp23_);
#line 423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp25_ = _tmp24_;
#line 423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp26_ = g_strdup (_tmp25_);
#line 423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp27_ = ns;
#line 423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp28_ = tracker_namespace_get_uri (_tmp27_);
#line 423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp29_ = _tmp28_;
#line 423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp30_ = g_strdup (_tmp29_);
#line 423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_hash_table_insert (_tmp22_, _tmp26_, _tmp30_);
#line 418 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_object_unref0 (ns);
#line 4263 "tracker-sparql-query.c"
			}
		}
	}
#line 426 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	tracker_sparql_query_parse_prologue (self, &_inner_error_);
#line 426 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 426 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 426 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_propagate_error (error, _inner_error_);
#line 426 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_object_unref0 (ontologies);
#line 426 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return;
#line 4279 "tracker-sparql-query.c"
		} else {
#line 426 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_object_unref0 (ontologies);
#line 426 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 426 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_clear_error (&_inner_error_);
#line 426 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return;
#line 4289 "tracker-sparql-query.c"
		}
	}
#line 408 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_object_unref0 (ontologies);
#line 4294 "tracker-sparql-query.c"
}


TrackerDBCursor* tracker_sparql_query_execute_cursor (TrackerSparqlQuery* self, GError** error) {
	TrackerDBCursor* result = NULL;
	TrackerSparqlTokenType _tmp0_;
	GError * _inner_error_ = NULL;
#line 430 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 432 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	tracker_sparql_query_prepare_execute (self, &_inner_error_);
#line 432 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 432 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 432 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_propagate_error (error, _inner_error_);
#line 432 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return NULL;
#line 4314 "tracker-sparql-query.c"
		} else {
#line 432 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 432 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_clear_error (&_inner_error_);
#line 432 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return NULL;
#line 4322 "tracker-sparql-query.c"
		}
	}
#line 434 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = tracker_sparql_query_current (self);
#line 434 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	switch (_tmp0_) {
#line 434 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_SELECT:
#line 4331 "tracker-sparql-query.c"
		{
			TrackerDBCursor* _tmp1_ = NULL;
			TrackerDBCursor* _tmp2_;
			TrackerDBCursor* _tmp3_;
#line 436 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp2_ = tracker_sparql_query_execute_select_cursor (self, &_inner_error_);
#line 436 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp1_ = _tmp2_;
#line 436 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 436 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 436 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_propagate_error (error, _inner_error_);
#line 436 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return NULL;
#line 4348 "tracker-sparql-query.c"
				} else {
#line 436 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 436 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_clear_error (&_inner_error_);
#line 436 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return NULL;
#line 4356 "tracker-sparql-query.c"
				}
			}
#line 436 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp3_ = _tmp1_;
#line 436 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp1_ = NULL;
#line 436 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			result = _tmp3_;
#line 436 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_object_unref0 (_tmp1_);
#line 436 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return result;
#line 4369 "tracker-sparql-query.c"
		}
#line 434 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_CONSTRUCT:
#line 4373 "tracker-sparql-query.c"
		{
			GError* _tmp4_;
#line 438 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp4_ = tracker_sparql_query_get_internal_error (self, "CONSTRUCT is not supported");
#line 438 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_inner_error_ = _tmp4_;
#line 438 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 438 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 438 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return NULL;
#line 4386 "tracker-sparql-query.c"
			} else {
#line 438 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 438 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_clear_error (&_inner_error_);
#line 438 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return NULL;
#line 4394 "tracker-sparql-query.c"
			}
		}
#line 434 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DESCRIBE:
#line 4399 "tracker-sparql-query.c"
		{
			GError* _tmp5_;
#line 440 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp5_ = tracker_sparql_query_get_internal_error (self, "DESCRIBE is not supported");
#line 440 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_inner_error_ = _tmp5_;
#line 440 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 440 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 440 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return NULL;
#line 4412 "tracker-sparql-query.c"
			} else {
#line 440 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 440 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_clear_error (&_inner_error_);
#line 440 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return NULL;
#line 4420 "tracker-sparql-query.c"
			}
		}
#line 434 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ASK:
#line 4425 "tracker-sparql-query.c"
		{
			TrackerDBCursor* _tmp6_ = NULL;
			TrackerDBCursor* _tmp7_;
			TrackerDBCursor* _tmp8_;
#line 442 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp7_ = tracker_sparql_query_execute_ask_cursor (self, &_inner_error_);
#line 442 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp6_ = _tmp7_;
#line 442 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 442 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 442 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_propagate_error (error, _inner_error_);
#line 442 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return NULL;
#line 4442 "tracker-sparql-query.c"
				} else {
#line 442 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 442 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_clear_error (&_inner_error_);
#line 442 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return NULL;
#line 4450 "tracker-sparql-query.c"
				}
			}
#line 442 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp8_ = _tmp6_;
#line 442 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp6_ = NULL;
#line 442 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			result = _tmp8_;
#line 442 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_object_unref0 (_tmp6_);
#line 442 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return result;
#line 4463 "tracker-sparql-query.c"
		}
#line 434 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_INSERT:
#line 434 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DELETE:
#line 434 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DROP:
#line 4471 "tracker-sparql-query.c"
		{
			GError* _tmp9_;
#line 446 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp9_ = tracker_sparql_query_get_error (self, "INSERT and DELETE are not supported in query mode");
#line 446 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_inner_error_ = _tmp9_;
#line 446 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 446 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 446 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return NULL;
#line 4484 "tracker-sparql-query.c"
			} else {
#line 446 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 446 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_clear_error (&_inner_error_);
#line 446 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return NULL;
#line 4492 "tracker-sparql-query.c"
			}
		}
		default:
		{
			GError* _tmp10_;
#line 448 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp10_ = tracker_sparql_query_get_error (self, "expected SELECT or ASK");
#line 448 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_inner_error_ = _tmp10_;
#line 448 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 448 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 448 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return NULL;
#line 4508 "tracker-sparql-query.c"
			} else {
#line 448 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 448 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_clear_error (&_inner_error_);
#line 448 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return NULL;
#line 4516 "tracker-sparql-query.c"
			}
		}
	}
}


GVariant* tracker_sparql_query_execute_update (TrackerSparqlQuery* self, gboolean blank, GError** error) {
	GVariant* result = NULL;
	GVariant* _result_ = NULL;
	gboolean _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	TrackerSparqlScanner* _tmp5_;
	GHashTable* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	TrackerOntologies* ontologies = NULL;
	TrackerDataManager* _tmp9_;
	TrackerOntologies* _tmp10_;
	TrackerOntologies* _tmp11_;
	TrackerOntologies* _tmp12_;
	gint _tmp13_;
	TrackerNamespace** _tmp14_;
	GVariantBuilder* ublank_nodes = NULL;
	gboolean _tmp31_;
	gboolean _tmp42_;
	GError * _inner_error_ = NULL;
#line 452 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 453 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_result_ = NULL;
#line 454 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = self->priv->update_extensions;
#line 454 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_vala_assert (_tmp0_, "update_extensions");
#line 456 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = self->priv->query_string;
#line 456 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp2_ = self->priv->query_string;
#line 456 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp3_ = strlen (_tmp2_);
#line 456 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp4_ = _tmp3_;
#line 456 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp5_ = tracker_sparql_scanner_new ((gchar*) _tmp1_, (gsize) ((glong) _tmp4_));
#line 456 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_object_unref0 (self->priv->scanner);
#line 456 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->priv->scanner = _tmp5_;
#line 457 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	tracker_sparql_query_next (self, &_inner_error_);
#line 457 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 457 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		g_propagate_error (error, _inner_error_);
#line 457 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_variant_unref0 (_result_);
#line 457 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		return NULL;
#line 4578 "tracker-sparql-query.c"
	}
#line 460 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp6_ = self->priv->prefix_map;
#line 460 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp7_ = g_strdup ("fn");
#line 460 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp8_ = g_strdup (TRACKER_SPARQL_QUERY_FN_NS);
#line 460 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_hash_table_insert (_tmp6_, _tmp7_, _tmp8_);
#line 461 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp9_ = self->manager;
#line 461 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp10_ = tracker_data_manager_get_ontologies (_tmp9_);
#line 461 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp11_ = _g_object_ref0 (_tmp10_);
#line 461 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	ontologies = _tmp11_;
#line 463 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp12_ = ontologies;
#line 463 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp14_ = tracker_ontologies_get_namespaces (_tmp12_, &_tmp13_);
#line 4600 "tracker-sparql-query.c"
	{
		TrackerNamespace** ns_collection = NULL;
		gint ns_collection_length1 = 0;
		gint _ns_collection_size_ = 0;
		gint ns_it = 0;
#line 463 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		ns_collection = _tmp14_;
#line 463 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		ns_collection_length1 = _tmp13_;
#line 463 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		for (ns_it = 0; ns_it < _tmp13_; ns_it = ns_it + 1) {
#line 4612 "tracker-sparql-query.c"
			TrackerNamespace* _tmp15_;
			TrackerNamespace* ns = NULL;
#line 463 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp15_ = _g_object_ref0 (ns_collection[ns_it]);
#line 463 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			ns = _tmp15_;
#line 4619 "tracker-sparql-query.c"
			{
				TrackerNamespace* _tmp16_;
				const gchar* _tmp17_;
				const gchar* _tmp18_;
				GHashTable* _tmp22_;
				TrackerNamespace* _tmp23_;
				const gchar* _tmp24_;
				const gchar* _tmp25_;
				gchar* _tmp26_;
				TrackerNamespace* _tmp27_;
				const gchar* _tmp28_;
				const gchar* _tmp29_;
				gchar* _tmp30_;
#line 464 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp16_ = ns;
#line 464 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp17_ = tracker_namespace_get_prefix (_tmp16_);
#line 464 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp18_ = _tmp17_;
#line 464 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if (_tmp18_ == NULL) {
#line 4641 "tracker-sparql-query.c"
					TrackerNamespace* _tmp19_;
					const gchar* _tmp20_;
					const gchar* _tmp21_;
#line 465 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp19_ = ns;
#line 465 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp20_ = tracker_namespace_get_uri (_tmp19_);
#line 465 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp21_ = _tmp20_;
#line 465 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_critical ("Namespace does not specify a prefix: %s", _tmp21_);
#line 466 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_object_unref0 (ns);
#line 466 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					continue;
#line 4657 "tracker-sparql-query.c"
				}
#line 468 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp22_ = self->priv->prefix_map;
#line 468 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp23_ = ns;
#line 468 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp24_ = tracker_namespace_get_prefix (_tmp23_);
#line 468 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp25_ = _tmp24_;
#line 468 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp26_ = g_strdup (_tmp25_);
#line 468 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp27_ = ns;
#line 468 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp28_ = tracker_namespace_get_uri (_tmp27_);
#line 468 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp29_ = _tmp28_;
#line 468 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp30_ = g_strdup (_tmp29_);
#line 468 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_hash_table_insert (_tmp22_, _tmp26_, _tmp30_);
#line 463 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_object_unref0 (ns);
#line 4681 "tracker-sparql-query.c"
			}
		}
	}
#line 471 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	tracker_sparql_query_parse_prologue (self, &_inner_error_);
#line 471 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 471 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		g_propagate_error (error, _inner_error_);
#line 471 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_object_unref0 (ontologies);
#line 471 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_variant_unref0 (_result_);
#line 471 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		return NULL;
#line 4697 "tracker-sparql-query.c"
	}
#line 474 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	ublank_nodes = NULL;
#line 476 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp31_ = blank;
#line 476 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (_tmp31_) {
#line 4705 "tracker-sparql-query.c"
		GVariantBuilder* _tmp32_;
#line 477 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp32_ = g_variant_builder_new ((const GVariantType*) "aaa{ss}");
#line 477 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_variant_builder_unref0 (ublank_nodes);
#line 477 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		ublank_nodes = _tmp32_;
#line 4713 "tracker-sparql-query.c"
	}
#line 480 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	while (TRUE) {
#line 4717 "tracker-sparql-query.c"
		TrackerSparqlTokenType _tmp33_;
		TrackerSparqlTokenType _tmp34_;
#line 480 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp33_ = tracker_sparql_query_current (self);
#line 480 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (!(_tmp33_ != TRACKER_SPARQL_TOKEN_TYPE_EOF)) {
#line 480 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			break;
#line 4726 "tracker-sparql-query.c"
		}
#line 481 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp34_ = tracker_sparql_query_current (self);
#line 481 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		switch (_tmp34_) {
#line 481 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_WITH:
#line 481 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_INSERT:
#line 481 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_DELETE:
#line 4738 "tracker-sparql-query.c"
			{
				gboolean _tmp35_;
#line 485 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp35_ = blank;
#line 485 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if (_tmp35_) {
#line 4745 "tracker-sparql-query.c"
					GVariantBuilder* _tmp36_;
					GVariantBuilder* _tmp37_;
					GVariantBuilder* _tmp38_;
#line 486 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp36_ = ublank_nodes;
#line 486 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_variant_builder_open (_tmp36_, (const GVariantType*) "aa{ss}");
#line 487 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp37_ = ublank_nodes;
#line 487 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					tracker_sparql_query_execute_insert_delete (self, _tmp37_, &_inner_error_);
#line 487 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 487 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_propagate_error (error, _inner_error_);
#line 487 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_variant_builder_unref0 (ublank_nodes);
#line 487 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_object_unref0 (ontologies);
#line 487 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_variant_unref0 (_result_);
#line 487 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						return NULL;
#line 4769 "tracker-sparql-query.c"
					}
#line 488 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp38_ = ublank_nodes;
#line 488 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_variant_builder_close (_tmp38_);
#line 4775 "tracker-sparql-query.c"
				} else {
#line 490 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					tracker_sparql_query_execute_insert_delete (self, NULL, &_inner_error_);
#line 490 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 490 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_propagate_error (error, _inner_error_);
#line 490 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_variant_builder_unref0 (ublank_nodes);
#line 490 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_object_unref0 (ontologies);
#line 490 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_variant_unref0 (_result_);
#line 490 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						return NULL;
#line 4791 "tracker-sparql-query.c"
					}
				}
#line 492 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				break;
#line 4796 "tracker-sparql-query.c"
			}
#line 481 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_DROP:
#line 4800 "tracker-sparql-query.c"
			{
				GError* _tmp39_;
#line 494 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp39_ = tracker_sparql_query_get_internal_error (self, "DROP GRAPH is not supported");
#line 494 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_inner_error_ = _tmp39_;
#line 494 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 494 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_variant_builder_unref0 (ublank_nodes);
#line 494 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_object_unref0 (ontologies);
#line 494 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_variant_unref0 (_result_);
#line 494 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return NULL;
#line 4817 "tracker-sparql-query.c"
			}
#line 481 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_SELECT:
#line 481 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_CONSTRUCT:
#line 481 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_DESCRIBE:
#line 481 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_ASK:
#line 4827 "tracker-sparql-query.c"
			{
				GError* _tmp40_;
#line 499 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp40_ = tracker_sparql_query_get_error (self, "SELECT, CONSTRUCT, DESCRIBE, and ASK are not supported in update mode");
#line 499 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_inner_error_ = _tmp40_;
#line 499 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 499 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_variant_builder_unref0 (ublank_nodes);
#line 499 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_object_unref0 (ontologies);
#line 499 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_variant_unref0 (_result_);
#line 499 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return NULL;
#line 4844 "tracker-sparql-query.c"
			}
			default:
			{
				GError* _tmp41_;
#line 501 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp41_ = tracker_sparql_query_get_error (self, "expected INSERT or DELETE");
#line 501 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_inner_error_ = _tmp41_;
#line 501 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 501 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_variant_builder_unref0 (ublank_nodes);
#line 501 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_object_unref0 (ontologies);
#line 501 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_variant_unref0 (_result_);
#line 501 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return NULL;
#line 4863 "tracker-sparql-query.c"
			}
		}
#line 506 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		tracker_sparql_query_optional (self, TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON, &_inner_error_);
#line 506 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 506 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_propagate_error (error, _inner_error_);
#line 506 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_variant_builder_unref0 (ublank_nodes);
#line 506 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_object_unref0 (ontologies);
#line 506 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_variant_unref0 (_result_);
#line 506 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return NULL;
#line 4880 "tracker-sparql-query.c"
		}
	}
#line 509 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp42_ = blank;
#line 509 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (_tmp42_) {
#line 4887 "tracker-sparql-query.c"
		GVariantBuilder* _tmp43_;
		GVariant* _tmp44_;
#line 510 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp43_ = ublank_nodes;
#line 510 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp44_ = g_variant_builder_end (_tmp43_);
#line 510 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		g_variant_ref_sink (_tmp44_);
#line 510 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_variant_unref0 (_result_);
#line 510 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_result_ = _tmp44_;
#line 4900 "tracker-sparql-query.c"
	}
#line 513 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	result = _result_;
#line 513 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_variant_builder_unref0 (ublank_nodes);
#line 513 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_object_unref0 (ontologies);
#line 513 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return result;
#line 4910 "tracker-sparql-query.c"
}


static TrackerDBStatement* tracker_sparql_query_prepare_for_exec (TrackerSparqlQuery* self, TrackerDBInterface* iface, const gchar* sql, GError** error) {
	TrackerDBStatement* result = NULL;
	TrackerDBStatementCacheType _tmp0_ = 0;
	gboolean _tmp1_;
	TrackerDBStatement* stmt = NULL;
	TrackerDBInterface* _tmp2_;
	const gchar* _tmp3_;
	TrackerDBStatement* _tmp4_;
	gint i = 0;
	GList* _tmp5_;
	GError * _inner_error_ = NULL;
#line 516 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 516 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (iface != NULL, NULL);
#line 516 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (sql != NULL, NULL);
#line 517 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = self->priv->_no_cache;
#line 517 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (_tmp1_) {
#line 517 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp0_ = TRACKER_DB_STATEMENT_CACHE_TYPE_NONE;
#line 4937 "tracker-sparql-query.c"
	} else {
#line 517 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp0_ = TRACKER_DB_STATEMENT_CACHE_TYPE_SELECT;
#line 4941 "tracker-sparql-query.c"
	}
#line 517 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp2_ = iface;
#line 517 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp3_ = sql;
#line 517 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp4_ = tracker_db_interface_create_statement (_tmp2_, _tmp0_, &_inner_error_, "%s", _tmp3_);
#line 517 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	stmt = _tmp4_;
#line 517 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 517 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 517 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_propagate_error (error, _inner_error_);
#line 517 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return NULL;
#line 4959 "tracker-sparql-query.c"
		} else {
#line 517 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 517 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_clear_error (&_inner_error_);
#line 517 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return NULL;
#line 4967 "tracker-sparql-query.c"
		}
	}
#line 520 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	i = 0;
#line 521 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp5_ = self->bindings;
#line 4974 "tracker-sparql-query.c"
	{
		GList* binding_collection = NULL;
		GList* binding_it = NULL;
#line 521 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		binding_collection = _tmp5_;
#line 521 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		for (binding_it = binding_collection; binding_it != NULL; binding_it = binding_it->next) {
#line 4982 "tracker-sparql-query.c"
			TrackerSparqlLiteralBinding* _tmp6_;
			TrackerSparqlLiteralBinding* binding = NULL;
#line 521 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp6_ = _g_object_ref0 ((TrackerSparqlLiteralBinding*) binding_it->data);
#line 521 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			binding = _tmp6_;
#line 4989 "tracker-sparql-query.c"
			{
				TrackerSparqlLiteralBinding* _tmp7_;
				TrackerPropertyType _tmp8_;
				gint _tmp59_;
#line 522 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp7_ = binding;
#line 522 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp8_ = ((TrackerSparqlDataBinding*) _tmp7_)->data_type;
#line 522 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if (_tmp8_ == TRACKER_PROPERTY_TYPE_BOOLEAN) {
#line 5000 "tracker-sparql-query.c"
					gboolean _tmp9_ = FALSE;
					TrackerSparqlLiteralBinding* _tmp10_;
					const gchar* _tmp11_;
#line 523 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp10_ = binding;
#line 523 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp11_ = _tmp10_->literal;
#line 523 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if (g_strcmp0 (_tmp11_, "true") == 0) {
#line 523 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp9_ = TRUE;
#line 5012 "tracker-sparql-query.c"
					} else {
						TrackerSparqlLiteralBinding* _tmp12_;
						const gchar* _tmp13_;
#line 523 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp12_ = binding;
#line 523 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp13_ = _tmp12_->literal;
#line 523 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp9_ = g_strcmp0 (_tmp13_, "1") == 0;
#line 5022 "tracker-sparql-query.c"
					}
#line 523 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if (_tmp9_) {
#line 5026 "tracker-sparql-query.c"
						TrackerDBStatement* _tmp14_;
						gint _tmp15_;
#line 524 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp14_ = stmt;
#line 524 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp15_ = i;
#line 524 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						tracker_db_statement_bind_int (_tmp14_, _tmp15_, 1);
#line 5035 "tracker-sparql-query.c"
					} else {
						gboolean _tmp16_ = FALSE;
						TrackerSparqlLiteralBinding* _tmp17_;
						const gchar* _tmp18_;
#line 525 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp17_ = binding;
#line 525 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp18_ = _tmp17_->literal;
#line 525 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						if (g_strcmp0 (_tmp18_, "false") == 0) {
#line 525 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_tmp16_ = TRUE;
#line 5048 "tracker-sparql-query.c"
						} else {
							TrackerSparqlLiteralBinding* _tmp19_;
							const gchar* _tmp20_;
#line 525 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_tmp19_ = binding;
#line 525 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_tmp20_ = _tmp19_->literal;
#line 525 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_tmp16_ = g_strcmp0 (_tmp20_, "0") == 0;
#line 5058 "tracker-sparql-query.c"
						}
#line 525 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						if (_tmp16_) {
#line 5062 "tracker-sparql-query.c"
							TrackerDBStatement* _tmp21_;
							gint _tmp22_;
#line 526 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_tmp21_ = stmt;
#line 526 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_tmp22_ = i;
#line 526 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							tracker_db_statement_bind_int (_tmp21_, _tmp22_, 0);
#line 5071 "tracker-sparql-query.c"
						} else {
							TrackerSparqlLiteralBinding* _tmp23_;
							const gchar* _tmp24_;
							gchar* _tmp25_;
							gchar* _tmp26_;
							GError* _tmp27_;
							GError* _tmp28_;
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_tmp23_ = binding;
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_tmp24_ = _tmp23_->literal;
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_tmp25_ = g_strdup_printf ("`%s' is not a valid boolean", _tmp24_);
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_tmp26_ = _tmp25_;
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_tmp27_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_TYPE, _tmp26_);
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_tmp28_ = _tmp27_;
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_g_free0 (_tmp26_);
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_inner_error_ = _tmp28_;
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								g_propagate_error (error, _inner_error_);
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_g_object_unref0 (binding);
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_g_object_unref0 (stmt);
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								return NULL;
#line 5105 "tracker-sparql-query.c"
							} else {
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_g_object_unref0 (binding);
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_g_object_unref0 (stmt);
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								g_clear_error (&_inner_error_);
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								return NULL;
#line 5117 "tracker-sparql-query.c"
							}
						}
					}
				} else {
					TrackerSparqlLiteralBinding* _tmp29_;
					TrackerPropertyType _tmp30_;
#line 530 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp29_ = binding;
#line 530 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp30_ = ((TrackerSparqlDataBinding*) _tmp29_)->data_type;
#line 530 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if (_tmp30_ == TRACKER_PROPERTY_TYPE_DATE) {
#line 5130 "tracker-sparql-query.c"
						gdouble _tmp31_ = 0.0;
						TrackerSparqlLiteralBinding* _tmp32_;
						const gchar* _tmp33_;
						gchar* _tmp34_;
						gchar* _tmp35_;
						gdouble _tmp36_;
						gdouble _tmp37_;
						TrackerDBStatement* _tmp38_;
						gint _tmp39_;
#line 531 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp32_ = binding;
#line 531 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp33_ = _tmp32_->literal;
#line 531 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp34_ = g_strconcat (_tmp33_, "T00:00:00Z", NULL);
#line 531 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp35_ = _tmp34_;
#line 531 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp36_ = tracker_string_to_date (_tmp35_, NULL, &_inner_error_);
#line 531 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp37_ = _tmp36_;
#line 531 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (_tmp35_);
#line 531 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp31_ = _tmp37_;
#line 531 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 531 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 531 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								g_propagate_error (error, _inner_error_);
#line 531 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_g_object_unref0 (binding);
#line 531 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_g_object_unref0 (stmt);
#line 531 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								return NULL;
#line 5168 "tracker-sparql-query.c"
							} else {
#line 531 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_g_object_unref0 (binding);
#line 531 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_g_object_unref0 (stmt);
#line 531 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 531 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								g_clear_error (&_inner_error_);
#line 531 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								return NULL;
#line 5180 "tracker-sparql-query.c"
							}
						}
#line 531 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp38_ = stmt;
#line 531 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp39_ = i;
#line 531 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						tracker_db_statement_bind_int (_tmp38_, _tmp39_, (gint) _tmp31_);
#line 5189 "tracker-sparql-query.c"
					} else {
						TrackerSparqlLiteralBinding* _tmp40_;
						TrackerPropertyType _tmp41_;
#line 532 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp40_ = binding;
#line 532 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp41_ = ((TrackerSparqlDataBinding*) _tmp40_)->data_type;
#line 532 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						if (_tmp41_ == TRACKER_PROPERTY_TYPE_DATETIME) {
#line 5199 "tracker-sparql-query.c"
							gdouble _tmp42_ = 0.0;
							TrackerSparqlLiteralBinding* _tmp43_;
							const gchar* _tmp44_;
							gdouble _tmp45_;
							TrackerDBStatement* _tmp46_;
							gint _tmp47_;
#line 533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_tmp43_ = binding;
#line 533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_tmp44_ = _tmp43_->literal;
#line 533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_tmp45_ = tracker_string_to_date (_tmp44_, NULL, &_inner_error_);
#line 533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_tmp42_ = _tmp45_;
#line 533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									g_propagate_error (error, _inner_error_);
#line 533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									_g_object_unref0 (binding);
#line 533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									_g_object_unref0 (stmt);
#line 533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									return NULL;
#line 5226 "tracker-sparql-query.c"
								} else {
#line 533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									_g_object_unref0 (binding);
#line 533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									_g_object_unref0 (stmt);
#line 533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									g_clear_error (&_inner_error_);
#line 533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									return NULL;
#line 5238 "tracker-sparql-query.c"
								}
							}
#line 533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_tmp46_ = stmt;
#line 533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_tmp47_ = i;
#line 533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							tracker_db_statement_bind_double (_tmp46_, _tmp47_, _tmp42_);
#line 5247 "tracker-sparql-query.c"
						} else {
							TrackerSparqlLiteralBinding* _tmp48_;
							TrackerPropertyType _tmp49_;
#line 534 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_tmp48_ = binding;
#line 534 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_tmp49_ = ((TrackerSparqlDataBinding*) _tmp48_)->data_type;
#line 534 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							if (_tmp49_ == TRACKER_PROPERTY_TYPE_INTEGER) {
#line 5257 "tracker-sparql-query.c"
								TrackerDBStatement* _tmp50_;
								gint _tmp51_;
								TrackerSparqlLiteralBinding* _tmp52_;
								const gchar* _tmp53_;
								gint _tmp54_;
#line 535 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_tmp50_ = stmt;
#line 535 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_tmp51_ = i;
#line 535 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_tmp52_ = binding;
#line 535 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_tmp53_ = _tmp52_->literal;
#line 535 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_tmp54_ = atoi (_tmp53_);
#line 535 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								tracker_db_statement_bind_int (_tmp50_, _tmp51_, _tmp54_);
#line 5275 "tracker-sparql-query.c"
							} else {
								TrackerDBStatement* _tmp55_;
								gint _tmp56_;
								TrackerSparqlLiteralBinding* _tmp57_;
								const gchar* _tmp58_;
#line 537 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_tmp55_ = stmt;
#line 537 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_tmp56_ = i;
#line 537 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_tmp57_ = binding;
#line 537 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_tmp58_ = _tmp57_->literal;
#line 537 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								tracker_db_statement_bind_text (_tmp55_, _tmp56_, _tmp58_);
#line 5291 "tracker-sparql-query.c"
							}
						}
					}
				}
#line 539 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp59_ = i;
#line 539 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				i = _tmp59_ + 1;
#line 521 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_object_unref0 (binding);
#line 5302 "tracker-sparql-query.c"
			}
		}
	}
#line 542 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	result = stmt;
#line 542 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return result;
#line 5310 "tracker-sparql-query.c"
}


static TrackerDBCursor* tracker_sparql_query_exec_sql_cursor (TrackerSparqlQuery* self, TrackerDBInterface* iface, const gchar* sql, TrackerPropertyType* types, int types_length1, gchar** variable_names, int variable_names_length1, GError** error) {
	TrackerDBCursor* result = NULL;
	TrackerDBStatement* stmt = NULL;
	TrackerDBInterface* _tmp0_;
	const gchar* _tmp1_;
	TrackerDBStatement* _tmp2_;
	TrackerDBCursor* _tmp3_ = NULL;
	TrackerDBStatement* _tmp4_;
	TrackerPropertyType* _tmp5_;
	gint _tmp5__length1;
	gchar** _tmp6_;
	gint _tmp6__length1;
	TrackerDBCursor* _tmp7_;
	TrackerDBCursor* _tmp8_;
	GError * _inner_error_ = NULL;
#line 545 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 545 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (iface != NULL, NULL);
#line 545 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (sql != NULL, NULL);
#line 546 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = iface;
#line 546 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = sql;
#line 546 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp2_ = tracker_sparql_query_prepare_for_exec (self, _tmp0_, _tmp1_, &_inner_error_);
#line 546 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	stmt = _tmp2_;
#line 546 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 546 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 546 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_propagate_error (error, _inner_error_);
#line 546 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return NULL;
#line 5351 "tracker-sparql-query.c"
		} else {
#line 546 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 546 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_clear_error (&_inner_error_);
#line 546 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return NULL;
#line 5359 "tracker-sparql-query.c"
		}
	}
#line 548 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp4_ = stmt;
#line 548 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp5_ = types;
#line 548 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp5__length1 = types_length1;
#line 548 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp6_ = variable_names;
#line 548 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp6__length1 = variable_names_length1;
#line 548 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp7_ = tracker_db_statement_start_sparql_cursor (_tmp4_, _tmp5_, _tmp5__length1, _tmp6_, _tmp6__length1, &_inner_error_);
#line 548 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp3_ = _tmp7_;
#line 548 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 548 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 548 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_propagate_error (error, _inner_error_);
#line 548 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_object_unref0 (stmt);
#line 548 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return NULL;
#line 5386 "tracker-sparql-query.c"
		} else {
#line 548 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_object_unref0 (stmt);
#line 548 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 548 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_clear_error (&_inner_error_);
#line 548 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return NULL;
#line 5396 "tracker-sparql-query.c"
		}
	}
#line 548 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp8_ = _tmp3_;
#line 548 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp3_ = NULL;
#line 548 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	result = _tmp8_;
#line 548 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_object_unref0 (_tmp3_);
#line 548 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_object_unref0 (stmt);
#line 548 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return result;
#line 5411 "tracker-sparql-query.c"
}


static gchar* tracker_sparql_query_get_select_query (TrackerSparqlQuery* self, TrackerSparqlSelectContext* * context, GError** error) {
	TrackerSparqlSelectContext* _vala_context = NULL;
	gchar* result = NULL;
	GString* sql = NULL;
	GString* _tmp0_;
	TrackerSparqlSelectContext* _tmp1_ = NULL;
	TrackerSparqlPattern* _tmp2_;
	GString* _tmp3_;
	TrackerSparqlSelectContext* _tmp4_;
	TrackerSparqlSelectContext* _tmp5_;
	GString* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	GError * _inner_error_ = NULL;
#line 551 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 555 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = g_string_new ("");
#line 555 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	sql = _tmp0_;
#line 556 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp2_ = self->pattern;
#line 556 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp3_ = sql;
#line 556 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp4_ = tracker_sparql_pattern_translate_select (_tmp2_, _tmp3_, FALSE, FALSE, &_inner_error_);
#line 556 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = _tmp4_;
#line 556 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 556 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 556 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_propagate_error (error, _inner_error_);
#line 556 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_string_free0 (sql);
#line 556 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return NULL;
#line 5453 "tracker-sparql-query.c"
		} else {
#line 556 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_string_free0 (sql);
#line 556 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 556 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_clear_error (&_inner_error_);
#line 556 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return NULL;
#line 5463 "tracker-sparql-query.c"
		}
	}
#line 556 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp5_ = _tmp1_;
#line 556 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = NULL;
#line 556 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tracker_sparql_context_unref0 (_vala_context);
#line 556 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_vala_context = _tmp5_;
#line 558 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_EOF, &_inner_error_);
#line 558 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 558 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 558 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_propagate_error (error, _inner_error_);
#line 558 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tracker_sparql_context_unref0 (_tmp1_);
#line 558 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_string_free0 (sql);
#line 558 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return NULL;
#line 5488 "tracker-sparql-query.c"
		} else {
#line 558 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tracker_sparql_context_unref0 (_tmp1_);
#line 558 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_string_free0 (sql);
#line 558 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 558 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_clear_error (&_inner_error_);
#line 558 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return NULL;
#line 5500 "tracker-sparql-query.c"
		}
	}
#line 560 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp6_ = sql;
#line 560 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp7_ = _tmp6_->str;
#line 560 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp8_ = g_strdup (_tmp7_);
#line 560 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	result = _tmp8_;
#line 560 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tracker_sparql_context_unref0 (_tmp1_);
#line 560 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_string_free0 (sql);
#line 560 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (context) {
#line 560 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		*context = _vala_context;
#line 5519 "tracker-sparql-query.c"
	} else {
#line 560 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tracker_sparql_context_unref0 (_vala_context);
#line 5523 "tracker-sparql-query.c"
	}
#line 560 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return result;
#line 5527 "tracker-sparql-query.c"
}


static TrackerDBCursor* tracker_sparql_query_execute_select_cursor (TrackerSparqlQuery* self, GError** error) {
	TrackerDBCursor* result = NULL;
	TrackerSparqlSelectContext* context = NULL;
	gchar* sql = NULL;
	TrackerSparqlSelectContext* _tmp0_ = NULL;
	gchar* _tmp1_;
	TrackerDBInterface* iface = NULL;
	TrackerDataManager* _tmp2_;
	TrackerDBInterface* _tmp3_;
	TrackerDBInterface* _tmp4_;
	TrackerDBCursor* _tmp5_ = NULL;
	TrackerDBInterface* _tmp6_;
	const gchar* _tmp7_;
	TrackerSparqlSelectContext* _tmp8_;
	TrackerPropertyType* _tmp9_;
	gint _tmp9__length1;
	TrackerSparqlSelectContext* _tmp10_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	TrackerDBCursor* _tmp12_;
	TrackerDBCursor* _tmp13_;
	GError * _inner_error_ = NULL;
#line 563 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 565 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = tracker_sparql_query_get_select_query (self, &_tmp0_, &_inner_error_);
#line 565 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tracker_sparql_context_unref0 (context);
#line 565 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	context = _tmp0_;
#line 565 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	sql = _tmp1_;
#line 565 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 565 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 565 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_propagate_error (error, _inner_error_);
#line 565 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tracker_sparql_context_unref0 (context);
#line 565 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return NULL;
#line 5573 "tracker-sparql-query.c"
		} else {
#line 565 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tracker_sparql_context_unref0 (context);
#line 565 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 565 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_clear_error (&_inner_error_);
#line 565 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return NULL;
#line 5583 "tracker-sparql-query.c"
		}
	}
#line 566 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp2_ = self->manager;
#line 566 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp3_ = tracker_data_manager_get_db_interface (_tmp2_);
#line 566 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 566 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	iface = _tmp4_;
#line 568 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp6_ = iface;
#line 568 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp7_ = sql;
#line 568 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp8_ = context;
#line 568 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp9_ = _tmp8_->types;
#line 568 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp9__length1 = _tmp8_->types_length1;
#line 568 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp10_ = context;
#line 568 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp11_ = _tmp10_->variable_names;
#line 568 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp11__length1 = _tmp10_->variable_names_length1;
#line 568 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp12_ = tracker_sparql_query_exec_sql_cursor (self, _tmp6_, _tmp7_, _tmp9_, _tmp9__length1, _tmp11_, _tmp11__length1, &_inner_error_);
#line 568 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp5_ = _tmp12_;
#line 568 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 568 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 568 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_propagate_error (error, _inner_error_);
#line 568 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_object_unref0 (iface);
#line 568 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_free0 (sql);
#line 568 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tracker_sparql_context_unref0 (context);
#line 568 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return NULL;
#line 5628 "tracker-sparql-query.c"
		} else {
#line 568 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_object_unref0 (iface);
#line 568 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_free0 (sql);
#line 568 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tracker_sparql_context_unref0 (context);
#line 568 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 568 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_clear_error (&_inner_error_);
#line 568 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return NULL;
#line 5642 "tracker-sparql-query.c"
		}
	}
#line 568 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp13_ = _tmp5_;
#line 568 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp5_ = NULL;
#line 568 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	result = _tmp13_;
#line 568 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_object_unref0 (_tmp5_);
#line 568 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_object_unref0 (iface);
#line 568 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_free0 (sql);
#line 568 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tracker_sparql_context_unref0 (context);
#line 568 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return result;
#line 5661 "tracker-sparql-query.c"
}


static gchar* tracker_sparql_query_get_ask_query (TrackerSparqlQuery* self, GError** error) {
	gchar* result = NULL;
	GString* pattern_sql = NULL;
	GString* _tmp0_;
	GString* sql = NULL;
	GString* _tmp1_;
	GString* _tmp2_;
	TrackerSparqlContext* _tmp3_ = NULL;
	TrackerSparqlPattern* _tmp4_;
	GString* _tmp5_;
	TrackerSparqlContext* _tmp6_;
	TrackerSparqlContext* _tmp7_;
	GString* _tmp8_;
	GString* _tmp9_;
	const gchar* _tmp10_;
	GString* _tmp11_;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_;
	TrackerSparqlContext* _tmp29_;
	TrackerSparqlContext* _tmp30_;
	TrackerSparqlContext* _tmp31_;
	GString* _tmp32_;
	const gchar* _tmp33_;
	gchar* _tmp34_;
	GError * _inner_error_ = NULL;
#line 571 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 574 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = g_string_new ("");
#line 574 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	pattern_sql = _tmp0_;
#line 577 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = g_string_new ("");
#line 577 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	sql = _tmp1_;
#line 578 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp2_ = sql;
#line 578 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_string_append (_tmp2_, "SELECT CASE EXISTS ( ");
#line 580 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_ASK, &_inner_error_);
#line 580 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 580 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 580 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_propagate_error (error, _inner_error_);
#line 580 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_string_free0 (sql);
#line 580 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_string_free0 (pattern_sql);
#line 580 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return NULL;
#line 5721 "tracker-sparql-query.c"
		} else {
#line 580 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_string_free0 (sql);
#line 580 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_string_free0 (pattern_sql);
#line 580 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 580 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_clear_error (&_inner_error_);
#line 580 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return NULL;
#line 5733 "tracker-sparql-query.c"
		}
	}
#line 582 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	tracker_sparql_query_optional (self, TRACKER_SPARQL_TOKEN_TYPE_WHERE, &_inner_error_);
#line 582 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 582 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 582 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_propagate_error (error, _inner_error_);
#line 582 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_string_free0 (sql);
#line 582 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_string_free0 (pattern_sql);
#line 582 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return NULL;
#line 5750 "tracker-sparql-query.c"
		} else {
#line 582 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_string_free0 (sql);
#line 582 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_string_free0 (pattern_sql);
#line 582 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 582 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_clear_error (&_inner_error_);
#line 582 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return NULL;
#line 5762 "tracker-sparql-query.c"
		}
	}
#line 584 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp4_ = self->pattern;
#line 584 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp5_ = pattern_sql;
#line 584 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp6_ = tracker_sparql_pattern_translate_group_graph_pattern (_tmp4_, _tmp5_, &_inner_error_);
#line 584 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp3_ = _tmp6_;
#line 584 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 584 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 584 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_propagate_error (error, _inner_error_);
#line 584 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_string_free0 (sql);
#line 584 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_string_free0 (pattern_sql);
#line 584 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return NULL;
#line 5785 "tracker-sparql-query.c"
		} else {
#line 584 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_string_free0 (sql);
#line 584 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_string_free0 (pattern_sql);
#line 584 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 584 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_clear_error (&_inner_error_);
#line 584 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return NULL;
#line 5797 "tracker-sparql-query.c"
		}
	}
#line 584 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp7_ = _tmp3_;
#line 584 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp3_ = NULL;
#line 584 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tracker_sparql_context_unref0 (self->context);
#line 584 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->context = _tmp7_;
#line 587 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp8_ = sql;
#line 587 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp9_ = pattern_sql;
#line 587 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp10_ = _tmp9_->str;
#line 587 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_string_append (_tmp8_, _tmp10_);
#line 588 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp11_ = sql;
#line 588 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_string_append (_tmp11_, " ) WHEN 1 THEN 'true' WHEN 0 THEN 'false' ELSE NULL END");
#line 590 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp16_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_GROUP, &_inner_error_);
#line 590 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp15_ = _tmp16_;
#line 590 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 590 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 590 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_propagate_error (error, _inner_error_);
#line 590 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tracker_sparql_context_unref0 (_tmp3_);
#line 590 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_string_free0 (sql);
#line 590 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_string_free0 (pattern_sql);
#line 590 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return NULL;
#line 5838 "tracker-sparql-query.c"
		} else {
#line 590 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tracker_sparql_context_unref0 (_tmp3_);
#line 590 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_string_free0 (sql);
#line 590 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_string_free0 (pattern_sql);
#line 590 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 590 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_clear_error (&_inner_error_);
#line 590 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return NULL;
#line 5852 "tracker-sparql-query.c"
		}
	}
#line 590 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (_tmp15_) {
#line 590 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp14_ = TRUE;
#line 5859 "tracker-sparql-query.c"
	} else {
		gboolean _tmp17_ = FALSE;
		gboolean _tmp18_;
#line 590 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp18_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_ORDER, &_inner_error_);
#line 590 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp17_ = _tmp18_;
#line 590 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 590 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 590 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 590 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tracker_sparql_context_unref0 (_tmp3_);
#line 590 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_string_free0 (sql);
#line 590 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_string_free0 (pattern_sql);
#line 590 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return NULL;
#line 5881 "tracker-sparql-query.c"
			} else {
#line 590 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tracker_sparql_context_unref0 (_tmp3_);
#line 590 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_string_free0 (sql);
#line 590 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_string_free0 (pattern_sql);
#line 590 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 590 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_clear_error (&_inner_error_);
#line 590 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return NULL;
#line 5895 "tracker-sparql-query.c"
			}
		}
#line 590 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp14_ = _tmp17_;
#line 5900 "tracker-sparql-query.c"
	}
#line 590 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (_tmp14_) {
#line 590 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp13_ = TRUE;
#line 5906 "tracker-sparql-query.c"
	} else {
		gboolean _tmp19_ = FALSE;
		gboolean _tmp20_;
#line 591 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp20_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OFFSET, &_inner_error_);
#line 591 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp19_ = _tmp20_;
#line 591 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 591 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 591 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 591 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tracker_sparql_context_unref0 (_tmp3_);
#line 591 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_string_free0 (sql);
#line 591 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_string_free0 (pattern_sql);
#line 591 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return NULL;
#line 5928 "tracker-sparql-query.c"
			} else {
#line 591 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tracker_sparql_context_unref0 (_tmp3_);
#line 591 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_string_free0 (sql);
#line 591 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_string_free0 (pattern_sql);
#line 591 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 591 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_clear_error (&_inner_error_);
#line 591 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return NULL;
#line 5942 "tracker-sparql-query.c"
			}
		}
#line 591 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp13_ = _tmp19_;
#line 5947 "tracker-sparql-query.c"
	}
#line 590 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (_tmp13_) {
#line 590 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp12_ = TRUE;
#line 5953 "tracker-sparql-query.c"
	} else {
		gboolean _tmp21_ = FALSE;
		gboolean _tmp22_;
#line 591 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp22_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_LIMIT, &_inner_error_);
#line 591 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp21_ = _tmp22_;
#line 591 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 591 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 591 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 591 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tracker_sparql_context_unref0 (_tmp3_);
#line 591 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_string_free0 (sql);
#line 591 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_string_free0 (pattern_sql);
#line 591 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return NULL;
#line 5975 "tracker-sparql-query.c"
			} else {
#line 591 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tracker_sparql_context_unref0 (_tmp3_);
#line 591 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_string_free0 (sql);
#line 591 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_string_free0 (pattern_sql);
#line 591 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 591 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_clear_error (&_inner_error_);
#line 591 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return NULL;
#line 5989 "tracker-sparql-query.c"
			}
		}
#line 591 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp12_ = _tmp21_;
#line 5994 "tracker-sparql-query.c"
	}
#line 590 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (_tmp12_) {
#line 5998 "tracker-sparql-query.c"
		TrackerSparqlTokenType _tmp23_;
		const gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		GError* _tmp27_;
		GError* _tmp28_;
#line 592 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp23_ = tracker_sparql_query_last (self);
#line 592 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp24_ = tracker_sparql_token_type_to_string (_tmp23_);
#line 592 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp25_ = g_strdup_printf ("invalid use of %s in ASK", _tmp24_);
#line 592 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp26_ = _tmp25_;
#line 592 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp27_ = tracker_sparql_query_get_error (self, _tmp26_);
#line 592 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp28_ = _tmp27_;
#line 592 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_free0 (_tmp26_);
#line 592 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_inner_error_ = _tmp28_;
#line 592 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 592 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_propagate_error (error, _inner_error_);
#line 592 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tracker_sparql_context_unref0 (_tmp3_);
#line 592 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_string_free0 (sql);
#line 592 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_string_free0 (pattern_sql);
#line 592 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return NULL;
#line 6033 "tracker-sparql-query.c"
		} else {
#line 592 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tracker_sparql_context_unref0 (_tmp3_);
#line 592 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_string_free0 (sql);
#line 592 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_string_free0 (pattern_sql);
#line 592 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 592 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_clear_error (&_inner_error_);
#line 592 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return NULL;
#line 6047 "tracker-sparql-query.c"
		}
	}
#line 595 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_EOF, &_inner_error_);
#line 595 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 595 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 595 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_propagate_error (error, _inner_error_);
#line 595 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tracker_sparql_context_unref0 (_tmp3_);
#line 595 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_string_free0 (sql);
#line 595 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_string_free0 (pattern_sql);
#line 595 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return NULL;
#line 6066 "tracker-sparql-query.c"
		} else {
#line 595 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tracker_sparql_context_unref0 (_tmp3_);
#line 595 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_string_free0 (sql);
#line 595 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_string_free0 (pattern_sql);
#line 595 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 595 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_clear_error (&_inner_error_);
#line 595 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return NULL;
#line 6080 "tracker-sparql-query.c"
		}
	}
#line 597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp29_ = self->context;
#line 597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp30_ = _tmp29_->parent_context;
#line 597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp31_ = _tracker_sparql_context_ref0 (_tmp30_);
#line 597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tracker_sparql_context_unref0 (self->context);
#line 597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->context = _tmp31_;
#line 599 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp32_ = sql;
#line 599 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp33_ = _tmp32_->str;
#line 599 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp34_ = g_strdup (_tmp33_);
#line 599 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	result = _tmp34_;
#line 599 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tracker_sparql_context_unref0 (_tmp3_);
#line 599 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_string_free0 (sql);
#line 599 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_string_free0 (pattern_sql);
#line 599 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return result;
#line 6109 "tracker-sparql-query.c"
}


static TrackerDBCursor* tracker_sparql_query_execute_ask_cursor (TrackerSparqlQuery* self, GError** error) {
	TrackerDBCursor* result = NULL;
	TrackerDBInterface* iface = NULL;
	TrackerDataManager* _tmp0_;
	TrackerDBInterface* _tmp1_;
	TrackerDBInterface* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	TrackerDBCursor* _tmp5_ = NULL;
	TrackerDBInterface* _tmp6_;
	TrackerPropertyType* _tmp7_;
	TrackerPropertyType* _tmp8_;
	gint _tmp8__length1;
	gchar* _tmp9_;
	gchar** _tmp10_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	TrackerDBCursor* _tmp12_;
	TrackerDBCursor* _tmp13_;
	TrackerDBCursor* _tmp14_;
	GError * _inner_error_ = NULL;
#line 602 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 603 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = self->manager;
#line 603 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = tracker_data_manager_get_db_interface (_tmp0_);
#line 603 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 603 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	iface = _tmp2_;
#line 604 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp4_ = tracker_sparql_query_get_ask_query (self, &_inner_error_);
#line 604 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp3_ = _tmp4_;
#line 604 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 604 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 604 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_propagate_error (error, _inner_error_);
#line 604 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_object_unref0 (iface);
#line 604 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return NULL;
#line 6158 "tracker-sparql-query.c"
		} else {
#line 604 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_object_unref0 (iface);
#line 604 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 604 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_clear_error (&_inner_error_);
#line 604 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return NULL;
#line 6168 "tracker-sparql-query.c"
		}
	}
#line 604 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp6_ = iface;
#line 604 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp7_ = g_new0 (TrackerPropertyType, 1);
#line 604 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp7_[0] = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 604 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp8_ = _tmp7_;
#line 604 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp8__length1 = 1;
#line 604 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp9_ = g_strdup ("result");
#line 604 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp10_ = g_new0 (gchar*, 1 + 1);
#line 604 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp10_[0] = _tmp9_;
#line 604 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp11_ = _tmp10_;
#line 604 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp11__length1 = 1;
#line 604 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp12_ = tracker_sparql_query_exec_sql_cursor (self, _tmp6_, _tmp3_, _tmp8_, 1, _tmp11_, 1, &_inner_error_);
#line 604 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp13_ = _tmp12_;
#line 604 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_free), NULL);
#line 604 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp8_ = (g_free (_tmp8_), NULL);
#line 604 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp5_ = _tmp13_;
#line 604 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 604 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 604 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_propagate_error (error, _inner_error_);
#line 604 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_free0 (_tmp3_);
#line 604 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_object_unref0 (iface);
#line 604 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return NULL;
#line 6213 "tracker-sparql-query.c"
		} else {
#line 604 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_free0 (_tmp3_);
#line 604 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_object_unref0 (iface);
#line 604 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 604 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_clear_error (&_inner_error_);
#line 604 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return NULL;
#line 6225 "tracker-sparql-query.c"
		}
	}
#line 604 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp14_ = _tmp5_;
#line 604 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp5_ = NULL;
#line 604 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	result = _tmp14_;
#line 604 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_object_unref0 (_tmp5_);
#line 604 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_free0 (_tmp3_);
#line 604 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_object_unref0 (iface);
#line 604 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return result;
#line 6242 "tracker-sparql-query.c"
}


static void tracker_sparql_query_parse_from_or_into_param (TrackerSparqlQuery* self, GError** error) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
#line 607 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_if_fail (self != NULL);
#line 608 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error_);
#line 608 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = _tmp1_;
#line 608 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 608 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 608 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_propagate_error (error, _inner_error_);
#line 608 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return;
#line 6264 "tracker-sparql-query.c"
		} else {
#line 608 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 608 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_clear_error (&_inner_error_);
#line 608 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return;
#line 6272 "tracker-sparql-query.c"
		}
	}
#line 608 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (_tmp0_) {
#line 6277 "tracker-sparql-query.c"
		gchar* _tmp2_;
#line 609 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp2_ = tracker_sparql_query_get_last_string (self, 1);
#line 609 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_free0 (self->priv->current_graph);
#line 609 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		self->priv->current_graph = _tmp2_;
#line 6285 "tracker-sparql-query.c"
	} else {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_;
#line 610 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp4_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error_);
#line 610 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp3_ = _tmp4_;
#line 610 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 610 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 610 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 610 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 6301 "tracker-sparql-query.c"
			} else {
#line 610 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 610 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_clear_error (&_inner_error_);
#line 610 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 6309 "tracker-sparql-query.c"
			}
		}
#line 610 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (_tmp3_) {
#line 6314 "tracker-sparql-query.c"
			gchar* ns = NULL;
			gchar* _tmp5_;
			gchar* _tmp6_ = NULL;
			const gchar* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
#line 611 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp5_ = tracker_sparql_query_get_last_string (self, 0);
#line 611 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			ns = _tmp5_;
#line 612 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
#line 612 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 612 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 612 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_propagate_error (error, _inner_error_);
#line 612 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (ns);
#line 612 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return;
#line 6342 "tracker-sparql-query.c"
				} else {
#line 612 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (ns);
#line 612 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 612 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_clear_error (&_inner_error_);
#line 612 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return;
#line 6352 "tracker-sparql-query.c"
				}
			}
#line 613 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp7_ = ns;
#line 613 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp8_ = tracker_sparql_query_get_last_string (self, 0);
#line 613 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp9_ = _tmp8_;
#line 613 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp10_ = string_substring (_tmp9_, (glong) 1, (glong) -1);
#line 613 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp11_ = _tmp10_;
#line 613 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp12_ = tracker_sparql_query_resolve_prefixed_name (self, _tmp7_, _tmp11_, &_inner_error_);
#line 613 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp13_ = _tmp12_;
#line 613 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_free0 (_tmp11_);
#line 613 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_free0 (_tmp9_);
#line 613 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp6_ = _tmp13_;
#line 613 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 613 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 613 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_propagate_error (error, _inner_error_);
#line 613 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (ns);
#line 613 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return;
#line 6385 "tracker-sparql-query.c"
				} else {
#line 613 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (ns);
#line 613 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 613 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_clear_error (&_inner_error_);
#line 613 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return;
#line 6395 "tracker-sparql-query.c"
				}
			}
#line 613 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp14_ = _tmp6_;
#line 613 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp6_ = NULL;
#line 613 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_free0 (self->priv->current_graph);
#line 613 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			self->priv->current_graph = _tmp14_;
#line 610 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_free0 (_tmp6_);
#line 610 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_free0 (ns);
#line 6410 "tracker-sparql-query.c"
		} else {
			gchar* _tmp15_ = NULL;
			gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
#line 615 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
#line 615 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 615 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 615 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_propagate_error (error, _inner_error_);
#line 615 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return;
#line 6430 "tracker-sparql-query.c"
				} else {
#line 615 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 615 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_clear_error (&_inner_error_);
#line 615 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return;
#line 6438 "tracker-sparql-query.c"
				}
			}
#line 616 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp16_ = tracker_sparql_query_get_last_string (self, 0);
#line 616 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp17_ = _tmp16_;
#line 616 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp18_ = string_substring (_tmp17_, (glong) 1, (glong) -1);
#line 616 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp19_ = _tmp18_;
#line 616 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp20_ = tracker_sparql_query_resolve_prefixed_name (self, "", _tmp19_, &_inner_error_);
#line 616 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp21_ = _tmp20_;
#line 616 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_free0 (_tmp19_);
#line 616 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_free0 (_tmp17_);
#line 616 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp15_ = _tmp21_;
#line 616 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 616 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 616 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_propagate_error (error, _inner_error_);
#line 616 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return;
#line 6467 "tracker-sparql-query.c"
				} else {
#line 616 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 616 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_clear_error (&_inner_error_);
#line 616 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return;
#line 6475 "tracker-sparql-query.c"
				}
			}
#line 616 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp22_ = _tmp15_;
#line 616 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp15_ = NULL;
#line 616 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_free0 (self->priv->current_graph);
#line 616 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			self->priv->current_graph = _tmp22_;
#line 610 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_free0 (_tmp15_);
#line 6488 "tracker-sparql-query.c"
		}
	}
}


static gpointer _tracker_source_location_dup0 (gpointer self) {
#line 663 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return self ? tracker_source_location_dup (self) : NULL;
#line 6497 "tracker-sparql-query.c"
}


static GVariant* _variant_new1 (GHashTable* value) {
	GVariantBuilder _tmp168_;
	GHashTableIter _tmp169_;
	gpointer _tmp170_;
	gpointer _tmp171_;
#line 802 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_hash_table_iter_init (&_tmp169_, value);
#line 802 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_variant_builder_init (&_tmp168_, G_VARIANT_TYPE ("a{ss}"));
#line 802 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	while (g_hash_table_iter_next (&_tmp169_, &_tmp170_, &_tmp171_)) {
#line 6512 "tracker-sparql-query.c"
		gchar* _key;
		gchar* _value;
#line 802 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_key = (gchar*) _tmp170_;
#line 802 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_value = (gchar*) _tmp171_;
#line 802 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		g_variant_builder_add (&_tmp168_, "{?*}", g_variant_new_string (_key), g_variant_new_string (_value));
#line 6521 "tracker-sparql-query.c"
	}
#line 802 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return g_variant_ref_sink (g_variant_builder_end (&_tmp168_));
#line 6525 "tracker-sparql-query.c"
}


static void tracker_sparql_query_execute_insert_delete (TrackerSparqlQuery* self, GVariantBuilder* update_blank_nodes, GError** error) {
	gboolean blank = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	TrackerSourceLocation* delete_location = NULL;
	TrackerSourceLocation* insert_location = NULL;
	gboolean insert_is_update = FALSE;
	gboolean delete_where = FALSE;
	gboolean data = FALSE;
	TrackerData* data_update = NULL;
	TrackerDataManager* _tmp2_;
	TrackerData* _tmp3_;
	TrackerData* _tmp4_;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_;
	gboolean _tmp24_ = FALSE;
	gboolean _tmp25_ = FALSE;
	gboolean _tmp26_;
	GString* pattern_sql = NULL;
	GString* _tmp48_;
	GString* sql = NULL;
	GString* _tmp49_;
	gboolean _tmp50_;
	TrackerSourceLocation after_where = {0};
	TrackerSourceLocation _tmp71_ = {0};
	TrackerSparqlSolution* solution = NULL;
	TrackerSparqlSolution* _tmp72_;
	GString* _tmp73_;
	gint var_idx = 0;
	TrackerSparqlContext* _tmp74_;
	GHashTable* _tmp75_;
	GList* _tmp76_;
	gint _tmp102_;
	GString* _tmp104_;
	GString* _tmp105_;
	GString* _tmp106_;
	const gchar* _tmp107_;
	GString* _tmp108_;
	TrackerDBInterface* iface = NULL;
	TrackerDataManager* _tmp109_;
	TrackerDBInterface* _tmp110_;
	TrackerDBInterface* _tmp111_;
	TrackerDBCursor* cursor = NULL;
	TrackerDBInterface* _tmp112_;
	GString* _tmp113_;
	const gchar* _tmp114_;
	TrackerDBCursor* _tmp115_;
	gint n_solutions = 0;
	TrackerSourceLocation* _tmp132_;
	TrackerSourceLocation* _tmp145_;
	gboolean _tmp174_;
	TrackerData* _tmp176_;
	TrackerSparqlContext* _tmp177_;
	TrackerSparqlContext* _tmp178_;
	TrackerSparqlContext* _tmp179_;
	GError * _inner_error_ = NULL;
#line 620 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_if_fail (self != NULL);
#line 621 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	blank = TRUE;
#line 625 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_WITH, &_inner_error_);
#line 625 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = _tmp1_;
#line 625 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 625 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		g_propagate_error (error, _inner_error_);
#line 625 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		return;
#line 6599 "tracker-sparql-query.c"
	}
#line 625 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (_tmp0_) {
#line 626 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		tracker_sparql_query_parse_from_or_into_param (self, &_inner_error_);
#line 626 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 626 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_propagate_error (error, _inner_error_);
#line 626 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return;
#line 6611 "tracker-sparql-query.c"
		}
	} else {
#line 628 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_free0 (self->priv->current_graph);
#line 628 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		self->priv->current_graph = NULL;
#line 6618 "tracker-sparql-query.c"
	}
#line 631 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	delete_location = NULL;
#line 632 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	insert_location = NULL;
#line 633 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	insert_is_update = FALSE;
#line 634 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	delete_where = FALSE;
#line 635 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	data = FALSE;
#line 637 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp2_ = self->manager;
#line 637 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp3_ = tracker_data_manager_get_data (_tmp2_);
#line 637 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 637 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	data_update = _tmp4_;
#line 643 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp6_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DELETE, &_inner_error_);
#line 643 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp5_ = _tmp6_;
#line 643 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 643 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		g_propagate_error (error, _inner_error_);
#line 643 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_object_unref0 (data_update);
#line 643 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tracker_source_location_free0 (insert_location);
#line 643 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tracker_source_location_free0 (delete_location);
#line 643 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		return;
#line 6654 "tracker-sparql-query.c"
	}
#line 643 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (_tmp5_) {
#line 6658 "tracker-sparql-query.c"
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_;
		gboolean _tmp9_ = FALSE;
		const gchar* _tmp10_;
		gboolean _tmp13_ = FALSE;
		const gchar* _tmp14_;
		TrackerSourceLocation _tmp19_ = {0};
		TrackerSourceLocation* _tmp20_;
		gboolean _tmp21_ = FALSE;
		gboolean _tmp22_;
#line 644 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		blank = FALSE;
#line 647 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp8_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_SILENT, &_inner_error_);
#line 647 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp7_ = _tmp8_;
#line 647 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 647 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_propagate_error (error, _inner_error_);
#line 647 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_object_unref0 (data_update);
#line 647 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tracker_source_location_free0 (insert_location);
#line 647 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tracker_source_location_free0 (delete_location);
#line 647 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return;
#line 6687 "tracker-sparql-query.c"
		}
#line 647 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		self->priv->silent = _tmp7_;
#line 649 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp10_ = self->priv->current_graph;
#line 649 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (_tmp10_ == NULL) {
#line 6695 "tracker-sparql-query.c"
			gboolean _tmp11_ = FALSE;
			gboolean _tmp12_;
#line 649 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp12_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_FROM, &_inner_error_);
#line 649 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp11_ = _tmp12_;
#line 649 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 649 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 649 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_object_unref0 (data_update);
#line 649 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tracker_source_location_free0 (insert_location);
#line 649 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tracker_source_location_free0 (delete_location);
#line 649 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 6714 "tracker-sparql-query.c"
			}
#line 649 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp9_ = _tmp11_;
#line 6718 "tracker-sparql-query.c"
		} else {
#line 649 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp9_ = FALSE;
#line 6722 "tracker-sparql-query.c"
		}
#line 649 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (_tmp9_) {
#line 650 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			tracker_sparql_query_parse_from_or_into_param (self, &_inner_error_);
#line 650 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 650 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 650 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_object_unref0 (data_update);
#line 650 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tracker_source_location_free0 (insert_location);
#line 650 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tracker_source_location_free0 (delete_location);
#line 650 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 6740 "tracker-sparql-query.c"
			}
		}
#line 653 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp14_ = self->priv->current_graph;
#line 653 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (_tmp14_ == NULL) {
#line 6747 "tracker-sparql-query.c"
			gboolean _tmp15_ = FALSE;
			gboolean _tmp16_;
#line 653 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp16_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DATA, &_inner_error_);
#line 653 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp15_ = _tmp16_;
#line 653 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 653 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 653 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_object_unref0 (data_update);
#line 653 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tracker_source_location_free0 (insert_location);
#line 653 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tracker_source_location_free0 (delete_location);
#line 653 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 6766 "tracker-sparql-query.c"
			}
#line 653 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp13_ = _tmp15_;
#line 6770 "tracker-sparql-query.c"
		} else {
#line 653 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp13_ = FALSE;
#line 6774 "tracker-sparql-query.c"
		}
#line 653 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (_tmp13_) {
#line 656 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			data = TRUE;
#line 6780 "tracker-sparql-query.c"
		} else {
			gboolean _tmp17_ = FALSE;
			gboolean _tmp18_;
#line 657 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp18_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_WHERE, &_inner_error_);
#line 657 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp17_ = _tmp18_;
#line 657 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 657 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 657 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_object_unref0 (data_update);
#line 657 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tracker_source_location_free0 (insert_location);
#line 657 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tracker_source_location_free0 (delete_location);
#line 657 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 6800 "tracker-sparql-query.c"
			}
#line 657 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (_tmp17_) {
#line 660 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				delete_where = TRUE;
#line 6806 "tracker-sparql-query.c"
			}
		}
#line 663 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		tracker_sparql_query_get_location (self, &_tmp19_);
#line 663 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp20_ = _tracker_source_location_dup0 (&_tmp19_);
#line 663 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tracker_source_location_free0 (delete_location);
#line 663 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		delete_location = _tmp20_;
#line 665 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp22_ = data;
#line 665 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (!_tmp22_) {
#line 6821 "tracker-sparql-query.c"
			gboolean _tmp23_;
#line 665 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp23_ = delete_where;
#line 665 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp21_ = !_tmp23_;
#line 6827 "tracker-sparql-query.c"
		} else {
#line 665 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp21_ = FALSE;
#line 6831 "tracker-sparql-query.c"
		}
#line 665 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (_tmp21_) {
#line 666 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			tracker_sparql_query_skip_braces (self, &_inner_error_);
#line 666 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 666 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 666 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_object_unref0 (data_update);
#line 666 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tracker_source_location_free0 (insert_location);
#line 666 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tracker_source_location_free0 (delete_location);
#line 666 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 6849 "tracker-sparql-query.c"
			}
		}
	}
#line 670 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp26_ = data;
#line 670 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (!_tmp26_) {
#line 6857 "tracker-sparql-query.c"
		gboolean _tmp27_;
#line 670 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp27_ = delete_where;
#line 670 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp25_ = !_tmp27_;
#line 6863 "tracker-sparql-query.c"
	} else {
#line 670 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp25_ = FALSE;
#line 6867 "tracker-sparql-query.c"
	}
#line 670 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (_tmp25_) {
#line 6871 "tracker-sparql-query.c"
		gboolean _tmp28_ = FALSE;
		gboolean _tmp29_;
#line 670 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp29_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_INSERT, &_inner_error_);
#line 670 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp28_ = _tmp29_;
#line 670 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 670 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_propagate_error (error, _inner_error_);
#line 670 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_object_unref0 (data_update);
#line 670 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tracker_source_location_free0 (insert_location);
#line 670 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tracker_source_location_free0 (delete_location);
#line 670 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return;
#line 6890 "tracker-sparql-query.c"
		}
#line 670 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp24_ = _tmp28_;
#line 6894 "tracker-sparql-query.c"
	} else {
#line 670 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp24_ = FALSE;
#line 6898 "tracker-sparql-query.c"
	}
#line 670 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (_tmp24_) {
#line 6902 "tracker-sparql-query.c"
		gboolean _tmp30_ = FALSE;
		gboolean _tmp31_;
		gboolean _tmp32_;
		gboolean _tmp35_ = FALSE;
		const gchar* _tmp36_;
		gboolean _tmp39_ = FALSE;
		const gchar* _tmp40_;
		TrackerSparqlTokenType _tmp43_;
		TrackerSourceLocation _tmp45_ = {0};
		TrackerSourceLocation* _tmp46_;
		gboolean _tmp47_;
#line 671 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp31_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OR, &_inner_error_);
#line 671 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp30_ = _tmp31_;
#line 671 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 671 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_propagate_error (error, _inner_error_);
#line 671 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_object_unref0 (data_update);
#line 671 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tracker_source_location_free0 (insert_location);
#line 671 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tracker_source_location_free0 (delete_location);
#line 671 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return;
#line 6930 "tracker-sparql-query.c"
		}
#line 671 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (_tmp30_) {
#line 672 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_REPLACE, &_inner_error_);
#line 672 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 672 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 672 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_object_unref0 (data_update);
#line 672 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tracker_source_location_free0 (insert_location);
#line 672 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tracker_source_location_free0 (delete_location);
#line 672 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 6948 "tracker-sparql-query.c"
			}
#line 673 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			insert_is_update = TRUE;
#line 6952 "tracker-sparql-query.c"
		}
#line 676 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp32_ = insert_is_update;
#line 676 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (!_tmp32_) {
#line 6958 "tracker-sparql-query.c"
			gboolean _tmp33_ = FALSE;
			gboolean _tmp34_;
#line 678 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp34_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_SILENT, &_inner_error_);
#line 678 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp33_ = _tmp34_;
#line 678 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 678 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 678 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_object_unref0 (data_update);
#line 678 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tracker_source_location_free0 (insert_location);
#line 678 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tracker_source_location_free0 (delete_location);
#line 678 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 6977 "tracker-sparql-query.c"
			}
#line 678 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			self->priv->silent = _tmp33_;
#line 6981 "tracker-sparql-query.c"
		}
#line 681 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp36_ = self->priv->current_graph;
#line 681 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (_tmp36_ == NULL) {
#line 6987 "tracker-sparql-query.c"
			gboolean _tmp37_ = FALSE;
			gboolean _tmp38_;
#line 681 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp38_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_INTO, &_inner_error_);
#line 681 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp37_ = _tmp38_;
#line 681 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 681 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 681 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_object_unref0 (data_update);
#line 681 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tracker_source_location_free0 (insert_location);
#line 681 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tracker_source_location_free0 (delete_location);
#line 681 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 7006 "tracker-sparql-query.c"
			}
#line 681 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp35_ = _tmp37_;
#line 7010 "tracker-sparql-query.c"
		} else {
#line 681 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp35_ = FALSE;
#line 7014 "tracker-sparql-query.c"
		}
#line 681 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (_tmp35_) {
#line 682 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			tracker_sparql_query_parse_from_or_into_param (self, &_inner_error_);
#line 682 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 682 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 682 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_object_unref0 (data_update);
#line 682 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tracker_source_location_free0 (insert_location);
#line 682 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tracker_source_location_free0 (delete_location);
#line 682 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 7032 "tracker-sparql-query.c"
			}
		}
#line 685 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp40_ = self->priv->current_graph;
#line 685 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (_tmp40_ == NULL) {
#line 7039 "tracker-sparql-query.c"
			gboolean _tmp41_ = FALSE;
			gboolean _tmp42_;
#line 685 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp42_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DATA, &_inner_error_);
#line 685 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp41_ = _tmp42_;
#line 685 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 685 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 685 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_object_unref0 (data_update);
#line 685 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tracker_source_location_free0 (insert_location);
#line 685 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tracker_source_location_free0 (delete_location);
#line 685 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 7058 "tracker-sparql-query.c"
			}
#line 685 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp39_ = _tmp41_;
#line 7062 "tracker-sparql-query.c"
		} else {
#line 685 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp39_ = FALSE;
#line 7066 "tracker-sparql-query.c"
		}
#line 685 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (_tmp39_) {
#line 688 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			data = TRUE;
#line 7072 "tracker-sparql-query.c"
		}
#line 691 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp43_ = tracker_sparql_query_current (self);
#line 691 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (_tmp43_ != TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE) {
#line 7078 "tracker-sparql-query.c"
			GError* _tmp44_;
#line 692 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp44_ = tracker_sparql_query_get_error (self, "Expected '{' beginning a quad data/pattern block");
#line 692 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_inner_error_ = _tmp44_;
#line 692 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_propagate_error (error, _inner_error_);
#line 692 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_object_unref0 (data_update);
#line 692 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tracker_source_location_free0 (insert_location);
#line 692 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tracker_source_location_free0 (delete_location);
#line 692 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return;
#line 7094 "tracker-sparql-query.c"
		}
#line 695 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		tracker_sparql_query_get_location (self, &_tmp45_);
#line 695 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp46_ = _tracker_source_location_dup0 (&_tmp45_);
#line 695 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tracker_source_location_free0 (insert_location);
#line 695 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		insert_location = _tmp46_;
#line 697 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp47_ = data;
#line 697 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (!_tmp47_) {
#line 698 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			tracker_sparql_query_skip_braces (self, &_inner_error_);
#line 698 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 698 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 698 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_object_unref0 (data_update);
#line 698 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tracker_source_location_free0 (insert_location);
#line 698 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tracker_source_location_free0 (delete_location);
#line 698 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 7122 "tracker-sparql-query.c"
			}
		}
	}
#line 702 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp48_ = g_string_new ("");
#line 702 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	pattern_sql = _tmp48_;
#line 704 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp49_ = g_string_new ("");
#line 704 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	sql = _tmp49_;
#line 706 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp50_ = data;
#line 706 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (!_tmp50_) {
#line 7138 "tracker-sparql-query.c"
		gboolean _tmp51_ = FALSE;
		gboolean _tmp52_;
#line 707 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp52_ = delete_where;
#line 707 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (_tmp52_) {
#line 707 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp51_ = TRUE;
#line 7147 "tracker-sparql-query.c"
		} else {
			gboolean _tmp53_ = FALSE;
			gboolean _tmp54_;
#line 707 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp54_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_WHERE, &_inner_error_);
#line 707 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp53_ = _tmp54_;
#line 707 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 707 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 707 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_string_free0 (sql);
#line 707 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_string_free0 (pattern_sql);
#line 707 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_object_unref0 (data_update);
#line 707 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tracker_source_location_free0 (insert_location);
#line 707 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tracker_source_location_free0 (delete_location);
#line 707 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 7171 "tracker-sparql-query.c"
			}
#line 707 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp51_ = _tmp53_;
#line 7175 "tracker-sparql-query.c"
		}
#line 707 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (_tmp51_) {
#line 7179 "tracker-sparql-query.c"
			TrackerSparqlPattern* _tmp55_;
			const gchar* _tmp56_;
			gchar* _tmp57_;
			TrackerSparqlContext* _tmp58_ = NULL;
			TrackerSparqlPattern* _tmp59_;
			GString* _tmp60_;
			TrackerSparqlContext* _tmp61_;
			TrackerSparqlContext* _tmp62_;
			TrackerSparqlPattern* _tmp63_;
#line 708 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp55_ = self->pattern;
#line 708 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp56_ = self->priv->current_graph;
#line 708 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp57_ = g_strdup (_tmp56_);
#line 708 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_free0 (_tmp55_->current_graph);
#line 708 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp55_->current_graph = _tmp57_;
#line 709 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp59_ = self->pattern;
#line 709 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp60_ = pattern_sql;
#line 709 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp61_ = tracker_sparql_pattern_translate_group_graph_pattern (_tmp59_, _tmp60_, &_inner_error_);
#line 709 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp58_ = _tmp61_;
#line 709 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 709 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 709 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_string_free0 (sql);
#line 709 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_string_free0 (pattern_sql);
#line 709 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_object_unref0 (data_update);
#line 709 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tracker_source_location_free0 (insert_location);
#line 709 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tracker_source_location_free0 (delete_location);
#line 709 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 7223 "tracker-sparql-query.c"
			}
#line 709 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp62_ = _tmp58_;
#line 709 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp58_ = NULL;
#line 709 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tracker_sparql_context_unref0 (self->context);
#line 709 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			self->context = _tmp62_;
#line 710 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp63_ = self->pattern;
#line 710 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_free0 (_tmp63_->current_graph);
#line 710 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp63_->current_graph = NULL;
#line 707 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tracker_sparql_context_unref0 (_tmp58_);
#line 7241 "tracker-sparql-query.c"
		} else {
			TrackerSparqlContext* _tmp64_;
			GString* _tmp65_;
#line 712 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp64_ = tracker_sparql_context_new (self, NULL);
#line 712 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tracker_sparql_context_unref0 (self->context);
#line 712 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			self->context = _tmp64_;
#line 714 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp65_ = pattern_sql;
#line 714 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_string_append (_tmp65_, "SELECT 1");
#line 7255 "tracker-sparql-query.c"
		}
	} else {
		gint _tmp66_ = 0;
		gint _tmp67_;
		TrackerSparqlContext* _tmp69_;
		GString* _tmp70_;
#line 719 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp67_ = tracker_sparql_query_quad_data_unbound_var_count (self, &_inner_error_);
#line 719 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp66_ = _tmp67_;
#line 719 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 719 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_propagate_error (error, _inner_error_);
#line 719 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_string_free0 (sql);
#line 719 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_string_free0 (pattern_sql);
#line 719 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_object_unref0 (data_update);
#line 719 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tracker_source_location_free0 (insert_location);
#line 719 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tracker_source_location_free0 (delete_location);
#line 719 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return;
#line 7282 "tracker-sparql-query.c"
		}
#line 719 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (_tmp66_ > 0) {
#line 7286 "tracker-sparql-query.c"
			GError* _tmp68_;
#line 720 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp68_ = tracker_sparql_query_get_error (self, "INSERT/DELETE DATA do not allow unbound values");
#line 720 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_inner_error_ = _tmp68_;
#line 720 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_propagate_error (error, _inner_error_);
#line 720 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_string_free0 (sql);
#line 720 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_string_free0 (pattern_sql);
#line 720 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_object_unref0 (data_update);
#line 720 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tracker_source_location_free0 (insert_location);
#line 720 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tracker_source_location_free0 (delete_location);
#line 720 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return;
#line 7306 "tracker-sparql-query.c"
		}
#line 723 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp69_ = tracker_sparql_context_new (self, NULL);
#line 723 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tracker_sparql_context_unref0 (self->context);
#line 723 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		self->context = _tmp69_;
#line 725 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp70_ = pattern_sql;
#line 725 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		g_string_append (_tmp70_, "SELECT 1");
#line 7318 "tracker-sparql-query.c"
	}
#line 728 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	tracker_sparql_query_get_location (self, &_tmp71_);
#line 728 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	after_where = _tmp71_;
#line 730 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp72_ = tracker_sparql_solution_new ();
#line 730 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	solution = _tmp72_;
#line 733 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp73_ = sql;
#line 733 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_string_append (_tmp73_, "SELECT ");
#line 734 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	var_idx = 0;
#line 735 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp74_ = self->context;
#line 735 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp75_ = _tmp74_->var_set;
#line 735 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp76_ = g_hash_table_get_keys (_tmp75_);
#line 7340 "tracker-sparql-query.c"
	{
		GList* variable_collection = NULL;
		GList* variable_it = NULL;
#line 735 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		variable_collection = _tmp76_;
#line 735 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		for (variable_it = variable_collection; variable_it != NULL; variable_it = variable_it->next) {
#line 7348 "tracker-sparql-query.c"
			TrackerSparqlVariable* variable = NULL;
#line 735 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			variable = (TrackerSparqlVariable*) variable_it->data;
#line 7352 "tracker-sparql-query.c"
			{
				gint _tmp77_;
				TrackerSparqlVariable* _tmp79_;
				TrackerSparqlVariableBinding* _tmp80_;
				GString* _tmp88_;
				TrackerSparqlVariable* _tmp89_;
				const gchar* _tmp90_;
				const gchar* _tmp91_;
				TrackerSparqlVariable* _tmp92_;
				TrackerSparqlVariableBinding* _tmp93_;
				TrackerPropertyType _tmp94_;
				TrackerSparqlSolution* _tmp95_;
				GHashTable* _tmp96_;
				TrackerSparqlVariable* _tmp97_;
				const gchar* _tmp98_;
				const gchar* _tmp99_;
				gchar* _tmp100_;
				gint _tmp101_;
#line 736 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp77_ = var_idx;
#line 736 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if (_tmp77_ > 0) {
#line 7375 "tracker-sparql-query.c"
					GString* _tmp78_;
#line 737 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp78_ = sql;
#line 737 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_string_append (_tmp78_, ", ");
#line 7381 "tracker-sparql-query.c"
				}
#line 740 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp79_ = variable;
#line 740 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp80_ = _tmp79_->binding;
#line 740 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if (_tmp80_ == NULL) {
#line 7389 "tracker-sparql-query.c"
					TrackerSparqlVariable* _tmp81_;
					const gchar* _tmp82_;
					const gchar* _tmp83_;
					gchar* _tmp84_;
					gchar* _tmp85_;
					GError* _tmp86_;
					GError* _tmp87_;
#line 741 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp81_ = variable;
#line 741 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp82_ = tracker_sparql_variable_get_name (_tmp81_);
#line 741 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp83_ = _tmp82_;
#line 741 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp84_ = g_strdup_printf ("use of undefined variable `%s'", _tmp83_);
#line 741 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp85_ = _tmp84_;
#line 741 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp86_ = tracker_sparql_query_get_error (self, _tmp85_);
#line 741 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp87_ = _tmp86_;
#line 741 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (_tmp85_);
#line 741 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_inner_error_ = _tmp87_;
#line 741 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_propagate_error (error, _inner_error_);
#line 741 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_list_free0 (variable_collection);
#line 741 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tracker_sparql_solution_unref0 (solution);
#line 741 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_string_free0 (sql);
#line 741 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_string_free0 (pattern_sql);
#line 741 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_object_unref0 (data_update);
#line 741 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tracker_source_location_free0 (insert_location);
#line 741 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tracker_source_location_free0 (delete_location);
#line 741 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return;
#line 7433 "tracker-sparql-query.c"
				}
#line 743 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp88_ = sql;
#line 743 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp89_ = variable;
#line 743 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp90_ = tracker_sparql_variable_get_sql_expression (_tmp89_);
#line 743 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp91_ = _tmp90_;
#line 743 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp92_ = variable;
#line 743 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp93_ = _tmp92_->binding;
#line 743 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp94_ = ((TrackerSparqlDataBinding*) _tmp93_)->data_type;
#line 743 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				tracker_sparql_expression_append_expression_as_string (_tmp88_, _tmp91_, _tmp94_);
#line 745 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp95_ = solution;
#line 745 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp96_ = _tmp95_->hash;
#line 745 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp97_ = variable;
#line 745 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp98_ = tracker_sparql_variable_get_name (_tmp97_);
#line 745 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp99_ = _tmp98_;
#line 745 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp100_ = g_strdup (_tmp99_);
#line 745 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp101_ = var_idx;
#line 745 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				var_idx = _tmp101_ + 1;
#line 745 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_hash_table_insert (_tmp96_, _tmp100_, (gpointer) ((gintptr) _tmp101_));
#line 7469 "tracker-sparql-query.c"
			}
		}
#line 735 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_list_free0 (variable_collection);
#line 7474 "tracker-sparql-query.c"
	}
#line 748 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp102_ = var_idx;
#line 748 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (_tmp102_ == 0) {
#line 7480 "tracker-sparql-query.c"
		GString* _tmp103_;
#line 749 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp103_ = sql;
#line 749 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		g_string_append (_tmp103_, "1");
#line 7486 "tracker-sparql-query.c"
	}
#line 753 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp104_ = sql;
#line 753 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_string_append (_tmp104_, " FROM (");
#line 754 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp105_ = sql;
#line 754 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp106_ = pattern_sql;
#line 754 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp107_ = _tmp106_->str;
#line 754 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_string_append (_tmp105_, _tmp107_);
#line 755 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp108_ = sql;
#line 755 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_string_append (_tmp108_, ")");
#line 757 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp109_ = self->manager;
#line 757 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp110_ = tracker_data_manager_get_writable_db_interface (_tmp109_);
#line 757 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp111_ = _g_object_ref0 (_tmp110_);
#line 757 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	iface = _tmp111_;
#line 758 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp112_ = iface;
#line 758 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp113_ = sql;
#line 758 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp114_ = _tmp113_->str;
#line 758 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp115_ = tracker_sparql_query_exec_sql_cursor (self, _tmp112_, _tmp114_, NULL, 0, NULL, 0, &_inner_error_);
#line 758 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	cursor = _tmp115_;
#line 758 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 758 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		g_propagate_error (error, _inner_error_);
#line 758 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_object_unref0 (iface);
#line 758 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tracker_sparql_solution_unref0 (solution);
#line 758 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_string_free0 (sql);
#line 758 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_string_free0 (pattern_sql);
#line 758 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_object_unref0 (data_update);
#line 758 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tracker_source_location_free0 (insert_location);
#line 758 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tracker_source_location_free0 (delete_location);
#line 758 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		return;
#line 7542 "tracker-sparql-query.c"
	}
#line 760 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	n_solutions = 0;
#line 761 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	while (TRUE) {
#line 7548 "tracker-sparql-query.c"
		gboolean _tmp116_ = FALSE;
		TrackerDBCursor* _tmp117_;
		gboolean _tmp118_;
		gint _tmp131_;
#line 761 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp117_ = cursor;
#line 761 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp118_ = tracker_sparql_cursor_next ((TrackerSparqlCursor*) _tmp117_, NULL, &_inner_error_);
#line 761 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp116_ = _tmp118_;
#line 761 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 761 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_propagate_error (error, _inner_error_);
#line 761 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_object_unref0 (cursor);
#line 761 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_object_unref0 (iface);
#line 761 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tracker_sparql_solution_unref0 (solution);
#line 761 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_string_free0 (sql);
#line 761 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_string_free0 (pattern_sql);
#line 761 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_object_unref0 (data_update);
#line 761 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tracker_source_location_free0 (insert_location);
#line 761 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tracker_source_location_free0 (delete_location);
#line 761 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return;
#line 7581 "tracker-sparql-query.c"
		}
#line 761 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (!_tmp116_) {
#line 761 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			break;
#line 7587 "tracker-sparql-query.c"
		}
		{
			gboolean _tmp119_ = FALSE;
#line 763 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			var_idx = 0;
#line 763 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp119_ = TRUE;
#line 763 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			while (TRUE) {
#line 7597 "tracker-sparql-query.c"
				gint _tmp121_;
				TrackerSparqlSolution* _tmp122_;
				GHashTable* _tmp123_;
				guint _tmp124_;
				TrackerSparqlSolution* _tmp125_;
				GPtrArray* _tmp126_;
				TrackerDBCursor* _tmp127_;
				gint _tmp128_;
				const gchar* _tmp129_;
				gchar* _tmp130_;
#line 763 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if (!_tmp119_) {
#line 7610 "tracker-sparql-query.c"
					gint _tmp120_;
#line 763 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp120_ = var_idx;
#line 763 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					var_idx = _tmp120_ + 1;
#line 7616 "tracker-sparql-query.c"
				}
#line 763 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp119_ = FALSE;
#line 763 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp121_ = var_idx;
#line 763 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp122_ = solution;
#line 763 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp123_ = _tmp122_->hash;
#line 763 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp124_ = g_hash_table_size (_tmp123_);
#line 763 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if (!(((guint) _tmp121_) < _tmp124_)) {
#line 763 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					break;
#line 7632 "tracker-sparql-query.c"
				}
#line 764 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp125_ = solution;
#line 764 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp126_ = _tmp125_->values;
#line 764 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp127_ = cursor;
#line 764 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp128_ = var_idx;
#line 764 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp129_ = tracker_sparql_cursor_get_string ((TrackerSparqlCursor*) _tmp127_, _tmp128_, NULL);
#line 764 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp130_ = g_strdup (_tmp129_);
#line 764 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_ptr_array_add (_tmp126_, _tmp130_);
#line 7648 "tracker-sparql-query.c"
			}
		}
#line 766 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp131_ = n_solutions;
#line 766 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		n_solutions = _tmp131_ + 1;
#line 7655 "tracker-sparql-query.c"
	}
#line 769 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_object_unref0 (cursor);
#line 769 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	cursor = NULL;
#line 773 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp132_ = delete_location;
#line 773 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (_tmp132_ != NULL) {
#line 7665 "tracker-sparql-query.c"
		TrackerSourceLocation* _tmp143_;
		{
			gint i = 0;
#line 774 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			i = 0;
#line 7671 "tracker-sparql-query.c"
			{
				gboolean _tmp133_ = FALSE;
#line 774 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp133_ = TRUE;
#line 774 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				while (TRUE) {
#line 7678 "tracker-sparql-query.c"
					gint _tmp135_;
					gint _tmp136_;
					TrackerSparqlSolution* _tmp137_;
					gint _tmp138_;
					TrackerSourceLocation* _tmp139_;
					TrackerSourceLocation _tmp140_;
					TrackerSparqlSolution* _tmp141_;
					TrackerData* _tmp142_;
#line 774 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if (!_tmp133_) {
#line 7689 "tracker-sparql-query.c"
						gint _tmp134_;
#line 774 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp134_ = i;
#line 774 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						i = _tmp134_ + 1;
#line 7695 "tracker-sparql-query.c"
					}
#line 774 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp133_ = FALSE;
#line 774 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp135_ = i;
#line 774 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp136_ = n_solutions;
#line 774 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if (!(_tmp135_ < _tmp136_)) {
#line 774 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						break;
#line 7707 "tracker-sparql-query.c"
					}
#line 775 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp137_ = solution;
#line 775 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp138_ = i;
#line 775 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp137_->solution_index = _tmp138_;
#line 776 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp139_ = delete_location;
#line 776 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp140_ = *_tmp139_;
#line 776 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					tracker_sparql_query_set_location (self, &_tmp140_);
#line 777 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp141_ = solution;
#line 777 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					tracker_sparql_query_parse_construct_triples_block (self, _tmp141_, TRACKER_SPARQL_UPDATE_TYPE_DELETE, &_inner_error_);
#line 777 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 777 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_propagate_error (error, _inner_error_);
#line 777 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_object_unref0 (cursor);
#line 777 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_object_unref0 (iface);
#line 777 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tracker_sparql_solution_unref0 (solution);
#line 777 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_string_free0 (sql);
#line 777 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_string_free0 (pattern_sql);
#line 777 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_object_unref0 (data_update);
#line 777 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tracker_source_location_free0 (insert_location);
#line 777 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tracker_source_location_free0 (delete_location);
#line 777 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						return;
#line 7747 "tracker-sparql-query.c"
					}
#line 778 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp142_ = data_update;
#line 778 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					tracker_data_update_buffer_might_flush (_tmp142_, &_inner_error_);
#line 778 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 778 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_propagate_error (error, _inner_error_);
#line 778 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_object_unref0 (cursor);
#line 778 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_object_unref0 (iface);
#line 778 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tracker_sparql_solution_unref0 (solution);
#line 778 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_string_free0 (sql);
#line 778 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_string_free0 (pattern_sql);
#line 778 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_object_unref0 (data_update);
#line 778 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tracker_source_location_free0 (insert_location);
#line 778 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tracker_source_location_free0 (delete_location);
#line 778 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						return;
#line 7775 "tracker-sparql-query.c"
					}
				}
			}
		}
#line 784 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp143_ = insert_location;
#line 784 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (_tmp143_ != NULL) {
#line 7784 "tracker-sparql-query.c"
			TrackerData* _tmp144_;
#line 785 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp144_ = data_update;
#line 785 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			tracker_data_update_buffer_flush (_tmp144_, &_inner_error_);
#line 785 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 785 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 785 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_object_unref0 (cursor);
#line 785 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_object_unref0 (iface);
#line 785 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tracker_sparql_solution_unref0 (solution);
#line 785 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_string_free0 (sql);
#line 785 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_string_free0 (pattern_sql);
#line 785 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_object_unref0 (data_update);
#line 785 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tracker_source_location_free0 (insert_location);
#line 785 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tracker_source_location_free0 (delete_location);
#line 785 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 7812 "tracker-sparql-query.c"
			}
		}
	}
#line 789 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp145_ = insert_location;
#line 789 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (_tmp145_ != NULL) {
#line 7820 "tracker-sparql-query.c"
		{
			gint i = 0;
#line 790 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			i = 0;
#line 7825 "tracker-sparql-query.c"
			{
				gboolean _tmp146_ = FALSE;
#line 790 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp146_ = TRUE;
#line 790 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				while (TRUE) {
#line 7832 "tracker-sparql-query.c"
					gint _tmp148_;
					gint _tmp149_;
					guchar* _tmp150_;
					gint _tmp150__length1;
					GHashFunc _tmp151_;
					GEqualFunc _tmp152_;
					GDestroyNotify _tmp153_;
					GDestroyNotify _tmp154_;
					GHashTable* _tmp155_;
					TrackerSparqlSolution* _tmp156_;
					gint _tmp157_;
					TrackerSourceLocation* _tmp158_;
					TrackerSourceLocation _tmp159_;
					TrackerSparqlUpdateType _tmp160_ = 0;
					gboolean _tmp161_;
					TrackerSparqlSolution* _tmp162_;
					gboolean _tmp163_ = FALSE;
					gboolean _tmp164_;
					TrackerData* _tmp173_;
#line 790 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if (!_tmp146_) {
#line 7854 "tracker-sparql-query.c"
						gint _tmp147_;
#line 790 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp147_ = i;
#line 790 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						i = _tmp147_ + 1;
#line 7860 "tracker-sparql-query.c"
					}
#line 790 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp146_ = FALSE;
#line 790 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp148_ = i;
#line 790 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp149_ = n_solutions;
#line 790 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if (!(_tmp148_ < _tmp149_)) {
#line 790 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						break;
#line 7872 "tracker-sparql-query.c"
					}
#line 791 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp150_ = self->priv->base_uuid;
#line 791 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp150__length1 = self->priv->base_uuid_length1;
#line 791 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					uuid_generate (_tmp150_);
#line 792 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp151_ = g_str_hash;
#line 792 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp152_ = g_str_equal;
#line 792 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp153_ = g_free;
#line 792 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp154_ = g_free;
#line 792 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp155_ = g_hash_table_new_full (_tmp151_, _tmp152_, _tmp153_, _tmp154_);
#line 792 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_hash_table_unref0 (self->priv->blank_nodes);
#line 792 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					self->priv->blank_nodes = _tmp155_;
#line 793 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp156_ = solution;
#line 793 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp157_ = i;
#line 793 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp156_->solution_index = _tmp157_;
#line 795 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp158_ = insert_location;
#line 795 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp159_ = *_tmp158_;
#line 795 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					tracker_sparql_query_set_location (self, &_tmp159_);
#line 797 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp161_ = insert_is_update;
#line 797 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if (_tmp161_) {
#line 798 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp160_ = TRACKER_SPARQL_UPDATE_TYPE_UPDATE;
#line 7912 "tracker-sparql-query.c"
					} else {
#line 799 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp160_ = TRACKER_SPARQL_UPDATE_TYPE_INSERT;
#line 7916 "tracker-sparql-query.c"
					}
#line 796 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp162_ = solution;
#line 796 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					tracker_sparql_query_parse_construct_triples_block (self, _tmp162_, _tmp160_, &_inner_error_);
#line 796 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 796 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_propagate_error (error, _inner_error_);
#line 796 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_object_unref0 (cursor);
#line 796 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_object_unref0 (iface);
#line 796 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tracker_sparql_solution_unref0 (solution);
#line 796 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_string_free0 (sql);
#line 796 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_string_free0 (pattern_sql);
#line 796 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_object_unref0 (data_update);
#line 796 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tracker_source_location_free0 (insert_location);
#line 796 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tracker_source_location_free0 (delete_location);
#line 796 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						return;
#line 7944 "tracker-sparql-query.c"
					}
#line 801 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp164_ = blank;
#line 801 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if (_tmp164_) {
#line 7950 "tracker-sparql-query.c"
						GVariantBuilder* _tmp165_;
#line 801 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp165_ = update_blank_nodes;
#line 801 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp163_ = _tmp165_ != NULL;
#line 7956 "tracker-sparql-query.c"
					} else {
#line 801 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp163_ = FALSE;
#line 7960 "tracker-sparql-query.c"
					}
#line 801 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if (_tmp163_) {
#line 7964 "tracker-sparql-query.c"
						GVariantBuilder* _tmp166_;
						GHashTable* _tmp167_;
						GVariant* _tmp172_;
#line 802 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp166_ = update_blank_nodes;
#line 802 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp167_ = self->priv->blank_nodes;
#line 802 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp172_ = _variant_new1 (_tmp167_);
#line 802 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_variant_builder_add_value (_tmp166_, _tmp172_);
#line 802 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_variant_unref0 (_tmp172_);
#line 7978 "tracker-sparql-query.c"
					}
#line 805 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp173_ = data_update;
#line 805 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					tracker_data_update_buffer_might_flush (_tmp173_, &_inner_error_);
#line 805 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 805 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_propagate_error (error, _inner_error_);
#line 805 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_object_unref0 (cursor);
#line 805 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_object_unref0 (iface);
#line 805 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tracker_sparql_solution_unref0 (solution);
#line 805 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_string_free0 (sql);
#line 805 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_string_free0 (pattern_sql);
#line 805 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_object_unref0 (data_update);
#line 805 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tracker_source_location_free0 (insert_location);
#line 805 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tracker_source_location_free0 (delete_location);
#line 805 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						return;
#line 8006 "tracker-sparql-query.c"
					}
				}
			}
		}
	}
#line 809 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tracker_sparql_solution_unref0 (solution);
#line 809 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	solution = NULL;
#line 811 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp174_ = data;
#line 811 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (!_tmp174_) {
#line 8020 "tracker-sparql-query.c"
		TrackerSourceLocation _tmp175_;
#line 813 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp175_ = after_where;
#line 813 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		tracker_sparql_query_set_location (self, &_tmp175_);
#line 8026 "tracker-sparql-query.c"
	}
#line 817 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp176_ = data_update;
#line 817 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	tracker_data_update_buffer_flush (_tmp176_, &_inner_error_);
#line 817 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 817 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		g_propagate_error (error, _inner_error_);
#line 817 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_object_unref0 (cursor);
#line 817 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_object_unref0 (iface);
#line 817 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tracker_sparql_solution_unref0 (solution);
#line 817 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_string_free0 (sql);
#line 817 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_string_free0 (pattern_sql);
#line 817 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_object_unref0 (data_update);
#line 817 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tracker_source_location_free0 (insert_location);
#line 817 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tracker_source_location_free0 (delete_location);
#line 817 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		return;
#line 8054 "tracker-sparql-query.c"
	}
#line 818 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	__g_list_free__g_object_unref0_0 (self->bindings);
#line 818 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->bindings = NULL;
#line 820 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp177_ = self->context;
#line 820 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp178_ = _tmp177_->parent_context;
#line 820 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp179_ = _tracker_sparql_context_ref0 (_tmp178_);
#line 820 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tracker_sparql_context_unref0 (self->context);
#line 820 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->context = _tmp179_;
#line 620 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_object_unref0 (cursor);
#line 620 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_object_unref0 (iface);
#line 620 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tracker_sparql_solution_unref0 (solution);
#line 620 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_string_free0 (sql);
#line 620 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_string_free0 (pattern_sql);
#line 620 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_object_unref0 (data_update);
#line 620 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tracker_source_location_free0 (insert_location);
#line 620 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tracker_source_location_free0 (delete_location);
#line 8086 "tracker-sparql-query.c"
}


gchar* tracker_sparql_query_resolve_prefixed_name (TrackerSparqlQuery* self, const gchar* prefix, const gchar* local_name, GError** error) {
	gchar* result = NULL;
	gchar* ns = NULL;
	GHashTable* _tmp0_;
	const gchar* _tmp1_;
	gconstpointer _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	GError * _inner_error_ = NULL;
#line 823 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 823 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (prefix != NULL, NULL);
#line 823 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (local_name != NULL, NULL);
#line 824 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = self->priv->prefix_map;
#line 824 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = prefix;
#line 824 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp2_ = g_hash_table_lookup (_tmp0_, _tmp1_);
#line 824 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp3_ = g_strdup ((const gchar*) _tmp2_);
#line 824 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	ns = _tmp3_;
#line 825 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp4_ = ns;
#line 825 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (_tmp4_ == NULL) {
#line 8122 "tracker-sparql-query.c"
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		GError* _tmp8_;
		GError* _tmp9_;
#line 826 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp5_ = prefix;
#line 826 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp6_ = g_strdup_printf ("use of undefined prefix `%s'", _tmp5_);
#line 826 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp7_ = _tmp6_;
#line 826 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp8_ = tracker_sparql_query_get_error (self, _tmp7_);
#line 826 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp9_ = _tmp8_;
#line 826 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_free0 (_tmp7_);
#line 826 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_inner_error_ = _tmp9_;
#line 826 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 826 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_propagate_error (error, _inner_error_);
#line 826 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_free0 (ns);
#line 826 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return NULL;
#line 8150 "tracker-sparql-query.c"
		} else {
#line 826 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_free0 (ns);
#line 826 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 826 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_clear_error (&_inner_error_);
#line 826 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return NULL;
#line 8160 "tracker-sparql-query.c"
		}
	}
#line 828 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp10_ = ns;
#line 828 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp11_ = local_name;
#line 828 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp12_ = g_strconcat (_tmp10_, _tmp11_, NULL);
#line 828 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	result = _tmp12_;
#line 828 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_free0 (ns);
#line 828 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return result;
#line 8175 "tracker-sparql-query.c"
}


static gint tracker_sparql_query_quad_data_unbound_var_count (TrackerSparqlQuery* self, GError** error) {
	gint result = 0;
	TrackerSourceLocation current_pos = {0};
	TrackerSourceLocation _tmp0_ = {0};
	gint n_braces = 0;
	gint n_unbound = 0;
	TrackerSourceLocation _tmp22_;
	GError * _inner_error_ = NULL;
#line 831 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 832 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	tracker_sparql_query_get_location (self, &_tmp0_);
#line 832 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	current_pos = _tmp0_;
#line 833 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	n_braces = 1;
#line 834 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	n_unbound = 0;
#line 836 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE, &_inner_error_);
#line 836 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 836 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 8203 "tracker-sparql-query.c"
			gint _tmp1_ = 0;
#line 836 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_propagate_error (error, _inner_error_);
#line 836 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return _tmp1_;
#line 8209 "tracker-sparql-query.c"
		} else {
			gint _tmp2_ = 0;
#line 836 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 836 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_clear_error (&_inner_error_);
#line 836 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return _tmp2_;
#line 8218 "tracker-sparql-query.c"
		}
	}
#line 837 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	while (TRUE) {
#line 8223 "tracker-sparql-query.c"
		gint _tmp3_;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_;
#line 837 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp3_ = n_braces;
#line 837 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (!(_tmp3_ > 0)) {
#line 837 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			break;
#line 8233 "tracker-sparql-query.c"
		}
#line 838 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp5_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE, &_inner_error_);
#line 838 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp4_ = _tmp5_;
#line 838 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 838 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 8243 "tracker-sparql-query.c"
				gint _tmp6_ = 0;
#line 838 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 838 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return _tmp6_;
#line 8249 "tracker-sparql-query.c"
			} else {
				gint _tmp7_ = 0;
#line 838 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 838 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_clear_error (&_inner_error_);
#line 838 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return _tmp7_;
#line 8258 "tracker-sparql-query.c"
			}
		}
#line 838 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (_tmp4_) {
#line 8263 "tracker-sparql-query.c"
			gint _tmp8_;
#line 839 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp8_ = n_braces;
#line 839 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			n_braces = _tmp8_ + 1;
#line 8269 "tracker-sparql-query.c"
		} else {
			gboolean _tmp9_ = FALSE;
			gboolean _tmp10_;
#line 840 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp10_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE, &_inner_error_);
#line 840 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp9_ = _tmp10_;
#line 840 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 840 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 8281 "tracker-sparql-query.c"
					gint _tmp11_ = 0;
#line 840 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_propagate_error (error, _inner_error_);
#line 840 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return _tmp11_;
#line 8287 "tracker-sparql-query.c"
				} else {
					gint _tmp12_ = 0;
#line 840 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 840 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_clear_error (&_inner_error_);
#line 840 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return _tmp12_;
#line 8296 "tracker-sparql-query.c"
				}
			}
#line 840 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (_tmp9_) {
#line 8301 "tracker-sparql-query.c"
				gint _tmp13_;
#line 841 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp13_ = n_braces;
#line 841 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				n_braces = _tmp13_ - 1;
#line 8307 "tracker-sparql-query.c"
			} else {
				TrackerSparqlTokenType _tmp14_;
#line 842 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp14_ = tracker_sparql_query_current (self);
#line 842 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if (_tmp14_ == TRACKER_SPARQL_TOKEN_TYPE_EOF) {
#line 8314 "tracker-sparql-query.c"
					GError* _tmp15_;
#line 843 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp15_ = tracker_sparql_query_get_error (self, "unexpected end of query, expected }");
#line 843 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_inner_error_ = _tmp15_;
#line 843 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 8322 "tracker-sparql-query.c"
						gint _tmp16_ = 0;
#line 843 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_propagate_error (error, _inner_error_);
#line 843 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						return _tmp16_;
#line 8328 "tracker-sparql-query.c"
					} else {
						gint _tmp17_ = 0;
#line 843 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 843 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_clear_error (&_inner_error_);
#line 843 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						return _tmp17_;
#line 8337 "tracker-sparql-query.c"
					}
				} else {
					TrackerSparqlTokenType _tmp18_;
#line 845 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp18_ = tracker_sparql_query_current (self);
#line 845 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if (_tmp18_ == TRACKER_SPARQL_TOKEN_TYPE_VAR) {
#line 8345 "tracker-sparql-query.c"
						gint _tmp19_;
#line 846 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp19_ = n_unbound;
#line 846 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						n_unbound = _tmp19_ + 1;
#line 8351 "tracker-sparql-query.c"
					}
#line 848 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					tracker_sparql_query_next (self, &_inner_error_);
#line 848 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 848 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 8359 "tracker-sparql-query.c"
							gint _tmp20_ = 0;
#line 848 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							g_propagate_error (error, _inner_error_);
#line 848 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							return _tmp20_;
#line 8365 "tracker-sparql-query.c"
						} else {
							gint _tmp21_ = 0;
#line 848 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 848 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							g_clear_error (&_inner_error_);
#line 848 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							return _tmp21_;
#line 8374 "tracker-sparql-query.c"
						}
					}
				}
			}
		}
	}
#line 852 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp22_ = current_pos;
#line 852 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	tracker_sparql_query_set_location (self, &_tmp22_);
#line 853 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	result = n_unbound;
#line 853 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return result;
#line 8389 "tracker-sparql-query.c"
}


static void tracker_sparql_query_skip_braces (TrackerSparqlQuery* self, GError** error) {
	gint n_braces = 0;
	GError * _inner_error_ = NULL;
#line 856 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_if_fail (self != NULL);
#line 857 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE, &_inner_error_);
#line 857 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 857 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 857 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_propagate_error (error, _inner_error_);
#line 857 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return;
#line 8408 "tracker-sparql-query.c"
		} else {
#line 857 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 857 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_clear_error (&_inner_error_);
#line 857 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return;
#line 8416 "tracker-sparql-query.c"
		}
	}
#line 858 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	n_braces = 1;
#line 859 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	while (TRUE) {
#line 8423 "tracker-sparql-query.c"
		gint _tmp0_;
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_;
#line 859 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp0_ = n_braces;
#line 859 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (!(_tmp0_ > 0)) {
#line 859 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			break;
#line 8433 "tracker-sparql-query.c"
		}
#line 860 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp2_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE, &_inner_error_);
#line 860 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp1_ = _tmp2_;
#line 860 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 860 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 860 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 860 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 8447 "tracker-sparql-query.c"
			} else {
#line 860 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 860 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_clear_error (&_inner_error_);
#line 860 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 8455 "tracker-sparql-query.c"
			}
		}
#line 860 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (_tmp1_) {
#line 8460 "tracker-sparql-query.c"
			gint _tmp3_;
#line 861 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp3_ = n_braces;
#line 861 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			n_braces = _tmp3_ + 1;
#line 8466 "tracker-sparql-query.c"
		} else {
			gboolean _tmp4_ = FALSE;
			gboolean _tmp5_;
#line 862 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp5_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE, &_inner_error_);
#line 862 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp4_ = _tmp5_;
#line 862 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 862 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 862 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_propagate_error (error, _inner_error_);
#line 862 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return;
#line 8482 "tracker-sparql-query.c"
				} else {
#line 862 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 862 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_clear_error (&_inner_error_);
#line 862 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return;
#line 8490 "tracker-sparql-query.c"
				}
			}
#line 862 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (_tmp4_) {
#line 8495 "tracker-sparql-query.c"
				gint _tmp6_;
#line 863 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp6_ = n_braces;
#line 863 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				n_braces = _tmp6_ - 1;
#line 8501 "tracker-sparql-query.c"
			} else {
				TrackerSparqlTokenType _tmp7_;
#line 864 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp7_ = tracker_sparql_query_current (self);
#line 864 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if (_tmp7_ == TRACKER_SPARQL_TOKEN_TYPE_EOF) {
#line 8508 "tracker-sparql-query.c"
					GError* _tmp8_;
#line 865 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp8_ = tracker_sparql_query_get_error (self, "unexpected end of query, expected }");
#line 865 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_inner_error_ = _tmp8_;
#line 865 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 865 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_propagate_error (error, _inner_error_);
#line 865 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						return;
#line 8520 "tracker-sparql-query.c"
					} else {
#line 865 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 865 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_clear_error (&_inner_error_);
#line 865 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						return;
#line 8528 "tracker-sparql-query.c"
					}
				} else {
#line 868 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					tracker_sparql_query_next (self, &_inner_error_);
#line 868 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 868 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 868 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							g_propagate_error (error, _inner_error_);
#line 868 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							return;
#line 8541 "tracker-sparql-query.c"
						} else {
#line 868 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 868 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							g_clear_error (&_inner_error_);
#line 868 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							return;
#line 8549 "tracker-sparql-query.c"
						}
					}
				}
			}
		}
	}
}


static void tracker_sparql_query_parse_construct_triples_block (TrackerSparqlQuery* self, TrackerSparqlSolution* var_value_map, TrackerSparqlUpdateType type, GError** error) {
	GError * _inner_error_ = NULL;
#line 873 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_if_fail (self != NULL);
#line 873 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_if_fail (var_value_map != NULL);
#line 874 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE, &_inner_error_);
#line 874 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 874 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 874 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_propagate_error (error, _inner_error_);
#line 874 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return;
#line 8575 "tracker-sparql-query.c"
		} else {
#line 874 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 874 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_clear_error (&_inner_error_);
#line 874 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return;
#line 8583 "tracker-sparql-query.c"
		}
	}
#line 876 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	while (TRUE) {
#line 8588 "tracker-sparql-query.c"
		TrackerSparqlTokenType _tmp0_;
		gboolean is_null = FALSE;
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_;
#line 876 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp0_ = tracker_sparql_query_current (self);
#line 876 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (!(_tmp0_ != TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE)) {
#line 876 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			break;
#line 8599 "tracker-sparql-query.c"
		}
#line 877 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		is_null = FALSE;
#line 879 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp2_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_GRAPH, &_inner_error_);
#line 879 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp1_ = _tmp2_;
#line 879 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 879 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 879 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 879 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 8615 "tracker-sparql-query.c"
			} else {
#line 879 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 879 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_clear_error (&_inner_error_);
#line 879 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 8623 "tracker-sparql-query.c"
			}
		}
#line 879 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (_tmp1_) {
#line 8628 "tracker-sparql-query.c"
			gchar* old_graph = NULL;
			const gchar* _tmp3_;
			gchar* _tmp4_;
			gchar* _tmp5_ = NULL;
			TrackerSparqlSolution* _tmp6_;
			TrackerSparqlUpdateType _tmp7_;
			gboolean _tmp8_ = FALSE;
			gchar* _tmp9_;
			gchar* _tmp10_;
			gboolean _tmp11_;
			const gchar* _tmp26_;
			gchar* _tmp27_;
#line 880 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp3_ = self->priv->current_graph;
#line 880 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp4_ = g_strdup (_tmp3_);
#line 880 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			old_graph = _tmp4_;
#line 881 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp6_ = var_value_map;
#line 881 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp7_ = type;
#line 881 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp9_ = tracker_sparql_query_parse_construct_var_or_term (self, _tmp6_, _tmp7_, &_tmp8_, &_inner_error_);
#line 881 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			is_null = _tmp8_;
#line 881 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp5_ = _tmp9_;
#line 881 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 881 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 881 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_propagate_error (error, _inner_error_);
#line 881 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (old_graph);
#line 881 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return;
#line 8667 "tracker-sparql-query.c"
				} else {
#line 881 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (old_graph);
#line 881 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 881 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_clear_error (&_inner_error_);
#line 881 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return;
#line 8677 "tracker-sparql-query.c"
				}
			}
#line 881 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp10_ = _tmp5_;
#line 881 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp5_ = NULL;
#line 881 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_free0 (self->priv->current_graph);
#line 881 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			self->priv->current_graph = _tmp10_;
#line 883 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp11_ = is_null;
#line 883 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (_tmp11_) {
#line 8692 "tracker-sparql-query.c"
				GError* _tmp12_;
#line 884 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp12_ = tracker_sparql_query_get_error (self, "'null' not supported for graph");
#line 884 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_inner_error_ = _tmp12_;
#line 884 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 884 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_propagate_error (error, _inner_error_);
#line 884 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (_tmp5_);
#line 884 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (old_graph);
#line 884 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return;
#line 8708 "tracker-sparql-query.c"
				} else {
#line 884 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (_tmp5_);
#line 884 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (old_graph);
#line 884 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 884 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_clear_error (&_inner_error_);
#line 884 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return;
#line 8720 "tracker-sparql-query.c"
				}
			}
#line 887 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE, &_inner_error_);
#line 887 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 887 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 887 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_propagate_error (error, _inner_error_);
#line 887 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (_tmp5_);
#line 887 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (old_graph);
#line 887 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return;
#line 8737 "tracker-sparql-query.c"
				} else {
#line 887 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (_tmp5_);
#line 887 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (old_graph);
#line 887 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 887 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_clear_error (&_inner_error_);
#line 887 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return;
#line 8749 "tracker-sparql-query.c"
				}
			}
#line 889 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			while (TRUE) {
#line 8754 "tracker-sparql-query.c"
				TrackerSparqlTokenType _tmp13_;
				gchar* _tmp14_ = NULL;
				TrackerSparqlSolution* _tmp15_;
				TrackerSparqlUpdateType _tmp16_;
				gboolean _tmp17_ = FALSE;
				gchar* _tmp18_;
				gchar* _tmp19_;
				gboolean _tmp20_;
				TrackerSparqlSolution* _tmp22_;
				TrackerSparqlUpdateType _tmp23_;
				gboolean _tmp24_ = FALSE;
				gboolean _tmp25_;
#line 889 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp13_ = tracker_sparql_query_current (self);
#line 889 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if (!(_tmp13_ != TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE)) {
#line 889 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					break;
#line 8773 "tracker-sparql-query.c"
				}
#line 890 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp15_ = var_value_map;
#line 890 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp16_ = type;
#line 890 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp18_ = tracker_sparql_query_parse_construct_var_or_term (self, _tmp15_, _tmp16_, &_tmp17_, &_inner_error_);
#line 890 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				is_null = _tmp17_;
#line 890 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp14_ = _tmp18_;
#line 890 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 890 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 890 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_propagate_error (error, _inner_error_);
#line 890 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (_tmp5_);
#line 890 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (old_graph);
#line 890 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						return;
#line 8797 "tracker-sparql-query.c"
					} else {
#line 890 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (_tmp5_);
#line 890 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (old_graph);
#line 890 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 890 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_clear_error (&_inner_error_);
#line 890 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						return;
#line 8809 "tracker-sparql-query.c"
					}
				}
#line 890 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp19_ = _tmp14_;
#line 890 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp14_ = NULL;
#line 890 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_free0 (self->priv->current_subject);
#line 890 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				self->priv->current_subject = _tmp19_;
#line 892 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp20_ = is_null;
#line 892 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if (_tmp20_) {
#line 8824 "tracker-sparql-query.c"
					GError* _tmp21_;
#line 893 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp21_ = tracker_sparql_query_get_error (self, "'null' not supported for subject");
#line 893 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_inner_error_ = _tmp21_;
#line 893 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 893 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_propagate_error (error, _inner_error_);
#line 893 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (_tmp14_);
#line 893 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (_tmp5_);
#line 893 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (old_graph);
#line 893 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						return;
#line 8842 "tracker-sparql-query.c"
					} else {
#line 893 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (_tmp14_);
#line 893 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (_tmp5_);
#line 893 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (old_graph);
#line 893 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 893 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_clear_error (&_inner_error_);
#line 893 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						return;
#line 8856 "tracker-sparql-query.c"
					}
				}
#line 896 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp22_ = var_value_map;
#line 896 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp23_ = type;
#line 896 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				tracker_sparql_query_parse_construct_property_list_not_empty (self, _tmp22_, _tmp23_, &_inner_error_);
#line 896 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 896 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 896 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_propagate_error (error, _inner_error_);
#line 896 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (_tmp14_);
#line 896 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (_tmp5_);
#line 896 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (old_graph);
#line 896 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						return;
#line 8879 "tracker-sparql-query.c"
					} else {
#line 896 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (_tmp14_);
#line 896 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (_tmp5_);
#line 896 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (old_graph);
#line 896 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 896 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_clear_error (&_inner_error_);
#line 896 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						return;
#line 8893 "tracker-sparql-query.c"
					}
				}
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp25_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOT, &_inner_error_);
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp24_ = _tmp25_;
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_propagate_error (error, _inner_error_);
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (_tmp14_);
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (_tmp5_);
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (old_graph);
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						return;
#line 8914 "tracker-sparql-query.c"
					} else {
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (_tmp14_);
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (_tmp5_);
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (old_graph);
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_clear_error (&_inner_error_);
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						return;
#line 8928 "tracker-sparql-query.c"
					}
				}
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if (!_tmp24_) {
#line 899 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (_tmp14_);
#line 899 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					break;
#line 8937 "tracker-sparql-query.c"
				}
#line 889 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_free0 (_tmp14_);
#line 8941 "tracker-sparql-query.c"
			}
#line 903 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE, &_inner_error_);
#line 903 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 903 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 903 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_propagate_error (error, _inner_error_);
#line 903 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (_tmp5_);
#line 903 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (old_graph);
#line 903 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return;
#line 8957 "tracker-sparql-query.c"
				} else {
#line 903 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (_tmp5_);
#line 903 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (old_graph);
#line 903 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 903 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_clear_error (&_inner_error_);
#line 903 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return;
#line 8969 "tracker-sparql-query.c"
				}
			}
#line 905 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp26_ = old_graph;
#line 905 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp27_ = g_strdup (_tmp26_);
#line 905 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_free0 (self->priv->current_graph);
#line 905 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			self->priv->current_graph = _tmp27_;
#line 907 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			tracker_sparql_query_optional (self, TRACKER_SPARQL_TOKEN_TYPE_DOT, &_inner_error_);
#line 907 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 907 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 907 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_propagate_error (error, _inner_error_);
#line 907 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (_tmp5_);
#line 907 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (old_graph);
#line 907 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return;
#line 8994 "tracker-sparql-query.c"
				} else {
#line 907 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (_tmp5_);
#line 907 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (old_graph);
#line 907 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 907 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_clear_error (&_inner_error_);
#line 907 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return;
#line 9006 "tracker-sparql-query.c"
				}
			}
#line 879 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_free0 (_tmp5_);
#line 879 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_free0 (old_graph);
#line 9013 "tracker-sparql-query.c"
		} else {
			gchar* _tmp28_ = NULL;
			TrackerSparqlSolution* _tmp29_;
			TrackerSparqlUpdateType _tmp30_;
			gboolean _tmp31_ = FALSE;
			gchar* _tmp32_;
			gchar* _tmp33_;
			gboolean _tmp34_;
			TrackerSparqlSolution* _tmp36_;
			TrackerSparqlUpdateType _tmp37_;
			gboolean _tmp38_ = FALSE;
			gboolean _tmp39_ = FALSE;
			gboolean _tmp40_;
#line 909 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp29_ = var_value_map;
#line 909 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp30_ = type;
#line 909 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp32_ = tracker_sparql_query_parse_construct_var_or_term (self, _tmp29_, _tmp30_, &_tmp31_, &_inner_error_);
#line 909 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			is_null = _tmp31_;
#line 909 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp28_ = _tmp32_;
#line 909 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 909 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 909 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_propagate_error (error, _inner_error_);
#line 909 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return;
#line 9045 "tracker-sparql-query.c"
				} else {
#line 909 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 909 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_clear_error (&_inner_error_);
#line 909 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return;
#line 9053 "tracker-sparql-query.c"
				}
			}
#line 909 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp33_ = _tmp28_;
#line 909 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp28_ = NULL;
#line 909 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_free0 (self->priv->current_subject);
#line 909 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			self->priv->current_subject = _tmp33_;
#line 911 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp34_ = is_null;
#line 911 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (_tmp34_) {
#line 9068 "tracker-sparql-query.c"
				GError* _tmp35_;
#line 912 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp35_ = tracker_sparql_query_get_error (self, "'null' not supported for subject");
#line 912 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_inner_error_ = _tmp35_;
#line 912 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 912 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_propagate_error (error, _inner_error_);
#line 912 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (_tmp28_);
#line 912 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return;
#line 9082 "tracker-sparql-query.c"
				} else {
#line 912 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (_tmp28_);
#line 912 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 912 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_clear_error (&_inner_error_);
#line 912 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return;
#line 9092 "tracker-sparql-query.c"
				}
			}
#line 915 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp36_ = var_value_map;
#line 915 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp37_ = type;
#line 915 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			tracker_sparql_query_parse_construct_property_list_not_empty (self, _tmp36_, _tmp37_, &_inner_error_);
#line 915 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 915 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 915 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_propagate_error (error, _inner_error_);
#line 915 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (_tmp28_);
#line 915 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return;
#line 9111 "tracker-sparql-query.c"
				} else {
#line 915 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (_tmp28_);
#line 915 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 915 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_clear_error (&_inner_error_);
#line 915 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return;
#line 9121 "tracker-sparql-query.c"
				}
			}
#line 916 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp40_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOT, &_inner_error_);
#line 916 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp39_ = _tmp40_;
#line 916 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 916 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 916 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_propagate_error (error, _inner_error_);
#line 916 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (_tmp28_);
#line 916 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return;
#line 9138 "tracker-sparql-query.c"
				} else {
#line 916 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (_tmp28_);
#line 916 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 916 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_clear_error (&_inner_error_);
#line 916 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return;
#line 9148 "tracker-sparql-query.c"
				}
			}
#line 916 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (!_tmp39_) {
#line 9153 "tracker-sparql-query.c"
				TrackerSparqlTokenType _tmp41_;
#line 916 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp41_ = tracker_sparql_query_current (self);
#line 916 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp38_ = _tmp41_ != TRACKER_SPARQL_TOKEN_TYPE_GRAPH;
#line 9159 "tracker-sparql-query.c"
			} else {
#line 916 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp38_ = FALSE;
#line 9163 "tracker-sparql-query.c"
			}
#line 916 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (_tmp38_) {
#line 918 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_free0 (_tmp28_);
#line 918 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				break;
#line 9171 "tracker-sparql-query.c"
			}
#line 879 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_free0 (_tmp28_);
#line 9175 "tracker-sparql-query.c"
		}
	}
#line 923 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE, &_inner_error_);
#line 923 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 923 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 923 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_propagate_error (error, _inner_error_);
#line 923 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return;
#line 9188 "tracker-sparql-query.c"
		} else {
#line 923 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 923 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_clear_error (&_inner_error_);
#line 923 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return;
#line 9196 "tracker-sparql-query.c"
		}
	}
}


static gchar* tracker_sparql_query_parse_construct_var_or_term (TrackerSparqlQuery* self, TrackerSparqlSolution* var_value_map, TrackerSparqlUpdateType type, gboolean* is_null, GError** error) {
	gboolean _vala_is_null = FALSE;
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	TrackerSparqlTokenType _tmp1_;
	GError * _inner_error_ = NULL;
#line 928 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 928 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (var_value_map != NULL, NULL);
#line 929 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = g_strdup ("");
#line 929 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_result_ = _tmp0_;
#line 930 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_vala_is_null = FALSE;
#line 931 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = tracker_sparql_query_current (self);
#line 931 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (_tmp1_ == TRACKER_SPARQL_TOKEN_TYPE_VAR) {
#line 9223 "tracker-sparql-query.c"
		TrackerSparqlSolution* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
#line 932 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		tracker_sparql_query_next (self, &_inner_error_);
#line 932 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 932 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 932 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 932 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_free0 (_result_);
#line 932 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return NULL;
#line 9242 "tracker-sparql-query.c"
			} else {
#line 932 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_free0 (_result_);
#line 932 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 932 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_clear_error (&_inner_error_);
#line 932 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return NULL;
#line 9252 "tracker-sparql-query.c"
			}
		}
#line 933 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp2_ = var_value_map;
#line 933 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp3_ = tracker_sparql_query_get_last_string (self, 0);
#line 933 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp4_ = _tmp3_;
#line 933 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp5_ = string_substring (_tmp4_, (glong) 1, (glong) -1);
#line 933 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp6_ = _tmp5_;
#line 933 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp7_ = tracker_sparql_solution_lookup (_tmp2_, _tmp6_);
#line 933 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_free0 (_result_);
#line 933 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_result_ = _tmp7_;
#line 933 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_free0 (_tmp6_);
#line 933 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_free0 (_tmp4_);
#line 9275 "tracker-sparql-query.c"
	} else {
		TrackerSparqlTokenType _tmp8_;
#line 934 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp8_ = tracker_sparql_query_current (self);
#line 934 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (_tmp8_ == TRACKER_SPARQL_TOKEN_TYPE_IRI_REF) {
#line 9282 "tracker-sparql-query.c"
			gchar* _tmp9_;
#line 935 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			tracker_sparql_query_next (self, &_inner_error_);
#line 935 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 935 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 935 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_propagate_error (error, _inner_error_);
#line 935 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (_result_);
#line 935 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return NULL;
#line 9296 "tracker-sparql-query.c"
				} else {
#line 935 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (_result_);
#line 935 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 935 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_clear_error (&_inner_error_);
#line 935 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return NULL;
#line 9306 "tracker-sparql-query.c"
				}
			}
#line 936 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp9_ = tracker_sparql_query_get_last_string (self, 1);
#line 936 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_free0 (_result_);
#line 936 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_result_ = _tmp9_;
#line 9315 "tracker-sparql-query.c"
		} else {
			TrackerSparqlTokenType _tmp10_;
#line 937 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp10_ = tracker_sparql_query_current (self);
#line 937 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (_tmp10_ == TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX) {
#line 9322 "tracker-sparql-query.c"
				gchar* ns = NULL;
				gchar* _tmp11_;
				gchar* _tmp12_ = NULL;
				const gchar* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
#line 939 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				tracker_sparql_query_next (self, &_inner_error_);
#line 939 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 939 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 939 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_propagate_error (error, _inner_error_);
#line 939 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (_result_);
#line 939 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						return NULL;
#line 9346 "tracker-sparql-query.c"
					} else {
#line 939 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (_result_);
#line 939 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 939 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_clear_error (&_inner_error_);
#line 939 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						return NULL;
#line 9356 "tracker-sparql-query.c"
					}
				}
#line 940 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp11_ = tracker_sparql_query_get_last_string (self, 0);
#line 940 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				ns = _tmp11_;
#line 941 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
#line 941 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 941 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 941 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_propagate_error (error, _inner_error_);
#line 941 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (ns);
#line 941 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (_result_);
#line 941 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						return NULL;
#line 9377 "tracker-sparql-query.c"
					} else {
#line 941 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (ns);
#line 941 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (_result_);
#line 941 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 941 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_clear_error (&_inner_error_);
#line 941 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						return NULL;
#line 9389 "tracker-sparql-query.c"
					}
				}
#line 942 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp13_ = ns;
#line 942 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp14_ = tracker_sparql_query_get_last_string (self, 0);
#line 942 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp15_ = _tmp14_;
#line 942 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp16_ = string_substring (_tmp15_, (glong) 1, (glong) -1);
#line 942 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp17_ = _tmp16_;
#line 942 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp18_ = tracker_sparql_query_resolve_prefixed_name (self, _tmp13_, _tmp17_, &_inner_error_);
#line 942 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp19_ = _tmp18_;
#line 942 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_free0 (_tmp17_);
#line 942 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_free0 (_tmp15_);
#line 942 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp12_ = _tmp19_;
#line 942 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 942 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 942 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_propagate_error (error, _inner_error_);
#line 942 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (ns);
#line 942 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (_result_);
#line 942 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						return NULL;
#line 9424 "tracker-sparql-query.c"
					} else {
#line 942 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (ns);
#line 942 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (_result_);
#line 942 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 942 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_clear_error (&_inner_error_);
#line 942 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						return NULL;
#line 9436 "tracker-sparql-query.c"
					}
				}
#line 942 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp20_ = _tmp12_;
#line 942 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp12_ = NULL;
#line 942 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_free0 (_result_);
#line 942 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_result_ = _tmp20_;
#line 937 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_free0 (_tmp12_);
#line 937 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_free0 (ns);
#line 9451 "tracker-sparql-query.c"
			} else {
				TrackerSparqlTokenType _tmp21_;
#line 943 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp21_ = tracker_sparql_query_current (self);
#line 943 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if (_tmp21_ == TRACKER_SPARQL_TOKEN_TYPE_COLON) {
#line 9458 "tracker-sparql-query.c"
					gchar* _tmp22_ = NULL;
					gchar* _tmp23_;
					gchar* _tmp24_;
					gchar* _tmp25_;
					gchar* _tmp26_;
					gchar* _tmp27_;
					gchar* _tmp28_;
					gchar* _tmp29_;
#line 945 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					tracker_sparql_query_next (self, &_inner_error_);
#line 945 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 945 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 945 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							g_propagate_error (error, _inner_error_);
#line 945 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_g_free0 (_result_);
#line 945 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							return NULL;
#line 9479 "tracker-sparql-query.c"
						} else {
#line 945 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_g_free0 (_result_);
#line 945 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 945 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							g_clear_error (&_inner_error_);
#line 945 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							return NULL;
#line 9489 "tracker-sparql-query.c"
						}
					}
#line 946 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp23_ = tracker_sparql_query_get_last_string (self, 0);
#line 946 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp24_ = _tmp23_;
#line 946 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp25_ = string_substring (_tmp24_, (glong) 1, (glong) -1);
#line 946 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp26_ = _tmp25_;
#line 946 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp27_ = tracker_sparql_query_resolve_prefixed_name (self, "", _tmp26_, &_inner_error_);
#line 946 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp28_ = _tmp27_;
#line 946 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (_tmp26_);
#line 946 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (_tmp24_);
#line 946 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp22_ = _tmp28_;
#line 946 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 946 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 946 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							g_propagate_error (error, _inner_error_);
#line 946 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_g_free0 (_result_);
#line 946 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							return NULL;
#line 9520 "tracker-sparql-query.c"
						} else {
#line 946 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_g_free0 (_result_);
#line 946 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 946 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							g_clear_error (&_inner_error_);
#line 946 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							return NULL;
#line 9530 "tracker-sparql-query.c"
						}
					}
#line 946 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp29_ = _tmp22_;
#line 946 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp22_ = NULL;
#line 946 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (_result_);
#line 946 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_result_ = _tmp29_;
#line 943 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (_tmp22_);
#line 9543 "tracker-sparql-query.c"
				} else {
					gboolean _tmp30_ = FALSE;
					gboolean _tmp31_;
#line 947 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp31_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE, &_inner_error_);
#line 947 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp30_ = _tmp31_;
#line 947 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 947 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 947 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							g_propagate_error (error, _inner_error_);
#line 947 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_g_free0 (_result_);
#line 947 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							return NULL;
#line 9561 "tracker-sparql-query.c"
						} else {
#line 947 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_g_free0 (_result_);
#line 947 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 947 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							g_clear_error (&_inner_error_);
#line 947 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							return NULL;
#line 9571 "tracker-sparql-query.c"
						}
					}
#line 947 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if (_tmp30_) {
#line 9576 "tracker-sparql-query.c"
						gchar* _tmp32_;
						gchar* _tmp33_;
						gchar* _tmp34_;
						gchar* _tmp35_;
						gchar* _tmp36_;
#line 949 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
#line 949 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 949 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 949 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								g_propagate_error (error, _inner_error_);
#line 949 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_g_free0 (_result_);
#line 949 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								return NULL;
#line 9594 "tracker-sparql-query.c"
							} else {
#line 949 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_g_free0 (_result_);
#line 949 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 949 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								g_clear_error (&_inner_error_);
#line 949 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								return NULL;
#line 9604 "tracker-sparql-query.c"
							}
						}
#line 950 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp32_ = tracker_sparql_query_get_last_string (self, 0);
#line 950 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp33_ = _tmp32_;
#line 950 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp34_ = string_substring (_tmp33_, (glong) 1, (glong) -1);
#line 950 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp35_ = _tmp34_;
#line 950 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp36_ = tracker_sparql_query_generate_bnodeid (self, _tmp35_);
#line 950 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (_result_);
#line 950 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_result_ = _tmp36_;
#line 950 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (_tmp35_);
#line 950 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (_tmp33_);
#line 9625 "tracker-sparql-query.c"
					} else {
						TrackerSparqlTokenType _tmp37_;
#line 951 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp37_ = tracker_sparql_query_current (self);
#line 951 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						if (_tmp37_ == TRACKER_SPARQL_TOKEN_TYPE_MINUS) {
#line 9632 "tracker-sparql-query.c"
							gboolean _tmp38_ = FALSE;
							gboolean _tmp39_ = FALSE;
							TrackerSparqlTokenType _tmp40_;
#line 952 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							tracker_sparql_query_next (self, &_inner_error_);
#line 952 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 952 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 952 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									g_propagate_error (error, _inner_error_);
#line 952 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									_g_free0 (_result_);
#line 952 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									return NULL;
#line 9648 "tracker-sparql-query.c"
								} else {
#line 952 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									_g_free0 (_result_);
#line 952 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 952 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									g_clear_error (&_inner_error_);
#line 952 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									return NULL;
#line 9658 "tracker-sparql-query.c"
								}
							}
#line 953 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_tmp40_ = tracker_sparql_query_current (self);
#line 953 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							if (_tmp40_ == TRACKER_SPARQL_TOKEN_TYPE_INTEGER) {
#line 953 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_tmp39_ = TRUE;
#line 9667 "tracker-sparql-query.c"
							} else {
								TrackerSparqlTokenType _tmp41_;
#line 954 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_tmp41_ = tracker_sparql_query_current (self);
#line 954 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_tmp39_ = _tmp41_ == TRACKER_SPARQL_TOKEN_TYPE_DECIMAL;
#line 9674 "tracker-sparql-query.c"
							}
#line 953 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							if (_tmp39_) {
#line 953 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_tmp38_ = TRUE;
#line 9680 "tracker-sparql-query.c"
							} else {
								TrackerSparqlTokenType _tmp42_;
#line 955 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_tmp42_ = tracker_sparql_query_current (self);
#line 955 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_tmp38_ = _tmp42_ == TRACKER_SPARQL_TOKEN_TYPE_DOUBLE;
#line 9687 "tracker-sparql-query.c"
							}
#line 953 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							if (_tmp38_) {
#line 9691 "tracker-sparql-query.c"
								gchar* _tmp43_;
								gchar* _tmp44_;
								gchar* _tmp45_;
#line 956 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								tracker_sparql_query_next (self, &_inner_error_);
#line 956 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 956 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 956 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
										g_propagate_error (error, _inner_error_);
#line 956 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
										_g_free0 (_result_);
#line 956 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
										return NULL;
#line 9707 "tracker-sparql-query.c"
									} else {
#line 956 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
										_g_free0 (_result_);
#line 956 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 956 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
										g_clear_error (&_inner_error_);
#line 956 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
										return NULL;
#line 9717 "tracker-sparql-query.c"
									}
								}
#line 957 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_tmp43_ = tracker_sparql_query_get_last_string (self, 0);
#line 957 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_tmp44_ = _tmp43_;
#line 957 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_tmp45_ = g_strconcat ("-", _tmp44_, NULL);
#line 957 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_g_free0 (_result_);
#line 957 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_result_ = _tmp45_;
#line 957 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_g_free0 (_tmp44_);
#line 9732 "tracker-sparql-query.c"
							} else {
								GError* _tmp46_;
#line 959 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_tmp46_ = tracker_sparql_query_get_error (self, "expected variable or term");
#line 959 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_inner_error_ = _tmp46_;
#line 959 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 959 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									g_propagate_error (error, _inner_error_);
#line 959 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									_g_free0 (_result_);
#line 959 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									return NULL;
#line 9747 "tracker-sparql-query.c"
								} else {
#line 959 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									_g_free0 (_result_);
#line 959 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 959 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									g_clear_error (&_inner_error_);
#line 959 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									return NULL;
#line 9757 "tracker-sparql-query.c"
								}
							}
						} else {
							TrackerSparqlTokenType _tmp47_;
#line 961 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_tmp47_ = tracker_sparql_query_current (self);
#line 961 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							if (_tmp47_ == TRACKER_SPARQL_TOKEN_TYPE_INTEGER) {
#line 9766 "tracker-sparql-query.c"
								gchar* _tmp48_;
#line 962 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								tracker_sparql_query_next (self, &_inner_error_);
#line 962 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 962 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 962 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
										g_propagate_error (error, _inner_error_);
#line 962 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
										_g_free0 (_result_);
#line 962 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
										return NULL;
#line 9780 "tracker-sparql-query.c"
									} else {
#line 962 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
										_g_free0 (_result_);
#line 962 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 962 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
										g_clear_error (&_inner_error_);
#line 962 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
										return NULL;
#line 9790 "tracker-sparql-query.c"
									}
								}
#line 963 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_tmp48_ = tracker_sparql_query_get_last_string (self, 0);
#line 963 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_g_free0 (_result_);
#line 963 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_result_ = _tmp48_;
#line 9799 "tracker-sparql-query.c"
							} else {
								TrackerSparqlTokenType _tmp49_;
#line 964 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_tmp49_ = tracker_sparql_query_current (self);
#line 964 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								if (_tmp49_ == TRACKER_SPARQL_TOKEN_TYPE_NULL) {
#line 9806 "tracker-sparql-query.c"
									gchar* _tmp50_;
#line 965 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									tracker_sparql_query_next (self, &_inner_error_);
#line 965 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 965 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
										if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 965 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
											g_propagate_error (error, _inner_error_);
#line 965 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
											_g_free0 (_result_);
#line 965 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
											return NULL;
#line 9820 "tracker-sparql-query.c"
										} else {
#line 965 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
											_g_free0 (_result_);
#line 965 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 965 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
											g_clear_error (&_inner_error_);
#line 965 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
											return NULL;
#line 9830 "tracker-sparql-query.c"
										}
									}
#line 966 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									_tmp50_ = g_strdup ("null");
#line 966 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									_g_free0 (_result_);
#line 966 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									_result_ = _tmp50_;
#line 967 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									_vala_is_null = TRUE;
#line 9841 "tracker-sparql-query.c"
								} else {
									TrackerSparqlTokenType _tmp51_;
#line 968 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									_tmp51_ = tracker_sparql_query_current (self);
#line 968 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									if (_tmp51_ == TRACKER_SPARQL_TOKEN_TYPE_DECIMAL) {
#line 9848 "tracker-sparql-query.c"
										gchar* _tmp52_;
#line 969 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
										tracker_sparql_query_next (self, &_inner_error_);
#line 969 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
										if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 969 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
											if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 969 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
												g_propagate_error (error, _inner_error_);
#line 969 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
												_g_free0 (_result_);
#line 969 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
												return NULL;
#line 9862 "tracker-sparql-query.c"
											} else {
#line 969 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
												_g_free0 (_result_);
#line 969 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 969 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
												g_clear_error (&_inner_error_);
#line 969 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
												return NULL;
#line 9872 "tracker-sparql-query.c"
											}
										}
#line 970 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
										_tmp52_ = tracker_sparql_query_get_last_string (self, 0);
#line 970 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
										_g_free0 (_result_);
#line 970 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
										_result_ = _tmp52_;
#line 9881 "tracker-sparql-query.c"
									} else {
										TrackerSparqlTokenType _tmp53_;
#line 971 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
										_tmp53_ = tracker_sparql_query_current (self);
#line 971 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
										if (_tmp53_ == TRACKER_SPARQL_TOKEN_TYPE_DOUBLE) {
#line 9888 "tracker-sparql-query.c"
											gchar* _tmp54_;
#line 972 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
											tracker_sparql_query_next (self, &_inner_error_);
#line 972 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
											if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 972 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
												if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 972 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
													g_propagate_error (error, _inner_error_);
#line 972 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
													_g_free0 (_result_);
#line 972 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
													return NULL;
#line 9902 "tracker-sparql-query.c"
												} else {
#line 972 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
													_g_free0 (_result_);
#line 972 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 972 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
													g_clear_error (&_inner_error_);
#line 972 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
													return NULL;
#line 9912 "tracker-sparql-query.c"
												}
											}
#line 973 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
											_tmp54_ = tracker_sparql_query_get_last_string (self, 0);
#line 973 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
											_g_free0 (_result_);
#line 973 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
											_result_ = _tmp54_;
#line 9921 "tracker-sparql-query.c"
										} else {
											TrackerSparqlTokenType _tmp55_;
#line 974 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
											_tmp55_ = tracker_sparql_query_current (self);
#line 974 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
											if (_tmp55_ == TRACKER_SPARQL_TOKEN_TYPE_TRUE) {
#line 9928 "tracker-sparql-query.c"
												gchar* _tmp56_;
#line 975 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
												tracker_sparql_query_next (self, &_inner_error_);
#line 975 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
												if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 975 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
													if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 975 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
														g_propagate_error (error, _inner_error_);
#line 975 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
														_g_free0 (_result_);
#line 975 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
														return NULL;
#line 9942 "tracker-sparql-query.c"
													} else {
#line 975 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
														_g_free0 (_result_);
#line 975 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 975 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
														g_clear_error (&_inner_error_);
#line 975 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
														return NULL;
#line 9952 "tracker-sparql-query.c"
													}
												}
#line 976 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
												_tmp56_ = g_strdup ("true");
#line 976 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
												_g_free0 (_result_);
#line 976 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
												_result_ = _tmp56_;
#line 9961 "tracker-sparql-query.c"
											} else {
												TrackerSparqlTokenType _tmp57_;
#line 977 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
												_tmp57_ = tracker_sparql_query_current (self);
#line 977 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
												if (_tmp57_ == TRACKER_SPARQL_TOKEN_TYPE_FALSE) {
#line 9968 "tracker-sparql-query.c"
													gchar* _tmp58_;
#line 978 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
													tracker_sparql_query_next (self, &_inner_error_);
#line 978 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
													if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 978 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
														if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 978 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
															g_propagate_error (error, _inner_error_);
#line 978 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
															_g_free0 (_result_);
#line 978 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
															return NULL;
#line 9982 "tracker-sparql-query.c"
														} else {
#line 978 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
															_g_free0 (_result_);
#line 978 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 978 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
															g_clear_error (&_inner_error_);
#line 978 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
															return NULL;
#line 9992 "tracker-sparql-query.c"
														}
													}
#line 979 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
													_tmp58_ = g_strdup ("false");
#line 979 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
													_g_free0 (_result_);
#line 979 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
													_result_ = _tmp58_;
#line 10001 "tracker-sparql-query.c"
												} else {
													TrackerSparqlTokenType _tmp59_;
#line 980 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
													_tmp59_ = tracker_sparql_query_current (self);
#line 980 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
													if (_tmp59_ == TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1) {
#line 10008 "tracker-sparql-query.c"
														gchar* _tmp60_ = NULL;
														TrackerSparqlExpression* _tmp61_;
														gchar* _tmp62_;
														gchar* _tmp63_;
#line 981 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
														_tmp61_ = self->expression;
#line 981 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
														_tmp62_ = tracker_sparql_expression_parse_string_literal (_tmp61_, NULL, &_inner_error_);
#line 981 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
														_tmp60_ = _tmp62_;
#line 981 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
														if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 981 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
															if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 981 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																g_propagate_error (error, _inner_error_);
#line 981 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																_g_free0 (_result_);
#line 981 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																return NULL;
#line 10029 "tracker-sparql-query.c"
															} else {
#line 981 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																_g_free0 (_result_);
#line 981 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 981 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																g_clear_error (&_inner_error_);
#line 981 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																return NULL;
#line 10039 "tracker-sparql-query.c"
															}
														}
#line 981 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
														_tmp63_ = _tmp60_;
#line 981 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
														_tmp60_ = NULL;
#line 981 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
														_g_free0 (_result_);
#line 981 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
														_result_ = _tmp63_;
#line 980 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
														_g_free0 (_tmp60_);
#line 10052 "tracker-sparql-query.c"
													} else {
														TrackerSparqlTokenType _tmp64_;
#line 982 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
														_tmp64_ = tracker_sparql_query_current (self);
#line 982 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
														if (_tmp64_ == TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2) {
#line 10059 "tracker-sparql-query.c"
															gchar* _tmp65_ = NULL;
															TrackerSparqlExpression* _tmp66_;
															gchar* _tmp67_;
															gchar* _tmp68_;
#line 983 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
															_tmp66_ = self->expression;
#line 983 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
															_tmp67_ = tracker_sparql_expression_parse_string_literal (_tmp66_, NULL, &_inner_error_);
#line 983 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
															_tmp65_ = _tmp67_;
#line 983 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
															if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 983 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 983 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																	g_propagate_error (error, _inner_error_);
#line 983 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																	_g_free0 (_result_);
#line 983 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																	return NULL;
#line 10080 "tracker-sparql-query.c"
																} else {
#line 983 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																	_g_free0 (_result_);
#line 983 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 983 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																	g_clear_error (&_inner_error_);
#line 983 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																	return NULL;
#line 10090 "tracker-sparql-query.c"
																}
															}
#line 983 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
															_tmp68_ = _tmp65_;
#line 983 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
															_tmp65_ = NULL;
#line 983 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
															_g_free0 (_result_);
#line 983 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
															_result_ = _tmp68_;
#line 982 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
															_g_free0 (_tmp65_);
#line 10103 "tracker-sparql-query.c"
														} else {
															TrackerSparqlTokenType _tmp69_;
#line 984 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
															_tmp69_ = tracker_sparql_query_current (self);
#line 984 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
															if (_tmp69_ == TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1) {
#line 10110 "tracker-sparql-query.c"
																gchar* _tmp70_ = NULL;
																TrackerSparqlExpression* _tmp71_;
																gchar* _tmp72_;
																gchar* _tmp73_;
#line 985 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																_tmp71_ = self->expression;
#line 985 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																_tmp72_ = tracker_sparql_expression_parse_string_literal (_tmp71_, NULL, &_inner_error_);
#line 985 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																_tmp70_ = _tmp72_;
#line 985 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 985 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																	if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 985 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		g_propagate_error (error, _inner_error_);
#line 985 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		_g_free0 (_result_);
#line 985 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		return NULL;
#line 10131 "tracker-sparql-query.c"
																	} else {
#line 985 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		_g_free0 (_result_);
#line 985 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 985 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		g_clear_error (&_inner_error_);
#line 985 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		return NULL;
#line 10141 "tracker-sparql-query.c"
																	}
																}
#line 985 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																_tmp73_ = _tmp70_;
#line 985 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																_tmp70_ = NULL;
#line 985 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																_g_free0 (_result_);
#line 985 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																_result_ = _tmp73_;
#line 984 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																_g_free0 (_tmp70_);
#line 10154 "tracker-sparql-query.c"
															} else {
																TrackerSparqlTokenType _tmp74_;
#line 986 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																_tmp74_ = tracker_sparql_query_current (self);
#line 986 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																if (_tmp74_ == TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2) {
#line 10161 "tracker-sparql-query.c"
																	gchar* _tmp75_ = NULL;
																	TrackerSparqlExpression* _tmp76_;
																	gchar* _tmp77_;
																	gchar* _tmp78_;
#line 987 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																	_tmp76_ = self->expression;
#line 987 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																	_tmp77_ = tracker_sparql_expression_parse_string_literal (_tmp76_, NULL, &_inner_error_);
#line 987 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																	_tmp75_ = _tmp77_;
#line 987 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 987 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 987 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																			g_propagate_error (error, _inner_error_);
#line 987 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																			_g_free0 (_result_);
#line 987 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																			return NULL;
#line 10182 "tracker-sparql-query.c"
																		} else {
#line 987 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																			_g_free0 (_result_);
#line 987 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 987 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																			g_clear_error (&_inner_error_);
#line 987 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																			return NULL;
#line 10192 "tracker-sparql-query.c"
																		}
																	}
#line 987 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																	_tmp78_ = _tmp75_;
#line 987 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																	_tmp75_ = NULL;
#line 987 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																	_g_free0 (_result_);
#line 987 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																	_result_ = _tmp78_;
#line 986 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																	_g_free0 (_tmp75_);
#line 10205 "tracker-sparql-query.c"
																} else {
																	TrackerSparqlTokenType _tmp79_;
#line 988 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																	_tmp79_ = tracker_sparql_query_current (self);
#line 988 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																	if (_tmp79_ == TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET) {
#line 10212 "tracker-sparql-query.c"
																		gboolean _tmp80_;
																		gchar* _tmp82_;
																		gchar* old_subject = NULL;
																		const gchar* _tmp83_;
																		gchar* _tmp84_;
																		gboolean old_subject_is_var = FALSE;
																		gboolean _tmp85_;
																		const gchar* _tmp86_;
																		gchar* _tmp87_;
																		TrackerSparqlSolution* _tmp88_;
																		TrackerSparqlUpdateType _tmp89_;
																		const gchar* _tmp90_;
																		gchar* _tmp91_;
																		gboolean _tmp92_;
#line 990 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		_tmp80_ = self->priv->anon_blank_node_open;
#line 990 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		if (_tmp80_) {
#line 10231 "tracker-sparql-query.c"
																			GError* _tmp81_;
#line 991 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																			_tmp81_ = tracker_sparql_query_get_error (self, "no support for nested anonymous blank nodes");
#line 991 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																			_inner_error_ = _tmp81_;
#line 991 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																			if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 991 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																				g_propagate_error (error, _inner_error_);
#line 991 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																				_g_free0 (_result_);
#line 991 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																				return NULL;
#line 10245 "tracker-sparql-query.c"
																			} else {
#line 991 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																				_g_free0 (_result_);
#line 991 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 991 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																				g_clear_error (&_inner_error_);
#line 991 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																				return NULL;
#line 10255 "tracker-sparql-query.c"
																			}
																		}
#line 994 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		self->priv->anon_blank_node_open = TRUE;
#line 995 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		tracker_sparql_query_next (self, &_inner_error_);
#line 995 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 995 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																			if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 995 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																				g_propagate_error (error, _inner_error_);
#line 995 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																				_g_free0 (_result_);
#line 995 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																				return NULL;
#line 10272 "tracker-sparql-query.c"
																			} else {
#line 995 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																				_g_free0 (_result_);
#line 995 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 995 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																				g_clear_error (&_inner_error_);
#line 995 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																				return NULL;
#line 10282 "tracker-sparql-query.c"
																			}
																		}
#line 997 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		_tmp82_ = tracker_sparql_query_generate_bnodeid (self, NULL);
#line 997 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		_g_free0 (_result_);
#line 997 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		_result_ = _tmp82_;
#line 999 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		_tmp83_ = self->priv->current_subject;
#line 999 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		_tmp84_ = g_strdup (_tmp83_);
#line 999 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		old_subject = _tmp84_;
#line 1000 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		_tmp85_ = self->priv->current_subject_is_var;
#line 1000 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		old_subject_is_var = _tmp85_;
#line 1002 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		_tmp86_ = _result_;
#line 1002 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		_tmp87_ = g_strdup (_tmp86_);
#line 1002 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		_g_free0 (self->priv->current_subject);
#line 1002 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		self->priv->current_subject = _tmp87_;
#line 1003 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		_tmp88_ = var_value_map;
#line 1003 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		_tmp89_ = type;
#line 1003 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		tracker_sparql_query_parse_construct_property_list_not_empty (self, _tmp88_, _tmp89_, &_inner_error_);
#line 1003 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1003 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																			if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 1003 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																				g_propagate_error (error, _inner_error_);
#line 1003 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																				_g_free0 (old_subject);
#line 1003 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																				_g_free0 (_result_);
#line 1003 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																				return NULL;
#line 10327 "tracker-sparql-query.c"
																			} else {
#line 1003 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																				_g_free0 (old_subject);
#line 1003 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																				_g_free0 (_result_);
#line 1003 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1003 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																				g_clear_error (&_inner_error_);
#line 1003 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																				return NULL;
#line 10339 "tracker-sparql-query.c"
																			}
																		}
#line 1004 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACKET, &_inner_error_);
#line 1004 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1004 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																			if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 1004 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																				g_propagate_error (error, _inner_error_);
#line 1004 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																				_g_free0 (old_subject);
#line 1004 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																				_g_free0 (_result_);
#line 1004 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																				return NULL;
#line 10356 "tracker-sparql-query.c"
																			} else {
#line 1004 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																				_g_free0 (old_subject);
#line 1004 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																				_g_free0 (_result_);
#line 1004 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1004 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																				g_clear_error (&_inner_error_);
#line 1004 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																				return NULL;
#line 10368 "tracker-sparql-query.c"
																			}
																		}
#line 1005 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		self->priv->anon_blank_node_open = FALSE;
#line 1007 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		_tmp90_ = old_subject;
#line 1007 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		_tmp91_ = g_strdup (_tmp90_);
#line 1007 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		_g_free0 (self->priv->current_subject);
#line 1007 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		self->priv->current_subject = _tmp91_;
#line 1008 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		_tmp92_ = old_subject_is_var;
#line 1008 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		self->priv->current_subject_is_var = _tmp92_;
#line 988 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		_g_free0 (old_subject);
#line 10387 "tracker-sparql-query.c"
																	} else {
																		GError* _tmp93_;
#line 1010 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		_tmp93_ = tracker_sparql_query_get_error (self, "expected variable or term");
#line 1010 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		_inner_error_ = _tmp93_;
#line 1010 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																		if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 1010 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																			g_propagate_error (error, _inner_error_);
#line 1010 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																			_g_free0 (_result_);
#line 1010 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																			return NULL;
#line 10402 "tracker-sparql-query.c"
																		} else {
#line 1010 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																			_g_free0 (_result_);
#line 1010 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1010 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																			g_clear_error (&_inner_error_);
#line 1010 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
																			return NULL;
#line 10412 "tracker-sparql-query.c"
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
#line 1012 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	result = _result_;
#line 1012 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (is_null) {
#line 1012 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		*is_null = _vala_is_null;
#line 10437 "tracker-sparql-query.c"
	}
#line 1012 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return result;
#line 10441 "tracker-sparql-query.c"
}


static void tracker_sparql_query_parse_construct_property_list_not_empty (TrackerSparqlQuery* self, TrackerSparqlSolution* var_value_map, TrackerSparqlUpdateType type, GError** error) {
	GError * _inner_error_ = NULL;
#line 1015 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_if_fail (self != NULL);
#line 1015 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_if_fail (var_value_map != NULL);
#line 1016 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	while (TRUE) {
#line 10453 "tracker-sparql-query.c"
		gchar* old_predicate = NULL;
		const gchar* _tmp0_;
		gchar* _tmp1_;
		TrackerSparqlTokenType _tmp2_;
		TrackerSparqlSolution* _tmp34_;
		TrackerSparqlUpdateType _tmp35_;
		const gchar* _tmp36_;
		gchar* _tmp37_;
		gboolean _tmp38_ = FALSE;
		gboolean _tmp39_;
#line 1017 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp0_ = self->priv->current_predicate;
#line 1017 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp1_ = g_strdup (_tmp0_);
#line 1017 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		old_predicate = _tmp1_;
#line 1019 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_free0 (self->priv->current_predicate);
#line 1019 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		self->priv->current_predicate = NULL;
#line 1020 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp2_ = tracker_sparql_query_current (self);
#line 1020 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (_tmp2_ == TRACKER_SPARQL_TOKEN_TYPE_VAR) {
#line 10478 "tracker-sparql-query.c"
			TrackerSparqlSolution* _tmp3_;
			gchar* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
#line 1021 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			self->priv->current_predicate_is_var = TRUE;
#line 1022 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			tracker_sparql_query_next (self, &_inner_error_);
#line 1022 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1022 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 1022 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_propagate_error (error, _inner_error_);
#line 1022 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (old_predicate);
#line 1022 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return;
#line 10499 "tracker-sparql-query.c"
				} else {
#line 1022 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (old_predicate);
#line 1022 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1022 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_clear_error (&_inner_error_);
#line 1022 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return;
#line 10509 "tracker-sparql-query.c"
				}
			}
#line 1023 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp3_ = var_value_map;
#line 1023 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp4_ = tracker_sparql_query_get_last_string (self, 0);
#line 1023 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp5_ = _tmp4_;
#line 1023 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp6_ = string_substring (_tmp5_, (glong) 1, (glong) -1);
#line 1023 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp7_ = _tmp6_;
#line 1023 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp8_ = tracker_sparql_solution_lookup (_tmp3_, _tmp7_);
#line 1023 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_free0 (self->priv->current_predicate);
#line 1023 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			self->priv->current_predicate = _tmp8_;
#line 1023 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_free0 (_tmp7_);
#line 1023 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_free0 (_tmp5_);
#line 10532 "tracker-sparql-query.c"
		} else {
			TrackerSparqlTokenType _tmp9_;
#line 1024 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp9_ = tracker_sparql_query_current (self);
#line 1024 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (_tmp9_ == TRACKER_SPARQL_TOKEN_TYPE_IRI_REF) {
#line 10539 "tracker-sparql-query.c"
				gchar* _tmp10_;
#line 1025 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				tracker_sparql_query_next (self, &_inner_error_);
#line 1025 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1025 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 1025 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_propagate_error (error, _inner_error_);
#line 1025 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (old_predicate);
#line 1025 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						return;
#line 10553 "tracker-sparql-query.c"
					} else {
#line 1025 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (old_predicate);
#line 1025 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1025 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_clear_error (&_inner_error_);
#line 1025 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						return;
#line 10563 "tracker-sparql-query.c"
					}
				}
#line 1026 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp10_ = tracker_sparql_query_get_last_string (self, 1);
#line 1026 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_free0 (self->priv->current_predicate);
#line 1026 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				self->priv->current_predicate = _tmp10_;
#line 10572 "tracker-sparql-query.c"
			} else {
				TrackerSparqlTokenType _tmp11_;
#line 1027 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp11_ = tracker_sparql_query_current (self);
#line 1027 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if (_tmp11_ == TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX) {
#line 10579 "tracker-sparql-query.c"
					gchar* ns = NULL;
					gchar* _tmp12_;
					gchar* _tmp13_ = NULL;
					const gchar* _tmp14_;
					gchar* _tmp15_;
					gchar* _tmp16_;
					gchar* _tmp17_;
					gchar* _tmp18_;
					gchar* _tmp19_;
					gchar* _tmp20_;
					gchar* _tmp21_;
#line 1028 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					tracker_sparql_query_next (self, &_inner_error_);
#line 1028 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1028 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 1028 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							g_propagate_error (error, _inner_error_);
#line 1028 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_g_free0 (old_predicate);
#line 1028 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							return;
#line 10603 "tracker-sparql-query.c"
						} else {
#line 1028 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_g_free0 (old_predicate);
#line 1028 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1028 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							g_clear_error (&_inner_error_);
#line 1028 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							return;
#line 10613 "tracker-sparql-query.c"
						}
					}
#line 1029 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp12_ = tracker_sparql_query_get_last_string (self, 0);
#line 1029 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					ns = _tmp12_;
#line 1030 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
#line 1030 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1030 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 1030 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							g_propagate_error (error, _inner_error_);
#line 1030 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_g_free0 (ns);
#line 1030 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_g_free0 (old_predicate);
#line 1030 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							return;
#line 10634 "tracker-sparql-query.c"
						} else {
#line 1030 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_g_free0 (ns);
#line 1030 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_g_free0 (old_predicate);
#line 1030 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1030 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							g_clear_error (&_inner_error_);
#line 1030 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							return;
#line 10646 "tracker-sparql-query.c"
						}
					}
#line 1031 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp14_ = ns;
#line 1031 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp15_ = tracker_sparql_query_get_last_string (self, 0);
#line 1031 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp16_ = _tmp15_;
#line 1031 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp17_ = string_substring (_tmp16_, (glong) 1, (glong) -1);
#line 1031 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp18_ = _tmp17_;
#line 1031 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp19_ = tracker_sparql_query_resolve_prefixed_name (self, _tmp14_, _tmp18_, &_inner_error_);
#line 1031 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp20_ = _tmp19_;
#line 1031 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (_tmp18_);
#line 1031 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (_tmp16_);
#line 1031 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp13_ = _tmp20_;
#line 1031 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1031 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 1031 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							g_propagate_error (error, _inner_error_);
#line 1031 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_g_free0 (ns);
#line 1031 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_g_free0 (old_predicate);
#line 1031 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							return;
#line 10681 "tracker-sparql-query.c"
						} else {
#line 1031 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_g_free0 (ns);
#line 1031 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_g_free0 (old_predicate);
#line 1031 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1031 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							g_clear_error (&_inner_error_);
#line 1031 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							return;
#line 10693 "tracker-sparql-query.c"
						}
					}
#line 1031 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp21_ = _tmp13_;
#line 1031 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp13_ = NULL;
#line 1031 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (self->priv->current_predicate);
#line 1031 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					self->priv->current_predicate = _tmp21_;
#line 1027 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (_tmp13_);
#line 1027 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (ns);
#line 10708 "tracker-sparql-query.c"
				} else {
					TrackerSparqlTokenType _tmp22_;
#line 1032 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp22_ = tracker_sparql_query_current (self);
#line 1032 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if (_tmp22_ == TRACKER_SPARQL_TOKEN_TYPE_COLON) {
#line 10715 "tracker-sparql-query.c"
						gchar* _tmp23_ = NULL;
						gchar* _tmp24_;
						gchar* _tmp25_;
						gchar* _tmp26_;
						gchar* _tmp27_;
						gchar* _tmp28_;
						gchar* _tmp29_;
						gchar* _tmp30_;
#line 1033 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						tracker_sparql_query_next (self, &_inner_error_);
#line 1033 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1033 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 1033 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								g_propagate_error (error, _inner_error_);
#line 1033 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_g_free0 (old_predicate);
#line 1033 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								return;
#line 10736 "tracker-sparql-query.c"
							} else {
#line 1033 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_g_free0 (old_predicate);
#line 1033 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1033 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								g_clear_error (&_inner_error_);
#line 1033 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								return;
#line 10746 "tracker-sparql-query.c"
							}
						}
#line 1034 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp24_ = tracker_sparql_query_get_last_string (self, 0);
#line 1034 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp25_ = _tmp24_;
#line 1034 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp26_ = string_substring (_tmp25_, (glong) 1, (glong) -1);
#line 1034 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp27_ = _tmp26_;
#line 1034 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp28_ = tracker_sparql_query_resolve_prefixed_name (self, "", _tmp27_, &_inner_error_);
#line 1034 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp29_ = _tmp28_;
#line 1034 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (_tmp27_);
#line 1034 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (_tmp25_);
#line 1034 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp23_ = _tmp29_;
#line 1034 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1034 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 1034 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								g_propagate_error (error, _inner_error_);
#line 1034 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_g_free0 (old_predicate);
#line 1034 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								return;
#line 10777 "tracker-sparql-query.c"
							} else {
#line 1034 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_g_free0 (old_predicate);
#line 1034 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1034 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								g_clear_error (&_inner_error_);
#line 1034 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								return;
#line 10787 "tracker-sparql-query.c"
							}
						}
#line 1034 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp30_ = _tmp23_;
#line 1034 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp23_ = NULL;
#line 1034 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (self->priv->current_predicate);
#line 1034 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						self->priv->current_predicate = _tmp30_;
#line 1032 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (_tmp23_);
#line 10800 "tracker-sparql-query.c"
					} else {
						TrackerSparqlTokenType _tmp31_;
#line 1035 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp31_ = tracker_sparql_query_current (self);
#line 1035 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						if (_tmp31_ == TRACKER_SPARQL_TOKEN_TYPE_A) {
#line 10807 "tracker-sparql-query.c"
							gchar* _tmp32_;
#line 1036 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							tracker_sparql_query_next (self, &_inner_error_);
#line 1036 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1036 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 1036 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									g_propagate_error (error, _inner_error_);
#line 1036 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									_g_free0 (old_predicate);
#line 1036 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									return;
#line 10821 "tracker-sparql-query.c"
								} else {
#line 1036 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									_g_free0 (old_predicate);
#line 1036 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1036 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									g_clear_error (&_inner_error_);
#line 1036 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
									return;
#line 10831 "tracker-sparql-query.c"
								}
							}
#line 1037 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_tmp32_ = g_strdup ("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
#line 1037 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_g_free0 (self->priv->current_predicate);
#line 1037 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							self->priv->current_predicate = _tmp32_;
#line 10840 "tracker-sparql-query.c"
						} else {
							GError* _tmp33_;
#line 1039 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_tmp33_ = tracker_sparql_query_get_error (self, "expected non-empty property list");
#line 1039 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							_inner_error_ = _tmp33_;
#line 1039 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
							if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 1039 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								g_propagate_error (error, _inner_error_);
#line 1039 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_g_free0 (old_predicate);
#line 1039 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								return;
#line 10855 "tracker-sparql-query.c"
							} else {
#line 1039 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								_g_free0 (old_predicate);
#line 1039 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1039 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								g_clear_error (&_inner_error_);
#line 1039 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
								return;
#line 10865 "tracker-sparql-query.c"
							}
						}
					}
				}
			}
		}
#line 1041 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp34_ = var_value_map;
#line 1041 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp35_ = type;
#line 1041 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		tracker_sparql_query_parse_construct_object_list (self, _tmp34_, _tmp35_, &_inner_error_);
#line 1041 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1041 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 1041 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 1041 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_free0 (old_predicate);
#line 1041 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 10888 "tracker-sparql-query.c"
			} else {
#line 1041 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_free0 (old_predicate);
#line 1041 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1041 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_clear_error (&_inner_error_);
#line 1041 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 10898 "tracker-sparql-query.c"
			}
		}
#line 1043 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp36_ = old_predicate;
#line 1043 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp37_ = g_strdup (_tmp36_);
#line 1043 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_free0 (self->priv->current_predicate);
#line 1043 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		self->priv->current_predicate = _tmp37_;
#line 1045 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp39_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON, &_inner_error_);
#line 1045 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp38_ = _tmp39_;
#line 1045 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1045 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 1045 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 1045 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_free0 (old_predicate);
#line 1045 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 10923 "tracker-sparql-query.c"
			} else {
#line 1045 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_free0 (old_predicate);
#line 1045 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1045 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_clear_error (&_inner_error_);
#line 1045 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 10933 "tracker-sparql-query.c"
			}
		}
#line 1045 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (_tmp38_) {
#line 1046 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_free0 (old_predicate);
#line 1046 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			continue;
#line 10942 "tracker-sparql-query.c"
		}
#line 1048 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_free0 (old_predicate);
#line 1048 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		break;
#line 10948 "tracker-sparql-query.c"
	}
}


static void tracker_sparql_query_parse_construct_object_list (TrackerSparqlQuery* self, TrackerSparqlSolution* var_value_map, TrackerSparqlUpdateType type, GError** error) {
	GError * _inner_error_ = NULL;
#line 1052 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_if_fail (self != NULL);
#line 1052 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_if_fail (var_value_map != NULL);
#line 1053 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	while (TRUE) {
#line 10961 "tracker-sparql-query.c"
		TrackerSparqlSolution* _tmp0_;
		TrackerSparqlUpdateType _tmp1_;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_;
#line 1054 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp0_ = var_value_map;
#line 1054 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp1_ = type;
#line 1054 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		tracker_sparql_query_parse_construct_object (self, _tmp0_, _tmp1_, &_inner_error_);
#line 1054 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1054 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 1054 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 1054 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 10980 "tracker-sparql-query.c"
			} else {
#line 1054 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1054 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_clear_error (&_inner_error_);
#line 1054 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 10988 "tracker-sparql-query.c"
			}
		}
#line 1055 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp3_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 1055 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp2_ = _tmp3_;
#line 1055 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1055 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 1055 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_propagate_error (error, _inner_error_);
#line 1055 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 11003 "tracker-sparql-query.c"
			} else {
#line 1055 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1055 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_clear_error (&_inner_error_);
#line 1055 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 11011 "tracker-sparql-query.c"
			}
		}
#line 1055 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (_tmp2_) {
#line 1056 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			continue;
#line 11018 "tracker-sparql-query.c"
		}
#line 1058 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		break;
#line 11022 "tracker-sparql-query.c"
	}
}


static gpointer _g_error_copy0 (gpointer self) {
#line 1090 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return self ? g_error_copy (self) : NULL;
#line 11030 "tracker-sparql-query.c"
}


static void tracker_sparql_query_parse_construct_object (TrackerSparqlQuery* self, TrackerSparqlSolution* var_value_map, TrackerSparqlUpdateType type, GError** error) {
	gboolean is_null = FALSE;
	gchar* object = NULL;
	TrackerSparqlSolution* _tmp0_;
	TrackerSparqlUpdateType _tmp1_;
	gboolean _tmp2_ = FALSE;
	gchar* _tmp3_;
	TrackerData* data = NULL;
	TrackerDataManager* _tmp4_;
	TrackerData* _tmp5_;
	TrackerData* _tmp6_;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp9_;
	GError * _inner_error_ = NULL;
#line 1062 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_if_fail (self != NULL);
#line 1062 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_if_fail (var_value_map != NULL);
#line 1063 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	is_null = FALSE;
#line 1064 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = var_value_map;
#line 1064 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp1_ = type;
#line 1064 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp3_ = tracker_sparql_query_parse_construct_var_or_term (self, _tmp0_, _tmp1_, &_tmp2_, &_inner_error_);
#line 1064 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	is_null = _tmp2_;
#line 1064 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	object = _tmp3_;
#line 1064 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1064 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 1064 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_propagate_error (error, _inner_error_);
#line 1064 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return;
#line 11073 "tracker-sparql-query.c"
		} else {
#line 1064 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1064 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_clear_error (&_inner_error_);
#line 1064 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return;
#line 11081 "tracker-sparql-query.c"
		}
	}
#line 1065 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp4_ = self->manager;
#line 1065 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp5_ = tracker_data_manager_get_data (_tmp4_);
#line 1065 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 1065 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	data = _tmp6_;
#line 1066 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp9_ = self->priv->current_subject;
#line 1066 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (_tmp9_ == NULL) {
#line 1066 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp8_ = TRUE;
#line 11098 "tracker-sparql-query.c"
	} else {
		const gchar* _tmp10_;
#line 1066 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp10_ = self->priv->current_predicate;
#line 1066 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp8_ = _tmp10_ == NULL;
#line 11105 "tracker-sparql-query.c"
	}
#line 1066 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (_tmp8_) {
#line 1066 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp7_ = TRUE;
#line 11111 "tracker-sparql-query.c"
	} else {
		const gchar* _tmp11_;
#line 1066 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp11_ = object;
#line 1066 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp7_ = _tmp11_ == NULL;
#line 11118 "tracker-sparql-query.c"
	}
#line 1066 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (_tmp7_) {
#line 1069 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_object_unref0 (data);
#line 1069 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_free0 (object);
#line 1069 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		return;
#line 11128 "tracker-sparql-query.c"
	}
	{
		TrackerSparqlUpdateType _tmp12_;
#line 1072 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp12_ = type;
#line 1072 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (_tmp12_ == TRACKER_SPARQL_UPDATE_TYPE_UPDATE) {
#line 11136 "tracker-sparql-query.c"
			const gchar* _tmp13_ = NULL;
			gboolean _tmp14_;
			TrackerData* _tmp16_;
			const gchar* _tmp17_;
			const gchar* _tmp18_;
			const gchar* _tmp19_;
#line 1074 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp14_ = is_null;
#line 1074 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (_tmp14_) {
#line 1074 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp13_ = NULL;
#line 11149 "tracker-sparql-query.c"
			} else {
				const gchar* _tmp15_;
#line 1074 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp15_ = object;
#line 1074 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp13_ = _tmp15_;
#line 11156 "tracker-sparql-query.c"
			}
#line 1074 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp16_ = data;
#line 1074 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp17_ = self->priv->current_graph;
#line 1074 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp18_ = self->priv->current_subject;
#line 1074 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp19_ = self->priv->current_predicate;
#line 1074 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			tracker_data_update_statement (_tmp16_, _tmp17_, _tmp18_, _tmp19_, _tmp13_, &_inner_error_);
#line 1074 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1074 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 11172 "tracker-sparql-query.c"
					goto __catch3_tracker_sparql_error;
				}
#line 1074 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if (_inner_error_->domain == TRACKER_DATE_ERROR) {
#line 11177 "tracker-sparql-query.c"
					goto __catch3_tracker_date_error;
				}
#line 1074 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_object_unref0 (data);
#line 1074 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_g_free0 (object);
#line 1074 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1074 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				g_clear_error (&_inner_error_);
#line 1074 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				return;
#line 11190 "tracker-sparql-query.c"
			}
		} else {
			TrackerSparqlUpdateType _tmp20_;
#line 1075 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp20_ = type;
#line 1075 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			if (_tmp20_ == TRACKER_SPARQL_UPDATE_TYPE_DELETE) {
#line 11198 "tracker-sparql-query.c"
				gboolean _tmp21_;
				TrackerData* _tmp23_;
				const gchar* _tmp24_;
				const gchar* _tmp25_;
				const gchar* _tmp26_;
				const gchar* _tmp27_;
#line 1077 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp21_ = is_null;
#line 1077 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if (_tmp21_) {
#line 11209 "tracker-sparql-query.c"
					GError* _tmp22_;
#line 1078 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp22_ = tracker_sparql_query_get_error (self, "'null' not supported in this mode");
#line 1078 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_inner_error_ = _tmp22_;
#line 1078 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 11217 "tracker-sparql-query.c"
						goto __catch3_tracker_sparql_error;
					}
#line 1078 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if (_inner_error_->domain == TRACKER_DATE_ERROR) {
#line 11222 "tracker-sparql-query.c"
						goto __catch3_tracker_date_error;
					}
#line 1078 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_object_unref0 (data);
#line 1078 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (object);
#line 1078 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1078 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_clear_error (&_inner_error_);
#line 1078 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return;
#line 11235 "tracker-sparql-query.c"
				}
#line 1080 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp23_ = data;
#line 1080 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp24_ = self->priv->current_graph;
#line 1080 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp25_ = self->priv->current_subject;
#line 1080 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp26_ = self->priv->current_predicate;
#line 1080 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp27_ = object;
#line 1080 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				tracker_data_delete_statement (_tmp23_, _tmp24_, _tmp25_, _tmp26_, _tmp27_, &_inner_error_);
#line 1080 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1080 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 11253 "tracker-sparql-query.c"
						goto __catch3_tracker_sparql_error;
					}
#line 1080 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if (_inner_error_->domain == TRACKER_DATE_ERROR) {
#line 11258 "tracker-sparql-query.c"
						goto __catch3_tracker_date_error;
					}
#line 1080 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_object_unref0 (data);
#line 1080 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_g_free0 (object);
#line 1080 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1080 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					g_clear_error (&_inner_error_);
#line 1080 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					return;
#line 11271 "tracker-sparql-query.c"
				}
			} else {
				TrackerSparqlUpdateType _tmp28_;
#line 1081 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				_tmp28_ = type;
#line 1081 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
				if (_tmp28_ == TRACKER_SPARQL_UPDATE_TYPE_INSERT) {
#line 11279 "tracker-sparql-query.c"
					gboolean _tmp29_;
					TrackerData* _tmp31_;
					const gchar* _tmp32_;
					const gchar* _tmp33_;
					const gchar* _tmp34_;
					const gchar* _tmp35_;
#line 1083 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp29_ = is_null;
#line 1083 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if (_tmp29_) {
#line 11290 "tracker-sparql-query.c"
						GError* _tmp30_;
#line 1084 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_tmp30_ = tracker_sparql_query_get_error (self, "'null' not supported in this mode");
#line 1084 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_inner_error_ = _tmp30_;
#line 1084 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 11298 "tracker-sparql-query.c"
							goto __catch3_tracker_sparql_error;
						}
#line 1084 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						if (_inner_error_->domain == TRACKER_DATE_ERROR) {
#line 11303 "tracker-sparql-query.c"
							goto __catch3_tracker_date_error;
						}
#line 1084 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_object_unref0 (data);
#line 1084 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (object);
#line 1084 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1084 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_clear_error (&_inner_error_);
#line 1084 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						return;
#line 11316 "tracker-sparql-query.c"
					}
#line 1086 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp31_ = data;
#line 1086 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp32_ = self->priv->current_graph;
#line 1086 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp33_ = self->priv->current_subject;
#line 1086 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp34_ = self->priv->current_predicate;
#line 1086 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					_tmp35_ = object;
#line 1086 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					tracker_data_insert_statement (_tmp31_, _tmp32_, _tmp33_, _tmp34_, _tmp35_, &_inner_error_);
#line 1086 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1086 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 11334 "tracker-sparql-query.c"
							goto __catch3_tracker_sparql_error;
						}
#line 1086 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						if (_inner_error_->domain == TRACKER_DATE_ERROR) {
#line 11339 "tracker-sparql-query.c"
							goto __catch3_tracker_date_error;
						}
#line 1086 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_object_unref0 (data);
#line 1086 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						_g_free0 (object);
#line 1086 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1086 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						g_clear_error (&_inner_error_);
#line 1086 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
						return;
#line 11352 "tracker-sparql-query.c"
					}
				}
			}
		}
	}
	goto __finally3;
	__catch3_tracker_sparql_error:
	{
		GError* e = NULL;
		gboolean _tmp36_;
#line 1071 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		e = _inner_error_;
#line 1071 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_inner_error_ = NULL;
#line 1089 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp36_ = self->priv->silent;
#line 1089 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (!_tmp36_) {
#line 11371 "tracker-sparql-query.c"
			GError* _tmp37_;
			GError* _tmp38_;
#line 1090 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp37_ = e;
#line 1090 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp38_ = _g_error_copy0 (_tmp37_);
#line 1090 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_inner_error_ = _tmp38_;
#line 1090 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_error_free0 (e);
#line 11382 "tracker-sparql-query.c"
			goto __finally3;
		}
#line 1071 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_error_free0 (e);
#line 11387 "tracker-sparql-query.c"
	}
	goto __finally3;
	__catch3_tracker_date_error:
	{
		GError* e = NULL;
		gboolean _tmp39_;
#line 1071 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		e = _inner_error_;
#line 1071 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_inner_error_ = NULL;
#line 1093 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp39_ = self->priv->silent;
#line 1093 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if (!_tmp39_) {
#line 11402 "tracker-sparql-query.c"
			GError* _tmp40_;
			const gchar* _tmp41_;
			GError* _tmp42_;
#line 1094 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp40_ = e;
#line 1094 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp41_ = _tmp40_->message;
#line 1094 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_tmp42_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_TYPE, _tmp41_);
#line 1094 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_inner_error_ = _tmp42_;
#line 1094 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_error_free0 (e);
#line 11416 "tracker-sparql-query.c"
			goto __finally3;
		}
#line 1071 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_g_error_free0 (e);
#line 11421 "tracker-sparql-query.c"
	}
	__finally3:
#line 1071 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1071 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
#line 1071 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_propagate_error (error, _inner_error_);
#line 1071 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_object_unref0 (data);
#line 1071 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_free0 (object);
#line 1071 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return;
#line 11436 "tracker-sparql-query.c"
		} else {
#line 1071 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_object_unref0 (data);
#line 1071 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			_g_free0 (object);
#line 1071 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1071 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			g_clear_error (&_inner_error_);
#line 1071 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
			return;
#line 11448 "tracker-sparql-query.c"
		}
	}
#line 1062 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_object_unref0 (data);
#line 1062 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_free0 (object);
#line 11455 "tracker-sparql-query.c"
}


gboolean tracker_sparql_query_get_no_cache (TrackerSparqlQuery* self) {
	gboolean result;
	gboolean _tmp0_;
#line 250 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 250 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tmp0_ = self->priv->_no_cache;
#line 250 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	result = _tmp0_;
#line 250 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return result;
#line 11470 "tracker-sparql-query.c"
}


void tracker_sparql_query_set_no_cache (TrackerSparqlQuery* self, gboolean value) {
#line 250 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_return_if_fail (self != NULL);
#line 250 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	if (tracker_sparql_query_get_no_cache (self) != value) {
#line 11479 "tracker-sparql-query.c"
		gboolean _tmp0_;
#line 250 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		_tmp0_ = value;
#line 250 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		self->priv->_no_cache = _tmp0_;
#line 250 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		g_object_notify ((GObject *) self, "no-cache");
#line 11487 "tracker-sparql-query.c"
	}
}


static TrackerSparqlQueryTokenInfo* tracker_sparql_query_token_info_dup (const TrackerSparqlQueryTokenInfo* self) {
	TrackerSparqlQueryTokenInfo* dup;
#line 210 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	dup = g_new0 (TrackerSparqlQueryTokenInfo, 1);
#line 210 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	memcpy (dup, self, sizeof (TrackerSparqlQueryTokenInfo));
#line 210 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	return dup;
#line 11500 "tracker-sparql-query.c"
}


static void tracker_sparql_query_token_info_free (TrackerSparqlQueryTokenInfo* self) {
#line 210 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_free (self);
#line 11507 "tracker-sparql-query.c"
}


static GType tracker_sparql_query_token_info_get_type (void) {
	static volatile gsize tracker_sparql_query_token_info_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_query_token_info_type_id__volatile)) {
		GType tracker_sparql_query_token_info_type_id;
		tracker_sparql_query_token_info_type_id = g_boxed_type_register_static ("TrackerSparqlQueryTokenInfo", (GBoxedCopyFunc) tracker_sparql_query_token_info_dup, (GBoxedFreeFunc) tracker_sparql_query_token_info_free);
		g_once_init_leave (&tracker_sparql_query_token_info_type_id__volatile, tracker_sparql_query_token_info_type_id);
	}
	return tracker_sparql_query_token_info_type_id__volatile;
}


static void tracker_sparql_query_class_init (TrackerSparqlQueryClass * klass) {
#line 198 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	tracker_sparql_query_parent_class = g_type_class_peek_parent (klass);
#line 198 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_type_class_add_private (klass, sizeof (TrackerSparqlQueryPrivate));
#line 198 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_tracker_sparql_query_get_property;
#line 198 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_tracker_sparql_query_set_property;
#line 198 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_query_finalize;
#line 198 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_SPARQL_QUERY_NO_CACHE, g_param_spec_boolean ("no-cache", "no-cache", "no-cache", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 11535 "tracker-sparql-query.c"
}


static void tracker_sparql_query_instance_init (TrackerSparqlQuery * self) {
#line 198 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->priv = TRACKER_SPARQL_QUERY_GET_PRIVATE (self);
#line 240 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->priv->bnodeid = 0;
#line 926 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->priv->anon_blank_node_open = FALSE;
#line 11546 "tracker-sparql-query.c"
}


static void tracker_sparql_query_finalize (GObject * obj) {
	TrackerSparqlQuery * self;
#line 198 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_SPARQL_TYPE_QUERY, TrackerSparqlQuery);
#line 199 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_object_unref0 (self->priv->scanner);
#line 202 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->priv->tokens = (g_free (self->priv->tokens), NULL);
#line 218 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_free0 (self->priv->query_string);
#line 221 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_object_unref0 (self->expression);
#line 222 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_object_unref0 (self->pattern);
#line 224 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_free0 (self->priv->current_graph);
#line 225 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_free0 (self->priv->current_subject);
#line 227 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_free0 (self->priv->current_predicate);
#line 233 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_hash_table_unref0 (self->priv->prefix_map);
#line 236 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	__g_list_free__g_object_unref0_0 (self->bindings);
#line 238 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_tracker_sparql_context_unref0 (self->context);
#line 242 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	self->priv->base_uuid = (g_free (self->priv->base_uuid), NULL);
#line 243 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_hash_table_unref0 (self->priv->blank_nodes);
#line 245 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	_g_object_unref0 (self->manager);
#line 198 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	G_OBJECT_CLASS (tracker_sparql_query_parent_class)->finalize (obj);
#line 11584 "tracker-sparql-query.c"
}


GType tracker_sparql_query_get_type (void) {
	static volatile gsize tracker_sparql_query_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_query_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlQueryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_query_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlQuery), 0, (GInstanceInitFunc) tracker_sparql_query_instance_init, NULL };
		GType tracker_sparql_query_type_id;
		tracker_sparql_query_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerSparqlQuery", &g_define_type_info, 0);
		g_once_init_leave (&tracker_sparql_query_type_id__volatile, tracker_sparql_query_type_id);
	}
	return tracker_sparql_query_type_id__volatile;
}


static void _vala_tracker_sparql_query_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TrackerSparqlQuery * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TRACKER_SPARQL_TYPE_QUERY, TrackerSparqlQuery);
#line 198 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	switch (property_id) {
#line 198 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		case TRACKER_SPARQL_QUERY_NO_CACHE:
#line 198 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		g_value_set_boolean (value, tracker_sparql_query_get_no_cache (self));
#line 198 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		break;
#line 11611 "tracker-sparql-query.c"
		default:
#line 198 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 198 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		break;
#line 11617 "tracker-sparql-query.c"
	}
}


static void _vala_tracker_sparql_query_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TrackerSparqlQuery * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TRACKER_SPARQL_TYPE_QUERY, TrackerSparqlQuery);
#line 198 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
	switch (property_id) {
#line 198 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		case TRACKER_SPARQL_QUERY_NO_CACHE:
#line 198 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		tracker_sparql_query_set_no_cache (self, g_value_get_boolean (value));
#line 198 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		break;
#line 11633 "tracker-sparql-query.c"
		default:
#line 198 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 198 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-query.vala"
		break;
#line 11639 "tracker-sparql-query.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



