/* This file is part of the KDE project

   Copyright (C) 2001 Lukas Tinkl <lukas@kde.org>
                      Andreas Schlapbach <schlpbch@iam.unibe.ch>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License version 2 as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#ifndef kimgalleryplugin_h
#define kimgalleryplugin_h

#include <qcheckbox.h>
#include <qlineedit.h>

#include <kparts/plugin.h>
#include <klibloader.h>

#include <kcolorbtn.h>
#include <kurlrequester.h>
#include <konq_dirpart.h>
#include <kio/jobclasses.h>
#include <kdialogbase.h>

class QProgressDialog;
class KURL;

class KIGPDialog : public KDialogBase
{
 Q_OBJECT

 public:
  KIGPDialog(QWidget *parent=0, const QString& path=0, const char *name=0 ); 
  ~KIGPDialog();

  const QString getURL();
  QString getTitle();
  bool getDialogOk();
  bool getCopyFiles();
  const QColor getBackgroundColor();
  const QColor getForegroundColor();

 protected slots:
  void slotOk();
  void slotCancel();

 private:
  const QString m_Path;

  KColorButton *fg_colorbutton;
  KColorButton *bg_colorbutton;

  QCheckBox *cp_local;
  QLineEdit *title_lineedit;

  KURLRequester *urlreq;
  bool gen_gallery;
};

class KImGalleryPlugin : public KParts::Plugin
{
 Q_OBJECT
 public:
  KImGalleryPlugin( QObject* parent, const char* name );
  ~KImGalleryPlugin() {}

 public slots:
  void slotExecute();
  void slotCancelled();

 private:
  bool m_cancelled;
  bool m_copyFiles;

  int m_imgWidth, m_imgHeight;
  KIGPDialog *m_configDlg;
  QProgressDialog *m_progressDlg;

  QString m_backColorName, m_foreColorName;
  QString m_textTitle;

  bool createHtml( const KURL& url );
  bool createThumb( const QString& imgName, const QString& sourceDir,
		    const QString& imgGalleryDir );
};

class KImGalleryPluginFactory : public KLibFactory
{
 Q_OBJECT
 public:
  KImGalleryPluginFactory( QObject* parent = 0, const char* name = 0 );
  ~KImGalleryPluginFactory();

  virtual QObject* createObject( QObject* parent = 0, const char* pname = 0,
				 const char* name = "QObject",
				 const QStringList &args = QStringList() );

 private:
  static KInstance* s_instance;
};

#endif
