
#include <qstring.h>
#include <qfile.h>
#include <qcstring.h>
#include <stdlib.h>
#include <unistd.h>

#ifdef YYDEBUG
extern int yydebug;
#endif

extern void parsepofile(const char *file);

int main( int argc, char** argv )
{
    if (argc != 2)
    {
        fprintf(stderr, "Usage : %s input_file\n", argv[0]);
        return -1;
    }
    QFile file( argv[1] );
    if ( !file.open( IO_ReadOnly ) )
    {
        fprintf(stderr, "Can't open input file\n");
        return -1;
    }

    QByteArray arr = file.readAll();
    int len = arr.size();
    arr.resize( len + 1 );
    arr[ len ] = 0;

#ifdef YYDEBUG
    char *debug = getenv("DEBUG");
    if (debug)
        yydebug = 1;
#endif

    file.close();
    parsepofile(arr.data());

    return 0;
}

