
/**
 *
 *  This file is part of the kdewebdev package
 *  Copyright (c) 2002 Keith Isdale <keith@kdewebdev.org>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 **/

#ifndef XSLDBGDIALOGBASE_H 
#define XSLDBGDIALOGBASE_H 
 
 
/** 
  *@author Keith Isdale 
  */ 

#include <QString> 
#include <QTimer>
 
class XsldbgDialogBase { 
 
public:  
	XsldbgDialogBase(); 
	virtual ~XsldbgDialogBase(); 
 
public : 
	/** return true if all data ok */ 
	virtual bool isValid(); 
 
	/** Update changes to xsldbg*/ 
	virtual void update(); 
	 
	/** refresh data from source */ 
	virtual void refresh(); 

	const QString & lastError() {return m_lastError;}; 

protected:
	QString m_lastError;
	QTimer resizeTimer;
 
}; 
 
#endif 
