
/**
 *
 *  This file is part of the kdewebdev package
 *  Copyright (c) 2002 Keith Isdale <keith@kdewebdev.org>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 **/

#include <QTableWidget> 
#include <QLineEdit> 

#include "xsldbgdebugger.h" 
#include "xsldbgcallstackimpl.h" 
 
XsldbgCallStackImpl::XsldbgCallStackImpl(XsldbgDebugger *debugger, 
        QWidget *parent /*=0*/) 
:  QWidget(parent)
{
    setupUi(this);
    this->debugger = debugger; 

    connect(debugger, SIGNAL(callStackItem(QString /* templateName*/, QString /* fileName */, int /* lineNumber */)), 
            this, SLOT(slotProcCallStackItem(QString /* templateName*/, QString /* fileName */, int /* lineNumber */))); 
    connect( callstackView,  SIGNAL(itemSelectionChanged()), 
            this, SLOT(itemSelectionChanged())); 
    connect(&resizeTimer, SIGNAL(timeout()), this, SLOT(resizeContents()));
    resizeContents();

    show(); 
    refresh(); 
}
 
XsldbgCallStackImpl::~XsldbgCallStackImpl()
{
    debugger = 0L; 
}

void XsldbgCallStackImpl::slotProcCallStackItem(QString  templateName, QString  fileName , int  lineNumber ) 
{
    static int insertPosition = 0; 
    static int frameNo =0; 
    if (templateName.isNull()){ 
        callstackView->clearContents(); 
        frameNo = 0;
        insertPosition=0;
    }else{ 
        if (insertPosition >= callstackView->rowCount())
            callstackView->insertRow(insertPosition);
        QTableWidgetItem *cellItem;
        for (int column=FrameColumn; column<=LineNumberColumn; column++){
            cellItem = callstackView->item(insertPosition, column);
            if (!cellItem)
                callstackView->setItem(insertPosition, column, new QTableWidgetItem);
            cellItem = callstackView->item(insertPosition, column);
            if (cellItem){
                switch(column){
                    case FrameColumn:
                        cellItem->setText(templateName.prepend(QString::number(frameNo++)+ "# "));
                        break;
                    case FileNameColumn:
                        cellItem->setText(fileName);
                        break;
                    case LineNumberColumn:
                        if (lineNumber != -1)
                            cellItem->setText(QString::number(lineNumber));
                        else
                            cellItem->setText("");
                        break;
                }
            }
        } 
        callstackView->resizeColumnsToContents(); 
        insertPosition++;
    }
} 


void XsldbgCallStackImpl::itemSelectionChanged() 
{
    QList<QTableWidgetItem *> items = callstackView->selectedItems();
    if (!items.isEmpty()){
        QString fileName;
        int lineNumber = 0;
        bool ok=false;
        QTableWidgetItem *cellItem;
        for (int i = 0; i < items.size(); ++i) {
            cellItem = items[i];	
            switch(cellItem->column()){
                case FileNameColumn:
                    fileName = cellItem->text();
                    break;
                case LineNumberColumn:
                    lineNumber = cellItem->text().toInt(&ok);
                    if (!ok)
                        lineNumber = 0;
                    break;
            }
        }
        if (!fileName.isEmpty())
            debugger->gotoLine(fileName, lineNumber);
    }
}

void XsldbgCallStackImpl::resizeContents()
{
    callstackView->resizeColumnsToContents();

}

void XsldbgCallStackImpl::refresh() 
{
    debugger->fakeInput("where", true) ;
}


#include "xsldbgcallstackimpl.moc"
