
/**
 *
 *  This file is part of the kdewebdev package
 *  Copyright (c) 2002 Keith Isdale <keith@kdewebdev.org>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 **/

#include <QTableWidget> 
#include <QLineEdit> 
 
#include "xsldbgentitiesimpl.h" 
#include "xsldbgdebugger.h" 
 
 
XsldbgEntitiesImpl::XsldbgEntitiesImpl(XsldbgDebugger *debugger, 
        QWidget *parent /*=0*/) 
:  QWidget(parent) 
{	 
    setupUi(this);
    this->debugger = debugger; 
    connect(debugger,  
            SIGNAL(entityItem(QString /*SystemID*/,   
                    QString /*PublicID*/)), 
            this,  
            SLOT(slotProcEntityItem(QString /*SystemID*/,   
                    QString /*PublicID*/)));	 

    connect( entitiesView,   
            SIGNAL(itemSelectionChanged()), 
            this, SLOT(itemSelectionChanged())); 

    connect(&resizeTimer, SIGNAL(timeout()), this, SLOT(resizeContents()));
    resizeContents();

    show(); 
} 
 
 
XsldbgEntitiesImpl::~XsldbgEntitiesImpl()
{ 
} 
 
 
void XsldbgEntitiesImpl::slotProcEntityItem(QString SystemID,  QString PublicID) 
{ 
    static int insertPosition = 0; 
    if (SystemID.isNull()) {
        entitiesView->clearContents(); 
        insertPosition=0;
    }else{		 
        resizeTimer.stop();
        if (insertPosition >= entitiesView->rowCount())
            entitiesView->insertRow(insertPosition);
        QTableWidgetItem *cellItem;
        for (int column=PublicIDColumn; column<=SystemIDColumn; column++){
            cellItem = entitiesView->item(insertPosition, column); 
            if (!cellItem)
                entitiesView->setItem(insertPosition, column, new QTableWidgetItem);
            cellItem = entitiesView->item(insertPosition, column); 
            if (cellItem){
                switch(column){
                    case PublicIDColumn:
                        cellItem->setText(PublicID);
                        break;
                    case SystemIDColumn:
                        cellItem->setText(SystemID);
                        break;
                }
            }
        }
        resizeTimer.start();
        insertPosition++;
    } 

} 


void XsldbgEntitiesImpl::itemSelectionChanged() 
{ 
    QList<QTableWidgetItem *> items = entitiesView->selectedItems();
    if (!items.isEmpty()){
        QString fileName;
        QTableWidgetItem *cellItem;
        for (int i = 0; i < items.size(); ++i) {
            cellItem = items[i];	
            switch(cellItem->column()){
                case SystemIDColumn:
                    fileName = cellItem->text();
                    break;
            }
        }
        if (!fileName.isEmpty())
            debugger->gotoLine(fileName, 1);			 
    } 
} 
 
void XsldbgEntitiesImpl::resizeContents()
{
   entitiesView->resizeColumnsToContents();
}

void XsldbgEntitiesImpl::refresh() 
{ 
    debugger->fakeInput("entities", true) ; 
} 
 
 
 
 

#include "xsldbgentitiesimpl.moc"
