/***************************************************************************
                          itemdlg.h  -  description
                             -------------------

    This file is a part of kpl - a program for graphical presentation of
    data sets and functions.

    begin                : Sun Apr 25 1999
    copyright            : (C) 2003 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef ITEMDLG_H
#define ITEMDLG_H

#include <qlist.h>
#include <kdialog.h>

class QButtonGroup;
class QCheckBox;
class QListViewItem;
class QPopupMenu;
class QRadioButton;
class KListView;
class KplCheckListItem;
class KplDoc;

/**
  * New item  dialog class. Provides a dialog for the selection of the type
  * of a new plot item.
  * @author Werner Stille
  */
class NewItemDlg : public KDialog
{
  Q_OBJECT
public:
  /**
   * Constructor.
   * @param parent pointer to parent widget.
   * @param i pointer to item type.
   */
  NewItemDlg(QWidget* parent, int* i);
  /** Destructor. */
  ~NewItemDlg();

protected:
  /**
   * reimplemented to display help when key F1 is pressed.
   * @param e Key event.
   */
  void keyPressEvent(QKeyEvent* e);
  int* ityp;
  QButtonGroup* bg;
  QPushButton* help;

protected slots:
  /** Accepts selection and leaves the dialog. */
  void slotClicked(int id);
  /** Displays help for the new item dialog. */
  void slotHelp();
};

/**
  * Items dialog class. Provides a dialog for editing the plot item list.
  * @author Werner Stille
  */
class ItemDlg : public KDialog
{
  Q_OBJECT
public:
  /**
   * Constructor.
   * @param model pointer to KplDoc model object.
   */
  ItemDlg(KplDoc* model);
  /** Destructor. */
  ~ItemDlg();
  /** Updates the item list. */
  void updItemList();

protected:
  /**
   * moves current item up or down.
   * @param di index difference: -1 true for upwards, +1 for downwards.
   */
  void moveItem(int di);
  /**
   * reimplemented to display help when key F1 is pressed.
   * @param e Key event.
   */
  void keyPressEvent(QKeyEvent* e);
  KplDoc* m;
  int iDest, iSource, idActive;
  KListView* itemList;
  QList<KplCheckListItem> lItem;
  QPushButton *up, *down, *edit, *fit, *del, *copy, *help;
  QCheckBox *appendItems;
  QPopupMenu* popupMenu;

  friend class KplApp;

protected slots:
  /**
   * Displays a dialog to edit an item according to its type.
   * @param i selected item.
   */
  void slotList(QListViewItem* i);
  /**
   * Resorts item list.
   * @param item moved item.
   * @param afterFirst preceeding item before move.
   * @param afterNow preceeding item after move.
   */
  void slotMoved(QListViewItem* item, QListViewItem* afterFirst,
                 QListViewItem* afterNow);
  void moveItem();
  /** Displays the dialog to choose the type of a new item. */
  void slotNew();
  /** Displays a dialog to edit an item according to its type. */
  void slotEdit();
  /** Enters parameter fitting. */
  void slotFit();
  /** Deletes the selected item. */
  void slotDelete();
  /** Append a copy of the selected item at the end of the list. */
  void slotCopy();
  /** Displays help for the items dialog. */
  void slotHelp();
  /**
   * Displays a popup menu.
   * @param item pointer to clicked QCheckListItem.
   * @param point where popup menu will appear.
   */
  void slotPopup(QListViewItem* item, const QPoint& p);
  /**
   * Toggles active state of item.
   * @param item pointer to clicked QCheckListItem.
   */
  void slotExecuted(QListViewItem* item);
  /** Updates item structure and repaints view. */
  void slotStateChanged(KplCheckListItem* item, bool bState);
  /** Toggles active state of item. */
  void slotToggleState();
  /** Enables/disables move buttons. */
  void slotSelectionChanged(QListViewItem* item);
  /** Moves item up in sequence. */
  void slotMoveUp();
  /** Moves item down in sequence. */
  void slotMoveDown();

signals:
  /**
   * Emitted when status message should be displayed.
   * @param msg message text.
   */
  void displayMessage(const QString& msg);
};

#endif
