/***************************************************************************
                          splinedlg.h  -  description
                             -------------------
    begin                : Sun Mar 3 2002
    copyright            : (C) 2003 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SPLINEDLG_H
#define SPLINEDLG_H

#include <kdialogbase.h>

class QComboBox;
class KColorButton;
class KplDoc;
class SplineItem;
class KplDoubleEdit;
class KplSpinBox;

/**
  * Spline settings dialog class. Provides a dialog for the settings
  * of a smoothing spline.
  * @author Werner Stille
  */
class SplineDlg : public KDialogBase
{
  Q_OBJECT
public:
  /**
   * Constructor.
   * @param parent pointer to parent widget.
   * @param model pointer to KplDoc model object.
   * @param fd pointer to spline object.
   */
  SplineDlg(QWidget* parent, KplDoc* model, SplineItem* fd);
  /** Destructor. */
  ~SplineDlg();

protected:
  /**
   * Copies settings to temporary spline object.
   * @param fd pointer to spline object.
   */
  void getTemp(SplineItem* fd);
  /**
   * Copies settings to spline object.
   * @param accept true for leaving the dialog, false for applying.
   */
  void getValues(bool accept);
  KplDoc* m;
  SplineItem *fd;
  QComboBox *eDeriv;
  KplDoubleEdit *exLow, *exMin, *exMax, *exStep, *efx, *efy;
  KplSpinBox *symb, *eRelSize;
  KColorButton* colData;

protected slots:
  /**
   * Enables lower boundary widget for integrals.
   * @param index index of selected derivative box item.
   */
  void slotDerivChanged(int index);
  /** Saves function value table into a data file. */
  virtual void slotUser1();
  /** Shows root finding dialog. */
  virtual void slotUser2();
  /** Applies settings and leaves the dialog. */
  virtual void slotOk();
  /** Applies settings without leaving the dialog. */
  virtual void slotApply();
};

#endif
