/* client.c */
/*
Copyright 2011 Patrick Spendrin <ps_ml@gmx.de>

This file is part of the SSH Library

You are free to copy this file, modify it in any way, consider it being public
domain. This does not apply to the rest of the library though, but it is
allowed to cut-and-paste working code from this file to any license of
program.
The goal is to show the API in action. It's not a reference on how terminal
clients must be made or how a client should react.
*/

#include "config.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <libssh/callbacks.h>
#include <libssh/libssh.h>
#include <libssh/sftp.h>

#include <fcntl.h>

#include "examples_common.h"
#define MAXCMD 10
#define snprintf _snprintf

static int client(ssh_session session, char* user, char* host){
  int auth=0;
  char *banner;
  int state;
  if (ssh_options_set(session, SSH_OPTIONS_USER, user) < 0)
    return -1;
  if (ssh_options_set(session, SSH_OPTIONS_HOST, host) < 0)
    return -1;
  printf("user and server are set\n");
  ssh_options_parse_config(session, NULL);

  if(ssh_connect(session)){
      fprintf(stderr,"Connection failed : %s\n",ssh_get_error(session));
      return -1;
  }
  state=verify_knownhost(session);
  printf("verified known host\n");
  if (state != 0)
    return -1;
  printf("trying to authenticate next\n");
  ssh_userauth_none(session, NULL);
  printf("trying to get banner next\n");
  banner=ssh_get_issue_banner(session);
  if(banner){
      printf("%s\n",banner);
      free(banner);
  }
  printf("banner has been printed\n");
  auth=authenticate_console(session);
  if(auth != SSH_AUTH_SUCCESS){
    return -1;
  }
  ssh_log(session, SSH_LOG_FUNCTIONS, "Authentication success");
  return 0;
}

void usage() {
}

int main(int argc, char **argv){
    ssh_session session;
    char *user, *host;

    if(argc <= 1) {
        printf("syntax: %s user@host\n", argv[0]);
        printf("checks whether a ssh connection can be established\n");
        exit(1);
    }

    host = strchr(argv[1], '@') + 1;
    user = (char*)malloc(strlen(argv[1]) - strlen(host));
    strncpy(user, argv[1], strlen(argv[1]) - strlen(host) - 1);
    user[strlen(argv[1]) - strlen(host) - 1] = 0;
    printf("testing ssh authentication to %s@%s\n", user, host);
    session = ssh_new();

    client(session, user, host);

    ssh_disconnect(session);
    ssh_free(session);

    ssh_finalize();
    free(user);
    return 0;
}

