# Configure checks for the config.h

include(CheckIncludeFile)
include(CheckFunctionExists)
include(CheckSymbolExists)


check_include_file("dlfcn.h" HAVE_DLFCN_H)
check_include_file("fcntl.h" HAVE_FCNTL_H)
check_include_file("inttypes.h" HAVE_INTTYPES_H)
check_include_file("memory.h" HAVE_MEMORY_H)
check_include_file("stdint.h" HAVE_STDINT_H)
check_include_file("stdlib.h" HAVE_STDLIB_H)
check_include_file("strings.h" HAVE_STRINGS_H)
check_include_file("string.h" HAVE_STRING_H)
check_include_file("sys/select.h" HAVE_SYS_SELECT_H)
check_include_file("sys/stat.h" HAVE_SYS_STAT_H)
check_include_file("sys/types.h" HAVE_SYS_TYPES_H)
check_include_file("sys/time.h" HAVE_SYS_TIME_H)
check_include_file("sys/uio.h" HAVE_SYS_UIO_H)
check_include_file("unistd.h" HAVE_UNISTD_H)

if(WIN32)
    set(HAVE_DOSISH_SYSTEM 1)
    set(HAVE_W32_SYSTEM 1)
    if(WINCE)
        set(uintptr_t "unsigned __int32")
    endif(WINCE)
endif(WIN32)

check_function_exists("fopencookie" HAVE_FOPENCOOKIE)
check_function_exists("funopen" HAVE_FUNOPEN)
check_function_exists("getegid" HAVE_GETEGID)
check_function_exists("getenv_r" HAVE_GETENV_R)
check_function_exists("getgid" HAVE_GETGID)
check_function_exists("setenv" HAVE_SETENV)
check_function_exists("stpcpy" HAVE_STPCPY)
check_function_exists("timegm" HAVE_TIMEGM)
check_function_exists("ttyname_r" HAVE_TTYNAME_R)
check_function_exists("vasprintf" HAVE_VASPRINTF)

#/* Define to 1 if the system has the type `error_t'. */
#cmakedefine HAVE_ERROR_T

#/* Define to 1 if fseeko (and presumably ftello) exists and is declared. */
#cmakedefine HAVE_FSEEKO

#/* Define if we have Pth. */
#cmakedefine HAVE_PTH

#/* Define if we have pthread. */
#cmakedefine HAVE_PTHREAD

#/* Define if getenv() is thread-safe */
#cmakedefine HAVE_THREAD_SAFE_GETENV

#/* Define if __thread is supported */
#cmakedefine HAVE_TLS

#/* Define to 1 if the system has the type `uintptr_t'. */
#cmakedefine HAVE_UINTPTR_T

#/* used to implement the va_copy macro */
#cmakedefine MUST_COPY_VA_BYVAL

#/* The size of `unsigned int', as computed by sizeof. */
#cmakedefine SIZEOF_UNSIGNED_INT

#/* Define to 1 if you have the ANSI C header files. */
#cmakedefine STDC_HEADERS

#/* Defined if descriptor passing is enabled and supported */
#cmakedefine USE_DESCRIPTOR_PASSING

#/* Number of bits in a file offset, on hosts where this is settable. */
#cmakedefine _FILE_OFFSET_BITS

#/* Define to 1 to make fseeko visible on some hosts (e.g. glibc 2.2). */
#cmakedefine _LARGEFILE_SOURCE

#/* Define to a type to use for `error_t' if it is not otherwise available. */
#cmakedefine error_t

if(MSVC)
    set(inline __inline)
else(MSVC)
    set(inline __inline__)
endif(MSVC)

#check_symbol_exists("off_t" "sys/types.h" off_t)
#if(NOT off_t)
#    set(off_t "long int")
#endif(NOT off_t)

add_definitions(-DHAVE_CONFIG_H)

configure_file(config.h.cmake config.h)
configure_file(src/gpgme.h.in gpgme.h)
