# - Try to find GPG_ERROR
# Once done this will define
#
#  GPG_ERROR_FOUND - system has GPG_ERROR
#  GPG_ERROR_INCLUDE_DIR - the GPG_ERROR include directory
#  GPG_ERROR_LIBRARIES - the libraries needed to use GPG_ERROR

if (GPG_ERROR_INCLUDE_DIR AND GPG_ERROR_LIBRARIES)

    # in cache already
    SET(GPG_ERROR_FOUND TRUE)

else (GPG_ERROR_INCLUDE_DIR AND GPG_ERROR_LIBRARIES)

    FIND_PATH(GPG_ERROR_INCLUDE_DIR gpg-error.h)

    FIND_LIBRARY(GPG_ERROR_LIBRARIES NAMES gpg-error libgpg-error gpg-error-0 libgpg-error-0)

    if (GPG_ERROR_INCLUDE_DIR AND GPG_ERROR_LIBRARIES)
       set(GPG_ERROR_FOUND TRUE)
    endif (GPG_ERROR_INCLUDE_DIR AND GPG_ERROR_LIBRARIES)

    if (GPG_ERROR_FOUND)
      if (NOT GPG_ERROR_FIND_QUIETLY)
        message(STATUS "Found gpg-error: ${GPG_ERROR_LIBRARIES}")
      endif (NOT GPG_ERROR_FIND_QUIETLY)
    else (GPG_ERROR_FOUND)
      if (GPG-ERROR_FIND_REQUIRED)
        message(SEND_ERROR "Could NOT find gpg-error")
      endif (GPG-ERROR_FIND_REQUIRED)
    endif (GPG_ERROR_FOUND)

    MARK_AS_ADVANCED(GPG_ERROR_INCLUDE_DIR GPG_ERROR_LIBRARIES)

endif (GPG_ERROR_INCLUDE_DIR AND GPG_ERROR_LIBRARIES)
