############## search for external tools that are needed for header generation ###################
find_program(AWK_EXECUTABLE NAMES awk gawk)

if(NOT AWK_EXECUTABLE)
    message(FATAL_ERROR "awk wasn't found. Please install it.")
else(NOT AWK_EXECUTABLE)
    message(STATUS "Found awk: ${AWK_EXECUTABLE}")
endif(NOT AWK_EXECUTABLE)

file(WRITE ${CMAKE_BINARY_DIR}/status-table.h "/* Generated automatically by mkstatus */\n"
"/* Do not edit! */\n"
"\n"
"struct status_table_s {\n"
"    const char *name;\n"
"    gpgme_status_code_t code;\n"
"};\n"
"\n"
"static struct status_table_s status_table[] = \n"
"{\n")

execute_process(COMMAND ${AWK_EXECUTABLE} -f mkstatus.awk
                  WORKING_DIRECTORY ${CMAKE_SOURCE_DIR}
                  OUTPUT_VARIABLE _awk_output
                  ERROR_VARIABLE _awk_error
                  INPUT_FILE ${CMAKE_BINARY_DIR}/gpgme.h
)

string(REGEX REPLACE ";" "\\\\;" contents "${_awk_output}")
string(REGEX REPLACE "\n" ";" contents "${contents}")
list(SORT contents)
foreach(line ${contents})
    file(APPEND ${CMAKE_BINARY_DIR}/status-table.h "${line}\n")
endforeach(line ${contents})

#message(STATUS "<${_awk_error}><${contents}>")
#awk '
#/GPGME_STATUS_ENTER/      { okay = 1 }
#!okay                     { next }
#/}/                       { exit 0 }
#/GPGME_STATUS_[A-Za-z_]*/ { sub (/,/, "", $1); printf "  { \"%s\", %s },\n", substr($1,14), $1 }
#' | sort  

file(APPEND ${CMAKE_BINARY_DIR}/status-table.h "  {NULL, 0}\n"
"};\n"
"\n")
