/* 
*/


#ifndef KNEWICONLOADER_H
#define KNEWICONLOADER_H

#ifndef HAVE_CONFIG_H
#include "../config.h"
#endif

#include <qapp.h>
#include <qlist.h>
#include <qpixmap.h>
#include <qstrlist.h>
#include <qstring.h>
#include <kiconloader.h>
#ifdef HAVE_DLFCN_H
#include <dlfcn.h>
#endif
#ifdef HAVE_DL_H
#include <dl.h>
#endif

#include "kdynlib.h"

#define LIB KDynamicLibrary

class KNewIconLoader : public KIconLoader
{
  Q_OBJECT

public:
  KNewIconLoader ( KConfig *conf, const QString &app_name, const QString &var_name );
  KNewIconLoader ();
  ~KNewIconLoader ();

protected:
  QPixmap loadInternal(const QString &name, int w = 0, int h = 0 );
  bool loadLibrary(const char *lib);

  QStrList libicons;
  KDynamicHandle handle;
  QStrList (*xpm_names)(QStrList);
  QPixmap *(*xpm_icon)(const char*);
  void (*xpm_init)(void);
  void (*xpm_fini)(void);
  char *error;
};

#endif // KICONLOADER_H




