/* This is the base file for creating icon libs.*/

#include <qobject.h>
#include <qpixmap.h>
#include <qdict.h>
#include <stdlib.h>
#include <stdio.h>
#include <qstrlist.h>
#include "kicons_in.h"

#define XpmDict QDict<char*>
XpmDict *xpmdict = 0;

extern "C" void xpm_fini()
{
  if(xpmdict)
  {
    xpmdict->clear();
    delete xpmdict;
  }
}

extern "C" QPixmap* xpm_icon(const char *name)
{
  if(!xpmdict)
    return (QPixmap*)0;
  char **x = xpmdict->find(name);
  if(x)
    return new QPixmap((const char**)x);
  else
    return (QPixmap*)0;
}

extern "C" QStrList xpm_names(QStrList list)
{
  QDictIterator<char*> it(*xpmdict);

  while(it.current())
  {
    list.append(it.currentKey());
    ++it;
  }
  return list;
}


