#include <qapplication.h>
#include <qdialog.h>
#include <qpushbutton.h>

class MyDialog : public QDialog
{
public:
  MyDialog(QWidget *parent);
private:
  QPushButton *ok;
};

// Create a modal dialog
MyDialog::MyDialog(QWidget *parent) : QDialog(parent,0,TRUE)
{
  // Create a new button; parent=this, caption="Accept"
  ok = new QPushButton("Accept", this);

  // Left=50, Top=10, Width=100, Height=30
  ok->setGeometry(50, 10, 100, 30);

  // Show the button
  ok->show();

  // signals and slots will be explained more later.
  connect(ok, SIGNAL(clicked()), this, SLOT(accept()));
}



// A window class
class MyWindow : public QWidget
{
  public:
    MyWindow();
};


MyWindow::MyWindow() : QWidget()
{
  // Create and show my dialog window 
  MyDialog dialog(this);
  dialog.exec();
}


int main(int argc, char **argv)
{
  QApplication app(argc, argv);
  MyWindow window;
  window.setGeometry(200,200,400,300);
  window.setCaption("QDialog Example");  
  app.setMainWidget(&window);
  window.show();
  return app.exec();
}
