#include <qpainter.h>
#include <qtimer.h>
#include <qpixmap.h>

#include <kmenubar.h>
#include <kapp.h>
#include <kstdaccel.h>

#include "klongdraw.moc"


KLongDraw::KLongDraw (QWidget *parent, const char *name=0) :
  QWidget (parent, name)
{
  bneedrecreate=true;
  qpixmap=0;

  for (int i=0; i<NEllipses; i++)
    {
      x[i]=(kapp->random()%1000)/1000.;
      y[i]=(kapp->random()%1000)/1000.;
    }

  setBackgroundMode (NoBackground);

  qtimer = new QTimer (this);
  connect ( qtimer, SIGNAL (timeout()),
	    this, SLOT (slotDrawSome()) );
}

void
KLongDraw::paintEvent (QPaintEvent *)
{

  if (bneedrecreate)
    {
      if (qpixmap!=0)
	delete qpixmap;
      qpixmap = new QPixmap (width(), height());

      QPainter qpainter;
      qpainter.begin (qpixmap, this);
      qpainter.fillRect (qpixmap->rect(), white);
      
      bitBlt (this, 0, 0, qpixmap);
      
      w = width()/100;
      h = height()/100;

      bneedrecreate=false;
      total=0;

      qtimer->start(0);
    }

  bitBlt (this, 0, 0, qpixmap);

}

void
KLongDraw::slotDrawSome()
{

  QPainter qpainter;
  qpainter.begin (qpixmap, this);

  qpainter.setBrush (blue);
  
  int imax = total+100;
  for (int i=total; i<imax; i++)
    qpainter.drawEllipse (x[i]*width(), y[i]*height(), w, h);
  total = imax;

  //This updates the window periodically with the partially-drawn scene.
  // While this _does_ indicate progress on the update, you might,
  // instead, update a progress bar here and only call update()
  // after the entire scene has been drawn.
  if (!(total%1000))
    update();

  if (total>=NEllipses)
    {
      qtimer->stop();
      update();
    }
    

}

void
KLongDraw::resizeEvent (QResizeEvent *)
{
  bneedrecreate = true;
}
