#include <kapp.h>
#include <kfiledialog.h>
#include <kfontdialog.h>
#include <kcolordlg.h>
#include <kmessagebox.h>
#include <kurl.h>

int
main (int argc, char *argv[])
{
  KApplication kapplication (argc, argv, "kstandarddialogs");

  if (KMessageBox::
      warningContinueCancel (0, "Are you sure you want to see this demo?",
			     "Demo program", "See demo") == 
      KMessageBox::Cancel)
    exit (0);

  KURL kurl = KFileDialog::getOpenURL ();

  if (!kurl.isMalformed())
    {
      QString message;
      message.sprintf ("The file you selected was \"%s\".",
		       (const char *)kurl.url());
      
      KMessageBox::information (0, message, "File selected");
    }

  QFont qfont;
  if (KFontDialog::getFont (qfont))
    {
      QString message;
      message.sprintf ("Sorry, but you selected \"%d point %s\"",
		       qfont.pointSize(),
		       (const char *) qfont.family());


      KMessageBox::sorry (0, message, "Font selected");
    }

  QColor qcolor;
  if (KColorDialog::getColor (qcolor))
    {
      QString message;
      message.sprintf ("Oh no! The color you selected was (R,G,B)=(%d,%d,%d).",
		       qcolor.red(), qcolor.green(), qcolor.blue());
      
      KMessageBox::error (0, message, "Error:  Color selected");
    }      
  
  return 0;
}

	   
