#include <qimage.h>
#include <qpainter.h>

#include "ktransform.h"

KTransform::KTransform (const QString &filename,
			QWidget *parent, const char *name=0) :
  QWidget (parent, name)
{
  qimage = new QImage;
  qimage->load (filename);          

  int i;
  for (i=0; i<qimage->numColors(); i++)
    {
      QRgb color = qimage->color (i);
      QRgb gray = qRgb (qGray (color), qGray (color), qGray (color));
      qimage->setColor (i, gray);
    }
  
}

void
KTransform::paintEvent (QPaintEvent *)
{
  QPainter qpainter (this);
 
  qpainter.drawImage (0, 0, *qimage);
}                                   
