<?php
/* Iterate through the servers in an attempt to locate a preferred
   server for this web server/virtualhost. If none are found, we
   default to the first entry in the $servers array that isn't a
   prompt (key begins with '_'). */
foreach ($servers as $key => $curServer) {
    if (!isset($server_key) && substr($key, 0, 1) != '_') {
        $server_key = $key;
    }
    if (IMP::isPreferredServer($curServer, $key)) {
        $server_key = $key;
        break;
    }
}

// Grab some default values from the preferred or otherwise default
// server.
$server_value = $servers[$server_key]['server'];
$protocol_value = $servers[$server_key]['protocol'];
$port_value = $servers[$server_key]['port'];
$folders_value = $servers[$server_key]['folders'];
$namespace_value = $servers[$server_key]['namespace'];
$maildomain_value = $servers[$server_key]['maildomain'];
$realm_value = $servers[$server_key]['realm'];

/* Build the <select> widget for the servers list. */
if ($conf['server']['server_list'] == 'shown') {
    $servers_list = '';

    foreach ($servers as $key => $curServer) {
        $sel = (IMP::isPreferredServer($curServer, $key)) ? ' selected="selected"' : '';
        $servers_list .= "<option value=\"$key\"$sel>";
        $servers_list .= $curServer['name'] . '</option>';
    }
}

/* Build the <select> widget containing the available languages. */
if (!$prefs->isLocked('language')) {
    $_SESSION['horde_language'] = NLS::select();
    $langs = '<select name="new_lang" onchange="selectLang()">';
    foreach ($nls['languages'] as $key => $val) {
        $sel = ($key == $_SESSION['horde_language']) ? ' selected="selected"' : '';
        $langs .= "<option value=\"$key\"$sel>$val</option>";
    }
    $langs .= '</select>';
}

// Get a list of applications guests can use, so we can link to the
// guest page if we should.
$apps = $registry->listApps();
$guestapps = array();
$problem = false;
foreach ($apps as $app) {
    if ($registry->allowGuests($app) &&
        $app != 'horde') {
        if ($app == 'problem') {
            $problem = true;
        } else {
            $guestapps[] = $app;
        }
    }
}

?>

<script language="JavaScript" type="text/javascript">
<!--

function setFocus()
{
    if (document.implogin.imapuser.value == "") {
        document.implogin.imapuser.focus();
    } else {
        document.implogin.pass.focus();
    }
}

function submit_login()
{
<?php if ($conf['server']['server_list'] == 'shown'): ?>
    if (document.implogin.server[document.implogin.server.selectedIndex].value.substr(0, 1) == "_") {
        return false;
    }
<?php endif; ?>
    if (document.implogin.imapuser.value == "") {
        alert('<?php echo addslashes(_("Please provide your username and password")) ?>');
        document.implogin.imapuser.focus();
        return false;
    } else if (document.implogin.pass.value == "") {
        alert('<?php echo addslashes(_("Please provide your username and password")) ?>');
        document.implogin.pass.focus();
        return false;
    } else {
        document.implogin.loginButton.disabled = true;
        document.implogin.submit();
        return true;
    }
}
//-->
</script>

<script language="JavaScript1.2" type="text/javascript">
<!--
function enter_key_trap(e)
{
    var keyPressed;

    if (document.layers) {
        keyPressed = String.fromCharCode(e.which);
    } else if (document.all) {
        keyPressed = String.fromCharCode(window.event.keyCode);
    } else if (document.getElementById) {
        keyPressed = String.fromCharCode(e.keyCode);
    }

    if ((keyPressed == "\r" || keyPressed == "\n") && (submit_login())) {
        document.implogin.submit();
    }
}
//-->
</script>

<form action="<?php echo $formAction ?>" method="post" name="implogin">
<?php Horde::pformInput() ?>
<?php if (!empty($formData)): ?>
<input type="hidden" name="formData" value="<?php echo htmlspecialchars($formData) ?>" />
<?php endif; ?>
<input type="hidden" name="actionID" value="<?php echo $actionID ?>" />
<input type="hidden" name="url" value="<?php echo htmlspecialchars(Horde::getFormData('url')) ?>" />
<input type="hidden" name="mailbox" value="<?php echo $prefs->getValue('mailbox') ?>" />
<input type="hidden" name="frameset" value="" />
<?php $args = IMP::getComposeArgs('array'); foreach ($args as $arg => $value): ?>
<input type="hidden" name="<?php echo htmlspecialchars($arg) ?>" value="<?php echo htmlspecialchars($value) ?>" />
<?php endforeach; ?>

<table align="center" border="0" width="100%">
<tr><td align="center" colspan="2" class="header">
  <?php echo $title ?>
</td></tr>
</table>

<table align="center" border="0" width="300">
<?php if (!empty($reasons[$reason])): ?>
<tr><td align="center" colspan="2" class="light"><p class="light"><?php echo $reasons[$reason] ?></p></td></tr>
<?php endif; ?>
<?php if ((count($guestapps) || $problem) && $imp_auth): ?>
<tr>
  <td align="center" colspan="2" class="light">
    <?php if (count($guestapps)) echo sprintf(_("%s%s Guest Services</a>"), Horde::link(Horde::url($registry->getParam('webroot', 'horde') . '/guest.php'), _("Guest Services"), 'menuitem'), Horde::img('guest.gif', _("Guest Services"), null, $registry->getParam('graphics', 'horde'))) ?>
    <?php if ($problem) echo sprintf('%s%s%s</a>', Horde::link(Horde::url($registry->getParam('webroot', 'horde') . '/problem.php'), $registry->getParam('name', 'problem'), 'menuitem'), Horde::img($registry->getParam('icon', 'problem'), $registry->getParam('name', 'problem'), null, ''), $registry->getParam('name', 'problem')) ?>
  </td>
</tr>
<?php endif; ?>
<tr>
    <td align="right" class="light"><b><?php echo _("Username") ?></b></td>
    <td align="left" class="light">
      <input type="text" tabindex="1" name="imapuser" value="<?php echo htmlspecialchars(Horde::getFormData('imapuser', getenv('REMOTE_USER'))) ?>" />
    <?php
        if (!empty($conf['hooks']['vinfo'])) {
            @include_once HORDE_BASE . '/config/hooks.php';
            if (function_exists('_imp_hook_vinfo')) { ?>
      <b>@<?php echo call_user_func('_imp_hook_vinfo', 'vdomain') ?></b>
    <?php } } ?>
    </td>
</tr>
<tr>
    <td align="right" class="light"><b><?php echo _("Password") ?></b></td>
    <td align="left"><input type="password" tabindex="2" name="pass" /></td>
</tr>

<?php if ($conf['server']['server_list'] == 'hidden'): ?>
<tr>
    <td><input type="hidden" name="server" value="<?php echo $server_key ?>" /></td>
<?php elseif ($conf['server']['server_list'] == 'shown'): ?>
<tr>
    <td align="right" class="light"><b><?php echo _("Server") ?></b></td>
    <td class="light" align="left">
        <select tabindex="3" name="server"><?php echo $servers_list ?></select>
    </td>
<?php elseif ($conf['server']['change_server']): ?>
<tr>
    <td align="right" class="light"><b><?php echo _("Server") ?></b></td>
    <td align="left" class="light">
        <input type="hidden" name="namespace" value="<?php echo $namespace_value ?>" />
        <input type="hidden" name="maildomain" value="<?php echo $maildomain_value ?>" />
        <input type="text" tabindex="3" name="server" value="<?php echo Horde::getFormData('server', $server_value) ?>" />
        <?php if ($conf['server']['change_port']): ?>
        <input type="text" size="4" name="port" tabindex="3" value="<?php echo Horde::getFormData('port', $port_value) ?>" />
        <?php else: ?>
        <input type="hidden" name="port" value="<?php echo $port_value ?>" />
        <?php endif; ?>
        <?php if ($conf['server']['change_protocol']): ?>
        <select tabindex="3" name="protocol" onchange="updatePort();">
            <?php $protocol = Horde::getFormData('protocol', $protocol_value) ?>
            <option value="imap"<?php if ($protocol == 'imap') echo ' selected="selected"' ?>>IMAP</option>
            <option value="imap/notls"<?php if ($protocol == 'imap/notls') echo ' selected="selected"' ?>><?php echo _("IMAP, no TLS") ?></option>
            <option value="imap/ssl"<?php if ($protocol == 'imap/ssl') echo ' selected="selected"' ?>><?php echo _("IMAP over SSL") ?></option>
            <option value="imap/ssl/novalidate-cert"<?php if ($protocol == 'imap/ssl/novalidate-cert') echo ' selected="selected"' ?>><?php echo _("IMAP over SSL (self-signed)") ?></option>
            <option value="pop3"<?php if ($protocol == 'pop3') echo ' selected="selected"' ?>>POP3</option>
            <option value="pop3/ssl/novalidate-cert"<?php if ($protocol == 'pop3/ssl/novalidate-cert') echo ' selected="selected"' ?>><?php echo _("POP3 over SSL (self-signed)") ?></option>
        </select>
        <?php else: ?>
        <input type="hidden" name="protocol" value="<?php echo $protocol_value ?>" />
        <?php endif; ?>
    </td>
<?php else: ?>
<tr>
    <td>
        <input type="hidden" name="server" value="<?php echo $server_value ?>" />
        <input type="hidden" name="port" value="<?php echo $port_value ?>" />
        <input type="hidden" name="namespace" value="<?php echo $namespace_value ?>" />
        <input type="hidden" name="maildomain" value="<?php echo $maildomain_value ?>" />
        <input type="hidden" name="protocol" value="<?php echo $protocol_value ?>" />
        <input type="hidden" name="realm" value="<?php echo $realm_value ?>" />
    </td>
<?php endif; ?>

<?php if ($conf['server']['change_folders'] && $conf['server']['server_list'] == 'none'): ?>
</tr>
<tr>
    <td align="right" class="light"><b><?php echo _("Folder Prefix") ?></b></td>
    <td align="left"><input type="text" tabindex="3" name="folders" value="<?php echo Horde::getFormData('folders', $folders_value) ?>" /></td>
</tr>
<?php else: ?>
    <td><input type="hidden" name="folders" value="<?php echo $folders_value ?>" /></td>
</tr>
<?php endif; ?>

<?php if (!$prefs->isLocked('language')): ?>
<tr>
    <td align="right" class="light"><b><?php echo _("Language") ?></b></td>
    <td align="left" class="light"><?php echo $langs ?></td>
</tr>
<?php endif; ?>

<tr>
    <td>&nbsp;</td>
    <td align="left" class="light"><input type="submit" class="button" name="loginButton" tabindex="4" value="<?php echo _("Log in") ?>" onclick="return submit_login();" /></td>
</tr>
<?php if ($conf['signup']['allow'] && $auth->hasCapability('add')): ?>
<tr>
  <td></td>
  <td class="light"><?php echo Horde::link(Horde::addParameter(Horde::url($registry->getParam('webroot', 'horde') . '/signup.php'), 'url', Horde::getFormData('url')), _("Sign up if not registered"), 'menuitem') . _("Sign up if not registered") ?></a></td>
</tr>
<?php endif; ?>
</table>
</form>

<script language="JavaScript" type="text/javascript">
<!--

function updatePort()
{
<?php if ($conf['server']['change_port']): ?>
    if (document.implogin.protocol.options[document.implogin.protocol.selectedIndex].value == 'imap') {
        document.implogin.port.value = 143;
    } else if (document.implogin.protocol.options[document.implogin.protocol.selectedIndex].value == 'imap/ssl') {
        document.implogin.port.value = 993;
    } else if (document.implogin.protocol.options[document.implogin.protocol.selectedIndex].value == 'imap/ssl/novalidate-cert') {
        document.implogin.port.value = 993;
    } else if (document.implogin.protocol.options[document.implogin.protocol.selectedIndex].value == 'pop3') {
        document.implogin.port.value = 110;
    } else if (document.implogin.protocol.options[document.implogin.protocol.selectedIndex].value == 'pop3/ssl') {
        document.implogin.port.value = 995;
    } else if (document.implogin.protocol.options[document.implogin.protocol.selectedIndex].value == 'pop3/ssl/novalidate-cert') {
        document.implogin.port.value = 995;
    }
<?php endif; ?>
}

<?php if (!$prefs->isLocked('language')): ?>
function selectLang()
{
    // We need to reload the login page here, but only if the user hasn't
    // already entered a username and password.
    if (document.implogin.imapuser.value == '' &&
        document.implogin.pass.value == '') {
        var lang_page = 'login.php?new_lang=' + document.implogin.new_lang[document.implogin.new_lang.selectedIndex].value;
<?php
$url = Horde::getFormData('url');
if (!empty($url)):
?>
        lang_page += '&url=<?php echo urlencode($url) ?>';
<?php endif; ?>
        self.location = lang_page;
    }
}
<?php endif; ?>

if (window.parent.frames.horde_menu) document.implogin.frameset.value = 1;

//-->
</script>

<script language="JavaScript1.2" type="text/javascript">
<!--
// Setup the enter keytrap code
if (window.document.captureEvents != null) {
    window.document.captureEvents(Event.KEYPRESS);
    window.document.onkeypress = enter_key_trap;
}
//-->
</script>
