<?php
/**
 * Vacation Configuration File
 *
 * This file contains global configuration settings for vacation. Values
 * may be safely edited by hand. Use conf.php.dist as a reference.
 *
 * Strings should be enclosed in 'quotes'.
 * Integers should be given literally (without quotes).
 * Boolean values may be 'true' or 'false'.
 *
 * $Horde: vacation/config/conf.php.dist,v 1.18 2003/07/11 12:21:48 opal Exp $
 */

// We need to know where to find the vacation program on your system
// for the forwards driver...
// $conf['vacation']['path'] = '/usr/local/bin/vacation';


// You can restrict vacation messages to match a certain pattern, if
// you like. If this config value is non-empty, it is expected to be a
// PCRE regular expression. Include the pattern delimiters, and any
// modifiers that you want applied. See:
// http://www.php.net/manual/en/pcre.pattern.syntax.php
//$conf['vacation']['validation_pattern'] = '';

// This example forces the message to include a Subject, a newline,
// and then any text:
// $conf['vacation']['validation_pattern'] = '|^Subject: .+\n.+|';

// You can specify a default vacation message here:
$conf['vacation']['default'] = 'Subject: ' . _("On vacation message") . "\n" . _("I'm on vacation and will not be reading my mail for a while.") . "\n" . _("Your mail will be dealt with when I return.") . "\n";


// The driver to use. Valid values are:
//
// forwards:         An ftp driven driver for dot-forward compliant mailers.
// qmail:            An ftp driven driver for qmail compliant mailers.
// sql:              An sql driven driver for the exim mailer.
// ldap:	     An ldap driven driver for the exim mailer.
$conf['server']['driver'] = 'kolab';

// Any parameters that the driver needs go in this array. See driver
// specific sections below for information on what parameters each
// driver takes...
$conf['server']['params'] = array();

// If not using realms (multiple domains or virtual hosting) then
// there is only one possible configuration which is called 'default'
// by convention.
//
// Even if you are using realms/hosting, you should probably set a
// default configuration. The following line defines the default
// configuration for the 'forwards' ftp based driver, setting the
// hostname where the ftp server is running and the port that it is
// running one. These may be overriden by realm/domain specific values
// by defining additional arrays, one per realm/domain, with the
// realm/domain name as the key instead of the key 'default' as shown
// below.
//
// The special parameter 'hordeauth' may be set to true on any realm,
// including the default realm, to tell Vacation to use the password
// that the user logged in to Horde with, instead of prompting for it.
//
// The special parameter 'norealm' may be set to true on any realm,
// including the default realm, to tell Vacation to NOT add any domain
// information to the email address used in the .forward file. If this
// is true, and a user is logged in as user@example.com, the .forward
// will only contain user. By default it contains user@example.com,
// but this leads to forwarding loops on some systems.
$conf['server']['params']['default'] = array(
    'host' => $conf['server']['name'],
    'port' => 21,
    // Uncomment this if the user's login password is the right
    // password, and you don't want them to have to confirm it:
    // 'hordeauth' => true,
    // Uncomment this if domain information shouldn't be added to the
    // email address in .forward files:
    // 'norealm' => true,
);

// If you are using realms or virtual hosting where you authenticate
// to Horde with 'user@realm' rather than just 'user', then you can
// have a seperate configuration for each realm or domain. The
// following example would be for a realm called 'example.com':
//
// $conf['server']['params']['example.com'] =
//     array('host' => 'mail.example.com', 'port' => 21);


// The type of database file to use if using the forwards backend.
// Valid types are:
//
// empty:      An empty file
// hash:       Berkeley DB 2.x hash, little endian
// hash3:      Berkeley DB 3.x hash, little endian
// btree:      Berkeley DB 2.x btree, little endian
// gdbm:       GNU dbm (gdbm) database, little endian
$conf['server']['params']['dbtype'] = 'empty';

// For sql driver, we need to define the database info.
// $conf['server']['params'] = array();
// $conf['server']['params']['phptype'] = 'mysql';
// $conf['server']['params']['hostspec'] = 'localhost';
// $conf['server']['params']['username'] = 'username';
// $conf['server']['params']['password'] = '*****';
// $conf['server']['params']['vacation'] = 'vacation'; // y/n ENUM
// $conf['server']['params']['message'] = 'vacation_msg';
// $conf['server']['params']['subject'] = 'vacation_sub';
// $conf['server']['params']['database'] = 'users';
// $conf['server']['params']['table'] = 'users';
// $conf['server']['params']['user_col'] = 'user';
// $conf['server']['params']['pass_col'] = 'password';

// For ldap driver, we need to define some information.
//$conf['server']['params']['default'] = array(
//        'host' => 'ldap.some.org',
//        'uid'=> 'uid', // The attribute to use for searching users.
//        'port' => 389,
//        'basedn' => 'ou=mailaccounts,dc=some.org',
// An alternative way.
//        'userdn' => 'uid=' . Auth::getAuth() . ',ou=mailaccounts,dc=some.org',
//        'vacation' => 'autoreply' // 'autoreply' is the attribute to search for.				// if it exists it defines the vacation message.
//);


// Define usernames for which we will refuse to set forwards. Lists
// usernames only, and be aware that this blocks the username in all
// realms!
$conf['user']['refused'] = array('root', 'bin', 'daemon', 'adm', 'lp', 'shutdown',
                                 'halt', 'uucp', 'ftp', 'anonymous', 'nobody', 'httpd',
                                 'operator', 'guest', 'diginext', 'bind', 'courier',
                                 'cyrus', 'games', 'kmem', 'mailnull', 'man', 'mysql',
                                 'news', 'postfix', 'sshd', 'tty', 'www');


// Define apps to put in the menu bar. To include IMP in the menu bar,
// you would add: $conf['menu']['apps'] = array('imp');
$conf['menu']['apps'] = array();
