/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath.internal;

import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0019\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u001a_\u0010\u0003\u001a\u0002H\u0004\"\u0004\b\u0000\u0010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u000626\u0010\b\u001a2\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\r\u0012\u0004\u0012\u0002H\u00040\tH\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000e\u001a0\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0006H\u0000\u001a\u0010\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u001a\u0018\u0010\u0016\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u0001H\u0000\u001a \u0010\u0016\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001H\u0000\u001a \u0010\u0016\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a_\u0010\u0017\u001a\u0002H\u0004\"\u0004\b\u0000\u0010\u00042\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000626\u0010\b\u001a2\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\u0005\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u0002H\u00040\tH\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000e\u001a\f\u0010\u0018\u001a\u00020\u0006*\u00020\u0006H\u0000\u001a\f\u0010\u0019\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a\f\u0010\u0019\u001a\u00020\u0006*\u00020\u0006H\u0000\u001a\f\u0010\u001a\u001a\u00020\u0006*\u00020\u0006H\u0000\u001a\f\u0010\u001b\u001a\u00020\u0006*\u00020\u0006H\u0000\u001a\f\u0010\u001c\u001a\u00020\u0006*\u00020\u0006H\u0000\u001a\f\u0010\u001d\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a\f\u0010\u001e\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a\f\u0010\u001e\u001a\u00020\u0006*\u00020\u0006H\u0000\u001a\f\u0010\u001f\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a\f\u0010\u001f\u001a\u00020\u0006*\u00020\u0006H\u0000\u001a\u0014\u0010 \u001a\u00020\u0001*\u00020\u00012\u0006\u0010!\u001a\u00020\u0001H\u0000\u001a\u0014\u0010 \u001a\u00020\u0001*\u00020\u00062\u0006\u0010!\u001a\u00020\u0001H\u0000\u001a\f\u0010\"\u001a\u00020\u0006*\u00020\u0006H\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006#"}, d2={"cosDeg", "", "deg", "fromPolarModel", "T", "c", "", "h", "block", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "a", "b", "(FFLkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "scaleRange", "l1", "r1", "l2", "r2", "t", "sinDeg", "sqrtSumSq", "toPolarModel", "degToGrad", "degToRad", "degToTurns", "gradToDeg", "nanToOne", "nanToZero", "normalizeDeg", "radToDeg", "spow", "p", "turnToDeg", "colormath"})
public final class InternalMathKt {
    public static final float degToRad(float $this$degToRad) {
        return (float)InternalMathKt.degToRad((double)$this$degToRad);
    }

    public static final float radToDeg(float $this$radToDeg) {
        return (float)InternalMathKt.radToDeg((double)$this$radToDeg);
    }

    public static final float gradToDeg(float $this$gradToDeg) {
        return $this$gradToDeg * 0.9f;
    }

    public static final float turnToDeg(float $this$turnToDeg) {
        return $this$turnToDeg * 360.0f;
    }

    public static final float degToGrad(float $this$degToGrad) {
        return $this$degToGrad * 200.0f / 180.0f;
    }

    public static final float degToTurns(float $this$degToTurns) {
        return $this$degToTurns / 360.0f;
    }

    public static final double radToDeg(double $this$radToDeg) {
        return $this$radToDeg * 180.0 / Math.PI;
    }

    public static final double degToRad(double $this$degToRad) {
        return $this$degToRad * Math.PI / 180.0;
    }

    public static final double cosDeg(double deg) {
        double d = InternalMathKt.degToRad(deg);
        boolean bl = false;
        return Math.cos(d);
    }

    public static final double sinDeg(double deg) {
        double d = InternalMathKt.degToRad(deg);
        boolean bl = false;
        return Math.sin(d);
    }

    public static final float normalizeDeg(float $this$normalizeDeg) {
        return ($this$normalizeDeg % 360.0f + 360.0f) % 360.0f;
    }

    public static final double normalizeDeg(double $this$normalizeDeg) {
        return ($this$normalizeDeg % 360.0 + 360.0) % 360.0;
    }

    public static final double nanToZero(double $this$nanToZero) {
        double d = $this$nanToZero;
        boolean bl = false;
        return Double.isNaN(d) ? 0.0 : $this$nanToZero;
    }

    public static final float nanToOne(float $this$nanToOne) {
        float f = $this$nanToOne;
        boolean bl = false;
        return Float.isNaN(f) ? 1.0f : $this$nanToOne;
    }

    public static final <T> T toPolarModel(float a, float b, @NotNull Function2<? super Float, ? super Float, ? extends T> block) {
        float f;
        Intrinsics.checkNotNullParameter(block, "block");
        boolean $i$f$toPolarModel = false;
        float f2 = a * a + b * b;
        boolean bl = false;
        float c = (float)Math.sqrt(f2);
        if ((double)c > -1.0E-7 && (double)c < 1.0E-7) {
            f = Float.NaN;
        } else {
            bl = false;
            f = InternalMathKt.radToDeg((float)Math.atan2(b, a));
        }
        float h = f;
        return block.invoke(Float.valueOf(c), Float.valueOf(InternalMathKt.normalizeDeg(h)));
    }

    public static final <T> T fromPolarModel(float c, float h, @NotNull Function2<? super Float, ? super Float, ? extends T> block) {
        Intrinsics.checkNotNullParameter(block, "block");
        boolean $i$f$fromPolarModel = false;
        float f = h;
        boolean bl = false;
        float hDegrees = Float.isNaN(f) ? 0.0f : InternalMathKt.degToRad(h);
        bl = false;
        float a = c * (float)Math.cos(hDegrees);
        boolean bl2 = false;
        float b = c * (float)Math.sin(hDegrees);
        return block.invoke(Float.valueOf(a), Float.valueOf(b));
    }

    public static final double spow(double $this$spow, double p) {
        double d = $this$spow;
        boolean bl = false;
        d = Math.abs(d);
        bl = false;
        d = Math.pow(d, p);
        bl = false;
        return Math.copySign(d, $this$spow);
    }

    public static final double spow(float $this$spow, double p) {
        return InternalMathKt.spow((double)$this$spow, p);
    }

    public static final float sqrtSumSq(float a, float b, float c) {
        float f = a;
        int n = 2;
        boolean bl = false;
        float f2 = (float)Math.pow(f, n);
        f = b;
        n = 2;
        bl = false;
        float f3 = f2 + (float)Math.pow(f, n);
        f = c;
        n = 2;
        bl = false;
        f = f3 + (float)Math.pow(f, n);
        n = 0;
        return (float)Math.sqrt(f);
    }

    public static final double sqrtSumSq(double a, double b) {
        double d = a;
        int n = 2;
        boolean bl = false;
        double d2 = Math.pow(d, n);
        d = b;
        n = 2;
        bl = false;
        d = d2 + Math.pow(d, n);
        n = 0;
        return Math.sqrt(d);
    }

    public static final double sqrtSumSq(double a, double b, double c) {
        double d = a;
        int n = 2;
        boolean bl = false;
        double d2 = Math.pow(d, n);
        d = b;
        n = 2;
        bl = false;
        double d3 = d2 + Math.pow(d, n);
        d = c;
        n = 2;
        bl = false;
        d = d3 + Math.pow(d, n);
        n = 0;
        return Math.sqrt(d);
    }

    public static final float scaleRange(float l1, float r1, float l2, float r2, float t) {
        return r1 == l1 ? t : (r2 - l2) * (t - l1) / (r1 - l1) + l2;
    }
}

