# tikztosvg(1)

Pablo Emilio Escobar Gaviria &lt;<pablo-escobar@riseup.net>&gt;  

The `tikztosvg(1)` command renders TikZ diagrams to SVG, using [`xetex`](http://xetex.sourceforge.net/) and [`pdf2svg`](https://github.com/dawbarton/pdf2svg).

## Usage

    tikztosvg [OPTION]... INPUT_PATH

If *INPUT\_PATH* is set to *-* the input will be read from stdin.

### Options

**-o, --output**=*OUTPUT\_PATH*  
Write output to file *OUTPUT\_PATH*. If set to *-* the output will be written to stdout. Defaults to the base name of the input file suffixed with the *.svg* extension. The file is resolved relative to the working directory.

**-p, --package**=+*PACKAGE*  
Include `\usepackage{PACKAGE}` when rendering the diagram.

**-q, --quiet**  
Silence application log messages and script warnings.

**-h, --help**  
Print a help message.

**-v, --version**  
Print version information.

## Example

Let’s say you want to convert the file `example.tikz` to SVG:

``` latex
\begin{tikzcd}
    G \arrow[r, "\varphi"] \arrow[d, "\psi"', two heads] & H \\
    \sfrac{G}{\ker \varphi} \arrow[ru, dotted]           &
\end{tikzcd}
```

You could achieve that by running the following command:

    tikztosvg -p tikz-cd -p xfrac example.tikz

The results will be stored in the file `example.svg`:

![example](examples/example.svg)

## Installation

The `tikztosvg(1)` command and it’s man page can be installed in Unix systems by running:

    $ curl -s https://gitlab.com/pablo-escobar/tikztosvg/-/raw/master/install.sh | sudo sh

The executable is installed in `$HOME/.local/bin/` and the man-page is installed in `$HOME/.local/share/man/man1/`.

## Authors

**tikztosvg** was written by [Pablo Emilio Escobar Gaviria](mailto:pablo-escobar@riseup.net).

**pdf2svg** was written by [David Barton](mailto:davebarton@cityinthesky.co.uk) and [Matthew Flaschen](mailto:matthew.flaschen@gatech.edu).

## License

© 2020 Pablo Emilio Escobar Gaviria.

Free use of this software is granted under the terms of the GPL-3.0 License.
