// -*- c++ -*-
// Generated by gmmproc 2.38.1 -- DO NOT MODIFY!
#ifndef _LIBGDAMM_METASTRUCT_H
#define _LIBGDAMM_METASTRUCT_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

// -*- C++ -*- //

/* metastore.h
 *
 * Copyright 2006 libgdamm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or(at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libgdamm/value.h>
#include <glibmm/object.h>
#include <glibmm/error.h>
#include <libgda/gda-meta-struct.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdaMetaStruct GdaMetaStruct;
typedef struct _GdaMetaStructClass GdaMetaStructClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{ class MetaStruct_Class; } // namespace Gda

} // namespace Gnome
namespace Gnome
{

namespace Gda
{

/** Exception class for Gda MetaStruct errors.
 */
class MetaStructError : public Glib::Error
{
public:
  enum Code
  {
    META_STRUCT_UNKNOWN_OBJECT_ERROR,
    META_STRUCT_DUPLICATE_OBJECT_ERROR,
    META_STRUCT_INCOHERENCE_ERROR,
    META_STRUCT_XML_ERROR
  };

  MetaStructError(Code error_code, const Glib::ustring& error_message);
  explicit MetaStructError(GError* gobject);
  Code code() const;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
private:

  static void throw_func(GError* gobject);

  friend void wrap_init(); // uses throw_func()

  #endif //DOXYGEN_SHOULD_SKIP_THIS
};

} // namespace Gda

} // namespace Gnome

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::Gda::MetaStructError::Code> : public Glib::Value_Enum<Gnome::Gda::MetaStructError::Code>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{


/** @addtogroup libgdammEnums libgdamm Enums and Flags */

/** 
 * 
 * @ingroup libgdammEnums
 * @par Bitwise operators:
 * <tt>%MetaStructFeature operator|(MetaStructFeature, MetaStructFeature)</tt><br>
 * <tt>%MetaStructFeature operator&(MetaStructFeature, MetaStructFeature)</tt><br>
 * <tt>%MetaStructFeature operator^(MetaStructFeature, MetaStructFeature)</tt><br>
 * <tt>%MetaStructFeature operator~(MetaStructFeature)</tt><br>
 * <tt>%MetaStructFeature& operator|=(MetaStructFeature&, MetaStructFeature)</tt><br>
 * <tt>%MetaStructFeature& operator&=(MetaStructFeature&, MetaStructFeature)</tt><br>
 * <tt>%MetaStructFeature& operator^=(MetaStructFeature&, MetaStructFeature)</tt><br>
 */
enum MetaStructFeature
{
  META_STRUCT_FEATURE_NONE = 0x0,
  META_STRUCT_FEATURE_FOREIGN_KEYS = 1 << 0,
  META_STRUCT_FEATURE_VIEW_DEPENDENCIES = 1 << 1,
  META_STRUCT_FEATURE_ALL = 0x3
};

/** @ingroup libgdammEnums */
inline MetaStructFeature operator|(MetaStructFeature lhs, MetaStructFeature rhs)
  { return static_cast<MetaStructFeature>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup libgdammEnums */
inline MetaStructFeature operator&(MetaStructFeature lhs, MetaStructFeature rhs)
  { return static_cast<MetaStructFeature>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup libgdammEnums */
inline MetaStructFeature operator^(MetaStructFeature lhs, MetaStructFeature rhs)
  { return static_cast<MetaStructFeature>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup libgdammEnums */
inline MetaStructFeature operator~(MetaStructFeature flags)
  { return static_cast<MetaStructFeature>(~static_cast<unsigned>(flags)); }

/** @ingroup libgdammEnums */
inline MetaStructFeature& operator|=(MetaStructFeature& lhs, MetaStructFeature rhs)
  { return (lhs = static_cast<MetaStructFeature>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup libgdammEnums */
inline MetaStructFeature& operator&=(MetaStructFeature& lhs, MetaStructFeature rhs)
  { return (lhs = static_cast<MetaStructFeature>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup libgdammEnums */
inline MetaStructFeature& operator^=(MetaStructFeature& lhs, MetaStructFeature rhs)
  { return (lhs = static_cast<MetaStructFeature>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gda

} // namespace Gnome


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::Gda::MetaStructFeature> : public Glib::Value_Flags<Gnome::Gda::MetaStructFeature>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{

/** 
 * 
 * @ingroup libgdammEnums
 */
enum MetaDbObjectType
{
  META_DB_UNKNOWN,
  META_DB_TABLE,
  META_DB_VIEW
};

} // namespace Gda

} // namespace Gnome


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::Gda::MetaDbObjectType> : public Glib::Value_Enum<Gnome::Gda::MetaDbObjectType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{

/** 
 * 
 * @ingroup libgdammEnums
 */
enum MetaSortType
{
  META_SORT_ALHAPETICAL,
  META_SORT_DEPENDENCIES
};

} // namespace Gda

} // namespace Gnome


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::Gda::MetaSortType> : public Glib::Value_Enum<Gnome::Gda::MetaSortType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{

/** 
 * 
 * @ingroup libgdammEnums
 * @par Bitwise operators:
 * <tt>%MetaGraphInfo operator|(MetaGraphInfo, MetaGraphInfo)</tt><br>
 * <tt>%MetaGraphInfo operator&(MetaGraphInfo, MetaGraphInfo)</tt><br>
 * <tt>%MetaGraphInfo operator^(MetaGraphInfo, MetaGraphInfo)</tt><br>
 * <tt>%MetaGraphInfo operator~(MetaGraphInfo)</tt><br>
 * <tt>%MetaGraphInfo& operator|=(MetaGraphInfo&, MetaGraphInfo)</tt><br>
 * <tt>%MetaGraphInfo& operator&=(MetaGraphInfo&, MetaGraphInfo)</tt><br>
 * <tt>%MetaGraphInfo& operator^=(MetaGraphInfo&, MetaGraphInfo)</tt><br>
 */
enum MetaGraphInfo
{
  META_GRAPH_COLUMNS = 1 << 0
};

/** @ingroup libgdammEnums */
inline MetaGraphInfo operator|(MetaGraphInfo lhs, MetaGraphInfo rhs)
  { return static_cast<MetaGraphInfo>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup libgdammEnums */
inline MetaGraphInfo operator&(MetaGraphInfo lhs, MetaGraphInfo rhs)
  { return static_cast<MetaGraphInfo>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup libgdammEnums */
inline MetaGraphInfo operator^(MetaGraphInfo lhs, MetaGraphInfo rhs)
  { return static_cast<MetaGraphInfo>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup libgdammEnums */
inline MetaGraphInfo operator~(MetaGraphInfo flags)
  { return static_cast<MetaGraphInfo>(~static_cast<unsigned>(flags)); }

/** @ingroup libgdammEnums */
inline MetaGraphInfo& operator|=(MetaGraphInfo& lhs, MetaGraphInfo rhs)
  { return (lhs = static_cast<MetaGraphInfo>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup libgdammEnums */
inline MetaGraphInfo& operator&=(MetaGraphInfo& lhs, MetaGraphInfo rhs)
  { return (lhs = static_cast<MetaGraphInfo>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup libgdammEnums */
inline MetaGraphInfo& operator^=(MetaGraphInfo& lhs, MetaGraphInfo rhs)
  { return (lhs = static_cast<MetaGraphInfo>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gda

} // namespace Gnome


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::Gda::MetaGraphInfo> : public Glib::Value_Flags<Gnome::Gda::MetaGraphInfo>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{
 

class MetaStore;

/** In-memory representation of some database objects.
 *
 * The Gda::MetaStruct object reads data from a Gda::MetaStore object and creates 
 * an easy to use in memory representation for some database objects. For example
 * one can easily analyse the columns of a table (or its foreign keys) using a 
 * Gda::MetaStruct.
 *
 * When created, the new Gda::MetaStruct object is empty (it does not have any 
 * information about any database object). Information about database objects is 
 * computed upon request using the gda_meta_struct_complement() method. Information 
 * about individual database objects is represented by GdaMetaDbObject structures, 
 * which can be obtained using get_db_object() or get_all_db_objects().
 * 
 * Note that the Gda::MetaDbObject structures may change or may be removed or 
 * replaced by others, so it not advised to keep pointers to these structures: 
 * pointers to these structures should be considered valid as long as 
 * complement() and other similar functions have not been called. 
 *
 * @ingroup Connection
 */

class MetaStruct : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef MetaStruct CppObjectType;
  typedef MetaStruct_Class CppClassType;
  typedef GdaMetaStruct BaseObjectType;
  typedef GdaMetaStructClass BaseClassType;

private:  friend class MetaStruct_Class;
  static CppClassType metastruct_class_;

private:
  // noncopyable
  MetaStruct(const MetaStruct&);
  MetaStruct& operator=(const MetaStruct&);

protected:
  explicit MetaStruct(const Glib::ConstructParams& construct_params);
  explicit MetaStruct(GdaMetaStruct* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~MetaStruct();

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdaMetaStruct*       gobj()       { return reinterpret_cast<GdaMetaStruct*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GdaMetaStruct* gobj() const { return reinterpret_cast<GdaMetaStruct*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GdaMetaStruct* gobj_copy();

private:

protected:
    explicit MetaStruct(const Glib::RefPtr<MetaStore>& meta_store, MetaStructFeature features);


public:
  
  static Glib::RefPtr<MetaStruct> create(const Glib::RefPtr<MetaStore>& store, MetaStructFeature features =  META_STRUCT_FEATURE_ALL);

  
  //TODO: Wrap GdaMetaDbObject?
  
  /** Creates a new Gda::MetaDbObject structure in @a mstruct to represent the database object (of type @a type)
   * which can be uniquely identified as @a catalog. @a schema. @a name.
   * 
   * If @a catalog is not <tt>0</tt>, then @a schema should not be <tt>0</tt>.
   * 
   * If both @a catalog and @a schema are <tt>0</tt>, then the database object will be the one which is
   * "visible" by default (that is which can be accessed only by its short @a name name).
   * 
   * If @a catalog is <tt>0</tt> and @a schema is not <tt>0</tt>, then the database object will be the one which 
   * can be accessed by its @a schema. @a name name.
   * 
   * Important note: @a catalog, @a schema and @a name will be used using the following convention:
   * - be surrounded by double quotes for a case sensitive search
   * - otherwise for case insensitive search
   * 
   * For more information, see the 
   * meta data section about SQL identifiers.
   * @param type The type of object to add (which can be GDA_META_DB_UNKNOWN).
   * @param catalog The catalog the object belongs to (as a G_TYPE_STRING GValue), or <tt>0</tt>.
   * @param schema The schema the object belongs to (as a G_TYPE_STRING GValue), or <tt>0</tt>.
   * @param name The object's name (as a G_TYPE_STRING GValue), not <tt>0</tt>.
   * @return The Gda::MetaDbObject corresponding to the database object if no error occurred, or <tt>0</tt>.
   */
  GdaMetaDbObject* complement(MetaDbObjectType type, const Value& catalog, const Value& schema, const Value& name);
  
  /** This method is similar to complement() but creates Gda::MetaDbObject for all the
   * database object which are in the @a schema schema (and in the @a catalog catalog).
   * If @a catalog is <tt>0</tt>, then any catalog will be used, and
   * if @a schema is <tt>0</tt> then any schema will be used (if @a schema is <tt>0</tt> then catalog must also be <tt>0</tt>).
   * 
   * Please refer to complement() form more information.
   * @param catalog Name of a catalog, or <tt>0</tt>.
   * @param schema Name of a schema, or <tt>0</tt>.
   * @return <tt>true</tt> if no error occurred.
   */
  bool complement_schema(const Value& catalog, const Value& schema);
  
  /** This method is similar to complement() and complement_all()
   * but creates Gda::MetaDbObject for all the
   * database object which are usable using only their short name (that is which do not need to be prefixed by 
   * the schema in which they are to be used).
   * 
   * Please refer to complement() form more information.
   * @return <tt>true</tt> if no error occurred.
   */
  bool complement_default();
   // private API   

  
  /** Reorders the list of database objects within @a mstruct in a way specified by @a sort_type.
   * @param sort_type The kind of sorting requested.
   * @return <tt>true</tt> if no error occurred.
   */
  bool sort_db_object(MetaSortType sort_type);
    
  /** Tries to locate the Gda::MetaDbObject structure representing the database object named after
   *  @a catalog, @a schema and @a name.
   * 
   * If one or both of @a catalog and @a schema are <tt>0</tt>, and more than one database object matches the name, then
   * the return value is also <tt>0</tt>.
   * @param catalog The catalog the object belongs to (as a G_TYPE_STRING GValue), or <tt>0</tt>.
   * @param schema The schema the object belongs to (as a G_TYPE_STRING GValue), or <tt>0</tt>.
   * @param name The object's name (as a G_TYPE_STRING GValue), not <tt>0</tt>.
   * @return The Gda::MetaDbObject or <tt>0</tt> if not found.
   */
  GdaMetaDbObject* get_db_object(const Value& catalog, const Value& schema, const Value& name);

  //TODO: Wrap GdaMetaTable and GdaMetaDbObject? They seem to be bare C structs.
  //http://library.gnome.org/devel/libgda/unstable/GdaMetaStruct.html#GdaMetaTable
  
  GdaMetaTableColumn* get_table_column(GdaMetaTable* table, const Value& col_name);
  
  /** Creates a new graph (in the GraphViz syntax) representation of @a mstruct.
   * @param info Informs what kind of information to show in the resulting graph.
   * @return A new string, or <tt>0</tt> if an error occurred.
   */
  Glib::ustring dump_as_graph(MetaGraphInfo info);
  
  
  /** This method is similar to complement() and complement_default()
   * but creates Gda::MetaDbObject for all the database object.
   * 
   * Please refer to complement() form more information.
   * @return <tt>true</tt> if no error occurred.
   */
  bool complement_all();
    
  // TODO: Use C++ type.
  // See http://bugzilla.gnome.org/show_bug.cgi?id=574740
  
  /** Get a list of all the Gda::MetaDbObject structures representing database objects in @a mstruct. Note that
   * no Gda::MetaDbObject structure must not be modified.
   * @return A new SList list of pointers to Gda::MetaDbObject structures which must be destroyed after usage using Glib::slist_free(). The individual Gda::MetaDbObject must not be modified.
   */
  GSList* get_all_db_objects();
    
  //Ignore private functions.
  
  
  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< guint > property_features() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gda
} // namespace Gnome


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gnome::Gda::MetaStruct
   */
  Glib::RefPtr<Gnome::Gda::MetaStruct> wrap(GdaMetaStruct* object, bool take_copy = false);
}


#endif /* _LIBGDAMM_METASTRUCT_H */

