/* midori-tab.c generated by valac 0.38.8, the Vala compiler
 * generated from midori-tab.vala, do not modify */

/*
 Copyright (C) 2007-2013 Christian Dywan <christian@twotoasts.de>
 Copyright (C) 2009 Jean-François Guchens <zcx000@gmail.com>
 Copyright (C) 2011 Peter Hatina <phatina@redhat.com>

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.

 See the file COPYING for the full license text.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include "webkit/webkit.h"
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <pango/pango.h>


#define MIDORI_TYPE_NEW_VIEW (midori_new_view_get_type ())

#define MIDORI_TYPE_SECURITY (midori_security_get_type ())

#define MIDORI_TYPE_LOAD_STATUS (midori_load_status_get_type ())

#define MIDORI_TYPE_LOAD_ERROR (midori_load_error_get_type ())

#define MIDORI_TYPE_TAB (midori_tab_get_type ())
#define MIDORI_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MIDORI_TYPE_TAB, MidoriTab))
#define MIDORI_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MIDORI_TYPE_TAB, MidoriTabClass))
#define MIDORI_IS_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MIDORI_TYPE_TAB))
#define MIDORI_IS_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MIDORI_TYPE_TAB))
#define MIDORI_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MIDORI_TYPE_TAB, MidoriTabClass))

typedef struct _MidoriTab MidoriTab;
typedef struct _MidoriTabClass MidoriTabClass;
typedef struct _MidoriTabPrivate MidoriTabPrivate;
enum  {
	MIDORI_TAB_0_PROPERTY,
	MIDORI_TAB_RELATED_PROPERTY,
	MIDORI_TAB_WEB_VIEW_PROPERTY,
	MIDORI_TAB_URI_PROPERTY,
	MIDORI_TAB_SPECIAL_PROPERTY,
	MIDORI_TAB_MINIMIZED_PROPERTY,
	MIDORI_TAB_MIME_TYPE_PROPERTY,
	MIDORI_TAB_SECURITY_PROPERTY,
	MIDORI_TAB_LOAD_STATUS_PROPERTY,
	MIDORI_TAB_LOAD_ERROR_PROPERTY,
	MIDORI_TAB_STATUSBAR_TEXT_PROPERTY,
	MIDORI_TAB_PROGRESS_PROPERTY,
	MIDORI_TAB_IS_DIALOG_PROPERTY,
	MIDORI_TAB_VIEW_SOURCE_PROPERTY,
	MIDORI_TAB_NUM_PROPERTIES
};
static GParamSpec* midori_tab_properties[MIDORI_TAB_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _MidoriTabUpdateActionsData MidoriTabUpdateActionsData;

#define MIDORI_TYPE_CONTEXT_ACTION (midori_context_action_get_type ())
#define MIDORI_CONTEXT_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MIDORI_TYPE_CONTEXT_ACTION, MidoriContextAction))
#define MIDORI_CONTEXT_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MIDORI_TYPE_CONTEXT_ACTION, MidoriContextActionClass))
#define MIDORI_IS_CONTEXT_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MIDORI_TYPE_CONTEXT_ACTION))
#define MIDORI_IS_CONTEXT_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MIDORI_TYPE_CONTEXT_ACTION))
#define MIDORI_CONTEXT_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MIDORI_TYPE_CONTEXT_ACTION, MidoriContextActionClass))

typedef struct _MidoriContextAction MidoriContextAction;
typedef struct _MidoriContextActionClass MidoriContextActionClass;
enum  {
	MIDORI_TAB_COLORS_CHANGED_SIGNAL,
	MIDORI_TAB_OPEN_URI_SIGNAL,
	MIDORI_TAB_NAVIGATION_REQUESTED_SIGNAL,
	MIDORI_TAB_CONSOLE_MESSAGE_SIGNAL,
	MIDORI_TAB_ATTACH_INSPECTOR_SIGNAL,
	MIDORI_TAB_DETACH_INSPECTOR_SIGNAL,
	MIDORI_TAB_SEARCH_TEXT_SIGNAL,
	MIDORI_TAB_CONTEXT_MENU_SIGNAL,
	MIDORI_TAB_NUM_SIGNALS
};
static guint midori_tab_signals[MIDORI_TAB_NUM_SIGNALS] = {0};

typedef enum  {
	MIDORI_NEW_VIEW_TAB,
	MIDORI_NEW_VIEW_BACKGROUND,
	MIDORI_NEW_VIEW_WINDOW
} MidoriNewView;

typedef enum  {
	MIDORI_SECURITY_NONE,
	MIDORI_SECURITY_UNKNOWN,
	MIDORI_SECURITY_TRUSTED
} MidoriSecurity;

typedef enum  {
	MIDORI_LOAD_FINISHED,
	MIDORI_LOAD_COMMITTED,
	MIDORI_LOAD_PROVISIONAL
} MidoriLoadStatus;

typedef enum  {
	MIDORI_LOAD_ERROR_NONE,
	MIDORI_LOAD_ERROR_DELAYED,
	MIDORI_LOAD_ERROR_SECURITY,
	MIDORI_LOAD_ERROR_CRASH,
	MIDORI_LOAD_ERROR_NETWORK
} MidoriLoadError;

struct _MidoriTab {
	GtkVBox parent_instance;
	MidoriTabPrivate * priv;
};

struct _MidoriTabClass {
	GtkVBoxClass parent_class;
};

struct _MidoriTabPrivate {
	MidoriTab* _related;
	WebKitWebView* _web_view;
	gchar* current_uri;
	gboolean _special;
	gboolean _minimized;
	gchar* _mime_type;
	MidoriSecurity _security;
	MidoriLoadStatus _load_status;
	MidoriLoadError _load_error;
	gchar* _statusbar_text;
	GdkColor* _fg_color;
	GdkColor* bg_color_;
	gdouble current_progress;
	gboolean _is_dialog;
	gboolean _view_source;
};

struct _MidoriTabUpdateActionsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	MidoriTab* self;
	GtkActionGroup* actions;
	GtkActionGroup* _tmp0_;
	GtkAction* _tmp1_;
	WebKitWebView* _tmp2_;
	gboolean _tmp3_;
	GtkActionGroup* _tmp4_;
	GtkAction* _tmp5_;
	WebKitWebView* _tmp6_;
	gboolean _tmp7_;
	GtkActionGroup* _tmp8_;
	GtkAction* _tmp9_;
	WebKitWebView* _tmp10_;
	gboolean _tmp11_;
	GtkActionGroup* _tmp12_;
	GtkAction* _tmp13_;
	WebKitWebView* _tmp14_;
	gboolean _tmp15_;
	GtkActionGroup* _tmp16_;
	GtkAction* _tmp17_;
	WebKitWebView* _tmp18_;
	gboolean _tmp19_;
	GtkActionGroup* _tmp20_;
	GtkAction* _tmp21_;
	WebKitWebView* _tmp22_;
	gboolean _tmp23_;
	GtkActionGroup* _tmp24_;
	GtkAction* _tmp25_;
};


static gpointer midori_tab_parent_class = NULL;

GType midori_new_view_get_type (void) G_GNUC_CONST;
GType midori_security_get_type (void) G_GNUC_CONST;
GType midori_load_status_get_type (void) G_GNUC_CONST;
GType midori_load_error_get_type (void) G_GNUC_CONST;
GType midori_tab_get_type (void) G_GNUC_CONST;
#define MIDORI_TAB_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), MIDORI_TYPE_TAB, MidoriTabPrivate))
gboolean midori_tab_is_blank (MidoriTab* self);
gboolean midori_uri_is_blank (const gchar* uri);
const gchar* midori_tab_get_uri (MidoriTab* self);
void midori_tab_inject_stylesheet (MidoriTab* self, const gchar* stylesheet);
WebKitWebView* midori_tab_get_web_view (MidoriTab* self);
gboolean midori_tab_can_view_source (MidoriTab* self);
gboolean midori_tab_get_view_source (MidoriTab* self);
const gchar* midori_tab_get_mime_type (MidoriTab* self);
gchar* midori_tab_get_display_title (const gchar* title, const gchar* uri);
gchar* midori_uri_strip_prefix_for_display (const gchar* uri);
PangoEllipsizeMode midori_tab_get_display_ellipsize (const gchar* title, const gchar* uri);
gboolean midori_tab_can_save (MidoriTab* self);
gboolean midori_tab_get_special (MidoriTab* self);
void midori_tab_stop_loading (MidoriTab* self);
gboolean midori_tab_can_go_forward (MidoriTab* self);
void midori_tab_go_forward (MidoriTab* self);
void midori_tab_unmark_text_matches (MidoriTab* self);
gboolean midori_tab_find (MidoriTab* self, const gchar* text, gboolean case_sensitive, gboolean forward);
static void midori_tab_update_actions_data_free (gpointer _data);
static void midori_tab_update_actions_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data);
void midori_tab_update_actions (MidoriTab* self, GtkActionGroup* actions, GAsyncReadyCallback _callback_, gpointer _user_data_);
void midori_tab_update_actions_finish (MidoriTab* self, GAsyncResult* _res_);
static gboolean midori_tab_update_actions_co (MidoriTabUpdateActionsData* _data_);
MidoriTab* midori_tab_new (void);
MidoriTab* midori_tab_construct (GType object_type);
MidoriTab* midori_tab_get_related (MidoriTab* self);
void midori_tab_set_related (MidoriTab* self, MidoriTab* value);
static void midori_tab_set_web_view (MidoriTab* self, WebKitWebView* value);
void midori_tab_set_uri (MidoriTab* self, const gchar* value);
gchar* midori_uri_format_for_display (const gchar* uri);
void midori_tab_set_special (MidoriTab* self, gboolean value);
gboolean midori_tab_get_minimized (MidoriTab* self);
void midori_tab_set_minimized (MidoriTab* self, gboolean value);
void midori_tab_set_mime_type (MidoriTab* self, const gchar* value);
MidoriSecurity midori_tab_get_security (MidoriTab* self);
void midori_tab_set_security (MidoriTab* self, MidoriSecurity value);
MidoriLoadStatus midori_tab_get_load_status (MidoriTab* self);
void midori_tab_set_load_status (MidoriTab* self, MidoriLoadStatus value);
MidoriLoadError midori_tab_get_load_error (MidoriTab* self);
void midori_tab_set_load_error (MidoriTab* self, MidoriLoadError value);
const gchar* midori_tab_get_statusbar_text (MidoriTab* self);
void midori_tab_set_statusbar_text (MidoriTab* self, const gchar* value);
GdkColor* midori_tab_get_fg_color (MidoriTab* self);
void midori_tab_set_fg_color (MidoriTab* self, GdkColor* value);
static GdkColor* _gdk_color_dup (GdkColor* self);
GdkColor* midori_tab_get_bg_color (MidoriTab* self);
void midori_tab_set_bg_color (MidoriTab* self, GdkColor* value);
gdouble midori_tab_get_progress (MidoriTab* self);
void midori_tab_set_progress (MidoriTab* self, gdouble value);
gboolean midori_tab_get_is_dialog (MidoriTab* self);
void midori_tab_set_is_dialog (MidoriTab* self, gboolean value);
static void midori_tab_set_view_source (MidoriTab* self, gboolean value);
static void g_cclosure_user_marshal_BOOLEAN__STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__STRING_INT_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__BOOLEAN_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
GType midori_context_action_get_type (void) G_GNUC_CONST;
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static GObject * midori_tab_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void midori_tab_finalize (GObject * obj);
static void _vala_midori_tab_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_midori_tab_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GType midori_new_view_get_type (void) {
	static volatile gsize midori_new_view_type_id__volatile = 0;
	if (g_once_init_enter (&midori_new_view_type_id__volatile)) {
		static const GEnumValue values[] = {{MIDORI_NEW_VIEW_TAB, "MIDORI_NEW_VIEW_TAB", "tab"}, {MIDORI_NEW_VIEW_BACKGROUND, "MIDORI_NEW_VIEW_BACKGROUND", "background"}, {MIDORI_NEW_VIEW_WINDOW, "MIDORI_NEW_VIEW_WINDOW", "window"}, {0, NULL, NULL}};
		GType midori_new_view_type_id;
		midori_new_view_type_id = g_enum_register_static ("MidoriNewView", values);
		g_once_init_leave (&midori_new_view_type_id__volatile, midori_new_view_type_id);
	}
	return midori_new_view_type_id__volatile;
}


GType midori_security_get_type (void) {
	static volatile gsize midori_security_type_id__volatile = 0;
	if (g_once_init_enter (&midori_security_type_id__volatile)) {
		static const GEnumValue values[] = {{MIDORI_SECURITY_NONE, "MIDORI_SECURITY_NONE", "none"}, {MIDORI_SECURITY_UNKNOWN, "MIDORI_SECURITY_UNKNOWN", "unknown"}, {MIDORI_SECURITY_TRUSTED, "MIDORI_SECURITY_TRUSTED", "trusted"}, {0, NULL, NULL}};
		GType midori_security_type_id;
		midori_security_type_id = g_enum_register_static ("MidoriSecurity", values);
		g_once_init_leave (&midori_security_type_id__volatile, midori_security_type_id);
	}
	return midori_security_type_id__volatile;
}


GType midori_load_status_get_type (void) {
	static volatile gsize midori_load_status_type_id__volatile = 0;
	if (g_once_init_enter (&midori_load_status_type_id__volatile)) {
		static const GEnumValue values[] = {{MIDORI_LOAD_FINISHED, "MIDORI_LOAD_FINISHED", "finished"}, {MIDORI_LOAD_COMMITTED, "MIDORI_LOAD_COMMITTED", "committed"}, {MIDORI_LOAD_PROVISIONAL, "MIDORI_LOAD_PROVISIONAL", "provisional"}, {0, NULL, NULL}};
		GType midori_load_status_type_id;
		midori_load_status_type_id = g_enum_register_static ("MidoriLoadStatus", values);
		g_once_init_leave (&midori_load_status_type_id__volatile, midori_load_status_type_id);
	}
	return midori_load_status_type_id__volatile;
}


GType midori_load_error_get_type (void) {
	static volatile gsize midori_load_error_type_id__volatile = 0;
	if (g_once_init_enter (&midori_load_error_type_id__volatile)) {
		static const GEnumValue values[] = {{MIDORI_LOAD_ERROR_NONE, "MIDORI_LOAD_ERROR_NONE", "none"}, {MIDORI_LOAD_ERROR_DELAYED, "MIDORI_LOAD_ERROR_DELAYED", "delayed"}, {MIDORI_LOAD_ERROR_SECURITY, "MIDORI_LOAD_ERROR_SECURITY", "security"}, {MIDORI_LOAD_ERROR_CRASH, "MIDORI_LOAD_ERROR_CRASH", "crash"}, {MIDORI_LOAD_ERROR_NETWORK, "MIDORI_LOAD_ERROR_NETWORK", "network"}, {0, NULL, NULL}};
		GType midori_load_error_type_id;
		midori_load_error_type_id = g_enum_register_static ("MidoriLoadError", values);
		g_once_init_leave (&midori_load_error_type_id__volatile, midori_load_error_type_id);
	}
	return midori_load_error_type_id__volatile;
}


gboolean midori_tab_is_blank (MidoriTab* self) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_;
#line 127 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 128 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp0_ = midori_tab_get_uri (self);
#line 128 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp1_ = _tmp0_;
#line 128 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp2_ = midori_uri_is_blank (_tmp1_);
#line 128 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	result = _tmp2_;
#line 128 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	return result;
#line 325 "midori-tab.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 148 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	return self ? g_object_ref (self) : NULL;
#line 332 "midori-tab.c"
}


void midori_tab_inject_stylesheet (MidoriTab* self, const gchar* stylesheet) {
	WebKitDOMDocument* dom = NULL;
	WebKitWebView* _tmp0_;
	WebKitDOMDocument* _tmp1_;
	WebKitDOMDocument* _tmp2_;
	WebKitDOMDocument* _tmp3_;
	WebKitDOMHTMLElement* _tmp4_;
	WebKitDOMHTMLElement* _tmp5_;
	GError * _inner_error_ = NULL;
#line 146 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_return_if_fail (self != NULL);
#line 146 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_return_if_fail (stylesheet != NULL);
#line 148 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp0_ = self->priv->_web_view;
#line 148 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp1_ = webkit_web_view_get_dom_document (_tmp0_);
#line 148 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 148 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	dom = _tmp2_;
#line 149 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp3_ = dom;
#line 149 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp4_ = webkit_dom_document_get_head (_tmp3_);
#line 149 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp5_ = _tmp4_;
#line 149 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_return_if_fail (_tmp5_ != NULL);
#line 365 "midori-tab.c"
	{
		WebKitDOMElement* style = NULL;
		WebKitDOMDocument* _tmp6_;
		WebKitDOMElement* _tmp7_;
		WebKitDOMElement* _tmp8_;
		WebKitDOMElement* _tmp9_;
		WebKitDOMElement* _tmp10_;
		WebKitDOMDocument* _tmp11_;
		const gchar* _tmp12_;
		WebKitDOMText* _tmp13_;
		WebKitDOMDocument* _tmp14_;
		WebKitDOMHTMLElement* _tmp15_;
		WebKitDOMHTMLElement* _tmp16_;
		WebKitDOMElement* _tmp17_;
#line 151 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_tmp6_ = dom;
#line 151 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_tmp7_ = webkit_dom_document_create_element (_tmp6_, "style", &_inner_error_);
#line 151 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_tmp8_ = _g_object_ref0 (_tmp7_);
#line 151 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		style = _tmp8_;
#line 151 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 390 "midori-tab.c"
			goto __catch37_g_error;
		}
#line 152 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_tmp9_ = style;
#line 152 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		webkit_dom_element_set_attribute (_tmp9_, "type", "text/css", &_inner_error_);
#line 152 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 152 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
			_g_object_unref0 (style);
#line 401 "midori-tab.c"
			goto __catch37_g_error;
		}
#line 153 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_tmp10_ = style;
#line 153 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_tmp11_ = dom;
#line 153 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_tmp12_ = stylesheet;
#line 153 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_tmp13_ = webkit_dom_document_create_text_node (_tmp11_, _tmp12_);
#line 153 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		webkit_dom_node_append_child ((WebKitDOMNode*) _tmp10_, (WebKitDOMNode*) _tmp13_, &_inner_error_);
#line 153 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 153 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
			_g_object_unref0 (style);
#line 418 "midori-tab.c"
			goto __catch37_g_error;
		}
#line 154 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_tmp14_ = dom;
#line 154 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_tmp15_ = webkit_dom_document_get_head (_tmp14_);
#line 154 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_tmp16_ = _tmp15_;
#line 154 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_tmp17_ = style;
#line 154 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		webkit_dom_node_append_child ((WebKitDOMNode*) _tmp16_, (WebKitDOMNode*) _tmp17_, &_inner_error_);
#line 154 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 154 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
			_g_object_unref0 (style);
#line 435 "midori-tab.c"
			goto __catch37_g_error;
		}
#line 150 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_g_object_unref0 (style);
#line 440 "midori-tab.c"
	}
	goto __finally37;
	__catch37_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp18_;
		const gchar* _tmp19_;
#line 150 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_error_ = _inner_error_;
#line 150 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_inner_error_ = NULL;
#line 157 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_tmp18_ = _error_;
#line 157 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_tmp19_ = _tmp18_->message;
#line 157 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		g_critical (_ ("Failed to inject stylesheet: %s"), _tmp19_);
#line 150 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_g_error_free0 (_error_);
#line 460 "midori-tab.c"
	}
	__finally37:
#line 150 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 150 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_g_object_unref0 (dom);
#line 150 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 150 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		g_clear_error (&_inner_error_);
#line 150 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		return;
#line 473 "midori-tab.c"
	}
#line 146 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_g_object_unref0 (dom);
#line 477 "midori-tab.c"
}


gboolean midori_tab_can_view_source (MidoriTab* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	gchar* content_type = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* text_type = NULL;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gboolean _tmp6_;
#line 167 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 168 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp0_ = self->priv->_view_source;
#line 168 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	if (_tmp0_) {
#line 169 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		result = FALSE;
#line 169 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		return result;
#line 502 "midori-tab.c"
	}
#line 170 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp1_ = self->priv->_mime_type;
#line 170 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp2_ = g_content_type_from_mime_type (_tmp1_);
#line 170 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	content_type = _tmp2_;
#line 175 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp3_ = g_content_type_from_mime_type ("text/plain");
#line 175 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	text_type = _tmp3_;
#line 177 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp4_ = content_type;
#line 177 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp5_ = text_type;
#line 177 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp6_ = g_content_type_is_a (_tmp4_, _tmp5_);
#line 177 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	result = _tmp6_;
#line 177 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_g_free0 (text_type);
#line 177 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_g_free0 (content_type);
#line 177 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	return result;
#line 528 "midori-tab.c"
}


gchar* midori_tab_get_display_title (const gchar* title, const gchar* uri) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gboolean _tmp12_ = FALSE;
	const gchar* _tmp13_;
	const gchar* _tmp20_;
	gboolean _tmp21_;
	const gchar* _tmp24_;
	gchar* _tmp25_;
#line 180 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 182 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp1_ = title;
#line 182 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	if (_tmp1_ == NULL) {
#line 548 "midori-tab.c"
		gboolean _tmp2_ = FALSE;
		const gchar* _tmp3_;
		gboolean _tmp4_;
#line 182 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_tmp3_ = uri;
#line 182 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_tmp4_ = g_str_has_suffix (_tmp3_, ".diff");
#line 182 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		if (_tmp4_) {
#line 182 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
			_tmp2_ = TRUE;
#line 560 "midori-tab.c"
		} else {
			const gchar* _tmp5_;
			gboolean _tmp6_;
#line 182 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
			_tmp5_ = uri;
#line 182 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
			_tmp6_ = g_str_has_suffix (_tmp5_, ".patch");
#line 182 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
			_tmp2_ = _tmp6_;
#line 570 "midori-tab.c"
		}
#line 182 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_tmp0_ = _tmp2_;
#line 574 "midori-tab.c"
	} else {
#line 182 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_tmp0_ = FALSE;
#line 578 "midori-tab.c"
	}
#line 182 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	if (_tmp0_) {
#line 582 "midori-tab.c"
		const gchar* _tmp7_;
		GFile* _tmp8_;
		GFile* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
#line 183 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_tmp7_ = uri;
#line 183 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_tmp8_ = g_file_new_for_uri (_tmp7_);
#line 183 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_tmp9_ = _tmp8_;
#line 183 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_tmp10_ = g_file_get_basename (_tmp9_);
#line 183 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_tmp11_ = _tmp10_;
#line 183 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_g_object_unref0 (_tmp9_);
#line 183 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		result = _tmp11_;
#line 183 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		return result;
#line 604 "midori-tab.c"
	}
#line 186 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp13_ = title;
#line 186 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	if (_tmp13_ == NULL) {
#line 186 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_tmp12_ = TRUE;
#line 612 "midori-tab.c"
	} else {
		gboolean _tmp14_ = FALSE;
		const gchar* _tmp15_;
#line 186 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_tmp15_ = title;
#line 186 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		if (g_strcmp0 (_tmp15_, "OMG!") == 0) {
#line 620 "midori-tab.c"
			const gchar* _tmp16_;
			gboolean _tmp17_;
#line 186 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
			_tmp16_ = uri;
#line 186 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
			_tmp17_ = g_str_has_prefix (_tmp16_, "file://");
#line 186 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
			_tmp14_ = _tmp17_;
#line 629 "midori-tab.c"
		} else {
#line 186 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
			_tmp14_ = FALSE;
#line 633 "midori-tab.c"
		}
#line 186 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_tmp12_ = _tmp14_;
#line 637 "midori-tab.c"
	}
#line 186 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	if (_tmp12_) {
#line 641 "midori-tab.c"
		const gchar* _tmp18_;
		gchar* _tmp19_;
#line 187 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_tmp18_ = uri;
#line 187 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_tmp19_ = midori_uri_strip_prefix_for_display (_tmp18_);
#line 187 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		result = _tmp19_;
#line 187 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		return result;
#line 652 "midori-tab.c"
	}
#line 196 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp20_ = title;
#line 196 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp21_ = g_str_has_prefix (_tmp20_, "‪");
#line 196 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	if (!_tmp21_) {
#line 660 "midori-tab.c"
		const gchar* _tmp22_;
		gchar* _tmp23_;
#line 197 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_tmp22_ = title;
#line 197 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_tmp23_ = g_strconcat ("‪", _tmp22_, NULL);
#line 197 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		result = _tmp23_;
#line 197 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		return result;
#line 671 "midori-tab.c"
	}
#line 199 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp24_ = title;
#line 199 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp25_ = g_strdup (_tmp24_);
#line 199 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	result = _tmp25_;
#line 199 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	return result;
#line 681 "midori-tab.c"
}


PangoEllipsizeMode midori_tab_get_display_ellipsize (const gchar* title, const gchar* uri) {
	PangoEllipsizeMode result = 0;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gboolean _tmp4_;
	gchar** parts = NULL;
	const gchar* _tmp7_;
	gchar** _tmp8_;
	gchar** _tmp9_;
	gint parts_length1;
	gint _parts_size_;
	gboolean _tmp10_ = FALSE;
	gchar** _tmp11_;
	gint _tmp11__length1;
	const gchar* _tmp12_;
#line 202 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_return_val_if_fail (title != NULL, 0);
#line 202 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_return_val_if_fail (uri != NULL, 0);
#line 203 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp0_ = title;
#line 203 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp1_ = uri;
#line 203 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	if (g_strcmp0 (_tmp0_, _tmp1_) == 0) {
#line 204 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		result = PANGO_ELLIPSIZE_START;
#line 204 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		return result;
#line 716 "midori-tab.c"
	}
#line 206 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp3_ = title;
#line 206 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp4_ = g_str_has_suffix (_tmp3_, ".diff");
#line 206 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	if (_tmp4_) {
#line 206 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_tmp2_ = TRUE;
#line 726 "midori-tab.c"
	} else {
		const gchar* _tmp5_;
		gboolean _tmp6_;
#line 206 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_tmp5_ = title;
#line 206 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_tmp6_ = g_str_has_suffix (_tmp5_, ".patch");
#line 206 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_tmp2_ = _tmp6_;
#line 736 "midori-tab.c"
	}
#line 206 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	if (_tmp2_) {
#line 207 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		result = PANGO_ELLIPSIZE_START;
#line 207 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		return result;
#line 744 "midori-tab.c"
	}
#line 209 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp7_ = title;
#line 209 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp9_ = _tmp8_ = g_strsplit (_tmp7_, " ", 0);
#line 209 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	parts = _tmp9_;
#line 209 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	parts_length1 = _vala_array_length (_tmp8_);
#line 209 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_parts_size_ = parts_length1;
#line 210 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp11_ = parts;
#line 210 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp11__length1 = parts_length1;
#line 210 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp12_ = _tmp11_[0];
#line 210 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	if (_tmp12_ != NULL) {
#line 764 "midori-tab.c"
		const gchar* _tmp13_;
		gchar** _tmp14_;
		gint _tmp14__length1;
		gchar** _tmp15_;
		gint _tmp15__length1;
		const gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gboolean _tmp19_;
#line 210 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_tmp13_ = uri;
#line 210 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_tmp14_ = parts;
#line 210 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_tmp14__length1 = parts_length1;
#line 210 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_tmp15_ = parts;
#line 210 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_tmp15__length1 = parts_length1;
#line 210 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_tmp16_ = _tmp14_[_tmp15__length1 - 1];
#line 210 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_tmp17_ = g_utf8_strdown (_tmp16_, (gssize) -1);
#line 210 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_tmp18_ = _tmp17_;
#line 210 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_tmp19_ = g_str_has_suffix (_tmp13_, _tmp18_);
#line 210 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_tmp10_ = _tmp19_;
#line 210 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_g_free0 (_tmp18_);
#line 796 "midori-tab.c"
	} else {
#line 210 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_tmp10_ = FALSE;
#line 800 "midori-tab.c"
	}
#line 210 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	if (_tmp10_) {
#line 211 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		result = PANGO_ELLIPSIZE_START;
#line 211 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
#line 211 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		return result;
#line 810 "midori-tab.c"
	}
#line 213 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	result = PANGO_ELLIPSIZE_END;
#line 213 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
#line 213 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	return result;
#line 818 "midori-tab.c"
}


gboolean midori_tab_can_save (MidoriTab* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp3_;
	WebKitWebView* _tmp4_;
	WebKitWebFrame* _tmp5_;
	WebKitWebDataSource* _tmp6_;
	GString* _tmp7_;
#line 217 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 218 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp1_ = midori_tab_is_blank (self);
#line 218 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	if (_tmp1_) {
#line 218 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_tmp0_ = TRUE;
#line 839 "midori-tab.c"
	} else {
		gboolean _tmp2_;
#line 218 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_tmp2_ = self->priv->_special;
#line 218 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_tmp0_ = _tmp2_;
#line 846 "midori-tab.c"
	}
#line 218 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	if (_tmp0_) {
#line 219 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		result = FALSE;
#line 219 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		return result;
#line 854 "midori-tab.c"
	}
#line 220 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp3_ = self->priv->_view_source;
#line 220 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	if (_tmp3_) {
#line 221 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		result = FALSE;
#line 221 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		return result;
#line 864 "midori-tab.c"
	}
#line 223 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp4_ = self->priv->_web_view;
#line 223 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp5_ = webkit_web_view_get_main_frame (_tmp4_);
#line 223 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp6_ = webkit_web_frame_get_data_source (_tmp5_);
#line 223 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp7_ = webkit_web_data_source_get_data (_tmp6_);
#line 223 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	if (_tmp7_ == NULL) {
#line 224 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		result = FALSE;
#line 224 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		return result;
#line 880 "midori-tab.c"
	}
#line 226 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	result = TRUE;
#line 226 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	return result;
#line 886 "midori-tab.c"
}


void midori_tab_stop_loading (MidoriTab* self) {
	WebKitWebView* _tmp0_;
#line 229 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_return_if_fail (self != NULL);
#line 230 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp0_ = self->priv->_web_view;
#line 230 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	webkit_web_view_stop_loading (_tmp0_);
#line 898 "midori-tab.c"
}


gboolean midori_tab_can_go_forward (MidoriTab* self) {
	gboolean result = FALSE;
	WebKitWebView* _tmp0_;
	gboolean _tmp1_;
#line 233 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 234 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp0_ = self->priv->_web_view;
#line 234 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp1_ = webkit_web_view_can_go_forward (_tmp0_);
#line 234 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	result = _tmp1_;
#line 234 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	return result;
#line 916 "midori-tab.c"
}


void midori_tab_go_forward (MidoriTab* self) {
	WebKitWebView* _tmp0_;
#line 237 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_return_if_fail (self != NULL);
#line 238 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp0_ = self->priv->_web_view;
#line 238 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	webkit_web_view_go_forward (_tmp0_);
#line 928 "midori-tab.c"
}


void midori_tab_unmark_text_matches (MidoriTab* self) {
	WebKitWebView* _tmp0_;
#line 241 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_return_if_fail (self != NULL);
#line 243 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp0_ = self->priv->_web_view;
#line 243 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	webkit_web_view_unmark_text_matches (_tmp0_);
#line 940 "midori-tab.c"
}


gboolean midori_tab_find (MidoriTab* self, const gchar* text, gboolean case_sensitive, gboolean forward) {
	gboolean result = FALSE;
	gboolean found = FALSE;
	WebKitWebView* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	WebKitWebView* _tmp5_;
	const gchar* _tmp6_;
	gboolean _tmp7_;
	WebKitWebView* _tmp8_;
#line 247 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 247 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_return_val_if_fail (text != NULL, FALSE);
#line 259 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	found = FALSE;
#line 260 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp0_ = self->priv->_web_view;
#line 260 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp1_ = text;
#line 260 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp2_ = case_sensitive;
#line 260 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp3_ = forward;
#line 260 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp4_ = webkit_web_view_search_text (_tmp0_, _tmp1_, _tmp2_, _tmp3_, TRUE);
#line 260 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	found = _tmp4_;
#line 261 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp5_ = self->priv->_web_view;
#line 261 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp6_ = text;
#line 261 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp7_ = case_sensitive;
#line 261 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	webkit_web_view_mark_text_matches (_tmp5_, _tmp6_, _tmp7_, (guint) 0);
#line 262 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp8_ = self->priv->_web_view;
#line 262 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	webkit_web_view_set_highlight_text_matches (_tmp8_, TRUE);
#line 263 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	result = found;
#line 263 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	return result;
#line 990 "midori-tab.c"
}


static void midori_tab_update_actions_data_free (gpointer _data) {
	MidoriTabUpdateActionsData* _data_;
	_data_ = _data;
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_g_object_unref0 (_data_->actions);
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_g_object_unref0 (_data_->self);
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_slice_free (MidoriTabUpdateActionsData, _data_);
#line 1003 "midori-tab.c"
}


static void midori_tab_update_actions_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data) {
	MidoriTabUpdateActionsData* _task_data_;
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_task_data_ = g_task_get_task_data (G_TASK (res));
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	if (_task_data_->_callback_ != NULL) {
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_task_data_->_callback_ (source_object, res, user_data);
#line 1015 "midori-tab.c"
	}
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_task_data_->_task_complete_ = TRUE;
#line 1019 "midori-tab.c"
}


void midori_tab_update_actions (MidoriTab* self, GtkActionGroup* actions, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	MidoriTabUpdateActionsData* _data_;
	MidoriTab* _tmp0_;
	GtkActionGroup* _tmp1_;
	GtkActionGroup* _tmp2_;
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_data_ = g_slice_new0 (MidoriTabUpdateActionsData);
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_data_->_callback_ = _callback_;
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, midori_tab_update_actions_async_ready_wrapper, _user_data_);
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	if (_callback_ == NULL) {
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_data_->_task_complete_ = TRUE;
#line 1038 "midori-tab.c"
	}
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_task_set_task_data (_data_->_async_result, _data_, midori_tab_update_actions_data_free);
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_data_->self = _tmp0_;
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp1_ = actions;
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_g_object_unref0 (_data_->actions);
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_data_->actions = _tmp2_;
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	midori_tab_update_actions_co (_data_);
#line 1056 "midori-tab.c"
}


void midori_tab_update_actions_finish (MidoriTab* self, GAsyncResult* _res_) {
	MidoriTabUpdateActionsData* _data_;
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 1064 "midori-tab.c"
}


static gboolean midori_tab_update_actions_co (MidoriTabUpdateActionsData* _data_) {
#line 272 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	switch (_data_->_state_) {
#line 272 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		case 0:
#line 1073 "midori-tab.c"
		goto _state_0;
		default:
#line 272 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		g_assert_not_reached ();
#line 1078 "midori-tab.c"
	}
	_state_0:
#line 286 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_data_->_tmp0_ = _data_->actions;
#line 286 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_data_->_tmp1_ = gtk_action_group_get_action (_data_->_tmp0_, "Undo");
#line 286 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_data_->_tmp2_ = _data_->self->priv->_web_view;
#line 286 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_data_->_tmp3_ = webkit_web_view_can_undo (_data_->_tmp2_);
#line 286 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	gtk_action_set_sensitive (_data_->_tmp1_, _data_->_tmp3_);
#line 287 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_data_->_tmp4_ = _data_->actions;
#line 287 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_data_->_tmp5_ = gtk_action_group_get_action (_data_->_tmp4_, "Redo");
#line 287 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_data_->_tmp6_ = _data_->self->priv->_web_view;
#line 287 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_data_->_tmp7_ = webkit_web_view_can_redo (_data_->_tmp6_);
#line 287 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	gtk_action_set_sensitive (_data_->_tmp5_, _data_->_tmp7_);
#line 288 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_data_->_tmp8_ = _data_->actions;
#line 288 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_data_->_tmp9_ = gtk_action_group_get_action (_data_->_tmp8_, "Cut");
#line 288 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_data_->_tmp10_ = _data_->self->priv->_web_view;
#line 288 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_data_->_tmp11_ = webkit_web_view_can_cut_clipboard (_data_->_tmp10_);
#line 288 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	gtk_action_set_sensitive (_data_->_tmp9_, _data_->_tmp11_);
#line 289 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_data_->_tmp12_ = _data_->actions;
#line 289 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_data_->_tmp13_ = gtk_action_group_get_action (_data_->_tmp12_, "Copy");
#line 289 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_data_->_tmp14_ = _data_->self->priv->_web_view;
#line 289 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_data_->_tmp15_ = webkit_web_view_can_copy_clipboard (_data_->_tmp14_);
#line 289 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	gtk_action_set_sensitive (_data_->_tmp13_, _data_->_tmp15_);
#line 290 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_data_->_tmp16_ = _data_->actions;
#line 290 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_data_->_tmp17_ = gtk_action_group_get_action (_data_->_tmp16_, "Paste");
#line 290 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_data_->_tmp18_ = _data_->self->priv->_web_view;
#line 290 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_data_->_tmp19_ = webkit_web_view_can_paste_clipboard (_data_->_tmp18_);
#line 290 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	gtk_action_set_sensitive (_data_->_tmp17_, _data_->_tmp19_);
#line 291 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_data_->_tmp20_ = _data_->actions;
#line 291 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_data_->_tmp21_ = gtk_action_group_get_action (_data_->_tmp20_, "Delete");
#line 291 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_data_->_tmp22_ = _data_->self->priv->_web_view;
#line 291 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_data_->_tmp23_ = webkit_web_view_can_cut_clipboard (_data_->_tmp22_);
#line 291 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	gtk_action_set_sensitive (_data_->_tmp21_, _data_->_tmp23_);
#line 292 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_data_->_tmp24_ = _data_->actions;
#line 292 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_data_->_tmp25_ = gtk_action_group_get_action (_data_->_tmp24_, "SelectAll");
#line 292 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	gtk_action_set_sensitive (_data_->_tmp25_, TRUE);
#line 272 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 272 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	if (_data_->_state_ != 0) {
#line 272 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		while (_data_->_task_complete_ != TRUE) {
#line 272 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1155 "midori-tab.c"
		}
	}
#line 272 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_object_unref (_data_->_async_result);
#line 272 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	return FALSE;
#line 1162 "midori-tab.c"
}


MidoriTab* midori_tab_construct (GType object_type) {
	MidoriTab * self = NULL;
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	self = (MidoriTab*) g_object_new (object_type, NULL);
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	return self;
#line 1172 "midori-tab.c"
}


MidoriTab* midori_tab_new (void) {
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	return midori_tab_construct (MIDORI_TYPE_TAB);
#line 1179 "midori-tab.c"
}


MidoriTab* midori_tab_get_related (MidoriTab* self) {
	MidoriTab* result;
	MidoriTab* _tmp0_;
#line 46 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 46 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp0_ = self->priv->_related;
#line 46 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	result = _tmp0_;
#line 46 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	return result;
#line 1194 "midori-tab.c"
}


void midori_tab_set_related (MidoriTab* self, MidoriTab* value) {
#line 46 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_return_if_fail (self != NULL);
#line 46 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	if (midori_tab_get_related (self) != value) {
#line 1203 "midori-tab.c"
		MidoriTab* _tmp0_;
		MidoriTab* _tmp1_;
#line 46 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_tmp0_ = value;
#line 46 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 46 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_g_object_unref0 (self->priv->_related);
#line 46 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		self->priv->_related = _tmp1_;
#line 46 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		g_object_notify_by_pspec ((GObject *) self, midori_tab_properties[MIDORI_TAB_RELATED_PROPERTY]);
#line 1216 "midori-tab.c"
	}
}


WebKitWebView* midori_tab_get_web_view (MidoriTab* self) {
	WebKitWebView* result;
	WebKitWebView* _tmp0_;
#line 47 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 47 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp0_ = self->priv->_web_view;
#line 47 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	result = _tmp0_;
#line 47 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	return result;
#line 1232 "midori-tab.c"
}


static void midori_tab_set_web_view (MidoriTab* self, WebKitWebView* value) {
#line 47 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_return_if_fail (self != NULL);
#line 47 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	if (midori_tab_get_web_view (self) != value) {
#line 1241 "midori-tab.c"
		WebKitWebView* _tmp0_;
		WebKitWebView* _tmp1_;
#line 47 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_tmp0_ = value;
#line 47 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 47 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_g_object_unref0 (self->priv->_web_view);
#line 47 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		self->priv->_web_view = _tmp1_;
#line 47 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		g_object_notify_by_pspec ((GObject *) self, midori_tab_properties[MIDORI_TAB_WEB_VIEW_PROPERTY]);
#line 1254 "midori-tab.c"
	}
}


const gchar* midori_tab_get_uri (MidoriTab* self) {
	const gchar* result;
	const gchar* _tmp0_;
#line 50 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 51 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp0_ = self->priv->current_uri;
#line 51 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	result = _tmp0_;
#line 51 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	return result;
#line 1270 "midori-tab.c"
}


void midori_tab_set_uri (MidoriTab* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 53 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_return_if_fail (self != NULL);
#line 54 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp0_ = value;
#line 54 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp1_ = midori_uri_format_for_display (_tmp0_);
#line 54 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_g_free0 (self->priv->current_uri);
#line 54 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	self->priv->current_uri = _tmp1_;
#line 53 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_object_notify_by_pspec ((GObject *) self, midori_tab_properties[MIDORI_TAB_URI_PROPERTY]);
#line 1289 "midori-tab.c"
}


gboolean midori_tab_get_special (MidoriTab* self) {
	gboolean result;
	gboolean _tmp0_;
#line 59 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 59 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp0_ = self->priv->_special;
#line 59 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	result = _tmp0_;
#line 59 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	return result;
#line 1304 "midori-tab.c"
}


void midori_tab_set_special (MidoriTab* self, gboolean value) {
#line 59 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_return_if_fail (self != NULL);
#line 59 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	if (midori_tab_get_special (self) != value) {
#line 1313 "midori-tab.c"
		gboolean _tmp0_;
#line 59 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_tmp0_ = value;
#line 59 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		self->priv->_special = _tmp0_;
#line 59 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		g_object_notify_by_pspec ((GObject *) self, midori_tab_properties[MIDORI_TAB_SPECIAL_PROPERTY]);
#line 1321 "midori-tab.c"
	}
}


gboolean midori_tab_get_minimized (MidoriTab* self) {
	gboolean result;
	gboolean _tmp0_;
#line 62 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 62 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp0_ = self->priv->_minimized;
#line 62 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	result = _tmp0_;
#line 62 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	return result;
#line 1337 "midori-tab.c"
}


void midori_tab_set_minimized (MidoriTab* self, gboolean value) {
#line 62 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_return_if_fail (self != NULL);
#line 62 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	if (midori_tab_get_minimized (self) != value) {
#line 1346 "midori-tab.c"
		gboolean _tmp0_;
#line 62 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_tmp0_ = value;
#line 62 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		self->priv->_minimized = _tmp0_;
#line 62 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		g_object_notify_by_pspec ((GObject *) self, midori_tab_properties[MIDORI_TAB_MINIMIZED_PROPERTY]);
#line 1354 "midori-tab.c"
	}
}


const gchar* midori_tab_get_mime_type (MidoriTab* self) {
	const gchar* result;
	const gchar* _tmp0_;
#line 64 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 64 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp0_ = self->priv->_mime_type;
#line 64 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	result = _tmp0_;
#line 64 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	return result;
#line 1370 "midori-tab.c"
}


void midori_tab_set_mime_type (MidoriTab* self, const gchar* value) {
#line 64 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_return_if_fail (self != NULL);
#line 64 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	if (g_strcmp0 (value, midori_tab_get_mime_type (self)) != 0) {
#line 1379 "midori-tab.c"
		const gchar* _tmp0_;
		gchar* _tmp1_;
#line 64 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_tmp0_ = value;
#line 64 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_tmp1_ = g_strdup (_tmp0_);
#line 64 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_g_free0 (self->priv->_mime_type);
#line 64 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		self->priv->_mime_type = _tmp1_;
#line 64 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		g_object_notify_by_pspec ((GObject *) self, midori_tab_properties[MIDORI_TAB_MIME_TYPE_PROPERTY]);
#line 1392 "midori-tab.c"
	}
}


MidoriSecurity midori_tab_get_security (MidoriTab* self) {
	MidoriSecurity result;
	MidoriSecurity _tmp0_;
#line 66 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 66 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp0_ = self->priv->_security;
#line 66 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	result = _tmp0_;
#line 66 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	return result;
#line 1408 "midori-tab.c"
}


void midori_tab_set_security (MidoriTab* self, MidoriSecurity value) {
#line 66 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_return_if_fail (self != NULL);
#line 66 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	if (midori_tab_get_security (self) != value) {
#line 1417 "midori-tab.c"
		MidoriSecurity _tmp0_;
#line 66 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_tmp0_ = value;
#line 66 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		self->priv->_security = _tmp0_;
#line 66 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		g_object_notify_by_pspec ((GObject *) self, midori_tab_properties[MIDORI_TAB_SECURITY_PROPERTY]);
#line 1425 "midori-tab.c"
	}
}


MidoriLoadStatus midori_tab_get_load_status (MidoriTab* self) {
	MidoriLoadStatus result;
	MidoriLoadStatus _tmp0_;
#line 67 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 67 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp0_ = self->priv->_load_status;
#line 67 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	result = _tmp0_;
#line 67 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	return result;
#line 1441 "midori-tab.c"
}


void midori_tab_set_load_status (MidoriTab* self, MidoriLoadStatus value) {
#line 67 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_return_if_fail (self != NULL);
#line 67 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	if (midori_tab_get_load_status (self) != value) {
#line 1450 "midori-tab.c"
		MidoriLoadStatus _tmp0_;
#line 67 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_tmp0_ = value;
#line 67 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		self->priv->_load_status = _tmp0_;
#line 67 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		g_object_notify_by_pspec ((GObject *) self, midori_tab_properties[MIDORI_TAB_LOAD_STATUS_PROPERTY]);
#line 1458 "midori-tab.c"
	}
}


MidoriLoadError midori_tab_get_load_error (MidoriTab* self) {
	MidoriLoadError result;
	MidoriLoadError _tmp0_;
#line 68 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 68 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp0_ = self->priv->_load_error;
#line 68 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	result = _tmp0_;
#line 68 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	return result;
#line 1474 "midori-tab.c"
}


void midori_tab_set_load_error (MidoriTab* self, MidoriLoadError value) {
#line 68 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_return_if_fail (self != NULL);
#line 68 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	if (midori_tab_get_load_error (self) != value) {
#line 1483 "midori-tab.c"
		MidoriLoadError _tmp0_;
#line 68 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_tmp0_ = value;
#line 68 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		self->priv->_load_error = _tmp0_;
#line 68 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		g_object_notify_by_pspec ((GObject *) self, midori_tab_properties[MIDORI_TAB_LOAD_ERROR_PROPERTY]);
#line 1491 "midori-tab.c"
	}
}


const gchar* midori_tab_get_statusbar_text (MidoriTab* self) {
	const gchar* result;
	const gchar* _tmp0_;
#line 69 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 69 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp0_ = self->priv->_statusbar_text;
#line 69 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	result = _tmp0_;
#line 69 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	return result;
#line 1507 "midori-tab.c"
}


void midori_tab_set_statusbar_text (MidoriTab* self, const gchar* value) {
#line 69 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_return_if_fail (self != NULL);
#line 69 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	if (g_strcmp0 (value, midori_tab_get_statusbar_text (self)) != 0) {
#line 1516 "midori-tab.c"
		const gchar* _tmp0_;
		gchar* _tmp1_;
#line 69 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_tmp0_ = value;
#line 69 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_tmp1_ = g_strdup (_tmp0_);
#line 69 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_g_free0 (self->priv->_statusbar_text);
#line 69 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		self->priv->_statusbar_text = _tmp1_;
#line 69 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		g_object_notify_by_pspec ((GObject *) self, midori_tab_properties[MIDORI_TAB_STATUSBAR_TEXT_PROPERTY]);
#line 1529 "midori-tab.c"
	}
}


GdkColor* midori_tab_get_fg_color (MidoriTab* self) {
	GdkColor* result;
	GdkColor* _tmp0_;
#line 72 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 72 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp0_ = self->priv->_fg_color;
#line 72 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	result = _tmp0_;
#line 72 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	return result;
#line 1545 "midori-tab.c"
}


static GdkColor* _gdk_color_dup (GdkColor* self) {
	GdkColor* dup;
#line 72 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	dup = g_new0 (GdkColor, 1);
#line 72 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	memcpy (dup, self, sizeof (GdkColor));
#line 72 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	return dup;
#line 1557 "midori-tab.c"
}


static gpointer __gdk_color_dup0 (gpointer self) {
#line 72 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	return self ? _gdk_color_dup (self) : NULL;
#line 1564 "midori-tab.c"
}


void midori_tab_set_fg_color (MidoriTab* self, GdkColor* value) {
	GdkColor* _tmp0_;
	GdkColor* _tmp1_;
#line 72 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_return_if_fail (self != NULL);
#line 72 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp0_ = value;
#line 72 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp1_ = __gdk_color_dup0 (_tmp0_);
#line 72 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_g_free0 (self->priv->_fg_color);
#line 72 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	self->priv->_fg_color = _tmp1_;
#line 1581 "midori-tab.c"
}


GdkColor* midori_tab_get_bg_color (MidoriTab* self) {
	GdkColor* result;
	GdkColor* _tmp0_;
#line 74 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 75 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp0_ = self->priv->bg_color_;
#line 75 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	result = _tmp0_;
#line 75 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	return result;
#line 1596 "midori-tab.c"
}


void midori_tab_set_bg_color (MidoriTab* self, GdkColor* value) {
	GdkColor* _tmp0_;
	GdkColor* _tmp1_;
#line 76 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_return_if_fail (self != NULL);
#line 77 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp0_ = value;
#line 77 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp1_ = __gdk_color_dup0 (_tmp0_);
#line 77 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_g_free0 (self->priv->bg_color_);
#line 77 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	self->priv->bg_color_ = _tmp1_;
#line 78 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_signal_emit (self, midori_tab_signals[MIDORI_TAB_COLORS_CHANGED_SIGNAL], 0);
#line 1615 "midori-tab.c"
}


gdouble midori_tab_get_progress (MidoriTab* self) {
	gdouble result;
	gdouble _tmp0_ = 0.0;
	gboolean _tmp1_;
#line 86 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_return_val_if_fail (self != NULL, 0.0);
#line 87 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp1_ = self->priv->_special;
#line 87 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	if (_tmp1_) {
#line 87 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_tmp0_ = 0.0;
#line 1631 "midori-tab.c"
	} else {
		gdouble _tmp2_;
#line 87 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_tmp2_ = self->priv->current_progress;
#line 87 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_tmp0_ = _tmp2_;
#line 1638 "midori-tab.c"
	}
#line 87 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	result = _tmp0_;
#line 87 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	return result;
#line 1644 "midori-tab.c"
}


void midori_tab_set_progress (MidoriTab* self, gdouble value) {
	MidoriLoadStatus _tmp0_;
#line 89 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_return_if_fail (self != NULL);
#line 91 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp0_ = self->priv->_load_status;
#line 91 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	if (_tmp0_ == MIDORI_LOAD_FINISHED) {
#line 92 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		self->priv->current_progress = 0.0;
#line 1658 "midori-tab.c"
	} else {
		gdouble _tmp1_;
#line 94 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_tmp1_ = value;
#line 94 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		if (_tmp1_ == 1.0) {
#line 95 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
			self->priv->current_progress = 0.0;
#line 1667 "midori-tab.c"
		} else {
			gdouble _tmp2_;
			gdouble _tmp3_;
#line 98 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
			_tmp2_ = value;
#line 98 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
			_tmp3_ = CLAMP (_tmp2_, 0.1, 1.0);
#line 98 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
			self->priv->current_progress = _tmp3_;
#line 1677 "midori-tab.c"
		}
	}
#line 89 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_object_notify_by_pspec ((GObject *) self, midori_tab_properties[MIDORI_TAB_PROGRESS_PROPERTY]);
#line 1682 "midori-tab.c"
}


gboolean midori_tab_get_is_dialog (MidoriTab* self) {
	gboolean result;
	gboolean _tmp0_;
#line 125 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 125 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp0_ = self->priv->_is_dialog;
#line 125 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	result = _tmp0_;
#line 125 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	return result;
#line 1697 "midori-tab.c"
}


void midori_tab_set_is_dialog (MidoriTab* self, gboolean value) {
#line 125 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_return_if_fail (self != NULL);
#line 125 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	if (midori_tab_get_is_dialog (self) != value) {
#line 1706 "midori-tab.c"
		gboolean _tmp0_;
#line 125 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_tmp0_ = value;
#line 125 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		self->priv->_is_dialog = _tmp0_;
#line 125 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		g_object_notify_by_pspec ((GObject *) self, midori_tab_properties[MIDORI_TAB_IS_DIALOG_PROPERTY]);
#line 1714 "midori-tab.c"
	}
}


gboolean midori_tab_get_view_source (MidoriTab* self) {
	gboolean result;
	gboolean _tmp0_;
#line 165 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 165 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp0_ = self->priv->_view_source;
#line 165 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	result = _tmp0_;
#line 165 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	return result;
#line 1730 "midori-tab.c"
}


static void midori_tab_set_view_source (MidoriTab* self, gboolean value) {
#line 165 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_return_if_fail (self != NULL);
#line 165 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	if (midori_tab_get_view_source (self) != value) {
#line 1739 "midori-tab.c"
		gboolean _tmp0_;
#line 165 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		_tmp0_ = value;
#line 165 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		self->priv->_view_source = _tmp0_;
#line 165 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		g_object_notify_by_pspec ((GObject *) self, midori_tab_properties[MIDORI_TAB_VIEW_SOURCE_PROPERTY]);
#line 1747 "midori-tab.c"
	}
}


static void g_cclosure_user_marshal_BOOLEAN__STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef gboolean (*GMarshalFunc_BOOLEAN__STRING) (gpointer data1, const char* arg_1, gpointer data2);
	register GMarshalFunc_BOOLEAN__STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	gboolean v_return;
	cc = (GCClosure *) closure;
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_return_if_fail (return_value != NULL);
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_return_if_fail (n_param_values == 2);
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		data1 = closure->data;
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		data2 = param_values->data[0].v_pointer;
#line 1770 "midori-tab.c"
	} else {
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		data1 = param_values->data[0].v_pointer;
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		data2 = closure->data;
#line 1776 "midori-tab.c"
	}
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	callback = (GMarshalFunc_BOOLEAN__STRING) (marshal_data ? marshal_data : cc->callback);
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	v_return = callback (data1, g_value_get_string (param_values + 1), data2);
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_value_set_boolean (return_value, v_return);
#line 1784 "midori-tab.c"
}


static void g_cclosure_user_marshal_VOID__STRING_INT_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_INT_STRING) (gpointer data1, const char* arg_1, gint arg_2, const char* arg_3, gpointer data2);
	register GMarshalFunc_VOID__STRING_INT_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_return_if_fail (n_param_values == 4);
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		data1 = closure->data;
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		data2 = param_values->data[0].v_pointer;
#line 1803 "midori-tab.c"
	} else {
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		data1 = param_values->data[0].v_pointer;
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		data2 = closure->data;
#line 1809 "midori-tab.c"
	}
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	callback = (GMarshalFunc_VOID__STRING_INT_STRING) (marshal_data ? marshal_data : cc->callback);
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	callback (data1, g_value_get_string (param_values + 1), g_value_get_int (param_values + 2), g_value_get_string (param_values + 3), data2);
#line 1815 "midori-tab.c"
}


static void g_cclosure_user_marshal_VOID__BOOLEAN_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__BOOLEAN_STRING) (gpointer data1, gboolean arg_1, const char* arg_2, gpointer data2);
	register GMarshalFunc_VOID__BOOLEAN_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_return_if_fail (n_param_values == 3);
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		data1 = closure->data;
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		data2 = param_values->data[0].v_pointer;
#line 1834 "midori-tab.c"
	} else {
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		data1 = param_values->data[0].v_pointer;
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		data2 = closure->data;
#line 1840 "midori-tab.c"
	}
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	callback = (GMarshalFunc_VOID__BOOLEAN_STRING) (marshal_data ? marshal_data : cc->callback);
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	callback (data1, g_value_get_boolean (param_values + 1), g_value_get_string (param_values + 2), data2);
#line 1846 "midori-tab.c"
}


static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_return_if_fail (n_param_values == 3);
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		data1 = closure->data;
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		data2 = param_values->data[0].v_pointer;
#line 1865 "midori-tab.c"
	} else {
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		data1 = param_values->data[0].v_pointer;
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		data2 = closure->data;
#line 1871 "midori-tab.c"
	}
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT) (marshal_data ? marshal_data : cc->callback);
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), data2);
#line 1877 "midori-tab.c"
}


static GObject * midori_tab_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	MidoriTab * self;
	WebKitWebView* _tmp0_;
	WebKitWebView* _tmp1_;
	WebKitWebView* _tmp2_;
#line 131 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	parent_class = G_OBJECT_CLASS (midori_tab_parent_class);
#line 131 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 131 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MIDORI_TYPE_TAB, MidoriTab);
#line 140 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp0_ = (WebKitWebView*) webkit_web_view_new ();
#line 140 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_object_ref_sink (_tmp0_);
#line 140 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp1_ = _tmp0_;
#line 140 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	midori_tab_set_web_view (self, _tmp1_);
#line 140 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_g_object_unref0 (_tmp1_);
#line 143 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp2_ = self->priv->_web_view;
#line 143 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	webkit_web_view_load_uri (_tmp2_, "");
#line 131 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	return obj;
#line 1910 "midori-tab.c"
}


static void midori_tab_class_init (MidoriTabClass * klass) {
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	midori_tab_parent_class = g_type_class_peek_parent (klass);
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_type_class_add_private (klass, sizeof (MidoriTabPrivate));
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_midori_tab_get_property;
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_midori_tab_set_property;
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	G_OBJECT_CLASS (klass)->constructor = midori_tab_constructor;
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	G_OBJECT_CLASS (klass)->finalize = midori_tab_finalize;
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_TAB_RELATED_PROPERTY, midori_tab_properties[MIDORI_TAB_RELATED_PROPERTY] = g_param_spec_object ("related", "related", "related", MIDORI_TYPE_TAB, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_TAB_WEB_VIEW_PROPERTY, midori_tab_properties[MIDORI_TAB_WEB_VIEW_PROPERTY] = g_param_spec_object ("web-view", "web-view", "web-view", WEBKIT_TYPE_WEB_VIEW, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_TAB_URI_PROPERTY, midori_tab_properties[MIDORI_TAB_URI_PROPERTY] = g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_TAB_SPECIAL_PROPERTY, midori_tab_properties[MIDORI_TAB_SPECIAL_PROPERTY] = g_param_spec_boolean ("special", "special", "special", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_TAB_MINIMIZED_PROPERTY, midori_tab_properties[MIDORI_TAB_MINIMIZED_PROPERTY] = g_param_spec_boolean ("minimized", "minimized", "minimized", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_TAB_MIME_TYPE_PROPERTY, midori_tab_properties[MIDORI_TAB_MIME_TYPE_PROPERTY] = g_param_spec_string ("mime-type", "mime-type", "mime-type", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_TAB_SECURITY_PROPERTY, midori_tab_properties[MIDORI_TAB_SECURITY_PROPERTY] = g_param_spec_enum ("security", "security", "security", MIDORI_TYPE_SECURITY, MIDORI_SECURITY_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_TAB_LOAD_STATUS_PROPERTY, midori_tab_properties[MIDORI_TAB_LOAD_STATUS_PROPERTY] = g_param_spec_enum ("load-status", "load-status", "load-status", MIDORI_TYPE_LOAD_STATUS, MIDORI_LOAD_FINISHED, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_TAB_LOAD_ERROR_PROPERTY, midori_tab_properties[MIDORI_TAB_LOAD_ERROR_PROPERTY] = g_param_spec_enum ("load-error", "load-error", "load-error", MIDORI_TYPE_LOAD_ERROR, MIDORI_LOAD_ERROR_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_TAB_STATUSBAR_TEXT_PROPERTY, midori_tab_properties[MIDORI_TAB_STATUSBAR_TEXT_PROPERTY] = g_param_spec_string ("statusbar-text", "statusbar-text", "statusbar-text", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_TAB_PROGRESS_PROPERTY, midori_tab_properties[MIDORI_TAB_PROGRESS_PROPERTY] = g_param_spec_double ("progress", "progress", "progress", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_TAB_IS_DIALOG_PROPERTY, midori_tab_properties[MIDORI_TAB_IS_DIALOG_PROPERTY] = g_param_spec_boolean ("is-dialog", "is-dialog", "is-dialog", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_TAB_VIEW_SOURCE_PROPERTY, midori_tab_properties[MIDORI_TAB_VIEW_SOURCE_PROPERTY] = g_param_spec_boolean ("view-source", "view-source", "view-source", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	midori_tab_signals[MIDORI_TAB_COLORS_CHANGED_SIGNAL] = g_signal_new ("colors-changed", MIDORI_TYPE_TAB, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	midori_tab_signals[MIDORI_TAB_OPEN_URI_SIGNAL] = g_signal_new ("open-uri", MIDORI_TYPE_TAB, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_BOOLEAN__STRING, G_TYPE_BOOLEAN, 1, G_TYPE_STRING);
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	midori_tab_signals[MIDORI_TAB_NAVIGATION_REQUESTED_SIGNAL] = g_signal_new ("navigation-requested", MIDORI_TYPE_TAB, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_BOOLEAN__STRING, G_TYPE_BOOLEAN, 1, G_TYPE_STRING);
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	midori_tab_signals[MIDORI_TAB_CONSOLE_MESSAGE_SIGNAL] = g_signal_new ("console-message", MIDORI_TYPE_TAB, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_INT_STRING, G_TYPE_NONE, 3, G_TYPE_STRING, G_TYPE_INT, G_TYPE_STRING);
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	midori_tab_signals[MIDORI_TAB_ATTACH_INSPECTOR_SIGNAL] = g_signal_new ("attach-inspector", MIDORI_TYPE_TAB, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, WEBKIT_TYPE_WEB_VIEW);
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	midori_tab_signals[MIDORI_TAB_DETACH_INSPECTOR_SIGNAL] = g_signal_new ("detach-inspector", MIDORI_TYPE_TAB, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, WEBKIT_TYPE_WEB_VIEW);
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	midori_tab_signals[MIDORI_TAB_SEARCH_TEXT_SIGNAL] = g_signal_new ("search-text", MIDORI_TYPE_TAB, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOOLEAN_STRING, G_TYPE_NONE, 2, G_TYPE_BOOLEAN, G_TYPE_STRING);
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	midori_tab_signals[MIDORI_TAB_CONTEXT_MENU_SIGNAL] = g_signal_new ("context-menu", MIDORI_TYPE_TAB, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, WEBKIT_TYPE_HIT_TEST_RESULT, MIDORI_TYPE_CONTEXT_ACTION);
#line 1969 "midori-tab.c"
}


static void midori_tab_instance_init (MidoriTab * self) {
	gchar* _tmp0_;
	gchar* _tmp1_;
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	self->priv = MIDORI_TAB_GET_PRIVATE (self);
#line 49 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp0_ = g_strdup ("about:blank");
#line 49 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	self->priv->current_uri = _tmp0_;
#line 59 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	self->priv->_special = FALSE;
#line 62 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	self->priv->_minimized = FALSE;
#line 64 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_tmp1_ = g_strdup ("text/plain");
#line 64 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	self->priv->_mime_type = _tmp1_;
#line 66 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	self->priv->_security = MIDORI_SECURITY_NONE;
#line 67 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	self->priv->_load_status = MIDORI_LOAD_FINISHED;
#line 68 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	self->priv->_load_error = MIDORI_LOAD_ERROR_NONE;
#line 69 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	self->priv->_statusbar_text = NULL;
#line 72 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	self->priv->_fg_color = NULL;
#line 73 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	self->priv->bg_color_ = NULL;
#line 85 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	self->priv->current_progress = 0.0;
#line 165 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	self->priv->_view_source = FALSE;
#line 2006 "midori-tab.c"
}


static void midori_tab_finalize (GObject * obj) {
	MidoriTab * self;
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MIDORI_TYPE_TAB, MidoriTab);
#line 46 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_g_object_unref0 (self->priv->_related);
#line 47 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_g_object_unref0 (self->priv->_web_view);
#line 49 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_g_free0 (self->priv->current_uri);
#line 64 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_g_free0 (self->priv->_mime_type);
#line 69 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_g_free0 (self->priv->_statusbar_text);
#line 72 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_g_free0 (self->priv->_fg_color);
#line 73 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	_g_free0 (self->priv->bg_color_);
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	G_OBJECT_CLASS (midori_tab_parent_class)->finalize (obj);
#line 2030 "midori-tab.c"
}


GType midori_tab_get_type (void) {
	static volatile gsize midori_tab_type_id__volatile = 0;
	if (g_once_init_enter (&midori_tab_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MidoriTabClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) midori_tab_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MidoriTab), 0, (GInstanceInitFunc) midori_tab_instance_init, NULL };
		GType midori_tab_type_id;
		midori_tab_type_id = g_type_register_static (GTK_TYPE_VBOX, "MidoriTab", &g_define_type_info, 0);
		g_once_init_leave (&midori_tab_type_id__volatile, midori_tab_type_id);
	}
	return midori_tab_type_id__volatile;
}


static void _vala_midori_tab_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	MidoriTab * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MIDORI_TYPE_TAB, MidoriTab);
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	switch (property_id) {
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		case MIDORI_TAB_RELATED_PROPERTY:
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		g_value_set_object (value, midori_tab_get_related (self));
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		break;
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		case MIDORI_TAB_WEB_VIEW_PROPERTY:
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		g_value_set_object (value, midori_tab_get_web_view (self));
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		break;
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		case MIDORI_TAB_URI_PROPERTY:
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		g_value_set_string (value, midori_tab_get_uri (self));
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		break;
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		case MIDORI_TAB_SPECIAL_PROPERTY:
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		g_value_set_boolean (value, midori_tab_get_special (self));
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		break;
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		case MIDORI_TAB_MINIMIZED_PROPERTY:
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		g_value_set_boolean (value, midori_tab_get_minimized (self));
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		break;
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		case MIDORI_TAB_MIME_TYPE_PROPERTY:
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		g_value_set_string (value, midori_tab_get_mime_type (self));
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		break;
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		case MIDORI_TAB_SECURITY_PROPERTY:
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		g_value_set_enum (value, midori_tab_get_security (self));
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		break;
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		case MIDORI_TAB_LOAD_STATUS_PROPERTY:
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		g_value_set_enum (value, midori_tab_get_load_status (self));
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		break;
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		case MIDORI_TAB_LOAD_ERROR_PROPERTY:
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		g_value_set_enum (value, midori_tab_get_load_error (self));
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		break;
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		case MIDORI_TAB_STATUSBAR_TEXT_PROPERTY:
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		g_value_set_string (value, midori_tab_get_statusbar_text (self));
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		break;
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		case MIDORI_TAB_PROGRESS_PROPERTY:
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		g_value_set_double (value, midori_tab_get_progress (self));
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		break;
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		case MIDORI_TAB_IS_DIALOG_PROPERTY:
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		g_value_set_boolean (value, midori_tab_get_is_dialog (self));
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		break;
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		case MIDORI_TAB_VIEW_SOURCE_PROPERTY:
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		g_value_set_boolean (value, midori_tab_get_view_source (self));
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		break;
#line 2129 "midori-tab.c"
		default:
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		break;
#line 2135 "midori-tab.c"
	}
}


static void _vala_midori_tab_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	MidoriTab * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MIDORI_TYPE_TAB, MidoriTab);
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
	switch (property_id) {
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		case MIDORI_TAB_RELATED_PROPERTY:
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		midori_tab_set_related (self, g_value_get_object (value));
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		break;
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		case MIDORI_TAB_WEB_VIEW_PROPERTY:
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		midori_tab_set_web_view (self, g_value_get_object (value));
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		break;
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		case MIDORI_TAB_URI_PROPERTY:
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		midori_tab_set_uri (self, g_value_get_string (value));
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		break;
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		case MIDORI_TAB_SPECIAL_PROPERTY:
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		midori_tab_set_special (self, g_value_get_boolean (value));
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		break;
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		case MIDORI_TAB_MINIMIZED_PROPERTY:
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		midori_tab_set_minimized (self, g_value_get_boolean (value));
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		break;
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		case MIDORI_TAB_MIME_TYPE_PROPERTY:
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		midori_tab_set_mime_type (self, g_value_get_string (value));
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		break;
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		case MIDORI_TAB_SECURITY_PROPERTY:
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		midori_tab_set_security (self, g_value_get_enum (value));
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		break;
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		case MIDORI_TAB_LOAD_STATUS_PROPERTY:
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		midori_tab_set_load_status (self, g_value_get_enum (value));
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		break;
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		case MIDORI_TAB_LOAD_ERROR_PROPERTY:
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		midori_tab_set_load_error (self, g_value_get_enum (value));
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		break;
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		case MIDORI_TAB_STATUSBAR_TEXT_PROPERTY:
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		midori_tab_set_statusbar_text (self, g_value_get_string (value));
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		break;
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		case MIDORI_TAB_PROGRESS_PROPERTY:
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		midori_tab_set_progress (self, g_value_get_double (value));
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		break;
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		case MIDORI_TAB_IS_DIALOG_PROPERTY:
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		midori_tab_set_is_dialog (self, g_value_get_boolean (value));
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		break;
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		case MIDORI_TAB_VIEW_SOURCE_PROPERTY:
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		midori_tab_set_view_source (self, g_value_get_boolean (value));
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		break;
#line 2223 "midori-tab.c"
		default:
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 45 "/usr/src/ports/midori/midori-0.5.11-2.i686/src/midori-0.5.11/midori/midori-tab.vala"
		break;
#line 2229 "midori-tab.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



