/***************************************************
	mined keyboard mapping table
	* generated with mkkbmap
	  from lib/kbmaps/cxterm/WuBi.utf
	* supplemented with punctuation mappings
*/
struct keymap keymap_WuBi [] = {
	{"!", "！"},
	{"#", "〃 々 〆 〇 〜 ￦"},
	{"$", "￥"},
	{"&", "―"},
	{"(", "（"},
	{")", "）"},
	{",", "，"},
	{".", "。"},
	{":", "："},
	{";", "；"},
	{"<", "〈"},
	{"<<", "《"},
	{">", "〉"},
	{">>", "》"},
	{"?", "？"},
	{"@", "・"},
	{"[", "【 〖 〔 「 『"},
	{"\\", "、"},
	{"]", "】 〗 〕 」 』"},
	{"^", "……"},
	{"_", "――"},
	{"«", "《"},
	{"»", "》"},
	{"€", "€ ＄ ￥ ￦ ￡ ￠ ￢ ￣"},

	{"a", "工"},
	{"aa", "式"},
	{"aaaa", "工"},
	{"aad", "式"},
	{"aadk", "匿"},
	{"aadn", "葚 慝"},
	{"aadw", "萁"},
	{"aafd", "甙"},
	{"aaff", "苷"},
	{"aah", "芽"},
	{"aaht", "芽"},
	{"aak", "戒"},
	{"aanf", "苣"},
	{"aatq", "荛"},
	{"ab", "节"},
	{"abe", "荫"},
	{"abef", "荫"},
	{"abf", "茸"},
	{"abh", "邛"},
	{"abib", "菡"},
	{"abio", "蒸"},
	{"abiu", "荪"},
	{"abj", "节"},
	{"abm", "茁"},
	{"abmj", "茁"},
	{"abnb", "芤"},
	{"abry", "菰"},
	{"abu", "萨"},
	{"abut", "萨"},
	{"ac", "芭"},
	{"aca", "茎"},
	{"acaf", "茎"},
	{"acb", "芭"},
	{"acbm", "蓣"},
	{"acbt", "茅"},
	{"ack", "苔"},
	{"ackf", "苔"},
	{"ad", "基"},
	{"ada", "莽"},
	{"adaj", "莽"},
	{"adaw", "蕻"},
	{"adbb", "苊"},
	{"adcu", "茇"},
	{"ade", "戎"},
	{"adef", "葫"},
	{"adf", "苦"},
	{"adff", "蓐"},
	{"adfi", "萘"},
	{"adgt", "葳"},
	{"adh", "荐"},
	{"adhb", "荐"},
	{"adhd", "葜"},
	{"adhf", "茬"},
	{"adi", "藉"},
	{"adij", "藉"},
	{"adiy", "藕"},
	{"adj", "菲"},
	{"adjd", "菲 匪"},
	{"adk", "若"},
	{"adkf", "若"},
	{"adkn", "惹"},
	{"adlb", "苈"},
	{"adm", "项"},
	{"admt", "蒇"},
	{"admy", "项"},
	{"adn", "茂"},
	{"adnt", "藏 茂"},
	{"aduw", "蕨"},
	{"adw", "其"},
	{"adwa", "戡"},
	{"adwe", "期"},
	{"adwf", "基 斟"},
	{"adwi", "綦"},
	{"adwl", "勘"},
	{"adwn", "甚"},
	{"adwr", "斯"},
	{"adwt", "蓁"},
	{"adwu", "其"},
	{"adww", "欺"},
	{"adxb", "茏"},
	{"ae", "菜"},
	{"aeb", "艿"},
	{"aebc", "菔"},
	{"aebf", "莩"},
	{"aee", "藐"},
	{"aeej", "蒯"},
	{"aeeq", "藐"},
	{"aegf", "苴"},
	{"aes", "菜"},
	{"aesu", "菜"},
	{"aet", "散"},
	{"aetg", "蕤"},
	{"aety", "散"},
	{"aeu", "藤"},
	{"aeui", "藤"},
	{"aevf", "荽"},
	{"aeyu", "芨"},
	{"af", "革"},
	{"afab", "鞯"},
	{"afae", "鞴"},
	{"afb", "邯"},
	{"afbh", "邯"},
	{"afc", "靶"},
	{"afcn", "靶"},
	{"afcs", "鞣"},
	{"afcu", "芸 芰"},
	{"afd", "甘"},
	{"afdj", "薷"},
	{"afdp", "鞑"},
	{"aff", "芏"},
	{"afff", "鞋 葑 鞲"},
	{"afi", "蒜"},
	{"afie", "鞘"},
	{"afii", "蒜"},
	{"afj", "革"},
	{"afjg", "靼"},
	{"afkf", "薹"},
	{"afl", "勒"},
	{"aflf", "蕾"},
	{"afln", "勒"},
	{"afm", "贰"},
	{"afmd", "鞅"},
	{"afmi", "贰"},
	{"afn", "苇"},
	{"afnh", "苇"},
	{"afp", "鞍"},
	{"afpb", "荸"},
	{"afpv", "鞍"},
	{"afq", "鞠"},
	{"afqb", "芜 芫"},
	{"afqo", "鞠"},
	{"afqq", "鞔"},
	{"afqw", "莰"},
	{"afqy", "鞫"},
	{"afr", "靳"},
	{"afrh", "靳"},
	{"afs", "某"},
	{"afsu", "某"},
	{"aft", "著"},
	{"aftj", "蓍 鞒 著"},
	{"afu", "蔷"},
	{"afuk", "蔷"},
	{"afw", "鞭"},
	{"afwq", "鞭"},
	{"afwt", "菱"},
	{"afwu", "芙"},
	{"afwx", "靴"},
	{"afwy", "藿"},
	{"ag", "七"},
	{"aga", "荆"},
	{"agaj", "荆"},
	{"agd", "匡"},
	{"age", "莆"},
	{"agef", "菁"},
	{"agey", "莆"},
	{"agf", "芋"},
	{"agfj", "芋"},
	{"aghg", "廿"},
	{"aghh", "艹"},
	{"agho", "蔫"},
	{"agig", "苤"},
	{"agjn", "蕙"},
	{"agkw", "蔌"},
	{"agmh", "芾"},
	{"agmm", "颟"},
	{"agn", "匚 七"},
	{"agnn", "巧"},
	{"agnt", "戈"},
	{"agny", "弋"},
	{"ago", "莱"},
	{"agou", "莱"},
	{"agq", "葬"},
	{"agqa", "葬"},
	{"agqg", "薤"},
	{"agsu", "茉"},
	{"agth", "廾"},
	{"agu", "苹"},
	{"aguh", "苹"},
	{"aguw", "荚"},
	{"agvv", "萋"},
	{"agxw", "荑"},
	{"ah", "牙"},
	{"ahap", "蘧"},
	{"ahf", "芷 苜"},
	{"ahic", "菽"},
	{"ahk", "苫 熙"},
	{"ahkf", "苫"},
	{"ahkm", "赜 颐"},
	{"ahko", "熙"},
	{"ahn", "臣"},
	{"ahnh", "臣 卧"},
	{"aht", "牙"},
	{"ahtb", "邪"},
	{"ahte", "牙"},
	{"ahtg", "鸦"},
	{"ahtp", "迓"},
	{"ahty", "雅"},
	{"ahxb", "茈"},
	{"ai", "东"},
	{"aiaf", "茳"},
	{"aias", "蕖"},
	{"aib", "范"},
	{"aibb", "范"},
	{"aieg", "菹"},
	{"aig", "薄 萍"},
	{"aigf", "薄"},
	{"aigh", "萍"},
	{"aigy", "蒲"},
	{"aih", "菠"},
	{"aihc", "菠"},
	{"aii", "东"},
	{"aiit", "莎"},
	{"aik", "藻"},
	{"aiks", "藻"},
	{"ain", "荡"},
	{"ainr", "荡"},
	{"aiqg", "鸫"},
	{"aire", "蒎"},
	{"ais", "菏"},
	{"aisk", "菏"},
	{"ait", "落"},
	{"aitk", "落"},
	{"aitl", "藩"},
	{"aiu", "汞"},
	{"aiy", "茫"},
	{"aiye", "蒗"},
	{"aiyn", "茫"},
	{"aj", "划"},
	{"ajbc", "蕞"},
	{"ajd", "莫 募"},
	{"ajdc", "蓦"},
	{"ajdf", "墓"},
	{"ajdh", "幕"},
	{"ajdj", "暮"},
	{"ajdl", "募"},
	{"ajdn", "慕"},
	{"ajdr", "摹"},
	{"ajdu", "莫"},
	{"aje", "萌"},
	{"ajef", "萌"},
	{"ajf", "昔"},
	{"ajfu", "莳"},
	{"ajh", "划"},
	{"ajj", "草"},
	{"ajjf", "菖"},
	{"ajl", "蔓"},
	{"ajlc", "蔓"},
	{"ajq", "葛 鹊"},
	{"ajqg", "鹊"},
	{"ajqn", "葛"},
	{"ajt", "蓝"},
	{"ajtl", "蓝"},
	{"aju", "茧"},
	{"ajvb", "郾"},
	{"ak", "或"},
	{"akbf", "葺"},
	{"akbt", "蕺"},
	{"akd", "叵"},
	{"akg", "或"},
	{"akgb", "鄞"},
	{"akgd", "或"},
	{"akgf", "堇"},
	{"akgl", "勤"},
	{"akgn", "惑"},
	{"akgq", "觐"},
	{"akhm", "匮 佝 蒉"},
	{"akk", "颧"},
	{"akkf", "莒"},
	{"akkg", "鹳"},
	{"akkm", "颧"},
	{"akkn", "萼"},
	{"akmw", "莴"},
	{"al", "功"},
	{"ald", "茵"},
	{"aldn", "蒽"},
	{"aldt", "蔑"},
	{"aldu", "茵"},
	{"alf", "苗"},
	{"alfj", "薯"},
	{"alk", "匣"},
	{"alkf", "茄 茴"},
	{"all", "荔"},
	{"alll", "荔"},
	{"aln", "功"},
	{"alnu", "葸"},
	{"alp", "莲"},
	{"alph", "瞢"},
	{"alpn", "甍"},
	{"alpu", "莲"},
	{"alpx", "薨"},
	{"alq", "萝"},
	{"alqg", "鹋"},
	{"alqu", "萝"},
	{"alt", "菌"},
	{"altu", "菌"},
	{"alvv", "匦"},
	{"alw", "苏"},
	{"alwu", "苏"},
	{"am", "贡"},
	{"amcu", "芟"},
	{"amd", "英"},
	{"amdu", "英"},
	{"amff", "苒"},
	{"amgk", "茼"},
	{"amh", "匝"},
	{"amhk", "萜 匝"},
	{"amkf", "苘"},
	{"amqb", "苋"},
	{"amu", "贡"},
	{"amw", "黄"},
	{"amwu", "黄 芮"},
	{"amy", "巩"},
	{"amyh", "跫"},
	{"amyj", "蛩"},
	{"amyn", "恐"},
	{"amyq", "銎"},
	{"amyy", "巩"},
	{"an", "世"},
	{"anab", "苠"},
	{"anb", "芑 艺"},
	{"and", "巨"},
	{"anf", "蔚"},
	{"anff", "蔚"},
	{"anh", "蔬"},
	{"anhq", "蔬"},
	{"ani", "忒"},
	{"anku", "薜"},
	{"anmu", "贳"},
	{"ann", "蕊"},
	{"annn", "蕊"},
	{"anu", "芯"},
	{"anud", "荬"},
	{"anv", "世"},
	{"anwe", "蓼"},
	{"anyu", "荩"},
	{"anyw", "苡"},
	{"aovf", "蒌"},
	{"aovt", "薮"},
	{"ap", "芝"},
	{"apdf", "菪"},
	{"apff", "茔"},
	{"apfl", "蔻"},
	{"apfq", "莞"},
	{"apg", "蒙 莹"},
	{"apge", "蒙"},
	{"apgf", "苎"},
	{"apgg", "萱"},
	{"apgy", "莹"},
	{"apiu", "荥"},
	{"apj", "萤"},
	{"apju", "萤"},
	{"apk", "营"},
	{"apkk", "营"},
	{"apl", "劳"},
	{"aplb", "劳"},
	{"aplj", "荤"},
	{"apnf", "茕"},
	{"apnn", "菅"},
	{"apo", "荧"},
	{"apou", "荧"},
	{"apqb", "菀"},
	{"apqf", "蓥"},
	{"apqg", "莺"},
	{"aprh", "荦"},
	{"aps", "荣"},
	{"apsu", "荣"},
	{"apu", "芝"},
	{"apw", "蓉"},
	{"apwj", "蓿"},
	{"apwk", "蓉"},
	{"apxi", "萦"},
	{"aq", "区"},
	{"aqab", "芪"},
	{"aqb", "苑"},
	{"aqbb", "苑"},
	{"aqg", "葡"},
	{"aqgb", "茚"},
	{"aqgd", "藓"},
	{"aqgj", "蓟"},
	{"aqgn", "瓯"},
	{"aqgy", "葡"},
	{"aqi", "区"},
	{"aqjf", "荀"},
	{"aqk", "敬"},
	{"aqkf", "苟 茗"},
	{"aqkr", "擎"},
	{"aqks", "檠"},
	{"aqkt", "敬"},
	{"aqky", "警 菟"},
	{"aqm", "殴"},
	{"aqmc", "殴"},
	{"aqn", "苞"},
	{"aqnb", "苞"},
	{"aqo", "菊"},
	{"aqou", "菊"},
	{"aqq", "欧"},
	{"aqqg", "鸥"},
	{"aqqw", "欧"},
	{"aqr", "萄"},
	{"aqrm", "萄"},
	{"aqrn", "葱"},
	{"aqrq", "蔸"},
	{"aqrr", "芴"},
	{"aqt", "获"},
	{"aqtb", "茆"},
	{"aqtd", "获"},
	{"aqtn", "莸"},
	{"aqto", "荻"},
	{"aqu", "艾"},
	{"aqv", "匹"},
	{"aqvf", "萏"},
	{"aqwu", "芡"},
	{"aqy", "芍"},
	{"aqyg", "茑 鸢"},
	{"aqyu", "芍"},
	{"ar", "匠"},
	{"arcb", "葩"},
	{"ardc", "菝"},
	{"ariu", "茱"},
	{"arj", "芹"},
	{"ark", "匠"},
	{"artf", "萆"},
	{"as", "苛"},
	{"asf", "茜"},
	{"asg", "苯"},
	{"asgf", "苯"},
	{"asgo", "蘸"},
	{"ashf", "葙"},
	{"asjj", "蕈"},
	{"ask", "苛"},
	{"askf", "苛"},
	{"asrj", "菥"},
	{"aswc", "菘"},
	{"at", "攻"},
	{"atay", "苌"},
	{"atd", "医"},
	{"atdi", "医"},
	{"atdj", "荞"},
	{"atdn", "翳"},
	{"atdp", "蓬"},
	{"ateb", "莠"},
	{"atfh", "荇"},
	{"atfj", "芊"},
	{"atfp", "莛"},
	{"atg", "董"},
	{"atgf", "董"},
	{"atgn", "翘"},
	{"atgo", "薰"},
	{"atgq", "尧"},
	{"athh", "蓰"},
	{"atl", "蓖"},
	{"atlx", "蓖"},
	{"atmt", "薇"},
	{"atol", "蕃"},
	{"atqh", "蘅"},
	{"atqi", "藜"},
	{"atrt", "莪"},
	{"atv", "萎"},
	{"atvf", "萎"},
	{"atxi", "蘩"},
	{"atxu", "莓"},
	{"aty", "攻"},
	{"au", "燕"},
	{"aube", "蒴"},
	{"augu", "茭"},
	{"auj", "莘"},
	{"aujn", "薏"},
	{"aujr", "蕲"},
	{"auk", "菩 燕"},
	{"aukf", "菩"},
	{"auko", "燕"},
	{"aum", "蔽"},
	{"aumt", "蔽"},
	{"aup", "蒂"},
	{"auph", "蒂"},
	{"aupy", "蒡"},
	{"auq", "蒋"},
	{"auqf", "蒋"},
	{"auqw", "茨"},
	{"aus", "薪"},
	{"ausr", "薪"},
	{"autd", "蒺"},
	{"auvo", "蒹"},
	{"auwy", "蔺"},
	{"av", "切"},
	{"avb", "艽"},
	{"avd", "菇"},
	{"avdf", "菇 薅"},
	{"aveu", "茛"},
	{"avfu", "荨"},
	{"avij", "萧"},
	{"avk", "茹"},
	{"avkf", "茹 苕"},
	{"avn", "切"},
	{"avwu", "萸"},
	{"avyu", "芄"},
	{"aw", "共"},
	{"awb", "苍"},
	{"awbb", "苍"},
	{"awcn", "蓊"},
	{"awdu", "茯"},
	{"awf", "蔡"},
	{"awfc", "荟"},
	{"awff", "茌"},
	{"awfi", "蔡"},
	{"awfu", "苻"},
	{"awg", "葵"},
	{"awgd", "葵"},
	{"awgf", "荃"},
	{"awgi", "莶"},
	{"awgt", "蔹"},
	{"awht", "莜"},
	{"awj", "芥"},
	{"awjj", "芥"},
	{"awks", "葆"},
	{"awn", "巷"},
	{"awnb", "孽 巷"},
	{"awns", "蘖"},
	{"awnu", "恭 薛"},
	{"aws", "茶 荷"},
	{"awsk", "荷"},
	{"awsu", "茶"},
	{"awtf", "荏"},
	{"awtu", "荼"},
	{"awu", "共"},
	{"awuf", "莅"},
	{"awuk", "蓓"},
	{"awv", "芬"},
	{"awvb", "芬"},
	{"aww", "巫"},
	{"awwi", "巫"},
	{"awwq", "觋"},
	{"awwu", "苁"},
	{"awx", "花"},
	{"awxb", "花"},
	{"awy", "蕉"},
	{"awyc", "苓"},
	{"awyf", "萑"},
	{"awyj", "劐"},
	{"awyn", "芩"},
	{"awyo", "蕉"},
	{"ax", "药"},
	{"axaf", "荭"},
	{"axb", "芎"},
	{"axfu", "荮"},
	{"axgn", "莼"},
	{"axj", "蕴"},
	{"axjl", "蕴"},
	{"axq", "药"},
	{"axqy", "药"},
	{"axtr", "芗"},
	{"axxb", "芘"},
	{"axxf", "荜"},
	{"axxr", "蒈"},
	{"ay", "芳"},
	{"ayao", "蔗"},
	{"ayb", "芳"},
	{"aybc", "葭 蓠"},
	{"aycq", "茺"},
	{"ayhu", "苄"},
	{"ayj", "蔼"},
	{"ayjj", "荠"},
	{"ayjn", "蔼"},
	{"ayk", "蓑"},
	{"ayke", "蓑"},
	{"aymk", "蒿"},
	{"ayms", "藁"},
	{"ayn", "芒"},
	{"ayna", "匾"},
	{"aynb", "芒"},
	{"aynq", "荒"},
	{"aynr", "芦"},
	{"ayps", "葶"},
	{"ays", "蘑"},
	{"aysd", "蘑 蘼"},
	{"aytd", "蔟"},
	{"ayve", "莨"},
	{"aywf", "萃"},
	{"aywu", "菸"},
	{"ayx", "蓄"},
	{"ayxl", "蓄"},
	{"ayxy", "蕹"},
	{"b", "了"},
	{"ba", "陈"},
	{"bai", "陈"},
	{"baiy", "陈"},
	{"bb", "子"},
	{"bbb", "子"},
	{"bbbb", "子"},
	{"bbcy", "陬"},
	{"bbh", "耶"},
	{"bc", "取"},
	{"bcag", "陉"},
	{"bccm", "颞"},
	{"bccu", "聂"},
	{"bct", "聚"},
	{"bctb", "鄹"},
	{"bcti", "聚"},
	{"bcv", "娶"},
	{"bcvf", "娶"},
	{"bcy", "取"},
	{"bd", "承"},
	{"bda", "隋"},
	{"bdae", "隋"},
	{"bdan", "隳"},
	{"bde", "随"},
	{"bdef", "堕"},
	{"bdep", "随"},
	{"bdi", "承"},
	{"bdii", "承"},
	{"bdj", "陌"},
	{"bdjg", "陌"},
	{"bdx", "陇"},
	{"bdxn", "陇"},
	{"be", "阴"},
	{"beg", "阴"},
	{"begg", "阻"},
	{"bf", "际"},
	{"bfd", "孺"},
	{"bfdj", "孺"},
	{"bfek", "唇"},
	{"bfh", "陡"},
	{"bfhy", "陡"},
	{"bfi", "际"},
	{"bfiy", "际"},
	{"bfjh", "阱"},
	{"bfm", "陆"},
	{"bfmh", "陆"},
	{"bfq", "阮"},
	{"bfqn", "阮"},
	{"bfw", "陵"},
	{"bfwt", "陵"},
	{"bg", "卫"},
	{"bgd", "卫"},
	{"bgh", "耳"},
	{"bghg", "耳"},
	{"bgk", "隔"},
	{"bgkh", "隔"},
	{"bgm", "陋"},
	{"bgmn", "陋"},
	{"bgqn", "阢"},
	{"bgu", "陕"},
	{"bguw", "陕"},
	{"bh", "耻"},
	{"bhcy", "陂"},
	{"bhg", "耻"},
	{"bhgj", "蚩"},
	{"bhic", "骘"},
	{"bhit", "陟"},
	{"bhk", "屮"},
	{"bhkg", "阽"},
	{"bi", "孙"},
	{"bib", "函"},
	{"bibk", "函"},
	{"bigb", "卺"},
	{"bigf", "丞"},
	{"bij", "隙"},
	{"biji", "隙"},
	{"bip", "逊"},
	{"bipi", "逊"},
	{"biy", "孙"},
	{"bj", "阳"},
	{"bjfg", "陧"},
	{"bjg", "阳"},
	{"bjm", "隅"},
	{"bjmy", "隅"},
	{"bjxo", "隰"},
	{"bk", "职"},
	{"bkcg", "亟"},
	{"bkhm", "聩"},
	{"bkm", "陨"},
	{"bkmy", "陨"},
	{"bkw", "职"},
	{"bkwy", "职"},
	{"bl", "阵"},
	{"blf", "孟"},
	{"blge", "隈"},
	{"blh", "阵"},
	{"blln", "勐"},
	{"bm", "出"},
	{"bmf", "祟"},
	{"bmfg", "聃"},
	{"bmfi", "祟"},
	{"bmg", "聘"},
	{"bmgn", "聘"},
	{"bmk", "出"},
	{"bmou", "粜"},
	{"bn", "也"},
	{"bnh", "了 卩 阝 凵 也"},
	{"bnhg", "孑"},
	{"bnhn", "也"},
	{"bnn", "孔"},
	{"bo", "耿"},
	{"boy", "耿"},
	{"bp", "辽"},
	{"bpf", "院"},
	{"bpfq", "院"},
	{"bpk", "辽"},
	{"bpq", "耽"},
	{"bpqn", "耽"},
	{"bpsh", "聍"},
	{"bpx", "陀"},
	{"bpxn", "陀"},
	{"bq", "隐"},
	{"bqnn", "孢"},
	{"bqr", "陶"},
	{"bqrm", "陶"},
	{"bqt", "聊"},
	{"bqtb", "聊"},
	{"bqv", "陷 隐"},
	{"bqvg", "陷"},
	{"bqvn", "隐"},
	{"br", "孤"},
	{"brc", "孤"},
	{"brcy", "孤 阪"},
	{"brgg", "隍"},
	{"brqc", "隗"},
	{"brtf", "陴"},
	{"bs", "阿"},
	{"bsh", "耵"},
	{"bsk", "阿"},
	{"bskg", "阿"},
	{"bt", "降"},
	{"bta", "降"},
	{"btah", "降"},
	{"btdg", "聒"},
	{"btfh", "阡"},
	{"btg", "隆"},
	{"btgf", "陲"},
	{"btgg", "隆"},
	{"bthf", "阼"},
	{"bty", "孜"},
	{"bu", "联"},
	{"bubj", "劂"},
	{"bud", "联"},
	{"budy", "联"},
	{"bue", "隧"},
	{"buep", "隧"},
	{"buj", "障"},
	{"bujh", "障"},
	{"buk", "陪"},
	{"bukg", "陪"},
	{"bukn", "聪"},
	{"buw", "隘"},
	{"buwl", "隘"},
	{"bv", "限"},
	{"bve", "限"},
	{"bvey", "限"},
	{"bw", "队"},
	{"bwf", "附"},
	{"bwff", "坠"},
	{"bwfy", "附"},
	{"bwg", "险"},
	{"bwgi", "险"},
	{"bwj", "阶"},
	{"bwjh", "阶"},
	{"bwt", "除"},
	{"bwty", "除"},
	{"bwy", "队"},
	{"bwyc", "聆"},
	{"bx", "陛"},
	{"bxx", "陛"},
	{"bxxf", "陛"},
	{"by", "防"},
	{"byi", "孓"},
	{"byn", "防"},
	{"bynw", "孩 陔"},
	{"c", "以"},
	{"ca", "戏"},
	{"cad", "颈"},
	{"cadm", "颈"},
	{"cadw", "骐"},
	{"caj", "弁"},
	{"cajh", "刭"},
	{"cal", "劲"},
	{"caln", "劲"},
	{"capd", "迳"},
	{"caq", "驱"},
	{"caqy", "驱"},
	{"cat", "戏"},
	{"catq", "骁"},
	{"cayq", "巯"},
	{"cb", "邓"},
	{"cbc", "骤"},
	{"cbci", "骤"},
	{"cbd", "预"},
	{"cbdm", "预"},
	{"cbh", "邓"},
	{"cbj", "予"},
	{"cbn", "驰"},
	{"cbq", "豫"},
	{"cbqe", "豫"},
	{"cbt", "矛"},
	{"cbtc", "骛"},
	{"cbtg", "鹜 鹬"},
	{"cbth", "瞀"},
	{"cbtj", "蝥 蟊"},
	{"cbtn", "矜"},
	{"cbtq", "鍪"},
	{"cbtr", "矛"},
	{"cbts", "柔"},
	{"cbtv", "婺"},
	{"cc", "双"},
	{"ccc", "又"},
	{"cccc", "又"},
	{"cccf", "垒"},
	{"cccg", "叠"},
	{"cccm", "颡"},
	{"cccs", "桑"},
	{"ccde", "骖"},
	{"ccfh", "驿"},
	{"cckg", "骀"},
	{"ccw", "骏"},
	{"ccwt", "骏"},
	{"ccy", "双 驭"},
	{"ccyj", "骚"},
	{"cd", "参"},
	{"cdd", "叁"},
	{"cddf", "叁"},
	{"cde", "参"},
	{"cden", "毵"},
	{"cder", "参"},
	{"cdlf", "畚"},
	{"cds", "骑"},
	{"cdsk", "骑"},
	{"cdy", "驮"},
	{"ce", "能"},
	{"cegg", "驵"},
	{"cej", "甬"},
	{"cel", "勇"},
	{"celb", "勇"},
	{"cen", "恿"},
	{"cenu", "恿"},
	{"cep", "通"},
	{"cepk", "通"},
	{"cex", "能"},
	{"cexo", "熊"},
	{"cexx", "能"},
	{"cf", "对"},
	{"cff", "圣"},
	{"cfnu", "怼"},
	{"cfy", "对"},
	{"cgmy", "骊"},
	{"ciit", "耖"},
	{"cjsy", "骒"},
	{"ck", "台"},
	{"ckbh", "邰"},
	{"ckf", "台"},
	{"ckh", "驯"},
	{"ckn", "怠"},
	{"cknu", "怠"},
	{"ckou", "炱"},
	{"ckpd", "迨"},
	{"ckq", "驶"},
	{"ckqy", "驶"},
	{"cl", "劝"},
	{"clg", "驷"},
	{"cln", "劝"},
	{"clx", "骡"},
	{"clxi", "骡"},
	{"cm", "观"},
	{"cmd", "碳"},
	{"cmdo", "碳"},
	{"cmg", "骋"},
	{"cmgn", "骋"},
	{"cmq", "观"},
	{"cmqn", "观"},
	{"cn", "马"},
	{"cnbb", "骣"},
	{"cnh", "巴"},
	{"cnhn", "巴"},
	{"cnn", "马"},
	{"cnng", "马"},
	{"cny", "厶"},
	{"cp", "驼"},
	{"cpx", "驼"},
	{"cpxn", "驼"},
	{"cq", "允"},
	{"cqb", "允"},
	{"cqk", "驹"},
	{"cqkg", "驹"},
	{"cqq", "驳"},
	{"cqqy", "驳"},
	{"cqvg", "驺"},
	{"cqw", "欢"},
	{"cqwy", "欢"},
	{"cqy", "鸡"},
	{"cqyg", "鸡"},
	{"cqyl", "骝"},
	{"cr", "牟"},
	{"crh", "牟"},
	{"crhj", "牟"},
	{"csfi", "骠"},
	{"ct", "矣"},
	{"ctd", "矣"},
	{"ctdj", "骄"},
	{"ctdu", "矣"},
	{"ctk", "骆"},
	{"ctkg", "骆"},
	{"ctln", "骢"},
	{"cuah", "骈"},
	{"cuxw", "骥"},
	{"cv", "艰"},
	{"cve", "艰"},
	{"cvey", "艰"},
	{"cw", "难"},
	{"cwfy", "驸"},
	{"cwg", "验"},
	{"cwgi", "验"},
	{"cwtc", "皴"},
	{"cwtp", "逡"},
	{"cwxf", "骅"},
	{"cwy", "难"},
	{"cwyg", "难 骓"},
	{"cy", "驻"},
	{"cyg", "驻"},
	{"cygg", "驻"},
	{"cyi", "叉"},
	{"cyj", "蚤"},
	{"cyju", "蚤"},
	{"cyke", "骧"},
	{"cyn", "驴"},
	{"cyna", "骗"},
	{"cynn", "骟"},
	{"cynt", "驴"},
	{"cynw", "骇"},
	{"d", "在"},
	{"da", "左"},
	{"dadr", "厮"},
	{"daf", "左"},
	{"daht", "砑"},
	{"daif", "礴"},
	{"dajd", "厝"},
	{"dam", "磺"},
	{"damh", "砸"},
	{"damw", "磺"},
	{"dan", "碟"},
	{"dans", "碟"},
	{"dape", "朦 礞"},
	{"daqu", "奁"},
	{"daqy", "砹"},
	{"datq", "硗"},
	{"dav", "砌"},
	{"davn", "砌"},
	{"dawi", "礤"},
	{"dayn", "硭"},
	{"db", "顾"},
	{"dbd", "顾"},
	{"dbdm", "顾"},
	{"dbf", "耷"},
	{"dbm", "础"},
	{"dbmh", "础"},
	{"dbn", "怨"},
	{"dbnu", "怨"},
	{"dbv", "厄"},
	{"dc", "友"},
	{"dccs", "磉"},
	{"dcde", "碜"},
	{"dcg", "码"},
	{"dcu", "友"},
	{"dcw", "雄"},
	{"dcwy", "雄"},
	{"dd", "大"},
	{"ddd", "磊"},
	{"dddd", "大"},
	{"dddf", "磊"},
	{"dddl", "靥"},
	{"dddn", "砺"},
	{"dddq", "飙"},
	{"ddg", "碱"},
	{"ddgt", "碱"},
	{"ddh", "厦"},
	{"ddht", "厦"},
	{"ddi", "厌"},
	{"ddlk", "厣"},
	{"ddm", "硕"},
	{"ddmy", "硕"},
	{"ddn", "厉"},
	{"ddnl", "励"},
	{"ddnv", "厉"},
	{"ddrc", "魇"},
	{"ddu", "套"},
	{"ddwe", "餍"},
	{"de", "胡"},
	{"deb", "郁"},
	{"debh", "郁"},
	{"dee", "硼"},
	{"deeg", "硼"},
	{"def", "有"},
	{"defk", "髻"},
	{"deg", "胡"},
	{"degq", "髡"},
	{"dehx", "髭"},
	{"dele", "鬟"},
	{"demf", "髯"},
	{"dep", "鬃"},
	{"depi", "鬃"},
	{"depw", "鬓"},
	{"deqg", "鹕"},
	{"det", "髟"},
	{"detn", "髦"},
	{"deto", "鬏"},
	{"deub", "鬈"},
	{"devk", "髫"},
	{"devn", "鬣"},
	{"dews", "髹"},
	{"df", "夺"},
	{"dfa", "奔"},
	{"dfaj", "奔"},
	{"dfc", "磕"},
	{"dfcl", "磕"},
	{"dfcy", "砝"},
	{"dfe", "辰"},
	{"dfef", "辱"},
	{"dfei", "辰"},
	{"dfej", "蜃"},
	{"dff", "硅"},
	{"dfff", "奎"},
	{"dffg", "硅"},
	{"dfh", "矸"},
	{"dfi", "奈"},
	{"dfiu", "奈"},
	{"dfn", "夸"},
	{"dfnb", "夸"},
	{"dfnj", "刳"},
	{"dfnn", "匏"},
	{"dfny", "瓠 砖"},
	{"dft", "奢"},
	{"dftj", "奢"},
	{"dfu", "夺"},
	{"dfy", "压"},
	{"dfyi", "压"},
	{"dg", "三"},
	{"dga", "研"},
	{"dgah", "研"},
	{"dgaj", "硎"},
	{"dgbn", "砘"},
	{"dgg", "三"},
	{"dggg", "三"},
	{"dgh", "古"},
	{"dghg", "古"},
	{"dgj", "硬"},
	{"dgjq", "硬"},
	{"dgk", "咸"},
	{"dgkf", "厨"},
	{"dgkn", "感"},
	{"dgkt", "咸"},
	{"dglg", "礓"},
	{"dgmy", "碛"},
	{"dgn", "戌"},
	{"dgnt", "戌"},
	{"dgt", "厂"},
	{"dgtg", "石"},
	{"dgty", "犬"},
	{"dgu", "砰"},
	{"dguh", "砰"},
	{"dguw", "硖"},
	{"dgv", "威"},
	{"dgvt", "威"},
	{"dgxu", "碡"},
	{"dh", "丰"},
	{"dhar", "戛"},
	{"dhb", "存"},
	{"dhbd", "存"},
	{"dhc", "破"},
	{"dhcy", "破"},
	{"dhdb", "酆"},
	{"dhdf", "砉"},
	{"dhdn", "慧"},
	{"dhdv", "彗"},
	{"dhf", "在"},
	{"dhfd", "在"},
	{"dhi", "戚"},
	{"dhih", "蹙"},
	{"dhit", "戚"},
	{"dhk", "丰"},
	{"dhkg", "砧"},
	{"dhq", "艳"},
	{"dhqc", "艳"},
	{"dht", "夏"},
	{"dhtu", "夏"},
	{"dhv", "契"},
	{"dhvd", "契"},
	{"dhvn", "恝"},
	{"dhvr", "挈"},
	{"di", "砂"},
	{"dial", "耢"},
	{"dias", "磲"},
	{"dibg", "耔"},
	{"dic", "耙"},
	{"dicn", "耙"},
	{"didf", "耨"},
	{"die", "硝"},
	{"dieg", "硝"},
	{"dif", "耕"},
	{"difc", "耘"},
	{"diff", "耩"},
	{"difj", "耕"},
	{"dii", "耒"},
	{"diik", "耥"},
	{"dijy", "耦"},
	{"dinn", "耜"},
	{"diov", "耧"},
	{"dit", "砂"},
	{"ditn", "耗"},
	{"ditt", "砂"},
	{"diu", "泵"},
	{"diuy", "耪"},
	{"diwk", "耠"},
	{"diyd", "耱"},
	{"dj", "百"},
	{"djb", "厚"},
	{"djbd", "厚"},
	{"djd", "非"},
	{"djdd", "非"},
	{"djde", "裴"},
	{"djdg", "韭"},
	{"djdj", "蜚"},
	{"djdl", "辈"},
	{"djdn", "悲 翡"},
	{"djdy", "斐"},
	{"djf", "百"},
	{"djfd", "厘"},
	{"djg", "碍"},
	{"djgf", "碍"},
	{"djh", "砷"},
	{"djhh", "砷"},
	{"djn", "奄"},
	{"djnb", "奄"},
	{"djng", "鹌"},
	{"djqn", "碣"},
	{"dk", "右"},
	{"dkf", "右"},
	{"dkj", "夼"},
	{"dl", "历"},
	{"dlb", "夯"},
	{"dlf", "奋"},
	{"dlh", "砗"},
	{"dlk", "厍"},
	{"dlv", "历"},
	{"dm", "面"},
	{"dma", "碘"},
	{"dmaw", "碘"},
	{"dmf", "碉"},
	{"dmfk", "碉"},
	{"dmgk", "硐"},
	{"dmh", "布"},
	{"dmhj", "布"},
	{"dmj", "而"},
	{"dmjd", "面"},
	{"dmjf", "耐"},
	{"dmjg", "鸸"},
	{"dmjj", "而"},
	{"dmjk", "厕"},
	{"dmjn", "恧"},
	{"dmjv", "耍"},
	{"dmn", "矶"},
	{"dmq", "砚"},
	{"dmqn", "砚"},
	{"dmqy", "砜"},
	{"dmu", "页"},
	{"dmy", "矾"},
	{"dmyy", "矾"},
	{"dn", "成"},
	{"dna", "碾"},
	{"dnae", "碾"},
	{"dndt", "臧"},
	{"dnhc", "嘏"},
	{"dnjl", "尴"},
	{"dnju", "虿"},
	{"dnkh", "趸"},
	{"dnln", "劢"},
	{"dnn", "成"},
	{"dnnl", "盛"},
	{"dnnt", "成"},
	{"dnp", "迈"},
	{"dnpv", "迈"},
	{"dnqy", "尥"},
	{"dnrt", "砀"},
	{"dnv", "万 尢 尤"},
	{"dnwj", "尬"},
	{"dny", "戊"},
	{"dnyt", "戊"},
	{"do", "灰"},
	{"dol", "盔"},
	{"dolf", "盔"},
	{"doq", "磷"},
	{"doqh", "磷"},
	{"dou", "灰"},
	{"dp", "达"},
	{"dpgg", "碹"},
	{"dpgh", "碇"},
	{"dpi", "达"},
	{"dpq", "碗"},
	{"dpqb", "碗"},
	{"dpr", "牵"},
	{"dprh", "牵"},
	{"dpwf", "膣"},
	{"dpxn", "砣"},
	{"dq", "克"},
	{"dqas", "磔"},
	{"dqay", "砥"},
	{"dqb", "克"},
	{"dqd", "兢"},
	{"dqdq", "兢"},
	{"dqe", "确"},
	{"dqeh", "确"},
	{"dqi", "砾"},
	{"dqiy", "砾"},
	{"dqq", "爽"},
	{"dqqq", "爽"},
	{"dqw", "砍"},
	{"dqwy", "砍"},
	{"dqy", "矽"},
	{"dqyg", "鸪"},
	{"dr", "原"},
	{"drh", "斫"},
	{"dri", "原"},
	{"drii", "原"},
	{"drin", "愿"},
	{"drt", "碑"},
	{"drtf", "碑"},
	{"ds", "厅"},
	{"dsg", "硒"},
	{"dsh", "厢"},
	{"dshd", "厢"},
	{"dsj", "碴"},
	{"dsjg", "碴"},
	{"dsk", "厅"},
	{"dskf", "奇"},
	{"dskj", "剞"},
	{"dskw", "欹"},
	{"dt", "帮"},
	{"dtb", "邦"},
	{"dtbh", "邦 帮"},
	{"dtf", "寿"},
	{"dtfo", "焘"},
	{"dtfu", "寿"},
	{"dthf", "砟"},
	{"dtkg", "硌"},
	{"dtlq", "硇"},
	{"dtpy", "砭"},
	{"dtrt", "硪"},
	{"dty", "故"},
	{"du", "磁"},
	{"dubw", "厥"},
	{"duce", "磙"},
	{"dud", "磋"},
	{"duda", "磋"},
	{"dug", "砬"},
	{"duj", "辜"},
	{"dujg", "鹩"},
	{"dukg", "碚"},
	{"duo", "碰"},
	{"duog", "碰"},
	{"dup", "磅"},
	{"duph", "碲"},
	{"dupy", "磅"},
	{"dux", "磁"},
	{"duxx", "磁"},
	{"dv", "肆"},
	{"dvc", "厩"},
	{"dvcq", "厩"},
	{"dvf", "肆"},
	{"dvfh", "肆"},
	{"dvi", "碌"},
	{"dviy", "碌"},
	{"dw", "春"},
	{"dwag", "砼"},
	{"dwf", "奉"},
	{"dwfh", "奉"},
	{"dwg", "奏"},
	{"dwgd", "奏"},
	{"dwgi", "硷"},
	{"dwgu", "磴"},
	{"dwi", "仄 泰"},
	{"dwiu", "泰"},
	{"dwj", "春"},
	{"dwjf", "春"},
	{"dwjj", "蠢"},
	{"dwt", "秦"},
	{"dwtu", "秦"},
	{"dwvf", "舂"},
	{"dww", "雁"},
	{"dwwm", "赝"},
	{"dwwy", "雁"},
	{"dwy", "礁"},
	{"dwyg", "碓"},
	{"dwyo", "礁"},
	{"dx", "龙"},
	{"dxa", "龚"},
	{"dxaw", "龚"},
	{"dxb", "聋"},
	{"dxbf", "聋"},
	{"dxdf", "砻"},
	{"dxf", "垄"},
	{"dxff", "垄"},
	{"dxjh", "砩"},
	{"dxv", "龙"},
	{"dxx", "砒"},
	{"dxxn", "砒"},
	{"dxy", "袭"},
	{"dxye", "袭"},
	{"dy", "太"},
	{"dybt", "礅"},
	{"dyc", "硫"},
	{"dycq", "硫"},
	{"dyi", "太 丈"},
	{"dyn", "态"},
	{"dyna", "碥"},
	{"dynt", "戍"},
	{"dynu", "态"},
	{"dyt", "矿"},
	{"dyw", "碎"},
	{"dywf", "碎"},
	{"e", "有"},
	{"ea", "肛"},
	{"eaf", "腻"},
	{"eafm", "腻"},
	{"eag", "肛"},
	{"eaiy", "胨"},
	{"eaj", "腊"},
	{"eajd", "膜"},
	{"eajg", "腊"},
	{"eb", "服"},
	{"ebbh", "郛"},
	{"ebc", "服"},
	{"ebcy", "服"},
	{"ebf", "孚 孕"},
	{"ebn", "乳"},
	{"ebnn", "乳"},
	{"ec", "肥"},
	{"ecag", "胫"},
	{"eck", "胎"},
	{"eckg", "胎"},
	{"ecl", "盈"},
	{"ecla", "戤"},
	{"eclf", "盈"},
	{"ecn", "肥"},
	{"edcy", "肱"},
	{"edf", "胯"},
	{"edfn", "胯"},
	{"edjd", "腓"},
	{"edjn", "腌"},
	{"edm", "须"},
	{"edmd", "腼"},
	{"edmy", "须"},
	{"edwd", "腠"},
	{"edxn", "胧"},
	{"edyy", "肽"},
	{"ee", "朋"},
	{"eead", "貘"},
	{"eebg", "脬"},
	{"eedj", "貊"},
	{"eee", "月"},
	{"eeee", "月"},
	{"eef", "豺"},
	{"eeft", "豺"},
	{"eeg", "朋"},
	{"eemk", "豳"},
	{"eeou", "燹"},
	{"eeq", "鹏"},
	{"eeqg", "鹏"},
	{"eeqy", "豹"},
	{"eer", "豸"},
	{"eerp", "邈"},
	{"eerq", "貌"},
	{"eet", "肜"},
	{"eetk", "貉"},
	{"eetx", "貔"},
	{"eevk", "貂"},
	{"eews", "貅"},
	{"eey", "豚"},
	{"ef", "肝"},
	{"efc", "肢"},
	{"efcb", "脚"},
	{"efcy", "肢"},
	{"efg", "肚"},
	{"efh", "肝"},
	{"efhm", "虢"},
	{"efjh", "肼"},
	{"efk", "膨"},
	{"efkc", "臌"},
	{"efke", "膨"},
	{"efmf", "腩"},
	{"efnn", "肟"},
	{"efp", "脖"},
	{"efpb", "脖"},
	{"efqn", "朊"},
	{"eftc", "爰"},
	{"efw", "肤"},
	{"efwy", "肤"},
	{"efy", "肘"},
	{"eg", "且"},
	{"egbn", "肫"},
	{"egc", "县"},
	{"egcn", "悬"},
	{"egcu", "县"},
	{"egd", "且"},
	{"ege", "脯"},
	{"egef", "膊"},
	{"egeg", "腈"},
	{"egey", "脯"},
	{"egi", "胚"},
	{"egig", "胚"},
	{"egkh", "膈"},
	{"egl", "助"},
	{"egln", "助"},
	{"egm", "肺"},
	{"egmh", "肺"},
	{"egty", "豕"},
	{"egwy", "雎"},
	{"egx", "胰"},
	{"egxw", "胰"},
	{"ehhy", "胩"},
	{"ehnn", "鼐"},
	{"ehnt", "胪"},
	{"ei", "膛"},
	{"eip", "膛"},
	{"eipf", "膛"},
	{"eiqn", "胱"},
	{"eiu", "尕"},
	{"ej", "胆"},
	{"ejg", "胆"},
	{"ejgg", "胆"},
	{"ejh", "刖"},
	{"ejhh", "胂"},
	{"ejlg", "腽"},
	{"ejt", "腥"},
	{"ejtg", "腥"},
	{"ek", "肿"},
	{"ekh", "肿"},
	{"ekhh", "肿"},
	{"ekkn", "腭"},
	{"ekks", "臊"},
	{"ekmw", "脶"},
	{"el", "肋"},
	{"eldy", "胭"},
	{"elh", "胛"},
	{"eln", "肋"},
	{"elny", "腮"},
	{"elv", "爵"},
	{"elvf", "爵"},
	{"elw", "胁"},
	{"elwy", "胁"},
	{"em", "肌"},
	{"ema", "腆"},
	{"emaw", "腆"},
	{"emc", "股"},
	{"emcy", "股"},
	{"emgk", "胴"},
	{"emn", "肌"},
	{"emq", "觅"},
	{"emqb", "觅"},
	{"emwy", "肭"},
	{"en", "甩"},
	{"eniy", "脲"},
	{"enr", "肠"},
	{"enrt", "肠"},
	{"env", "甩"},
	{"eoqh", "膦"},
	{"eoy", "脒"},
	{"epc", "受"},
	{"epcu", "受"},
	{"epd", "爱"},
	{"epdc", "爱"},
	{"epe", "脓"},
	{"epey", "脓"},
	{"epfi", "腙"},
	{"epfq", "脘"},
	{"epgh", "腚"},
	{"epi", "逐"},
	{"epq", "腕"},
	{"epqb", "腕"},
	{"epqh", "舜"},
	{"eprw", "膑"},
	{"epv", "胺"},
	{"epvg", "胺"},
	{"epw", "腔"},
	{"epwa", "腔"},
	{"eq", "胸"},
	{"eqay", "胝"},
	{"eqd", "脆"},
	{"eqdb", "脆"},
	{"eqkg", "朐"},
	{"eqn", "胞"},
	{"eqnn", "胞"},
	{"eqq", "胸"},
	{"eqqb", "胸"},
	{"eqsy", "脎"},
	{"eqwy", "肷"},
	{"er", "遥"},
	{"ercy", "胍"},
	{"eri", "腺"},
	{"eriy", "腺"},
	{"erm", "遥"},
	{"ermg", "鹞"},
	{"ermi", "繇"},
	{"ermp", "遥"},
	{"ert", "脾"},
	{"ertf", "脾"},
	{"es", "采"},
	{"ese", "彩"},
	{"eset", "彩"},
	{"esf", "膘"},
	{"esfi", "膘"},
	{"esu", "采"},
	{"esv", "腰"},
	{"esvg", "腰"},
	{"esw", "膝"},
	{"eswi", "膝"},
	{"et", "用"},
	{"eta", "胀"},
	{"etay", "胀"},
	{"etg", "胜"},
	{"etgg", "胜"},
	{"ethf", "胙"},
	{"etj", "腹"},
	{"etjt", "腹"},
	{"etk", "胳"},
	{"etkg", "胳"},
	{"etn", "乃"},
	{"etnh", "用"},
	{"ettt", "彡"},
	{"eu", "胶"},
	{"euah", "胼"},
	{"eud", "腾"},
	{"eudc", "腾"},
	{"eudf", "塍"},
	{"eudi", "滕"},
	{"eudk", "膳"},
	{"eudv", "媵"},
	{"eudy", "朕"},
	{"euf", "胖"},
	{"eufh", "胖"},
	{"euj", "臆"},
	{"eujn", "臆"},
	{"euk", "脱"},
	{"eukq", "脱"},
	{"eup", "膀"},
	{"eupk", "膪"},
	{"eupy", "膀"},
	{"euq", "胶"},
	{"euqy", "胶"},
	{"ev", "妥"},
	{"eve", "腿"},
	{"evep", "腿"},
	{"evf", "妥 舀"},
	{"evfp", "腱"},
	{"evwy", "腴"},
	{"ew", "脸"},
	{"ewet", "胗"},
	{"ewfc", "脍"},
	{"ewg", "脸"},
	{"ewgi", "脸"},
	{"ewgj", "腧"},
	{"ewwf", "脞"},
	{"ex", "脂"},
	{"exdu", "奚"},
	{"exj", "脂"},
	{"exjg", "脂"},
	{"ey", "及"},
	{"eyb", "脑"},
	{"eybh", "脑"},
	{"eyf", "脏"},
	{"eyfg", "脏"},
	{"eyi", "及"},
	{"eyj", "脐"},
	{"eyjh", "脐"},
	{"eylg", "膻"},
	{"eym", "肮"},
	{"eymn", "肮"},
	{"eyn", "肪"},
	{"eyni", "脉"},
	{"eynw", "胲"},
	{"eyuo", "臁"},
	{"eyw", "腑"},
	{"eywf", "腑"},
	{"eywy", "腋"},
	{"eyx", "臃"},
	{"eyxy", "臃"},
	{"f", "地"},
	{"fa", "载"},
	{"fad", "堪"},
	{"fadn", "堪"},
	{"faet", "霰"},
	{"faf", "霸"},
	{"fafe", "霸"},
	{"fafg", "坩"},
	{"faj", "卉"},
	{"fajv", "堰"},
	{"fak", "哉"},
	{"fakd", "哉"},
	{"fakg", "域"},
	{"fal", "载"},
	{"falk", "载"},
	{"falw", "戴"},
	{"famu", "贲"},
	{"fans", "堞"},
	{"fas", "栽"},
	{"fasi", "栽"},
	{"faw", "截"},
	{"fawk", "塔"},
	{"fawy", "截"},
	{"fay", "裁"},
	{"faye", "裁"},
	{"fb", "地"},
	{"fbh", "邗"},
	{"fbn", "地"},
	{"fc", "支"},
	{"fcb", "却"},
	{"fcbh", "却"},
	{"fcl", "动"},
	{"fclf", "盍"},
	{"fcln", "动 劫"},
	{"fcn", "翅"},
	{"fcnd", "翅"},
	{"fcp", "运"},
	{"fcpi", "运"},
	{"fcr", "魂"},
	{"fcrc", "魂"},
	{"fct", "埃"},
	{"fctd", "埃"},
	{"fcu", "去 云 支"},
	{"fd", "城"},
	{"fdf", "震"},
	{"fdfe", "震"},
	{"fdfn", "垮"},
	{"fdjd", "霏"},
	{"fdjn", "埯"},
	{"fdlb", "雳"},
	{"fdln", "坜"},
	{"fdm", "顶 需"},
	{"fdmj", "需"},
	{"fdmm", "颥"},
	{"fdmy", "顶 顸"},
	{"fdn", "城"},
	{"fdnt", "城"},
	{"fdri", "塬"},
	{"fdxn", "垅"},
	{"fe", "圾"},
	{"feef", "霾"},
	{"feeg", "堋"},
	{"fefy", "埒"},
	{"fey", "圾"},
	{"feyy", "圾"},
	{"ff", "寺"},
	{"ffc", "坛"},
	{"ffcy", "坛"},
	{"fff", "圭"},
	{"ffff", "土"},
	{"fffy", "封"},
	{"ffh", "填"},
	{"ffhg", "埴"},
	{"ffhw", "填"},
	{"ffhy", "卦"},
	{"ffi", "款"},
	{"ffiw", "款"},
	{"ffnb", "雩"},
	{"ffnn", "圬"},
	{"ffnu", "恚"},
	{"fft", "堵"},
	{"fftj", "堵"},
	{"ffu", "寺"},
	{"ffuk", "墙"},
	{"fg", "二"},
	{"fgcf", "垤"},
	{"fge", "博"},
	{"fgef", "博"},
	{"fgey", "埔"},
	{"fgfh", "圩"},
	{"fgg", "二"},
	{"fggh", "干"},
	{"fgh", "十"},
	{"fghg", "士"},
	{"fghy", "寸 雨"},
	{"fgi", "坏"},
	{"fgig", "坯"},
	{"fgiy", "坏"},
	{"fgj", "埂"},
	{"fgjg", "垣"},
	{"fgjq", "埂"},
	{"fgkh", "塥"},
	{"fgog", "垭"},
	{"fgu", "坪"},
	{"fguh", "坪"},
	{"fh", "直"},
	{"fha", "越"},
	{"fhag", "墟"},
	{"fhat", "越"},
	{"fhb", "趣"},
	{"fhbc", "趣"},
	{"fhc", "坡"},
	{"fhcy", "坡"},
	{"fheg", "趄"},
	{"fhf", "直"},
	{"fhfh", "矗"},
	{"fhfk", "赶"},
	{"fhg", "址"},
	{"fhgj", "趔"},
	{"fhh", "赴"},
	{"fhhi", "赴"},
	{"fhi", "趟"},
	{"fhik", "趟"},
	{"fhk", "亍"},
	{"fhkg", "坫"},
	{"fhl", "盐"},
	{"fhlf", "盐"},
	{"fhn", "起"},
	{"fhnh", "赳"},
	{"fhnt", "垆"},
	{"fhnv", "起"},
	{"fhq", "赵"},
	{"fhqi", "赵"},
	{"fhqv", "趋"},
	{"fhtm", "趱"},
	{"fhu", "走"},
	{"fhuw", "趑"},
	{"fhv", "超"},
	{"fhvk", "超"},
	{"fhw", "真"},
	{"fhwe", "趁"},
	{"fhwm", "颠"},
	{"fhwu", "真"},
	{"fi", "示"},
	{"fie", "霄"},
	{"fief", "霄 霪"},
	{"figh", "霈"},
	{"fii", "未"},
	{"fitv", "嫠"},
	{"fiu", "示"},
	{"fivs", "墚"},
	{"fiw", "翰"},
	{"fiwn", "翰"},
	{"fiy", "求"},
	{"fiye", "裘"},
	{"fiyi", "求"},
	{"fiyp", "逑"},
	{"fiyt", "救"},
	{"fj", "进"},
	{"fjat", "戟"},
	{"fje", "朝"},
	{"fjeg", "朝"},
	{"fjf", "埋"},
	{"fjfg", "埋"},
	{"fjfh", "韩"},
	{"fjfy", "埘"},
	{"fjg", "坦"},
	{"fjgg", "坦"},
	{"fjgh", "堤"},
	{"fjgp", "遘"},
	{"fjgq", "觏"},
	{"fjh", "刊"},
	{"fjhh", "坤"},
	{"fjj", "亓"},
	{"fjk", "井"},
	{"fjlc", "墁"},
	{"fjn", "塌"},
	{"fjng", "塌"},
	{"fjp", "进"},
	{"fjpk", "进"},
	{"fjqr", "埸"},
	{"fjt", "乾"},
	{"fjtn", "乾"},
	{"fjwf", "斡"},
	{"fk", "吉"},
	{"fkdm", "颉"},
	{"fke", "袁"},
	{"fkeu", "袁"},
	{"fkf", "吉"},
	{"fkgg", "埕"},
	{"fkh", "圳"},
	{"fkhk", "露"},
	{"fkkb", "酃"},
	{"fkmw", "埚"},
	{"fkmy", "埙"},
	{"fku", "喜"},
	{"fkuc", "鼓"},
	{"fkue", "彭"},
	{"fkuf", "鼙"},
	{"fkuh", "瞽"},
	{"fkuk", "嘉 喜"},
	{"fkun", "甏"},
	{"fkuo", "熹"},
	{"fl", "协"},
	{"flf", "雷"},
	{"flw", "协"},
	{"flwy", "协"},
	{"flyn", "塄"},
	{"fm", "南"},
	{"fmgk", "垌"},
	{"fmk", "击"},
	{"fmnn", "垲"},
	{"fms", "垛"},
	{"fmsy", "垛"},
	{"fmu", "南"},
	{"fmud", "献"},
	{"fmuf", "南"},
	{"fmy", "坝"},
	{"fmyg", "坍"},
	{"fn", "志"},
	{"fnbh", "堀"},
	{"fnh", "韦"},
	{"fnhc", "霞"},
	{"fnhk", "韦"},
	{"fnhl", "韫"},
	{"fnhp", "违"},
	{"fnhv", "韬"},
	{"fnhy", "韧"},
	{"fnih", "墀"},
	{"fnk", "霹"},
	{"fnku", "霹"},
	{"fnmd", "磬"},
	{"fnmj", "馨"},
	{"fnmm", "罄"},
	{"fnmy", "謦"},
	{"fnn", "圮 圯"},
	{"fnq", "霓"},
	{"fnqb", "霓"},
	{"fnr", "声"},
	{"fnrt", "场"},
	{"fnu", "志"},
	{"fnud", "卖"},
	{"fnuq", "觌"},
	{"fnv", "亏"},
	{"fnw", "块"},
	{"fnwy", "块"},
	{"fnxn", "坭"},
	{"fny", "专"},
	{"fnyi", "专"},
	{"fo", "赤"},
	{"fob", "郝"},
	{"fobc", "赧"},
	{"fobh", "郝"},
	{"fof", "赫"},
	{"fofj", "赭"},
	{"fofo", "赫"},
	{"fot", "赦"},
	{"fotj", "螫"},
	{"foty", "赦"},
	{"fou", "赤"},
	{"fp", "过"},
	{"fpb", "勃"},
	{"fpbf", "孛"},
	{"fpbg", "鹁"},
	{"fpbl", "勃"},
	{"fpfq", "垸"},
	{"fpg", "壹"},
	{"fpgc", "彀 觳"},
	{"fpgn", "懿"},
	{"fpgu", "壹"},
	{"fpi", "过"},
	{"fplc", "毂"},
	{"fpm", "壳"},
	{"fpmb", "壳"},
	{"fpmn", "悫"},
	{"fpo", "壶"},
	{"fpog", "壶"},
	{"fpx", "索"},
	{"fpxi", "索"},
	{"fpxn", "坨"},
	{"fq", "无"},
	{"fqay", "坻"},
	{"fqb", "元"},
	{"fqd", "顽"},
	{"fqdm", "顽"},
	{"fqkn", "鼋"},
	{"fqky", "堍"},
	{"fqn", "雹"},
	{"fqnb", "雹"},
	{"fqng", "坞"},
	{"fqp", "远"},
	{"fqpv", "远"},
	{"fqu", "均"},
	{"fqug", "均"},
	{"fqv", "无"},
	{"fqw", "坎"},
	{"fqwy", "坎"},
	{"fr", "垢"},
	{"frcy", "坂"},
	{"frg", "垢"},
	{"frgk", "垢"},
	{"frh", "圻"},
	{"frtf", "埤"},
	{"fryy", "坼"},
	{"fs", "霜"},
	{"fsfg", "堙"},
	{"fsh", "霜"},
	{"fshf", "霜"},
	{"fsk", "坷"},
	{"fskg", "坷"},
	{"fss", "霖"},
	{"fssu", "霖"},
	{"ft", "才"},
	{"ftb", "孝"},
	{"ftbf", "孝"},
	{"ftbt", "教"},
	{"fte", "才"},
	{"ftfp", "霆"},
	{"ftg", "考"},
	{"ftgn", "考"},
	{"fthp", "埏"},
	{"ftj", "者"},
	{"ftjb", "都"},
	{"ftjf", "者"},
	{"ftjn", "翥"},
	{"ftjo", "煮"},
	{"ftl", "雾"},
	{"ftlb", "雾"},
	{"ftmk", "垧"},
	{"ftnn", "圪"},
	{"ftx", "老"},
	{"ftxb", "老"},
	{"ftxf", "耋"},
	{"ftxj", "耆"},
	{"ftxn", "耄"},
	{"ftxu", "霉"},
	{"fu", "增"},
	{"fue", "丧"},
	{"fueu", "丧"},
	{"fuf", "幸"},
	{"fufj", "幸"},
	{"fug", "垃"},
	{"fuj", "境"},
	{"fujq", "境"},
	{"fuk", "培"},
	{"fukg", "培"},
	{"ful", "增"},
	{"fulj", "增"},
	{"fulk", "啬"},
	{"fum", "墒"},
	{"fumk", "墒"},
	{"fuvf", "霎"},
	{"fv", "雪"},
	{"fvey", "垠"},
	{"fvf", "雪"},
	{"fviy", "埭"},
	{"fvph", "埽"},
	{"fw", "夫"},
	{"fwf", "替"},
	{"fwfj", "替"},
	{"fwfl", "辇"},
	{"fwfp", "逵"},
	{"fwi", "夫"},
	{"fwm", "规"},
	{"fwmq", "规"},
	{"fwn", "埠"},
	{"fwnd", "堠"},
	{"fwnf", "埠"},
	{"fwwm", "赍"},
	{"fwwo", "麴"},
	{"fwy", "堆"},
	{"fwyc", "零"},
	{"fwyf", "霍"},
	{"fwyg", "堆"},
	{"fwyn", "埝"},
	{"fxgu", "坶"},
	{"fxln", "坳"},
	{"fy", "坟"},
	{"fyb", "墩"},
	{"fybh", "垴"},
	{"fybt", "墩"},
	{"fyjj", "霁"},
	{"fyjn", "霭"},
	{"fyk", "壤"},
	{"fyke", "壤"},
	{"fym", "坑"},
	{"fymn", "坑"},
	{"fyn", "坊"},
	{"fynw", "垓"},
	{"fyp", "壕"},
	{"fype", "壕"},
	{"fyt", "圹"},
	{"fyu", "雯"},
	{"fyv", "塘"},
	{"fyvh", "墉"},
	{"fyvk", "塘"},
	{"fyy", "坟"},
	{"g", "一"},
	{"ga", "开"},
	{"gab", "邢"},
	{"gabh", "邢"},
	{"gadw", "琪"},
	{"gae", "形"},
	{"gaet", "形"},
	{"gah", "武"},
	{"gahb", "琊"},
	{"gahd", "武"},
	{"gahg", "鹉"},
	{"gaj", "弄"},
	{"gajf", "型"},
	{"gajh", "刑"},
	{"gak", "开"},
	{"gakg", "瑾"},
	{"gamd", "瑛"},
	{"gamw", "璜"},
	{"gawy", "珙"},
	{"gb", "屯"},
	{"gbg", "珥"},
	{"gbn", "屯"},
	{"gbnm", "顿"},
	{"gbnv", "屯"},
	{"gc", "到"},
	{"gcf", "至"},
	{"gcfb", "郅"},
	{"gcff", "至"},
	{"gcfj", "到"},
	{"gcft", "臻 致"},
	{"gcg", "玛"},
	{"gd", "天"},
	{"gde", "瑚"},
	{"gdeg", "瑚"},
	{"gdi", "天"},
	{"gdj", "蚕"},
	{"gdju", "蚕"},
	{"gdk", "吞"},
	{"gdkf", "吞"},
	{"gdmb", "郗"},
	{"gdmy", "顼"},
	{"gdnu", "忝"},
	{"gdsk", "琦"},
	{"gdxn", "珑"},
	{"ge", "表"},
	{"gef", "青"},
	{"gefc", "瑗"},
	{"geh", "甫"},
	{"gehp", "逋"},
	{"geht", "敷"},
	{"gehy", "甫"},
	{"gemq", "靓"},
	{"gepc", "瑷"},
	{"geph", "靛"},
	{"geq", "静"},
	{"geqh", "静"},
	{"ger", "瑶"},
	{"germ", "瑶"},
	{"geu", "表"},
	{"gey", "琢"},
	{"geyy", "琢"},
	{"gf", "于"},
	{"gfc", "珐"},
	{"gfcy", "珐"},
	{"gfi", "球"},
	{"gfiy", "球"},
	{"gfk", "于"},
	{"gfl", "盂"},
	{"gflf", "盂"},
	{"gfnh", "玮"},
	{"gfp", "迂"},
	{"gfpk", "迂"},
	{"gfq", "玩"},
	{"gfqn", "玩"},
	{"gg", "五"},
	{"ggc", "琶"},
	{"ggcb", "琶"},
	{"ggg", "王"},
	{"gggg", "王"},
	{"gggt", "戋"},
	{"ggh", "五"},
	{"gghg", "五"},
	{"ggi", "环"},
	{"ggiy", "环"},
	{"ggl", "一"},
	{"ggll", "一"},
	{"ggn", "瑟"},
	{"ggnt", "瑟"},
	{"ggw", "琴"},
	{"ggwn", "琴"},
	{"ggx", "琵"},
	{"ggxx", "琵"},
	{"ggyy", "珏"},
	{"ghae", "璩"},
	{"gham", "琥"},
	{"ghc", "玻"},
	{"ghcy", "玻"},
	{"ghd", "正"},
	{"ghg", "焉"},
	{"ghgb", "鄢"},
	{"ghgo", "焉"},
	{"ghi", "下"},
	{"ghkg", "玷"},
	{"ghnu", "忑"},
	{"ghnv", "丐"},
	{"ghqo", "璨"},
	{"ght", "政"},
	{"ghty", "政"},
	{"gi", "不"},
	{"gie", "甭"},
	{"giej", "甭"},
	{"gig", "歪"},
	{"gigb", "邳"},
	{"gigf", "丕"},
	{"gigh", "歪"},
	{"gii", "不"},
	{"gik", "否"},
	{"gikf", "否"},
	{"gim", "琐"},
	{"gimy", "琐"},
	{"gip", "还"},
	{"gipi", "还"},
	{"giqn", "珧"},
	{"givb", "孬"},
	{"gj", "理"},
	{"gjf", "理"},
	{"gjff", "墼"},
	{"gjfg", "理"},
	{"gjfk", "軎"},
	{"gjgf", "亘"},
	{"gjgh", "芈"},
	{"gjh", "惠"},
	{"gjhg", "瑁"},
	{"gjhn", "惠"},
	{"gjk", "丌"},
	{"gjq", "更"},
	{"gjqi", "更"},
	{"gjxx", "琨"},
	{"gk", "事"},
	{"gkf", "吾"},
	{"gkh", "囊"},
	{"gkhe", "囊"},
	{"gkhj", "蠹"},
	{"gkhk", "璐"},
	{"gkhs", "橐"},
	{"gki", "束"},
	{"gkih", "整"},
	{"gkii", "束"},
	{"gkij", "剌"},
	{"gkim", "赖"},
	{"gkip", "速"},
	{"gkit", "敕"},
	{"gkk", "卅"},
	{"gkkk", "噩"},
	{"gkl", "副"},
	{"gklj", "副"},
	{"gklp", "逼"},
	{"gkm", "融"},
	{"gkmh", "鬲"},
	{"gkmj", "融"},
	{"gkmn", "翮"},
	{"gkp", "带"},
	{"gkph", "带"},
	{"gkq", "吏"},
	{"gkqi", "吏"},
	{"gku", "豆"},
	{"gkua", "豇"},
	{"gkub", "豌"},
	{"gkuc", "豉"},
	{"gkuf", "豆"},
	{"gkup", "逗"},
	{"gkv", "事"},
	{"gkvh", "事"},
	{"gl", "画"},
	{"glb", "画"},
	{"glbj", "画"},
	{"glf", "盏"},
	{"gli", "柬"},
	{"glii", "柬"},
	{"glkg", "珈"},
	{"glpy", "琏"},
	{"gm", "现"},
	{"gma", "曹"},
	{"gmaj", "曹"},
	{"gmap", "遭"},
	{"gmd", "瑞"},
	{"gmdj", "瑞"},
	{"gmf", "再"},
	{"gmfd", "再"},
	{"gmi", "刺"},
	{"gmii", "棘"},
	{"gmij", "刺"},
	{"gmiu", "枣"},
	{"gmm", "珊"},
	{"gmmg", "珊"},
	{"gmmv", "璎"},
	{"gmn", "玑"},
	{"gmq", "现"},
	{"gmqn", "现"},
	{"gmu", "责"},
	{"gmw", "丙"},
	{"gmwb", "邴"},
	{"gmwi", "丙"},
	{"gmww", "两"},
	{"gmwy", "璀"},
	{"gmy", "丽"},
	{"gmyb", "郦"},
	{"gmyg", "鹂"},
	{"gmyp", "逦"},
	{"gmyy", "丽"},
	{"gn", "与"},
	{"gnan", "珉"},
	{"gndg", "琚"},
	{"gng", "与"},
	{"gngd", "与"},
	{"gngw", "欤"},
	{"gnhc", "瑕"},
	{"gny", "瓦"},
	{"gnyn", "瓦"},
	{"go", "来"},
	{"god", "严"},
	{"godr", "严"},
	{"gog", "亚"},
	{"goga", "戬"},
	{"gogd", "亚"},
	{"gogf", "垩"},
	{"gogj", "晋"},
	{"gogn", "恶"},
	{"gogy", "璞"},
	{"goi", "来 灭"},
	{"gomu", "赉"},
	{"gooy", "琰"},
	{"gpfi", "琮"},
	{"gplh", "珲"},
	{"gpqb", "琬"},
	{"gpws", "琛"},
	{"gq", "列"},
	{"gqbg", "殛"},
	{"gqc", "殆"},
	{"gqck", "殆"},
	{"gqeb", "殍"},
	{"gqeg", "殂"},
	{"gqf", "殖"},
	{"gqfh", "殖"},
	{"gqfu", "殪"},
	{"gqfw", "麸"},
	{"gqg", "残"},
	{"gqgt", "残"},
	{"gqi", "歹"},
	{"gqj", "列"},
	{"gqje", "裂"},
	{"gqjh", "列"},
	{"gqji", "虺"},
	{"gqjo", "烈"},
	{"gqkm", "殒"},
	{"gqm", "殃"},
	{"gqmc", "殁"},
	{"gqmd", "殃"},
	{"gqpw", "殡"},
	{"gqq", "殉"},
	{"gqqj", "殉"},
	{"gqr", "殊"},
	{"gqri", "殊"},
	{"gqt", "歼"},
	{"gqtb", "聱"},
	{"gqtc", "骜"},
	{"gqtd", "獒"},
	{"gqtf", "歼"},
	{"gqtg", "鳌"},
	{"gqtj", "螯"},
	{"gqtm", "赘"},
	{"gqto", "熬"},
	{"gqtp", "遨"},
	{"gqtq", "鏊"},
	{"gqtr", "殇"},
	{"gqty", "敖"},
	{"gquf", "殚"},
	{"gqv", "兀"},
	{"gqwe", "殄 餮"},
	{"gqwi", "殓"},
	{"gqx", "死"},
	{"gqxb", "死"},
	{"gqy", "玖"},
	{"gqyy", "玖"},
	{"gr", "珠"},
	{"grd", "碧"},
	{"grdf", "碧"},
	{"grg", "珀"},
	{"gri", "珠"},
	{"griy", "珠"},
	{"grq", "瑰"},
	{"grqc", "瑰"},
	{"gs", "末"},
	{"gsh", "玎"},
	{"gsi", "末"},
	{"gskg", "珂"},
	{"gss", "琳"},
	{"gssy", "琳"},
	{"gt", "玫"},
	{"gtfh", "珩"},
	{"gtfm", "瓒"},
	{"gtkg", "珞"},
	{"gtln", "璁"},
	{"gtu", "麦"},
	{"gty", "玫"},
	{"gu", "平"},
	{"guh", "平"},
	{"guhk", "平"},
	{"gujh", "璋"},
	{"guw", "夹"},
	{"guwb", "郏"},
	{"guwi", "夹"},
	{"guwm", "颊"},
	{"gv", "妻"},
	{"gvh", "妻"},
	{"gvhv", "妻"},
	{"gvtq", "瑙"},
	{"gw", "珍"},
	{"gway", "玳"},
	{"gwe", "珍"},
	{"gwet", "珍"},
	{"gwgj", "瑜"},
	{"gwvn", "玢"},
	{"gwy", "玲"},
	{"gwyc", "玲"},
	{"gx", "互"},
	{"gxfi", "纛"},
	{"gxg", "互"},
	{"gxgd", "互"},
	{"gxgu", "毒"},
	{"gxi", "素"},
	{"gxiu", "素"},
	{"gxw", "夷"},
	{"gxwi", "夷"},
	{"gy", "玉"},
	{"gyb", "璃"},
	{"gybc", "璃"},
	{"gyc", "琉"},
	{"gycq", "琉"},
	{"gyg", "斑"},
	{"gygg", "斑"},
	{"gyi", "玉"},
	{"gyiy", "琼"},
	{"gyt", "班"},
	{"gytg", "班"},
	{"gyth", "璇"},
	{"gyv", "琅"},
	{"gyve", "琅"},
	{"gyvk", "瑭"},
	{"gyy", "玟"},
	{"h", "上"},
	{"ha", "虎"},
	{"haa", "虐"},
	{"haag", "虐"},
	{"haep", "遽"},
	{"hag", "眶"},
	{"hagg", "眶"},
	{"hagw", "瞒"},
	{"hak", "虞"},
	{"hakd", "虞"},
	{"hal", "瞄"},
	{"halg", "瞄"},
	{"halv", "虏"},
	{"ham", "虎"},
	{"hame", "彪"},
	{"hamv", "虎"},
	{"han", "虑"},
	{"hani", "虑"},
	{"hao", "虚"},
	{"haog", "虚"},
	{"haoq", "觑"},
	{"haqy", "眍"},
	{"hav", "虍"},
	{"hayi", "虔"},
	{"hc", "皮"},
	{"hcd", "颇"},
	{"hcdm", "颇"},
	{"hci", "皮"},
	{"hckg", "眙"},
	{"hcrh", "眸"},
	{"hcu", "攴"},
	{"hcwt", "睃"},
	{"hdff", "睚"},
	{"he", "肯"},
	{"hef", "肯"},
	{"hep", "瞬"},
	{"heph", "瞬"},
	{"hes", "睬"},
	{"hesy", "睬"},
	{"hf", "睦"},
	{"hfc", "歧"},
	{"hfcl", "瞌"},
	{"hfcy", "歧"},
	{"hffg", "眭"},
	{"hft", "睹"},
	{"hftj", "睹"},
	{"hfw", "睦"},
	{"hfwf", "睦"},
	{"hg", "睛"},
	{"hgbn", "盹"},
	{"hge", "睛"},
	{"hgeg", "睛"},
	{"hgfh", "盱"},
	{"hghn", "眄"},
	{"hgm", "凸"},
	{"hgmg", "凸"},
	{"hgoy", "睐"},
	{"hgv", "睫"},
	{"hgvh", "睫"},
	{"hh", "止"},
	{"hhg", "上"},
	{"hhgg", "上"},
	{"hhh", "止"},
	{"hhhg", "止"},
	{"hhhh", "目"},
	{"hhll", "丨"},
	{"hhu", "卡"},
	{"hhwc", "矍"},
	{"hhwn", "氍"},
	{"hhwy", "瞿"},
	{"hhxn", "眦"},
	{"hhy", "卜"},
	{"hi", "步"},
	{"hic", "叔"},
	{"hich", "督"},
	{"hicy", "叔"},
	{"hid", "频"},
	{"hidf", "颦"},
	{"hidm", "频"},
	{"hipf", "瞠"},
	{"hiq", "眺"},
	{"hiqn", "眺"},
	{"hir", "步"},
	{"hitt", "眇"},
	{"hj", "旧"},
	{"hjg", "旧"},
	{"hjj", "卓"},
	{"hjs", "桌"},
	{"hjsu", "桌"},
	{"hk", "占"},
	{"hka", "战"},
	{"hkat", "战"},
	{"hkf", "占"},
	{"hkmq", "觇"},
	{"hknn", "乩"},
	{"hko", "点"},
	{"hkou", "点"},
	{"hl", "卤"},
	{"hlnf", "卣"},
	{"hlq", "卤"},
	{"hlqa", "鹾"},
	{"hlqi", "卤"},
	{"hm", "贞"},
	{"hmu", "贞"},
	{"hn", "卢"},
	{"hna", "眠"},
	{"hnan", "眠"},
	{"hnbt", "瞰"},
	{"hnd", "鼎"},
	{"hndm", "颅"},
	{"hndn", "鼎"},
	{"hne", "卢"},
	{"hnqg", "鸬"},
	{"hnt", "瞩"},
	{"hnty", "瞩"},
	{"hnu", "忐"},
	{"ho", "眯"},
	{"hoqh", "瞵"},
	{"hoy", "眯"},
	{"hp", "瞎"},
	{"hpd", "瞎"},
	{"hpdk", "瞎"},
	{"hpgf", "壑"},
	{"hpgh", "睿"},
	{"hpju", "瞑"},
	{"hpqn", "眈"},
	{"hq", "餐"},
	{"hqc", "餐"},
	{"hqce", "餐"},
	{"hqco", "粲"},
	{"hqd", "瞻"},
	{"hqdy", "瞻"},
	{"hqqy", "眵"},
	{"hqv", "睁"},
	{"hqvh", "睁"},
	{"hrtf", "睥"},
	{"hs", "盯"},
	{"hsfi", "瞟"},
	{"hsh", "盯"},
	{"ht", "睡"},
	{"htg", "睡"},
	{"htgf", "睡"},
	{"hto", "瞅"},
	{"htoy", "瞅"},
	{"htp", "眨"},
	{"htpy", "眨"},
	{"hu", "瞳"},
	{"huj", "瞳"},
	{"hujf", "瞳"},
	{"huxt", "睇"},
	{"hv", "眼"},
	{"hve", "眼"},
	{"hvey", "眼"},
	{"hvhc", "瞍"},
	{"hvqn", "睨"},
	{"hw", "具"},
	{"hwb", "齿"},
	{"hwbc", "龄"},
	{"hwbe", "龈"},
	{"hwbf", "龌"},
	{"hwbg", "龃"},
	{"hwbh", "龊"},
	{"hwbj", "齿"},
	{"hwbk", "龆 龉"},
	{"hwbn", "龅"},
	{"hwbx", "龀 龇"},
	{"hwby", "龋"},
	{"hwg", "瞪"},
	{"hwgd", "睽"},
	{"hwgi", "睑"},
	{"hwgu", "瞪"},
	{"hwu", "具"},
	{"hwv", "盼"},
	{"hwvn", "盼"},
	{"hwy", "瞧"},
	{"hwyg", "睢"},
	{"hwyo", "瞧"},
	{"hx", "此"},
	{"hxdf", "砦"},
	{"hxf", "些"},
	{"hxff", "些"},
	{"hxmu", "赀"},
	{"hxn", "此"},
	{"hxqe", "觜"},
	{"hxs", "柴"},
	{"hxsu", "柴"},
	{"hxw", "雌"},
	{"hxwy", "雌"},
	{"hxx", "紫"},
	{"hxxi", "紫"},
	{"hxyf", "訾"},
	{"hy", "眩"},
	{"hyx", "眩"},
	{"hyxy", "眩"},
	{"i", "不"},
	{"ia", "江"},
	{"iad", "湛"},
	{"iada", "漭"},
	{"iadn", "湛"},
	{"iadr", "澌"},
	{"iadw", "淇"},
	{"iafg", "泔"},
	{"iag", "江"},
	{"iagn", "懑"},
	{"iagw", "满"},
	{"iaj", "漠"},
	{"iajd", "漠"},
	{"iak", "灌"},
	{"iaky", "灌"},
	{"iamw", "潢"},
	{"ian", "汇"},
	{"iann", "泄"},
	{"ians", "渠 渫"},
	{"iap", "涝"},
	{"iapi", "潆"},
	{"iapl", "涝"},
	{"iapy", "滢"},
	{"iaq", "沤"},
	{"iaqg", "鸿"},
	{"iaqy", "沤"},
	{"ias", "柒"},
	{"iasu", "柒"},
	{"iat", "浇"},
	{"iatq", "浇"},
	{"iav", "沏"},
	{"iavj", "潇"},
	{"iavn", "沏"},
	{"iaw", "洪"},
	{"iawn", "港"},
	{"iawy", "洪"},
	{"ib", "池"},
	{"ibcc", "滠"},
	{"ibg", "洱"},
	{"ibi", "涵"},
	{"ibib", "涵"},
	{"ibk", "凼"},
	{"ibln", "泐"},
	{"ibn", "池"},
	{"ibw", "滁"},
	{"ibwt", "滁"},
	{"ic", "汉"},
	{"icag", "泾"},
	{"icd", "渗"},
	{"icde", "渗"},
	{"ice", "涌"},
	{"iceh", "涌"},
	{"icf", "泽"},
	{"icfh", "泽"},
	{"ick", "治"},
	{"ickg", "治"},
	{"icw", "滩"},
	{"icwt", "浚"},
	{"icwy", "滩"},
	{"icy", "汉"},
	{"icyy", "汊"},
	{"id", "尖"},
	{"ide", "湖"},
	{"ideg", "湖 洧"},
	{"idf", "涯"},
	{"idff", "涯 溽"},
	{"idg", "沽"},
	{"idhc", "滟"},
	{"idhh", "沣"},
	{"idiu", "尜"},
	{"idj", "淹"},
	{"idjn", "淹"},
	{"idl", "沥"},
	{"idln", "沥"},
	{"idmd", "湎"},
	{"idr", "源"},
	{"idri", "源"},
	{"idt", "涛"},
	{"idtf", "涛"},
	{"idu", "尖"},
	{"idui", "潦"},
	{"idwt", "溱"},
	{"idxn", "泷"},
	{"idy", "汰"},
	{"idyy", "汰"},
	{"ie", "肖"},
	{"ieb", "浮"},
	{"iebg", "浮"},
	{"iecn", "淝"},
	{"ief", "肖"},
	{"ieg", "沮"},
	{"iegg", "沮"},
	{"iej", "削"},
	{"iejh", "削"},
	{"iepd", "逍"},
	{"iet", "淫"},
	{"ietf", "淫"},
	{"iev", "滔"},
	{"ievg", "滔"},
	{"iex", "溪"},
	{"iexd", "溪"},
	{"iey", "汲"},
	{"ieyy", "汲 涿"},
	{"if", "法"},
	{"ifae", "灞"},
	{"ifc", "法"},
	{"ifcl", "溘"},
	{"ifcy", "法"},
	{"ifdj", "濡"},
	{"iff", "尘"},
	{"iffg", "洼"},
	{"ifh", "汗 汁"},
	{"ifhw", "滇"},
	{"ifj", "潮"},
	{"ifje", "潮"},
	{"ifjn", "瀚"},
	{"ifk", "洁"},
	{"ifke", "澎"},
	{"ifkf", "澍"},
	{"ifkg", "洁"},
	{"ifn", "污"},
	{"ifnd", "渎"},
	{"ifnn", "污"},
	{"ifp", "渤"},
	{"ifpl", "渤"},
	{"ifqn", "沅"},
	{"iftj", "渚"},
	{"ifw", "潜"},
	{"ifwj", "潜"},
	{"ig", "汪"},
	{"igbn", "沌"},
	{"igd", "添"},
	{"igdn", "添"},
	{"ige", "清"},
	{"igef", "溥"},
	{"igeg", "清"},
	{"igey", "浦"},
	{"igg", "汪"},
	{"ighn", "沔"},
	{"igjg", "洹"},
	{"igk", "滞"},
	{"igkg", "浯"},
	{"igkh", "滞"},
	{"igki", "涑"},
	{"igkm", "濑"},
	{"igkw", "漱"},
	{"igm", "渍"},
	{"igmh", "沛"},
	{"igmj", "漕"},
	{"igmy", "渍"},
	{"igoy", "涞"},
	{"igqj", "洌"},
	{"igs", "沫"},
	{"igsy", "沫"},
	{"igt", "浅"},
	{"iguw", "浃"},
	{"ih", "小"},
	{"iha", "滤"},
	{"ihah", "滹"},
	{"ihan", "滤"},
	{"ihc", "波"},
	{"ihcv", "婆"},
	{"ihcy", "波"},
	{"ihg", "泪"},
	{"ihi", "涉"},
	{"ihic", "淑"},
	{"ihim", "濒"},
	{"ihit", "渺 涉"},
	{"ihj", "淖"},
	{"ihjh", "淖"},
	{"ihk", "沾"},
	{"ihkg", "沾"},
	{"ihmy", "浈"},
	{"ihnt", "泸"},
	{"ihqg", "瀣"},
	{"iht", "小"},
	{"ihty", "小"},
	{"ihwy", "濉"},
	{"ii", "水"},
	{"iie", "消"},
	{"iieg", "消"},
	{"iii", "水"},
	{"iiii", "水"},
	{"iiiu", "淼"},
	{"iim", "淌"},
	{"iimk", "淌"},
	{"iiqn", "洮"},
	{"iit", "沙"},
	{"iite", "裟"},
	{"iitp", "沙"},
	{"iitr", "挲"},
	{"iitv", "娑"},
	{"ij", "浊"},
	{"ija", "瀑"},
	{"ijai", "瀑"},
	{"ijf", "沓"},
	{"ijfg", "涅"},
	{"ijg", "汨 汩"},
	{"ijl", "温"},
	{"ijlc", "漫"},
	{"ijlg", "温"},
	{"ijng", "溻"},
	{"ijo", "湿"},
	{"ijog", "湿"},
	{"ijq", "渴"},
	{"ijqn", "渴"},
	{"ijt", "滥"},
	{"ijtl", "滥"},
	{"ijx", "混"},
	{"ijxx", "混"},
	{"ijy", "浊"},
	{"ijym", "灏"},
	{"ik", "澡"},
	{"ikeg", "涓"},
	{"ikh", "溃"},
	{"ikhk", "潞"},
	{"ikhm", "溃"},
	{"ikhy", "浞"},
	{"ikjn", "渑"},
	{"ikk", "澡"},
	{"ikkn", "漶"},
	{"ikks", "澡"},
	{"ikm", "涡"},
	{"ikmw", "涡"},
	{"il", "渐"},
	{"ild", "涸"},
	{"ildg", "涸"},
	{"ildy", "洇"},
	{"ile", "渭"},
	{"ileg", "渭"},
	{"iley", "溷"},
	{"ilfh", "涠"},
	{"ilg", "泗"},
	{"ilgj", "淠"},
	{"ilkg", "洄"},
	{"ilp", "涟"},
	{"ilpy", "涟"},
	{"ilr", "渐"},
	{"ilrh", "渐"},
	{"ilw", "泅"},
	{"ilwy", "泅"},
	{"ilxi", "漯"},
	{"im", "没"},
	{"imau", "澧"},
	{"imc", "没"},
	{"imcy", "没"},
	{"imd", "湍"},
	{"imdj", "湍"},
	{"imdy", "泱"},
	{"ime", "滑"},
	{"imeg", "滑"},
	{"img", "油"},
	{"imgk", "洞"},
	{"imgt", "溅"},
	{"imh", "汕"},
	{"imj", "测"},
	{"imjh", "测"},
	{"imk", "沿"},
	{"imkf", "尚"},
	{"imkg", "沿"},
	{"imkn", "氅"},
	{"imkt", "敞"},
	{"imwn", "涔"},
	{"in", "沁"},
	{"inan", "泯"},
	{"inbb", "潺"},
	{"inbt", "澉"},
	{"inf", "汛"},
	{"infh", "汛"},
	{"infy", "漏"},
	{"ingf", "渥"},
	{"inhg", "湄"},
	{"inmj", "涮"},
	{"inn", "汜"},
	{"inr", "汤"},
	{"inro", "烫"},
	{"inrt", "汤"},
	{"int", "泌"},
	{"intt", "泌"},
	{"inty", "泼"},
	{"inwy", "濯"},
	{"inx", "泥"},
	{"inxn", "泥"},
	{"iny", "沁"},
	{"io", "淡"},
	{"iolw", "瀵"},
	{"ioo", "淡"},
	{"iooy", "淡"},
	{"ip", "学"},
	{"ipaw", "黉"},
	{"ipb", "学"},
	{"ipbf", "学"},
	{"ipe", "浓"},
	{"ipey", "浓"},
	{"ipf", "尝"},
	{"ipfc", "尝"},
	{"ipfi", "淙"},
	{"ipfq", "浣"},
	{"ipg", "演"},
	{"ipgg", "泻 渲"},
	{"ipgh", "淀"},
	{"ipgw", "演"},
	{"ipiu", "泶"},
	{"ipjh", "渖"},
	{"ipju", "溟"},
	{"ipk", "党"},
	{"ipke", "裳"},
	{"ipkf", "堂"},
	{"ipkh", "常"},
	{"ipkm", "赏"},
	{"ipkq", "党"},
	{"ipkr", "掌"},
	{"ipks", "棠"},
	{"ipl", "浑"},
	{"iplh", "浑"},
	{"ipm", "沉"},
	{"ipmn", "沉"},
	{"ipmq", "觉"},
	{"ipnn", "涫"},
	{"ipq", "沈"},
	{"ipqg", "鲎"},
	{"ipqn", "沈"},
	{"ipr", "滨"},
	{"iprw", "滨"},
	{"ips", "泞"},
	{"ipsh", "泞"},
	{"iptk", "喾"},
	{"ipu", "滓"},
	{"ipuh", "滓"},
	{"ipw", "深"},
	{"ipwk", "溶"},
	{"ipws", "深"},
	{"ipxn", "沱"},
	{"iq", "光"},
	{"iqb", "光"},
	{"iqbh", "汹"},
	{"iqc", "沟"},
	{"iqcy", "沟"},
	{"iqd", "淆"},
	{"iqde", "淆"},
	{"iqdh", "浠"},
	{"iqdy", "澹"},
	{"iqfc", "鼗"},
	{"iqg", "淦"},
	{"iqgg", "渔"},
	{"iqiy", "泺"},
	{"iqjg", "洵"},
	{"iqkq", "浼"},
	{"iqm", "涣"},
	{"iqmd", "涣"},
	{"iqn", "泡"},
	{"iqnn", "泡"},
	{"iqny", "耀"},
	{"iqp", "逃"},
	{"iqpl", "辉"},
	{"iqpv", "逃"},
	{"iqr", "淘"},
	{"iqrm", "淘"},
	{"iqtb", "泖"},
	{"iqtj", "潴"},
	{"iqtk", "漪"},
	{"iqv", "兆"},
	{"iqy", "汐"},
	{"iqyl", "溜"},
	{"ir", "泊"},
	{"ird", "湃"},
	{"irdf", "湃"},
	{"ire", "派"},
	{"irey", "派"},
	{"irg", "泊"},
	{"irgg", "湟"},
	{"irgw", "浜"},
	{"irh", "沂"},
	{"iriy", "洙"},
	{"irn", "汽"},
	{"irnn", "汽"},
	{"irrh", "浙"},
	{"iry", "激"},
	{"iryt", "激"},
	{"is", "洒"},
	{"isf", "漂"},
	{"isfg", "湮"},
	{"isfi", "漂"},
	{"isg", "洒"},
	{"isgg", "酒"},
	{"ish", "汀"},
	{"ishg", "湘"},
	{"isj", "潭"},
	{"isjg", "渣"},
	{"isjh", "潭"},
	{"isk", "河"},
	{"iskg", "河"},
	{"isrh", "淅"},
	{"iss", "淋"},
	{"isse", "潸"},
	{"issv", "漤"},
	{"issy", "淋 溧"},
	{"isw", "漆"},
	{"iswc", "淞"},
	{"iswi", "漆"},
	{"isy", "沐"},
	{"isyy", "沭"},
	{"it", "少"},
	{"itah", "洚"},
	{"itbn", "沲"},
	{"itd", "活"},
	{"itdg", "活"},
	{"itdq", "鋈"},
	{"itdy", "沃"},
	{"itf", "洗"},
	{"itfk", "浩"},
	{"itfq", "洗"},
	{"ith", "省"},
	{"ithd", "溴"},
	{"ithf", "省"},
	{"ithg", "洎"},
	{"ithj", "濞"},
	{"ithp", "涎"},
	{"itie", "潲"},
	{"itjg", "鲨"},
	{"itk", "洛"},
	{"itkg", "洛"},
	{"itl", "劣"},
	{"itlb", "劣"},
	{"itlg", "洫"},
	{"itm", "澳"},
	{"itmd", "澳"},
	{"itnn", "汔"},
	{"ito", "渊"},
	{"itoh", "渊"},
	{"itol", "潘"},
	{"itoy", "湫"},
	{"itp", "泛"},
	{"itpy", "泛"},
	{"itr", "少"},
	{"its", "涤"},
	{"itsy", "涤"},
	{"ittn", "滗"},
	{"itx", "海"},
	{"itxu", "海"},
	{"iu", "洋"},
	{"iub", "溯"},
	{"iube", "溯"},
	{"iuc", "滚"},
	{"iuce", "滚"},
	{"iud", "洋"},
	{"iudh", "洋"},
	{"iuej", "湔"},
	{"iufh", "泮"},
	{"iug", "泣"},
	{"iugg", "润"},
	{"iugi", "澜 漾"},
	{"iuj", "漳"},
	{"iujf", "潼"},
	{"iujg", "涧"},
	{"iujh", "漳"},
	{"iuk", "涪"},
	{"iukg", "涪"},
	{"ium", "滴"},
	{"iumd", "滴"},
	{"iupy", "滂"},
	{"iuw", "溢"},
	{"iuwl", "溢"},
	{"iux", "滋"},
	{"iuxt", "涕"},
	{"iuxx", "滋"},
	{"iv", "当"},
	{"ivc", "溉"},
	{"ivcq", "溉"},
	{"ivf", "当"},
	{"ivfh", "津"},
	{"ivfy", "浔"},
	{"ivg", "汝"},
	{"ivhc", "溲"},
	{"iviy", "渌"},
	{"ivk", "沼"},
	{"ivkg", "洳 沼"},
	{"ivl", "淄"},
	{"ivlg", "淄"},
	{"ivp", "浸"},
	{"ivpc", "浸"},
	{"ivs", "染"},
	{"ivsu", "染"},
	{"ivw", "梁"},
	{"ivwo", "粱"},
	{"ivws", "梁"},
	{"ivy", "涩"},
	{"ivyh", "涩"},
	{"iw", "兴"},
	{"iwb", "沧"},
	{"iwbn", "沧"},
	{"iwe", "脊"},
	{"iwef", "脊"},
	{"iwf", "举"},
	{"iwfc", "浍"},
	{"iwfh", "举"},
	{"iwg", "洽"},
	{"iwga", "瀹"},
	{"iwgj", "渝"},
	{"iwgk", "洽"},
	{"iwgt", "潋"},
	{"iwgu", "澄"},
	{"iwoy", "濮"},
	{"iwqu", "滏"},
	{"iwt", "涂"},
	{"iwtc", "溆"},
	{"iwty", "涂"},
	{"iwu", "兴"},
	{"iwv", "汾"},
	{"iwvl", "湓"},
	{"iwvn", "汾"},
	{"iww", "浴"},
	{"iwwk", "浴"},
	{"iwx", "沦"},
	{"iwxn", "沦"},
	{"iwy", "淮"},
	{"iwyc", "泠"},
	{"iwyf", "雀 誉"},
	{"iwyg", "淮"},
	{"ix", "涨"},
	{"ixcy", "泓"},
	{"ixj", "沸"},
	{"ixjh", "沸"},
	{"ixt", "涨"},
	{"ixty", "涨"},
	{"ixu", "溺"},
	{"ixuu", "溺"},
	{"ixw", "潍"},
	{"ixwy", "潍"},
	{"iy", "注"},
	{"iya", "渡"},
	{"iyac", "渡"},
	{"iyb", "淳"},
	{"iybc", "漓"},
	{"iybg", "淳"},
	{"iyc", "流"},
	{"iycq", "流 鎏"},
	{"iyct", "澈"},
	{"iyg", "注"},
	{"iygg", "注"},
	{"iyhy", "汴"},
	{"iyj", "济"},
	{"iyjh", "济 浏"},
	{"iylg", "澶"},
	{"iyly", "沩"},
	{"iymn", "沆"},
	{"iyn", "沪"},
	{"iyni", "泳"},
	{"iynt", "沪"},
	{"iynx", "漉"},
	{"iyny", "瀛"},
	{"iyo", "湾"},
	{"iyos", "滦"},
	{"iyox", "湾"},
	{"iype", "濠"},
	{"iyt", "洲"},
	{"iytb", "游"},
	{"iytf", "浒"},
	{"iyth", "漩 洲"},
	{"iyuo", "濂"},
	{"iyv", "浪"},
	{"iyve", "浪"},
	{"iyvk", "溏"},
	{"iyw", "液"},
	{"iywf", "淬"},
	{"iywu", "淤"},
	{"iywy", "液"},
	{"iyxy", "泫"},
	{"iyy", "汶"},
	{"iyyg", "氵"},
	{"j", "是"},
	{"ja", "虹"},
	{"jada", "蟒"},
	{"jadw", "蜞"},
	{"jafg", "蚶"},
	{"jag", "虹"},
	{"jagw", "螨"},
	{"jah", "蚜"},
	{"jaht", "蚜"},
	{"jaj", "蜡"},
	{"jajd", "蟆"},
	{"jajg", "蜡"},
	{"jakg", "蜮"},
	{"jalt", "蠛"},
	{"jamw", "蟥"},
	{"jan", "蝶"},
	{"jans", "蝶"},
	{"jape", "蠓"},
	{"japs", "蝾"},
	{"jat", "晓"},
	{"jatq", "晓 蛲"},
	{"jaw", "暴"},
	{"jawc", "蠖"},
	{"jawi", "暴"},
	{"jb", "最"},
	{"jbc", "最"},
	{"jbcu", "最"},
	{"jblg", "蜢"},
	{"jc", "紧"},
	{"jce", "肾"},
	{"jcef", "肾"},
	{"jceh", "蛹"},
	{"jcf", "坚"},
	{"jcff", "坚"},
	{"jcfg", "蛏"},
	{"jcg", "蚂"},
	{"jcm", "贤"},
	{"jcmu", "贤"},
	{"jcrh", "蛑"},
	{"jcu", "竖"},
	{"jcuf", "竖"},
	{"jcx", "紧"},
	{"jcxi", "紧"},
	{"jd", "晨"},
	{"jddn", "蛎"},
	{"jde", "蝴"},
	{"jdeg", "蝴"},
	{"jdf", "晨"},
	{"jdfe", "晨"},
	{"jdff", "蝰"},
	{"jdg", "蛄"},
	{"jdh", "蚌"},
	{"jdhh", "蚌"},
	{"jdnt", "晟"},
	{"jdri", "螈"},
	{"jdwj", "蝽"},
	{"jdwt", "螓"},
	{"jdwu", "昃"},
	{"je", "明"},
	{"jebg", "蜉"},
	{"jef", "暖"},
	{"jefc", "暖"},
	{"jeg", "明"},
	{"jegg", "蛆"},
	{"jel", "盟"},
	{"jelf", "盟"},
	{"jepc", "暧"},
	{"jf", "时"},
	{"jfc", "野"},
	{"jfcb", "野"},
	{"jfcf", "墅"},
	{"jfcu", "昙"},
	{"jfd", "里"},
	{"jfdj", "蠕"},
	{"jff", "蛙"},
	{"jffg", "蛙"},
	{"jfh", "旰"},
	{"jfi", "昧"},
	{"jfiy", "昧"},
	{"jfj", "旱"},
	{"jfke", "蟛"},
	{"jfmf", "蝻"},
	{"jft", "暑"},
	{"jftj", "暑"},
	{"jfwy", "蚨"},
	{"jfy", "时"},
	{"jg", "量"},
	{"jgcf", "蛭"},
	{"jgdu", "昊"},
	{"jge", "晴"},
	{"jgeg", "晴 蜻"},
	{"jgey", "晡"},
	{"jgf", "旦"},
	{"jgg", "旺"},
	{"jgh", "是"},
	{"jghh", "韪"},
	{"jghm", "题"},
	{"jghu", "是"},
	{"jghx", "匙"},
	{"jghy", "虾"},
	{"jgj", "量"},
	{"jgjf", "量"},
	{"jgjn", "蟪"},
	{"jgk", "晤"},
	{"jgkg", "晤"},
	{"jgkl", "蝠"},
	{"jgm", "师"},
	{"jgmh", "师"},
	{"jgmj", "螬"},
	{"jguw", "蛱"},
	{"jh", "早"},
	{"jhf", "冒"},
	{"jhh", "刂"},
	{"jhhc", "蠼"},
	{"jhk", "申"},
	{"jhln", "勖"},
	{"jhn", "早"},
	{"jhng", "曰"},
	{"jhnh", "早"},
	{"jhnr", "畅"},
	{"jhny", "虫"},
	{"ji", "晃"},
	{"jieg", "蛸"},
	{"jipf", "螳"},
	{"jiq", "晃"},
	{"jiqb", "晃 晁"},
	{"jj", "昌"},
	{"jja", "曝"},
	{"jjai", "曝"},
	{"jjf", "昌"},
	{"jjgh", "蛳"},
	{"jjj", "晶"},
	{"jjjf", "晶"},
	{"jjjj", "日"},
	{"jjq", "蝎"},
	{"jjqn", "蝎"},
	{"jjqr", "蜴"},
	{"jjsy", "蜾"},
	{"jk", "蝇"},
	{"jkgd", "蜈"},
	{"jkj", "蝇"},
	{"jkjn", "蝇"},
	{"jkm", "蜗"},
	{"jkmw", "蜗"},
	{"jl", "曙"},
	{"jlc", "曼"},
	{"jlcu", "曼"},
	{"jlf", "蛊"},
	{"jlfj", "曙"},
	{"jlgy", "蝈"},
	{"jlk", "蛔"},
	{"jlkg", "蛔"},
	{"jlx", "螺"},
	{"jlxi", "螺"},
	{"jm", "遇"},
	{"jmag", "蛐"},
	{"jmd", "映"},
	{"jmdy", "映"},
	{"jmfg", "蚺"},
	{"jmfk", "蜩"},
	{"jmg", "蚰"},
	{"jmh", "帅"},
	{"jmhh", "帅"},
	{"jmhn", "愚"},
	{"jmhp", "遇"},
	{"jmhy", "禺"},
	{"jmn", "虮"},
	{"jmqn", "蚬"},
	{"jmwy", "蚋"},
	{"jn", "电"},
	{"jnh", "暇"},
	{"jnhc", "暇"},
	{"jnn", "虬"},
	{"jnpd", "遢"},
	{"jnv", "电"},
	{"jnwy", "曜"},
	{"jnxn", "昵"},
	{"jo", "显"},
	{"jog", "显"},
	{"jogf", "显"},
	{"jou", "炅"},
	{"jovg", "蝼"},
	{"jp", "晕"},
	{"jpgg", "暄"},
	{"jpj", "螟"},
	{"jpju", "螟 暝"},
	{"jpl", "晕"},
	{"jplh", "晖"},
	{"jplj", "晕"},
	{"jpqb", "蜿"},
	{"jpvf", "晏"},
	{"jpx", "蛇"},
	{"jpxn", "蛇"},
	{"jq", "晚"},
	{"jqb", "昂"},
	{"jqbj", "昂"},
	{"jqdy", "蟾"},
	{"jqje", "蟓"},
	{"jqk", "晚"},
	{"jqko", "煦"},
	{"jqkq", "冕 晚"},
	{"jqr", "易"},
	{"jqrj", "剔"},
	{"jqrr", "易"},
	{"jqtb", "昴"},
	{"jqug", "昀"},
	{"jqw", "歇"},
	{"jqwn", "曷"},
	{"jqwp", "遏"},
	{"jqww", "歇"},
	{"jr", "蝗"},
	{"jrg", "蝗"},
	{"jrgg", "蝗 蚯"},
	{"jrh", "昕"},
	{"jri", "蛛"},
	{"jriy", "蛛"},
	{"jrtf", "蜱"},
	{"jsd", "颗"},
	{"jsdm", "颗"},
	{"jsfi", "螵"},
	{"jsg", "晒"},
	{"jsi", "果"},
	{"jskg", "蚵"},
	{"jsqq", "夥"},
	{"jsr", "晰"},
	{"jsrh", "晰 蜥"},
	{"jsu", "杲"},
	{"jt", "昨"},
	{"jtd", "蜂"},
	{"jtdg", "蛞"},
	{"jtdh", "蜂"},
	{"jtdk", "蜘"},
	{"jtfn", "蚝"},
	{"jtfp", "蜓"},
	{"jtg", "星"},
	{"jtga", "戥"},
	{"jtgf", "星"},
	{"jtgo", "曛"},
	{"jth", "昨"},
	{"jthf", "蚱 昨"},
	{"jthk", "晷"},
	{"jthn", "螅"},
	{"jthp", "蜒"},
	{"jtjh", "蜊"},
	{"jtjt", "蝮"},
	{"jtm", "晌"},
	{"jtmk", "晌"},
	{"jtnn", "虼"},
	{"jtol", "蟠"},
	{"jton", "蟋"},
	{"jtr", "蛾"},
	{"jtrt", "蛾"},
	{"jtuf", "蝌"},
	{"jtx", "晦"},
	{"jtxu", "晦"},
	{"jty", "临"},
	{"jtyj", "临"},
	{"jtyl", "监"},
	{"jtyq", "鉴 览"},
	{"ju", "暗"},
	{"judb", "蜷"},
	{"judh", "蛘"},
	{"judk", "蟮"},
	{"judn", "蜣"},
	{"juf", "昱"},
	{"jufh", "蚪"},
	{"jugt", "曦"},
	{"juj", "暗"},
	{"jujf", "蝉"},
	{"jujg", "暗"},
	{"jujh", "蟑"},
	{"juk", "蜕"},
	{"jukq", "蜕"},
	{"jupy", "螃"},
	{"juqy", "蛟"},
	{"jusg", "蝤"},
	{"jv", "归"},
	{"jvb", "旯"},
	{"jvg", "归"},
	{"jvhc", "螋"},
	{"jvk", "昭"},
	{"jvkg", "昭"},
	{"jvko", "照"},
	{"jw", "蛤"},
	{"jwcy", "蚣"},
	{"jwg", "蛤"},
	{"jwgd", "暌"},
	{"jwgj", "蝓"},
	{"jwgk", "蛤"},
	{"jwjh", "蚧"},
	{"jwty", "蜍"},
	{"jwxf", "晔"},
	{"jwyc", "蛉"},
	{"jwyk", "晗"},
	{"jwyp", "暹"},
	{"jx", "昆"},
	{"jxe", "曳"},
	{"jxhh", "蚓"},
	{"jxln", "蚴"},
	{"jxx", "昆"},
	{"jxxb", "昆"},
	{"jxxn", "蚍"},
	{"jy", "景"},
	{"jybc", "螭"},
	{"jybt", "暾"},
	{"jyg", "蛀"},
	{"jygg", "蛀"},
	{"jyi", "景"},
	{"jyie", "影"},
	{"jyim", "颢"},
	{"jyiu", "景"},
	{"jyiy", "晾"},
	{"jyjh", "蛴"},
	{"jyke", "曩"},
	{"jyna", "蝙"},
	{"jynn", "虻"},
	{"jyq", "蚁"},
	{"jyqy", "蚁"},
	{"jyt", "旷"},
	{"jytb", "蝣"},
	{"jyuo", "蠊"},
	{"jyvb", "螂"},
	{"jyvk", "螗"},
	{"jyxf", "蟀"},
	{"jyy", "蚊"},
	{"k", "中"},
	{"ka", "呀"},
	{"kad", "嘶"},
	{"kadk", "喏"},
	{"kadr", "嘶"},
	{"kafl", "嘞"},
	{"kagg", "哐"},
	{"kah", "呀"},
	{"kaht", "呀"},
	{"kaj", "噶"},
	{"kajn", "噶"},
	{"kalg", "喵"},
	{"kamh", "咂"},
	{"kann", "呓"},
	{"kans", "喋"},
	{"kapl", "唠"},
	{"kaq", "哎"},
	{"kaqy", "哎 呕"},
	{"karn", "唣"},
	{"katq", "哓"},
	{"kaw", "哄"},
	{"kawk", "嗒 嗬"},
	{"kawy", "哄"},
	{"kayk", "嚆"},
	{"kb", "啊"},
	{"kbcc", "嗫"},
	{"kbh", "叩"},
	{"kbhj", "嗤"},
	{"kbmh", "咄"},
	{"kbn", "吼"},
	{"kbnn", "吼"},
	{"kbnt", "戢"},
	{"kbs", "啊"},
	{"kbsk", "啊"},
	{"kc", "吧"},
	{"kcb", "邑"},
	{"kcc", "嗓"},
	{"kccc", "啜"},
	{"kccs", "嗓"},
	{"kcep", "嗵"},
	{"kcg", "吗"},
	{"kcn", "吧"},
	{"kcq", "吮"},
	{"kcqn", "吮"},
	{"kcrh", "哞"},
	{"kct", "唉"},
	{"kctd", "唉"},
	{"kcw", "唆"},
	{"kcwt", "唆"},
	{"kcy", "叹"},
	{"kd", "顺"},
	{"kdbn", "呃"},
	{"kdff", "喹"},
	{"kdg", "咕"},
	{"kdgt", "喊"},
	{"kdh", "嘎"},
	{"kdha", "嘎"},
	{"kdht", "嗄 嘁"},
	{"kdj", "啡"},
	{"kdjd", "啡"},
	{"kdjf", "喱"},
	{"kdln", "呖"},
	{"kdm", "顺"},
	{"kdmy", "顺"},
	{"kdoy", "咴"},
	{"kdpy", "哒"},
	{"kdui", "嘹"},
	{"kduw", "噘"},
	{"kdwh", "唪"},
	{"kdwt", "嗪"},
	{"kdx", "咙"},
	{"kdxn", "咙"},
	{"kdy", "吠"},
	{"kdyy", "呔"},
	{"ke", "吸"},
	{"keg", "咀"},
	{"kegg", "咀"},
	{"kel", "嚼"},
	{"kelf", "嚼"},
	{"kepc", "嗳"},
	{"keq", "鹃"},
	{"keqg", "鹃"},
	{"key", "吸"},
	{"keyy", "吸 啄"},
	{"kf", "叶"},
	{"kfa", "喷"},
	{"kfam", "喷"},
	{"kfc", "吱"},
	{"kfcl", "嗑"},
	{"kfcy", "吱"},
	{"kfdj", "嚅"},
	{"kff", "哇"},
	{"kffg", "哇"},
	{"kfg", "吐"},
	{"kfh", "叶"},
	{"kfhw", "嗔"},
	{"kfi", "味"},
	{"kfiy", "味"},
	{"kfj", "嘲"},
	{"kfje", "嘲"},
	{"kfk", "嘻"},
	{"kfke", "嘭"},
	{"kfkg", "咭"},
	{"kfkk", "嘻"},
	{"kfl", "鄙"},
	{"kflb", "鄙"},
	{"kfmf", "喃"},
	{"kfoy", "哧"},
	{"kfp", "噎"},
	{"kfph", "嚏"},
	{"kfpi", "嗦"},
	{"kfpu", "噎"},
	{"kfqn", "呒"},
	{"kft", "哮"},
	{"kftb", "哮"},
	{"kftj", "嗜"},
	{"kftp", "嘟"},
	{"kfwy", "呋 嚯"},
	{"kg", "呈"},
	{"kgb", "吨"},
	{"kgbh", "郢"},
	{"kgbn", "吨"},
	{"kgd", "吴"},
	{"kgdu", "吴"},
	{"kge", "哺"},
	{"kgey", "哺"},
	{"kgf", "呈"},
	{"kgfh", "吁"},
	{"kgh", "吓"},
	{"kghy", "吓"},
	{"kgi", "呸"},
	{"kgig", "呸"},
	{"kgjq", "哽"},
	{"kgk", "喇"},
	{"kgke", "囔"},
	{"kgkg", "唔"},
	{"kgkh", "嗝"},
	{"kgkj", "喇"},
	{"kgkw", "嗽"},
	{"kgmj", "嘈"},
	{"kgmy", "啧"},
	{"kgn", "号"},
	{"kgnb", "号"},
	{"kgne", "饕"},
	{"kgo", "哑"},
	{"kgog", "哑"},
	{"kgp", "逞"},
	{"kgpd", "逞"},
	{"kgqj", "咧"},
	{"kgqt", "嗷"},
	{"kgty", "唛"},
	{"kgxi", "嗉"},
	{"kgxw", "咦"},
	{"kh", "中"},
	{"kha", "距"},
	{"khae", "噱"},
	{"khag", "嘘"},
	{"khaj", "躇"},
	{"kham", "唬"},
	{"khan", "距"},
	{"khaq", "跷"},
	{"khas", "蹀"},
	{"khaw", "蹒"},
	{"khay", "躏"},
	{"khbc", "蹑"},
	{"khc", "踊"},
	{"khce", "踊"},
	{"khck", "跆"},
	{"khcs", "蹂"},
	{"khd", "跨"},
	{"khdc", "跋"},
	{"khdf", "踌 蹰"},
	{"khdg", "跖"},
	{"khdn", "跨"},
	{"khdw", "蹶"},
	{"khe", "啃"},
	{"khed", "蹊"},
	{"kheg", "啃"},
	{"khes", "踩"},
	{"khev", "蹈"},
	{"khey", "趿"},
	{"khff", "跬"},
	{"khfw", "趺"},
	{"khg", "践"},
	{"khga", "趼"},
	{"khgm", "贵"},
	{"khgp", "遣 遗"},
	{"khgt", "践"},
	{"khh", "趾"},
	{"khhc", "跛"},
	{"khhg", "趾"},
	{"khhj", "踔"},
	{"khhy", "咔"},
	{"khi", "跳"},
	{"khij", "踏"},
	{"khiq", "跳"},
	{"khj", "踢"},
	{"khjn", "蹋"},
	{"khjr", "踢"},
	{"khjs", "踝"},
	{"khk", "中"},
	{"khks", "躁"},
	{"khl", "盅"},
	{"khlf", "盅"},
	{"khlj", "躅"},
	{"khlk", "跏"},
	{"khm", "跺"},
	{"khme", "蹦"},
	{"khmg", "跚"},
	{"khmj", "踹"},
	{"khms", "跺"},
	{"khn", "忠"},
	{"khnd", "踞"},
	{"khnn", "跽"},
	{"khnu", "忠"},
	{"khoc", "躞"},
	{"khoy", "蹼"},
	{"khp", "踪"},
	{"khph", "蹿"},
	{"khpi", "踪"},
	{"khpx", "跎"},
	{"khq", "跑"},
	{"khqb", "跪"},
	{"khqi", "跞"},
	{"khqn", "跑"},
	{"khqy", "趵"},
	{"khr", "跌"},
	{"khrm", "踬"},
	{"khrw", "跌"},
	{"kht", "路"},
	{"khtd", "跃"},
	{"khtf", "踵"},
	{"khtg", "鹭"},
	{"khtk", "路 踟"},
	{"khtl", "蹯"},
	{"khtm", "躜"},
	{"khtp", "跹"},
	{"khtq", "跣"},
	{"khty", "踽"},
	{"khu", "足"},
	{"khua", "蹉"},
	{"khub", "踯"},
	{"khuf", "蹲"},
	{"khuh", "蹄"},
	{"khuj", "蹭"},
	{"khuk", "踣"},
	{"khuq", "跤"},
	{"khv", "跟"},
	{"khve", "跟"},
	{"khvn", "躐"},
	{"khvp", "踺"},
	{"khw", "趴"},
	{"khwb", "啮 跄"},
	{"khwf", "跗"},
	{"khwu", "蹬"},
	{"khwy", "趴"},
	{"khx", "嘴"},
	{"khxe", "嘴"},
	{"khxf", "跸"},
	{"khxn", "呲"},
	{"khy", "卟"},
	{"khya", "蹁"},
	{"khyc", "踱"},
	{"khye", "踉"},
	{"khyf", "躔"},
	{"khyj", "跻"},
	{"khyk", "踮"},
	{"khyn", "蹴"},
	{"ki", "吵"},
	{"kie", "哨"},
	{"kieg", "哨"},
	{"kihc", "啵"},
	{"kimy", "唢"},
	{"kiqn", "咣"},
	{"kit", "吵"},
	{"kitt", "吵"},
	{"kitu", "嗨"},
	{"kj", "虽"},
	{"kjbc", "嘬"},
	{"kjf", "哩"},
	{"kjfg", "哩"},
	{"kjh", "呻"},
	{"kjhh", "呻"},
	{"kjj", "唱"},
	{"kjjg", "唱"},
	{"kjmy", "喁"},
	{"kjnb", "黾"},
	{"kjq", "喝"},
	{"kjqn", "喝"},
	{"kju", "虽"},
	{"kk", "吕"},
	{"kkc", "骂"},
	{"kkcf", "骂"},
	{"kkd", "器"},
	{"kkdk", "器 嚣"},
	{"kkdu", "哭"},
	{"kkf", "吕"},
	{"kkfb", "鄂"},
	{"kkfg", "鹗"},
	{"kkfm", "颚"},
	{"kkh", "串"},
	{"kkhk", "串"},
	{"kkhn", "患"},
	{"kkk", "品"},
	{"kkkf", "品"},
	{"kkkk", "口"},
	{"kkks", "噪"},
	{"kkln", "鼍"},
	{"kkm", "咒"},
	{"kkmb", "咒"},
	{"kl", "另"},
	{"klb", "另"},
	{"kld", "咽"},
	{"kldn", "嗯"},
	{"kldy", "咽"},
	{"kleg", "喟"},
	{"klf", "嘿"},
	{"klfo", "嘿"},
	{"klfy", "啭"},
	{"klge", "喂"},
	{"klh", "呷"},
	{"klj", "别"},
	{"kljh", "别"},
	{"klk", "咖"},
	{"klkg", "咖"},
	{"kln", "叻"},
	{"km", "员"},
	{"kma", "嗣"},
	{"kmak", "嗣"},
	{"kmb", "郧"},
	{"kmbh", "郧"},
	{"kmd", "喘"},
	{"kmdj", "喘"},
	{"kmee", "嘣"},
	{"kmfk", "啁"},
	{"kmg", "叼"},
	{"kmgg", "叼"},
	{"kmh", "吊"},
	{"kmhj", "吊"},
	{"kml", "勋"},
	{"kmln", "勋"},
	{"kmmv", "嘤"},
	{"kmn", "叽"},
	{"kmqy", "哕"},
	{"kmsy", "哚"},
	{"kmu", "员"},
	{"kmw", "呐"},
	{"kmwj", "剐"},
	{"kmwu", "呙"},
	{"kmwy", "呐"},
	{"kmy", "呗"},
	{"kn", "叫"},
	{"kngf", "喔"},
	{"knh", "叫"},
	{"knhh", "叫"},
	{"knku", "噼"},
	{"knmj", "唰"},
	{"knt", "嘱"},
	{"knty", "嘱"},
	{"knx", "呢"},
	{"knxn", "呢"},
	{"kny", "吣"},
	{"kogy", "噗"},
	{"kooy", "啖"},
	{"kovg", "喽"},
	{"koy", "咪"},
	{"kp", "喧"},
	{"kpey", "哝"},
	{"kpff", "噻"},
	{"kpg", "喧"},
	{"kpgg", "喧"},
	{"kpgh", "啶"},
	{"kpnm", "嘧"},
	{"kpsh", "咛"},
	{"kpt", "喀"},
	{"kpta", "咤"},
	{"kptk", "喀"},
	{"kpwi", "嚓"},
	{"kq", "史"},
	{"kqb", "兄"},
	{"kqdh", "唏"},
	{"kqgj", "噜"},
	{"kqi", "史"},
	{"kqm", "唤"},
	{"kqmd", "唤"},
	{"kqn", "咆"},
	{"kqng", "呜"},
	{"kqnn", "咆"},
	{"kqq", "哆"},
	{"kqqy", "哆"},
	{"kqr", "吻"},
	{"kqrm", "啕"},
	{"kqrn", "唿"},
	{"kqrt", "吻"},
	{"kqw", "吹"},
	{"kqwy", "吹"},
	{"kqy", "鸣"},
	{"kqyg", "鸣"},
	{"kr", "听"},
	{"krcy", "呱"},
	{"krdf", "嗥"},
	{"krey", "哌"},
	{"krh", "听"},
	{"krr", "啪"},
	{"krrg", "啪"},
	{"krrh", "哳"},
	{"krt", "啤"},
	{"krtf", "啤"},
	{"kru", "啦"},
	{"krug", "啦"},
	{"ks", "呆"},
	{"ksfi", "嘌"},
	{"ksg", "哂"},
	{"ksh", "叮"},
	{"ksj", "喳"},
	{"ksjg", "喳"},
	{"ksk", "呵"},
	{"kskg", "呵"},
	{"kssi", "噤"},
	{"kssy", "啉"},
	{"ksu", "呆"},
	{"kt", "呼"},
	{"kta", "噬"},
	{"ktan", "吒"},
	{"ktaw", "噬"},
	{"ktg", "唾"},
	{"ktgf", "唾"},
	{"kth", "咱"},
	{"kthd", "嗅"},
	{"kthf", "咋"},
	{"kthg", "咱"},
	{"kthh", "川"},
	{"ktk", "咯"},
	{"ktkg", "咯"},
	{"ktm", "响"},
	{"ktmd", "噢"},
	{"ktmk", "响"},
	{"ktn", "吃"},
	{"ktnn", "吃"},
	{"ktoy", "啾"},
	{"ktr", "哦"},
	{"ktrt", "哦"},
	{"ktu", "呼"},
	{"ktuh", "呼"},
	{"ktuy", "咚"},
	{"ku", "啼"},
	{"kube", "嗍"},
	{"kuda", "嗟"},
	{"kudh", "咩"},
	{"kuhh", "吖"},
	{"kujg", "喑"},
	{"kujn", "噫"},
	{"kulj", "噌"},
	{"kumd", "嘀"},
	{"kup", "啼"},
	{"kuph", "啼"},
	{"kuq", "咬"},
	{"kuqy", "咬"},
	{"kuvg", "唼"},
	{"kuwl", "嗌"},
	{"kv", "哪"},
	{"kvcb", "唧"},
	{"kvcy", "呶"},
	{"kvey", "哏"},
	{"kvf", "哪"},
	{"kvfb", "哪"},
	{"kvhc", "嗖"},
	{"kvi", "啸"},
	{"kvij", "啸"},
	{"kvn", "叨"},
	{"kw", "只"},
	{"kwb", "呛"},
	{"kwbn", "呛"},
	{"kwc", "嗡"},
	{"kwcn", "嗡"},
	{"kwf", "咐"},
	{"kwfc", "哙"},
	{"kwfk", "啥"},
	{"kwfy", "咐"},
	{"kwg", "哈"},
	{"kwgj", "喻"},
	{"kwgk", "哈"},
	{"kwgu", "噔"},
	{"kwn", "喉"},
	{"kwnd", "喉"},
	{"kwqq", "嗲"},
	{"kwsy", "咻"},
	{"kwu", "只"},
	{"kwv", "吩"},
	{"kwvn", "吩"},
	{"kwvt", "咿"},
	{"kwwf", "唑"},
	{"kwx", "哗"},
	{"kwxf", "哗"},
	{"kwy", "叭"},
	{"kwyc", "呤 噙"},
	{"kwyg", "唯"},
	{"kwyn", "吟"},
	{"kwyo", "噍"},
	{"kx", "哟"},
	{"kxey", "喙"},
	{"kxhh", "吲"},
	{"kxln", "呦"},
	{"kxn", "叱"},
	{"kxq", "哟"},
	{"kxqy", "哟"},
	{"kxxf", "哔"},
	{"kxxg", "咝"},
	{"kxxn", "吡"},
	{"kxxr", "喈"},
	{"kxy", "吆"},
	{"ky", "嘛"},
	{"kyb", "哼"},
	{"kybh", "哼"},
	{"kyce", "唷"},
	{"kydn", "唳"},
	{"kyg", "唁"},
	{"kyjh", "哜"},
	{"kyk", "嚷"},
	{"kyke", "嚷"},
	{"kym", "吭"},
	{"kymn", "吭"},
	{"kyn", "咏"},
	{"kyni", "咏"},
	{"kynw", "咳"},
	{"kyp", "嚎"},
	{"kype", "嚎"},
	{"kys", "嘛"},
	{"kyss", "嘛"},
	{"kytd", "嗾"},
	{"kyvb", "啷"},
	{"kywf", "啐"},
	{"l", "国"},
	{"laag", "轼"},
	{"lafc", "羁"},
	{"lbd", "囝"},
	{"lbnn", "辄"},
	{"lc", "轻"},
	{"lca", "轻"},
	{"lcag", "轻"},
	{"lcc", "轰"},
	{"lccc", "辍"},
	{"lccu", "轰"},
	{"ld", "因"},
	{"ldbn", "轭"},
	{"ldd", "固"},
	{"lded", "囿"},
	{"ldf", "罟"},
	{"ldg", "轱"},
	{"ldi", "因"},
	{"ldj", "罪"},
	{"ldjd", "罪"},
	{"ldjn", "罨"},
	{"ldn", "恩"},
	{"ldnu", "恩"},
	{"lds", "畸"},
	{"ldsk", "畸"},
	{"ldt", "畴"},
	{"ldtf", "畴"},
	{"ldwd", "辏"},
	{"ldy", "畎"},
	{"le", "胃"},
	{"lef", "胃"},
	{"lf", "轩"},
	{"lfc", "罢"},
	{"lfco", "罴"},
	{"lfcu", "罢"},
	{"lff", "畦"},
	{"lffg", "畦"},
	{"lfh", "轩"},
	{"lfhf", "置"},
	{"lfk", "辕"},
	{"lfke", "辕"},
	{"lfmf", "罱"},
	{"lfn", "转"},
	{"lfnh", "围"},
	{"lfny", "转"},
	{"lfo", "黑"},
	{"lfod", "默 黩"},
	{"lfoe", "黪"},
	{"lfof", "墨"},
	{"lfoi", "黥"},
	{"lfoj", "黯"},
	{"lfok", "黠"},
	{"lfol", "黝"},
	{"lfom", "黜"},
	{"lfon", "黔"},
	{"lfoq", "黟"},
	{"lfot", "黢"},
	{"lfou", "黑"},
	{"lfq", "园"},
	{"lfqv", "园"},
	{"lft", "团"},
	{"lfte", "团"},
	{"lftj", "署"},
	{"lfuf", "圉"},
	{"lg", "车"},
	{"lgb", "囤"},
	{"lgbn", "囤"},
	{"lgcf", "轾"},
	{"lge", "畏"},
	{"lged", "圊"},
	{"lgeu", "畏"},
	{"lgey", "辅 圃"},
	{"lghf", "罡"},
	{"lgiu", "罘"},
	{"lgjj", "畀"},
	{"lgk", "辐"},
	{"lgkd", "圄"},
	{"lgkl", "辐"},
	{"lgm", "辆"},
	{"lgmw", "辆"},
	{"lgn", "车"},
	{"lgnh", "车"},
	{"lgy", "国"},
	{"lgyi", "国"},
	{"lh", "四"},
	{"lhj", "罩"},
	{"lhjj", "罩"},
	{"lhn", "皿"},
	{"lhng", "皿 四 囗"},
	{"lhnh", "甲"},
	{"lhnt", "轳"},
	{"lj", "辊"},
	{"ljx", "辊"},
	{"ljxx", "辊"},
	{"lk", "加"},
	{"lkb", "辑"},
	{"lkbg", "辑"},
	{"lkc", "驾"},
	{"lkcf", "驾"},
	{"lkd", "回"},
	{"lkg", "加"},
	{"lkm", "贺"},
	{"lkmi", "圆"},
	{"lkmu", "贺"},
	{"lkpd", "迦"},
	{"lks", "架"},
	{"lksk", "哿"},
	{"lksu", "架"},
	{"lkwy", "轵"},
	{"lkye", "袈"},
	{"ll", "男"},
	{"llb", "男"},
	{"llge", "圜"},
	{"lll", "田"},
	{"llll", "田"},
	{"llln", "勰"},
	{"llvl", "嬲"},
	{"lm", "轴"},
	{"lmg", "轴"},
	{"lmun", "辋"},
	{"ln", "思"},
	{"lna", "辗"},
	{"lnae", "辗"},
	{"lnn", "轧"},
	{"lnu", "思"},
	{"lnwy", "罹"},
	{"loqh", "辚"},
	{"lp", "边"},
	{"lpdk", "辖"},
	{"lpk", "连"},
	{"lpqb", "畹"},
	{"lpv", "边"},
	{"lq", "罗"},
	{"lqiy", "轹"},
	{"lqj", "蜀"},
	{"lqju", "蜀"},
	{"lqp", "逻"},
	{"lqpi", "逻"},
	{"lqre", "囫"},
	{"lqu", "罗"},
	{"lqw", "软"},
	{"lqwy", "软"},
	{"lqy", "鸭"},
	{"lqyg", "鸭"},
	{"lr", "斩"},
	{"lrcy", "畈"},
	{"lrf", "堑"},
	{"lrff", "堑"},
	{"lrh", "斩"},
	{"lrj", "暂"},
	{"lrjf", "暂"},
	{"lrqf", "錾"},
	{"lrsu", "椠"},
	{"lrwy", "轶"},
	{"ls", "困"},
	{"lsh", "町"},
	{"lsi", "困"},
	{"lskg", "轲"},
	{"lt", "力"},
	{"ltd", "轿"},
	{"ltdj", "轿"},
	{"ltk", "略"},
	{"ltkg", "略 辂"},
	{"ltn", "力"},
	{"ltu", "图"},
	{"ltuh", "轷"},
	{"ltui", "图"},
	{"lty", "畋"},
	{"lu", "较"},
	{"lud", "圈"},
	{"ludb", "圈"},
	{"luf", "畔"},
	{"lufh", "畔"},
	{"lujf", "疃"},
	{"lulj", "罾"},
	{"luq", "较"},
	{"luqy", "较"},
	{"lv", "轨"},
	{"lvd", "囡"},
	{"lvkg", "轺"},
	{"lvlg", "辎"},
	{"lvn", "轨"},
	{"lvyy", "轫"},
	{"lw", "办"},
	{"lwet", "轸 畛"},
	{"lwg", "输"},
	{"lwgg", "辁"},
	{"lwgj", "输"},
	{"lwi", "办 囚"},
	{"lwj", "界"},
	{"lwjj", "界"},
	{"lwx", "轮"},
	{"lwxn", "轮"},
	{"lwxv", "囵"},
	{"lwyc", "囹"},
	{"lx", "累"},
	{"lxi", "累"},
	{"lxiu", "累"},
	{"lxx", "毗"},
	{"lxxn", "毗"},
	{"ly", "罚"},
	{"lyc", "辙"},
	{"lyct", "辙"},
	{"lyf", "詈"},
	{"lyj", "罚"},
	{"lyjj", "罚"},
	{"lynx", "辘"},
	{"m", "同"},
	{"ma", "曲"},
	{"mad", "曲"},
	{"madt", "贼"},
	{"maf", "嵌"},
	{"mafw", "嵌"},
	{"maht", "岈"},
	{"maiu", "岽"},
	{"maps", "嵘"},
	{"maqy", "岖"},
	{"maw", "典"},
	{"mawu", "典"},
	{"mb", "邮"},
	{"mbh", "邮"},
	{"mc", "凤"},
	{"mcb", "岜"},
	{"mcfh", "峄"},
	{"mci", "凤"},
	{"mckg", "贻"},
	{"mcu", "殳"},
	{"mcw", "峻"},
	{"mcwt", "峻"},
	{"md", "央"},
	{"mde", "贿"},
	{"mdeg", "贿"},
	{"mdf", "岩"},
	{"mdfe", "赈"},
	{"mdff", "崖"},
	{"mdfj", "岸"},
	{"mdg", "岵"},
	{"mdgt", "崴"},
	{"mdi", "央"},
	{"mdjn", "崦"},
	{"mdl", "盎"},
	{"mdlf", "盎"},
	{"mdmm", "颛"},
	{"mdmp", "遄"},
	{"mdo", "炭"},
	{"mdou", "炭"},
	{"mdq", "鸯"},
	{"mdqg", "鸯"},
	{"mds", "崎"},
	{"mdsk", "崎"},
	{"me", "骨"},
	{"med", "髓"},
	{"medg", "骷"},
	{"medp", "髓"},
	{"mee", "崩"},
	{"meef", "崩"},
	{"mef", "骨 胄"},
	{"mejs", "髁"},
	{"melj", "髑"},
	{"memc", "骰"},
	{"meov", "髅"},
	{"mepk", "髂"},
	{"mepq", "髋"},
	{"mepw", "髌"},
	{"meqg", "鹘"},
	{"meqy", "骶"},
	{"merf", "髀"},
	{"merk", "骺"},
	{"metk", "骼"},
	{"mewj", "骱"},
	{"mey", "骸"},
	{"meyu", "岌"},
	{"meyw", "骸"},
	{"mf", "财"},
	{"mfcy", "岐"},
	{"mfd", "冉"},
	{"mff", "峙"},
	{"mffy", "峙"},
	{"mfhm", "巅"},
	{"mfiy", "赇"},
	{"mfk", "周"},
	{"mfkd", "周"},
	{"mfky", "雕"},
	{"mfn", "赎"},
	{"mfnd", "赎"},
	{"mft", "财"},
	{"mftj", "赌"},
	{"mftt", "财"},
	{"mg", "同"},
	{"mga", "赋"},
	{"mgah", "赋 岍"},
	{"mgef", "赙"},
	{"mgk", "同"},
	{"mgkd", "同"},
	{"mgn", "屿"},
	{"mgng", "屿"},
	{"mgoy", "崃"},
	{"mgqi", "夙"},
	{"mgt", "贱"},
	{"mgu", "峡"},
	{"mguw", "峡"},
	{"mh", "由"},
	{"mhdf", "帱"},
	{"mhfh", "帏"},
	{"mhg", "幅"},
	{"mhgl", "幅"},
	{"mhgm", "帻"},
	{"mhhc", "帔"},
	{"mhhk", "帖"},
	{"mhhm", "帧"},
	{"mhj", "帽"},
	{"mhjc", "幔"},
	{"mhjh", "帽"},
	{"mhjq", "幌"},
	{"mhk", "巾 贴"},
	{"mhkg", "贴"},
	{"mhkw", "帜"},
	{"mhly", "帼"},
	{"mhm", "帆"},
	{"mhmy", "帆"},
	{"mhn", "冂"},
	{"mhnf", "幄"},
	{"mhng", "由"},
	{"mhny", "贝"},
	{"mhoy", "幞"},
	{"mhr", "帕"},
	{"mhrg", "帕"},
	{"mhrw", "帙"},
	{"mht", "帐"},
	{"mhtl", "幡"},
	{"mhty", "帐"},
	{"mhu", "幢"},
	{"mhuf", "幢"},
	{"mhuj", "幛"},
	{"mhwy", "帷"},
	{"mi", "峭"},
	{"mie", "峭"},
	{"mieg", "峭"},
	{"miwe", "嵴"},
	{"mj", "则"},
	{"mjh", "则"},
	{"mjq", "赐"},
	{"mjqr", "赐"},
	{"mjv", "岿"},
	{"mjvf", "岿"},
	{"mkpd", "迥"},
	{"mkqn", "贶"},
	{"ml", "崭"},
	{"mldf", "崮"},
	{"mlh", "岬"},
	{"mlnu", "崽"},
	{"mlr", "崭"},
	{"mlrj", "崭"},
	{"mm", "册"},
	{"mmg", "岫"},
	{"mmgd", "凹 册"},
	{"mmgj", "删"},
	{"mmgk", "峒"},
	{"mmgq", "兕"},
	{"mmm", "山"},
	{"mmmm", "山"},
	{"mmq", "岗"},
	{"mmqn", "岘"},
	{"mmqu", "岗 岚"},
	{"mmrg", "鹦"},
	{"mmrm", "罂"},
	{"mmv", "婴"},
	{"mmvf", "婴"},
	{"mn", "岂"},
	{"mnan", "岷"},
	{"mnb", "岂"},
	{"mnbm", "崛"},
	{"mnhg", "嵋"},
	{"mnjh", "剀"},
	{"mnm", "凯"},
	{"mnmn", "凯"},
	{"mnmq", "觊"},
	{"mnn", "屺"},
	{"mnyu", "赆"},
	{"mooy", "赕"},
	{"moqh", "嶙"},
	{"movg", "嵝"},
	{"mp", "迪"},
	{"mpd", "迪"},
	{"mpf", "崇"},
	{"mpfi", "崇"},
	{"mpg", "贮"},
	{"mpgg", "贮"},
	{"mpwa", "崆"},
	{"mq", "风"},
	{"mqb", "见"},
	{"mqc", "购"},
	{"mqcy", "购"},
	{"mqd", "赡"},
	{"mqde", "崤"},
	{"mqdy", "赡"},
	{"mqhw", "飓"},
	{"mqi", "风 冈"},
	{"mqj", "刚"},
	{"mqjg", "峋"},
	{"mqjh", "刿 刚"},
	{"mqkg", "岣"},
	{"mqoo", "飚"},
	{"mqpl", "崂"},
	{"mqq", "网"},
	{"mqqi", "网"},
	{"mqqn", "飑"},
	{"mqtb", "峁"},
	{"mqu", "岁"},
	{"mqvc", "飕"},
	{"mqvh", "峥"},
	{"mr", "贩"},
	{"mrc", "贩"},
	{"mrcy", "贩"},
	{"mrg", "凰"},
	{"mrgd", "凰"},
	{"mrqc", "嵬"},
	{"ms", "朵"},
	{"msj", "剁"},
	{"msjh", "剁"},
	{"mskf", "岢"},
	{"msu", "朵"},
	{"msvg", "崾"},
	{"mswc", "崧"},
	{"mt", "几"},
	{"mta", "账"},
	{"mtay", "账"},
	{"mtd", "峰"},
	{"mtdh", "峰"},
	{"mtdj", "峤"},
	{"mtk", "赂"},
	{"mtkg", "赂"},
	{"mtn", "几"},
	{"mtnn", "屹"},
	{"mtp", "贬"},
	{"mtpy", "贬"},
	{"mtr", "峨"},
	{"mtrt", "峨"},
	{"mtuq", "嵊"},
	{"mtv", "巍"},
	{"mtvc", "巍"},
	{"mty", "败"},
	{"mu", "赠"},
	{"muda", "嵯"},
	{"mujh", "嶂"},
	{"muk", "赔"},
	{"mukg", "赔"},
	{"mul", "赠"},
	{"mulj", "赠"},
	{"muv", "赚"},
	{"muvo", "赚"},
	{"muxx", "嵫"},
	{"muyn", "罔"},
	{"mw", "内"},
	{"mweg", "鹨"},
	{"mwf", "赊"},
	{"mwfi", "赊"},
	{"mwgj", "嵛"},
	{"mwgu", "嶝"},
	{"mwi", "内"},
	{"mww", "肉"},
	{"mwwi", "肉"},
	{"mwwk", "峪"},
	{"mwy", "崔"},
	{"mwyc", "岭"},
	{"mwyf", "崔"},
	{"mwyn", "岑"},
	{"mxth", "嶷"},
	{"my", "凡"},
	{"mybg", "崞"},
	{"myd", "丹"},
	{"mye", "彤"},
	{"myet", "彤"},
	{"myf", "赃"},
	{"myfg", "赃"},
	{"myi", "凡"},
	{"mymk", "嵩"},
	{"mynw", "赅"},
	{"n", "民"},
	{"na", "民"},
	{"nae", "展"},
	{"naei", "展"},
	{"nagw", "惬"},
	{"naj", "羿 异"},
	{"najg", "惜"},
	{"nalh", "懵"},
	{"nan", "屉"},
	{"nanv", "屉"},
	{"naqy", "怄"},
	{"nat", "懂"},
	{"natf", "懂"},
	{"natn", "愍"},
	{"nav", "民"},
	{"naw", "殿"},
	{"nawc", "殿"},
	{"nawe", "臀"},
	{"nay", "慌"},
	{"nayq", "慌"},
	{"nb", "敢"},
	{"nbbb", "孱"},
	{"nbc", "慑"},
	{"nbcc", "慑"},
	{"nbm", "屈"},
	{"nbmk", "屈"},
	{"nbsk", "屙"},
	{"nbt", "敢"},
	{"nbtn", "憨"},
	{"nbty", "敢"},
	{"nc", "怪"},
	{"ncd", "惨"},
	{"ncde", "惨"},
	{"ncf", "怪"},
	{"ncfg", "怪"},
	{"ncfh", "怿"},
	{"nckg", "怡"},
	{"ncwt", "悛"},
	{"nd", "居"},
	{"nda", "惰"},
	{"ndae", "惰"},
	{"ndd", "居"},
	{"nddy", "恹"},
	{"ndg", "怙"},
	{"ndgn", "憾"},
	{"ndj", "剧"},
	{"ndjd", "悱"},
	{"ndjh", "剧"},
	{"ndm", "怖"},
	{"ndmh", "怖"},
	{"ndn", "忧"},
	{"ndnn", "忧"},
	{"ndo", "恢"},
	{"ndoy", "恢"},
	{"nf", "导"},
	{"nfa", "愤"},
	{"nfam", "愤"},
	{"nfc", "层"},
	{"nfci", "层"},
	{"nfcl", "恸"},
	{"nfcy", "怯 忮"},
	{"nfd", "丑"},
	{"nfdj", "懦"},
	{"nff", "恃"},
	{"nffy", "恃"},
	{"nfh", "慎"},
	{"nfhw", "慎"},
	{"nfi", "慰"},
	{"nfif", "尉"},
	{"nfin", "慰"},
	{"nfio", "熨"},
	{"nfp", "迅"},
	{"nfpb", "悖"},
	{"nfpk", "迅"},
	{"nfqn", "怃"},
	{"nft", "屠"},
	{"nftj", "屠"},
	{"nfu", "导"},
	{"nfuf", "悻"},
	{"nfy", "忖"},
	{"ng", "怀"},
	{"ngc", "屋"},
	{"ngcf", "屋"},
	{"ngd", "刁"},
	{"nge", "情"},
	{"ngeg", "情"},
	{"ngh", "怔"},
	{"nghg", "怔"},
	{"ngi", "怀"},
	{"ngiy", "怀"},
	{"ngj", "恒"},
	{"ngjg", "恒"},
	{"ngk", "司"},
	{"ngkd", "司"},
	{"ngkg", "悟"},
	{"ngki", "悚"},
	{"ngkm", "懒"},
	{"nguh", "怦"},
	{"ngxi", "愫"},
	{"nh", "收"},
	{"nhd", "眉"},
	{"nhda", "戕"},
	{"nhdd", "奘"},
	{"nhde", "爿"},
	{"nhef", "胥"},
	{"nhfp", "遐"},
	{"nhi", "疋"},
	{"nhj", "蛋"},
	{"nhjh", "悼"},
	{"nhju", "蛋"},
	{"nhqg", "鹛"},
	{"nht", "收"},
	{"nhty", "收"},
	{"nhw", "惧"},
	{"nhwy", "惧"},
	{"nhy", "疏"},
	{"nhyq", "疏"},
	{"nie", "悄"},
	{"nied", "屑"},
	{"nieg", "悄"},
	{"nii", "尿"},
	{"nimk", "惝"},
	{"niq", "恍"},
	{"niqn", "恍"},
	{"nir", "犀"},
	{"nirh", "犀"},
	{"nj", "慢"},
	{"njcf", "悭"},
	{"njf", "悍"},
	{"njfg", "悝"},
	{"njfh", "悍"},
	{"njgg", "怛"},
	{"njl", "慢"},
	{"njlc", "慢"},
	{"njlg", "愠"},
	{"njq", "惕"},
	{"njqr", "惕"},
	{"njt", "惺"},
	{"njtg", "惺"},
	{"njyi", "憬"},
	{"nk", "避"},
	{"nkcn", "悒"},
	{"nkhh", "忡"},
	{"nkhm", "愦"},
	{"nkkn", "愕"},
	{"nku", "辟"},
	{"nkue", "臂 襞"},
	{"nkuf", "壁"},
	{"nkuh", "辟"},
	{"nkun", "甓"},
	{"nkup", "避"},
	{"nkuq", "鐾"},
	{"nkur", "擘"},
	{"nkus", "檗"},
	{"nkuv", "劈 嬖"},
	{"nkuy", "譬 璧"},
	{"nl", "惭"},
	{"nla", "翼"},
	{"nlaw", "翼"},
	{"nlr", "惭"},
	{"nlrh", "惭"},
	{"nlsy", "悃"},
	{"nlyn", "愣"},
	{"nm", "届"},
	{"nmd", "届"},
	{"nmdj", "惴"},
	{"nmdy", "怏"},
	{"nmfk", "惆"},
	{"nmg", "恫"},
	{"nmgk", "恫"},
	{"nmh", "刷"},
	{"nmhj", "刷"},
	{"nmjh", "恻"},
	{"nmnn", "恺"},
	{"nmun", "惘"},
	{"nn", "忆"},
	{"nnaw", "巽"},
	{"nnfg", "忸"},
	{"nng", "己"},
	{"nngn", "己 巳"},
	{"nngt", "尸"},
	{"nnh", "书"},
	{"nnhy", "书"},
	{"nnk", "局"},
	{"nnkd", "局"},
	{"nnl", "乙"},
	{"nnll", "乙"},
	{"nnn", "忆"},
	{"nnnn", "已"},
	{"nnu", "忌"},
	{"nnv", "乜"},
	{"nnw", "快"},
	{"nnwy", "快"},
	{"nnxn", "怩"},
	{"nny", "羽"},
	{"nnyg", "羽"},
	{"no", "屡"},
	{"noi", "屎"},
	{"nov", "屡"},
	{"novd", "屡"},
	{"np", "忱"},
	{"nplh", "恽"},
	{"npq", "忱"},
	{"npqb", "惋"},
	{"npqn", "忱"},
	{"nq", "懈"},
	{"nqe", "懈"},
	{"nqeh", "懈"},
	{"nqjg", "恂"},
	{"nqrn", "惚"},
	{"nr", "怕"},
	{"nrg", "怕"},
	{"nrgg", "惶"},
	{"nrh", "忻"},
	{"nrnn", "忾"},
	{"nrq", "愧"},
	{"nrqc", "愧"},
	{"nssh", "憷"},
	{"nsyy", "怵"},
	{"nt", "必"},
	{"ntay", "怅"},
	{"ntb", "悸"},
	{"ntbg", "悸"},
	{"ntc", "发"},
	{"ntcy", "发"},
	{"ntd", "恬"},
	{"ntdg", "恬"},
	{"nte", "必"},
	{"ntf", "尾"},
	{"ntfc", "屐"},
	{"ntfh", "忏 忤"},
	{"ntfn", "尾"},
	{"ntg", "性"},
	{"ntgg", "性"},
	{"nthf", "怍"},
	{"nthh", "屣"},
	{"ntj", "虱"},
	{"ntji", "虱"},
	{"ntjt", "愎"},
	{"ntk", "属"},
	{"ntkg", "恪"},
	{"ntky", "属"},
	{"ntl", "恤"},
	{"ntlg", "恤"},
	{"ntm", "懊"},
	{"ntmd", "懊"},
	{"ntov", "屦"},
	{"ntoy", "愀"},
	{"ntr", "恼"},
	{"ntrh", "恼"},
	{"ntt", "履"},
	{"nttt", "履"},
	{"ntx", "悔"},
	{"ntxu", "悔"},
	{"nty", "改"},
	{"nu", "习"},
	{"nua", "屏"},
	{"nuak", "屏"},
	{"nud", "习"},
	{"nudd", "羼"},
	{"nudu", "买"},
	{"nuf", "翌"},
	{"nui", "飞"},
	{"nuj", "惮"},
	{"nujf", "惮 憧"},
	{"nuk", "悦"},
	{"nukq", "悦"},
	{"nul", "憎"},
	{"nulj", "憎"},
	{"nuvo", "慊"},
	{"nuxt", "悌"},
	{"nuy", "悯"},
	{"nuyy", "悯"},
	{"nv", "恨"},
	{"nvc", "慨"},
	{"nvcq", "慨"},
	{"nve", "恨"},
	{"nvey", "恨"},
	{"nvkg", "怊"},
	{"nvn", "忉"},
	{"nvv", "尻"},
	{"nw", "愉"},
	{"nwbn", "怆"},
	{"nwcy", "忪"},
	{"nwe", "戮"},
	{"nwea", "戮"},
	{"nwg", "愉"},
	{"nwgj", "愉"},
	{"nwgk", "恰"},
	{"nwy", "惟"},
	{"nwya", "戳"},
	{"nwyc", "怜"},
	{"nwyf", "翟"},
	{"nwyg", "惟"},
	{"nwyo", "憔"},
	{"nx", "尼"},
	{"nxf", "惯"},
	{"nxfm", "惯"},
	{"nxjh", "怫"},
	{"nxv", "尼"},
	{"nxx", "屁"},
	{"nxxv", "屁"},
	{"ny", "心"},
	{"nyh", "惦"},
	{"nyhk", "惦"},
	{"nyhy", "忄 忭"},
	{"nyi", "尺"},
	{"nyiy", "惊"},
	{"nyj", "昼"},
	{"nyjg", "昼"},
	{"nykw", "咫"},
	{"nyn", "心"},
	{"nynn", "忙"},
	{"nyny", "心"},
	{"nyp", "迟"},
	{"nypi", "迟"},
	{"nyu", "尽"},
	{"nyuu", "尽"},
	{"nyv", "慷"},
	{"nyvh", "慵"},
	{"nyvi", "慷"},
	{"nyw", "以"},
	{"nywf", "翠 悴"},
	{"nywy", "以"},
	{"o", "为"},
	{"oa", "煤"},
	{"oaf", "煤"},
	{"oafs", "煤"},
	{"oan", "炬"},
	{"oang", "炬"},
	{"oanw", "炼"},
	{"oat", "烧"},
	{"oatq", "烧"},
	{"oaw", "烘"},
	{"oawu", "粪"},
	{"oawy", "烘"},
	{"ob", "籽"},
	{"obg", "籽"},
	{"oc", "烃"},
	{"oca", "烃"},
	{"ocag", "烃"},
	{"ocbs", "糅"},
	{"ocde", "糁"},
	{"ocn", "粑"},
	{"od", "类"},
	{"oddn", "粝"},
	{"ode", "糊"},
	{"odeg", "糊 煳"},
	{"odg", "炻"},
	{"odm", "烦"},
	{"odmy", "烦"},
	{"odu", "类"},
	{"odui", "燎"},
	{"oe", "粗"},
	{"oeg", "粗"},
	{"oegg", "粗"},
	{"oelf", "爝"},
	{"of", "灶"},
	{"ofd", "糯"},
	{"ofdj", "糯"},
	{"ofg", "灶"},
	{"ofnh", "炜"},
	{"oft", "烤"},
	{"oftn", "烤"},
	{"og", "业"},
	{"ogbh", "邺"},
	{"ogbn", "炖"},
	{"ogd", "业"},
	{"oge", "精"},
	{"ogeg", "精"},
	{"ogj", "粳"},
	{"ogjq", "粳"},
	{"ogkg", "焐"},
	{"ogm", "炳"},
	{"ogmj", "糟"},
	{"ogmw", "炳"},
	{"ogu", "凿"},
	{"ogub", "凿"},
	{"oguc", "黻"},
	{"ogui", "黹"},
	{"oguy", "黼"},
	{"oh", "粘"},
	{"ohjh", "焯"},
	{"ohk", "粘"},
	{"ohkg", "粘"},
	{"oi", "炒"},
	{"oit", "炒"},
	{"oitt", "炒"},
	{"oj", "烛"},
	{"oja", "爆"},
	{"ojai", "爆"},
	{"ojf", "焊"},
	{"ojfh", "焊"},
	{"ojlc", "熳"},
	{"ojug", "煜"},
	{"ojy", "烛"},
	{"ok", "炽"},
	{"okk", "燥"},
	{"okks", "燥"},
	{"okw", "炽"},
	{"okwy", "炽"},
	{"ol", "烟"},
	{"old", "烟"},
	{"oldy", "烟"},
	{"olge", "煨"},
	{"om", "灿"},
	{"omh", "灿 籼"},
	{"omkg", "炯"},
	{"on", "断"},
	{"onhe", "糈"},
	{"onr", "断"},
	{"onrg", "熠"},
	{"onrh", "断"},
	{"onrt", "炀"},
	{"onw", "炔"},
	{"onwy", "炔"},
	{"ony", "烬"},
	{"onyu", "烬"},
	{"oo", "炎"},
	{"oobh", "郯"},
	{"oojh", "剡"},
	{"ooo", "火"},
	{"oooo", "火"},
	{"ooou", "焱"},
	{"oou", "炎"},
	{"op", "迷"},
	{"opf", "烷"},
	{"opfi", "粽"},
	{"opfq", "烷"},
	{"opgg", "煊"},
	{"opi", "迷"},
	{"opw", "熔"},
	{"opwk", "熔"},
	{"oq", "炮"},
	{"oqab", "粼"},
	{"oqap", "遴"},
	{"oqd", "烯"},
	{"oqdh", "烯"},
	{"oqdo", "燃"},
	{"oqi", "烁"},
	{"oqiy", "烁"},
	{"oqm", "焕"},
	{"oqmd", "焕"},
	{"oqn", "炮"},
	{"oqnn", "炮"},
	{"oqv", "焰"},
	{"oqvg", "焰"},
	{"oqw", "炊"},
	{"oqwy", "炊"},
	{"oqy", "灼"},
	{"oqyl", "熘"},
	{"oqyy", "灼"},
	{"or", "煌"},
	{"org", "粕"},
	{"orgg", "煌"},
	{"os", "灯"},
	{"osg", "粞"},
	{"osh", "灯"},
	{"ot", "烽"},
	{"otd", "烽"},
	{"otdh", "烽"},
	{"otf", "糙"},
	{"otfp", "糙"},
	{"oth", "炸"},
	{"othd", "糗"},
	{"othf", "炸"},
	{"othj", "糌"},
	{"othn", "熄"},
	{"otk", "烙"},
	{"otkg", "烙"},
	{"otmd", "燠"},
	{"otol", "燔"},
	{"otuh", "烀"},
	{"oty", "敉"},
	{"ou", "料"},
	{"oudh", "烊"},
	{"ouep", "燧"},
	{"ouf", "料"},
	{"oufg", "烂"},
	{"oufh", "料"},
	{"oug", "粒"},
	{"ougo", "糕"},
	{"ouk", "焙"},
	{"oukg", "焙"},
	{"oumk", "熵"},
	{"ouny", "焖"},
	{"ouxx", "糍"},
	{"ov", "娄"},
	{"ovep", "煺"},
	{"ovf", "娄"},
	{"ovt", "数"},
	{"ovty", "数"},
	{"ow", "粉"},
	{"owbn", "炝"},
	{"owdc", "煅"},
	{"owf", "烩"},
	{"owfc", "烩"},
	{"ownd", "糇"},
	{"owv", "粉"},
	{"owvn", "粉"},
	{"owxf", "烨"},
	{"owyk", "焓"},
	{"oxkj", "糨"},
	{"oy", "米"},
	{"oygg", "炷"},
	{"oym", "炕"},
	{"oymn", "炕"},
	{"oyn", "炉"},
	{"oyna", "煸"},
	{"oynn", "煽"},
	{"oynt", "炉"},
	{"oyoc", "燮"},
	{"oyt", "米"},
	{"oyty", "米"},
	{"oyv", "粮 糖"},
	{"oyve", "粮"},
	{"oyvi", "糠"},
	{"oyvk", "糖"},
	{"oyw", "粹"},
	{"oywf", "粹"},
	{"oyxy", "炫"},
	{"oyyy", "灬"},
	{"p", "这"},
	{"pa", "宽"},
	{"pah", "宦"},
	{"pahh", "宦"},
	{"paj", "寞"},
	{"pajd", "寞"},
	{"pam", "宽"},
	{"pamq", "宽"},
	{"pb", "字"},
	{"pbf", "字"},
	{"pd", "害"},
	{"pdc", "宏"},
	{"pdcu", "宏"},
	{"pde", "寡"},
	{"pdef", "宥"},
	{"pdev", "寡"},
	{"pdf", "宕"},
	{"pdfe", "宸"},
	{"pdh", "害"},
	{"pdhj", "割"},
	{"pdhk", "害 豁"},
	{"pds", "寄"},
	{"pdsk", "寄"},
	{"pdui", "寮"},
	{"pdx", "宠"},
	{"pdxb", "宠"},
	{"pe", "家"},
	{"peg", "宜"},
	{"pegf", "宜"},
	{"pei", "农"},
	{"peu", "家"},
	{"peyu", "冢"},
	{"pf", "守"},
	{"pfi", "宗"},
	{"pfiu", "宗"},
	{"pfj", "寒"},
	{"pfjc", "骞"},
	{"pfje", "褰"},
	{"pfjf", "塞"},
	{"pfjh", "蹇"},
	{"pfjm", "赛"},
	{"pfjr", "搴"},
	{"pfjs", "寨"},
	{"pfju", "寒"},
	{"pfjy", "謇"},
	{"pfq", "完"},
	{"pfqb", "完"},
	{"pfqc", "寇"},
	{"pfqf", "冠"},
	{"pfu", "守"},
	{"pg", "定"},
	{"pgc", "室"},
	{"pgcf", "室"},
	{"pgf", "宇"},
	{"pgfj", "宇"},
	{"pgh", "定"},
	{"pghu", "定"},
	{"pgj", "宣"},
	{"pgjg", "宣"},
	{"pgk", "富"},
	{"pgkl", "富"},
	{"pgm", "寅"},
	{"pgmw", "寅"},
	{"pgn", "写"},
	{"pgng", "写"},
	{"pgy", "宝"},
	{"pgyu", "宝"},
	{"ph", "寂"},
	{"phi", "寂"},
	{"phic", "寂"},
	{"pi", "宵"},
	{"pie", "宵"},
	{"pief", "宵"},
	{"pj", "审"},
	{"pjd", "幂"},
	{"pjdh", "幂"},
	{"pjh", "审"},
	{"pjhj", "审"},
	{"pjm", "寓"},
	{"pjmy", "寓"},
	{"pjuu", "冥"},
	{"pjv", "宴"},
	{"pjvf", "宴"},
	{"pk", "宫"},
	{"pkk", "宫"},
	{"pkkf", "宫"},
	{"pl", "军"},
	{"plbh", "郓"},
	{"plge", "寰"},
	{"plhc", "皲"},
	{"plj", "军"},
	{"pm", "宙"},
	{"pmb", "冗"},
	{"pmf", "宙"},
	{"pn", "官"},
	{"pnej", "甯"},
	{"pnh", "官"},
	{"pnhi", "寐"},
	{"pnhk", "寤"},
	{"pnhn", "官"},
	{"pnhp", "逭"},
	{"pnt", "密"},
	{"pntj", "蜜"},
	{"pntm", "密"},
	{"pntr", "宓"},
	{"pnw", "寥"},
	{"pnwe", "寥"},
	{"pny", "廴"},
	{"po", "灾"},
	{"pou", "灾"},
	{"pp", "之"},
	{"ppp", "之"},
	{"pppp", "之"},
	{"pq", "宛"},
	{"pqb", "宛"},
	{"pqbb", "宛"},
	{"pqbj", "剜"},
	{"pqk", "冤"},
	{"pqky", "冤"},
	{"pqqq", "鸩"},
	{"pr", "宾"},
	{"prg", "宾"},
	{"prgw", "宾"},
	{"prh", "牢"},
	{"prhj", "牢"},
	{"prwn", "衿"},
	{"ps", "宁"},
	{"psj", "宁"},
	{"psu", "宋"},
	{"pt", "客"},
	{"pta", "宅"},
	{"ptab", "宅"},
	{"ptf", "宪"},
	{"ptfq", "宪"},
	{"ptk", "客"},
	{"ptkf", "客"},
	{"ptkm", "额"},
	{"pu", "实"},
	{"puak", "褡"},
	{"pucc", "裰"},
	{"pucy", "衩"},
	{"pud", "实"},
	{"pudf", "褥"},
	{"pudu", "实"},
	{"pue", "衫"},
	{"puet", "衫"},
	{"puf", "衬"},
	{"pufh", "褂"},
	{"pufj", "褚 襦"},
	{"pufy", "衬"},
	{"pug", "袜"},
	{"puge", "裱"},
	{"pugs", "袜"},
	{"puh", "补"},
	{"puhc", "被"},
	{"puhy", "补"},
	{"pui", "衤"},
	{"puiv", "裆"},
	{"puj", "宰"},
	{"pujg", "袒"},
	{"pujl", "褴"},
	{"pujn", "褐"},
	{"pujr", "裼"},
	{"pujs", "裸"},
	{"pukg", "裎"},
	{"pulp", "裢"},
	{"pum", "袖"},
	{"pumg", "袖"},
	{"pumw", "衲"},
	{"pund", "裾"},
	{"punr", "褶"},
	{"punw", "袂"},
	{"puov", "褛"},
	{"puq", "袍"},
	{"puqn", "袍"},
	{"purf", "裨"},
	{"purm", "褫"},
	{"pus", "襟"},
	{"pusi", "襟"},
	{"pusr", "襻"},
	{"put", "袄"},
	{"putd", "袄"},
	{"putf", "衽"},
	{"putk", "袼"},
	{"puue", "褙"},
	{"puuf", "袢"},
	{"puuj", "裥"},
	{"puv", "初"},
	{"puvc", "寝"},
	{"puve", "裉"},
	{"puvk", "裙"},
	{"puvn", "初"},
	{"puvp", "褪"},
	{"puw", "裕"},
	{"puwd", "袱"},
	{"puwi", "裣"},
	{"puwk", "袷 裕"},
	{"puws", "褓"},
	{"puxj", "襁"},
	{"puy", "裤"},
	{"puya", "褊"},
	{"puyl", "裤"},
	{"pv", "安"},
	{"pvb", "宄"},
	{"pvf", "安"},
	{"pvs", "案"},
	{"pvsu", "案"},
	{"pw", "空"},
	{"pwa", "空"},
	{"pwaf", "空"},
	{"pwan", "窍"},
	{"pwat", "穿"},
	{"pwav", "窃"},
	{"pwb", "窿"},
	{"pwbg", "窿"},
	{"pwd", "突"},
	{"pwdj", "宿"},
	{"pwdu", "突"},
	{"pwf", "罕"},
	{"pwfd", "窦"},
	{"pwfi", "察"},
	{"pwfj", "罕"},
	{"pwfq", "窥"},
	{"pwg", "窒"},
	{"pwgf", "窒"},
	{"pwgn", "窀"},
	{"pwiq", "窕"},
	{"pwjs", "窠"},
	{"pwk", "窜"},
	{"pwkh", "窜"},
	{"pwkw", "窝"},
	{"pwl", "穷"},
	{"pwlb", "穷"},
	{"pwm", "帘"},
	{"pwmh", "帘"},
	{"pwn", "窟"},
	{"pwnm", "窟"},
	{"pwov", "窭"},
	{"pwqu", "穸"},
	{"pwr", "窑"},
	{"pwrm", "窑"},
	{"pwry", "窳"},
	{"pwt", "窗"},
	{"pwtf", "窄"},
	{"pwtk", "窖"},
	{"pwtp", "窆"},
	{"pwtq", "窗"},
	{"pwu", "穴"},
	{"pwuj", "窨"},
	{"pwup", "邃"},
	{"pwv", "究"},
	{"pwvb", "究"},
	{"pwvk", "窘"},
	{"pww", "容"},
	{"pwwj", "窬"},
	{"pwwk", "容"},
	{"pwxb", "穹"},
	{"pwxl", "窈"},
	{"pwy", "鹤"},
	{"pwyg", "鹤"},
	{"px", "它"},
	{"pxb", "它"},
	{"py", "社"},
	{"pyaq", "祺"},
	{"pyb", "祁"},
	{"pybh", "祁"},
	{"pyd", "祷"},
	{"pydc", "祓"},
	{"pydd", "禊"},
	{"pydf", "祷"},
	{"pydg", "祜"},
	{"pye", "祖"},
	{"pyeg", "祖"},
	{"pyf", "社"},
	{"pyfc", "祛"},
	{"pyfg", "社"},
	{"pyfk", "禧"},
	{"pyg", "福"},
	{"pygd", "祆"},
	{"pygl", "福"},
	{"pyhg", "祉"},
	{"pyhm", "祯"},
	{"pyi", "礻"},
	{"pyiq", "祧"},
	{"pyj", "神"},
	{"pyjh", "神"},
	{"pyk", "祝"},
	{"pykq", "祝"},
	{"pykw", "祸"},
	{"pym", "视"},
	{"pymq", "视"},
	{"pyn", "冖"},
	{"pynk", "祠"},
	{"pynn", "礼 祀"},
	{"pyny", "辶"},
	{"pyqi", "祢"},
	{"pyqy", "祗"},
	{"pyr", "祈"},
	{"pyrh", "祈"},
	{"pytf", "祚"},
	{"pyu", "祥"},
	{"pyud", "祥"},
	{"pyuf", "禅"},
	{"pyuo", "禚"},
	{"pyv", "禄"},
	{"pyvi", "禄"},
	{"pyye", "禳"},
	{"pyyn", "宀"},
	{"q", "我"},
	{"qa", "氏"},
	{"qadk", "锘"},
	{"qaf", "钳"},
	{"qafg", "钳"},
	{"qahb", "铘"},
	{"qahh", "舛"},
	{"qahs", "桀"},
	{"qaj", "错"},
	{"qajd", "镆"},
	{"qajf", "昏"},
	{"qajg", "错"},
	{"qakg", "钷"},
	{"qal", "锚"},
	{"qalg", "锚"},
	{"qang", "钜"},
	{"qant", "钺"},
	{"qany", "铽"},
	{"qapl", "铹"},
	{"qatq", "铙"},
	{"qav", "氏"},
	{"qawc", "镬"},
	{"qayb", "邸"},
	{"qayg", "鸱"},
	{"qayi", "氐"},
	{"qb", "凶"},
	{"qbc", "镊"},
	{"qbcc", "镊"},
	{"qbg", "铒"},
	{"qbh", "钌"},
	{"qbhf", "眢"},
	{"qbk", "凶"},
	{"qbl", "锰"},
	{"qblg", "锰"},
	{"qbp", "迎"},
	{"qbpk", "迎"},
	{"qbq", "鸳"},
	{"qbqg", "鸳"},
	{"qbsk", "锕"},
	{"qc", "色"},
	{"qcb", "色"},
	{"qcfh", "铎"},
	{"qci", "勾"},
	{"qcn", "钯"},
	{"qcyy", "钗"},
	{"qd", "然"},
	{"qdb", "危"},
	{"qdbb", "危"},
	{"qdcb", "郄"},
	{"qdcy", "钹"},
	{"qdef", "肴"},
	{"qdeg", "铕"},
	{"qdfa", "锛"},
	{"qdg", "钴"},
	{"qdhd", "锲"},
	{"qdm", "希"},
	{"qdmh", "希 钸"},
	{"qdmw", "欷"},
	{"qdnt", "铖"},
	{"qdo", "然"},
	{"qdou", "然"},
	{"qdt", "铸"},
	{"qdtf", "铸"},
	{"qdu", "镣"},
	{"qdui", "镣"},
	{"qduw", "镢"},
	{"qdw", "詹"},
	{"qdwy", "詹"},
	{"qdyy", "钛"},
	{"qe", "角"},
	{"qefc", "锾"},
	{"qefy", "锊"},
	{"qeg", "钥"},
	{"qegi", "觫"},
	{"qegl", "锄"},
	{"qeiq", "觥"},
	{"qej", "角"},
	{"qejy", "触"},
	{"qenw", "觖"},
	{"qery", "觚"},
	{"qet", "钐"},
	{"qetr", "觞"},
	{"qeuf", "斛 觯"},
	{"qev", "解"},
	{"qevh", "解"},
	{"qevj", "蟹"},
	{"qevp", "邂"},
	{"qf", "针"},
	{"qfg", "钍"},
	{"qfh", "针"},
	{"qfhw", "镇"},
	{"qfl", "镭"},
	{"qflg", "镭"},
	{"qft", "锗"},
	{"qftj", "锗"},
	{"qftn", "铐"},
	{"qftx", "铑"},
	{"qg", "钱"},
	{"qgal", "鳓"},
	{"qgas", "鲽"},
	{"qgb", "印"},
	{"qgbc", "鲰"},
	{"qgbh", "印"},
	{"qgbn", "钝"},
	{"qgdc", "鲅"},
	{"qgdd", "鲱"},
	{"qgde", "鲔"},
	{"qgdj", "鲕"},
	{"qgdn", "鱿"},
	{"qgdw", "鳜"},
	{"qge", "铺"},
	{"qgeg", "锖"},
	{"qgem", "鳐"},
	{"qgey", "匍 铺"},
	{"qgf", "鱼"},
	{"qgff", "鲑"},
	{"qgfj", "鳍"},
	{"qgfk", "鲒"},
	{"qgfm", "鲼"},
	{"qgft", "鲮"},
	{"qgfv", "鳕"},
	{"qgge", "鲭"},
	{"qggh", "鲆"},
	{"qggq", "鲠"},
	{"qggy", "鲡"},
	{"qgh", "钙"},
	{"qghg", "钲"},
	{"qghk", "鲇"},
	{"qghn", "钙 鲈"},
	{"qgil", "盥"},
	{"qgiy", "钚"},
	{"qgj", "鲁"},
	{"qgjc", "鳗"},
	{"qgjf", "鲤 鲁 鲣 鲥"},
	{"qgjj", "鲳"},
	{"qgjn", "鳎"},
	{"qgjx", "鲲"},
	{"qgkh", "镉"},
	{"qgkl", "匐"},
	{"qgkn", "鳄"},
	{"qgl", "鳃"},
	{"qgld", "鲴"},
	{"qgli", "鳏"},
	{"qgln", "鳃"},
	{"qglp", "鲢"},
	{"qgmk", "鲷"},
	{"qgmu", "鳢"},
	{"qgnj", "鲺"},
	{"qgo", "鳞"},
	{"qgoh", "鳞"},
	{"qgoj", "鳋"},
	{"qgok", "鲐"},
	{"qgoy", "铼"},
	{"qgpq", "鲩"},
	{"qgq", "鲍"},
	{"qgqn", "鲍"},
	{"qgrg", "鳇"},
	{"qgsi", "鳔"},
	{"qgt", "钱"},
	{"qgti", "鲧"},
	{"qgto", "鳅"},
	{"qgts", "鲦"},
	{"qgtt", "鳆"},
	{"qgu", "鲜"},
	{"qgud", "鲜"},
	{"qguf", "鳟"},
	{"qguk", "鳝"},
	{"qguq", "鲛"},
	{"qguw", "铗"},
	{"qgvb", "鲫"},
	{"qgvf", "鲟"},
	{"qgvl", "鲻"},
	{"qgvq", "鲵"},
	{"qgwf", "鲋"},
	{"qgwn", "鲶"},
	{"qgy", "鲸"},
	{"qgya", "鳊"},
	{"qgyh", "鳙"},
	{"qgyi", "鲸"},
	{"qgyj", "鲚"},
	{"qgyn", "鲂"},
	{"qgyy", "钰"},
	{"qh", "外"},
	{"qhcy", "铍"},
	{"qhg", "钼"},
	{"qhk", "钻"},
	{"qhkg", "钻"},
	{"qhty", "稣"},
	{"qhy", "外 钋"},
	{"qi", "乐"},
	{"qie", "销"},
	{"qieg", "销"},
	{"qigy", "玺"},
	{"qii", "乐"},
	{"qim", "锁"},
	{"qimy", "锁"},
	{"qinr", "铴"},
	{"qipf", "镗"},
	{"qipi", "迩"},
	{"qiqn", "铫"},
	{"qit", "钞"},
	{"qitt", "钞"},
	{"qiu", "尔"},
	{"qivg", "铛"},
	{"qj", "旬"},
	{"qjbh", "郇"},
	{"qjcf", "铿"},
	{"qjd", "旬"},
	{"qje", "象"},
	{"qjeu", "象"},
	{"qjfg", "锂"},
	{"qjgf", "锝"},
	{"qjgg", "钽"},
	{"qjh", "刈 钊"},
	{"qjlc", "镘"},
	{"qjn", "龟"},
	{"qjnb", "龟"},
	{"qjq", "锡"},
	{"qjqr", "锡"},
	{"qjsy", "锞"},
	{"qjxx", "锟"},
	{"qk", "名"},
	{"qkd", "句"},
	{"qkf", "名"},
	{"qkgg", "锃"},
	{"qkh", "钏"},
	{"qkhh", "钟"},
	{"qkk", "铝"},
	{"qkkg", "铝"},
	{"qkkn", "锷"},
	{"qkln", "劬"},
	{"qkm", "锅"},
	{"qkmh", "铞"},
	{"qkmw", "锅"},
	{"qkq", "免"},
	{"qkqb", "免"},
	{"qkqg", "鸲"},
	{"qkql", "勉"},
	{"qkqp", "逸"},
	{"qkqq", "够"},
	{"qkqy", "兔"},
	{"ql", "甸"},
	{"qld", "甸"},
	{"qldg", "锢"},
	{"qldy", "铟"},
	{"qlg", "钿"},
	{"qlh", "钾"},
	{"qlny", "锶"},
	{"qlp", "链"},
	{"qlpy", "链"},
	{"qlq", "锣"},
	{"qlqj", "镯"},
	{"qlqy", "锣"},
	{"qlxi", "镙"},
	{"qm", "负"},
	{"qmdu", "奂"},
	{"qmg", "铀"},
	{"qmgk", "铜"},
	{"qmj", "铡"},
	{"qmjh", "铡"},
	{"qmk", "铅"},
	{"qmkg", "铅"},
	{"qmnn", "铠"},
	{"qmq", "钢"},
	{"qmqy", "钢"},
	{"qmu", "负"},
	{"qmw", "钠"},
	{"qmwy", "钠"},
	{"qmy", "钡"},
	{"qmyy", "钒"},
	{"qn", "包"},
	{"qna", "饶"},
	{"qnad", "馍"},
	{"qnag", "馑"},
	{"qnaq", "饶"},
	{"qnat", "馓"},
	{"qnb", "饣"},
	{"qnbg", "饵"},
	{"qnck", "饴"},
	{"qnd", "锯"},
	{"qndg", "锯"},
	{"qne", "馁"},
	{"qnev", "馁"},
	{"qnf", "钮"},
	{"qnfb", "饽"},
	{"qnfg", "钮"},
	{"qng", "乌"},
	{"qngb", "邬"},
	{"qngd", "乌"},
	{"qnge", "馕"},
	{"qngn", "饨"},
	{"qngt", "饯"},
	{"qnhg", "镅"},
	{"qnj", "蚀"},
	{"qnjc", "馒"},
	{"qnjh", "刨"},
	{"qnjx", "馄"},
	{"qnjy", "蚀"},
	{"qnk", "馈"},
	{"qnkm", "馈"},
	{"qnm", "饥"},
	{"qnmn", "饥"},
	{"qnn", "钆 钇"},
	{"qnnk", "饲 锔"},
	{"qnnr", "饧"},
	{"qnnw", "馔"},
	{"qnp", "馆"},
	{"qnpn", "馆"},
	{"qnq", "饮"},
	{"qnql", "馏"},
	{"qnqn", "饱"},
	{"qnqu", "馋"},
	{"qnqv", "馅"},
	{"qnqw", "饮"},
	{"qnr", "饭"},
	{"qnrc", "饭"},
	{"qnrn", "饩"},
	{"qnsg", "馇"},
	{"qnt", "饿"},
	{"qntd", "饫"},
	{"qntf", "饪"},
	{"qnth", "饰"},
	{"qntk", "饷"},
	{"qntl", "饬"},
	{"qntt", "饿 铋"},
	{"qnu", "饼"},
	{"qnua", "饼"},
	{"qnuf", "馐"},
	{"qnuq", "饺"},
	{"qnv", "包"},
	{"qnvc", "馊"},
	{"qnwt", "馀"},
	{"qnxn", "铌"},
	{"qo", "炙"},
	{"qobx", "鬯"},
	{"qogy", "镤"},
	{"qooy", "锬"},
	{"qou", "炙"},
	{"qovg", "镂"},
	{"qoy", "钬"},
	{"qp", "锭"},
	{"qpey", "镓"},
	{"qpg", "锭"},
	{"qpgh", "锭"},
	{"qpgw", "夤"},
	{"qprw", "镔"},
	{"qpvg", "铵"},
	{"qpwh", "镩"},
	{"qpwi", "镲"},
	{"qpxn", "铊"},
	{"qq", "多"},
	{"qqb", "匈"},
	{"qqbk", "匈"},
	{"qqcn", "铯"},
	{"qqcy", "钩"},
	{"qqgj", "镥"},
	{"qqiy", "铄"},
	{"qqk", "铭"},
	{"qqkg", "铭"},
	{"qqn", "钨"},
	{"qqng", "钨"},
	{"qqqf", "鑫"},
	{"qqqq", "金"},
	{"qqrn", "锪"},
	{"qqsy", "铩"},
	{"qqt", "铆"},
	{"qqtb", "铆"},
	{"qqu", "爻 多"},
	{"qqug", "钧"},
	{"qqvh", "铮"},
	{"qqw", "钦"},
	{"qqwy", "钦"},
	{"qqyl", "镏"},
	{"qqyy", "钓"},
	{"qr", "铁"},
	{"qrcy", "钣"},
	{"qre", "勿"},
	{"qrg", "铂"},
	{"qriy", "铢"},
	{"qrjh", "刎"},
	{"qrm", "锦"},
	{"qrmh", "锦"},
	{"qrn", "忽"},
	{"qrnq", "兜"},
	{"qrnu", "忽"},
	{"qrq", "锨"},
	{"qrqw", "锨"},
	{"qrw", "铁"},
	{"qrwy", "铁"},
	{"qry", "匆"},
	{"qryi", "匆"},
	{"qs", "钉"},
	{"qsaa", "弑"},
	{"qsfi", "镖"},
	{"qsg", "钵"},
	{"qsgg", "钵"},
	{"qsh", "钉"},
	{"qsj", "刹"},
	{"qsjh", "刹 镡"},
	{"qskg", "钶"},
	{"qsu", "杀"},
	{"qt", "儿 狭"},
	{"qta", "猎"},
	{"qtad", "狨"},
	{"qtaj", "猎"},
	{"qtal", "猫"},
	{"qtay", "獾"},
	{"qtbh", "卯"},
	{"qtbi", "狲"},
	{"qtbl", "猛"},
	{"qtbn", "犯"},
	{"qtcg", "犸"},
	{"qtcq", "狁"},
	{"qtcs", "猱"},
	{"qtct", "狻"},
	{"qtd", "锋"},
	{"qtde", "猢"},
	{"qtdh", "锋"},
	{"qtdi", "獠"},
	{"qtdk", "猗"},
	{"qtdn", "犹"},
	{"qtdw", "獗"},
	{"qte", "犭"},
	{"qteg", "狙"},
	{"qten", "锈"},
	{"qtf", "钎"},
	{"qtfc", "铥"},
	{"qtfe", "猿"},
	{"qtfh", "钎 犴"},
	{"qtfj", "猪"},
	{"qtfk", "锆"},
	{"qtfp", "铤"},
	{"qtfq", "铣"},
	{"qtfs", "橥"},
	{"qtfv", "锸"},
	{"qtg", "狂 狭"},
	{"qtge", "猜"},
	{"qtgf", "锤 锺"},
	{"qtgg", "狂"},
	{"qtgm", "獭"},
	{"qtgn", "钅"},
	{"qtgp", "逛"},
	{"qtgw", "狭"},
	{"qth", "镍"},
	{"qths", "镍"},
	{"qtj", "独 莉"},
	{"qtjf", "狸"},
	{"qtjg", "猩"},
	{"qtjh", "狮"},
	{"qtjj", "猖 莉"},
	{"qtjs", "猓"},
	{"qtjy", "独"},
	{"qtk", "铬"},
	{"qtke", "狷"},
	{"qtkg", "铬"},
	{"qtle", "猥 猬"},
	{"qtlh", "狎"},
	{"qtlq", "猡"},
	{"qtm", "猾"},
	{"qtme", "猾"},
	{"qtmy", "狈"},
	{"qtn", "儿 勹"},
	{"qtnf", "狃"},
	{"qtnh", "猸"},
	{"qtny", "夕"},
	{"qto", "锹"},
	{"qtop", "逖"},
	{"qtoy", "狄 锹"},
	{"qtp", "狞"},
	{"qtpf", "狩"},
	{"qtps", "狞"},
	{"qtq", "狗"},
	{"qtqh", "獬 狰"},
	{"qtqk", "狗"},
	{"qtqn", "狍"},
	{"qtr", "狐"},
	{"qtrt", "锇"},
	{"qtry", "狐"},
	{"qtsg", "猹"},
	{"qttj", "猁"},
	{"qtto", "獯"},
	{"qtu", "狡"},
	{"qtuj", "獐"},
	{"qtuq", "狡 獍"},
	{"qtv", "狠"},
	{"qtvb", "卿"},
	{"qtve", "狠"},
	{"qtvn", "犰"},
	{"qtvq", "猊"},
	{"qtw", "猴"},
	{"qtwc", "狯"},
	{"qtwd", "猴"},
	{"qtwi", "猃"},
	{"qtwk", "猞"},
	{"qtwt", "狳"},
	{"qtxf", "狴"},
	{"qtxi", "猕"},
	{"qtxj", "狒"},
	{"qty", "狼"},
	{"qtyd", "狱"},
	{"qtye", "狼"},
	{"qtyf", "猝"},
	{"qtyg", "狺"},
	{"qtyt", "犷"},
	{"qu", "匀"},
	{"qud", "匀"},
	{"qudb", "锩"},
	{"qufh", "钭"},
	{"qug", "镁"},
	{"quga", "锎"},
	{"qugd", "镁"},
	{"qugi", "镧"},
	{"quh", "锌"},
	{"quj", "镜"},
	{"qujg", "锏"},
	{"qujn", "镱"},
	{"qujq", "镜"},
	{"quk", "锐"},
	{"qukg", "锫"},
	{"qukq", "锐"},
	{"qumd", "镝"},
	{"qun", "钔"},
	{"quoj", "镨"},
	{"qup", "镑"},
	{"qupy", "镑"},
	{"quq", "铰"},
	{"quqf", "锵"},
	{"quqy", "铰"},
	{"qusl", "镒"},
	{"qut", "铲"},
	{"qutt", "铲"},
	{"qux", "锑"},
	{"quxt", "锑"},
	{"qv", "争"},
	{"qvb", "邹"},
	{"qvbh", "邹"},
	{"qve", "银"},
	{"qvey", "银"},
	{"qvf", "刍"},
	{"qvfp", "键"},
	{"qvg", "钕"},
	{"qvh", "争"},
	{"qvhc", "锼 皱"},
	{"qvhj", "争"},
	{"qvkg", "铷"},
	{"qvlg", "锱"},
	{"qvn", "急"},
	{"qvnu", "急"},
	{"qvpc", "锓"},
	{"qvt", "煞"},
	{"qvto", "煞"},
	{"qvw", "雏"},
	{"qvwy", "雏"},
	{"qw", "欠"},
	{"qwd", "锻"},
	{"qwdc", "锻"},
	{"qwgg", "铨"},
	{"qwgk", "铪"},
	{"qwgr", "镎"},
	{"qwgu", "镫"},
	{"qwu", "欠"},
	{"qwwf", "锉"},
	{"qwxf", "铧"},
	{"qwy", "锥"},
	{"qwyc", "铃"},
	{"qwye", "飧 镌"},
	{"qwyg", "锥"},
	{"qwyn", "钤"},
	{"qxjm", "镄"},
	{"qxkj", "镪"},
	{"qxxr", "锴"},
	{"qy", "久"},
	{"qya", "镀"},
	{"qyac", "镀"},
	{"qybt", "镦"},
	{"qycq", "铳 锍"},
	{"qyd", "訇"},
	{"qye", "铱"},
	{"qyey", "锿 铱"},
	{"qyi", "久 勺"},
	{"qyk", "镶"},
	{"qyke", "镶"},
	{"qym", "镐"},
	{"qymh", "铈"},
	{"qymk", "镐"},
	{"qymn", "钪"},
	{"qyn", "钫"},
	{"qync", "鹱"},
	{"qyne", "袅"},
	{"qyng", "鸟"},
	{"qynm", "岛 凫"},
	{"qyno", "镳"},
	{"qyns", "枭"},
	{"qynx", "鸵"},
	{"qyo", "灸"},
	{"qyou", "灸"},
	{"qyt", "卵"},
	{"qytb", "孵"},
	{"qytd", "镞"},
	{"qyth", "镟"},
	{"qyty", "卵"},
	{"qyuo", "镰"},
	{"qyv", "贸"},
	{"qyve", "锒"},
	{"qyvh", "镛"},
	{"qyvl", "留"},
	{"qyvm", "贸"},
	{"qyvp", "遛"},
	{"qyxy", "铉"},
	{"r", "的"},
	{"ra", "找"},
	{"raa", "拭"},
	{"raag", "拭"},
	{"rab", "皂"},
	{"rad", "撕"},
	{"radr", "撕"},
	{"rae", "撒"},
	{"raet", "撒"},
	{"rag", "扛"},
	{"raj", "措"},
	{"rajd", "摸"},
	{"rajg", "措"},
	{"rajv", "揠"},
	{"ral", "描"},
	{"ralg", "描"},
	{"ran", "拒"},
	{"rang", "拒"},
	{"rans", "揲"},
	{"ranw", "拣"},
	{"rap", "捞"},
	{"rapl", "捞"},
	{"raq", "抠"},
	{"raqy", "抠"},
	{"rat", "找"},
	{"ratq", "挠"},
	{"raw", "拱"},
	{"rawk", "搭"},
	{"raws", "搽"},
	{"rawy", "拱"},
	{"rb", "报"},
	{"rbbh", "揶"},
	{"rbc", "报"},
	{"rbcc", "摄"},
	{"rbcy", "报"},
	{"rbi", "拯"},
	{"rbig", "拯"},
	{"rbm", "拙"},
	{"rbmh", "拙"},
	{"rc", "反"},
	{"rcah", "拚"},
	{"rcb", "抒"},
	{"rcbh", "抒"},
	{"rcbs", "揉"},
	{"rcc", "掇"},
	{"rccc", "掇"},
	{"rccs", "搡"},
	{"rcd", "掺"},
	{"rcde", "掺"},
	{"rce", "捅"},
	{"rceh", "捅"},
	{"rcf", "择"},
	{"rcfh", "择"},
	{"rci", "反"},
	{"rck", "抬"},
	{"rckg", "抬"},
	{"rcn", "把"},
	{"rcp", "返"},
	{"rcpi", "返"},
	{"rct", "挨"},
	{"rctd", "挨"},
	{"rcw", "摊"},
	{"rcwy", "摊"},
	{"rcy", "瓜"},
	{"rcyi", "瓜"},
	{"rcyj", "搔"},
	{"rcyw", "瓞"},
	{"rd", "拓"},
	{"rdb", "扼"},
	{"rdbn", "扼"},
	{"rdc", "拔"},
	{"rdcy", "拔"},
	{"rdf", "振"},
	{"rdfe", "振"},
	{"rdff", "捱"},
	{"rdfh", "拜"},
	{"rdfi", "捺"},
	{"rdfj", "皋"},
	{"rdfn", "翱 挎"},
	{"rdg", "拓"},
	{"rdgn", "撼"},
	{"rdj", "排"},
	{"rdjd", "排"},
	{"rdjn", "掩"},
	{"rdmy", "颀"},
	{"rdn", "扰"},
	{"rdnn", "扰"},
	{"rdp", "挞"},
	{"rdpy", "挞"},
	{"rdsk", "掎"},
	{"rdu", "撩"},
	{"rdui", "撩"},
	{"rduw", "撅"},
	{"rdw", "捧"},
	{"rdwd", "揍"},
	{"rdwh", "捧"},
	{"rdx", "拢"},
	{"rdxn", "拢"},
	{"re", "扔"},
	{"ref", "援"},
	{"refc", "援"},
	{"refy", "捋"},
	{"reh", "拥"},
	{"ren", "扔"},
	{"rep", "授"},
	{"repc", "授"},
	{"rer", "摇"},
	{"rerm", "摇"},
	{"rf", "持"},
	{"rfc", "技"},
	{"rfcy", "技"},
	{"rff", "持"},
	{"rffg", "挂"},
	{"rffy", "持"},
	{"rfh", "盾"},
	{"rfhd", "盾"},
	{"rfhp", "遁"},
	{"rfjf", "擀"},
	{"rfkg", "拮"},
	{"rfkm", "撷"},
	{"rfl", "擂"},
	{"rflg", "擂"},
	{"rfm", "质"},
	{"rfmi", "质"},
	{"rfny", "抟"},
	{"rfp", "挝"},
	{"rfpy", "挝"},
	{"rfq", "抚"},
	{"rfqn", "抚"},
	{"rft", "拷"},
	{"rftn", "拷"},
	{"rfw", "扶"},
	{"rfwl", "撵"},
	{"rfwy", "扶 攉"},
	{"rg", "后"},
	{"rgb", "邱"},
	{"rgbh", "邱"},
	{"rgbv", "卮"},
	{"rgd", "丘"},
	{"rgdn", "掭"},
	{"rge", "捕"},
	{"rgef", "搏"},
	{"rgey", "捕"},
	{"rgf", "皇"},
	{"rghg", "扌"},
	{"rgk", "后"},
	{"rgkd", "后"},
	{"rgke", "攮"},
	{"rgkg", "捂"},
	{"rgkp", "逅"},
	{"rgm", "岳"},
	{"rgmj", "岳"},
	{"rgpd", "遑"},
	{"rgs", "抹"},
	{"rgsy", "抹"},
	{"rgt", "乒"},
	{"rgtr", "乒"},
	{"rgu", "挟"},
	{"rguh", "抨"},
	{"rguw", "挟"},
	{"rgv", "捷"},
	{"rgvh", "捷"},
	{"rgw", "兵"},
	{"rgwu", "兵"},
	{"rgy", "乓"},
	{"rgyu", "乓"},
	{"rh", "年"},
	{"rha", "掳"},
	{"rhal", "掳"},
	{"rhan", "摅"},
	{"rhb", "卸"},
	{"rhbh", "卸"},
	{"rhc", "披"},
	{"rhcy", "披"},
	{"rhf", "看"},
	{"rhfk", "年"},
	{"rhg", "扯"},
	{"rhh", "攫"},
	{"rhhc", "攫"},
	{"rhj", "掉"},
	{"rhjh", "掉"},
	{"rhk", "牛"},
	{"rhkg", "拈"},
	{"rhy", "扑"},
	{"rhyc", "爬"},
	{"rhyi", "爪"},
	{"ri", "朱"},
	{"ribh", "邾"},
	{"rie", "捎"},
	{"rieg", "捎"},
	{"rii", "朱"},
	{"rip", "撑"},
	{"ripq", "搅"},
	{"ripr", "撑"},
	{"riq", "挑"},
	{"riqn", "挑"},
	{"rit", "抄"},
	{"ritt", "抄"},
	{"riu", "泉"},
	{"riv", "挡"},
	{"rivg", "挡"},
	{"rj", "提"},
	{"rjb", "撮"},
	{"rjbc", "撮"},
	{"rjf", "捍"},
	{"rjfg", "捏"},
	{"rjfh", "捍"},
	{"rjg", "担"},
	{"rjgg", "担"},
	{"rjgh", "提"},
	{"rjhh", "抻"},
	{"rjq", "揭"},
	{"rjqn", "揭"},
	{"rjt", "揽"},
	{"rjtq", "揽"},
	{"rjx", "拽"},
	{"rjxt", "拽"},
	{"rk", "扣"},
	{"rkb", "揖"},
	{"rkbg", "揖"},
	{"rkcn", "挹"},
	{"rke", "捐"},
	{"rkeg", "捐"},
	{"rkg", "扣"},
	{"rkh", "捉"},
	{"rkhy", "捉"},
	{"rkk", "操"},
	{"rkks", "操"},
	{"rkl", "拐"},
	{"rklj", "捌"},
	{"rkln", "拐"},
	{"rkm", "损"},
	{"rkmy", "损"},
	{"rl", "押"},
	{"rldn", "摁"},
	{"rlf", "摆"},
	{"rlfc", "摆"},
	{"rlg", "舞"},
	{"rlge", "擐"},
	{"rlgh", "舞"},
	{"rlgy", "掴"},
	{"rlh", "押"},
	{"rls", "捆"},
	{"rlsy", "捆"},
	{"rlt", "撂"},
	{"rltk", "撂"},
	{"rlxi", "摞"},
	{"rm", "抽"},
	{"rma", "缸"},
	{"rmag", "缸"},
	{"rmay", "罐"},
	{"rmc", "投"},
	{"rmcy", "投"},
	{"rmd", "揣"},
	{"rmdj", "揣"},
	{"rmg", "抽"},
	{"rmh", "帛"},
	{"rmhh", "罅"},
	{"rmhj", "帛 制"},
	{"rmhr", "掣"},
	{"rmk", "缶"},
	{"rmmy", "撄"},
	{"rmn", "缺"},
	{"rmnn", "皑"},
	{"rmnw", "缺"},
	{"rmw", "摧"},
	{"rmwy", "摧"},
	{"rn", "所"},
	{"rna", "抿"},
	{"rnae", "搌"},
	{"rnan", "抿"},
	{"rnb", "气"},
	{"rnbm", "掘"},
	{"rnbt", "撖"},
	{"rnc", "氢"},
	{"rnca", "氢"},
	{"rnd", "据"},
	{"rndg", "据"},
	{"rndq", "氪"},
	{"rne", "氖"},
	{"rnev", "氖"},
	{"rnf", "扭"},
	{"rnfg", "扭"},
	{"rng", "握"},
	{"rnge", "氰"},
	{"rngf", "握"},
	{"rngg", "氩"},
	{"rnjj", "氘"},
	{"rnjl", "氲"},
	{"rnkj", "氚"},
	{"rnku", "擗"},
	{"rnld", "氤"},
	{"rnmj", "氙"},
	{"rnn", "扎"},
	{"rnnw", "撰"},
	{"rno", "氮"},
	{"rnoo", "氮"},
	{"rnp", "氨"},
	{"rnpv", "氨"},
	{"rnr", "扬"},
	{"rnrg", "摺"},
	{"rnrh", "所"},
	{"rnrt", "扬"},
	{"rnt", "拨"},
	{"rntr", "氕"},
	{"rntu", "氡"},
	{"rnty", "拨"},
	{"rnua", "摒"},
	{"rnud", "氧"},
	{"rnv", "氯"},
	{"rnvi", "氯"},
	{"rnw", "氛"},
	{"rnwv", "氛"},
	{"rnwy", "抉 擢"},
	{"rnx", "氟"},
	{"rnxj", "氟"},
	{"rny", "拟"},
	{"rnyw", "氦 拟"},
	{"ro", "搂"},
	{"rov", "搂"},
	{"rovg", "搂"},
	{"rovt", "擞"},
	{"rp", "近"},
	{"rpd", "迫"},
	{"rpf", "皖"},
	{"rpfq", "皖"},
	{"rpgg", "揎"},
	{"rpk", "近"},
	{"rpl", "挥"},
	{"rplh", "挥"},
	{"rpr", "摈"},
	{"rprw", "摈"},
	{"rps", "拧"},
	{"rpsh", "拧"},
	{"rpv", "按"},
	{"rpvg", "按"},
	{"rpw", "控"},
	{"rpwa", "控"},
	{"rpwh", "撺"},
	{"rpwi", "擦"},
	{"rpwn", "挖"},
	{"rpws", "探"},
	{"rq", "换"},
	{"rqa", "抵"},
	{"rqay", "抵"},
	{"rqb", "抑"},
	{"rqbh", "抑"},
	{"rqc", "鬼"},
	{"rqcc", "魃 魑"},
	{"rqce", "魈"},
	{"rqcf", "魁"},
	{"rqci", "鬼 魅"},
	{"rqcn", "魍"},
	{"rqcw", "魉"},
	{"rqgj", "撸"},
	{"rqk", "拘"},
	{"rqkg", "拘"},
	{"rqkq", "挽"},
	{"rqku", "搀"},
	{"rqm", "换"},
	{"rqmd", "换"},
	{"rqn", "抱"},
	{"rqnn", "抱"},
	{"rqoy", "掬"},
	{"rqqw", "揿"},
	{"rqr", "掏"},
	{"rqrm", "掏"},
	{"rqv", "掐"},
	{"rqvg", "掐"},
	{"rqvh", "挣"},
	{"rqw", "欣"},
	{"rqwy", "欣"},
	{"rqy", "的"},
	{"rqym", "捣"},
	{"rqyy", "的"},
	{"rr", "折"},
	{"rrc", "扳"},
	{"rrcy", "扳 皈"},
	{"rrg", "拍"},
	{"rrh", "折"},
	{"rrhm", "搋"},
	{"rrhy", "抓"},
	{"rrju", "蜇"},
	{"rrk", "哲"},
	{"rrkf", "哲"},
	{"rrkh", "踅"},
	{"rrp", "逝"},
	{"rrpk", "逝"},
	{"rrq", "掀"},
	{"rrqc", "魄"},
	{"rrqw", "掀"},
	{"rrr", "白"},
	{"rrrr", "白"},
	{"rrtf", "捭"},
	{"rry", "拆"},
	{"rryf", "誓"},
	{"rryy", "拆"},
	{"rs", "打"},
	{"rsh", "打"},
	{"rsjg", "揸"},
	{"rt", "手"},
	{"rta", "托"},
	{"rtan", "托"},
	{"rtb", "拖"},
	{"rtbn", "拖"},
	{"rtd", "括"},
	{"rtdg", "括"},
	{"rtdj", "挢"},
	{"rte", "搬"},
	{"rtec", "搬"},
	{"rtf", "插"},
	{"rtfb", "郫"},
	{"rtfg", "鹎"},
	{"rtfh", "扦"},
	{"rtfj", "卑"},
	{"rtfk", "皓"},
	{"rtfm", "攒"},
	{"rtfn", "撬"},
	{"rtfp", "挺"},
	{"rtfv", "插"},
	{"rtg", "手"},
	{"rtgf", "捶"},
	{"rtgh", "手"},
	{"rthi", "攥"},
	{"rthj", "擤"},
	{"rto", "揪"},
	{"rtol", "播 皤"},
	{"rtoy", "揪"},
	{"rtt", "斤"},
	{"rtth", "斤"},
	{"ru", "拉"},
	{"rua", "拼"},
	{"ruah", "拼"},
	{"rube", "搠"},
	{"rud", "搓"},
	{"ruda", "搓"},
	{"rudb", "掷"},
	{"ruf", "拦"},
	{"rufg", "拦"},
	{"rufh", "拌 抖"},
	{"rug", "拉"},
	{"ruj", "撞"},
	{"rujf", "掸 撞"},
	{"rujg", "揞"},
	{"rukg", "掊"},
	{"rum", "摘"},
	{"rumd", "摘"},
	{"rumt", "撇"},
	{"run", "扪"},
	{"ruqy", "皎"},
	{"rusf", "撙"},
	{"rut", "搁"},
	{"rutk", "搁"},
	{"ruv", "接"},
	{"ruvg", "接"},
	{"ruvo", "搛"},
	{"rv", "扫"},
	{"rvf", "挪"},
	{"rvfb", "挪"},
	{"rvg", "扫"},
	{"rvh", "搜"},
	{"rvhc", "搜"},
	{"rvk", "招"},
	{"rvkg", "招"},
	{"rvl", "抛"},
	{"rvln", "抛"},
	{"rvn", "殷"},
	{"rvnc", "殷"},
	{"rvqy", "拶"},
	{"rvtk", "捃"},
	{"rvy", "执"},
	{"rvyf", "垫"},
	{"rvyg", "鸷"},
	{"rvyi", "絷"},
	{"rvyj", "蛰"},
	{"rvyl", "势"},
	{"rvym", "贽"},
	{"rvyo", "热"},
	{"rvyr", "挚"},
	{"rvyy", "执"},
	{"rw", "失"},
	{"rwb", "抢"},
	{"rwbn", "抢"},
	{"rwfy", "拊"},
	{"rwg", "拴"},
	{"rwgd", "揆"},
	{"rwgg", "拴"},
	{"rwgi", "捡"},
	{"rwgj", "揄"},
	{"rwgk", "拾"},
	{"rwgr", "搿"},
	{"rwi", "失"},
	{"rwp", "迭"},
	{"rwpi", "迭"},
	{"rwv", "扮"},
	{"rwvn", "扮"},
	{"rwvr", "掰"},
	{"rww", "挫"},
	{"rwwf", "挫"},
	{"rwx", "抡"},
	{"rwxn", "抡"},
	{"rwy", "扒"},
	{"rwyc", "拎 擒"},
	{"rwye", "携"},
	{"rwyg", "推"},
	{"rwyn", "捻"},
	{"rx", "批"},
	{"rxey", "掾"},
	{"rxfm", "掼"},
	{"rxg", "拇"},
	{"rxgu", "拇"},
	{"rxj", "指"},
	{"rxjg", "指"},
	{"rxjh", "拂"},
	{"rxln", "拗"},
	{"rxuu", "搦"},
	{"rxx", "批"},
	{"rxxn", "批"},
	{"rxxr", "揩"},
	{"ry", "扩"},
	{"ryao", "摭"},
	{"ryc", "撤"},
	{"ryct", "撤"},
	{"rydn", "捩"},
	{"ryg", "拄"},
	{"rygg", "拄"},
	{"ryh", "掂"},
	{"ryhk", "掂"},
	{"ryi", "斥"},
	{"ryiy", "掠"},
	{"ryj", "挤"},
	{"ryjh", "挤"},
	{"ryk", "攘"},
	{"ryke", "攘"},
	{"ryl", "擅"},
	{"rylg", "擅"},
	{"rym", "搞"},
	{"rymk", "搞"},
	{"rymn", "抗"},
	{"ryn", "护"},
	{"ryne", "掮"},
	{"rynt", "护"},
	{"ryt", "扩"},
	{"rytp", "邀"},
	{"ryty", "敫"},
	{"ryv", "搪"},
	{"ryvk", "搪"},
	{"ryw", "掖"},
	{"rywy", "掖"},
	{"ryx", "摔"},
	{"ryxf", "摔"},
	{"ryxl", "搐"},
	{"s", "要"},
	{"sa", "械"},
	{"saa", "械"},
	{"saah", "械"},
	{"sabh", "栉"},
	{"sad", "棋"},
	{"sadd", "榧"},
	{"sadn", "椹"},
	{"sadw", "棋"},
	{"saf", "柑"},
	{"safg", "柑"},
	{"sag", "杠"},
	{"sagg", "框"},
	{"sai", "栋"},
	{"saiy", "栋"},
	{"saj", "模"},
	{"sajd", "模"},
	{"sakg", "槿"},
	{"sam", "横"},
	{"samw", "横"},
	{"san", "柜"},
	{"sang", "柜"},
	{"sap", "檬"},
	{"sape", "檬"},
	{"saq", "枢"},
	{"saqy", "枢 柩"},
	{"satq", "桡"},
	{"sb", "李"},
	{"sbb", "椰"},
	{"sbbh", "椰"},
	{"sbd", "椭"},
	{"sbde", "椭"},
	{"sbf", "李"},
	{"sc", "权"},
	{"scbh", "杼"},
	{"scbk", "橘"},
	{"scbn", "懋"},
	{"sce", "桶"},
	{"sceh", "桶"},
	{"scf", "树"},
	{"scfg", "柽"},
	{"scfy", "树"},
	{"scg", "杩"},
	{"scn", "杷"},
	{"scw", "梭"},
	{"scwt", "梭"},
	{"scy", "权"},
	{"scyy", "杈"},
	{"sd", "枯"},
	{"sdg", "枯 柘"},
	{"sdgf", "橱"},
	{"sdh", "楔"},
	{"sdhd", "楔"},
	{"sdht", "槭"},
	{"sdln", "枥"},
	{"sds", "椅"},
	{"sdsk", "椅"},
	{"sdt", "梆"},
	{"sdtb", "梆"},
	{"sduw", "橛"},
	{"sdw", "棒"},
	{"sdwd", "楱"},
	{"sdwh", "棒"},
	{"sdwj", "椿"},
	{"sdwt", "榛"},
	{"sdxn", "栊"},
	{"sdy", "杖"},
	{"sdyy", "杖"},
	{"se", "极"},
	{"sebg", "桴"},
	{"secl", "楹"},
	{"see", "棚"},
	{"seeg", "棚"},
	{"set", "杉"},
	{"seyy", "极"},
	{"sf", "村"},
	{"sfbh", "鄄"},
	{"sfc", "枝"},
	{"sfcy", "枝"},
	{"sff", "桂"},
	{"sffg", "桂"},
	{"sffn", "樗"},
	{"sfg", "杜"},
	{"sfgn", "甄"},
	{"sfh", "杆"},
	{"sfhg", "植"},
	{"sfht", "樾"},
	{"sfi", "标"},
	{"sfij", "剽"},
	{"sfiq", "飘"},
	{"sfiu", "票 柰"},
	{"sfiy", "标 瓢"},
	{"sfk", "桔"},
	{"sfkg", "桔"},
	{"sflg", "檑"},
	{"sfmf", "楠"},
	{"sfnd", "椟"},
	{"sft", "材"},
	{"sftj", "楮"},
	{"sftn", "栲"},
	{"sftt", "材"},
	{"sftx", "栳"},
	{"sfuk", "樯"},
	{"sfw", "棱"},
	{"sfwt", "棱"},
	{"sfy", "村"},
	{"sg", "本"},
	{"sga", "醋"},
	{"sgaf", "酣"},
	{"sgag", "醛"},
	{"sgaj", "醋"},
	{"sgbn", "酏"},
	{"sgc", "酸"},
	{"sgcf", "桎"},
	{"sgct", "酸"},
	{"sgd", "本 酉"},
	{"sgde", "醐"},
	{"sgdg", "酤"},
	{"sgdl", "醢"},
	{"sgdy", "酞"},
	{"sgef", "酹"},
	{"sgf", "酝"},
	{"sgfb", "酵"},
	{"sgfc", "酝"},
	{"sgfh", "酐"},
	{"sgfy", "酎"},
	{"sgg", "枉"},
	{"sggd", "酽"},
	{"sggy", "酾"},
	{"sgh", "丁"},
	{"sghe", "醵"},
	{"sghg", "西"},
	{"sgi", "杯"},
	{"sgiy", "杯"},
	{"sgj", "醒"},
	{"sgjg", "桓 醒"},
	{"sgjh", "醍"},
	{"sgjq", "梗"},
	{"sgjx", "醌"},
	{"sgk", "梧"},
	{"sgkg", "梧 酲"},
	{"sgli", "楝"},
	{"sgm", "柄"},
	{"sgmj", "槽"},
	{"sgmk", "酮"},
	{"sgmu", "醴"},
	{"sgmw", "柄"},
	{"sgn", "配"},
	{"sgne", "醑 醪"},
	{"sgnn", "配 朽"},
	{"sgo", "醚"},
	{"sgog", "桠"},
	{"sgop", "醚"},
	{"sgoy", "醭"},
	{"sgpx", "酡"},
	{"sgq", "酌"},
	{"sgqb", "酗"},
	{"sgqk", "酩"},
	{"sgqn", "杌"},
	{"sgqy", "酌"},
	{"sgsh", "酊"},
	{"sgt", "栈"},
	{"sgtf", "酢"},
	{"sgtk", "酷 酪"},
	{"sgto", "醺"},
	{"sgtq", "酰"},
	{"sgtu", "酶"},
	{"sgty", "酥"},
	{"sguh", "枰"},
	{"sguk", "醅"},
	{"sgw", "酚"},
	{"sgwo", "醮"},
	{"sgwt", "酴"},
	{"sgwv", "酚"},
	{"sgxj", "酯"},
	{"sgy", "醉"},
	{"sgyb", "醇"},
	{"sgye", "酿"},
	{"sgyf", "醉"},
	{"sgyh", "酬"},
	{"sgyk", "醣"},
	{"sgyl", "醯"},
	{"sh", "相"},
	{"shg", "相"},
	{"shi", "椒"},
	{"shic", "椒"},
	{"shjh", "棹"},
	{"shmy", "桢"},
	{"shn", "想"},
	{"shnt", "栌"},
	{"shnu", "想"},
	{"shy", "朴"},
	{"si", "档"},
	{"sie", "梢"},
	{"sieg", "梢"},
	{"siit", "桫"},
	{"sipf", "樘"},
	{"siq", "桃"},
	{"siqn", "桃 桄"},
	{"sitt", "杪"},
	{"siv", "档"},
	{"sivg", "档"},
	{"siwh", "榉"},
	{"sj", "查"},
	{"sjf", "杳"},
	{"sjg", "查"},
	{"sjgf", "查"},
	{"sjj", "覃"},
	{"sjng", "榻"},
	{"sjs", "棵"},
	{"sjsy", "棵"},
	{"sjt", "槛"},
	{"sjtl", "槛"},
	{"sjtq", "榄"},
	{"sjx", "棍"},
	{"sjxx", "棍"},
	{"sk", "可"},
	{"skbg", "楫"},
	{"skd", "可"},
	{"skf", "杏"},
	{"skgn", "枵"},
	{"skkk", "榀"},
	{"sks", "哥"},
	{"sksk", "哥"},
	{"sksw", "歌"},
	{"skwy", "枳"},
	{"sl", "楞"},
	{"slh", "柙"},
	{"slk", "枷"},
	{"slkg", "枷"},
	{"slqy", "椤"},
	{"sly", "楞"},
	{"slyn", "楞"},
	{"sm", "机"},
	{"smg", "柚"},
	{"smgk", "桐"},
	{"smm", "栅"},
	{"smmg", "栅"},
	{"smmv", "樱"},
	{"smn", "机"},
	{"smnn", "桤"},
	{"smq", "枫"},
	{"smqn", "枧"},
	{"smqy", "枫"},
	{"smu", "贾"},
	{"smwy", "枘"},
	{"sn", "杨"},
	{"snbt", "橄"},
	{"sndg", "椐"},
	{"sng", "栩"},
	{"snhg", "楣"},
	{"snie", "榍"},
	{"snih", "樨"},
	{"snn", "杞 札"},
	{"snr", "杨"},
	{"snrt", "杨"},
	{"so", "杰"},
	{"sou", "杰 粟"},
	{"sov", "楼"},
	{"sovg", "楼"},
	{"sp", "棕"},
	{"spf", "棕"},
	{"spfi", "棕"},
	{"spgg", "楦"},
	{"spn", "棺"},
	{"spnn", "棺"},
	{"spq", "枕"},
	{"spqn", "枕"},
	{"sprw", "槟"},
	{"sps", "柠"},
	{"spsh", "柠"},
	{"spvg", "桉"},
	{"spw", "榨"},
	{"spwf", "榨"},
	{"spwi", "檫"},
	{"spwk", "榕"},
	{"spwy", "榷"},
	{"spxn", "柁"},
	{"sq", "构"},
	{"sqay", "柢"},
	{"sqc", "构"},
	{"sqcy", "构"},
	{"sqd", "桅"},
	{"sqdb", "桅"},
	{"sqdy", "檐"},
	{"sqef", "槲"},
	{"sqeh", "桷"},
	{"sqgj", "橹"},
	{"sqiy", "栎"},
	{"sqj", "橡"},
	{"sqje", "橡"},
	{"sqkg", "枸"},
	{"sqq", "攀"},
	{"sqqd", "樊"},
	{"sqqr", "攀"},
	{"sqt", "柳"},
	{"sqtb", "柳"},
	{"sqy", "榴"},
	{"sqyl", "榴"},
	{"sqyy", "杓"},
	{"sr", "析"},
	{"src", "板"},
	{"srcy", "板"},
	{"srdf", "槔"},
	{"srg", "柏"},
	{"srgb", "栀"},
	{"srh", "析"},
	{"sri", "株"},
	{"sriy", "株"},
	{"srm", "棉"},
	{"srmh", "棉"},
	{"srq", "槐"},
	{"srqc", "槐"},
	{"srrf", "皙"},
	{"sry", "檄"},
	{"sryt", "檄"},
	{"sryy", "柝"},
	{"ss", "林"},
	{"ssb", "郴"},
	{"ssbh", "郴"},
	{"sse", "彬"},
	{"sset", "彬"},
	{"ssf", "禁"},
	{"ssfi", "禁"},
	{"ssg", "栖"},
	{"ssjg", "楂"},
	{"ssk", "柯"},
	{"sskg", "柯"},
	{"ssmy", "梵"},
	{"ssn", "楚"},
	{"ssnh", "楚"},
	{"sso", "焚"},
	{"ssou", "焚"},
	{"ssq", "梦"},
	{"ssqu", "梦"},
	{"sss", "森"},
	{"ssss", "木"},
	{"sssu", "森"},
	{"ssu", "栗"},
	{"ssv", "婪"},
	{"ssvf", "婪"},
	{"sswv", "棼"},
	{"ssy", "林"},
	{"ssyx", "麓"},
	{"st", "格"},
	{"stay", "枨"},
	{"std", "桥"},
	{"stdg", "栝"},
	{"stdj", "桥"},
	{"stf", "橇"},
	{"stfh", "杵 桁"},
	{"stfk", "梏"},
	{"stfn", "橇"},
	{"stfp", "梃"},
	{"stgf", "棰"},
	{"sth", "柞"},
	{"sthf", "柞"},
	{"stk", "格"},
	{"stkg", "格"},
	{"stmf", "榭"},
	{"stoy", "楸"},
	{"stt", "覆"},
	{"sttt", "覆"},
	{"stx", "梅"},
	{"stxu", "梅"},
	{"sty", "枚"},
	{"su", "样"},
	{"sud", "样"},
	{"suda", "槎"},
	{"sudh", "样"},
	{"suf", "栏"},
	{"sufg", "栏"},
	{"suh", "梓"},
	{"suj", "樟"},
	{"sujh", "樟"},
	{"sukk", "榈"},
	{"sup", "榜"},
	{"supy", "榜"},
	{"suq", "校"},
	{"suqy", "校"},
	{"susf", "樽"},
	{"susy", "榇"},
	{"sux", "梯"},
	{"suxt", "梯"},
	{"sv", "要"},
	{"svc", "概"},
	{"svcq", "概"},
	{"sve", "根"},
	{"svey", "根"},
	{"svf", "要"},
	{"svfp", "楗"},
	{"svg", "桕"},
	{"sviy", "棣"},
	{"svoy", "棂"},
	{"sw", "检"},
	{"swb", "枪"},
	{"swbn", "枪"},
	{"swc", "松"},
	{"swcy", "松"},
	{"swdc", "椴"},
	{"swfc", "桧"},
	{"swg", "栓"},
	{"swgg", "栓"},
	{"swgi", "检"},
	{"swgj", "榆"},
	{"swgu", "橙"},
	{"swnp", "槌"},
	{"swwy", "枞"},
	{"swxf", "桦"},
	{"swyc", "柃 檎"},
	{"swyf", "榫"},
	{"swyg", "椎"},
	{"swyo", "樵"},
	{"sx", "楷"},
	{"sxe", "椽"},
	{"sxey", "椽"},
	{"sxx", "楷"},
	{"sxxe", "橼"},
	{"sxxn", "枇"},
	{"sxxr", "楷"},
	{"sy", "术"},
	{"sybg", "椁"},
	{"syc", "梳"},
	{"sycq", "梳"},
	{"syf", "桩"},
	{"syfg", "桩"},
	{"syfj", "槠 隼"},
	{"syg", "柱"},
	{"sygg", "柱"},
	{"syi", "术"},
	{"syiy", "椋"},
	{"syke", "榱"},
	{"syl", "檀"},
	{"sylg", "檀"},
	{"syli", "懔 檩"},
	{"sym", "杭"},
	{"symh", "柿"},
	{"symk", "槁"},
	{"symn", "杭"},
	{"syn", "枋"},
	{"synw", "核"},
	{"syp", "述"},
	{"sypi", "述"},
	{"syv", "榔"},
	{"syvb", "榔"},
	{"t", "和"},
	{"ta", "长"},
	{"tabk", "筇"},
	{"tad", "箕"},
	{"tadc", "簸"},
	{"tadd", "篚"},
	{"tadk", "箬"},
	{"tadw", "箕"},
	{"tag", "筐"},
	{"tagf", "筐"},
	{"tagw", "箧"},
	{"tahp", "逄"},
	{"tak", "升"},
	{"takf", "笸"},
	{"tam", "筑"},
	{"tamw", "簧"},
	{"tamy", "筑"},
	{"taqj", "簪"},
	{"tav", "乇"},
	{"tavn", "彻"},
	{"taww", "筮"},
	{"tay", "长"},
	{"tayi", "长"},
	{"tb", "季"},
	{"tbf", "季"},
	{"tbpv", "迤"},
	{"tc", "么"},
	{"tca", "径"},
	{"tcag", "径"},
	{"tcb", "笆"},
	{"tcf", "笃"},
	{"tckf", "笞"},
	{"tcu", "么"},
	{"tcy", "私"},
	{"td", "知"},
	{"tda", "矩"},
	{"tdaf", "甜"},
	{"tdan", "矩"},
	{"tdas", "榘"},
	{"tdd", "舌"},
	{"tdg", "短"},
	{"tdgn", "舔"},
	{"tdgt", "箴"},
	{"tdgu", "短"},
	{"tdh", "逢"},
	{"tdhp", "逢"},
	{"tdi", "夭"},
	{"tdij", "籍"},
	{"tdj", "乔"},
	{"tdjd", "徘"},
	{"tdjh", "刮"},
	{"tdjj", "乔"},
	{"tdk", "知"},
	{"tdkg", "知"},
	{"tdkj", "智"},
	{"tdmj", "岙"},
	{"tdn", "乱"},
	{"tdnj", "稽"},
	{"tdnm", "嵇"},
	{"tdnn", "乱"},
	{"tdp", "适"},
	{"tdpd", "适"},
	{"tdqa", "舐"},
	{"tdqg", "鸹"},
	{"tdt", "敌"},
	{"tdtf", "筹"},
	{"tdtj", "矫"},
	{"tdtn", "憩"},
	{"tdtv", "矮"},
	{"tdty", "敌"},
	{"tdu", "矢"},
	{"tduh", "辞"},
	{"tdwf", "矬"},
	{"tdwy", "雉"},
	{"tdx", "笼"},
	{"tdxb", "笼"},
	{"tdxh", "矧"},
	{"te", "秀"},
	{"teae", "艨"},
	{"teag", "舡"},
	{"teb", "秀"},
	{"tebg", "稃"},
	{"tebl", "艋"},
	{"teg", "租"},
	{"tegg", "徂 租"},
	{"tegj", "艚"},
	{"tehn", "舻"},
	{"tei", "舟"},
	{"teie", "艄"},
	{"tekh", "舯"},
	{"tel", "盘"},
	{"telb", "筋"},
	{"telf", "盘"},
	{"tem", "般"},
	{"temc", "般"},
	{"temd", "磐"},
	{"temg", "舳"},
	{"temh", "舢"},
	{"temk", "船"},
	{"temq", "舰"},
	{"tenn", "艉"},
	{"tep", "透"},
	{"tepv", "透"},
	{"tepx", "舵"},
	{"ter", "舶"},
	{"terc", "舨"},
	{"terg", "舶"},
	{"term", "徭"},
	{"tesg", "舾"},
	{"tesk", "舸"},
	{"tet", "艇"},
	{"tetf", "舴"},
	{"tetp", "艇"},
	{"teuf", "艟"},
	{"teuh", "艏"},
	{"tev", "稻"},
	{"tevc", "艘"},
	{"tevg", "稻"},
	{"tew", "舱"},
	{"tewb", "舱"},
	{"texx", "舭"},
	{"tey", "航"},
	{"teym", "航"},
	{"teyn", "舫"},
	{"teyq", "舣"},
	{"teyu", "笈"},
	{"teyx", "舷"},
	{"tf", "先 行"},
	{"tfc", "丢"},
	{"tfcu", "丢"},
	{"tfd", "壬"},
	{"tff", "竺"},
	{"tffh", "街"},
	{"tffu", "等"},
	{"tffy", "待"},
	{"tfh", "秆"},
	{"tfhh", "行"},
	{"tfhw", "稹"},
	{"tfhy", "徒"},
	{"tfj", "竿 午"},
	{"tfjf", "篝"},
	{"tfk", "千"},
	{"tfkb", "郜"},
	{"tfkd", "靠"},
	{"tfkf", "告"},
	{"tfkg", "秸 鹄"},
	{"tfkp", "造"},
	{"tfl", "德"},
	{"tfln", "德"},
	{"tfn", "毛"},
	{"tfnh", "毪"},
	{"tfnj", "氇 氆"},
	{"tfnk", "毡"},
	{"tfnn", "毳"},
	{"tfno", "毯"},
	{"tfnp", "毽"},
	{"tfnv", "毛"},
	{"tfp", "迁"},
	{"tfpd", "廷"},
	{"tfpk", "迁 迕"},
	{"tfq", "先"},
	{"tfqb", "先"},
	{"tfqm", "赞"},
	{"tfqp", "选"},
	{"tfqu", "筠"},
	{"tftj", "箸"},
	{"tfuk", "穑"},
	{"tfux", "乖"},
	{"tfvw", "歃"},
	{"tg", "生"},
	{"tga", "垂"},
	{"tgaf", "垂"},
	{"tgaj", "笄"},
	{"tgd", "生"},
	{"tgef", "箐"},
	{"tgfj", "竽"},
	{"tgh", "征"},
	{"tghf", "眚"},
	{"tghg", "征"},
	{"tghn", "惩"},
	{"tgj", "重"},
	{"tgjf", "重"},
	{"tgjn", "穗"},
	{"tgjq", "筻"},
	{"tgk", "衙"},
	{"tgkh", "衙"},
	{"tgkm", "籁"},
	{"tgkw", "簌"},
	{"tgl", "熏"},
	{"tgll", "甥"},
	{"tglo", "熏"},
	{"tgm", "策"},
	{"tgmi", "策"},
	{"tgmu", "箦"},
	{"tgoy", "徕"},
	{"tgr", "笺"},
	{"tgsy", "秣"},
	{"tgu", "秤"},
	{"tguh", "秤"},
	{"tgv", "秉"},
	{"tgvi", "秉"},
	{"th", "处"},
	{"tha", "算"},
	{"thaj", "算"},
	{"thc", "彼"},
	{"thcy", "彼"},
	{"thd", "自"},
	{"thdc", "篡"},
	{"thdi", "纂"},
	{"thdu", "臭"},
	{"thf", "乍"},
	{"thfd", "乍"},
	{"thfn", "怎"},
	{"thfp", "迮"},
	{"thg", "片"},
	{"thgc", "版"},
	{"thgd", "牍"},
	{"thgf", "牌"},
	{"thgn", "片"},
	{"thgs", "牒"},
	{"thgy", "牖"},
	{"thhh", "衢"},
	{"thhy", "徙"},
	{"thi", "处"},
	{"thjf", "昝"},
	{"thk", "咎"},
	{"thkf", "咎"},
	{"thl", "鼻"},
	{"thlf", "鼾"},
	{"thlg", "齄"},
	{"thlj", "鼻 劓"},
	{"thlv", "鼽"},
	{"thn", "息"},
	{"thnu", "息"},
	{"thp", "延"},
	{"thpd", "延"},
	{"thsu", "臬"},
	{"ti", "秒"},
	{"tie", "稍"},
	{"tief", "筲"},
	{"tieg", "稍"},
	{"tif", "衍"},
	{"tifh", "衍"},
	{"tifn", "愆"},
	{"tig", "簿"},
	{"tigf", "簿"},
	{"timk", "徜"},
	{"tir", "箔"},
	{"tirf", "箔"},
	{"tit", "秒"},
	{"titt", "秒"},
	{"tj", "得"},
	{"tjf", "香"},
	{"tjg", "得"},
	{"tjgf", "得 笪"},
	{"tjgh", "筛"},
	{"tjh", "利"},
	{"tjr", "犁"},
	{"tjrh", "犁"},
	{"tjs", "梨"},
	{"tjsu", "梨"},
	{"tjsy", "稞"},
	{"tjt", "复"},
	{"tjtl", "篮"},
	{"tjtt", "馥"},
	{"tjtu", "复"},
	{"tk", "各"},
	{"tkf", "各"},
	{"tkg", "和"},
	{"tkgg", "程"},
	{"tkh", "种"},
	{"tkhh", "种"},
	{"tkhm", "篑"},
	{"tkkg", "稆"},
	{"tkm", "禹"},
	{"tkmy", "禹"},
	{"tkw", "积"},
	{"tkwy", "积 雒"},
	{"tl", "务"},
	{"tlb", "务"},
	{"tld", "血"},
	{"tldt", "篾"},
	{"tlf", "备"},
	{"tlff", "睾"},
	{"tlgj", "箅"},
	{"tlk", "徊"},
	{"tlkf", "笳"},
	{"tlkg", "徊"},
	{"tln", "惫"},
	{"tlnu", "惫"},
	{"tlo", "粤"},
	{"tlon", "粤"},
	{"tlpu", "笾"},
	{"tlq", "箩"},
	{"tlqi", "囟 囱"},
	{"tlqu", "箩"},
	{"tlu", "衅"},
	{"tluf", "衅"},
	{"tlwt", "稷"},
	{"tm", "向"},
	{"tmb", "秃"},
	{"tmc", "役"},
	{"tmcy", "役"},
	{"tmd", "身"},
	{"tmdf", "射"},
	{"tmdk", "躺"},
	{"tmdm", "颓"},
	{"tmdq", "躯"},
	{"tmds", "躲"},
	{"tmdt", "身"},
	{"tmdx", "躬"},
	{"tmdy", "秧"},
	{"tmf", "笛"},
	{"tmfk", "稠"},
	{"tmg", "微"},
	{"tmgk", "筒"},
	{"tmgt", "徽 微 徵"},
	{"tmh", "币"},
	{"tmhk", "币"},
	{"tmk", "向"},
	{"tmkd", "向"},
	{"tmo", "奥"},
	{"tmod", "奥"},
	{"tmq", "秽"},
	{"tmqb", "笕"},
	{"tmqy", "秽"},
	{"tn", "秘"},
	{"tnb", "乞"},
	{"tngk", "笥"},
	{"tnn", "筷"},
	{"tnnw", "筷"},
	{"tnp", "迄"},
	{"tnpv", "迄"},
	{"tnt", "秘"},
	{"tntt", "秘"},
	{"to", "秋"},
	{"toc", "释"},
	{"toch", "释"},
	{"tol", "番"},
	{"tolb", "鄱"},
	{"tolf", "番"},
	{"toln", "翻"},
	{"tom", "釉"},
	{"tomg", "釉"},
	{"ton", "悉"},
	{"tonr", "簖"},
	{"tonu", "愁 悉"},
	{"tov", "篓"},
	{"tovf", "篓"},
	{"toy", "秋"},
	{"tp", "管"},
	{"tpe", "稼"},
	{"tpey", "稼"},
	{"tpi", "乏"},
	{"tpn", "管"},
	{"tpnn", "管"},
	{"tpqb", "箢"},
	{"tpwa", "箜"},
	{"tq", "称 衔"},
	{"tqd", "稀"},
	{"tqdh", "衡 稀"},
	{"tqf", "衔"},
	{"tqfh", "衔"},
	{"tqi", "称"},
	{"tqiy", "称"},
	{"tqjg", "徇"},
	{"tqkf", "笱"},
	{"tqq", "移"},
	{"tqqy", "移"},
	{"tqrq", "篼"},
	{"tqrr", "笏"},
	{"tqt", "黎"},
	{"tqti", "黎"},
	{"tqto", "黧"},
	{"tqv", "稳"},
	{"tqvh", "筝"},
	{"tqvn", "稳"},
	{"tr", "物"},
	{"tra", "箍"},
	{"traf", "箝"},
	{"trah", "箍"},
	{"trcb", "筢"},
	{"trch", "箨"},
	{"trdg", "牯"},
	{"trdk", "犄"},
	{"trf", "特"},
	{"trfd", "犊"},
	{"trff", "特"},
	{"trfg", "牡"},
	{"trfh", "循"},
	{"trgf", "篁"},
	{"trgg", "徨"},
	{"trgk", "牾"},
	{"trh", "御"},
	{"trhb", "御"},
	{"trhm", "篪"},
	{"trhw", "犋"},
	{"trhy", "笊"},
	{"tri", "穆"},
	{"trie", "穆"},
	{"trkf", "筘"},
	{"trn", "我"},
	{"trng", "鹅"},
	{"trnt", "我"},
	{"trq", "物"},
	{"trql", "籀"},
	{"trqr", "物"},
	{"trs", "牺"},
	{"trsg", "牺"},
	{"trt", "牧"},
	{"trtf", "稗"},
	{"trtg", "牲"},
	{"trtk", "牿"},
	{"trtn", "牦"},
	{"trty", "牧"},
	{"trvp", "犍"},
	{"trw", "秩"},
	{"trwy", "秩"},
	{"trxn", "牝"},
	{"trya", "犏"},
	{"tryk", "犒"},
	{"tryt", "徼"},
	{"ts", "条"},
	{"tsg", "笨"},
	{"tsgf", "笨"},
	{"tsh", "箱"},
	{"tshf", "箱"},
	{"tsjj", "簟"},
	{"tsso", "糜"},
	{"tssu", "篥"},
	{"tsu", "条"},
	{"tsyy", "秫"},
	{"tt", "笔"},
	{"ttd", "笑"},
	{"ttdp", "篷"},
	{"ttdu", "笑"},
	{"ttf", "笔"},
	{"ttfn", "笔"},
	{"ttfq", "筅"},
	{"ttg", "竹"},
	{"ttgf", "笙"},
	{"ttgh", "竹"},
	{"ttgy", "攵"},
	{"tthf", "笮"},
	{"tthp", "筵"},
	{"ttll", "丿"},
	{"ttlx", "篦"},
	{"ttnt", "秭 笫"},
	{"ttny", "夂"},
	{"ttt", "禾"},
	{"ttth", "彳"},
	{"tttt", "禾"},
	{"tu", "科"},
	{"tudh", "徉"},
	{"tue", "箭"},
	{"tuej", "箭"},
	{"tuf", "笠"},
	{"tufh", "科"},
	{"tuh", "乎"},
	{"tuhk", "乎"},
	{"tuj", "简"},
	{"tujf", "简 箪"},
	{"tujj", "螽"},
	{"tuk", "税"},
	{"tukq", "税"},
	{"tuu", "冬"},
	{"tux", "乘"},
	{"tuxj", "剩"},
	{"tuxv", "乘"},
	{"tv", "委"},
	{"tve", "很"},
	{"tvel", "簋"},
	{"tvey", "很"},
	{"tvf", "委"},
	{"tvfh", "律"},
	{"tvij", "箫"},
	{"tvkf", "笤"},
	{"tvpd", "逶"},
	{"tvr", "魏"},
	{"tvrc", "魏"},
	{"tvt", "笋"},
	{"tvtr", "笋"},
	{"tw", "答"},
	{"twa", "筏"},
	{"twar", "筏"},
	{"twf", "符"},
	{"twfu", "符"},
	{"twg", "答"},
	{"twgf", "筌"},
	{"twgi", "签"},
	{"twgk", "答"},
	{"twgu", "簦"},
	{"twht", "筱"},
	{"twi", "黍"},
	{"twik", "黏"},
	{"twiu", "黍"},
	{"twnd", "篌"},
	{"twt", "徐"},
	{"twty", "徐"},
	{"twy", "稚"},
	{"twyg", "稚"},
	{"twyn", "稔"},
	{"tx", "第"},
	{"txe", "篆"},
	{"txen", "胤"},
	{"txeu", "篆"},
	{"txg", "每"},
	{"txgg", "鳘"},
	{"txgi", "繁"},
	{"txgq", "毓"},
	{"txgt", "敏"},
	{"txgu", "每"},
	{"txh", "第"},
	{"txht", "第"},
	{"txi", "系"},
	{"txiu", "系"},
	{"txty", "後"},
	{"txxf", "筚"},
	{"txxn", "秕"},
	{"ty", "入"},
	{"tyb", "篱"},
	{"tybc", "篱"},
	{"tyg", "往"},
	{"tygg", "往"},
	{"tyi", "入"},
	{"tyiu", "汆"},
	{"tyke", "穰"},
	{"tym", "稿"},
	{"tymk", "篙 稿"},
	{"tyn", "彷"},
	{"tyna", "篇"},
	{"tynx", "簏"},
	{"tyou", "籴"},
	{"tyt", "簇"},
	{"tytd", "簇"},
	{"tyve", "稂"},
	{"u", "产"},
	{"ua", "并"},
	{"uafd", "疳"},
	{"uag", "瓶"},
	{"uagd", "疟"},
	{"uagn", "瓶"},
	{"uai", "冻"},
	{"uaiy", "冻"},
	{"uaj", "并"},
	{"uajd", "瘼"},
	{"uakg", "阈"},
	{"uamw", "癀"},
	{"uap", "迸"},
	{"uapk", "迸"},
	{"uapl", "痨"},
	{"uaw", "瘩"},
	{"uawk", "瘩"},
	{"ub", "闻"},
	{"ubd", "闻"},
	{"ubk", "疗 疖"},
	{"ubqn", "瘾"},
	{"ubt", "逆"},
	{"ubte", "朔"},
	{"ubtf", "塑"},
	{"ubtg", "癃"},
	{"ubtp", "逆"},
	{"ubts", "槊"},
	{"uc", "冯"},
	{"uca", "痉"},
	{"ucad", "痉"},
	{"ucd", "闯"},
	{"uce", "痛"},
	{"ucek", "痛"},
	{"uceu", "衮"},
	{"ucg", "冯"},
	{"ucjn", "羯"},
	{"uck", "冶"},
	{"uckg", "冶"},
	{"ucnv", "疠"},
	{"ucqb", "兖"},
	{"ucv", "疤"},
	{"ucw", "竣"},
	{"ucwt", "竣"},
	{"ucwy", "瘫"},
	{"ucyj", "瘙"},
	{"ud", "关"},
	{"uda", "差"},
	{"udaf", "差"},
	{"udb", "郑"},
	{"udbb", "卷"},
	{"udbh", "郑"},
	{"udca", "羟"},
	{"udci", "闳"},
	{"udct", "羧"},
	{"udd", "闫"},
	{"ude", "豢"},
	{"udeu", "豢"},
	{"udg", "减"},
	{"udgt", "减"},
	{"udh", "着"},
	{"udhf", "眷 着"},
	{"udhn", "瘛"},
	{"udi", "头"},
	{"udj", "羊"},
	{"udjd", "痱"},
	{"udjh", "判"},
	{"udjn", "阉"},
	{"udlv", "疬"},
	{"udmo", "羰"},
	{"udn", "羞"},
	{"udnb", "羌"},
	{"udnf", "羞"},
	{"udng", "翔"},
	{"udnv", "疣"},
	{"udp", "送"},
	{"udpi", "送 闼"},
	{"udqg", "鲞"},
	{"udqy", "羝"},
	{"udr", "拳"},
	{"udrc", "叛"},
	{"udrj", "拳"},
	{"udsu", "桊"},
	{"udu", "关"},
	{"udub", "鄯"},
	{"uduk", "善"},
	{"udv", "券"},
	{"udvb", "券"},
	{"udw", "凑"},
	{"udwc", "羚"},
	{"udwd", "凑"},
	{"udy", "状"},
	{"udyf", "誊"},
	{"udyj", "养"},
	{"ue", "前"},
	{"ueg", "疽"},
	{"uegd", "疽"},
	{"uej", "前"},
	{"uejj", "前"},
	{"uejn", "翦"},
	{"uejo", "煎"},
	{"uejv", "剪"},
	{"uek", "痈"},
	{"uem", "毅"},
	{"uemc", "毅"},
	{"uep", "遂"},
	{"uepc", "阌"},
	{"uepi", "遂"},
	{"ueyi", "瘃"},
	{"uf", "半"},
	{"ufcl", "阖"},
	{"uff", "兰"},
	{"uffd", "闺"},
	{"uffi", "痔"},
	{"ufg", "壮"},
	{"ufhm", "癫"},
	{"ufhw", "阗"},
	{"ufk", "半 斗"},
	{"ufnh", "闱"},
	{"ufni", "痣"},
	{"uft", "闭"},
	{"ufte", "闭"},
	{"ufw", "凌"},
	{"ufwt", "凌"},
	{"ufy", "装"},
	{"ufye", "装"},
	{"ug", "闰"},
	{"ugd", "闰 闩"},
	{"ugdu", "美"},
	{"uge", "靖"},
	{"ugeg", "靖"},
	{"ugh", "症"},
	{"ughd", "症"},
	{"ugi", "痞"},
	{"ugik", "痞"},
	{"ugk", "辣"},
	{"ugkd", "痦"},
	{"ugki", "辣 竦"},
	{"ugkj", "瘌"},
	{"ugkm", "癞"},
	{"ugku", "痘"},
	{"ugl", "盖"},
	{"uglf", "盖"},
	{"ugli", "阑"},
	{"ugm", "病"},
	{"ugmw", "病"},
	{"ugnu", "恙"},
	{"ugo", "羔"},
	{"ugod", "羹"},
	{"ugog", "痖"},
	{"ugou", "羔"},
	{"ugqj", "冽"},
	{"ugtt", "羲"},
	{"ugu", "羡"},
	{"uguf", "瘗"},
	{"uguw", "羡"},
	{"ugv", "姜"},
	{"ugvf", "姜"},
	{"ugvv", "凄"},
	{"ugxg", "冱"},
	{"ugxw", "痍"},
	{"ugyg", "癍"},
	{"uh", "站"},
	{"uhc", "疲"},
	{"uhci", "疲"},
	{"uhdi", "阒"},
	{"uhhy", "癯"},
	{"uhk", "丫 站"},
	{"uhkg", "站"},
	{"uhtt", "夔"},
	{"uhx", "疵"},
	{"uhxv", "疵"},
	{"ui", "冰"},
	{"uife", "冁"},
	{"uiit", "痧"},
	{"uip", "逮"},
	{"uipi", "逮"},
	{"uit", "阔"},
	{"uitd", "阔"},
	{"uiwe", "瘠"},
	{"uiy", "冰"},
	{"uj", "间"},
	{"ujbh", "鄣"},
	{"ujd", "间"},
	{"uje", "彰"},
	{"ujet", "彰"},
	{"ujf", "音"},
	{"ujfb", "郸"},
	{"ujff", "童"},
	{"ujfj", "单"},
	{"ujgd", "疸"},
	{"uji", "闽"},
	{"ujj", "章"},
	{"ujjd", "阊"},
	{"ujl", "瘟"},
	{"ujld", "瘟"},
	{"ujn", "意"},
	{"ujnu", "意"},
	{"ujq", "竟"},
	{"ujqb", "竟"},
	{"ujqn", "竭"},
	{"ujqu", "韵"},
	{"ujqw", "歆"},
	{"ujt", "赣"},
	{"ujtm", "赣"},
	{"ujtn", "戆"},
	{"ujv", "韶"},
	{"ujvk", "韶"},
	{"uk", "部"},
	{"ukb", "部"},
	{"ukbh", "部"},
	{"ukd", "问"},
	{"ukgn", "瓿"},
	{"ukh", "冲"},
	{"ukhh", "冲"},
	{"ukj", "剖"},
	{"ukjh", "剖"},
	{"ukk", "癌"},
	{"ukkd", "闾"},
	{"ukkm", "癌"},
	{"ukn", "总"},
	{"uknu", "总"},
	{"ukq", "况"},
	{"ukqb", "兑 竞"},
	{"ukqn", "况"},
	{"ul", "曾"},
	{"uldd", "痼"},
	{"ulg", "兽"},
	{"ulgj", "痹"},
	{"ulgk", "兽"},
	{"ulj", "曾"},
	{"uljf", "曾"},
	{"uljn", "甑"},
	{"ulk", "闸"},
	{"ulkd", "痂"},
	{"ulkw", "瘸"},
	{"ulsi", "阃"},
	{"ulxi", "瘰"},
	{"um", "商"},
	{"umc", "疫"},
	{"umci", "疫"},
	{"umdj", "端"},
	{"umf", "凋"},
	{"umfk", "凋"},
	{"umi", "敝"},
	{"umia", "弊"},
	{"umig", "鳖"},
	{"umih", "瞥 蹩"},
	{"umin", "憋"},
	{"umit", "敝"},
	{"umk", "疝"},
	{"ummv", "瘿"},
	{"umq", "疯"},
	{"umqi", "疯"},
	{"umqy", "飒"},
	{"umw", "商"},
	{"umwk", "商"},
	{"un", "决"},
	{"unac", "癜"},
	{"unbt", "阚"},
	{"ung", "翊"},
	{"unhc", "瘕"},
	{"uni", "闷"},
	{"unku", "癖"},
	{"unr", "疡"},
	{"unre", "疡"},
	{"unw", "决"},
	{"unwe", "瘳"},
	{"unwy", "决"},
	{"uo", "普"},
	{"uog", "普"},
	{"uogj", "普"},
	{"uoo", "痰"},
	{"uooi", "痰"},
	{"uovd", "瘘"},
	{"up", "帝"},
	{"upm", "帝"},
	{"upmh", "帝"},
	{"upmk", "啻"},
	{"upy", "旁"},
	{"upyb", "旁"},
	{"uq", "交"},
	{"uqaj", "阍"},
	{"uqb", "郊"},
	{"uqbh", "郊"},
	{"uqd", "奖"},
	{"uqdu", "奖"},
	{"uqf", "将"},
	{"uqfy", "将"},
	{"uqg", "癣"},
	{"uqgd", "癣"},
	{"uqi", "浆"},
	{"uqiu", "浆"},
	{"uqjn", "阄"},
	{"uqm", "痪"},
	{"uqmd", "痪"},
	{"uqnv", "疱"},
	{"uqs", "桨"},
	{"uqsg", "酱"},
	{"uqsu", "桨"},
	{"uqt", "效"},
	{"uqty", "效"},
	{"uqu", "交"},
	{"uqv", "净"},
	{"uqvd", "阎"},
	{"uqvh", "净"},
	{"uqw", "次"},
	{"uqwk", "咨"},
	{"uqwl", "盗"},
	{"uqwm", "资"},
	{"uqwn", "瓷 恣"},
	{"uqwo", "粢"},
	{"uqwv", "姿"},
	{"uqwy", "次"},
	{"uqy", "疚"},
	{"uqyi", "疚"},
	{"uqyl", "瘤"},
	{"ur", "瓣"},
	{"urc", "瓣"},
	{"urcu", "瓣"},
	{"us", "亲"},
	{"usfi", "瘭"},
	{"usg", "尊"},
	{"usgd", "奠 猷"},
	{"usgf", "酋 尊"},
	{"usgp", "遒 遵"},
	{"usi", "闲"},
	{"usk", "疔"},
	{"uskd", "疴"},
	{"usqg", "鹇"},
	{"usr", "新"},
	{"usrh", "新"},
	{"usu", "亲"},
	{"uswc", "凇"},
	{"ut", "产"},
	{"utd", "疾"},
	{"utdi", "疾"},
	{"utdk", "痴"},
	{"ute", "产"},
	{"utec", "瘢"},
	{"utem", "颜"},
	{"uter", "彦"},
	{"utfq", "冼"},
	{"uth", "首"},
	{"uthf", "首 痄"},
	{"uthg", "馘"},
	{"uthp", "道"},
	{"uthx", "瘪"},
	{"utj", "痢"},
	{"utjk", "痢"},
	{"utk", "阁"},
	{"utkb", "郡"},
	{"utkd", "阁"},
	{"utn", "疙"},
	{"utnv", "疙"},
	{"utu", "疼"},
	{"utui", "疼"},
	{"utvd", "痿"},
	{"uu", "立"},
	{"uubw", "阙"},
	{"uud", "痒"},
	{"uuda", "瘥"},
	{"uudk", "痒"},
	{"uuj", "阐"},
	{"uujf", "阐 瘅"},
	{"uujk", "瘴"},
	{"uujn", "癔"},
	{"uuk", "阅"},
	{"uukq", "阅"},
	{"uusi", "痫"},
	{"uuu", "立"},
	{"uuuu", "立"},
	{"uv", "妆"},
	{"uve", "痕"},
	{"uvei", "痕"},
	{"uvf", "妾"},
	{"uvg", "妆"},
	{"uvh", "瘦"},
	{"uvhc", "瘦"},
	{"uvo", "兼"},
	{"uvog", "鹣"},
	{"uvou", "兼"},
	{"uvow", "歉"},
	{"uvqv", "阋"},
	{"uvwi", "瘐"},
	{"uw", "闪"},
	{"uwa", "阀"},
	{"uwae", "阀"},
	{"uwb", "疮"},
	{"uwbv", "疮"},
	{"uwe", "疹"},
	{"uwee", "疹"},
	{"uwfi", "瘵"},
	{"uwg", "痊"},
	{"uwgd", "痊 阕"},
	{"uwi", "闪"},
	{"uwj", "疥"},
	{"uwjk", "疥"},
	{"uwl", "益"},
	{"uwlf", "益"},
	{"uwlj", "蠲"},
	{"uwnd", "瘊"},
	{"uwsi", "庥"},
	{"uwwf", "痤"},
	{"uwy", "准"},
	{"uwyc", "冷"},
	{"uwyg", "准"},
	{"ux", "北"},
	{"uxbh", "邶"},
	{"uxe", "背"},
	{"uxef", "背"},
	{"uxh", "弟"},
	{"uxhg", "鹈"},
	{"uxhj", "剃"},
	{"uxhp", "递"},
	{"uxht", "弟"},
	{"uxl", "冀"},
	{"uxlw", "冀"},
	{"uxn", "北"},
	{"uxt", "凝"},
	{"uxth", "凝"},
	{"uxu", "辫"},
	{"uxuh", "辫"},
	{"uxx", "兹"},
	{"uxxb", "孳"},
	{"uxxg", "鹚"},
	{"uxxn", "慈"},
	{"uxxu", "兹"},
	{"uy", "六"},
	{"uyg", "冫"},
	{"uygd", "疰"},
	{"uygg", "疒"},
	{"uygh", "辛 丬"},
	{"uygy", "六"},
	{"uyh", "门"},
	{"uyhn", "门"},
	{"uyi", "闵"},
	{"uyiy", "凉"},
	{"uyl", "凛"},
	{"uyli", "凛"},
	{"uym", "闹"},
	{"uymh", "闹"},
	{"uymv", "闶"},
	{"uyn", "阂"},
	{"uynw", "阂"},
	{"uyt", "辨"},
	{"uytu", "辨"},
	{"uyu", "辩"},
	{"uyuh", "辩"},
	{"uyve", "阆"},
	{"uyw", "瘁"},
	{"uywf", "瘁"},
	{"uywu", "阏 瘀"},
	{"uyxi", "痃"},
	{"v", "发"},
	{"va", "毁"},
	{"vaf", "媒"},
	{"vafs", "媒"},
	{"vah", "姬"},
	{"vahh", "姬"},
	{"vaj", "舁"},
	{"vajd", "嫫"},
	{"vam", "毁"},
	{"vamc", "毁"},
	{"vaqy", "妪"},
	{"vatq", "娆"},
	{"vb", "好"},
	{"vbg", "好"},
	{"vbhj", "媸"},
	{"vbn", "她"},
	{"vbsk", "婀"},
	{"vc", "妈"},
	{"vca", "既"},
	{"vcag", "暨"},
	{"vcaq", "既"},
	{"vcb", "即"},
	{"vcbf", "孥"},
	{"vcbh", "即 妤"},
	{"vccf", "驽"},
	{"vcg", "妈"},
	{"vck", "始"},
	{"vckg", "始"},
	{"vcl", "努"},
	{"vclb", "努"},
	{"vcmh", "帑"},
	{"vcmw", "胬"},
	{"vcn", "怒"},
	{"vcnu", "怒"},
	{"vcxb", "弩"},
	{"vcy", "奴"},
	{"vd", "姑"},
	{"vdf", "娠"},
	{"vdfe", "娠"},
	{"vdg", "姑"},
	{"vef", "垦"},
	{"vefc", "媛"},
	{"veff", "垦"},
	{"veg", "姐"},
	{"vegg", "姐"},
	{"vei", "艮"},
	{"ven", "奶"},
	{"venu", "恳"},
	{"vep", "退"},
	{"vepc", "嫒"},
	{"vepi", "退"},
	{"vf", "寻"},
	{"vfb", "那"},
	{"vfbh", "那"},
	{"vfc", "妓"},
	{"vfcy", "妓"},
	{"vff", "娃"},
	{"vffg", "娃"},
	{"vfh", "奸"},
	{"vfhk", "聿"},
	{"vfhp", "建"},
	{"vfi", "妹"},
	{"vfiy", "妹"},
	{"vfjf", "媾"},
	{"vfkk", "嬉"},
	{"vfqn", "妩"},
	{"vfsh", "孀"},
	{"vft", "姥"},
	{"vftx", "姥"},
	{"vfu", "寻"},
	{"vfuk", "嫱"},
	{"vg", "姨"},
	{"vgah", "妍"},
	{"vgeg", "婧"},
	{"vgey", "婊"},
	{"vgho", "嫣"},
	{"vgk", "嫩"},
	{"vgkt", "嫩"},
	{"vgog", "娅"},
	{"vgvh", "婕"},
	{"vgx", "姨"},
	{"vgxw", "姨"},
	{"vhcu", "叟"},
	{"vhk", "肀"},
	{"vi", "录"},
	{"vii", "隶"},
	{"vij", "肃"},
	{"vijh", "剥"},
	{"vijk", "肃"},
	{"viph", "嫦"},
	{"vipi", "逯"},
	{"viq", "姚"},
	{"viqn", "姚"},
	{"vit", "妙"},
	{"vitt", "妙"},
	{"viu", "录"},
	{"vj", "旭"},
	{"vjd", "旭"},
	{"vjf", "旮"},
	{"vjfg", "娌"},
	{"vjgg", "妲"},
	{"vjjg", "娼"},
	{"vjlg", "媪"},
	{"vjs", "巢"},
	{"vjsj", "剿"},
	{"vjsu", "巢"},
	{"vk", "如"},
	{"vkb", "邵"},
	{"vkbh", "邵"},
	{"vkcb", "邕"},
	{"vke", "娟"},
	{"vkeg", "娟"},
	{"vkf", "召"},
	{"vkg", "如"},
	{"vkgd", "娱"},
	{"vkln", "劭"},
	{"vkmw", "娲"},
	{"vkn", "恕"},
	{"vknu", "恕"},
	{"vkp", "迢"},
	{"vkpd", "迢"},
	{"vkx", "絮"},
	{"vkxi", "絮"},
	{"vl", "舅"},
	{"vld", "姻"},
	{"vldy", "姻"},
	{"vlf", "甾"},
	{"vll", "舅"},
	{"vllb", "舅"},
	{"vlqp", "邋"},
	{"vlxi", "嫘"},
	{"vmg", "妯"},
	{"vmgn", "娉"},
	{"vmmg", "姗"},
	{"vn", "刀"},
	{"vnfg", "妞"},
	{"vngg", "彐"},
	{"vnh", "媚"},
	{"vnhe", "婿"},
	{"vnhg", "媚"},
	{"vnn", "妃"},
	{"vnnn", "巛"},
	{"vnt", "刀"},
	{"vntn", "娓"},
	{"vnu", "鼠"},
	{"vnud", "鼷"},
	{"vnuk", "鼯"},
	{"vnum", "鼬"},
	{"vnun", "鼠"},
	{"vnuv", "鼢 鼹"},
	{"vnx", "妮"},
	{"vnxn", "妮"},
	{"vnyw", "姒"},
	{"vo", "灵"},
	{"vou", "灵"},
	{"vp", "巡"},
	{"vpe", "嫁"},
	{"vpey", "嫁"},
	{"vpj", "婶"},
	{"vpjh", "婶"},
	{"vpm", "帚"},
	{"vpmh", "帚"},
	{"vpq", "婉"},
	{"vpqb", "婉"},
	{"vprw", "嫔"},
	{"vpta", "姹"},
	{"vpv", "巡"},
	{"vq", "婚"},
	{"vqa", "婚"},
	{"vqaj", "婚"},
	{"vqk", "娩"},
	{"vqkq", "娩"},
	{"vqou", "舄"},
	{"vqyg", "鸠"},
	{"vqyy", "妁"},
	{"vriy", "姝"},
	{"vrtf", "婢"},
	{"vs", "杂"},
	{"vsfi", "嫖"},
	{"vsu", "杂"},
	{"vt", "九"},
	{"vtd", "妖"},
	{"vtdj", "娇"},
	{"vtdy", "妖"},
	{"vte", "尹"},
	{"vtf", "妊"},
	{"vtfg", "妊"},
	{"vtg", "姓"},
	{"vtgg", "姓"},
	{"vth", "臼"},
	{"vthg", "臼"},
	{"vthn", "媳"},
	{"vtk", "群"},
	{"vtkd", "君 群"},
	{"vtlx", "媲"},
	{"vtn", "九"},
	{"vtnt", "姊"},
	{"vtr", "娥"},
	{"vtrt", "娥"},
	{"vu", "嫌"},
	{"vuah", "姘"},
	{"vujf", "婵"},
	{"vujh", "嫜"},
	{"vum", "嫡"},
	{"vumd", "嫡"},
	{"vuqy", "姣"},
	{"vusy", "娴"},
	{"vut", "嫉"},
	{"vutd", "嫉"},
	{"vuth", "馗"},
	{"vuv", "嫌"},
	{"vuvo", "嫌"},
	{"vuxt", "娣"},
	{"vv", "妇"},
	{"vvf", "娜"},
	{"vvfb", "娜"},
	{"vvg", "妇"},
	{"vvh", "嫂"},
	{"vvhc", "嫂"},
	{"vvv", "女"},
	{"vvvv", "女"},
	{"vwi", "臾"},
	{"vwyn", "妗"},
	{"vx", "姆"},
	{"vxg", "姆"},
	{"vxgu", "姆"},
	{"vxxn", "妣"},
	{"vy", "妨"},
	{"vyi", "刃 丸"},
	{"vylg", "嬗"},
	{"vyly", "妫"},
	{"vyn", "妨"},
	{"vynt", "妒"},
	{"vynu", "忍"},
	{"vyps", "婷"},
	{"vysc", "嬷"},
	{"vyv", "娘"},
	{"vyve", "娘"},
	{"w", "人"},
	{"wa", "代"},
	{"wadk", "偌"},
	{"waf", "仝"},
	{"waff", "垡"},
	{"waht", "伢"},
	{"waj", "借"},
	{"wajg", "借"},
	{"wajv", "偃"},
	{"walo", "黛"},
	{"wam", "贷"},
	{"wamj", "岱"},
	{"wamu", "贷"},
	{"waqj", "僭"},
	{"waqt", "儆"},
	{"waqy", "伛"},
	{"warh", "牮"},
	{"wat", "伐"},
	{"watq", "侥"},
	{"waw", "供"},
	{"wawy", "供"},
	{"way", "代"},
	{"waye", "袋"},
	{"wb", "他"},
	{"wbat", "戗"},
	{"wbb", "仓"},
	{"wbg", "佴 仔"},
	{"wbj", "创"},
	{"wbjh", "创"},
	{"wbn", "他"},
	{"wc", "公"},
	{"wcd", "颂"},
	{"wcdm", "颂"},
	{"wceh", "俑"},
	{"wcg", "瓮"},
	{"wcgn", "瓮"},
	{"wcn", "翁"},
	{"wcnf", "翁"},
	{"wcrh", "侔"},
	{"wctd", "俟"},
	{"wcu", "公"},
	{"wcw", "俊"},
	{"wcwt", "俊"},
	{"wcwy", "傩"},
	{"wcy", "仅"},
	{"wd", "估"},
	{"wda", "佐"},
	{"wdag", "佐"},
	{"wdeg", "侑"},
	{"wdfn", "侉"},
	{"wdg", "仨 估"},
	{"wdj", "佰"},
	{"wdjd", "俳"},
	{"wdjg", "佰"},
	{"wdjn", "俺"},
	{"wdk", "佑"},
	{"wdkg", "佑"},
	{"wdm", "段"},
	{"wdmc", "段"},
	{"wdn", "优"},
	{"wdnn", "优"},
	{"wds", "倚"},
	{"wdsk", "倚"},
	{"wdt", "做"},
	{"wdtf", "俦"},
	{"wdty", "做"},
	{"wdu", "僚"},
	{"wdui", "僚"},
	{"wdw", "傣"},
	{"wdwh", "俸"},
	{"wdwi", "傣"},
	{"wdy", "伏"},
	{"wdyy", "仗"},
	{"we", "仍"},
	{"web", "俘"},
	{"webg", "俘"},
	{"wen", "仍 佣"},
	{"wf", "会"},
	{"wfam", "偾"},
	{"wfc", "会"},
	{"wfcb", "郐"},
	{"wfcj", "刽"},
	{"wfcu", "会"},
	{"wfcy", "伎"},
	{"wfd", "儒"},
	{"wfdj", "儒"},
	{"wff", "侍"},
	{"wffg", "佳"},
	{"wffy", "侍"},
	{"wfg", "仁 仕"},
	{"wfh", "什"},
	{"wfhg", "值"},
	{"wfi", "祭"},
	{"wfil", "畲"},
	{"wfiu", "佘 祭"},
	{"wfiy", "俅"},
	{"wfk", "舍"},
	{"wfkb", "舒"},
	{"wfkf", "舍"},
	{"wfkg", "佶"},
	{"wfkk", "僖"},
	{"wfl", "舆"},
	{"wflw", "舆"},
	{"wfmo", "爨"},
	{"wfmy", "璺"},
	{"wfn", "伟"},
	{"wfnh", "伟"},
	{"wfny", "传"},
	{"wft", "佬"},
	{"wftx", "佬"},
	{"wfvg", "佞"},
	{"wfy", "付"},
	{"wg", "全"},
	{"wgc", "倒"},
	{"wgcf", "侄"},
	{"wgcj", "倒"},
	{"wgd", "癸"},
	{"wgdu", "癸"},
	{"wge", "傅"},
	{"wgef", "傅"},
	{"wgeg", "倩"},
	{"wgej", "俞"},
	{"wgen", "毹 愈"},
	{"wgep", "逾"},
	{"wgeq", "觎"},
	{"wgf", "全"},
	{"wgg", "伍"},
	{"wgi", "剑"},
	{"wgif", "佥"},
	{"wgij", "剑"},
	{"wgit", "敛"},
	{"wgj", "便"},
	{"wgjq", "便"},
	{"wgk", "合"},
	{"wgka", "龠"},
	{"wgkb", "命"},
	{"wgkf", "合"},
	{"wgkg", "鸽"},
	{"wgkl", "盒"},
	{"wgkm", "凳 颌"},
	{"wgkn", "翕"},
	{"wgkq", "使"},
	{"wgkr", "拿"},
	{"wgku", "登"},
	{"wgkw", "歙"},
	{"wgkx", "龛"},
	{"wgl", "僵"},
	{"wglg", "僵"},
	{"wgm", "俩"},
	{"wgmw", "俩"},
	{"wgmy", "俪 债"},
	{"wgnb", "兮"},
	{"wgnn", "佤"},
	{"wgod", "俨"},
	{"wgq", "例"},
	{"wgqj", "例"},
	{"wgqt", "傲"},
	{"wgu", "侠"},
	{"wguw", "侠"},
	{"wh", "个"},
	{"whf", "企"},
	{"whhy", "佧"},
	{"whj", "个"},
	{"whjh", "倬"},
	{"whm", "侦"},
	{"whmy", "侦"},
	{"whn", "候"},
	{"whnd", "候"},
	{"wht", "修"},
	{"whtd", "倏"},
	{"whte", "修"},
	{"whtn", "悠"},
	{"whty", "攸"},
	{"whw", "俱"},
	{"whwy", "俱"},
	{"why", "仆"},
	{"wi", "偿"},
	{"wie", "俏"},
	{"wieg", "俏"},
	{"wim", "倘"},
	{"wimk", "倘"},
	{"wioj", "劁"},
	{"wip", "偿"},
	{"wipc", "偿"},
	{"wipq", "傥"},
	{"wiqn", "佻"},
	{"wiu", "氽"},
	{"wj", "介"},
	{"wjfg", "俚"},
	{"wjg", "但"},
	{"wjgg", "但"},
	{"wjh", "伸"},
	{"wjhh", "伸"},
	{"wjj", "介"},
	{"wjjg", "倡"},
	{"wjm", "偶"},
	{"wjmy", "偶"},
	{"wjqn", "偈"},
	{"wjsy", "倮"},
	{"wk", "保"},
	{"wkgd", "俣"},
	{"wkh", "促"},
	{"wkhh", "仲"},
	{"wkhy", "促"},
	{"wkk", "侣"},
	{"wkkg", "侣"},
	{"wkqn", "侃"},
	{"wks", "保"},
	{"wksf", "堡"},
	{"wkso", "煲"},
	{"wksy", "保"},
	{"wl", "佃"},
	{"wlg", "佃"},
	{"wlge", "偎 儇"},
	{"wlkg", "伽"},
	{"wll", "儡"},
	{"wlll", "儡"},
	{"wln", "仂"},
	{"wmfk", "倜"},
	{"wmg", "佩"},
	{"wmgh", "佩"},
	{"wmgk", "侗"},
	{"wmgn", "俜"},
	{"wmh", "仙"},
	{"wmj", "侧"},
	{"wmjh", "侧"},
	{"wmn", "仉"},
	{"wmw", "催"},
	{"wmwy", "催"},
	{"wn", "亿"},
	{"wnb", "倔"},
	{"wnbm", "倔"},
	{"wndg", "倨"},
	{"wng", "伺"},
	{"wngk", "伺"},
	{"wnh", "假"},
	{"wnhc", "假"},
	{"wnk", "僻"},
	{"wnku", "僻"},
	{"wnn", "亿"},
	{"wnnf", "阜"},
	{"wnnp", "追"},
	{"wnt", "侯"},
	{"wntd", "侯"},
	{"wnxn", "伲"},
	{"wny", "似"},
	{"wnyw", "似"},
	{"wo", "伙"},
	{"wovg", "偻"},
	{"woy", "伙"},
	{"wpey", "侬"},
	{"wpgg", "伫"},
	{"wpnn", "倌"},
	{"wprw", "傧"},
	{"wpwa", "倥"},
	{"wpxn", "佗"},
	{"wq", "你"},
	{"wqa", "低"},
	{"wqay", "低"},
	{"wqb", "爷"},
	{"wqbh", "仰"},
	{"wqbj", "爷"},
	{"wqc", "爸"},
	{"wqcb", "爸"},
	{"wqdy", "儋"},
	{"wqf", "釜"},
	{"wqfu", "釜"},
	{"wqi", "你"},
	{"wqin", "您"},
	{"wqiy", "你"},
	{"wqj", "像"},
	{"wqje", "像"},
	{"wqq", "侈"},
	{"wqqq", "爹"},
	{"wqqy", "侈"},
	{"wqr", "斧"},
	{"wqrj", "斧"},
	{"wqrn", "偬"},
	{"wqu", "父"},
	{"wr", "伯"},
	{"wrg", "伯"},
	{"wrh", "件"},
	{"wrhh", "件"},
	{"wriy", "侏"},
	{"wrq", "傀"},
	{"wrqc", "傀"},
	{"wrtf", "俾"},
	{"wrwy", "佚"},
	{"ws", "休"},
	{"wsg", "体"},
	{"wsgg", "体"},
	{"wsh", "仃"},
	{"wsk", "何"},
	{"wskg", "何"},
	{"wso", "僳"},
	{"wsoy", "僳"},
	{"wsqg", "鸺"},
	{"wss", "傈"},
	{"wssy", "傈"},
	{"wsy", "休"},
	{"wt", "作"},
	{"wtay", "伥"},
	{"wtc", "叙"},
	{"wtcy", "仫 叙"},
	{"wtd", "侨"},
	{"wtdj", "侨"},
	{"wtf", "任"},
	{"wtfg", "任"},
	{"wtfh", "仵 仟"},
	{"wtfm", "赁 凭"},
	{"wtfn", "恁"},
	{"wth", "亻 作"},
	{"wthf", "作"},
	{"wtj", "俐"},
	{"wtjh", "俐"},
	{"wtl", "伤"},
	{"wtln", "伤"},
	{"wtlt", "傻"},
	{"wtnn", "仡"},
	{"wtp", "途"},
	{"wtpi", "途"},
	{"wtr", "俄"},
	{"wtrt", "俄"},
	{"wtu", "余"},
	{"wtuf", "斜"},
	{"wtuy", "佟"},
	{"wtvg", "倭"},
	{"wtx", "侮"},
	{"wtxu", "侮"},
	{"wty", "八"},
	{"wu", "们"},
	{"wud", "倦"},
	{"wudb", "倦"},
	{"wudh", "佯"},
	{"wuf", "伴"},
	{"wufh", "伴"},
	{"wug", "位"},
	{"wuh", "伞"},
	{"wuhj", "伞"},
	{"wujf", "僮"},
	{"wuk", "倍"},
	{"wul", "僧"},
	{"wulj", "僧"},
	{"wun", "们"},
	{"wup", "傍"},
	{"wupy", "傍"},
	{"wuqy", "佼"},
	{"wv", "分"},
	{"wvb", "分"},
	{"wvd", "颁"},
	{"wvdm", "颁"},
	{"wvf", "健"},
	{"wvff", "坌"},
	{"wvfp", "健"},
	{"wvl", "盆"},
	{"wvlf", "盆"},
	{"wvm", "贫"},
	{"wvmj", "岔"},
	{"wvmu", "贫"},
	{"wvn", "仇"},
	{"wvnu", "忿"},
	{"wvp", "侵"},
	{"wvpc", "侵"},
	{"wvq", "倪"},
	{"wvqn", "倪"},
	{"wvt", "伊"},
	{"wvtt", "伊"},
	{"wvyy", "仞"},
	{"ww", "从"},
	{"wwb", "耸"},
	{"wwbf", "耸"},
	{"wwbn", "伧"},
	{"wweg", "佾 俎"},
	{"wwf", "坐"},
	{"wwfc", "侩"},
	{"wwff", "坐"},
	{"wwfi", "傺"},
	{"wwg", "丛"},
	{"wwgf", "丛"},
	{"wwgi", "俭"},
	{"wwgj", "偷"},
	{"wwj", "价"},
	{"wwjh", "价"},
	{"wwk", "谷"},
	{"wwkf", "谷"},
	{"wwkg", "鹆"},
	{"wwkw", "欲"},
	{"wwn", "怂"},
	{"wwnu", "怂"},
	{"wwv", "份"},
	{"wwvn", "份"},
	{"www", "众"},
	{"wwwk", "俗"},
	{"wwwu", "众"},
	{"wwww", "人"},
	{"wwx", "伦"},
	{"wwxn", "伦"},
	{"wwy", "从"},
	{"wwyc", "伶"},
	{"wwyo", "僬"},
	{"wx", "化"},
	{"wxb", "仑"},
	{"wxd", "倾"},
	{"wxdm", "倾"},
	{"wxf", "华"},
	{"wxfj", "华"},
	{"wxj", "佛"},
	{"wxjh", "佛"},
	{"wxm", "货"},
	{"wxmu", "货"},
	{"wxn", "化"},
	{"wxxn", "仳"},
	{"wxxr", "偕"},
	{"wy", "信"},
	{"wyb", "禽"},
	{"wybc", "禽"},
	{"wyc", "令"},
	{"wycb", "邻"},
	{"wycm", "领"},
	{"wycn", "瓴 翎"},
	{"wycu", "令"},
	{"wye", "依"},
	{"wyeb", "隽"},
	{"wyey", "依"},
	{"wyf", "储"},
	{"wyfj", "储"},
	{"wyg", "信 隹"},
	{"wygg", "住"},
	{"wyin", "僦"},
	{"wyjh", "侪"},
	{"wyk", "售"},
	{"wykf", "售"},
	{"wyl", "伪"},
	{"wyly", "伪"},
	{"wymn", "伉"},
	{"wyn", "仿"},
	{"wyna", "偏"},
	{"wynb", "今"},
	{"wyne", "衾"},
	{"wynk", "含"},
	{"wynm", "贪 颔"},
	{"wynn", "念"},
	{"wyo", "焦"},
	{"wyog", "鹪"},
	{"wyou", "焦"},
	{"wyp", "停"},
	{"wyps", "停"},
	{"wyq", "仪"},
	{"wyqy", "仪"},
	{"wys", "集"},
	{"wysu", "集"},
	{"wyv", "食"},
	{"wyve", "食"},
	{"wyw", "俯"},
	{"wywf", "俯"},
	{"wyyy", "雠"},
	{"x", "经"},
	{"xa", "红"},
	{"xad", "绒"},
	{"xadt", "绒"},
	{"xafg", "绀"},
	{"xafh", "缂"},
	{"xag", "红"},
	{"xan", "练"},
	{"xann", "绁"},
	{"xanw", "练"},
	{"xat", "绕"},
	{"xatq", "绕"},
	{"xb", "弛"},
	{"xbg", "弭"},
	{"xbmh", "绌"},
	{"xbn", "弛"},
	{"xc", "经"},
	{"xca", "经"},
	{"xcag", "经 弪"},
	{"xcbh", "纾"},
	{"xcc", "缀"},
	{"xccc", "缀"},
	{"xcf", "绎"},
	{"xcfh", "绎"},
	{"xckg", "绐"},
	{"xcy", "弘"},
	{"xd", "顷"},
	{"xdcy", "绂"},
	{"xde", "毋"},
	{"xdff", "缛"},
	{"xdfn", "绔"},
	{"xdg", "缄"},
	{"xdgt", "缄"},
	{"xdjd", "绯"},
	{"xdjx", "弼"},
	{"xdm", "顷"},
	{"xdmd", "缅"},
	{"xdmy", "顷"},
	{"xdsk", "绮"},
	{"xdt", "绑"},
	{"xdtb", "绑"},
	{"xe", "级"},
	{"xee", "绷"},
	{"xeeg", "绷"},
	{"xef", "缓"},
	{"xefc", "缓"},
	{"xeg", "组"},
	{"xegg", "组"},
	{"xejj", "蠡"},
	{"xepc", "绶"},
	{"xeu", "彖"},
	{"xev", "绥"},
	{"xevg", "绥"},
	{"xey", "级"},
	{"xeyy", "级"},
	{"xf", "结"},
	{"xfcy", "纭"},
	{"xfg", "疆"},
	{"xfgg", "疆"},
	{"xfhw", "缜"},
	{"xfk", "结"},
	{"xfkg", "结"},
	{"xfm", "贯"},
	{"xfmu", "贯"},
	{"xfn", "续"},
	{"xfnd", "续"},
	{"xfnh", "纬"},
	{"xfqg", "鸨"},
	{"xft", "绪"},
	{"xftj", "绪"},
	{"xfwt", "绫"},
	{"xfy", "纣"},
	{"xg", "线"},
	{"xgb", "纯"},
	{"xgbn", "纯"},
	{"xge", "缚"},
	{"xgef", "缚"},
	{"xgfh", "纡"},
	{"xgjq", "绠"},
	{"xgm", "绩"},
	{"xgmy", "绩"},
	{"xgo", "彝"},
	{"xgoa", "彝"},
	{"xgoj", "缙"},
	{"xgt", "线"},
	{"xgu", "母"},
	{"xgui", "母"},
	{"xgxx", "彘"},
	{"xh", "引"},
	{"xhh", "引"},
	{"xhit", "缈"},
	{"xhj", "绰"},
	{"xhjh", "绰"},
	{"xi", "纱"},
	{"xidm", "颍"},
	{"xieg", "绡"},
	{"ximk", "绱"},
	{"xit", "纱"},
	{"xitt", "纱"},
	{"xiu", "糸"},
	{"xj", "旨"},
	{"xjf", "旨"},
	{"xjgh", "缇"},
	{"xjh", "绅"},
	{"xjhh", "绅"},
	{"xjk", "弗"},
	{"xjlc", "缦 缳"},
	{"xjm", "费"},
	{"xjmu", "费"},
	{"xjqc", "艴"},
	{"xjt", "缆"},
	{"xjtq", "缆"},
	{"xjxx", "绲"},
	{"xk", "强"},
	{"xkb", "缉"},
	{"xkbg", "缉"},
	{"xke", "绢"},
	{"xkeg", "绢"},
	{"xkhm", "缋"},
	{"xkj", "强"},
	{"xkjh", "犟"},
	{"xkjn", "绳"},
	{"xkjy", "强"},
	{"xkw", "织"},
	{"xkwy", "织"},
	{"xl", "细"},
	{"xlg", "细"},
	{"xln", "幼"},
	{"xlny", "缌"},
	{"xlxi", "缧 缵"},
	{"xlxk", "辔"},
	{"xm", "纲"},
	{"xmf", "绸"},
	{"xmfk", "绸"},
	{"xmm", "缨"},
	{"xmmv", "缨"},
	{"xmq", "纲"},
	{"xmqy", "纲"},
	{"xmw", "纳"},
	{"xmwy", "纳"},
	{"xn", "纪"},
	{"xnaj", "缗"},
	{"xnf", "纽"},
	{"xnfg", "纽"},
	{"xng", "弓"},
	{"xngn", "弓"},
	{"xnh", "纠"},
	{"xnhh", "纠"},
	{"xnn", "幻 纪"},
	{"xnwe", "缪 幺"},
	{"xo", "继"},
	{"xon", "继"},
	{"xonn", "继"},
	{"xov", "缕"},
	{"xovg", "缕"},
	{"xox", "粥"},
	{"xoxh", "鬻"},
	{"xoxn", "粥"},
	{"xp", "综"},
	{"xpf", "综"},
	{"xpfi", "综"},
	{"xpg", "绽"},
	{"xpgh", "绽"},
	{"xpnn", "绾"},
	{"xprw", "缤 缱"},
	{"xpw", "缩"},
	{"xpwj", "缩"},
	{"xq", "约"},
	{"xqa", "纸"},
	{"xqan", "纸"},
	{"xqc", "绝"},
	{"xqcn", "绝"},
	{"xqi", "弥"},
	{"xqiy", "弥"},
	{"xqj", "绚"},
	{"xqjg", "绚"},
	{"xqvg", "绉"},
	{"xqy", "约"},
	{"xqyy", "约"},
	{"xr", "绵"},
	{"xrc", "弧"},
	{"xrcy", "弧"},
	{"xrm", "绵"},
	{"xrmh", "绵"},
	{"xry", "缴"},
	{"xryt", "缴"},
	{"xsfi", "缥 缲"},
	{"xshg", "缃"},
	{"xt", "张"},
	{"xta", "张"},
	{"xtah", "绛"},
	{"xtay", "张"},
	{"xtd", "颖"},
	{"xtdh", "疑 肄"},
	{"xtdm", "颖"},
	{"xtdp", "缝"},
	{"xte", "乡"},
	{"xten", "绣"},
	{"xtf", "纤"},
	{"xtfh", "纤 绗"},
	{"xtgf", "缍"},
	{"xthk", "绺"},
	{"xtk", "络"},
	{"xtkg", "络"},
	{"xtn", "匕"},
	{"xtnn", "纥"},
	{"xts", "绦"},
	{"xtsy", "绦"},
	{"xtu", "终"},
	{"xtuy", "终"},
	{"xtwe", "飨"},
	{"xu", "弱"},
	{"xud", "缮"},
	{"xudb", "绻"},
	{"xudk", "缮"},
	{"xuf", "绊"},
	{"xufh", "绊"},
	{"xuj", "弹"},
	{"xujf", "弹"},
	{"xup", "缔"},
	{"xuph", "缔"},
	{"xuq", "绞"},
	{"xuqy", "绞"},
	{"xuvo", "缣 缰"},
	{"xuwl", "缢 缯"},
	{"xux", "弱"},
	{"xuxt", "绨"},
	{"xuxu", "弱"},
	{"xv", "绿"},
	{"xvi", "绿"},
	{"xviy", "绿"},
	{"xvjs", "缫"},
	{"xvk", "绍"},
	{"xvkg", "绍"},
	{"xvlg", "缁"},
	{"xvy", "纫"},
	{"xvyy", "纫 纨"},
	{"xw", "给"},
	{"xwd", "缎"},
	{"xwdc", "缎"},
	{"xwf", "绘"},
	{"xwfc", "绘"},
	{"xwg", "给"},
	{"xwgk", "给"},
	{"xwgq", "缏"},
	{"xwnd", "缑"},
	{"xwnp", "缒"},
	{"xwv", "纷"},
	{"xwvn", "纷"},
	{"xww", "纵"},
	{"xwwy", "纵"},
	{"xwx", "纶"},
	{"xwxn", "纶"},
	{"xwy", "维"},
	{"xwyg", "维"},
	{"xx", "比"},
	{"xxal", "畿"},
	{"xxe", "缘"},
	{"xxey", "缘"},
	{"xxf", "毕"},
	{"xxfj", "毕"},
	{"xxg", "丝"},
	{"xxgf", "丝"},
	{"xxgg", "鸶"},
	{"xxgx", "毙"},
	{"xxjh", "绋"},
	{"xxm", "幽"},
	{"xxmk", "幽"},
	{"xxn", "比"},
	{"xxnt", "毖"},
	{"xxr", "皆"},
	{"xxrf", "皆"},
	{"xxxn", "纰"},
	{"xxxx", "纟"},
	{"xy", "纺"},
	{"xybc", "缡 缭"},
	{"xyc", "统"},
	{"xycq", "统"},
	{"xyj", "缠"},
	{"xyjf", "缠"},
	{"xymk", "缟 缬"},
	{"xyn", "纺"},
	{"xyna", "编"},
	{"xyt", "纩"},
	{"xyx", "弦"},
	{"xyxy", "弦"},
	{"xyy", "纹"},
	{"y", "主"},
	{"ya", "度"},
	{"yaa", "试"},
	{"yaag", "试"},
	{"yac", "度"},
	{"yaci", "度"},
	{"yad", "诺"},
	{"yadk", "诺"},
	{"yadn", "谌"},
	{"yaf", "谋"},
	{"yafs", "谋"},
	{"yag", "讧"},
	{"yagg", "诓"},
	{"yagy", "讴"},
	{"yah", "讶"},
	{"yaht", "讶"},
	{"yajd", "谟"},
	{"yak", "谨"},
	{"yakg", "谨 廑"},
	{"yam", "席"},
	{"yamh", "席"},
	{"yan", "谍"},
	{"yang", "讵"},
	{"yans", "谍"},
	{"yany", "庹"},
	{"yao", "庶"},
	{"yaog", "鹧"},
	{"yaoi", "庶"},
	{"yaop", "遮"},
	{"yaqj", "谮"},
	{"yaw", "诬"},
	{"yaww", "诬"},
	{"yay", "谎"},
	{"yayq", "谎"},
	{"yb", "离"},
	{"ybb", "郭"},
	{"ybbh", "郭"},
	{"ybcy", "诹"},
	{"ybf", "享"},
	{"ybh", "邝 邡"},
	{"ybj", "亨"},
	{"ybm", "离"},
	{"ybmc", "离"},
	{"ybmh", "诎"},
	{"ybo", "烹"},
	{"ybou", "烹"},
	{"ybqg", "鹑"},
	{"ybt", "敦"},
	{"ybtn", "憝"},
	{"ybty", "敦"},
	{"ybv", "熟"},
	{"ybvf", "塾"},
	{"ybvo", "熟"},
	{"ybvy", "孰"},
	{"yc", "充"},
	{"yca", "弃"},
	{"ycaj", "弃"},
	{"ycb", "序"},
	{"ycbe", "袤"},
	{"ycbk", "序 谲"},
	{"yce", "育"},
	{"ycef", "育"},
	{"yceh", "诵"},
	{"ycf", "译"},
	{"ycfh", "译"},
	{"yckg", "诒"},
	{"ycq", "充"},
	{"ycqb", "充"},
	{"yctd", "诶"},
	{"yd", "庆"},
	{"ydg", "诂"},
	{"ydi", "庆"},
	{"ydiy", "诔"},
	{"ydj", "诽"},
	{"ydjd", "诽"},
	{"ydjj", "齑"},
	{"ydjn", "庵"},
	{"ydm", "斋"},
	{"ydmj", "斋"},
	{"ydn", "诚"},
	{"ydnt", "诚"},
	{"ydoy", "诙"},
	{"ydx", "庞"},
	{"ydxv", "庞"},
	{"ye", "衣"},
	{"yefc", "谖"},
	{"yeg", "诅"},
	{"yegg", "诅"},
	{"yem", "裔"},
	{"yemk", "裔"},
	{"yer", "谣"},
	{"yerm", "谣"},
	{"yet", "夜"},
	{"yety", "夜"},
	{"yeu", "哀 衣"},
	{"yeyy", "诼"},
	{"yf", "计"},
	{"yfci", "庋"},
	{"yfd", "庄"},
	{"yff", "诗"},
	{"yffg", "诖"},
	{"yffy", "诗"},
	{"yfh", "讦 计"},
	{"yfj", "讲"},
	{"yfjh", "讲"},
	{"yfkg", "诘"},
	{"yfmd", "谳"},
	{"yfn", "读"},
	{"yfnd", "读"},
	{"yfnh", "讳"},
	{"yfqv", "庑"},
	{"yft", "诸"},
	{"yftj", "诸"},
	{"yfy", "讨"},
	{"yg", "主"},
	{"yga", "斌"},
	{"ygah", "斌"},
	{"ygd", "主"},
	{"yge", "请"},
	{"ygeg", "请"},
	{"ygh", "证"},
	{"yghg", "证"},
	{"ygk", "语"},
	{"ygkg", "语"},
	{"ygli", "谏"},
	{"ygqt", "廒"},
	{"ygu", "评"},
	{"yguh", "评"},
	{"yh", "让"},
	{"yhag", "谑"},
	{"yhg", "让"},
	{"yhi", "卞"},
	{"yhk", "店"},
	{"yhkd", "店"},
	{"yhy", "讣"},
	{"yi", "就"},
	{"yid", "应"},
	{"yidg", "鹫"},
	{"yidn", "就"},
	{"yieg", "诮"},
	{"yipq", "谠"},
	{"yiu", "京"},
	{"yj", "刘"},
	{"yjff", "廛"},
	{"yjh", "刘"},
	{"yjj", "齐"},
	{"yjjh", "剂"},
	{"yjl", "谩"},
	{"yjlc", "谩"},
	{"yjqn", "谒"},
	{"yjs", "课"},
	{"yjse", "裹"},
	{"yjsy", "课"},
	{"yk", "训"},
	{"ykf", "吝"},
	{"ykg", "误"},
	{"ykgd", "误"},
	{"ykge", "衰"},
	{"ykh", "训"},
	{"ykhe", "衷"},
	{"ykhp", "谴"},
	{"ykk", "襄"},
	{"ykke", "襄"},
	{"ykkn", "谔"},
	{"ykky", "瓤"},
	{"ykw", "识"},
	{"ykwy", "识"},
	{"yl", "为"},
	{"yle", "谓"},
	{"yleg", "谓"},
	{"ylf", "亩"},
	{"ylk", "库"},
	{"ylki", "禀"},
	{"ylkm", "颤"},
	{"ylnf", "衄"},
	{"ylwt", "谡"},
	{"yly", "为"},
	{"ylyi", "为"},
	{"ym", "高"},
	{"ymb", "亢"},
	{"ymc", "设"},
	{"ymcy", "设"},
	{"ymd", "庙"},
	{"ymdm", "颃"},
	{"ymf", "调"},
	{"ymfk", "调"},
	{"ymh", "讪"},
	{"ymhj", "市"},
	{"ymk", "高"},
	{"ymkc", "敲"},
	{"ymkf", "高"},
	{"ymn", "讥"},
	{"ymq", "讽"},
	{"ymqy", "讽"},
	{"ymwy", "讷"},
	{"yn", "记"},
	{"ynbh", "邙"},
	{"yndd", "扉"},
	{"yndi", "戾"},
	{"yne", "户"},
	{"yned", "肩"},
	{"ynef", "肓"},
	{"yneg", "望"},
	{"ynf", "讯"},
	{"ynfh", "讯"},
	{"yng", "诩"},
	{"yngk", "词"},
	{"ynh", "盲"},
	{"ynhf", "盲"},
	{"yni", "永"},
	{"ynii", "永"},
	{"ynij", "昶"},
	{"ynj", "鹿"},
	{"ynjf", "麝"},
	{"ynjg", "麈"},
	{"ynjh", "麟"},
	{"ynjm", "麂"},
	{"ynjo", "麋"},
	{"ynjq", "鏖"},
	{"ynjt", "麇"},
	{"ynjw", "麒"},
	{"ynjx", "鹿"},
	{"ynk", "启"},
	{"ynkc", "扈"},
	{"ynkd", "启"},
	{"ynky", "嬴 蠃 羸 赢"},
	{"ynm", "遍"},
	{"ynma", "扁"},
	{"ynmk", "扃"},
	{"ynmn", "翩"},
	{"ynmp", "遍"},
	{"ynn", "记"},
	{"ynna", "氓"},
	{"ynnd", "扇"},
	{"ynnu", "忘"},
	{"ynt", "刻"},
	{"ynth", "肇"},
	{"ynti", "綮"},
	{"yntj", "刻"},
	{"yntl", "谧 劾"},
	{"yntm", "颏"},
	{"yntw", "亥"},
	{"ynty", "废"},
	{"ynuf", "戽"},
	{"ynv", "亡"},
	{"ynvf", "妄"},
	{"ynw", "廖"},
	{"ynwe", "廖 谬"},
	{"ynwy", "雇 诀"},
	{"yny", "房"},
	{"ynyv", "房"},
	{"yo", "变"},
	{"yoaj", "弈"},
	{"yob", "孪"},
	{"yobf", "孪"},
	{"yoc", "变"},
	{"yocu", "变"},
	{"yodu", "奕"},
	{"yoj", "蛮"},
	{"yoju", "蛮"},
	{"yom", "峦"},
	{"yomj", "峦"},
	{"yomw", "脔"},
	{"yon", "恋"},
	{"yonu", "恋"},
	{"yoo", "谈"},
	{"yooy", "谈"},
	{"yop", "迹"},
	{"yopi", "迹"},
	{"yopy", "谜"},
	{"yoqf", "銮"},
	{"yoqg", "鸾"},
	{"yor", "挛"},
	{"yorj", "挛"},
	{"yosu", "栾"},
	{"you", "亦"},
	{"yovf", "娈"},
	{"yox", "弯"},
	{"yoxb", "弯"},
	{"yp", "这"},
	{"ype", "谊"},
	{"ypeg", "谊"},
	{"ypeu", "豪"},
	{"ypi", "这"},
	{"ypk", "膏"},
	{"ypke", "膏"},
	{"yplh", "诨"},
	{"ypm", "亮"},
	{"ypmb", "亮"},
	{"yps", "亭"},
	{"ypsj", "亭"},
	{"ypt", "毫"},
	{"ypta", "诧 亳"},
	{"yptn", "毫"},
	{"yq", "义"},
	{"yqa", "底"},
	{"yqay", "底 诋"},
	{"yqd", "诡"},
	{"yqdb", "诡"},
	{"yqdy", "谵"},
	{"yqeh", "廨"},
	{"yqi", "义"},
	{"yqj", "询"},
	{"yqjg", "询"},
	{"yqk", "谗"},
	{"yqku", "谗"},
	{"yqnv", "庖"},
	{"yqtg", "诳"},
	{"yqvg", "谄 诌"},
	{"yqvh", "诤"},
	{"yr", "诉"},
	{"yrgk", "诟"},
	{"yri", "诛"},
	{"yriy", "诛"},
	{"yrtf", "庳"},
	{"yrve", "亵"},
	{"yry", "诉"},
	{"yryy", "诉"},
	{"ys", "订"},
	{"ysh", "订"},
	{"ysi", "床"},
	{"ysj", "谭"},
	{"ysjh", "谭"},
	{"yskg", "诃"},
	{"yss", "麻"},
	{"yssc", "魔 麽"},
	{"yssd", "靡 磨"},
	{"yssi", "麻 縻"},
	{"yssn", "麾"},
	{"yssr", "摩"},
	{"yt", "放"},
	{"yta", "旗"},
	{"ytaw", "旗"},
	{"ytb", "施"},
	{"ytbn", "施"},
	{"ytd", "话"},
	{"ytdg", "话"},
	{"ytdk", "旖"},
	{"yte", "诱"},
	{"ytee", "膂"},
	{"yten", "诱"},
	{"ytey", "旅"},
	{"ytf", "许"},
	{"ytfh", "许"},
	{"ytfk", "诰"},
	{"ytfp", "庭"},
	{"ytfq", "诜"},
	{"ytgh", "旆"},
	{"yth", "诈"},
	{"ythf", "诈"},
	{"ythp", "诞"},
	{"ytm", "谢"},
	{"ytmf", "谢"},
	{"ytmy", "旃"},
	{"ytn", "旋"},
	{"ytnh", "旋"},
	{"ytnn", "讫"},
	{"ytnx", "旎"},
	{"ytt", "族"},
	{"yttd", "族"},
	{"yttg", "旌"},
	{"yttn", "旄"},
	{"ytvg", "诿"},
	{"ytx", "诲"},
	{"ytxu", "诲"},
	{"yty", "放"},
	{"ytyh", "州"},
	{"ytyq", "旒"},
	{"yu", "说"},
	{"yud", "详"},
	{"yudh", "详"},
	{"yudk", "庠"},
	{"yuev", "谫"},
	{"yug", "谰"},
	{"yugi", "谰 斓"},
	{"yujg", "谙"},
	{"yuk", "说"},
	{"yukq", "说"},
	{"yumd", "谪"},
	{"yuo", "谱"},
	{"yuoj", "谱"},
	{"yup", "谤"},
	{"yuph", "谛"},
	{"yupy", "谤"},
	{"yuqk", "谘"},
	{"yut", "谚"},
	{"yute", "谚"},
	{"yuv", "谦"},
	{"yuvo", "廉 谦"},
	{"yuwl", "谥"},
	{"yv", "良"},
	{"yvc", "朗"},
	{"yvcb", "郎"},
	{"yvce", "朗"},
	{"yve", "良"},
	{"yveh", "庸"},
	{"yvei", "良"},
	{"yveu", "裒"},
	{"yvh", "唐"},
	{"yvhk", "唐"},
	{"yvi", "康"},
	{"yvii", "康"},
	{"yvkg", "诏"},
	{"yvw", "庚"},
	{"yvwi", "庚 庾"},
	{"yvwm", "赓"},
	{"yvwy", "谀"},
	{"yw", "认"},
	{"ywc", "讼"},
	{"ywcy", "讼"},
	{"ywe", "诊"},
	{"ywet", "诊"},
	{"ywf", "府"},
	{"ywfi", "府"},
	{"ywfw", "腐"},
	{"ywgg", "诠"},
	{"ywgj", "谕"},
	{"ywk", "褒"},
	{"ywke", "褒"},
	{"ywuy", "於"},
	{"yww", "座"},
	{"ywwe", "膺"},
	{"ywwf", "卒 座"},
	{"ywwg", "谶 鹰"},
	{"ywx", "论"},
	{"ywxn", "讹 论"},
	{"ywy", "认"},
	{"ywyg", "谁"},
	{"ywyn", "谂"},
	{"ywyo", "谯"},
	{"yx", "率"},
	{"yxi", "率"},
	{"yxif", "率"},
	{"yxiu", "紊"},
	{"yxj", "诣"},
	{"yxjg", "诣"},
	{"yxl", "畜"},
	{"yxlf", "畜"},
	{"yxt", "雍"},
	{"yxte", "饔"},
	{"yxtf", "壅"},
	{"yxty", "雍"},
	{"yxu", "玄"},
	{"yxv", "庀"},
	{"yxx", "庇"},
	{"yxxr", "谐"},
	{"yxxv", "庇"},
	{"yy", "方"},
	{"yyah", "诫"},
	{"yybb", "廓"},
	{"yybg", "谆"},
	{"yyg", "亠"},
	{"yygn", "方"},
	{"yygt", "广"},
	{"yygy", "文"},
	{"yyi", "谅"},
	{"yyiy", "谅"},
	{"yyli", "廪"},
	{"yyll", "丶"},
	{"yyn", "访 讠"},
	{"yyna", "谝"},
	{"yyne", "庐"},
	{"yynw", "该"},
	{"yyq", "议"},
	{"yyqy", "议"},
	{"yyv", "廊"},
	{"yyvb", "廊"},
	{"yywf", "谇"},
	{"yyy", "言"},
	{"yyyy", "言"},
	{NIL_PTR}
};
