---
myst:
  html_meta:
    keywords: LaTeX, fichiers, fontes, MetaFont
---

# Quels fichiers de police associés à MetaFont doivent être conservés ?

MetaFont produit trois fichiers :
- un fichier de métrique (TFM), 
- un fichier de police générique (GF), 
- et un fichier journal.

Tous ces fichiers ont le même nom de base que le fichier d'entrée (par exemple, 
si le fichier d'entrée était `cmr10.mf`, les sorties seront `cmr10.tfm`, `cmr10.nnngf` 
(le nom du fichier peut être altéré si vous utilisez un système d'exploitation 
qui n'autorise pas les noms de fichiers longs) et `cmr10.log`).

Pour que TeX utilise la police, vous avez besoin d'un fichier TFM, 
**vous devez donc le conserver**. 
Cependant, il est probable que vous génériez la même police en plusieurs tailles et,
à chaque fois que vous le ferez, vous générerez (incidemment) un autre fichier TFM ; 
ces fichiers sont tous identiques, et vous n'avez donc besoin d'en conserver qu'un seul.

Pour la prévisualisation ou l'impression, 
le processeur DVI a besoin d'un fichier de trame de police ; c'est ce que fournit le fichier GF. 
Cependant, alors qu'il existait (autrefois) des processeurs IVC capables d'utiliser des fichiers GF,
les processeurs modernes utilisent des fichiers PK (*packed raster*). 
Il faut noter que pdfTeX utilise également des fichiers PK s'il n'y a rien de "mieux" (vous pouvez
ici consulter la question "[](mon_document_est_flou_a_cause_des_fontes_t3)"). 
Par conséquent, vous devez générer un fichier PK à partir du fichier GF : 
ici, le programme `gftopk` le fait pour vous et, une fois que vous avez fait cela, 
vous pouvez vous débarrasser du fichier GF.

Le fichier journal ne devrait plus jamais être utilisé, 
à moins qu'il n'y ait eu un problème quelconque lors de l'exécution de MetaFont, 
et n'a donc pas besoin d'être conservé.

:::{sources}
[Which font files should be kept](faquk:FAQ-keepfonts)
:::