
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; MODULE      : translit-kbd.scm
;; DESCRIPTION : typing russian using the translit keyboard encoding
;; COPYRIGHT   : (C) 1999-2001  Joris van der Hoeven and Andrey Grozin
;;
;; This software falls under the GNU general public license version 3 or later.
;; It comes WITHOUT ANY WARRANTY WHATSOEVER. For details, see the file LICENSE
;; in the root directory or <http://www.gnu.org/licenses/gpl-3.0.html>.
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(texmacs-module (text cyrillic translit-kbd)
  (:use (text text-kbd)))

(kbd-map
  (:mode in-cyrillic-translit?)

  ("a" "<#430>")
  ("b" "<#431>")
  ("v" "<#432>")
  ("g" "<#433>")
  ("d" "<#434>")
  ("e" "<#435>")
  ("z h" "<#436>")
  ("j var" "<#436>")
  ("z" "<#437>")
  ("z /" "<#437>")
  ("i" "<#438>")
  ("j" "<#439>")
  ("k" "<#43A>")
  ("l" "<#43B>")
  ("m" "<#43C>")
  ("n" "<#43D>")
  ("o" "<#43E>")
  ("p" "<#43F>")
  ("r" "<#440>")
  ("s" "<#441>")
  ("s /" "<#441>")
  ("t" "<#442>")
  ("u" "<#443>")
  ("f" "<#444>")
  ("h" "<#445>")
  ("c" "<#446>")
  ("c /" "<#446>")
  ("c h" "<#447>")
  ("s h" "<#448>")
  ("s c" "<#441><#446>")
  ("s c /" "<#441><#446>")
  ("s c h" "<#449>")
  ("q" "<#44A>")
  ("y" "<#44B>")
  ("y /" "<#44B>")
  ("i var" "<#44B>")
  ("i var var" "<#456>")
  ("x" "<#44C>")
  ("e var" "<#44D>")
  ("y u" "<#44E>")
  ("y a" "<#44F>")
  ("y o" "<#451>")
  ("y i" "<#457>")
  ("accent:umlaut e" "<#451>")
  ("accent:umlaut i" "<#457>")

  ("A" "<#410>")
  ("B" "<#411>")
  ("V" "<#412>")
  ("G" "<#413>")
  ("D" "<#414>")
  ("E" "<#415>")
  ("Z h" "<#416>")
  ("Z H" "<#416>")
  ("J var" "<#416>")
  ("Z" "<#417>")
  ("Z /" "<#417>")
  ("I" "<#418>")
  ("J" "<#419>")
  ("K" "<#41A>")
  ("L" "<#41B>")
  ("M" "<#41C>")
  ("N" "<#41D>")
  ("O" "<#41E>")
  ("P" "<#41F>")
  ("R" "<#420>")
  ("S" "<#421>")
  ("T" "<#422>")
  ("U" "<#423>")
  ("F" "<#424>")
  ("H" "<#425>")
  ("C" "<#426>")
  ("C /" "<#426>")
  ("C h" "<#427>")
  ("C H" "<#427>")
  ("S h" "<#428>")
  ("S H" "<#428>")
  ("S c" "<#421><#446>")
  ("S c /" "<#421><#446>")
  ("S C" "<#421><#426>")
  ("S C /" "<#421><#426>")
  ("S c h" "<#429>")
  ("S C H" "<#429>")
  ("Q" "<#42A>")
  ("Y" "<#42B>")
  ("Y /" "<#42B>")
  ("I var" "<#42B>")
  ("I var var" "<#406>")
  ("X" "<#42C>")
  ("E var" "<#42D>")
  ("Y u" "<#42E>")
  ("Y U" "<#42E>")
  ("Y a" "<#42F>")
  ("Y A" "<#42F>")
  ("Y o" "<#401>")
  ("Y O" "<#401>")
  ("Y i" "<#407>")
  ("Y I" "<#407>")
  ("accent:umlaut E" "<#401>")
  ("accent:umlaut I" "<#407>"))
