; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt -S -passes=instcombine < %s | FileCheck %s

define i1 @test1(i32 %i, ptr %p) {
; CHECK-LABEL: define i1 @test1(
; CHECK-SAME: i32 [[I:%.*]], ptr [[P:%.*]]) {
; CHECK-NEXT:    [[DOTLOBIT:%.*]] = lshr i32 [[I]], 31
; CHECK-NEXT:    store i32 [[DOTLOBIT]], ptr [[P]], align 1
; CHECK-NEXT:    ret i1 false
;
  %lobit = lshr i32 %i, 31
  %t = trunc nuw i32 %lobit to i1
  %b = icmp slt i32 %i, 0
  %not = xor i1 %t, true
  %op = select i1 %not, i1 %b, i1 false
  store i32 %lobit, ptr %p, align 1
  ret i1 %op
}

define i1 @test2(i32 %i, ptr %p) {
; CHECK-LABEL: define i1 @test2(
; CHECK-SAME: i32 [[I:%.*]], ptr [[P:%.*]]) {
; CHECK-NEXT:    [[DOTLOBIT:%.*]] = ashr i32 [[I]], 31
; CHECK-NEXT:    store i32 [[DOTLOBIT]], ptr [[P]], align 1
; CHECK-NEXT:    ret i1 false
;
  %lobit = ashr i32 %i, 31
  %t = trunc nuw i32 %lobit to i1
  %b = icmp slt i32 %i, 0
  %not = xor i1 %t, true
  %op = select i1 %not, i1 %b, i1 false
  store i32 %lobit, ptr %p, align 1
  ret i1 %op
}

define i1 @test3(i32 %i, ptr %p, ptr %q) {
; CHECK-LABEL: define i1 @test3(
; CHECK-SAME: i32 [[I:%.*]], ptr [[P:%.*]], ptr [[Q:%.*]]) {
; CHECK-NEXT:    [[DOTLOBIT:%.*]] = lshr i32 [[I]], 31
; CHECK-NEXT:    store i32 [[DOTLOBIT]], ptr [[P]], align 1
; CHECK-NEXT:    store i32 [[DOTLOBIT]], ptr [[Q]], align 1
; CHECK-NEXT:    ret i1 false
;
  %lobit = lshr i32 %i, 31
  %t = trunc nuw i32 %lobit to i1
  %b = icmp slt i32 %i, 0
  %not = xor i1 %t, true
  %op = select i1 %not, i1 %b, i1 false
  store i32 %lobit, ptr %p, align 1
  store i32 %lobit, ptr %q, align 1
  ret i1 %op
}

; Negative Test
define i1 @test4(i32 %i, ptr %p) {
; CHECK-LABEL: define i1 @test4(
; CHECK-SAME: i32 [[I:%.*]], ptr [[P:%.*]]) {
; CHECK-NEXT:    [[DOTLOBIT:%.*]] = lshr i32 [[I]], 30
; CHECK-NEXT:    [[T:%.*]] = trunc nuw i32 [[DOTLOBIT]] to i1
; CHECK-NEXT:    [[B:%.*]] = icmp slt i32 [[I]], 0
; CHECK-NEXT:    [[NOT_:%.*]] = xor i1 [[T]], true
; CHECK-NEXT:    [[COMMON_RET1_OP:%.*]] = select i1 [[NOT_]], i1 [[B]], i1 false
; CHECK-NEXT:    store i32 [[DOTLOBIT]], ptr [[P]], align 1
; CHECK-NEXT:    ret i1 [[COMMON_RET1_OP]]
;
  %lobit = lshr i32 %i, 30 ; should not fold as no. of bits shifted < BitWidth - 1
  %t = trunc nuw i32 %lobit to i1
  %b = icmp slt i32 %i, 0
  %not = xor i1 %t, true
  %op = select i1 %not, i1 %b, i1 false
  store i32 %lobit, ptr %p, align 1
  ret i1 %op
}

; Negative Test
define i1 @test5(i32 %i, ptr %p) {
; CHECK-LABEL: define i1 @test5(
; CHECK-SAME: i32 [[I:%.*]], ptr [[P:%.*]]) {
; CHECK-NEXT:    [[DOTLOBIT:%.*]] = ashr i32 [[I]], 30
; CHECK-NEXT:    [[T:%.*]] = trunc nuw i32 [[DOTLOBIT]] to i1
; CHECK-NEXT:    [[B:%.*]] = icmp slt i32 [[I]], 0
; CHECK-NEXT:    [[NOT_:%.*]] = xor i1 [[T]], true
; CHECK-NEXT:    [[COMMON_RET1_OP:%.*]] = select i1 [[NOT_]], i1 [[B]], i1 false
; CHECK-NEXT:    store i32 [[DOTLOBIT]], ptr [[P]], align 1
; CHECK-NEXT:    ret i1 [[COMMON_RET1_OP]]
;
  %lobit = ashr i32 %i, 30 ; should not fold as no. of bits shifted < BitWidth - 1
  %t = trunc nuw i32 %lobit to i1
  %b = icmp slt i32 %i, 0
  %not = xor i1 %t, true
  %op = select i1 %not, i1 %b, i1 false
  store i32 %lobit, ptr %p, align 1
  ret i1 %op
}

