/*
	$Id:$

    TiMidity++ -- MIDI to WAVE converter and player
    Copyright (C) 1999 Masanao Izumo <mo@goice.co.jp>
    Copyright (C) 1995 Tuukka Toivonen <tt@cgs.fi>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <math.h>
#include <stdio.h>
#ifdef __FreeBSD__
#include <stdlib.h>
#else
#include <malloc.h>
#endif

#include "gtim.h"
#include "common.h"
#include "instrum.h"
#include "playmidi.h"
#include "output.h"
#include "controls.h"
#include "tables.h"
#include "resample.h"

static FLOAT_T vsf_q0[241][2] = {
{ /* dummy entry */ 0, 0},
{ /*  1 f=  100 */ 0.00654497301305325026, 2.00000000000000000000 },
{ /*  2 f=  200 */ 0.01308987593470371628, 2.00000000000000000000 },
{ /*  3 f=  300 */ 0.01963463867429923390, 2.00000000000000000000 },
{ /*  4 f=  400 */ 0.02617919114268887903, 2.00000000000000000000 },
{ /*  5 f=  500 */ 0.03272346325297356001, 2.00000000000000000000 },
{ /*  6 f=  600 */ 0.03926738492125660118, 2.00000000000000000000 },
{ /*  7 f=  700 */ 0.04581088606739427971, 2.00000000000000000000 },
{ /*  8 f=  800 */ 0.05235389661574629816, 2.00000000000000000000 },
{ /*  9 f=  900 */ 0.05889634649592632304, 2.00000000000000000000 },
{ /* 10 f= 1000 */ 0.06543816564355227350, 2.00000000000000000000 },
{ /* 11 f= 1100 */ 0.07197928400099674884, 2.00000000000000000000 },
{ /* 12 f= 1200 */ 0.07851963151813722008, 2.00000000000000000000 },
{ /* 13 f= 1300 */ 0.08505913815310624237, 2.00000000000000000000 },
{ /* 14 f= 1400 */ 0.09159773387304154246, 2.00000000000000000000 },
{ /* 15 f= 1500 */ 0.09813534865483602987, 2.00000000000000000000 },
{ /* 16 f= 1600 */ 0.10467191248588765540, 2.00000000000000000000 },
{ /* 17 f= 1700 */ 0.11120735536484922801, 2.00000000000000000000 },
{ /* 18 f= 1800 */ 0.11774160730237806516, 2.00000000000000000000 },
{ /* 19 f= 1900 */ 0.12427459832188544886, 2.00000000000000000000 },
{ /* 20 f= 2000 */ 0.13080625846028612336, 2.00000000000000000000 },
{ /* 21 f= 2100 */ 0.13733651776874752914, 2.00000000000000000000 },
{ /* 22 f= 2200 */ 0.14386530631343877329, 2.00000000000000000000 },
{ /* 23 f= 2300 */ 0.15039255417627980793, 2.00000000000000000000 },
{ /* 24 f= 2400 */ 0.15691819145568988714, 2.00000000000000000000 },
{ /* 25 f= 2500 */ 0.16344214826733644008, 2.00000000000000000000 },
{ /* 26 f= 2600 */ 0.16996435474488333361, 2.00000000000000000000 },
{ /* 27 f= 2700 */ 0.17648474104073902380, 2.00000000000000000000 },
{ /* 28 f= 2800 */ 0.18300323732680476296, 2.00000000000000000000 },
{ /* 29 f= 2900 */ 0.18951977379522222389, 2.00000000000000000000 },
{ /* 30 f= 3000 */ 0.19603428065912120726, 2.00000000000000000000 },
{ /* 31 f= 3100 */ 0.20254668815336684951, 2.00000000000000000000 },
{ /* 32 f= 3200 */ 0.20905692653530691394, 2.00000000000000000000 },
{ /* 33 f= 3300 */ 0.21556492608551869328, 2.00000000000000000000 },
{ /* 34 f= 3400 */ 0.22207061710855535708, 2.00000000000000000000 },
{ /* 35 f= 3500 */ 0.22857392993369279877, 2.00000000000000000000 },
{ /* 36 f= 3600 */ 0.23507479491567528918, 2.00000000000000000000 },
{ /* 37 f= 3700 */ 0.24157314243546165744, 2.00000000000000000000 },
{ /* 38 f= 3800 */ 0.24806890290097063922, 2.00000000000000000000 },
{ /* 39 f= 3900 */ 0.25456200674782641924, 2.00000000000000000000 },
{ /* 40 f= 4000 */ 0.26105238444010314680, 2.00000000000000000000 },
{ /* 41 f= 4100 */ 0.26753996647107025630, 2.00000000000000000000 },
{ /* 42 f= 4200 */ 0.27402468336393603909, 2.00000000000000000000 },
{ /* 43 f= 4300 */ 0.28050646567259251984, 2.00000000000000000000 },
{ /* 44 f= 4400 */ 0.28698524398235858435, 2.00000000000000000000 },
{ /* 45 f= 4500 */ 0.29346094891072349586, 2.00000000000000000000 },
{ /* 46 f= 4600 */ 0.29993351110809002291, 2.00000000000000000000 },
{ /* 47 f= 4700 */ 0.30640286125851695642, 2.00000000000000000000 },
{ /* 48 f= 4800 */ 0.31286893008046173792, 2.00000000000000000000 },
{ /* 49 f= 4900 */ 0.31933164832752197748, 2.00000000000000000000 },
{ /* 50 f= 5000 */ 0.32579094678917747130, 2.00000000000000000000 },
{ /* 51 f= 5100 */ 0.33224675629153094247, 2.00000000000000000000 },
{ /* 52 f= 5200 */ 0.33869900769804922591, 2.00000000000000000000 },
{ /* 53 f= 5300 */ 0.34514763191030339851, 2.00000000000000000000 },
{ /* 54 f= 5400 */ 0.35159255986870902033, 2.00000000000000000000 },
{ /* 55 f= 5500 */ 0.35803372255326532114, 2.00000000000000000000 },
{ /* 56 f= 5600 */ 0.36447105098429494197, 2.00000000000000000000 },
{ /* 57 f= 5700 */ 0.37090447622318184484, 2.00000000000000000000 },
{ /* 58 f= 5800 */ 0.37733392937311044379, 2.00000000000000000000 },
{ /* 59 f= 5900 */ 0.38375934157980284844, 2.00000000000000000000 },
{ /* 60 f= 6000 */ 0.39018064403225649617, 2.00000000000000000000 },
{ /* 61 f= 6100 */ 0.39659776796348089611, 2.00000000000000000000 },
{ /* 62 f= 6200 */ 0.40301064465123426217, 2.00000000000000000000 },
{ /* 63 f= 6300 */ 0.40941920541875920225, 2.00000000000000000000 },
{ /* 64 f= 6400 */ 0.41582338163551862964, 2.00000000000000000000 },
{ /* 65 f= 6500 */ 0.42222310471793028652, 2.00000000000000000000 },
{ /* 66 f= 6600 */ 0.42861830613010154511, 2.00000000000000000000 },
{ /* 67 f= 6700 */ 0.43500891738456293201, 2.00000000000000000000 },
{ /* 68 f= 6800 */ 0.44139487004300215212, 2.00000000000000000000 },
{ /* 69 f= 6900 */ 0.44777609571699672486, 2.00000000000000000000 },
{ /* 70 f= 7000 */ 0.45415252606874645380, 2.00000000000000000000 },
{ /* 71 f= 7100 */ 0.46052409281180473055, 2.00000000000000000000 },
{ /* 72 f= 7200 */ 0.46689072771181078236, 2.00000000000000000000 },
{ /* 73 f= 7300 */ 0.47325236258721975480, 2.00000000000000000000 },
{ /* 74 f= 7400 */ 0.47960892931003307194, 2.00000000000000000000 },
{ /* 75 f= 7500 */ 0.48596035980652774189, 2.00000000000000000000 },
{ /* 76 f= 7600 */ 0.49230658605798605088, 2.00000000000000000000 },
{ /* 77 f= 7700 */ 0.49864754010142336993, 2.00000000000000000000 },
{ /* 78 f= 7800 */ 0.50498315403031590609, 2.00000000000000000000 },
{ /* 79 f= 7900 */ 0.51131335999532878667, 2.00000000000000000000 },
{ /* 80 f= 8000 */ 0.51763809020504147895, 2.00000000000000000000 },
{ /* 81 f= 8100 */ 0.52395727692667493081, 2.00000000000000000000 },
{ /* 82 f= 8200 */ 0.53027085248681604668, 2.00000000000000000000 },
{ /* 83 f= 8300 */ 0.53657874927214277427, 2.00000000000000000000 },
{ /* 84 f= 8400 */ 0.54288089973014852507, 2.00000000000000000000 },
{ /* 85 f= 8500 */ 0.54917723636986470748, 2.00000000000000000000 },
{ /* 86 f= 8600 */ 0.55546769176258437017, 2.00000000000000000000 },
{ /* 87 f= 8700 */ 0.56175219854258418017, 2.00000000000000000000 },
{ /* 88 f= 8800 */ 0.56803068940784517959, 2.00000000000000000000 },
{ /* 89 f= 8900 */ 0.57430309712077465267, 2.00000000000000000000 },
{ /* 90 f= 9000 */ 0.58056935450892466211, 2.00000000000000000000 },
{ /* 91 f= 9100 */ 0.58682939446571336095, 2.00000000000000000000 },
{ /* 92 f= 9200 */ 0.59308314995114197465, 2.00000000000000000000 },
{ /* 93 f= 9300 */ 0.59933055399251322637, 2.00000000000000000000 },
{ /* 94 f= 9400 */ 0.60557153968514920717, 2.00000000000000000000 },
{ /* 95 f= 9500 */ 0.61180604019310691477, 2.00000000000000000000 },
{ /* 96 f= 9600 */ 0.61803398874989479150, 2.00000000000000000000 },
{ /* 97 f= 9700 */ 0.62425531865918737484, 2.00000000000000000000 },
{ /* 98 f= 9800 */ 0.63046996329553928184, 2.00000000000000000000 },
{ /* 99 f= 9900 */ 0.63667785610509941563, 2.00000000000000000000 },
{ /*100 f=10000 */ 0.64287893060632317344, 2.00000000000000000000 },
{ /*101 f=10100 */ 0.64907312039068432163, 2.00000000000000000000 },
{ /*102 f=10200 */ 0.65526035912338698175, 2.00000000000000000000 },
{ /*103 f=10300 */ 0.66144058054407484093, 2.00000000000000000000 },
{ /*104 f=10400 */ 0.66761371846754191672, 2.00000000000000000000 },
{ /*105 f=10500 */ 0.67377970678444010222, 2.00000000000000000000 },
{ /*106 f=10600 */ 0.67993847946198837651, 2.00000000000000000000 },
{ /*107 f=10700 */ 0.68608997054467968368, 2.00000000000000000000 },
{ /*108 f=10800 */ 0.69223411415498592447, 2.00000000000000000000 },
{ /*109 f=10900 */ 0.69837084449406572340, 2.00000000000000000000 },
{ /*110 f=11000 */ 0.70450009584246697791, 2.00000000000000000000 },
{ /*111 f=11100 */ 0.71062180256083218310, 2.00000000000000000000 },
{ /*112 f=11200 */ 0.71673589909060053671, 2.00000000000000000000 },
{ /*113 f=11300 */ 0.72284231995471004417, 2.00000000000000000000 },
{ /*114 f=11400 */ 0.72894099975829929061, 2.00000000000000000000 },
{ /*115 f=11500 */ 0.73503187318940710338, 2.00000000000000000000 },
{ /*116 f=11600 */ 0.74111487501967243663, 2.00000000000000000000 },
{ /*117 f=11700 */ 0.74718994010503270164, 2.00000000000000000000 },
{ /*118 f=11800 */ 0.75325700338642143095, 2.00000000000000000000 },
{ /*119 f=11900 */ 0.75931599989046549837, 2.00000000000000000000 },
{ /*120 f=12000 */ 0.76536686473017956356, 2.00000000000000000000 },
{ /*121 f=12100 */ 0.77140953310566262591, 2.00000000000000000000 },
{ /*122 f=12200 */ 0.77744394030479113678, 2.00000000000000000000 },
{ /*123 f=12300 */ 0.78347002170391177867, 2.00000000000000000000 },
{ /*124 f=12400 */ 0.78948771276853446643, 2.00000000000000000000 },
{ /*125 f=12500 */ 0.79549694905402212886, 2.00000000000000000000 },
{ /*126 f=12600 */ 0.80149766620628193348, 2.00000000000000000000 },
{ /*127 f=12700 */ 0.80748979996245418000, 2.00000000000000000000 },
{ /*128 f=12800 */ 0.81347328615160030552, 2.00000000000000000000 },
{ /*129 f=12900 */ 0.81944806069539055660, 2.00000000000000000000 },
{ /*130 f=13000 */ 0.82541405960878933001, 2.00000000000000000000 },
{ /*131 f=13100 */ 0.83137121900074162362, 1.98997861640809903250 },
{ /*132 f=13200 */ 0.83731947507485626758, 1.96991482633641479261 },
{ /*133 f=13300 */ 0.84325876413008904464, 1.95012183485021917129 },
{ /*134 f=13400 */ 0.84918902256142625440, 1.93059372933897721580 },
{ /*135 f=13500 */ 0.85511018686056416982, 1.91132477343548767834 },
{ /*136 f=13600 */ 0.86102219361659015906, 1.89230940053488061459 },
{ /*137 f=13700 */ 0.86692497951666180889, 1.87354220759744682923 },
{ /*138 f=13800 */ 0.87281848134668404970, 1.85501794922090912365 },
{ /*139 f=13900 */ 0.87870263599198739080, 1.83673153196855043490 },
{ /*140 f=14000 */ 0.88457738043800260286, 1.81867800894042175308 },
{ /*141 f=14100 */ 0.89044265177093639974, 1.80085257457555081295 },
{ /*142 f=14200 */ 0.89629838717844512175, 1.78325055967376910893 },
{ /*143 f=14300 */ 0.90214452395030675369, 1.76586742662641116297 },
{ /*144 f=14400 */ 0.90798099947909349794, 1.74869876484572017716 },
{ /*145 f=14500 */ 0.91380775126084123894, 1.73174028638338040054 },
{ /*146 f=14600 */ 0.91962471689571967381, 1.71498782172910368971 },
{ /*147 f=14700 */ 0.92543183408870022255, 1.69843731578068934951 },
{ /*148 f=14800 */ 0.93122904065022282794, 1.68208482397746417192 },
{ /*149 f=14900 */ 0.93701627449686286653, 1.66592650858940438674 },
{ /*150 f=15000 */ 0.94279347365199528408, 1.64995863515469731730 },
{ /*151 f=15100 */ 0.94856057624645839788, 1.63417756905884381524 },
{ /*152 f=15200 */ 0.95431752051921681090, 1.61857977224879334699 },
{ /*153 f=15300 */ 0.96006424481802221660, 1.60316180007593156454 },
{ /*154 f=15400 */ 0.96580068760007475870, 1.58792029826205793874 },
{ /*155 f=15500 */ 0.97152678743268006123, 1.57285199998281299827 },
{ /*156 f=15600 */ 0.97724248299390981121, 1.55795372306326274092 },
{ /*157 f=15700 */ 0.98294771307325645715, 1.54322236728066597422 },
{ /*158 f=15800 */ 0.98864241657228923987, 1.52865491176965573317 },
{ /*159 f=15900 */ 0.99432653250530855793, 1.51424841252533548541 },
{ /*160 f=16000 */ 0.99999999999999988898, 1.50000000000000000000 },
{ /*161 f=16100 */ 1.00566275829808415843, 1.48590687678942501293 },
{ /*162 f=16200 */ 1.01131474675596910728, 1.47196631540483235945 },
{ /*163 f=16300 */ 1.01695590484539954979, 1.45817565612687216614 },
{ /*164 f=16400 */ 1.02258617215410430035, 1.44453230493811091151 },
{ /*165 f=16500 */ 1.02820548838644332257, 1.43103373153069979296 },
{ /*166 f=16600 */ 1.03381379336405498925, 1.41767746738604305534 },
{ /*167 f=16700 */ 1.03941102702649845746, 1.40446110392346623641 },
{ /*168 f=16800 */ 1.04499712943189759784, 1.39138229071499419653 },
{ /*169 f=16900 */ 1.05057204075758403583, 1.37843873376350201099 },
{ /*170 f=17000 */ 1.05613570130073597397, 1.36562819384164324532 },
{ /*171 f=17100 */ 1.06168805147901901265, 1.35294848488904562167 },
{ /*172 f=17200 */ 1.06722903183122297399, 1.34039747246542617631 },
{ /*173 f=17300 */ 1.07275858301790050220, 1.32797307225734106950 },
{ /*174 f=17400 */ 1.07827664582200033472, 1.31567324863643353439 },
{ /*175 f=17500 */ 1.08378316114950346005, 1.30349601326710184956 },
{ /*176 f=17600 */ 1.08927807003005394648, 1.29143942376163645136 },
{ /*177 f=17700 */ 1.09476131361759310145, 1.27950158238093480989 },
{ /*178 f=17800 */ 1.10023283319098674760, 1.26768063477901771208 },
{ /*179 f=17900 */ 1.10569257015465582938, 1.25597476878962099889 },
{ /*180 f=18000 */ 1.11114046603920435530, 1.24438221325322939670 },
{ /*181 f=18100 */ 1.11657646250204400928, 1.23290123688299635418 },
{ /*182 f=18200 */ 1.12200050132801965042, 1.22153014716804531048 },
{ /*183 f=18300 */ 1.12741252443003325823, 1.21026728931272242740 },
{ /*184 f=18400 */ 1.13281247384966565761, 1.19911104521044298288 },
{ /*185 f=18500 */ 1.13820029175779646735, 1.18805983245081248079 },
{ /*186 f=18600 */ 1.14357592045522449276, 1.17711210335877192179 },
{ /*187 f=18700 */ 1.14893930237328523170, 1.16626634406457485582 },
{ /*188 f=18800 */ 1.15429038007446727043, 1.15552107360343958575 },
{ /*189 f=18900 */ 1.15962909625302712513, 1.14487484304378761557 },
{ /*190 f=19000 */ 1.16495539373560430541, 1.13432623464299986438 },
{ /*191 f=19100 */ 1.17026921548183104882, 1.12387386102970543433 },
{ /*192 f=19200 */ 1.17557050458494627421, 1.11351636441160661839 },
{ /*193 f=19300 */ 1.18085920427240220754, 1.10325241580794441987 },
{ /*194 f=19400 */ 1.18613525790647433844, 1.09308071430568842786 },
{ /*195 f=19500 */ 1.19139860898486671381, 1.08299998633862060160 },
{ /*196 f=19600 */ 1.19664920114131789752, 1.07300898498848162887 },
{ /*197 f=19700 */ 1.20188697814620470972, 1.06310648930740070384 },
{ /*198 f=19800 */ 1.20711188390714285745, 1.05329130366086243242 },
{ /*199 f=19900 */ 1.21232386246958934173, 1.04356225709047567562 },
{ /*200 f=20000 */ 1.21752285801744131177, 1.03391820269586087733 },
{ /*201 f=20100 */ 1.22270881487363292095, 1.02435801703499063109 },
{ /*202 f=20200 */ 1.22788167750073284878, 1.01488059954233600379 },
{ /*203 f=20300 */ 1.23304139050153827029, 1.00548487196421465484 },
{ /*204 f=20400 */ 1.23818789861966793708, 0.99616977781074300680 },
{ /*205 f=20500 */ 1.24332114674015481448, 0.98693428182382814118 },
{ /*206 f=20600 */ 1.24844107989003516579, 0.97777736946065774148 },
{ /*207 f=20700 */ 1.25354764323893919098, 0.96869804639215506548 },
{ /*208 f=20800 */ 1.25864078209967500399, 0.95969533801591189182 },
{ /*209 f=20900 */ 1.26372044192881749503, 0.95076828898309073690 },
{ /*210 f=21000 */ 1.26878656832729097559, 0.94191596273885491719 },
{ /*211 f=21100 */ 1.27383910704095182354, 0.93313744107586238385 },
{ /*212 f=21200 */ 1.27887800396116935175, 0.92443182370039722606 },
{ /*213 f=21300 */ 1.28390320512540601072, 0.91579822781072373061 },
{ /*214 f=21400 */ 1.28891465671779492652, 0.90723578768726120813 },
{ /*215 f=21500 */ 1.29391230506971455227, 0.89874365429420155493 },
{ /*216 f=21600 */ 1.29889609666036731639, 0.89032099489218263777 },
{ /*217 f=21700 */ 1.30386597811734850083, 0.88196699266168554487 },
{ /*218 f=21800 */ 1.30882189621722067052, 0.87368084633678677609 },
{ /*219 f=21900 */ 1.31376379788608255161, 0.86546176984895073492 },
{ /*220 f=22000 */ 1.31869163020013768772, 0.85730899198053744925 },
{ /*221 f=22100 */ 1.32360534038626065367, 0.84922175602771798886 },
{ /*222 f=22200 */ 1.32850487582256349128, 0.84119931947249937387 },
{ /*223 f=22300 */ 1.33339018403895726017, 0.83324095366358041925 },
{ /*224 f=22400 */ 1.33826121271771647514, 0.82534594350575041233 },
{ /*225 f=22500 */ 1.34311790969403666018, 0.81751358715757882489 },
{ /*226 f=22600 */ 1.34796022295659567725, 0.80974319573712583153 },
{ /*227 f=22700 */ 1.35278810064810839364, 0.80203409303544037634 },
{ /*228 f=22800 */ 1.35760149106588334789, 0.79438561523759276817 },
{ /*229 f=22900 */ 1.36240034266237652893, 0.78679711065102153622 },
{ /*230 f=23000 */ 1.36718460404574249090, 0.77926793944096928168 },
{ /*231 f=23100 */ 1.37195422398038568979, 0.77179747337279025476 },
{ /*232 f=23200 */ 1.37670915138750782347, 0.76438509556092792963 },
{ /*233 f=23300 */ 1.38144933534565739208, 0.75703020022435185687 },
{ /*234 f=23400 */ 1.38617472509127170888, 0.74973219244827837837 },
{ /*235 f=23500 */ 1.39088527001922335202, 0.74249048795196670447 },
{ /*236 f=23600 */ 1.39558091968336017707, 0.73530451286242859421 },
{ /*237 f=23700 */ 1.40026162379704732786, 0.72817370349386423278 },
{ /*238 f=23800 */ 1.40492733223370347417, 0.72109750613266698771 },
{ /*239 f=23900 */ 1.40957799502734015817, 0.71407537682782074029 },
{ /*240 f=24000 */ 1.41421356237309492343, 0.70710678118654768376 }
};
static FLOAT_T vsf_q10[241][2] = {
{ /* dummy entry */ 0, 0},
{ /*  1 f=  100 */ 0.00654497301305325026, 0.65313624472864661996 },
{ /*  2 f=  200 */ 0.01308987593470371628, 0.65313624472864661996 },
{ /*  3 f=  300 */ 0.01963463867429923390, 0.65313624472864661996 },
{ /*  4 f=  400 */ 0.02617919114268887903, 0.65313624472864661996 },
{ /*  5 f=  500 */ 0.03272346325297356001, 0.65313624472864661996 },
{ /*  6 f=  600 */ 0.03926738492125660118, 0.65313624472864661996 },
{ /*  7 f=  700 */ 0.04581088606739427971, 0.65313624472864661996 },
{ /*  8 f=  800 */ 0.05235389661574629816, 0.65313624472864661996 },
{ /*  9 f=  900 */ 0.05889634649592632304, 0.65313624472864661996 },
{ /* 10 f= 1000 */ 0.06543816564355227350, 0.65313624472864661996 },
{ /* 11 f= 1100 */ 0.07197928400099674884, 0.65313624472864661996 },
{ /* 12 f= 1200 */ 0.07851963151813722008, 0.65313624472864661996 },
{ /* 13 f= 1300 */ 0.08505913815310624237, 0.65313624472864661996 },
{ /* 14 f= 1400 */ 0.09159773387304154246, 0.65313624472864661996 },
{ /* 15 f= 1500 */ 0.09813534865483602987, 0.65313624472864661996 },
{ /* 16 f= 1600 */ 0.10467191248588765540, 0.65313624472864661996 },
{ /* 17 f= 1700 */ 0.11120735536484922801, 0.65313624472864661996 },
{ /* 18 f= 1800 */ 0.11774160730237806516, 0.65313624472864661996 },
{ /* 19 f= 1900 */ 0.12427459832188544886, 0.65313624472864661996 },
{ /* 20 f= 2000 */ 0.13080625846028612336, 0.65313624472864661996 },
{ /* 21 f= 2100 */ 0.13733651776874752914, 0.65313624472864661996 },
{ /* 22 f= 2200 */ 0.14386530631343877329, 0.65313624472864661996 },
{ /* 23 f= 2300 */ 0.15039255417627980793, 0.65313624472864661996 },
{ /* 24 f= 2400 */ 0.15691819145568988714, 0.65313624472864661996 },
{ /* 25 f= 2500 */ 0.16344214826733644008, 0.65313624472864661996 },
{ /* 26 f= 2600 */ 0.16996435474488333361, 0.65313624472864661996 },
{ /* 27 f= 2700 */ 0.17648474104073902380, 0.65313624472864661996 },
{ /* 28 f= 2800 */ 0.18300323732680476296, 0.65313624472864661996 },
{ /* 29 f= 2900 */ 0.18951977379522222389, 0.65313624472864661996 },
{ /* 30 f= 3000 */ 0.19603428065912120726, 0.65313624472864661996 },
{ /* 31 f= 3100 */ 0.20254668815336684951, 0.65313624472864661996 },
{ /* 32 f= 3200 */ 0.20905692653530691394, 0.65313624472864661996 },
{ /* 33 f= 3300 */ 0.21556492608551869328, 0.65313624472864661996 },
{ /* 34 f= 3400 */ 0.22207061710855535708, 0.65313624472864661996 },
{ /* 35 f= 3500 */ 0.22857392993369279877, 0.65313624472864661996 },
{ /* 36 f= 3600 */ 0.23507479491567528918, 0.65313624472864661996 },
{ /* 37 f= 3700 */ 0.24157314243546165744, 0.65313624472864661996 },
{ /* 38 f= 3800 */ 0.24806890290097063922, 0.65313624472864661996 },
{ /* 39 f= 3900 */ 0.25456200674782641924, 0.65313624472864661996 },
{ /* 40 f= 4000 */ 0.26105238444010314680, 0.65313624472864661996 },
{ /* 41 f= 4100 */ 0.26753996647107025630, 0.65313624472864661996 },
{ /* 42 f= 4200 */ 0.27402468336393603909, 0.65313624472864661996 },
{ /* 43 f= 4300 */ 0.28050646567259251984, 0.65313624472864661996 },
{ /* 44 f= 4400 */ 0.28698524398235858435, 0.65313624472864661996 },
{ /* 45 f= 4500 */ 0.29346094891072349586, 0.65313624472864661996 },
{ /* 46 f= 4600 */ 0.29993351110809002291, 0.65313624472864661996 },
{ /* 47 f= 4700 */ 0.30640286125851695642, 0.65313624472864661996 },
{ /* 48 f= 4800 */ 0.31286893008046173792, 0.65313624472864661996 },
{ /* 49 f= 4900 */ 0.31933164832752197748, 0.65313624472864661996 },
{ /* 50 f= 5000 */ 0.32579094678917747130, 0.65313624472864661996 },
{ /* 51 f= 5100 */ 0.33224675629153094247, 0.65313624472864661996 },
{ /* 52 f= 5200 */ 0.33869900769804922591, 0.65313624472864661996 },
{ /* 53 f= 5300 */ 0.34514763191030339851, 0.65313624472864661996 },
{ /* 54 f= 5400 */ 0.35159255986870902033, 0.65313624472864661996 },
{ /* 55 f= 5500 */ 0.35803372255326532114, 0.65313624472864661996 },
{ /* 56 f= 5600 */ 0.36447105098429494197, 0.65313624472864661996 },
{ /* 57 f= 5700 */ 0.37090447622318184484, 0.65313624472864661996 },
{ /* 58 f= 5800 */ 0.37733392937311044379, 0.65313624472864661996 },
{ /* 59 f= 5900 */ 0.38375934157980284844, 0.65313624472864661996 },
{ /* 60 f= 6000 */ 0.39018064403225649617, 0.65313624472864661996 },
{ /* 61 f= 6100 */ 0.39659776796348089611, 0.65313624472864661996 },
{ /* 62 f= 6200 */ 0.40301064465123426217, 0.65313624472864661996 },
{ /* 63 f= 6300 */ 0.40941920541875920225, 0.65313624472864661996 },
{ /* 64 f= 6400 */ 0.41582338163551862964, 0.65313624472864661996 },
{ /* 65 f= 6500 */ 0.42222310471793028652, 0.65313624472864661996 },
{ /* 66 f= 6600 */ 0.42861830613010154511, 0.65313624472864661996 },
{ /* 67 f= 6700 */ 0.43500891738456293201, 0.65313624472864661996 },
{ /* 68 f= 6800 */ 0.44139487004300215212, 0.65313624472864661996 },
{ /* 69 f= 6900 */ 0.44777609571699672486, 0.65313624472864661996 },
{ /* 70 f= 7000 */ 0.45415252606874645380, 0.65313624472864661996 },
{ /* 71 f= 7100 */ 0.46052409281180473055, 0.65313624472864661996 },
{ /* 72 f= 7200 */ 0.46689072771181078236, 0.65313624472864661996 },
{ /* 73 f= 7300 */ 0.47325236258721975480, 0.65313624472864661996 },
{ /* 74 f= 7400 */ 0.47960892931003307194, 0.65313624472864661996 },
{ /* 75 f= 7500 */ 0.48596035980652774189, 0.65313624472864661996 },
{ /* 76 f= 7600 */ 0.49230658605798605088, 0.65313624472864661996 },
{ /* 77 f= 7700 */ 0.49864754010142336993, 0.65313624472864661996 },
{ /* 78 f= 7800 */ 0.50498315403031590609, 0.65313624472864661996 },
{ /* 79 f= 7900 */ 0.51131335999532878667, 0.65313624472864661996 },
{ /* 80 f= 8000 */ 0.51763809020504147895, 0.65313624472864661996 },
{ /* 81 f= 8100 */ 0.52395727692667493081, 0.65313624472864661996 },
{ /* 82 f= 8200 */ 0.53027085248681604668, 0.65313624472864661996 },
{ /* 83 f= 8300 */ 0.53657874927214277427, 0.65313624472864661996 },
{ /* 84 f= 8400 */ 0.54288089973014852507, 0.65313624472864661996 },
{ /* 85 f= 8500 */ 0.54917723636986470748, 0.65313624472864661996 },
{ /* 86 f= 8600 */ 0.55546769176258437017, 0.65313624472864661996 },
{ /* 87 f= 8700 */ 0.56175219854258418017, 0.65313624472864661996 },
{ /* 88 f= 8800 */ 0.56803068940784517959, 0.65313624472864661996 },
{ /* 89 f= 8900 */ 0.57430309712077465267, 0.65313624472864661996 },
{ /* 90 f= 9000 */ 0.58056935450892466211, 0.65313624472864661996 },
{ /* 91 f= 9100 */ 0.58682939446571336095, 0.65313624472864661996 },
{ /* 92 f= 9200 */ 0.59308314995114197465, 0.65313624472864661996 },
{ /* 93 f= 9300 */ 0.59933055399251322637, 0.65313624472864661996 },
{ /* 94 f= 9400 */ 0.60557153968514920717, 0.65313624472864661996 },
{ /* 95 f= 9500 */ 0.61180604019310691477, 0.65313624472864661996 },
{ /* 96 f= 9600 */ 0.61803398874989479150, 0.65313624472864661996 },
{ /* 97 f= 9700 */ 0.62425531865918737484, 0.65313624472864661996 },
{ /* 98 f= 9800 */ 0.63046996329553928184, 0.65313624472864661996 },
{ /* 99 f= 9900 */ 0.63667785610509941563, 0.65313624472864661996 },
{ /*100 f=10000 */ 0.64287893060632317344, 0.65313624472864661996 },
{ /*101 f=10100 */ 0.64907312039068432163, 0.65313624472864661996 },
{ /*102 f=10200 */ 0.65526035912338698175, 0.65313624472864661996 },
{ /*103 f=10300 */ 0.66144058054407484093, 0.65313624472864661996 },
{ /*104 f=10400 */ 0.66761371846754191672, 0.65313624472864661996 },
{ /*105 f=10500 */ 0.67377970678444010222, 0.65313624472864661996 },
{ /*106 f=10600 */ 0.67993847946198837651, 0.65313624472864661996 },
{ /*107 f=10700 */ 0.68608997054467968368, 0.65313624472864661996 },
{ /*108 f=10800 */ 0.69223411415498592447, 0.65313624472864661996 },
{ /*109 f=10900 */ 0.69837084449406572340, 0.65313624472864661996 },
{ /*110 f=11000 */ 0.70450009584246697791, 0.65313624472864661996 },
{ /*111 f=11100 */ 0.71062180256083218310, 0.65313624472864661996 },
{ /*112 f=11200 */ 0.71673589909060053671, 0.65313624472864661996 },
{ /*113 f=11300 */ 0.72284231995471004417, 0.65313624472864661996 },
{ /*114 f=11400 */ 0.72894099975829929061, 0.65313624472864661996 },
{ /*115 f=11500 */ 0.73503187318940710338, 0.65313624472864661996 },
{ /*116 f=11600 */ 0.74111487501967243663, 0.65313624472864661996 },
{ /*117 f=11700 */ 0.74718994010503270164, 0.65313624472864661996 },
{ /*118 f=11800 */ 0.75325700338642143095, 0.65313624472864661996 },
{ /*119 f=11900 */ 0.75931599989046549837, 0.65313624472864661996 },
{ /*120 f=12000 */ 0.76536686473017956356, 0.65313624472864661996 },
{ /*121 f=12100 */ 0.77140953310566262591, 0.65313624472864661996 },
{ /*122 f=12200 */ 0.77744394030479113678, 0.65313624472864661996 },
{ /*123 f=12300 */ 0.78347002170391177867, 0.65313624472864661996 },
{ /*124 f=12400 */ 0.78948771276853446643, 0.65313624472864661996 },
{ /*125 f=12500 */ 0.79549694905402212886, 0.65313624472864661996 },
{ /*126 f=12600 */ 0.80149766620628193348, 0.65313624472864661996 },
{ /*127 f=12700 */ 0.80748979996245418000, 0.65313624472864661996 },
{ /*128 f=12800 */ 0.81347328615160030552, 0.65313624472864661996 },
{ /*129 f=12900 */ 0.81944806069539055660, 0.65313624472864661996 },
{ /*130 f=13000 */ 0.82541405960878933001, 0.65313624472864661996 },
{ /*131 f=13100 */ 0.83137121900074162362, 0.65313624472864661996 },
{ /*132 f=13200 */ 0.83731947507485626758, 0.65313624472864661996 },
{ /*133 f=13300 */ 0.84325876413008904464, 0.65313624472864661996 },
{ /*134 f=13400 */ 0.84918902256142625440, 0.65313624472864661996 },
{ /*135 f=13500 */ 0.85511018686056416982, 0.65313624472864661996 },
{ /*136 f=13600 */ 0.86102219361659015906, 0.65313624472864661996 },
{ /*137 f=13700 */ 0.86692497951666180889, 0.65313624472864661996 },
{ /*138 f=13800 */ 0.87281848134668404970, 0.65313624472864661996 },
{ /*139 f=13900 */ 0.87870263599198739080, 0.65313624472864661996 },
{ /*140 f=14000 */ 0.88457738043800260286, 0.65313624472864661996 },
{ /*141 f=14100 */ 0.89044265177093639974, 0.65313624472864661996 },
{ /*142 f=14200 */ 0.89629838717844512175, 0.65313624472864661996 },
{ /*143 f=14300 */ 0.90214452395030675369, 0.65313624472864661996 },
{ /*144 f=14400 */ 0.90798099947909349794, 0.65313624472864661996 },
{ /*145 f=14500 */ 0.91380775126084123894, 0.65313624472864661996 },
{ /*146 f=14600 */ 0.91962471689571967381, 0.65313624472864661996 },
{ /*147 f=14700 */ 0.92543183408870022255, 0.65313624472864661996 },
{ /*148 f=14800 */ 0.93122904065022282794, 0.65313624472864661996 },
{ /*149 f=14900 */ 0.93701627449686286653, 0.65313624472864661996 },
{ /*150 f=15000 */ 0.94279347365199528408, 0.65313624472864661996 },
{ /*151 f=15100 */ 0.94856057624645839788, 0.65313624472864661996 },
{ /*152 f=15200 */ 0.95431752051921681090, 0.65313624472864661996 },
{ /*153 f=15300 */ 0.96006424481802221660, 0.65313624472864661996 },
{ /*154 f=15400 */ 0.96580068760007475870, 0.65313624472864661996 },
{ /*155 f=15500 */ 0.97152678743268006123, 0.65313624472864661996 },
{ /*156 f=15600 */ 0.97724248299390981121, 0.65313624472864661996 },
{ /*157 f=15700 */ 0.98294771307325645715, 0.65313624472864661996 },
{ /*158 f=15800 */ 0.98864241657228923987, 0.65313624472864661996 },
{ /*159 f=15900 */ 0.99432653250530855793, 0.65313624472864661996 },
{ /*160 f=16000 */ 0.99999999999999988898, 0.65313624472864661996 },
{ /*161 f=16100 */ 1.00566275829808415843, 0.65313624472864661996 },
{ /*162 f=16200 */ 1.01131474675596910728, 0.65313624472864661996 },
{ /*163 f=16300 */ 1.01695590484539954979, 0.65313624472864661996 },
{ /*164 f=16400 */ 1.02258617215410430035, 0.65313624472864661996 },
{ /*165 f=16500 */ 1.02820548838644332257, 0.65313624472864661996 },
{ /*166 f=16600 */ 1.03381379336405498925, 0.65313624472864661996 },
{ /*167 f=16700 */ 1.03941102702649845746, 0.65313624472864661996 },
{ /*168 f=16800 */ 1.04499712943189759784, 0.65313624472864661996 },
{ /*169 f=16900 */ 1.05057204075758403583, 0.65313624472864661996 },
{ /*170 f=17000 */ 1.05613570130073597397, 0.65313624472864661996 },
{ /*171 f=17100 */ 1.06168805147901901265, 0.65313624472864661996 },
{ /*172 f=17200 */ 1.06722903183122297399, 0.65313624472864661996 },
{ /*173 f=17300 */ 1.07275858301790050220, 0.65313624472864661996 },
{ /*174 f=17400 */ 1.07827664582200033472, 0.65313624472864661996 },
{ /*175 f=17500 */ 1.08378316114950346005, 0.65313624472864661996 },
{ /*176 f=17600 */ 1.08927807003005394648, 0.65313624472864661996 },
{ /*177 f=17700 */ 1.09476131361759310145, 0.65313624472864661996 },
{ /*178 f=17800 */ 1.10023283319098674760, 0.65313624472864661996 },
{ /*179 f=17900 */ 1.10569257015465582938, 0.65313624472864661996 },
{ /*180 f=18000 */ 1.11114046603920435530, 0.65313624472864661996 },
{ /*181 f=18100 */ 1.11657646250204400928, 0.65313624472864661996 },
{ /*182 f=18200 */ 1.12200050132801965042, 0.65313624472864661996 },
{ /*183 f=18300 */ 1.12741252443003325823, 0.65313624472864661996 },
{ /*184 f=18400 */ 1.13281247384966565761, 0.65313624472864661996 },
{ /*185 f=18500 */ 1.13820029175779646735, 0.65313624472864661996 },
{ /*186 f=18600 */ 1.14357592045522449276, 0.65313624472864661996 },
{ /*187 f=18700 */ 1.14893930237328523170, 0.65313624472864661996 },
{ /*188 f=18800 */ 1.15429038007446727043, 0.65313624472864661996 },
{ /*189 f=18900 */ 1.15962909625302712513, 0.65313624472864661996 },
{ /*190 f=19000 */ 1.16495539373560430541, 0.65313624472864661996 },
{ /*191 f=19100 */ 1.17026921548183104882, 0.65313624472864661996 },
{ /*192 f=19200 */ 1.17557050458494627421, 0.65313624472864661996 },
{ /*193 f=19300 */ 1.18085920427240220754, 0.65313624472864661996 },
{ /*194 f=19400 */ 1.18613525790647433844, 0.65313624472864661996 },
{ /*195 f=19500 */ 1.19139860898486671381, 0.65313624472864661996 },
{ /*196 f=19600 */ 1.19664920114131789752, 0.65313624472864661996 },
{ /*197 f=19700 */ 1.20188697814620470972, 0.65313624472864661996 },
{ /*198 f=19800 */ 1.20711188390714285745, 0.65313624472864661996 },
{ /*199 f=19900 */ 1.21232386246958934173, 0.65313624472864661996 },
{ /*200 f=20000 */ 1.21752285801744131177, 0.65313624472864661996 },
{ /*201 f=20100 */ 1.22270881487363292095, 0.65313624472864661996 },
{ /*202 f=20200 */ 1.22788167750073284878, 0.65313624472864661996 },
{ /*203 f=20300 */ 1.23304139050153827029, 0.65313624472864661996 },
{ /*204 f=20400 */ 1.23818789861966793708, 0.65313624472864661996 },
{ /*205 f=20500 */ 1.24332114674015481448, 0.65313624472864661996 },
{ /*206 f=20600 */ 1.24844107989003516579, 0.65313624472864661996 },
{ /*207 f=20700 */ 1.25354764323893919098, 0.65313624472864661996 },
{ /*208 f=20800 */ 1.25864078209967500399, 0.65313624472864661996 },
{ /*209 f=20900 */ 1.26372044192881749503, 0.65313624472864661996 },
{ /*210 f=21000 */ 1.26878656832729097559, 0.65313624472864661996 },
{ /*211 f=21100 */ 1.27383910704095182354, 0.65313624472864661996 },
{ /*212 f=21200 */ 1.27887800396116935175, 0.65313624472864661996 },
{ /*213 f=21300 */ 1.28390320512540601072, 0.65313624472864661996 },
{ /*214 f=21400 */ 1.28891465671779492652, 0.65313624472864661996 },
{ /*215 f=21500 */ 1.29391230506971455227, 0.65313624472864661996 },
{ /*216 f=21600 */ 1.29889609666036731639, 0.65313624472864661996 },
{ /*217 f=21700 */ 1.30386597811734850083, 0.65313624472864661996 },
{ /*218 f=21800 */ 1.30882189621722067052, 0.65313624472864661996 },
{ /*219 f=21900 */ 1.31376379788608255161, 0.65313624472864661996 },
{ /*220 f=22000 */ 1.31869163020013768772, 0.65313624472864661996 },
{ /*221 f=22100 */ 1.32360534038626065367, 0.65313624472864661996 },
{ /*222 f=22200 */ 1.32850487582256349128, 0.65313624472864661996 },
{ /*223 f=22300 */ 1.33339018403895726017, 0.65313624472864661996 },
{ /*224 f=22400 */ 1.33826121271771647514, 0.65313624472864661996 },
{ /*225 f=22500 */ 1.34311790969403666018, 0.65313624472864661996 },
{ /*226 f=22600 */ 1.34796022295659567725, 0.65313624472864661996 },
{ /*227 f=22700 */ 1.35278810064810839364, 0.65313624472864661996 },
{ /*228 f=22800 */ 1.35760149106588334789, 0.65313624472864661996 },
{ /*229 f=22900 */ 1.36240034266237652893, 0.65313624472864661996 },
{ /*230 f=23000 */ 1.36718460404574249090, 0.65313624472864661996 },
{ /*231 f=23100 */ 1.37195422398038568979, 0.65313624472864661996 },
{ /*232 f=23200 */ 1.37670915138750782347, 0.65313624472864661996 },
{ /*233 f=23300 */ 1.38144933534565739208, 0.65313624472864661996 },
{ /*234 f=23400 */ 1.38617472509127170888, 0.65313624472864661996 },
{ /*235 f=23500 */ 1.39088527001922335202, 0.65313624472864661996 },
{ /*236 f=23600 */ 1.39558091968336017707, 0.65313624472864661996 },
{ /*237 f=23700 */ 1.40026162379704732786, 0.65313624472864661996 },
{ /*238 f=23800 */ 1.40492733223370347417, 0.65313624472864661996 },
{ /*239 f=23900 */ 1.40957799502734015817, 0.65313624472864661996 },
{ /*240 f=24000 */ 1.41421356237309492343, 0.65313624472864661996 }
};
static FLOAT_T vsf_q20[241][2] = {
{ /* dummy entry */ 0, 0},
{ /*  1 f=  100 */ 0.00654497301305325026, 0.44116862414430002559 },
{ /*  2 f=  200 */ 0.01308987593470371628, 0.44116862414430002559 },
{ /*  3 f=  300 */ 0.01963463867429923390, 0.44116862414430002559 },
{ /*  4 f=  400 */ 0.02617919114268887903, 0.44116862414430002559 },
{ /*  5 f=  500 */ 0.03272346325297356001, 0.44116862414430002559 },
{ /*  6 f=  600 */ 0.03926738492125660118, 0.44116862414430002559 },
{ /*  7 f=  700 */ 0.04581088606739427971, 0.44116862414430002559 },
{ /*  8 f=  800 */ 0.05235389661574629816, 0.44116862414430002559 },
{ /*  9 f=  900 */ 0.05889634649592632304, 0.44116862414430002559 },
{ /* 10 f= 1000 */ 0.06543816564355227350, 0.44116862414430002559 },
{ /* 11 f= 1100 */ 0.07197928400099674884, 0.44116862414430002559 },
{ /* 12 f= 1200 */ 0.07851963151813722008, 0.44116862414430002559 },
{ /* 13 f= 1300 */ 0.08505913815310624237, 0.44116862414430002559 },
{ /* 14 f= 1400 */ 0.09159773387304154246, 0.44116862414430002559 },
{ /* 15 f= 1500 */ 0.09813534865483602987, 0.44116862414430002559 },
{ /* 16 f= 1600 */ 0.10467191248588765540, 0.44116862414430002559 },
{ /* 17 f= 1700 */ 0.11120735536484922801, 0.44116862414430002559 },
{ /* 18 f= 1800 */ 0.11774160730237806516, 0.44116862414430002559 },
{ /* 19 f= 1900 */ 0.12427459832188544886, 0.44116862414430002559 },
{ /* 20 f= 2000 */ 0.13080625846028612336, 0.44116862414430002559 },
{ /* 21 f= 2100 */ 0.13733651776874752914, 0.44116862414430002559 },
{ /* 22 f= 2200 */ 0.14386530631343877329, 0.44116862414430002559 },
{ /* 23 f= 2300 */ 0.15039255417627980793, 0.44116862414430002559 },
{ /* 24 f= 2400 */ 0.15691819145568988714, 0.44116862414430002559 },
{ /* 25 f= 2500 */ 0.16344214826733644008, 0.44116862414430002559 },
{ /* 26 f= 2600 */ 0.16996435474488333361, 0.44116862414430002559 },
{ /* 27 f= 2700 */ 0.17648474104073902380, 0.44116862414430002559 },
{ /* 28 f= 2800 */ 0.18300323732680476296, 0.44116862414430002559 },
{ /* 29 f= 2900 */ 0.18951977379522222389, 0.44116862414430002559 },
{ /* 30 f= 3000 */ 0.19603428065912120726, 0.44116862414430002559 },
{ /* 31 f= 3100 */ 0.20254668815336684951, 0.44116862414430002559 },
{ /* 32 f= 3200 */ 0.20905692653530691394, 0.44116862414430002559 },
{ /* 33 f= 3300 */ 0.21556492608551869328, 0.44116862414430002559 },
{ /* 34 f= 3400 */ 0.22207061710855535708, 0.44116862414430002559 },
{ /* 35 f= 3500 */ 0.22857392993369279877, 0.44116862414430002559 },
{ /* 36 f= 3600 */ 0.23507479491567528918, 0.44116862414430002559 },
{ /* 37 f= 3700 */ 0.24157314243546165744, 0.44116862414430002559 },
{ /* 38 f= 3800 */ 0.24806890290097063922, 0.44116862414430002559 },
{ /* 39 f= 3900 */ 0.25456200674782641924, 0.44116862414430002559 },
{ /* 40 f= 4000 */ 0.26105238444010314680, 0.44116862414430002559 },
{ /* 41 f= 4100 */ 0.26753996647107025630, 0.44116862414430002559 },
{ /* 42 f= 4200 */ 0.27402468336393603909, 0.44116862414430002559 },
{ /* 43 f= 4300 */ 0.28050646567259251984, 0.44116862414430002559 },
{ /* 44 f= 4400 */ 0.28698524398235858435, 0.44116862414430002559 },
{ /* 45 f= 4500 */ 0.29346094891072349586, 0.44116862414430002559 },
{ /* 46 f= 4600 */ 0.29993351110809002291, 0.44116862414430002559 },
{ /* 47 f= 4700 */ 0.30640286125851695642, 0.44116862414430002559 },
{ /* 48 f= 4800 */ 0.31286893008046173792, 0.44116862414430002559 },
{ /* 49 f= 4900 */ 0.31933164832752197748, 0.44116862414430002559 },
{ /* 50 f= 5000 */ 0.32579094678917747130, 0.44116862414430002559 },
{ /* 51 f= 5100 */ 0.33224675629153094247, 0.44116862414430002559 },
{ /* 52 f= 5200 */ 0.33869900769804922591, 0.44116862414430002559 },
{ /* 53 f= 5300 */ 0.34514763191030339851, 0.44116862414430002559 },
{ /* 54 f= 5400 */ 0.35159255986870902033, 0.44116862414430002559 },
{ /* 55 f= 5500 */ 0.35803372255326532114, 0.44116862414430002559 },
{ /* 56 f= 5600 */ 0.36447105098429494197, 0.44116862414430002559 },
{ /* 57 f= 5700 */ 0.37090447622318184484, 0.44116862414430002559 },
{ /* 58 f= 5800 */ 0.37733392937311044379, 0.44116862414430002559 },
{ /* 59 f= 5900 */ 0.38375934157980284844, 0.44116862414430002559 },
{ /* 60 f= 6000 */ 0.39018064403225649617, 0.44116862414430002559 },
{ /* 61 f= 6100 */ 0.39659776796348089611, 0.44116862414430002559 },
{ /* 62 f= 6200 */ 0.40301064465123426217, 0.44116862414430002559 },
{ /* 63 f= 6300 */ 0.40941920541875920225, 0.44116862414430002559 },
{ /* 64 f= 6400 */ 0.41582338163551862964, 0.44116862414430002559 },
{ /* 65 f= 6500 */ 0.42222310471793028652, 0.44116862414430002559 },
{ /* 66 f= 6600 */ 0.42861830613010154511, 0.44116862414430002559 },
{ /* 67 f= 6700 */ 0.43500891738456293201, 0.44116862414430002559 },
{ /* 68 f= 6800 */ 0.44139487004300215212, 0.44116862414430002559 },
{ /* 69 f= 6900 */ 0.44777609571699672486, 0.44116862414430002559 },
{ /* 70 f= 7000 */ 0.45415252606874645380, 0.44116862414430002559 },
{ /* 71 f= 7100 */ 0.46052409281180473055, 0.44116862414430002559 },
{ /* 72 f= 7200 */ 0.46689072771181078236, 0.44116862414430002559 },
{ /* 73 f= 7300 */ 0.47325236258721975480, 0.44116862414430002559 },
{ /* 74 f= 7400 */ 0.47960892931003307194, 0.44116862414430002559 },
{ /* 75 f= 7500 */ 0.48596035980652774189, 0.44116862414430002559 },
{ /* 76 f= 7600 */ 0.49230658605798605088, 0.44116862414430002559 },
{ /* 77 f= 7700 */ 0.49864754010142336993, 0.44116862414430002559 },
{ /* 78 f= 7800 */ 0.50498315403031590609, 0.44116862414430002559 },
{ /* 79 f= 7900 */ 0.51131335999532878667, 0.44116862414430002559 },
{ /* 80 f= 8000 */ 0.51763809020504147895, 0.44116862414430002559 },
{ /* 81 f= 8100 */ 0.52395727692667493081, 0.44116862414430002559 },
{ /* 82 f= 8200 */ 0.53027085248681604668, 0.44116862414430002559 },
{ /* 83 f= 8300 */ 0.53657874927214277427, 0.44116862414430002559 },
{ /* 84 f= 8400 */ 0.54288089973014852507, 0.44116862414430002559 },
{ /* 85 f= 8500 */ 0.54917723636986470748, 0.44116862414430002559 },
{ /* 86 f= 8600 */ 0.55546769176258437017, 0.44116862414430002559 },
{ /* 87 f= 8700 */ 0.56175219854258418017, 0.44116862414430002559 },
{ /* 88 f= 8800 */ 0.56803068940784517959, 0.44116862414430002559 },
{ /* 89 f= 8900 */ 0.57430309712077465267, 0.44116862414430002559 },
{ /* 90 f= 9000 */ 0.58056935450892466211, 0.44116862414430002559 },
{ /* 91 f= 9100 */ 0.58682939446571336095, 0.44116862414430002559 },
{ /* 92 f= 9200 */ 0.59308314995114197465, 0.44116862414430002559 },
{ /* 93 f= 9300 */ 0.59933055399251322637, 0.44116862414430002559 },
{ /* 94 f= 9400 */ 0.60557153968514920717, 0.44116862414430002559 },
{ /* 95 f= 9500 */ 0.61180604019310691477, 0.44116862414430002559 },
{ /* 96 f= 9600 */ 0.61803398874989479150, 0.44116862414430002559 },
{ /* 97 f= 9700 */ 0.62425531865918737484, 0.44116862414430002559 },
{ /* 98 f= 9800 */ 0.63046996329553928184, 0.44116862414430002559 },
{ /* 99 f= 9900 */ 0.63667785610509941563, 0.44116862414430002559 },
{ /*100 f=10000 */ 0.64287893060632317344, 0.44116862414430002559 },
{ /*101 f=10100 */ 0.64907312039068432163, 0.44116862414430002559 },
{ /*102 f=10200 */ 0.65526035912338698175, 0.44116862414430002559 },
{ /*103 f=10300 */ 0.66144058054407484093, 0.44116862414430002559 },
{ /*104 f=10400 */ 0.66761371846754191672, 0.44116862414430002559 },
{ /*105 f=10500 */ 0.67377970678444010222, 0.44116862414430002559 },
{ /*106 f=10600 */ 0.67993847946198837651, 0.44116862414430002559 },
{ /*107 f=10700 */ 0.68608997054467968368, 0.44116862414430002559 },
{ /*108 f=10800 */ 0.69223411415498592447, 0.44116862414430002559 },
{ /*109 f=10900 */ 0.69837084449406572340, 0.44116862414430002559 },
{ /*110 f=11000 */ 0.70450009584246697791, 0.44116862414430002559 },
{ /*111 f=11100 */ 0.71062180256083218310, 0.44116862414430002559 },
{ /*112 f=11200 */ 0.71673589909060053671, 0.44116862414430002559 },
{ /*113 f=11300 */ 0.72284231995471004417, 0.44116862414430002559 },
{ /*114 f=11400 */ 0.72894099975829929061, 0.44116862414430002559 },
{ /*115 f=11500 */ 0.73503187318940710338, 0.44116862414430002559 },
{ /*116 f=11600 */ 0.74111487501967243663, 0.44116862414430002559 },
{ /*117 f=11700 */ 0.74718994010503270164, 0.44116862414430002559 },
{ /*118 f=11800 */ 0.75325700338642143095, 0.44116862414430002559 },
{ /*119 f=11900 */ 0.75931599989046549837, 0.44116862414430002559 },
{ /*120 f=12000 */ 0.76536686473017956356, 0.44116862414430002559 },
{ /*121 f=12100 */ 0.77140953310566262591, 0.44116862414430002559 },
{ /*122 f=12200 */ 0.77744394030479113678, 0.44116862414430002559 },
{ /*123 f=12300 */ 0.78347002170391177867, 0.44116862414430002559 },
{ /*124 f=12400 */ 0.78948771276853446643, 0.44116862414430002559 },
{ /*125 f=12500 */ 0.79549694905402212886, 0.44116862414430002559 },
{ /*126 f=12600 */ 0.80149766620628193348, 0.44116862414430002559 },
{ /*127 f=12700 */ 0.80748979996245418000, 0.44116862414430002559 },
{ /*128 f=12800 */ 0.81347328615160030552, 0.44116862414430002559 },
{ /*129 f=12900 */ 0.81944806069539055660, 0.44116862414430002559 },
{ /*130 f=13000 */ 0.82541405960878933001, 0.44116862414430002559 },
{ /*131 f=13100 */ 0.83137121900074162362, 0.44116862414430002559 },
{ /*132 f=13200 */ 0.83731947507485626758, 0.44116862414430002559 },
{ /*133 f=13300 */ 0.84325876413008904464, 0.44116862414430002559 },
{ /*134 f=13400 */ 0.84918902256142625440, 0.44116862414430002559 },
{ /*135 f=13500 */ 0.85511018686056416982, 0.44116862414430002559 },
{ /*136 f=13600 */ 0.86102219361659015906, 0.44116862414430002559 },
{ /*137 f=13700 */ 0.86692497951666180889, 0.44116862414430002559 },
{ /*138 f=13800 */ 0.87281848134668404970, 0.44116862414430002559 },
{ /*139 f=13900 */ 0.87870263599198739080, 0.44116862414430002559 },
{ /*140 f=14000 */ 0.88457738043800260286, 0.44116862414430002559 },
{ /*141 f=14100 */ 0.89044265177093639974, 0.44116862414430002559 },
{ /*142 f=14200 */ 0.89629838717844512175, 0.44116862414430002559 },
{ /*143 f=14300 */ 0.90214452395030675369, 0.44116862414430002559 },
{ /*144 f=14400 */ 0.90798099947909349794, 0.44116862414430002559 },
{ /*145 f=14500 */ 0.91380775126084123894, 0.44116862414430002559 },
{ /*146 f=14600 */ 0.91962471689571967381, 0.44116862414430002559 },
{ /*147 f=14700 */ 0.92543183408870022255, 0.44116862414430002559 },
{ /*148 f=14800 */ 0.93122904065022282794, 0.44116862414430002559 },
{ /*149 f=14900 */ 0.93701627449686286653, 0.44116862414430002559 },
{ /*150 f=15000 */ 0.94279347365199528408, 0.44116862414430002559 },
{ /*151 f=15100 */ 0.94856057624645839788, 0.44116862414430002559 },
{ /*152 f=15200 */ 0.95431752051921681090, 0.44116862414430002559 },
{ /*153 f=15300 */ 0.96006424481802221660, 0.44116862414430002559 },
{ /*154 f=15400 */ 0.96580068760007475870, 0.44116862414430002559 },
{ /*155 f=15500 */ 0.97152678743268006123, 0.44116862414430002559 },
{ /*156 f=15600 */ 0.97724248299390981121, 0.44116862414430002559 },
{ /*157 f=15700 */ 0.98294771307325645715, 0.44116862414430002559 },
{ /*158 f=15800 */ 0.98864241657228923987, 0.44116862414430002559 },
{ /*159 f=15900 */ 0.99432653250530855793, 0.44116862414430002559 },
{ /*160 f=16000 */ 0.99999999999999988898, 0.44116862414430002559 },
{ /*161 f=16100 */ 1.00566275829808415843, 0.44116862414430002559 },
{ /*162 f=16200 */ 1.01131474675596910728, 0.44116862414430002559 },
{ /*163 f=16300 */ 1.01695590484539954979, 0.44116862414430002559 },
{ /*164 f=16400 */ 1.02258617215410430035, 0.44116862414430002559 },
{ /*165 f=16500 */ 1.02820548838644332257, 0.44116862414430002559 },
{ /*166 f=16600 */ 1.03381379336405498925, 0.44116862414430002559 },
{ /*167 f=16700 */ 1.03941102702649845746, 0.44116862414430002559 },
{ /*168 f=16800 */ 1.04499712943189759784, 0.44116862414430002559 },
{ /*169 f=16900 */ 1.05057204075758403583, 0.44116862414430002559 },
{ /*170 f=17000 */ 1.05613570130073597397, 0.44116862414430002559 },
{ /*171 f=17100 */ 1.06168805147901901265, 0.44116862414430002559 },
{ /*172 f=17200 */ 1.06722903183122297399, 0.44116862414430002559 },
{ /*173 f=17300 */ 1.07275858301790050220, 0.44116862414430002559 },
{ /*174 f=17400 */ 1.07827664582200033472, 0.44116862414430002559 },
{ /*175 f=17500 */ 1.08378316114950346005, 0.44116862414430002559 },
{ /*176 f=17600 */ 1.08927807003005394648, 0.44116862414430002559 },
{ /*177 f=17700 */ 1.09476131361759310145, 0.44116862414430002559 },
{ /*178 f=17800 */ 1.10023283319098674760, 0.44116862414430002559 },
{ /*179 f=17900 */ 1.10569257015465582938, 0.44116862414430002559 },
{ /*180 f=18000 */ 1.11114046603920435530, 0.44116862414430002559 },
{ /*181 f=18100 */ 1.11657646250204400928, 0.44116862414430002559 },
{ /*182 f=18200 */ 1.12200050132801965042, 0.44116862414430002559 },
{ /*183 f=18300 */ 1.12741252443003325823, 0.44116862414430002559 },
{ /*184 f=18400 */ 1.13281247384966565761, 0.44116862414430002559 },
{ /*185 f=18500 */ 1.13820029175779646735, 0.44116862414430002559 },
{ /*186 f=18600 */ 1.14357592045522449276, 0.44116862414430002559 },
{ /*187 f=18700 */ 1.14893930237328523170, 0.44116862414430002559 },
{ /*188 f=18800 */ 1.15429038007446727043, 0.44116862414430002559 },
{ /*189 f=18900 */ 1.15962909625302712513, 0.44116862414430002559 },
{ /*190 f=19000 */ 1.16495539373560430541, 0.44116862414430002559 },
{ /*191 f=19100 */ 1.17026921548183104882, 0.44116862414430002559 },
{ /*192 f=19200 */ 1.17557050458494627421, 0.44116862414430002559 },
{ /*193 f=19300 */ 1.18085920427240220754, 0.44116862414430002559 },
{ /*194 f=19400 */ 1.18613525790647433844, 0.44116862414430002559 },
{ /*195 f=19500 */ 1.19139860898486671381, 0.44116862414430002559 },
{ /*196 f=19600 */ 1.19664920114131789752, 0.44116862414430002559 },
{ /*197 f=19700 */ 1.20188697814620470972, 0.44116862414430002559 },
{ /*198 f=19800 */ 1.20711188390714285745, 0.44116862414430002559 },
{ /*199 f=19900 */ 1.21232386246958934173, 0.44116862414430002559 },
{ /*200 f=20000 */ 1.21752285801744131177, 0.44116862414430002559 },
{ /*201 f=20100 */ 1.22270881487363292095, 0.44116862414430002559 },
{ /*202 f=20200 */ 1.22788167750073284878, 0.44116862414430002559 },
{ /*203 f=20300 */ 1.23304139050153827029, 0.44116862414430002559 },
{ /*204 f=20400 */ 1.23818789861966793708, 0.44116862414430002559 },
{ /*205 f=20500 */ 1.24332114674015481448, 0.44116862414430002559 },
{ /*206 f=20600 */ 1.24844107989003516579, 0.44116862414430002559 },
{ /*207 f=20700 */ 1.25354764323893919098, 0.44116862414430002559 },
{ /*208 f=20800 */ 1.25864078209967500399, 0.44116862414430002559 },
{ /*209 f=20900 */ 1.26372044192881749503, 0.44116862414430002559 },
{ /*210 f=21000 */ 1.26878656832729097559, 0.44116862414430002559 },
{ /*211 f=21100 */ 1.27383910704095182354, 0.44116862414430002559 },
{ /*212 f=21200 */ 1.27887800396116935175, 0.44116862414430002559 },
{ /*213 f=21300 */ 1.28390320512540601072, 0.44116862414430002559 },
{ /*214 f=21400 */ 1.28891465671779492652, 0.44116862414430002559 },
{ /*215 f=21500 */ 1.29391230506971455227, 0.44116862414430002559 },
{ /*216 f=21600 */ 1.29889609666036731639, 0.44116862414430002559 },
{ /*217 f=21700 */ 1.30386597811734850083, 0.44116862414430002559 },
{ /*218 f=21800 */ 1.30882189621722067052, 0.44116862414430002559 },
{ /*219 f=21900 */ 1.31376379788608255161, 0.44116862414430002559 },
{ /*220 f=22000 */ 1.31869163020013768772, 0.44116862414430002559 },
{ /*221 f=22100 */ 1.32360534038626065367, 0.44116862414430002559 },
{ /*222 f=22200 */ 1.32850487582256349128, 0.44116862414430002559 },
{ /*223 f=22300 */ 1.33339018403895726017, 0.44116862414430002559 },
{ /*224 f=22400 */ 1.33826121271771647514, 0.44116862414430002559 },
{ /*225 f=22500 */ 1.34311790969403666018, 0.44116862414430002559 },
{ /*226 f=22600 */ 1.34796022295659567725, 0.44116862414430002559 },
{ /*227 f=22700 */ 1.35278810064810839364, 0.44116862414430002559 },
{ /*228 f=22800 */ 1.35760149106588334789, 0.44116862414430002559 },
{ /*229 f=22900 */ 1.36240034266237652893, 0.44116862414430002559 },
{ /*230 f=23000 */ 1.36718460404574249090, 0.44116862414430002559 },
{ /*231 f=23100 */ 1.37195422398038568979, 0.44116862414430002559 },
{ /*232 f=23200 */ 1.37670915138750782347, 0.44116862414430002559 },
{ /*233 f=23300 */ 1.38144933534565739208, 0.44116862414430002559 },
{ /*234 f=23400 */ 1.38617472509127170888, 0.44116862414430002559 },
{ /*235 f=23500 */ 1.39088527001922335202, 0.44116862414430002559 },
{ /*236 f=23600 */ 1.39558091968336017707, 0.44116862414430002559 },
{ /*237 f=23700 */ 1.40026162379704732786, 0.44116862414430002559 },
{ /*238 f=23800 */ 1.40492733223370347417, 0.44116862414430002559 },
{ /*239 f=23900 */ 1.40957799502734015817, 0.44116862414430002559 },
{ /*240 f=24000 */ 1.41421356237309492343, 0.44116862414430002559 }
};
static FLOAT_T vsf_q30[241][2] = {
{ /* dummy entry */ 0, 0},
{ /*  1 f=  100 */ 0.00654497301305325026, 0.31920639582883225671 },
{ /*  2 f=  200 */ 0.01308987593470371628, 0.31920639582883225671 },
{ /*  3 f=  300 */ 0.01963463867429923390, 0.31920639582883225671 },
{ /*  4 f=  400 */ 0.02617919114268887903, 0.31920639582883225671 },
{ /*  5 f=  500 */ 0.03272346325297356001, 0.31920639582883225671 },
{ /*  6 f=  600 */ 0.03926738492125660118, 0.31920639582883225671 },
{ /*  7 f=  700 */ 0.04581088606739427971, 0.31920639582883225671 },
{ /*  8 f=  800 */ 0.05235389661574629816, 0.31920639582883225671 },
{ /*  9 f=  900 */ 0.05889634649592632304, 0.31920639582883225671 },
{ /* 10 f= 1000 */ 0.06543816564355227350, 0.31920639582883225671 },
{ /* 11 f= 1100 */ 0.07197928400099674884, 0.31920639582883225671 },
{ /* 12 f= 1200 */ 0.07851963151813722008, 0.31920639582883225671 },
{ /* 13 f= 1300 */ 0.08505913815310624237, 0.31920639582883225671 },
{ /* 14 f= 1400 */ 0.09159773387304154246, 0.31920639582883225671 },
{ /* 15 f= 1500 */ 0.09813534865483602987, 0.31920639582883225671 },
{ /* 16 f= 1600 */ 0.10467191248588765540, 0.31920639582883225671 },
{ /* 17 f= 1700 */ 0.11120735536484922801, 0.31920639582883225671 },
{ /* 18 f= 1800 */ 0.11774160730237806516, 0.31920639582883225671 },
{ /* 19 f= 1900 */ 0.12427459832188544886, 0.31920639582883225671 },
{ /* 20 f= 2000 */ 0.13080625846028612336, 0.31920639582883225671 },
{ /* 21 f= 2100 */ 0.13733651776874752914, 0.31920639582883225671 },
{ /* 22 f= 2200 */ 0.14386530631343877329, 0.31920639582883225671 },
{ /* 23 f= 2300 */ 0.15039255417627980793, 0.31920639582883225671 },
{ /* 24 f= 2400 */ 0.15691819145568988714, 0.31920639582883225671 },
{ /* 25 f= 2500 */ 0.16344214826733644008, 0.31920639582883225671 },
{ /* 26 f= 2600 */ 0.16996435474488333361, 0.31920639582883225671 },
{ /* 27 f= 2700 */ 0.17648474104073902380, 0.31920639582883225671 },
{ /* 28 f= 2800 */ 0.18300323732680476296, 0.31920639582883225671 },
{ /* 29 f= 2900 */ 0.18951977379522222389, 0.31920639582883225671 },
{ /* 30 f= 3000 */ 0.19603428065912120726, 0.31920639582883225671 },
{ /* 31 f= 3100 */ 0.20254668815336684951, 0.31920639582883225671 },
{ /* 32 f= 3200 */ 0.20905692653530691394, 0.31920639582883225671 },
{ /* 33 f= 3300 */ 0.21556492608551869328, 0.31920639582883225671 },
{ /* 34 f= 3400 */ 0.22207061710855535708, 0.31920639582883225671 },
{ /* 35 f= 3500 */ 0.22857392993369279877, 0.31920639582883225671 },
{ /* 36 f= 3600 */ 0.23507479491567528918, 0.31920639582883225671 },
{ /* 37 f= 3700 */ 0.24157314243546165744, 0.31920639582883225671 },
{ /* 38 f= 3800 */ 0.24806890290097063922, 0.31920639582883225671 },
{ /* 39 f= 3900 */ 0.25456200674782641924, 0.31920639582883225671 },
{ /* 40 f= 4000 */ 0.26105238444010314680, 0.31920639582883225671 },
{ /* 41 f= 4100 */ 0.26753996647107025630, 0.31920639582883225671 },
{ /* 42 f= 4200 */ 0.27402468336393603909, 0.31920639582883225671 },
{ /* 43 f= 4300 */ 0.28050646567259251984, 0.31920639582883225671 },
{ /* 44 f= 4400 */ 0.28698524398235858435, 0.31920639582883225671 },
{ /* 45 f= 4500 */ 0.29346094891072349586, 0.31920639582883225671 },
{ /* 46 f= 4600 */ 0.29993351110809002291, 0.31920639582883225671 },
{ /* 47 f= 4700 */ 0.30640286125851695642, 0.31920639582883225671 },
{ /* 48 f= 4800 */ 0.31286893008046173792, 0.31920639582883225671 },
{ /* 49 f= 4900 */ 0.31933164832752197748, 0.31920639582883225671 },
{ /* 50 f= 5000 */ 0.32579094678917747130, 0.31920639582883225671 },
{ /* 51 f= 5100 */ 0.33224675629153094247, 0.31920639582883225671 },
{ /* 52 f= 5200 */ 0.33869900769804922591, 0.31920639582883225671 },
{ /* 53 f= 5300 */ 0.34514763191030339851, 0.31920639582883225671 },
{ /* 54 f= 5400 */ 0.35159255986870902033, 0.31920639582883225671 },
{ /* 55 f= 5500 */ 0.35803372255326532114, 0.31920639582883225671 },
{ /* 56 f= 5600 */ 0.36447105098429494197, 0.31920639582883225671 },
{ /* 57 f= 5700 */ 0.37090447622318184484, 0.31920639582883225671 },
{ /* 58 f= 5800 */ 0.37733392937311044379, 0.31920639582883225671 },
{ /* 59 f= 5900 */ 0.38375934157980284844, 0.31920639582883225671 },
{ /* 60 f= 6000 */ 0.39018064403225649617, 0.31920639582883225671 },
{ /* 61 f= 6100 */ 0.39659776796348089611, 0.31920639582883225671 },
{ /* 62 f= 6200 */ 0.40301064465123426217, 0.31920639582883225671 },
{ /* 63 f= 6300 */ 0.40941920541875920225, 0.31920639582883225671 },
{ /* 64 f= 6400 */ 0.41582338163551862964, 0.31920639582883225671 },
{ /* 65 f= 6500 */ 0.42222310471793028652, 0.31920639582883225671 },
{ /* 66 f= 6600 */ 0.42861830613010154511, 0.31920639582883225671 },
{ /* 67 f= 6700 */ 0.43500891738456293201, 0.31920639582883225671 },
{ /* 68 f= 6800 */ 0.44139487004300215212, 0.31920639582883225671 },
{ /* 69 f= 6900 */ 0.44777609571699672486, 0.31920639582883225671 },
{ /* 70 f= 7000 */ 0.45415252606874645380, 0.31920639582883225671 },
{ /* 71 f= 7100 */ 0.46052409281180473055, 0.31920639582883225671 },
{ /* 72 f= 7200 */ 0.46689072771181078236, 0.31920639582883225671 },
{ /* 73 f= 7300 */ 0.47325236258721975480, 0.31920639582883225671 },
{ /* 74 f= 7400 */ 0.47960892931003307194, 0.31920639582883225671 },
{ /* 75 f= 7500 */ 0.48596035980652774189, 0.31920639582883225671 },
{ /* 76 f= 7600 */ 0.49230658605798605088, 0.31920639582883225671 },
{ /* 77 f= 7700 */ 0.49864754010142336993, 0.31920639582883225671 },
{ /* 78 f= 7800 */ 0.50498315403031590609, 0.31920639582883225671 },
{ /* 79 f= 7900 */ 0.51131335999532878667, 0.31920639582883225671 },
{ /* 80 f= 8000 */ 0.51763809020504147895, 0.31920639582883225671 },
{ /* 81 f= 8100 */ 0.52395727692667493081, 0.31920639582883225671 },
{ /* 82 f= 8200 */ 0.53027085248681604668, 0.31920639582883225671 },
{ /* 83 f= 8300 */ 0.53657874927214277427, 0.31920639582883225671 },
{ /* 84 f= 8400 */ 0.54288089973014852507, 0.31920639582883225671 },
{ /* 85 f= 8500 */ 0.54917723636986470748, 0.31920639582883225671 },
{ /* 86 f= 8600 */ 0.55546769176258437017, 0.31920639582883225671 },
{ /* 87 f= 8700 */ 0.56175219854258418017, 0.31920639582883225671 },
{ /* 88 f= 8800 */ 0.56803068940784517959, 0.31920639582883225671 },
{ /* 89 f= 8900 */ 0.57430309712077465267, 0.31920639582883225671 },
{ /* 90 f= 9000 */ 0.58056935450892466211, 0.31920639582883225671 },
{ /* 91 f= 9100 */ 0.58682939446571336095, 0.31920639582883225671 },
{ /* 92 f= 9200 */ 0.59308314995114197465, 0.31920639582883225671 },
{ /* 93 f= 9300 */ 0.59933055399251322637, 0.31920639582883225671 },
{ /* 94 f= 9400 */ 0.60557153968514920717, 0.31920639582883225671 },
{ /* 95 f= 9500 */ 0.61180604019310691477, 0.31920639582883225671 },
{ /* 96 f= 9600 */ 0.61803398874989479150, 0.31920639582883225671 },
{ /* 97 f= 9700 */ 0.62425531865918737484, 0.31920639582883225671 },
{ /* 98 f= 9800 */ 0.63046996329553928184, 0.31920639582883225671 },
{ /* 99 f= 9900 */ 0.63667785610509941563, 0.31920639582883225671 },
{ /*100 f=10000 */ 0.64287893060632317344, 0.31920639582883225671 },
{ /*101 f=10100 */ 0.64907312039068432163, 0.31920639582883225671 },
{ /*102 f=10200 */ 0.65526035912338698175, 0.31920639582883225671 },
{ /*103 f=10300 */ 0.66144058054407484093, 0.31920639582883225671 },
{ /*104 f=10400 */ 0.66761371846754191672, 0.31920639582883225671 },
{ /*105 f=10500 */ 0.67377970678444010222, 0.31920639582883225671 },
{ /*106 f=10600 */ 0.67993847946198837651, 0.31920639582883225671 },
{ /*107 f=10700 */ 0.68608997054467968368, 0.31920639582883225671 },
{ /*108 f=10800 */ 0.69223411415498592447, 0.31920639582883225671 },
{ /*109 f=10900 */ 0.69837084449406572340, 0.31920639582883225671 },
{ /*110 f=11000 */ 0.70450009584246697791, 0.31920639582883225671 },
{ /*111 f=11100 */ 0.71062180256083218310, 0.31920639582883225671 },
{ /*112 f=11200 */ 0.71673589909060053671, 0.31920639582883225671 },
{ /*113 f=11300 */ 0.72284231995471004417, 0.31920639582883225671 },
{ /*114 f=11400 */ 0.72894099975829929061, 0.31920639582883225671 },
{ /*115 f=11500 */ 0.73503187318940710338, 0.31920639582883225671 },
{ /*116 f=11600 */ 0.74111487501967243663, 0.31920639582883225671 },
{ /*117 f=11700 */ 0.74718994010503270164, 0.31920639582883225671 },
{ /*118 f=11800 */ 0.75325700338642143095, 0.31920639582883225671 },
{ /*119 f=11900 */ 0.75931599989046549837, 0.31920639582883225671 },
{ /*120 f=12000 */ 0.76536686473017956356, 0.31920639582883225671 },
{ /*121 f=12100 */ 0.77140953310566262591, 0.31920639582883225671 },
{ /*122 f=12200 */ 0.77744394030479113678, 0.31920639582883225671 },
{ /*123 f=12300 */ 0.78347002170391177867, 0.31920639582883225671 },
{ /*124 f=12400 */ 0.78948771276853446643, 0.31920639582883225671 },
{ /*125 f=12500 */ 0.79549694905402212886, 0.31920639582883225671 },
{ /*126 f=12600 */ 0.80149766620628193348, 0.31920639582883225671 },
{ /*127 f=12700 */ 0.80748979996245418000, 0.31920639582883225671 },
{ /*128 f=12800 */ 0.81347328615160030552, 0.31920639582883225671 },
{ /*129 f=12900 */ 0.81944806069539055660, 0.31920639582883225671 },
{ /*130 f=13000 */ 0.82541405960878933001, 0.31920639582883225671 },
{ /*131 f=13100 */ 0.83137121900074162362, 0.31920639582883225671 },
{ /*132 f=13200 */ 0.83731947507485626758, 0.31920639582883225671 },
{ /*133 f=13300 */ 0.84325876413008904464, 0.31920639582883225671 },
{ /*134 f=13400 */ 0.84918902256142625440, 0.31920639582883225671 },
{ /*135 f=13500 */ 0.85511018686056416982, 0.31920639582883225671 },
{ /*136 f=13600 */ 0.86102219361659015906, 0.31920639582883225671 },
{ /*137 f=13700 */ 0.86692497951666180889, 0.31920639582883225671 },
{ /*138 f=13800 */ 0.87281848134668404970, 0.31920639582883225671 },
{ /*139 f=13900 */ 0.87870263599198739080, 0.31920639582883225671 },
{ /*140 f=14000 */ 0.88457738043800260286, 0.31920639582883225671 },
{ /*141 f=14100 */ 0.89044265177093639974, 0.31920639582883225671 },
{ /*142 f=14200 */ 0.89629838717844512175, 0.31920639582883225671 },
{ /*143 f=14300 */ 0.90214452395030675369, 0.31920639582883225671 },
{ /*144 f=14400 */ 0.90798099947909349794, 0.31920639582883225671 },
{ /*145 f=14500 */ 0.91380775126084123894, 0.31920639582883225671 },
{ /*146 f=14600 */ 0.91962471689571967381, 0.31920639582883225671 },
{ /*147 f=14700 */ 0.92543183408870022255, 0.31920639582883225671 },
{ /*148 f=14800 */ 0.93122904065022282794, 0.31920639582883225671 },
{ /*149 f=14900 */ 0.93701627449686286653, 0.31920639582883225671 },
{ /*150 f=15000 */ 0.94279347365199528408, 0.31920639582883225671 },
{ /*151 f=15100 */ 0.94856057624645839788, 0.31920639582883225671 },
{ /*152 f=15200 */ 0.95431752051921681090, 0.31920639582883225671 },
{ /*153 f=15300 */ 0.96006424481802221660, 0.31920639582883225671 },
{ /*154 f=15400 */ 0.96580068760007475870, 0.31920639582883225671 },
{ /*155 f=15500 */ 0.97152678743268006123, 0.31920639582883225671 },
{ /*156 f=15600 */ 0.97724248299390981121, 0.31920639582883225671 },
{ /*157 f=15700 */ 0.98294771307325645715, 0.31920639582883225671 },
{ /*158 f=15800 */ 0.98864241657228923987, 0.31920639582883225671 },
{ /*159 f=15900 */ 0.99432653250530855793, 0.31920639582883225671 },
{ /*160 f=16000 */ 0.99999999999999988898, 0.31920639582883225671 },
{ /*161 f=16100 */ 1.00566275829808415843, 0.31920639582883225671 },
{ /*162 f=16200 */ 1.01131474675596910728, 0.31920639582883225671 },
{ /*163 f=16300 */ 1.01695590484539954979, 0.31920639582883225671 },
{ /*164 f=16400 */ 1.02258617215410430035, 0.31920639582883225671 },
{ /*165 f=16500 */ 1.02820548838644332257, 0.31920639582883225671 },
{ /*166 f=16600 */ 1.03381379336405498925, 0.31920639582883225671 },
{ /*167 f=16700 */ 1.03941102702649845746, 0.31920639582883225671 },
{ /*168 f=16800 */ 1.04499712943189759784, 0.31920639582883225671 },
{ /*169 f=16900 */ 1.05057204075758403583, 0.31920639582883225671 },
{ /*170 f=17000 */ 1.05613570130073597397, 0.31920639582883225671 },
{ /*171 f=17100 */ 1.06168805147901901265, 0.31920639582883225671 },
{ /*172 f=17200 */ 1.06722903183122297399, 0.31920639582883225671 },
{ /*173 f=17300 */ 1.07275858301790050220, 0.31920639582883225671 },
{ /*174 f=17400 */ 1.07827664582200033472, 0.31920639582883225671 },
{ /*175 f=17500 */ 1.08378316114950346005, 0.31920639582883225671 },
{ /*176 f=17600 */ 1.08927807003005394648, 0.31920639582883225671 },
{ /*177 f=17700 */ 1.09476131361759310145, 0.31920639582883225671 },
{ /*178 f=17800 */ 1.10023283319098674760, 0.31920639582883225671 },
{ /*179 f=17900 */ 1.10569257015465582938, 0.31920639582883225671 },
{ /*180 f=18000 */ 1.11114046603920435530, 0.31920639582883225671 },
{ /*181 f=18100 */ 1.11657646250204400928, 0.31920639582883225671 },
{ /*182 f=18200 */ 1.12200050132801965042, 0.31920639582883225671 },
{ /*183 f=18300 */ 1.12741252443003325823, 0.31920639582883225671 },
{ /*184 f=18400 */ 1.13281247384966565761, 0.31920639582883225671 },
{ /*185 f=18500 */ 1.13820029175779646735, 0.31920639582883225671 },
{ /*186 f=18600 */ 1.14357592045522449276, 0.31920639582883225671 },
{ /*187 f=18700 */ 1.14893930237328523170, 0.31920639582883225671 },
{ /*188 f=18800 */ 1.15429038007446727043, 0.31920639582883225671 },
{ /*189 f=18900 */ 1.15962909625302712513, 0.31920639582883225671 },
{ /*190 f=19000 */ 1.16495539373560430541, 0.31920639582883225671 },
{ /*191 f=19100 */ 1.17026921548183104882, 0.31920639582883225671 },
{ /*192 f=19200 */ 1.17557050458494627421, 0.31920639582883225671 },
{ /*193 f=19300 */ 1.18085920427240220754, 0.31920639582883225671 },
{ /*194 f=19400 */ 1.18613525790647433844, 0.31920639582883225671 },
{ /*195 f=19500 */ 1.19139860898486671381, 0.31920639582883225671 },
{ /*196 f=19600 */ 1.19664920114131789752, 0.31920639582883225671 },
{ /*197 f=19700 */ 1.20188697814620470972, 0.31920639582883225671 },
{ /*198 f=19800 */ 1.20711188390714285745, 0.31920639582883225671 },
{ /*199 f=19900 */ 1.21232386246958934173, 0.31920639582883225671 },
{ /*200 f=20000 */ 1.21752285801744131177, 0.31920639582883225671 },
{ /*201 f=20100 */ 1.22270881487363292095, 0.31920639582883225671 },
{ /*202 f=20200 */ 1.22788167750073284878, 0.31920639582883225671 },
{ /*203 f=20300 */ 1.23304139050153827029, 0.31920639582883225671 },
{ /*204 f=20400 */ 1.23818789861966793708, 0.31920639582883225671 },
{ /*205 f=20500 */ 1.24332114674015481448, 0.31920639582883225671 },
{ /*206 f=20600 */ 1.24844107989003516579, 0.31920639582883225671 },
{ /*207 f=20700 */ 1.25354764323893919098, 0.31920639582883225671 },
{ /*208 f=20800 */ 1.25864078209967500399, 0.31920639582883225671 },
{ /*209 f=20900 */ 1.26372044192881749503, 0.31920639582883225671 },
{ /*210 f=21000 */ 1.26878656832729097559, 0.31920639582883225671 },
{ /*211 f=21100 */ 1.27383910704095182354, 0.31920639582883225671 },
{ /*212 f=21200 */ 1.27887800396116935175, 0.31920639582883225671 },
{ /*213 f=21300 */ 1.28390320512540601072, 0.31920639582883225671 },
{ /*214 f=21400 */ 1.28891465671779492652, 0.31920639582883225671 },
{ /*215 f=21500 */ 1.29391230506971455227, 0.31920639582883225671 },
{ /*216 f=21600 */ 1.29889609666036731639, 0.31920639582883225671 },
{ /*217 f=21700 */ 1.30386597811734850083, 0.31920639582883225671 },
{ /*218 f=21800 */ 1.30882189621722067052, 0.31920639582883225671 },
{ /*219 f=21900 */ 1.31376379788608255161, 0.31920639582883225671 },
{ /*220 f=22000 */ 1.31869163020013768772, 0.31920639582883225671 },
{ /*221 f=22100 */ 1.32360534038626065367, 0.31920639582883225671 },
{ /*222 f=22200 */ 1.32850487582256349128, 0.31920639582883225671 },
{ /*223 f=22300 */ 1.33339018403895726017, 0.31920639582883225671 },
{ /*224 f=22400 */ 1.33826121271771647514, 0.31920639582883225671 },
{ /*225 f=22500 */ 1.34311790969403666018, 0.31920639582883225671 },
{ /*226 f=22600 */ 1.34796022295659567725, 0.31920639582883225671 },
{ /*227 f=22700 */ 1.35278810064810839364, 0.31920639582883225671 },
{ /*228 f=22800 */ 1.35760149106588334789, 0.31920639582883225671 },
{ /*229 f=22900 */ 1.36240034266237652893, 0.31920639582883225671 },
{ /*230 f=23000 */ 1.36718460404574249090, 0.31920639582883225671 },
{ /*231 f=23100 */ 1.37195422398038568979, 0.31920639582883225671 },
{ /*232 f=23200 */ 1.37670915138750782347, 0.31920639582883225671 },
{ /*233 f=23300 */ 1.38144933534565739208, 0.31920639582883225671 },
{ /*234 f=23400 */ 1.38617472509127170888, 0.31920639582883225671 },
{ /*235 f=23500 */ 1.39088527001922335202, 0.31920639582883225671 },
{ /*236 f=23600 */ 1.39558091968336017707, 0.31920639582883225671 },
{ /*237 f=23700 */ 1.40026162379704732786, 0.31920639582883225671 },
{ /*238 f=23800 */ 1.40492733223370347417, 0.31920639582883225671 },
{ /*239 f=23900 */ 1.40957799502734015817, 0.31920639582883225671 },
{ /*240 f=24000 */ 1.41421356237309492343, 0.31920639582883225671 }
};
static FLOAT_T vsf_q40[241][2] = {
{ /* dummy entry */ 0, 0},
{ /*  1 f=  100 */ 0.00654497301305325026, 0.23838991054995539720 },
{ /*  2 f=  200 */ 0.01308987593470371628, 0.23838991054995539720 },
{ /*  3 f=  300 */ 0.01963463867429923390, 0.23838991054995539720 },
{ /*  4 f=  400 */ 0.02617919114268887903, 0.23838991054995539720 },
{ /*  5 f=  500 */ 0.03272346325297356001, 0.23838991054995539720 },
{ /*  6 f=  600 */ 0.03926738492125660118, 0.23838991054995539720 },
{ /*  7 f=  700 */ 0.04581088606739427971, 0.23838991054995539720 },
{ /*  8 f=  800 */ 0.05235389661574629816, 0.23838991054995539720 },
{ /*  9 f=  900 */ 0.05889634649592632304, 0.23838991054995539720 },
{ /* 10 f= 1000 */ 0.06543816564355227350, 0.23838991054995539720 },
{ /* 11 f= 1100 */ 0.07197928400099674884, 0.23838991054995539720 },
{ /* 12 f= 1200 */ 0.07851963151813722008, 0.23838991054995539720 },
{ /* 13 f= 1300 */ 0.08505913815310624237, 0.23838991054995539720 },
{ /* 14 f= 1400 */ 0.09159773387304154246, 0.23838991054995539720 },
{ /* 15 f= 1500 */ 0.09813534865483602987, 0.23838991054995539720 },
{ /* 16 f= 1600 */ 0.10467191248588765540, 0.23838991054995539720 },
{ /* 17 f= 1700 */ 0.11120735536484922801, 0.23838991054995539720 },
{ /* 18 f= 1800 */ 0.11774160730237806516, 0.23838991054995539720 },
{ /* 19 f= 1900 */ 0.12427459832188544886, 0.23838991054995539720 },
{ /* 20 f= 2000 */ 0.13080625846028612336, 0.23838991054995539720 },
{ /* 21 f= 2100 */ 0.13733651776874752914, 0.23838991054995539720 },
{ /* 22 f= 2200 */ 0.14386530631343877329, 0.23838991054995539720 },
{ /* 23 f= 2300 */ 0.15039255417627980793, 0.23838991054995539720 },
{ /* 24 f= 2400 */ 0.15691819145568988714, 0.23838991054995539720 },
{ /* 25 f= 2500 */ 0.16344214826733644008, 0.23838991054995539720 },
{ /* 26 f= 2600 */ 0.16996435474488333361, 0.23838991054995539720 },
{ /* 27 f= 2700 */ 0.17648474104073902380, 0.23838991054995539720 },
{ /* 28 f= 2800 */ 0.18300323732680476296, 0.23838991054995539720 },
{ /* 29 f= 2900 */ 0.18951977379522222389, 0.23838991054995539720 },
{ /* 30 f= 3000 */ 0.19603428065912120726, 0.23838991054995539720 },
{ /* 31 f= 3100 */ 0.20254668815336684951, 0.23838991054995539720 },
{ /* 32 f= 3200 */ 0.20905692653530691394, 0.23838991054995539720 },
{ /* 33 f= 3300 */ 0.21556492608551869328, 0.23838991054995539720 },
{ /* 34 f= 3400 */ 0.22207061710855535708, 0.23838991054995539720 },
{ /* 35 f= 3500 */ 0.22857392993369279877, 0.23838991054995539720 },
{ /* 36 f= 3600 */ 0.23507479491567528918, 0.23838991054995539720 },
{ /* 37 f= 3700 */ 0.24157314243546165744, 0.23838991054995539720 },
{ /* 38 f= 3800 */ 0.24806890290097063922, 0.23838991054995539720 },
{ /* 39 f= 3900 */ 0.25456200674782641924, 0.23838991054995539720 },
{ /* 40 f= 4000 */ 0.26105238444010314680, 0.23838991054995539720 },
{ /* 41 f= 4100 */ 0.26753996647107025630, 0.23838991054995539720 },
{ /* 42 f= 4200 */ 0.27402468336393603909, 0.23838991054995539720 },
{ /* 43 f= 4300 */ 0.28050646567259251984, 0.23838991054995539720 },
{ /* 44 f= 4400 */ 0.28698524398235858435, 0.23838991054995539720 },
{ /* 45 f= 4500 */ 0.29346094891072349586, 0.23838991054995539720 },
{ /* 46 f= 4600 */ 0.29993351110809002291, 0.23838991054995539720 },
{ /* 47 f= 4700 */ 0.30640286125851695642, 0.23838991054995539720 },
{ /* 48 f= 4800 */ 0.31286893008046173792, 0.23838991054995539720 },
{ /* 49 f= 4900 */ 0.31933164832752197748, 0.23838991054995539720 },
{ /* 50 f= 5000 */ 0.32579094678917747130, 0.23838991054995539720 },
{ /* 51 f= 5100 */ 0.33224675629153094247, 0.23838991054995539720 },
{ /* 52 f= 5200 */ 0.33869900769804922591, 0.23838991054995539720 },
{ /* 53 f= 5300 */ 0.34514763191030339851, 0.23838991054995539720 },
{ /* 54 f= 5400 */ 0.35159255986870902033, 0.23838991054995539720 },
{ /* 55 f= 5500 */ 0.35803372255326532114, 0.23838991054995539720 },
{ /* 56 f= 5600 */ 0.36447105098429494197, 0.23838991054995539720 },
{ /* 57 f= 5700 */ 0.37090447622318184484, 0.23838991054995539720 },
{ /* 58 f= 5800 */ 0.37733392937311044379, 0.23838991054995539720 },
{ /* 59 f= 5900 */ 0.38375934157980284844, 0.23838991054995539720 },
{ /* 60 f= 6000 */ 0.39018064403225649617, 0.23838991054995539720 },
{ /* 61 f= 6100 */ 0.39659776796348089611, 0.23838991054995539720 },
{ /* 62 f= 6200 */ 0.40301064465123426217, 0.23838991054995539720 },
{ /* 63 f= 6300 */ 0.40941920541875920225, 0.23838991054995539720 },
{ /* 64 f= 6400 */ 0.41582338163551862964, 0.23838991054995539720 },
{ /* 65 f= 6500 */ 0.42222310471793028652, 0.23838991054995539720 },
{ /* 66 f= 6600 */ 0.42861830613010154511, 0.23838991054995539720 },
{ /* 67 f= 6700 */ 0.43500891738456293201, 0.23838991054995539720 },
{ /* 68 f= 6800 */ 0.44139487004300215212, 0.23838991054995539720 },
{ /* 69 f= 6900 */ 0.44777609571699672486, 0.23838991054995539720 },
{ /* 70 f= 7000 */ 0.45415252606874645380, 0.23838991054995539720 },
{ /* 71 f= 7100 */ 0.46052409281180473055, 0.23838991054995539720 },
{ /* 72 f= 7200 */ 0.46689072771181078236, 0.23838991054995539720 },
{ /* 73 f= 7300 */ 0.47325236258721975480, 0.23838991054995539720 },
{ /* 74 f= 7400 */ 0.47960892931003307194, 0.23838991054995539720 },
{ /* 75 f= 7500 */ 0.48596035980652774189, 0.23838991054995539720 },
{ /* 76 f= 7600 */ 0.49230658605798605088, 0.23838991054995539720 },
{ /* 77 f= 7700 */ 0.49864754010142336993, 0.23838991054995539720 },
{ /* 78 f= 7800 */ 0.50498315403031590609, 0.23838991054995539720 },
{ /* 79 f= 7900 */ 0.51131335999532878667, 0.23838991054995539720 },
{ /* 80 f= 8000 */ 0.51763809020504147895, 0.23838991054995539720 },
{ /* 81 f= 8100 */ 0.52395727692667493081, 0.23838991054995539720 },
{ /* 82 f= 8200 */ 0.53027085248681604668, 0.23838991054995539720 },
{ /* 83 f= 8300 */ 0.53657874927214277427, 0.23838991054995539720 },
{ /* 84 f= 8400 */ 0.54288089973014852507, 0.23838991054995539720 },
{ /* 85 f= 8500 */ 0.54917723636986470748, 0.23838991054995539720 },
{ /* 86 f= 8600 */ 0.55546769176258437017, 0.23838991054995539720 },
{ /* 87 f= 8700 */ 0.56175219854258418017, 0.23838991054995539720 },
{ /* 88 f= 8800 */ 0.56803068940784517959, 0.23838991054995539720 },
{ /* 89 f= 8900 */ 0.57430309712077465267, 0.23838991054995539720 },
{ /* 90 f= 9000 */ 0.58056935450892466211, 0.23838991054995539720 },
{ /* 91 f= 9100 */ 0.58682939446571336095, 0.23838991054995539720 },
{ /* 92 f= 9200 */ 0.59308314995114197465, 0.23838991054995539720 },
{ /* 93 f= 9300 */ 0.59933055399251322637, 0.23838991054995539720 },
{ /* 94 f= 9400 */ 0.60557153968514920717, 0.23838991054995539720 },
{ /* 95 f= 9500 */ 0.61180604019310691477, 0.23838991054995539720 },
{ /* 96 f= 9600 */ 0.61803398874989479150, 0.23838991054995539720 },
{ /* 97 f= 9700 */ 0.62425531865918737484, 0.23838991054995539720 },
{ /* 98 f= 9800 */ 0.63046996329553928184, 0.23838991054995539720 },
{ /* 99 f= 9900 */ 0.63667785610509941563, 0.23838991054995539720 },
{ /*100 f=10000 */ 0.64287893060632317344, 0.23838991054995539720 },
{ /*101 f=10100 */ 0.64907312039068432163, 0.23838991054995539720 },
{ /*102 f=10200 */ 0.65526035912338698175, 0.23838991054995539720 },
{ /*103 f=10300 */ 0.66144058054407484093, 0.23838991054995539720 },
{ /*104 f=10400 */ 0.66761371846754191672, 0.23838991054995539720 },
{ /*105 f=10500 */ 0.67377970678444010222, 0.23838991054995539720 },
{ /*106 f=10600 */ 0.67993847946198837651, 0.23838991054995539720 },
{ /*107 f=10700 */ 0.68608997054467968368, 0.23838991054995539720 },
{ /*108 f=10800 */ 0.69223411415498592447, 0.23838991054995539720 },
{ /*109 f=10900 */ 0.69837084449406572340, 0.23838991054995539720 },
{ /*110 f=11000 */ 0.70450009584246697791, 0.23838991054995539720 },
{ /*111 f=11100 */ 0.71062180256083218310, 0.23838991054995539720 },
{ /*112 f=11200 */ 0.71673589909060053671, 0.23838991054995539720 },
{ /*113 f=11300 */ 0.72284231995471004417, 0.23838991054995539720 },
{ /*114 f=11400 */ 0.72894099975829929061, 0.23838991054995539720 },
{ /*115 f=11500 */ 0.73503187318940710338, 0.23838991054995539720 },
{ /*116 f=11600 */ 0.74111487501967243663, 0.23838991054995539720 },
{ /*117 f=11700 */ 0.74718994010503270164, 0.23838991054995539720 },
{ /*118 f=11800 */ 0.75325700338642143095, 0.23838991054995539720 },
{ /*119 f=11900 */ 0.75931599989046549837, 0.23838991054995539720 },
{ /*120 f=12000 */ 0.76536686473017956356, 0.23838991054995539720 },
{ /*121 f=12100 */ 0.77140953310566262591, 0.23838991054995539720 },
{ /*122 f=12200 */ 0.77744394030479113678, 0.23838991054995539720 },
{ /*123 f=12300 */ 0.78347002170391177867, 0.23838991054995539720 },
{ /*124 f=12400 */ 0.78948771276853446643, 0.23838991054995539720 },
{ /*125 f=12500 */ 0.79549694905402212886, 0.23838991054995539720 },
{ /*126 f=12600 */ 0.80149766620628193348, 0.23838991054995539720 },
{ /*127 f=12700 */ 0.80748979996245418000, 0.23838991054995539720 },
{ /*128 f=12800 */ 0.81347328615160030552, 0.23838991054995539720 },
{ /*129 f=12900 */ 0.81944806069539055660, 0.23838991054995539720 },
{ /*130 f=13000 */ 0.82541405960878933001, 0.23838991054995539720 },
{ /*131 f=13100 */ 0.83137121900074162362, 0.23838991054995539720 },
{ /*132 f=13200 */ 0.83731947507485626758, 0.23838991054995539720 },
{ /*133 f=13300 */ 0.84325876413008904464, 0.23838991054995539720 },
{ /*134 f=13400 */ 0.84918902256142625440, 0.23838991054995539720 },
{ /*135 f=13500 */ 0.85511018686056416982, 0.23838991054995539720 },
{ /*136 f=13600 */ 0.86102219361659015906, 0.23838991054995539720 },
{ /*137 f=13700 */ 0.86692497951666180889, 0.23838991054995539720 },
{ /*138 f=13800 */ 0.87281848134668404970, 0.23838991054995539720 },
{ /*139 f=13900 */ 0.87870263599198739080, 0.23838991054995539720 },
{ /*140 f=14000 */ 0.88457738043800260286, 0.23838991054995539720 },
{ /*141 f=14100 */ 0.89044265177093639974, 0.23838991054995539720 },
{ /*142 f=14200 */ 0.89629838717844512175, 0.23838991054995539720 },
{ /*143 f=14300 */ 0.90214452395030675369, 0.23838991054995539720 },
{ /*144 f=14400 */ 0.90798099947909349794, 0.23838991054995539720 },
{ /*145 f=14500 */ 0.91380775126084123894, 0.23838991054995539720 },
{ /*146 f=14600 */ 0.91962471689571967381, 0.23838991054995539720 },
{ /*147 f=14700 */ 0.92543183408870022255, 0.23838991054995539720 },
{ /*148 f=14800 */ 0.93122904065022282794, 0.23838991054995539720 },
{ /*149 f=14900 */ 0.93701627449686286653, 0.23838991054995539720 },
{ /*150 f=15000 */ 0.94279347365199528408, 0.23838991054995539720 },
{ /*151 f=15100 */ 0.94856057624645839788, 0.23838991054995539720 },
{ /*152 f=15200 */ 0.95431752051921681090, 0.23838991054995539720 },
{ /*153 f=15300 */ 0.96006424481802221660, 0.23838991054995539720 },
{ /*154 f=15400 */ 0.96580068760007475870, 0.23838991054995539720 },
{ /*155 f=15500 */ 0.97152678743268006123, 0.23838991054995539720 },
{ /*156 f=15600 */ 0.97724248299390981121, 0.23838991054995539720 },
{ /*157 f=15700 */ 0.98294771307325645715, 0.23838991054995539720 },
{ /*158 f=15800 */ 0.98864241657228923987, 0.23838991054995539720 },
{ /*159 f=15900 */ 0.99432653250530855793, 0.23838991054995539720 },
{ /*160 f=16000 */ 0.99999999999999988898, 0.23838991054995539720 },
{ /*161 f=16100 */ 1.00566275829808415843, 0.23838991054995539720 },
{ /*162 f=16200 */ 1.01131474675596910728, 0.23838991054995539720 },
{ /*163 f=16300 */ 1.01695590484539954979, 0.23838991054995539720 },
{ /*164 f=16400 */ 1.02258617215410430035, 0.23838991054995539720 },
{ /*165 f=16500 */ 1.02820548838644332257, 0.23838991054995539720 },
{ /*166 f=16600 */ 1.03381379336405498925, 0.23838991054995539720 },
{ /*167 f=16700 */ 1.03941102702649845746, 0.23838991054995539720 },
{ /*168 f=16800 */ 1.04499712943189759784, 0.23838991054995539720 },
{ /*169 f=16900 */ 1.05057204075758403583, 0.23838991054995539720 },
{ /*170 f=17000 */ 1.05613570130073597397, 0.23838991054995539720 },
{ /*171 f=17100 */ 1.06168805147901901265, 0.23838991054995539720 },
{ /*172 f=17200 */ 1.06722903183122297399, 0.23838991054995539720 },
{ /*173 f=17300 */ 1.07275858301790050220, 0.23838991054995539720 },
{ /*174 f=17400 */ 1.07827664582200033472, 0.23838991054995539720 },
{ /*175 f=17500 */ 1.08378316114950346005, 0.23838991054995539720 },
{ /*176 f=17600 */ 1.08927807003005394648, 0.23838991054995539720 },
{ /*177 f=17700 */ 1.09476131361759310145, 0.23838991054995539720 },
{ /*178 f=17800 */ 1.10023283319098674760, 0.23838991054995539720 },
{ /*179 f=17900 */ 1.10569257015465582938, 0.23838991054995539720 },
{ /*180 f=18000 */ 1.11114046603920435530, 0.23838991054995539720 },
{ /*181 f=18100 */ 1.11657646250204400928, 0.23838991054995539720 },
{ /*182 f=18200 */ 1.12200050132801965042, 0.23838991054995539720 },
{ /*183 f=18300 */ 1.12741252443003325823, 0.23838991054995539720 },
{ /*184 f=18400 */ 1.13281247384966565761, 0.23838991054995539720 },
{ /*185 f=18500 */ 1.13820029175779646735, 0.23838991054995539720 },
{ /*186 f=18600 */ 1.14357592045522449276, 0.23838991054995539720 },
{ /*187 f=18700 */ 1.14893930237328523170, 0.23838991054995539720 },
{ /*188 f=18800 */ 1.15429038007446727043, 0.23838991054995539720 },
{ /*189 f=18900 */ 1.15962909625302712513, 0.23838991054995539720 },
{ /*190 f=19000 */ 1.16495539373560430541, 0.23838991054995539720 },
{ /*191 f=19100 */ 1.17026921548183104882, 0.23838991054995539720 },
{ /*192 f=19200 */ 1.17557050458494627421, 0.23838991054995539720 },
{ /*193 f=19300 */ 1.18085920427240220754, 0.23838991054995539720 },
{ /*194 f=19400 */ 1.18613525790647433844, 0.23838991054995539720 },
{ /*195 f=19500 */ 1.19139860898486671381, 0.23838991054995539720 },
{ /*196 f=19600 */ 1.19664920114131789752, 0.23838991054995539720 },
{ /*197 f=19700 */ 1.20188697814620470972, 0.23838991054995539720 },
{ /*198 f=19800 */ 1.20711188390714285745, 0.23838991054995539720 },
{ /*199 f=19900 */ 1.21232386246958934173, 0.23838991054995539720 },
{ /*200 f=20000 */ 1.21752285801744131177, 0.23838991054995539720 },
{ /*201 f=20100 */ 1.22270881487363292095, 0.23838991054995539720 },
{ /*202 f=20200 */ 1.22788167750073284878, 0.23838991054995539720 },
{ /*203 f=20300 */ 1.23304139050153827029, 0.23838991054995539720 },
{ /*204 f=20400 */ 1.23818789861966793708, 0.23838991054995539720 },
{ /*205 f=20500 */ 1.24332114674015481448, 0.23838991054995539720 },
{ /*206 f=20600 */ 1.24844107989003516579, 0.23838991054995539720 },
{ /*207 f=20700 */ 1.25354764323893919098, 0.23838991054995539720 },
{ /*208 f=20800 */ 1.25864078209967500399, 0.23838991054995539720 },
{ /*209 f=20900 */ 1.26372044192881749503, 0.23838991054995539720 },
{ /*210 f=21000 */ 1.26878656832729097559, 0.23838991054995539720 },
{ /*211 f=21100 */ 1.27383910704095182354, 0.23838991054995539720 },
{ /*212 f=21200 */ 1.27887800396116935175, 0.23838991054995539720 },
{ /*213 f=21300 */ 1.28390320512540601072, 0.23838991054995539720 },
{ /*214 f=21400 */ 1.28891465671779492652, 0.23838991054995539720 },
{ /*215 f=21500 */ 1.29391230506971455227, 0.23838991054995539720 },
{ /*216 f=21600 */ 1.29889609666036731639, 0.23838991054995539720 },
{ /*217 f=21700 */ 1.30386597811734850083, 0.23838991054995539720 },
{ /*218 f=21800 */ 1.30882189621722067052, 0.23838991054995539720 },
{ /*219 f=21900 */ 1.31376379788608255161, 0.23838991054995539720 },
{ /*220 f=22000 */ 1.31869163020013768772, 0.23838991054995539720 },
{ /*221 f=22100 */ 1.32360534038626065367, 0.23838991054995539720 },
{ /*222 f=22200 */ 1.32850487582256349128, 0.23838991054995539720 },
{ /*223 f=22300 */ 1.33339018403895726017, 0.23838991054995539720 },
{ /*224 f=22400 */ 1.33826121271771647514, 0.23838991054995539720 },
{ /*225 f=22500 */ 1.34311790969403666018, 0.23838991054995539720 },
{ /*226 f=22600 */ 1.34796022295659567725, 0.23838991054995539720 },
{ /*227 f=22700 */ 1.35278810064810839364, 0.23838991054995539720 },
{ /*228 f=22800 */ 1.35760149106588334789, 0.23838991054995539720 },
{ /*229 f=22900 */ 1.36240034266237652893, 0.23838991054995539720 },
{ /*230 f=23000 */ 1.36718460404574249090, 0.23838991054995539720 },
{ /*231 f=23100 */ 1.37195422398038568979, 0.23838991054995539720 },
{ /*232 f=23200 */ 1.37670915138750782347, 0.23838991054995539720 },
{ /*233 f=23300 */ 1.38144933534565739208, 0.23838991054995539720 },
{ /*234 f=23400 */ 1.38617472509127170888, 0.23838991054995539720 },
{ /*235 f=23500 */ 1.39088527001922335202, 0.23838991054995539720 },
{ /*236 f=23600 */ 1.39558091968336017707, 0.23838991054995539720 },
{ /*237 f=23700 */ 1.40026162379704732786, 0.23838991054995539720 },
{ /*238 f=23800 */ 1.40492733223370347417, 0.23838991054995539720 },
{ /*239 f=23900 */ 1.40957799502734015817, 0.23838991054995539720 },
{ /*240 f=24000 */ 1.41421356237309492343, 0.23838991054995539720 }
};
static FLOAT_T vsf_q50[241][2] = {
{ /* dummy entry */ 0, 0},
{ /*  1 f=  100 */ 0.00654497301305325026, 0.18131342127250671403 },
{ /*  2 f=  200 */ 0.01308987593470371628, 0.18131342127250671403 },
{ /*  3 f=  300 */ 0.01963463867429923390, 0.18131342127250671403 },
{ /*  4 f=  400 */ 0.02617919114268887903, 0.18131342127250671403 },
{ /*  5 f=  500 */ 0.03272346325297356001, 0.18131342127250671403 },
{ /*  6 f=  600 */ 0.03926738492125660118, 0.18131342127250671403 },
{ /*  7 f=  700 */ 0.04581088606739427971, 0.18131342127250671403 },
{ /*  8 f=  800 */ 0.05235389661574629816, 0.18131342127250671403 },
{ /*  9 f=  900 */ 0.05889634649592632304, 0.18131342127250671403 },
{ /* 10 f= 1000 */ 0.06543816564355227350, 0.18131342127250671403 },
{ /* 11 f= 1100 */ 0.07197928400099674884, 0.18131342127250671403 },
{ /* 12 f= 1200 */ 0.07851963151813722008, 0.18131342127250671403 },
{ /* 13 f= 1300 */ 0.08505913815310624237, 0.18131342127250671403 },
{ /* 14 f= 1400 */ 0.09159773387304154246, 0.18131342127250671403 },
{ /* 15 f= 1500 */ 0.09813534865483602987, 0.18131342127250671403 },
{ /* 16 f= 1600 */ 0.10467191248588765540, 0.18131342127250671403 },
{ /* 17 f= 1700 */ 0.11120735536484922801, 0.18131342127250671403 },
{ /* 18 f= 1800 */ 0.11774160730237806516, 0.18131342127250671403 },
{ /* 19 f= 1900 */ 0.12427459832188544886, 0.18131342127250671403 },
{ /* 20 f= 2000 */ 0.13080625846028612336, 0.18131342127250671403 },
{ /* 21 f= 2100 */ 0.13733651776874752914, 0.18131342127250671403 },
{ /* 22 f= 2200 */ 0.14386530631343877329, 0.18131342127250671403 },
{ /* 23 f= 2300 */ 0.15039255417627980793, 0.18131342127250671403 },
{ /* 24 f= 2400 */ 0.15691819145568988714, 0.18131342127250671403 },
{ /* 25 f= 2500 */ 0.16344214826733644008, 0.18131342127250671403 },
{ /* 26 f= 2600 */ 0.16996435474488333361, 0.18131342127250671403 },
{ /* 27 f= 2700 */ 0.17648474104073902380, 0.18131342127250671403 },
{ /* 28 f= 2800 */ 0.18300323732680476296, 0.18131342127250671403 },
{ /* 29 f= 2900 */ 0.18951977379522222389, 0.18131342127250671403 },
{ /* 30 f= 3000 */ 0.19603428065912120726, 0.18131342127250671403 },
{ /* 31 f= 3100 */ 0.20254668815336684951, 0.18131342127250671403 },
{ /* 32 f= 3200 */ 0.20905692653530691394, 0.18131342127250671403 },
{ /* 33 f= 3300 */ 0.21556492608551869328, 0.18131342127250671403 },
{ /* 34 f= 3400 */ 0.22207061710855535708, 0.18131342127250671403 },
{ /* 35 f= 3500 */ 0.22857392993369279877, 0.18131342127250671403 },
{ /* 36 f= 3600 */ 0.23507479491567528918, 0.18131342127250671403 },
{ /* 37 f= 3700 */ 0.24157314243546165744, 0.18131342127250671403 },
{ /* 38 f= 3800 */ 0.24806890290097063922, 0.18131342127250671403 },
{ /* 39 f= 3900 */ 0.25456200674782641924, 0.18131342127250671403 },
{ /* 40 f= 4000 */ 0.26105238444010314680, 0.18131342127250671403 },
{ /* 41 f= 4100 */ 0.26753996647107025630, 0.18131342127250671403 },
{ /* 42 f= 4200 */ 0.27402468336393603909, 0.18131342127250671403 },
{ /* 43 f= 4300 */ 0.28050646567259251984, 0.18131342127250671403 },
{ /* 44 f= 4400 */ 0.28698524398235858435, 0.18131342127250671403 },
{ /* 45 f= 4500 */ 0.29346094891072349586, 0.18131342127250671403 },
{ /* 46 f= 4600 */ 0.29993351110809002291, 0.18131342127250671403 },
{ /* 47 f= 4700 */ 0.30640286125851695642, 0.18131342127250671403 },
{ /* 48 f= 4800 */ 0.31286893008046173792, 0.18131342127250671403 },
{ /* 49 f= 4900 */ 0.31933164832752197748, 0.18131342127250671403 },
{ /* 50 f= 5000 */ 0.32579094678917747130, 0.18131342127250671403 },
{ /* 51 f= 5100 */ 0.33224675629153094247, 0.18131342127250671403 },
{ /* 52 f= 5200 */ 0.33869900769804922591, 0.18131342127250671403 },
{ /* 53 f= 5300 */ 0.34514763191030339851, 0.18131342127250671403 },
{ /* 54 f= 5400 */ 0.35159255986870902033, 0.18131342127250671403 },
{ /* 55 f= 5500 */ 0.35803372255326532114, 0.18131342127250671403 },
{ /* 56 f= 5600 */ 0.36447105098429494197, 0.18131342127250671403 },
{ /* 57 f= 5700 */ 0.37090447622318184484, 0.18131342127250671403 },
{ /* 58 f= 5800 */ 0.37733392937311044379, 0.18131342127250671403 },
{ /* 59 f= 5900 */ 0.38375934157980284844, 0.18131342127250671403 },
{ /* 60 f= 6000 */ 0.39018064403225649617, 0.18131342127250671403 },
{ /* 61 f= 6100 */ 0.39659776796348089611, 0.18131342127250671403 },
{ /* 62 f= 6200 */ 0.40301064465123426217, 0.18131342127250671403 },
{ /* 63 f= 6300 */ 0.40941920541875920225, 0.18131342127250671403 },
{ /* 64 f= 6400 */ 0.41582338163551862964, 0.18131342127250671403 },
{ /* 65 f= 6500 */ 0.42222310471793028652, 0.18131342127250671403 },
{ /* 66 f= 6600 */ 0.42861830613010154511, 0.18131342127250671403 },
{ /* 67 f= 6700 */ 0.43500891738456293201, 0.18131342127250671403 },
{ /* 68 f= 6800 */ 0.44139487004300215212, 0.18131342127250671403 },
{ /* 69 f= 6900 */ 0.44777609571699672486, 0.18131342127250671403 },
{ /* 70 f= 7000 */ 0.45415252606874645380, 0.18131342127250671403 },
{ /* 71 f= 7100 */ 0.46052409281180473055, 0.18131342127250671403 },
{ /* 72 f= 7200 */ 0.46689072771181078236, 0.18131342127250671403 },
{ /* 73 f= 7300 */ 0.47325236258721975480, 0.18131342127250671403 },
{ /* 74 f= 7400 */ 0.47960892931003307194, 0.18131342127250671403 },
{ /* 75 f= 7500 */ 0.48596035980652774189, 0.18131342127250671403 },
{ /* 76 f= 7600 */ 0.49230658605798605088, 0.18131342127250671403 },
{ /* 77 f= 7700 */ 0.49864754010142336993, 0.18131342127250671403 },
{ /* 78 f= 7800 */ 0.50498315403031590609, 0.18131342127250671403 },
{ /* 79 f= 7900 */ 0.51131335999532878667, 0.18131342127250671403 },
{ /* 80 f= 8000 */ 0.51763809020504147895, 0.18131342127250671403 },
{ /* 81 f= 8100 */ 0.52395727692667493081, 0.18131342127250671403 },
{ /* 82 f= 8200 */ 0.53027085248681604668, 0.18131342127250671403 },
{ /* 83 f= 8300 */ 0.53657874927214277427, 0.18131342127250671403 },
{ /* 84 f= 8400 */ 0.54288089973014852507, 0.18131342127250671403 },
{ /* 85 f= 8500 */ 0.54917723636986470748, 0.18131342127250671403 },
{ /* 86 f= 8600 */ 0.55546769176258437017, 0.18131342127250671403 },
{ /* 87 f= 8700 */ 0.56175219854258418017, 0.18131342127250671403 },
{ /* 88 f= 8800 */ 0.56803068940784517959, 0.18131342127250671403 },
{ /* 89 f= 8900 */ 0.57430309712077465267, 0.18131342127250671403 },
{ /* 90 f= 9000 */ 0.58056935450892466211, 0.18131342127250671403 },
{ /* 91 f= 9100 */ 0.58682939446571336095, 0.18131342127250671403 },
{ /* 92 f= 9200 */ 0.59308314995114197465, 0.18131342127250671403 },
{ /* 93 f= 9300 */ 0.59933055399251322637, 0.18131342127250671403 },
{ /* 94 f= 9400 */ 0.60557153968514920717, 0.18131342127250671403 },
{ /* 95 f= 9500 */ 0.61180604019310691477, 0.18131342127250671403 },
{ /* 96 f= 9600 */ 0.61803398874989479150, 0.18131342127250671403 },
{ /* 97 f= 9700 */ 0.62425531865918737484, 0.18131342127250671403 },
{ /* 98 f= 9800 */ 0.63046996329553928184, 0.18131342127250671403 },
{ /* 99 f= 9900 */ 0.63667785610509941563, 0.18131342127250671403 },
{ /*100 f=10000 */ 0.64287893060632317344, 0.18131342127250671403 },
{ /*101 f=10100 */ 0.64907312039068432163, 0.18131342127250671403 },
{ /*102 f=10200 */ 0.65526035912338698175, 0.18131342127250671403 },
{ /*103 f=10300 */ 0.66144058054407484093, 0.18131342127250671403 },
{ /*104 f=10400 */ 0.66761371846754191672, 0.18131342127250671403 },
{ /*105 f=10500 */ 0.67377970678444010222, 0.18131342127250671403 },
{ /*106 f=10600 */ 0.67993847946198837651, 0.18131342127250671403 },
{ /*107 f=10700 */ 0.68608997054467968368, 0.18131342127250671403 },
{ /*108 f=10800 */ 0.69223411415498592447, 0.18131342127250671403 },
{ /*109 f=10900 */ 0.69837084449406572340, 0.18131342127250671403 },
{ /*110 f=11000 */ 0.70450009584246697791, 0.18131342127250671403 },
{ /*111 f=11100 */ 0.71062180256083218310, 0.18131342127250671403 },
{ /*112 f=11200 */ 0.71673589909060053671, 0.18131342127250671403 },
{ /*113 f=11300 */ 0.72284231995471004417, 0.18131342127250671403 },
{ /*114 f=11400 */ 0.72894099975829929061, 0.18131342127250671403 },
{ /*115 f=11500 */ 0.73503187318940710338, 0.18131342127250671403 },
{ /*116 f=11600 */ 0.74111487501967243663, 0.18131342127250671403 },
{ /*117 f=11700 */ 0.74718994010503270164, 0.18131342127250671403 },
{ /*118 f=11800 */ 0.75325700338642143095, 0.18131342127250671403 },
{ /*119 f=11900 */ 0.75931599989046549837, 0.18131342127250671403 },
{ /*120 f=12000 */ 0.76536686473017956356, 0.18131342127250671403 },
{ /*121 f=12100 */ 0.77140953310566262591, 0.18131342127250671403 },
{ /*122 f=12200 */ 0.77744394030479113678, 0.18131342127250671403 },
{ /*123 f=12300 */ 0.78347002170391177867, 0.18131342127250671403 },
{ /*124 f=12400 */ 0.78948771276853446643, 0.18131342127250671403 },
{ /*125 f=12500 */ 0.79549694905402212886, 0.18131342127250671403 },
{ /*126 f=12600 */ 0.80149766620628193348, 0.18131342127250671403 },
{ /*127 f=12700 */ 0.80748979996245418000, 0.18131342127250671403 },
{ /*128 f=12800 */ 0.81347328615160030552, 0.18131342127250671403 },
{ /*129 f=12900 */ 0.81944806069539055660, 0.18131342127250671403 },
{ /*130 f=13000 */ 0.82541405960878933001, 0.18131342127250671403 },
{ /*131 f=13100 */ 0.83137121900074162362, 0.18131342127250671403 },
{ /*132 f=13200 */ 0.83731947507485626758, 0.18131342127250671403 },
{ /*133 f=13300 */ 0.84325876413008904464, 0.18131342127250671403 },
{ /*134 f=13400 */ 0.84918902256142625440, 0.18131342127250671403 },
{ /*135 f=13500 */ 0.85511018686056416982, 0.18131342127250671403 },
{ /*136 f=13600 */ 0.86102219361659015906, 0.18131342127250671403 },
{ /*137 f=13700 */ 0.86692497951666180889, 0.18131342127250671403 },
{ /*138 f=13800 */ 0.87281848134668404970, 0.18131342127250671403 },
{ /*139 f=13900 */ 0.87870263599198739080, 0.18131342127250671403 },
{ /*140 f=14000 */ 0.88457738043800260286, 0.18131342127250671403 },
{ /*141 f=14100 */ 0.89044265177093639974, 0.18131342127250671403 },
{ /*142 f=14200 */ 0.89629838717844512175, 0.18131342127250671403 },
{ /*143 f=14300 */ 0.90214452395030675369, 0.18131342127250671403 },
{ /*144 f=14400 */ 0.90798099947909349794, 0.18131342127250671403 },
{ /*145 f=14500 */ 0.91380775126084123894, 0.18131342127250671403 },
{ /*146 f=14600 */ 0.91962471689571967381, 0.18131342127250671403 },
{ /*147 f=14700 */ 0.92543183408870022255, 0.18131342127250671403 },
{ /*148 f=14800 */ 0.93122904065022282794, 0.18131342127250671403 },
{ /*149 f=14900 */ 0.93701627449686286653, 0.18131342127250671403 },
{ /*150 f=15000 */ 0.94279347365199528408, 0.18131342127250671403 },
{ /*151 f=15100 */ 0.94856057624645839788, 0.18131342127250671403 },
{ /*152 f=15200 */ 0.95431752051921681090, 0.18131342127250671403 },
{ /*153 f=15300 */ 0.96006424481802221660, 0.18131342127250671403 },
{ /*154 f=15400 */ 0.96580068760007475870, 0.18131342127250671403 },
{ /*155 f=15500 */ 0.97152678743268006123, 0.18131342127250671403 },
{ /*156 f=15600 */ 0.97724248299390981121, 0.18131342127250671403 },
{ /*157 f=15700 */ 0.98294771307325645715, 0.18131342127250671403 },
{ /*158 f=15800 */ 0.98864241657228923987, 0.18131342127250671403 },
{ /*159 f=15900 */ 0.99432653250530855793, 0.18131342127250671403 },
{ /*160 f=16000 */ 0.99999999999999988898, 0.18131342127250671403 },
{ /*161 f=16100 */ 1.00566275829808415843, 0.18131342127250671403 },
{ /*162 f=16200 */ 1.01131474675596910728, 0.18131342127250671403 },
{ /*163 f=16300 */ 1.01695590484539954979, 0.18131342127250671403 },
{ /*164 f=16400 */ 1.02258617215410430035, 0.18131342127250671403 },
{ /*165 f=16500 */ 1.02820548838644332257, 0.18131342127250671403 },
{ /*166 f=16600 */ 1.03381379336405498925, 0.18131342127250671403 },
{ /*167 f=16700 */ 1.03941102702649845746, 0.18131342127250671403 },
{ /*168 f=16800 */ 1.04499712943189759784, 0.18131342127250671403 },
{ /*169 f=16900 */ 1.05057204075758403583, 0.18131342127250671403 },
{ /*170 f=17000 */ 1.05613570130073597397, 0.18131342127250671403 },
{ /*171 f=17100 */ 1.06168805147901901265, 0.18131342127250671403 },
{ /*172 f=17200 */ 1.06722903183122297399, 0.18131342127250671403 },
{ /*173 f=17300 */ 1.07275858301790050220, 0.18131342127250671403 },
{ /*174 f=17400 */ 1.07827664582200033472, 0.18131342127250671403 },
{ /*175 f=17500 */ 1.08378316114950346005, 0.18131342127250671403 },
{ /*176 f=17600 */ 1.08927807003005394648, 0.18131342127250671403 },
{ /*177 f=17700 */ 1.09476131361759310145, 0.18131342127250671403 },
{ /*178 f=17800 */ 1.10023283319098674760, 0.18131342127250671403 },
{ /*179 f=17900 */ 1.10569257015465582938, 0.18131342127250671403 },
{ /*180 f=18000 */ 1.11114046603920435530, 0.18131342127250671403 },
{ /*181 f=18100 */ 1.11657646250204400928, 0.18131342127250671403 },
{ /*182 f=18200 */ 1.12200050132801965042, 0.18131342127250671403 },
{ /*183 f=18300 */ 1.12741252443003325823, 0.18131342127250671403 },
{ /*184 f=18400 */ 1.13281247384966565761, 0.18131342127250671403 },
{ /*185 f=18500 */ 1.13820029175779646735, 0.18131342127250671403 },
{ /*186 f=18600 */ 1.14357592045522449276, 0.18131342127250671403 },
{ /*187 f=18700 */ 1.14893930237328523170, 0.18131342127250671403 },
{ /*188 f=18800 */ 1.15429038007446727043, 0.18131342127250671403 },
{ /*189 f=18900 */ 1.15962909625302712513, 0.18131342127250671403 },
{ /*190 f=19000 */ 1.16495539373560430541, 0.18131342127250671403 },
{ /*191 f=19100 */ 1.17026921548183104882, 0.18131342127250671403 },
{ /*192 f=19200 */ 1.17557050458494627421, 0.18131342127250671403 },
{ /*193 f=19300 */ 1.18085920427240220754, 0.18131342127250671403 },
{ /*194 f=19400 */ 1.18613525790647433844, 0.18131342127250671403 },
{ /*195 f=19500 */ 1.19139860898486671381, 0.18131342127250671403 },
{ /*196 f=19600 */ 1.19664920114131789752, 0.18131342127250671403 },
{ /*197 f=19700 */ 1.20188697814620470972, 0.18131342127250671403 },
{ /*198 f=19800 */ 1.20711188390714285745, 0.18131342127250671403 },
{ /*199 f=19900 */ 1.21232386246958934173, 0.18131342127250671403 },
{ /*200 f=20000 */ 1.21752285801744131177, 0.18131342127250671403 },
{ /*201 f=20100 */ 1.22270881487363292095, 0.18131342127250671403 },
{ /*202 f=20200 */ 1.22788167750073284878, 0.18131342127250671403 },
{ /*203 f=20300 */ 1.23304139050153827029, 0.18131342127250671403 },
{ /*204 f=20400 */ 1.23818789861966793708, 0.18131342127250671403 },
{ /*205 f=20500 */ 1.24332114674015481448, 0.18131342127250671403 },
{ /*206 f=20600 */ 1.24844107989003516579, 0.18131342127250671403 },
{ /*207 f=20700 */ 1.25354764323893919098, 0.18131342127250671403 },
{ /*208 f=20800 */ 1.25864078209967500399, 0.18131342127250671403 },
{ /*209 f=20900 */ 1.26372044192881749503, 0.18131342127250671403 },
{ /*210 f=21000 */ 1.26878656832729097559, 0.18131342127250671403 },
{ /*211 f=21100 */ 1.27383910704095182354, 0.18131342127250671403 },
{ /*212 f=21200 */ 1.27887800396116935175, 0.18131342127250671403 },
{ /*213 f=21300 */ 1.28390320512540601072, 0.18131342127250671403 },
{ /*214 f=21400 */ 1.28891465671779492652, 0.18131342127250671403 },
{ /*215 f=21500 */ 1.29391230506971455227, 0.18131342127250671403 },
{ /*216 f=21600 */ 1.29889609666036731639, 0.18131342127250671403 },
{ /*217 f=21700 */ 1.30386597811734850083, 0.18131342127250671403 },
{ /*218 f=21800 */ 1.30882189621722067052, 0.18131342127250671403 },
{ /*219 f=21900 */ 1.31376379788608255161, 0.18131342127250671403 },
{ /*220 f=22000 */ 1.31869163020013768772, 0.18131342127250671403 },
{ /*221 f=22100 */ 1.32360534038626065367, 0.18131342127250671403 },
{ /*222 f=22200 */ 1.32850487582256349128, 0.18131342127250671403 },
{ /*223 f=22300 */ 1.33339018403895726017, 0.18131342127250671403 },
{ /*224 f=22400 */ 1.33826121271771647514, 0.18131342127250671403 },
{ /*225 f=22500 */ 1.34311790969403666018, 0.18131342127250671403 },
{ /*226 f=22600 */ 1.34796022295659567725, 0.18131342127250671403 },
{ /*227 f=22700 */ 1.35278810064810839364, 0.18131342127250671403 },
{ /*228 f=22800 */ 1.35760149106588334789, 0.18131342127250671403 },
{ /*229 f=22900 */ 1.36240034266237652893, 0.18131342127250671403 },
{ /*230 f=23000 */ 1.36718460404574249090, 0.18131342127250671403 },
{ /*231 f=23100 */ 1.37195422398038568979, 0.18131342127250671403 },
{ /*232 f=23200 */ 1.37670915138750782347, 0.18131342127250671403 },
{ /*233 f=23300 */ 1.38144933534565739208, 0.18131342127250671403 },
{ /*234 f=23400 */ 1.38617472509127170888, 0.18131342127250671403 },
{ /*235 f=23500 */ 1.39088527001922335202, 0.18131342127250671403 },
{ /*236 f=23600 */ 1.39558091968336017707, 0.18131342127250671403 },
{ /*237 f=23700 */ 1.40026162379704732786, 0.18131342127250671403 },
{ /*238 f=23800 */ 1.40492733223370347417, 0.18131342127250671403 },
{ /*239 f=23900 */ 1.40957799502734015817, 0.18131342127250671403 },
{ /*240 f=24000 */ 1.41421356237309492343, 0.18131342127250671403 }
};
static FLOAT_T vsf_q60[241][2] = {
{ /* dummy entry */ 0, 0},
{ /*  1 f=  100 */ 0.00654497301305325026, 0.13952815532610940430 },
{ /*  2 f=  200 */ 0.01308987593470371628, 0.13952815532610940430 },
{ /*  3 f=  300 */ 0.01963463867429923390, 0.13952815532610940430 },
{ /*  4 f=  400 */ 0.02617919114268887903, 0.13952815532610940430 },
{ /*  5 f=  500 */ 0.03272346325297356001, 0.13952815532610940430 },
{ /*  6 f=  600 */ 0.03926738492125660118, 0.13952815532610940430 },
{ /*  7 f=  700 */ 0.04581088606739427971, 0.13952815532610940430 },
{ /*  8 f=  800 */ 0.05235389661574629816, 0.13952815532610940430 },
{ /*  9 f=  900 */ 0.05889634649592632304, 0.13952815532610940430 },
{ /* 10 f= 1000 */ 0.06543816564355227350, 0.13952815532610940430 },
{ /* 11 f= 1100 */ 0.07197928400099674884, 0.13952815532610940430 },
{ /* 12 f= 1200 */ 0.07851963151813722008, 0.13952815532610940430 },
{ /* 13 f= 1300 */ 0.08505913815310624237, 0.13952815532610940430 },
{ /* 14 f= 1400 */ 0.09159773387304154246, 0.13952815532610940430 },
{ /* 15 f= 1500 */ 0.09813534865483602987, 0.13952815532610940430 },
{ /* 16 f= 1600 */ 0.10467191248588765540, 0.13952815532610940430 },
{ /* 17 f= 1700 */ 0.11120735536484922801, 0.13952815532610940430 },
{ /* 18 f= 1800 */ 0.11774160730237806516, 0.13952815532610940430 },
{ /* 19 f= 1900 */ 0.12427459832188544886, 0.13952815532610940430 },
{ /* 20 f= 2000 */ 0.13080625846028612336, 0.13952815532610940430 },
{ /* 21 f= 2100 */ 0.13733651776874752914, 0.13952815532610940430 },
{ /* 22 f= 2200 */ 0.14386530631343877329, 0.13952815532610940430 },
{ /* 23 f= 2300 */ 0.15039255417627980793, 0.13952815532610940430 },
{ /* 24 f= 2400 */ 0.15691819145568988714, 0.13952815532610940430 },
{ /* 25 f= 2500 */ 0.16344214826733644008, 0.13952815532610940430 },
{ /* 26 f= 2600 */ 0.16996435474488333361, 0.13952815532610940430 },
{ /* 27 f= 2700 */ 0.17648474104073902380, 0.13952815532610940430 },
{ /* 28 f= 2800 */ 0.18300323732680476296, 0.13952815532610940430 },
{ /* 29 f= 2900 */ 0.18951977379522222389, 0.13952815532610940430 },
{ /* 30 f= 3000 */ 0.19603428065912120726, 0.13952815532610940430 },
{ /* 31 f= 3100 */ 0.20254668815336684951, 0.13952815532610940430 },
{ /* 32 f= 3200 */ 0.20905692653530691394, 0.13952815532610940430 },
{ /* 33 f= 3300 */ 0.21556492608551869328, 0.13952815532610940430 },
{ /* 34 f= 3400 */ 0.22207061710855535708, 0.13952815532610940430 },
{ /* 35 f= 3500 */ 0.22857392993369279877, 0.13952815532610940430 },
{ /* 36 f= 3600 */ 0.23507479491567528918, 0.13952815532610940430 },
{ /* 37 f= 3700 */ 0.24157314243546165744, 0.13952815532610940430 },
{ /* 38 f= 3800 */ 0.24806890290097063922, 0.13952815532610940430 },
{ /* 39 f= 3900 */ 0.25456200674782641924, 0.13952815532610940430 },
{ /* 40 f= 4000 */ 0.26105238444010314680, 0.13952815532610940430 },
{ /* 41 f= 4100 */ 0.26753996647107025630, 0.13952815532610940430 },
{ /* 42 f= 4200 */ 0.27402468336393603909, 0.13952815532610940430 },
{ /* 43 f= 4300 */ 0.28050646567259251984, 0.13952815532610940430 },
{ /* 44 f= 4400 */ 0.28698524398235858435, 0.13952815532610940430 },
{ /* 45 f= 4500 */ 0.29346094891072349586, 0.13952815532610940430 },
{ /* 46 f= 4600 */ 0.29993351110809002291, 0.13952815532610940430 },
{ /* 47 f= 4700 */ 0.30640286125851695642, 0.13952815532610940430 },
{ /* 48 f= 4800 */ 0.31286893008046173792, 0.13952815532610940430 },
{ /* 49 f= 4900 */ 0.31933164832752197748, 0.13952815532610940430 },
{ /* 50 f= 5000 */ 0.32579094678917747130, 0.13952815532610940430 },
{ /* 51 f= 5100 */ 0.33224675629153094247, 0.13952815532610940430 },
{ /* 52 f= 5200 */ 0.33869900769804922591, 0.13952815532610940430 },
{ /* 53 f= 5300 */ 0.34514763191030339851, 0.13952815532610940430 },
{ /* 54 f= 5400 */ 0.35159255986870902033, 0.13952815532610940430 },
{ /* 55 f= 5500 */ 0.35803372255326532114, 0.13952815532610940430 },
{ /* 56 f= 5600 */ 0.36447105098429494197, 0.13952815532610940430 },
{ /* 57 f= 5700 */ 0.37090447622318184484, 0.13952815532610940430 },
{ /* 58 f= 5800 */ 0.37733392937311044379, 0.13952815532610940430 },
{ /* 59 f= 5900 */ 0.38375934157980284844, 0.13952815532610940430 },
{ /* 60 f= 6000 */ 0.39018064403225649617, 0.13952815532610940430 },
{ /* 61 f= 6100 */ 0.39659776796348089611, 0.13952815532610940430 },
{ /* 62 f= 6200 */ 0.40301064465123426217, 0.13952815532610940430 },
{ /* 63 f= 6300 */ 0.40941920541875920225, 0.13952815532610940430 },
{ /* 64 f= 6400 */ 0.41582338163551862964, 0.13952815532610940430 },
{ /* 65 f= 6500 */ 0.42222310471793028652, 0.13952815532610940430 },
{ /* 66 f= 6600 */ 0.42861830613010154511, 0.13952815532610940430 },
{ /* 67 f= 6700 */ 0.43500891738456293201, 0.13952815532610940430 },
{ /* 68 f= 6800 */ 0.44139487004300215212, 0.13952815532610940430 },
{ /* 69 f= 6900 */ 0.44777609571699672486, 0.13952815532610940430 },
{ /* 70 f= 7000 */ 0.45415252606874645380, 0.13952815532610940430 },
{ /* 71 f= 7100 */ 0.46052409281180473055, 0.13952815532610940430 },
{ /* 72 f= 7200 */ 0.46689072771181078236, 0.13952815532610940430 },
{ /* 73 f= 7300 */ 0.47325236258721975480, 0.13952815532610940430 },
{ /* 74 f= 7400 */ 0.47960892931003307194, 0.13952815532610940430 },
{ /* 75 f= 7500 */ 0.48596035980652774189, 0.13952815532610940430 },
{ /* 76 f= 7600 */ 0.49230658605798605088, 0.13952815532610940430 },
{ /* 77 f= 7700 */ 0.49864754010142336993, 0.13952815532610940430 },
{ /* 78 f= 7800 */ 0.50498315403031590609, 0.13952815532610940430 },
{ /* 79 f= 7900 */ 0.51131335999532878667, 0.13952815532610940430 },
{ /* 80 f= 8000 */ 0.51763809020504147895, 0.13952815532610940430 },
{ /* 81 f= 8100 */ 0.52395727692667493081, 0.13952815532610940430 },
{ /* 82 f= 8200 */ 0.53027085248681604668, 0.13952815532610940430 },
{ /* 83 f= 8300 */ 0.53657874927214277427, 0.13952815532610940430 },
{ /* 84 f= 8400 */ 0.54288089973014852507, 0.13952815532610940430 },
{ /* 85 f= 8500 */ 0.54917723636986470748, 0.13952815532610940430 },
{ /* 86 f= 8600 */ 0.55546769176258437017, 0.13952815532610940430 },
{ /* 87 f= 8700 */ 0.56175219854258418017, 0.13952815532610940430 },
{ /* 88 f= 8800 */ 0.56803068940784517959, 0.13952815532610940430 },
{ /* 89 f= 8900 */ 0.57430309712077465267, 0.13952815532610940430 },
{ /* 90 f= 9000 */ 0.58056935450892466211, 0.13952815532610940430 },
{ /* 91 f= 9100 */ 0.58682939446571336095, 0.13952815532610940430 },
{ /* 92 f= 9200 */ 0.59308314995114197465, 0.13952815532610940430 },
{ /* 93 f= 9300 */ 0.59933055399251322637, 0.13952815532610940430 },
{ /* 94 f= 9400 */ 0.60557153968514920717, 0.13952815532610940430 },
{ /* 95 f= 9500 */ 0.61180604019310691477, 0.13952815532610940430 },
{ /* 96 f= 9600 */ 0.61803398874989479150, 0.13952815532610940430 },
{ /* 97 f= 9700 */ 0.62425531865918737484, 0.13952815532610940430 },
{ /* 98 f= 9800 */ 0.63046996329553928184, 0.13952815532610940430 },
{ /* 99 f= 9900 */ 0.63667785610509941563, 0.13952815532610940430 },
{ /*100 f=10000 */ 0.64287893060632317344, 0.13952815532610940430 },
{ /*101 f=10100 */ 0.64907312039068432163, 0.13952815532610940430 },
{ /*102 f=10200 */ 0.65526035912338698175, 0.13952815532610940430 },
{ /*103 f=10300 */ 0.66144058054407484093, 0.13952815532610940430 },
{ /*104 f=10400 */ 0.66761371846754191672, 0.13952815532610940430 },
{ /*105 f=10500 */ 0.67377970678444010222, 0.13952815532610940430 },
{ /*106 f=10600 */ 0.67993847946198837651, 0.13952815532610940430 },
{ /*107 f=10700 */ 0.68608997054467968368, 0.13952815532610940430 },
{ /*108 f=10800 */ 0.69223411415498592447, 0.13952815532610940430 },
{ /*109 f=10900 */ 0.69837084449406572340, 0.13952815532610940430 },
{ /*110 f=11000 */ 0.70450009584246697791, 0.13952815532610940430 },
{ /*111 f=11100 */ 0.71062180256083218310, 0.13952815532610940430 },
{ /*112 f=11200 */ 0.71673589909060053671, 0.13952815532610940430 },
{ /*113 f=11300 */ 0.72284231995471004417, 0.13952815532610940430 },
{ /*114 f=11400 */ 0.72894099975829929061, 0.13952815532610940430 },
{ /*115 f=11500 */ 0.73503187318940710338, 0.13952815532610940430 },
{ /*116 f=11600 */ 0.74111487501967243663, 0.13952815532610940430 },
{ /*117 f=11700 */ 0.74718994010503270164, 0.13952815532610940430 },
{ /*118 f=11800 */ 0.75325700338642143095, 0.13952815532610940430 },
{ /*119 f=11900 */ 0.75931599989046549837, 0.13952815532610940430 },
{ /*120 f=12000 */ 0.76536686473017956356, 0.13952815532610940430 },
{ /*121 f=12100 */ 0.77140953310566262591, 0.13952815532610940430 },
{ /*122 f=12200 */ 0.77744394030479113678, 0.13952815532610940430 },
{ /*123 f=12300 */ 0.78347002170391177867, 0.13952815532610940430 },
{ /*124 f=12400 */ 0.78948771276853446643, 0.13952815532610940430 },
{ /*125 f=12500 */ 0.79549694905402212886, 0.13952815532610940430 },
{ /*126 f=12600 */ 0.80149766620628193348, 0.13952815532610940430 },
{ /*127 f=12700 */ 0.80748979996245418000, 0.13952815532610940430 },
{ /*128 f=12800 */ 0.81347328615160030552, 0.13952815532610940430 },
{ /*129 f=12900 */ 0.81944806069539055660, 0.13952815532610940430 },
{ /*130 f=13000 */ 0.82541405960878933001, 0.13952815532610940430 },
{ /*131 f=13100 */ 0.83137121900074162362, 0.13952815532610940430 },
{ /*132 f=13200 */ 0.83731947507485626758, 0.13952815532610940430 },
{ /*133 f=13300 */ 0.84325876413008904464, 0.13952815532610940430 },
{ /*134 f=13400 */ 0.84918902256142625440, 0.13952815532610940430 },
{ /*135 f=13500 */ 0.85511018686056416982, 0.13952815532610940430 },
{ /*136 f=13600 */ 0.86102219361659015906, 0.13952815532610940430 },
{ /*137 f=13700 */ 0.86692497951666180889, 0.13952815532610940430 },
{ /*138 f=13800 */ 0.87281848134668404970, 0.13952815532610940430 },
{ /*139 f=13900 */ 0.87870263599198739080, 0.13952815532610940430 },
{ /*140 f=14000 */ 0.88457738043800260286, 0.13952815532610940430 },
{ /*141 f=14100 */ 0.89044265177093639974, 0.13952815532610940430 },
{ /*142 f=14200 */ 0.89629838717844512175, 0.13952815532610940430 },
{ /*143 f=14300 */ 0.90214452395030675369, 0.13952815532610940430 },
{ /*144 f=14400 */ 0.90798099947909349794, 0.13952815532610940430 },
{ /*145 f=14500 */ 0.91380775126084123894, 0.13952815532610940430 },
{ /*146 f=14600 */ 0.91962471689571967381, 0.13952815532610940430 },
{ /*147 f=14700 */ 0.92543183408870022255, 0.13952815532610940430 },
{ /*148 f=14800 */ 0.93122904065022282794, 0.13952815532610940430 },
{ /*149 f=14900 */ 0.93701627449686286653, 0.13952815532610940430 },
{ /*150 f=15000 */ 0.94279347365199528408, 0.13952815532610940430 },
{ /*151 f=15100 */ 0.94856057624645839788, 0.13952815532610940430 },
{ /*152 f=15200 */ 0.95431752051921681090, 0.13952815532610940430 },
{ /*153 f=15300 */ 0.96006424481802221660, 0.13952815532610940430 },
{ /*154 f=15400 */ 0.96580068760007475870, 0.13952815532610940430 },
{ /*155 f=15500 */ 0.97152678743268006123, 0.13952815532610940430 },
{ /*156 f=15600 */ 0.97724248299390981121, 0.13952815532610940430 },
{ /*157 f=15700 */ 0.98294771307325645715, 0.13952815532610940430 },
{ /*158 f=15800 */ 0.98864241657228923987, 0.13952815532610940430 },
{ /*159 f=15900 */ 0.99432653250530855793, 0.13952815532610940430 },
{ /*160 f=16000 */ 0.99999999999999988898, 0.13952815532610940430 },
{ /*161 f=16100 */ 1.00566275829808415843, 0.13952815532610940430 },
{ /*162 f=16200 */ 1.01131474675596910728, 0.13952815532610940430 },
{ /*163 f=16300 */ 1.01695590484539954979, 0.13952815532610940430 },
{ /*164 f=16400 */ 1.02258617215410430035, 0.13952815532610940430 },
{ /*165 f=16500 */ 1.02820548838644332257, 0.13952815532610940430 },
{ /*166 f=16600 */ 1.03381379336405498925, 0.13952815532610940430 },
{ /*167 f=16700 */ 1.03941102702649845746, 0.13952815532610940430 },
{ /*168 f=16800 */ 1.04499712943189759784, 0.13952815532610940430 },
{ /*169 f=16900 */ 1.05057204075758403583, 0.13952815532610940430 },
{ /*170 f=17000 */ 1.05613570130073597397, 0.13952815532610940430 },
{ /*171 f=17100 */ 1.06168805147901901265, 0.13952815532610940430 },
{ /*172 f=17200 */ 1.06722903183122297399, 0.13952815532610940430 },
{ /*173 f=17300 */ 1.07275858301790050220, 0.13952815532610940430 },
{ /*174 f=17400 */ 1.07827664582200033472, 0.13952815532610940430 },
{ /*175 f=17500 */ 1.08378316114950346005, 0.13952815532610940430 },
{ /*176 f=17600 */ 1.08927807003005394648, 0.13952815532610940430 },
{ /*177 f=17700 */ 1.09476131361759310145, 0.13952815532610940430 },
{ /*178 f=17800 */ 1.10023283319098674760, 0.13952815532610940430 },
{ /*179 f=17900 */ 1.10569257015465582938, 0.13952815532610940430 },
{ /*180 f=18000 */ 1.11114046603920435530, 0.13952815532610940430 },
{ /*181 f=18100 */ 1.11657646250204400928, 0.13952815532610940430 },
{ /*182 f=18200 */ 1.12200050132801965042, 0.13952815532610940430 },
{ /*183 f=18300 */ 1.12741252443003325823, 0.13952815532610940430 },
{ /*184 f=18400 */ 1.13281247384966565761, 0.13952815532610940430 },
{ /*185 f=18500 */ 1.13820029175779646735, 0.13952815532610940430 },
{ /*186 f=18600 */ 1.14357592045522449276, 0.13952815532610940430 },
{ /*187 f=18700 */ 1.14893930237328523170, 0.13952815532610940430 },
{ /*188 f=18800 */ 1.15429038007446727043, 0.13952815532610940430 },
{ /*189 f=18900 */ 1.15962909625302712513, 0.13952815532610940430 },
{ /*190 f=19000 */ 1.16495539373560430541, 0.13952815532610940430 },
{ /*191 f=19100 */ 1.17026921548183104882, 0.13952815532610940430 },
{ /*192 f=19200 */ 1.17557050458494627421, 0.13952815532610940430 },
{ /*193 f=19300 */ 1.18085920427240220754, 0.13952815532610940430 },
{ /*194 f=19400 */ 1.18613525790647433844, 0.13952815532610940430 },
{ /*195 f=19500 */ 1.19139860898486671381, 0.13952815532610940430 },
{ /*196 f=19600 */ 1.19664920114131789752, 0.13952815532610940430 },
{ /*197 f=19700 */ 1.20188697814620470972, 0.13952815532610940430 },
{ /*198 f=19800 */ 1.20711188390714285745, 0.13952815532610940430 },
{ /*199 f=19900 */ 1.21232386246958934173, 0.13952815532610940430 },
{ /*200 f=20000 */ 1.21752285801744131177, 0.13952815532610940430 },
{ /*201 f=20100 */ 1.22270881487363292095, 0.13952815532610940430 },
{ /*202 f=20200 */ 1.22788167750073284878, 0.13952815532610940430 },
{ /*203 f=20300 */ 1.23304139050153827029, 0.13952815532610940430 },
{ /*204 f=20400 */ 1.23818789861966793708, 0.13952815532610940430 },
{ /*205 f=20500 */ 1.24332114674015481448, 0.13952815532610940430 },
{ /*206 f=20600 */ 1.24844107989003516579, 0.13952815532610940430 },
{ /*207 f=20700 */ 1.25354764323893919098, 0.13952815532610940430 },
{ /*208 f=20800 */ 1.25864078209967500399, 0.13952815532610940430 },
{ /*209 f=20900 */ 1.26372044192881749503, 0.13952815532610940430 },
{ /*210 f=21000 */ 1.26878656832729097559, 0.13952815532610940430 },
{ /*211 f=21100 */ 1.27383910704095182354, 0.13952815532610940430 },
{ /*212 f=21200 */ 1.27887800396116935175, 0.13952815532610940430 },
{ /*213 f=21300 */ 1.28390320512540601072, 0.13952815532610940430 },
{ /*214 f=21400 */ 1.28891465671779492652, 0.13952815532610940430 },
{ /*215 f=21500 */ 1.29391230506971455227, 0.13952815532610940430 },
{ /*216 f=21600 */ 1.29889609666036731639, 0.13952815532610940430 },
{ /*217 f=21700 */ 1.30386597811734850083, 0.13952815532610940430 },
{ /*218 f=21800 */ 1.30882189621722067052, 0.13952815532610940430 },
{ /*219 f=21900 */ 1.31376379788608255161, 0.13952815532610940430 },
{ /*220 f=22000 */ 1.31869163020013768772, 0.13952815532610940430 },
{ /*221 f=22100 */ 1.32360534038626065367, 0.13952815532610940430 },
{ /*222 f=22200 */ 1.32850487582256349128, 0.13952815532610940430 },
{ /*223 f=22300 */ 1.33339018403895726017, 0.13952815532610940430 },
{ /*224 f=22400 */ 1.33826121271771647514, 0.13952815532610940430 },
{ /*225 f=22500 */ 1.34311790969403666018, 0.13952815532610940430 },
{ /*226 f=22600 */ 1.34796022295659567725, 0.13952815532610940430 },
{ /*227 f=22700 */ 1.35278810064810839364, 0.13952815532610940430 },
{ /*228 f=22800 */ 1.35760149106588334789, 0.13952815532610940430 },
{ /*229 f=22900 */ 1.36240034266237652893, 0.13952815532610940430 },
{ /*230 f=23000 */ 1.36718460404574249090, 0.13952815532610940430 },
{ /*231 f=23100 */ 1.37195422398038568979, 0.13952815532610940430 },
{ /*232 f=23200 */ 1.37670915138750782347, 0.13952815532610940430 },
{ /*233 f=23300 */ 1.38144933534565739208, 0.13952815532610940430 },
{ /*234 f=23400 */ 1.38617472509127170888, 0.13952815532610940430 },
{ /*235 f=23500 */ 1.39088527001922335202, 0.13952815532610940430 },
{ /*236 f=23600 */ 1.39558091968336017707, 0.13952815532610940430 },
{ /*237 f=23700 */ 1.40026162379704732786, 0.13952815532610940430 },
{ /*238 f=23800 */ 1.40492733223370347417, 0.13952815532610940430 },
{ /*239 f=23900 */ 1.40957799502734015817, 0.13952815532610940430 },
{ /*240 f=24000 */ 1.41421356237309492343, 0.13952815532610940430 }
};
static FLOAT_T vsf_q70[241][2] = {
{ /* dummy entry */ 0, 0},
{ /*  1 f=  100 */ 0.00654497301305325026, 0.10823680221510856292 },
{ /*  2 f=  200 */ 0.01308987593470371628, 0.10823680221510856292 },
{ /*  3 f=  300 */ 0.01963463867429923390, 0.10823680221510856292 },
{ /*  4 f=  400 */ 0.02617919114268887903, 0.10823680221510856292 },
{ /*  5 f=  500 */ 0.03272346325297356001, 0.10823680221510856292 },
{ /*  6 f=  600 */ 0.03926738492125660118, 0.10823680221510856292 },
{ /*  7 f=  700 */ 0.04581088606739427971, 0.10823680221510856292 },
{ /*  8 f=  800 */ 0.05235389661574629816, 0.10823680221510856292 },
{ /*  9 f=  900 */ 0.05889634649592632304, 0.10823680221510856292 },
{ /* 10 f= 1000 */ 0.06543816564355227350, 0.10823680221510856292 },
{ /* 11 f= 1100 */ 0.07197928400099674884, 0.10823680221510856292 },
{ /* 12 f= 1200 */ 0.07851963151813722008, 0.10823680221510856292 },
{ /* 13 f= 1300 */ 0.08505913815310624237, 0.10823680221510856292 },
{ /* 14 f= 1400 */ 0.09159773387304154246, 0.10823680221510856292 },
{ /* 15 f= 1500 */ 0.09813534865483602987, 0.10823680221510856292 },
{ /* 16 f= 1600 */ 0.10467191248588765540, 0.10823680221510856292 },
{ /* 17 f= 1700 */ 0.11120735536484922801, 0.10823680221510856292 },
{ /* 18 f= 1800 */ 0.11774160730237806516, 0.10823680221510856292 },
{ /* 19 f= 1900 */ 0.12427459832188544886, 0.10823680221510856292 },
{ /* 20 f= 2000 */ 0.13080625846028612336, 0.10823680221510856292 },
{ /* 21 f= 2100 */ 0.13733651776874752914, 0.10823680221510856292 },
{ /* 22 f= 2200 */ 0.14386530631343877329, 0.10823680221510856292 },
{ /* 23 f= 2300 */ 0.15039255417627980793, 0.10823680221510856292 },
{ /* 24 f= 2400 */ 0.15691819145568988714, 0.10823680221510856292 },
{ /* 25 f= 2500 */ 0.16344214826733644008, 0.10823680221510856292 },
{ /* 26 f= 2600 */ 0.16996435474488333361, 0.10823680221510856292 },
{ /* 27 f= 2700 */ 0.17648474104073902380, 0.10823680221510856292 },
{ /* 28 f= 2800 */ 0.18300323732680476296, 0.10823680221510856292 },
{ /* 29 f= 2900 */ 0.18951977379522222389, 0.10823680221510856292 },
{ /* 30 f= 3000 */ 0.19603428065912120726, 0.10823680221510856292 },
{ /* 31 f= 3100 */ 0.20254668815336684951, 0.10823680221510856292 },
{ /* 32 f= 3200 */ 0.20905692653530691394, 0.10823680221510856292 },
{ /* 33 f= 3300 */ 0.21556492608551869328, 0.10823680221510856292 },
{ /* 34 f= 3400 */ 0.22207061710855535708, 0.10823680221510856292 },
{ /* 35 f= 3500 */ 0.22857392993369279877, 0.10823680221510856292 },
{ /* 36 f= 3600 */ 0.23507479491567528918, 0.10823680221510856292 },
{ /* 37 f= 3700 */ 0.24157314243546165744, 0.10823680221510856292 },
{ /* 38 f= 3800 */ 0.24806890290097063922, 0.10823680221510856292 },
{ /* 39 f= 3900 */ 0.25456200674782641924, 0.10823680221510856292 },
{ /* 40 f= 4000 */ 0.26105238444010314680, 0.10823680221510856292 },
{ /* 41 f= 4100 */ 0.26753996647107025630, 0.10823680221510856292 },
{ /* 42 f= 4200 */ 0.27402468336393603909, 0.10823680221510856292 },
{ /* 43 f= 4300 */ 0.28050646567259251984, 0.10823680221510856292 },
{ /* 44 f= 4400 */ 0.28698524398235858435, 0.10823680221510856292 },
{ /* 45 f= 4500 */ 0.29346094891072349586, 0.10823680221510856292 },
{ /* 46 f= 4600 */ 0.29993351110809002291, 0.10823680221510856292 },
{ /* 47 f= 4700 */ 0.30640286125851695642, 0.10823680221510856292 },
{ /* 48 f= 4800 */ 0.31286893008046173792, 0.10823680221510856292 },
{ /* 49 f= 4900 */ 0.31933164832752197748, 0.10823680221510856292 },
{ /* 50 f= 5000 */ 0.32579094678917747130, 0.10823680221510856292 },
{ /* 51 f= 5100 */ 0.33224675629153094247, 0.10823680221510856292 },
{ /* 52 f= 5200 */ 0.33869900769804922591, 0.10823680221510856292 },
{ /* 53 f= 5300 */ 0.34514763191030339851, 0.10823680221510856292 },
{ /* 54 f= 5400 */ 0.35159255986870902033, 0.10823680221510856292 },
{ /* 55 f= 5500 */ 0.35803372255326532114, 0.10823680221510856292 },
{ /* 56 f= 5600 */ 0.36447105098429494197, 0.10823680221510856292 },
{ /* 57 f= 5700 */ 0.37090447622318184484, 0.10823680221510856292 },
{ /* 58 f= 5800 */ 0.37733392937311044379, 0.10823680221510856292 },
{ /* 59 f= 5900 */ 0.38375934157980284844, 0.10823680221510856292 },
{ /* 60 f= 6000 */ 0.39018064403225649617, 0.10823680221510856292 },
{ /* 61 f= 6100 */ 0.39659776796348089611, 0.10823680221510856292 },
{ /* 62 f= 6200 */ 0.40301064465123426217, 0.10823680221510856292 },
{ /* 63 f= 6300 */ 0.40941920541875920225, 0.10823680221510856292 },
{ /* 64 f= 6400 */ 0.41582338163551862964, 0.10823680221510856292 },
{ /* 65 f= 6500 */ 0.42222310471793028652, 0.10823680221510856292 },
{ /* 66 f= 6600 */ 0.42861830613010154511, 0.10823680221510856292 },
{ /* 67 f= 6700 */ 0.43500891738456293201, 0.10823680221510856292 },
{ /* 68 f= 6800 */ 0.44139487004300215212, 0.10823680221510856292 },
{ /* 69 f= 6900 */ 0.44777609571699672486, 0.10823680221510856292 },
{ /* 70 f= 7000 */ 0.45415252606874645380, 0.10823680221510856292 },
{ /* 71 f= 7100 */ 0.46052409281180473055, 0.10823680221510856292 },
{ /* 72 f= 7200 */ 0.46689072771181078236, 0.10823680221510856292 },
{ /* 73 f= 7300 */ 0.47325236258721975480, 0.10823680221510856292 },
{ /* 74 f= 7400 */ 0.47960892931003307194, 0.10823680221510856292 },
{ /* 75 f= 7500 */ 0.48596035980652774189, 0.10823680221510856292 },
{ /* 76 f= 7600 */ 0.49230658605798605088, 0.10823680221510856292 },
{ /* 77 f= 7700 */ 0.49864754010142336993, 0.10823680221510856292 },
{ /* 78 f= 7800 */ 0.50498315403031590609, 0.10823680221510856292 },
{ /* 79 f= 7900 */ 0.51131335999532878667, 0.10823680221510856292 },
{ /* 80 f= 8000 */ 0.51763809020504147895, 0.10823680221510856292 },
{ /* 81 f= 8100 */ 0.52395727692667493081, 0.10823680221510856292 },
{ /* 82 f= 8200 */ 0.53027085248681604668, 0.10823680221510856292 },
{ /* 83 f= 8300 */ 0.53657874927214277427, 0.10823680221510856292 },
{ /* 84 f= 8400 */ 0.54288089973014852507, 0.10823680221510856292 },
{ /* 85 f= 8500 */ 0.54917723636986470748, 0.10823680221510856292 },
{ /* 86 f= 8600 */ 0.55546769176258437017, 0.10823680221510856292 },
{ /* 87 f= 8700 */ 0.56175219854258418017, 0.10823680221510856292 },
{ /* 88 f= 8800 */ 0.56803068940784517959, 0.10823680221510856292 },
{ /* 89 f= 8900 */ 0.57430309712077465267, 0.10823680221510856292 },
{ /* 90 f= 9000 */ 0.58056935450892466211, 0.10823680221510856292 },
{ /* 91 f= 9100 */ 0.58682939446571336095, 0.10823680221510856292 },
{ /* 92 f= 9200 */ 0.59308314995114197465, 0.10823680221510856292 },
{ /* 93 f= 9300 */ 0.59933055399251322637, 0.10823680221510856292 },
{ /* 94 f= 9400 */ 0.60557153968514920717, 0.10823680221510856292 },
{ /* 95 f= 9500 */ 0.61180604019310691477, 0.10823680221510856292 },
{ /* 96 f= 9600 */ 0.61803398874989479150, 0.10823680221510856292 },
{ /* 97 f= 9700 */ 0.62425531865918737484, 0.10823680221510856292 },
{ /* 98 f= 9800 */ 0.63046996329553928184, 0.10823680221510856292 },
{ /* 99 f= 9900 */ 0.63667785610509941563, 0.10823680221510856292 },
{ /*100 f=10000 */ 0.64287893060632317344, 0.10823680221510856292 },
{ /*101 f=10100 */ 0.64907312039068432163, 0.10823680221510856292 },
{ /*102 f=10200 */ 0.65526035912338698175, 0.10823680221510856292 },
{ /*103 f=10300 */ 0.66144058054407484093, 0.10823680221510856292 },
{ /*104 f=10400 */ 0.66761371846754191672, 0.10823680221510856292 },
{ /*105 f=10500 */ 0.67377970678444010222, 0.10823680221510856292 },
{ /*106 f=10600 */ 0.67993847946198837651, 0.10823680221510856292 },
{ /*107 f=10700 */ 0.68608997054467968368, 0.10823680221510856292 },
{ /*108 f=10800 */ 0.69223411415498592447, 0.10823680221510856292 },
{ /*109 f=10900 */ 0.69837084449406572340, 0.10823680221510856292 },
{ /*110 f=11000 */ 0.70450009584246697791, 0.10823680221510856292 },
{ /*111 f=11100 */ 0.71062180256083218310, 0.10823680221510856292 },
{ /*112 f=11200 */ 0.71673589909060053671, 0.10823680221510856292 },
{ /*113 f=11300 */ 0.72284231995471004417, 0.10823680221510856292 },
{ /*114 f=11400 */ 0.72894099975829929061, 0.10823680221510856292 },
{ /*115 f=11500 */ 0.73503187318940710338, 0.10823680221510856292 },
{ /*116 f=11600 */ 0.74111487501967243663, 0.10823680221510856292 },
{ /*117 f=11700 */ 0.74718994010503270164, 0.10823680221510856292 },
{ /*118 f=11800 */ 0.75325700338642143095, 0.10823680221510856292 },
{ /*119 f=11900 */ 0.75931599989046549837, 0.10823680221510856292 },
{ /*120 f=12000 */ 0.76536686473017956356, 0.10823680221510856292 },
{ /*121 f=12100 */ 0.77140953310566262591, 0.10823680221510856292 },
{ /*122 f=12200 */ 0.77744394030479113678, 0.10823680221510856292 },
{ /*123 f=12300 */ 0.78347002170391177867, 0.10823680221510856292 },
{ /*124 f=12400 */ 0.78948771276853446643, 0.10823680221510856292 },
{ /*125 f=12500 */ 0.79549694905402212886, 0.10823680221510856292 },
{ /*126 f=12600 */ 0.80149766620628193348, 0.10823680221510856292 },
{ /*127 f=12700 */ 0.80748979996245418000, 0.10823680221510856292 },
{ /*128 f=12800 */ 0.81347328615160030552, 0.10823680221510856292 },
{ /*129 f=12900 */ 0.81944806069539055660, 0.10823680221510856292 },
{ /*130 f=13000 */ 0.82541405960878933001, 0.10823680221510856292 },
{ /*131 f=13100 */ 0.83137121900074162362, 0.10823680221510856292 },
{ /*132 f=13200 */ 0.83731947507485626758, 0.10823680221510856292 },
{ /*133 f=13300 */ 0.84325876413008904464, 0.10823680221510856292 },
{ /*134 f=13400 */ 0.84918902256142625440, 0.10823680221510856292 },
{ /*135 f=13500 */ 0.85511018686056416982, 0.10823680221510856292 },
{ /*136 f=13600 */ 0.86102219361659015906, 0.10823680221510856292 },
{ /*137 f=13700 */ 0.86692497951666180889, 0.10823680221510856292 },
{ /*138 f=13800 */ 0.87281848134668404970, 0.10823680221510856292 },
{ /*139 f=13900 */ 0.87870263599198739080, 0.10823680221510856292 },
{ /*140 f=14000 */ 0.88457738043800260286, 0.10823680221510856292 },
{ /*141 f=14100 */ 0.89044265177093639974, 0.10823680221510856292 },
{ /*142 f=14200 */ 0.89629838717844512175, 0.10823680221510856292 },
{ /*143 f=14300 */ 0.90214452395030675369, 0.10823680221510856292 },
{ /*144 f=14400 */ 0.90798099947909349794, 0.10823680221510856292 },
{ /*145 f=14500 */ 0.91380775126084123894, 0.10823680221510856292 },
{ /*146 f=14600 */ 0.91962471689571967381, 0.10823680221510856292 },
{ /*147 f=14700 */ 0.92543183408870022255, 0.10823680221510856292 },
{ /*148 f=14800 */ 0.93122904065022282794, 0.10823680221510856292 },
{ /*149 f=14900 */ 0.93701627449686286653, 0.10823680221510856292 },
{ /*150 f=15000 */ 0.94279347365199528408, 0.10823680221510856292 },
{ /*151 f=15100 */ 0.94856057624645839788, 0.10823680221510856292 },
{ /*152 f=15200 */ 0.95431752051921681090, 0.10823680221510856292 },
{ /*153 f=15300 */ 0.96006424481802221660, 0.10823680221510856292 },
{ /*154 f=15400 */ 0.96580068760007475870, 0.10823680221510856292 },
{ /*155 f=15500 */ 0.97152678743268006123, 0.10823680221510856292 },
{ /*156 f=15600 */ 0.97724248299390981121, 0.10823680221510856292 },
{ /*157 f=15700 */ 0.98294771307325645715, 0.10823680221510856292 },
{ /*158 f=15800 */ 0.98864241657228923987, 0.10823680221510856292 },
{ /*159 f=15900 */ 0.99432653250530855793, 0.10823680221510856292 },
{ /*160 f=16000 */ 0.99999999999999988898, 0.10823680221510856292 },
{ /*161 f=16100 */ 1.00566275829808415843, 0.10823680221510856292 },
{ /*162 f=16200 */ 1.01131474675596910728, 0.10823680221510856292 },
{ /*163 f=16300 */ 1.01695590484539954979, 0.10823680221510856292 },
{ /*164 f=16400 */ 1.02258617215410430035, 0.10823680221510856292 },
{ /*165 f=16500 */ 1.02820548838644332257, 0.10823680221510856292 },
{ /*166 f=16600 */ 1.03381379336405498925, 0.10823680221510856292 },
{ /*167 f=16700 */ 1.03941102702649845746, 0.10823680221510856292 },
{ /*168 f=16800 */ 1.04499712943189759784, 0.10823680221510856292 },
{ /*169 f=16900 */ 1.05057204075758403583, 0.10823680221510856292 },
{ /*170 f=17000 */ 1.05613570130073597397, 0.10823680221510856292 },
{ /*171 f=17100 */ 1.06168805147901901265, 0.10823680221510856292 },
{ /*172 f=17200 */ 1.06722903183122297399, 0.10823680221510856292 },
{ /*173 f=17300 */ 1.07275858301790050220, 0.10823680221510856292 },
{ /*174 f=17400 */ 1.07827664582200033472, 0.10823680221510856292 },
{ /*175 f=17500 */ 1.08378316114950346005, 0.10823680221510856292 },
{ /*176 f=17600 */ 1.08927807003005394648, 0.10823680221510856292 },
{ /*177 f=17700 */ 1.09476131361759310145, 0.10823680221510856292 },
{ /*178 f=17800 */ 1.10023283319098674760, 0.10823680221510856292 },
{ /*179 f=17900 */ 1.10569257015465582938, 0.10823680221510856292 },
{ /*180 f=18000 */ 1.11114046603920435530, 0.10823680221510856292 },
{ /*181 f=18100 */ 1.11657646250204400928, 0.10823680221510856292 },
{ /*182 f=18200 */ 1.12200050132801965042, 0.10823680221510856292 },
{ /*183 f=18300 */ 1.12741252443003325823, 0.10823680221510856292 },
{ /*184 f=18400 */ 1.13281247384966565761, 0.10823680221510856292 },
{ /*185 f=18500 */ 1.13820029175779646735, 0.10823680221510856292 },
{ /*186 f=18600 */ 1.14357592045522449276, 0.10823680221510856292 },
{ /*187 f=18700 */ 1.14893930237328523170, 0.10823680221510856292 },
{ /*188 f=18800 */ 1.15429038007446727043, 0.10823680221510856292 },
{ /*189 f=18900 */ 1.15962909625302712513, 0.10823680221510856292 },
{ /*190 f=19000 */ 1.16495539373560430541, 0.10823680221510856292 },
{ /*191 f=19100 */ 1.17026921548183104882, 0.10823680221510856292 },
{ /*192 f=19200 */ 1.17557050458494627421, 0.10823680221510856292 },
{ /*193 f=19300 */ 1.18085920427240220754, 0.10823680221510856292 },
{ /*194 f=19400 */ 1.18613525790647433844, 0.10823680221510856292 },
{ /*195 f=19500 */ 1.19139860898486671381, 0.10823680221510856292 },
{ /*196 f=19600 */ 1.19664920114131789752, 0.10823680221510856292 },
{ /*197 f=19700 */ 1.20188697814620470972, 0.10823680221510856292 },
{ /*198 f=19800 */ 1.20711188390714285745, 0.10823680221510856292 },
{ /*199 f=19900 */ 1.21232386246958934173, 0.10823680221510856292 },
{ /*200 f=20000 */ 1.21752285801744131177, 0.10823680221510856292 },
{ /*201 f=20100 */ 1.22270881487363292095, 0.10823680221510856292 },
{ /*202 f=20200 */ 1.22788167750073284878, 0.10823680221510856292 },
{ /*203 f=20300 */ 1.23304139050153827029, 0.10823680221510856292 },
{ /*204 f=20400 */ 1.23818789861966793708, 0.10823680221510856292 },
{ /*205 f=20500 */ 1.24332114674015481448, 0.10823680221510856292 },
{ /*206 f=20600 */ 1.24844107989003516579, 0.10823680221510856292 },
{ /*207 f=20700 */ 1.25354764323893919098, 0.10823680221510856292 },
{ /*208 f=20800 */ 1.25864078209967500399, 0.10823680221510856292 },
{ /*209 f=20900 */ 1.26372044192881749503, 0.10823680221510856292 },
{ /*210 f=21000 */ 1.26878656832729097559, 0.10823680221510856292 },
{ /*211 f=21100 */ 1.27383910704095182354, 0.10823680221510856292 },
{ /*212 f=21200 */ 1.27887800396116935175, 0.10823680221510856292 },
{ /*213 f=21300 */ 1.28390320512540601072, 0.10823680221510856292 },
{ /*214 f=21400 */ 1.28891465671779492652, 0.10823680221510856292 },
{ /*215 f=21500 */ 1.29391230506971455227, 0.10823680221510856292 },
{ /*216 f=21600 */ 1.29889609666036731639, 0.10823680221510856292 },
{ /*217 f=21700 */ 1.30386597811734850083, 0.10823680221510856292 },
{ /*218 f=21800 */ 1.30882189621722067052, 0.10823680221510856292 },
{ /*219 f=21900 */ 1.31376379788608255161, 0.10823680221510856292 },
{ /*220 f=22000 */ 1.31869163020013768772, 0.10823680221510856292 },
{ /*221 f=22100 */ 1.32360534038626065367, 0.10823680221510856292 },
{ /*222 f=22200 */ 1.32850487582256349128, 0.10823680221510856292 },
{ /*223 f=22300 */ 1.33339018403895726017, 0.10823680221510856292 },
{ /*224 f=22400 */ 1.33826121271771647514, 0.10823680221510856292 },
{ /*225 f=22500 */ 1.34311790969403666018, 0.10823680221510856292 },
{ /*226 f=22600 */ 1.34796022295659567725, 0.10823680221510856292 },
{ /*227 f=22700 */ 1.35278810064810839364, 0.10823680221510856292 },
{ /*228 f=22800 */ 1.35760149106588334789, 0.10823680221510856292 },
{ /*229 f=22900 */ 1.36240034266237652893, 0.10823680221510856292 },
{ /*230 f=23000 */ 1.36718460404574249090, 0.10823680221510856292 },
{ /*231 f=23100 */ 1.37195422398038568979, 0.10823680221510856292 },
{ /*232 f=23200 */ 1.37670915138750782347, 0.10823680221510856292 },
{ /*233 f=23300 */ 1.38144933534565739208, 0.10823680221510856292 },
{ /*234 f=23400 */ 1.38617472509127170888, 0.10823680221510856292 },
{ /*235 f=23500 */ 1.39088527001922335202, 0.10823680221510856292 },
{ /*236 f=23600 */ 1.39558091968336017707, 0.10823680221510856292 },
{ /*237 f=23700 */ 1.40026162379704732786, 0.10823680221510856292 },
{ /*238 f=23800 */ 1.40492733223370347417, 0.10823680221510856292 },
{ /*239 f=23900 */ 1.40957799502734015817, 0.10823680221510856292 },
{ /*240 f=24000 */ 1.41421356237309492343, 0.10823680221510856292 }
};
static FLOAT_T vsf_q80[241][2] = {
{ /* dummy entry */ 0, 0},
{ /*  1 f=  100 */ 0.00654497301305325026, 0.08444377261189717210 },
{ /*  2 f=  200 */ 0.01308987593470371628, 0.08444377261189717210 },
{ /*  3 f=  300 */ 0.01963463867429923390, 0.08444377261189717210 },
{ /*  4 f=  400 */ 0.02617919114268887903, 0.08444377261189717210 },
{ /*  5 f=  500 */ 0.03272346325297356001, 0.08444377261189717210 },
{ /*  6 f=  600 */ 0.03926738492125660118, 0.08444377261189717210 },
{ /*  7 f=  700 */ 0.04581088606739427971, 0.08444377261189717210 },
{ /*  8 f=  800 */ 0.05235389661574629816, 0.08444377261189717210 },
{ /*  9 f=  900 */ 0.05889634649592632304, 0.08444377261189717210 },
{ /* 10 f= 1000 */ 0.06543816564355227350, 0.08444377261189717210 },
{ /* 11 f= 1100 */ 0.07197928400099674884, 0.08444377261189717210 },
{ /* 12 f= 1200 */ 0.07851963151813722008, 0.08444377261189717210 },
{ /* 13 f= 1300 */ 0.08505913815310624237, 0.08444377261189717210 },
{ /* 14 f= 1400 */ 0.09159773387304154246, 0.08444377261189717210 },
{ /* 15 f= 1500 */ 0.09813534865483602987, 0.08444377261189717210 },
{ /* 16 f= 1600 */ 0.10467191248588765540, 0.08444377261189717210 },
{ /* 17 f= 1700 */ 0.11120735536484922801, 0.08444377261189717210 },
{ /* 18 f= 1800 */ 0.11774160730237806516, 0.08444377261189717210 },
{ /* 19 f= 1900 */ 0.12427459832188544886, 0.08444377261189717210 },
{ /* 20 f= 2000 */ 0.13080625846028612336, 0.08444377261189717210 },
{ /* 21 f= 2100 */ 0.13733651776874752914, 0.08444377261189717210 },
{ /* 22 f= 2200 */ 0.14386530631343877329, 0.08444377261189717210 },
{ /* 23 f= 2300 */ 0.15039255417627980793, 0.08444377261189717210 },
{ /* 24 f= 2400 */ 0.15691819145568988714, 0.08444377261189717210 },
{ /* 25 f= 2500 */ 0.16344214826733644008, 0.08444377261189717210 },
{ /* 26 f= 2600 */ 0.16996435474488333361, 0.08444377261189717210 },
{ /* 27 f= 2700 */ 0.17648474104073902380, 0.08444377261189717210 },
{ /* 28 f= 2800 */ 0.18300323732680476296, 0.08444377261189717210 },
{ /* 29 f= 2900 */ 0.18951977379522222389, 0.08444377261189717210 },
{ /* 30 f= 3000 */ 0.19603428065912120726, 0.08444377261189717210 },
{ /* 31 f= 3100 */ 0.20254668815336684951, 0.08444377261189717210 },
{ /* 32 f= 3200 */ 0.20905692653530691394, 0.08444377261189717210 },
{ /* 33 f= 3300 */ 0.21556492608551869328, 0.08444377261189717210 },
{ /* 34 f= 3400 */ 0.22207061710855535708, 0.08444377261189717210 },
{ /* 35 f= 3500 */ 0.22857392993369279877, 0.08444377261189717210 },
{ /* 36 f= 3600 */ 0.23507479491567528918, 0.08444377261189717210 },
{ /* 37 f= 3700 */ 0.24157314243546165744, 0.08444377261189717210 },
{ /* 38 f= 3800 */ 0.24806890290097063922, 0.08444377261189717210 },
{ /* 39 f= 3900 */ 0.25456200674782641924, 0.08444377261189717210 },
{ /* 40 f= 4000 */ 0.26105238444010314680, 0.08444377261189717210 },
{ /* 41 f= 4100 */ 0.26753996647107025630, 0.08444377261189717210 },
{ /* 42 f= 4200 */ 0.27402468336393603909, 0.08444377261189717210 },
{ /* 43 f= 4300 */ 0.28050646567259251984, 0.08444377261189717210 },
{ /* 44 f= 4400 */ 0.28698524398235858435, 0.08444377261189717210 },
{ /* 45 f= 4500 */ 0.29346094891072349586, 0.08444377261189717210 },
{ /* 46 f= 4600 */ 0.29993351110809002291, 0.08444377261189717210 },
{ /* 47 f= 4700 */ 0.30640286125851695642, 0.08444377261189717210 },
{ /* 48 f= 4800 */ 0.31286893008046173792, 0.08444377261189717210 },
{ /* 49 f= 4900 */ 0.31933164832752197748, 0.08444377261189717210 },
{ /* 50 f= 5000 */ 0.32579094678917747130, 0.08444377261189717210 },
{ /* 51 f= 5100 */ 0.33224675629153094247, 0.08444377261189717210 },
{ /* 52 f= 5200 */ 0.33869900769804922591, 0.08444377261189717210 },
{ /* 53 f= 5300 */ 0.34514763191030339851, 0.08444377261189717210 },
{ /* 54 f= 5400 */ 0.35159255986870902033, 0.08444377261189717210 },
{ /* 55 f= 5500 */ 0.35803372255326532114, 0.08444377261189717210 },
{ /* 56 f= 5600 */ 0.36447105098429494197, 0.08444377261189717210 },
{ /* 57 f= 5700 */ 0.37090447622318184484, 0.08444377261189717210 },
{ /* 58 f= 5800 */ 0.37733392937311044379, 0.08444377261189717210 },
{ /* 59 f= 5900 */ 0.38375934157980284844, 0.08444377261189717210 },
{ /* 60 f= 6000 */ 0.39018064403225649617, 0.08444377261189717210 },
{ /* 61 f= 6100 */ 0.39659776796348089611, 0.08444377261189717210 },
{ /* 62 f= 6200 */ 0.40301064465123426217, 0.08444377261189717210 },
{ /* 63 f= 6300 */ 0.40941920541875920225, 0.08444377261189717210 },
{ /* 64 f= 6400 */ 0.41582338163551862964, 0.08444377261189717210 },
{ /* 65 f= 6500 */ 0.42222310471793028652, 0.08444377261189717210 },
{ /* 66 f= 6600 */ 0.42861830613010154511, 0.08444377261189717210 },
{ /* 67 f= 6700 */ 0.43500891738456293201, 0.08444377261189717210 },
{ /* 68 f= 6800 */ 0.44139487004300215212, 0.08444377261189717210 },
{ /* 69 f= 6900 */ 0.44777609571699672486, 0.08444377261189717210 },
{ /* 70 f= 7000 */ 0.45415252606874645380, 0.08444377261189717210 },
{ /* 71 f= 7100 */ 0.46052409281180473055, 0.08444377261189717210 },
{ /* 72 f= 7200 */ 0.46689072771181078236, 0.08444377261189717210 },
{ /* 73 f= 7300 */ 0.47325236258721975480, 0.08444377261189717210 },
{ /* 74 f= 7400 */ 0.47960892931003307194, 0.08444377261189717210 },
{ /* 75 f= 7500 */ 0.48596035980652774189, 0.08444377261189717210 },
{ /* 76 f= 7600 */ 0.49230658605798605088, 0.08444377261189717210 },
{ /* 77 f= 7700 */ 0.49864754010142336993, 0.08444377261189717210 },
{ /* 78 f= 7800 */ 0.50498315403031590609, 0.08444377261189717210 },
{ /* 79 f= 7900 */ 0.51131335999532878667, 0.08444377261189717210 },
{ /* 80 f= 8000 */ 0.51763809020504147895, 0.08444377261189717210 },
{ /* 81 f= 8100 */ 0.52395727692667493081, 0.08444377261189717210 },
{ /* 82 f= 8200 */ 0.53027085248681604668, 0.08444377261189717210 },
{ /* 83 f= 8300 */ 0.53657874927214277427, 0.08444377261189717210 },
{ /* 84 f= 8400 */ 0.54288089973014852507, 0.08444377261189717210 },
{ /* 85 f= 8500 */ 0.54917723636986470748, 0.08444377261189717210 },
{ /* 86 f= 8600 */ 0.55546769176258437017, 0.08444377261189717210 },
{ /* 87 f= 8700 */ 0.56175219854258418017, 0.08444377261189717210 },
{ /* 88 f= 8800 */ 0.56803068940784517959, 0.08444377261189717210 },
{ /* 89 f= 8900 */ 0.57430309712077465267, 0.08444377261189717210 },
{ /* 90 f= 9000 */ 0.58056935450892466211, 0.08444377261189717210 },
{ /* 91 f= 9100 */ 0.58682939446571336095, 0.08444377261189717210 },
{ /* 92 f= 9200 */ 0.59308314995114197465, 0.08444377261189717210 },
{ /* 93 f= 9300 */ 0.59933055399251322637, 0.08444377261189717210 },
{ /* 94 f= 9400 */ 0.60557153968514920717, 0.08444377261189717210 },
{ /* 95 f= 9500 */ 0.61180604019310691477, 0.08444377261189717210 },
{ /* 96 f= 9600 */ 0.61803398874989479150, 0.08444377261189717210 },
{ /* 97 f= 9700 */ 0.62425531865918737484, 0.08444377261189717210 },
{ /* 98 f= 9800 */ 0.63046996329553928184, 0.08444377261189717210 },
{ /* 99 f= 9900 */ 0.63667785610509941563, 0.08444377261189717210 },
{ /*100 f=10000 */ 0.64287893060632317344, 0.08444377261189717210 },
{ /*101 f=10100 */ 0.64907312039068432163, 0.08444377261189717210 },
{ /*102 f=10200 */ 0.65526035912338698175, 0.08444377261189717210 },
{ /*103 f=10300 */ 0.66144058054407484093, 0.08444377261189717210 },
{ /*104 f=10400 */ 0.66761371846754191672, 0.08444377261189717210 },
{ /*105 f=10500 */ 0.67377970678444010222, 0.08444377261189717210 },
{ /*106 f=10600 */ 0.67993847946198837651, 0.08444377261189717210 },
{ /*107 f=10700 */ 0.68608997054467968368, 0.08444377261189717210 },
{ /*108 f=10800 */ 0.69223411415498592447, 0.08444377261189717210 },
{ /*109 f=10900 */ 0.69837084449406572340, 0.08444377261189717210 },
{ /*110 f=11000 */ 0.70450009584246697791, 0.08444377261189717210 },
{ /*111 f=11100 */ 0.71062180256083218310, 0.08444377261189717210 },
{ /*112 f=11200 */ 0.71673589909060053671, 0.08444377261189717210 },
{ /*113 f=11300 */ 0.72284231995471004417, 0.08444377261189717210 },
{ /*114 f=11400 */ 0.72894099975829929061, 0.08444377261189717210 },
{ /*115 f=11500 */ 0.73503187318940710338, 0.08444377261189717210 },
{ /*116 f=11600 */ 0.74111487501967243663, 0.08444377261189717210 },
{ /*117 f=11700 */ 0.74718994010503270164, 0.08444377261189717210 },
{ /*118 f=11800 */ 0.75325700338642143095, 0.08444377261189717210 },
{ /*119 f=11900 */ 0.75931599989046549837, 0.08444377261189717210 },
{ /*120 f=12000 */ 0.76536686473017956356, 0.08444377261189717210 },
{ /*121 f=12100 */ 0.77140953310566262591, 0.08444377261189717210 },
{ /*122 f=12200 */ 0.77744394030479113678, 0.08444377261189717210 },
{ /*123 f=12300 */ 0.78347002170391177867, 0.08444377261189717210 },
{ /*124 f=12400 */ 0.78948771276853446643, 0.08444377261189717210 },
{ /*125 f=12500 */ 0.79549694905402212886, 0.08444377261189717210 },
{ /*126 f=12600 */ 0.80149766620628193348, 0.08444377261189717210 },
{ /*127 f=12700 */ 0.80748979996245418000, 0.08444377261189717210 },
{ /*128 f=12800 */ 0.81347328615160030552, 0.08444377261189717210 },
{ /*129 f=12900 */ 0.81944806069539055660, 0.08444377261189717210 },
{ /*130 f=13000 */ 0.82541405960878933001, 0.08444377261189717210 },
{ /*131 f=13100 */ 0.83137121900074162362, 0.08444377261189717210 },
{ /*132 f=13200 */ 0.83731947507485626758, 0.08444377261189717210 },
{ /*133 f=13300 */ 0.84325876413008904464, 0.08444377261189717210 },
{ /*134 f=13400 */ 0.84918902256142625440, 0.08444377261189717210 },
{ /*135 f=13500 */ 0.85511018686056416982, 0.08444377261189717210 },
{ /*136 f=13600 */ 0.86102219361659015906, 0.08444377261189717210 },
{ /*137 f=13700 */ 0.86692497951666180889, 0.08444377261189717210 },
{ /*138 f=13800 */ 0.87281848134668404970, 0.08444377261189717210 },
{ /*139 f=13900 */ 0.87870263599198739080, 0.08444377261189717210 },
{ /*140 f=14000 */ 0.88457738043800260286, 0.08444377261189717210 },
{ /*141 f=14100 */ 0.89044265177093639974, 0.08444377261189717210 },
{ /*142 f=14200 */ 0.89629838717844512175, 0.08444377261189717210 },
{ /*143 f=14300 */ 0.90214452395030675369, 0.08444377261189717210 },
{ /*144 f=14400 */ 0.90798099947909349794, 0.08444377261189717210 },
{ /*145 f=14500 */ 0.91380775126084123894, 0.08444377261189717210 },
{ /*146 f=14600 */ 0.91962471689571967381, 0.08444377261189717210 },
{ /*147 f=14700 */ 0.92543183408870022255, 0.08444377261189717210 },
{ /*148 f=14800 */ 0.93122904065022282794, 0.08444377261189717210 },
{ /*149 f=14900 */ 0.93701627449686286653, 0.08444377261189717210 },
{ /*150 f=15000 */ 0.94279347365199528408, 0.08444377261189717210 },
{ /*151 f=15100 */ 0.94856057624645839788, 0.08444377261189717210 },
{ /*152 f=15200 */ 0.95431752051921681090, 0.08444377261189717210 },
{ /*153 f=15300 */ 0.96006424481802221660, 0.08444377261189717210 },
{ /*154 f=15400 */ 0.96580068760007475870, 0.08444377261189717210 },
{ /*155 f=15500 */ 0.97152678743268006123, 0.08444377261189717210 },
{ /*156 f=15600 */ 0.97724248299390981121, 0.08444377261189717210 },
{ /*157 f=15700 */ 0.98294771307325645715, 0.08444377261189717210 },
{ /*158 f=15800 */ 0.98864241657228923987, 0.08444377261189717210 },
{ /*159 f=15900 */ 0.99432653250530855793, 0.08444377261189717210 },
{ /*160 f=16000 */ 0.99999999999999988898, 0.08444377261189717210 },
{ /*161 f=16100 */ 1.00566275829808415843, 0.08444377261189717210 },
{ /*162 f=16200 */ 1.01131474675596910728, 0.08444377261189717210 },
{ /*163 f=16300 */ 1.01695590484539954979, 0.08444377261189717210 },
{ /*164 f=16400 */ 1.02258617215410430035, 0.08444377261189717210 },
{ /*165 f=16500 */ 1.02820548838644332257, 0.08444377261189717210 },
{ /*166 f=16600 */ 1.03381379336405498925, 0.08444377261189717210 },
{ /*167 f=16700 */ 1.03941102702649845746, 0.08444377261189717210 },
{ /*168 f=16800 */ 1.04499712943189759784, 0.08444377261189717210 },
{ /*169 f=16900 */ 1.05057204075758403583, 0.08444377261189717210 },
{ /*170 f=17000 */ 1.05613570130073597397, 0.08444377261189717210 },
{ /*171 f=17100 */ 1.06168805147901901265, 0.08444377261189717210 },
{ /*172 f=17200 */ 1.06722903183122297399, 0.08444377261189717210 },
{ /*173 f=17300 */ 1.07275858301790050220, 0.08444377261189717210 },
{ /*174 f=17400 */ 1.07827664582200033472, 0.08444377261189717210 },
{ /*175 f=17500 */ 1.08378316114950346005, 0.08444377261189717210 },
{ /*176 f=17600 */ 1.08927807003005394648, 0.08444377261189717210 },
{ /*177 f=17700 */ 1.09476131361759310145, 0.08444377261189717210 },
{ /*178 f=17800 */ 1.10023283319098674760, 0.08444377261189717210 },
{ /*179 f=17900 */ 1.10569257015465582938, 0.08444377261189717210 },
{ /*180 f=18000 */ 1.11114046603920435530, 0.08444377261189717210 },
{ /*181 f=18100 */ 1.11657646250204400928, 0.08444377261189717210 },
{ /*182 f=18200 */ 1.12200050132801965042, 0.08444377261189717210 },
{ /*183 f=18300 */ 1.12741252443003325823, 0.08444377261189717210 },
{ /*184 f=18400 */ 1.13281247384966565761, 0.08444377261189717210 },
{ /*185 f=18500 */ 1.13820029175779646735, 0.08444377261189717210 },
{ /*186 f=18600 */ 1.14357592045522449276, 0.08444377261189717210 },
{ /*187 f=18700 */ 1.14893930237328523170, 0.08444377261189717210 },
{ /*188 f=18800 */ 1.15429038007446727043, 0.08444377261189717210 },
{ /*189 f=18900 */ 1.15962909625302712513, 0.08444377261189717210 },
{ /*190 f=19000 */ 1.16495539373560430541, 0.08444377261189717210 },
{ /*191 f=19100 */ 1.17026921548183104882, 0.08444377261189717210 },
{ /*192 f=19200 */ 1.17557050458494627421, 0.08444377261189717210 },
{ /*193 f=19300 */ 1.18085920427240220754, 0.08444377261189717210 },
{ /*194 f=19400 */ 1.18613525790647433844, 0.08444377261189717210 },
{ /*195 f=19500 */ 1.19139860898486671381, 0.08444377261189717210 },
{ /*196 f=19600 */ 1.19664920114131789752, 0.08444377261189717210 },
{ /*197 f=19700 */ 1.20188697814620470972, 0.08444377261189717210 },
{ /*198 f=19800 */ 1.20711188390714285745, 0.08444377261189717210 },
{ /*199 f=19900 */ 1.21232386246958934173, 0.08444377261189717210 },
{ /*200 f=20000 */ 1.21752285801744131177, 0.08444377261189717210 },
{ /*201 f=20100 */ 1.22270881487363292095, 0.08444377261189717210 },
{ /*202 f=20200 */ 1.22788167750073284878, 0.08444377261189717210 },
{ /*203 f=20300 */ 1.23304139050153827029, 0.08444377261189717210 },
{ /*204 f=20400 */ 1.23818789861966793708, 0.08444377261189717210 },
{ /*205 f=20500 */ 1.24332114674015481448, 0.08444377261189717210 },
{ /*206 f=20600 */ 1.24844107989003516579, 0.08444377261189717210 },
{ /*207 f=20700 */ 1.25354764323893919098, 0.08444377261189717210 },
{ /*208 f=20800 */ 1.25864078209967500399, 0.08444377261189717210 },
{ /*209 f=20900 */ 1.26372044192881749503, 0.08444377261189717210 },
{ /*210 f=21000 */ 1.26878656832729097559, 0.08444377261189717210 },
{ /*211 f=21100 */ 1.27383910704095182354, 0.08444377261189717210 },
{ /*212 f=21200 */ 1.27887800396116935175, 0.08444377261189717210 },
{ /*213 f=21300 */ 1.28390320512540601072, 0.08444377261189717210 },
{ /*214 f=21400 */ 1.28891465671779492652, 0.08444377261189717210 },
{ /*215 f=21500 */ 1.29391230506971455227, 0.08444377261189717210 },
{ /*216 f=21600 */ 1.29889609666036731639, 0.08444377261189717210 },
{ /*217 f=21700 */ 1.30386597811734850083, 0.08444377261189717210 },
{ /*218 f=21800 */ 1.30882189621722067052, 0.08444377261189717210 },
{ /*219 f=21900 */ 1.31376379788608255161, 0.08444377261189717210 },
{ /*220 f=22000 */ 1.31869163020013768772, 0.08444377261189717210 },
{ /*221 f=22100 */ 1.32360534038626065367, 0.08444377261189717210 },
{ /*222 f=22200 */ 1.32850487582256349128, 0.08444377261189717210 },
{ /*223 f=22300 */ 1.33339018403895726017, 0.08444377261189717210 },
{ /*224 f=22400 */ 1.33826121271771647514, 0.08444377261189717210 },
{ /*225 f=22500 */ 1.34311790969403666018, 0.08444377261189717210 },
{ /*226 f=22600 */ 1.34796022295659567725, 0.08444377261189717210 },
{ /*227 f=22700 */ 1.35278810064810839364, 0.08444377261189717210 },
{ /*228 f=22800 */ 1.35760149106588334789, 0.08444377261189717210 },
{ /*229 f=22900 */ 1.36240034266237652893, 0.08444377261189717210 },
{ /*230 f=23000 */ 1.36718460404574249090, 0.08444377261189717210 },
{ /*231 f=23100 */ 1.37195422398038568979, 0.08444377261189717210 },
{ /*232 f=23200 */ 1.37670915138750782347, 0.08444377261189717210 },
{ /*233 f=23300 */ 1.38144933534565739208, 0.08444377261189717210 },
{ /*234 f=23400 */ 1.38617472509127170888, 0.08444377261189717210 },
{ /*235 f=23500 */ 1.39088527001922335202, 0.08444377261189717210 },
{ /*236 f=23600 */ 1.39558091968336017707, 0.08444377261189717210 },
{ /*237 f=23700 */ 1.40026162379704732786, 0.08444377261189717210 },
{ /*238 f=23800 */ 1.40492733223370347417, 0.08444377261189717210 },
{ /*239 f=23900 */ 1.40957799502734015817, 0.08444377261189717210 },
{ /*240 f=24000 */ 1.41421356237309492343, 0.08444377261189717210 }
};
static FLOAT_T vsf_q90[241][2] = {
{ /* dummy entry */ 0, 0},
{ /*  1 f=  100 */ 0.00654497301305325026, 0.06615704492794938218 },
{ /*  2 f=  200 */ 0.01308987593470371628, 0.06615704492794938218 },
{ /*  3 f=  300 */ 0.01963463867429923390, 0.06615704492794938218 },
{ /*  4 f=  400 */ 0.02617919114268887903, 0.06615704492794938218 },
{ /*  5 f=  500 */ 0.03272346325297356001, 0.06615704492794938218 },
{ /*  6 f=  600 */ 0.03926738492125660118, 0.06615704492794938218 },
{ /*  7 f=  700 */ 0.04581088606739427971, 0.06615704492794938218 },
{ /*  8 f=  800 */ 0.05235389661574629816, 0.06615704492794938218 },
{ /*  9 f=  900 */ 0.05889634649592632304, 0.06615704492794938218 },
{ /* 10 f= 1000 */ 0.06543816564355227350, 0.06615704492794938218 },
{ /* 11 f= 1100 */ 0.07197928400099674884, 0.06615704492794938218 },
{ /* 12 f= 1200 */ 0.07851963151813722008, 0.06615704492794938218 },
{ /* 13 f= 1300 */ 0.08505913815310624237, 0.06615704492794938218 },
{ /* 14 f= 1400 */ 0.09159773387304154246, 0.06615704492794938218 },
{ /* 15 f= 1500 */ 0.09813534865483602987, 0.06615704492794938218 },
{ /* 16 f= 1600 */ 0.10467191248588765540, 0.06615704492794938218 },
{ /* 17 f= 1700 */ 0.11120735536484922801, 0.06615704492794938218 },
{ /* 18 f= 1800 */ 0.11774160730237806516, 0.06615704492794938218 },
{ /* 19 f= 1900 */ 0.12427459832188544886, 0.06615704492794938218 },
{ /* 20 f= 2000 */ 0.13080625846028612336, 0.06615704492794938218 },
{ /* 21 f= 2100 */ 0.13733651776874752914, 0.06615704492794938218 },
{ /* 22 f= 2200 */ 0.14386530631343877329, 0.06615704492794938218 },
{ /* 23 f= 2300 */ 0.15039255417627980793, 0.06615704492794938218 },
{ /* 24 f= 2400 */ 0.15691819145568988714, 0.06615704492794938218 },
{ /* 25 f= 2500 */ 0.16344214826733644008, 0.06615704492794938218 },
{ /* 26 f= 2600 */ 0.16996435474488333361, 0.06615704492794938218 },
{ /* 27 f= 2700 */ 0.17648474104073902380, 0.06615704492794938218 },
{ /* 28 f= 2800 */ 0.18300323732680476296, 0.06615704492794938218 },
{ /* 29 f= 2900 */ 0.18951977379522222389, 0.06615704492794938218 },
{ /* 30 f= 3000 */ 0.19603428065912120726, 0.06615704492794938218 },
{ /* 31 f= 3100 */ 0.20254668815336684951, 0.06615704492794938218 },
{ /* 32 f= 3200 */ 0.20905692653530691394, 0.06615704492794938218 },
{ /* 33 f= 3300 */ 0.21556492608551869328, 0.06615704492794938218 },
{ /* 34 f= 3400 */ 0.22207061710855535708, 0.06615704492794938218 },
{ /* 35 f= 3500 */ 0.22857392993369279877, 0.06615704492794938218 },
{ /* 36 f= 3600 */ 0.23507479491567528918, 0.06615704492794938218 },
{ /* 37 f= 3700 */ 0.24157314243546165744, 0.06615704492794938218 },
{ /* 38 f= 3800 */ 0.24806890290097063922, 0.06615704492794938218 },
{ /* 39 f= 3900 */ 0.25456200674782641924, 0.06615704492794938218 },
{ /* 40 f= 4000 */ 0.26105238444010314680, 0.06615704492794938218 },
{ /* 41 f= 4100 */ 0.26753996647107025630, 0.06615704492794938218 },
{ /* 42 f= 4200 */ 0.27402468336393603909, 0.06615704492794938218 },
{ /* 43 f= 4300 */ 0.28050646567259251984, 0.06615704492794938218 },
{ /* 44 f= 4400 */ 0.28698524398235858435, 0.06615704492794938218 },
{ /* 45 f= 4500 */ 0.29346094891072349586, 0.06615704492794938218 },
{ /* 46 f= 4600 */ 0.29993351110809002291, 0.06615704492794938218 },
{ /* 47 f= 4700 */ 0.30640286125851695642, 0.06615704492794938218 },
{ /* 48 f= 4800 */ 0.31286893008046173792, 0.06615704492794938218 },
{ /* 49 f= 4900 */ 0.31933164832752197748, 0.06615704492794938218 },
{ /* 50 f= 5000 */ 0.32579094678917747130, 0.06615704492794938218 },
{ /* 51 f= 5100 */ 0.33224675629153094247, 0.06615704492794938218 },
{ /* 52 f= 5200 */ 0.33869900769804922591, 0.06615704492794938218 },
{ /* 53 f= 5300 */ 0.34514763191030339851, 0.06615704492794938218 },
{ /* 54 f= 5400 */ 0.35159255986870902033, 0.06615704492794938218 },
{ /* 55 f= 5500 */ 0.35803372255326532114, 0.06615704492794938218 },
{ /* 56 f= 5600 */ 0.36447105098429494197, 0.06615704492794938218 },
{ /* 57 f= 5700 */ 0.37090447622318184484, 0.06615704492794938218 },
{ /* 58 f= 5800 */ 0.37733392937311044379, 0.06615704492794938218 },
{ /* 59 f= 5900 */ 0.38375934157980284844, 0.06615704492794938218 },
{ /* 60 f= 6000 */ 0.39018064403225649617, 0.06615704492794938218 },
{ /* 61 f= 6100 */ 0.39659776796348089611, 0.06615704492794938218 },
{ /* 62 f= 6200 */ 0.40301064465123426217, 0.06615704492794938218 },
{ /* 63 f= 6300 */ 0.40941920541875920225, 0.06615704492794938218 },
{ /* 64 f= 6400 */ 0.41582338163551862964, 0.06615704492794938218 },
{ /* 65 f= 6500 */ 0.42222310471793028652, 0.06615704492794938218 },
{ /* 66 f= 6600 */ 0.42861830613010154511, 0.06615704492794938218 },
{ /* 67 f= 6700 */ 0.43500891738456293201, 0.06615704492794938218 },
{ /* 68 f= 6800 */ 0.44139487004300215212, 0.06615704492794938218 },
{ /* 69 f= 6900 */ 0.44777609571699672486, 0.06615704492794938218 },
{ /* 70 f= 7000 */ 0.45415252606874645380, 0.06615704492794938218 },
{ /* 71 f= 7100 */ 0.46052409281180473055, 0.06615704492794938218 },
{ /* 72 f= 7200 */ 0.46689072771181078236, 0.06615704492794938218 },
{ /* 73 f= 7300 */ 0.47325236258721975480, 0.06615704492794938218 },
{ /* 74 f= 7400 */ 0.47960892931003307194, 0.06615704492794938218 },
{ /* 75 f= 7500 */ 0.48596035980652774189, 0.06615704492794938218 },
{ /* 76 f= 7600 */ 0.49230658605798605088, 0.06615704492794938218 },
{ /* 77 f= 7700 */ 0.49864754010142336993, 0.06615704492794938218 },
{ /* 78 f= 7800 */ 0.50498315403031590609, 0.06615704492794938218 },
{ /* 79 f= 7900 */ 0.51131335999532878667, 0.06615704492794938218 },
{ /* 80 f= 8000 */ 0.51763809020504147895, 0.06615704492794938218 },
{ /* 81 f= 8100 */ 0.52395727692667493081, 0.06615704492794938218 },
{ /* 82 f= 8200 */ 0.53027085248681604668, 0.06615704492794938218 },
{ /* 83 f= 8300 */ 0.53657874927214277427, 0.06615704492794938218 },
{ /* 84 f= 8400 */ 0.54288089973014852507, 0.06615704492794938218 },
{ /* 85 f= 8500 */ 0.54917723636986470748, 0.06615704492794938218 },
{ /* 86 f= 8600 */ 0.55546769176258437017, 0.06615704492794938218 },
{ /* 87 f= 8700 */ 0.56175219854258418017, 0.06615704492794938218 },
{ /* 88 f= 8800 */ 0.56803068940784517959, 0.06615704492794938218 },
{ /* 89 f= 8900 */ 0.57430309712077465267, 0.06615704492794938218 },
{ /* 90 f= 9000 */ 0.58056935450892466211, 0.06615704492794938218 },
{ /* 91 f= 9100 */ 0.58682939446571336095, 0.06615704492794938218 },
{ /* 92 f= 9200 */ 0.59308314995114197465, 0.06615704492794938218 },
{ /* 93 f= 9300 */ 0.59933055399251322637, 0.06615704492794938218 },
{ /* 94 f= 9400 */ 0.60557153968514920717, 0.06615704492794938218 },
{ /* 95 f= 9500 */ 0.61180604019310691477, 0.06615704492794938218 },
{ /* 96 f= 9600 */ 0.61803398874989479150, 0.06615704492794938218 },
{ /* 97 f= 9700 */ 0.62425531865918737484, 0.06615704492794938218 },
{ /* 98 f= 9800 */ 0.63046996329553928184, 0.06615704492794938218 },
{ /* 99 f= 9900 */ 0.63667785610509941563, 0.06615704492794938218 },
{ /*100 f=10000 */ 0.64287893060632317344, 0.06615704492794938218 },
{ /*101 f=10100 */ 0.64907312039068432163, 0.06615704492794938218 },
{ /*102 f=10200 */ 0.65526035912338698175, 0.06615704492794938218 },
{ /*103 f=10300 */ 0.66144058054407484093, 0.06615704492794938218 },
{ /*104 f=10400 */ 0.66761371846754191672, 0.06615704492794938218 },
{ /*105 f=10500 */ 0.67377970678444010222, 0.06615704492794938218 },
{ /*106 f=10600 */ 0.67993847946198837651, 0.06615704492794938218 },
{ /*107 f=10700 */ 0.68608997054467968368, 0.06615704492794938218 },
{ /*108 f=10800 */ 0.69223411415498592447, 0.06615704492794938218 },
{ /*109 f=10900 */ 0.69837084449406572340, 0.06615704492794938218 },
{ /*110 f=11000 */ 0.70450009584246697791, 0.06615704492794938218 },
{ /*111 f=11100 */ 0.71062180256083218310, 0.06615704492794938218 },
{ /*112 f=11200 */ 0.71673589909060053671, 0.06615704492794938218 },
{ /*113 f=11300 */ 0.72284231995471004417, 0.06615704492794938218 },
{ /*114 f=11400 */ 0.72894099975829929061, 0.06615704492794938218 },
{ /*115 f=11500 */ 0.73503187318940710338, 0.06615704492794938218 },
{ /*116 f=11600 */ 0.74111487501967243663, 0.06615704492794938218 },
{ /*117 f=11700 */ 0.74718994010503270164, 0.06615704492794938218 },
{ /*118 f=11800 */ 0.75325700338642143095, 0.06615704492794938218 },
{ /*119 f=11900 */ 0.75931599989046549837, 0.06615704492794938218 },
{ /*120 f=12000 */ 0.76536686473017956356, 0.06615704492794938218 },
{ /*121 f=12100 */ 0.77140953310566262591, 0.06615704492794938218 },
{ /*122 f=12200 */ 0.77744394030479113678, 0.06615704492794938218 },
{ /*123 f=12300 */ 0.78347002170391177867, 0.06615704492794938218 },
{ /*124 f=12400 */ 0.78948771276853446643, 0.06615704492794938218 },
{ /*125 f=12500 */ 0.79549694905402212886, 0.06615704492794938218 },
{ /*126 f=12600 */ 0.80149766620628193348, 0.06615704492794938218 },
{ /*127 f=12700 */ 0.80748979996245418000, 0.06615704492794938218 },
{ /*128 f=12800 */ 0.81347328615160030552, 0.06615704492794938218 },
{ /*129 f=12900 */ 0.81944806069539055660, 0.06615704492794938218 },
{ /*130 f=13000 */ 0.82541405960878933001, 0.06615704492794938218 },
{ /*131 f=13100 */ 0.83137121900074162362, 0.06615704492794938218 },
{ /*132 f=13200 */ 0.83731947507485626758, 0.06615704492794938218 },
{ /*133 f=13300 */ 0.84325876413008904464, 0.06615704492794938218 },
{ /*134 f=13400 */ 0.84918902256142625440, 0.06615704492794938218 },
{ /*135 f=13500 */ 0.85511018686056416982, 0.06615704492794938218 },
{ /*136 f=13600 */ 0.86102219361659015906, 0.06615704492794938218 },
{ /*137 f=13700 */ 0.86692497951666180889, 0.06615704492794938218 },
{ /*138 f=13800 */ 0.87281848134668404970, 0.06615704492794938218 },
{ /*139 f=13900 */ 0.87870263599198739080, 0.06615704492794938218 },
{ /*140 f=14000 */ 0.88457738043800260286, 0.06615704492794938218 },
{ /*141 f=14100 */ 0.89044265177093639974, 0.06615704492794938218 },
{ /*142 f=14200 */ 0.89629838717844512175, 0.06615704492794938218 },
{ /*143 f=14300 */ 0.90214452395030675369, 0.06615704492794938218 },
{ /*144 f=14400 */ 0.90798099947909349794, 0.06615704492794938218 },
{ /*145 f=14500 */ 0.91380775126084123894, 0.06615704492794938218 },
{ /*146 f=14600 */ 0.91962471689571967381, 0.06615704492794938218 },
{ /*147 f=14700 */ 0.92543183408870022255, 0.06615704492794938218 },
{ /*148 f=14800 */ 0.93122904065022282794, 0.06615704492794938218 },
{ /*149 f=14900 */ 0.93701627449686286653, 0.06615704492794938218 },
{ /*150 f=15000 */ 0.94279347365199528408, 0.06615704492794938218 },
{ /*151 f=15100 */ 0.94856057624645839788, 0.06615704492794938218 },
{ /*152 f=15200 */ 0.95431752051921681090, 0.06615704492794938218 },
{ /*153 f=15300 */ 0.96006424481802221660, 0.06615704492794938218 },
{ /*154 f=15400 */ 0.96580068760007475870, 0.06615704492794938218 },
{ /*155 f=15500 */ 0.97152678743268006123, 0.06615704492794938218 },
{ /*156 f=15600 */ 0.97724248299390981121, 0.06615704492794938218 },
{ /*157 f=15700 */ 0.98294771307325645715, 0.06615704492794938218 },
{ /*158 f=15800 */ 0.98864241657228923987, 0.06615704492794938218 },
{ /*159 f=15900 */ 0.99432653250530855793, 0.06615704492794938218 },
{ /*160 f=16000 */ 0.99999999999999988898, 0.06615704492794938218 },
{ /*161 f=16100 */ 1.00566275829808415843, 0.06615704492794938218 },
{ /*162 f=16200 */ 1.01131474675596910728, 0.06615704492794938218 },
{ /*163 f=16300 */ 1.01695590484539954979, 0.06615704492794938218 },
{ /*164 f=16400 */ 1.02258617215410430035, 0.06615704492794938218 },
{ /*165 f=16500 */ 1.02820548838644332257, 0.06615704492794938218 },
{ /*166 f=16600 */ 1.03381379336405498925, 0.06615704492794938218 },
{ /*167 f=16700 */ 1.03941102702649845746, 0.06615704492794938218 },
{ /*168 f=16800 */ 1.04499712943189759784, 0.06615704492794938218 },
{ /*169 f=16900 */ 1.05057204075758403583, 0.06615704492794938218 },
{ /*170 f=17000 */ 1.05613570130073597397, 0.06615704492794938218 },
{ /*171 f=17100 */ 1.06168805147901901265, 0.06615704492794938218 },
{ /*172 f=17200 */ 1.06722903183122297399, 0.06615704492794938218 },
{ /*173 f=17300 */ 1.07275858301790050220, 0.06615704492794938218 },
{ /*174 f=17400 */ 1.07827664582200033472, 0.06615704492794938218 },
{ /*175 f=17500 */ 1.08378316114950346005, 0.06615704492794938218 },
{ /*176 f=17600 */ 1.08927807003005394648, 0.06615704492794938218 },
{ /*177 f=17700 */ 1.09476131361759310145, 0.06615704492794938218 },
{ /*178 f=17800 */ 1.10023283319098674760, 0.06615704492794938218 },
{ /*179 f=17900 */ 1.10569257015465582938, 0.06615704492794938218 },
{ /*180 f=18000 */ 1.11114046603920435530, 0.06615704492794938218 },
{ /*181 f=18100 */ 1.11657646250204400928, 0.06615704492794938218 },
{ /*182 f=18200 */ 1.12200050132801965042, 0.06615704492794938218 },
{ /*183 f=18300 */ 1.12741252443003325823, 0.06615704492794938218 },
{ /*184 f=18400 */ 1.13281247384966565761, 0.06615704492794938218 },
{ /*185 f=18500 */ 1.13820029175779646735, 0.06615704492794938218 },
{ /*186 f=18600 */ 1.14357592045522449276, 0.06615704492794938218 },
{ /*187 f=18700 */ 1.14893930237328523170, 0.06615704492794938218 },
{ /*188 f=18800 */ 1.15429038007446727043, 0.06615704492794938218 },
{ /*189 f=18900 */ 1.15962909625302712513, 0.06615704492794938218 },
{ /*190 f=19000 */ 1.16495539373560430541, 0.06615704492794938218 },
{ /*191 f=19100 */ 1.17026921548183104882, 0.06615704492794938218 },
{ /*192 f=19200 */ 1.17557050458494627421, 0.06615704492794938218 },
{ /*193 f=19300 */ 1.18085920427240220754, 0.06615704492794938218 },
{ /*194 f=19400 */ 1.18613525790647433844, 0.06615704492794938218 },
{ /*195 f=19500 */ 1.19139860898486671381, 0.06615704492794938218 },
{ /*196 f=19600 */ 1.19664920114131789752, 0.06615704492794938218 },
{ /*197 f=19700 */ 1.20188697814620470972, 0.06615704492794938218 },
{ /*198 f=19800 */ 1.20711188390714285745, 0.06615704492794938218 },
{ /*199 f=19900 */ 1.21232386246958934173, 0.06615704492794938218 },
{ /*200 f=20000 */ 1.21752285801744131177, 0.06615704492794938218 },
{ /*201 f=20100 */ 1.22270881487363292095, 0.06615704492794938218 },
{ /*202 f=20200 */ 1.22788167750073284878, 0.06615704492794938218 },
{ /*203 f=20300 */ 1.23304139050153827029, 0.06615704492794938218 },
{ /*204 f=20400 */ 1.23818789861966793708, 0.06615704492794938218 },
{ /*205 f=20500 */ 1.24332114674015481448, 0.06615704492794938218 },
{ /*206 f=20600 */ 1.24844107989003516579, 0.06615704492794938218 },
{ /*207 f=20700 */ 1.25354764323893919098, 0.06615704492794938218 },
{ /*208 f=20800 */ 1.25864078209967500399, 0.06615704492794938218 },
{ /*209 f=20900 */ 1.26372044192881749503, 0.06615704492794938218 },
{ /*210 f=21000 */ 1.26878656832729097559, 0.06615704492794938218 },
{ /*211 f=21100 */ 1.27383910704095182354, 0.06615704492794938218 },
{ /*212 f=21200 */ 1.27887800396116935175, 0.06615704492794938218 },
{ /*213 f=21300 */ 1.28390320512540601072, 0.06615704492794938218 },
{ /*214 f=21400 */ 1.28891465671779492652, 0.06615704492794938218 },
{ /*215 f=21500 */ 1.29391230506971455227, 0.06615704492794938218 },
{ /*216 f=21600 */ 1.29889609666036731639, 0.06615704492794938218 },
{ /*217 f=21700 */ 1.30386597811734850083, 0.06615704492794938218 },
{ /*218 f=21800 */ 1.30882189621722067052, 0.06615704492794938218 },
{ /*219 f=21900 */ 1.31376379788608255161, 0.06615704492794938218 },
{ /*220 f=22000 */ 1.31869163020013768772, 0.06615704492794938218 },
{ /*221 f=22100 */ 1.32360534038626065367, 0.06615704492794938218 },
{ /*222 f=22200 */ 1.32850487582256349128, 0.06615704492794938218 },
{ /*223 f=22300 */ 1.33339018403895726017, 0.06615704492794938218 },
{ /*224 f=22400 */ 1.33826121271771647514, 0.06615704492794938218 },
{ /*225 f=22500 */ 1.34311790969403666018, 0.06615704492794938218 },
{ /*226 f=22600 */ 1.34796022295659567725, 0.06615704492794938218 },
{ /*227 f=22700 */ 1.35278810064810839364, 0.06615704492794938218 },
{ /*228 f=22800 */ 1.35760149106588334789, 0.06615704492794938218 },
{ /*229 f=22900 */ 1.36240034266237652893, 0.06615704492794938218 },
{ /*230 f=23000 */ 1.36718460404574249090, 0.06615704492794938218 },
{ /*231 f=23100 */ 1.37195422398038568979, 0.06615704492794938218 },
{ /*232 f=23200 */ 1.37670915138750782347, 0.06615704492794938218 },
{ /*233 f=23300 */ 1.38144933534565739208, 0.06615704492794938218 },
{ /*234 f=23400 */ 1.38617472509127170888, 0.06615704492794938218 },
{ /*235 f=23500 */ 1.39088527001922335202, 0.06615704492794938218 },
{ /*236 f=23600 */ 1.39558091968336017707, 0.06615704492794938218 },
{ /*237 f=23700 */ 1.40026162379704732786, 0.06615704492794938218 },
{ /*238 f=23800 */ 1.40492733223370347417, 0.06615704492794938218 },
{ /*239 f=23900 */ 1.40957799502734015817, 0.06615704492794938218 },
{ /*240 f=24000 */ 1.41421356237309492343, 0.06615704492794938218 }
};
static FLOAT_T vsf_q100[241][2] = {
{ /* dummy entry */ 0, 0},
{ /*  1 f=  100 */ 0.00654497301305325026, 0.05199250529278276467 },
{ /*  2 f=  200 */ 0.01308987593470371628, 0.05199250529278276467 },
{ /*  3 f=  300 */ 0.01963463867429923390, 0.05199250529278276467 },
{ /*  4 f=  400 */ 0.02617919114268887903, 0.05199250529278276467 },
{ /*  5 f=  500 */ 0.03272346325297356001, 0.05199250529278276467 },
{ /*  6 f=  600 */ 0.03926738492125660118, 0.05199250529278276467 },
{ /*  7 f=  700 */ 0.04581088606739427971, 0.05199250529278276467 },
{ /*  8 f=  800 */ 0.05235389661574629816, 0.05199250529278276467 },
{ /*  9 f=  900 */ 0.05889634649592632304, 0.05199250529278276467 },
{ /* 10 f= 1000 */ 0.06543816564355227350, 0.05199250529278276467 },
{ /* 11 f= 1100 */ 0.07197928400099674884, 0.05199250529278276467 },
{ /* 12 f= 1200 */ 0.07851963151813722008, 0.05199250529278276467 },
{ /* 13 f= 1300 */ 0.08505913815310624237, 0.05199250529278276467 },
{ /* 14 f= 1400 */ 0.09159773387304154246, 0.05199250529278276467 },
{ /* 15 f= 1500 */ 0.09813534865483602987, 0.05199250529278276467 },
{ /* 16 f= 1600 */ 0.10467191248588765540, 0.05199250529278276467 },
{ /* 17 f= 1700 */ 0.11120735536484922801, 0.05199250529278276467 },
{ /* 18 f= 1800 */ 0.11774160730237806516, 0.05199250529278276467 },
{ /* 19 f= 1900 */ 0.12427459832188544886, 0.05199250529278276467 },
{ /* 20 f= 2000 */ 0.13080625846028612336, 0.05199250529278276467 },
{ /* 21 f= 2100 */ 0.13733651776874752914, 0.05199250529278276467 },
{ /* 22 f= 2200 */ 0.14386530631343877329, 0.05199250529278276467 },
{ /* 23 f= 2300 */ 0.15039255417627980793, 0.05199250529278276467 },
{ /* 24 f= 2400 */ 0.15691819145568988714, 0.05199250529278276467 },
{ /* 25 f= 2500 */ 0.16344214826733644008, 0.05199250529278276467 },
{ /* 26 f= 2600 */ 0.16996435474488333361, 0.05199250529278276467 },
{ /* 27 f= 2700 */ 0.17648474104073902380, 0.05199250529278276467 },
{ /* 28 f= 2800 */ 0.18300323732680476296, 0.05199250529278276467 },
{ /* 29 f= 2900 */ 0.18951977379522222389, 0.05199250529278276467 },
{ /* 30 f= 3000 */ 0.19603428065912120726, 0.05199250529278276467 },
{ /* 31 f= 3100 */ 0.20254668815336684951, 0.05199250529278276467 },
{ /* 32 f= 3200 */ 0.20905692653530691394, 0.05199250529278276467 },
{ /* 33 f= 3300 */ 0.21556492608551869328, 0.05199250529278276467 },
{ /* 34 f= 3400 */ 0.22207061710855535708, 0.05199250529278276467 },
{ /* 35 f= 3500 */ 0.22857392993369279877, 0.05199250529278276467 },
{ /* 36 f= 3600 */ 0.23507479491567528918, 0.05199250529278276467 },
{ /* 37 f= 3700 */ 0.24157314243546165744, 0.05199250529278276467 },
{ /* 38 f= 3800 */ 0.24806890290097063922, 0.05199250529278276467 },
{ /* 39 f= 3900 */ 0.25456200674782641924, 0.05199250529278276467 },
{ /* 40 f= 4000 */ 0.26105238444010314680, 0.05199250529278276467 },
{ /* 41 f= 4100 */ 0.26753996647107025630, 0.05199250529278276467 },
{ /* 42 f= 4200 */ 0.27402468336393603909, 0.05199250529278276467 },
{ /* 43 f= 4300 */ 0.28050646567259251984, 0.05199250529278276467 },
{ /* 44 f= 4400 */ 0.28698524398235858435, 0.05199250529278276467 },
{ /* 45 f= 4500 */ 0.29346094891072349586, 0.05199250529278276467 },
{ /* 46 f= 4600 */ 0.29993351110809002291, 0.05199250529278276467 },
{ /* 47 f= 4700 */ 0.30640286125851695642, 0.05199250529278276467 },
{ /* 48 f= 4800 */ 0.31286893008046173792, 0.05199250529278276467 },
{ /* 49 f= 4900 */ 0.31933164832752197748, 0.05199250529278276467 },
{ /* 50 f= 5000 */ 0.32579094678917747130, 0.05199250529278276467 },
{ /* 51 f= 5100 */ 0.33224675629153094247, 0.05199250529278276467 },
{ /* 52 f= 5200 */ 0.33869900769804922591, 0.05199250529278276467 },
{ /* 53 f= 5300 */ 0.34514763191030339851, 0.05199250529278276467 },
{ /* 54 f= 5400 */ 0.35159255986870902033, 0.05199250529278276467 },
{ /* 55 f= 5500 */ 0.35803372255326532114, 0.05199250529278276467 },
{ /* 56 f= 5600 */ 0.36447105098429494197, 0.05199250529278276467 },
{ /* 57 f= 5700 */ 0.37090447622318184484, 0.05199250529278276467 },
{ /* 58 f= 5800 */ 0.37733392937311044379, 0.05199250529278276467 },
{ /* 59 f= 5900 */ 0.38375934157980284844, 0.05199250529278276467 },
{ /* 60 f= 6000 */ 0.39018064403225649617, 0.05199250529278276467 },
{ /* 61 f= 6100 */ 0.39659776796348089611, 0.05199250529278276467 },
{ /* 62 f= 6200 */ 0.40301064465123426217, 0.05199250529278276467 },
{ /* 63 f= 6300 */ 0.40941920541875920225, 0.05199250529278276467 },
{ /* 64 f= 6400 */ 0.41582338163551862964, 0.05199250529278276467 },
{ /* 65 f= 6500 */ 0.42222310471793028652, 0.05199250529278276467 },
{ /* 66 f= 6600 */ 0.42861830613010154511, 0.05199250529278276467 },
{ /* 67 f= 6700 */ 0.43500891738456293201, 0.05199250529278276467 },
{ /* 68 f= 6800 */ 0.44139487004300215212, 0.05199250529278276467 },
{ /* 69 f= 6900 */ 0.44777609571699672486, 0.05199250529278276467 },
{ /* 70 f= 7000 */ 0.45415252606874645380, 0.05199250529278276467 },
{ /* 71 f= 7100 */ 0.46052409281180473055, 0.05199250529278276467 },
{ /* 72 f= 7200 */ 0.46689072771181078236, 0.05199250529278276467 },
{ /* 73 f= 7300 */ 0.47325236258721975480, 0.05199250529278276467 },
{ /* 74 f= 7400 */ 0.47960892931003307194, 0.05199250529278276467 },
{ /* 75 f= 7500 */ 0.48596035980652774189, 0.05199250529278276467 },
{ /* 76 f= 7600 */ 0.49230658605798605088, 0.05199250529278276467 },
{ /* 77 f= 7700 */ 0.49864754010142336993, 0.05199250529278276467 },
{ /* 78 f= 7800 */ 0.50498315403031590609, 0.05199250529278276467 },
{ /* 79 f= 7900 */ 0.51131335999532878667, 0.05199250529278276467 },
{ /* 80 f= 8000 */ 0.51763809020504147895, 0.05199250529278276467 },
{ /* 81 f= 8100 */ 0.52395727692667493081, 0.05199250529278276467 },
{ /* 82 f= 8200 */ 0.53027085248681604668, 0.05199250529278276467 },
{ /* 83 f= 8300 */ 0.53657874927214277427, 0.05199250529278276467 },
{ /* 84 f= 8400 */ 0.54288089973014852507, 0.05199250529278276467 },
{ /* 85 f= 8500 */ 0.54917723636986470748, 0.05199250529278276467 },
{ /* 86 f= 8600 */ 0.55546769176258437017, 0.05199250529278276467 },
{ /* 87 f= 8700 */ 0.56175219854258418017, 0.05199250529278276467 },
{ /* 88 f= 8800 */ 0.56803068940784517959, 0.05199250529278276467 },
{ /* 89 f= 8900 */ 0.57430309712077465267, 0.05199250529278276467 },
{ /* 90 f= 9000 */ 0.58056935450892466211, 0.05199250529278276467 },
{ /* 91 f= 9100 */ 0.58682939446571336095, 0.05199250529278276467 },
{ /* 92 f= 9200 */ 0.59308314995114197465, 0.05199250529278276467 },
{ /* 93 f= 9300 */ 0.59933055399251322637, 0.05199250529278276467 },
{ /* 94 f= 9400 */ 0.60557153968514920717, 0.05199250529278276467 },
{ /* 95 f= 9500 */ 0.61180604019310691477, 0.05199250529278276467 },
{ /* 96 f= 9600 */ 0.61803398874989479150, 0.05199250529278276467 },
{ /* 97 f= 9700 */ 0.62425531865918737484, 0.05199250529278276467 },
{ /* 98 f= 9800 */ 0.63046996329553928184, 0.05199250529278276467 },
{ /* 99 f= 9900 */ 0.63667785610509941563, 0.05199250529278276467 },
{ /*100 f=10000 */ 0.64287893060632317344, 0.05199250529278276467 },
{ /*101 f=10100 */ 0.64907312039068432163, 0.05199250529278276467 },
{ /*102 f=10200 */ 0.65526035912338698175, 0.05199250529278276467 },
{ /*103 f=10300 */ 0.66144058054407484093, 0.05199250529278276467 },
{ /*104 f=10400 */ 0.66761371846754191672, 0.05199250529278276467 },
{ /*105 f=10500 */ 0.67377970678444010222, 0.05199250529278276467 },
{ /*106 f=10600 */ 0.67993847946198837651, 0.05199250529278276467 },
{ /*107 f=10700 */ 0.68608997054467968368, 0.05199250529278276467 },
{ /*108 f=10800 */ 0.69223411415498592447, 0.05199250529278276467 },
{ /*109 f=10900 */ 0.69837084449406572340, 0.05199250529278276467 },
{ /*110 f=11000 */ 0.70450009584246697791, 0.05199250529278276467 },
{ /*111 f=11100 */ 0.71062180256083218310, 0.05199250529278276467 },
{ /*112 f=11200 */ 0.71673589909060053671, 0.05199250529278276467 },
{ /*113 f=11300 */ 0.72284231995471004417, 0.05199250529278276467 },
{ /*114 f=11400 */ 0.72894099975829929061, 0.05199250529278276467 },
{ /*115 f=11500 */ 0.73503187318940710338, 0.05199250529278276467 },
{ /*116 f=11600 */ 0.74111487501967243663, 0.05199250529278276467 },
{ /*117 f=11700 */ 0.74718994010503270164, 0.05199250529278276467 },
{ /*118 f=11800 */ 0.75325700338642143095, 0.05199250529278276467 },
{ /*119 f=11900 */ 0.75931599989046549837, 0.05199250529278276467 },
{ /*120 f=12000 */ 0.76536686473017956356, 0.05199250529278276467 },
{ /*121 f=12100 */ 0.77140953310566262591, 0.05199250529278276467 },
{ /*122 f=12200 */ 0.77744394030479113678, 0.05199250529278276467 },
{ /*123 f=12300 */ 0.78347002170391177867, 0.05199250529278276467 },
{ /*124 f=12400 */ 0.78948771276853446643, 0.05199250529278276467 },
{ /*125 f=12500 */ 0.79549694905402212886, 0.05199250529278276467 },
{ /*126 f=12600 */ 0.80149766620628193348, 0.05199250529278276467 },
{ /*127 f=12700 */ 0.80748979996245418000, 0.05199250529278276467 },
{ /*128 f=12800 */ 0.81347328615160030552, 0.05199250529278276467 },
{ /*129 f=12900 */ 0.81944806069539055660, 0.05199250529278276467 },
{ /*130 f=13000 */ 0.82541405960878933001, 0.05199250529278276467 },
{ /*131 f=13100 */ 0.83137121900074162362, 0.05199250529278276467 },
{ /*132 f=13200 */ 0.83731947507485626758, 0.05199250529278276467 },
{ /*133 f=13300 */ 0.84325876413008904464, 0.05199250529278276467 },
{ /*134 f=13400 */ 0.84918902256142625440, 0.05199250529278276467 },
{ /*135 f=13500 */ 0.85511018686056416982, 0.05199250529278276467 },
{ /*136 f=13600 */ 0.86102219361659015906, 0.05199250529278276467 },
{ /*137 f=13700 */ 0.86692497951666180889, 0.05199250529278276467 },
{ /*138 f=13800 */ 0.87281848134668404970, 0.05199250529278276467 },
{ /*139 f=13900 */ 0.87870263599198739080, 0.05199250529278276467 },
{ /*140 f=14000 */ 0.88457738043800260286, 0.05199250529278276467 },
{ /*141 f=14100 */ 0.89044265177093639974, 0.05199250529278276467 },
{ /*142 f=14200 */ 0.89629838717844512175, 0.05199250529278276467 },
{ /*143 f=14300 */ 0.90214452395030675369, 0.05199250529278276467 },
{ /*144 f=14400 */ 0.90798099947909349794, 0.05199250529278276467 },
{ /*145 f=14500 */ 0.91380775126084123894, 0.05199250529278276467 },
{ /*146 f=14600 */ 0.91962471689571967381, 0.05199250529278276467 },
{ /*147 f=14700 */ 0.92543183408870022255, 0.05199250529278276467 },
{ /*148 f=14800 */ 0.93122904065022282794, 0.05199250529278276467 },
{ /*149 f=14900 */ 0.93701627449686286653, 0.05199250529278276467 },
{ /*150 f=15000 */ 0.94279347365199528408, 0.05199250529278276467 },
{ /*151 f=15100 */ 0.94856057624645839788, 0.05199250529278276467 },
{ /*152 f=15200 */ 0.95431752051921681090, 0.05199250529278276467 },
{ /*153 f=15300 */ 0.96006424481802221660, 0.05199250529278276467 },
{ /*154 f=15400 */ 0.96580068760007475870, 0.05199250529278276467 },
{ /*155 f=15500 */ 0.97152678743268006123, 0.05199250529278276467 },
{ /*156 f=15600 */ 0.97724248299390981121, 0.05199250529278276467 },
{ /*157 f=15700 */ 0.98294771307325645715, 0.05199250529278276467 },
{ /*158 f=15800 */ 0.98864241657228923987, 0.05199250529278276467 },
{ /*159 f=15900 */ 0.99432653250530855793, 0.05199250529278276467 },
{ /*160 f=16000 */ 0.99999999999999988898, 0.05199250529278276467 },
{ /*161 f=16100 */ 1.00566275829808415843, 0.05199250529278276467 },
{ /*162 f=16200 */ 1.01131474675596910728, 0.05199250529278276467 },
{ /*163 f=16300 */ 1.01695590484539954979, 0.05199250529278276467 },
{ /*164 f=16400 */ 1.02258617215410430035, 0.05199250529278276467 },
{ /*165 f=16500 */ 1.02820548838644332257, 0.05199250529278276467 },
{ /*166 f=16600 */ 1.03381379336405498925, 0.05199250529278276467 },
{ /*167 f=16700 */ 1.03941102702649845746, 0.05199250529278276467 },
{ /*168 f=16800 */ 1.04499712943189759784, 0.05199250529278276467 },
{ /*169 f=16900 */ 1.05057204075758403583, 0.05199250529278276467 },
{ /*170 f=17000 */ 1.05613570130073597397, 0.05199250529278276467 },
{ /*171 f=17100 */ 1.06168805147901901265, 0.05199250529278276467 },
{ /*172 f=17200 */ 1.06722903183122297399, 0.05199250529278276467 },
{ /*173 f=17300 */ 1.07275858301790050220, 0.05199250529278276467 },
{ /*174 f=17400 */ 1.07827664582200033472, 0.05199250529278276467 },
{ /*175 f=17500 */ 1.08378316114950346005, 0.05199250529278276467 },
{ /*176 f=17600 */ 1.08927807003005394648, 0.05199250529278276467 },
{ /*177 f=17700 */ 1.09476131361759310145, 0.05199250529278276467 },
{ /*178 f=17800 */ 1.10023283319098674760, 0.05199250529278276467 },
{ /*179 f=17900 */ 1.10569257015465582938, 0.05199250529278276467 },
{ /*180 f=18000 */ 1.11114046603920435530, 0.05199250529278276467 },
{ /*181 f=18100 */ 1.11657646250204400928, 0.05199250529278276467 },
{ /*182 f=18200 */ 1.12200050132801965042, 0.05199250529278276467 },
{ /*183 f=18300 */ 1.12741252443003325823, 0.05199250529278276467 },
{ /*184 f=18400 */ 1.13281247384966565761, 0.05199250529278276467 },
{ /*185 f=18500 */ 1.13820029175779646735, 0.05199250529278276467 },
{ /*186 f=18600 */ 1.14357592045522449276, 0.05199250529278276467 },
{ /*187 f=18700 */ 1.14893930237328523170, 0.05199250529278276467 },
{ /*188 f=18800 */ 1.15429038007446727043, 0.05199250529278276467 },
{ /*189 f=18900 */ 1.15962909625302712513, 0.05199250529278276467 },
{ /*190 f=19000 */ 1.16495539373560430541, 0.05199250529278276467 },
{ /*191 f=19100 */ 1.17026921548183104882, 0.05199250529278276467 },
{ /*192 f=19200 */ 1.17557050458494627421, 0.05199250529278276467 },
{ /*193 f=19300 */ 1.18085920427240220754, 0.05199250529278276467 },
{ /*194 f=19400 */ 1.18613525790647433844, 0.05199250529278276467 },
{ /*195 f=19500 */ 1.19139860898486671381, 0.05199250529278276467 },
{ /*196 f=19600 */ 1.19664920114131789752, 0.05199250529278276467 },
{ /*197 f=19700 */ 1.20188697814620470972, 0.05199250529278276467 },
{ /*198 f=19800 */ 1.20711188390714285745, 0.05199250529278276467 },
{ /*199 f=19900 */ 1.21232386246958934173, 0.05199250529278276467 },
{ /*200 f=20000 */ 1.21752285801744131177, 0.05199250529278276467 },
{ /*201 f=20100 */ 1.22270881487363292095, 0.05199250529278276467 },
{ /*202 f=20200 */ 1.22788167750073284878, 0.05199250529278276467 },
{ /*203 f=20300 */ 1.23304139050153827029, 0.05199250529278276467 },
{ /*204 f=20400 */ 1.23818789861966793708, 0.05199250529278276467 },
{ /*205 f=20500 */ 1.24332114674015481448, 0.05199250529278276467 },
{ /*206 f=20600 */ 1.24844107989003516579, 0.05199250529278276467 },
{ /*207 f=20700 */ 1.25354764323893919098, 0.05199250529278276467 },
{ /*208 f=20800 */ 1.25864078209967500399, 0.05199250529278276467 },
{ /*209 f=20900 */ 1.26372044192881749503, 0.05199250529278276467 },
{ /*210 f=21000 */ 1.26878656832729097559, 0.05199250529278276467 },
{ /*211 f=21100 */ 1.27383910704095182354, 0.05199250529278276467 },
{ /*212 f=21200 */ 1.27887800396116935175, 0.05199250529278276467 },
{ /*213 f=21300 */ 1.28390320512540601072, 0.05199250529278276467 },
{ /*214 f=21400 */ 1.28891465671779492652, 0.05199250529278276467 },
{ /*215 f=21500 */ 1.29391230506971455227, 0.05199250529278276467 },
{ /*216 f=21600 */ 1.29889609666036731639, 0.05199250529278276467 },
{ /*217 f=21700 */ 1.30386597811734850083, 0.05199250529278276467 },
{ /*218 f=21800 */ 1.30882189621722067052, 0.05199250529278276467 },
{ /*219 f=21900 */ 1.31376379788608255161, 0.05199250529278276467 },
{ /*220 f=22000 */ 1.31869163020013768772, 0.05199250529278276467 },
{ /*221 f=22100 */ 1.32360534038626065367, 0.05199250529278276467 },
{ /*222 f=22200 */ 1.32850487582256349128, 0.05199250529278276467 },
{ /*223 f=22300 */ 1.33339018403895726017, 0.05199250529278276467 },
{ /*224 f=22400 */ 1.33826121271771647514, 0.05199250529278276467 },
{ /*225 f=22500 */ 1.34311790969403666018, 0.05199250529278276467 },
{ /*226 f=22600 */ 1.34796022295659567725, 0.05199250529278276467 },
{ /*227 f=22700 */ 1.35278810064810839364, 0.05199250529278276467 },
{ /*228 f=22800 */ 1.35760149106588334789, 0.05199250529278276467 },
{ /*229 f=22900 */ 1.36240034266237652893, 0.05199250529278276467 },
{ /*230 f=23000 */ 1.36718460404574249090, 0.05199250529278276467 },
{ /*231 f=23100 */ 1.37195422398038568979, 0.05199250529278276467 },
{ /*232 f=23200 */ 1.37670915138750782347, 0.05199250529278276467 },
{ /*233 f=23300 */ 1.38144933534565739208, 0.05199250529278276467 },
{ /*234 f=23400 */ 1.38617472509127170888, 0.05199250529278276467 },
{ /*235 f=23500 */ 1.39088527001922335202, 0.05199250529278276467 },
{ /*236 f=23600 */ 1.39558091968336017707, 0.05199250529278276467 },
{ /*237 f=23700 */ 1.40026162379704732786, 0.05199250529278276467 },
{ /*238 f=23800 */ 1.40492733223370347417, 0.05199250529278276467 },
{ /*239 f=23900 */ 1.40957799502734015817, 0.05199250529278276467 },
{ /*240 f=24000 */ 1.41421356237309492343, 0.05199250529278276467 }
};
static FLOAT_T vsf_q110[241][2] = {
{ /* dummy entry */ 0, 0},
{ /*  1 f=  100 */ 0.00654497301305325026, 0.04095745643573378558 },
{ /*  2 f=  200 */ 0.01308987593470371628, 0.04095745643573378558 },
{ /*  3 f=  300 */ 0.01963463867429923390, 0.04095745643573378558 },
{ /*  4 f=  400 */ 0.02617919114268887903, 0.04095745643573378558 },
{ /*  5 f=  500 */ 0.03272346325297356001, 0.04095745643573378558 },
{ /*  6 f=  600 */ 0.03926738492125660118, 0.04095745643573378558 },
{ /*  7 f=  700 */ 0.04581088606739427971, 0.04095745643573378558 },
{ /*  8 f=  800 */ 0.05235389661574629816, 0.04095745643573378558 },
{ /*  9 f=  900 */ 0.05889634649592632304, 0.04095745643573378558 },
{ /* 10 f= 1000 */ 0.06543816564355227350, 0.04095745643573378558 },
{ /* 11 f= 1100 */ 0.07197928400099674884, 0.04095745643573378558 },
{ /* 12 f= 1200 */ 0.07851963151813722008, 0.04095745643573378558 },
{ /* 13 f= 1300 */ 0.08505913815310624237, 0.04095745643573378558 },
{ /* 14 f= 1400 */ 0.09159773387304154246, 0.04095745643573378558 },
{ /* 15 f= 1500 */ 0.09813534865483602987, 0.04095745643573378558 },
{ /* 16 f= 1600 */ 0.10467191248588765540, 0.04095745643573378558 },
{ /* 17 f= 1700 */ 0.11120735536484922801, 0.04095745643573378558 },
{ /* 18 f= 1800 */ 0.11774160730237806516, 0.04095745643573378558 },
{ /* 19 f= 1900 */ 0.12427459832188544886, 0.04095745643573378558 },
{ /* 20 f= 2000 */ 0.13080625846028612336, 0.04095745643573378558 },
{ /* 21 f= 2100 */ 0.13733651776874752914, 0.04095745643573378558 },
{ /* 22 f= 2200 */ 0.14386530631343877329, 0.04095745643573378558 },
{ /* 23 f= 2300 */ 0.15039255417627980793, 0.04095745643573378558 },
{ /* 24 f= 2400 */ 0.15691819145568988714, 0.04095745643573378558 },
{ /* 25 f= 2500 */ 0.16344214826733644008, 0.04095745643573378558 },
{ /* 26 f= 2600 */ 0.16996435474488333361, 0.04095745643573378558 },
{ /* 27 f= 2700 */ 0.17648474104073902380, 0.04095745643573378558 },
{ /* 28 f= 2800 */ 0.18300323732680476296, 0.04095745643573378558 },
{ /* 29 f= 2900 */ 0.18951977379522222389, 0.04095745643573378558 },
{ /* 30 f= 3000 */ 0.19603428065912120726, 0.04095745643573378558 },
{ /* 31 f= 3100 */ 0.20254668815336684951, 0.04095745643573378558 },
{ /* 32 f= 3200 */ 0.20905692653530691394, 0.04095745643573378558 },
{ /* 33 f= 3300 */ 0.21556492608551869328, 0.04095745643573378558 },
{ /* 34 f= 3400 */ 0.22207061710855535708, 0.04095745643573378558 },
{ /* 35 f= 3500 */ 0.22857392993369279877, 0.04095745643573378558 },
{ /* 36 f= 3600 */ 0.23507479491567528918, 0.04095745643573378558 },
{ /* 37 f= 3700 */ 0.24157314243546165744, 0.04095745643573378558 },
{ /* 38 f= 3800 */ 0.24806890290097063922, 0.04095745643573378558 },
{ /* 39 f= 3900 */ 0.25456200674782641924, 0.04095745643573378558 },
{ /* 40 f= 4000 */ 0.26105238444010314680, 0.04095745643573378558 },
{ /* 41 f= 4100 */ 0.26753996647107025630, 0.04095745643573378558 },
{ /* 42 f= 4200 */ 0.27402468336393603909, 0.04095745643573378558 },
{ /* 43 f= 4300 */ 0.28050646567259251984, 0.04095745643573378558 },
{ /* 44 f= 4400 */ 0.28698524398235858435, 0.04095745643573378558 },
{ /* 45 f= 4500 */ 0.29346094891072349586, 0.04095745643573378558 },
{ /* 46 f= 4600 */ 0.29993351110809002291, 0.04095745643573378558 },
{ /* 47 f= 4700 */ 0.30640286125851695642, 0.04095745643573378558 },
{ /* 48 f= 4800 */ 0.31286893008046173792, 0.04095745643573378558 },
{ /* 49 f= 4900 */ 0.31933164832752197748, 0.04095745643573378558 },
{ /* 50 f= 5000 */ 0.32579094678917747130, 0.04095745643573378558 },
{ /* 51 f= 5100 */ 0.33224675629153094247, 0.04095745643573378558 },
{ /* 52 f= 5200 */ 0.33869900769804922591, 0.04095745643573378558 },
{ /* 53 f= 5300 */ 0.34514763191030339851, 0.04095745643573378558 },
{ /* 54 f= 5400 */ 0.35159255986870902033, 0.04095745643573378558 },
{ /* 55 f= 5500 */ 0.35803372255326532114, 0.04095745643573378558 },
{ /* 56 f= 5600 */ 0.36447105098429494197, 0.04095745643573378558 },
{ /* 57 f= 5700 */ 0.37090447622318184484, 0.04095745643573378558 },
{ /* 58 f= 5800 */ 0.37733392937311044379, 0.04095745643573378558 },
{ /* 59 f= 5900 */ 0.38375934157980284844, 0.04095745643573378558 },
{ /* 60 f= 6000 */ 0.39018064403225649617, 0.04095745643573378558 },
{ /* 61 f= 6100 */ 0.39659776796348089611, 0.04095745643573378558 },
{ /* 62 f= 6200 */ 0.40301064465123426217, 0.04095745643573378558 },
{ /* 63 f= 6300 */ 0.40941920541875920225, 0.04095745643573378558 },
{ /* 64 f= 6400 */ 0.41582338163551862964, 0.04095745643573378558 },
{ /* 65 f= 6500 */ 0.42222310471793028652, 0.04095745643573378558 },
{ /* 66 f= 6600 */ 0.42861830613010154511, 0.04095745643573378558 },
{ /* 67 f= 6700 */ 0.43500891738456293201, 0.04095745643573378558 },
{ /* 68 f= 6800 */ 0.44139487004300215212, 0.04095745643573378558 },
{ /* 69 f= 6900 */ 0.44777609571699672486, 0.04095745643573378558 },
{ /* 70 f= 7000 */ 0.45415252606874645380, 0.04095745643573378558 },
{ /* 71 f= 7100 */ 0.46052409281180473055, 0.04095745643573378558 },
{ /* 72 f= 7200 */ 0.46689072771181078236, 0.04095745643573378558 },
{ /* 73 f= 7300 */ 0.47325236258721975480, 0.04095745643573378558 },
{ /* 74 f= 7400 */ 0.47960892931003307194, 0.04095745643573378558 },
{ /* 75 f= 7500 */ 0.48596035980652774189, 0.04095745643573378558 },
{ /* 76 f= 7600 */ 0.49230658605798605088, 0.04095745643573378558 },
{ /* 77 f= 7700 */ 0.49864754010142336993, 0.04095745643573378558 },
{ /* 78 f= 7800 */ 0.50498315403031590609, 0.04095745643573378558 },
{ /* 79 f= 7900 */ 0.51131335999532878667, 0.04095745643573378558 },
{ /* 80 f= 8000 */ 0.51763809020504147895, 0.04095745643573378558 },
{ /* 81 f= 8100 */ 0.52395727692667493081, 0.04095745643573378558 },
{ /* 82 f= 8200 */ 0.53027085248681604668, 0.04095745643573378558 },
{ /* 83 f= 8300 */ 0.53657874927214277427, 0.04095745643573378558 },
{ /* 84 f= 8400 */ 0.54288089973014852507, 0.04095745643573378558 },
{ /* 85 f= 8500 */ 0.54917723636986470748, 0.04095745643573378558 },
{ /* 86 f= 8600 */ 0.55546769176258437017, 0.04095745643573378558 },
{ /* 87 f= 8700 */ 0.56175219854258418017, 0.04095745643573378558 },
{ /* 88 f= 8800 */ 0.56803068940784517959, 0.04095745643573378558 },
{ /* 89 f= 8900 */ 0.57430309712077465267, 0.04095745643573378558 },
{ /* 90 f= 9000 */ 0.58056935450892466211, 0.04095745643573378558 },
{ /* 91 f= 9100 */ 0.58682939446571336095, 0.04095745643573378558 },
{ /* 92 f= 9200 */ 0.59308314995114197465, 0.04095745643573378558 },
{ /* 93 f= 9300 */ 0.59933055399251322637, 0.04095745643573378558 },
{ /* 94 f= 9400 */ 0.60557153968514920717, 0.04095745643573378558 },
{ /* 95 f= 9500 */ 0.61180604019310691477, 0.04095745643573378558 },
{ /* 96 f= 9600 */ 0.61803398874989479150, 0.04095745643573378558 },
{ /* 97 f= 9700 */ 0.62425531865918737484, 0.04095745643573378558 },
{ /* 98 f= 9800 */ 0.63046996329553928184, 0.04095745643573378558 },
{ /* 99 f= 9900 */ 0.63667785610509941563, 0.04095745643573378558 },
{ /*100 f=10000 */ 0.64287893060632317344, 0.04095745643573378558 },
{ /*101 f=10100 */ 0.64907312039068432163, 0.04095745643573378558 },
{ /*102 f=10200 */ 0.65526035912338698175, 0.04095745643573378558 },
{ /*103 f=10300 */ 0.66144058054407484093, 0.04095745643573378558 },
{ /*104 f=10400 */ 0.66761371846754191672, 0.04095745643573378558 },
{ /*105 f=10500 */ 0.67377970678444010222, 0.04095745643573378558 },
{ /*106 f=10600 */ 0.67993847946198837651, 0.04095745643573378558 },
{ /*107 f=10700 */ 0.68608997054467968368, 0.04095745643573378558 },
{ /*108 f=10800 */ 0.69223411415498592447, 0.04095745643573378558 },
{ /*109 f=10900 */ 0.69837084449406572340, 0.04095745643573378558 },
{ /*110 f=11000 */ 0.70450009584246697791, 0.04095745643573378558 },
{ /*111 f=11100 */ 0.71062180256083218310, 0.04095745643573378558 },
{ /*112 f=11200 */ 0.71673589909060053671, 0.04095745643573378558 },
{ /*113 f=11300 */ 0.72284231995471004417, 0.04095745643573378558 },
{ /*114 f=11400 */ 0.72894099975829929061, 0.04095745643573378558 },
{ /*115 f=11500 */ 0.73503187318940710338, 0.04095745643573378558 },
{ /*116 f=11600 */ 0.74111487501967243663, 0.04095745643573378558 },
{ /*117 f=11700 */ 0.74718994010503270164, 0.04095745643573378558 },
{ /*118 f=11800 */ 0.75325700338642143095, 0.04095745643573378558 },
{ /*119 f=11900 */ 0.75931599989046549837, 0.04095745643573378558 },
{ /*120 f=12000 */ 0.76536686473017956356, 0.04095745643573378558 },
{ /*121 f=12100 */ 0.77140953310566262591, 0.04095745643573378558 },
{ /*122 f=12200 */ 0.77744394030479113678, 0.04095745643573378558 },
{ /*123 f=12300 */ 0.78347002170391177867, 0.04095745643573378558 },
{ /*124 f=12400 */ 0.78948771276853446643, 0.04095745643573378558 },
{ /*125 f=12500 */ 0.79549694905402212886, 0.04095745643573378558 },
{ /*126 f=12600 */ 0.80149766620628193348, 0.04095745643573378558 },
{ /*127 f=12700 */ 0.80748979996245418000, 0.04095745643573378558 },
{ /*128 f=12800 */ 0.81347328615160030552, 0.04095745643573378558 },
{ /*129 f=12900 */ 0.81944806069539055660, 0.04095745643573378558 },
{ /*130 f=13000 */ 0.82541405960878933001, 0.04095745643573378558 },
{ /*131 f=13100 */ 0.83137121900074162362, 0.04095745643573378558 },
{ /*132 f=13200 */ 0.83731947507485626758, 0.04095745643573378558 },
{ /*133 f=13300 */ 0.84325876413008904464, 0.04095745643573378558 },
{ /*134 f=13400 */ 0.84918902256142625440, 0.04095745643573378558 },
{ /*135 f=13500 */ 0.85511018686056416982, 0.04095745643573378558 },
{ /*136 f=13600 */ 0.86102219361659015906, 0.04095745643573378558 },
{ /*137 f=13700 */ 0.86692497951666180889, 0.04095745643573378558 },
{ /*138 f=13800 */ 0.87281848134668404970, 0.04095745643573378558 },
{ /*139 f=13900 */ 0.87870263599198739080, 0.04095745643573378558 },
{ /*140 f=14000 */ 0.88457738043800260286, 0.04095745643573378558 },
{ /*141 f=14100 */ 0.89044265177093639974, 0.04095745643573378558 },
{ /*142 f=14200 */ 0.89629838717844512175, 0.04095745643573378558 },
{ /*143 f=14300 */ 0.90214452395030675369, 0.04095745643573378558 },
{ /*144 f=14400 */ 0.90798099947909349794, 0.04095745643573378558 },
{ /*145 f=14500 */ 0.91380775126084123894, 0.04095745643573378558 },
{ /*146 f=14600 */ 0.91962471689571967381, 0.04095745643573378558 },
{ /*147 f=14700 */ 0.92543183408870022255, 0.04095745643573378558 },
{ /*148 f=14800 */ 0.93122904065022282794, 0.04095745643573378558 },
{ /*149 f=14900 */ 0.93701627449686286653, 0.04095745643573378558 },
{ /*150 f=15000 */ 0.94279347365199528408, 0.04095745643573378558 },
{ /*151 f=15100 */ 0.94856057624645839788, 0.04095745643573378558 },
{ /*152 f=15200 */ 0.95431752051921681090, 0.04095745643573378558 },
{ /*153 f=15300 */ 0.96006424481802221660, 0.04095745643573378558 },
{ /*154 f=15400 */ 0.96580068760007475870, 0.04095745643573378558 },
{ /*155 f=15500 */ 0.97152678743268006123, 0.04095745643573378558 },
{ /*156 f=15600 */ 0.97724248299390981121, 0.04095745643573378558 },
{ /*157 f=15700 */ 0.98294771307325645715, 0.04095745643573378558 },
{ /*158 f=15800 */ 0.98864241657228923987, 0.04095745643573378558 },
{ /*159 f=15900 */ 0.99432653250530855793, 0.04095745643573378558 },
{ /*160 f=16000 */ 0.99999999999999988898, 0.04095745643573378558 },
{ /*161 f=16100 */ 1.00566275829808415843, 0.04095745643573378558 },
{ /*162 f=16200 */ 1.01131474675596910728, 0.04095745643573378558 },
{ /*163 f=16300 */ 1.01695590484539954979, 0.04095745643573378558 },
{ /*164 f=16400 */ 1.02258617215410430035, 0.04095745643573378558 },
{ /*165 f=16500 */ 1.02820548838644332257, 0.04095745643573378558 },
{ /*166 f=16600 */ 1.03381379336405498925, 0.04095745643573378558 },
{ /*167 f=16700 */ 1.03941102702649845746, 0.04095745643573378558 },
{ /*168 f=16800 */ 1.04499712943189759784, 0.04095745643573378558 },
{ /*169 f=16900 */ 1.05057204075758403583, 0.04095745643573378558 },
{ /*170 f=17000 */ 1.05613570130073597397, 0.04095745643573378558 },
{ /*171 f=17100 */ 1.06168805147901901265, 0.04095745643573378558 },
{ /*172 f=17200 */ 1.06722903183122297399, 0.04095745643573378558 },
{ /*173 f=17300 */ 1.07275858301790050220, 0.04095745643573378558 },
{ /*174 f=17400 */ 1.07827664582200033472, 0.04095745643573378558 },
{ /*175 f=17500 */ 1.08378316114950346005, 0.04095745643573378558 },
{ /*176 f=17600 */ 1.08927807003005394648, 0.04095745643573378558 },
{ /*177 f=17700 */ 1.09476131361759310145, 0.04095745643573378558 },
{ /*178 f=17800 */ 1.10023283319098674760, 0.04095745643573378558 },
{ /*179 f=17900 */ 1.10569257015465582938, 0.04095745643573378558 },
{ /*180 f=18000 */ 1.11114046603920435530, 0.04095745643573378558 },
{ /*181 f=18100 */ 1.11657646250204400928, 0.04095745643573378558 },
{ /*182 f=18200 */ 1.12200050132801965042, 0.04095745643573378558 },
{ /*183 f=18300 */ 1.12741252443003325823, 0.04095745643573378558 },
{ /*184 f=18400 */ 1.13281247384966565761, 0.04095745643573378558 },
{ /*185 f=18500 */ 1.13820029175779646735, 0.04095745643573378558 },
{ /*186 f=18600 */ 1.14357592045522449276, 0.04095745643573378558 },
{ /*187 f=18700 */ 1.14893930237328523170, 0.04095745643573378558 },
{ /*188 f=18800 */ 1.15429038007446727043, 0.04095745643573378558 },
{ /*189 f=18900 */ 1.15962909625302712513, 0.04095745643573378558 },
{ /*190 f=19000 */ 1.16495539373560430541, 0.04095745643573378558 },
{ /*191 f=19100 */ 1.17026921548183104882, 0.04095745643573378558 },
{ /*192 f=19200 */ 1.17557050458494627421, 0.04095745643573378558 },
{ /*193 f=19300 */ 1.18085920427240220754, 0.04095745643573378558 },
{ /*194 f=19400 */ 1.18613525790647433844, 0.04095745643573378558 },
{ /*195 f=19500 */ 1.19139860898486671381, 0.04095745643573378558 },
{ /*196 f=19600 */ 1.19664920114131789752, 0.04095745643573378558 },
{ /*197 f=19700 */ 1.20188697814620470972, 0.04095745643573378558 },
{ /*198 f=19800 */ 1.20711188390714285745, 0.04095745643573378558 },
{ /*199 f=19900 */ 1.21232386246958934173, 0.04095745643573378558 },
{ /*200 f=20000 */ 1.21752285801744131177, 0.04095745643573378558 },
{ /*201 f=20100 */ 1.22270881487363292095, 0.04095745643573378558 },
{ /*202 f=20200 */ 1.22788167750073284878, 0.04095745643573378558 },
{ /*203 f=20300 */ 1.23304139050153827029, 0.04095745643573378558 },
{ /*204 f=20400 */ 1.23818789861966793708, 0.04095745643573378558 },
{ /*205 f=20500 */ 1.24332114674015481448, 0.04095745643573378558 },
{ /*206 f=20600 */ 1.24844107989003516579, 0.04095745643573378558 },
{ /*207 f=20700 */ 1.25354764323893919098, 0.04095745643573378558 },
{ /*208 f=20800 */ 1.25864078209967500399, 0.04095745643573378558 },
{ /*209 f=20900 */ 1.26372044192881749503, 0.04095745643573378558 },
{ /*210 f=21000 */ 1.26878656832729097559, 0.04095745643573378558 },
{ /*211 f=21100 */ 1.27383910704095182354, 0.04095745643573378558 },
{ /*212 f=21200 */ 1.27887800396116935175, 0.04095745643573378558 },
{ /*213 f=21300 */ 1.28390320512540601072, 0.04095745643573378558 },
{ /*214 f=21400 */ 1.28891465671779492652, 0.04095745643573378558 },
{ /*215 f=21500 */ 1.29391230506971455227, 0.04095745643573378558 },
{ /*216 f=21600 */ 1.29889609666036731639, 0.04095745643573378558 },
{ /*217 f=21700 */ 1.30386597811734850083, 0.04095745643573378558 },
{ /*218 f=21800 */ 1.30882189621722067052, 0.04095745643573378558 },
{ /*219 f=21900 */ 1.31376379788608255161, 0.04095745643573378558 },
{ /*220 f=22000 */ 1.31869163020013768772, 0.04095745643573378558 },
{ /*221 f=22100 */ 1.32360534038626065367, 0.04095745643573378558 },
{ /*222 f=22200 */ 1.32850487582256349128, 0.04095745643573378558 },
{ /*223 f=22300 */ 1.33339018403895726017, 0.04095745643573378558 },
{ /*224 f=22400 */ 1.33826121271771647514, 0.04095745643573378558 },
{ /*225 f=22500 */ 1.34311790969403666018, 0.04095745643573378558 },
{ /*226 f=22600 */ 1.34796022295659567725, 0.04095745643573378558 },
{ /*227 f=22700 */ 1.35278810064810839364, 0.04095745643573378558 },
{ /*228 f=22800 */ 1.35760149106588334789, 0.04095745643573378558 },
{ /*229 f=22900 */ 1.36240034266237652893, 0.04095745643573378558 },
{ /*230 f=23000 */ 1.36718460404574249090, 0.04095745643573378558 },
{ /*231 f=23100 */ 1.37195422398038568979, 0.04095745643573378558 },
{ /*232 f=23200 */ 1.37670915138750782347, 0.04095745643573378558 },
{ /*233 f=23300 */ 1.38144933534565739208, 0.04095745643573378558 },
{ /*234 f=23400 */ 1.38617472509127170888, 0.04095745643573378558 },
{ /*235 f=23500 */ 1.39088527001922335202, 0.04095745643573378558 },
{ /*236 f=23600 */ 1.39558091968336017707, 0.04095745643573378558 },
{ /*237 f=23700 */ 1.40026162379704732786, 0.04095745643573378558 },
{ /*238 f=23800 */ 1.40492733223370347417, 0.04095745643573378558 },
{ /*239 f=23900 */ 1.40957799502734015817, 0.04095745643573378558 },
{ /*240 f=24000 */ 1.41421356237309492343, 0.04095745643573378558 }
};
static FLOAT_T vsf_q120[241][2] = {
{ /* dummy entry */ 0, 0},
{ /*  1 f=  100 */ 0.00654497301305325026, 0.03232304169578403830 },
{ /*  2 f=  200 */ 0.01308987593470371628, 0.03232304169578403830 },
{ /*  3 f=  300 */ 0.01963463867429923390, 0.03232304169578403830 },
{ /*  4 f=  400 */ 0.02617919114268887903, 0.03232304169578403830 },
{ /*  5 f=  500 */ 0.03272346325297356001, 0.03232304169578403830 },
{ /*  6 f=  600 */ 0.03926738492125660118, 0.03232304169578403830 },
{ /*  7 f=  700 */ 0.04581088606739427971, 0.03232304169578403830 },
{ /*  8 f=  800 */ 0.05235389661574629816, 0.03232304169578403830 },
{ /*  9 f=  900 */ 0.05889634649592632304, 0.03232304169578403830 },
{ /* 10 f= 1000 */ 0.06543816564355227350, 0.03232304169578403830 },
{ /* 11 f= 1100 */ 0.07197928400099674884, 0.03232304169578403830 },
{ /* 12 f= 1200 */ 0.07851963151813722008, 0.03232304169578403830 },
{ /* 13 f= 1300 */ 0.08505913815310624237, 0.03232304169578403830 },
{ /* 14 f= 1400 */ 0.09159773387304154246, 0.03232304169578403830 },
{ /* 15 f= 1500 */ 0.09813534865483602987, 0.03232304169578403830 },
{ /* 16 f= 1600 */ 0.10467191248588765540, 0.03232304169578403830 },
{ /* 17 f= 1700 */ 0.11120735536484922801, 0.03232304169578403830 },
{ /* 18 f= 1800 */ 0.11774160730237806516, 0.03232304169578403830 },
{ /* 19 f= 1900 */ 0.12427459832188544886, 0.03232304169578403830 },
{ /* 20 f= 2000 */ 0.13080625846028612336, 0.03232304169578403830 },
{ /* 21 f= 2100 */ 0.13733651776874752914, 0.03232304169578403830 },
{ /* 22 f= 2200 */ 0.14386530631343877329, 0.03232304169578403830 },
{ /* 23 f= 2300 */ 0.15039255417627980793, 0.03232304169578403830 },
{ /* 24 f= 2400 */ 0.15691819145568988714, 0.03232304169578403830 },
{ /* 25 f= 2500 */ 0.16344214826733644008, 0.03232304169578403830 },
{ /* 26 f= 2600 */ 0.16996435474488333361, 0.03232304169578403830 },
{ /* 27 f= 2700 */ 0.17648474104073902380, 0.03232304169578403830 },
{ /* 28 f= 2800 */ 0.18300323732680476296, 0.03232304169578403830 },
{ /* 29 f= 2900 */ 0.18951977379522222389, 0.03232304169578403830 },
{ /* 30 f= 3000 */ 0.19603428065912120726, 0.03232304169578403830 },
{ /* 31 f= 3100 */ 0.20254668815336684951, 0.03232304169578403830 },
{ /* 32 f= 3200 */ 0.20905692653530691394, 0.03232304169578403830 },
{ /* 33 f= 3300 */ 0.21556492608551869328, 0.03232304169578403830 },
{ /* 34 f= 3400 */ 0.22207061710855535708, 0.03232304169578403830 },
{ /* 35 f= 3500 */ 0.22857392993369279877, 0.03232304169578403830 },
{ /* 36 f= 3600 */ 0.23507479491567528918, 0.03232304169578403830 },
{ /* 37 f= 3700 */ 0.24157314243546165744, 0.03232304169578403830 },
{ /* 38 f= 3800 */ 0.24806890290097063922, 0.03232304169578403830 },
{ /* 39 f= 3900 */ 0.25456200674782641924, 0.03232304169578403830 },
{ /* 40 f= 4000 */ 0.26105238444010314680, 0.03232304169578403830 },
{ /* 41 f= 4100 */ 0.26753996647107025630, 0.03232304169578403830 },
{ /* 42 f= 4200 */ 0.27402468336393603909, 0.03232304169578403830 },
{ /* 43 f= 4300 */ 0.28050646567259251984, 0.03232304169578403830 },
{ /* 44 f= 4400 */ 0.28698524398235858435, 0.03232304169578403830 },
{ /* 45 f= 4500 */ 0.29346094891072349586, 0.03232304169578403830 },
{ /* 46 f= 4600 */ 0.29993351110809002291, 0.03232304169578403830 },
{ /* 47 f= 4700 */ 0.30640286125851695642, 0.03232304169578403830 },
{ /* 48 f= 4800 */ 0.31286893008046173792, 0.03232304169578403830 },
{ /* 49 f= 4900 */ 0.31933164832752197748, 0.03232304169578403830 },
{ /* 50 f= 5000 */ 0.32579094678917747130, 0.03232304169578403830 },
{ /* 51 f= 5100 */ 0.33224675629153094247, 0.03232304169578403830 },
{ /* 52 f= 5200 */ 0.33869900769804922591, 0.03232304169578403830 },
{ /* 53 f= 5300 */ 0.34514763191030339851, 0.03232304169578403830 },
{ /* 54 f= 5400 */ 0.35159255986870902033, 0.03232304169578403830 },
{ /* 55 f= 5500 */ 0.35803372255326532114, 0.03232304169578403830 },
{ /* 56 f= 5600 */ 0.36447105098429494197, 0.03232304169578403830 },
{ /* 57 f= 5700 */ 0.37090447622318184484, 0.03232304169578403830 },
{ /* 58 f= 5800 */ 0.37733392937311044379, 0.03232304169578403830 },
{ /* 59 f= 5900 */ 0.38375934157980284844, 0.03232304169578403830 },
{ /* 60 f= 6000 */ 0.39018064403225649617, 0.03232304169578403830 },
{ /* 61 f= 6100 */ 0.39659776796348089611, 0.03232304169578403830 },
{ /* 62 f= 6200 */ 0.40301064465123426217, 0.03232304169578403830 },
{ /* 63 f= 6300 */ 0.40941920541875920225, 0.03232304169578403830 },
{ /* 64 f= 6400 */ 0.41582338163551862964, 0.03232304169578403830 },
{ /* 65 f= 6500 */ 0.42222310471793028652, 0.03232304169578403830 },
{ /* 66 f= 6600 */ 0.42861830613010154511, 0.03232304169578403830 },
{ /* 67 f= 6700 */ 0.43500891738456293201, 0.03232304169578403830 },
{ /* 68 f= 6800 */ 0.44139487004300215212, 0.03232304169578403830 },
{ /* 69 f= 6900 */ 0.44777609571699672486, 0.03232304169578403830 },
{ /* 70 f= 7000 */ 0.45415252606874645380, 0.03232304169578403830 },
{ /* 71 f= 7100 */ 0.46052409281180473055, 0.03232304169578403830 },
{ /* 72 f= 7200 */ 0.46689072771181078236, 0.03232304169578403830 },
{ /* 73 f= 7300 */ 0.47325236258721975480, 0.03232304169578403830 },
{ /* 74 f= 7400 */ 0.47960892931003307194, 0.03232304169578403830 },
{ /* 75 f= 7500 */ 0.48596035980652774189, 0.03232304169578403830 },
{ /* 76 f= 7600 */ 0.49230658605798605088, 0.03232304169578403830 },
{ /* 77 f= 7700 */ 0.49864754010142336993, 0.03232304169578403830 },
{ /* 78 f= 7800 */ 0.50498315403031590609, 0.03232304169578403830 },
{ /* 79 f= 7900 */ 0.51131335999532878667, 0.03232304169578403830 },
{ /* 80 f= 8000 */ 0.51763809020504147895, 0.03232304169578403830 },
{ /* 81 f= 8100 */ 0.52395727692667493081, 0.03232304169578403830 },
{ /* 82 f= 8200 */ 0.53027085248681604668, 0.03232304169578403830 },
{ /* 83 f= 8300 */ 0.53657874927214277427, 0.03232304169578403830 },
{ /* 84 f= 8400 */ 0.54288089973014852507, 0.03232304169578403830 },
{ /* 85 f= 8500 */ 0.54917723636986470748, 0.03232304169578403830 },
{ /* 86 f= 8600 */ 0.55546769176258437017, 0.03232304169578403830 },
{ /* 87 f= 8700 */ 0.56175219854258418017, 0.03232304169578403830 },
{ /* 88 f= 8800 */ 0.56803068940784517959, 0.03232304169578403830 },
{ /* 89 f= 8900 */ 0.57430309712077465267, 0.03232304169578403830 },
{ /* 90 f= 9000 */ 0.58056935450892466211, 0.03232304169578403830 },
{ /* 91 f= 9100 */ 0.58682939446571336095, 0.03232304169578403830 },
{ /* 92 f= 9200 */ 0.59308314995114197465, 0.03232304169578403830 },
{ /* 93 f= 9300 */ 0.59933055399251322637, 0.03232304169578403830 },
{ /* 94 f= 9400 */ 0.60557153968514920717, 0.03232304169578403830 },
{ /* 95 f= 9500 */ 0.61180604019310691477, 0.03232304169578403830 },
{ /* 96 f= 9600 */ 0.61803398874989479150, 0.03232304169578403830 },
{ /* 97 f= 9700 */ 0.62425531865918737484, 0.03232304169578403830 },
{ /* 98 f= 9800 */ 0.63046996329553928184, 0.03232304169578403830 },
{ /* 99 f= 9900 */ 0.63667785610509941563, 0.03232304169578403830 },
{ /*100 f=10000 */ 0.64287893060632317344, 0.03232304169578403830 },
{ /*101 f=10100 */ 0.64907312039068432163, 0.03232304169578403830 },
{ /*102 f=10200 */ 0.65526035912338698175, 0.03232304169578403830 },
{ /*103 f=10300 */ 0.66144058054407484093, 0.03232304169578403830 },
{ /*104 f=10400 */ 0.66761371846754191672, 0.03232304169578403830 },
{ /*105 f=10500 */ 0.67377970678444010222, 0.03232304169578403830 },
{ /*106 f=10600 */ 0.67993847946198837651, 0.03232304169578403830 },
{ /*107 f=10700 */ 0.68608997054467968368, 0.03232304169578403830 },
{ /*108 f=10800 */ 0.69223411415498592447, 0.03232304169578403830 },
{ /*109 f=10900 */ 0.69837084449406572340, 0.03232304169578403830 },
{ /*110 f=11000 */ 0.70450009584246697791, 0.03232304169578403830 },
{ /*111 f=11100 */ 0.71062180256083218310, 0.03232304169578403830 },
{ /*112 f=11200 */ 0.71673589909060053671, 0.03232304169578403830 },
{ /*113 f=11300 */ 0.72284231995471004417, 0.03232304169578403830 },
{ /*114 f=11400 */ 0.72894099975829929061, 0.03232304169578403830 },
{ /*115 f=11500 */ 0.73503187318940710338, 0.03232304169578403830 },
{ /*116 f=11600 */ 0.74111487501967243663, 0.03232304169578403830 },
{ /*117 f=11700 */ 0.74718994010503270164, 0.03232304169578403830 },
{ /*118 f=11800 */ 0.75325700338642143095, 0.03232304169578403830 },
{ /*119 f=11900 */ 0.75931599989046549837, 0.03232304169578403830 },
{ /*120 f=12000 */ 0.76536686473017956356, 0.03232304169578403830 },
{ /*121 f=12100 */ 0.77140953310566262591, 0.03232304169578403830 },
{ /*122 f=12200 */ 0.77744394030479113678, 0.03232304169578403830 },
{ /*123 f=12300 */ 0.78347002170391177867, 0.03232304169578403830 },
{ /*124 f=12400 */ 0.78948771276853446643, 0.03232304169578403830 },
{ /*125 f=12500 */ 0.79549694905402212886, 0.03232304169578403830 },
{ /*126 f=12600 */ 0.80149766620628193348, 0.03232304169578403830 },
{ /*127 f=12700 */ 0.80748979996245418000, 0.03232304169578403830 },
{ /*128 f=12800 */ 0.81347328615160030552, 0.03232304169578403830 },
{ /*129 f=12900 */ 0.81944806069539055660, 0.03232304169578403830 },
{ /*130 f=13000 */ 0.82541405960878933001, 0.03232304169578403830 },
{ /*131 f=13100 */ 0.83137121900074162362, 0.03232304169578403830 },
{ /*132 f=13200 */ 0.83731947507485626758, 0.03232304169578403830 },
{ /*133 f=13300 */ 0.84325876413008904464, 0.03232304169578403830 },
{ /*134 f=13400 */ 0.84918902256142625440, 0.03232304169578403830 },
{ /*135 f=13500 */ 0.85511018686056416982, 0.03232304169578403830 },
{ /*136 f=13600 */ 0.86102219361659015906, 0.03232304169578403830 },
{ /*137 f=13700 */ 0.86692497951666180889, 0.03232304169578403830 },
{ /*138 f=13800 */ 0.87281848134668404970, 0.03232304169578403830 },
{ /*139 f=13900 */ 0.87870263599198739080, 0.03232304169578403830 },
{ /*140 f=14000 */ 0.88457738043800260286, 0.03232304169578403830 },
{ /*141 f=14100 */ 0.89044265177093639974, 0.03232304169578403830 },
{ /*142 f=14200 */ 0.89629838717844512175, 0.03232304169578403830 },
{ /*143 f=14300 */ 0.90214452395030675369, 0.03232304169578403830 },
{ /*144 f=14400 */ 0.90798099947909349794, 0.03232304169578403830 },
{ /*145 f=14500 */ 0.91380775126084123894, 0.03232304169578403830 },
{ /*146 f=14600 */ 0.91962471689571967381, 0.03232304169578403830 },
{ /*147 f=14700 */ 0.92543183408870022255, 0.03232304169578403830 },
{ /*148 f=14800 */ 0.93122904065022282794, 0.03232304169578403830 },
{ /*149 f=14900 */ 0.93701627449686286653, 0.03232304169578403830 },
{ /*150 f=15000 */ 0.94279347365199528408, 0.03232304169578403830 },
{ /*151 f=15100 */ 0.94856057624645839788, 0.03232304169578403830 },
{ /*152 f=15200 */ 0.95431752051921681090, 0.03232304169578403830 },
{ /*153 f=15300 */ 0.96006424481802221660, 0.03232304169578403830 },
{ /*154 f=15400 */ 0.96580068760007475870, 0.03232304169578403830 },
{ /*155 f=15500 */ 0.97152678743268006123, 0.03232304169578403830 },
{ /*156 f=15600 */ 0.97724248299390981121, 0.03232304169578403830 },
{ /*157 f=15700 */ 0.98294771307325645715, 0.03232304169578403830 },
{ /*158 f=15800 */ 0.98864241657228923987, 0.03232304169578403830 },
{ /*159 f=15900 */ 0.99432653250530855793, 0.03232304169578403830 },
{ /*160 f=16000 */ 0.99999999999999988898, 0.03232304169578403830 },
{ /*161 f=16100 */ 1.00566275829808415843, 0.03232304169578403830 },
{ /*162 f=16200 */ 1.01131474675596910728, 0.03232304169578403830 },
{ /*163 f=16300 */ 1.01695590484539954979, 0.03232304169578403830 },
{ /*164 f=16400 */ 1.02258617215410430035, 0.03232304169578403830 },
{ /*165 f=16500 */ 1.02820548838644332257, 0.03232304169578403830 },
{ /*166 f=16600 */ 1.03381379336405498925, 0.03232304169578403830 },
{ /*167 f=16700 */ 1.03941102702649845746, 0.03232304169578403830 },
{ /*168 f=16800 */ 1.04499712943189759784, 0.03232304169578403830 },
{ /*169 f=16900 */ 1.05057204075758403583, 0.03232304169578403830 },
{ /*170 f=17000 */ 1.05613570130073597397, 0.03232304169578403830 },
{ /*171 f=17100 */ 1.06168805147901901265, 0.03232304169578403830 },
{ /*172 f=17200 */ 1.06722903183122297399, 0.03232304169578403830 },
{ /*173 f=17300 */ 1.07275858301790050220, 0.03232304169578403830 },
{ /*174 f=17400 */ 1.07827664582200033472, 0.03232304169578403830 },
{ /*175 f=17500 */ 1.08378316114950346005, 0.03232304169578403830 },
{ /*176 f=17600 */ 1.08927807003005394648, 0.03232304169578403830 },
{ /*177 f=17700 */ 1.09476131361759310145, 0.03232304169578403830 },
{ /*178 f=17800 */ 1.10023283319098674760, 0.03232304169578403830 },
{ /*179 f=17900 */ 1.10569257015465582938, 0.03232304169578403830 },
{ /*180 f=18000 */ 1.11114046603920435530, 0.03232304169578403830 },
{ /*181 f=18100 */ 1.11657646250204400928, 0.03232304169578403830 },
{ /*182 f=18200 */ 1.12200050132801965042, 0.03232304169578403830 },
{ /*183 f=18300 */ 1.12741252443003325823, 0.03232304169578403830 },
{ /*184 f=18400 */ 1.13281247384966565761, 0.03232304169578403830 },
{ /*185 f=18500 */ 1.13820029175779646735, 0.03232304169578403830 },
{ /*186 f=18600 */ 1.14357592045522449276, 0.03232304169578403830 },
{ /*187 f=18700 */ 1.14893930237328523170, 0.03232304169578403830 },
{ /*188 f=18800 */ 1.15429038007446727043, 0.03232304169578403830 },
{ /*189 f=18900 */ 1.15962909625302712513, 0.03232304169578403830 },
{ /*190 f=19000 */ 1.16495539373560430541, 0.03232304169578403830 },
{ /*191 f=19100 */ 1.17026921548183104882, 0.03232304169578403830 },
{ /*192 f=19200 */ 1.17557050458494627421, 0.03232304169578403830 },
{ /*193 f=19300 */ 1.18085920427240220754, 0.03232304169578403830 },
{ /*194 f=19400 */ 1.18613525790647433844, 0.03232304169578403830 },
{ /*195 f=19500 */ 1.19139860898486671381, 0.03232304169578403830 },
{ /*196 f=19600 */ 1.19664920114131789752, 0.03232304169578403830 },
{ /*197 f=19700 */ 1.20188697814620470972, 0.03232304169578403830 },
{ /*198 f=19800 */ 1.20711188390714285745, 0.03232304169578403830 },
{ /*199 f=19900 */ 1.21232386246958934173, 0.03232304169578403830 },
{ /*200 f=20000 */ 1.21752285801744131177, 0.03232304169578403830 },
{ /*201 f=20100 */ 1.22270881487363292095, 0.03232304169578403830 },
{ /*202 f=20200 */ 1.22788167750073284878, 0.03232304169578403830 },
{ /*203 f=20300 */ 1.23304139050153827029, 0.03232304169578403830 },
{ /*204 f=20400 */ 1.23818789861966793708, 0.03232304169578403830 },
{ /*205 f=20500 */ 1.24332114674015481448, 0.03232304169578403830 },
{ /*206 f=20600 */ 1.24844107989003516579, 0.03232304169578403830 },
{ /*207 f=20700 */ 1.25354764323893919098, 0.03232304169578403830 },
{ /*208 f=20800 */ 1.25864078209967500399, 0.03232304169578403830 },
{ /*209 f=20900 */ 1.26372044192881749503, 0.03232304169578403830 },
{ /*210 f=21000 */ 1.26878656832729097559, 0.03232304169578403830 },
{ /*211 f=21100 */ 1.27383910704095182354, 0.03232304169578403830 },
{ /*212 f=21200 */ 1.27887800396116935175, 0.03232304169578403830 },
{ /*213 f=21300 */ 1.28390320512540601072, 0.03232304169578403830 },
{ /*214 f=21400 */ 1.28891465671779492652, 0.03232304169578403830 },
{ /*215 f=21500 */ 1.29391230506971455227, 0.03232304169578403830 },
{ /*216 f=21600 */ 1.29889609666036731639, 0.03232304169578403830 },
{ /*217 f=21700 */ 1.30386597811734850083, 0.03232304169578403830 },
{ /*218 f=21800 */ 1.30882189621722067052, 0.03232304169578403830 },
{ /*219 f=21900 */ 1.31376379788608255161, 0.03232304169578403830 },
{ /*220 f=22000 */ 1.31869163020013768772, 0.03232304169578403830 },
{ /*221 f=22100 */ 1.32360534038626065367, 0.03232304169578403830 },
{ /*222 f=22200 */ 1.32850487582256349128, 0.03232304169578403830 },
{ /*223 f=22300 */ 1.33339018403895726017, 0.03232304169578403830 },
{ /*224 f=22400 */ 1.33826121271771647514, 0.03232304169578403830 },
{ /*225 f=22500 */ 1.34311790969403666018, 0.03232304169578403830 },
{ /*226 f=22600 */ 1.34796022295659567725, 0.03232304169578403830 },
{ /*227 f=22700 */ 1.35278810064810839364, 0.03232304169578403830 },
{ /*228 f=22800 */ 1.35760149106588334789, 0.03232304169578403830 },
{ /*229 f=22900 */ 1.36240034266237652893, 0.03232304169578403830 },
{ /*230 f=23000 */ 1.36718460404574249090, 0.03232304169578403830 },
{ /*231 f=23100 */ 1.37195422398038568979, 0.03232304169578403830 },
{ /*232 f=23200 */ 1.37670915138750782347, 0.03232304169578403830 },
{ /*233 f=23300 */ 1.38144933534565739208, 0.03232304169578403830 },
{ /*234 f=23400 */ 1.38617472509127170888, 0.03232304169578403830 },
{ /*235 f=23500 */ 1.39088527001922335202, 0.03232304169578403830 },
{ /*236 f=23600 */ 1.39558091968336017707, 0.03232304169578403830 },
{ /*237 f=23700 */ 1.40026162379704732786, 0.03232304169578403830 },
{ /*238 f=23800 */ 1.40492733223370347417, 0.03232304169578403830 },
{ /*239 f=23900 */ 1.40957799502734015817, 0.03232304169578403830 },
{ /*240 f=24000 */ 1.41421356237309492343, 0.03232304169578403830 }
};
static FLOAT_T vsf_q130[241][2] = {
{ /* dummy entry */ 0, 0},
{ /*  1 f=  100 */ 0.00654497301305325026, 0.02554460174476558265 },
{ /*  2 f=  200 */ 0.01308987593470371628, 0.02554460174476558265 },
{ /*  3 f=  300 */ 0.01963463867429923390, 0.02554460174476558265 },
{ /*  4 f=  400 */ 0.02617919114268887903, 0.02554460174476558265 },
{ /*  5 f=  500 */ 0.03272346325297356001, 0.02554460174476558265 },
{ /*  6 f=  600 */ 0.03926738492125660118, 0.02554460174476558265 },
{ /*  7 f=  700 */ 0.04581088606739427971, 0.02554460174476558265 },
{ /*  8 f=  800 */ 0.05235389661574629816, 0.02554460174476558265 },
{ /*  9 f=  900 */ 0.05889634649592632304, 0.02554460174476558265 },
{ /* 10 f= 1000 */ 0.06543816564355227350, 0.02554460174476558265 },
{ /* 11 f= 1100 */ 0.07197928400099674884, 0.02554460174476558265 },
{ /* 12 f= 1200 */ 0.07851963151813722008, 0.02554460174476558265 },
{ /* 13 f= 1300 */ 0.08505913815310624237, 0.02554460174476558265 },
{ /* 14 f= 1400 */ 0.09159773387304154246, 0.02554460174476558265 },
{ /* 15 f= 1500 */ 0.09813534865483602987, 0.02554460174476558265 },
{ /* 16 f= 1600 */ 0.10467191248588765540, 0.02554460174476558265 },
{ /* 17 f= 1700 */ 0.11120735536484922801, 0.02554460174476558265 },
{ /* 18 f= 1800 */ 0.11774160730237806516, 0.02554460174476558265 },
{ /* 19 f= 1900 */ 0.12427459832188544886, 0.02554460174476558265 },
{ /* 20 f= 2000 */ 0.13080625846028612336, 0.02554460174476558265 },
{ /* 21 f= 2100 */ 0.13733651776874752914, 0.02554460174476558265 },
{ /* 22 f= 2200 */ 0.14386530631343877329, 0.02554460174476558265 },
{ /* 23 f= 2300 */ 0.15039255417627980793, 0.02554460174476558265 },
{ /* 24 f= 2400 */ 0.15691819145568988714, 0.02554460174476558265 },
{ /* 25 f= 2500 */ 0.16344214826733644008, 0.02554460174476558265 },
{ /* 26 f= 2600 */ 0.16996435474488333361, 0.02554460174476558265 },
{ /* 27 f= 2700 */ 0.17648474104073902380, 0.02554460174476558265 },
{ /* 28 f= 2800 */ 0.18300323732680476296, 0.02554460174476558265 },
{ /* 29 f= 2900 */ 0.18951977379522222389, 0.02554460174476558265 },
{ /* 30 f= 3000 */ 0.19603428065912120726, 0.02554460174476558265 },
{ /* 31 f= 3100 */ 0.20254668815336684951, 0.02554460174476558265 },
{ /* 32 f= 3200 */ 0.20905692653530691394, 0.02554460174476558265 },
{ /* 33 f= 3300 */ 0.21556492608551869328, 0.02554460174476558265 },
{ /* 34 f= 3400 */ 0.22207061710855535708, 0.02554460174476558265 },
{ /* 35 f= 3500 */ 0.22857392993369279877, 0.02554460174476558265 },
{ /* 36 f= 3600 */ 0.23507479491567528918, 0.02554460174476558265 },
{ /* 37 f= 3700 */ 0.24157314243546165744, 0.02554460174476558265 },
{ /* 38 f= 3800 */ 0.24806890290097063922, 0.02554460174476558265 },
{ /* 39 f= 3900 */ 0.25456200674782641924, 0.02554460174476558265 },
{ /* 40 f= 4000 */ 0.26105238444010314680, 0.02554460174476558265 },
{ /* 41 f= 4100 */ 0.26753996647107025630, 0.02554460174476558265 },
{ /* 42 f= 4200 */ 0.27402468336393603909, 0.02554460174476558265 },
{ /* 43 f= 4300 */ 0.28050646567259251984, 0.02554460174476558265 },
{ /* 44 f= 4400 */ 0.28698524398235858435, 0.02554460174476558265 },
{ /* 45 f= 4500 */ 0.29346094891072349586, 0.02554460174476558265 },
{ /* 46 f= 4600 */ 0.29993351110809002291, 0.02554460174476558265 },
{ /* 47 f= 4700 */ 0.30640286125851695642, 0.02554460174476558265 },
{ /* 48 f= 4800 */ 0.31286893008046173792, 0.02554460174476558265 },
{ /* 49 f= 4900 */ 0.31933164832752197748, 0.02554460174476558265 },
{ /* 50 f= 5000 */ 0.32579094678917747130, 0.02554460174476558265 },
{ /* 51 f= 5100 */ 0.33224675629153094247, 0.02554460174476558265 },
{ /* 52 f= 5200 */ 0.33869900769804922591, 0.02554460174476558265 },
{ /* 53 f= 5300 */ 0.34514763191030339851, 0.02554460174476558265 },
{ /* 54 f= 5400 */ 0.35159255986870902033, 0.02554460174476558265 },
{ /* 55 f= 5500 */ 0.35803372255326532114, 0.02554460174476558265 },
{ /* 56 f= 5600 */ 0.36447105098429494197, 0.02554460174476558265 },
{ /* 57 f= 5700 */ 0.37090447622318184484, 0.02554460174476558265 },
{ /* 58 f= 5800 */ 0.37733392937311044379, 0.02554460174476558265 },
{ /* 59 f= 5900 */ 0.38375934157980284844, 0.02554460174476558265 },
{ /* 60 f= 6000 */ 0.39018064403225649617, 0.02554460174476558265 },
{ /* 61 f= 6100 */ 0.39659776796348089611, 0.02554460174476558265 },
{ /* 62 f= 6200 */ 0.40301064465123426217, 0.02554460174476558265 },
{ /* 63 f= 6300 */ 0.40941920541875920225, 0.02554460174476558265 },
{ /* 64 f= 6400 */ 0.41582338163551862964, 0.02554460174476558265 },
{ /* 65 f= 6500 */ 0.42222310471793028652, 0.02554460174476558265 },
{ /* 66 f= 6600 */ 0.42861830613010154511, 0.02554460174476558265 },
{ /* 67 f= 6700 */ 0.43500891738456293201, 0.02554460174476558265 },
{ /* 68 f= 6800 */ 0.44139487004300215212, 0.02554460174476558265 },
{ /* 69 f= 6900 */ 0.44777609571699672486, 0.02554460174476558265 },
{ /* 70 f= 7000 */ 0.45415252606874645380, 0.02554460174476558265 },
{ /* 71 f= 7100 */ 0.46052409281180473055, 0.02554460174476558265 },
{ /* 72 f= 7200 */ 0.46689072771181078236, 0.02554460174476558265 },
{ /* 73 f= 7300 */ 0.47325236258721975480, 0.02554460174476558265 },
{ /* 74 f= 7400 */ 0.47960892931003307194, 0.02554460174476558265 },
{ /* 75 f= 7500 */ 0.48596035980652774189, 0.02554460174476558265 },
{ /* 76 f= 7600 */ 0.49230658605798605088, 0.02554460174476558265 },
{ /* 77 f= 7700 */ 0.49864754010142336993, 0.02554460174476558265 },
{ /* 78 f= 7800 */ 0.50498315403031590609, 0.02554460174476558265 },
{ /* 79 f= 7900 */ 0.51131335999532878667, 0.02554460174476558265 },
{ /* 80 f= 8000 */ 0.51763809020504147895, 0.02554460174476558265 },
{ /* 81 f= 8100 */ 0.52395727692667493081, 0.02554460174476558265 },
{ /* 82 f= 8200 */ 0.53027085248681604668, 0.02554460174476558265 },
{ /* 83 f= 8300 */ 0.53657874927214277427, 0.02554460174476558265 },
{ /* 84 f= 8400 */ 0.54288089973014852507, 0.02554460174476558265 },
{ /* 85 f= 8500 */ 0.54917723636986470748, 0.02554460174476558265 },
{ /* 86 f= 8600 */ 0.55546769176258437017, 0.02554460174476558265 },
{ /* 87 f= 8700 */ 0.56175219854258418017, 0.02554460174476558265 },
{ /* 88 f= 8800 */ 0.56803068940784517959, 0.02554460174476558265 },
{ /* 89 f= 8900 */ 0.57430309712077465267, 0.02554460174476558265 },
{ /* 90 f= 9000 */ 0.58056935450892466211, 0.02554460174476558265 },
{ /* 91 f= 9100 */ 0.58682939446571336095, 0.02554460174476558265 },
{ /* 92 f= 9200 */ 0.59308314995114197465, 0.02554460174476558265 },
{ /* 93 f= 9300 */ 0.59933055399251322637, 0.02554460174476558265 },
{ /* 94 f= 9400 */ 0.60557153968514920717, 0.02554460174476558265 },
{ /* 95 f= 9500 */ 0.61180604019310691477, 0.02554460174476558265 },
{ /* 96 f= 9600 */ 0.61803398874989479150, 0.02554460174476558265 },
{ /* 97 f= 9700 */ 0.62425531865918737484, 0.02554460174476558265 },
{ /* 98 f= 9800 */ 0.63046996329553928184, 0.02554460174476558265 },
{ /* 99 f= 9900 */ 0.63667785610509941563, 0.02554460174476558265 },
{ /*100 f=10000 */ 0.64287893060632317344, 0.02554460174476558265 },
{ /*101 f=10100 */ 0.64907312039068432163, 0.02554460174476558265 },
{ /*102 f=10200 */ 0.65526035912338698175, 0.02554460174476558265 },
{ /*103 f=10300 */ 0.66144058054407484093, 0.02554460174476558265 },
{ /*104 f=10400 */ 0.66761371846754191672, 0.02554460174476558265 },
{ /*105 f=10500 */ 0.67377970678444010222, 0.02554460174476558265 },
{ /*106 f=10600 */ 0.67993847946198837651, 0.02554460174476558265 },
{ /*107 f=10700 */ 0.68608997054467968368, 0.02554460174476558265 },
{ /*108 f=10800 */ 0.69223411415498592447, 0.02554460174476558265 },
{ /*109 f=10900 */ 0.69837084449406572340, 0.02554460174476558265 },
{ /*110 f=11000 */ 0.70450009584246697791, 0.02554460174476558265 },
{ /*111 f=11100 */ 0.71062180256083218310, 0.02554460174476558265 },
{ /*112 f=11200 */ 0.71673589909060053671, 0.02554460174476558265 },
{ /*113 f=11300 */ 0.72284231995471004417, 0.02554460174476558265 },
{ /*114 f=11400 */ 0.72894099975829929061, 0.02554460174476558265 },
{ /*115 f=11500 */ 0.73503187318940710338, 0.02554460174476558265 },
{ /*116 f=11600 */ 0.74111487501967243663, 0.02554460174476558265 },
{ /*117 f=11700 */ 0.74718994010503270164, 0.02554460174476558265 },
{ /*118 f=11800 */ 0.75325700338642143095, 0.02554460174476558265 },
{ /*119 f=11900 */ 0.75931599989046549837, 0.02554460174476558265 },
{ /*120 f=12000 */ 0.76536686473017956356, 0.02554460174476558265 },
{ /*121 f=12100 */ 0.77140953310566262591, 0.02554460174476558265 },
{ /*122 f=12200 */ 0.77744394030479113678, 0.02554460174476558265 },
{ /*123 f=12300 */ 0.78347002170391177867, 0.02554460174476558265 },
{ /*124 f=12400 */ 0.78948771276853446643, 0.02554460174476558265 },
{ /*125 f=12500 */ 0.79549694905402212886, 0.02554460174476558265 },
{ /*126 f=12600 */ 0.80149766620628193348, 0.02554460174476558265 },
{ /*127 f=12700 */ 0.80748979996245418000, 0.02554460174476558265 },
{ /*128 f=12800 */ 0.81347328615160030552, 0.02554460174476558265 },
{ /*129 f=12900 */ 0.81944806069539055660, 0.02554460174476558265 },
{ /*130 f=13000 */ 0.82541405960878933001, 0.02554460174476558265 },
{ /*131 f=13100 */ 0.83137121900074162362, 0.02554460174476558265 },
{ /*132 f=13200 */ 0.83731947507485626758, 0.02554460174476558265 },
{ /*133 f=13300 */ 0.84325876413008904464, 0.02554460174476558265 },
{ /*134 f=13400 */ 0.84918902256142625440, 0.02554460174476558265 },
{ /*135 f=13500 */ 0.85511018686056416982, 0.02554460174476558265 },
{ /*136 f=13600 */ 0.86102219361659015906, 0.02554460174476558265 },
{ /*137 f=13700 */ 0.86692497951666180889, 0.02554460174476558265 },
{ /*138 f=13800 */ 0.87281848134668404970, 0.02554460174476558265 },
{ /*139 f=13900 */ 0.87870263599198739080, 0.02554460174476558265 },
{ /*140 f=14000 */ 0.88457738043800260286, 0.02554460174476558265 },
{ /*141 f=14100 */ 0.89044265177093639974, 0.02554460174476558265 },
{ /*142 f=14200 */ 0.89629838717844512175, 0.02554460174476558265 },
{ /*143 f=14300 */ 0.90214452395030675369, 0.02554460174476558265 },
{ /*144 f=14400 */ 0.90798099947909349794, 0.02554460174476558265 },
{ /*145 f=14500 */ 0.91380775126084123894, 0.02554460174476558265 },
{ /*146 f=14600 */ 0.91962471689571967381, 0.02554460174476558265 },
{ /*147 f=14700 */ 0.92543183408870022255, 0.02554460174476558265 },
{ /*148 f=14800 */ 0.93122904065022282794, 0.02554460174476558265 },
{ /*149 f=14900 */ 0.93701627449686286653, 0.02554460174476558265 },
{ /*150 f=15000 */ 0.94279347365199528408, 0.02554460174476558265 },
{ /*151 f=15100 */ 0.94856057624645839788, 0.02554460174476558265 },
{ /*152 f=15200 */ 0.95431752051921681090, 0.02554460174476558265 },
{ /*153 f=15300 */ 0.96006424481802221660, 0.02554460174476558265 },
{ /*154 f=15400 */ 0.96580068760007475870, 0.02554460174476558265 },
{ /*155 f=15500 */ 0.97152678743268006123, 0.02554460174476558265 },
{ /*156 f=15600 */ 0.97724248299390981121, 0.02554460174476558265 },
{ /*157 f=15700 */ 0.98294771307325645715, 0.02554460174476558265 },
{ /*158 f=15800 */ 0.98864241657228923987, 0.02554460174476558265 },
{ /*159 f=15900 */ 0.99432653250530855793, 0.02554460174476558265 },
{ /*160 f=16000 */ 0.99999999999999988898, 0.02554460174476558265 },
{ /*161 f=16100 */ 1.00566275829808415843, 0.02554460174476558265 },
{ /*162 f=16200 */ 1.01131474675596910728, 0.02554460174476558265 },
{ /*163 f=16300 */ 1.01695590484539954979, 0.02554460174476558265 },
{ /*164 f=16400 */ 1.02258617215410430035, 0.02554460174476558265 },
{ /*165 f=16500 */ 1.02820548838644332257, 0.02554460174476558265 },
{ /*166 f=16600 */ 1.03381379336405498925, 0.02554460174476558265 },
{ /*167 f=16700 */ 1.03941102702649845746, 0.02554460174476558265 },
{ /*168 f=16800 */ 1.04499712943189759784, 0.02554460174476558265 },
{ /*169 f=16900 */ 1.05057204075758403583, 0.02554460174476558265 },
{ /*170 f=17000 */ 1.05613570130073597397, 0.02554460174476558265 },
{ /*171 f=17100 */ 1.06168805147901901265, 0.02554460174476558265 },
{ /*172 f=17200 */ 1.06722903183122297399, 0.02554460174476558265 },
{ /*173 f=17300 */ 1.07275858301790050220, 0.02554460174476558265 },
{ /*174 f=17400 */ 1.07827664582200033472, 0.02554460174476558265 },
{ /*175 f=17500 */ 1.08378316114950346005, 0.02554460174476558265 },
{ /*176 f=17600 */ 1.08927807003005394648, 0.02554460174476558265 },
{ /*177 f=17700 */ 1.09476131361759310145, 0.02554460174476558265 },
{ /*178 f=17800 */ 1.10023283319098674760, 0.02554460174476558265 },
{ /*179 f=17900 */ 1.10569257015465582938, 0.02554460174476558265 },
{ /*180 f=18000 */ 1.11114046603920435530, 0.02554460174476558265 },
{ /*181 f=18100 */ 1.11657646250204400928, 0.02554460174476558265 },
{ /*182 f=18200 */ 1.12200050132801965042, 0.02554460174476558265 },
{ /*183 f=18300 */ 1.12741252443003325823, 0.02554460174476558265 },
{ /*184 f=18400 */ 1.13281247384966565761, 0.02554460174476558265 },
{ /*185 f=18500 */ 1.13820029175779646735, 0.02554460174476558265 },
{ /*186 f=18600 */ 1.14357592045522449276, 0.02554460174476558265 },
{ /*187 f=18700 */ 1.14893930237328523170, 0.02554460174476558265 },
{ /*188 f=18800 */ 1.15429038007446727043, 0.02554460174476558265 },
{ /*189 f=18900 */ 1.15962909625302712513, 0.02554460174476558265 },
{ /*190 f=19000 */ 1.16495539373560430541, 0.02554460174476558265 },
{ /*191 f=19100 */ 1.17026921548183104882, 0.02554460174476558265 },
{ /*192 f=19200 */ 1.17557050458494627421, 0.02554460174476558265 },
{ /*193 f=19300 */ 1.18085920427240220754, 0.02554460174476558265 },
{ /*194 f=19400 */ 1.18613525790647433844, 0.02554460174476558265 },
{ /*195 f=19500 */ 1.19139860898486671381, 0.02554460174476558265 },
{ /*196 f=19600 */ 1.19664920114131789752, 0.02554460174476558265 },
{ /*197 f=19700 */ 1.20188697814620470972, 0.02554460174476558265 },
{ /*198 f=19800 */ 1.20711188390714285745, 0.02554460174476558265 },
{ /*199 f=19900 */ 1.21232386246958934173, 0.02554460174476558265 },
{ /*200 f=20000 */ 1.21752285801744131177, 0.02554460174476558265 },
{ /*201 f=20100 */ 1.22270881487363292095, 0.02554460174476558265 },
{ /*202 f=20200 */ 1.22788167750073284878, 0.02554460174476558265 },
{ /*203 f=20300 */ 1.23304139050153827029, 0.02554460174476558265 },
{ /*204 f=20400 */ 1.23818789861966793708, 0.02554460174476558265 },
{ /*205 f=20500 */ 1.24332114674015481448, 0.02554460174476558265 },
{ /*206 f=20600 */ 1.24844107989003516579, 0.02554460174476558265 },
{ /*207 f=20700 */ 1.25354764323893919098, 0.02554460174476558265 },
{ /*208 f=20800 */ 1.25864078209967500399, 0.02554460174476558265 },
{ /*209 f=20900 */ 1.26372044192881749503, 0.02554460174476558265 },
{ /*210 f=21000 */ 1.26878656832729097559, 0.02554460174476558265 },
{ /*211 f=21100 */ 1.27383910704095182354, 0.02554460174476558265 },
{ /*212 f=21200 */ 1.27887800396116935175, 0.02554460174476558265 },
{ /*213 f=21300 */ 1.28390320512540601072, 0.02554460174476558265 },
{ /*214 f=21400 */ 1.28891465671779492652, 0.02554460174476558265 },
{ /*215 f=21500 */ 1.29391230506971455227, 0.02554460174476558265 },
{ /*216 f=21600 */ 1.29889609666036731639, 0.02554460174476558265 },
{ /*217 f=21700 */ 1.30386597811734850083, 0.02554460174476558265 },
{ /*218 f=21800 */ 1.30882189621722067052, 0.02554460174476558265 },
{ /*219 f=21900 */ 1.31376379788608255161, 0.02554460174476558265 },
{ /*220 f=22000 */ 1.31869163020013768772, 0.02554460174476558265 },
{ /*221 f=22100 */ 1.32360534038626065367, 0.02554460174476558265 },
{ /*222 f=22200 */ 1.32850487582256349128, 0.02554460174476558265 },
{ /*223 f=22300 */ 1.33339018403895726017, 0.02554460174476558265 },
{ /*224 f=22400 */ 1.33826121271771647514, 0.02554460174476558265 },
{ /*225 f=22500 */ 1.34311790969403666018, 0.02554460174476558265 },
{ /*226 f=22600 */ 1.34796022295659567725, 0.02554460174476558265 },
{ /*227 f=22700 */ 1.35278810064810839364, 0.02554460174476558265 },
{ /*228 f=22800 */ 1.35760149106588334789, 0.02554460174476558265 },
{ /*229 f=22900 */ 1.36240034266237652893, 0.02554460174476558265 },
{ /*230 f=23000 */ 1.36718460404574249090, 0.02554460174476558265 },
{ /*231 f=23100 */ 1.37195422398038568979, 0.02554460174476558265 },
{ /*232 f=23200 */ 1.37670915138750782347, 0.02554460174476558265 },
{ /*233 f=23300 */ 1.38144933534565739208, 0.02554460174476558265 },
{ /*234 f=23400 */ 1.38617472509127170888, 0.02554460174476558265 },
{ /*235 f=23500 */ 1.39088527001922335202, 0.02554460174476558265 },
{ /*236 f=23600 */ 1.39558091968336017707, 0.02554460174476558265 },
{ /*237 f=23700 */ 1.40026162379704732786, 0.02554460174476558265 },
{ /*238 f=23800 */ 1.40492733223370347417, 0.02554460174476558265 },
{ /*239 f=23900 */ 1.40957799502734015817, 0.02554460174476558265 },
{ /*240 f=24000 */ 1.41421356237309492343, 0.02554460174476558265 }
};
static FLOAT_T vsf_q140[241][2] = {
{ /* dummy entry */ 0, 0},
{ /*  1 f=  100 */ 0.00654497301305325026, 0.02020962081695998336 },
{ /*  2 f=  200 */ 0.01308987593470371628, 0.02020962081695998336 },
{ /*  3 f=  300 */ 0.01963463867429923390, 0.02020962081695998336 },
{ /*  4 f=  400 */ 0.02617919114268887903, 0.02020962081695998336 },
{ /*  5 f=  500 */ 0.03272346325297356001, 0.02020962081695998336 },
{ /*  6 f=  600 */ 0.03926738492125660118, 0.02020962081695998336 },
{ /*  7 f=  700 */ 0.04581088606739427971, 0.02020962081695998336 },
{ /*  8 f=  800 */ 0.05235389661574629816, 0.02020962081695998336 },
{ /*  9 f=  900 */ 0.05889634649592632304, 0.02020962081695998336 },
{ /* 10 f= 1000 */ 0.06543816564355227350, 0.02020962081695998336 },
{ /* 11 f= 1100 */ 0.07197928400099674884, 0.02020962081695998336 },
{ /* 12 f= 1200 */ 0.07851963151813722008, 0.02020962081695998336 },
{ /* 13 f= 1300 */ 0.08505913815310624237, 0.02020962081695998336 },
{ /* 14 f= 1400 */ 0.09159773387304154246, 0.02020962081695998336 },
{ /* 15 f= 1500 */ 0.09813534865483602987, 0.02020962081695998336 },
{ /* 16 f= 1600 */ 0.10467191248588765540, 0.02020962081695998336 },
{ /* 17 f= 1700 */ 0.11120735536484922801, 0.02020962081695998336 },
{ /* 18 f= 1800 */ 0.11774160730237806516, 0.02020962081695998336 },
{ /* 19 f= 1900 */ 0.12427459832188544886, 0.02020962081695998336 },
{ /* 20 f= 2000 */ 0.13080625846028612336, 0.02020962081695998336 },
{ /* 21 f= 2100 */ 0.13733651776874752914, 0.02020962081695998336 },
{ /* 22 f= 2200 */ 0.14386530631343877329, 0.02020962081695998336 },
{ /* 23 f= 2300 */ 0.15039255417627980793, 0.02020962081695998336 },
{ /* 24 f= 2400 */ 0.15691819145568988714, 0.02020962081695998336 },
{ /* 25 f= 2500 */ 0.16344214826733644008, 0.02020962081695998336 },
{ /* 26 f= 2600 */ 0.16996435474488333361, 0.02020962081695998336 },
{ /* 27 f= 2700 */ 0.17648474104073902380, 0.02020962081695998336 },
{ /* 28 f= 2800 */ 0.18300323732680476296, 0.02020962081695998336 },
{ /* 29 f= 2900 */ 0.18951977379522222389, 0.02020962081695998336 },
{ /* 30 f= 3000 */ 0.19603428065912120726, 0.02020962081695998336 },
{ /* 31 f= 3100 */ 0.20254668815336684951, 0.02020962081695998336 },
{ /* 32 f= 3200 */ 0.20905692653530691394, 0.02020962081695998336 },
{ /* 33 f= 3300 */ 0.21556492608551869328, 0.02020962081695998336 },
{ /* 34 f= 3400 */ 0.22207061710855535708, 0.02020962081695998336 },
{ /* 35 f= 3500 */ 0.22857392993369279877, 0.02020962081695998336 },
{ /* 36 f= 3600 */ 0.23507479491567528918, 0.02020962081695998336 },
{ /* 37 f= 3700 */ 0.24157314243546165744, 0.02020962081695998336 },
{ /* 38 f= 3800 */ 0.24806890290097063922, 0.02020962081695998336 },
{ /* 39 f= 3900 */ 0.25456200674782641924, 0.02020962081695998336 },
{ /* 40 f= 4000 */ 0.26105238444010314680, 0.02020962081695998336 },
{ /* 41 f= 4100 */ 0.26753996647107025630, 0.02020962081695998336 },
{ /* 42 f= 4200 */ 0.27402468336393603909, 0.02020962081695998336 },
{ /* 43 f= 4300 */ 0.28050646567259251984, 0.02020962081695998336 },
{ /* 44 f= 4400 */ 0.28698524398235858435, 0.02020962081695998336 },
{ /* 45 f= 4500 */ 0.29346094891072349586, 0.02020962081695998336 },
{ /* 46 f= 4600 */ 0.29993351110809002291, 0.02020962081695998336 },
{ /* 47 f= 4700 */ 0.30640286125851695642, 0.02020962081695998336 },
{ /* 48 f= 4800 */ 0.31286893008046173792, 0.02020962081695998336 },
{ /* 49 f= 4900 */ 0.31933164832752197748, 0.02020962081695998336 },
{ /* 50 f= 5000 */ 0.32579094678917747130, 0.02020962081695998336 },
{ /* 51 f= 5100 */ 0.33224675629153094247, 0.02020962081695998336 },
{ /* 52 f= 5200 */ 0.33869900769804922591, 0.02020962081695998336 },
{ /* 53 f= 5300 */ 0.34514763191030339851, 0.02020962081695998336 },
{ /* 54 f= 5400 */ 0.35159255986870902033, 0.02020962081695998336 },
{ /* 55 f= 5500 */ 0.35803372255326532114, 0.02020962081695998336 },
{ /* 56 f= 5600 */ 0.36447105098429494197, 0.02020962081695998336 },
{ /* 57 f= 5700 */ 0.37090447622318184484, 0.02020962081695998336 },
{ /* 58 f= 5800 */ 0.37733392937311044379, 0.02020962081695998336 },
{ /* 59 f= 5900 */ 0.38375934157980284844, 0.02020962081695998336 },
{ /* 60 f= 6000 */ 0.39018064403225649617, 0.02020962081695998336 },
{ /* 61 f= 6100 */ 0.39659776796348089611, 0.02020962081695998336 },
{ /* 62 f= 6200 */ 0.40301064465123426217, 0.02020962081695998336 },
{ /* 63 f= 6300 */ 0.40941920541875920225, 0.02020962081695998336 },
{ /* 64 f= 6400 */ 0.41582338163551862964, 0.02020962081695998336 },
{ /* 65 f= 6500 */ 0.42222310471793028652, 0.02020962081695998336 },
{ /* 66 f= 6600 */ 0.42861830613010154511, 0.02020962081695998336 },
{ /* 67 f= 6700 */ 0.43500891738456293201, 0.02020962081695998336 },
{ /* 68 f= 6800 */ 0.44139487004300215212, 0.02020962081695998336 },
{ /* 69 f= 6900 */ 0.44777609571699672486, 0.02020962081695998336 },
{ /* 70 f= 7000 */ 0.45415252606874645380, 0.02020962081695998336 },
{ /* 71 f= 7100 */ 0.46052409281180473055, 0.02020962081695998336 },
{ /* 72 f= 7200 */ 0.46689072771181078236, 0.02020962081695998336 },
{ /* 73 f= 7300 */ 0.47325236258721975480, 0.02020962081695998336 },
{ /* 74 f= 7400 */ 0.47960892931003307194, 0.02020962081695998336 },
{ /* 75 f= 7500 */ 0.48596035980652774189, 0.02020962081695998336 },
{ /* 76 f= 7600 */ 0.49230658605798605088, 0.02020962081695998336 },
{ /* 77 f= 7700 */ 0.49864754010142336993, 0.02020962081695998336 },
{ /* 78 f= 7800 */ 0.50498315403031590609, 0.02020962081695998336 },
{ /* 79 f= 7900 */ 0.51131335999532878667, 0.02020962081695998336 },
{ /* 80 f= 8000 */ 0.51763809020504147895, 0.02020962081695998336 },
{ /* 81 f= 8100 */ 0.52395727692667493081, 0.02020962081695998336 },
{ /* 82 f= 8200 */ 0.53027085248681604668, 0.02020962081695998336 },
{ /* 83 f= 8300 */ 0.53657874927214277427, 0.02020962081695998336 },
{ /* 84 f= 8400 */ 0.54288089973014852507, 0.02020962081695998336 },
{ /* 85 f= 8500 */ 0.54917723636986470748, 0.02020962081695998336 },
{ /* 86 f= 8600 */ 0.55546769176258437017, 0.02020962081695998336 },
{ /* 87 f= 8700 */ 0.56175219854258418017, 0.02020962081695998336 },
{ /* 88 f= 8800 */ 0.56803068940784517959, 0.02020962081695998336 },
{ /* 89 f= 8900 */ 0.57430309712077465267, 0.02020962081695998336 },
{ /* 90 f= 9000 */ 0.58056935450892466211, 0.02020962081695998336 },
{ /* 91 f= 9100 */ 0.58682939446571336095, 0.02020962081695998336 },
{ /* 92 f= 9200 */ 0.59308314995114197465, 0.02020962081695998336 },
{ /* 93 f= 9300 */ 0.59933055399251322637, 0.02020962081695998336 },
{ /* 94 f= 9400 */ 0.60557153968514920717, 0.02020962081695998336 },
{ /* 95 f= 9500 */ 0.61180604019310691477, 0.02020962081695998336 },
{ /* 96 f= 9600 */ 0.61803398874989479150, 0.02020962081695998336 },
{ /* 97 f= 9700 */ 0.62425531865918737484, 0.02020962081695998336 },
{ /* 98 f= 9800 */ 0.63046996329553928184, 0.02020962081695998336 },
{ /* 99 f= 9900 */ 0.63667785610509941563, 0.02020962081695998336 },
{ /*100 f=10000 */ 0.64287893060632317344, 0.02020962081695998336 },
{ /*101 f=10100 */ 0.64907312039068432163, 0.02020962081695998336 },
{ /*102 f=10200 */ 0.65526035912338698175, 0.02020962081695998336 },
{ /*103 f=10300 */ 0.66144058054407484093, 0.02020962081695998336 },
{ /*104 f=10400 */ 0.66761371846754191672, 0.02020962081695998336 },
{ /*105 f=10500 */ 0.67377970678444010222, 0.02020962081695998336 },
{ /*106 f=10600 */ 0.67993847946198837651, 0.02020962081695998336 },
{ /*107 f=10700 */ 0.68608997054467968368, 0.02020962081695998336 },
{ /*108 f=10800 */ 0.69223411415498592447, 0.02020962081695998336 },
{ /*109 f=10900 */ 0.69837084449406572340, 0.02020962081695998336 },
{ /*110 f=11000 */ 0.70450009584246697791, 0.02020962081695998336 },
{ /*111 f=11100 */ 0.71062180256083218310, 0.02020962081695998336 },
{ /*112 f=11200 */ 0.71673589909060053671, 0.02020962081695998336 },
{ /*113 f=11300 */ 0.72284231995471004417, 0.02020962081695998336 },
{ /*114 f=11400 */ 0.72894099975829929061, 0.02020962081695998336 },
{ /*115 f=11500 */ 0.73503187318940710338, 0.02020962081695998336 },
{ /*116 f=11600 */ 0.74111487501967243663, 0.02020962081695998336 },
{ /*117 f=11700 */ 0.74718994010503270164, 0.02020962081695998336 },
{ /*118 f=11800 */ 0.75325700338642143095, 0.02020962081695998336 },
{ /*119 f=11900 */ 0.75931599989046549837, 0.02020962081695998336 },
{ /*120 f=12000 */ 0.76536686473017956356, 0.02020962081695998336 },
{ /*121 f=12100 */ 0.77140953310566262591, 0.02020962081695998336 },
{ /*122 f=12200 */ 0.77744394030479113678, 0.02020962081695998336 },
{ /*123 f=12300 */ 0.78347002170391177867, 0.02020962081695998336 },
{ /*124 f=12400 */ 0.78948771276853446643, 0.02020962081695998336 },
{ /*125 f=12500 */ 0.79549694905402212886, 0.02020962081695998336 },
{ /*126 f=12600 */ 0.80149766620628193348, 0.02020962081695998336 },
{ /*127 f=12700 */ 0.80748979996245418000, 0.02020962081695998336 },
{ /*128 f=12800 */ 0.81347328615160030552, 0.02020962081695998336 },
{ /*129 f=12900 */ 0.81944806069539055660, 0.02020962081695998336 },
{ /*130 f=13000 */ 0.82541405960878933001, 0.02020962081695998336 },
{ /*131 f=13100 */ 0.83137121900074162362, 0.02020962081695998336 },
{ /*132 f=13200 */ 0.83731947507485626758, 0.02020962081695998336 },
{ /*133 f=13300 */ 0.84325876413008904464, 0.02020962081695998336 },
{ /*134 f=13400 */ 0.84918902256142625440, 0.02020962081695998336 },
{ /*135 f=13500 */ 0.85511018686056416982, 0.02020962081695998336 },
{ /*136 f=13600 */ 0.86102219361659015906, 0.02020962081695998336 },
{ /*137 f=13700 */ 0.86692497951666180889, 0.02020962081695998336 },
{ /*138 f=13800 */ 0.87281848134668404970, 0.02020962081695998336 },
{ /*139 f=13900 */ 0.87870263599198739080, 0.02020962081695998336 },
{ /*140 f=14000 */ 0.88457738043800260286, 0.02020962081695998336 },
{ /*141 f=14100 */ 0.89044265177093639974, 0.02020962081695998336 },
{ /*142 f=14200 */ 0.89629838717844512175, 0.02020962081695998336 },
{ /*143 f=14300 */ 0.90214452395030675369, 0.02020962081695998336 },
{ /*144 f=14400 */ 0.90798099947909349794, 0.02020962081695998336 },
{ /*145 f=14500 */ 0.91380775126084123894, 0.02020962081695998336 },
{ /*146 f=14600 */ 0.91962471689571967381, 0.02020962081695998336 },
{ /*147 f=14700 */ 0.92543183408870022255, 0.02020962081695998336 },
{ /*148 f=14800 */ 0.93122904065022282794, 0.02020962081695998336 },
{ /*149 f=14900 */ 0.93701627449686286653, 0.02020962081695998336 },
{ /*150 f=15000 */ 0.94279347365199528408, 0.02020962081695998336 },
{ /*151 f=15100 */ 0.94856057624645839788, 0.02020962081695998336 },
{ /*152 f=15200 */ 0.95431752051921681090, 0.02020962081695998336 },
{ /*153 f=15300 */ 0.96006424481802221660, 0.02020962081695998336 },
{ /*154 f=15400 */ 0.96580068760007475870, 0.02020962081695998336 },
{ /*155 f=15500 */ 0.97152678743268006123, 0.02020962081695998336 },
{ /*156 f=15600 */ 0.97724248299390981121, 0.02020962081695998336 },
{ /*157 f=15700 */ 0.98294771307325645715, 0.02020962081695998336 },
{ /*158 f=15800 */ 0.98864241657228923987, 0.02020962081695998336 },
{ /*159 f=15900 */ 0.99432653250530855793, 0.02020962081695998336 },
{ /*160 f=16000 */ 0.99999999999999988898, 0.02020962081695998336 },
{ /*161 f=16100 */ 1.00566275829808415843, 0.02020962081695998336 },
{ /*162 f=16200 */ 1.01131474675596910728, 0.02020962081695998336 },
{ /*163 f=16300 */ 1.01695590484539954979, 0.02020962081695998336 },
{ /*164 f=16400 */ 1.02258617215410430035, 0.02020962081695998336 },
{ /*165 f=16500 */ 1.02820548838644332257, 0.02020962081695998336 },
{ /*166 f=16600 */ 1.03381379336405498925, 0.02020962081695998336 },
{ /*167 f=16700 */ 1.03941102702649845746, 0.02020962081695998336 },
{ /*168 f=16800 */ 1.04499712943189759784, 0.02020962081695998336 },
{ /*169 f=16900 */ 1.05057204075758403583, 0.02020962081695998336 },
{ /*170 f=17000 */ 1.05613570130073597397, 0.02020962081695998336 },
{ /*171 f=17100 */ 1.06168805147901901265, 0.02020962081695998336 },
{ /*172 f=17200 */ 1.06722903183122297399, 0.02020962081695998336 },
{ /*173 f=17300 */ 1.07275858301790050220, 0.02020962081695998336 },
{ /*174 f=17400 */ 1.07827664582200033472, 0.02020962081695998336 },
{ /*175 f=17500 */ 1.08378316114950346005, 0.02020962081695998336 },
{ /*176 f=17600 */ 1.08927807003005394648, 0.02020962081695998336 },
{ /*177 f=17700 */ 1.09476131361759310145, 0.02020962081695998336 },
{ /*178 f=17800 */ 1.10023283319098674760, 0.02020962081695998336 },
{ /*179 f=17900 */ 1.10569257015465582938, 0.02020962081695998336 },
{ /*180 f=18000 */ 1.11114046603920435530, 0.02020962081695998336 },
{ /*181 f=18100 */ 1.11657646250204400928, 0.02020962081695998336 },
{ /*182 f=18200 */ 1.12200050132801965042, 0.02020962081695998336 },
{ /*183 f=18300 */ 1.12741252443003325823, 0.02020962081695998336 },
{ /*184 f=18400 */ 1.13281247384966565761, 0.02020962081695998336 },
{ /*185 f=18500 */ 1.13820029175779646735, 0.02020962081695998336 },
{ /*186 f=18600 */ 1.14357592045522449276, 0.02020962081695998336 },
{ /*187 f=18700 */ 1.14893930237328523170, 0.02020962081695998336 },
{ /*188 f=18800 */ 1.15429038007446727043, 0.02020962081695998336 },
{ /*189 f=18900 */ 1.15962909625302712513, 0.02020962081695998336 },
{ /*190 f=19000 */ 1.16495539373560430541, 0.02020962081695998336 },
{ /*191 f=19100 */ 1.17026921548183104882, 0.02020962081695998336 },
{ /*192 f=19200 */ 1.17557050458494627421, 0.02020962081695998336 },
{ /*193 f=19300 */ 1.18085920427240220754, 0.02020962081695998336 },
{ /*194 f=19400 */ 1.18613525790647433844, 0.02020962081695998336 },
{ /*195 f=19500 */ 1.19139860898486671381, 0.02020962081695998336 },
{ /*196 f=19600 */ 1.19664920114131789752, 0.02020962081695998336 },
{ /*197 f=19700 */ 1.20188697814620470972, 0.02020962081695998336 },
{ /*198 f=19800 */ 1.20711188390714285745, 0.02020962081695998336 },
{ /*199 f=19900 */ 1.21232386246958934173, 0.02020962081695998336 },
{ /*200 f=20000 */ 1.21752285801744131177, 0.02020962081695998336 },
{ /*201 f=20100 */ 1.22270881487363292095, 0.02020962081695998336 },
{ /*202 f=20200 */ 1.22788167750073284878, 0.02020962081695998336 },
{ /*203 f=20300 */ 1.23304139050153827029, 0.02020962081695998336 },
{ /*204 f=20400 */ 1.23818789861966793708, 0.02020962081695998336 },
{ /*205 f=20500 */ 1.24332114674015481448, 0.02020962081695998336 },
{ /*206 f=20600 */ 1.24844107989003516579, 0.02020962081695998336 },
{ /*207 f=20700 */ 1.25354764323893919098, 0.02020962081695998336 },
{ /*208 f=20800 */ 1.25864078209967500399, 0.02020962081695998336 },
{ /*209 f=20900 */ 1.26372044192881749503, 0.02020962081695998336 },
{ /*210 f=21000 */ 1.26878656832729097559, 0.02020962081695998336 },
{ /*211 f=21100 */ 1.27383910704095182354, 0.02020962081695998336 },
{ /*212 f=21200 */ 1.27887800396116935175, 0.02020962081695998336 },
{ /*213 f=21300 */ 1.28390320512540601072, 0.02020962081695998336 },
{ /*214 f=21400 */ 1.28891465671779492652, 0.02020962081695998336 },
{ /*215 f=21500 */ 1.29391230506971455227, 0.02020962081695998336 },
{ /*216 f=21600 */ 1.29889609666036731639, 0.02020962081695998336 },
{ /*217 f=21700 */ 1.30386597811734850083, 0.02020962081695998336 },
{ /*218 f=21800 */ 1.30882189621722067052, 0.02020962081695998336 },
{ /*219 f=21900 */ 1.31376379788608255161, 0.02020962081695998336 },
{ /*220 f=22000 */ 1.31869163020013768772, 0.02020962081695998336 },
{ /*221 f=22100 */ 1.32360534038626065367, 0.02020962081695998336 },
{ /*222 f=22200 */ 1.32850487582256349128, 0.02020962081695998336 },
{ /*223 f=22300 */ 1.33339018403895726017, 0.02020962081695998336 },
{ /*224 f=22400 */ 1.33826121271771647514, 0.02020962081695998336 },
{ /*225 f=22500 */ 1.34311790969403666018, 0.02020962081695998336 },
{ /*226 f=22600 */ 1.34796022295659567725, 0.02020962081695998336 },
{ /*227 f=22700 */ 1.35278810064810839364, 0.02020962081695998336 },
{ /*228 f=22800 */ 1.35760149106588334789, 0.02020962081695998336 },
{ /*229 f=22900 */ 1.36240034266237652893, 0.02020962081695998336 },
{ /*230 f=23000 */ 1.36718460404574249090, 0.02020962081695998336 },
{ /*231 f=23100 */ 1.37195422398038568979, 0.02020962081695998336 },
{ /*232 f=23200 */ 1.37670915138750782347, 0.02020962081695998336 },
{ /*233 f=23300 */ 1.38144933534565739208, 0.02020962081695998336 },
{ /*234 f=23400 */ 1.38617472509127170888, 0.02020962081695998336 },
{ /*235 f=23500 */ 1.39088527001922335202, 0.02020962081695998336 },
{ /*236 f=23600 */ 1.39558091968336017707, 0.02020962081695998336 },
{ /*237 f=23700 */ 1.40026162379704732786, 0.02020962081695998336 },
{ /*238 f=23800 */ 1.40492733223370347417, 0.02020962081695998336 },
{ /*239 f=23900 */ 1.40957799502734015817, 0.02020962081695998336 },
{ /*240 f=24000 */ 1.41421356237309492343, 0.02020962081695998336 }
};
static FLOAT_T vsf_q150[241][2] = {
{ /* dummy entry */ 0, 0},
{ /*  1 f=  100 */ 0.00654497301305325026, 0.01600242323298606273 },
{ /*  2 f=  200 */ 0.01308987593470371628, 0.01600242323298606273 },
{ /*  3 f=  300 */ 0.01963463867429923390, 0.01600242323298606273 },
{ /*  4 f=  400 */ 0.02617919114268887903, 0.01600242323298606273 },
{ /*  5 f=  500 */ 0.03272346325297356001, 0.01600242323298606273 },
{ /*  6 f=  600 */ 0.03926738492125660118, 0.01600242323298606273 },
{ /*  7 f=  700 */ 0.04581088606739427971, 0.01600242323298606273 },
{ /*  8 f=  800 */ 0.05235389661574629816, 0.01600242323298606273 },
{ /*  9 f=  900 */ 0.05889634649592632304, 0.01600242323298606273 },
{ /* 10 f= 1000 */ 0.06543816564355227350, 0.01600242323298606273 },
{ /* 11 f= 1100 */ 0.07197928400099674884, 0.01600242323298606273 },
{ /* 12 f= 1200 */ 0.07851963151813722008, 0.01600242323298606273 },
{ /* 13 f= 1300 */ 0.08505913815310624237, 0.01600242323298606273 },
{ /* 14 f= 1400 */ 0.09159773387304154246, 0.01600242323298606273 },
{ /* 15 f= 1500 */ 0.09813534865483602987, 0.01600242323298606273 },
{ /* 16 f= 1600 */ 0.10467191248588765540, 0.01600242323298606273 },
{ /* 17 f= 1700 */ 0.11120735536484922801, 0.01600242323298606273 },
{ /* 18 f= 1800 */ 0.11774160730237806516, 0.01600242323298606273 },
{ /* 19 f= 1900 */ 0.12427459832188544886, 0.01600242323298606273 },
{ /* 20 f= 2000 */ 0.13080625846028612336, 0.01600242323298606273 },
{ /* 21 f= 2100 */ 0.13733651776874752914, 0.01600242323298606273 },
{ /* 22 f= 2200 */ 0.14386530631343877329, 0.01600242323298606273 },
{ /* 23 f= 2300 */ 0.15039255417627980793, 0.01600242323298606273 },
{ /* 24 f= 2400 */ 0.15691819145568988714, 0.01600242323298606273 },
{ /* 25 f= 2500 */ 0.16344214826733644008, 0.01600242323298606273 },
{ /* 26 f= 2600 */ 0.16996435474488333361, 0.01600242323298606273 },
{ /* 27 f= 2700 */ 0.17648474104073902380, 0.01600242323298606273 },
{ /* 28 f= 2800 */ 0.18300323732680476296, 0.01600242323298606273 },
{ /* 29 f= 2900 */ 0.18951977379522222389, 0.01600242323298606273 },
{ /* 30 f= 3000 */ 0.19603428065912120726, 0.01600242323298606273 },
{ /* 31 f= 3100 */ 0.20254668815336684951, 0.01600242323298606273 },
{ /* 32 f= 3200 */ 0.20905692653530691394, 0.01600242323298606273 },
{ /* 33 f= 3300 */ 0.21556492608551869328, 0.01600242323298606273 },
{ /* 34 f= 3400 */ 0.22207061710855535708, 0.01600242323298606273 },
{ /* 35 f= 3500 */ 0.22857392993369279877, 0.01600242323298606273 },
{ /* 36 f= 3600 */ 0.23507479491567528918, 0.01600242323298606273 },
{ /* 37 f= 3700 */ 0.24157314243546165744, 0.01600242323298606273 },
{ /* 38 f= 3800 */ 0.24806890290097063922, 0.01600242323298606273 },
{ /* 39 f= 3900 */ 0.25456200674782641924, 0.01600242323298606273 },
{ /* 40 f= 4000 */ 0.26105238444010314680, 0.01600242323298606273 },
{ /* 41 f= 4100 */ 0.26753996647107025630, 0.01600242323298606273 },
{ /* 42 f= 4200 */ 0.27402468336393603909, 0.01600242323298606273 },
{ /* 43 f= 4300 */ 0.28050646567259251984, 0.01600242323298606273 },
{ /* 44 f= 4400 */ 0.28698524398235858435, 0.01600242323298606273 },
{ /* 45 f= 4500 */ 0.29346094891072349586, 0.01600242323298606273 },
{ /* 46 f= 4600 */ 0.29993351110809002291, 0.01600242323298606273 },
{ /* 47 f= 4700 */ 0.30640286125851695642, 0.01600242323298606273 },
{ /* 48 f= 4800 */ 0.31286893008046173792, 0.01600242323298606273 },
{ /* 49 f= 4900 */ 0.31933164832752197748, 0.01600242323298606273 },
{ /* 50 f= 5000 */ 0.32579094678917747130, 0.01600242323298606273 },
{ /* 51 f= 5100 */ 0.33224675629153094247, 0.01600242323298606273 },
{ /* 52 f= 5200 */ 0.33869900769804922591, 0.01600242323298606273 },
{ /* 53 f= 5300 */ 0.34514763191030339851, 0.01600242323298606273 },
{ /* 54 f= 5400 */ 0.35159255986870902033, 0.01600242323298606273 },
{ /* 55 f= 5500 */ 0.35803372255326532114, 0.01600242323298606273 },
{ /* 56 f= 5600 */ 0.36447105098429494197, 0.01600242323298606273 },
{ /* 57 f= 5700 */ 0.37090447622318184484, 0.01600242323298606273 },
{ /* 58 f= 5800 */ 0.37733392937311044379, 0.01600242323298606273 },
{ /* 59 f= 5900 */ 0.38375934157980284844, 0.01600242323298606273 },
{ /* 60 f= 6000 */ 0.39018064403225649617, 0.01600242323298606273 },
{ /* 61 f= 6100 */ 0.39659776796348089611, 0.01600242323298606273 },
{ /* 62 f= 6200 */ 0.40301064465123426217, 0.01600242323298606273 },
{ /* 63 f= 6300 */ 0.40941920541875920225, 0.01600242323298606273 },
{ /* 64 f= 6400 */ 0.41582338163551862964, 0.01600242323298606273 },
{ /* 65 f= 6500 */ 0.42222310471793028652, 0.01600242323298606273 },
{ /* 66 f= 6600 */ 0.42861830613010154511, 0.01600242323298606273 },
{ /* 67 f= 6700 */ 0.43500891738456293201, 0.01600242323298606273 },
{ /* 68 f= 6800 */ 0.44139487004300215212, 0.01600242323298606273 },
{ /* 69 f= 6900 */ 0.44777609571699672486, 0.01600242323298606273 },
{ /* 70 f= 7000 */ 0.45415252606874645380, 0.01600242323298606273 },
{ /* 71 f= 7100 */ 0.46052409281180473055, 0.01600242323298606273 },
{ /* 72 f= 7200 */ 0.46689072771181078236, 0.01600242323298606273 },
{ /* 73 f= 7300 */ 0.47325236258721975480, 0.01600242323298606273 },
{ /* 74 f= 7400 */ 0.47960892931003307194, 0.01600242323298606273 },
{ /* 75 f= 7500 */ 0.48596035980652774189, 0.01600242323298606273 },
{ /* 76 f= 7600 */ 0.49230658605798605088, 0.01600242323298606273 },
{ /* 77 f= 7700 */ 0.49864754010142336993, 0.01600242323298606273 },
{ /* 78 f= 7800 */ 0.50498315403031590609, 0.01600242323298606273 },
{ /* 79 f= 7900 */ 0.51131335999532878667, 0.01600242323298606273 },
{ /* 80 f= 8000 */ 0.51763809020504147895, 0.01600242323298606273 },
{ /* 81 f= 8100 */ 0.52395727692667493081, 0.01600242323298606273 },
{ /* 82 f= 8200 */ 0.53027085248681604668, 0.01600242323298606273 },
{ /* 83 f= 8300 */ 0.53657874927214277427, 0.01600242323298606273 },
{ /* 84 f= 8400 */ 0.54288089973014852507, 0.01600242323298606273 },
{ /* 85 f= 8500 */ 0.54917723636986470748, 0.01600242323298606273 },
{ /* 86 f= 8600 */ 0.55546769176258437017, 0.01600242323298606273 },
{ /* 87 f= 8700 */ 0.56175219854258418017, 0.01600242323298606273 },
{ /* 88 f= 8800 */ 0.56803068940784517959, 0.01600242323298606273 },
{ /* 89 f= 8900 */ 0.57430309712077465267, 0.01600242323298606273 },
{ /* 90 f= 9000 */ 0.58056935450892466211, 0.01600242323298606273 },
{ /* 91 f= 9100 */ 0.58682939446571336095, 0.01600242323298606273 },
{ /* 92 f= 9200 */ 0.59308314995114197465, 0.01600242323298606273 },
{ /* 93 f= 9300 */ 0.59933055399251322637, 0.01600242323298606273 },
{ /* 94 f= 9400 */ 0.60557153968514920717, 0.01600242323298606273 },
{ /* 95 f= 9500 */ 0.61180604019310691477, 0.01600242323298606273 },
{ /* 96 f= 9600 */ 0.61803398874989479150, 0.01600242323298606273 },
{ /* 97 f= 9700 */ 0.62425531865918737484, 0.01600242323298606273 },
{ /* 98 f= 9800 */ 0.63046996329553928184, 0.01600242323298606273 },
{ /* 99 f= 9900 */ 0.63667785610509941563, 0.01600242323298606273 },
{ /*100 f=10000 */ 0.64287893060632317344, 0.01600242323298606273 },
{ /*101 f=10100 */ 0.64907312039068432163, 0.01600242323298606273 },
{ /*102 f=10200 */ 0.65526035912338698175, 0.01600242323298606273 },
{ /*103 f=10300 */ 0.66144058054407484093, 0.01600242323298606273 },
{ /*104 f=10400 */ 0.66761371846754191672, 0.01600242323298606273 },
{ /*105 f=10500 */ 0.67377970678444010222, 0.01600242323298606273 },
{ /*106 f=10600 */ 0.67993847946198837651, 0.01600242323298606273 },
{ /*107 f=10700 */ 0.68608997054467968368, 0.01600242323298606273 },
{ /*108 f=10800 */ 0.69223411415498592447, 0.01600242323298606273 },
{ /*109 f=10900 */ 0.69837084449406572340, 0.01600242323298606273 },
{ /*110 f=11000 */ 0.70450009584246697791, 0.01600242323298606273 },
{ /*111 f=11100 */ 0.71062180256083218310, 0.01600242323298606273 },
{ /*112 f=11200 */ 0.71673589909060053671, 0.01600242323298606273 },
{ /*113 f=11300 */ 0.72284231995471004417, 0.01600242323298606273 },
{ /*114 f=11400 */ 0.72894099975829929061, 0.01600242323298606273 },
{ /*115 f=11500 */ 0.73503187318940710338, 0.01600242323298606273 },
{ /*116 f=11600 */ 0.74111487501967243663, 0.01600242323298606273 },
{ /*117 f=11700 */ 0.74718994010503270164, 0.01600242323298606273 },
{ /*118 f=11800 */ 0.75325700338642143095, 0.01600242323298606273 },
{ /*119 f=11900 */ 0.75931599989046549837, 0.01600242323298606273 },
{ /*120 f=12000 */ 0.76536686473017956356, 0.01600242323298606273 },
{ /*121 f=12100 */ 0.77140953310566262591, 0.01600242323298606273 },
{ /*122 f=12200 */ 0.77744394030479113678, 0.01600242323298606273 },
{ /*123 f=12300 */ 0.78347002170391177867, 0.01600242323298606273 },
{ /*124 f=12400 */ 0.78948771276853446643, 0.01600242323298606273 },
{ /*125 f=12500 */ 0.79549694905402212886, 0.01600242323298606273 },
{ /*126 f=12600 */ 0.80149766620628193348, 0.01600242323298606273 },
{ /*127 f=12700 */ 0.80748979996245418000, 0.01600242323298606273 },
{ /*128 f=12800 */ 0.81347328615160030552, 0.01600242323298606273 },
{ /*129 f=12900 */ 0.81944806069539055660, 0.01600242323298606273 },
{ /*130 f=13000 */ 0.82541405960878933001, 0.01600242323298606273 },
{ /*131 f=13100 */ 0.83137121900074162362, 0.01600242323298606273 },
{ /*132 f=13200 */ 0.83731947507485626758, 0.01600242323298606273 },
{ /*133 f=13300 */ 0.84325876413008904464, 0.01600242323298606273 },
{ /*134 f=13400 */ 0.84918902256142625440, 0.01600242323298606273 },
{ /*135 f=13500 */ 0.85511018686056416982, 0.01600242323298606273 },
{ /*136 f=13600 */ 0.86102219361659015906, 0.01600242323298606273 },
{ /*137 f=13700 */ 0.86692497951666180889, 0.01600242323298606273 },
{ /*138 f=13800 */ 0.87281848134668404970, 0.01600242323298606273 },
{ /*139 f=13900 */ 0.87870263599198739080, 0.01600242323298606273 },
{ /*140 f=14000 */ 0.88457738043800260286, 0.01600242323298606273 },
{ /*141 f=14100 */ 0.89044265177093639974, 0.01600242323298606273 },
{ /*142 f=14200 */ 0.89629838717844512175, 0.01600242323298606273 },
{ /*143 f=14300 */ 0.90214452395030675369, 0.01600242323298606273 },
{ /*144 f=14400 */ 0.90798099947909349794, 0.01600242323298606273 },
{ /*145 f=14500 */ 0.91380775126084123894, 0.01600242323298606273 },
{ /*146 f=14600 */ 0.91962471689571967381, 0.01600242323298606273 },
{ /*147 f=14700 */ 0.92543183408870022255, 0.01600242323298606273 },
{ /*148 f=14800 */ 0.93122904065022282794, 0.01600242323298606273 },
{ /*149 f=14900 */ 0.93701627449686286653, 0.01600242323298606273 },
{ /*150 f=15000 */ 0.94279347365199528408, 0.01600242323298606273 },
{ /*151 f=15100 */ 0.94856057624645839788, 0.01600242323298606273 },
{ /*152 f=15200 */ 0.95431752051921681090, 0.01600242323298606273 },
{ /*153 f=15300 */ 0.96006424481802221660, 0.01600242323298606273 },
{ /*154 f=15400 */ 0.96580068760007475870, 0.01600242323298606273 },
{ /*155 f=15500 */ 0.97152678743268006123, 0.01600242323298606273 },
{ /*156 f=15600 */ 0.97724248299390981121, 0.01600242323298606273 },
{ /*157 f=15700 */ 0.98294771307325645715, 0.01600242323298606273 },
{ /*158 f=15800 */ 0.98864241657228923987, 0.01600242323298606273 },
{ /*159 f=15900 */ 0.99432653250530855793, 0.01600242323298606273 },
{ /*160 f=16000 */ 0.99999999999999988898, 0.01600242323298606273 },
{ /*161 f=16100 */ 1.00566275829808415843, 0.01600242323298606273 },
{ /*162 f=16200 */ 1.01131474675596910728, 0.01600242323298606273 },
{ /*163 f=16300 */ 1.01695590484539954979, 0.01600242323298606273 },
{ /*164 f=16400 */ 1.02258617215410430035, 0.01600242323298606273 },
{ /*165 f=16500 */ 1.02820548838644332257, 0.01600242323298606273 },
{ /*166 f=16600 */ 1.03381379336405498925, 0.01600242323298606273 },
{ /*167 f=16700 */ 1.03941102702649845746, 0.01600242323298606273 },
{ /*168 f=16800 */ 1.04499712943189759784, 0.01600242323298606273 },
{ /*169 f=16900 */ 1.05057204075758403583, 0.01600242323298606273 },
{ /*170 f=17000 */ 1.05613570130073597397, 0.01600242323298606273 },
{ /*171 f=17100 */ 1.06168805147901901265, 0.01600242323298606273 },
{ /*172 f=17200 */ 1.06722903183122297399, 0.01600242323298606273 },
{ /*173 f=17300 */ 1.07275858301790050220, 0.01600242323298606273 },
{ /*174 f=17400 */ 1.07827664582200033472, 0.01600242323298606273 },
{ /*175 f=17500 */ 1.08378316114950346005, 0.01600242323298606273 },
{ /*176 f=17600 */ 1.08927807003005394648, 0.01600242323298606273 },
{ /*177 f=17700 */ 1.09476131361759310145, 0.01600242323298606273 },
{ /*178 f=17800 */ 1.10023283319098674760, 0.01600242323298606273 },
{ /*179 f=17900 */ 1.10569257015465582938, 0.01600242323298606273 },
{ /*180 f=18000 */ 1.11114046603920435530, 0.01600242323298606273 },
{ /*181 f=18100 */ 1.11657646250204400928, 0.01600242323298606273 },
{ /*182 f=18200 */ 1.12200050132801965042, 0.01600242323298606273 },
{ /*183 f=18300 */ 1.12741252443003325823, 0.01600242323298606273 },
{ /*184 f=18400 */ 1.13281247384966565761, 0.01600242323298606273 },
{ /*185 f=18500 */ 1.13820029175779646735, 0.01600242323298606273 },
{ /*186 f=18600 */ 1.14357592045522449276, 0.01600242323298606273 },
{ /*187 f=18700 */ 1.14893930237328523170, 0.01600242323298606273 },
{ /*188 f=18800 */ 1.15429038007446727043, 0.01600242323298606273 },
{ /*189 f=18900 */ 1.15962909625302712513, 0.01600242323298606273 },
{ /*190 f=19000 */ 1.16495539373560430541, 0.01600242323298606273 },
{ /*191 f=19100 */ 1.17026921548183104882, 0.01600242323298606273 },
{ /*192 f=19200 */ 1.17557050458494627421, 0.01600242323298606273 },
{ /*193 f=19300 */ 1.18085920427240220754, 0.01600242323298606273 },
{ /*194 f=19400 */ 1.18613525790647433844, 0.01600242323298606273 },
{ /*195 f=19500 */ 1.19139860898486671381, 0.01600242323298606273 },
{ /*196 f=19600 */ 1.19664920114131789752, 0.01600242323298606273 },
{ /*197 f=19700 */ 1.20188697814620470972, 0.01600242323298606273 },
{ /*198 f=19800 */ 1.20711188390714285745, 0.01600242323298606273 },
{ /*199 f=19900 */ 1.21232386246958934173, 0.01600242323298606273 },
{ /*200 f=20000 */ 1.21752285801744131177, 0.01600242323298606273 },
{ /*201 f=20100 */ 1.22270881487363292095, 0.01600242323298606273 },
{ /*202 f=20200 */ 1.22788167750073284878, 0.01600242323298606273 },
{ /*203 f=20300 */ 1.23304139050153827029, 0.01600242323298606273 },
{ /*204 f=20400 */ 1.23818789861966793708, 0.01600242323298606273 },
{ /*205 f=20500 */ 1.24332114674015481448, 0.01600242323298606273 },
{ /*206 f=20600 */ 1.24844107989003516579, 0.01600242323298606273 },
{ /*207 f=20700 */ 1.25354764323893919098, 0.01600242323298606273 },
{ /*208 f=20800 */ 1.25864078209967500399, 0.01600242323298606273 },
{ /*209 f=20900 */ 1.26372044192881749503, 0.01600242323298606273 },
{ /*210 f=21000 */ 1.26878656832729097559, 0.01600242323298606273 },
{ /*211 f=21100 */ 1.27383910704095182354, 0.01600242323298606273 },
{ /*212 f=21200 */ 1.27887800396116935175, 0.01600242323298606273 },
{ /*213 f=21300 */ 1.28390320512540601072, 0.01600242323298606273 },
{ /*214 f=21400 */ 1.28891465671779492652, 0.01600242323298606273 },
{ /*215 f=21500 */ 1.29391230506971455227, 0.01600242323298606273 },
{ /*216 f=21600 */ 1.29889609666036731639, 0.01600242323298606273 },
{ /*217 f=21700 */ 1.30386597811734850083, 0.01600242323298606273 },
{ /*218 f=21800 */ 1.30882189621722067052, 0.01600242323298606273 },
{ /*219 f=21900 */ 1.31376379788608255161, 0.01600242323298606273 },
{ /*220 f=22000 */ 1.31869163020013768772, 0.01600242323298606273 },
{ /*221 f=22100 */ 1.32360534038626065367, 0.01600242323298606273 },
{ /*222 f=22200 */ 1.32850487582256349128, 0.01600242323298606273 },
{ /*223 f=22300 */ 1.33339018403895726017, 0.01600242323298606273 },
{ /*224 f=22400 */ 1.33826121271771647514, 0.01600242323298606273 },
{ /*225 f=22500 */ 1.34311790969403666018, 0.01600242323298606273 },
{ /*226 f=22600 */ 1.34796022295659567725, 0.01600242323298606273 },
{ /*227 f=22700 */ 1.35278810064810839364, 0.01600242323298606273 },
{ /*228 f=22800 */ 1.35760149106588334789, 0.01600242323298606273 },
{ /*229 f=22900 */ 1.36240034266237652893, 0.01600242323298606273 },
{ /*230 f=23000 */ 1.36718460404574249090, 0.01600242323298606273 },
{ /*231 f=23100 */ 1.37195422398038568979, 0.01600242323298606273 },
{ /*232 f=23200 */ 1.37670915138750782347, 0.01600242323298606273 },
{ /*233 f=23300 */ 1.38144933534565739208, 0.01600242323298606273 },
{ /*234 f=23400 */ 1.38617472509127170888, 0.01600242323298606273 },
{ /*235 f=23500 */ 1.39088527001922335202, 0.01600242323298606273 },
{ /*236 f=23600 */ 1.39558091968336017707, 0.01600242323298606273 },
{ /*237 f=23700 */ 1.40026162379704732786, 0.01600242323298606273 },
{ /*238 f=23800 */ 1.40492733223370347417, 0.01600242323298606273 },
{ /*239 f=23900 */ 1.40957799502734015817, 0.01600242323298606273 },
{ /*240 f=24000 */ 1.41421356237309492343, 0.01600242323298606273 }
};
static FLOAT_T vsf_q160[241][2] = {
{ /* dummy entry */ 0, 0},
{ /*  1 f=  100 */ 0.00654497301305325026, 0.01267949994500838784 },
{ /*  2 f=  200 */ 0.01308987593470371628, 0.01267949994500838784 },
{ /*  3 f=  300 */ 0.01963463867429923390, 0.01267949994500838784 },
{ /*  4 f=  400 */ 0.02617919114268887903, 0.01267949994500838784 },
{ /*  5 f=  500 */ 0.03272346325297356001, 0.01267949994500838784 },
{ /*  6 f=  600 */ 0.03926738492125660118, 0.01267949994500838784 },
{ /*  7 f=  700 */ 0.04581088606739427971, 0.01267949994500838784 },
{ /*  8 f=  800 */ 0.05235389661574629816, 0.01267949994500838784 },
{ /*  9 f=  900 */ 0.05889634649592632304, 0.01267949994500838784 },
{ /* 10 f= 1000 */ 0.06543816564355227350, 0.01267949994500838784 },
{ /* 11 f= 1100 */ 0.07197928400099674884, 0.01267949994500838784 },
{ /* 12 f= 1200 */ 0.07851963151813722008, 0.01267949994500838784 },
{ /* 13 f= 1300 */ 0.08505913815310624237, 0.01267949994500838784 },
{ /* 14 f= 1400 */ 0.09159773387304154246, 0.01267949994500838784 },
{ /* 15 f= 1500 */ 0.09813534865483602987, 0.01267949994500838784 },
{ /* 16 f= 1600 */ 0.10467191248588765540, 0.01267949994500838784 },
{ /* 17 f= 1700 */ 0.11120735536484922801, 0.01267949994500838784 },
{ /* 18 f= 1800 */ 0.11774160730237806516, 0.01267949994500838784 },
{ /* 19 f= 1900 */ 0.12427459832188544886, 0.01267949994500838784 },
{ /* 20 f= 2000 */ 0.13080625846028612336, 0.01267949994500838784 },
{ /* 21 f= 2100 */ 0.13733651776874752914, 0.01267949994500838784 },
{ /* 22 f= 2200 */ 0.14386530631343877329, 0.01267949994500838784 },
{ /* 23 f= 2300 */ 0.15039255417627980793, 0.01267949994500838784 },
{ /* 24 f= 2400 */ 0.15691819145568988714, 0.01267949994500838784 },
{ /* 25 f= 2500 */ 0.16344214826733644008, 0.01267949994500838784 },
{ /* 26 f= 2600 */ 0.16996435474488333361, 0.01267949994500838784 },
{ /* 27 f= 2700 */ 0.17648474104073902380, 0.01267949994500838784 },
{ /* 28 f= 2800 */ 0.18300323732680476296, 0.01267949994500838784 },
{ /* 29 f= 2900 */ 0.18951977379522222389, 0.01267949994500838784 },
{ /* 30 f= 3000 */ 0.19603428065912120726, 0.01267949994500838784 },
{ /* 31 f= 3100 */ 0.20254668815336684951, 0.01267949994500838784 },
{ /* 32 f= 3200 */ 0.20905692653530691394, 0.01267949994500838784 },
{ /* 33 f= 3300 */ 0.21556492608551869328, 0.01267949994500838784 },
{ /* 34 f= 3400 */ 0.22207061710855535708, 0.01267949994500838784 },
{ /* 35 f= 3500 */ 0.22857392993369279877, 0.01267949994500838784 },
{ /* 36 f= 3600 */ 0.23507479491567528918, 0.01267949994500838784 },
{ /* 37 f= 3700 */ 0.24157314243546165744, 0.01267949994500838784 },
{ /* 38 f= 3800 */ 0.24806890290097063922, 0.01267949994500838784 },
{ /* 39 f= 3900 */ 0.25456200674782641924, 0.01267949994500838784 },
{ /* 40 f= 4000 */ 0.26105238444010314680, 0.01267949994500838784 },
{ /* 41 f= 4100 */ 0.26753996647107025630, 0.01267949994500838784 },
{ /* 42 f= 4200 */ 0.27402468336393603909, 0.01267949994500838784 },
{ /* 43 f= 4300 */ 0.28050646567259251984, 0.01267949994500838784 },
{ /* 44 f= 4400 */ 0.28698524398235858435, 0.01267949994500838784 },
{ /* 45 f= 4500 */ 0.29346094891072349586, 0.01267949994500838784 },
{ /* 46 f= 4600 */ 0.29993351110809002291, 0.01267949994500838784 },
{ /* 47 f= 4700 */ 0.30640286125851695642, 0.01267949994500838784 },
{ /* 48 f= 4800 */ 0.31286893008046173792, 0.01267949994500838784 },
{ /* 49 f= 4900 */ 0.31933164832752197748, 0.01267949994500838784 },
{ /* 50 f= 5000 */ 0.32579094678917747130, 0.01267949994500838784 },
{ /* 51 f= 5100 */ 0.33224675629153094247, 0.01267949994500838784 },
{ /* 52 f= 5200 */ 0.33869900769804922591, 0.01267949994500838784 },
{ /* 53 f= 5300 */ 0.34514763191030339851, 0.01267949994500838784 },
{ /* 54 f= 5400 */ 0.35159255986870902033, 0.01267949994500838784 },
{ /* 55 f= 5500 */ 0.35803372255326532114, 0.01267949994500838784 },
{ /* 56 f= 5600 */ 0.36447105098429494197, 0.01267949994500838784 },
{ /* 57 f= 5700 */ 0.37090447622318184484, 0.01267949994500838784 },
{ /* 58 f= 5800 */ 0.37733392937311044379, 0.01267949994500838784 },
{ /* 59 f= 5900 */ 0.38375934157980284844, 0.01267949994500838784 },
{ /* 60 f= 6000 */ 0.39018064403225649617, 0.01267949994500838784 },
{ /* 61 f= 6100 */ 0.39659776796348089611, 0.01267949994500838784 },
{ /* 62 f= 6200 */ 0.40301064465123426217, 0.01267949994500838784 },
{ /* 63 f= 6300 */ 0.40941920541875920225, 0.01267949994500838784 },
{ /* 64 f= 6400 */ 0.41582338163551862964, 0.01267949994500838784 },
{ /* 65 f= 6500 */ 0.42222310471793028652, 0.01267949994500838784 },
{ /* 66 f= 6600 */ 0.42861830613010154511, 0.01267949994500838784 },
{ /* 67 f= 6700 */ 0.43500891738456293201, 0.01267949994500838784 },
{ /* 68 f= 6800 */ 0.44139487004300215212, 0.01267949994500838784 },
{ /* 69 f= 6900 */ 0.44777609571699672486, 0.01267949994500838784 },
{ /* 70 f= 7000 */ 0.45415252606874645380, 0.01267949994500838784 },
{ /* 71 f= 7100 */ 0.46052409281180473055, 0.01267949994500838784 },
{ /* 72 f= 7200 */ 0.46689072771181078236, 0.01267949994500838784 },
{ /* 73 f= 7300 */ 0.47325236258721975480, 0.01267949994500838784 },
{ /* 74 f= 7400 */ 0.47960892931003307194, 0.01267949994500838784 },
{ /* 75 f= 7500 */ 0.48596035980652774189, 0.01267949994500838784 },
{ /* 76 f= 7600 */ 0.49230658605798605088, 0.01267949994500838784 },
{ /* 77 f= 7700 */ 0.49864754010142336993, 0.01267949994500838784 },
{ /* 78 f= 7800 */ 0.50498315403031590609, 0.01267949994500838784 },
{ /* 79 f= 7900 */ 0.51131335999532878667, 0.01267949994500838784 },
{ /* 80 f= 8000 */ 0.51763809020504147895, 0.01267949994500838784 },
{ /* 81 f= 8100 */ 0.52395727692667493081, 0.01267949994500838784 },
{ /* 82 f= 8200 */ 0.53027085248681604668, 0.01267949994500838784 },
{ /* 83 f= 8300 */ 0.53657874927214277427, 0.01267949994500838784 },
{ /* 84 f= 8400 */ 0.54288089973014852507, 0.01267949994500838784 },
{ /* 85 f= 8500 */ 0.54917723636986470748, 0.01267949994500838784 },
{ /* 86 f= 8600 */ 0.55546769176258437017, 0.01267949994500838784 },
{ /* 87 f= 8700 */ 0.56175219854258418017, 0.01267949994500838784 },
{ /* 88 f= 8800 */ 0.56803068940784517959, 0.01267949994500838784 },
{ /* 89 f= 8900 */ 0.57430309712077465267, 0.01267949994500838784 },
{ /* 90 f= 9000 */ 0.58056935450892466211, 0.01267949994500838784 },
{ /* 91 f= 9100 */ 0.58682939446571336095, 0.01267949994500838784 },
{ /* 92 f= 9200 */ 0.59308314995114197465, 0.01267949994500838784 },
{ /* 93 f= 9300 */ 0.59933055399251322637, 0.01267949994500838784 },
{ /* 94 f= 9400 */ 0.60557153968514920717, 0.01267949994500838784 },
{ /* 95 f= 9500 */ 0.61180604019310691477, 0.01267949994500838784 },
{ /* 96 f= 9600 */ 0.61803398874989479150, 0.01267949994500838784 },
{ /* 97 f= 9700 */ 0.62425531865918737484, 0.01267949994500838784 },
{ /* 98 f= 9800 */ 0.63046996329553928184, 0.01267949994500838784 },
{ /* 99 f= 9900 */ 0.63667785610509941563, 0.01267949994500838784 },
{ /*100 f=10000 */ 0.64287893060632317344, 0.01267949994500838784 },
{ /*101 f=10100 */ 0.64907312039068432163, 0.01267949994500838784 },
{ /*102 f=10200 */ 0.65526035912338698175, 0.01267949994500838784 },
{ /*103 f=10300 */ 0.66144058054407484093, 0.01267949994500838784 },
{ /*104 f=10400 */ 0.66761371846754191672, 0.01267949994500838784 },
{ /*105 f=10500 */ 0.67377970678444010222, 0.01267949994500838784 },
{ /*106 f=10600 */ 0.67993847946198837651, 0.01267949994500838784 },
{ /*107 f=10700 */ 0.68608997054467968368, 0.01267949994500838784 },
{ /*108 f=10800 */ 0.69223411415498592447, 0.01267949994500838784 },
{ /*109 f=10900 */ 0.69837084449406572340, 0.01267949994500838784 },
{ /*110 f=11000 */ 0.70450009584246697791, 0.01267949994500838784 },
{ /*111 f=11100 */ 0.71062180256083218310, 0.01267949994500838784 },
{ /*112 f=11200 */ 0.71673589909060053671, 0.01267949994500838784 },
{ /*113 f=11300 */ 0.72284231995471004417, 0.01267949994500838784 },
{ /*114 f=11400 */ 0.72894099975829929061, 0.01267949994500838784 },
{ /*115 f=11500 */ 0.73503187318940710338, 0.01267949994500838784 },
{ /*116 f=11600 */ 0.74111487501967243663, 0.01267949994500838784 },
{ /*117 f=11700 */ 0.74718994010503270164, 0.01267949994500838784 },
{ /*118 f=11800 */ 0.75325700338642143095, 0.01267949994500838784 },
{ /*119 f=11900 */ 0.75931599989046549837, 0.01267949994500838784 },
{ /*120 f=12000 */ 0.76536686473017956356, 0.01267949994500838784 },
{ /*121 f=12100 */ 0.77140953310566262591, 0.01267949994500838784 },
{ /*122 f=12200 */ 0.77744394030479113678, 0.01267949994500838784 },
{ /*123 f=12300 */ 0.78347002170391177867, 0.01267949994500838784 },
{ /*124 f=12400 */ 0.78948771276853446643, 0.01267949994500838784 },
{ /*125 f=12500 */ 0.79549694905402212886, 0.01267949994500838784 },
{ /*126 f=12600 */ 0.80149766620628193348, 0.01267949994500838784 },
{ /*127 f=12700 */ 0.80748979996245418000, 0.01267949994500838784 },
{ /*128 f=12800 */ 0.81347328615160030552, 0.01267949994500838784 },
{ /*129 f=12900 */ 0.81944806069539055660, 0.01267949994500838784 },
{ /*130 f=13000 */ 0.82541405960878933001, 0.01267949994500838784 },
{ /*131 f=13100 */ 0.83137121900074162362, 0.01267949994500838784 },
{ /*132 f=13200 */ 0.83731947507485626758, 0.01267949994500838784 },
{ /*133 f=13300 */ 0.84325876413008904464, 0.01267949994500838784 },
{ /*134 f=13400 */ 0.84918902256142625440, 0.01267949994500838784 },
{ /*135 f=13500 */ 0.85511018686056416982, 0.01267949994500838784 },
{ /*136 f=13600 */ 0.86102219361659015906, 0.01267949994500838784 },
{ /*137 f=13700 */ 0.86692497951666180889, 0.01267949994500838784 },
{ /*138 f=13800 */ 0.87281848134668404970, 0.01267949994500838784 },
{ /*139 f=13900 */ 0.87870263599198739080, 0.01267949994500838784 },
{ /*140 f=14000 */ 0.88457738043800260286, 0.01267949994500838784 },
{ /*141 f=14100 */ 0.89044265177093639974, 0.01267949994500838784 },
{ /*142 f=14200 */ 0.89629838717844512175, 0.01267949994500838784 },
{ /*143 f=14300 */ 0.90214452395030675369, 0.01267949994500838784 },
{ /*144 f=14400 */ 0.90798099947909349794, 0.01267949994500838784 },
{ /*145 f=14500 */ 0.91380775126084123894, 0.01267949994500838784 },
{ /*146 f=14600 */ 0.91962471689571967381, 0.01267949994500838784 },
{ /*147 f=14700 */ 0.92543183408870022255, 0.01267949994500838784 },
{ /*148 f=14800 */ 0.93122904065022282794, 0.01267949994500838784 },
{ /*149 f=14900 */ 0.93701627449686286653, 0.01267949994500838784 },
{ /*150 f=15000 */ 0.94279347365199528408, 0.01267949994500838784 },
{ /*151 f=15100 */ 0.94856057624645839788, 0.01267949994500838784 },
{ /*152 f=15200 */ 0.95431752051921681090, 0.01267949994500838784 },
{ /*153 f=15300 */ 0.96006424481802221660, 0.01267949994500838784 },
{ /*154 f=15400 */ 0.96580068760007475870, 0.01267949994500838784 },
{ /*155 f=15500 */ 0.97152678743268006123, 0.01267949994500838784 },
{ /*156 f=15600 */ 0.97724248299390981121, 0.01267949994500838784 },
{ /*157 f=15700 */ 0.98294771307325645715, 0.01267949994500838784 },
{ /*158 f=15800 */ 0.98864241657228923987, 0.01267949994500838784 },
{ /*159 f=15900 */ 0.99432653250530855793, 0.01267949994500838784 },
{ /*160 f=16000 */ 0.99999999999999988898, 0.01267949994500838784 },
{ /*161 f=16100 */ 1.00566275829808415843, 0.01267949994500838784 },
{ /*162 f=16200 */ 1.01131474675596910728, 0.01267949994500838784 },
{ /*163 f=16300 */ 1.01695590484539954979, 0.01267949994500838784 },
{ /*164 f=16400 */ 1.02258617215410430035, 0.01267949994500838784 },
{ /*165 f=16500 */ 1.02820548838644332257, 0.01267949994500838784 },
{ /*166 f=16600 */ 1.03381379336405498925, 0.01267949994500838784 },
{ /*167 f=16700 */ 1.03941102702649845746, 0.01267949994500838784 },
{ /*168 f=16800 */ 1.04499712943189759784, 0.01267949994500838784 },
{ /*169 f=16900 */ 1.05057204075758403583, 0.01267949994500838784 },
{ /*170 f=17000 */ 1.05613570130073597397, 0.01267949994500838784 },
{ /*171 f=17100 */ 1.06168805147901901265, 0.01267949994500838784 },
{ /*172 f=17200 */ 1.06722903183122297399, 0.01267949994500838784 },
{ /*173 f=17300 */ 1.07275858301790050220, 0.01267949994500838784 },
{ /*174 f=17400 */ 1.07827664582200033472, 0.01267949994500838784 },
{ /*175 f=17500 */ 1.08378316114950346005, 0.01267949994500838784 },
{ /*176 f=17600 */ 1.08927807003005394648, 0.01267949994500838784 },
{ /*177 f=17700 */ 1.09476131361759310145, 0.01267949994500838784 },
{ /*178 f=17800 */ 1.10023283319098674760, 0.01267949994500838784 },
{ /*179 f=17900 */ 1.10569257015465582938, 0.01267949994500838784 },
{ /*180 f=18000 */ 1.11114046603920435530, 0.01267949994500838784 },
{ /*181 f=18100 */ 1.11657646250204400928, 0.01267949994500838784 },
{ /*182 f=18200 */ 1.12200050132801965042, 0.01267949994500838784 },
{ /*183 f=18300 */ 1.12741252443003325823, 0.01267949994500838784 },
{ /*184 f=18400 */ 1.13281247384966565761, 0.01267949994500838784 },
{ /*185 f=18500 */ 1.13820029175779646735, 0.01267949994500838784 },
{ /*186 f=18600 */ 1.14357592045522449276, 0.01267949994500838784 },
{ /*187 f=18700 */ 1.14893930237328523170, 0.01267949994500838784 },
{ /*188 f=18800 */ 1.15429038007446727043, 0.01267949994500838784 },
{ /*189 f=18900 */ 1.15962909625302712513, 0.01267949994500838784 },
{ /*190 f=19000 */ 1.16495539373560430541, 0.01267949994500838784 },
{ /*191 f=19100 */ 1.17026921548183104882, 0.01267949994500838784 },
{ /*192 f=19200 */ 1.17557050458494627421, 0.01267949994500838784 },
{ /*193 f=19300 */ 1.18085920427240220754, 0.01267949994500838784 },
{ /*194 f=19400 */ 1.18613525790647433844, 0.01267949994500838784 },
{ /*195 f=19500 */ 1.19139860898486671381, 0.01267949994500838784 },
{ /*196 f=19600 */ 1.19664920114131789752, 0.01267949994500838784 },
{ /*197 f=19700 */ 1.20188697814620470972, 0.01267949994500838784 },
{ /*198 f=19800 */ 1.20711188390714285745, 0.01267949994500838784 },
{ /*199 f=19900 */ 1.21232386246958934173, 0.01267949994500838784 },
{ /*200 f=20000 */ 1.21752285801744131177, 0.01267949994500838784 },
{ /*201 f=20100 */ 1.22270881487363292095, 0.01267949994500838784 },
{ /*202 f=20200 */ 1.22788167750073284878, 0.01267949994500838784 },
{ /*203 f=20300 */ 1.23304139050153827029, 0.01267949994500838784 },
{ /*204 f=20400 */ 1.23818789861966793708, 0.01267949994500838784 },
{ /*205 f=20500 */ 1.24332114674015481448, 0.01267949994500838784 },
{ /*206 f=20600 */ 1.24844107989003516579, 0.01267949994500838784 },
{ /*207 f=20700 */ 1.25354764323893919098, 0.01267949994500838784 },
{ /*208 f=20800 */ 1.25864078209967500399, 0.01267949994500838784 },
{ /*209 f=20900 */ 1.26372044192881749503, 0.01267949994500838784 },
{ /*210 f=21000 */ 1.26878656832729097559, 0.01267949994500838784 },
{ /*211 f=21100 */ 1.27383910704095182354, 0.01267949994500838784 },
{ /*212 f=21200 */ 1.27887800396116935175, 0.01267949994500838784 },
{ /*213 f=21300 */ 1.28390320512540601072, 0.01267949994500838784 },
{ /*214 f=21400 */ 1.28891465671779492652, 0.01267949994500838784 },
{ /*215 f=21500 */ 1.29391230506971455227, 0.01267949994500838784 },
{ /*216 f=21600 */ 1.29889609666036731639, 0.01267949994500838784 },
{ /*217 f=21700 */ 1.30386597811734850083, 0.01267949994500838784 },
{ /*218 f=21800 */ 1.30882189621722067052, 0.01267949994500838784 },
{ /*219 f=21900 */ 1.31376379788608255161, 0.01267949994500838784 },
{ /*220 f=22000 */ 1.31869163020013768772, 0.01267949994500838784 },
{ /*221 f=22100 */ 1.32360534038626065367, 0.01267949994500838784 },
{ /*222 f=22200 */ 1.32850487582256349128, 0.01267949994500838784 },
{ /*223 f=22300 */ 1.33339018403895726017, 0.01267949994500838784 },
{ /*224 f=22400 */ 1.33826121271771647514, 0.01267949994500838784 },
{ /*225 f=22500 */ 1.34311790969403666018, 0.01267949994500838784 },
{ /*226 f=22600 */ 1.34796022295659567725, 0.01267949994500838784 },
{ /*227 f=22700 */ 1.35278810064810839364, 0.01267949994500838784 },
{ /*228 f=22800 */ 1.35760149106588334789, 0.01267949994500838784 },
{ /*229 f=22900 */ 1.36240034266237652893, 0.01267949994500838784 },
{ /*230 f=23000 */ 1.36718460404574249090, 0.01267949994500838784 },
{ /*231 f=23100 */ 1.37195422398038568979, 0.01267949994500838784 },
{ /*232 f=23200 */ 1.37670915138750782347, 0.01267949994500838784 },
{ /*233 f=23300 */ 1.38144933534565739208, 0.01267949994500838784 },
{ /*234 f=23400 */ 1.38617472509127170888, 0.01267949994500838784 },
{ /*235 f=23500 */ 1.39088527001922335202, 0.01267949994500838784 },
{ /*236 f=23600 */ 1.39558091968336017707, 0.01267949994500838784 },
{ /*237 f=23700 */ 1.40026162379704732786, 0.01267949994500838784 },
{ /*238 f=23800 */ 1.40492733223370347417, 0.01267949994500838784 },
{ /*239 f=23900 */ 1.40957799502734015817, 0.01267949994500838784 },
{ /*240 f=24000 */ 1.41421356237309492343, 0.01267949994500838784 }
};
static FLOAT_T vsf_q170[241][2] = {
{ /* dummy entry */ 0, 0},
{ /*  1 f=  100 */ 0.00654497301305325026, 0.01005183697391776043 },
{ /*  2 f=  200 */ 0.01308987593470371628, 0.01005183697391776043 },
{ /*  3 f=  300 */ 0.01963463867429923390, 0.01005183697391776043 },
{ /*  4 f=  400 */ 0.02617919114268887903, 0.01005183697391776043 },
{ /*  5 f=  500 */ 0.03272346325297356001, 0.01005183697391776043 },
{ /*  6 f=  600 */ 0.03926738492125660118, 0.01005183697391776043 },
{ /*  7 f=  700 */ 0.04581088606739427971, 0.01005183697391776043 },
{ /*  8 f=  800 */ 0.05235389661574629816, 0.01005183697391776043 },
{ /*  9 f=  900 */ 0.05889634649592632304, 0.01005183697391776043 },
{ /* 10 f= 1000 */ 0.06543816564355227350, 0.01005183697391776043 },
{ /* 11 f= 1100 */ 0.07197928400099674884, 0.01005183697391776043 },
{ /* 12 f= 1200 */ 0.07851963151813722008, 0.01005183697391776043 },
{ /* 13 f= 1300 */ 0.08505913815310624237, 0.01005183697391776043 },
{ /* 14 f= 1400 */ 0.09159773387304154246, 0.01005183697391776043 },
{ /* 15 f= 1500 */ 0.09813534865483602987, 0.01005183697391776043 },
{ /* 16 f= 1600 */ 0.10467191248588765540, 0.01005183697391776043 },
{ /* 17 f= 1700 */ 0.11120735536484922801, 0.01005183697391776043 },
{ /* 18 f= 1800 */ 0.11774160730237806516, 0.01005183697391776043 },
{ /* 19 f= 1900 */ 0.12427459832188544886, 0.01005183697391776043 },
{ /* 20 f= 2000 */ 0.13080625846028612336, 0.01005183697391776043 },
{ /* 21 f= 2100 */ 0.13733651776874752914, 0.01005183697391776043 },
{ /* 22 f= 2200 */ 0.14386530631343877329, 0.01005183697391776043 },
{ /* 23 f= 2300 */ 0.15039255417627980793, 0.01005183697391776043 },
{ /* 24 f= 2400 */ 0.15691819145568988714, 0.01005183697391776043 },
{ /* 25 f= 2500 */ 0.16344214826733644008, 0.01005183697391776043 },
{ /* 26 f= 2600 */ 0.16996435474488333361, 0.01005183697391776043 },
{ /* 27 f= 2700 */ 0.17648474104073902380, 0.01005183697391776043 },
{ /* 28 f= 2800 */ 0.18300323732680476296, 0.01005183697391776043 },
{ /* 29 f= 2900 */ 0.18951977379522222389, 0.01005183697391776043 },
{ /* 30 f= 3000 */ 0.19603428065912120726, 0.01005183697391776043 },
{ /* 31 f= 3100 */ 0.20254668815336684951, 0.01005183697391776043 },
{ /* 32 f= 3200 */ 0.20905692653530691394, 0.01005183697391776043 },
{ /* 33 f= 3300 */ 0.21556492608551869328, 0.01005183697391776043 },
{ /* 34 f= 3400 */ 0.22207061710855535708, 0.01005183697391776043 },
{ /* 35 f= 3500 */ 0.22857392993369279877, 0.01005183697391776043 },
{ /* 36 f= 3600 */ 0.23507479491567528918, 0.01005183697391776043 },
{ /* 37 f= 3700 */ 0.24157314243546165744, 0.01005183697391776043 },
{ /* 38 f= 3800 */ 0.24806890290097063922, 0.01005183697391776043 },
{ /* 39 f= 3900 */ 0.25456200674782641924, 0.01005183697391776043 },
{ /* 40 f= 4000 */ 0.26105238444010314680, 0.01005183697391776043 },
{ /* 41 f= 4100 */ 0.26753996647107025630, 0.01005183697391776043 },
{ /* 42 f= 4200 */ 0.27402468336393603909, 0.01005183697391776043 },
{ /* 43 f= 4300 */ 0.28050646567259251984, 0.01005183697391776043 },
{ /* 44 f= 4400 */ 0.28698524398235858435, 0.01005183697391776043 },
{ /* 45 f= 4500 */ 0.29346094891072349586, 0.01005183697391776043 },
{ /* 46 f= 4600 */ 0.29993351110809002291, 0.01005183697391776043 },
{ /* 47 f= 4700 */ 0.30640286125851695642, 0.01005183697391776043 },
{ /* 48 f= 4800 */ 0.31286893008046173792, 0.01005183697391776043 },
{ /* 49 f= 4900 */ 0.31933164832752197748, 0.01005183697391776043 },
{ /* 50 f= 5000 */ 0.32579094678917747130, 0.01005183697391776043 },
{ /* 51 f= 5100 */ 0.33224675629153094247, 0.01005183697391776043 },
{ /* 52 f= 5200 */ 0.33869900769804922591, 0.01005183697391776043 },
{ /* 53 f= 5300 */ 0.34514763191030339851, 0.01005183697391776043 },
{ /* 54 f= 5400 */ 0.35159255986870902033, 0.01005183697391776043 },
{ /* 55 f= 5500 */ 0.35803372255326532114, 0.01005183697391776043 },
{ /* 56 f= 5600 */ 0.36447105098429494197, 0.01005183697391776043 },
{ /* 57 f= 5700 */ 0.37090447622318184484, 0.01005183697391776043 },
{ /* 58 f= 5800 */ 0.37733392937311044379, 0.01005183697391776043 },
{ /* 59 f= 5900 */ 0.38375934157980284844, 0.01005183697391776043 },
{ /* 60 f= 6000 */ 0.39018064403225649617, 0.01005183697391776043 },
{ /* 61 f= 6100 */ 0.39659776796348089611, 0.01005183697391776043 },
{ /* 62 f= 6200 */ 0.40301064465123426217, 0.01005183697391776043 },
{ /* 63 f= 6300 */ 0.40941920541875920225, 0.01005183697391776043 },
{ /* 64 f= 6400 */ 0.41582338163551862964, 0.01005183697391776043 },
{ /* 65 f= 6500 */ 0.42222310471793028652, 0.01005183697391776043 },
{ /* 66 f= 6600 */ 0.42861830613010154511, 0.01005183697391776043 },
{ /* 67 f= 6700 */ 0.43500891738456293201, 0.01005183697391776043 },
{ /* 68 f= 6800 */ 0.44139487004300215212, 0.01005183697391776043 },
{ /* 69 f= 6900 */ 0.44777609571699672486, 0.01005183697391776043 },
{ /* 70 f= 7000 */ 0.45415252606874645380, 0.01005183697391776043 },
{ /* 71 f= 7100 */ 0.46052409281180473055, 0.01005183697391776043 },
{ /* 72 f= 7200 */ 0.46689072771181078236, 0.01005183697391776043 },
{ /* 73 f= 7300 */ 0.47325236258721975480, 0.01005183697391776043 },
{ /* 74 f= 7400 */ 0.47960892931003307194, 0.01005183697391776043 },
{ /* 75 f= 7500 */ 0.48596035980652774189, 0.01005183697391776043 },
{ /* 76 f= 7600 */ 0.49230658605798605088, 0.01005183697391776043 },
{ /* 77 f= 7700 */ 0.49864754010142336993, 0.01005183697391776043 },
{ /* 78 f= 7800 */ 0.50498315403031590609, 0.01005183697391776043 },
{ /* 79 f= 7900 */ 0.51131335999532878667, 0.01005183697391776043 },
{ /* 80 f= 8000 */ 0.51763809020504147895, 0.01005183697391776043 },
{ /* 81 f= 8100 */ 0.52395727692667493081, 0.01005183697391776043 },
{ /* 82 f= 8200 */ 0.53027085248681604668, 0.01005183697391776043 },
{ /* 83 f= 8300 */ 0.53657874927214277427, 0.01005183697391776043 },
{ /* 84 f= 8400 */ 0.54288089973014852507, 0.01005183697391776043 },
{ /* 85 f= 8500 */ 0.54917723636986470748, 0.01005183697391776043 },
{ /* 86 f= 8600 */ 0.55546769176258437017, 0.01005183697391776043 },
{ /* 87 f= 8700 */ 0.56175219854258418017, 0.01005183697391776043 },
{ /* 88 f= 8800 */ 0.56803068940784517959, 0.01005183697391776043 },
{ /* 89 f= 8900 */ 0.57430309712077465267, 0.01005183697391776043 },
{ /* 90 f= 9000 */ 0.58056935450892466211, 0.01005183697391776043 },
{ /* 91 f= 9100 */ 0.58682939446571336095, 0.01005183697391776043 },
{ /* 92 f= 9200 */ 0.59308314995114197465, 0.01005183697391776043 },
{ /* 93 f= 9300 */ 0.59933055399251322637, 0.01005183697391776043 },
{ /* 94 f= 9400 */ 0.60557153968514920717, 0.01005183697391776043 },
{ /* 95 f= 9500 */ 0.61180604019310691477, 0.01005183697391776043 },
{ /* 96 f= 9600 */ 0.61803398874989479150, 0.01005183697391776043 },
{ /* 97 f= 9700 */ 0.62425531865918737484, 0.01005183697391776043 },
{ /* 98 f= 9800 */ 0.63046996329553928184, 0.01005183697391776043 },
{ /* 99 f= 9900 */ 0.63667785610509941563, 0.01005183697391776043 },
{ /*100 f=10000 */ 0.64287893060632317344, 0.01005183697391776043 },
{ /*101 f=10100 */ 0.64907312039068432163, 0.01005183697391776043 },
{ /*102 f=10200 */ 0.65526035912338698175, 0.01005183697391776043 },
{ /*103 f=10300 */ 0.66144058054407484093, 0.01005183697391776043 },
{ /*104 f=10400 */ 0.66761371846754191672, 0.01005183697391776043 },
{ /*105 f=10500 */ 0.67377970678444010222, 0.01005183697391776043 },
{ /*106 f=10600 */ 0.67993847946198837651, 0.01005183697391776043 },
{ /*107 f=10700 */ 0.68608997054467968368, 0.01005183697391776043 },
{ /*108 f=10800 */ 0.69223411415498592447, 0.01005183697391776043 },
{ /*109 f=10900 */ 0.69837084449406572340, 0.01005183697391776043 },
{ /*110 f=11000 */ 0.70450009584246697791, 0.01005183697391776043 },
{ /*111 f=11100 */ 0.71062180256083218310, 0.01005183697391776043 },
{ /*112 f=11200 */ 0.71673589909060053671, 0.01005183697391776043 },
{ /*113 f=11300 */ 0.72284231995471004417, 0.01005183697391776043 },
{ /*114 f=11400 */ 0.72894099975829929061, 0.01005183697391776043 },
{ /*115 f=11500 */ 0.73503187318940710338, 0.01005183697391776043 },
{ /*116 f=11600 */ 0.74111487501967243663, 0.01005183697391776043 },
{ /*117 f=11700 */ 0.74718994010503270164, 0.01005183697391776043 },
{ /*118 f=11800 */ 0.75325700338642143095, 0.01005183697391776043 },
{ /*119 f=11900 */ 0.75931599989046549837, 0.01005183697391776043 },
{ /*120 f=12000 */ 0.76536686473017956356, 0.01005183697391776043 },
{ /*121 f=12100 */ 0.77140953310566262591, 0.01005183697391776043 },
{ /*122 f=12200 */ 0.77744394030479113678, 0.01005183697391776043 },
{ /*123 f=12300 */ 0.78347002170391177867, 0.01005183697391776043 },
{ /*124 f=12400 */ 0.78948771276853446643, 0.01005183697391776043 },
{ /*125 f=12500 */ 0.79549694905402212886, 0.01005183697391776043 },
{ /*126 f=12600 */ 0.80149766620628193348, 0.01005183697391776043 },
{ /*127 f=12700 */ 0.80748979996245418000, 0.01005183697391776043 },
{ /*128 f=12800 */ 0.81347328615160030552, 0.01005183697391776043 },
{ /*129 f=12900 */ 0.81944806069539055660, 0.01005183697391776043 },
{ /*130 f=13000 */ 0.82541405960878933001, 0.01005183697391776043 },
{ /*131 f=13100 */ 0.83137121900074162362, 0.01005183697391776043 },
{ /*132 f=13200 */ 0.83731947507485626758, 0.01005183697391776043 },
{ /*133 f=13300 */ 0.84325876413008904464, 0.01005183697391776043 },
{ /*134 f=13400 */ 0.84918902256142625440, 0.01005183697391776043 },
{ /*135 f=13500 */ 0.85511018686056416982, 0.01005183697391776043 },
{ /*136 f=13600 */ 0.86102219361659015906, 0.01005183697391776043 },
{ /*137 f=13700 */ 0.86692497951666180889, 0.01005183697391776043 },
{ /*138 f=13800 */ 0.87281848134668404970, 0.01005183697391776043 },
{ /*139 f=13900 */ 0.87870263599198739080, 0.01005183697391776043 },
{ /*140 f=14000 */ 0.88457738043800260286, 0.01005183697391776043 },
{ /*141 f=14100 */ 0.89044265177093639974, 0.01005183697391776043 },
{ /*142 f=14200 */ 0.89629838717844512175, 0.01005183697391776043 },
{ /*143 f=14300 */ 0.90214452395030675369, 0.01005183697391776043 },
{ /*144 f=14400 */ 0.90798099947909349794, 0.01005183697391776043 },
{ /*145 f=14500 */ 0.91380775126084123894, 0.01005183697391776043 },
{ /*146 f=14600 */ 0.91962471689571967381, 0.01005183697391776043 },
{ /*147 f=14700 */ 0.92543183408870022255, 0.01005183697391776043 },
{ /*148 f=14800 */ 0.93122904065022282794, 0.01005183697391776043 },
{ /*149 f=14900 */ 0.93701627449686286653, 0.01005183697391776043 },
{ /*150 f=15000 */ 0.94279347365199528408, 0.01005183697391776043 },
{ /*151 f=15100 */ 0.94856057624645839788, 0.01005183697391776043 },
{ /*152 f=15200 */ 0.95431752051921681090, 0.01005183697391776043 },
{ /*153 f=15300 */ 0.96006424481802221660, 0.01005183697391776043 },
{ /*154 f=15400 */ 0.96580068760007475870, 0.01005183697391776043 },
{ /*155 f=15500 */ 0.97152678743268006123, 0.01005183697391776043 },
{ /*156 f=15600 */ 0.97724248299390981121, 0.01005183697391776043 },
{ /*157 f=15700 */ 0.98294771307325645715, 0.01005183697391776043 },
{ /*158 f=15800 */ 0.98864241657228923987, 0.01005183697391776043 },
{ /*159 f=15900 */ 0.99432653250530855793, 0.01005183697391776043 },
{ /*160 f=16000 */ 0.99999999999999988898, 0.01005183697391776043 },
{ /*161 f=16100 */ 1.00566275829808415843, 0.01005183697391776043 },
{ /*162 f=16200 */ 1.01131474675596910728, 0.01005183697391776043 },
{ /*163 f=16300 */ 1.01695590484539954979, 0.01005183697391776043 },
{ /*164 f=16400 */ 1.02258617215410430035, 0.01005183697391776043 },
{ /*165 f=16500 */ 1.02820548838644332257, 0.01005183697391776043 },
{ /*166 f=16600 */ 1.03381379336405498925, 0.01005183697391776043 },
{ /*167 f=16700 */ 1.03941102702649845746, 0.01005183697391776043 },
{ /*168 f=16800 */ 1.04499712943189759784, 0.01005183697391776043 },
{ /*169 f=16900 */ 1.05057204075758403583, 0.01005183697391776043 },
{ /*170 f=17000 */ 1.05613570130073597397, 0.01005183697391776043 },
{ /*171 f=17100 */ 1.06168805147901901265, 0.01005183697391776043 },
{ /*172 f=17200 */ 1.06722903183122297399, 0.01005183697391776043 },
{ /*173 f=17300 */ 1.07275858301790050220, 0.01005183697391776043 },
{ /*174 f=17400 */ 1.07827664582200033472, 0.01005183697391776043 },
{ /*175 f=17500 */ 1.08378316114950346005, 0.01005183697391776043 },
{ /*176 f=17600 */ 1.08927807003005394648, 0.01005183697391776043 },
{ /*177 f=17700 */ 1.09476131361759310145, 0.01005183697391776043 },
{ /*178 f=17800 */ 1.10023283319098674760, 0.01005183697391776043 },
{ /*179 f=17900 */ 1.10569257015465582938, 0.01005183697391776043 },
{ /*180 f=18000 */ 1.11114046603920435530, 0.01005183697391776043 },
{ /*181 f=18100 */ 1.11657646250204400928, 0.01005183697391776043 },
{ /*182 f=18200 */ 1.12200050132801965042, 0.01005183697391776043 },
{ /*183 f=18300 */ 1.12741252443003325823, 0.01005183697391776043 },
{ /*184 f=18400 */ 1.13281247384966565761, 0.01005183697391776043 },
{ /*185 f=18500 */ 1.13820029175779646735, 0.01005183697391776043 },
{ /*186 f=18600 */ 1.14357592045522449276, 0.01005183697391776043 },
{ /*187 f=18700 */ 1.14893930237328523170, 0.01005183697391776043 },
{ /*188 f=18800 */ 1.15429038007446727043, 0.01005183697391776043 },
{ /*189 f=18900 */ 1.15962909625302712513, 0.01005183697391776043 },
{ /*190 f=19000 */ 1.16495539373560430541, 0.01005183697391776043 },
{ /*191 f=19100 */ 1.17026921548183104882, 0.01005183697391776043 },
{ /*192 f=19200 */ 1.17557050458494627421, 0.01005183697391776043 },
{ /*193 f=19300 */ 1.18085920427240220754, 0.01005183697391776043 },
{ /*194 f=19400 */ 1.18613525790647433844, 0.01005183697391776043 },
{ /*195 f=19500 */ 1.19139860898486671381, 0.01005183697391776043 },
{ /*196 f=19600 */ 1.19664920114131789752, 0.01005183697391776043 },
{ /*197 f=19700 */ 1.20188697814620470972, 0.01005183697391776043 },
{ /*198 f=19800 */ 1.20711188390714285745, 0.01005183697391776043 },
{ /*199 f=19900 */ 1.21232386246958934173, 0.01005183697391776043 },
{ /*200 f=20000 */ 1.21752285801744131177, 0.01005183697391776043 },
{ /*201 f=20100 */ 1.22270881487363292095, 0.01005183697391776043 },
{ /*202 f=20200 */ 1.22788167750073284878, 0.01005183697391776043 },
{ /*203 f=20300 */ 1.23304139050153827029, 0.01005183697391776043 },
{ /*204 f=20400 */ 1.23818789861966793708, 0.01005183697391776043 },
{ /*205 f=20500 */ 1.24332114674015481448, 0.01005183697391776043 },
{ /*206 f=20600 */ 1.24844107989003516579, 0.01005183697391776043 },
{ /*207 f=20700 */ 1.25354764323893919098, 0.01005183697391776043 },
{ /*208 f=20800 */ 1.25864078209967500399, 0.01005183697391776043 },
{ /*209 f=20900 */ 1.26372044192881749503, 0.01005183697391776043 },
{ /*210 f=21000 */ 1.26878656832729097559, 0.01005183697391776043 },
{ /*211 f=21100 */ 1.27383910704095182354, 0.01005183697391776043 },
{ /*212 f=21200 */ 1.27887800396116935175, 0.01005183697391776043 },
{ /*213 f=21300 */ 1.28390320512540601072, 0.01005183697391776043 },
{ /*214 f=21400 */ 1.28891465671779492652, 0.01005183697391776043 },
{ /*215 f=21500 */ 1.29391230506971455227, 0.01005183697391776043 },
{ /*216 f=21600 */ 1.29889609666036731639, 0.01005183697391776043 },
{ /*217 f=21700 */ 1.30386597811734850083, 0.01005183697391776043 },
{ /*218 f=21800 */ 1.30882189621722067052, 0.01005183697391776043 },
{ /*219 f=21900 */ 1.31376379788608255161, 0.01005183697391776043 },
{ /*220 f=22000 */ 1.31869163020013768772, 0.01005183697391776043 },
{ /*221 f=22100 */ 1.32360534038626065367, 0.01005183697391776043 },
{ /*222 f=22200 */ 1.32850487582256349128, 0.01005183697391776043 },
{ /*223 f=22300 */ 1.33339018403895726017, 0.01005183697391776043 },
{ /*224 f=22400 */ 1.33826121271771647514, 0.01005183697391776043 },
{ /*225 f=22500 */ 1.34311790969403666018, 0.01005183697391776043 },
{ /*226 f=22600 */ 1.34796022295659567725, 0.01005183697391776043 },
{ /*227 f=22700 */ 1.35278810064810839364, 0.01005183697391776043 },
{ /*228 f=22800 */ 1.35760149106588334789, 0.01005183697391776043 },
{ /*229 f=22900 */ 1.36240034266237652893, 0.01005183697391776043 },
{ /*230 f=23000 */ 1.36718460404574249090, 0.01005183697391776043 },
{ /*231 f=23100 */ 1.37195422398038568979, 0.01005183697391776043 },
{ /*232 f=23200 */ 1.37670915138750782347, 0.01005183697391776043 },
{ /*233 f=23300 */ 1.38144933534565739208, 0.01005183697391776043 },
{ /*234 f=23400 */ 1.38617472509127170888, 0.01005183697391776043 },
{ /*235 f=23500 */ 1.39088527001922335202, 0.01005183697391776043 },
{ /*236 f=23600 */ 1.39558091968336017707, 0.01005183697391776043 },
{ /*237 f=23700 */ 1.40026162379704732786, 0.01005183697391776043 },
{ /*238 f=23800 */ 1.40492733223370347417, 0.01005183697391776043 },
{ /*239 f=23900 */ 1.40957799502734015817, 0.01005183697391776043 },
{ /*240 f=24000 */ 1.41421356237309492343, 0.01005183697391776043 }
};
static FLOAT_T vsf_q180[241][2] = {
{ /* dummy entry */ 0, 0},
{ /*  1 f=  100 */ 0.00654497301305325026, 0.00797200356891547557 },
{ /*  2 f=  200 */ 0.01308987593470371628, 0.00797200356891547557 },
{ /*  3 f=  300 */ 0.01963463867429923390, 0.00797200356891547557 },
{ /*  4 f=  400 */ 0.02617919114268887903, 0.00797200356891547557 },
{ /*  5 f=  500 */ 0.03272346325297356001, 0.00797200356891547557 },
{ /*  6 f=  600 */ 0.03926738492125660118, 0.00797200356891547557 },
{ /*  7 f=  700 */ 0.04581088606739427971, 0.00797200356891547557 },
{ /*  8 f=  800 */ 0.05235389661574629816, 0.00797200356891547557 },
{ /*  9 f=  900 */ 0.05889634649592632304, 0.00797200356891547557 },
{ /* 10 f= 1000 */ 0.06543816564355227350, 0.00797200356891547557 },
{ /* 11 f= 1100 */ 0.07197928400099674884, 0.00797200356891547557 },
{ /* 12 f= 1200 */ 0.07851963151813722008, 0.00797200356891547557 },
{ /* 13 f= 1300 */ 0.08505913815310624237, 0.00797200356891547557 },
{ /* 14 f= 1400 */ 0.09159773387304154246, 0.00797200356891547557 },
{ /* 15 f= 1500 */ 0.09813534865483602987, 0.00797200356891547557 },
{ /* 16 f= 1600 */ 0.10467191248588765540, 0.00797200356891547557 },
{ /* 17 f= 1700 */ 0.11120735536484922801, 0.00797200356891547557 },
{ /* 18 f= 1800 */ 0.11774160730237806516, 0.00797200356891547557 },
{ /* 19 f= 1900 */ 0.12427459832188544886, 0.00797200356891547557 },
{ /* 20 f= 2000 */ 0.13080625846028612336, 0.00797200356891547557 },
{ /* 21 f= 2100 */ 0.13733651776874752914, 0.00797200356891547557 },
{ /* 22 f= 2200 */ 0.14386530631343877329, 0.00797200356891547557 },
{ /* 23 f= 2300 */ 0.15039255417627980793, 0.00797200356891547557 },
{ /* 24 f= 2400 */ 0.15691819145568988714, 0.00797200356891547557 },
{ /* 25 f= 2500 */ 0.16344214826733644008, 0.00797200356891547557 },
{ /* 26 f= 2600 */ 0.16996435474488333361, 0.00797200356891547557 },
{ /* 27 f= 2700 */ 0.17648474104073902380, 0.00797200356891547557 },
{ /* 28 f= 2800 */ 0.18300323732680476296, 0.00797200356891547557 },
{ /* 29 f= 2900 */ 0.18951977379522222389, 0.00797200356891547557 },
{ /* 30 f= 3000 */ 0.19603428065912120726, 0.00797200356891547557 },
{ /* 31 f= 3100 */ 0.20254668815336684951, 0.00797200356891547557 },
{ /* 32 f= 3200 */ 0.20905692653530691394, 0.00797200356891547557 },
{ /* 33 f= 3300 */ 0.21556492608551869328, 0.00797200356891547557 },
{ /* 34 f= 3400 */ 0.22207061710855535708, 0.00797200356891547557 },
{ /* 35 f= 3500 */ 0.22857392993369279877, 0.00797200356891547557 },
{ /* 36 f= 3600 */ 0.23507479491567528918, 0.00797200356891547557 },
{ /* 37 f= 3700 */ 0.24157314243546165744, 0.00797200356891547557 },
{ /* 38 f= 3800 */ 0.24806890290097063922, 0.00797200356891547557 },
{ /* 39 f= 3900 */ 0.25456200674782641924, 0.00797200356891547557 },
{ /* 40 f= 4000 */ 0.26105238444010314680, 0.00797200356891547557 },
{ /* 41 f= 4100 */ 0.26753996647107025630, 0.00797200356891547557 },
{ /* 42 f= 4200 */ 0.27402468336393603909, 0.00797200356891547557 },
{ /* 43 f= 4300 */ 0.28050646567259251984, 0.00797200356891547557 },
{ /* 44 f= 4400 */ 0.28698524398235858435, 0.00797200356891547557 },
{ /* 45 f= 4500 */ 0.29346094891072349586, 0.00797200356891547557 },
{ /* 46 f= 4600 */ 0.29993351110809002291, 0.00797200356891547557 },
{ /* 47 f= 4700 */ 0.30640286125851695642, 0.00797200356891547557 },
{ /* 48 f= 4800 */ 0.31286893008046173792, 0.00797200356891547557 },
{ /* 49 f= 4900 */ 0.31933164832752197748, 0.00797200356891547557 },
{ /* 50 f= 5000 */ 0.32579094678917747130, 0.00797200356891547557 },
{ /* 51 f= 5100 */ 0.33224675629153094247, 0.00797200356891547557 },
{ /* 52 f= 5200 */ 0.33869900769804922591, 0.00797200356891547557 },
{ /* 53 f= 5300 */ 0.34514763191030339851, 0.00797200356891547557 },
{ /* 54 f= 5400 */ 0.35159255986870902033, 0.00797200356891547557 },
{ /* 55 f= 5500 */ 0.35803372255326532114, 0.00797200356891547557 },
{ /* 56 f= 5600 */ 0.36447105098429494197, 0.00797200356891547557 },
{ /* 57 f= 5700 */ 0.37090447622318184484, 0.00797200356891547557 },
{ /* 58 f= 5800 */ 0.37733392937311044379, 0.00797200356891547557 },
{ /* 59 f= 5900 */ 0.38375934157980284844, 0.00797200356891547557 },
{ /* 60 f= 6000 */ 0.39018064403225649617, 0.00797200356891547557 },
{ /* 61 f= 6100 */ 0.39659776796348089611, 0.00797200356891547557 },
{ /* 62 f= 6200 */ 0.40301064465123426217, 0.00797200356891547557 },
{ /* 63 f= 6300 */ 0.40941920541875920225, 0.00797200356891547557 },
{ /* 64 f= 6400 */ 0.41582338163551862964, 0.00797200356891547557 },
{ /* 65 f= 6500 */ 0.42222310471793028652, 0.00797200356891547557 },
{ /* 66 f= 6600 */ 0.42861830613010154511, 0.00797200356891547557 },
{ /* 67 f= 6700 */ 0.43500891738456293201, 0.00797200356891547557 },
{ /* 68 f= 6800 */ 0.44139487004300215212, 0.00797200356891547557 },
{ /* 69 f= 6900 */ 0.44777609571699672486, 0.00797200356891547557 },
{ /* 70 f= 7000 */ 0.45415252606874645380, 0.00797200356891547557 },
{ /* 71 f= 7100 */ 0.46052409281180473055, 0.00797200356891547557 },
{ /* 72 f= 7200 */ 0.46689072771181078236, 0.00797200356891547557 },
{ /* 73 f= 7300 */ 0.47325236258721975480, 0.00797200356891547557 },
{ /* 74 f= 7400 */ 0.47960892931003307194, 0.00797200356891547557 },
{ /* 75 f= 7500 */ 0.48596035980652774189, 0.00797200356891547557 },
{ /* 76 f= 7600 */ 0.49230658605798605088, 0.00797200356891547557 },
{ /* 77 f= 7700 */ 0.49864754010142336993, 0.00797200356891547557 },
{ /* 78 f= 7800 */ 0.50498315403031590609, 0.00797200356891547557 },
{ /* 79 f= 7900 */ 0.51131335999532878667, 0.00797200356891547557 },
{ /* 80 f= 8000 */ 0.51763809020504147895, 0.00797200356891547557 },
{ /* 81 f= 8100 */ 0.52395727692667493081, 0.00797200356891547557 },
{ /* 82 f= 8200 */ 0.53027085248681604668, 0.00797200356891547557 },
{ /* 83 f= 8300 */ 0.53657874927214277427, 0.00797200356891547557 },
{ /* 84 f= 8400 */ 0.54288089973014852507, 0.00797200356891547557 },
{ /* 85 f= 8500 */ 0.54917723636986470748, 0.00797200356891547557 },
{ /* 86 f= 8600 */ 0.55546769176258437017, 0.00797200356891547557 },
{ /* 87 f= 8700 */ 0.56175219854258418017, 0.00797200356891547557 },
{ /* 88 f= 8800 */ 0.56803068940784517959, 0.00797200356891547557 },
{ /* 89 f= 8900 */ 0.57430309712077465267, 0.00797200356891547557 },
{ /* 90 f= 9000 */ 0.58056935450892466211, 0.00797200356891547557 },
{ /* 91 f= 9100 */ 0.58682939446571336095, 0.00797200356891547557 },
{ /* 92 f= 9200 */ 0.59308314995114197465, 0.00797200356891547557 },
{ /* 93 f= 9300 */ 0.59933055399251322637, 0.00797200356891547557 },
{ /* 94 f= 9400 */ 0.60557153968514920717, 0.00797200356891547557 },
{ /* 95 f= 9500 */ 0.61180604019310691477, 0.00797200356891547557 },
{ /* 96 f= 9600 */ 0.61803398874989479150, 0.00797200356891547557 },
{ /* 97 f= 9700 */ 0.62425531865918737484, 0.00797200356891547557 },
{ /* 98 f= 9800 */ 0.63046996329553928184, 0.00797200356891547557 },
{ /* 99 f= 9900 */ 0.63667785610509941563, 0.00797200356891547557 },
{ /*100 f=10000 */ 0.64287893060632317344, 0.00797200356891547557 },
{ /*101 f=10100 */ 0.64907312039068432163, 0.00797200356891547557 },
{ /*102 f=10200 */ 0.65526035912338698175, 0.00797200356891547557 },
{ /*103 f=10300 */ 0.66144058054407484093, 0.00797200356891547557 },
{ /*104 f=10400 */ 0.66761371846754191672, 0.00797200356891547557 },
{ /*105 f=10500 */ 0.67377970678444010222, 0.00797200356891547557 },
{ /*106 f=10600 */ 0.67993847946198837651, 0.00797200356891547557 },
{ /*107 f=10700 */ 0.68608997054467968368, 0.00797200356891547557 },
{ /*108 f=10800 */ 0.69223411415498592447, 0.00797200356891547557 },
{ /*109 f=10900 */ 0.69837084449406572340, 0.00797200356891547557 },
{ /*110 f=11000 */ 0.70450009584246697791, 0.00797200356891547557 },
{ /*111 f=11100 */ 0.71062180256083218310, 0.00797200356891547557 },
{ /*112 f=11200 */ 0.71673589909060053671, 0.00797200356891547557 },
{ /*113 f=11300 */ 0.72284231995471004417, 0.00797200356891547557 },
{ /*114 f=11400 */ 0.72894099975829929061, 0.00797200356891547557 },
{ /*115 f=11500 */ 0.73503187318940710338, 0.00797200356891547557 },
{ /*116 f=11600 */ 0.74111487501967243663, 0.00797200356891547557 },
{ /*117 f=11700 */ 0.74718994010503270164, 0.00797200356891547557 },
{ /*118 f=11800 */ 0.75325700338642143095, 0.00797200356891547557 },
{ /*119 f=11900 */ 0.75931599989046549837, 0.00797200356891547557 },
{ /*120 f=12000 */ 0.76536686473017956356, 0.00797200356891547557 },
{ /*121 f=12100 */ 0.77140953310566262591, 0.00797200356891547557 },
{ /*122 f=12200 */ 0.77744394030479113678, 0.00797200356891547557 },
{ /*123 f=12300 */ 0.78347002170391177867, 0.00797200356891547557 },
{ /*124 f=12400 */ 0.78948771276853446643, 0.00797200356891547557 },
{ /*125 f=12500 */ 0.79549694905402212886, 0.00797200356891547557 },
{ /*126 f=12600 */ 0.80149766620628193348, 0.00797200356891547557 },
{ /*127 f=12700 */ 0.80748979996245418000, 0.00797200356891547557 },
{ /*128 f=12800 */ 0.81347328615160030552, 0.00797200356891547557 },
{ /*129 f=12900 */ 0.81944806069539055660, 0.00797200356891547557 },
{ /*130 f=13000 */ 0.82541405960878933001, 0.00797200356891547557 },
{ /*131 f=13100 */ 0.83137121900074162362, 0.00797200356891547557 },
{ /*132 f=13200 */ 0.83731947507485626758, 0.00797200356891547557 },
{ /*133 f=13300 */ 0.84325876413008904464, 0.00797200356891547557 },
{ /*134 f=13400 */ 0.84918902256142625440, 0.00797200356891547557 },
{ /*135 f=13500 */ 0.85511018686056416982, 0.00797200356891547557 },
{ /*136 f=13600 */ 0.86102219361659015906, 0.00797200356891547557 },
{ /*137 f=13700 */ 0.86692497951666180889, 0.00797200356891547557 },
{ /*138 f=13800 */ 0.87281848134668404970, 0.00797200356891547557 },
{ /*139 f=13900 */ 0.87870263599198739080, 0.00797200356891547557 },
{ /*140 f=14000 */ 0.88457738043800260286, 0.00797200356891547557 },
{ /*141 f=14100 */ 0.89044265177093639974, 0.00797200356891547557 },
{ /*142 f=14200 */ 0.89629838717844512175, 0.00797200356891547557 },
{ /*143 f=14300 */ 0.90214452395030675369, 0.00797200356891547557 },
{ /*144 f=14400 */ 0.90798099947909349794, 0.00797200356891547557 },
{ /*145 f=14500 */ 0.91380775126084123894, 0.00797200356891547557 },
{ /*146 f=14600 */ 0.91962471689571967381, 0.00797200356891547557 },
{ /*147 f=14700 */ 0.92543183408870022255, 0.00797200356891547557 },
{ /*148 f=14800 */ 0.93122904065022282794, 0.00797200356891547557 },
{ /*149 f=14900 */ 0.93701627449686286653, 0.00797200356891547557 },
{ /*150 f=15000 */ 0.94279347365199528408, 0.00797200356891547557 },
{ /*151 f=15100 */ 0.94856057624645839788, 0.00797200356891547557 },
{ /*152 f=15200 */ 0.95431752051921681090, 0.00797200356891547557 },
{ /*153 f=15300 */ 0.96006424481802221660, 0.00797200356891547557 },
{ /*154 f=15400 */ 0.96580068760007475870, 0.00797200356891547557 },
{ /*155 f=15500 */ 0.97152678743268006123, 0.00797200356891547557 },
{ /*156 f=15600 */ 0.97724248299390981121, 0.00797200356891547557 },
{ /*157 f=15700 */ 0.98294771307325645715, 0.00797200356891547557 },
{ /*158 f=15800 */ 0.98864241657228923987, 0.00797200356891547557 },
{ /*159 f=15900 */ 0.99432653250530855793, 0.00797200356891547557 },
{ /*160 f=16000 */ 0.99999999999999988898, 0.00797200356891547557 },
{ /*161 f=16100 */ 1.00566275829808415843, 0.00797200356891547557 },
{ /*162 f=16200 */ 1.01131474675596910728, 0.00797200356891547557 },
{ /*163 f=16300 */ 1.01695590484539954979, 0.00797200356891547557 },
{ /*164 f=16400 */ 1.02258617215410430035, 0.00797200356891547557 },
{ /*165 f=16500 */ 1.02820548838644332257, 0.00797200356891547557 },
{ /*166 f=16600 */ 1.03381379336405498925, 0.00797200356891547557 },
{ /*167 f=16700 */ 1.03941102702649845746, 0.00797200356891547557 },
{ /*168 f=16800 */ 1.04499712943189759784, 0.00797200356891547557 },
{ /*169 f=16900 */ 1.05057204075758403583, 0.00797200356891547557 },
{ /*170 f=17000 */ 1.05613570130073597397, 0.00797200356891547557 },
{ /*171 f=17100 */ 1.06168805147901901265, 0.00797200356891547557 },
{ /*172 f=17200 */ 1.06722903183122297399, 0.00797200356891547557 },
{ /*173 f=17300 */ 1.07275858301790050220, 0.00797200356891547557 },
{ /*174 f=17400 */ 1.07827664582200033472, 0.00797200356891547557 },
{ /*175 f=17500 */ 1.08378316114950346005, 0.00797200356891547557 },
{ /*176 f=17600 */ 1.08927807003005394648, 0.00797200356891547557 },
{ /*177 f=17700 */ 1.09476131361759310145, 0.00797200356891547557 },
{ /*178 f=17800 */ 1.10023283319098674760, 0.00797200356891547557 },
{ /*179 f=17900 */ 1.10569257015465582938, 0.00797200356891547557 },
{ /*180 f=18000 */ 1.11114046603920435530, 0.00797200356891547557 },
{ /*181 f=18100 */ 1.11657646250204400928, 0.00797200356891547557 },
{ /*182 f=18200 */ 1.12200050132801965042, 0.00797200356891547557 },
{ /*183 f=18300 */ 1.12741252443003325823, 0.00797200356891547557 },
{ /*184 f=18400 */ 1.13281247384966565761, 0.00797200356891547557 },
{ /*185 f=18500 */ 1.13820029175779646735, 0.00797200356891547557 },
{ /*186 f=18600 */ 1.14357592045522449276, 0.00797200356891547557 },
{ /*187 f=18700 */ 1.14893930237328523170, 0.00797200356891547557 },
{ /*188 f=18800 */ 1.15429038007446727043, 0.00797200356891547557 },
{ /*189 f=18900 */ 1.15962909625302712513, 0.00797200356891547557 },
{ /*190 f=19000 */ 1.16495539373560430541, 0.00797200356891547557 },
{ /*191 f=19100 */ 1.17026921548183104882, 0.00797200356891547557 },
{ /*192 f=19200 */ 1.17557050458494627421, 0.00797200356891547557 },
{ /*193 f=19300 */ 1.18085920427240220754, 0.00797200356891547557 },
{ /*194 f=19400 */ 1.18613525790647433844, 0.00797200356891547557 },
{ /*195 f=19500 */ 1.19139860898486671381, 0.00797200356891547557 },
{ /*196 f=19600 */ 1.19664920114131789752, 0.00797200356891547557 },
{ /*197 f=19700 */ 1.20188697814620470972, 0.00797200356891547557 },
{ /*198 f=19800 */ 1.20711188390714285745, 0.00797200356891547557 },
{ /*199 f=19900 */ 1.21232386246958934173, 0.00797200356891547557 },
{ /*200 f=20000 */ 1.21752285801744131177, 0.00797200356891547557 },
{ /*201 f=20100 */ 1.22270881487363292095, 0.00797200356891547557 },
{ /*202 f=20200 */ 1.22788167750073284878, 0.00797200356891547557 },
{ /*203 f=20300 */ 1.23304139050153827029, 0.00797200356891547557 },
{ /*204 f=20400 */ 1.23818789861966793708, 0.00797200356891547557 },
{ /*205 f=20500 */ 1.24332114674015481448, 0.00797200356891547557 },
{ /*206 f=20600 */ 1.24844107989003516579, 0.00797200356891547557 },
{ /*207 f=20700 */ 1.25354764323893919098, 0.00797200356891547557 },
{ /*208 f=20800 */ 1.25864078209967500399, 0.00797200356891547557 },
{ /*209 f=20900 */ 1.26372044192881749503, 0.00797200356891547557 },
{ /*210 f=21000 */ 1.26878656832729097559, 0.00797200356891547557 },
{ /*211 f=21100 */ 1.27383910704095182354, 0.00797200356891547557 },
{ /*212 f=21200 */ 1.27887800396116935175, 0.00797200356891547557 },
{ /*213 f=21300 */ 1.28390320512540601072, 0.00797200356891547557 },
{ /*214 f=21400 */ 1.28891465671779492652, 0.00797200356891547557 },
{ /*215 f=21500 */ 1.29391230506971455227, 0.00797200356891547557 },
{ /*216 f=21600 */ 1.29889609666036731639, 0.00797200356891547557 },
{ /*217 f=21700 */ 1.30386597811734850083, 0.00797200356891547557 },
{ /*218 f=21800 */ 1.30882189621722067052, 0.00797200356891547557 },
{ /*219 f=21900 */ 1.31376379788608255161, 0.00797200356891547557 },
{ /*220 f=22000 */ 1.31869163020013768772, 0.00797200356891547557 },
{ /*221 f=22100 */ 1.32360534038626065367, 0.00797200356891547557 },
{ /*222 f=22200 */ 1.32850487582256349128, 0.00797200356891547557 },
{ /*223 f=22300 */ 1.33339018403895726017, 0.00797200356891547557 },
{ /*224 f=22400 */ 1.33826121271771647514, 0.00797200356891547557 },
{ /*225 f=22500 */ 1.34311790969403666018, 0.00797200356891547557 },
{ /*226 f=22600 */ 1.34796022295659567725, 0.00797200356891547557 },
{ /*227 f=22700 */ 1.35278810064810839364, 0.00797200356891547557 },
{ /*228 f=22800 */ 1.35760149106588334789, 0.00797200356891547557 },
{ /*229 f=22900 */ 1.36240034266237652893, 0.00797200356891547557 },
{ /*230 f=23000 */ 1.36718460404574249090, 0.00797200356891547557 },
{ /*231 f=23100 */ 1.37195422398038568979, 0.00797200356891547557 },
{ /*232 f=23200 */ 1.37670915138750782347, 0.00797200356891547557 },
{ /*233 f=23300 */ 1.38144933534565739208, 0.00797200356891547557 },
{ /*234 f=23400 */ 1.38617472509127170888, 0.00797200356891547557 },
{ /*235 f=23500 */ 1.39088527001922335202, 0.00797200356891547557 },
{ /*236 f=23600 */ 1.39558091968336017707, 0.00797200356891547557 },
{ /*237 f=23700 */ 1.40026162379704732786, 0.00797200356891547557 },
{ /*238 f=23800 */ 1.40492733223370347417, 0.00797200356891547557 },
{ /*239 f=23900 */ 1.40957799502734015817, 0.00797200356891547557 },
{ /*240 f=24000 */ 1.41421356237309492343, 0.00797200356891547557 }
};
static FLOAT_T vsf_q190[241][2] = {
{ /* dummy entry */ 0, 0},
{ /*  1 f=  100 */ 0.00654497301305325026, 0.00632456353070742772 },
{ /*  2 f=  200 */ 0.01308987593470371628, 0.00632456353070742772 },
{ /*  3 f=  300 */ 0.01963463867429923390, 0.00632456353070742772 },
{ /*  4 f=  400 */ 0.02617919114268887903, 0.00632456353070742772 },
{ /*  5 f=  500 */ 0.03272346325297356001, 0.00632456353070742772 },
{ /*  6 f=  600 */ 0.03926738492125660118, 0.00632456353070742772 },
{ /*  7 f=  700 */ 0.04581088606739427971, 0.00632456353070742772 },
{ /*  8 f=  800 */ 0.05235389661574629816, 0.00632456353070742772 },
{ /*  9 f=  900 */ 0.05889634649592632304, 0.00632456353070742772 },
{ /* 10 f= 1000 */ 0.06543816564355227350, 0.00632456353070742772 },
{ /* 11 f= 1100 */ 0.07197928400099674884, 0.00632456353070742772 },
{ /* 12 f= 1200 */ 0.07851963151813722008, 0.00632456353070742772 },
{ /* 13 f= 1300 */ 0.08505913815310624237, 0.00632456353070742772 },
{ /* 14 f= 1400 */ 0.09159773387304154246, 0.00632456353070742772 },
{ /* 15 f= 1500 */ 0.09813534865483602987, 0.00632456353070742772 },
{ /* 16 f= 1600 */ 0.10467191248588765540, 0.00632456353070742772 },
{ /* 17 f= 1700 */ 0.11120735536484922801, 0.00632456353070742772 },
{ /* 18 f= 1800 */ 0.11774160730237806516, 0.00632456353070742772 },
{ /* 19 f= 1900 */ 0.12427459832188544886, 0.00632456353070742772 },
{ /* 20 f= 2000 */ 0.13080625846028612336, 0.00632456353070742772 },
{ /* 21 f= 2100 */ 0.13733651776874752914, 0.00632456353070742772 },
{ /* 22 f= 2200 */ 0.14386530631343877329, 0.00632456353070742772 },
{ /* 23 f= 2300 */ 0.15039255417627980793, 0.00632456353070742772 },
{ /* 24 f= 2400 */ 0.15691819145568988714, 0.00632456353070742772 },
{ /* 25 f= 2500 */ 0.16344214826733644008, 0.00632456353070742772 },
{ /* 26 f= 2600 */ 0.16996435474488333361, 0.00632456353070742772 },
{ /* 27 f= 2700 */ 0.17648474104073902380, 0.00632456353070742772 },
{ /* 28 f= 2800 */ 0.18300323732680476296, 0.00632456353070742772 },
{ /* 29 f= 2900 */ 0.18951977379522222389, 0.00632456353070742772 },
{ /* 30 f= 3000 */ 0.19603428065912120726, 0.00632456353070742772 },
{ /* 31 f= 3100 */ 0.20254668815336684951, 0.00632456353070742772 },
{ /* 32 f= 3200 */ 0.20905692653530691394, 0.00632456353070742772 },
{ /* 33 f= 3300 */ 0.21556492608551869328, 0.00632456353070742772 },
{ /* 34 f= 3400 */ 0.22207061710855535708, 0.00632456353070742772 },
{ /* 35 f= 3500 */ 0.22857392993369279877, 0.00632456353070742772 },
{ /* 36 f= 3600 */ 0.23507479491567528918, 0.00632456353070742772 },
{ /* 37 f= 3700 */ 0.24157314243546165744, 0.00632456353070742772 },
{ /* 38 f= 3800 */ 0.24806890290097063922, 0.00632456353070742772 },
{ /* 39 f= 3900 */ 0.25456200674782641924, 0.00632456353070742772 },
{ /* 40 f= 4000 */ 0.26105238444010314680, 0.00632456353070742772 },
{ /* 41 f= 4100 */ 0.26753996647107025630, 0.00632456353070742772 },
{ /* 42 f= 4200 */ 0.27402468336393603909, 0.00632456353070742772 },
{ /* 43 f= 4300 */ 0.28050646567259251984, 0.00632456353070742772 },
{ /* 44 f= 4400 */ 0.28698524398235858435, 0.00632456353070742772 },
{ /* 45 f= 4500 */ 0.29346094891072349586, 0.00632456353070742772 },
{ /* 46 f= 4600 */ 0.29993351110809002291, 0.00632456353070742772 },
{ /* 47 f= 4700 */ 0.30640286125851695642, 0.00632456353070742772 },
{ /* 48 f= 4800 */ 0.31286893008046173792, 0.00632456353070742772 },
{ /* 49 f= 4900 */ 0.31933164832752197748, 0.00632456353070742772 },
{ /* 50 f= 5000 */ 0.32579094678917747130, 0.00632456353070742772 },
{ /* 51 f= 5100 */ 0.33224675629153094247, 0.00632456353070742772 },
{ /* 52 f= 5200 */ 0.33869900769804922591, 0.00632456353070742772 },
{ /* 53 f= 5300 */ 0.34514763191030339851, 0.00632456353070742772 },
{ /* 54 f= 5400 */ 0.35159255986870902033, 0.00632456353070742772 },
{ /* 55 f= 5500 */ 0.35803372255326532114, 0.00632456353070742772 },
{ /* 56 f= 5600 */ 0.36447105098429494197, 0.00632456353070742772 },
{ /* 57 f= 5700 */ 0.37090447622318184484, 0.00632456353070742772 },
{ /* 58 f= 5800 */ 0.37733392937311044379, 0.00632456353070742772 },
{ /* 59 f= 5900 */ 0.38375934157980284844, 0.00632456353070742772 },
{ /* 60 f= 6000 */ 0.39018064403225649617, 0.00632456353070742772 },
{ /* 61 f= 6100 */ 0.39659776796348089611, 0.00632456353070742772 },
{ /* 62 f= 6200 */ 0.40301064465123426217, 0.00632456353070742772 },
{ /* 63 f= 6300 */ 0.40941920541875920225, 0.00632456353070742772 },
{ /* 64 f= 6400 */ 0.41582338163551862964, 0.00632456353070742772 },
{ /* 65 f= 6500 */ 0.42222310471793028652, 0.00632456353070742772 },
{ /* 66 f= 6600 */ 0.42861830613010154511, 0.00632456353070742772 },
{ /* 67 f= 6700 */ 0.43500891738456293201, 0.00632456353070742772 },
{ /* 68 f= 6800 */ 0.44139487004300215212, 0.00632456353070742772 },
{ /* 69 f= 6900 */ 0.44777609571699672486, 0.00632456353070742772 },
{ /* 70 f= 7000 */ 0.45415252606874645380, 0.00632456353070742772 },
{ /* 71 f= 7100 */ 0.46052409281180473055, 0.00632456353070742772 },
{ /* 72 f= 7200 */ 0.46689072771181078236, 0.00632456353070742772 },
{ /* 73 f= 7300 */ 0.47325236258721975480, 0.00632456353070742772 },
{ /* 74 f= 7400 */ 0.47960892931003307194, 0.00632456353070742772 },
{ /* 75 f= 7500 */ 0.48596035980652774189, 0.00632456353070742772 },
{ /* 76 f= 7600 */ 0.49230658605798605088, 0.00632456353070742772 },
{ /* 77 f= 7700 */ 0.49864754010142336993, 0.00632456353070742772 },
{ /* 78 f= 7800 */ 0.50498315403031590609, 0.00632456353070742772 },
{ /* 79 f= 7900 */ 0.51131335999532878667, 0.00632456353070742772 },
{ /* 80 f= 8000 */ 0.51763809020504147895, 0.00632456353070742772 },
{ /* 81 f= 8100 */ 0.52395727692667493081, 0.00632456353070742772 },
{ /* 82 f= 8200 */ 0.53027085248681604668, 0.00632456353070742772 },
{ /* 83 f= 8300 */ 0.53657874927214277427, 0.00632456353070742772 },
{ /* 84 f= 8400 */ 0.54288089973014852507, 0.00632456353070742772 },
{ /* 85 f= 8500 */ 0.54917723636986470748, 0.00632456353070742772 },
{ /* 86 f= 8600 */ 0.55546769176258437017, 0.00632456353070742772 },
{ /* 87 f= 8700 */ 0.56175219854258418017, 0.00632456353070742772 },
{ /* 88 f= 8800 */ 0.56803068940784517959, 0.00632456353070742772 },
{ /* 89 f= 8900 */ 0.57430309712077465267, 0.00632456353070742772 },
{ /* 90 f= 9000 */ 0.58056935450892466211, 0.00632456353070742772 },
{ /* 91 f= 9100 */ 0.58682939446571336095, 0.00632456353070742772 },
{ /* 92 f= 9200 */ 0.59308314995114197465, 0.00632456353070742772 },
{ /* 93 f= 9300 */ 0.59933055399251322637, 0.00632456353070742772 },
{ /* 94 f= 9400 */ 0.60557153968514920717, 0.00632456353070742772 },
{ /* 95 f= 9500 */ 0.61180604019310691477, 0.00632456353070742772 },
{ /* 96 f= 9600 */ 0.61803398874989479150, 0.00632456353070742772 },
{ /* 97 f= 9700 */ 0.62425531865918737484, 0.00632456353070742772 },
{ /* 98 f= 9800 */ 0.63046996329553928184, 0.00632456353070742772 },
{ /* 99 f= 9900 */ 0.63667785610509941563, 0.00632456353070742772 },
{ /*100 f=10000 */ 0.64287893060632317344, 0.00632456353070742772 },
{ /*101 f=10100 */ 0.64907312039068432163, 0.00632456353070742772 },
{ /*102 f=10200 */ 0.65526035912338698175, 0.00632456353070742772 },
{ /*103 f=10300 */ 0.66144058054407484093, 0.00632456353070742772 },
{ /*104 f=10400 */ 0.66761371846754191672, 0.00632456353070742772 },
{ /*105 f=10500 */ 0.67377970678444010222, 0.00632456353070742772 },
{ /*106 f=10600 */ 0.67993847946198837651, 0.00632456353070742772 },
{ /*107 f=10700 */ 0.68608997054467968368, 0.00632456353070742772 },
{ /*108 f=10800 */ 0.69223411415498592447, 0.00632456353070742772 },
{ /*109 f=10900 */ 0.69837084449406572340, 0.00632456353070742772 },
{ /*110 f=11000 */ 0.70450009584246697791, 0.00632456353070742772 },
{ /*111 f=11100 */ 0.71062180256083218310, 0.00632456353070742772 },
{ /*112 f=11200 */ 0.71673589909060053671, 0.00632456353070742772 },
{ /*113 f=11300 */ 0.72284231995471004417, 0.00632456353070742772 },
{ /*114 f=11400 */ 0.72894099975829929061, 0.00632456353070742772 },
{ /*115 f=11500 */ 0.73503187318940710338, 0.00632456353070742772 },
{ /*116 f=11600 */ 0.74111487501967243663, 0.00632456353070742772 },
{ /*117 f=11700 */ 0.74718994010503270164, 0.00632456353070742772 },
{ /*118 f=11800 */ 0.75325700338642143095, 0.00632456353070742772 },
{ /*119 f=11900 */ 0.75931599989046549837, 0.00632456353070742772 },
{ /*120 f=12000 */ 0.76536686473017956356, 0.00632456353070742772 },
{ /*121 f=12100 */ 0.77140953310566262591, 0.00632456353070742772 },
{ /*122 f=12200 */ 0.77744394030479113678, 0.00632456353070742772 },
{ /*123 f=12300 */ 0.78347002170391177867, 0.00632456353070742772 },
{ /*124 f=12400 */ 0.78948771276853446643, 0.00632456353070742772 },
{ /*125 f=12500 */ 0.79549694905402212886, 0.00632456353070742772 },
{ /*126 f=12600 */ 0.80149766620628193348, 0.00632456353070742772 },
{ /*127 f=12700 */ 0.80748979996245418000, 0.00632456353070742772 },
{ /*128 f=12800 */ 0.81347328615160030552, 0.00632456353070742772 },
{ /*129 f=12900 */ 0.81944806069539055660, 0.00632456353070742772 },
{ /*130 f=13000 */ 0.82541405960878933001, 0.00632456353070742772 },
{ /*131 f=13100 */ 0.83137121900074162362, 0.00632456353070742772 },
{ /*132 f=13200 */ 0.83731947507485626758, 0.00632456353070742772 },
{ /*133 f=13300 */ 0.84325876413008904464, 0.00632456353070742772 },
{ /*134 f=13400 */ 0.84918902256142625440, 0.00632456353070742772 },
{ /*135 f=13500 */ 0.85511018686056416982, 0.00632456353070742772 },
{ /*136 f=13600 */ 0.86102219361659015906, 0.00632456353070742772 },
{ /*137 f=13700 */ 0.86692497951666180889, 0.00632456353070742772 },
{ /*138 f=13800 */ 0.87281848134668404970, 0.00632456353070742772 },
{ /*139 f=13900 */ 0.87870263599198739080, 0.00632456353070742772 },
{ /*140 f=14000 */ 0.88457738043800260286, 0.00632456353070742772 },
{ /*141 f=14100 */ 0.89044265177093639974, 0.00632456353070742772 },
{ /*142 f=14200 */ 0.89629838717844512175, 0.00632456353070742772 },
{ /*143 f=14300 */ 0.90214452395030675369, 0.00632456353070742772 },
{ /*144 f=14400 */ 0.90798099947909349794, 0.00632456353070742772 },
{ /*145 f=14500 */ 0.91380775126084123894, 0.00632456353070742772 },
{ /*146 f=14600 */ 0.91962471689571967381, 0.00632456353070742772 },
{ /*147 f=14700 */ 0.92543183408870022255, 0.00632456353070742772 },
{ /*148 f=14800 */ 0.93122904065022282794, 0.00632456353070742772 },
{ /*149 f=14900 */ 0.93701627449686286653, 0.00632456353070742772 },
{ /*150 f=15000 */ 0.94279347365199528408, 0.00632456353070742772 },
{ /*151 f=15100 */ 0.94856057624645839788, 0.00632456353070742772 },
{ /*152 f=15200 */ 0.95431752051921681090, 0.00632456353070742772 },
{ /*153 f=15300 */ 0.96006424481802221660, 0.00632456353070742772 },
{ /*154 f=15400 */ 0.96580068760007475870, 0.00632456353070742772 },
{ /*155 f=15500 */ 0.97152678743268006123, 0.00632456353070742772 },
{ /*156 f=15600 */ 0.97724248299390981121, 0.00632456353070742772 },
{ /*157 f=15700 */ 0.98294771307325645715, 0.00632456353070742772 },
{ /*158 f=15800 */ 0.98864241657228923987, 0.00632456353070742772 },
{ /*159 f=15900 */ 0.99432653250530855793, 0.00632456353070742772 },
{ /*160 f=16000 */ 0.99999999999999988898, 0.00632456353070742772 },
{ /*161 f=16100 */ 1.00566275829808415843, 0.00632456353070742772 },
{ /*162 f=16200 */ 1.01131474675596910728, 0.00632456353070742772 },
{ /*163 f=16300 */ 1.01695590484539954979, 0.00632456353070742772 },
{ /*164 f=16400 */ 1.02258617215410430035, 0.00632456353070742772 },
{ /*165 f=16500 */ 1.02820548838644332257, 0.00632456353070742772 },
{ /*166 f=16600 */ 1.03381379336405498925, 0.00632456353070742772 },
{ /*167 f=16700 */ 1.03941102702649845746, 0.00632456353070742772 },
{ /*168 f=16800 */ 1.04499712943189759784, 0.00632456353070742772 },
{ /*169 f=16900 */ 1.05057204075758403583, 0.00632456353070742772 },
{ /*170 f=17000 */ 1.05613570130073597397, 0.00632456353070742772 },
{ /*171 f=17100 */ 1.06168805147901901265, 0.00632456353070742772 },
{ /*172 f=17200 */ 1.06722903183122297399, 0.00632456353070742772 },
{ /*173 f=17300 */ 1.07275858301790050220, 0.00632456353070742772 },
{ /*174 f=17400 */ 1.07827664582200033472, 0.00632456353070742772 },
{ /*175 f=17500 */ 1.08378316114950346005, 0.00632456353070742772 },
{ /*176 f=17600 */ 1.08927807003005394648, 0.00632456353070742772 },
{ /*177 f=17700 */ 1.09476131361759310145, 0.00632456353070742772 },
{ /*178 f=17800 */ 1.10023283319098674760, 0.00632456353070742772 },
{ /*179 f=17900 */ 1.10569257015465582938, 0.00632456353070742772 },
{ /*180 f=18000 */ 1.11114046603920435530, 0.00632456353070742772 },
{ /*181 f=18100 */ 1.11657646250204400928, 0.00632456353070742772 },
{ /*182 f=18200 */ 1.12200050132801965042, 0.00632456353070742772 },
{ /*183 f=18300 */ 1.12741252443003325823, 0.00632456353070742772 },
{ /*184 f=18400 */ 1.13281247384966565761, 0.00632456353070742772 },
{ /*185 f=18500 */ 1.13820029175779646735, 0.00632456353070742772 },
{ /*186 f=18600 */ 1.14357592045522449276, 0.00632456353070742772 },
{ /*187 f=18700 */ 1.14893930237328523170, 0.00632456353070742772 },
{ /*188 f=18800 */ 1.15429038007446727043, 0.00632456353070742772 },
{ /*189 f=18900 */ 1.15962909625302712513, 0.00632456353070742772 },
{ /*190 f=19000 */ 1.16495539373560430541, 0.00632456353070742772 },
{ /*191 f=19100 */ 1.17026921548183104882, 0.00632456353070742772 },
{ /*192 f=19200 */ 1.17557050458494627421, 0.00632456353070742772 },
{ /*193 f=19300 */ 1.18085920427240220754, 0.00632456353070742772 },
{ /*194 f=19400 */ 1.18613525790647433844, 0.00632456353070742772 },
{ /*195 f=19500 */ 1.19139860898486671381, 0.00632456353070742772 },
{ /*196 f=19600 */ 1.19664920114131789752, 0.00632456353070742772 },
{ /*197 f=19700 */ 1.20188697814620470972, 0.00632456353070742772 },
{ /*198 f=19800 */ 1.20711188390714285745, 0.00632456353070742772 },
{ /*199 f=19900 */ 1.21232386246958934173, 0.00632456353070742772 },
{ /*200 f=20000 */ 1.21752285801744131177, 0.00632456353070742772 },
{ /*201 f=20100 */ 1.22270881487363292095, 0.00632456353070742772 },
{ /*202 f=20200 */ 1.22788167750073284878, 0.00632456353070742772 },
{ /*203 f=20300 */ 1.23304139050153827029, 0.00632456353070742772 },
{ /*204 f=20400 */ 1.23818789861966793708, 0.00632456353070742772 },
{ /*205 f=20500 */ 1.24332114674015481448, 0.00632456353070742772 },
{ /*206 f=20600 */ 1.24844107989003516579, 0.00632456353070742772 },
{ /*207 f=20700 */ 1.25354764323893919098, 0.00632456353070742772 },
{ /*208 f=20800 */ 1.25864078209967500399, 0.00632456353070742772 },
{ /*209 f=20900 */ 1.26372044192881749503, 0.00632456353070742772 },
{ /*210 f=21000 */ 1.26878656832729097559, 0.00632456353070742772 },
{ /*211 f=21100 */ 1.27383910704095182354, 0.00632456353070742772 },
{ /*212 f=21200 */ 1.27887800396116935175, 0.00632456353070742772 },
{ /*213 f=21300 */ 1.28390320512540601072, 0.00632456353070742772 },
{ /*214 f=21400 */ 1.28891465671779492652, 0.00632456353070742772 },
{ /*215 f=21500 */ 1.29391230506971455227, 0.00632456353070742772 },
{ /*216 f=21600 */ 1.29889609666036731639, 0.00632456353070742772 },
{ /*217 f=21700 */ 1.30386597811734850083, 0.00632456353070742772 },
{ /*218 f=21800 */ 1.30882189621722067052, 0.00632456353070742772 },
{ /*219 f=21900 */ 1.31376379788608255161, 0.00632456353070742772 },
{ /*220 f=22000 */ 1.31869163020013768772, 0.00632456353070742772 },
{ /*221 f=22100 */ 1.32360534038626065367, 0.00632456353070742772 },
{ /*222 f=22200 */ 1.32850487582256349128, 0.00632456353070742772 },
{ /*223 f=22300 */ 1.33339018403895726017, 0.00632456353070742772 },
{ /*224 f=22400 */ 1.33826121271771647514, 0.00632456353070742772 },
{ /*225 f=22500 */ 1.34311790969403666018, 0.00632456353070742772 },
{ /*226 f=22600 */ 1.34796022295659567725, 0.00632456353070742772 },
{ /*227 f=22700 */ 1.35278810064810839364, 0.00632456353070742772 },
{ /*228 f=22800 */ 1.35760149106588334789, 0.00632456353070742772 },
{ /*229 f=22900 */ 1.36240034266237652893, 0.00632456353070742772 },
{ /*230 f=23000 */ 1.36718460404574249090, 0.00632456353070742772 },
{ /*231 f=23100 */ 1.37195422398038568979, 0.00632456353070742772 },
{ /*232 f=23200 */ 1.37670915138750782347, 0.00632456353070742772 },
{ /*233 f=23300 */ 1.38144933534565739208, 0.00632456353070742772 },
{ /*234 f=23400 */ 1.38617472509127170888, 0.00632456353070742772 },
{ /*235 f=23500 */ 1.39088527001922335202, 0.00632456353070742772 },
{ /*236 f=23600 */ 1.39558091968336017707, 0.00632456353070742772 },
{ /*237 f=23700 */ 1.40026162379704732786, 0.00632456353070742772 },
{ /*238 f=23800 */ 1.40492733223370347417, 0.00632456353070742772 },
{ /*239 f=23900 */ 1.40957799502734015817, 0.00632456353070742772 },
{ /*240 f=24000 */ 1.41421356237309492343, 0.00632456353070742772 }
};
static FLOAT_T vsf_q200[241][2] = {
{ /* dummy entry */ 0, 0},
{ /*  1 f=  100 */ 0.00654497301305325026, 0.00501885978692984125 },
{ /*  2 f=  200 */ 0.01308987593470371628, 0.00501885978692984125 },
{ /*  3 f=  300 */ 0.01963463867429923390, 0.00501885978692984125 },
{ /*  4 f=  400 */ 0.02617919114268887903, 0.00501885978692984125 },
{ /*  5 f=  500 */ 0.03272346325297356001, 0.00501885978692984125 },
{ /*  6 f=  600 */ 0.03926738492125660118, 0.00501885978692984125 },
{ /*  7 f=  700 */ 0.04581088606739427971, 0.00501885978692984125 },
{ /*  8 f=  800 */ 0.05235389661574629816, 0.00501885978692984125 },
{ /*  9 f=  900 */ 0.05889634649592632304, 0.00501885978692984125 },
{ /* 10 f= 1000 */ 0.06543816564355227350, 0.00501885978692984125 },
{ /* 11 f= 1100 */ 0.07197928400099674884, 0.00501885978692984125 },
{ /* 12 f= 1200 */ 0.07851963151813722008, 0.00501885978692984125 },
{ /* 13 f= 1300 */ 0.08505913815310624237, 0.00501885978692984125 },
{ /* 14 f= 1400 */ 0.09159773387304154246, 0.00501885978692984125 },
{ /* 15 f= 1500 */ 0.09813534865483602987, 0.00501885978692984125 },
{ /* 16 f= 1600 */ 0.10467191248588765540, 0.00501885978692984125 },
{ /* 17 f= 1700 */ 0.11120735536484922801, 0.00501885978692984125 },
{ /* 18 f= 1800 */ 0.11774160730237806516, 0.00501885978692984125 },
{ /* 19 f= 1900 */ 0.12427459832188544886, 0.00501885978692984125 },
{ /* 20 f= 2000 */ 0.13080625846028612336, 0.00501885978692984125 },
{ /* 21 f= 2100 */ 0.13733651776874752914, 0.00501885978692984125 },
{ /* 22 f= 2200 */ 0.14386530631343877329, 0.00501885978692984125 },
{ /* 23 f= 2300 */ 0.15039255417627980793, 0.00501885978692984125 },
{ /* 24 f= 2400 */ 0.15691819145568988714, 0.00501885978692984125 },
{ /* 25 f= 2500 */ 0.16344214826733644008, 0.00501885978692984125 },
{ /* 26 f= 2600 */ 0.16996435474488333361, 0.00501885978692984125 },
{ /* 27 f= 2700 */ 0.17648474104073902380, 0.00501885978692984125 },
{ /* 28 f= 2800 */ 0.18300323732680476296, 0.00501885978692984125 },
{ /* 29 f= 2900 */ 0.18951977379522222389, 0.00501885978692984125 },
{ /* 30 f= 3000 */ 0.19603428065912120726, 0.00501885978692984125 },
{ /* 31 f= 3100 */ 0.20254668815336684951, 0.00501885978692984125 },
{ /* 32 f= 3200 */ 0.20905692653530691394, 0.00501885978692984125 },
{ /* 33 f= 3300 */ 0.21556492608551869328, 0.00501885978692984125 },
{ /* 34 f= 3400 */ 0.22207061710855535708, 0.00501885978692984125 },
{ /* 35 f= 3500 */ 0.22857392993369279877, 0.00501885978692984125 },
{ /* 36 f= 3600 */ 0.23507479491567528918, 0.00501885978692984125 },
{ /* 37 f= 3700 */ 0.24157314243546165744, 0.00501885978692984125 },
{ /* 38 f= 3800 */ 0.24806890290097063922, 0.00501885978692984125 },
{ /* 39 f= 3900 */ 0.25456200674782641924, 0.00501885978692984125 },
{ /* 40 f= 4000 */ 0.26105238444010314680, 0.00501885978692984125 },
{ /* 41 f= 4100 */ 0.26753996647107025630, 0.00501885978692984125 },
{ /* 42 f= 4200 */ 0.27402468336393603909, 0.00501885978692984125 },
{ /* 43 f= 4300 */ 0.28050646567259251984, 0.00501885978692984125 },
{ /* 44 f= 4400 */ 0.28698524398235858435, 0.00501885978692984125 },
{ /* 45 f= 4500 */ 0.29346094891072349586, 0.00501885978692984125 },
{ /* 46 f= 4600 */ 0.29993351110809002291, 0.00501885978692984125 },
{ /* 47 f= 4700 */ 0.30640286125851695642, 0.00501885978692984125 },
{ /* 48 f= 4800 */ 0.31286893008046173792, 0.00501885978692984125 },
{ /* 49 f= 4900 */ 0.31933164832752197748, 0.00501885978692984125 },
{ /* 50 f= 5000 */ 0.32579094678917747130, 0.00501885978692984125 },
{ /* 51 f= 5100 */ 0.33224675629153094247, 0.00501885978692984125 },
{ /* 52 f= 5200 */ 0.33869900769804922591, 0.00501885978692984125 },
{ /* 53 f= 5300 */ 0.34514763191030339851, 0.00501885978692984125 },
{ /* 54 f= 5400 */ 0.35159255986870902033, 0.00501885978692984125 },
{ /* 55 f= 5500 */ 0.35803372255326532114, 0.00501885978692984125 },
{ /* 56 f= 5600 */ 0.36447105098429494197, 0.00501885978692984125 },
{ /* 57 f= 5700 */ 0.37090447622318184484, 0.00501885978692984125 },
{ /* 58 f= 5800 */ 0.37733392937311044379, 0.00501885978692984125 },
{ /* 59 f= 5900 */ 0.38375934157980284844, 0.00501885978692984125 },
{ /* 60 f= 6000 */ 0.39018064403225649617, 0.00501885978692984125 },
{ /* 61 f= 6100 */ 0.39659776796348089611, 0.00501885978692984125 },
{ /* 62 f= 6200 */ 0.40301064465123426217, 0.00501885978692984125 },
{ /* 63 f= 6300 */ 0.40941920541875920225, 0.00501885978692984125 },
{ /* 64 f= 6400 */ 0.41582338163551862964, 0.00501885978692984125 },
{ /* 65 f= 6500 */ 0.42222310471793028652, 0.00501885978692984125 },
{ /* 66 f= 6600 */ 0.42861830613010154511, 0.00501885978692984125 },
{ /* 67 f= 6700 */ 0.43500891738456293201, 0.00501885978692984125 },
{ /* 68 f= 6800 */ 0.44139487004300215212, 0.00501885978692984125 },
{ /* 69 f= 6900 */ 0.44777609571699672486, 0.00501885978692984125 },
{ /* 70 f= 7000 */ 0.45415252606874645380, 0.00501885978692984125 },
{ /* 71 f= 7100 */ 0.46052409281180473055, 0.00501885978692984125 },
{ /* 72 f= 7200 */ 0.46689072771181078236, 0.00501885978692984125 },
{ /* 73 f= 7300 */ 0.47325236258721975480, 0.00501885978692984125 },
{ /* 74 f= 7400 */ 0.47960892931003307194, 0.00501885978692984125 },
{ /* 75 f= 7500 */ 0.48596035980652774189, 0.00501885978692984125 },
{ /* 76 f= 7600 */ 0.49230658605798605088, 0.00501885978692984125 },
{ /* 77 f= 7700 */ 0.49864754010142336993, 0.00501885978692984125 },
{ /* 78 f= 7800 */ 0.50498315403031590609, 0.00501885978692984125 },
{ /* 79 f= 7900 */ 0.51131335999532878667, 0.00501885978692984125 },
{ /* 80 f= 8000 */ 0.51763809020504147895, 0.00501885978692984125 },
{ /* 81 f= 8100 */ 0.52395727692667493081, 0.00501885978692984125 },
{ /* 82 f= 8200 */ 0.53027085248681604668, 0.00501885978692984125 },
{ /* 83 f= 8300 */ 0.53657874927214277427, 0.00501885978692984125 },
{ /* 84 f= 8400 */ 0.54288089973014852507, 0.00501885978692984125 },
{ /* 85 f= 8500 */ 0.54917723636986470748, 0.00501885978692984125 },
{ /* 86 f= 8600 */ 0.55546769176258437017, 0.00501885978692984125 },
{ /* 87 f= 8700 */ 0.56175219854258418017, 0.00501885978692984125 },
{ /* 88 f= 8800 */ 0.56803068940784517959, 0.00501885978692984125 },
{ /* 89 f= 8900 */ 0.57430309712077465267, 0.00501885978692984125 },
{ /* 90 f= 9000 */ 0.58056935450892466211, 0.00501885978692984125 },
{ /* 91 f= 9100 */ 0.58682939446571336095, 0.00501885978692984125 },
{ /* 92 f= 9200 */ 0.59308314995114197465, 0.00501885978692984125 },
{ /* 93 f= 9300 */ 0.59933055399251322637, 0.00501885978692984125 },
{ /* 94 f= 9400 */ 0.60557153968514920717, 0.00501885978692984125 },
{ /* 95 f= 9500 */ 0.61180604019310691477, 0.00501885978692984125 },
{ /* 96 f= 9600 */ 0.61803398874989479150, 0.00501885978692984125 },
{ /* 97 f= 9700 */ 0.62425531865918737484, 0.00501885978692984125 },
{ /* 98 f= 9800 */ 0.63046996329553928184, 0.00501885978692984125 },
{ /* 99 f= 9900 */ 0.63667785610509941563, 0.00501885978692984125 },
{ /*100 f=10000 */ 0.64287893060632317344, 0.00501885978692984125 },
{ /*101 f=10100 */ 0.64907312039068432163, 0.00501885978692984125 },
{ /*102 f=10200 */ 0.65526035912338698175, 0.00501885978692984125 },
{ /*103 f=10300 */ 0.66144058054407484093, 0.00501885978692984125 },
{ /*104 f=10400 */ 0.66761371846754191672, 0.00501885978692984125 },
{ /*105 f=10500 */ 0.67377970678444010222, 0.00501885978692984125 },
{ /*106 f=10600 */ 0.67993847946198837651, 0.00501885978692984125 },
{ /*107 f=10700 */ 0.68608997054467968368, 0.00501885978692984125 },
{ /*108 f=10800 */ 0.69223411415498592447, 0.00501885978692984125 },
{ /*109 f=10900 */ 0.69837084449406572340, 0.00501885978692984125 },
{ /*110 f=11000 */ 0.70450009584246697791, 0.00501885978692984125 },
{ /*111 f=11100 */ 0.71062180256083218310, 0.00501885978692984125 },
{ /*112 f=11200 */ 0.71673589909060053671, 0.00501885978692984125 },
{ /*113 f=11300 */ 0.72284231995471004417, 0.00501885978692984125 },
{ /*114 f=11400 */ 0.72894099975829929061, 0.00501885978692984125 },
{ /*115 f=11500 */ 0.73503187318940710338, 0.00501885978692984125 },
{ /*116 f=11600 */ 0.74111487501967243663, 0.00501885978692984125 },
{ /*117 f=11700 */ 0.74718994010503270164, 0.00501885978692984125 },
{ /*118 f=11800 */ 0.75325700338642143095, 0.00501885978692984125 },
{ /*119 f=11900 */ 0.75931599989046549837, 0.00501885978692984125 },
{ /*120 f=12000 */ 0.76536686473017956356, 0.00501885978692984125 },
{ /*121 f=12100 */ 0.77140953310566262591, 0.00501885978692984125 },
{ /*122 f=12200 */ 0.77744394030479113678, 0.00501885978692984125 },
{ /*123 f=12300 */ 0.78347002170391177867, 0.00501885978692984125 },
{ /*124 f=12400 */ 0.78948771276853446643, 0.00501885978692984125 },
{ /*125 f=12500 */ 0.79549694905402212886, 0.00501885978692984125 },
{ /*126 f=12600 */ 0.80149766620628193348, 0.00501885978692984125 },
{ /*127 f=12700 */ 0.80748979996245418000, 0.00501885978692984125 },
{ /*128 f=12800 */ 0.81347328615160030552, 0.00501885978692984125 },
{ /*129 f=12900 */ 0.81944806069539055660, 0.00501885978692984125 },
{ /*130 f=13000 */ 0.82541405960878933001, 0.00501885978692984125 },
{ /*131 f=13100 */ 0.83137121900074162362, 0.00501885978692984125 },
{ /*132 f=13200 */ 0.83731947507485626758, 0.00501885978692984125 },
{ /*133 f=13300 */ 0.84325876413008904464, 0.00501885978692984125 },
{ /*134 f=13400 */ 0.84918902256142625440, 0.00501885978692984125 },
{ /*135 f=13500 */ 0.85511018686056416982, 0.00501885978692984125 },
{ /*136 f=13600 */ 0.86102219361659015906, 0.00501885978692984125 },
{ /*137 f=13700 */ 0.86692497951666180889, 0.00501885978692984125 },
{ /*138 f=13800 */ 0.87281848134668404970, 0.00501885978692984125 },
{ /*139 f=13900 */ 0.87870263599198739080, 0.00501885978692984125 },
{ /*140 f=14000 */ 0.88457738043800260286, 0.00501885978692984125 },
{ /*141 f=14100 */ 0.89044265177093639974, 0.00501885978692984125 },
{ /*142 f=14200 */ 0.89629838717844512175, 0.00501885978692984125 },
{ /*143 f=14300 */ 0.90214452395030675369, 0.00501885978692984125 },
{ /*144 f=14400 */ 0.90798099947909349794, 0.00501885978692984125 },
{ /*145 f=14500 */ 0.91380775126084123894, 0.00501885978692984125 },
{ /*146 f=14600 */ 0.91962471689571967381, 0.00501885978692984125 },
{ /*147 f=14700 */ 0.92543183408870022255, 0.00501885978692984125 },
{ /*148 f=14800 */ 0.93122904065022282794, 0.00501885978692984125 },
{ /*149 f=14900 */ 0.93701627449686286653, 0.00501885978692984125 },
{ /*150 f=15000 */ 0.94279347365199528408, 0.00501885978692984125 },
{ /*151 f=15100 */ 0.94856057624645839788, 0.00501885978692984125 },
{ /*152 f=15200 */ 0.95431752051921681090, 0.00501885978692984125 },
{ /*153 f=15300 */ 0.96006424481802221660, 0.00501885978692984125 },
{ /*154 f=15400 */ 0.96580068760007475870, 0.00501885978692984125 },
{ /*155 f=15500 */ 0.97152678743268006123, 0.00501885978692984125 },
{ /*156 f=15600 */ 0.97724248299390981121, 0.00501885978692984125 },
{ /*157 f=15700 */ 0.98294771307325645715, 0.00501885978692984125 },
{ /*158 f=15800 */ 0.98864241657228923987, 0.00501885978692984125 },
{ /*159 f=15900 */ 0.99432653250530855793, 0.00501885978692984125 },
{ /*160 f=16000 */ 0.99999999999999988898, 0.00501885978692984125 },
{ /*161 f=16100 */ 1.00566275829808415843, 0.00501885978692984125 },
{ /*162 f=16200 */ 1.01131474675596910728, 0.00501885978692984125 },
{ /*163 f=16300 */ 1.01695590484539954979, 0.00501885978692984125 },
{ /*164 f=16400 */ 1.02258617215410430035, 0.00501885978692984125 },
{ /*165 f=16500 */ 1.02820548838644332257, 0.00501885978692984125 },
{ /*166 f=16600 */ 1.03381379336405498925, 0.00501885978692984125 },
{ /*167 f=16700 */ 1.03941102702649845746, 0.00501885978692984125 },
{ /*168 f=16800 */ 1.04499712943189759784, 0.00501885978692984125 },
{ /*169 f=16900 */ 1.05057204075758403583, 0.00501885978692984125 },
{ /*170 f=17000 */ 1.05613570130073597397, 0.00501885978692984125 },
{ /*171 f=17100 */ 1.06168805147901901265, 0.00501885978692984125 },
{ /*172 f=17200 */ 1.06722903183122297399, 0.00501885978692984125 },
{ /*173 f=17300 */ 1.07275858301790050220, 0.00501885978692984125 },
{ /*174 f=17400 */ 1.07827664582200033472, 0.00501885978692984125 },
{ /*175 f=17500 */ 1.08378316114950346005, 0.00501885978692984125 },
{ /*176 f=17600 */ 1.08927807003005394648, 0.00501885978692984125 },
{ /*177 f=17700 */ 1.09476131361759310145, 0.00501885978692984125 },
{ /*178 f=17800 */ 1.10023283319098674760, 0.00501885978692984125 },
{ /*179 f=17900 */ 1.10569257015465582938, 0.00501885978692984125 },
{ /*180 f=18000 */ 1.11114046603920435530, 0.00501885978692984125 },
{ /*181 f=18100 */ 1.11657646250204400928, 0.00501885978692984125 },
{ /*182 f=18200 */ 1.12200050132801965042, 0.00501885978692984125 },
{ /*183 f=18300 */ 1.12741252443003325823, 0.00501885978692984125 },
{ /*184 f=18400 */ 1.13281247384966565761, 0.00501885978692984125 },
{ /*185 f=18500 */ 1.13820029175779646735, 0.00501885978692984125 },
{ /*186 f=18600 */ 1.14357592045522449276, 0.00501885978692984125 },
{ /*187 f=18700 */ 1.14893930237328523170, 0.00501885978692984125 },
{ /*188 f=18800 */ 1.15429038007446727043, 0.00501885978692984125 },
{ /*189 f=18900 */ 1.15962909625302712513, 0.00501885978692984125 },
{ /*190 f=19000 */ 1.16495539373560430541, 0.00501885978692984125 },
{ /*191 f=19100 */ 1.17026921548183104882, 0.00501885978692984125 },
{ /*192 f=19200 */ 1.17557050458494627421, 0.00501885978692984125 },
{ /*193 f=19300 */ 1.18085920427240220754, 0.00501885978692984125 },
{ /*194 f=19400 */ 1.18613525790647433844, 0.00501885978692984125 },
{ /*195 f=19500 */ 1.19139860898486671381, 0.00501885978692984125 },
{ /*196 f=19600 */ 1.19664920114131789752, 0.00501885978692984125 },
{ /*197 f=19700 */ 1.20188697814620470972, 0.00501885978692984125 },
{ /*198 f=19800 */ 1.20711188390714285745, 0.00501885978692984125 },
{ /*199 f=19900 */ 1.21232386246958934173, 0.00501885978692984125 },
{ /*200 f=20000 */ 1.21752285801744131177, 0.00501885978692984125 },
{ /*201 f=20100 */ 1.22270881487363292095, 0.00501885978692984125 },
{ /*202 f=20200 */ 1.22788167750073284878, 0.00501885978692984125 },
{ /*203 f=20300 */ 1.23304139050153827029, 0.00501885978692984125 },
{ /*204 f=20400 */ 1.23818789861966793708, 0.00501885978692984125 },
{ /*205 f=20500 */ 1.24332114674015481448, 0.00501885978692984125 },
{ /*206 f=20600 */ 1.24844107989003516579, 0.00501885978692984125 },
{ /*207 f=20700 */ 1.25354764323893919098, 0.00501885978692984125 },
{ /*208 f=20800 */ 1.25864078209967500399, 0.00501885978692984125 },
{ /*209 f=20900 */ 1.26372044192881749503, 0.00501885978692984125 },
{ /*210 f=21000 */ 1.26878656832729097559, 0.00501885978692984125 },
{ /*211 f=21100 */ 1.27383910704095182354, 0.00501885978692984125 },
{ /*212 f=21200 */ 1.27887800396116935175, 0.00501885978692984125 },
{ /*213 f=21300 */ 1.28390320512540601072, 0.00501885978692984125 },
{ /*214 f=21400 */ 1.28891465671779492652, 0.00501885978692984125 },
{ /*215 f=21500 */ 1.29391230506971455227, 0.00501885978692984125 },
{ /*216 f=21600 */ 1.29889609666036731639, 0.00501885978692984125 },
{ /*217 f=21700 */ 1.30386597811734850083, 0.00501885978692984125 },
{ /*218 f=21800 */ 1.30882189621722067052, 0.00501885978692984125 },
{ /*219 f=21900 */ 1.31376379788608255161, 0.00501885978692984125 },
{ /*220 f=22000 */ 1.31869163020013768772, 0.00501885978692984125 },
{ /*221 f=22100 */ 1.32360534038626065367, 0.00501885978692984125 },
{ /*222 f=22200 */ 1.32850487582256349128, 0.00501885978692984125 },
{ /*223 f=22300 */ 1.33339018403895726017, 0.00501885978692984125 },
{ /*224 f=22400 */ 1.33826121271771647514, 0.00501885978692984125 },
{ /*225 f=22500 */ 1.34311790969403666018, 0.00501885978692984125 },
{ /*226 f=22600 */ 1.34796022295659567725, 0.00501885978692984125 },
{ /*227 f=22700 */ 1.35278810064810839364, 0.00501885978692984125 },
{ /*228 f=22800 */ 1.35760149106588334789, 0.00501885978692984125 },
{ /*229 f=22900 */ 1.36240034266237652893, 0.00501885978692984125 },
{ /*230 f=23000 */ 1.36718460404574249090, 0.00501885978692984125 },
{ /*231 f=23100 */ 1.37195422398038568979, 0.00501885978692984125 },
{ /*232 f=23200 */ 1.37670915138750782347, 0.00501885978692984125 },
{ /*233 f=23300 */ 1.38144933534565739208, 0.00501885978692984125 },
{ /*234 f=23400 */ 1.38617472509127170888, 0.00501885978692984125 },
{ /*235 f=23500 */ 1.39088527001922335202, 0.00501885978692984125 },
{ /*236 f=23600 */ 1.39558091968336017707, 0.00501885978692984125 },
{ /*237 f=23700 */ 1.40026162379704732786, 0.00501885978692984125 },
{ /*238 f=23800 */ 1.40492733223370347417, 0.00501885978692984125 },
{ /*239 f=23900 */ 1.40957799502734015817, 0.00501885978692984125 },
{ /*240 f=24000 */ 1.41421356237309492343, 0.00501885978692984125 }
};
static FLOAT_T vsf_q210[241][2] = {
{ /* dummy entry */ 0, 0},
{ /*  1 f=  100 */ 0.00654497301305325026, 0.00398352645444921549 },
{ /*  2 f=  200 */ 0.01308987593470371628, 0.00398352645444921549 },
{ /*  3 f=  300 */ 0.01963463867429923390, 0.00398352645444921549 },
{ /*  4 f=  400 */ 0.02617919114268887903, 0.00398352645444921549 },
{ /*  5 f=  500 */ 0.03272346325297356001, 0.00398352645444921549 },
{ /*  6 f=  600 */ 0.03926738492125660118, 0.00398352645444921549 },
{ /*  7 f=  700 */ 0.04581088606739427971, 0.00398352645444921549 },
{ /*  8 f=  800 */ 0.05235389661574629816, 0.00398352645444921549 },
{ /*  9 f=  900 */ 0.05889634649592632304, 0.00398352645444921549 },
{ /* 10 f= 1000 */ 0.06543816564355227350, 0.00398352645444921549 },
{ /* 11 f= 1100 */ 0.07197928400099674884, 0.00398352645444921549 },
{ /* 12 f= 1200 */ 0.07851963151813722008, 0.00398352645444921549 },
{ /* 13 f= 1300 */ 0.08505913815310624237, 0.00398352645444921549 },
{ /* 14 f= 1400 */ 0.09159773387304154246, 0.00398352645444921549 },
{ /* 15 f= 1500 */ 0.09813534865483602987, 0.00398352645444921549 },
{ /* 16 f= 1600 */ 0.10467191248588765540, 0.00398352645444921549 },
{ /* 17 f= 1700 */ 0.11120735536484922801, 0.00398352645444921549 },
{ /* 18 f= 1800 */ 0.11774160730237806516, 0.00398352645444921549 },
{ /* 19 f= 1900 */ 0.12427459832188544886, 0.00398352645444921549 },
{ /* 20 f= 2000 */ 0.13080625846028612336, 0.00398352645444921549 },
{ /* 21 f= 2100 */ 0.13733651776874752914, 0.00398352645444921549 },
{ /* 22 f= 2200 */ 0.14386530631343877329, 0.00398352645444921549 },
{ /* 23 f= 2300 */ 0.15039255417627980793, 0.00398352645444921549 },
{ /* 24 f= 2400 */ 0.15691819145568988714, 0.00398352645444921549 },
{ /* 25 f= 2500 */ 0.16344214826733644008, 0.00398352645444921549 },
{ /* 26 f= 2600 */ 0.16996435474488333361, 0.00398352645444921549 },
{ /* 27 f= 2700 */ 0.17648474104073902380, 0.00398352645444921549 },
{ /* 28 f= 2800 */ 0.18300323732680476296, 0.00398352645444921549 },
{ /* 29 f= 2900 */ 0.18951977379522222389, 0.00398352645444921549 },
{ /* 30 f= 3000 */ 0.19603428065912120726, 0.00398352645444921549 },
{ /* 31 f= 3100 */ 0.20254668815336684951, 0.00398352645444921549 },
{ /* 32 f= 3200 */ 0.20905692653530691394, 0.00398352645444921549 },
{ /* 33 f= 3300 */ 0.21556492608551869328, 0.00398352645444921549 },
{ /* 34 f= 3400 */ 0.22207061710855535708, 0.00398352645444921549 },
{ /* 35 f= 3500 */ 0.22857392993369279877, 0.00398352645444921549 },
{ /* 36 f= 3600 */ 0.23507479491567528918, 0.00398352645444921549 },
{ /* 37 f= 3700 */ 0.24157314243546165744, 0.00398352645444921549 },
{ /* 38 f= 3800 */ 0.24806890290097063922, 0.00398352645444921549 },
{ /* 39 f= 3900 */ 0.25456200674782641924, 0.00398352645444921549 },
{ /* 40 f= 4000 */ 0.26105238444010314680, 0.00398352645444921549 },
{ /* 41 f= 4100 */ 0.26753996647107025630, 0.00398352645444921549 },
{ /* 42 f= 4200 */ 0.27402468336393603909, 0.00398352645444921549 },
{ /* 43 f= 4300 */ 0.28050646567259251984, 0.00398352645444921549 },
{ /* 44 f= 4400 */ 0.28698524398235858435, 0.00398352645444921549 },
{ /* 45 f= 4500 */ 0.29346094891072349586, 0.00398352645444921549 },
{ /* 46 f= 4600 */ 0.29993351110809002291, 0.00398352645444921549 },
{ /* 47 f= 4700 */ 0.30640286125851695642, 0.00398352645444921549 },
{ /* 48 f= 4800 */ 0.31286893008046173792, 0.00398352645444921549 },
{ /* 49 f= 4900 */ 0.31933164832752197748, 0.00398352645444921549 },
{ /* 50 f= 5000 */ 0.32579094678917747130, 0.00398352645444921549 },
{ /* 51 f= 5100 */ 0.33224675629153094247, 0.00398352645444921549 },
{ /* 52 f= 5200 */ 0.33869900769804922591, 0.00398352645444921549 },
{ /* 53 f= 5300 */ 0.34514763191030339851, 0.00398352645444921549 },
{ /* 54 f= 5400 */ 0.35159255986870902033, 0.00398352645444921549 },
{ /* 55 f= 5500 */ 0.35803372255326532114, 0.00398352645444921549 },
{ /* 56 f= 5600 */ 0.36447105098429494197, 0.00398352645444921549 },
{ /* 57 f= 5700 */ 0.37090447622318184484, 0.00398352645444921549 },
{ /* 58 f= 5800 */ 0.37733392937311044379, 0.00398352645444921549 },
{ /* 59 f= 5900 */ 0.38375934157980284844, 0.00398352645444921549 },
{ /* 60 f= 6000 */ 0.39018064403225649617, 0.00398352645444921549 },
{ /* 61 f= 6100 */ 0.39659776796348089611, 0.00398352645444921549 },
{ /* 62 f= 6200 */ 0.40301064465123426217, 0.00398352645444921549 },
{ /* 63 f= 6300 */ 0.40941920541875920225, 0.00398352645444921549 },
{ /* 64 f= 6400 */ 0.41582338163551862964, 0.00398352645444921549 },
{ /* 65 f= 6500 */ 0.42222310471793028652, 0.00398352645444921549 },
{ /* 66 f= 6600 */ 0.42861830613010154511, 0.00398352645444921549 },
{ /* 67 f= 6700 */ 0.43500891738456293201, 0.00398352645444921549 },
{ /* 68 f= 6800 */ 0.44139487004300215212, 0.00398352645444921549 },
{ /* 69 f= 6900 */ 0.44777609571699672486, 0.00398352645444921549 },
{ /* 70 f= 7000 */ 0.45415252606874645380, 0.00398352645444921549 },
{ /* 71 f= 7100 */ 0.46052409281180473055, 0.00398352645444921549 },
{ /* 72 f= 7200 */ 0.46689072771181078236, 0.00398352645444921549 },
{ /* 73 f= 7300 */ 0.47325236258721975480, 0.00398352645444921549 },
{ /* 74 f= 7400 */ 0.47960892931003307194, 0.00398352645444921549 },
{ /* 75 f= 7500 */ 0.48596035980652774189, 0.00398352645444921549 },
{ /* 76 f= 7600 */ 0.49230658605798605088, 0.00398352645444921549 },
{ /* 77 f= 7700 */ 0.49864754010142336993, 0.00398352645444921549 },
{ /* 78 f= 7800 */ 0.50498315403031590609, 0.00398352645444921549 },
{ /* 79 f= 7900 */ 0.51131335999532878667, 0.00398352645444921549 },
{ /* 80 f= 8000 */ 0.51763809020504147895, 0.00398352645444921549 },
{ /* 81 f= 8100 */ 0.52395727692667493081, 0.00398352645444921549 },
{ /* 82 f= 8200 */ 0.53027085248681604668, 0.00398352645444921549 },
{ /* 83 f= 8300 */ 0.53657874927214277427, 0.00398352645444921549 },
{ /* 84 f= 8400 */ 0.54288089973014852507, 0.00398352645444921549 },
{ /* 85 f= 8500 */ 0.54917723636986470748, 0.00398352645444921549 },
{ /* 86 f= 8600 */ 0.55546769176258437017, 0.00398352645444921549 },
{ /* 87 f= 8700 */ 0.56175219854258418017, 0.00398352645444921549 },
{ /* 88 f= 8800 */ 0.56803068940784517959, 0.00398352645444921549 },
{ /* 89 f= 8900 */ 0.57430309712077465267, 0.00398352645444921549 },
{ /* 90 f= 9000 */ 0.58056935450892466211, 0.00398352645444921549 },
{ /* 91 f= 9100 */ 0.58682939446571336095, 0.00398352645444921549 },
{ /* 92 f= 9200 */ 0.59308314995114197465, 0.00398352645444921549 },
{ /* 93 f= 9300 */ 0.59933055399251322637, 0.00398352645444921549 },
{ /* 94 f= 9400 */ 0.60557153968514920717, 0.00398352645444921549 },
{ /* 95 f= 9500 */ 0.61180604019310691477, 0.00398352645444921549 },
{ /* 96 f= 9600 */ 0.61803398874989479150, 0.00398352645444921549 },
{ /* 97 f= 9700 */ 0.62425531865918737484, 0.00398352645444921549 },
{ /* 98 f= 9800 */ 0.63046996329553928184, 0.00398352645444921549 },
{ /* 99 f= 9900 */ 0.63667785610509941563, 0.00398352645444921549 },
{ /*100 f=10000 */ 0.64287893060632317344, 0.00398352645444921549 },
{ /*101 f=10100 */ 0.64907312039068432163, 0.00398352645444921549 },
{ /*102 f=10200 */ 0.65526035912338698175, 0.00398352645444921549 },
{ /*103 f=10300 */ 0.66144058054407484093, 0.00398352645444921549 },
{ /*104 f=10400 */ 0.66761371846754191672, 0.00398352645444921549 },
{ /*105 f=10500 */ 0.67377970678444010222, 0.00398352645444921549 },
{ /*106 f=10600 */ 0.67993847946198837651, 0.00398352645444921549 },
{ /*107 f=10700 */ 0.68608997054467968368, 0.00398352645444921549 },
{ /*108 f=10800 */ 0.69223411415498592447, 0.00398352645444921549 },
{ /*109 f=10900 */ 0.69837084449406572340, 0.00398352645444921549 },
{ /*110 f=11000 */ 0.70450009584246697791, 0.00398352645444921549 },
{ /*111 f=11100 */ 0.71062180256083218310, 0.00398352645444921549 },
{ /*112 f=11200 */ 0.71673589909060053671, 0.00398352645444921549 },
{ /*113 f=11300 */ 0.72284231995471004417, 0.00398352645444921549 },
{ /*114 f=11400 */ 0.72894099975829929061, 0.00398352645444921549 },
{ /*115 f=11500 */ 0.73503187318940710338, 0.00398352645444921549 },
{ /*116 f=11600 */ 0.74111487501967243663, 0.00398352645444921549 },
{ /*117 f=11700 */ 0.74718994010503270164, 0.00398352645444921549 },
{ /*118 f=11800 */ 0.75325700338642143095, 0.00398352645444921549 },
{ /*119 f=11900 */ 0.75931599989046549837, 0.00398352645444921549 },
{ /*120 f=12000 */ 0.76536686473017956356, 0.00398352645444921549 },
{ /*121 f=12100 */ 0.77140953310566262591, 0.00398352645444921549 },
{ /*122 f=12200 */ 0.77744394030479113678, 0.00398352645444921549 },
{ /*123 f=12300 */ 0.78347002170391177867, 0.00398352645444921549 },
{ /*124 f=12400 */ 0.78948771276853446643, 0.00398352645444921549 },
{ /*125 f=12500 */ 0.79549694905402212886, 0.00398352645444921549 },
{ /*126 f=12600 */ 0.80149766620628193348, 0.00398352645444921549 },
{ /*127 f=12700 */ 0.80748979996245418000, 0.00398352645444921549 },
{ /*128 f=12800 */ 0.81347328615160030552, 0.00398352645444921549 },
{ /*129 f=12900 */ 0.81944806069539055660, 0.00398352645444921549 },
{ /*130 f=13000 */ 0.82541405960878933001, 0.00398352645444921549 },
{ /*131 f=13100 */ 0.83137121900074162362, 0.00398352645444921549 },
{ /*132 f=13200 */ 0.83731947507485626758, 0.00398352645444921549 },
{ /*133 f=13300 */ 0.84325876413008904464, 0.00398352645444921549 },
{ /*134 f=13400 */ 0.84918902256142625440, 0.00398352645444921549 },
{ /*135 f=13500 */ 0.85511018686056416982, 0.00398352645444921549 },
{ /*136 f=13600 */ 0.86102219361659015906, 0.00398352645444921549 },
{ /*137 f=13700 */ 0.86692497951666180889, 0.00398352645444921549 },
{ /*138 f=13800 */ 0.87281848134668404970, 0.00398352645444921549 },
{ /*139 f=13900 */ 0.87870263599198739080, 0.00398352645444921549 },
{ /*140 f=14000 */ 0.88457738043800260286, 0.00398352645444921549 },
{ /*141 f=14100 */ 0.89044265177093639974, 0.00398352645444921549 },
{ /*142 f=14200 */ 0.89629838717844512175, 0.00398352645444921549 },
{ /*143 f=14300 */ 0.90214452395030675369, 0.00398352645444921549 },
{ /*144 f=14400 */ 0.90798099947909349794, 0.00398352645444921549 },
{ /*145 f=14500 */ 0.91380775126084123894, 0.00398352645444921549 },
{ /*146 f=14600 */ 0.91962471689571967381, 0.00398352645444921549 },
{ /*147 f=14700 */ 0.92543183408870022255, 0.00398352645444921549 },
{ /*148 f=14800 */ 0.93122904065022282794, 0.00398352645444921549 },
{ /*149 f=14900 */ 0.93701627449686286653, 0.00398352645444921549 },
{ /*150 f=15000 */ 0.94279347365199528408, 0.00398352645444921549 },
{ /*151 f=15100 */ 0.94856057624645839788, 0.00398352645444921549 },
{ /*152 f=15200 */ 0.95431752051921681090, 0.00398352645444921549 },
{ /*153 f=15300 */ 0.96006424481802221660, 0.00398352645444921549 },
{ /*154 f=15400 */ 0.96580068760007475870, 0.00398352645444921549 },
{ /*155 f=15500 */ 0.97152678743268006123, 0.00398352645444921549 },
{ /*156 f=15600 */ 0.97724248299390981121, 0.00398352645444921549 },
{ /*157 f=15700 */ 0.98294771307325645715, 0.00398352645444921549 },
{ /*158 f=15800 */ 0.98864241657228923987, 0.00398352645444921549 },
{ /*159 f=15900 */ 0.99432653250530855793, 0.00398352645444921549 },
{ /*160 f=16000 */ 0.99999999999999988898, 0.00398352645444921549 },
{ /*161 f=16100 */ 1.00566275829808415843, 0.00398352645444921549 },
{ /*162 f=16200 */ 1.01131474675596910728, 0.00398352645444921549 },
{ /*163 f=16300 */ 1.01695590484539954979, 0.00398352645444921549 },
{ /*164 f=16400 */ 1.02258617215410430035, 0.00398352645444921549 },
{ /*165 f=16500 */ 1.02820548838644332257, 0.00398352645444921549 },
{ /*166 f=16600 */ 1.03381379336405498925, 0.00398352645444921549 },
{ /*167 f=16700 */ 1.03941102702649845746, 0.00398352645444921549 },
{ /*168 f=16800 */ 1.04499712943189759784, 0.00398352645444921549 },
{ /*169 f=16900 */ 1.05057204075758403583, 0.00398352645444921549 },
{ /*170 f=17000 */ 1.05613570130073597397, 0.00398352645444921549 },
{ /*171 f=17100 */ 1.06168805147901901265, 0.00398352645444921549 },
{ /*172 f=17200 */ 1.06722903183122297399, 0.00398352645444921549 },
{ /*173 f=17300 */ 1.07275858301790050220, 0.00398352645444921549 },
{ /*174 f=17400 */ 1.07827664582200033472, 0.00398352645444921549 },
{ /*175 f=17500 */ 1.08378316114950346005, 0.00398352645444921549 },
{ /*176 f=17600 */ 1.08927807003005394648, 0.00398352645444921549 },
{ /*177 f=17700 */ 1.09476131361759310145, 0.00398352645444921549 },
{ /*178 f=17800 */ 1.10023283319098674760, 0.00398352645444921549 },
{ /*179 f=17900 */ 1.10569257015465582938, 0.00398352645444921549 },
{ /*180 f=18000 */ 1.11114046603920435530, 0.00398352645444921549 },
{ /*181 f=18100 */ 1.11657646250204400928, 0.00398352645444921549 },
{ /*182 f=18200 */ 1.12200050132801965042, 0.00398352645444921549 },
{ /*183 f=18300 */ 1.12741252443003325823, 0.00398352645444921549 },
{ /*184 f=18400 */ 1.13281247384966565761, 0.00398352645444921549 },
{ /*185 f=18500 */ 1.13820029175779646735, 0.00398352645444921549 },
{ /*186 f=18600 */ 1.14357592045522449276, 0.00398352645444921549 },
{ /*187 f=18700 */ 1.14893930237328523170, 0.00398352645444921549 },
{ /*188 f=18800 */ 1.15429038007446727043, 0.00398352645444921549 },
{ /*189 f=18900 */ 1.15962909625302712513, 0.00398352645444921549 },
{ /*190 f=19000 */ 1.16495539373560430541, 0.00398352645444921549 },
{ /*191 f=19100 */ 1.17026921548183104882, 0.00398352645444921549 },
{ /*192 f=19200 */ 1.17557050458494627421, 0.00398352645444921549 },
{ /*193 f=19300 */ 1.18085920427240220754, 0.00398352645444921549 },
{ /*194 f=19400 */ 1.18613525790647433844, 0.00398352645444921549 },
{ /*195 f=19500 */ 1.19139860898486671381, 0.00398352645444921549 },
{ /*196 f=19600 */ 1.19664920114131789752, 0.00398352645444921549 },
{ /*197 f=19700 */ 1.20188697814620470972, 0.00398352645444921549 },
{ /*198 f=19800 */ 1.20711188390714285745, 0.00398352645444921549 },
{ /*199 f=19900 */ 1.21232386246958934173, 0.00398352645444921549 },
{ /*200 f=20000 */ 1.21752285801744131177, 0.00398352645444921549 },
{ /*201 f=20100 */ 1.22270881487363292095, 0.00398352645444921549 },
{ /*202 f=20200 */ 1.22788167750073284878, 0.00398352645444921549 },
{ /*203 f=20300 */ 1.23304139050153827029, 0.00398352645444921549 },
{ /*204 f=20400 */ 1.23818789861966793708, 0.00398352645444921549 },
{ /*205 f=20500 */ 1.24332114674015481448, 0.00398352645444921549 },
{ /*206 f=20600 */ 1.24844107989003516579, 0.00398352645444921549 },
{ /*207 f=20700 */ 1.25354764323893919098, 0.00398352645444921549 },
{ /*208 f=20800 */ 1.25864078209967500399, 0.00398352645444921549 },
{ /*209 f=20900 */ 1.26372044192881749503, 0.00398352645444921549 },
{ /*210 f=21000 */ 1.26878656832729097559, 0.00398352645444921549 },
{ /*211 f=21100 */ 1.27383910704095182354, 0.00398352645444921549 },
{ /*212 f=21200 */ 1.27887800396116935175, 0.00398352645444921549 },
{ /*213 f=21300 */ 1.28390320512540601072, 0.00398352645444921549 },
{ /*214 f=21400 */ 1.28891465671779492652, 0.00398352645444921549 },
{ /*215 f=21500 */ 1.29391230506971455227, 0.00398352645444921549 },
{ /*216 f=21600 */ 1.29889609666036731639, 0.00398352645444921549 },
{ /*217 f=21700 */ 1.30386597811734850083, 0.00398352645444921549 },
{ /*218 f=21800 */ 1.30882189621722067052, 0.00398352645444921549 },
{ /*219 f=21900 */ 1.31376379788608255161, 0.00398352645444921549 },
{ /*220 f=22000 */ 1.31869163020013768772, 0.00398352645444921549 },
{ /*221 f=22100 */ 1.32360534038626065367, 0.00398352645444921549 },
{ /*222 f=22200 */ 1.32850487582256349128, 0.00398352645444921549 },
{ /*223 f=22300 */ 1.33339018403895726017, 0.00398352645444921549 },
{ /*224 f=22400 */ 1.33826121271771647514, 0.00398352645444921549 },
{ /*225 f=22500 */ 1.34311790969403666018, 0.00398352645444921549 },
{ /*226 f=22600 */ 1.34796022295659567725, 0.00398352645444921549 },
{ /*227 f=22700 */ 1.35278810064810839364, 0.00398352645444921549 },
{ /*228 f=22800 */ 1.35760149106588334789, 0.00398352645444921549 },
{ /*229 f=22900 */ 1.36240034266237652893, 0.00398352645444921549 },
{ /*230 f=23000 */ 1.36718460404574249090, 0.00398352645444921549 },
{ /*231 f=23100 */ 1.37195422398038568979, 0.00398352645444921549 },
{ /*232 f=23200 */ 1.37670915138750782347, 0.00398352645444921549 },
{ /*233 f=23300 */ 1.38144933534565739208, 0.00398352645444921549 },
{ /*234 f=23400 */ 1.38617472509127170888, 0.00398352645444921549 },
{ /*235 f=23500 */ 1.39088527001922335202, 0.00398352645444921549 },
{ /*236 f=23600 */ 1.39558091968336017707, 0.00398352645444921549 },
{ /*237 f=23700 */ 1.40026162379704732786, 0.00398352645444921549 },
{ /*238 f=23800 */ 1.40492733223370347417, 0.00398352645444921549 },
{ /*239 f=23900 */ 1.40957799502734015817, 0.00398352645444921549 },
{ /*240 f=24000 */ 1.41421356237309492343, 0.00398352645444921549 }
};
static FLOAT_T vsf_q220[241][2] = {
{ /* dummy entry */ 0, 0},
{ /*  1 f=  100 */ 0.00654497301305325026, 0.00316227858607898149 },
{ /*  2 f=  200 */ 0.01308987593470371628, 0.00316227858607898149 },
{ /*  3 f=  300 */ 0.01963463867429923390, 0.00316227858607898149 },
{ /*  4 f=  400 */ 0.02617919114268887903, 0.00316227858607898149 },
{ /*  5 f=  500 */ 0.03272346325297356001, 0.00316227858607898149 },
{ /*  6 f=  600 */ 0.03926738492125660118, 0.00316227858607898149 },
{ /*  7 f=  700 */ 0.04581088606739427971, 0.00316227858607898149 },
{ /*  8 f=  800 */ 0.05235389661574629816, 0.00316227858607898149 },
{ /*  9 f=  900 */ 0.05889634649592632304, 0.00316227858607898149 },
{ /* 10 f= 1000 */ 0.06543816564355227350, 0.00316227858607898149 },
{ /* 11 f= 1100 */ 0.07197928400099674884, 0.00316227858607898149 },
{ /* 12 f= 1200 */ 0.07851963151813722008, 0.00316227858607898149 },
{ /* 13 f= 1300 */ 0.08505913815310624237, 0.00316227858607898149 },
{ /* 14 f= 1400 */ 0.09159773387304154246, 0.00316227858607898149 },
{ /* 15 f= 1500 */ 0.09813534865483602987, 0.00316227858607898149 },
{ /* 16 f= 1600 */ 0.10467191248588765540, 0.00316227858607898149 },
{ /* 17 f= 1700 */ 0.11120735536484922801, 0.00316227858607898149 },
{ /* 18 f= 1800 */ 0.11774160730237806516, 0.00316227858607898149 },
{ /* 19 f= 1900 */ 0.12427459832188544886, 0.00316227858607898149 },
{ /* 20 f= 2000 */ 0.13080625846028612336, 0.00316227858607898149 },
{ /* 21 f= 2100 */ 0.13733651776874752914, 0.00316227858607898149 },
{ /* 22 f= 2200 */ 0.14386530631343877329, 0.00316227858607898149 },
{ /* 23 f= 2300 */ 0.15039255417627980793, 0.00316227858607898149 },
{ /* 24 f= 2400 */ 0.15691819145568988714, 0.00316227858607898149 },
{ /* 25 f= 2500 */ 0.16344214826733644008, 0.00316227858607898149 },
{ /* 26 f= 2600 */ 0.16996435474488333361, 0.00316227858607898149 },
{ /* 27 f= 2700 */ 0.17648474104073902380, 0.00316227858607898149 },
{ /* 28 f= 2800 */ 0.18300323732680476296, 0.00316227858607898149 },
{ /* 29 f= 2900 */ 0.18951977379522222389, 0.00316227858607898149 },
{ /* 30 f= 3000 */ 0.19603428065912120726, 0.00316227858607898149 },
{ /* 31 f= 3100 */ 0.20254668815336684951, 0.00316227858607898149 },
{ /* 32 f= 3200 */ 0.20905692653530691394, 0.00316227858607898149 },
{ /* 33 f= 3300 */ 0.21556492608551869328, 0.00316227858607898149 },
{ /* 34 f= 3400 */ 0.22207061710855535708, 0.00316227858607898149 },
{ /* 35 f= 3500 */ 0.22857392993369279877, 0.00316227858607898149 },
{ /* 36 f= 3600 */ 0.23507479491567528918, 0.00316227858607898149 },
{ /* 37 f= 3700 */ 0.24157314243546165744, 0.00316227858607898149 },
{ /* 38 f= 3800 */ 0.24806890290097063922, 0.00316227858607898149 },
{ /* 39 f= 3900 */ 0.25456200674782641924, 0.00316227858607898149 },
{ /* 40 f= 4000 */ 0.26105238444010314680, 0.00316227858607898149 },
{ /* 41 f= 4100 */ 0.26753996647107025630, 0.00316227858607898149 },
{ /* 42 f= 4200 */ 0.27402468336393603909, 0.00316227858607898149 },
{ /* 43 f= 4300 */ 0.28050646567259251984, 0.00316227858607898149 },
{ /* 44 f= 4400 */ 0.28698524398235858435, 0.00316227858607898149 },
{ /* 45 f= 4500 */ 0.29346094891072349586, 0.00316227858607898149 },
{ /* 46 f= 4600 */ 0.29993351110809002291, 0.00316227858607898149 },
{ /* 47 f= 4700 */ 0.30640286125851695642, 0.00316227858607898149 },
{ /* 48 f= 4800 */ 0.31286893008046173792, 0.00316227858607898149 },
{ /* 49 f= 4900 */ 0.31933164832752197748, 0.00316227858607898149 },
{ /* 50 f= 5000 */ 0.32579094678917747130, 0.00316227858607898149 },
{ /* 51 f= 5100 */ 0.33224675629153094247, 0.00316227858607898149 },
{ /* 52 f= 5200 */ 0.33869900769804922591, 0.00316227858607898149 },
{ /* 53 f= 5300 */ 0.34514763191030339851, 0.00316227858607898149 },
{ /* 54 f= 5400 */ 0.35159255986870902033, 0.00316227858607898149 },
{ /* 55 f= 5500 */ 0.35803372255326532114, 0.00316227858607898149 },
{ /* 56 f= 5600 */ 0.36447105098429494197, 0.00316227858607898149 },
{ /* 57 f= 5700 */ 0.37090447622318184484, 0.00316227858607898149 },
{ /* 58 f= 5800 */ 0.37733392937311044379, 0.00316227858607898149 },
{ /* 59 f= 5900 */ 0.38375934157980284844, 0.00316227858607898149 },
{ /* 60 f= 6000 */ 0.39018064403225649617, 0.00316227858607898149 },
{ /* 61 f= 6100 */ 0.39659776796348089611, 0.00316227858607898149 },
{ /* 62 f= 6200 */ 0.40301064465123426217, 0.00316227858607898149 },
{ /* 63 f= 6300 */ 0.40941920541875920225, 0.00316227858607898149 },
{ /* 64 f= 6400 */ 0.41582338163551862964, 0.00316227858607898149 },
{ /* 65 f= 6500 */ 0.42222310471793028652, 0.00316227858607898149 },
{ /* 66 f= 6600 */ 0.42861830613010154511, 0.00316227858607898149 },
{ /* 67 f= 6700 */ 0.43500891738456293201, 0.00316227858607898149 },
{ /* 68 f= 6800 */ 0.44139487004300215212, 0.00316227858607898149 },
{ /* 69 f= 6900 */ 0.44777609571699672486, 0.00316227858607898149 },
{ /* 70 f= 7000 */ 0.45415252606874645380, 0.00316227858607898149 },
{ /* 71 f= 7100 */ 0.46052409281180473055, 0.00316227858607898149 },
{ /* 72 f= 7200 */ 0.46689072771181078236, 0.00316227858607898149 },
{ /* 73 f= 7300 */ 0.47325236258721975480, 0.00316227858607898149 },
{ /* 74 f= 7400 */ 0.47960892931003307194, 0.00316227858607898149 },
{ /* 75 f= 7500 */ 0.48596035980652774189, 0.00316227858607898149 },
{ /* 76 f= 7600 */ 0.49230658605798605088, 0.00316227858607898149 },
{ /* 77 f= 7700 */ 0.49864754010142336993, 0.00316227858607898149 },
{ /* 78 f= 7800 */ 0.50498315403031590609, 0.00316227858607898149 },
{ /* 79 f= 7900 */ 0.51131335999532878667, 0.00316227858607898149 },
{ /* 80 f= 8000 */ 0.51763809020504147895, 0.00316227858607898149 },
{ /* 81 f= 8100 */ 0.52395727692667493081, 0.00316227858607898149 },
{ /* 82 f= 8200 */ 0.53027085248681604668, 0.00316227858607898149 },
{ /* 83 f= 8300 */ 0.53657874927214277427, 0.00316227858607898149 },
{ /* 84 f= 8400 */ 0.54288089973014852507, 0.00316227858607898149 },
{ /* 85 f= 8500 */ 0.54917723636986470748, 0.00316227858607898149 },
{ /* 86 f= 8600 */ 0.55546769176258437017, 0.00316227858607898149 },
{ /* 87 f= 8700 */ 0.56175219854258418017, 0.00316227858607898149 },
{ /* 88 f= 8800 */ 0.56803068940784517959, 0.00316227858607898149 },
{ /* 89 f= 8900 */ 0.57430309712077465267, 0.00316227858607898149 },
{ /* 90 f= 9000 */ 0.58056935450892466211, 0.00316227858607898149 },
{ /* 91 f= 9100 */ 0.58682939446571336095, 0.00316227858607898149 },
{ /* 92 f= 9200 */ 0.59308314995114197465, 0.00316227858607898149 },
{ /* 93 f= 9300 */ 0.59933055399251322637, 0.00316227858607898149 },
{ /* 94 f= 9400 */ 0.60557153968514920717, 0.00316227858607898149 },
{ /* 95 f= 9500 */ 0.61180604019310691477, 0.00316227858607898149 },
{ /* 96 f= 9600 */ 0.61803398874989479150, 0.00316227858607898149 },
{ /* 97 f= 9700 */ 0.62425531865918737484, 0.00316227858607898149 },
{ /* 98 f= 9800 */ 0.63046996329553928184, 0.00316227858607898149 },
{ /* 99 f= 9900 */ 0.63667785610509941563, 0.00316227858607898149 },
{ /*100 f=10000 */ 0.64287893060632317344, 0.00316227858607898149 },
{ /*101 f=10100 */ 0.64907312039068432163, 0.00316227858607898149 },
{ /*102 f=10200 */ 0.65526035912338698175, 0.00316227858607898149 },
{ /*103 f=10300 */ 0.66144058054407484093, 0.00316227858607898149 },
{ /*104 f=10400 */ 0.66761371846754191672, 0.00316227858607898149 },
{ /*105 f=10500 */ 0.67377970678444010222, 0.00316227858607898149 },
{ /*106 f=10600 */ 0.67993847946198837651, 0.00316227858607898149 },
{ /*107 f=10700 */ 0.68608997054467968368, 0.00316227858607898149 },
{ /*108 f=10800 */ 0.69223411415498592447, 0.00316227858607898149 },
{ /*109 f=10900 */ 0.69837084449406572340, 0.00316227858607898149 },
{ /*110 f=11000 */ 0.70450009584246697791, 0.00316227858607898149 },
{ /*111 f=11100 */ 0.71062180256083218310, 0.00316227858607898149 },
{ /*112 f=11200 */ 0.71673589909060053671, 0.00316227858607898149 },
{ /*113 f=11300 */ 0.72284231995471004417, 0.00316227858607898149 },
{ /*114 f=11400 */ 0.72894099975829929061, 0.00316227858607898149 },
{ /*115 f=11500 */ 0.73503187318940710338, 0.00316227858607898149 },
{ /*116 f=11600 */ 0.74111487501967243663, 0.00316227858607898149 },
{ /*117 f=11700 */ 0.74718994010503270164, 0.00316227858607898149 },
{ /*118 f=11800 */ 0.75325700338642143095, 0.00316227858607898149 },
{ /*119 f=11900 */ 0.75931599989046549837, 0.00316227858607898149 },
{ /*120 f=12000 */ 0.76536686473017956356, 0.00316227858607898149 },
{ /*121 f=12100 */ 0.77140953310566262591, 0.00316227858607898149 },
{ /*122 f=12200 */ 0.77744394030479113678, 0.00316227858607898149 },
{ /*123 f=12300 */ 0.78347002170391177867, 0.00316227858607898149 },
{ /*124 f=12400 */ 0.78948771276853446643, 0.00316227858607898149 },
{ /*125 f=12500 */ 0.79549694905402212886, 0.00316227858607898149 },
{ /*126 f=12600 */ 0.80149766620628193348, 0.00316227858607898149 },
{ /*127 f=12700 */ 0.80748979996245418000, 0.00316227858607898149 },
{ /*128 f=12800 */ 0.81347328615160030552, 0.00316227858607898149 },
{ /*129 f=12900 */ 0.81944806069539055660, 0.00316227858607898149 },
{ /*130 f=13000 */ 0.82541405960878933001, 0.00316227858607898149 },
{ /*131 f=13100 */ 0.83137121900074162362, 0.00316227858607898149 },
{ /*132 f=13200 */ 0.83731947507485626758, 0.00316227858607898149 },
{ /*133 f=13300 */ 0.84325876413008904464, 0.00316227858607898149 },
{ /*134 f=13400 */ 0.84918902256142625440, 0.00316227858607898149 },
{ /*135 f=13500 */ 0.85511018686056416982, 0.00316227858607898149 },
{ /*136 f=13600 */ 0.86102219361659015906, 0.00316227858607898149 },
{ /*137 f=13700 */ 0.86692497951666180889, 0.00316227858607898149 },
{ /*138 f=13800 */ 0.87281848134668404970, 0.00316227858607898149 },
{ /*139 f=13900 */ 0.87870263599198739080, 0.00316227858607898149 },
{ /*140 f=14000 */ 0.88457738043800260286, 0.00316227858607898149 },
{ /*141 f=14100 */ 0.89044265177093639974, 0.00316227858607898149 },
{ /*142 f=14200 */ 0.89629838717844512175, 0.00316227858607898149 },
{ /*143 f=14300 */ 0.90214452395030675369, 0.00316227858607898149 },
{ /*144 f=14400 */ 0.90798099947909349794, 0.00316227858607898149 },
{ /*145 f=14500 */ 0.91380775126084123894, 0.00316227858607898149 },
{ /*146 f=14600 */ 0.91962471689571967381, 0.00316227858607898149 },
{ /*147 f=14700 */ 0.92543183408870022255, 0.00316227858607898149 },
{ /*148 f=14800 */ 0.93122904065022282794, 0.00316227858607898149 },
{ /*149 f=14900 */ 0.93701627449686286653, 0.00316227858607898149 },
{ /*150 f=15000 */ 0.94279347365199528408, 0.00316227858607898149 },
{ /*151 f=15100 */ 0.94856057624645839788, 0.00316227858607898149 },
{ /*152 f=15200 */ 0.95431752051921681090, 0.00316227858607898149 },
{ /*153 f=15300 */ 0.96006424481802221660, 0.00316227858607898149 },
{ /*154 f=15400 */ 0.96580068760007475870, 0.00316227858607898149 },
{ /*155 f=15500 */ 0.97152678743268006123, 0.00316227858607898149 },
{ /*156 f=15600 */ 0.97724248299390981121, 0.00316227858607898149 },
{ /*157 f=15700 */ 0.98294771307325645715, 0.00316227858607898149 },
{ /*158 f=15800 */ 0.98864241657228923987, 0.00316227858607898149 },
{ /*159 f=15900 */ 0.99432653250530855793, 0.00316227858607898149 },
{ /*160 f=16000 */ 0.99999999999999988898, 0.00316227858607898149 },
{ /*161 f=16100 */ 1.00566275829808415843, 0.00316227858607898149 },
{ /*162 f=16200 */ 1.01131474675596910728, 0.00316227858607898149 },
{ /*163 f=16300 */ 1.01695590484539954979, 0.00316227858607898149 },
{ /*164 f=16400 */ 1.02258617215410430035, 0.00316227858607898149 },
{ /*165 f=16500 */ 1.02820548838644332257, 0.00316227858607898149 },
{ /*166 f=16600 */ 1.03381379336405498925, 0.00316227858607898149 },
{ /*167 f=16700 */ 1.03941102702649845746, 0.00316227858607898149 },
{ /*168 f=16800 */ 1.04499712943189759784, 0.00316227858607898149 },
{ /*169 f=16900 */ 1.05057204075758403583, 0.00316227858607898149 },
{ /*170 f=17000 */ 1.05613570130073597397, 0.00316227858607898149 },
{ /*171 f=17100 */ 1.06168805147901901265, 0.00316227858607898149 },
{ /*172 f=17200 */ 1.06722903183122297399, 0.00316227858607898149 },
{ /*173 f=17300 */ 1.07275858301790050220, 0.00316227858607898149 },
{ /*174 f=17400 */ 1.07827664582200033472, 0.00316227858607898149 },
{ /*175 f=17500 */ 1.08378316114950346005, 0.00316227858607898149 },
{ /*176 f=17600 */ 1.08927807003005394648, 0.00316227858607898149 },
{ /*177 f=17700 */ 1.09476131361759310145, 0.00316227858607898149 },
{ /*178 f=17800 */ 1.10023283319098674760, 0.00316227858607898149 },
{ /*179 f=17900 */ 1.10569257015465582938, 0.00316227858607898149 },
{ /*180 f=18000 */ 1.11114046603920435530, 0.00316227858607898149 },
{ /*181 f=18100 */ 1.11657646250204400928, 0.00316227858607898149 },
{ /*182 f=18200 */ 1.12200050132801965042, 0.00316227858607898149 },
{ /*183 f=18300 */ 1.12741252443003325823, 0.00316227858607898149 },
{ /*184 f=18400 */ 1.13281247384966565761, 0.00316227858607898149 },
{ /*185 f=18500 */ 1.13820029175779646735, 0.00316227858607898149 },
{ /*186 f=18600 */ 1.14357592045522449276, 0.00316227858607898149 },
{ /*187 f=18700 */ 1.14893930237328523170, 0.00316227858607898149 },
{ /*188 f=18800 */ 1.15429038007446727043, 0.00316227858607898149 },
{ /*189 f=18900 */ 1.15962909625302712513, 0.00316227858607898149 },
{ /*190 f=19000 */ 1.16495539373560430541, 0.00316227858607898149 },
{ /*191 f=19100 */ 1.17026921548183104882, 0.00316227858607898149 },
{ /*192 f=19200 */ 1.17557050458494627421, 0.00316227858607898149 },
{ /*193 f=19300 */ 1.18085920427240220754, 0.00316227858607898149 },
{ /*194 f=19400 */ 1.18613525790647433844, 0.00316227858607898149 },
{ /*195 f=19500 */ 1.19139860898486671381, 0.00316227858607898149 },
{ /*196 f=19600 */ 1.19664920114131789752, 0.00316227858607898149 },
{ /*197 f=19700 */ 1.20188697814620470972, 0.00316227858607898149 },
{ /*198 f=19800 */ 1.20711188390714285745, 0.00316227858607898149 },
{ /*199 f=19900 */ 1.21232386246958934173, 0.00316227858607898149 },
{ /*200 f=20000 */ 1.21752285801744131177, 0.00316227858607898149 },
{ /*201 f=20100 */ 1.22270881487363292095, 0.00316227858607898149 },
{ /*202 f=20200 */ 1.22788167750073284878, 0.00316227858607898149 },
{ /*203 f=20300 */ 1.23304139050153827029, 0.00316227858607898149 },
{ /*204 f=20400 */ 1.23818789861966793708, 0.00316227858607898149 },
{ /*205 f=20500 */ 1.24332114674015481448, 0.00316227858607898149 },
{ /*206 f=20600 */ 1.24844107989003516579, 0.00316227858607898149 },
{ /*207 f=20700 */ 1.25354764323893919098, 0.00316227858607898149 },
{ /*208 f=20800 */ 1.25864078209967500399, 0.00316227858607898149 },
{ /*209 f=20900 */ 1.26372044192881749503, 0.00316227858607898149 },
{ /*210 f=21000 */ 1.26878656832729097559, 0.00316227858607898149 },
{ /*211 f=21100 */ 1.27383910704095182354, 0.00316227858607898149 },
{ /*212 f=21200 */ 1.27887800396116935175, 0.00316227858607898149 },
{ /*213 f=21300 */ 1.28390320512540601072, 0.00316227858607898149 },
{ /*214 f=21400 */ 1.28891465671779492652, 0.00316227858607898149 },
{ /*215 f=21500 */ 1.29391230506971455227, 0.00316227858607898149 },
{ /*216 f=21600 */ 1.29889609666036731639, 0.00316227858607898149 },
{ /*217 f=21700 */ 1.30386597811734850083, 0.00316227858607898149 },
{ /*218 f=21800 */ 1.30882189621722067052, 0.00316227858607898149 },
{ /*219 f=21900 */ 1.31376379788608255161, 0.00316227858607898149 },
{ /*220 f=22000 */ 1.31869163020013768772, 0.00316227858607898149 },
{ /*221 f=22100 */ 1.32360534038626065367, 0.00316227858607898149 },
{ /*222 f=22200 */ 1.32850487582256349128, 0.00316227858607898149 },
{ /*223 f=22300 */ 1.33339018403895726017, 0.00316227858607898149 },
{ /*224 f=22400 */ 1.33826121271771647514, 0.00316227858607898149 },
{ /*225 f=22500 */ 1.34311790969403666018, 0.00316227858607898149 },
{ /*226 f=22600 */ 1.34796022295659567725, 0.00316227858607898149 },
{ /*227 f=22700 */ 1.35278810064810839364, 0.00316227858607898149 },
{ /*228 f=22800 */ 1.35760149106588334789, 0.00316227858607898149 },
{ /*229 f=22900 */ 1.36240034266237652893, 0.00316227858607898149 },
{ /*230 f=23000 */ 1.36718460404574249090, 0.00316227858607898149 },
{ /*231 f=23100 */ 1.37195422398038568979, 0.00316227858607898149 },
{ /*232 f=23200 */ 1.37670915138750782347, 0.00316227858607898149 },
{ /*233 f=23300 */ 1.38144933534565739208, 0.00316227858607898149 },
{ /*234 f=23400 */ 1.38617472509127170888, 0.00316227858607898149 },
{ /*235 f=23500 */ 1.39088527001922335202, 0.00316227858607898149 },
{ /*236 f=23600 */ 1.39558091968336017707, 0.00316227858607898149 },
{ /*237 f=23700 */ 1.40026162379704732786, 0.00316227858607898149 },
{ /*238 f=23800 */ 1.40492733223370347417, 0.00316227858607898149 },
{ /*239 f=23900 */ 1.40957799502734015817, 0.00316227858607898149 },
{ /*240 f=24000 */ 1.41421356237309492343, 0.00316227858607898149 }
};
static FLOAT_T vsf_q230[241][2] = {
{ /* dummy entry */ 0, 0},
{ /*  1 f=  100 */ 0.00654497301305325026, 0.00251065957381180205 },
{ /*  2 f=  200 */ 0.01308987593470371628, 0.00251065957381180205 },
{ /*  3 f=  300 */ 0.01963463867429923390, 0.00251065957381180205 },
{ /*  4 f=  400 */ 0.02617919114268887903, 0.00251065957381180205 },
{ /*  5 f=  500 */ 0.03272346325297356001, 0.00251065957381180205 },
{ /*  6 f=  600 */ 0.03926738492125660118, 0.00251065957381180205 },
{ /*  7 f=  700 */ 0.04581088606739427971, 0.00251065957381180205 },
{ /*  8 f=  800 */ 0.05235389661574629816, 0.00251065957381180205 },
{ /*  9 f=  900 */ 0.05889634649592632304, 0.00251065957381180205 },
{ /* 10 f= 1000 */ 0.06543816564355227350, 0.00251065957381180205 },
{ /* 11 f= 1100 */ 0.07197928400099674884, 0.00251065957381180205 },
{ /* 12 f= 1200 */ 0.07851963151813722008, 0.00251065957381180205 },
{ /* 13 f= 1300 */ 0.08505913815310624237, 0.00251065957381180205 },
{ /* 14 f= 1400 */ 0.09159773387304154246, 0.00251065957381180205 },
{ /* 15 f= 1500 */ 0.09813534865483602987, 0.00251065957381180205 },
{ /* 16 f= 1600 */ 0.10467191248588765540, 0.00251065957381180205 },
{ /* 17 f= 1700 */ 0.11120735536484922801, 0.00251065957381180205 },
{ /* 18 f= 1800 */ 0.11774160730237806516, 0.00251065957381180205 },
{ /* 19 f= 1900 */ 0.12427459832188544886, 0.00251065957381180205 },
{ /* 20 f= 2000 */ 0.13080625846028612336, 0.00251065957381180205 },
{ /* 21 f= 2100 */ 0.13733651776874752914, 0.00251065957381180205 },
{ /* 22 f= 2200 */ 0.14386530631343877329, 0.00251065957381180205 },
{ /* 23 f= 2300 */ 0.15039255417627980793, 0.00251065957381180205 },
{ /* 24 f= 2400 */ 0.15691819145568988714, 0.00251065957381180205 },
{ /* 25 f= 2500 */ 0.16344214826733644008, 0.00251065957381180205 },
{ /* 26 f= 2600 */ 0.16996435474488333361, 0.00251065957381180205 },
{ /* 27 f= 2700 */ 0.17648474104073902380, 0.00251065957381180205 },
{ /* 28 f= 2800 */ 0.18300323732680476296, 0.00251065957381180205 },
{ /* 29 f= 2900 */ 0.18951977379522222389, 0.00251065957381180205 },
{ /* 30 f= 3000 */ 0.19603428065912120726, 0.00251065957381180205 },
{ /* 31 f= 3100 */ 0.20254668815336684951, 0.00251065957381180205 },
{ /* 32 f= 3200 */ 0.20905692653530691394, 0.00251065957381180205 },
{ /* 33 f= 3300 */ 0.21556492608551869328, 0.00251065957381180205 },
{ /* 34 f= 3400 */ 0.22207061710855535708, 0.00251065957381180205 },
{ /* 35 f= 3500 */ 0.22857392993369279877, 0.00251065957381180205 },
{ /* 36 f= 3600 */ 0.23507479491567528918, 0.00251065957381180205 },
{ /* 37 f= 3700 */ 0.24157314243546165744, 0.00251065957381180205 },
{ /* 38 f= 3800 */ 0.24806890290097063922, 0.00251065957381180205 },
{ /* 39 f= 3900 */ 0.25456200674782641924, 0.00251065957381180205 },
{ /* 40 f= 4000 */ 0.26105238444010314680, 0.00251065957381180205 },
{ /* 41 f= 4100 */ 0.26753996647107025630, 0.00251065957381180205 },
{ /* 42 f= 4200 */ 0.27402468336393603909, 0.00251065957381180205 },
{ /* 43 f= 4300 */ 0.28050646567259251984, 0.00251065957381180205 },
{ /* 44 f= 4400 */ 0.28698524398235858435, 0.00251065957381180205 },
{ /* 45 f= 4500 */ 0.29346094891072349586, 0.00251065957381180205 },
{ /* 46 f= 4600 */ 0.29993351110809002291, 0.00251065957381180205 },
{ /* 47 f= 4700 */ 0.30640286125851695642, 0.00251065957381180205 },
{ /* 48 f= 4800 */ 0.31286893008046173792, 0.00251065957381180205 },
{ /* 49 f= 4900 */ 0.31933164832752197748, 0.00251065957381180205 },
{ /* 50 f= 5000 */ 0.32579094678917747130, 0.00251065957381180205 },
{ /* 51 f= 5100 */ 0.33224675629153094247, 0.00251065957381180205 },
{ /* 52 f= 5200 */ 0.33869900769804922591, 0.00251065957381180205 },
{ /* 53 f= 5300 */ 0.34514763191030339851, 0.00251065957381180205 },
{ /* 54 f= 5400 */ 0.35159255986870902033, 0.00251065957381180205 },
{ /* 55 f= 5500 */ 0.35803372255326532114, 0.00251065957381180205 },
{ /* 56 f= 5600 */ 0.36447105098429494197, 0.00251065957381180205 },
{ /* 57 f= 5700 */ 0.37090447622318184484, 0.00251065957381180205 },
{ /* 58 f= 5800 */ 0.37733392937311044379, 0.00251065957381180205 },
{ /* 59 f= 5900 */ 0.38375934157980284844, 0.00251065957381180205 },
{ /* 60 f= 6000 */ 0.39018064403225649617, 0.00251065957381180205 },
{ /* 61 f= 6100 */ 0.39659776796348089611, 0.00251065957381180205 },
{ /* 62 f= 6200 */ 0.40301064465123426217, 0.00251065957381180205 },
{ /* 63 f= 6300 */ 0.40941920541875920225, 0.00251065957381180205 },
{ /* 64 f= 6400 */ 0.41582338163551862964, 0.00251065957381180205 },
{ /* 65 f= 6500 */ 0.42222310471793028652, 0.00251065957381180205 },
{ /* 66 f= 6600 */ 0.42861830613010154511, 0.00251065957381180205 },
{ /* 67 f= 6700 */ 0.43500891738456293201, 0.00251065957381180205 },
{ /* 68 f= 6800 */ 0.44139487004300215212, 0.00251065957381180205 },
{ /* 69 f= 6900 */ 0.44777609571699672486, 0.00251065957381180205 },
{ /* 70 f= 7000 */ 0.45415252606874645380, 0.00251065957381180205 },
{ /* 71 f= 7100 */ 0.46052409281180473055, 0.00251065957381180205 },
{ /* 72 f= 7200 */ 0.46689072771181078236, 0.00251065957381180205 },
{ /* 73 f= 7300 */ 0.47325236258721975480, 0.00251065957381180205 },
{ /* 74 f= 7400 */ 0.47960892931003307194, 0.00251065957381180205 },
{ /* 75 f= 7500 */ 0.48596035980652774189, 0.00251065957381180205 },
{ /* 76 f= 7600 */ 0.49230658605798605088, 0.00251065957381180205 },
{ /* 77 f= 7700 */ 0.49864754010142336993, 0.00251065957381180205 },
{ /* 78 f= 7800 */ 0.50498315403031590609, 0.00251065957381180205 },
{ /* 79 f= 7900 */ 0.51131335999532878667, 0.00251065957381180205 },
{ /* 80 f= 8000 */ 0.51763809020504147895, 0.00251065957381180205 },
{ /* 81 f= 8100 */ 0.52395727692667493081, 0.00251065957381180205 },
{ /* 82 f= 8200 */ 0.53027085248681604668, 0.00251065957381180205 },
{ /* 83 f= 8300 */ 0.53657874927214277427, 0.00251065957381180205 },
{ /* 84 f= 8400 */ 0.54288089973014852507, 0.00251065957381180205 },
{ /* 85 f= 8500 */ 0.54917723636986470748, 0.00251065957381180205 },
{ /* 86 f= 8600 */ 0.55546769176258437017, 0.00251065957381180205 },
{ /* 87 f= 8700 */ 0.56175219854258418017, 0.00251065957381180205 },
{ /* 88 f= 8800 */ 0.56803068940784517959, 0.00251065957381180205 },
{ /* 89 f= 8900 */ 0.57430309712077465267, 0.00251065957381180205 },
{ /* 90 f= 9000 */ 0.58056935450892466211, 0.00251065957381180205 },
{ /* 91 f= 9100 */ 0.58682939446571336095, 0.00251065957381180205 },
{ /* 92 f= 9200 */ 0.59308314995114197465, 0.00251065957381180205 },
{ /* 93 f= 9300 */ 0.59933055399251322637, 0.00251065957381180205 },
{ /* 94 f= 9400 */ 0.60557153968514920717, 0.00251065957381180205 },
{ /* 95 f= 9500 */ 0.61180604019310691477, 0.00251065957381180205 },
{ /* 96 f= 9600 */ 0.61803398874989479150, 0.00251065957381180205 },
{ /* 97 f= 9700 */ 0.62425531865918737484, 0.00251065957381180205 },
{ /* 98 f= 9800 */ 0.63046996329553928184, 0.00251065957381180205 },
{ /* 99 f= 9900 */ 0.63667785610509941563, 0.00251065957381180205 },
{ /*100 f=10000 */ 0.64287893060632317344, 0.00251065957381180205 },
{ /*101 f=10100 */ 0.64907312039068432163, 0.00251065957381180205 },
{ /*102 f=10200 */ 0.65526035912338698175, 0.00251065957381180205 },
{ /*103 f=10300 */ 0.66144058054407484093, 0.00251065957381180205 },
{ /*104 f=10400 */ 0.66761371846754191672, 0.00251065957381180205 },
{ /*105 f=10500 */ 0.67377970678444010222, 0.00251065957381180205 },
{ /*106 f=10600 */ 0.67993847946198837651, 0.00251065957381180205 },
{ /*107 f=10700 */ 0.68608997054467968368, 0.00251065957381180205 },
{ /*108 f=10800 */ 0.69223411415498592447, 0.00251065957381180205 },
{ /*109 f=10900 */ 0.69837084449406572340, 0.00251065957381180205 },
{ /*110 f=11000 */ 0.70450009584246697791, 0.00251065957381180205 },
{ /*111 f=11100 */ 0.71062180256083218310, 0.00251065957381180205 },
{ /*112 f=11200 */ 0.71673589909060053671, 0.00251065957381180205 },
{ /*113 f=11300 */ 0.72284231995471004417, 0.00251065957381180205 },
{ /*114 f=11400 */ 0.72894099975829929061, 0.00251065957381180205 },
{ /*115 f=11500 */ 0.73503187318940710338, 0.00251065957381180205 },
{ /*116 f=11600 */ 0.74111487501967243663, 0.00251065957381180205 },
{ /*117 f=11700 */ 0.74718994010503270164, 0.00251065957381180205 },
{ /*118 f=11800 */ 0.75325700338642143095, 0.00251065957381180205 },
{ /*119 f=11900 */ 0.75931599989046549837, 0.00251065957381180205 },
{ /*120 f=12000 */ 0.76536686473017956356, 0.00251065957381180205 },
{ /*121 f=12100 */ 0.77140953310566262591, 0.00251065957381180205 },
{ /*122 f=12200 */ 0.77744394030479113678, 0.00251065957381180205 },
{ /*123 f=12300 */ 0.78347002170391177867, 0.00251065957381180205 },
{ /*124 f=12400 */ 0.78948771276853446643, 0.00251065957381180205 },
{ /*125 f=12500 */ 0.79549694905402212886, 0.00251065957381180205 },
{ /*126 f=12600 */ 0.80149766620628193348, 0.00251065957381180205 },
{ /*127 f=12700 */ 0.80748979996245418000, 0.00251065957381180205 },
{ /*128 f=12800 */ 0.81347328615160030552, 0.00251065957381180205 },
{ /*129 f=12900 */ 0.81944806069539055660, 0.00251065957381180205 },
{ /*130 f=13000 */ 0.82541405960878933001, 0.00251065957381180205 },
{ /*131 f=13100 */ 0.83137121900074162362, 0.00251065957381180205 },
{ /*132 f=13200 */ 0.83731947507485626758, 0.00251065957381180205 },
{ /*133 f=13300 */ 0.84325876413008904464, 0.00251065957381180205 },
{ /*134 f=13400 */ 0.84918902256142625440, 0.00251065957381180205 },
{ /*135 f=13500 */ 0.85511018686056416982, 0.00251065957381180205 },
{ /*136 f=13600 */ 0.86102219361659015906, 0.00251065957381180205 },
{ /*137 f=13700 */ 0.86692497951666180889, 0.00251065957381180205 },
{ /*138 f=13800 */ 0.87281848134668404970, 0.00251065957381180205 },
{ /*139 f=13900 */ 0.87870263599198739080, 0.00251065957381180205 },
{ /*140 f=14000 */ 0.88457738043800260286, 0.00251065957381180205 },
{ /*141 f=14100 */ 0.89044265177093639974, 0.00251065957381180205 },
{ /*142 f=14200 */ 0.89629838717844512175, 0.00251065957381180205 },
{ /*143 f=14300 */ 0.90214452395030675369, 0.00251065957381180205 },
{ /*144 f=14400 */ 0.90798099947909349794, 0.00251065957381180205 },
{ /*145 f=14500 */ 0.91380775126084123894, 0.00251065957381180205 },
{ /*146 f=14600 */ 0.91962471689571967381, 0.00251065957381180205 },
{ /*147 f=14700 */ 0.92543183408870022255, 0.00251065957381180205 },
{ /*148 f=14800 */ 0.93122904065022282794, 0.00251065957381180205 },
{ /*149 f=14900 */ 0.93701627449686286653, 0.00251065957381180205 },
{ /*150 f=15000 */ 0.94279347365199528408, 0.00251065957381180205 },
{ /*151 f=15100 */ 0.94856057624645839788, 0.00251065957381180205 },
{ /*152 f=15200 */ 0.95431752051921681090, 0.00251065957381180205 },
{ /*153 f=15300 */ 0.96006424481802221660, 0.00251065957381180205 },
{ /*154 f=15400 */ 0.96580068760007475870, 0.00251065957381180205 },
{ /*155 f=15500 */ 0.97152678743268006123, 0.00251065957381180205 },
{ /*156 f=15600 */ 0.97724248299390981121, 0.00251065957381180205 },
{ /*157 f=15700 */ 0.98294771307325645715, 0.00251065957381180205 },
{ /*158 f=15800 */ 0.98864241657228923987, 0.00251065957381180205 },
{ /*159 f=15900 */ 0.99432653250530855793, 0.00251065957381180205 },
{ /*160 f=16000 */ 0.99999999999999988898, 0.00251065957381180205 },
{ /*161 f=16100 */ 1.00566275829808415843, 0.00251065957381180205 },
{ /*162 f=16200 */ 1.01131474675596910728, 0.00251065957381180205 },
{ /*163 f=16300 */ 1.01695590484539954979, 0.00251065957381180205 },
{ /*164 f=16400 */ 1.02258617215410430035, 0.00251065957381180205 },
{ /*165 f=16500 */ 1.02820548838644332257, 0.00251065957381180205 },
{ /*166 f=16600 */ 1.03381379336405498925, 0.00251065957381180205 },
{ /*167 f=16700 */ 1.03941102702649845746, 0.00251065957381180205 },
{ /*168 f=16800 */ 1.04499712943189759784, 0.00251065957381180205 },
{ /*169 f=16900 */ 1.05057204075758403583, 0.00251065957381180205 },
{ /*170 f=17000 */ 1.05613570130073597397, 0.00251065957381180205 },
{ /*171 f=17100 */ 1.06168805147901901265, 0.00251065957381180205 },
{ /*172 f=17200 */ 1.06722903183122297399, 0.00251065957381180205 },
{ /*173 f=17300 */ 1.07275858301790050220, 0.00251065957381180205 },
{ /*174 f=17400 */ 1.07827664582200033472, 0.00251065957381180205 },
{ /*175 f=17500 */ 1.08378316114950346005, 0.00251065957381180205 },
{ /*176 f=17600 */ 1.08927807003005394648, 0.00251065957381180205 },
{ /*177 f=17700 */ 1.09476131361759310145, 0.00251065957381180205 },
{ /*178 f=17800 */ 1.10023283319098674760, 0.00251065957381180205 },
{ /*179 f=17900 */ 1.10569257015465582938, 0.00251065957381180205 },
{ /*180 f=18000 */ 1.11114046603920435530, 0.00251065957381180205 },
{ /*181 f=18100 */ 1.11657646250204400928, 0.00251065957381180205 },
{ /*182 f=18200 */ 1.12200050132801965042, 0.00251065957381180205 },
{ /*183 f=18300 */ 1.12741252443003325823, 0.00251065957381180205 },
{ /*184 f=18400 */ 1.13281247384966565761, 0.00251065957381180205 },
{ /*185 f=18500 */ 1.13820029175779646735, 0.00251065957381180205 },
{ /*186 f=18600 */ 1.14357592045522449276, 0.00251065957381180205 },
{ /*187 f=18700 */ 1.14893930237328523170, 0.00251065957381180205 },
{ /*188 f=18800 */ 1.15429038007446727043, 0.00251065957381180205 },
{ /*189 f=18900 */ 1.15962909625302712513, 0.00251065957381180205 },
{ /*190 f=19000 */ 1.16495539373560430541, 0.00251065957381180205 },
{ /*191 f=19100 */ 1.17026921548183104882, 0.00251065957381180205 },
{ /*192 f=19200 */ 1.17557050458494627421, 0.00251065957381180205 },
{ /*193 f=19300 */ 1.18085920427240220754, 0.00251065957381180205 },
{ /*194 f=19400 */ 1.18613525790647433844, 0.00251065957381180205 },
{ /*195 f=19500 */ 1.19139860898486671381, 0.00251065957381180205 },
{ /*196 f=19600 */ 1.19664920114131789752, 0.00251065957381180205 },
{ /*197 f=19700 */ 1.20188697814620470972, 0.00251065957381180205 },
{ /*198 f=19800 */ 1.20711188390714285745, 0.00251065957381180205 },
{ /*199 f=19900 */ 1.21232386246958934173, 0.00251065957381180205 },
{ /*200 f=20000 */ 1.21752285801744131177, 0.00251065957381180205 },
{ /*201 f=20100 */ 1.22270881487363292095, 0.00251065957381180205 },
{ /*202 f=20200 */ 1.22788167750073284878, 0.00251065957381180205 },
{ /*203 f=20300 */ 1.23304139050153827029, 0.00251065957381180205 },
{ /*204 f=20400 */ 1.23818789861966793708, 0.00251065957381180205 },
{ /*205 f=20500 */ 1.24332114674015481448, 0.00251065957381180205 },
{ /*206 f=20600 */ 1.24844107989003516579, 0.00251065957381180205 },
{ /*207 f=20700 */ 1.25354764323893919098, 0.00251065957381180205 },
{ /*208 f=20800 */ 1.25864078209967500399, 0.00251065957381180205 },
{ /*209 f=20900 */ 1.26372044192881749503, 0.00251065957381180205 },
{ /*210 f=21000 */ 1.26878656832729097559, 0.00251065957381180205 },
{ /*211 f=21100 */ 1.27383910704095182354, 0.00251065957381180205 },
{ /*212 f=21200 */ 1.27887800396116935175, 0.00251065957381180205 },
{ /*213 f=21300 */ 1.28390320512540601072, 0.00251065957381180205 },
{ /*214 f=21400 */ 1.28891465671779492652, 0.00251065957381180205 },
{ /*215 f=21500 */ 1.29391230506971455227, 0.00251065957381180205 },
{ /*216 f=21600 */ 1.29889609666036731639, 0.00251065957381180205 },
{ /*217 f=21700 */ 1.30386597811734850083, 0.00251065957381180205 },
{ /*218 f=21800 */ 1.30882189621722067052, 0.00251065957381180205 },
{ /*219 f=21900 */ 1.31376379788608255161, 0.00251065957381180205 },
{ /*220 f=22000 */ 1.31869163020013768772, 0.00251065957381180205 },
{ /*221 f=22100 */ 1.32360534038626065367, 0.00251065957381180205 },
{ /*222 f=22200 */ 1.32850487582256349128, 0.00251065957381180205 },
{ /*223 f=22300 */ 1.33339018403895726017, 0.00251065957381180205 },
{ /*224 f=22400 */ 1.33826121271771647514, 0.00251065957381180205 },
{ /*225 f=22500 */ 1.34311790969403666018, 0.00251065957381180205 },
{ /*226 f=22600 */ 1.34796022295659567725, 0.00251065957381180205 },
{ /*227 f=22700 */ 1.35278810064810839364, 0.00251065957381180205 },
{ /*228 f=22800 */ 1.35760149106588334789, 0.00251065957381180205 },
{ /*229 f=22900 */ 1.36240034266237652893, 0.00251065957381180205 },
{ /*230 f=23000 */ 1.36718460404574249090, 0.00251065957381180205 },
{ /*231 f=23100 */ 1.37195422398038568979, 0.00251065957381180205 },
{ /*232 f=23200 */ 1.37670915138750782347, 0.00251065957381180205 },
{ /*233 f=23300 */ 1.38144933534565739208, 0.00251065957381180205 },
{ /*234 f=23400 */ 1.38617472509127170888, 0.00251065957381180205 },
{ /*235 f=23500 */ 1.39088527001922335202, 0.00251065957381180205 },
{ /*236 f=23600 */ 1.39558091968336017707, 0.00251065957381180205 },
{ /*237 f=23700 */ 1.40026162379704732786, 0.00251065957381180205 },
{ /*238 f=23800 */ 1.40492733223370347417, 0.00251065957381180205 },
{ /*239 f=23900 */ 1.40957799502734015817, 0.00251065957381180205 },
{ /*240 f=24000 */ 1.41421356237309492343, 0.00251065957381180205 }
};
static FLOAT_T vsf_q240[241][2] = {
{ /* dummy entry */ 0, 0},
{ /*  1 f=  100 */ 0.00654497301305325026, 0.00199351428313865320 },
{ /*  2 f=  200 */ 0.01308987593470371628, 0.00199351428313865320 },
{ /*  3 f=  300 */ 0.01963463867429923390, 0.00199351428313865320 },
{ /*  4 f=  400 */ 0.02617919114268887903, 0.00199351428313865320 },
{ /*  5 f=  500 */ 0.03272346325297356001, 0.00199351428313865320 },
{ /*  6 f=  600 */ 0.03926738492125660118, 0.00199351428313865320 },
{ /*  7 f=  700 */ 0.04581088606739427971, 0.00199351428313865320 },
{ /*  8 f=  800 */ 0.05235389661574629816, 0.00199351428313865320 },
{ /*  9 f=  900 */ 0.05889634649592632304, 0.00199351428313865320 },
{ /* 10 f= 1000 */ 0.06543816564355227350, 0.00199351428313865320 },
{ /* 11 f= 1100 */ 0.07197928400099674884, 0.00199351428313865320 },
{ /* 12 f= 1200 */ 0.07851963151813722008, 0.00199351428313865320 },
{ /* 13 f= 1300 */ 0.08505913815310624237, 0.00199351428313865320 },
{ /* 14 f= 1400 */ 0.09159773387304154246, 0.00199351428313865320 },
{ /* 15 f= 1500 */ 0.09813534865483602987, 0.00199351428313865320 },
{ /* 16 f= 1600 */ 0.10467191248588765540, 0.00199351428313865320 },
{ /* 17 f= 1700 */ 0.11120735536484922801, 0.00199351428313865320 },
{ /* 18 f= 1800 */ 0.11774160730237806516, 0.00199351428313865320 },
{ /* 19 f= 1900 */ 0.12427459832188544886, 0.00199351428313865320 },
{ /* 20 f= 2000 */ 0.13080625846028612336, 0.00199351428313865320 },
{ /* 21 f= 2100 */ 0.13733651776874752914, 0.00199351428313865320 },
{ /* 22 f= 2200 */ 0.14386530631343877329, 0.00199351428313865320 },
{ /* 23 f= 2300 */ 0.15039255417627980793, 0.00199351428313865320 },
{ /* 24 f= 2400 */ 0.15691819145568988714, 0.00199351428313865320 },
{ /* 25 f= 2500 */ 0.16344214826733644008, 0.00199351428313865320 },
{ /* 26 f= 2600 */ 0.16996435474488333361, 0.00199351428313865320 },
{ /* 27 f= 2700 */ 0.17648474104073902380, 0.00199351428313865320 },
{ /* 28 f= 2800 */ 0.18300323732680476296, 0.00199351428313865320 },
{ /* 29 f= 2900 */ 0.18951977379522222389, 0.00199351428313865320 },
{ /* 30 f= 3000 */ 0.19603428065912120726, 0.00199351428313865320 },
{ /* 31 f= 3100 */ 0.20254668815336684951, 0.00199351428313865320 },
{ /* 32 f= 3200 */ 0.20905692653530691394, 0.00199351428313865320 },
{ /* 33 f= 3300 */ 0.21556492608551869328, 0.00199351428313865320 },
{ /* 34 f= 3400 */ 0.22207061710855535708, 0.00199351428313865320 },
{ /* 35 f= 3500 */ 0.22857392993369279877, 0.00199351428313865320 },
{ /* 36 f= 3600 */ 0.23507479491567528918, 0.00199351428313865320 },
{ /* 37 f= 3700 */ 0.24157314243546165744, 0.00199351428313865320 },
{ /* 38 f= 3800 */ 0.24806890290097063922, 0.00199351428313865320 },
{ /* 39 f= 3900 */ 0.25456200674782641924, 0.00199351428313865320 },
{ /* 40 f= 4000 */ 0.26105238444010314680, 0.00199351428313865320 },
{ /* 41 f= 4100 */ 0.26753996647107025630, 0.00199351428313865320 },
{ /* 42 f= 4200 */ 0.27402468336393603909, 0.00199351428313865320 },
{ /* 43 f= 4300 */ 0.28050646567259251984, 0.00199351428313865320 },
{ /* 44 f= 4400 */ 0.28698524398235858435, 0.00199351428313865320 },
{ /* 45 f= 4500 */ 0.29346094891072349586, 0.00199351428313865320 },
{ /* 46 f= 4600 */ 0.29993351110809002291, 0.00199351428313865320 },
{ /* 47 f= 4700 */ 0.30640286125851695642, 0.00199351428313865320 },
{ /* 48 f= 4800 */ 0.31286893008046173792, 0.00199351428313865320 },
{ /* 49 f= 4900 */ 0.31933164832752197748, 0.00199351428313865320 },
{ /* 50 f= 5000 */ 0.32579094678917747130, 0.00199351428313865320 },
{ /* 51 f= 5100 */ 0.33224675629153094247, 0.00199351428313865320 },
{ /* 52 f= 5200 */ 0.33869900769804922591, 0.00199351428313865320 },
{ /* 53 f= 5300 */ 0.34514763191030339851, 0.00199351428313865320 },
{ /* 54 f= 5400 */ 0.35159255986870902033, 0.00199351428313865320 },
{ /* 55 f= 5500 */ 0.35803372255326532114, 0.00199351428313865320 },
{ /* 56 f= 5600 */ 0.36447105098429494197, 0.00199351428313865320 },
{ /* 57 f= 5700 */ 0.37090447622318184484, 0.00199351428313865320 },
{ /* 58 f= 5800 */ 0.37733392937311044379, 0.00199351428313865320 },
{ /* 59 f= 5900 */ 0.38375934157980284844, 0.00199351428313865320 },
{ /* 60 f= 6000 */ 0.39018064403225649617, 0.00199351428313865320 },
{ /* 61 f= 6100 */ 0.39659776796348089611, 0.00199351428313865320 },
{ /* 62 f= 6200 */ 0.40301064465123426217, 0.00199351428313865320 },
{ /* 63 f= 6300 */ 0.40941920541875920225, 0.00199351428313865320 },
{ /* 64 f= 6400 */ 0.41582338163551862964, 0.00199351428313865320 },
{ /* 65 f= 6500 */ 0.42222310471793028652, 0.00199351428313865320 },
{ /* 66 f= 6600 */ 0.42861830613010154511, 0.00199351428313865320 },
{ /* 67 f= 6700 */ 0.43500891738456293201, 0.00199351428313865320 },
{ /* 68 f= 6800 */ 0.44139487004300215212, 0.00199351428313865320 },
{ /* 69 f= 6900 */ 0.44777609571699672486, 0.00199351428313865320 },
{ /* 70 f= 7000 */ 0.45415252606874645380, 0.00199351428313865320 },
{ /* 71 f= 7100 */ 0.46052409281180473055, 0.00199351428313865320 },
{ /* 72 f= 7200 */ 0.46689072771181078236, 0.00199351428313865320 },
{ /* 73 f= 7300 */ 0.47325236258721975480, 0.00199351428313865320 },
{ /* 74 f= 7400 */ 0.47960892931003307194, 0.00199351428313865320 },
{ /* 75 f= 7500 */ 0.48596035980652774189, 0.00199351428313865320 },
{ /* 76 f= 7600 */ 0.49230658605798605088, 0.00199351428313865320 },
{ /* 77 f= 7700 */ 0.49864754010142336993, 0.00199351428313865320 },
{ /* 78 f= 7800 */ 0.50498315403031590609, 0.00199351428313865320 },
{ /* 79 f= 7900 */ 0.51131335999532878667, 0.00199351428313865320 },
{ /* 80 f= 8000 */ 0.51763809020504147895, 0.00199351428313865320 },
{ /* 81 f= 8100 */ 0.52395727692667493081, 0.00199351428313865320 },
{ /* 82 f= 8200 */ 0.53027085248681604668, 0.00199351428313865320 },
{ /* 83 f= 8300 */ 0.53657874927214277427, 0.00199351428313865320 },
{ /* 84 f= 8400 */ 0.54288089973014852507, 0.00199351428313865320 },
{ /* 85 f= 8500 */ 0.54917723636986470748, 0.00199351428313865320 },
{ /* 86 f= 8600 */ 0.55546769176258437017, 0.00199351428313865320 },
{ /* 87 f= 8700 */ 0.56175219854258418017, 0.00199351428313865320 },
{ /* 88 f= 8800 */ 0.56803068940784517959, 0.00199351428313865320 },
{ /* 89 f= 8900 */ 0.57430309712077465267, 0.00199351428313865320 },
{ /* 90 f= 9000 */ 0.58056935450892466211, 0.00199351428313865320 },
{ /* 91 f= 9100 */ 0.58682939446571336095, 0.00199351428313865320 },
{ /* 92 f= 9200 */ 0.59308314995114197465, 0.00199351428313865320 },
{ /* 93 f= 9300 */ 0.59933055399251322637, 0.00199351428313865320 },
{ /* 94 f= 9400 */ 0.60557153968514920717, 0.00199351428313865320 },
{ /* 95 f= 9500 */ 0.61180604019310691477, 0.00199351428313865320 },
{ /* 96 f= 9600 */ 0.61803398874989479150, 0.00199351428313865320 },
{ /* 97 f= 9700 */ 0.62425531865918737484, 0.00199351428313865320 },
{ /* 98 f= 9800 */ 0.63046996329553928184, 0.00199351428313865320 },
{ /* 99 f= 9900 */ 0.63667785610509941563, 0.00199351428313865320 },
{ /*100 f=10000 */ 0.64287893060632317344, 0.00199351428313865320 },
{ /*101 f=10100 */ 0.64907312039068432163, 0.00199351428313865320 },
{ /*102 f=10200 */ 0.65526035912338698175, 0.00199351428313865320 },
{ /*103 f=10300 */ 0.66144058054407484093, 0.00199351428313865320 },
{ /*104 f=10400 */ 0.66761371846754191672, 0.00199351428313865320 },
{ /*105 f=10500 */ 0.67377970678444010222, 0.00199351428313865320 },
{ /*106 f=10600 */ 0.67993847946198837651, 0.00199351428313865320 },
{ /*107 f=10700 */ 0.68608997054467968368, 0.00199351428313865320 },
{ /*108 f=10800 */ 0.69223411415498592447, 0.00199351428313865320 },
{ /*109 f=10900 */ 0.69837084449406572340, 0.00199351428313865320 },
{ /*110 f=11000 */ 0.70450009584246697791, 0.00199351428313865320 },
{ /*111 f=11100 */ 0.71062180256083218310, 0.00199351428313865320 },
{ /*112 f=11200 */ 0.71673589909060053671, 0.00199351428313865320 },
{ /*113 f=11300 */ 0.72284231995471004417, 0.00199351428313865320 },
{ /*114 f=11400 */ 0.72894099975829929061, 0.00199351428313865320 },
{ /*115 f=11500 */ 0.73503187318940710338, 0.00199351428313865320 },
{ /*116 f=11600 */ 0.74111487501967243663, 0.00199351428313865320 },
{ /*117 f=11700 */ 0.74718994010503270164, 0.00199351428313865320 },
{ /*118 f=11800 */ 0.75325700338642143095, 0.00199351428313865320 },
{ /*119 f=11900 */ 0.75931599989046549837, 0.00199351428313865320 },
{ /*120 f=12000 */ 0.76536686473017956356, 0.00199351428313865320 },
{ /*121 f=12100 */ 0.77140953310566262591, 0.00199351428313865320 },
{ /*122 f=12200 */ 0.77744394030479113678, 0.00199351428313865320 },
{ /*123 f=12300 */ 0.78347002170391177867, 0.00199351428313865320 },
{ /*124 f=12400 */ 0.78948771276853446643, 0.00199351428313865320 },
{ /*125 f=12500 */ 0.79549694905402212886, 0.00199351428313865320 },
{ /*126 f=12600 */ 0.80149766620628193348, 0.00199351428313865320 },
{ /*127 f=12700 */ 0.80748979996245418000, 0.00199351428313865320 },
{ /*128 f=12800 */ 0.81347328615160030552, 0.00199351428313865320 },
{ /*129 f=12900 */ 0.81944806069539055660, 0.00199351428313865320 },
{ /*130 f=13000 */ 0.82541405960878933001, 0.00199351428313865320 },
{ /*131 f=13100 */ 0.83137121900074162362, 0.00199351428313865320 },
{ /*132 f=13200 */ 0.83731947507485626758, 0.00199351428313865320 },
{ /*133 f=13300 */ 0.84325876413008904464, 0.00199351428313865320 },
{ /*134 f=13400 */ 0.84918902256142625440, 0.00199351428313865320 },
{ /*135 f=13500 */ 0.85511018686056416982, 0.00199351428313865320 },
{ /*136 f=13600 */ 0.86102219361659015906, 0.00199351428313865320 },
{ /*137 f=13700 */ 0.86692497951666180889, 0.00199351428313865320 },
{ /*138 f=13800 */ 0.87281848134668404970, 0.00199351428313865320 },
{ /*139 f=13900 */ 0.87870263599198739080, 0.00199351428313865320 },
{ /*140 f=14000 */ 0.88457738043800260286, 0.00199351428313865320 },
{ /*141 f=14100 */ 0.89044265177093639974, 0.00199351428313865320 },
{ /*142 f=14200 */ 0.89629838717844512175, 0.00199351428313865320 },
{ /*143 f=14300 */ 0.90214452395030675369, 0.00199351428313865320 },
{ /*144 f=14400 */ 0.90798099947909349794, 0.00199351428313865320 },
{ /*145 f=14500 */ 0.91380775126084123894, 0.00199351428313865320 },
{ /*146 f=14600 */ 0.91962471689571967381, 0.00199351428313865320 },
{ /*147 f=14700 */ 0.92543183408870022255, 0.00199351428313865320 },
{ /*148 f=14800 */ 0.93122904065022282794, 0.00199351428313865320 },
{ /*149 f=14900 */ 0.93701627449686286653, 0.00199351428313865320 },
{ /*150 f=15000 */ 0.94279347365199528408, 0.00199351428313865320 },
{ /*151 f=15100 */ 0.94856057624645839788, 0.00199351428313865320 },
{ /*152 f=15200 */ 0.95431752051921681090, 0.00199351428313865320 },
{ /*153 f=15300 */ 0.96006424481802221660, 0.00199351428313865320 },
{ /*154 f=15400 */ 0.96580068760007475870, 0.00199351428313865320 },
{ /*155 f=15500 */ 0.97152678743268006123, 0.00199351428313865320 },
{ /*156 f=15600 */ 0.97724248299390981121, 0.00199351428313865320 },
{ /*157 f=15700 */ 0.98294771307325645715, 0.00199351428313865320 },
{ /*158 f=15800 */ 0.98864241657228923987, 0.00199351428313865320 },
{ /*159 f=15900 */ 0.99432653250530855793, 0.00199351428313865320 },
{ /*160 f=16000 */ 0.99999999999999988898, 0.00199351428313865320 },
{ /*161 f=16100 */ 1.00566275829808415843, 0.00199351428313865320 },
{ /*162 f=16200 */ 1.01131474675596910728, 0.00199351428313865320 },
{ /*163 f=16300 */ 1.01695590484539954979, 0.00199351428313865320 },
{ /*164 f=16400 */ 1.02258617215410430035, 0.00199351428313865320 },
{ /*165 f=16500 */ 1.02820548838644332257, 0.00199351428313865320 },
{ /*166 f=16600 */ 1.03381379336405498925, 0.00199351428313865320 },
{ /*167 f=16700 */ 1.03941102702649845746, 0.00199351428313865320 },
{ /*168 f=16800 */ 1.04499712943189759784, 0.00199351428313865320 },
{ /*169 f=16900 */ 1.05057204075758403583, 0.00199351428313865320 },
{ /*170 f=17000 */ 1.05613570130073597397, 0.00199351428313865320 },
{ /*171 f=17100 */ 1.06168805147901901265, 0.00199351428313865320 },
{ /*172 f=17200 */ 1.06722903183122297399, 0.00199351428313865320 },
{ /*173 f=17300 */ 1.07275858301790050220, 0.00199351428313865320 },
{ /*174 f=17400 */ 1.07827664582200033472, 0.00199351428313865320 },
{ /*175 f=17500 */ 1.08378316114950346005, 0.00199351428313865320 },
{ /*176 f=17600 */ 1.08927807003005394648, 0.00199351428313865320 },
{ /*177 f=17700 */ 1.09476131361759310145, 0.00199351428313865320 },
{ /*178 f=17800 */ 1.10023283319098674760, 0.00199351428313865320 },
{ /*179 f=17900 */ 1.10569257015465582938, 0.00199351428313865320 },
{ /*180 f=18000 */ 1.11114046603920435530, 0.00199351428313865320 },
{ /*181 f=18100 */ 1.11657646250204400928, 0.00199351428313865320 },
{ /*182 f=18200 */ 1.12200050132801965042, 0.00199351428313865320 },
{ /*183 f=18300 */ 1.12741252443003325823, 0.00199351428313865320 },
{ /*184 f=18400 */ 1.13281247384966565761, 0.00199351428313865320 },
{ /*185 f=18500 */ 1.13820029175779646735, 0.00199351428313865320 },
{ /*186 f=18600 */ 1.14357592045522449276, 0.00199351428313865320 },
{ /*187 f=18700 */ 1.14893930237328523170, 0.00199351428313865320 },
{ /*188 f=18800 */ 1.15429038007446727043, 0.00199351428313865320 },
{ /*189 f=18900 */ 1.15962909625302712513, 0.00199351428313865320 },
{ /*190 f=19000 */ 1.16495539373560430541, 0.00199351428313865320 },
{ /*191 f=19100 */ 1.17026921548183104882, 0.00199351428313865320 },
{ /*192 f=19200 */ 1.17557050458494627421, 0.00199351428313865320 },
{ /*193 f=19300 */ 1.18085920427240220754, 0.00199351428313865320 },
{ /*194 f=19400 */ 1.18613525790647433844, 0.00199351428313865320 },
{ /*195 f=19500 */ 1.19139860898486671381, 0.00199351428313865320 },
{ /*196 f=19600 */ 1.19664920114131789752, 0.00199351428313865320 },
{ /*197 f=19700 */ 1.20188697814620470972, 0.00199351428313865320 },
{ /*198 f=19800 */ 1.20711188390714285745, 0.00199351428313865320 },
{ /*199 f=19900 */ 1.21232386246958934173, 0.00199351428313865320 },
{ /*200 f=20000 */ 1.21752285801744131177, 0.00199351428313865320 },
{ /*201 f=20100 */ 1.22270881487363292095, 0.00199351428313865320 },
{ /*202 f=20200 */ 1.22788167750073284878, 0.00199351428313865320 },
{ /*203 f=20300 */ 1.23304139050153827029, 0.00199351428313865320 },
{ /*204 f=20400 */ 1.23818789861966793708, 0.00199351428313865320 },
{ /*205 f=20500 */ 1.24332114674015481448, 0.00199351428313865320 },
{ /*206 f=20600 */ 1.24844107989003516579, 0.00199351428313865320 },
{ /*207 f=20700 */ 1.25354764323893919098, 0.00199351428313865320 },
{ /*208 f=20800 */ 1.25864078209967500399, 0.00199351428313865320 },
{ /*209 f=20900 */ 1.26372044192881749503, 0.00199351428313865320 },
{ /*210 f=21000 */ 1.26878656832729097559, 0.00199351428313865320 },
{ /*211 f=21100 */ 1.27383910704095182354, 0.00199351428313865320 },
{ /*212 f=21200 */ 1.27887800396116935175, 0.00199351428313865320 },
{ /*213 f=21300 */ 1.28390320512540601072, 0.00199351428313865320 },
{ /*214 f=21400 */ 1.28891465671779492652, 0.00199351428313865320 },
{ /*215 f=21500 */ 1.29391230506971455227, 0.00199351428313865320 },
{ /*216 f=21600 */ 1.29889609666036731639, 0.00199351428313865320 },
{ /*217 f=21700 */ 1.30386597811734850083, 0.00199351428313865320 },
{ /*218 f=21800 */ 1.30882189621722067052, 0.00199351428313865320 },
{ /*219 f=21900 */ 1.31376379788608255161, 0.00199351428313865320 },
{ /*220 f=22000 */ 1.31869163020013768772, 0.00199351428313865320 },
{ /*221 f=22100 */ 1.32360534038626065367, 0.00199351428313865320 },
{ /*222 f=22200 */ 1.32850487582256349128, 0.00199351428313865320 },
{ /*223 f=22300 */ 1.33339018403895726017, 0.00199351428313865320 },
{ /*224 f=22400 */ 1.33826121271771647514, 0.00199351428313865320 },
{ /*225 f=22500 */ 1.34311790969403666018, 0.00199351428313865320 },
{ /*226 f=22600 */ 1.34796022295659567725, 0.00199351428313865320 },
{ /*227 f=22700 */ 1.35278810064810839364, 0.00199351428313865320 },
{ /*228 f=22800 */ 1.35760149106588334789, 0.00199351428313865320 },
{ /*229 f=22900 */ 1.36240034266237652893, 0.00199351428313865320 },
{ /*230 f=23000 */ 1.36718460404574249090, 0.00199351428313865320 },
{ /*231 f=23100 */ 1.37195422398038568979, 0.00199351428313865320 },
{ /*232 f=23200 */ 1.37670915138750782347, 0.00199351428313865320 },
{ /*233 f=23300 */ 1.38144933534565739208, 0.00199351428313865320 },
{ /*234 f=23400 */ 1.38617472509127170888, 0.00199351428313865320 },
{ /*235 f=23500 */ 1.39088527001922335202, 0.00199351428313865320 },
{ /*236 f=23600 */ 1.39558091968336017707, 0.00199351428313865320 },
{ /*237 f=23700 */ 1.40026162379704732786, 0.00199351428313865320 },
{ /*238 f=23800 */ 1.40492733223370347417, 0.00199351428313865320 },
{ /*239 f=23900 */ 1.40957799502734015817, 0.00199351428313865320 },
{ /*240 f=24000 */ 1.41421356237309492343, 0.00199351428313865320 }
};

#define LINEAR_INTERPOLATION
#define CSPLINE_INTERPOLATION
#define FILTER_INTERPOLATION
#define ENVELOPE_PITCH_MODULATION


#ifdef LOOKUP_HACK
#define MAX_DATAVAL 127
#define MIN_DATAVAL -128
#else
#define MAX_DATAVAL 32767
#define MIN_DATAVAL -32768
#endif

#define OVERSHOOT_STEP 50


static resample_t *vib_resample_voice(int, uint32 *, int);
static resample_t *normal_resample_voice(int, uint32 *, int);


static void update_reso(Voice *vp)
{
  FLOAT_T depth=vp->reso_depth / 2.0;
  int32 sweep = vp->reso_sweep << 2;
  int32 reso_vol;

  if (!sweep) return;

      /* Update sweep position */

      if (vp->reso_phase == 0) {
      	vp->reso_sweep_position += sweep;
        if (vp->reso_sweep_position >= (1<<SWEEP_SHIFT))
		vp->reso_phase = 1;
      }
      else {
      	vp->reso_sweep_position -= sweep;
        if (-vp->reso_sweep_position >= (1<<SWEEP_SHIFT))
		vp->reso_phase = 0;
      }
	  /* Need to adjust depth */
      depth *= (FLOAT_T)vp->reso_sweep_position / (FLOAT_T)(1<<SWEEP_SHIFT); /* centibels */
      depth += (FLOAT_T)vp->reso_depth/2.0; /* positive centibels */
      reso_vol = (int32)(depth + 0.5);
//fprintf(stderr,"depth = %f pos = %d factor = %f vol = %d\n", depth, vp->reso_sweep_position,
//	       	(FLOAT_T)vp->reso_sweep_position / (FLOAT_T)(1<<SWEEP_SHIFT), reso_vol );
      if (reso_vol < 0) reso_vol = 0;
      if (reso_vol > vp->reso_max) reso_vol = vp->reso_max;
      vp->reso_volume = reso_vol;
}

static void update_lfo(Voice *vp)
{
  /* FLOAT_T depth=vp->modLfoToFilterFc; */
  FLOAT_T depth=vp->lfo_depth;
  int32 sweep = vp->lfo_sweep << 2;

  if (!sweep) return;
  depth *= 0.01;
  if (depth < 0.1) return;
  if (depth > 0.9) depth = 0.9;

      /* Update sweep position */

      if (vp->lfo_phase == 0) {
      	vp->lfo_sweep_position += sweep;
        if (vp->lfo_sweep_position >= (1<<SWEEP_SHIFT))
		vp->lfo_phase = 1;
      }
      else {
      	vp->lfo_sweep_position -= sweep;
        if (-vp->lfo_sweep_position >= (1<<SWEEP_SHIFT))
		vp->lfo_phase = 0;
      }
	  /* Need to adjust depth */
      depth *= (FLOAT_T)vp->lfo_sweep_position / (FLOAT_T)(1<<SWEEP_SHIFT);
      vp->lfo_volume = 1.0 + depth;
}

static int calc_bw_index(Voice *vp)
{
  FLOAT_T mod_amount=vp->modEnvToFilterFc;
  int32 freq = vp->cutoff_freq;
  int ix;

  if (vp->lfo_phase_increment) update_lfo(vp);
  if (vp->reso_phase_increment) update_reso(vp);

/*  if (!vp->lfo_phase_increment && update_modulation_signal(vp)) return 0; */
  if (!vp->lfo_phase_increment && update_modulation_signal(vp)) return 1;

/* printf("mod_amount %f ", mod_amount); */
  if (vp->lfo_volume>0.05) {
	if (mod_amount) mod_amount *= vp->lfo_volume;
	else mod_amount = vp->lfo_volume;
/* printf("lfo %f -> mod %f ", voice[v].lfo_volume, mod_amount); */
  }

  if (mod_amount > 0.05) {
    if (vp->modulation_volume)
       freq =
	(int32)( (double)freq*(1.0 + (mod_amount - 1.0) * (vp->modulation_volume>>22) / 255.0) );
    else freq = (int32)( (double)freq*mod_amount );
/*
printf("v%d freq %d (was %d), modvol %d, mod_amount %f\n", v, (int)freq, (int)voice[v].sample->cutoff_freq,
(int)voice[v].modulation_volume>>22,
mod_amount);
*/
	ix = (freq+50) / 100;
	if (ix >= MAX_BW_INDEX) ix = MAX_BW_INDEX - 1;
	if (ix < 1) ix = 1;
	vp->bw_index = ix;
	return 1;
  }
	ix = (freq+50) / 100;
	if (ix >= MAX_BW_INDEX) ix = MAX_BW_INDEX - 1;
	if (ix < 1) ix = 1;
	vp->bw_index = ix;
  /* return 0; */
  return 1;
}

/*************** resampling with fixed increment *****************/

static resample_t *rs_plain(int v, uint32 *countptr)
{
  /* Play sample until end, then free the voice. */
  Voice
    *vp=&voice[v];
  int32   v0, v1, v2, v3, temp, overshoot;
  splen_t ofsd;
  int32 offset;
  FLOAT_T insamp, outsamp, s_high, s_notch, s_freq, s_damp,
    s_low=vp->current_x0, s_band=vp->current_x1,
    s_drive=(FLOAT_T)vp->drive/255000000.0;
  uint32 cc_count=vp->modulation_counter, bw_index=vp->bw_index, fmax;
  uint16 reso;
  const uint8 filter_type=vp->filter_type;
  resample_t newsample;
  resample_t
    *dest=resample_buffer+resample_buffer_offset;
#ifdef SL32
  samplel_t
    *src=vp->sample->ldata;
#else
  sample_t
    *src=vp->sample->data;
#endif
  int32
    incr=vp->sample_increment;
  splen_t
    ofs=vp->sample_offset;
#if defined(LAGRANGE_INTERPOLATION) || defined(CSPLINE_INTERPOLATION)
  splen_t
    ls=0,
    le=vp->sample->data_length;
#endif /* LAGRANGE_INTERPOLATION */
  splen_t
    se=vp->sample->data_length;
  uint32
    count=*countptr;

  if (!incr) return resample_buffer+resample_buffer_offset; /* --gl */

  overshoot = src[(se>>FRACTION_BITS)-1] / OVERSHOOT_STEP;
  if (overshoot < 0) overshoot = -overshoot;

    reso = vp->resonance + vp->reso_volume;
    if (reso > vp->reso_max) reso = vp->reso_max;
    fmax = (1000 + (vp->reso_max - reso) * (vp->reso_max - reso) * 2) / 100;
    if (reso && bw_index > fmax) bw_index = fmax;
    reso = (reso+5)/10;

    switch(reso) {
	case 0:
		s_freq = vsf_q0[bw_index][0];
		s_damp = vsf_q0[bw_index][1];
		
		
		break;
	case 1:
		s_freq = vsf_q10[bw_index][0];
		s_damp = vsf_q10[bw_index][1];
		
		
		break;
	case 2:
		s_freq = vsf_q20[bw_index][0];
		s_damp = vsf_q20[bw_index][1];
		
		
		break;
	case 3:
		s_freq = vsf_q30[bw_index][0];
		s_damp = vsf_q30[bw_index][1];
		
		
		break;
	case 4:
		s_freq = vsf_q40[bw_index][0];
		s_damp = vsf_q40[bw_index][1];
		
		
		break;
	case 5:
		s_freq = vsf_q50[bw_index][0];
		s_damp = vsf_q50[bw_index][1];
		
		
		break;
	case 6:
		s_freq = vsf_q60[bw_index][0];
		s_damp = vsf_q60[bw_index][1];
		
		
		break;
	case 7:
		s_freq = vsf_q70[bw_index][0];
		s_damp = vsf_q70[bw_index][1];
		
		
		break;
	case 8:
		s_freq = vsf_q80[bw_index][0];
		s_damp = vsf_q80[bw_index][1];
		
		
		break;
	case 9:
		s_freq = vsf_q90[bw_index][0];
		s_damp = vsf_q90[bw_index][1];
		
		
		break;
	case 10:
		s_freq = vsf_q100[bw_index][0];
		s_damp = vsf_q100[bw_index][1];
		
		
		break;
	case 11:
		s_freq = vsf_q110[bw_index][0];
		s_damp = vsf_q110[bw_index][1];
		
		
		break;
	case 12:
		s_freq = vsf_q120[bw_index][0];
		s_damp = vsf_q120[bw_index][1];
		
		
		break;
	case 13:
		s_freq = vsf_q130[bw_index][0];
		s_damp = vsf_q130[bw_index][1];
		
		
		break;
	case 14:
		s_freq = vsf_q140[bw_index][0];
		s_damp = vsf_q140[bw_index][1];
		
		
		break;
	case 15:
		s_freq = vsf_q150[bw_index][0];
		s_damp = vsf_q150[bw_index][1];
		
		
		break;
	case 16:
		s_freq = vsf_q160[bw_index][0];
		s_damp = vsf_q160[bw_index][1];
		
		
		break;
	case 17:
		s_freq = vsf_q170[bw_index][0];
		s_damp = vsf_q170[bw_index][1];
		
		
		break;
	case 18:
		s_freq = vsf_q180[bw_index][0];
		s_damp = vsf_q180[bw_index][1];
		
		
		break;
	case 19:
		s_freq = vsf_q190[bw_index][0];
		s_damp = vsf_q190[bw_index][1];
		
		
		break;
	case 20:
		s_freq = vsf_q200[bw_index][0];
		s_damp = vsf_q200[bw_index][1];
		
		
		break;
	case 21:
		s_freq = vsf_q210[bw_index][0];
		s_damp = vsf_q210[bw_index][1];
		
		
		break;
	case 22:
		s_freq = vsf_q220[bw_index][0];
		s_damp = vsf_q220[bw_index][1];
		
		
		break;
	case 23:
		s_freq = vsf_q230[bw_index][0];
		s_damp = vsf_q230[bw_index][1];
		
		
		break;
	default:
	case 24:
		s_freq = vsf_q240[bw_index][0];
		s_damp = vsf_q240[bw_index][1];
		
		
		break;
    }


    while (count--)
    {


	offset = ofs >> FRACTION_BITS;

	if (ofs >= se) {
		int32 delta = (ofs - se)>>FRACTION_BITS;
        	v1 = (int32)src[(int32)(se>>FRACTION_BITS)-1];
		if (overshoot) v1 -=  (delta+1) * v1 / overshoot;
        }
	else  v1 = (int32)src[offset];

	if (ofs + (1L<<FRACTION_BITS) >= se) {
		v2 = v1;
        }
	else  v2 = (int32)src[offset+1];

	if ( (vp->algorithm & INTERPOLATION_LINEAR) || dont_cspline ||
	   ((ofs-(1L<<FRACTION_BITS))<ls)||((ofs+(2L<<FRACTION_BITS))>le)){
		if (!cc_count--) {
		    cc_count = control_ratio - 1;
		    if (calc_bw_index(vp)) {
		        bw_index = vp->bw_index;


    reso = vp->resonance + vp->reso_volume;
    if (reso > vp->reso_max) reso = vp->reso_max;
    fmax = (1000 + (vp->reso_max - reso) * (vp->reso_max - reso) * 2) / 100;
    if (reso && bw_index > fmax) bw_index = fmax;
    reso = (reso+5)/10;

    switch(reso) {
	case 0:
		s_freq = vsf_q0[bw_index][0];
		s_damp = vsf_q0[bw_index][1];
		
		
		break;
	case 1:
		s_freq = vsf_q10[bw_index][0];
		s_damp = vsf_q10[bw_index][1];
		
		
		break;
	case 2:
		s_freq = vsf_q20[bw_index][0];
		s_damp = vsf_q20[bw_index][1];
		
		
		break;
	case 3:
		s_freq = vsf_q30[bw_index][0];
		s_damp = vsf_q30[bw_index][1];
		
		
		break;
	case 4:
		s_freq = vsf_q40[bw_index][0];
		s_damp = vsf_q40[bw_index][1];
		
		
		break;
	case 5:
		s_freq = vsf_q50[bw_index][0];
		s_damp = vsf_q50[bw_index][1];
		
		
		break;
	case 6:
		s_freq = vsf_q60[bw_index][0];
		s_damp = vsf_q60[bw_index][1];
		
		
		break;
	case 7:
		s_freq = vsf_q70[bw_index][0];
		s_damp = vsf_q70[bw_index][1];
		
		
		break;
	case 8:
		s_freq = vsf_q80[bw_index][0];
		s_damp = vsf_q80[bw_index][1];
		
		
		break;
	case 9:
		s_freq = vsf_q90[bw_index][0];
		s_damp = vsf_q90[bw_index][1];
		
		
		break;
	case 10:
		s_freq = vsf_q100[bw_index][0];
		s_damp = vsf_q100[bw_index][1];
		
		
		break;
	case 11:
		s_freq = vsf_q110[bw_index][0];
		s_damp = vsf_q110[bw_index][1];
		
		
		break;
	case 12:
		s_freq = vsf_q120[bw_index][0];
		s_damp = vsf_q120[bw_index][1];
		
		
		break;
	case 13:
		s_freq = vsf_q130[bw_index][0];
		s_damp = vsf_q130[bw_index][1];
		
		
		break;
	case 14:
		s_freq = vsf_q140[bw_index][0];
		s_damp = vsf_q140[bw_index][1];
		
		
		break;
	case 15:
		s_freq = vsf_q150[bw_index][0];
		s_damp = vsf_q150[bw_index][1];
		
		
		break;
	case 16:
		s_freq = vsf_q160[bw_index][0];
		s_damp = vsf_q160[bw_index][1];
		
		
		break;
	case 17:
		s_freq = vsf_q170[bw_index][0];
		s_damp = vsf_q170[bw_index][1];
		
		
		break;
	case 18:
		s_freq = vsf_q180[bw_index][0];
		s_damp = vsf_q180[bw_index][1];
		
		
		break;
	case 19:
		s_freq = vsf_q190[bw_index][0];
		s_damp = vsf_q190[bw_index][1];
		
		
		break;
	case 20:
		s_freq = vsf_q200[bw_index][0];
		s_damp = vsf_q200[bw_index][1];
		
		
		break;
	case 21:
		s_freq = vsf_q210[bw_index][0];
		s_damp = vsf_q210[bw_index][1];
		
		
		break;
	case 22:
		s_freq = vsf_q220[bw_index][0];
		s_damp = vsf_q220[bw_index][1];
		
		
		break;
	case 23:
		s_freq = vsf_q230[bw_index][0];
		s_damp = vsf_q230[bw_index][1];
		
		
		break;
	default:
	case 24:
		s_freq = vsf_q240[bw_index][0];
		s_damp = vsf_q240[bw_index][1];
		
		
		break;
    }


		    }
		    incr = calc_mod_freq(vp, incr);
		}
                newsample = (resample_t)(v1 + ((int32)((v2-v1) * (ofs & FRACTION_MASK)) >> FRACTION_BITS));
	        if (bw_index) {
                    insamp = (FLOAT_T)newsample;

		    s_notch = insamp - s_damp*s_band;
		    s_low   = s_low + s_freq*s_band;
		    s_high  = s_notch - s_low;
		    if (s_drive > 0) s_band  = s_freq*s_high + s_band - s_drive*s_band*s_band*s_band;
		    else s_band  = s_freq*s_high + s_band;
		    //outsamp   = 0.5*(s_notch or s_low or s_high or s_band or s_peak);
		    if (filter_type==FILTER_LOWPASS)
		        outsamp  = 0.5*s_low;
		    else if (filter_type==FILTER_HIGHPASS)
		        outsamp  = 0.5*s_high;
		    else if (filter_type==FILTER_BAND)
		        outsamp  = 0.5*s_band;
		    else if (filter_type==FILTER_NOTCH)
		        outsamp  = 0.5*s_notch;
		    else /* if (filter_type==FILTER_PEAK) */
		        outsamp  = 0.5*(s_low-s_high);
		    s_notch = insamp - s_damp*s_band;
		    s_low   = s_low + s_freq*s_band;
		    s_high  = s_notch - s_low;
		    if (s_drive > 0) s_band  = s_freq*s_high + s_band - s_drive*s_band*s_band*s_band;
		    else s_band  = s_freq*s_high + s_band;
		    //outsamp  += 0.5*(same out as above);
		    if (filter_type==FILTER_LOWPASS)
		        outsamp  += 0.5*s_low;
		    else if (filter_type==FILTER_HIGHPASS)
		        outsamp  += 0.5*s_high;
		    else if (filter_type==FILTER_BAND)
		        outsamp  += 0.5*s_band;
		    else if (filter_type==FILTER_NOTCH)
		        outsamp  += 0.5*s_notch;
		    else /* if (filter_type==FILTER_PEAK) */
		        outsamp  += 0.5*(s_low-s_high);

		    newsample = (resample_t)outsamp;
	        }
	}
	else {
		ofsd=ofs;
                v0 = (int32)src[offset-1];
                v3 = (int32)src[offset+2];
                ofs &= FRACTION_MASK;
                temp=v2;
		v2 = (6*v2 +
		      (((( ( (5*v3 - 11*v2 + 7*v1 - v0)*
		       (int32)ofs) >>FRACTION_BITS)*(int32)ofs)>>(FRACTION_BITS+2))-1))*(int32)ofs;
                ofs = (1L << FRACTION_BITS) - ofs;
		v1 = (6*v1 +
		      ((((((5*v0 - 11*v1 + 7*temp - v3)*
		       (int32)ofs)>>FRACTION_BITS)*(int32)ofs)>>(FRACTION_BITS+2))-1))*(int32)ofs;
		v1 = (v1 + v2)/(6L<<FRACTION_BITS);
		if (!cc_count--) {
		    cc_count = control_ratio - 1;
		    if (calc_bw_index(vp)) {
			bw_index = vp->bw_index;


    reso = vp->resonance + vp->reso_volume;
    if (reso > vp->reso_max) reso = vp->reso_max;
    fmax = (1000 + (vp->reso_max - reso) * (vp->reso_max - reso) * 2) / 100;
    if (reso && bw_index > fmax) bw_index = fmax;
    reso = (reso+5)/10;

    switch(reso) {
	case 0:
		s_freq = vsf_q0[bw_index][0];
		s_damp = vsf_q0[bw_index][1];
		
		
		break;
	case 1:
		s_freq = vsf_q10[bw_index][0];
		s_damp = vsf_q10[bw_index][1];
		
		
		break;
	case 2:
		s_freq = vsf_q20[bw_index][0];
		s_damp = vsf_q20[bw_index][1];
		
		
		break;
	case 3:
		s_freq = vsf_q30[bw_index][0];
		s_damp = vsf_q30[bw_index][1];
		
		
		break;
	case 4:
		s_freq = vsf_q40[bw_index][0];
		s_damp = vsf_q40[bw_index][1];
		
		
		break;
	case 5:
		s_freq = vsf_q50[bw_index][0];
		s_damp = vsf_q50[bw_index][1];
		
		
		break;
	case 6:
		s_freq = vsf_q60[bw_index][0];
		s_damp = vsf_q60[bw_index][1];
		
		
		break;
	case 7:
		s_freq = vsf_q70[bw_index][0];
		s_damp = vsf_q70[bw_index][1];
		
		
		break;
	case 8:
		s_freq = vsf_q80[bw_index][0];
		s_damp = vsf_q80[bw_index][1];
		
		
		break;
	case 9:
		s_freq = vsf_q90[bw_index][0];
		s_damp = vsf_q90[bw_index][1];
		
		
		break;
	case 10:
		s_freq = vsf_q100[bw_index][0];
		s_damp = vsf_q100[bw_index][1];
		
		
		break;
	case 11:
		s_freq = vsf_q110[bw_index][0];
		s_damp = vsf_q110[bw_index][1];
		
		
		break;
	case 12:
		s_freq = vsf_q120[bw_index][0];
		s_damp = vsf_q120[bw_index][1];
		
		
		break;
	case 13:
		s_freq = vsf_q130[bw_index][0];
		s_damp = vsf_q130[bw_index][1];
		
		
		break;
	case 14:
		s_freq = vsf_q140[bw_index][0];
		s_damp = vsf_q140[bw_index][1];
		
		
		break;
	case 15:
		s_freq = vsf_q150[bw_index][0];
		s_damp = vsf_q150[bw_index][1];
		
		
		break;
	case 16:
		s_freq = vsf_q160[bw_index][0];
		s_damp = vsf_q160[bw_index][1];
		
		
		break;
	case 17:
		s_freq = vsf_q170[bw_index][0];
		s_damp = vsf_q170[bw_index][1];
		
		
		break;
	case 18:
		s_freq = vsf_q180[bw_index][0];
		s_damp = vsf_q180[bw_index][1];
		
		
		break;
	case 19:
		s_freq = vsf_q190[bw_index][0];
		s_damp = vsf_q190[bw_index][1];
		
		
		break;
	case 20:
		s_freq = vsf_q200[bw_index][0];
		s_damp = vsf_q200[bw_index][1];
		
		
		break;
	case 21:
		s_freq = vsf_q210[bw_index][0];
		s_damp = vsf_q210[bw_index][1];
		
		
		break;
	case 22:
		s_freq = vsf_q220[bw_index][0];
		s_damp = vsf_q220[bw_index][1];
		
		
		break;
	case 23:
		s_freq = vsf_q230[bw_index][0];
		s_damp = vsf_q230[bw_index][1];
		
		
		break;
	default:
	case 24:
		s_freq = vsf_q240[bw_index][0];
		s_damp = vsf_q240[bw_index][1];
		
		
		break;
    }




		    }
		    incr = calc_mod_freq(vp, incr);
		}
		newsample = (resample_t)v1;
		if (bw_index) {
                    insamp = (FLOAT_T)newsample;

		    s_notch = insamp - s_damp*s_band;
		    s_low   = s_low + s_freq*s_band;
		    s_high  = s_notch - s_low;
		    if (s_drive > 0) s_band  = s_freq*s_high + s_band - s_drive*s_band*s_band*s_band;
		    else s_band  = s_freq*s_high + s_band;

		    if (filter_type==FILTER_LOWPASS)
		        outsamp  = 0.5*s_low;
		    else if (filter_type==FILTER_HIGHPASS)
		        outsamp  = 0.5*s_high;
		    else if (filter_type==FILTER_BAND)
		        outsamp  = 0.5*s_band;
		    else if (filter_type==FILTER_NOTCH)
		        outsamp  = 0.5*s_notch;
		    else /* if (filter_type==FILTER_PEAK) */
		        outsamp  = 0.5*(s_low-s_high);

		    s_notch = insamp - s_damp*s_band;
		    s_low   = s_low + s_freq*s_band;
		    s_high  = s_notch - s_low;
		    if (s_drive > 0) s_band  = s_freq*s_high + s_band - s_drive*s_band*s_band*s_band;
		    else s_band  = s_freq*s_high + s_band;

		    if (filter_type==FILTER_LOWPASS)
		        outsamp  += 0.5*s_low;
		    else if (filter_type==FILTER_HIGHPASS)
		        outsamp  += 0.5*s_high;
		    else if (filter_type==FILTER_BAND)
		        outsamp  += 0.5*s_band;
		    else if (filter_type==FILTER_NOTCH)
		        outsamp  += 0.5*s_notch;
		    else /* if (filter_type==FILTER_PEAK) */
		        outsamp  += 0.5*(s_low-s_high);


		    newsample = (resample_t)outsamp;
		}
		ofs=ofsd;
	}
	*dest++ = newsample;
      ofs += incr;
      if (ofs >= se + (overshoot << FRACTION_BITS))
	{
	  if (!(vp->status&VOICE_FREE))
	    {
	      vp->status=VOICE_FREE;
 	      ctl->note(v);
	    }
	  *countptr-=count+1;
	  break;
	}
    }

  vp->sample_offset=ofs; /* Update offset */
  vp->current_x0=s_low;
  vp->current_x1=s_band;
  vp->bw_index=bw_index;
  vp->modulation_counter=cc_count;
  return resample_buffer+resample_buffer_offset;
}

static resample_t *rs_loop(int v, Voice *vp, uint32 *countptr)
{
  /* Play sample until end-of-loop, skip back and continue. */
  int32   v0, v1, v2, v3, temp, overshoot;
  splen_t ofsd;
  int32 offset;
  FLOAT_T insamp, outsamp, s_high, s_notch, s_freq, s_damp,
    s_low=vp->current_x0, s_band=vp->current_x1,
    s_drive=(FLOAT_T)vp->drive/255000000.0;
  uint32 cc_count=vp->modulation_counter, bw_index=vp->bw_index, fmax;
  uint16 reso;
  const uint8 filter_type=vp->filter_type;
  resample_t newsample;
  int32
    incr=vp->sample_increment;
  splen_t
    ofs=vp->sample_offset,
    le=vp->loop_end,
#if defined(LAGRANGE_INTERPOLATION) || defined(CSPLINE_INTERPOLATION)
    ls=vp->loop_start,
#endif /* LAGRANGE_INTERPOLATION */
    ll=le - vp->loop_start;
  resample_t
    *dest=resample_buffer+resample_buffer_offset;
#ifdef SL32
  samplel_t
    *src=vp->sample->ldata;
#else
  sample_t
    *src=vp->sample->data;
#endif
  splen_t
    se=vp->sample->data_length;
  uint32
    count = *countptr;
  int
    flag_exit_loop;


  flag_exit_loop =
	(vp->status & (VOICE_FREE | VOICE_DIE)) ||
	((vp->status & VOICE_OFF) && (vp->sample->modes & MODES_FAST_RELEASE) ) ||
	((vp->status & VOICE_OFF) && dont_keep_looping ) ;

  overshoot = src[(se>>FRACTION_BITS)-1] / OVERSHOOT_STEP;
  if (overshoot < 0) overshoot = -overshoot;

    reso = vp->resonance + vp->reso_volume;
    if (reso > vp->reso_max) reso = vp->reso_max;
    fmax = (1000 + (vp->reso_max - reso) * (vp->reso_max - reso) * 2) / 100;
    if (reso && bw_index > fmax) bw_index = fmax;
    reso = (reso+5)/10;

    switch(reso) {
	case 0:
		s_freq = vsf_q0[bw_index][0];
		s_damp = vsf_q0[bw_index][1];
		
		
		break;
	case 1:
		s_freq = vsf_q10[bw_index][0];
		s_damp = vsf_q10[bw_index][1];
		
		
		break;
	case 2:
		s_freq = vsf_q20[bw_index][0];
		s_damp = vsf_q20[bw_index][1];
		
		
		break;
	case 3:
		s_freq = vsf_q30[bw_index][0];
		s_damp = vsf_q30[bw_index][1];
		
		
		break;
	case 4:
		s_freq = vsf_q40[bw_index][0];
		s_damp = vsf_q40[bw_index][1];
		
		
		break;
	case 5:
		s_freq = vsf_q50[bw_index][0];
		s_damp = vsf_q50[bw_index][1];
		
		
		break;
	case 6:
		s_freq = vsf_q60[bw_index][0];
		s_damp = vsf_q60[bw_index][1];
		
		
		break;
	case 7:
		s_freq = vsf_q70[bw_index][0];
		s_damp = vsf_q70[bw_index][1];
		
		
		break;
	case 8:
		s_freq = vsf_q80[bw_index][0];
		s_damp = vsf_q80[bw_index][1];
		
		
		break;
	case 9:
		s_freq = vsf_q90[bw_index][0];
		s_damp = vsf_q90[bw_index][1];
		
		
		break;
	case 10:
		s_freq = vsf_q100[bw_index][0];
		s_damp = vsf_q100[bw_index][1];
		
		
		break;
	case 11:
		s_freq = vsf_q110[bw_index][0];
		s_damp = vsf_q110[bw_index][1];
		
		
		break;
	case 12:
		s_freq = vsf_q120[bw_index][0];
		s_damp = vsf_q120[bw_index][1];
		
		
		break;
	case 13:
		s_freq = vsf_q130[bw_index][0];
		s_damp = vsf_q130[bw_index][1];
		
		
		break;
	case 14:
		s_freq = vsf_q140[bw_index][0];
		s_damp = vsf_q140[bw_index][1];
		
		
		break;
	case 15:
		s_freq = vsf_q150[bw_index][0];
		s_damp = vsf_q150[bw_index][1];
		
		
		break;
	case 16:
		s_freq = vsf_q160[bw_index][0];
		s_damp = vsf_q160[bw_index][1];
		
		
		break;
	case 17:
		s_freq = vsf_q170[bw_index][0];
		s_damp = vsf_q170[bw_index][1];
		
		
		break;
	case 18:
		s_freq = vsf_q180[bw_index][0];
		s_damp = vsf_q180[bw_index][1];
		
		
		break;
	case 19:
		s_freq = vsf_q190[bw_index][0];
		s_damp = vsf_q190[bw_index][1];
		
		
		break;
	case 20:
		s_freq = vsf_q200[bw_index][0];
		s_damp = vsf_q200[bw_index][1];
		
		
		break;
	case 21:
		s_freq = vsf_q210[bw_index][0];
		s_damp = vsf_q210[bw_index][1];
		
		
		break;
	case 22:
		s_freq = vsf_q220[bw_index][0];
		s_damp = vsf_q220[bw_index][1];
		
		
		break;
	case 23:
		s_freq = vsf_q230[bw_index][0];
		s_damp = vsf_q230[bw_index][1];
		
		
		break;
	default:
	case 24:
		s_freq = vsf_q240[bw_index][0];
		s_damp = vsf_q240[bw_index][1];
		
		
		break;
    }


  while (count--)
    {


	offset = ofs >> FRACTION_BITS;

	if (ofs >= se) {
		int32 delta = (ofs - se)>>FRACTION_BITS;
        	v1 = (int32)src[(int32)(se>>FRACTION_BITS)-1];
		if (overshoot) v1 -=  (delta+1) * v1 / overshoot;
        }
	else  v1 = (int32)src[offset];

	if (ofs + (1L<<FRACTION_BITS) >= se) {
		v2 = v1;
        }
	else  v2 = (int32)src[offset+1];

	if ( (vp->algorithm & INTERPOLATION_LINEAR) || dont_cspline ||
	   ((ofs-(1L<<FRACTION_BITS))<ls)||((ofs+(2L<<FRACTION_BITS))>le)){
		if (!cc_count--) {
		    cc_count = control_ratio - 1;
		    if (calc_bw_index(vp)) {
		        bw_index = vp->bw_index;


    reso = vp->resonance + vp->reso_volume;
    if (reso > vp->reso_max) reso = vp->reso_max;
    fmax = (1000 + (vp->reso_max - reso) * (vp->reso_max - reso) * 2) / 100;
    if (reso && bw_index > fmax) bw_index = fmax;
    reso = (reso+5)/10;

    switch(reso) {
	case 0:
		s_freq = vsf_q0[bw_index][0];
		s_damp = vsf_q0[bw_index][1];
		
		
		break;
	case 1:
		s_freq = vsf_q10[bw_index][0];
		s_damp = vsf_q10[bw_index][1];
		
		
		break;
	case 2:
		s_freq = vsf_q20[bw_index][0];
		s_damp = vsf_q20[bw_index][1];
		
		
		break;
	case 3:
		s_freq = vsf_q30[bw_index][0];
		s_damp = vsf_q30[bw_index][1];
		
		
		break;
	case 4:
		s_freq = vsf_q40[bw_index][0];
		s_damp = vsf_q40[bw_index][1];
		
		
		break;
	case 5:
		s_freq = vsf_q50[bw_index][0];
		s_damp = vsf_q50[bw_index][1];
		
		
		break;
	case 6:
		s_freq = vsf_q60[bw_index][0];
		s_damp = vsf_q60[bw_index][1];
		
		
		break;
	case 7:
		s_freq = vsf_q70[bw_index][0];
		s_damp = vsf_q70[bw_index][1];
		
		
		break;
	case 8:
		s_freq = vsf_q80[bw_index][0];
		s_damp = vsf_q80[bw_index][1];
		
		
		break;
	case 9:
		s_freq = vsf_q90[bw_index][0];
		s_damp = vsf_q90[bw_index][1];
		
		
		break;
	case 10:
		s_freq = vsf_q100[bw_index][0];
		s_damp = vsf_q100[bw_index][1];
		
		
		break;
	case 11:
		s_freq = vsf_q110[bw_index][0];
		s_damp = vsf_q110[bw_index][1];
		
		
		break;
	case 12:
		s_freq = vsf_q120[bw_index][0];
		s_damp = vsf_q120[bw_index][1];
		
		
		break;
	case 13:
		s_freq = vsf_q130[bw_index][0];
		s_damp = vsf_q130[bw_index][1];
		
		
		break;
	case 14:
		s_freq = vsf_q140[bw_index][0];
		s_damp = vsf_q140[bw_index][1];
		
		
		break;
	case 15:
		s_freq = vsf_q150[bw_index][0];
		s_damp = vsf_q150[bw_index][1];
		
		
		break;
	case 16:
		s_freq = vsf_q160[bw_index][0];
		s_damp = vsf_q160[bw_index][1];
		
		
		break;
	case 17:
		s_freq = vsf_q170[bw_index][0];
		s_damp = vsf_q170[bw_index][1];
		
		
		break;
	case 18:
		s_freq = vsf_q180[bw_index][0];
		s_damp = vsf_q180[bw_index][1];
		
		
		break;
	case 19:
		s_freq = vsf_q190[bw_index][0];
		s_damp = vsf_q190[bw_index][1];
		
		
		break;
	case 20:
		s_freq = vsf_q200[bw_index][0];
		s_damp = vsf_q200[bw_index][1];
		
		
		break;
	case 21:
		s_freq = vsf_q210[bw_index][0];
		s_damp = vsf_q210[bw_index][1];
		
		
		break;
	case 22:
		s_freq = vsf_q220[bw_index][0];
		s_damp = vsf_q220[bw_index][1];
		
		
		break;
	case 23:
		s_freq = vsf_q230[bw_index][0];
		s_damp = vsf_q230[bw_index][1];
		
		
		break;
	default:
	case 24:
		s_freq = vsf_q240[bw_index][0];
		s_damp = vsf_q240[bw_index][1];
		
		
		break;
    }


		    }
		    incr = calc_mod_freq(vp, incr);
		}
                newsample = (resample_t)(v1 + ((int32)((v2-v1) * (ofs & FRACTION_MASK)) >> FRACTION_BITS));
	        if (bw_index) {
                    insamp = (FLOAT_T)newsample;

		    s_notch = insamp - s_damp*s_band;
		    s_low   = s_low + s_freq*s_band;
		    s_high  = s_notch - s_low;
		    if (s_drive > 0) s_band  = s_freq*s_high + s_band - s_drive*s_band*s_band*s_band;
		    else s_band  = s_freq*s_high + s_band;
		    //outsamp   = 0.5*(s_notch or s_low or s_high or s_band or s_peak);
		    if (filter_type==FILTER_LOWPASS)
		        outsamp  = 0.5*s_low;
		    else if (filter_type==FILTER_HIGHPASS)
		        outsamp  = 0.5*s_high;
		    else if (filter_type==FILTER_BAND)
		        outsamp  = 0.5*s_band;
		    else if (filter_type==FILTER_NOTCH)
		        outsamp  = 0.5*s_notch;
		    else /* if (filter_type==FILTER_PEAK) */
		        outsamp  = 0.5*(s_low-s_high);
		    s_notch = insamp - s_damp*s_band;
		    s_low   = s_low + s_freq*s_band;
		    s_high  = s_notch - s_low;
		    if (s_drive > 0) s_band  = s_freq*s_high + s_band - s_drive*s_band*s_band*s_band;
		    else s_band  = s_freq*s_high + s_band;
		    //outsamp  += 0.5*(same out as above);
		    if (filter_type==FILTER_LOWPASS)
		        outsamp  += 0.5*s_low;
		    else if (filter_type==FILTER_HIGHPASS)
		        outsamp  += 0.5*s_high;
		    else if (filter_type==FILTER_BAND)
		        outsamp  += 0.5*s_band;
		    else if (filter_type==FILTER_NOTCH)
		        outsamp  += 0.5*s_notch;
		    else /* if (filter_type==FILTER_PEAK) */
		        outsamp  += 0.5*(s_low-s_high);

		    newsample = (resample_t)outsamp;
	        }
	}
	else {
		ofsd=ofs;
                v0 = (int32)src[offset-1];
                v3 = (int32)src[offset+2];
                ofs &= FRACTION_MASK;
                temp=v2;
		v2 = (6*v2 +
		      (((( ( (5*v3 - 11*v2 + 7*v1 - v0)*
		       (int32)ofs) >>FRACTION_BITS)*(int32)ofs)>>(FRACTION_BITS+2))-1))*(int32)ofs;
                ofs = (1L << FRACTION_BITS) - ofs;
		v1 = (6*v1 +
		      ((((((5*v0 - 11*v1 + 7*temp - v3)*
		       (int32)ofs)>>FRACTION_BITS)*(int32)ofs)>>(FRACTION_BITS+2))-1))*(int32)ofs;
		v1 = (v1 + v2)/(6L<<FRACTION_BITS);
		if (!cc_count--) {
		    cc_count = control_ratio - 1;
		    if (calc_bw_index(vp)) {
			bw_index = vp->bw_index;


    reso = vp->resonance + vp->reso_volume;
    if (reso > vp->reso_max) reso = vp->reso_max;
    fmax = (1000 + (vp->reso_max - reso) * (vp->reso_max - reso) * 2) / 100;
    if (reso && bw_index > fmax) bw_index = fmax;
    reso = (reso+5)/10;

    switch(reso) {
	case 0:
		s_freq = vsf_q0[bw_index][0];
		s_damp = vsf_q0[bw_index][1];
		
		
		break;
	case 1:
		s_freq = vsf_q10[bw_index][0];
		s_damp = vsf_q10[bw_index][1];
		
		
		break;
	case 2:
		s_freq = vsf_q20[bw_index][0];
		s_damp = vsf_q20[bw_index][1];
		
		
		break;
	case 3:
		s_freq = vsf_q30[bw_index][0];
		s_damp = vsf_q30[bw_index][1];
		
		
		break;
	case 4:
		s_freq = vsf_q40[bw_index][0];
		s_damp = vsf_q40[bw_index][1];
		
		
		break;
	case 5:
		s_freq = vsf_q50[bw_index][0];
		s_damp = vsf_q50[bw_index][1];
		
		
		break;
	case 6:
		s_freq = vsf_q60[bw_index][0];
		s_damp = vsf_q60[bw_index][1];
		
		
		break;
	case 7:
		s_freq = vsf_q70[bw_index][0];
		s_damp = vsf_q70[bw_index][1];
		
		
		break;
	case 8:
		s_freq = vsf_q80[bw_index][0];
		s_damp = vsf_q80[bw_index][1];
		
		
		break;
	case 9:
		s_freq = vsf_q90[bw_index][0];
		s_damp = vsf_q90[bw_index][1];
		
		
		break;
	case 10:
		s_freq = vsf_q100[bw_index][0];
		s_damp = vsf_q100[bw_index][1];
		
		
		break;
	case 11:
		s_freq = vsf_q110[bw_index][0];
		s_damp = vsf_q110[bw_index][1];
		
		
		break;
	case 12:
		s_freq = vsf_q120[bw_index][0];
		s_damp = vsf_q120[bw_index][1];
		
		
		break;
	case 13:
		s_freq = vsf_q130[bw_index][0];
		s_damp = vsf_q130[bw_index][1];
		
		
		break;
	case 14:
		s_freq = vsf_q140[bw_index][0];
		s_damp = vsf_q140[bw_index][1];
		
		
		break;
	case 15:
		s_freq = vsf_q150[bw_index][0];
		s_damp = vsf_q150[bw_index][1];
		
		
		break;
	case 16:
		s_freq = vsf_q160[bw_index][0];
		s_damp = vsf_q160[bw_index][1];
		
		
		break;
	case 17:
		s_freq = vsf_q170[bw_index][0];
		s_damp = vsf_q170[bw_index][1];
		
		
		break;
	case 18:
		s_freq = vsf_q180[bw_index][0];
		s_damp = vsf_q180[bw_index][1];
		
		
		break;
	case 19:
		s_freq = vsf_q190[bw_index][0];
		s_damp = vsf_q190[bw_index][1];
		
		
		break;
	case 20:
		s_freq = vsf_q200[bw_index][0];
		s_damp = vsf_q200[bw_index][1];
		
		
		break;
	case 21:
		s_freq = vsf_q210[bw_index][0];
		s_damp = vsf_q210[bw_index][1];
		
		
		break;
	case 22:
		s_freq = vsf_q220[bw_index][0];
		s_damp = vsf_q220[bw_index][1];
		
		
		break;
	case 23:
		s_freq = vsf_q230[bw_index][0];
		s_damp = vsf_q230[bw_index][1];
		
		
		break;
	default:
	case 24:
		s_freq = vsf_q240[bw_index][0];
		s_damp = vsf_q240[bw_index][1];
		
		
		break;
    }




		    }
		    incr = calc_mod_freq(vp, incr);
		}
		newsample = (resample_t)v1;
		if (bw_index) {
                    insamp = (FLOAT_T)newsample;

		    s_notch = insamp - s_damp*s_band;
		    s_low   = s_low + s_freq*s_band;
		    s_high  = s_notch - s_low;
		    if (s_drive > 0) s_band  = s_freq*s_high + s_band - s_drive*s_band*s_band*s_band;
		    else s_band  = s_freq*s_high + s_band;

		    if (filter_type==FILTER_LOWPASS)
		        outsamp  = 0.5*s_low;
		    else if (filter_type==FILTER_HIGHPASS)
		        outsamp  = 0.5*s_high;
		    else if (filter_type==FILTER_BAND)
		        outsamp  = 0.5*s_band;
		    else if (filter_type==FILTER_NOTCH)
		        outsamp  = 0.5*s_notch;
		    else /* if (filter_type==FILTER_PEAK) */
		        outsamp  = 0.5*(s_low-s_high);

		    s_notch = insamp - s_damp*s_band;
		    s_low   = s_low + s_freq*s_band;
		    s_high  = s_notch - s_low;
		    if (s_drive > 0) s_band  = s_freq*s_high + s_band - s_drive*s_band*s_band*s_band;
		    else s_band  = s_freq*s_high + s_band;

		    if (filter_type==FILTER_LOWPASS)
		        outsamp  += 0.5*s_low;
		    else if (filter_type==FILTER_HIGHPASS)
		        outsamp  += 0.5*s_high;
		    else if (filter_type==FILTER_BAND)
		        outsamp  += 0.5*s_band;
		    else if (filter_type==FILTER_NOTCH)
		        outsamp  += 0.5*s_notch;
		    else /* if (filter_type==FILTER_PEAK) */
		        outsamp  += 0.5*(s_low-s_high);


		    newsample = (resample_t)outsamp;
		}
		ofs=ofsd;
	}
	*dest++ = newsample;
      ofs += incr;
      if (ofs>=le)
	{
	  if (flag_exit_loop)
	    {
	    	vp->reverb_time -= ll >> FRACTION_BITS;
	  	if (vp->reverb_time >= 0) ofs -= ll;
	    }
	  else ofs -= ll; /* Hopefully the loop is longer than an increment. */
	}
      if (ofs >= se + (overshoot << FRACTION_BITS))
	{
	  if (!(vp->status&VOICE_FREE))
	    {
	      vp->status=VOICE_FREE;
 	      ctl->note(v);
	    }
	  *countptr-=count+1;
	  break;
	}
    }

  vp->sample_offset=ofs; /* Update offset */
  vp->current_x0=s_low;
  vp->current_x1=s_band;
  vp->bw_index=bw_index;
  vp->modulation_counter=cc_count;
  return resample_buffer+resample_buffer_offset;
}

static resample_t *rs_bidir(Voice *vp, uint32 count)
{
  int32   v0, v1, v2, v3, temp, overshoot;
  splen_t ofsd;
  int32 offset;
  FLOAT_T insamp, outsamp, s_high, s_notch, s_freq, s_damp,
    s_low=vp->current_x0, s_band=vp->current_x1,
    s_drive=(FLOAT_T)vp->drive/255000000.0;
  uint32 cc_count=vp->modulation_counter, bw_index=vp->bw_index, fmax;
  uint16 reso;
  const uint8 filter_type=vp->filter_type;
  resample_t newsample;
  int32
    incr=vp->sample_increment;
  splen_t
    le=vp->loop_end,
    ls=vp->loop_start,
    ofs=vp->sample_offset,
    se=vp->sample->data_length;
  resample_t
    *dest=resample_buffer+resample_buffer_offset;
#ifdef SL32
  samplel_t
    *src=vp->sample->ldata;
#else
  sample_t
    *src=vp->sample->data;
#endif


#ifdef USE_BIDIR_OVERSHOOT
  int32
    le2 = le<<1,
    ls2 = ls<<1;
#endif
  uint32
    i, j;
  /* Play normally until inside the loop region */

  overshoot = src[(se>>FRACTION_BITS)-1] / OVERSHOOT_STEP;
  if (overshoot < 0) overshoot = -overshoot;

    reso = vp->resonance + vp->reso_volume;
    if (reso > vp->reso_max) reso = vp->reso_max;
    fmax = (1000 + (vp->reso_max - reso) * (vp->reso_max - reso) * 2) / 100;
    if (reso && bw_index > fmax) bw_index = fmax;
    reso = (reso+5)/10;

    switch(reso) {
	case 0:
		s_freq = vsf_q0[bw_index][0];
		s_damp = vsf_q0[bw_index][1];
		
		
		break;
	case 1:
		s_freq = vsf_q10[bw_index][0];
		s_damp = vsf_q10[bw_index][1];
		
		
		break;
	case 2:
		s_freq = vsf_q20[bw_index][0];
		s_damp = vsf_q20[bw_index][1];
		
		
		break;
	case 3:
		s_freq = vsf_q30[bw_index][0];
		s_damp = vsf_q30[bw_index][1];
		
		
		break;
	case 4:
		s_freq = vsf_q40[bw_index][0];
		s_damp = vsf_q40[bw_index][1];
		
		
		break;
	case 5:
		s_freq = vsf_q50[bw_index][0];
		s_damp = vsf_q50[bw_index][1];
		
		
		break;
	case 6:
		s_freq = vsf_q60[bw_index][0];
		s_damp = vsf_q60[bw_index][1];
		
		
		break;
	case 7:
		s_freq = vsf_q70[bw_index][0];
		s_damp = vsf_q70[bw_index][1];
		
		
		break;
	case 8:
		s_freq = vsf_q80[bw_index][0];
		s_damp = vsf_q80[bw_index][1];
		
		
		break;
	case 9:
		s_freq = vsf_q90[bw_index][0];
		s_damp = vsf_q90[bw_index][1];
		
		
		break;
	case 10:
		s_freq = vsf_q100[bw_index][0];
		s_damp = vsf_q100[bw_index][1];
		
		
		break;
	case 11:
		s_freq = vsf_q110[bw_index][0];
		s_damp = vsf_q110[bw_index][1];
		
		
		break;
	case 12:
		s_freq = vsf_q120[bw_index][0];
		s_damp = vsf_q120[bw_index][1];
		
		
		break;
	case 13:
		s_freq = vsf_q130[bw_index][0];
		s_damp = vsf_q130[bw_index][1];
		
		
		break;
	case 14:
		s_freq = vsf_q140[bw_index][0];
		s_damp = vsf_q140[bw_index][1];
		
		
		break;
	case 15:
		s_freq = vsf_q150[bw_index][0];
		s_damp = vsf_q150[bw_index][1];
		
		
		break;
	case 16:
		s_freq = vsf_q160[bw_index][0];
		s_damp = vsf_q160[bw_index][1];
		
		
		break;
	case 17:
		s_freq = vsf_q170[bw_index][0];
		s_damp = vsf_q170[bw_index][1];
		
		
		break;
	case 18:
		s_freq = vsf_q180[bw_index][0];
		s_damp = vsf_q180[bw_index][1];
		
		
		break;
	case 19:
		s_freq = vsf_q190[bw_index][0];
		s_damp = vsf_q190[bw_index][1];
		
		
		break;
	case 20:
		s_freq = vsf_q200[bw_index][0];
		s_damp = vsf_q200[bw_index][1];
		
		
		break;
	case 21:
		s_freq = vsf_q210[bw_index][0];
		s_damp = vsf_q210[bw_index][1];
		
		
		break;
	case 22:
		s_freq = vsf_q220[bw_index][0];
		s_damp = vsf_q220[bw_index][1];
		
		
		break;
	case 23:
		s_freq = vsf_q230[bw_index][0];
		s_damp = vsf_q230[bw_index][1];
		
		
		break;
	default:
	case 24:
		s_freq = vsf_q240[bw_index][0];
		s_damp = vsf_q240[bw_index][1];
		
		
		break;
    }


  if (ofs <= ls)
    {
      /* NOTE: Assumes that incr > 0, which is NOT always the case
	 when doing bidirectional looping.  I have yet to see a case
	 where both ofs <= ls AND incr < 0, however. */
      if (incr < 0) i = ls - ofs;
	else
      i = (ls - ofs) / incr + 1;
      if (i > count)
	{
	  i = count;
	  count = 0;
	}
      else count -= i;
      for(j = 0; j < i; j++)
	{


	offset = ofs >> FRACTION_BITS;

	if (ofs >= se) {
		int32 delta = (ofs - se)>>FRACTION_BITS;
        	v1 = (int32)src[(int32)(se>>FRACTION_BITS)-1];
		if (overshoot) v1 -=  (delta+1) * v1 / overshoot;
        }
	else  v1 = (int32)src[offset];

	if (ofs + (1L<<FRACTION_BITS) >= se) {
		v2 = v1;
        }
	else  v2 = (int32)src[offset+1];

	if ( (vp->algorithm & INTERPOLATION_LINEAR) || dont_cspline ||
	   ((ofs-(1L<<FRACTION_BITS))<ls)||((ofs+(2L<<FRACTION_BITS))>le)){
		if (!cc_count--) {
		    cc_count = control_ratio - 1;
		    if (calc_bw_index(vp)) {
		        bw_index = vp->bw_index;


    reso = vp->resonance + vp->reso_volume;
    if (reso > vp->reso_max) reso = vp->reso_max;
    fmax = (1000 + (vp->reso_max - reso) * (vp->reso_max - reso) * 2) / 100;
    if (reso && bw_index > fmax) bw_index = fmax;
    reso = (reso+5)/10;

    switch(reso) {
	case 0:
		s_freq = vsf_q0[bw_index][0];
		s_damp = vsf_q0[bw_index][1];
		
		
		break;
	case 1:
		s_freq = vsf_q10[bw_index][0];
		s_damp = vsf_q10[bw_index][1];
		
		
		break;
	case 2:
		s_freq = vsf_q20[bw_index][0];
		s_damp = vsf_q20[bw_index][1];
		
		
		break;
	case 3:
		s_freq = vsf_q30[bw_index][0];
		s_damp = vsf_q30[bw_index][1];
		
		
		break;
	case 4:
		s_freq = vsf_q40[bw_index][0];
		s_damp = vsf_q40[bw_index][1];
		
		
		break;
	case 5:
		s_freq = vsf_q50[bw_index][0];
		s_damp = vsf_q50[bw_index][1];
		
		
		break;
	case 6:
		s_freq = vsf_q60[bw_index][0];
		s_damp = vsf_q60[bw_index][1];
		
		
		break;
	case 7:
		s_freq = vsf_q70[bw_index][0];
		s_damp = vsf_q70[bw_index][1];
		
		
		break;
	case 8:
		s_freq = vsf_q80[bw_index][0];
		s_damp = vsf_q80[bw_index][1];
		
		
		break;
	case 9:
		s_freq = vsf_q90[bw_index][0];
		s_damp = vsf_q90[bw_index][1];
		
		
		break;
	case 10:
		s_freq = vsf_q100[bw_index][0];
		s_damp = vsf_q100[bw_index][1];
		
		
		break;
	case 11:
		s_freq = vsf_q110[bw_index][0];
		s_damp = vsf_q110[bw_index][1];
		
		
		break;
	case 12:
		s_freq = vsf_q120[bw_index][0];
		s_damp = vsf_q120[bw_index][1];
		
		
		break;
	case 13:
		s_freq = vsf_q130[bw_index][0];
		s_damp = vsf_q130[bw_index][1];
		
		
		break;
	case 14:
		s_freq = vsf_q140[bw_index][0];
		s_damp = vsf_q140[bw_index][1];
		
		
		break;
	case 15:
		s_freq = vsf_q150[bw_index][0];
		s_damp = vsf_q150[bw_index][1];
		
		
		break;
	case 16:
		s_freq = vsf_q160[bw_index][0];
		s_damp = vsf_q160[bw_index][1];
		
		
		break;
	case 17:
		s_freq = vsf_q170[bw_index][0];
		s_damp = vsf_q170[bw_index][1];
		
		
		break;
	case 18:
		s_freq = vsf_q180[bw_index][0];
		s_damp = vsf_q180[bw_index][1];
		
		
		break;
	case 19:
		s_freq = vsf_q190[bw_index][0];
		s_damp = vsf_q190[bw_index][1];
		
		
		break;
	case 20:
		s_freq = vsf_q200[bw_index][0];
		s_damp = vsf_q200[bw_index][1];
		
		
		break;
	case 21:
		s_freq = vsf_q210[bw_index][0];
		s_damp = vsf_q210[bw_index][1];
		
		
		break;
	case 22:
		s_freq = vsf_q220[bw_index][0];
		s_damp = vsf_q220[bw_index][1];
		
		
		break;
	case 23:
		s_freq = vsf_q230[bw_index][0];
		s_damp = vsf_q230[bw_index][1];
		
		
		break;
	default:
	case 24:
		s_freq = vsf_q240[bw_index][0];
		s_damp = vsf_q240[bw_index][1];
		
		
		break;
    }


		    }
		    incr = calc_mod_freq(vp, incr);
		}
                newsample = (resample_t)(v1 + ((int32)((v2-v1) * (ofs & FRACTION_MASK)) >> FRACTION_BITS));
	        if (bw_index) {
                    insamp = (FLOAT_T)newsample;

		    s_notch = insamp - s_damp*s_band;
		    s_low   = s_low + s_freq*s_band;
		    s_high  = s_notch - s_low;
		    if (s_drive > 0) s_band  = s_freq*s_high + s_band - s_drive*s_band*s_band*s_band;
		    else s_band  = s_freq*s_high + s_band;
		    //outsamp   = 0.5*(s_notch or s_low or s_high or s_band or s_peak);
		    if (filter_type==FILTER_LOWPASS)
		        outsamp  = 0.5*s_low;
		    else if (filter_type==FILTER_HIGHPASS)
		        outsamp  = 0.5*s_high;
		    else if (filter_type==FILTER_BAND)
		        outsamp  = 0.5*s_band;
		    else if (filter_type==FILTER_NOTCH)
		        outsamp  = 0.5*s_notch;
		    else /* if (filter_type==FILTER_PEAK) */
		        outsamp  = 0.5*(s_low-s_high);
		    s_notch = insamp - s_damp*s_band;
		    s_low   = s_low + s_freq*s_band;
		    s_high  = s_notch - s_low;
		    if (s_drive > 0) s_band  = s_freq*s_high + s_band - s_drive*s_band*s_band*s_band;
		    else s_band  = s_freq*s_high + s_band;
		    //outsamp  += 0.5*(same out as above);
		    if (filter_type==FILTER_LOWPASS)
		        outsamp  += 0.5*s_low;
		    else if (filter_type==FILTER_HIGHPASS)
		        outsamp  += 0.5*s_high;
		    else if (filter_type==FILTER_BAND)
		        outsamp  += 0.5*s_band;
		    else if (filter_type==FILTER_NOTCH)
		        outsamp  += 0.5*s_notch;
		    else /* if (filter_type==FILTER_PEAK) */
		        outsamp  += 0.5*(s_low-s_high);

		    newsample = (resample_t)outsamp;
	        }
	}
	else {
		ofsd=ofs;
                v0 = (int32)src[offset-1];
                v3 = (int32)src[offset+2];
                ofs &= FRACTION_MASK;
                temp=v2;
		v2 = (6*v2 +
		      (((( ( (5*v3 - 11*v2 + 7*v1 - v0)*
		       (int32)ofs) >>FRACTION_BITS)*(int32)ofs)>>(FRACTION_BITS+2))-1))*(int32)ofs;
                ofs = (1L << FRACTION_BITS) - ofs;
		v1 = (6*v1 +
		      ((((((5*v0 - 11*v1 + 7*temp - v3)*
		       (int32)ofs)>>FRACTION_BITS)*(int32)ofs)>>(FRACTION_BITS+2))-1))*(int32)ofs;
		v1 = (v1 + v2)/(6L<<FRACTION_BITS);
		if (!cc_count--) {
		    cc_count = control_ratio - 1;
		    if (calc_bw_index(vp)) {
			bw_index = vp->bw_index;


    reso = vp->resonance + vp->reso_volume;
    if (reso > vp->reso_max) reso = vp->reso_max;
    fmax = (1000 + (vp->reso_max - reso) * (vp->reso_max - reso) * 2) / 100;
    if (reso && bw_index > fmax) bw_index = fmax;
    reso = (reso+5)/10;

    switch(reso) {
	case 0:
		s_freq = vsf_q0[bw_index][0];
		s_damp = vsf_q0[bw_index][1];
		
		
		break;
	case 1:
		s_freq = vsf_q10[bw_index][0];
		s_damp = vsf_q10[bw_index][1];
		
		
		break;
	case 2:
		s_freq = vsf_q20[bw_index][0];
		s_damp = vsf_q20[bw_index][1];
		
		
		break;
	case 3:
		s_freq = vsf_q30[bw_index][0];
		s_damp = vsf_q30[bw_index][1];
		
		
		break;
	case 4:
		s_freq = vsf_q40[bw_index][0];
		s_damp = vsf_q40[bw_index][1];
		
		
		break;
	case 5:
		s_freq = vsf_q50[bw_index][0];
		s_damp = vsf_q50[bw_index][1];
		
		
		break;
	case 6:
		s_freq = vsf_q60[bw_index][0];
		s_damp = vsf_q60[bw_index][1];
		
		
		break;
	case 7:
		s_freq = vsf_q70[bw_index][0];
		s_damp = vsf_q70[bw_index][1];
		
		
		break;
	case 8:
		s_freq = vsf_q80[bw_index][0];
		s_damp = vsf_q80[bw_index][1];
		
		
		break;
	case 9:
		s_freq = vsf_q90[bw_index][0];
		s_damp = vsf_q90[bw_index][1];
		
		
		break;
	case 10:
		s_freq = vsf_q100[bw_index][0];
		s_damp = vsf_q100[bw_index][1];
		
		
		break;
	case 11:
		s_freq = vsf_q110[bw_index][0];
		s_damp = vsf_q110[bw_index][1];
		
		
		break;
	case 12:
		s_freq = vsf_q120[bw_index][0];
		s_damp = vsf_q120[bw_index][1];
		
		
		break;
	case 13:
		s_freq = vsf_q130[bw_index][0];
		s_damp = vsf_q130[bw_index][1];
		
		
		break;
	case 14:
		s_freq = vsf_q140[bw_index][0];
		s_damp = vsf_q140[bw_index][1];
		
		
		break;
	case 15:
		s_freq = vsf_q150[bw_index][0];
		s_damp = vsf_q150[bw_index][1];
		
		
		break;
	case 16:
		s_freq = vsf_q160[bw_index][0];
		s_damp = vsf_q160[bw_index][1];
		
		
		break;
	case 17:
		s_freq = vsf_q170[bw_index][0];
		s_damp = vsf_q170[bw_index][1];
		
		
		break;
	case 18:
		s_freq = vsf_q180[bw_index][0];
		s_damp = vsf_q180[bw_index][1];
		
		
		break;
	case 19:
		s_freq = vsf_q190[bw_index][0];
		s_damp = vsf_q190[bw_index][1];
		
		
		break;
	case 20:
		s_freq = vsf_q200[bw_index][0];
		s_damp = vsf_q200[bw_index][1];
		
		
		break;
	case 21:
		s_freq = vsf_q210[bw_index][0];
		s_damp = vsf_q210[bw_index][1];
		
		
		break;
	case 22:
		s_freq = vsf_q220[bw_index][0];
		s_damp = vsf_q220[bw_index][1];
		
		
		break;
	case 23:
		s_freq = vsf_q230[bw_index][0];
		s_damp = vsf_q230[bw_index][1];
		
		
		break;
	default:
	case 24:
		s_freq = vsf_q240[bw_index][0];
		s_damp = vsf_q240[bw_index][1];
		
		
		break;
    }




		    }
		    incr = calc_mod_freq(vp, incr);
		}
		newsample = (resample_t)v1;
		if (bw_index) {
                    insamp = (FLOAT_T)newsample;

		    s_notch = insamp - s_damp*s_band;
		    s_low   = s_low + s_freq*s_band;
		    s_high  = s_notch - s_low;
		    if (s_drive > 0) s_band  = s_freq*s_high + s_band - s_drive*s_band*s_band*s_band;
		    else s_band  = s_freq*s_high + s_band;

		    if (filter_type==FILTER_LOWPASS)
		        outsamp  = 0.5*s_low;
		    else if (filter_type==FILTER_HIGHPASS)
		        outsamp  = 0.5*s_high;
		    else if (filter_type==FILTER_BAND)
		        outsamp  = 0.5*s_band;
		    else if (filter_type==FILTER_NOTCH)
		        outsamp  = 0.5*s_notch;
		    else /* if (filter_type==FILTER_PEAK) */
		        outsamp  = 0.5*(s_low-s_high);

		    s_notch = insamp - s_damp*s_band;
		    s_low   = s_low + s_freq*s_band;
		    s_high  = s_notch - s_low;
		    if (s_drive > 0) s_band  = s_freq*s_high + s_band - s_drive*s_band*s_band*s_band;
		    else s_band  = s_freq*s_high + s_band;

		    if (filter_type==FILTER_LOWPASS)
		        outsamp  += 0.5*s_low;
		    else if (filter_type==FILTER_HIGHPASS)
		        outsamp  += 0.5*s_high;
		    else if (filter_type==FILTER_BAND)
		        outsamp  += 0.5*s_band;
		    else if (filter_type==FILTER_NOTCH)
		        outsamp  += 0.5*s_notch;
		    else /* if (filter_type==FILTER_PEAK) */
		        outsamp  += 0.5*(s_low-s_high);


		    newsample = (resample_t)outsamp;
		}
		ofs=ofsd;
	}
	*dest++ = newsample;
	  ofs += incr;
	}
    }

  /* Then do the bidirectional looping */

  while(count)
    {
      /* Precalc how many times we should go through the loop */
#if 1
      i = ((incr > 0 ? le : ls) - ofs) / incr + 1;
#else
/* fix from M. Izumo */
      i = ((incr > 0 ? le : ls) - ofs + incr - 1) / incr;
#endif
      if (i > count)
	{
	  i = count;
	  count = 0;
	}
      else count -= i;
      for(j = 0; j < i && ofs < se; j++)
	{


	offset = ofs >> FRACTION_BITS;

	if (ofs >= se) {
		int32 delta = (ofs - se)>>FRACTION_BITS;
        	v1 = (int32)src[(int32)(se>>FRACTION_BITS)-1];
		if (overshoot) v1 -=  (delta+1) * v1 / overshoot;
        }
	else  v1 = (int32)src[offset];

	if (ofs + (1L<<FRACTION_BITS) >= se) {
		v2 = v1;
        }
	else  v2 = (int32)src[offset+1];

	if ( (vp->algorithm & INTERPOLATION_LINEAR) || dont_cspline ||
	   ((ofs-(1L<<FRACTION_BITS))<ls)||((ofs+(2L<<FRACTION_BITS))>le)){
		if (!cc_count--) {
		    cc_count = control_ratio - 1;
		    if (calc_bw_index(vp)) {
		        bw_index = vp->bw_index;


    reso = vp->resonance + vp->reso_volume;
    if (reso > vp->reso_max) reso = vp->reso_max;
    fmax = (1000 + (vp->reso_max - reso) * (vp->reso_max - reso) * 2) / 100;
    if (reso && bw_index > fmax) bw_index = fmax;
    reso = (reso+5)/10;

    switch(reso) {
	case 0:
		s_freq = vsf_q0[bw_index][0];
		s_damp = vsf_q0[bw_index][1];
		
		
		break;
	case 1:
		s_freq = vsf_q10[bw_index][0];
		s_damp = vsf_q10[bw_index][1];
		
		
		break;
	case 2:
		s_freq = vsf_q20[bw_index][0];
		s_damp = vsf_q20[bw_index][1];
		
		
		break;
	case 3:
		s_freq = vsf_q30[bw_index][0];
		s_damp = vsf_q30[bw_index][1];
		
		
		break;
	case 4:
		s_freq = vsf_q40[bw_index][0];
		s_damp = vsf_q40[bw_index][1];
		
		
		break;
	case 5:
		s_freq = vsf_q50[bw_index][0];
		s_damp = vsf_q50[bw_index][1];
		
		
		break;
	case 6:
		s_freq = vsf_q60[bw_index][0];
		s_damp = vsf_q60[bw_index][1];
		
		
		break;
	case 7:
		s_freq = vsf_q70[bw_index][0];
		s_damp = vsf_q70[bw_index][1];
		
		
		break;
	case 8:
		s_freq = vsf_q80[bw_index][0];
		s_damp = vsf_q80[bw_index][1];
		
		
		break;
	case 9:
		s_freq = vsf_q90[bw_index][0];
		s_damp = vsf_q90[bw_index][1];
		
		
		break;
	case 10:
		s_freq = vsf_q100[bw_index][0];
		s_damp = vsf_q100[bw_index][1];
		
		
		break;
	case 11:
		s_freq = vsf_q110[bw_index][0];
		s_damp = vsf_q110[bw_index][1];
		
		
		break;
	case 12:
		s_freq = vsf_q120[bw_index][0];
		s_damp = vsf_q120[bw_index][1];
		
		
		break;
	case 13:
		s_freq = vsf_q130[bw_index][0];
		s_damp = vsf_q130[bw_index][1];
		
		
		break;
	case 14:
		s_freq = vsf_q140[bw_index][0];
		s_damp = vsf_q140[bw_index][1];
		
		
		break;
	case 15:
		s_freq = vsf_q150[bw_index][0];
		s_damp = vsf_q150[bw_index][1];
		
		
		break;
	case 16:
		s_freq = vsf_q160[bw_index][0];
		s_damp = vsf_q160[bw_index][1];
		
		
		break;
	case 17:
		s_freq = vsf_q170[bw_index][0];
		s_damp = vsf_q170[bw_index][1];
		
		
		break;
	case 18:
		s_freq = vsf_q180[bw_index][0];
		s_damp = vsf_q180[bw_index][1];
		
		
		break;
	case 19:
		s_freq = vsf_q190[bw_index][0];
		s_damp = vsf_q190[bw_index][1];
		
		
		break;
	case 20:
		s_freq = vsf_q200[bw_index][0];
		s_damp = vsf_q200[bw_index][1];
		
		
		break;
	case 21:
		s_freq = vsf_q210[bw_index][0];
		s_damp = vsf_q210[bw_index][1];
		
		
		break;
	case 22:
		s_freq = vsf_q220[bw_index][0];
		s_damp = vsf_q220[bw_index][1];
		
		
		break;
	case 23:
		s_freq = vsf_q230[bw_index][0];
		s_damp = vsf_q230[bw_index][1];
		
		
		break;
	default:
	case 24:
		s_freq = vsf_q240[bw_index][0];
		s_damp = vsf_q240[bw_index][1];
		
		
		break;
    }


		    }
		    incr = calc_mod_freq(vp, incr);
		}
                newsample = (resample_t)(v1 + ((int32)((v2-v1) * (ofs & FRACTION_MASK)) >> FRACTION_BITS));
	        if (bw_index) {
                    insamp = (FLOAT_T)newsample;

		    s_notch = insamp - s_damp*s_band;
		    s_low   = s_low + s_freq*s_band;
		    s_high  = s_notch - s_low;
		    if (s_drive > 0) s_band  = s_freq*s_high + s_band - s_drive*s_band*s_band*s_band;
		    else s_band  = s_freq*s_high + s_band;
		    //outsamp   = 0.5*(s_notch or s_low or s_high or s_band or s_peak);
		    if (filter_type==FILTER_LOWPASS)
		        outsamp  = 0.5*s_low;
		    else if (filter_type==FILTER_HIGHPASS)
		        outsamp  = 0.5*s_high;
		    else if (filter_type==FILTER_BAND)
		        outsamp  = 0.5*s_band;
		    else if (filter_type==FILTER_NOTCH)
		        outsamp  = 0.5*s_notch;
		    else /* if (filter_type==FILTER_PEAK) */
		        outsamp  = 0.5*(s_low-s_high);
		    s_notch = insamp - s_damp*s_band;
		    s_low   = s_low + s_freq*s_band;
		    s_high  = s_notch - s_low;
		    if (s_drive > 0) s_band  = s_freq*s_high + s_band - s_drive*s_band*s_band*s_band;
		    else s_band  = s_freq*s_high + s_band;
		    //outsamp  += 0.5*(same out as above);
		    if (filter_type==FILTER_LOWPASS)
		        outsamp  += 0.5*s_low;
		    else if (filter_type==FILTER_HIGHPASS)
		        outsamp  += 0.5*s_high;
		    else if (filter_type==FILTER_BAND)
		        outsamp  += 0.5*s_band;
		    else if (filter_type==FILTER_NOTCH)
		        outsamp  += 0.5*s_notch;
		    else /* if (filter_type==FILTER_PEAK) */
		        outsamp  += 0.5*(s_low-s_high);

		    newsample = (resample_t)outsamp;
	        }
	}
	else {
		ofsd=ofs;
                v0 = (int32)src[offset-1];
                v3 = (int32)src[offset+2];
                ofs &= FRACTION_MASK;
                temp=v2;
		v2 = (6*v2 +
		      (((( ( (5*v3 - 11*v2 + 7*v1 - v0)*
		       (int32)ofs) >>FRACTION_BITS)*(int32)ofs)>>(FRACTION_BITS+2))-1))*(int32)ofs;
                ofs = (1L << FRACTION_BITS) - ofs;
		v1 = (6*v1 +
		      ((((((5*v0 - 11*v1 + 7*temp - v3)*
		       (int32)ofs)>>FRACTION_BITS)*(int32)ofs)>>(FRACTION_BITS+2))-1))*(int32)ofs;
		v1 = (v1 + v2)/(6L<<FRACTION_BITS);
		if (!cc_count--) {
		    cc_count = control_ratio - 1;
		    if (calc_bw_index(vp)) {
			bw_index = vp->bw_index;


    reso = vp->resonance + vp->reso_volume;
    if (reso > vp->reso_max) reso = vp->reso_max;
    fmax = (1000 + (vp->reso_max - reso) * (vp->reso_max - reso) * 2) / 100;
    if (reso && bw_index > fmax) bw_index = fmax;
    reso = (reso+5)/10;

    switch(reso) {
	case 0:
		s_freq = vsf_q0[bw_index][0];
		s_damp = vsf_q0[bw_index][1];
		
		
		break;
	case 1:
		s_freq = vsf_q10[bw_index][0];
		s_damp = vsf_q10[bw_index][1];
		
		
		break;
	case 2:
		s_freq = vsf_q20[bw_index][0];
		s_damp = vsf_q20[bw_index][1];
		
		
		break;
	case 3:
		s_freq = vsf_q30[bw_index][0];
		s_damp = vsf_q30[bw_index][1];
		
		
		break;
	case 4:
		s_freq = vsf_q40[bw_index][0];
		s_damp = vsf_q40[bw_index][1];
		
		
		break;
	case 5:
		s_freq = vsf_q50[bw_index][0];
		s_damp = vsf_q50[bw_index][1];
		
		
		break;
	case 6:
		s_freq = vsf_q60[bw_index][0];
		s_damp = vsf_q60[bw_index][1];
		
		
		break;
	case 7:
		s_freq = vsf_q70[bw_index][0];
		s_damp = vsf_q70[bw_index][1];
		
		
		break;
	case 8:
		s_freq = vsf_q80[bw_index][0];
		s_damp = vsf_q80[bw_index][1];
		
		
		break;
	case 9:
		s_freq = vsf_q90[bw_index][0];
		s_damp = vsf_q90[bw_index][1];
		
		
		break;
	case 10:
		s_freq = vsf_q100[bw_index][0];
		s_damp = vsf_q100[bw_index][1];
		
		
		break;
	case 11:
		s_freq = vsf_q110[bw_index][0];
		s_damp = vsf_q110[bw_index][1];
		
		
		break;
	case 12:
		s_freq = vsf_q120[bw_index][0];
		s_damp = vsf_q120[bw_index][1];
		
		
		break;
	case 13:
		s_freq = vsf_q130[bw_index][0];
		s_damp = vsf_q130[bw_index][1];
		
		
		break;
	case 14:
		s_freq = vsf_q140[bw_index][0];
		s_damp = vsf_q140[bw_index][1];
		
		
		break;
	case 15:
		s_freq = vsf_q150[bw_index][0];
		s_damp = vsf_q150[bw_index][1];
		
		
		break;
	case 16:
		s_freq = vsf_q160[bw_index][0];
		s_damp = vsf_q160[bw_index][1];
		
		
		break;
	case 17:
		s_freq = vsf_q170[bw_index][0];
		s_damp = vsf_q170[bw_index][1];
		
		
		break;
	case 18:
		s_freq = vsf_q180[bw_index][0];
		s_damp = vsf_q180[bw_index][1];
		
		
		break;
	case 19:
		s_freq = vsf_q190[bw_index][0];
		s_damp = vsf_q190[bw_index][1];
		
		
		break;
	case 20:
		s_freq = vsf_q200[bw_index][0];
		s_damp = vsf_q200[bw_index][1];
		
		
		break;
	case 21:
		s_freq = vsf_q210[bw_index][0];
		s_damp = vsf_q210[bw_index][1];
		
		
		break;
	case 22:
		s_freq = vsf_q220[bw_index][0];
		s_damp = vsf_q220[bw_index][1];
		
		
		break;
	case 23:
		s_freq = vsf_q230[bw_index][0];
		s_damp = vsf_q230[bw_index][1];
		
		
		break;
	default:
	case 24:
		s_freq = vsf_q240[bw_index][0];
		s_damp = vsf_q240[bw_index][1];
		
		
		break;
    }




		    }
		    incr = calc_mod_freq(vp, incr);
		}
		newsample = (resample_t)v1;
		if (bw_index) {
                    insamp = (FLOAT_T)newsample;

		    s_notch = insamp - s_damp*s_band;
		    s_low   = s_low + s_freq*s_band;
		    s_high  = s_notch - s_low;
		    if (s_drive > 0) s_band  = s_freq*s_high + s_band - s_drive*s_band*s_band*s_band;
		    else s_band  = s_freq*s_high + s_band;

		    if (filter_type==FILTER_LOWPASS)
		        outsamp  = 0.5*s_low;
		    else if (filter_type==FILTER_HIGHPASS)
		        outsamp  = 0.5*s_high;
		    else if (filter_type==FILTER_BAND)
		        outsamp  = 0.5*s_band;
		    else if (filter_type==FILTER_NOTCH)
		        outsamp  = 0.5*s_notch;
		    else /* if (filter_type==FILTER_PEAK) */
		        outsamp  = 0.5*(s_low-s_high);

		    s_notch = insamp - s_damp*s_band;
		    s_low   = s_low + s_freq*s_band;
		    s_high  = s_notch - s_low;
		    if (s_drive > 0) s_band  = s_freq*s_high + s_band - s_drive*s_band*s_band*s_band;
		    else s_band  = s_freq*s_high + s_band;

		    if (filter_type==FILTER_LOWPASS)
		        outsamp  += 0.5*s_low;
		    else if (filter_type==FILTER_HIGHPASS)
		        outsamp  += 0.5*s_high;
		    else if (filter_type==FILTER_BAND)
		        outsamp  += 0.5*s_band;
		    else if (filter_type==FILTER_NOTCH)
		        outsamp  += 0.5*s_notch;
		    else /* if (filter_type==FILTER_PEAK) */
		        outsamp  += 0.5*(s_low-s_high);


		    newsample = (resample_t)outsamp;
		}
		ofs=ofsd;
	}
	*dest++ = newsample;
	  ofs += incr;
	}
#ifdef USE_BIDIR_OVERSHOOT
      if (ofs>=le)
	{
	  /* fold the overshoot back in */
	  ofs = le2 - ofs;
	  incr *= -1;
	}
      else if (ofs <= ls)
	{
	  ofs = ls2 - ofs;
	  incr *= -1;
	}
#else
	  incr *= -1;
#endif
    }

  vp->sample_increment=incr;
  vp->sample_offset=ofs; /* Update offset */
  vp->current_x0=s_low;
  vp->current_x1=s_band;
  vp->bw_index=bw_index;
  vp->modulation_counter=cc_count;
  return resample_buffer+resample_buffer_offset;
}

/*********************** vibrato versions ***************************/

/* We only need to compute one half of the vibrato sine cycle */
static uint32 vib_phase_to_inc_ptr(uint32 phase)
{
  if (phase < VIBRATO_SAMPLE_INCREMENTS/2)
    return VIBRATO_SAMPLE_INCREMENTS/2-1-phase;
  else if (phase >= 3*VIBRATO_SAMPLE_INCREMENTS/2)
    return 5*VIBRATO_SAMPLE_INCREMENTS/2-1-phase;
  else
    return phase-VIBRATO_SAMPLE_INCREMENTS/2;
}

static int32 update_vibrato(Voice *vp, int sign)
{
  uint32 depth, freq=vp->frequency;
#ifdef ENVELOPE_PITCH_MODULATION
  FLOAT_T mod_amount=vp->modEnvToPitch;
#endif
  uint32 phase;
  int pb;
  double a;

  if(vp->vibrato_delay > 0)
  {
      vp->vibrato_delay -= vp->vibrato_control_ratio;
      if(vp->vibrato_delay > 0)
	  return vp->sample_increment;
  }

  if (vp->vibrato_phase++ >= 2*VIBRATO_SAMPLE_INCREMENTS-1)
    vp->vibrato_phase=0;
  phase=vib_phase_to_inc_ptr(vp->vibrato_phase);

  if (vp->vibrato_sample_increment[phase])
    {
      if (sign)
	return -vp->vibrato_sample_increment[phase];
      else
	return vp->vibrato_sample_increment[phase];
    }

  /* Need to compute this sample increment. */

  depth = vp->vibrato_depth;
  if(depth < vp->modulation_wheel)
      depth = vp->modulation_wheel;
  depth <<= 7;

  if (vp->vibrato_sweep && !vp->modulation_wheel)
    {
      /* Need to update sweep */
      vp->vibrato_sweep_position += vp->vibrato_sweep;
      if (vp->vibrato_sweep_position >= (1<<SWEEP_SHIFT))
	vp->vibrato_sweep=0;
      else
	{
	  /* Adjust depth */
	  depth *= vp->vibrato_sweep_position;
	  depth >>= SWEEP_SHIFT;
	}
    }

#ifdef ENVELOPE_PITCH_MODULATION
#ifndef FILTER_INTERPOLATION
  if (update_modulation_signal(vp)) mod_amount = 0;
  else
#endif
  if (mod_amount>0.5)
   freq = (int32)( (double)freq*(1.0 + (mod_amount - 1.0) * (vp->modulation_volume>>22) / 255.0) );
#endif

  pb=(int)((sine(vp->vibrato_phase *
			(SINE_CYCLE_LENGTH/(2*VIBRATO_SAMPLE_INCREMENTS)))
	    * (double)(depth) * VIBRATO_AMPLITUDE_TUNING));

  a = FRSCALE(((double)(vp->sample->sample_rate) *
		  (double)(freq)) /
		 ((double)(vp->sample->root_freq) *
		  (double)(play_mode->rate)),
		 FRACTION_BITS);
  if(pb<0)
  {
      pb = -pb;
      a /= bend_fine[(pb>>5) & 0xFF] * bend_coarse[pb>>13];
  }
  else
      a *= bend_fine[(pb>>5) & 0xFF] * bend_coarse[pb>>13];
  a += 0.5;

  /* If the sweep's over, we can store the newly computed sample_increment */
  if (!vp->vibrato_sweep || vp->modulation_wheel)
    vp->vibrato_sample_increment[phase]=(int32) a;

  if (sign)
    a = -a; /* need to preserve the loop direction */

  return (int32) a;
}

static resample_t *rs_vib_plain(int v, uint32 *countptr)
{

  /* Play sample until end, then free the voice. */

  Voice *vp=&voice[v];
  int32   v0, v1, v2, v3, temp, overshoot;
  splen_t ofsd;
  int32 offset;
  FLOAT_T insamp, outsamp, s_high, s_notch, s_freq, s_damp,
    s_low=vp->current_x0, s_band=vp->current_x1,
    s_drive=(FLOAT_T)vp->drive/255000000.0;
  uint32 cc_count=vp->modulation_counter, bw_index=vp->bw_index, fmax;
  uint16 reso;
  const uint8 filter_type=vp->filter_type;
  resample_t newsample;
  resample_t
    *dest=resample_buffer+resample_buffer_offset;
#ifdef SL32
  samplel_t
    *src=vp->sample->ldata;
#else
  sample_t
    *src=vp->sample->data;
#endif
  int32
    incr=vp->sample_increment;
#if defined(LAGRANGE_INTERPOLATION) || defined(CSPLINE_INTERPOLATION)
  splen_t
    ls=0,
    le=vp->sample->data_length;
#endif /* LAGRANGE_INTERPOLATION */
  splen_t
    ofs=vp->sample_offset,
    se=vp->sample->data_length,
    count=*countptr;
  uint32
    cc=vp->vibrato_control_counter;

  /* This has never been tested */

  if (incr<0) incr = -incr; /* In case we're coming out of a bidir loop */

  overshoot = src[(se>>FRACTION_BITS)-1] / OVERSHOOT_STEP;
  if (overshoot < 0) overshoot = -overshoot;

    reso = vp->resonance + vp->reso_volume;
    if (reso > vp->reso_max) reso = vp->reso_max;
    fmax = (1000 + (vp->reso_max - reso) * (vp->reso_max - reso) * 2) / 100;
    if (reso && bw_index > fmax) bw_index = fmax;
    reso = (reso+5)/10;

    switch(reso) {
	case 0:
		s_freq = vsf_q0[bw_index][0];
		s_damp = vsf_q0[bw_index][1];
		
		
		break;
	case 1:
		s_freq = vsf_q10[bw_index][0];
		s_damp = vsf_q10[bw_index][1];
		
		
		break;
	case 2:
		s_freq = vsf_q20[bw_index][0];
		s_damp = vsf_q20[bw_index][1];
		
		
		break;
	case 3:
		s_freq = vsf_q30[bw_index][0];
		s_damp = vsf_q30[bw_index][1];
		
		
		break;
	case 4:
		s_freq = vsf_q40[bw_index][0];
		s_damp = vsf_q40[bw_index][1];
		
		
		break;
	case 5:
		s_freq = vsf_q50[bw_index][0];
		s_damp = vsf_q50[bw_index][1];
		
		
		break;
	case 6:
		s_freq = vsf_q60[bw_index][0];
		s_damp = vsf_q60[bw_index][1];
		
		
		break;
	case 7:
		s_freq = vsf_q70[bw_index][0];
		s_damp = vsf_q70[bw_index][1];
		
		
		break;
	case 8:
		s_freq = vsf_q80[bw_index][0];
		s_damp = vsf_q80[bw_index][1];
		
		
		break;
	case 9:
		s_freq = vsf_q90[bw_index][0];
		s_damp = vsf_q90[bw_index][1];
		
		
		break;
	case 10:
		s_freq = vsf_q100[bw_index][0];
		s_damp = vsf_q100[bw_index][1];
		
		
		break;
	case 11:
		s_freq = vsf_q110[bw_index][0];
		s_damp = vsf_q110[bw_index][1];
		
		
		break;
	case 12:
		s_freq = vsf_q120[bw_index][0];
		s_damp = vsf_q120[bw_index][1];
		
		
		break;
	case 13:
		s_freq = vsf_q130[bw_index][0];
		s_damp = vsf_q130[bw_index][1];
		
		
		break;
	case 14:
		s_freq = vsf_q140[bw_index][0];
		s_damp = vsf_q140[bw_index][1];
		
		
		break;
	case 15:
		s_freq = vsf_q150[bw_index][0];
		s_damp = vsf_q150[bw_index][1];
		
		
		break;
	case 16:
		s_freq = vsf_q160[bw_index][0];
		s_damp = vsf_q160[bw_index][1];
		
		
		break;
	case 17:
		s_freq = vsf_q170[bw_index][0];
		s_damp = vsf_q170[bw_index][1];
		
		
		break;
	case 18:
		s_freq = vsf_q180[bw_index][0];
		s_damp = vsf_q180[bw_index][1];
		
		
		break;
	case 19:
		s_freq = vsf_q190[bw_index][0];
		s_damp = vsf_q190[bw_index][1];
		
		
		break;
	case 20:
		s_freq = vsf_q200[bw_index][0];
		s_damp = vsf_q200[bw_index][1];
		
		
		break;
	case 21:
		s_freq = vsf_q210[bw_index][0];
		s_damp = vsf_q210[bw_index][1];
		
		
		break;
	case 22:
		s_freq = vsf_q220[bw_index][0];
		s_damp = vsf_q220[bw_index][1];
		
		
		break;
	case 23:
		s_freq = vsf_q230[bw_index][0];
		s_damp = vsf_q230[bw_index][1];
		
		
		break;
	default:
	case 24:
		s_freq = vsf_q240[bw_index][0];
		s_damp = vsf_q240[bw_index][1];
		
		
		break;
    }

  while (count--)
    {
      if (!cc--)
	{
	  cc=vp->vibrato_control_ratio;
	  incr=update_vibrato(vp, 0);
	}


	offset = ofs >> FRACTION_BITS;

	if (ofs >= se) {
		int32 delta = (ofs - se)>>FRACTION_BITS;
        	v1 = (int32)src[(int32)(se>>FRACTION_BITS)-1];
		if (overshoot) v1 -=  (delta+1) * v1 / overshoot;
        }
	else  v1 = (int32)src[offset];

	if (ofs + (1L<<FRACTION_BITS) >= se) {
		v2 = v1;
        }
	else  v2 = (int32)src[offset+1];

	if ( (vp->algorithm & INTERPOLATION_LINEAR) || dont_cspline ||
	   ((ofs-(1L<<FRACTION_BITS))<ls)||((ofs+(2L<<FRACTION_BITS))>le)){
		if (!cc_count--) {
		    cc_count = control_ratio - 1;
		    if (calc_bw_index(vp)) {
		        bw_index = vp->bw_index;


    reso = vp->resonance + vp->reso_volume;
    if (reso > vp->reso_max) reso = vp->reso_max;
    fmax = (1000 + (vp->reso_max - reso) * (vp->reso_max - reso) * 2) / 100;
    if (reso && bw_index > fmax) bw_index = fmax;
    reso = (reso+5)/10;

    switch(reso) {
	case 0:
		s_freq = vsf_q0[bw_index][0];
		s_damp = vsf_q0[bw_index][1];
		
		
		break;
	case 1:
		s_freq = vsf_q10[bw_index][0];
		s_damp = vsf_q10[bw_index][1];
		
		
		break;
	case 2:
		s_freq = vsf_q20[bw_index][0];
		s_damp = vsf_q20[bw_index][1];
		
		
		break;
	case 3:
		s_freq = vsf_q30[bw_index][0];
		s_damp = vsf_q30[bw_index][1];
		
		
		break;
	case 4:
		s_freq = vsf_q40[bw_index][0];
		s_damp = vsf_q40[bw_index][1];
		
		
		break;
	case 5:
		s_freq = vsf_q50[bw_index][0];
		s_damp = vsf_q50[bw_index][1];
		
		
		break;
	case 6:
		s_freq = vsf_q60[bw_index][0];
		s_damp = vsf_q60[bw_index][1];
		
		
		break;
	case 7:
		s_freq = vsf_q70[bw_index][0];
		s_damp = vsf_q70[bw_index][1];
		
		
		break;
	case 8:
		s_freq = vsf_q80[bw_index][0];
		s_damp = vsf_q80[bw_index][1];
		
		
		break;
	case 9:
		s_freq = vsf_q90[bw_index][0];
		s_damp = vsf_q90[bw_index][1];
		
		
		break;
	case 10:
		s_freq = vsf_q100[bw_index][0];
		s_damp = vsf_q100[bw_index][1];
		
		
		break;
	case 11:
		s_freq = vsf_q110[bw_index][0];
		s_damp = vsf_q110[bw_index][1];
		
		
		break;
	case 12:
		s_freq = vsf_q120[bw_index][0];
		s_damp = vsf_q120[bw_index][1];
		
		
		break;
	case 13:
		s_freq = vsf_q130[bw_index][0];
		s_damp = vsf_q130[bw_index][1];
		
		
		break;
	case 14:
		s_freq = vsf_q140[bw_index][0];
		s_damp = vsf_q140[bw_index][1];
		
		
		break;
	case 15:
		s_freq = vsf_q150[bw_index][0];
		s_damp = vsf_q150[bw_index][1];
		
		
		break;
	case 16:
		s_freq = vsf_q160[bw_index][0];
		s_damp = vsf_q160[bw_index][1];
		
		
		break;
	case 17:
		s_freq = vsf_q170[bw_index][0];
		s_damp = vsf_q170[bw_index][1];
		
		
		break;
	case 18:
		s_freq = vsf_q180[bw_index][0];
		s_damp = vsf_q180[bw_index][1];
		
		
		break;
	case 19:
		s_freq = vsf_q190[bw_index][0];
		s_damp = vsf_q190[bw_index][1];
		
		
		break;
	case 20:
		s_freq = vsf_q200[bw_index][0];
		s_damp = vsf_q200[bw_index][1];
		
		
		break;
	case 21:
		s_freq = vsf_q210[bw_index][0];
		s_damp = vsf_q210[bw_index][1];
		
		
		break;
	case 22:
		s_freq = vsf_q220[bw_index][0];
		s_damp = vsf_q220[bw_index][1];
		
		
		break;
	case 23:
		s_freq = vsf_q230[bw_index][0];
		s_damp = vsf_q230[bw_index][1];
		
		
		break;
	default:
	case 24:
		s_freq = vsf_q240[bw_index][0];
		s_damp = vsf_q240[bw_index][1];
		
		
		break;
    }


		    }
		    incr = calc_mod_freq(vp, incr);
		}
                newsample = (resample_t)(v1 + ((int32)((v2-v1) * (ofs & FRACTION_MASK)) >> FRACTION_BITS));
	        if (bw_index) {
                    insamp = (FLOAT_T)newsample;

		    s_notch = insamp - s_damp*s_band;
		    s_low   = s_low + s_freq*s_band;
		    s_high  = s_notch - s_low;
		    if (s_drive > 0) s_band  = s_freq*s_high + s_band - s_drive*s_band*s_band*s_band;
		    else s_band  = s_freq*s_high + s_band;
		    //outsamp   = 0.5*(s_notch or s_low or s_high or s_band or s_peak);
		    if (filter_type==FILTER_LOWPASS)
		        outsamp  = 0.5*s_low;
		    else if (filter_type==FILTER_HIGHPASS)
		        outsamp  = 0.5*s_high;
		    else if (filter_type==FILTER_BAND)
		        outsamp  = 0.5*s_band;
		    else if (filter_type==FILTER_NOTCH)
		        outsamp  = 0.5*s_notch;
		    else /* if (filter_type==FILTER_PEAK) */
		        outsamp  = 0.5*(s_low-s_high);
		    s_notch = insamp - s_damp*s_band;
		    s_low   = s_low + s_freq*s_band;
		    s_high  = s_notch - s_low;
		    if (s_drive > 0) s_band  = s_freq*s_high + s_band - s_drive*s_band*s_band*s_band;
		    else s_band  = s_freq*s_high + s_band;
		    //outsamp  += 0.5*(same out as above);
		    if (filter_type==FILTER_LOWPASS)
		        outsamp  += 0.5*s_low;
		    else if (filter_type==FILTER_HIGHPASS)
		        outsamp  += 0.5*s_high;
		    else if (filter_type==FILTER_BAND)
		        outsamp  += 0.5*s_band;
		    else if (filter_type==FILTER_NOTCH)
		        outsamp  += 0.5*s_notch;
		    else /* if (filter_type==FILTER_PEAK) */
		        outsamp  += 0.5*(s_low-s_high);

		    newsample = (resample_t)outsamp;
	        }
	}
	else {
		ofsd=ofs;
                v0 = (int32)src[offset-1];
                v3 = (int32)src[offset+2];
                ofs &= FRACTION_MASK;
                temp=v2;
		v2 = (6*v2 +
		      (((( ( (5*v3 - 11*v2 + 7*v1 - v0)*
		       (int32)ofs) >>FRACTION_BITS)*(int32)ofs)>>(FRACTION_BITS+2))-1))*(int32)ofs;
                ofs = (1L << FRACTION_BITS) - ofs;
		v1 = (6*v1 +
		      ((((((5*v0 - 11*v1 + 7*temp - v3)*
		       (int32)ofs)>>FRACTION_BITS)*(int32)ofs)>>(FRACTION_BITS+2))-1))*(int32)ofs;
		v1 = (v1 + v2)/(6L<<FRACTION_BITS);
		if (!cc_count--) {
		    cc_count = control_ratio - 1;
		    if (calc_bw_index(vp)) {
			bw_index = vp->bw_index;


    reso = vp->resonance + vp->reso_volume;
    if (reso > vp->reso_max) reso = vp->reso_max;
    fmax = (1000 + (vp->reso_max - reso) * (vp->reso_max - reso) * 2) / 100;
    if (reso && bw_index > fmax) bw_index = fmax;
    reso = (reso+5)/10;

    switch(reso) {
	case 0:
		s_freq = vsf_q0[bw_index][0];
		s_damp = vsf_q0[bw_index][1];
		
		
		break;
	case 1:
		s_freq = vsf_q10[bw_index][0];
		s_damp = vsf_q10[bw_index][1];
		
		
		break;
	case 2:
		s_freq = vsf_q20[bw_index][0];
		s_damp = vsf_q20[bw_index][1];
		
		
		break;
	case 3:
		s_freq = vsf_q30[bw_index][0];
		s_damp = vsf_q30[bw_index][1];
		
		
		break;
	case 4:
		s_freq = vsf_q40[bw_index][0];
		s_damp = vsf_q40[bw_index][1];
		
		
		break;
	case 5:
		s_freq = vsf_q50[bw_index][0];
		s_damp = vsf_q50[bw_index][1];
		
		
		break;
	case 6:
		s_freq = vsf_q60[bw_index][0];
		s_damp = vsf_q60[bw_index][1];
		
		
		break;
	case 7:
		s_freq = vsf_q70[bw_index][0];
		s_damp = vsf_q70[bw_index][1];
		
		
		break;
	case 8:
		s_freq = vsf_q80[bw_index][0];
		s_damp = vsf_q80[bw_index][1];
		
		
		break;
	case 9:
		s_freq = vsf_q90[bw_index][0];
		s_damp = vsf_q90[bw_index][1];
		
		
		break;
	case 10:
		s_freq = vsf_q100[bw_index][0];
		s_damp = vsf_q100[bw_index][1];
		
		
		break;
	case 11:
		s_freq = vsf_q110[bw_index][0];
		s_damp = vsf_q110[bw_index][1];
		
		
		break;
	case 12:
		s_freq = vsf_q120[bw_index][0];
		s_damp = vsf_q120[bw_index][1];
		
		
		break;
	case 13:
		s_freq = vsf_q130[bw_index][0];
		s_damp = vsf_q130[bw_index][1];
		
		
		break;
	case 14:
		s_freq = vsf_q140[bw_index][0];
		s_damp = vsf_q140[bw_index][1];
		
		
		break;
	case 15:
		s_freq = vsf_q150[bw_index][0];
		s_damp = vsf_q150[bw_index][1];
		
		
		break;
	case 16:
		s_freq = vsf_q160[bw_index][0];
		s_damp = vsf_q160[bw_index][1];
		
		
		break;
	case 17:
		s_freq = vsf_q170[bw_index][0];
		s_damp = vsf_q170[bw_index][1];
		
		
		break;
	case 18:
		s_freq = vsf_q180[bw_index][0];
		s_damp = vsf_q180[bw_index][1];
		
		
		break;
	case 19:
		s_freq = vsf_q190[bw_index][0];
		s_damp = vsf_q190[bw_index][1];
		
		
		break;
	case 20:
		s_freq = vsf_q200[bw_index][0];
		s_damp = vsf_q200[bw_index][1];
		
		
		break;
	case 21:
		s_freq = vsf_q210[bw_index][0];
		s_damp = vsf_q210[bw_index][1];
		
		
		break;
	case 22:
		s_freq = vsf_q220[bw_index][0];
		s_damp = vsf_q220[bw_index][1];
		
		
		break;
	case 23:
		s_freq = vsf_q230[bw_index][0];
		s_damp = vsf_q230[bw_index][1];
		
		
		break;
	default:
	case 24:
		s_freq = vsf_q240[bw_index][0];
		s_damp = vsf_q240[bw_index][1];
		
		
		break;
    }




		    }
		    incr = calc_mod_freq(vp, incr);
		}
		newsample = (resample_t)v1;
		if (bw_index) {
                    insamp = (FLOAT_T)newsample;

		    s_notch = insamp - s_damp*s_band;
		    s_low   = s_low + s_freq*s_band;
		    s_high  = s_notch - s_low;
		    if (s_drive > 0) s_band  = s_freq*s_high + s_band - s_drive*s_band*s_band*s_band;
		    else s_band  = s_freq*s_high + s_band;

		    if (filter_type==FILTER_LOWPASS)
		        outsamp  = 0.5*s_low;
		    else if (filter_type==FILTER_HIGHPASS)
		        outsamp  = 0.5*s_high;
		    else if (filter_type==FILTER_BAND)
		        outsamp  = 0.5*s_band;
		    else if (filter_type==FILTER_NOTCH)
		        outsamp  = 0.5*s_notch;
		    else /* if (filter_type==FILTER_PEAK) */
		        outsamp  = 0.5*(s_low-s_high);

		    s_notch = insamp - s_damp*s_band;
		    s_low   = s_low + s_freq*s_band;
		    s_high  = s_notch - s_low;
		    if (s_drive > 0) s_band  = s_freq*s_high + s_band - s_drive*s_band*s_band*s_band;
		    else s_band  = s_freq*s_high + s_band;

		    if (filter_type==FILTER_LOWPASS)
		        outsamp  += 0.5*s_low;
		    else if (filter_type==FILTER_HIGHPASS)
		        outsamp  += 0.5*s_high;
		    else if (filter_type==FILTER_BAND)
		        outsamp  += 0.5*s_band;
		    else if (filter_type==FILTER_NOTCH)
		        outsamp  += 0.5*s_notch;
		    else /* if (filter_type==FILTER_PEAK) */
		        outsamp  += 0.5*(s_low-s_high);


		    newsample = (resample_t)outsamp;
		}
		ofs=ofsd;
	}
	*dest++ = newsample;
      ofs += incr;
      if (ofs >= se + (overshoot << FRACTION_BITS))
	{
	  if (!(vp->status&VOICE_FREE))
	    {
	      vp->status=VOICE_FREE;
 	      ctl->note(v);
	    }
	  *countptr-=count+1;
	  break;
	}
    }

  vp->vibrato_control_counter=cc;
  vp->sample_increment=incr;
  vp->sample_offset=ofs; /* Update offset */
  vp->current_x0=s_low;
  vp->current_x1=s_band;
  vp->bw_index=bw_index;
  vp->modulation_counter=cc_count;
  return resample_buffer+resample_buffer_offset;
}

static resample_t *rs_vib_loop(int v, Voice *vp, uint32 *countptr)
{
  /* Play sample until end-of-loop, skip back and continue. */
  int32   v0, v1, v2, v3, temp, overshoot;
  splen_t ofsd;
  int32 offset;
  FLOAT_T insamp, outsamp, s_high, s_notch, s_freq, s_damp,
    s_low=vp->current_x0, s_band=vp->current_x1,
    s_drive=(FLOAT_T)vp->drive/255000000.0;
  uint32 cc_count=vp->modulation_counter, bw_index=vp->bw_index, fmax;
  uint16 reso;
  const uint8 filter_type=vp->filter_type;
  resample_t newsample;
  int32
    incr=vp->sample_increment;
  splen_t
#if defined(LAGRANGE_INTERPOLATION) || defined(CSPLINE_INTERPOLATION)
    ls=vp->loop_start,
#endif /* LAGRANGE_INTERPOLATION */
    le=vp->loop_end,
    ll=le - vp->loop_start;
  resample_t
    *dest=resample_buffer+resample_buffer_offset;
#ifdef SL32
  samplel_t
    *src=vp->sample->ldata;
#else
  sample_t
    *src=vp->sample->data;
#endif
  splen_t
    ofs=vp->sample_offset,
    se=vp->sample->data_length,
    count = *countptr;
  uint32
    cc=vp->vibrato_control_counter;
  int
    flag_exit_loop;


  flag_exit_loop =
	(vp->status & (VOICE_FREE | VOICE_DIE)) ||
	((vp->status & VOICE_OFF) && (vp->sample->modes & MODES_FAST_RELEASE) ) ||
	((vp->status & VOICE_OFF) && dont_keep_looping ) ;

  overshoot = src[(se>>FRACTION_BITS)-1] / OVERSHOOT_STEP;
  if (overshoot < 0) overshoot = -overshoot;

    reso = vp->resonance + vp->reso_volume;
    if (reso > vp->reso_max) reso = vp->reso_max;
    fmax = (1000 + (vp->reso_max - reso) * (vp->reso_max - reso) * 2) / 100;
    if (reso && bw_index > fmax) bw_index = fmax;
    reso = (reso+5)/10;

    switch(reso) {
	case 0:
		s_freq = vsf_q0[bw_index][0];
		s_damp = vsf_q0[bw_index][1];
		
		
		break;
	case 1:
		s_freq = vsf_q10[bw_index][0];
		s_damp = vsf_q10[bw_index][1];
		
		
		break;
	case 2:
		s_freq = vsf_q20[bw_index][0];
		s_damp = vsf_q20[bw_index][1];
		
		
		break;
	case 3:
		s_freq = vsf_q30[bw_index][0];
		s_damp = vsf_q30[bw_index][1];
		
		
		break;
	case 4:
		s_freq = vsf_q40[bw_index][0];
		s_damp = vsf_q40[bw_index][1];
		
		
		break;
	case 5:
		s_freq = vsf_q50[bw_index][0];
		s_damp = vsf_q50[bw_index][1];
		
		
		break;
	case 6:
		s_freq = vsf_q60[bw_index][0];
		s_damp = vsf_q60[bw_index][1];
		
		
		break;
	case 7:
		s_freq = vsf_q70[bw_index][0];
		s_damp = vsf_q70[bw_index][1];
		
		
		break;
	case 8:
		s_freq = vsf_q80[bw_index][0];
		s_damp = vsf_q80[bw_index][1];
		
		
		break;
	case 9:
		s_freq = vsf_q90[bw_index][0];
		s_damp = vsf_q90[bw_index][1];
		
		
		break;
	case 10:
		s_freq = vsf_q100[bw_index][0];
		s_damp = vsf_q100[bw_index][1];
		
		
		break;
	case 11:
		s_freq = vsf_q110[bw_index][0];
		s_damp = vsf_q110[bw_index][1];
		
		
		break;
	case 12:
		s_freq = vsf_q120[bw_index][0];
		s_damp = vsf_q120[bw_index][1];
		
		
		break;
	case 13:
		s_freq = vsf_q130[bw_index][0];
		s_damp = vsf_q130[bw_index][1];
		
		
		break;
	case 14:
		s_freq = vsf_q140[bw_index][0];
		s_damp = vsf_q140[bw_index][1];
		
		
		break;
	case 15:
		s_freq = vsf_q150[bw_index][0];
		s_damp = vsf_q150[bw_index][1];
		
		
		break;
	case 16:
		s_freq = vsf_q160[bw_index][0];
		s_damp = vsf_q160[bw_index][1];
		
		
		break;
	case 17:
		s_freq = vsf_q170[bw_index][0];
		s_damp = vsf_q170[bw_index][1];
		
		
		break;
	case 18:
		s_freq = vsf_q180[bw_index][0];
		s_damp = vsf_q180[bw_index][1];
		
		
		break;
	case 19:
		s_freq = vsf_q190[bw_index][0];
		s_damp = vsf_q190[bw_index][1];
		
		
		break;
	case 20:
		s_freq = vsf_q200[bw_index][0];
		s_damp = vsf_q200[bw_index][1];
		
		
		break;
	case 21:
		s_freq = vsf_q210[bw_index][0];
		s_damp = vsf_q210[bw_index][1];
		
		
		break;
	case 22:
		s_freq = vsf_q220[bw_index][0];
		s_damp = vsf_q220[bw_index][1];
		
		
		break;
	case 23:
		s_freq = vsf_q230[bw_index][0];
		s_damp = vsf_q230[bw_index][1];
		
		
		break;
	default:
	case 24:
		s_freq = vsf_q240[bw_index][0];
		s_damp = vsf_q240[bw_index][1];
		
		
		break;
    }

  while (count--)
    {
      if (!cc--)
	{
	  cc=vp->vibrato_control_ratio;
	  incr=update_vibrato(vp, 0);
	}


	offset = ofs >> FRACTION_BITS;

	if (ofs >= se) {
		int32 delta = (ofs - se)>>FRACTION_BITS;
        	v1 = (int32)src[(int32)(se>>FRACTION_BITS)-1];
		if (overshoot) v1 -=  (delta+1) * v1 / overshoot;
        }
	else  v1 = (int32)src[offset];

	if (ofs + (1L<<FRACTION_BITS) >= se) {
		v2 = v1;
        }
	else  v2 = (int32)src[offset+1];

	if ( (vp->algorithm & INTERPOLATION_LINEAR) || dont_cspline ||
	   ((ofs-(1L<<FRACTION_BITS))<ls)||((ofs+(2L<<FRACTION_BITS))>le)){
		if (!cc_count--) {
		    cc_count = control_ratio - 1;
		    if (calc_bw_index(vp)) {
		        bw_index = vp->bw_index;


    reso = vp->resonance + vp->reso_volume;
    if (reso > vp->reso_max) reso = vp->reso_max;
    fmax = (1000 + (vp->reso_max - reso) * (vp->reso_max - reso) * 2) / 100;
    if (reso && bw_index > fmax) bw_index = fmax;
    reso = (reso+5)/10;

    switch(reso) {
	case 0:
		s_freq = vsf_q0[bw_index][0];
		s_damp = vsf_q0[bw_index][1];
		
		
		break;
	case 1:
		s_freq = vsf_q10[bw_index][0];
		s_damp = vsf_q10[bw_index][1];
		
		
		break;
	case 2:
		s_freq = vsf_q20[bw_index][0];
		s_damp = vsf_q20[bw_index][1];
		
		
		break;
	case 3:
		s_freq = vsf_q30[bw_index][0];
		s_damp = vsf_q30[bw_index][1];
		
		
		break;
	case 4:
		s_freq = vsf_q40[bw_index][0];
		s_damp = vsf_q40[bw_index][1];
		
		
		break;
	case 5:
		s_freq = vsf_q50[bw_index][0];
		s_damp = vsf_q50[bw_index][1];
		
		
		break;
	case 6:
		s_freq = vsf_q60[bw_index][0];
		s_damp = vsf_q60[bw_index][1];
		
		
		break;
	case 7:
		s_freq = vsf_q70[bw_index][0];
		s_damp = vsf_q70[bw_index][1];
		
		
		break;
	case 8:
		s_freq = vsf_q80[bw_index][0];
		s_damp = vsf_q80[bw_index][1];
		
		
		break;
	case 9:
		s_freq = vsf_q90[bw_index][0];
		s_damp = vsf_q90[bw_index][1];
		
		
		break;
	case 10:
		s_freq = vsf_q100[bw_index][0];
		s_damp = vsf_q100[bw_index][1];
		
		
		break;
	case 11:
		s_freq = vsf_q110[bw_index][0];
		s_damp = vsf_q110[bw_index][1];
		
		
		break;
	case 12:
		s_freq = vsf_q120[bw_index][0];
		s_damp = vsf_q120[bw_index][1];
		
		
		break;
	case 13:
		s_freq = vsf_q130[bw_index][0];
		s_damp = vsf_q130[bw_index][1];
		
		
		break;
	case 14:
		s_freq = vsf_q140[bw_index][0];
		s_damp = vsf_q140[bw_index][1];
		
		
		break;
	case 15:
		s_freq = vsf_q150[bw_index][0];
		s_damp = vsf_q150[bw_index][1];
		
		
		break;
	case 16:
		s_freq = vsf_q160[bw_index][0];
		s_damp = vsf_q160[bw_index][1];
		
		
		break;
	case 17:
		s_freq = vsf_q170[bw_index][0];
		s_damp = vsf_q170[bw_index][1];
		
		
		break;
	case 18:
		s_freq = vsf_q180[bw_index][0];
		s_damp = vsf_q180[bw_index][1];
		
		
		break;
	case 19:
		s_freq = vsf_q190[bw_index][0];
		s_damp = vsf_q190[bw_index][1];
		
		
		break;
	case 20:
		s_freq = vsf_q200[bw_index][0];
		s_damp = vsf_q200[bw_index][1];
		
		
		break;
	case 21:
		s_freq = vsf_q210[bw_index][0];
		s_damp = vsf_q210[bw_index][1];
		
		
		break;
	case 22:
		s_freq = vsf_q220[bw_index][0];
		s_damp = vsf_q220[bw_index][1];
		
		
		break;
	case 23:
		s_freq = vsf_q230[bw_index][0];
		s_damp = vsf_q230[bw_index][1];
		
		
		break;
	default:
	case 24:
		s_freq = vsf_q240[bw_index][0];
		s_damp = vsf_q240[bw_index][1];
		
		
		break;
    }


		    }
		    incr = calc_mod_freq(vp, incr);
		}
                newsample = (resample_t)(v1 + ((int32)((v2-v1) * (ofs & FRACTION_MASK)) >> FRACTION_BITS));
	        if (bw_index) {
                    insamp = (FLOAT_T)newsample;

		    s_notch = insamp - s_damp*s_band;
		    s_low   = s_low + s_freq*s_band;
		    s_high  = s_notch - s_low;
		    if (s_drive > 0) s_band  = s_freq*s_high + s_band - s_drive*s_band*s_band*s_band;
		    else s_band  = s_freq*s_high + s_band;
		    //outsamp   = 0.5*(s_notch or s_low or s_high or s_band or s_peak);
		    if (filter_type==FILTER_LOWPASS)
		        outsamp  = 0.5*s_low;
		    else if (filter_type==FILTER_HIGHPASS)
		        outsamp  = 0.5*s_high;
		    else if (filter_type==FILTER_BAND)
		        outsamp  = 0.5*s_band;
		    else if (filter_type==FILTER_NOTCH)
		        outsamp  = 0.5*s_notch;
		    else /* if (filter_type==FILTER_PEAK) */
		        outsamp  = 0.5*(s_low-s_high);
		    s_notch = insamp - s_damp*s_band;
		    s_low   = s_low + s_freq*s_band;
		    s_high  = s_notch - s_low;
		    if (s_drive > 0) s_band  = s_freq*s_high + s_band - s_drive*s_band*s_band*s_band;
		    else s_band  = s_freq*s_high + s_band;
		    //outsamp  += 0.5*(same out as above);
		    if (filter_type==FILTER_LOWPASS)
		        outsamp  += 0.5*s_low;
		    else if (filter_type==FILTER_HIGHPASS)
		        outsamp  += 0.5*s_high;
		    else if (filter_type==FILTER_BAND)
		        outsamp  += 0.5*s_band;
		    else if (filter_type==FILTER_NOTCH)
		        outsamp  += 0.5*s_notch;
		    else /* if (filter_type==FILTER_PEAK) */
		        outsamp  += 0.5*(s_low-s_high);

		    newsample = (resample_t)outsamp;
	        }
	}
	else {
		ofsd=ofs;
                v0 = (int32)src[offset-1];
                v3 = (int32)src[offset+2];
                ofs &= FRACTION_MASK;
                temp=v2;
		v2 = (6*v2 +
		      (((( ( (5*v3 - 11*v2 + 7*v1 - v0)*
		       (int32)ofs) >>FRACTION_BITS)*(int32)ofs)>>(FRACTION_BITS+2))-1))*(int32)ofs;
                ofs = (1L << FRACTION_BITS) - ofs;
		v1 = (6*v1 +
		      ((((((5*v0 - 11*v1 + 7*temp - v3)*
		       (int32)ofs)>>FRACTION_BITS)*(int32)ofs)>>(FRACTION_BITS+2))-1))*(int32)ofs;
		v1 = (v1 + v2)/(6L<<FRACTION_BITS);
		if (!cc_count--) {
		    cc_count = control_ratio - 1;
		    if (calc_bw_index(vp)) {
			bw_index = vp->bw_index;


    reso = vp->resonance + vp->reso_volume;
    if (reso > vp->reso_max) reso = vp->reso_max;
    fmax = (1000 + (vp->reso_max - reso) * (vp->reso_max - reso) * 2) / 100;
    if (reso && bw_index > fmax) bw_index = fmax;
    reso = (reso+5)/10;

    switch(reso) {
	case 0:
		s_freq = vsf_q0[bw_index][0];
		s_damp = vsf_q0[bw_index][1];
		
		
		break;
	case 1:
		s_freq = vsf_q10[bw_index][0];
		s_damp = vsf_q10[bw_index][1];
		
		
		break;
	case 2:
		s_freq = vsf_q20[bw_index][0];
		s_damp = vsf_q20[bw_index][1];
		
		
		break;
	case 3:
		s_freq = vsf_q30[bw_index][0];
		s_damp = vsf_q30[bw_index][1];
		
		
		break;
	case 4:
		s_freq = vsf_q40[bw_index][0];
		s_damp = vsf_q40[bw_index][1];
		
		
		break;
	case 5:
		s_freq = vsf_q50[bw_index][0];
		s_damp = vsf_q50[bw_index][1];
		
		
		break;
	case 6:
		s_freq = vsf_q60[bw_index][0];
		s_damp = vsf_q60[bw_index][1];
		
		
		break;
	case 7:
		s_freq = vsf_q70[bw_index][0];
		s_damp = vsf_q70[bw_index][1];
		
		
		break;
	case 8:
		s_freq = vsf_q80[bw_index][0];
		s_damp = vsf_q80[bw_index][1];
		
		
		break;
	case 9:
		s_freq = vsf_q90[bw_index][0];
		s_damp = vsf_q90[bw_index][1];
		
		
		break;
	case 10:
		s_freq = vsf_q100[bw_index][0];
		s_damp = vsf_q100[bw_index][1];
		
		
		break;
	case 11:
		s_freq = vsf_q110[bw_index][0];
		s_damp = vsf_q110[bw_index][1];
		
		
		break;
	case 12:
		s_freq = vsf_q120[bw_index][0];
		s_damp = vsf_q120[bw_index][1];
		
		
		break;
	case 13:
		s_freq = vsf_q130[bw_index][0];
		s_damp = vsf_q130[bw_index][1];
		
		
		break;
	case 14:
		s_freq = vsf_q140[bw_index][0];
		s_damp = vsf_q140[bw_index][1];
		
		
		break;
	case 15:
		s_freq = vsf_q150[bw_index][0];
		s_damp = vsf_q150[bw_index][1];
		
		
		break;
	case 16:
		s_freq = vsf_q160[bw_index][0];
		s_damp = vsf_q160[bw_index][1];
		
		
		break;
	case 17:
		s_freq = vsf_q170[bw_index][0];
		s_damp = vsf_q170[bw_index][1];
		
		
		break;
	case 18:
		s_freq = vsf_q180[bw_index][0];
		s_damp = vsf_q180[bw_index][1];
		
		
		break;
	case 19:
		s_freq = vsf_q190[bw_index][0];
		s_damp = vsf_q190[bw_index][1];
		
		
		break;
	case 20:
		s_freq = vsf_q200[bw_index][0];
		s_damp = vsf_q200[bw_index][1];
		
		
		break;
	case 21:
		s_freq = vsf_q210[bw_index][0];
		s_damp = vsf_q210[bw_index][1];
		
		
		break;
	case 22:
		s_freq = vsf_q220[bw_index][0];
		s_damp = vsf_q220[bw_index][1];
		
		
		break;
	case 23:
		s_freq = vsf_q230[bw_index][0];
		s_damp = vsf_q230[bw_index][1];
		
		
		break;
	default:
	case 24:
		s_freq = vsf_q240[bw_index][0];
		s_damp = vsf_q240[bw_index][1];
		
		
		break;
    }




		    }
		    incr = calc_mod_freq(vp, incr);
		}
		newsample = (resample_t)v1;
		if (bw_index) {
                    insamp = (FLOAT_T)newsample;

		    s_notch = insamp - s_damp*s_band;
		    s_low   = s_low + s_freq*s_band;
		    s_high  = s_notch - s_low;
		    if (s_drive > 0) s_band  = s_freq*s_high + s_band - s_drive*s_band*s_band*s_band;
		    else s_band  = s_freq*s_high + s_band;

		    if (filter_type==FILTER_LOWPASS)
		        outsamp  = 0.5*s_low;
		    else if (filter_type==FILTER_HIGHPASS)
		        outsamp  = 0.5*s_high;
		    else if (filter_type==FILTER_BAND)
		        outsamp  = 0.5*s_band;
		    else if (filter_type==FILTER_NOTCH)
		        outsamp  = 0.5*s_notch;
		    else /* if (filter_type==FILTER_PEAK) */
		        outsamp  = 0.5*(s_low-s_high);

		    s_notch = insamp - s_damp*s_band;
		    s_low   = s_low + s_freq*s_band;
		    s_high  = s_notch - s_low;
		    if (s_drive > 0) s_band  = s_freq*s_high + s_band - s_drive*s_band*s_band*s_band;
		    else s_band  = s_freq*s_high + s_band;

		    if (filter_type==FILTER_LOWPASS)
		        outsamp  += 0.5*s_low;
		    else if (filter_type==FILTER_HIGHPASS)
		        outsamp  += 0.5*s_high;
		    else if (filter_type==FILTER_BAND)
		        outsamp  += 0.5*s_band;
		    else if (filter_type==FILTER_NOTCH)
		        outsamp  += 0.5*s_notch;
		    else /* if (filter_type==FILTER_PEAK) */
		        outsamp  += 0.5*(s_low-s_high);


		    newsample = (resample_t)outsamp;
		}
		ofs=ofsd;
	}
	*dest++ = newsample;
      ofs += incr;
      if (ofs>=le)
	{
	  if (flag_exit_loop)
	    {
	    	vp->reverb_time -= ll >> FRACTION_BITS;
	  	if (vp->reverb_time >= 0) ofs -= ll;
	    }
	  else ofs -= ll; /* Hopefully the loop is longer than an increment. */
	}
      if (ofs >= se + (overshoot << FRACTION_BITS))
	{
	  if (!(vp->status&VOICE_FREE))
	    {
	      vp->status=VOICE_FREE;
 	      ctl->note(v);
	    }
	  *countptr-=count+1;
	  break;
	}
    }

  vp->vibrato_control_counter=cc;
  vp->sample_increment=incr;
  vp->sample_offset=ofs; /* Update offset */
  vp->current_x0=s_low;
  vp->current_x1=s_band;
  vp->bw_index=bw_index;
  vp->modulation_counter=cc_count;
  return resample_buffer+resample_buffer_offset;
}

static resample_t *rs_vib_bidir(Voice *vp, uint32 count)
{
  int32   v0, v1, v2, v3, temp, overshoot;
  splen_t ofsd;
  int32 offset;
  FLOAT_T insamp, outsamp, s_high, s_notch, s_freq, s_damp,
    s_low=vp->current_x0, s_band=vp->current_x1,
    s_drive=(FLOAT_T)vp->drive/255000000.0;
  uint32 cc_count=vp->modulation_counter, bw_index=vp->bw_index, fmax;
  uint16 reso;
  const uint8 filter_type=vp->filter_type;
  resample_t newsample;
  int32
    incr=vp->sample_increment;
  splen_t
    le=vp->loop_end,
    ls=vp->loop_start,
    ofs=vp->sample_offset,
    se=vp->sample->data_length;
  resample_t
    *dest=resample_buffer+resample_buffer_offset;
#ifdef SL32
  samplel_t
    *src=vp->sample->ldata;
#else
  sample_t
    *src=vp->sample->data;
#endif
  uint32
    cc=vp->vibrato_control_counter;


#ifdef USE_BIDIR_OVERSHOOT
  splen_t
    le2=le<<1,
    ls2=ls<<1;
#endif
  uint32
    i, j;
  int
    vibflag = 0;


  overshoot = src[(se>>FRACTION_BITS)-1] / OVERSHOOT_STEP;
  if (overshoot < 0) overshoot = -overshoot;

    reso = vp->resonance + vp->reso_volume;
    if (reso > vp->reso_max) reso = vp->reso_max;
    fmax = (1000 + (vp->reso_max - reso) * (vp->reso_max - reso) * 2) / 100;
    if (reso && bw_index > fmax) bw_index = fmax;
    reso = (reso+5)/10;

    switch(reso) {
	case 0:
		s_freq = vsf_q0[bw_index][0];
		s_damp = vsf_q0[bw_index][1];
		
		
		break;
	case 1:
		s_freq = vsf_q10[bw_index][0];
		s_damp = vsf_q10[bw_index][1];
		
		
		break;
	case 2:
		s_freq = vsf_q20[bw_index][0];
		s_damp = vsf_q20[bw_index][1];
		
		
		break;
	case 3:
		s_freq = vsf_q30[bw_index][0];
		s_damp = vsf_q30[bw_index][1];
		
		
		break;
	case 4:
		s_freq = vsf_q40[bw_index][0];
		s_damp = vsf_q40[bw_index][1];
		
		
		break;
	case 5:
		s_freq = vsf_q50[bw_index][0];
		s_damp = vsf_q50[bw_index][1];
		
		
		break;
	case 6:
		s_freq = vsf_q60[bw_index][0];
		s_damp = vsf_q60[bw_index][1];
		
		
		break;
	case 7:
		s_freq = vsf_q70[bw_index][0];
		s_damp = vsf_q70[bw_index][1];
		
		
		break;
	case 8:
		s_freq = vsf_q80[bw_index][0];
		s_damp = vsf_q80[bw_index][1];
		
		
		break;
	case 9:
		s_freq = vsf_q90[bw_index][0];
		s_damp = vsf_q90[bw_index][1];
		
		
		break;
	case 10:
		s_freq = vsf_q100[bw_index][0];
		s_damp = vsf_q100[bw_index][1];
		
		
		break;
	case 11:
		s_freq = vsf_q110[bw_index][0];
		s_damp = vsf_q110[bw_index][1];
		
		
		break;
	case 12:
		s_freq = vsf_q120[bw_index][0];
		s_damp = vsf_q120[bw_index][1];
		
		
		break;
	case 13:
		s_freq = vsf_q130[bw_index][0];
		s_damp = vsf_q130[bw_index][1];
		
		
		break;
	case 14:
		s_freq = vsf_q140[bw_index][0];
		s_damp = vsf_q140[bw_index][1];
		
		
		break;
	case 15:
		s_freq = vsf_q150[bw_index][0];
		s_damp = vsf_q150[bw_index][1];
		
		
		break;
	case 16:
		s_freq = vsf_q160[bw_index][0];
		s_damp = vsf_q160[bw_index][1];
		
		
		break;
	case 17:
		s_freq = vsf_q170[bw_index][0];
		s_damp = vsf_q170[bw_index][1];
		
		
		break;
	case 18:
		s_freq = vsf_q180[bw_index][0];
		s_damp = vsf_q180[bw_index][1];
		
		
		break;
	case 19:
		s_freq = vsf_q190[bw_index][0];
		s_damp = vsf_q190[bw_index][1];
		
		
		break;
	case 20:
		s_freq = vsf_q200[bw_index][0];
		s_damp = vsf_q200[bw_index][1];
		
		
		break;
	case 21:
		s_freq = vsf_q210[bw_index][0];
		s_damp = vsf_q210[bw_index][1];
		
		
		break;
	case 22:
		s_freq = vsf_q220[bw_index][0];
		s_damp = vsf_q220[bw_index][1];
		
		
		break;
	case 23:
		s_freq = vsf_q230[bw_index][0];
		s_damp = vsf_q230[bw_index][1];
		
		
		break;
	default:
	case 24:
		s_freq = vsf_q240[bw_index][0];
		s_damp = vsf_q240[bw_index][1];
		
		
		break;
    }

  /* Play normally until inside the loop region */
  while (count && (ofs <= ls))
    {
      i = (ls - ofs) / incr + 1;
      if (i > count) i = count;
      if (i > cc)
	{
	  i = cc;
	  vibflag = 1;
	}
      else cc -= i;
      count -= i;
      for(j = 0; j < i; j++)
	{


	offset = ofs >> FRACTION_BITS;

	if (ofs >= se) {
		int32 delta = (ofs - se)>>FRACTION_BITS;
        	v1 = (int32)src[(int32)(se>>FRACTION_BITS)-1];
		if (overshoot) v1 -=  (delta+1) * v1 / overshoot;
        }
	else  v1 = (int32)src[offset];

	if (ofs + (1L<<FRACTION_BITS) >= se) {
		v2 = v1;
        }
	else  v2 = (int32)src[offset+1];

	if ( (vp->algorithm & INTERPOLATION_LINEAR) || dont_cspline ||
	   ((ofs-(1L<<FRACTION_BITS))<ls)||((ofs+(2L<<FRACTION_BITS))>le)){
		if (!cc_count--) {
		    cc_count = control_ratio - 1;
		    if (calc_bw_index(vp)) {
		        bw_index = vp->bw_index;


    reso = vp->resonance + vp->reso_volume;
    if (reso > vp->reso_max) reso = vp->reso_max;
    fmax = (1000 + (vp->reso_max - reso) * (vp->reso_max - reso) * 2) / 100;
    if (reso && bw_index > fmax) bw_index = fmax;
    reso = (reso+5)/10;

    switch(reso) {
	case 0:
		s_freq = vsf_q0[bw_index][0];
		s_damp = vsf_q0[bw_index][1];
		
		
		break;
	case 1:
		s_freq = vsf_q10[bw_index][0];
		s_damp = vsf_q10[bw_index][1];
		
		
		break;
	case 2:
		s_freq = vsf_q20[bw_index][0];
		s_damp = vsf_q20[bw_index][1];
		
		
		break;
	case 3:
		s_freq = vsf_q30[bw_index][0];
		s_damp = vsf_q30[bw_index][1];
		
		
		break;
	case 4:
		s_freq = vsf_q40[bw_index][0];
		s_damp = vsf_q40[bw_index][1];
		
		
		break;
	case 5:
		s_freq = vsf_q50[bw_index][0];
		s_damp = vsf_q50[bw_index][1];
		
		
		break;
	case 6:
		s_freq = vsf_q60[bw_index][0];
		s_damp = vsf_q60[bw_index][1];
		
		
		break;
	case 7:
		s_freq = vsf_q70[bw_index][0];
		s_damp = vsf_q70[bw_index][1];
		
		
		break;
	case 8:
		s_freq = vsf_q80[bw_index][0];
		s_damp = vsf_q80[bw_index][1];
		
		
		break;
	case 9:
		s_freq = vsf_q90[bw_index][0];
		s_damp = vsf_q90[bw_index][1];
		
		
		break;
	case 10:
		s_freq = vsf_q100[bw_index][0];
		s_damp = vsf_q100[bw_index][1];
		
		
		break;
	case 11:
		s_freq = vsf_q110[bw_index][0];
		s_damp = vsf_q110[bw_index][1];
		
		
		break;
	case 12:
		s_freq = vsf_q120[bw_index][0];
		s_damp = vsf_q120[bw_index][1];
		
		
		break;
	case 13:
		s_freq = vsf_q130[bw_index][0];
		s_damp = vsf_q130[bw_index][1];
		
		
		break;
	case 14:
		s_freq = vsf_q140[bw_index][0];
		s_damp = vsf_q140[bw_index][1];
		
		
		break;
	case 15:
		s_freq = vsf_q150[bw_index][0];
		s_damp = vsf_q150[bw_index][1];
		
		
		break;
	case 16:
		s_freq = vsf_q160[bw_index][0];
		s_damp = vsf_q160[bw_index][1];
		
		
		break;
	case 17:
		s_freq = vsf_q170[bw_index][0];
		s_damp = vsf_q170[bw_index][1];
		
		
		break;
	case 18:
		s_freq = vsf_q180[bw_index][0];
		s_damp = vsf_q180[bw_index][1];
		
		
		break;
	case 19:
		s_freq = vsf_q190[bw_index][0];
		s_damp = vsf_q190[bw_index][1];
		
		
		break;
	case 20:
		s_freq = vsf_q200[bw_index][0];
		s_damp = vsf_q200[bw_index][1];
		
		
		break;
	case 21:
		s_freq = vsf_q210[bw_index][0];
		s_damp = vsf_q210[bw_index][1];
		
		
		break;
	case 22:
		s_freq = vsf_q220[bw_index][0];
		s_damp = vsf_q220[bw_index][1];
		
		
		break;
	case 23:
		s_freq = vsf_q230[bw_index][0];
		s_damp = vsf_q230[bw_index][1];
		
		
		break;
	default:
	case 24:
		s_freq = vsf_q240[bw_index][0];
		s_damp = vsf_q240[bw_index][1];
		
		
		break;
    }


		    }
		    incr = calc_mod_freq(vp, incr);
		}
                newsample = (resample_t)(v1 + ((int32)((v2-v1) * (ofs & FRACTION_MASK)) >> FRACTION_BITS));
	        if (bw_index) {
                    insamp = (FLOAT_T)newsample;

		    s_notch = insamp - s_damp*s_band;
		    s_low   = s_low + s_freq*s_band;
		    s_high  = s_notch - s_low;
		    if (s_drive > 0) s_band  = s_freq*s_high + s_band - s_drive*s_band*s_band*s_band;
		    else s_band  = s_freq*s_high + s_band;
		    //outsamp   = 0.5*(s_notch or s_low or s_high or s_band or s_peak);
		    if (filter_type==FILTER_LOWPASS)
		        outsamp  = 0.5*s_low;
		    else if (filter_type==FILTER_HIGHPASS)
		        outsamp  = 0.5*s_high;
		    else if (filter_type==FILTER_BAND)
		        outsamp  = 0.5*s_band;
		    else if (filter_type==FILTER_NOTCH)
		        outsamp  = 0.5*s_notch;
		    else /* if (filter_type==FILTER_PEAK) */
		        outsamp  = 0.5*(s_low-s_high);
		    s_notch = insamp - s_damp*s_band;
		    s_low   = s_low + s_freq*s_band;
		    s_high  = s_notch - s_low;
		    if (s_drive > 0) s_band  = s_freq*s_high + s_band - s_drive*s_band*s_band*s_band;
		    else s_band  = s_freq*s_high + s_band;
		    //outsamp  += 0.5*(same out as above);
		    if (filter_type==FILTER_LOWPASS)
		        outsamp  += 0.5*s_low;
		    else if (filter_type==FILTER_HIGHPASS)
		        outsamp  += 0.5*s_high;
		    else if (filter_type==FILTER_BAND)
		        outsamp  += 0.5*s_band;
		    else if (filter_type==FILTER_NOTCH)
		        outsamp  += 0.5*s_notch;
		    else /* if (filter_type==FILTER_PEAK) */
		        outsamp  += 0.5*(s_low-s_high);

		    newsample = (resample_t)outsamp;
	        }
	}
	else {
		ofsd=ofs;
                v0 = (int32)src[offset-1];
                v3 = (int32)src[offset+2];
                ofs &= FRACTION_MASK;
                temp=v2;
		v2 = (6*v2 +
		      (((( ( (5*v3 - 11*v2 + 7*v1 - v0)*
		       (int32)ofs) >>FRACTION_BITS)*(int32)ofs)>>(FRACTION_BITS+2))-1))*(int32)ofs;
                ofs = (1L << FRACTION_BITS) - ofs;
		v1 = (6*v1 +
		      ((((((5*v0 - 11*v1 + 7*temp - v3)*
		       (int32)ofs)>>FRACTION_BITS)*(int32)ofs)>>(FRACTION_BITS+2))-1))*(int32)ofs;
		v1 = (v1 + v2)/(6L<<FRACTION_BITS);
		if (!cc_count--) {
		    cc_count = control_ratio - 1;
		    if (calc_bw_index(vp)) {
			bw_index = vp->bw_index;


    reso = vp->resonance + vp->reso_volume;
    if (reso > vp->reso_max) reso = vp->reso_max;
    fmax = (1000 + (vp->reso_max - reso) * (vp->reso_max - reso) * 2) / 100;
    if (reso && bw_index > fmax) bw_index = fmax;
    reso = (reso+5)/10;

    switch(reso) {
	case 0:
		s_freq = vsf_q0[bw_index][0];
		s_damp = vsf_q0[bw_index][1];
		
		
		break;
	case 1:
		s_freq = vsf_q10[bw_index][0];
		s_damp = vsf_q10[bw_index][1];
		
		
		break;
	case 2:
		s_freq = vsf_q20[bw_index][0];
		s_damp = vsf_q20[bw_index][1];
		
		
		break;
	case 3:
		s_freq = vsf_q30[bw_index][0];
		s_damp = vsf_q30[bw_index][1];
		
		
		break;
	case 4:
		s_freq = vsf_q40[bw_index][0];
		s_damp = vsf_q40[bw_index][1];
		
		
		break;
	case 5:
		s_freq = vsf_q50[bw_index][0];
		s_damp = vsf_q50[bw_index][1];
		
		
		break;
	case 6:
		s_freq = vsf_q60[bw_index][0];
		s_damp = vsf_q60[bw_index][1];
		
		
		break;
	case 7:
		s_freq = vsf_q70[bw_index][0];
		s_damp = vsf_q70[bw_index][1];
		
		
		break;
	case 8:
		s_freq = vsf_q80[bw_index][0];
		s_damp = vsf_q80[bw_index][1];
		
		
		break;
	case 9:
		s_freq = vsf_q90[bw_index][0];
		s_damp = vsf_q90[bw_index][1];
		
		
		break;
	case 10:
		s_freq = vsf_q100[bw_index][0];
		s_damp = vsf_q100[bw_index][1];
		
		
		break;
	case 11:
		s_freq = vsf_q110[bw_index][0];
		s_damp = vsf_q110[bw_index][1];
		
		
		break;
	case 12:
		s_freq = vsf_q120[bw_index][0];
		s_damp = vsf_q120[bw_index][1];
		
		
		break;
	case 13:
		s_freq = vsf_q130[bw_index][0];
		s_damp = vsf_q130[bw_index][1];
		
		
		break;
	case 14:
		s_freq = vsf_q140[bw_index][0];
		s_damp = vsf_q140[bw_index][1];
		
		
		break;
	case 15:
		s_freq = vsf_q150[bw_index][0];
		s_damp = vsf_q150[bw_index][1];
		
		
		break;
	case 16:
		s_freq = vsf_q160[bw_index][0];
		s_damp = vsf_q160[bw_index][1];
		
		
		break;
	case 17:
		s_freq = vsf_q170[bw_index][0];
		s_damp = vsf_q170[bw_index][1];
		
		
		break;
	case 18:
		s_freq = vsf_q180[bw_index][0];
		s_damp = vsf_q180[bw_index][1];
		
		
		break;
	case 19:
		s_freq = vsf_q190[bw_index][0];
		s_damp = vsf_q190[bw_index][1];
		
		
		break;
	case 20:
		s_freq = vsf_q200[bw_index][0];
		s_damp = vsf_q200[bw_index][1];
		
		
		break;
	case 21:
		s_freq = vsf_q210[bw_index][0];
		s_damp = vsf_q210[bw_index][1];
		
		
		break;
	case 22:
		s_freq = vsf_q220[bw_index][0];
		s_damp = vsf_q220[bw_index][1];
		
		
		break;
	case 23:
		s_freq = vsf_q230[bw_index][0];
		s_damp = vsf_q230[bw_index][1];
		
		
		break;
	default:
	case 24:
		s_freq = vsf_q240[bw_index][0];
		s_damp = vsf_q240[bw_index][1];
		
		
		break;
    }




		    }
		    incr = calc_mod_freq(vp, incr);
		}
		newsample = (resample_t)v1;
		if (bw_index) {
                    insamp = (FLOAT_T)newsample;

		    s_notch = insamp - s_damp*s_band;
		    s_low   = s_low + s_freq*s_band;
		    s_high  = s_notch - s_low;
		    if (s_drive > 0) s_band  = s_freq*s_high + s_band - s_drive*s_band*s_band*s_band;
		    else s_band  = s_freq*s_high + s_band;

		    if (filter_type==FILTER_LOWPASS)
		        outsamp  = 0.5*s_low;
		    else if (filter_type==FILTER_HIGHPASS)
		        outsamp  = 0.5*s_high;
		    else if (filter_type==FILTER_BAND)
		        outsamp  = 0.5*s_band;
		    else if (filter_type==FILTER_NOTCH)
		        outsamp  = 0.5*s_notch;
		    else /* if (filter_type==FILTER_PEAK) */
		        outsamp  = 0.5*(s_low-s_high);

		    s_notch = insamp - s_damp*s_band;
		    s_low   = s_low + s_freq*s_band;
		    s_high  = s_notch - s_low;
		    if (s_drive > 0) s_band  = s_freq*s_high + s_band - s_drive*s_band*s_band*s_band;
		    else s_band  = s_freq*s_high + s_band;

		    if (filter_type==FILTER_LOWPASS)
		        outsamp  += 0.5*s_low;
		    else if (filter_type==FILTER_HIGHPASS)
		        outsamp  += 0.5*s_high;
		    else if (filter_type==FILTER_BAND)
		        outsamp  += 0.5*s_band;
		    else if (filter_type==FILTER_NOTCH)
		        outsamp  += 0.5*s_notch;
		    else /* if (filter_type==FILTER_PEAK) */
		        outsamp  += 0.5*(s_low-s_high);


		    newsample = (resample_t)outsamp;
		}
		ofs=ofsd;
	}
	*dest++ = newsample;
	  ofs += incr;
	}
      if (vibflag)
	{
	  cc = vp->vibrato_control_ratio;
	  incr = update_vibrato(vp, 0);
	  vibflag = 0;
	}
    }

  /* Then do the bidirectional looping */

  while (count)
    {
      /* Precalc how many times we should go through the loop */
#if 1
      i = ((incr > 0 ? le : ls) - ofs) / incr + 1;
#else
/* fix from M. Izumo */
      i = ((incr > 0 ? le : ls) - ofs + incr - 1) / incr;
#endif
      if(i > count) i = count;
      if(i > cc)
	{
	  i = cc;
	  vibflag = 1;
	}
      else cc -= i;
      count -= i;
      while (i-- && ofs < se)
	{


	offset = ofs >> FRACTION_BITS;

	if (ofs >= se) {
		int32 delta = (ofs - se)>>FRACTION_BITS;
        	v1 = (int32)src[(int32)(se>>FRACTION_BITS)-1];
		if (overshoot) v1 -=  (delta+1) * v1 / overshoot;
        }
	else  v1 = (int32)src[offset];

	if (ofs + (1L<<FRACTION_BITS) >= se) {
		v2 = v1;
        }
	else  v2 = (int32)src[offset+1];

	if ( (vp->algorithm & INTERPOLATION_LINEAR) || dont_cspline ||
	   ((ofs-(1L<<FRACTION_BITS))<ls)||((ofs+(2L<<FRACTION_BITS))>le)){
		if (!cc_count--) {
		    cc_count = control_ratio - 1;
		    if (calc_bw_index(vp)) {
		        bw_index = vp->bw_index;


    reso = vp->resonance + vp->reso_volume;
    if (reso > vp->reso_max) reso = vp->reso_max;
    fmax = (1000 + (vp->reso_max - reso) * (vp->reso_max - reso) * 2) / 100;
    if (reso && bw_index > fmax) bw_index = fmax;
    reso = (reso+5)/10;

    switch(reso) {
	case 0:
		s_freq = vsf_q0[bw_index][0];
		s_damp = vsf_q0[bw_index][1];
		
		
		break;
	case 1:
		s_freq = vsf_q10[bw_index][0];
		s_damp = vsf_q10[bw_index][1];
		
		
		break;
	case 2:
		s_freq = vsf_q20[bw_index][0];
		s_damp = vsf_q20[bw_index][1];
		
		
		break;
	case 3:
		s_freq = vsf_q30[bw_index][0];
		s_damp = vsf_q30[bw_index][1];
		
		
		break;
	case 4:
		s_freq = vsf_q40[bw_index][0];
		s_damp = vsf_q40[bw_index][1];
		
		
		break;
	case 5:
		s_freq = vsf_q50[bw_index][0];
		s_damp = vsf_q50[bw_index][1];
		
		
		break;
	case 6:
		s_freq = vsf_q60[bw_index][0];
		s_damp = vsf_q60[bw_index][1];
		
		
		break;
	case 7:
		s_freq = vsf_q70[bw_index][0];
		s_damp = vsf_q70[bw_index][1];
		
		
		break;
	case 8:
		s_freq = vsf_q80[bw_index][0];
		s_damp = vsf_q80[bw_index][1];
		
		
		break;
	case 9:
		s_freq = vsf_q90[bw_index][0];
		s_damp = vsf_q90[bw_index][1];
		
		
		break;
	case 10:
		s_freq = vsf_q100[bw_index][0];
		s_damp = vsf_q100[bw_index][1];
		
		
		break;
	case 11:
		s_freq = vsf_q110[bw_index][0];
		s_damp = vsf_q110[bw_index][1];
		
		
		break;
	case 12:
		s_freq = vsf_q120[bw_index][0];
		s_damp = vsf_q120[bw_index][1];
		
		
		break;
	case 13:
		s_freq = vsf_q130[bw_index][0];
		s_damp = vsf_q130[bw_index][1];
		
		
		break;
	case 14:
		s_freq = vsf_q140[bw_index][0];
		s_damp = vsf_q140[bw_index][1];
		
		
		break;
	case 15:
		s_freq = vsf_q150[bw_index][0];
		s_damp = vsf_q150[bw_index][1];
		
		
		break;
	case 16:
		s_freq = vsf_q160[bw_index][0];
		s_damp = vsf_q160[bw_index][1];
		
		
		break;
	case 17:
		s_freq = vsf_q170[bw_index][0];
		s_damp = vsf_q170[bw_index][1];
		
		
		break;
	case 18:
		s_freq = vsf_q180[bw_index][0];
		s_damp = vsf_q180[bw_index][1];
		
		
		break;
	case 19:
		s_freq = vsf_q190[bw_index][0];
		s_damp = vsf_q190[bw_index][1];
		
		
		break;
	case 20:
		s_freq = vsf_q200[bw_index][0];
		s_damp = vsf_q200[bw_index][1];
		
		
		break;
	case 21:
		s_freq = vsf_q210[bw_index][0];
		s_damp = vsf_q210[bw_index][1];
		
		
		break;
	case 22:
		s_freq = vsf_q220[bw_index][0];
		s_damp = vsf_q220[bw_index][1];
		
		
		break;
	case 23:
		s_freq = vsf_q230[bw_index][0];
		s_damp = vsf_q230[bw_index][1];
		
		
		break;
	default:
	case 24:
		s_freq = vsf_q240[bw_index][0];
		s_damp = vsf_q240[bw_index][1];
		
		
		break;
    }


		    }
		    incr = calc_mod_freq(vp, incr);
		}
                newsample = (resample_t)(v1 + ((int32)((v2-v1) * (ofs & FRACTION_MASK)) >> FRACTION_BITS));
	        if (bw_index) {
                    insamp = (FLOAT_T)newsample;

		    s_notch = insamp - s_damp*s_band;
		    s_low   = s_low + s_freq*s_band;
		    s_high  = s_notch - s_low;
		    if (s_drive > 0) s_band  = s_freq*s_high + s_band - s_drive*s_band*s_band*s_band;
		    else s_band  = s_freq*s_high + s_band;
		    //outsamp   = 0.5*(s_notch or s_low or s_high or s_band or s_peak);
		    if (filter_type==FILTER_LOWPASS)
		        outsamp  = 0.5*s_low;
		    else if (filter_type==FILTER_HIGHPASS)
		        outsamp  = 0.5*s_high;
		    else if (filter_type==FILTER_BAND)
		        outsamp  = 0.5*s_band;
		    else if (filter_type==FILTER_NOTCH)
		        outsamp  = 0.5*s_notch;
		    else /* if (filter_type==FILTER_PEAK) */
		        outsamp  = 0.5*(s_low-s_high);
		    s_notch = insamp - s_damp*s_band;
		    s_low   = s_low + s_freq*s_band;
		    s_high  = s_notch - s_low;
		    if (s_drive > 0) s_band  = s_freq*s_high + s_band - s_drive*s_band*s_band*s_band;
		    else s_band  = s_freq*s_high + s_band;
		    //outsamp  += 0.5*(same out as above);
		    if (filter_type==FILTER_LOWPASS)
		        outsamp  += 0.5*s_low;
		    else if (filter_type==FILTER_HIGHPASS)
		        outsamp  += 0.5*s_high;
		    else if (filter_type==FILTER_BAND)
		        outsamp  += 0.5*s_band;
		    else if (filter_type==FILTER_NOTCH)
		        outsamp  += 0.5*s_notch;
		    else /* if (filter_type==FILTER_PEAK) */
		        outsamp  += 0.5*(s_low-s_high);

		    newsample = (resample_t)outsamp;
	        }
	}
	else {
		ofsd=ofs;
                v0 = (int32)src[offset-1];
                v3 = (int32)src[offset+2];
                ofs &= FRACTION_MASK;
                temp=v2;
		v2 = (6*v2 +
		      (((( ( (5*v3 - 11*v2 + 7*v1 - v0)*
		       (int32)ofs) >>FRACTION_BITS)*(int32)ofs)>>(FRACTION_BITS+2))-1))*(int32)ofs;
                ofs = (1L << FRACTION_BITS) - ofs;
		v1 = (6*v1 +
		      ((((((5*v0 - 11*v1 + 7*temp - v3)*
		       (int32)ofs)>>FRACTION_BITS)*(int32)ofs)>>(FRACTION_BITS+2))-1))*(int32)ofs;
		v1 = (v1 + v2)/(6L<<FRACTION_BITS);
		if (!cc_count--) {
		    cc_count = control_ratio - 1;
		    if (calc_bw_index(vp)) {
			bw_index = vp->bw_index;


    reso = vp->resonance + vp->reso_volume;
    if (reso > vp->reso_max) reso = vp->reso_max;
    fmax = (1000 + (vp->reso_max - reso) * (vp->reso_max - reso) * 2) / 100;
    if (reso && bw_index > fmax) bw_index = fmax;
    reso = (reso+5)/10;

    switch(reso) {
	case 0:
		s_freq = vsf_q0[bw_index][0];
		s_damp = vsf_q0[bw_index][1];
		
		
		break;
	case 1:
		s_freq = vsf_q10[bw_index][0];
		s_damp = vsf_q10[bw_index][1];
		
		
		break;
	case 2:
		s_freq = vsf_q20[bw_index][0];
		s_damp = vsf_q20[bw_index][1];
		
		
		break;
	case 3:
		s_freq = vsf_q30[bw_index][0];
		s_damp = vsf_q30[bw_index][1];
		
		
		break;
	case 4:
		s_freq = vsf_q40[bw_index][0];
		s_damp = vsf_q40[bw_index][1];
		
		
		break;
	case 5:
		s_freq = vsf_q50[bw_index][0];
		s_damp = vsf_q50[bw_index][1];
		
		
		break;
	case 6:
		s_freq = vsf_q60[bw_index][0];
		s_damp = vsf_q60[bw_index][1];
		
		
		break;
	case 7:
		s_freq = vsf_q70[bw_index][0];
		s_damp = vsf_q70[bw_index][1];
		
		
		break;
	case 8:
		s_freq = vsf_q80[bw_index][0];
		s_damp = vsf_q80[bw_index][1];
		
		
		break;
	case 9:
		s_freq = vsf_q90[bw_index][0];
		s_damp = vsf_q90[bw_index][1];
		
		
		break;
	case 10:
		s_freq = vsf_q100[bw_index][0];
		s_damp = vsf_q100[bw_index][1];
		
		
		break;
	case 11:
		s_freq = vsf_q110[bw_index][0];
		s_damp = vsf_q110[bw_index][1];
		
		
		break;
	case 12:
		s_freq = vsf_q120[bw_index][0];
		s_damp = vsf_q120[bw_index][1];
		
		
		break;
	case 13:
		s_freq = vsf_q130[bw_index][0];
		s_damp = vsf_q130[bw_index][1];
		
		
		break;
	case 14:
		s_freq = vsf_q140[bw_index][0];
		s_damp = vsf_q140[bw_index][1];
		
		
		break;
	case 15:
		s_freq = vsf_q150[bw_index][0];
		s_damp = vsf_q150[bw_index][1];
		
		
		break;
	case 16:
		s_freq = vsf_q160[bw_index][0];
		s_damp = vsf_q160[bw_index][1];
		
		
		break;
	case 17:
		s_freq = vsf_q170[bw_index][0];
		s_damp = vsf_q170[bw_index][1];
		
		
		break;
	case 18:
		s_freq = vsf_q180[bw_index][0];
		s_damp = vsf_q180[bw_index][1];
		
		
		break;
	case 19:
		s_freq = vsf_q190[bw_index][0];
		s_damp = vsf_q190[bw_index][1];
		
		
		break;
	case 20:
		s_freq = vsf_q200[bw_index][0];
		s_damp = vsf_q200[bw_index][1];
		
		
		break;
	case 21:
		s_freq = vsf_q210[bw_index][0];
		s_damp = vsf_q210[bw_index][1];
		
		
		break;
	case 22:
		s_freq = vsf_q220[bw_index][0];
		s_damp = vsf_q220[bw_index][1];
		
		
		break;
	case 23:
		s_freq = vsf_q230[bw_index][0];
		s_damp = vsf_q230[bw_index][1];
		
		
		break;
	default:
	case 24:
		s_freq = vsf_q240[bw_index][0];
		s_damp = vsf_q240[bw_index][1];
		
		
		break;
    }




		    }
		    incr = calc_mod_freq(vp, incr);
		}
		newsample = (resample_t)v1;
		if (bw_index) {
                    insamp = (FLOAT_T)newsample;

		    s_notch = insamp - s_damp*s_band;
		    s_low   = s_low + s_freq*s_band;
		    s_high  = s_notch - s_low;
		    if (s_drive > 0) s_band  = s_freq*s_high + s_band - s_drive*s_band*s_band*s_band;
		    else s_band  = s_freq*s_high + s_band;

		    if (filter_type==FILTER_LOWPASS)
		        outsamp  = 0.5*s_low;
		    else if (filter_type==FILTER_HIGHPASS)
		        outsamp  = 0.5*s_high;
		    else if (filter_type==FILTER_BAND)
		        outsamp  = 0.5*s_band;
		    else if (filter_type==FILTER_NOTCH)
		        outsamp  = 0.5*s_notch;
		    else /* if (filter_type==FILTER_PEAK) */
		        outsamp  = 0.5*(s_low-s_high);

		    s_notch = insamp - s_damp*s_band;
		    s_low   = s_low + s_freq*s_band;
		    s_high  = s_notch - s_low;
		    if (s_drive > 0) s_band  = s_freq*s_high + s_band - s_drive*s_band*s_band*s_band;
		    else s_band  = s_freq*s_high + s_band;

		    if (filter_type==FILTER_LOWPASS)
		        outsamp  += 0.5*s_low;
		    else if (filter_type==FILTER_HIGHPASS)
		        outsamp  += 0.5*s_high;
		    else if (filter_type==FILTER_BAND)
		        outsamp  += 0.5*s_band;
		    else if (filter_type==FILTER_NOTCH)
		        outsamp  += 0.5*s_notch;
		    else /* if (filter_type==FILTER_PEAK) */
		        outsamp  += 0.5*(s_low-s_high);


		    newsample = (resample_t)outsamp;
		}
		ofs=ofsd;
	}
	*dest++ = newsample;
	  ofs += incr;
	}
      if (vibflag)
	{
	  cc = vp->vibrato_control_ratio;
	  incr = update_vibrato(vp, (incr < 0));
	  vibflag = 0;
	}
      if (ofs >= le)
	{
#ifdef USE_BIDIR_OVERSHOOT
	  /* fold the overshoot back in */
	  ofs = le2 - ofs;
#endif
	  incr *= -1;
	}
      else if (ofs <= ls)
	{
#ifdef USE_BIDIR_OVERSHOOT
	  ofs = ls2 - ofs;
#endif
	  incr *= -1;
	}
    }


  vp->vibrato_control_counter=cc;
  vp->sample_increment=incr;
  vp->sample_offset=ofs; /* Update offset */
  vp->current_x0=s_low;
  vp->current_x1=s_band;
  vp->bw_index=bw_index;
  vp->modulation_counter=cc_count;
  return resample_buffer+resample_buffer_offset;
}

static int rs_update_porta(int v)
{
    Voice *vp=&voice[v];
    int32 d;

    d = vp->porta_dpb;
    if(vp->porta_pb < 0)
    {
	if(d > -vp->porta_pb)
	    d = -vp->porta_pb;
    }
    else
    {
	if(d > vp->porta_pb)
	    d = -vp->porta_pb;
	else
	    d = -d;
    }

    vp->porta_pb += d;
    if(vp->porta_pb == 0)
    {
	vp->porta_control_ratio = 0;
	vp->porta_pb = 0;
    }
    recompute_freq(v);
    return vp->porta_control_ratio;
}

static resample_t *porta_resample_voice(int v, uint32 *countptr, int mode)
{
    Voice *vp=&voice[v];
    uint32 n = *countptr;
    uint32 i;
    resample_t *(* resampler)(int, uint32 *, int);
    int cc = vp->porta_control_counter;
    int loop;

    if(vp->vibrato_control_ratio)
	resampler = vib_resample_voice;
    else
	resampler = normal_resample_voice;
    if(mode != 1)
	loop = 1;
    else
	loop = 0;

    /* vp->cache = NULL; */
    resample_buffer_offset = 0;
    while(resample_buffer_offset < n)
    {
	if(cc == 0)
	{
	    if((cc = rs_update_porta(v)) == 0)
	    {
		i = n - resample_buffer_offset;
		resampler(v, &i, mode);
		resample_buffer_offset += i;
		break;
	    }
	}

	i = n - resample_buffer_offset;
	if(i > (uint32)cc)
	    i = (uint32)cc;
	resampler(v, &i, mode);
	resample_buffer_offset += i;

	/* if(!loop && vp->status == VOICE_FREE) */
	if(vp->status == VOICE_FREE)
	    break;
	cc -= (int)i;
    }
    *countptr = resample_buffer_offset;
    resample_buffer_offset = 0;
    vp->porta_control_counter = cc;
    return resample_buffer;
}

static resample_t *vib_resample_voice(int v, uint32 *countptr, int mode)
{
    Voice *vp = &voice[v];

    /* vp->cache = NULL; */
    if(mode == 0)
	return rs_vib_loop(v, vp, countptr);
    if(mode == 1)
	return rs_vib_plain(v, countptr);
    return rs_vib_bidir(vp, *countptr);
}

static resample_t *normal_resample_voice(int v, uint32 *countptr, int mode)
{
    Voice *vp = &voice[v];
    if(mode == 0)
	return rs_loop(v, vp, countptr);
    if(mode == 1)
	return rs_plain(v, countptr);
    return rs_bidir(vp, *countptr);
}

resample_t *resample_voice_vsf(int v, uint32 *countptr)
{
    Voice *vp=&voice[v];
    int mode;

    mode = vp->sample->modes;
    if((mode & MODES_LOOPING) &&
       ((mode & MODES_ENVELOPE) ||
	(vp->status & (VOICE_ON | VOICE_SUSTAINED))))
    {
	if(mode & MODES_PINGPONG)
	{
	    mode = 2;
	}
	else
	    mode = 0;
    }
    else
	mode = 1;

    if(vp->porta_control_ratio)
	return porta_resample_voice(v, countptr, mode);

    if(vp->vibrato_control_ratio)
	return vib_resample_voice(v, countptr, mode);

    return normal_resample_voice(v, countptr, mode);
}

