/* build_tools_preferences.c generated by valac 0.35.2.3-28fcae, the Vala compiler
 * generated from build_tools_preferences.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2012-2015 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Sébastien Wilmet
 */
/* The preferences of the default and personal build tools.*/
/* For the configuration of a single build tool, see build_tool_dialog.vala.*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <latexila.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_BUILD_TOOLS_PREFERENCES (build_tools_preferences_get_type ())
#define BUILD_TOOLS_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILD_TOOLS_PREFERENCES, BuildToolsPreferences))
#define BUILD_TOOLS_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILD_TOOLS_PREFERENCES, BuildToolsPreferencesClass))
#define IS_BUILD_TOOLS_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILD_TOOLS_PREFERENCES))
#define IS_BUILD_TOOLS_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILD_TOOLS_PREFERENCES))
#define BUILD_TOOLS_PREFERENCES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILD_TOOLS_PREFERENCES, BuildToolsPreferencesClass))

typedef struct _BuildToolsPreferences BuildToolsPreferences;
typedef struct _BuildToolsPreferencesClass BuildToolsPreferencesClass;
typedef struct _BuildToolsPreferencesPrivate BuildToolsPreferencesPrivate;

#define BUILD_TOOLS_PREFERENCES_TYPE_BUILD_TOOL_COLUMN (build_tools_preferences_build_tool_column_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block4Data Block4Data;
typedef struct _Block5Data Block5Data;
#define __g_list_free__gtk_tree_path_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__gtk_tree_path_free0_ (var), NULL)))
typedef struct _Block6Data Block6Data;
typedef struct _Block7Data Block7Data;

#define TYPE_BUILD_TOOL_DIALOG (build_tool_dialog_get_type ())
#define BUILD_TOOL_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILD_TOOL_DIALOG, BuildToolDialog))
#define BUILD_TOOL_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILD_TOOL_DIALOG, BuildToolDialogClass))
#define IS_BUILD_TOOL_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILD_TOOL_DIALOG))
#define IS_BUILD_TOOL_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILD_TOOL_DIALOG))
#define BUILD_TOOL_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILD_TOOL_DIALOG, BuildToolDialogClass))

typedef struct _BuildToolDialog BuildToolDialog;
typedef struct _BuildToolDialogClass BuildToolDialogClass;
typedef struct _Block8Data Block8Data;
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))
typedef struct _Block9Data Block9Data;
typedef struct _Block10Data Block10Data;

struct _BuildToolsPreferences {
	GObject parent_instance;
	BuildToolsPreferencesPrivate * priv;
};

struct _BuildToolsPreferencesClass {
	GObjectClass parent_class;
};

struct _BuildToolsPreferencesPrivate {
	GtkDialog* _dialog;
	GtkListStore* _default_store;
	GtkListStore* _personal_store;
	GtkTreeView* _default_view;
	GtkTreeView* _personal_view;
};

typedef enum  {
	BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_ENABLED,
	BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_PIXBUF,
	BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_LABEL,
	BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_DESCRIPTION,
	BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_N_COLUMNS
} BuildToolsPreferencesBuildToolColumn;

struct _Block4Data {
	int _ref_count_;
	BuildToolsPreferences* self;
	GtkTreeSelection* default_select;
	GtkTreeSelection* personal_select;
};

struct _Block5Data {
	int _ref_count_;
	BuildToolsPreferences* self;
	GtkTreeViewColumn* label_column;
	GtkListStore* store;
	LatexilaBuildTools* build_tools;
};

struct _Block6Data {
	int _ref_count_;
	BuildToolsPreferences* self;
	GtkTreeView* view;
	LatexilaBuildTools* build_tools;
};

struct _Block7Data {
	int _ref_count_;
	BuildToolsPreferences* self;
	GtkTreeView* view;
	LatexilaBuildTools* build_tools;
};

struct _Block8Data {
	int _ref_count_;
	BuildToolsPreferences* self;
	GtkToolButton* up_button;
	GtkTreeSelection* select;
};

struct _Block9Data {
	int _ref_count_;
	BuildToolsPreferences* self;
	GtkToolButton* down_button;
	GtkTreeSelection* select;
};

struct _Block10Data {
	int _ref_count_;
	BuildToolsPreferences* self;
	GtkTreeSelection* select;
	GtkWidget* widget;
};


static gpointer build_tools_preferences_parent_class = NULL;

GType build_tools_preferences_get_type (void) G_GNUC_CONST;
#define BUILD_TOOLS_PREFERENCES_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_BUILD_TOOLS_PREFERENCES, BuildToolsPreferencesPrivate))
enum  {
	BUILD_TOOLS_PREFERENCES_DUMMY_PROPERTY
};
static GType build_tools_preferences_build_tool_column_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
BuildToolsPreferences* build_tools_preferences_new (GtkWindow* parent_window);
BuildToolsPreferences* build_tools_preferences_construct (GType object_type, GtkWindow* parent_window);
static GtkListStore* build_tools_preferences_get_new_store (BuildToolsPreferences* self);
static void build_tools_preferences_update_default_store (BuildToolsPreferences* self);
static void build_tools_preferences_update_personal_store (BuildToolsPreferences* self);
static void build_tools_preferences_init_views (BuildToolsPreferences* self);
static GtkWidget* build_tools_preferences_get_default_grid (BuildToolsPreferences* self);
static GtkWidget* build_tools_preferences_get_personal_grid (BuildToolsPreferences* self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static GtkTreeView* build_tools_preferences_get_new_view (BuildToolsPreferences* self, GtkListStore* store, LatexilaBuildTools* build_tools);
static void __lambda119_ (Block4Data* _data4_);
static void build_tools_preferences_on_view_selection_changed (BuildToolsPreferences* self, GtkTreeSelection* select, GtkTreeSelection* other_select);
static void ___lambda119__gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self);
static void __lambda120_ (Block4Data* _data4_);
static void ___lambda120__gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self);
static GtkToolButton* build_tools_preferences_get_properties_button (BuildToolsPreferences* self, GtkTreeView* view, LatexilaBuildTools* build_tools, gboolean read_only);
static GtkToolButton* build_tools_preferences_get_copy_button (BuildToolsPreferences* self, GtkTreeView* view, LatexilaBuildTools* build_tools);
static GtkWidget* build_tools_preferences_join_view_and_toolbar (BuildToolsPreferences* self, GtkTreeView* view, GtkToolbar* toolbar);
static GtkToolButton* build_tools_preferences_get_add_button (BuildToolsPreferences* self);
static GtkToolButton* build_tools_preferences_get_remove_button (BuildToolsPreferences* self);
static GtkToolButton* build_tools_preferences_get_up_button (BuildToolsPreferences* self);
static GtkToolButton* build_tools_preferences_get_down_button (BuildToolsPreferences* self);
GtkScrolledWindow* utils_add_scrollbar (GtkWidget* child);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void __lambda108_ (Block5Data* _data5_, const gchar* path_string);
static void ___lambda108__gtk_cell_renderer_toggle_toggled (GtkCellRendererToggle* _sender, const gchar* path, gpointer self);
static void __lambda109_ (Block5Data* _data5_, GtkTreePath* path, GtkTreeViewColumn* column);
static void build_tools_preferences_open_build_tool (BuildToolsPreferences* self, LatexilaBuildTools* build_tools, gint build_tool_num);
static void ___lambda109__gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self);
static void _gtk_tree_path_free0_ (gpointer var);
static void _g_list_free__gtk_tree_path_free0_ (GList* self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void build_tools_preferences_set_sensitivity_on_selection (BuildToolsPreferences* self, GtkTreeView* view, GtkWidget* widget);
static void __lambda122_ (Block6Data* _data6_);
gint utils_get_selected_row (GtkTreeView* view, GtkTreeIter* iter);
static void ___lambda122__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void __lambda123_ (Block7Data* _data7_);
static void ___lambda123__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void __lambda124_ (BuildToolsPreferences* self);
GType build_tool_dialog_get_type (void) G_GNUC_CONST;
BuildToolDialog* build_tool_dialog_new (GtkWindow* parent, gboolean editable);
BuildToolDialog* build_tool_dialog_construct (GType object_type, GtkWindow* parent, gboolean editable);
gboolean build_tool_dialog_create_personal_build_tool (BuildToolDialog* self);
static void ___lambda124__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void __lambda125_ (BuildToolsPreferences* self);
static void ___lambda125__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static void __lambda126_ (Block8Data* _data8_);
static void ___lambda126__gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self);
static void __lambda127_ (Block8Data* _data8_);
gboolean utils_tree_model_iter_prev (GtkTreeModel* model, GtkTreeIter* iter);
static void ___lambda127__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static void __lambda128_ (Block9Data* _data9_);
static void ___lambda128__gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self);
static void __lambda129_ (Block9Data* _data9_);
static void ___lambda129__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void build_tools_preferences_update_store (BuildToolsPreferences* self, GtkListStore* store, LatexilaBuildTools* build_tools);
gboolean build_tool_dialog_open_build_tool (BuildToolDialog* self, LatexilaBuildTools* build_tools, gint build_tool_num);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
static void __lambda121_ (Block10Data* _data10_);
static void ___lambda121__gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self);
static void build_tools_preferences_finalize (GObject * obj);


static GType build_tools_preferences_build_tool_column_get_type (void) {
	static volatile gsize build_tools_preferences_build_tool_column_type_id__volatile = 0;
	if (g_once_init_enter (&build_tools_preferences_build_tool_column_type_id__volatile)) {
		static const GEnumValue values[] = {{BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_ENABLED, "BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_ENABLED", "enabled"}, {BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_PIXBUF, "BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_PIXBUF", "pixbuf"}, {BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_LABEL, "BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_LABEL", "label"}, {BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_DESCRIPTION, "BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_DESCRIPTION", "description"}, {BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_N_COLUMNS, "BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType build_tools_preferences_build_tool_column_type_id;
		build_tools_preferences_build_tool_column_type_id = g_enum_register_static ("BuildToolsPreferencesBuildToolColumn", values);
		g_once_init_leave (&build_tools_preferences_build_tool_column_type_id__volatile, build_tools_preferences_build_tool_column_type_id);
	}
	return build_tools_preferences_build_tool_column_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


BuildToolsPreferences* build_tools_preferences_construct (GType object_type, GtkWindow* parent_window) {
	BuildToolsPreferences * self = NULL;
	GtkListStore* _tmp0_;
	GtkListStore* _tmp1_;
	GObject* _tmp2_;
	GObject* _tmp3_;
	GtkDialog* _tmp4_;
	GtkDialog* _tmp5_;
	GtkWindow* _tmp6_;
	GtkDialog* _tmp7_;
	GtkDialog* _tmp8_;
	GtkGrid* hgrid;
	GtkGrid* _tmp9_;
	GtkWidget* _tmp10_;
	GtkWidget* _tmp11_;
	GtkWidget* _tmp12_;
	GtkWidget* _tmp13_;
	GtkBox* content_area;
	GtkDialog* _tmp14_;
	GtkBox* _tmp15_;
	GtkBox* _tmp16_;
	GtkDialog* _tmp17_;
	GtkDialog* _tmp18_;
	LatexilaBuildToolsPersonal* _tmp19_;
	g_return_val_if_fail (parent_window != NULL, NULL);
	self = (BuildToolsPreferences*) g_object_new (object_type, NULL);
	_tmp0_ = build_tools_preferences_get_new_store (self);
	_g_object_unref0 (self->priv->_default_store);
	self->priv->_default_store = _tmp0_;
	_tmp1_ = build_tools_preferences_get_new_store (self);
	_g_object_unref0 (self->priv->_personal_store);
	self->priv->_personal_store = _tmp1_;
	build_tools_preferences_update_default_store (self);
	build_tools_preferences_update_personal_store (self);
	build_tools_preferences_init_views (self);
	_tmp2_ = g_object_new (gtk_dialog_get_type (), "use-header-bar", TRUE, NULL, NULL);
	_tmp3_ = G_IS_INITIALLY_UNOWNED (_tmp2_) ? g_object_ref_sink (_tmp2_) : _tmp2_;
	_tmp4_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gtk_dialog_get_type ()) ? ((GtkDialog*) _tmp3_) : NULL;
	if (_tmp4_ == NULL) {
		_g_object_unref0 (_tmp3_);
	}
	_g_object_unref0 (self->priv->_dialog);
	self->priv->_dialog = _tmp4_;
	_tmp5_ = self->priv->_dialog;
	_tmp6_ = parent_window;
	gtk_window_set_transient_for ((GtkWindow*) _tmp5_, _tmp6_);
	_tmp7_ = self->priv->_dialog;
	gtk_window_set_destroy_with_parent ((GtkWindow*) _tmp7_, TRUE);
	_tmp8_ = self->priv->_dialog;
	gtk_window_set_title ((GtkWindow*) _tmp8_, _ ("Build Tools"));
	_tmp9_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp9_);
	hgrid = _tmp9_;
	gtk_orientable_set_orientation ((GtkOrientable*) hgrid, GTK_ORIENTATION_HORIZONTAL);
	gtk_grid_set_column_spacing (hgrid, (guint) 10);
	_tmp10_ = build_tools_preferences_get_default_grid (self);
	_tmp11_ = _tmp10_;
	gtk_container_add ((GtkContainer*) hgrid, _tmp11_);
	_g_object_unref0 (_tmp11_);
	_tmp12_ = build_tools_preferences_get_personal_grid (self);
	_tmp13_ = _tmp12_;
	gtk_container_add ((GtkContainer*) hgrid, _tmp13_);
	_g_object_unref0 (_tmp13_);
	_tmp14_ = self->priv->_dialog;
	_tmp15_ = (GtkBox*) gtk_dialog_get_content_area (_tmp14_);
	_tmp16_ = _g_object_ref0 (_tmp15_);
	content_area = _tmp16_;
	gtk_box_pack_start (content_area, (GtkWidget*) hgrid, TRUE, TRUE, (guint) 0);
	gtk_widget_show_all ((GtkWidget*) content_area);
	_tmp17_ = self->priv->_dialog;
	gtk_dialog_run (_tmp17_);
	_tmp18_ = self->priv->_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp18_);
	_tmp19_ = latexila_build_tools_personal_get_instance ();
	latexila_build_tools_personal_save (_tmp19_);
	_g_object_unref0 (content_area);
	_g_object_unref0 (hgrid);
	return self;
}


BuildToolsPreferences* build_tools_preferences_new (GtkWindow* parent_window) {
	return build_tools_preferences_construct (TYPE_BUILD_TOOLS_PREFERENCES, parent_window);
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		BuildToolsPreferences* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->personal_select);
		_g_object_unref0 (_data4_->default_select);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}


static void __lambda119_ (Block4Data* _data4_) {
	BuildToolsPreferences* self;
	self = _data4_->self;
	build_tools_preferences_on_view_selection_changed (self, _data4_->default_select, _data4_->personal_select);
}


static void ___lambda119__gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self) {
	__lambda119_ (self);
}


static void __lambda120_ (Block4Data* _data4_) {
	BuildToolsPreferences* self;
	self = _data4_->self;
	build_tools_preferences_on_view_selection_changed (self, _data4_->personal_select, _data4_->default_select);
}


static void ___lambda120__gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self) {
	__lambda120_ (self);
}


static void build_tools_preferences_init_views (BuildToolsPreferences* self) {
	Block4Data* _data4_;
	GtkListStore* _tmp0_;
	LatexilaBuildToolsDefault* _tmp1_;
	GtkTreeView* _tmp2_;
	GtkListStore* _tmp3_;
	LatexilaBuildToolsPersonal* _tmp4_;
	GtkTreeView* _tmp5_;
	GtkTreeView* _tmp6_;
	GtkTreeSelection* _tmp7_;
	GtkTreeSelection* _tmp8_;
	GtkTreeView* _tmp9_;
	GtkTreeSelection* _tmp10_;
	GtkTreeSelection* _tmp11_;
	g_return_if_fail (self != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = self->priv->_default_store;
	_tmp1_ = latexila_build_tools_default_get_instance ();
	_tmp2_ = build_tools_preferences_get_new_view (self, _tmp0_, (LatexilaBuildTools*) _tmp1_);
	_g_object_unref0 (self->priv->_default_view);
	self->priv->_default_view = _tmp2_;
	_tmp3_ = self->priv->_personal_store;
	_tmp4_ = latexila_build_tools_personal_get_instance ();
	_tmp5_ = build_tools_preferences_get_new_view (self, _tmp3_, (LatexilaBuildTools*) _tmp4_);
	_g_object_unref0 (self->priv->_personal_view);
	self->priv->_personal_view = _tmp5_;
	_tmp6_ = self->priv->_default_view;
	_tmp7_ = gtk_tree_view_get_selection (_tmp6_);
	_tmp8_ = _g_object_ref0 (_tmp7_);
	_data4_->default_select = _tmp8_;
	_tmp9_ = self->priv->_personal_view;
	_tmp10_ = gtk_tree_view_get_selection (_tmp9_);
	_tmp11_ = _g_object_ref0 (_tmp10_);
	_data4_->personal_select = _tmp11_;
	g_signal_connect_data (_data4_->default_select, "changed", (GCallback) ___lambda119__gtk_tree_selection_changed, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	g_signal_connect_data (_data4_->personal_select, "changed", (GCallback) ___lambda120__gtk_tree_selection_changed, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	block4_data_unref (_data4_);
	_data4_ = NULL;
}


static GtkWidget* build_tools_preferences_get_default_grid (BuildToolsPreferences* self) {
	GtkWidget* result = NULL;
	LatexilaBuildTools* default_build_tools;
	LatexilaBuildToolsDefault* _tmp0_;
	LatexilaBuildTools* _tmp1_;
	GtkToolButton* properties_button;
	GtkTreeView* _tmp2_;
	GtkToolButton* _tmp3_;
	GtkToolButton* copy_button;
	GtkTreeView* _tmp4_;
	GtkToolButton* _tmp5_;
	GtkToolbar* toolbar;
	GtkToolbar* _tmp6_;
	GtkWidget* join;
	GtkTreeView* _tmp7_;
	GtkWidget* _tmp8_;
	GtkWidget* _tmp9_;
	GtkWidget* _tmp10_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = latexila_build_tools_default_get_instance ();
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, latexila_build_tools_get_type ()) ? ((LatexilaBuildTools*) _tmp0_) : NULL);
	default_build_tools = _tmp1_;
	_tmp2_ = self->priv->_default_view;
	_tmp3_ = build_tools_preferences_get_properties_button (self, _tmp2_, default_build_tools, TRUE);
	properties_button = _tmp3_;
	_tmp4_ = self->priv->_default_view;
	_tmp5_ = build_tools_preferences_get_copy_button (self, _tmp4_, default_build_tools);
	copy_button = _tmp5_;
	_tmp6_ = (GtkToolbar*) gtk_toolbar_new ();
	g_object_ref_sink (_tmp6_);
	toolbar = _tmp6_;
	gtk_toolbar_insert (toolbar, (GtkToolItem*) properties_button, -1);
	gtk_toolbar_insert (toolbar, (GtkToolItem*) copy_button, -1);
	_tmp7_ = self->priv->_default_view;
	_tmp8_ = build_tools_preferences_join_view_and_toolbar (self, _tmp7_, toolbar);
	join = _tmp8_;
	_tmp9_ = latexila_utils_get_dialog_component (_ ("Default Build Tools"), join);
	_tmp10_ = _g_object_ref0 (_tmp9_);
	result = _tmp10_;
	_g_object_unref0 (join);
	_g_object_unref0 (toolbar);
	_g_object_unref0 (copy_button);
	_g_object_unref0 (properties_button);
	_g_object_unref0 (default_build_tools);
	return result;
}


static GtkWidget* build_tools_preferences_get_personal_grid (BuildToolsPreferences* self) {
	GtkWidget* result = NULL;
	LatexilaBuildTools* personal_build_tools;
	LatexilaBuildToolsPersonal* _tmp0_;
	LatexilaBuildTools* _tmp1_;
	GtkToolButton* properties_button;
	GtkTreeView* _tmp2_;
	GtkToolButton* _tmp3_;
	GtkToolButton* copy_button;
	GtkTreeView* _tmp4_;
	GtkToolButton* _tmp5_;
	GtkToolbar* toolbar;
	GtkToolbar* _tmp6_;
	GtkToolButton* _tmp7_;
	GtkToolButton* _tmp8_;
	GtkToolButton* _tmp9_;
	GtkToolButton* _tmp10_;
	GtkToolButton* _tmp11_;
	GtkToolButton* _tmp12_;
	GtkToolButton* _tmp13_;
	GtkToolButton* _tmp14_;
	GtkWidget* join;
	GtkTreeView* _tmp15_;
	GtkWidget* _tmp16_;
	GtkWidget* _tmp17_;
	GtkWidget* _tmp18_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = latexila_build_tools_personal_get_instance ();
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, latexila_build_tools_get_type ()) ? ((LatexilaBuildTools*) _tmp0_) : NULL);
	personal_build_tools = _tmp1_;
	_tmp2_ = self->priv->_personal_view;
	_tmp3_ = build_tools_preferences_get_properties_button (self, _tmp2_, personal_build_tools, FALSE);
	properties_button = _tmp3_;
	_tmp4_ = self->priv->_personal_view;
	_tmp5_ = build_tools_preferences_get_copy_button (self, _tmp4_, personal_build_tools);
	copy_button = _tmp5_;
	_tmp6_ = (GtkToolbar*) gtk_toolbar_new ();
	g_object_ref_sink (_tmp6_);
	toolbar = _tmp6_;
	gtk_toolbar_insert (toolbar, (GtkToolItem*) properties_button, -1);
	gtk_toolbar_insert (toolbar, (GtkToolItem*) copy_button, -1);
	_tmp7_ = build_tools_preferences_get_add_button (self);
	_tmp8_ = _tmp7_;
	gtk_toolbar_insert (toolbar, (GtkToolItem*) _tmp8_, -1);
	_g_object_unref0 (_tmp8_);
	_tmp9_ = build_tools_preferences_get_remove_button (self);
	_tmp10_ = _tmp9_;
	gtk_toolbar_insert (toolbar, (GtkToolItem*) _tmp10_, -1);
	_g_object_unref0 (_tmp10_);
	_tmp11_ = build_tools_preferences_get_up_button (self);
	_tmp12_ = _tmp11_;
	gtk_toolbar_insert (toolbar, (GtkToolItem*) _tmp12_, -1);
	_g_object_unref0 (_tmp12_);
	_tmp13_ = build_tools_preferences_get_down_button (self);
	_tmp14_ = _tmp13_;
	gtk_toolbar_insert (toolbar, (GtkToolItem*) _tmp14_, -1);
	_g_object_unref0 (_tmp14_);
	_tmp15_ = self->priv->_personal_view;
	_tmp16_ = build_tools_preferences_join_view_and_toolbar (self, _tmp15_, toolbar);
	join = _tmp16_;
	_tmp17_ = latexila_utils_get_dialog_component (_ ("Personal Build Tools"), join);
	_tmp18_ = _g_object_ref0 (_tmp17_);
	result = _tmp18_;
	_g_object_unref0 (join);
	_g_object_unref0 (toolbar);
	_g_object_unref0 (copy_button);
	_g_object_unref0 (properties_button);
	_g_object_unref0 (personal_build_tools);
	return result;
}


static GtkWidget* build_tools_preferences_join_view_and_toolbar (BuildToolsPreferences* self, GtkTreeView* view, GtkToolbar* toolbar) {
	GtkWidget* result = NULL;
	GtkTreeView* _tmp0_;
	GtkScrolledWindow* scrolled_window;
	GtkTreeView* _tmp1_;
	GtkScrolledWindow* _tmp2_;
	GtkToolbar* _tmp3_;
	GtkToolbar* _tmp4_;
	GtkStyleContext* context;
	GtkToolbar* _tmp5_;
	GtkStyleContext* _tmp6_;
	GtkStyleContext* _tmp7_;
	GtkToolbar* _tmp8_;
	GtkWidget* _tmp9_;
	GtkWidget* _tmp10_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (view != NULL, NULL);
	g_return_val_if_fail (toolbar != NULL, NULL);
	_tmp0_ = view;
	g_object_set ((GtkWidget*) _tmp0_, "expand", TRUE, NULL);
	_tmp1_ = view;
	_tmp2_ = utils_add_scrollbar ((GtkWidget*) _tmp1_);
	scrolled_window = _tmp2_;
	gtk_scrolled_window_set_shadow_type (scrolled_window, GTK_SHADOW_IN);
	gtk_widget_set_size_request ((GtkWidget*) scrolled_window, 350, 200);
	_tmp3_ = toolbar;
	gtk_toolbar_set_icon_size (_tmp3_, GTK_ICON_SIZE_MENU);
	_tmp4_ = toolbar;
	gtk_toolbar_set_style (_tmp4_, GTK_TOOLBAR_ICONS);
	_tmp5_ = toolbar;
	_tmp6_ = gtk_widget_get_style_context ((GtkWidget*) _tmp5_);
	_tmp7_ = _g_object_ref0 (_tmp6_);
	context = _tmp7_;
	gtk_style_context_add_class (context, GTK_STYLE_CLASS_INLINE_TOOLBAR);
	_tmp8_ = toolbar;
	_tmp9_ = latexila_utils_join_widgets ((GtkWidget*) scrolled_window, (GtkWidget*) _tmp8_);
	_tmp10_ = _g_object_ref0 (_tmp9_);
	result = _tmp10_;
	_g_object_unref0 (context);
	_g_object_unref0 (scrolled_window);
	return result;
}


static GtkListStore* build_tools_preferences_get_new_store (BuildToolsPreferences* self) {
	GtkListStore* result = NULL;
	GtkListStore* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gtk_list_store_new ((gint) BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_N_COLUMNS, G_TYPE_BOOLEAN, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, -1);
	result = _tmp0_;
	return result;
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (void * _userdata_) {
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		BuildToolsPreferences* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->label_column);
		_g_object_unref0 (_data5_->store);
		_g_object_unref0 (_data5_->build_tools);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}


static void __lambda108_ (Block5Data* _data5_, const gchar* path_string) {
	BuildToolsPreferences* self;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp0_;
	const gchar* _tmp1_;
	GtkTreeIter _tmp2_ = {0};
	gboolean enabled = FALSE;
	GtkTreeModel* model;
	GtkListStore* _tmp3_;
	GtkTreeModel* _tmp4_;
	GtkTreeIter _tmp5_;
	gboolean _tmp6_;
	GtkListStore* _tmp7_;
	GtkTreeIter _tmp8_;
	gboolean _tmp9_;
	gint num;
	const gchar* _tmp10_;
	gint _tmp11_;
	LatexilaBuildTools* _tmp12_;
	gboolean _tmp13_;
	self = _data5_->self;
	g_return_if_fail (path_string != NULL);
	_tmp0_ = _data5_->store;
	_tmp1_ = path_string;
	gtk_tree_model_get_iter_from_string ((GtkTreeModel*) _tmp0_, &_tmp2_, _tmp1_);
	iter = _tmp2_;
	_tmp3_ = _data5_->store;
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, GTK_TYPE_TREE_MODEL) ? ((GtkTreeModel*) _tmp3_) : NULL);
	model = _tmp4_;
	_tmp5_ = iter;
	gtk_tree_model_get (model, &_tmp5_, BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_ENABLED, &enabled, -1);
	_tmp6_ = enabled;
	enabled = !_tmp6_;
	_tmp7_ = _data5_->store;
	_tmp8_ = iter;
	_tmp9_ = enabled;
	gtk_list_store_set (_tmp7_, &_tmp8_, BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_ENABLED, _tmp9_, -1);
	_tmp10_ = path_string;
	_tmp11_ = atoi (_tmp10_);
	num = _tmp11_;
	_tmp12_ = _data5_->build_tools;
	_tmp13_ = enabled;
	latexila_build_tools_set_enabled (_tmp12_, (guint) num, _tmp13_);
	_g_object_unref0 (model);
}


static void ___lambda108__gtk_cell_renderer_toggle_toggled (GtkCellRendererToggle* _sender, const gchar* path, gpointer self) {
	__lambda108_ (self, path);
}


static void __lambda109_ (Block5Data* _data5_, GtkTreePath* path, GtkTreeViewColumn* column) {
	BuildToolsPreferences* self;
	GtkTreeViewColumn* _tmp0_;
	self = _data5_->self;
	g_return_if_fail (path != NULL);
	g_return_if_fail (column != NULL);
	_tmp0_ = column;
	if (_tmp0_ == _data5_->label_column) {
		gint build_tool_num;
		GtkTreePath* _tmp1_;
		gint _tmp2_;
		gint* _tmp3_;
		gint _tmp4_;
		LatexilaBuildTools* _tmp5_;
		gint _tmp6_;
		_tmp1_ = path;
		_tmp3_ = gtk_tree_path_get_indices_with_depth (_tmp1_, &_tmp2_);
		_tmp4_ = _tmp3_[0];
		build_tool_num = _tmp4_;
		_tmp5_ = _data5_->build_tools;
		_tmp6_ = build_tool_num;
		build_tools_preferences_open_build_tool (self, _tmp5_, _tmp6_);
	}
}


static void ___lambda109__gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self) {
	__lambda109_ (self, path, column);
}


static GtkTreeView* build_tools_preferences_get_new_view (BuildToolsPreferences* self, GtkListStore* store, LatexilaBuildTools* build_tools) {
	GtkTreeView* result = NULL;
	Block5Data* _data5_;
	GtkListStore* _tmp0_;
	GtkListStore* _tmp1_;
	LatexilaBuildTools* _tmp2_;
	LatexilaBuildTools* _tmp3_;
	GtkTreeView* view;
	GtkListStore* _tmp4_;
	GtkTreeView* _tmp5_;
	GtkTreeViewColumn* enabled_column;
	GtkTreeViewColumn* _tmp6_;
	GtkCellRendererToggle* toggle_renderer;
	GtkCellRendererToggle* _tmp7_;
	GtkTreeViewColumn* _tmp8_;
	GtkCellRendererPixbuf* pixbuf_renderer;
	GtkCellRendererPixbuf* _tmp9_;
	GtkCellRendererText* text_renderer;
	GtkCellRendererText* _tmp10_;
	GtkTreeSelection* select;
	GtkTreeSelection* _tmp11_;
	GtkTreeSelection* _tmp12_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (store != NULL, NULL);
	g_return_val_if_fail (build_tools != NULL, NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp0_ = store;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data5_->store);
	_data5_->store = _tmp1_;
	_tmp2_ = build_tools;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (_data5_->build_tools);
	_data5_->build_tools = _tmp3_;
	_tmp4_ = _data5_->store;
	_tmp5_ = (GtkTreeView*) gtk_tree_view_new_with_model ((GtkTreeModel*) _tmp4_);
	g_object_ref_sink (_tmp5_);
	view = _tmp5_;
	_tmp6_ = gtk_tree_view_column_new ();
	g_object_ref_sink (_tmp6_);
	enabled_column = _tmp6_;
	gtk_tree_view_column_set_title (enabled_column, _ ("Enabled"));
	gtk_tree_view_append_column (view, enabled_column);
	_tmp7_ = (GtkCellRendererToggle*) gtk_cell_renderer_toggle_new ();
	g_object_ref_sink (_tmp7_);
	toggle_renderer = _tmp7_;
	gtk_cell_layout_pack_start ((GtkCellLayout*) enabled_column, (GtkCellRenderer*) toggle_renderer, FALSE);
	gtk_tree_view_column_set_attributes (enabled_column, (GtkCellRenderer*) toggle_renderer, "active", BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_ENABLED, NULL);
	_tmp8_ = gtk_tree_view_column_new ();
	g_object_ref_sink (_tmp8_);
	_data5_->label_column = _tmp8_;
	gtk_tree_view_column_set_title (_data5_->label_column, _ ("Label"));
	gtk_tree_view_append_column (view, _data5_->label_column);
	_tmp9_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	g_object_ref_sink (_tmp9_);
	pixbuf_renderer = _tmp9_;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _data5_->label_column, (GtkCellRenderer*) pixbuf_renderer, FALSE);
	gtk_tree_view_column_set_attributes (_data5_->label_column, (GtkCellRenderer*) pixbuf_renderer, "icon-name", BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_PIXBUF, NULL);
	_tmp10_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp10_);
	text_renderer = _tmp10_;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _data5_->label_column, (GtkCellRenderer*) text_renderer, TRUE);
	gtk_tree_view_column_set_attributes (_data5_->label_column, (GtkCellRenderer*) text_renderer, "text", BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_LABEL, NULL);
	gtk_tree_view_set_tooltip_column (view, (gint) BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_DESCRIPTION);
	_tmp11_ = gtk_tree_view_get_selection (view);
	_tmp12_ = _g_object_ref0 (_tmp11_);
	select = _tmp12_;
	gtk_tree_selection_set_mode (select, GTK_SELECTION_SINGLE);
	g_signal_connect_data (toggle_renderer, "toggled", (GCallback) ___lambda108__gtk_cell_renderer_toggle_toggled, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	g_signal_connect_data (view, "row-activated", (GCallback) ___lambda109__gtk_tree_view_row_activated, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	result = view;
	_g_object_unref0 (select);
	_g_object_unref0 (text_renderer);
	_g_object_unref0 (pixbuf_renderer);
	_g_object_unref0 (toggle_renderer);
	_g_object_unref0 (enabled_column);
	block5_data_unref (_data5_);
	_data5_ = NULL;
	return result;
}


static void _gtk_tree_path_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL));
}


static void _g_list_free__gtk_tree_path_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _gtk_tree_path_free0_, NULL);
	g_list_free (self);
}


static void build_tools_preferences_on_view_selection_changed (BuildToolsPreferences* self, GtkTreeSelection* select, GtkTreeSelection* other_select) {
	GList* selected_items;
	GtkTreeSelection* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	guint _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (select != NULL);
	g_return_if_fail (other_select != NULL);
	_tmp0_ = select;
	_tmp1_ = gtk_tree_selection_get_selected_rows (_tmp0_, NULL);
	selected_items = _tmp1_;
	_tmp2_ = selected_items;
	_tmp3_ = g_list_length (_tmp2_);
	if (_tmp3_ > ((guint) 0)) {
		GtkTreeSelection* _tmp4_;
		_tmp4_ = other_select;
		gtk_tree_selection_unselect_all (_tmp4_);
	}
	__g_list_free__gtk_tree_path_free0_0 (selected_items);
}


static Block6Data* block6_data_ref (Block6Data* _data6_) {
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}


static void block6_data_unref (void * _userdata_) {
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		BuildToolsPreferences* self;
		self = _data6_->self;
		_g_object_unref0 (_data6_->view);
		_g_object_unref0 (_data6_->build_tools);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}


static void __lambda122_ (Block6Data* _data6_) {
	BuildToolsPreferences* self;
	gint build_tool_num;
	GtkTreeView* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	self = _data6_->self;
	_tmp0_ = _data6_->view;
	_tmp1_ = utils_get_selected_row (_tmp0_, NULL);
	build_tool_num = _tmp1_;
	_tmp2_ = build_tool_num;
	if (0 <= _tmp2_) {
		LatexilaBuildTools* _tmp3_;
		gint _tmp4_;
		_tmp3_ = _data6_->build_tools;
		_tmp4_ = build_tool_num;
		build_tools_preferences_open_build_tool (self, _tmp3_, _tmp4_);
	}
}


static void ___lambda122__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda122_ (self);
}


static GtkToolButton* build_tools_preferences_get_properties_button (BuildToolsPreferences* self, GtkTreeView* view, LatexilaBuildTools* build_tools, gboolean read_only) {
	GtkToolButton* result = NULL;
	Block6Data* _data6_;
	GtkTreeView* _tmp0_;
	GtkTreeView* _tmp1_;
	LatexilaBuildTools* _tmp2_;
	LatexilaBuildTools* _tmp3_;
	GtkToolButton* properties_button;
	GtkToolButton* _tmp4_;
	gboolean _tmp5_;
	GtkTreeView* _tmp10_;
	GtkToolButton* _tmp11_;
	GtkToolButton* _tmp12_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (view != NULL, NULL);
	g_return_val_if_fail (build_tools != NULL, NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	_tmp0_ = view;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data6_->view);
	_data6_->view = _tmp1_;
	_tmp2_ = build_tools;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (_data6_->build_tools);
	_data6_->build_tools = _tmp3_;
	_tmp4_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
	g_object_ref_sink (_tmp4_);
	properties_button = _tmp4_;
	_tmp5_ = read_only;
	if (_tmp5_) {
		GtkToolButton* _tmp6_;
		GtkToolButton* _tmp7_;
		_tmp6_ = properties_button;
		gtk_tool_button_set_icon_name (_tmp6_, "edit-find-symbolic");
		_tmp7_ = properties_button;
		gtk_tool_item_set_tooltip_text ((GtkToolItem*) _tmp7_, _ ("View the properties (read-only)"));
	} else {
		GtkToolButton* _tmp8_;
		GtkToolButton* _tmp9_;
		_tmp8_ = properties_button;
		gtk_tool_button_set_icon_name (_tmp8_, "document-properties-symbolic");
		_tmp9_ = properties_button;
		gtk_tool_item_set_tooltip_text ((GtkToolItem*) _tmp9_, _ ("Edit the properties"));
	}
	_tmp10_ = _data6_->view;
	_tmp11_ = properties_button;
	build_tools_preferences_set_sensitivity_on_selection (self, _tmp10_, (GtkWidget*) _tmp11_);
	_tmp12_ = properties_button;
	g_signal_connect_data (_tmp12_, "clicked", (GCallback) ___lambda122__gtk_tool_button_clicked, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
	result = properties_button;
	block6_data_unref (_data6_);
	_data6_ = NULL;
	return result;
}


static Block7Data* block7_data_ref (Block7Data* _data7_) {
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}


static void block7_data_unref (void * _userdata_) {
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		BuildToolsPreferences* self;
		self = _data7_->self;
		_g_object_unref0 (_data7_->view);
		_g_object_unref0 (_data7_->build_tools);
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}


static void __lambda123_ (Block7Data* _data7_) {
	BuildToolsPreferences* self;
	gint selected_row;
	GtkTreeView* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	LatexilaBuildTool* tool;
	LatexilaBuildTools* _tmp3_;
	gint _tmp4_;
	LatexilaBuildTool* _tmp5_;
	LatexilaBuildTool* _tmp6_;
	LatexilaBuildTool* _tmp7_;
	LatexilaBuildTool* _tmp8_;
	LatexilaBuildTool* _tmp9_;
	LatexilaBuildTool* _tmp10_;
	LatexilaBuildTool* _tmp11_;
	LatexilaBuildTool* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	LatexilaBuildToolsPersonal* personal_build_tools;
	LatexilaBuildToolsPersonal* _tmp18_;
	LatexilaBuildToolsPersonal* _tmp19_;
	LatexilaBuildToolsPersonal* _tmp20_;
	LatexilaBuildTool* _tmp21_;
	self = _data7_->self;
	_tmp0_ = _data7_->view;
	_tmp1_ = utils_get_selected_row (_tmp0_, NULL);
	selected_row = _tmp1_;
	_tmp2_ = selected_row;
	if (_tmp2_ < 0) {
		return;
	}
	_tmp3_ = _data7_->build_tools;
	_tmp4_ = selected_row;
	_tmp5_ = latexila_build_tools_nth (_tmp3_, (guint) _tmp4_);
	_tmp6_ = _g_object_ref0 (_tmp5_);
	tool = _tmp6_;
	_tmp7_ = tool;
	g_return_if_fail (_tmp7_ != NULL);
	_tmp8_ = tool;
	_tmp9_ = latexila_build_tool_clone (_tmp8_);
	_g_object_unref0 (tool);
	tool = _tmp9_;
	_tmp10_ = tool;
	g_object_set (_tmp10_, "enabled", FALSE, NULL);
	_tmp11_ = tool;
	_tmp12_ = tool;
	g_object_get (_tmp12_, "label", &_tmp13_, NULL);
	_tmp14_ = _tmp13_;
	_tmp15_ = _tmp14_;
	_tmp16_ = g_strdup_printf (_ ("%s [copy]"), _tmp15_);
	_tmp17_ = _tmp16_;
	g_object_set (_tmp11_, "label", _tmp17_, NULL);
	g_free (_tmp17_);
	g_free (_tmp15_);
	_tmp18_ = latexila_build_tools_personal_get_instance ();
	_tmp19_ = _g_object_ref0 (_tmp18_);
	personal_build_tools = _tmp19_;
	_tmp20_ = personal_build_tools;
	_tmp21_ = tool;
	latexila_build_tools_personal_add (_tmp20_, _tmp21_);
	build_tools_preferences_update_personal_store (self);
	_g_object_unref0 (personal_build_tools);
	_g_object_unref0 (tool);
}


static void ___lambda123__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda123_ (self);
}


static GtkToolButton* build_tools_preferences_get_copy_button (BuildToolsPreferences* self, GtkTreeView* view, LatexilaBuildTools* build_tools) {
	GtkToolButton* result = NULL;
	Block7Data* _data7_;
	GtkTreeView* _tmp0_;
	GtkTreeView* _tmp1_;
	LatexilaBuildTools* _tmp2_;
	LatexilaBuildTools* _tmp3_;
	GtkToolButton* copy_button;
	GtkToolButton* _tmp4_;
	GtkTreeView* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (view != NULL, NULL);
	g_return_val_if_fail (build_tools != NULL, NULL);
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	_tmp0_ = view;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data7_->view);
	_data7_->view = _tmp1_;
	_tmp2_ = build_tools;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (_data7_->build_tools);
	_data7_->build_tools = _tmp3_;
	_tmp4_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
	g_object_ref_sink (_tmp4_);
	copy_button = _tmp4_;
	gtk_tool_button_set_icon_name (copy_button, "edit-copy-symbolic");
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) copy_button, _ ("Create a copy"));
	_tmp5_ = _data7_->view;
	build_tools_preferences_set_sensitivity_on_selection (self, _tmp5_, (GtkWidget*) copy_button);
	g_signal_connect_data (copy_button, "clicked", (GCallback) ___lambda123__gtk_tool_button_clicked, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
	result = copy_button;
	block7_data_unref (_data7_);
	_data7_ = NULL;
	return result;
}


static void __lambda124_ (BuildToolsPreferences* self) {
	BuildToolDialog* dialog;
	GtkDialog* _tmp0_;
	BuildToolDialog* _tmp1_;
	BuildToolDialog* _tmp2_;
	gboolean _tmp3_;
	_tmp0_ = self->priv->_dialog;
	_tmp1_ = build_tool_dialog_new ((GtkWindow*) _tmp0_, TRUE);
	dialog = _tmp1_;
	_tmp2_ = dialog;
	_tmp3_ = build_tool_dialog_create_personal_build_tool (_tmp2_);
	if (_tmp3_) {
		build_tools_preferences_update_personal_store (self);
	}
	_g_object_unref0 (dialog);
}


static void ___lambda124__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda124_ ((BuildToolsPreferences*) self);
}


static GtkToolButton* build_tools_preferences_get_add_button (BuildToolsPreferences* self) {
	GtkToolButton* result = NULL;
	GtkToolButton* add_button;
	GtkToolButton* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
	g_object_ref_sink (_tmp0_);
	add_button = _tmp0_;
	gtk_tool_button_set_icon_name (add_button, "list-add-symbolic");
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) add_button, _ ("Add..."));
	g_signal_connect_object (add_button, "clicked", (GCallback) ___lambda124__gtk_tool_button_clicked, self, 0);
	result = add_button;
	return result;
}


static void __lambda125_ (BuildToolsPreferences* self) {
	GtkTreeIter iter = {0};
	gint selected_row;
	GtkTreeView* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gint _tmp2_;
	gint _tmp3_;
	gchar* label = NULL;
	GtkTreeModel* model;
	GtkListStore* _tmp4_;
	GtkTreeModel* _tmp5_;
	GtkTreeModel* _tmp6_;
	GtkTreeIter _tmp7_;
	GtkDialog* dialog;
	GtkDialog* _tmp8_;
	const gchar* _tmp9_;
	GtkMessageDialog* _tmp10_;
	GtkDialog* _tmp11_;
	GtkDialog* _tmp12_;
	gint _tmp13_;
	GtkDialog* _tmp18_;
	_tmp0_ = self->priv->_personal_view;
	_tmp2_ = utils_get_selected_row (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	selected_row = _tmp2_;
	_tmp3_ = selected_row;
	if (_tmp3_ == -1) {
		return;
	}
	_tmp4_ = self->priv->_personal_store;
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, GTK_TYPE_TREE_MODEL) ? ((GtkTreeModel*) _tmp4_) : NULL);
	model = _tmp5_;
	_tmp6_ = model;
	_tmp7_ = iter;
	gtk_tree_model_get (_tmp6_, &_tmp7_, BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_LABEL, &label, -1);
	_tmp8_ = self->priv->_dialog;
	_tmp9_ = label;
	_tmp10_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp8_, GTK_DIALOG_DESTROY_WITH_PARENT | GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, _ ("Do you really want to delete the build tool \"%s\"?"), _tmp9_);
	g_object_ref_sink (_tmp10_);
	dialog = (GtkDialog*) _tmp10_;
	_tmp11_ = dialog;
	gtk_dialog_add_buttons (_tmp11_, _ ("_Cancel"), GTK_RESPONSE_CANCEL, _ ("_Delete"), GTK_RESPONSE_YES, NULL);
	_tmp12_ = dialog;
	_tmp13_ = gtk_dialog_run (_tmp12_);
	if (_tmp13_ == ((gint) GTK_RESPONSE_YES)) {
		GtkListStore* _tmp14_;
		GtkTreeIter _tmp15_;
		LatexilaBuildToolsPersonal* _tmp16_;
		gint _tmp17_;
		_tmp14_ = self->priv->_personal_store;
		_tmp15_ = iter;
		gtk_list_store_remove (_tmp14_, &_tmp15_);
		_tmp16_ = latexila_build_tools_personal_get_instance ();
		_tmp17_ = selected_row;
		latexila_build_tools_personal_delete (_tmp16_, (guint) _tmp17_);
	}
	_tmp18_ = dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp18_);
	_g_object_unref0 (dialog);
	_g_object_unref0 (model);
	g_free (label);
}


static void ___lambda125__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda125_ ((BuildToolsPreferences*) self);
}


static GtkToolButton* build_tools_preferences_get_remove_button (BuildToolsPreferences* self) {
	GtkToolButton* result = NULL;
	GtkToolButton* remove_button;
	GtkToolButton* _tmp0_;
	GtkTreeView* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
	g_object_ref_sink (_tmp0_);
	remove_button = _tmp0_;
	gtk_tool_button_set_icon_name (remove_button, "list-remove-symbolic");
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) remove_button, _ ("Remove"));
	_tmp1_ = self->priv->_personal_view;
	build_tools_preferences_set_sensitivity_on_selection (self, _tmp1_, (GtkWidget*) remove_button);
	g_signal_connect_object (remove_button, "clicked", (GCallback) ___lambda125__gtk_tool_button_clicked, self, 0);
	result = remove_button;
	return result;
}


static Block8Data* block8_data_ref (Block8Data* _data8_) {
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}


static void block8_data_unref (void * _userdata_) {
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		BuildToolsPreferences* self;
		self = _data8_->self;
		_g_object_unref0 (_data8_->up_button);
		_g_object_unref0 (self);
		g_slice_free (Block8Data, _data8_);
	}
}


static gpointer _gtk_tree_path_copy0 (gpointer self) {
	return self ? gtk_tree_path_copy (self) : NULL;
}


static void __lambda126_ (Block8Data* _data8_) {
	BuildToolsPreferences* self;
	GList* selected_rows;
	GList* _tmp0_;
	GList* _tmp1_;
	guint _tmp2_;
	GtkTreePath* path_selected;
	GList* _tmp3_;
	gconstpointer _tmp4_;
	GtkTreePath* _tmp5_;
	gint row_num;
	GtkTreePath* _tmp6_;
	gint _tmp7_;
	gint* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	self = _data8_->self;
	_tmp0_ = gtk_tree_selection_get_selected_rows (_data8_->select, NULL);
	selected_rows = _tmp0_;
	_tmp1_ = selected_rows;
	_tmp2_ = g_list_length (_tmp1_);
	if (_tmp2_ == ((guint) 0)) {
		gtk_widget_set_sensitive ((GtkWidget*) _data8_->up_button, FALSE);
		__g_list_free__gtk_tree_path_free0_0 (selected_rows);
		return;
	}
	_tmp3_ = selected_rows;
	_tmp4_ = g_list_nth_data (_tmp3_, (guint) 0);
	_tmp5_ = _gtk_tree_path_copy0 ((GtkTreePath*) _tmp4_);
	path_selected = _tmp5_;
	_tmp6_ = path_selected;
	_tmp8_ = gtk_tree_path_get_indices_with_depth (_tmp6_, &_tmp7_);
	_tmp9_ = _tmp8_[0];
	row_num = _tmp9_;
	_tmp10_ = row_num;
	gtk_widget_set_sensitive ((GtkWidget*) _data8_->up_button, _tmp10_ > 0);
	_gtk_tree_path_free0 (path_selected);
	__g_list_free__gtk_tree_path_free0_0 (selected_rows);
}


static void ___lambda126__gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self) {
	__lambda126_ (self);
}


static void __lambda127_ (Block8Data* _data8_) {
	BuildToolsPreferences* self;
	GtkTreeIter iter_selected = {0};
	gint selected_row;
	GtkTreeView* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gint _tmp2_;
	gint _tmp3_;
	self = _data8_->self;
	_tmp0_ = self->priv->_personal_view;
	_tmp2_ = utils_get_selected_row (_tmp0_, &_tmp1_);
	iter_selected = _tmp1_;
	selected_row = _tmp2_;
	_tmp3_ = selected_row;
	if (_tmp3_ > 0) {
		GtkTreeIter iter_up;
		GtkTreeIter _tmp4_;
		GtkListStore* _tmp5_;
		gboolean _tmp6_;
		_tmp4_ = iter_selected;
		iter_up = _tmp4_;
		_tmp5_ = self->priv->_personal_store;
		_tmp6_ = utils_tree_model_iter_prev ((GtkTreeModel*) _tmp5_, &iter_up);
		if (_tmp6_) {
			GtkListStore* _tmp7_;
			GtkTreeIter _tmp8_;
			GtkTreeIter _tmp9_;
			LatexilaBuildToolsPersonal* _tmp10_;
			gint _tmp11_;
			_tmp7_ = self->priv->_personal_store;
			_tmp8_ = iter_selected;
			_tmp9_ = iter_up;
			gtk_list_store_swap (_tmp7_, &_tmp8_, &_tmp9_);
			_tmp10_ = latexila_build_tools_personal_get_instance ();
			_tmp11_ = selected_row;
			latexila_build_tools_personal_move_up (_tmp10_, (guint) _tmp11_);
			g_signal_emit_by_name (_data8_->select, "changed");
		}
	}
}


static void ___lambda127__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda127_ (self);
}


static GtkToolButton* build_tools_preferences_get_up_button (BuildToolsPreferences* self) {
	GtkToolButton* result = NULL;
	Block8Data* _data8_;
	GtkToolButton* _tmp0_;
	GtkTreeView* _tmp1_;
	GtkTreeSelection* _tmp2_;
	GtkToolButton* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_data8_ = g_slice_new0 (Block8Data);
	_data8_->_ref_count_ = 1;
	_data8_->self = g_object_ref (self);
	_tmp0_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
	g_object_ref_sink (_tmp0_);
	_data8_->up_button = _tmp0_;
	gtk_tool_button_set_icon_name (_data8_->up_button, "go-up-symbolic");
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) _data8_->up_button, _ ("Move up"));
	gtk_widget_set_sensitive ((GtkWidget*) _data8_->up_button, FALSE);
	_tmp1_ = self->priv->_personal_view;
	_tmp2_ = gtk_tree_view_get_selection (_tmp1_);
	_data8_->select = _tmp2_;
	g_signal_connect_data (_data8_->select, "changed", (GCallback) ___lambda126__gtk_tree_selection_changed, block8_data_ref (_data8_), (GClosureNotify) block8_data_unref, 0);
	g_signal_connect_data (_data8_->up_button, "clicked", (GCallback) ___lambda127__gtk_tool_button_clicked, block8_data_ref (_data8_), (GClosureNotify) block8_data_unref, 0);
	_tmp3_ = _g_object_ref0 (_data8_->up_button);
	result = _tmp3_;
	block8_data_unref (_data8_);
	_data8_ = NULL;
	return result;
}


static Block9Data* block9_data_ref (Block9Data* _data9_) {
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}


static void block9_data_unref (void * _userdata_) {
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		BuildToolsPreferences* self;
		self = _data9_->self;
		_g_object_unref0 (_data9_->down_button);
		_g_object_unref0 (self);
		g_slice_free (Block9Data, _data9_);
	}
}


static void __lambda128_ (Block9Data* _data9_) {
	BuildToolsPreferences* self;
	GList* selected_rows;
	GList* _tmp0_;
	GList* _tmp1_;
	guint _tmp2_;
	GtkTreePath* path_selected;
	GList* _tmp3_;
	gconstpointer _tmp4_;
	GtkTreePath* _tmp5_;
	gint row_num;
	GtkTreePath* _tmp6_;
	gint _tmp7_;
	gint* _tmp8_;
	gint _tmp9_;
	GtkTreeModel* model;
	GtkListStore* _tmp10_;
	GtkTreeModel* _tmp11_;
	gint nb_rows;
	GtkTreeModel* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	self = _data9_->self;
	_tmp0_ = gtk_tree_selection_get_selected_rows (_data9_->select, NULL);
	selected_rows = _tmp0_;
	_tmp1_ = selected_rows;
	_tmp2_ = g_list_length (_tmp1_);
	if (_tmp2_ == ((guint) 0)) {
		gtk_widget_set_sensitive ((GtkWidget*) _data9_->down_button, FALSE);
		__g_list_free__gtk_tree_path_free0_0 (selected_rows);
		return;
	}
	_tmp3_ = selected_rows;
	_tmp4_ = g_list_nth_data (_tmp3_, (guint) 0);
	_tmp5_ = _gtk_tree_path_copy0 ((GtkTreePath*) _tmp4_);
	path_selected = _tmp5_;
	_tmp6_ = path_selected;
	_tmp8_ = gtk_tree_path_get_indices_with_depth (_tmp6_, &_tmp7_);
	_tmp9_ = _tmp8_[0];
	row_num = _tmp9_;
	_tmp10_ = self->priv->_personal_store;
	_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, GTK_TYPE_TREE_MODEL) ? ((GtkTreeModel*) _tmp10_) : NULL);
	model = _tmp11_;
	_tmp12_ = model;
	_tmp13_ = gtk_tree_model_iter_n_children (_tmp12_, NULL);
	nb_rows = _tmp13_;
	_tmp14_ = row_num;
	_tmp15_ = nb_rows;
	gtk_widget_set_sensitive ((GtkWidget*) _data9_->down_button, _tmp14_ < (_tmp15_ - 1));
	_g_object_unref0 (model);
	_gtk_tree_path_free0 (path_selected);
	__g_list_free__gtk_tree_path_free0_0 (selected_rows);
}


static void ___lambda128__gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self) {
	__lambda128_ (self);
}


static void __lambda129_ (Block9Data* _data9_) {
	BuildToolsPreferences* self;
	GtkTreeIter iter_selected = {0};
	gint selected_row;
	GtkTreeView* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gint _tmp2_;
	gint _tmp3_;
	self = _data9_->self;
	_tmp0_ = self->priv->_personal_view;
	_tmp2_ = utils_get_selected_row (_tmp0_, &_tmp1_);
	iter_selected = _tmp1_;
	selected_row = _tmp2_;
	_tmp3_ = selected_row;
	if (_tmp3_ >= 0) {
		GtkTreeIter iter_down;
		GtkTreeIter _tmp4_;
		GtkListStore* _tmp5_;
		gboolean _tmp6_;
		_tmp4_ = iter_selected;
		iter_down = _tmp4_;
		_tmp5_ = self->priv->_personal_store;
		_tmp6_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp5_, &iter_down);
		if (_tmp6_) {
			GtkListStore* _tmp7_;
			GtkTreeIter _tmp8_;
			GtkTreeIter _tmp9_;
			LatexilaBuildToolsPersonal* _tmp10_;
			gint _tmp11_;
			_tmp7_ = self->priv->_personal_store;
			_tmp8_ = iter_selected;
			_tmp9_ = iter_down;
			gtk_list_store_swap (_tmp7_, &_tmp8_, &_tmp9_);
			_tmp10_ = latexila_build_tools_personal_get_instance ();
			_tmp11_ = selected_row;
			latexila_build_tools_personal_move_down (_tmp10_, (guint) _tmp11_);
			g_signal_emit_by_name (_data9_->select, "changed");
		}
	}
}


static void ___lambda129__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda129_ (self);
}


static GtkToolButton* build_tools_preferences_get_down_button (BuildToolsPreferences* self) {
	GtkToolButton* result = NULL;
	Block9Data* _data9_;
	GtkToolButton* _tmp0_;
	GtkTreeView* _tmp1_;
	GtkTreeSelection* _tmp2_;
	GtkToolButton* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_data9_ = g_slice_new0 (Block9Data);
	_data9_->_ref_count_ = 1;
	_data9_->self = g_object_ref (self);
	_tmp0_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
	g_object_ref_sink (_tmp0_);
	_data9_->down_button = _tmp0_;
	gtk_tool_button_set_icon_name (_data9_->down_button, "go-down-symbolic");
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) _data9_->down_button, _ ("Move down"));
	gtk_widget_set_sensitive ((GtkWidget*) _data9_->down_button, FALSE);
	_tmp1_ = self->priv->_personal_view;
	_tmp2_ = gtk_tree_view_get_selection (_tmp1_);
	_data9_->select = _tmp2_;
	g_signal_connect_data (_data9_->select, "changed", (GCallback) ___lambda128__gtk_tree_selection_changed, block9_data_ref (_data9_), (GClosureNotify) block9_data_unref, 0);
	g_signal_connect_data (_data9_->down_button, "clicked", (GCallback) ___lambda129__gtk_tool_button_clicked, block9_data_ref (_data9_), (GClosureNotify) block9_data_unref, 0);
	_tmp3_ = _g_object_ref0 (_data9_->down_button);
	result = _tmp3_;
	block9_data_unref (_data9_);
	_data9_ = NULL;
	return result;
}


static void build_tools_preferences_update_default_store (BuildToolsPreferences* self) {
	GtkListStore* _tmp0_;
	LatexilaBuildToolsDefault* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_default_store;
	_tmp1_ = latexila_build_tools_default_get_instance ();
	build_tools_preferences_update_store (self, _tmp0_, (LatexilaBuildTools*) _tmp1_);
}


static void build_tools_preferences_update_personal_store (BuildToolsPreferences* self) {
	GtkListStore* _tmp0_;
	LatexilaBuildToolsPersonal* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_personal_store;
	_tmp1_ = latexila_build_tools_personal_get_instance ();
	build_tools_preferences_update_store (self, _tmp0_, (LatexilaBuildTools*) _tmp1_);
}


static void build_tools_preferences_update_store (BuildToolsPreferences* self, GtkListStore* store, LatexilaBuildTools* build_tools) {
	GtkListStore* _tmp0_;
	LatexilaBuildTools* _tmp1_;
	GList* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	g_return_if_fail (build_tools != NULL);
	_tmp0_ = store;
	gtk_list_store_clear (_tmp0_);
	_tmp1_ = build_tools;
	_tmp2_ = _tmp1_->build_tools;
	{
		GList* tool_collection = NULL;
		GList* tool_it = NULL;
		tool_collection = _tmp2_;
		for (tool_it = tool_collection; tool_it != NULL; tool_it = tool_it->next) {
			LatexilaBuildTool* _tmp3_;
			LatexilaBuildTool* tool = NULL;
			_tmp3_ = _g_object_ref0 ((LatexilaBuildTool*) tool_it->data);
			tool = _tmp3_;
			{
				gchar* description;
				LatexilaBuildTool* _tmp4_;
				const gchar* _tmp5_;
				gchar* _tmp6_;
				GtkTreeIter iter = {0};
				GtkListStore* _tmp7_;
				GtkTreeIter _tmp8_ = {0};
				GtkListStore* _tmp9_;
				GtkTreeIter _tmp10_;
				LatexilaBuildTool* _tmp11_;
				gboolean _tmp12_;
				gboolean _tmp13_;
				LatexilaBuildTool* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				LatexilaBuildTool* _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				const gchar* _tmp22_;
				_tmp4_ = tool;
				_tmp5_ = latexila_build_tool_get_description (_tmp4_);
				_tmp6_ = g_markup_escape_text (_tmp5_, (gssize) -1);
				description = _tmp6_;
				_tmp7_ = store;
				gtk_list_store_append (_tmp7_, &_tmp8_);
				iter = _tmp8_;
				_tmp9_ = store;
				_tmp10_ = iter;
				_tmp11_ = tool;
				g_object_get (_tmp11_, "enabled", &_tmp12_, NULL);
				_tmp13_ = _tmp12_;
				_tmp14_ = tool;
				g_object_get (_tmp14_, "icon", &_tmp15_, NULL);
				_tmp16_ = _tmp15_;
				_tmp17_ = _tmp16_;
				_tmp18_ = tool;
				g_object_get (_tmp18_, "label", &_tmp19_, NULL);
				_tmp20_ = _tmp19_;
				_tmp21_ = _tmp20_;
				_tmp22_ = description;
				gtk_list_store_set (_tmp9_, &_tmp10_, BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_ENABLED, _tmp13_, BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_PIXBUF, _tmp17_, BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_LABEL, _tmp21_, BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_DESCRIPTION, _tmp22_, -1);
				g_free (_tmp21_);
				g_free (_tmp17_);
				g_free (description);
				_g_object_unref0 (tool);
			}
		}
	}
}


static void build_tools_preferences_open_build_tool (BuildToolsPreferences* self, LatexilaBuildTools* build_tools, gint build_tool_num) {
	gboolean editable;
	LatexilaBuildTools* _tmp0_;
	BuildToolDialog* dialog;
	GtkDialog* _tmp1_;
	gboolean _tmp2_;
	BuildToolDialog* _tmp3_;
	gboolean edited;
	BuildToolDialog* _tmp4_;
	LatexilaBuildTools* _tmp5_;
	gint _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (build_tools != NULL);
	_tmp0_ = build_tools;
	editable = G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, latexila_build_tools_personal_get_type ());
	_tmp1_ = self->priv->_dialog;
	_tmp2_ = editable;
	_tmp3_ = build_tool_dialog_new ((GtkWindow*) _tmp1_, _tmp2_);
	dialog = _tmp3_;
	_tmp4_ = dialog;
	_tmp5_ = build_tools;
	_tmp6_ = build_tool_num;
	_tmp7_ = build_tool_dialog_open_build_tool (_tmp4_, _tmp5_, _tmp6_);
	edited = _tmp7_;
	_tmp8_ = edited;
	if (_tmp8_) {
		build_tools_preferences_update_personal_store (self);
	}
	_g_object_unref0 (dialog);
}


static Block10Data* block10_data_ref (Block10Data* _data10_) {
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}


static void block10_data_unref (void * _userdata_) {
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		BuildToolsPreferences* self;
		self = _data10_->self;
		_g_object_unref0 (_data10_->widget);
		_g_object_unref0 (self);
		g_slice_free (Block10Data, _data10_);
	}
}


static void __lambda121_ (Block10Data* _data10_) {
	BuildToolsPreferences* self;
	gboolean row_selected;
	gint _tmp0_;
	GtkWidget* _tmp1_;
	self = _data10_->self;
	_tmp0_ = gtk_tree_selection_count_selected_rows (_data10_->select);
	row_selected = _tmp0_ > 0;
	_tmp1_ = _data10_->widget;
	gtk_widget_set_sensitive (_tmp1_, row_selected);
}


static void ___lambda121__gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self) {
	__lambda121_ (self);
}


static void build_tools_preferences_set_sensitivity_on_selection (BuildToolsPreferences* self, GtkTreeView* view, GtkWidget* widget) {
	Block10Data* _data10_;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	GtkTreeView* _tmp3_;
	GtkTreeSelection* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (view != NULL);
	g_return_if_fail (widget != NULL);
	_data10_ = g_slice_new0 (Block10Data);
	_data10_->_ref_count_ = 1;
	_data10_->self = g_object_ref (self);
	_tmp0_ = widget;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data10_->widget);
	_data10_->widget = _tmp1_;
	_tmp2_ = _data10_->widget;
	gtk_widget_set_sensitive (_tmp2_, FALSE);
	_tmp3_ = view;
	_tmp4_ = gtk_tree_view_get_selection (_tmp3_);
	_data10_->select = _tmp4_;
	g_signal_connect_data (_data10_->select, "changed", (GCallback) ___lambda121__gtk_tree_selection_changed, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
	block10_data_unref (_data10_);
	_data10_ = NULL;
}


static void build_tools_preferences_class_init (BuildToolsPreferencesClass * klass) {
	build_tools_preferences_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BuildToolsPreferencesPrivate));
	G_OBJECT_CLASS (klass)->finalize = build_tools_preferences_finalize;
}


static void build_tools_preferences_instance_init (BuildToolsPreferences * self) {
	self->priv = BUILD_TOOLS_PREFERENCES_GET_PRIVATE (self);
}


static void build_tools_preferences_finalize (GObject * obj) {
	BuildToolsPreferences * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BUILD_TOOLS_PREFERENCES, BuildToolsPreferences);
	_g_object_unref0 (self->priv->_dialog);
	_g_object_unref0 (self->priv->_default_store);
	_g_object_unref0 (self->priv->_personal_store);
	_g_object_unref0 (self->priv->_default_view);
	_g_object_unref0 (self->priv->_personal_view);
	G_OBJECT_CLASS (build_tools_preferences_parent_class)->finalize (obj);
}


GType build_tools_preferences_get_type (void) {
	static volatile gsize build_tools_preferences_type_id__volatile = 0;
	if (g_once_init_enter (&build_tools_preferences_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BuildToolsPreferencesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) build_tools_preferences_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BuildToolsPreferences), 0, (GInstanceInitFunc) build_tools_preferences_instance_init, NULL };
		GType build_tools_preferences_type_id;
		build_tools_preferences_type_id = g_type_register_static (G_TYPE_OBJECT, "BuildToolsPreferences", &g_define_type_info, 0);
		g_once_init_leave (&build_tools_preferences_type_id__volatile, build_tools_preferences_type_id);
	}
	return build_tools_preferences_type_id__volatile;
}



