; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt -S  -dxil-intrinsic-expansion -dxil-op-lower  -mtriple=dxil-pc-shadermodel6.3-library %s | FileCheck %s


define noundef i32 @sign_half(half noundef %a) {
; CHECK-LABEL: define noundef i32 @sign_half(
; CHECK-SAME: half noundef [[A:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[TMP0:%.*]] = fcmp olt half 0xH0000, [[A]]
; CHECK-NEXT:    [[TMP1:%.*]] = fcmp olt half [[A]], 0xH0000
; CHECK-NEXT:    [[TMP2:%.*]] = zext i1 [[TMP0]] to i32
; CHECK-NEXT:    [[TMP3:%.*]] = zext i1 [[TMP1]] to i32
; CHECK-NEXT:    [[TMP4:%.*]] = sub i32 [[TMP2]], [[TMP3]]
; CHECK-NEXT:    ret i32 [[TMP4]]
;
entry:
  %elt.sign = call i32 @llvm.dx.sign.f16(half %a)
  ret i32 %elt.sign
}

define noundef i32 @sign_float(float noundef %a) {
; CHECK-LABEL: define noundef i32 @sign_float(
; CHECK-SAME: float noundef [[A:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[TMP0:%.*]] = fcmp olt float 0.000000e+00, [[A]]
; CHECK-NEXT:    [[TMP1:%.*]] = fcmp olt float [[A]], 0.000000e+00
; CHECK-NEXT:    [[TMP2:%.*]] = zext i1 [[TMP0]] to i32
; CHECK-NEXT:    [[TMP3:%.*]] = zext i1 [[TMP1]] to i32
; CHECK-NEXT:    [[TMP4:%.*]] = sub i32 [[TMP2]], [[TMP3]]
; CHECK-NEXT:    ret i32 [[TMP4]]
;
entry:
  %elt.sign = call i32 @llvm.dx.sign.f32(float %a)
  ret i32 %elt.sign
}

define noundef i32 @sign_double(double noundef %a) {
; CHECK-LABEL: define noundef i32 @sign_double(
; CHECK-SAME: double noundef [[A:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[TMP0:%.*]] = fcmp olt double 0.000000e+00, [[A]]
; CHECK-NEXT:    [[TMP1:%.*]] = fcmp olt double [[A]], 0.000000e+00
; CHECK-NEXT:    [[TMP2:%.*]] = zext i1 [[TMP0]] to i32
; CHECK-NEXT:    [[TMP3:%.*]] = zext i1 [[TMP1]] to i32
; CHECK-NEXT:    [[TMP4:%.*]] = sub i32 [[TMP2]], [[TMP3]]
; CHECK-NEXT:    ret i32 [[TMP4]]
;
entry:
  %elt.sign = call i32 @llvm.dx.sign.f64(double %a)
  ret i32 %elt.sign
}

define noundef i32 @sign_i16(i16 noundef %a) {
; CHECK-LABEL: define noundef i32 @sign_i16(
; CHECK-SAME: i16 noundef [[A:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[TMP0:%.*]] = icmp slt i16 0, [[A]]
; CHECK-NEXT:    [[TMP1:%.*]] = icmp slt i16 [[A]], 0
; CHECK-NEXT:    [[TMP2:%.*]] = zext i1 [[TMP0]] to i32
; CHECK-NEXT:    [[TMP3:%.*]] = zext i1 [[TMP1]] to i32
; CHECK-NEXT:    [[TMP4:%.*]] = sub i32 [[TMP2]], [[TMP3]]
; CHECK-NEXT:    ret i32 [[TMP4]]
;
entry:
  %elt.sign = call i32 @llvm.dx.sign.i16(i16 %a)
  ret i32 %elt.sign
}

define noundef i32 @sign_i32(i32 noundef %a) {
; CHECK-LABEL: define noundef i32 @sign_i32(
; CHECK-SAME: i32 noundef [[A:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[TMP0:%.*]] = icmp slt i32 0, [[A]]
; CHECK-NEXT:    [[TMP1:%.*]] = icmp slt i32 [[A]], 0
; CHECK-NEXT:    [[TMP2:%.*]] = zext i1 [[TMP0]] to i32
; CHECK-NEXT:    [[TMP3:%.*]] = zext i1 [[TMP1]] to i32
; CHECK-NEXT:    [[TMP4:%.*]] = sub i32 [[TMP2]], [[TMP3]]
; CHECK-NEXT:    ret i32 [[TMP4]]
;
entry:
  %elt.sign = call i32 @llvm.dx.sign.i32(i32 %a)
  ret i32 %elt.sign
}

define noundef i32 @sign_i64(i64 noundef %a) {
; CHECK-LABEL: define noundef i32 @sign_i64(
; CHECK-SAME: i64 noundef [[A:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[TMP0:%.*]] = icmp slt i64 0, [[A]]
; CHECK-NEXT:    [[TMP1:%.*]] = icmp slt i64 [[A]], 0
; CHECK-NEXT:    [[TMP2:%.*]] = zext i1 [[TMP0]] to i32
; CHECK-NEXT:    [[TMP3:%.*]] = zext i1 [[TMP1]] to i32
; CHECK-NEXT:    [[TMP4:%.*]] = sub i32 [[TMP2]], [[TMP3]]
; CHECK-NEXT:    ret i32 [[TMP4]]
;
entry:
  %elt.sign = call i32 @llvm.dx.sign.i64(i64 %a)
  ret i32 %elt.sign
}

define noundef <4 x i32> @sign_half_vector(<4 x half> noundef %a) {
; CHECK-LABEL: define noundef <4 x i32> @sign_half_vector(
; CHECK-SAME: <4 x half> noundef [[A:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[TMP0:%.*]] = fcmp olt <4 x half> zeroinitializer, [[A]]
; CHECK-NEXT:    [[TMP1:%.*]] = fcmp olt <4 x half> [[A]], zeroinitializer
; CHECK-NEXT:    [[TMP2:%.*]] = zext <4 x i1> [[TMP0]] to <4 x i32>
; CHECK-NEXT:    [[TMP3:%.*]] = zext <4 x i1> [[TMP1]] to <4 x i32>
; CHECK-NEXT:    [[TMP4:%.*]] = sub <4 x i32> [[TMP2]], [[TMP3]]
; CHECK-NEXT:    ret <4 x i32> [[TMP4]]
;
entry:
  %elt.sign = call <4 x i32> @llvm.dx.sign.v4f16(<4 x half> %a)
  ret <4 x i32> %elt.sign
}

define noundef <4 x i32> @sign_float_vector(<4 x float> noundef %a) {
; CHECK-LABEL: define noundef <4 x i32> @sign_float_vector(
; CHECK-SAME: <4 x float> noundef [[A:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[TMP0:%.*]] = fcmp olt <4 x float> zeroinitializer, [[A]]
; CHECK-NEXT:    [[TMP1:%.*]] = fcmp olt <4 x float> [[A]], zeroinitializer
; CHECK-NEXT:    [[TMP2:%.*]] = zext <4 x i1> [[TMP0]] to <4 x i32>
; CHECK-NEXT:    [[TMP3:%.*]] = zext <4 x i1> [[TMP1]] to <4 x i32>
; CHECK-NEXT:    [[TMP4:%.*]] = sub <4 x i32> [[TMP2]], [[TMP3]]
; CHECK-NEXT:    ret <4 x i32> [[TMP4]]
;
entry:
  %elt.sign = call <4 x i32> @llvm.dx.sign.v4f32(<4 x float> %a)
  ret <4 x i32> %elt.sign
}

define noundef <4 x i32> @sign_double_vector(<4 x double> noundef %a) {
; CHECK-LABEL: define noundef <4 x i32> @sign_double_vector(
; CHECK-SAME: <4 x double> noundef [[A:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[TMP0:%.*]] = fcmp olt <4 x double> zeroinitializer, [[A]]
; CHECK-NEXT:    [[TMP1:%.*]] = fcmp olt <4 x double> [[A]], zeroinitializer
; CHECK-NEXT:    [[TMP2:%.*]] = zext <4 x i1> [[TMP0]] to <4 x i32>
; CHECK-NEXT:    [[TMP3:%.*]] = zext <4 x i1> [[TMP1]] to <4 x i32>
; CHECK-NEXT:    [[TMP4:%.*]] = sub <4 x i32> [[TMP2]], [[TMP3]]
; CHECK-NEXT:    ret <4 x i32> [[TMP4]]
;
entry:
  %elt.sign = call <4 x i32> @llvm.dx.sign.v4f64(<4 x double> %a)
  ret <4 x i32> %elt.sign
}

define noundef <4 x i32> @sign_i16_vector(<4 x i16> noundef %a) {
; CHECK-LABEL: define noundef <4 x i32> @sign_i16_vector(
; CHECK-SAME: <4 x i16> noundef [[A:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[TMP0:%.*]] = icmp slt <4 x i16> zeroinitializer, [[A]]
; CHECK-NEXT:    [[TMP1:%.*]] = icmp slt <4 x i16> [[A]], zeroinitializer
; CHECK-NEXT:    [[TMP2:%.*]] = zext <4 x i1> [[TMP0]] to <4 x i32>
; CHECK-NEXT:    [[TMP3:%.*]] = zext <4 x i1> [[TMP1]] to <4 x i32>
; CHECK-NEXT:    [[TMP4:%.*]] = sub <4 x i32> [[TMP2]], [[TMP3]]
; CHECK-NEXT:    ret <4 x i32> [[TMP4]]
;
entry:
  %elt.sign = call <4 x i32> @llvm.dx.sign.v4i16(<4 x i16> %a)
  ret <4 x i32> %elt.sign
}

define noundef <4 x i32> @sign_i32_vector(<4 x i32> noundef %a) {
; CHECK-LABEL: define noundef <4 x i32> @sign_i32_vector(
; CHECK-SAME: <4 x i32> noundef [[A:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[TMP0:%.*]] = icmp slt <4 x i32> zeroinitializer, [[A]]
; CHECK-NEXT:    [[TMP1:%.*]] = icmp slt <4 x i32> [[A]], zeroinitializer
; CHECK-NEXT:    [[TMP2:%.*]] = zext <4 x i1> [[TMP0]] to <4 x i32>
; CHECK-NEXT:    [[TMP3:%.*]] = zext <4 x i1> [[TMP1]] to <4 x i32>
; CHECK-NEXT:    [[TMP4:%.*]] = sub <4 x i32> [[TMP2]], [[TMP3]]
; CHECK-NEXT:    ret <4 x i32> [[TMP4]]
;
entry:
  %elt.sign = call <4 x i32> @llvm.dx.sign.v4i32(<4 x i32> %a)
  ret <4 x i32> %elt.sign
}

define noundef <4 x i32> @sign_i64_vector(<4 x i64> noundef %a) {
; CHECK-LABEL: define noundef <4 x i32> @sign_i64_vector(
; CHECK-SAME: <4 x i64> noundef [[A:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[TMP0:%.*]] = icmp slt <4 x i64> zeroinitializer, [[A]]
; CHECK-NEXT:    [[TMP1:%.*]] = icmp slt <4 x i64> [[A]], zeroinitializer
; CHECK-NEXT:    [[TMP2:%.*]] = zext <4 x i1> [[TMP0]] to <4 x i32>
; CHECK-NEXT:    [[TMP3:%.*]] = zext <4 x i1> [[TMP1]] to <4 x i32>
; CHECK-NEXT:    [[TMP4:%.*]] = sub <4 x i32> [[TMP2]], [[TMP3]]
; CHECK-NEXT:    ret <4 x i32> [[TMP4]]
;
entry:
  %elt.sign = call <4 x i32> @llvm.dx.sign.v4i64(<4 x i64> %a)
  ret <4 x i32> %elt.sign
}


declare i32 @llvm.dx.sign.f16(half)
declare i32 @llvm.dx.sign.f32(float)
declare i32 @llvm.dx.sign.f64(double)

declare i32 @llvm.dx.sign.i16(i16)
declare i32 @llvm.dx.sign.i32(i32)
declare i32 @llvm.dx.sign.i64(i64)

declare <4 x i32> @llvm.dx.sign.v4f16(<4 x half>)
declare <4 x i32> @llvm.dx.sign.v4f32(<4 x float>)
declare <4 x i32> @llvm.dx.sign.v4f64(<4 x double>)

declare <4 x i32> @llvm.dx.sign.v4i16(<4 x i16>)
declare <4 x i32> @llvm.dx.sign.v4i32(<4 x i32>)
declare <4 x i32> @llvm.dx.sign.v4i64(<4 x i64>)
