; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN:  sed 's/iXLen/i32/g' %s | llc -mtriple=riscv32 -mattr=+v,+zvfh,+xsfvcp \
; RUN:    -verify-machineinstrs | FileCheck %s
; RUN:  sed 's/iXLen/i64/g' %s | llc -mtriple=riscv64 -mattr=+v,+zvfh,+xsfvcp \
; RUN:    -verify-machineinstrs | FileCheck %s

define void @test_sf_vc_vvv_se_e8mf8(<1 x i8> %vd, <1 x i8> %vs2, <1 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vvv_se_e8mf8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    sf.vc.vvv 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv1i8.nxv1i8.iXLen(iXLen 3, <1 x i8> %vd, <1 x i8> %vs2, <1 x i8> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv1i8.nxv1i8.iXLen(iXLen, <1 x i8>, <1 x i8>, <1 x i8>, iXLen)

define void @test_sf_vc_vvv_se_e8mf4(<2 x i8> %vd, <2 x i8> %vs2, <2 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vvv_se_e8mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    sf.vc.vvv 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv2i8.nxv2i8.iXLen(iXLen 3, <2 x i8> %vd, <2 x i8> %vs2, <2 x i8> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv2i8.nxv2i8.iXLen(iXLen, <2 x i8>, <2 x i8>, <2 x i8>, iXLen)

define void @test_sf_vc_vvv_se_e8mf2(<4 x i8> %vd, <4 x i8> %vs2, <4 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vvv_se_e8mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf4, ta, ma
; CHECK-NEXT:    sf.vc.vvv 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv4i8.nxv4i8.iXLen(iXLen 3, <4 x i8> %vd, <4 x i8> %vs2, <4 x i8> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv4i8.nxv4i8.iXLen(iXLen, <4 x i8>, <4 x i8>, <4 x i8>, iXLen)

define void @test_sf_vc_vvv_se_e8m1(<8 x i8> %vd, <8 x i8> %vs2, <8 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vvv_se_e8m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; CHECK-NEXT:    sf.vc.vvv 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv8i8.nxv8i8.iXLen(iXLen 3, <8 x i8> %vd, <8 x i8> %vs2, <8 x i8> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv8i8.nxv8i8.iXLen(iXLen, <8 x i8>, <8 x i8>, <8 x i8>, iXLen)

define void @test_sf_vc_vvv_se_e8m2(<16 x i8> %vd, <16 x i8> %vs2, <16 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vvv_se_e8m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    sf.vc.vvv 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv16i8.nxv16i8.iXLen(iXLen 3, <16 x i8> %vd, <16 x i8> %vs2, <16 x i8> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv16i8.nxv16i8.iXLen(iXLen, <16 x i8>, <16 x i8>, <16 x i8>, iXLen)

define void @test_sf_vc_vvv_se_e8m4(<32 x i8> %vd, <32 x i8> %vs2, <32 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vvv_se_e8m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m2, ta, ma
; CHECK-NEXT:    sf.vc.vvv 3, v8, v10, v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv32i8.nxv32i8.iXLen(iXLen 3, <32 x i8> %vd, <32 x i8> %vs2, <32 x i8> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv32i8.nxv32i8.iXLen(iXLen, <32 x i8>, <32 x i8>, <32 x i8>, iXLen)

define void @test_sf_vc_vvv_se_e8m8(<64 x i8> %vd, <64 x i8> %vs2, <64 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vvv_se_e8m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m4, ta, ma
; CHECK-NEXT:    sf.vc.vvv 3, v8, v12, v16
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv64i8.nxv64i8.iXLen(iXLen 3, <64 x i8> %vd, <64 x i8> %vs2, <64 x i8> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv64i8.nxv64i8.iXLen(iXLen, <64 x i8>, <64 x i8>, <64 x i8>, iXLen)

define void @test_sf_vc_vvv_se_e16mf4(<1 x i16> %vd, <1 x i16> %vs2, <1 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vvv_se_e16mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-NEXT:    sf.vc.vvv 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv1i16.nxv1i16.iXLen(iXLen 3, <1 x i16> %vd, <1 x i16> %vs2, <1 x i16> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv1i16.nxv1i16.iXLen(iXLen, <1 x i16>, <1 x i16>, <1 x i16>, iXLen)

define void @test_sf_vc_vvv_se_e16mf2(<2 x i16> %vd, <2 x i16> %vs2, <2 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vvv_se_e16mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-NEXT:    sf.vc.vvv 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv2i16.nxv2i16.iXLen(iXLen 3, <2 x i16> %vd, <2 x i16> %vs2, <2 x i16> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv2i16.nxv2i16.iXLen(iXLen, <2 x i16>, <2 x i16>, <2 x i16>, iXLen)

define void @test_sf_vc_vvv_se_e16m1(<4 x i16> %vd, <4 x i16> %vs2, <4 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vvv_se_e16m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; CHECK-NEXT:    sf.vc.vvv 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv4i16.nxv4i16.iXLen(iXLen 3, <4 x i16> %vd, <4 x i16> %vs2, <4 x i16> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv4i16.nxv4i16.iXLen(iXLen, <4 x i16>, <4 x i16>, <4 x i16>, iXLen)

define void @test_sf_vc_vvv_se_e16m2(<8 x i16> %vd, <8 x i16> %vs2, <8 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vvv_se_e16m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    sf.vc.vvv 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv8i16.nxv8i16.iXLen(iXLen 3, <8 x i16> %vd, <8 x i16> %vs2, <8 x i16> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv8i16.nxv8i16.iXLen(iXLen, <8 x i16>, <8 x i16>, <8 x i16>, iXLen)

define void @test_sf_vc_vvv_se_e16m4(<16 x i16> %vd, <16 x i16> %vs2, <16 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vvv_se_e16m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; CHECK-NEXT:    sf.vc.vvv 3, v8, v10, v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv16i16.nxv16i16.iXLen(iXLen 3, <16 x i16> %vd, <16 x i16> %vs2, <16 x i16> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv16i16.nxv16i16.iXLen(iXLen, <16 x i16>, <16 x i16>, <16 x i16>, iXLen)

define void @test_sf_vc_vvv_se_e16m8(<32 x i16> %vd, <32 x i16> %vs2, <32 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vvv_se_e16m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    sf.vc.vvv 3, v8, v12, v16
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv32i16.nxv32i16.iXLen(iXLen 3, <32 x i16> %vd, <32 x i16> %vs2, <32 x i16> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv32i16.nxv32i16.iXLen(iXLen, <32 x i16>, <32 x i16>, <32 x i16>, iXLen)

define void @test_sf_vc_vvv_se_e32mf2(<1 x i32> %vd, <1 x i32> %vs2, <1 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vvv_se_e32mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    sf.vc.vvv 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv1i32.nxv1i32.iXLen(iXLen 3, <1 x i32> %vd, <1 x i32> %vs2, <1 x i32> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv1i32.nxv1i32.iXLen(iXLen, <1 x i32>, <1 x i32>, <1 x i32>, iXLen)

define void @test_sf_vc_vvv_se_e32m1(<2 x i32> %vd, <2 x i32> %vs2, <2 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vvv_se_e32m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    sf.vc.vvv 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv2i32.nxv2i32.iXLen(iXLen 3, <2 x i32> %vd, <2 x i32> %vs2, <2 x i32> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv2i32.nxv2i32.iXLen(iXLen, <2 x i32>, <2 x i32>, <2 x i32>, iXLen)

define void @test_sf_vc_vvv_se_e32m2(<4 x i32> %vd, <4 x i32> %vs2, <4 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vvv_se_e32m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; CHECK-NEXT:    sf.vc.vvv 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv4i32.nxv4i32.iXLen(iXLen 3, <4 x i32> %vd, <4 x i32> %vs2, <4 x i32> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv4i32.nxv4i32.iXLen(iXLen, <4 x i32>, <4 x i32>, <4 x i32>, iXLen)

define void @test_sf_vc_vvv_se_e32m4(<8 x i32> %vd, <8 x i32> %vs2, <8 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vvv_se_e32m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; CHECK-NEXT:    sf.vc.vvv 3, v8, v10, v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv8i32.nxv8i32.iXLen(iXLen 3, <8 x i32> %vd, <8 x i32> %vs2, <8 x i32> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv8i32.nxv8i32.iXLen(iXLen, <8 x i32>, <8 x i32>, <8 x i32>, iXLen)

define void @test_sf_vc_vvv_se_e32m8(<16 x i32> %vd, <16 x i32> %vs2, <16 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vvv_se_e32m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    sf.vc.vvv 3, v8, v12, v16
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv16i32.nxv16i32.iXLen(iXLen 3, <16 x i32> %vd, <16 x i32> %vs2, <16 x i32> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv16i32.nxv16i32.iXLen(iXLen, <16 x i32>, <16 x i32>, <16 x i32>, iXLen)

define void @test_sf_vc_vvv_se_e64m1(<1 x i64> %vd, <1 x i64> %vs2, <1 x i64> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vvv_se_e64m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    sf.vc.vvv 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv1i64.nxv1i64.iXLen(iXLen 3, <1 x i64> %vd, <1 x i64> %vs2, <1 x i64> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv1i64.nxv1i64.iXLen(iXLen, <1 x i64>, <1 x i64>, <1 x i64>, iXLen)

define void @test_sf_vc_vvv_se_e64m2(<2 x i64> %vd, <2 x i64> %vs2, <2 x i64> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vvv_se_e64m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    sf.vc.vvv 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv2i64.nxv2i64.iXLen(iXLen 3, <2 x i64> %vd, <2 x i64> %vs2, <2 x i64> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv2i64.nxv2i64.iXLen(iXLen, <2 x i64>, <2 x i64>, <2 x i64>, iXLen)

define void @test_sf_vc_vvv_se_e64m4(<4 x i64> %vd, <4 x i64> %vs2, <4 x i64> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vvv_se_e64m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; CHECK-NEXT:    sf.vc.vvv 3, v8, v10, v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv4i64.nxv4i64.iXLen(iXLen 3, <4 x i64> %vd, <4 x i64> %vs2, <4 x i64> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv4i64.nxv4i64.iXLen(iXLen, <4 x i64>, <4 x i64>, <4 x i64>, iXLen)

define void @test_sf_vc_vvv_se_e64m8(<8 x i64> %vd, <8 x i64> %vs2, <8 x i64> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vvv_se_e64m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    sf.vc.vvv 3, v8, v12, v16
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv8i64.nxv8i64.iXLen(iXLen 3, <8 x i64> %vd, <8 x i64> %vs2, <8 x i64> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv8i64.nxv8i64.iXLen(iXLen, <8 x i64>, <8 x i64>, <8 x i64>, iXLen)

define <1 x i8> @test_sf_vc_v_vvv_se_e8mf8(<1 x i8> %vd, <1 x i8> %vs2, <1 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvv_se_e8mf8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, tu, ma
; CHECK-NEXT:    sf.vc.v.vvv 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <1 x i8> @llvm.riscv.sf.vc.v.vvv.se.nxv1i8.iXLen.nxv1i8.iXLen(iXLen 3, <1 x i8> %vd, <1 x i8> %vs2, <1 x i8> %vs1, iXLen %vl)
  ret <1 x i8> %0
}

declare <1 x i8> @llvm.riscv.sf.vc.v.vvv.se.nxv1i8.iXLen.nxv1i8.iXLen(iXLen, <1 x i8>, <1 x i8>, <1 x i8>, iXLen)

define <2 x i8> @test_sf_vc_v_vvv_se_e8mf4(<2 x i8> %vd, <2 x i8> %vs2, <2 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvv_se_e8mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, tu, ma
; CHECK-NEXT:    sf.vc.v.vvv 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <2 x i8> @llvm.riscv.sf.vc.v.vvv.se.nxv2i8.iXLen.nxv2i8.iXLen(iXLen 3, <2 x i8> %vd, <2 x i8> %vs2, <2 x i8> %vs1, iXLen %vl)
  ret <2 x i8> %0
}

declare <2 x i8> @llvm.riscv.sf.vc.v.vvv.se.nxv2i8.iXLen.nxv2i8.iXLen(iXLen, <2 x i8>, <2 x i8>, <2 x i8>, iXLen)

define <4 x i8> @test_sf_vc_v_vvv_se_e8mf2(<4 x i8> %vd, <4 x i8> %vs2, <4 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvv_se_e8mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf4, tu, ma
; CHECK-NEXT:    sf.vc.v.vvv 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <4 x i8> @llvm.riscv.sf.vc.v.vvv.se.nxv4i8.iXLen.nxv4i8.iXLen(iXLen 3, <4 x i8> %vd, <4 x i8> %vs2, <4 x i8> %vs1, iXLen %vl)
  ret <4 x i8> %0
}

declare <4 x i8> @llvm.riscv.sf.vc.v.vvv.se.nxv4i8.iXLen.nxv4i8.iXLen(iXLen, <4 x i8>, <4 x i8>, <4 x i8>, iXLen)

define <8 x i8> @test_sf_vc_v_vvv_se_e8m1(<8 x i8> %vd, <8 x i8> %vs2, <8 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvv_se_e8m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf2, tu, ma
; CHECK-NEXT:    sf.vc.v.vvv 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <8 x i8> @llvm.riscv.sf.vc.v.vvv.se.nxv8i8.iXLen.nxv8i8.iXLen(iXLen 3, <8 x i8> %vd, <8 x i8> %vs2, <8 x i8> %vs1, iXLen %vl)
  ret <8 x i8> %0
}

declare <8 x i8> @llvm.riscv.sf.vc.v.vvv.se.nxv8i8.iXLen.nxv8i8.iXLen(iXLen, <8 x i8>, <8 x i8>, <8 x i8>, iXLen)

define <16 x i8> @test_sf_vc_v_vvv_se_e8m2(<16 x i8> %vd, <16 x i8> %vs2, <16 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvv_se_e8m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, tu, ma
; CHECK-NEXT:    sf.vc.v.vvv 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <16 x i8> @llvm.riscv.sf.vc.v.vvv.se.nxv16i8.iXLen.nxv16i8.iXLen(iXLen 3, <16 x i8> %vd, <16 x i8> %vs2, <16 x i8> %vs1, iXLen %vl)
  ret <16 x i8> %0
}

declare <16 x i8> @llvm.riscv.sf.vc.v.vvv.se.nxv16i8.iXLen.nxv16i8.iXLen(iXLen, <16 x i8>, <16 x i8>, <16 x i8>, iXLen)

define <32 x i8> @test_sf_vc_v_vvv_se_e8m4(<32 x i8> %vd, <32 x i8> %vs2, <32 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvv_se_e8m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m2, tu, ma
; CHECK-NEXT:    sf.vc.v.vvv 3, v8, v10, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call <32 x i8> @llvm.riscv.sf.vc.v.vvv.se.nxv32i8.iXLen.nxv32i8.iXLen(iXLen 3, <32 x i8> %vd, <32 x i8> %vs2, <32 x i8> %vs1, iXLen %vl)
  ret <32 x i8> %0
}

declare <32 x i8> @llvm.riscv.sf.vc.v.vvv.se.nxv32i8.iXLen.nxv32i8.iXLen(iXLen, <32 x i8>, <32 x i8>, <32 x i8>, iXLen)

define <64 x i8> @test_sf_vc_v_vvv_se_e8m8(<64 x i8> %vd, <64 x i8> %vs2, <64 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvv_se_e8m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m4, tu, ma
; CHECK-NEXT:    sf.vc.v.vvv 3, v8, v12, v16
; CHECK-NEXT:    ret
entry:
  %0 = tail call <64 x i8> @llvm.riscv.sf.vc.v.vvv.se.nxv64i8.iXLen.nxv64i8.iXLen(iXLen 3, <64 x i8> %vd, <64 x i8> %vs2, <64 x i8> %vs1, iXLen %vl)
  ret <64 x i8> %0
}

declare <64 x i8> @llvm.riscv.sf.vc.v.vvv.se.nxv64i8.iXLen.nxv64i8.iXLen(iXLen, <64 x i8>, <64 x i8>, <64 x i8>, iXLen)

define <1 x i16> @test_sf_vc_v_vvv_se_e16mf4(<1 x i16> %vd, <1 x i16> %vs2, <1 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvv_se_e16mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, tu, ma
; CHECK-NEXT:    sf.vc.v.vvv 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <1 x i16> @llvm.riscv.sf.vc.v.vvv.se.nxv1i16.iXLen.nxv1i16.iXLen(iXLen 3, <1 x i16> %vd, <1 x i16> %vs2, <1 x i16> %vs1, iXLen %vl)
  ret <1 x i16> %0
}

declare <1 x i16> @llvm.riscv.sf.vc.v.vvv.se.nxv1i16.iXLen.nxv1i16.iXLen(iXLen, <1 x i16>, <1 x i16>, <1 x i16>, iXLen)

define <2 x i16> @test_sf_vc_v_vvv_se_e16mf2(<2 x i16> %vd, <2 x i16> %vs2, <2 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvv_se_e16mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, tu, ma
; CHECK-NEXT:    sf.vc.v.vvv 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <2 x i16> @llvm.riscv.sf.vc.v.vvv.se.nxv2i16.iXLen.nxv2i16.iXLen(iXLen 3, <2 x i16> %vd, <2 x i16> %vs2, <2 x i16> %vs1, iXLen %vl)
  ret <2 x i16> %0
}

declare <2 x i16> @llvm.riscv.sf.vc.v.vvv.se.nxv2i16.iXLen.nxv2i16.iXLen(iXLen, <2 x i16>, <2 x i16>, <2 x i16>, iXLen)

define <4 x i16> @test_sf_vc_v_vvv_se_e16m1(<4 x i16> %vd, <4 x i16> %vs2, <4 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvv_se_e16m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf2, tu, ma
; CHECK-NEXT:    sf.vc.v.vvv 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <4 x i16> @llvm.riscv.sf.vc.v.vvv.se.nxv4i16.iXLen.nxv4i16.iXLen(iXLen 3, <4 x i16> %vd, <4 x i16> %vs2, <4 x i16> %vs1, iXLen %vl)
  ret <4 x i16> %0
}

declare <4 x i16> @llvm.riscv.sf.vc.v.vvv.se.nxv4i16.iXLen.nxv4i16.iXLen(iXLen, <4 x i16>, <4 x i16>, <4 x i16>, iXLen)

define <8 x i16> @test_sf_vc_v_vvv_se_e16m2(<8 x i16> %vd, <8 x i16> %vs2, <8 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvv_se_e16m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, tu, ma
; CHECK-NEXT:    sf.vc.v.vvv 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <8 x i16> @llvm.riscv.sf.vc.v.vvv.se.nxv8i16.iXLen.nxv8i16.iXLen(iXLen 3, <8 x i16> %vd, <8 x i16> %vs2, <8 x i16> %vs1, iXLen %vl)
  ret <8 x i16> %0
}

declare <8 x i16> @llvm.riscv.sf.vc.v.vvv.se.nxv8i16.iXLen.nxv8i16.iXLen(iXLen, <8 x i16>, <8 x i16>, <8 x i16>, iXLen)

define <16 x i16> @test_sf_vc_v_vvv_se_e16m4(<16 x i16> %vd, <16 x i16> %vs2, <16 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvv_se_e16m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m2, tu, ma
; CHECK-NEXT:    sf.vc.v.vvv 3, v8, v10, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call <16 x i16> @llvm.riscv.sf.vc.v.vvv.se.nxv16i16.iXLen.nxv16i16.iXLen(iXLen 3, <16 x i16> %vd, <16 x i16> %vs2, <16 x i16> %vs1, iXLen %vl)
  ret <16 x i16> %0
}

declare <16 x i16> @llvm.riscv.sf.vc.v.vvv.se.nxv16i16.iXLen.nxv16i16.iXLen(iXLen, <16 x i16>, <16 x i16>, <16 x i16>, iXLen)

define <32 x i16> @test_sf_vc_v_vvv_se_e16m8(<32 x i16> %vd, <32 x i16> %vs2, <32 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvv_se_e16m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, tu, ma
; CHECK-NEXT:    sf.vc.v.vvv 3, v8, v12, v16
; CHECK-NEXT:    ret
entry:
  %0 = tail call <32 x i16> @llvm.riscv.sf.vc.v.vvv.se.nxv32i16.iXLen.nxv32i16.iXLen(iXLen 3, <32 x i16> %vd, <32 x i16> %vs2, <32 x i16> %vs1, iXLen %vl)
  ret <32 x i16> %0
}

declare <32 x i16> @llvm.riscv.sf.vc.v.vvv.se.nxv32i16.iXLen.nxv32i16.iXLen(iXLen, <32 x i16>, <32 x i16>, <32 x i16>, iXLen)

define <1 x i32> @test_sf_vc_v_vvv_se_e32mf2(<1 x i32> %vd, <1 x i32> %vs2, <1 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvv_se_e32mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, tu, ma
; CHECK-NEXT:    sf.vc.v.vvv 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <1 x i32> @llvm.riscv.sf.vc.v.vvv.se.nxv1i32.iXLen.nxv1i32.iXLen(iXLen 3, <1 x i32> %vd, <1 x i32> %vs2, <1 x i32> %vs1, iXLen %vl)
  ret <1 x i32> %0
}

declare <1 x i32> @llvm.riscv.sf.vc.v.vvv.se.nxv1i32.iXLen.nxv1i32.iXLen(iXLen, <1 x i32>, <1 x i32>, <1 x i32>, iXLen)

define <2 x i32> @test_sf_vc_v_vvv_se_e32m1(<2 x i32> %vd, <2 x i32> %vs2, <2 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvv_se_e32m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, tu, ma
; CHECK-NEXT:    sf.vc.v.vvv 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <2 x i32> @llvm.riscv.sf.vc.v.vvv.se.nxv2i32.iXLen.nxv2i32.iXLen(iXLen 3, <2 x i32> %vd, <2 x i32> %vs2, <2 x i32> %vs1, iXLen %vl)
  ret <2 x i32> %0
}

declare <2 x i32> @llvm.riscv.sf.vc.v.vvv.se.nxv2i32.iXLen.nxv2i32.iXLen(iXLen, <2 x i32>, <2 x i32>, <2 x i32>, iXLen)

define <4 x i32> @test_sf_vc_v_vvv_se_e32m2(<4 x i32> %vd, <4 x i32> %vs2, <4 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvv_se_e32m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m1, tu, ma
; CHECK-NEXT:    sf.vc.v.vvv 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <4 x i32> @llvm.riscv.sf.vc.v.vvv.se.nxv4i32.iXLen.nxv4i32.iXLen(iXLen 3, <4 x i32> %vd, <4 x i32> %vs2, <4 x i32> %vs1, iXLen %vl)
  ret <4 x i32> %0
}

declare <4 x i32> @llvm.riscv.sf.vc.v.vvv.se.nxv4i32.iXLen.nxv4i32.iXLen(iXLen, <4 x i32>, <4 x i32>, <4 x i32>, iXLen)

define <8 x i32> @test_sf_vc_v_vvv_se_e32m4(<8 x i32> %vd, <8 x i32> %vs2, <8 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvv_se_e32m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, tu, ma
; CHECK-NEXT:    sf.vc.v.vvv 3, v8, v10, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call <8 x i32> @llvm.riscv.sf.vc.v.vvv.se.nxv8i32.iXLen.nxv8i32.iXLen(iXLen 3, <8 x i32> %vd, <8 x i32> %vs2, <8 x i32> %vs1, iXLen %vl)
  ret <8 x i32> %0
}

declare <8 x i32> @llvm.riscv.sf.vc.v.vvv.se.nxv8i32.iXLen.nxv8i32.iXLen(iXLen, <8 x i32>, <8 x i32>, <8 x i32>, iXLen)

define <16 x i32> @test_sf_vc_v_vvv_se_e32m8(<16 x i32> %vd, <16 x i32> %vs2, <16 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvv_se_e32m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, tu, ma
; CHECK-NEXT:    sf.vc.v.vvv 3, v8, v12, v16
; CHECK-NEXT:    ret
entry:
  %0 = tail call <16 x i32> @llvm.riscv.sf.vc.v.vvv.se.nxv16i32.iXLen.nxv16i32.iXLen(iXLen 3, <16 x i32> %vd, <16 x i32> %vs2, <16 x i32> %vs1, iXLen %vl)
  ret <16 x i32> %0
}

declare <16 x i32> @llvm.riscv.sf.vc.v.vvv.se.nxv16i32.iXLen.nxv16i32.iXLen(iXLen, <16 x i32>, <16 x i32>, <16 x i32>, iXLen)

define <1 x i64> @test_sf_vc_v_vvv_se_e64m1(<1 x i64> %vd, <1 x i64> %vs2, <1 x i64> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvv_se_e64m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, tu, ma
; CHECK-NEXT:    sf.vc.v.vvv 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <1 x i64> @llvm.riscv.sf.vc.v.vvv.se.nxv1i64.iXLen.nxv1i64.iXLen(iXLen 3, <1 x i64> %vd, <1 x i64> %vs2, <1 x i64> %vs1, iXLen %vl)
  ret <1 x i64> %0
}

declare <1 x i64> @llvm.riscv.sf.vc.v.vvv.se.nxv1i64.iXLen.nxv1i64.iXLen(iXLen, <1 x i64>, <1 x i64>, <1 x i64>, iXLen)

define <2 x i64> @test_sf_vc_v_vvv_se_e64m2(<2 x i64> %vd, <2 x i64> %vs2, <2 x i64> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvv_se_e64m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, tu, ma
; CHECK-NEXT:    sf.vc.v.vvv 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <2 x i64> @llvm.riscv.sf.vc.v.vvv.se.nxv2i64.iXLen.nxv2i64.iXLen(iXLen 3, <2 x i64> %vd, <2 x i64> %vs2, <2 x i64> %vs1, iXLen %vl)
  ret <2 x i64> %0
}

declare <2 x i64> @llvm.riscv.sf.vc.v.vvv.se.nxv2i64.iXLen.nxv2i64.iXLen(iXLen, <2 x i64>, <2 x i64>, <2 x i64>, iXLen)

define <4 x i64> @test_sf_vc_v_vvv_se_e64m4(<4 x i64> %vd, <4 x i64> %vs2, <4 x i64> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvv_se_e64m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m2, tu, ma
; CHECK-NEXT:    sf.vc.v.vvv 3, v8, v10, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call <4 x i64> @llvm.riscv.sf.vc.v.vvv.se.nxv4i64.iXLen.nxv4i64.iXLen(iXLen 3, <4 x i64> %vd, <4 x i64> %vs2, <4 x i64> %vs1, iXLen %vl)
  ret <4 x i64> %0
}

declare <4 x i64> @llvm.riscv.sf.vc.v.vvv.se.nxv4i64.iXLen.nxv4i64.iXLen(iXLen, <4 x i64>, <4 x i64>, <4 x i64>, iXLen)

define <8 x i64> @test_sf_vc_v_vvv_se_e64m8(<8 x i64> %vd, <8 x i64> %vs2, <8 x i64> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvv_se_e64m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, tu, ma
; CHECK-NEXT:    sf.vc.v.vvv 3, v8, v12, v16
; CHECK-NEXT:    ret
entry:
  %0 = tail call <8 x i64> @llvm.riscv.sf.vc.v.vvv.se.nxv8i64.iXLen.nxv8i64.iXLen(iXLen 3, <8 x i64> %vd, <8 x i64> %vs2, <8 x i64> %vs1, iXLen %vl)
  ret <8 x i64> %0
}

declare <8 x i64> @llvm.riscv.sf.vc.v.vvv.se.nxv8i64.iXLen.nxv8i64.iXLen(iXLen, <8 x i64>, <8 x i64>, <8 x i64>, iXLen)

define <1 x i8> @test_sf_vc_v_vvv_e8mf8(<1 x i8> %vd, <1 x i8> %vs2, <1 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvv_e8mf8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, tu, ma
; CHECK-NEXT:    sf.vc.v.vvv 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <1 x i8> @llvm.riscv.sf.vc.v.vvv.nxv1i8.iXLen.nxv1i8.iXLen(iXLen 3, <1 x i8> %vd, <1 x i8> %vs2, <1 x i8> %vs1, iXLen %vl)
  ret <1 x i8> %0
}

declare <1 x i8> @llvm.riscv.sf.vc.v.vvv.nxv1i8.iXLen.nxv1i8.iXLen(iXLen, <1 x i8>, <1 x i8>, <1 x i8>, iXLen)

define <2 x i8> @test_sf_vc_v_vvv_e8mf4(<2 x i8> %vd, <2 x i8> %vs2, <2 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvv_e8mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, tu, ma
; CHECK-NEXT:    sf.vc.v.vvv 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <2 x i8> @llvm.riscv.sf.vc.v.vvv.nxv2i8.iXLen.nxv2i8.iXLen(iXLen 3, <2 x i8> %vd, <2 x i8> %vs2, <2 x i8> %vs1, iXLen %vl)
  ret <2 x i8> %0
}

declare <2 x i8> @llvm.riscv.sf.vc.v.vvv.nxv2i8.iXLen.nxv2i8.iXLen(iXLen, <2 x i8>, <2 x i8>, <2 x i8>, iXLen)

define <4 x i8> @test_sf_vc_v_vvv_e8mf2(<4 x i8> %vd, <4 x i8> %vs2, <4 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvv_e8mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf4, tu, ma
; CHECK-NEXT:    sf.vc.v.vvv 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <4 x i8> @llvm.riscv.sf.vc.v.vvv.nxv4i8.iXLen.nxv4i8.iXLen(iXLen 3, <4 x i8> %vd, <4 x i8> %vs2, <4 x i8> %vs1, iXLen %vl)
  ret <4 x i8> %0
}

declare <4 x i8> @llvm.riscv.sf.vc.v.vvv.nxv4i8.iXLen.nxv4i8.iXLen(iXLen, <4 x i8>, <4 x i8>, <4 x i8>, iXLen)

define <8 x i8> @test_sf_vc_v_vvv_e8m1(<8 x i8> %vd, <8 x i8> %vs2, <8 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvv_e8m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf2, tu, ma
; CHECK-NEXT:    sf.vc.v.vvv 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <8 x i8> @llvm.riscv.sf.vc.v.vvv.nxv8i8.iXLen.nxv8i8.iXLen(iXLen 3, <8 x i8> %vd, <8 x i8> %vs2, <8 x i8> %vs1, iXLen %vl)
  ret <8 x i8> %0
}

declare <8 x i8> @llvm.riscv.sf.vc.v.vvv.nxv8i8.iXLen.nxv8i8.iXLen(iXLen, <8 x i8>, <8 x i8>, <8 x i8>, iXLen)

define <16 x i8> @test_sf_vc_v_vvv_e8m2(<16 x i8> %vd, <16 x i8> %vs2, <16 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvv_e8m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, tu, ma
; CHECK-NEXT:    sf.vc.v.vvv 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <16 x i8> @llvm.riscv.sf.vc.v.vvv.nxv16i8.iXLen.nxv16i8.iXLen(iXLen 3, <16 x i8> %vd, <16 x i8> %vs2, <16 x i8> %vs1, iXLen %vl)
  ret <16 x i8> %0
}

declare <16 x i8> @llvm.riscv.sf.vc.v.vvv.nxv16i8.iXLen.nxv16i8.iXLen(iXLen, <16 x i8>, <16 x i8>, <16 x i8>, iXLen)

define <32 x i8> @test_sf_vc_v_vvv_e8m4(<32 x i8> %vd, <32 x i8> %vs2, <32 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvv_e8m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m2, tu, ma
; CHECK-NEXT:    sf.vc.v.vvv 3, v8, v10, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call <32 x i8> @llvm.riscv.sf.vc.v.vvv.nxv32i8.iXLen.nxv32i8.iXLen(iXLen 3, <32 x i8> %vd, <32 x i8> %vs2, <32 x i8> %vs1, iXLen %vl)
  ret <32 x i8> %0
}

declare <32 x i8> @llvm.riscv.sf.vc.v.vvv.nxv32i8.iXLen.nxv32i8.iXLen(iXLen, <32 x i8>, <32 x i8>, <32 x i8>, iXLen)

define <64 x i8> @test_sf_vc_v_vvv_e8m8(<64 x i8> %vd, <64 x i8> %vs2, <64 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvv_e8m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m4, tu, ma
; CHECK-NEXT:    sf.vc.v.vvv 3, v8, v12, v16
; CHECK-NEXT:    ret
entry:
  %0 = tail call <64 x i8> @llvm.riscv.sf.vc.v.vvv.nxv64i8.iXLen.nxv64i8.iXLen(iXLen 3, <64 x i8> %vd, <64 x i8> %vs2, <64 x i8> %vs1, iXLen %vl)
  ret <64 x i8> %0
}

declare <64 x i8> @llvm.riscv.sf.vc.v.vvv.nxv64i8.iXLen.nxv64i8.iXLen(iXLen, <64 x i8>, <64 x i8>, <64 x i8>, iXLen)

define <1 x i16> @test_sf_vc_v_vvv_e16mf4(<1 x i16> %vd, <1 x i16> %vs2, <1 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvv_e16mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, tu, ma
; CHECK-NEXT:    sf.vc.v.vvv 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <1 x i16> @llvm.riscv.sf.vc.v.vvv.nxv1i16.iXLen.nxv1i16.iXLen(iXLen 3, <1 x i16> %vd, <1 x i16> %vs2, <1 x i16> %vs1, iXLen %vl)
  ret <1 x i16> %0
}

declare <1 x i16> @llvm.riscv.sf.vc.v.vvv.nxv1i16.iXLen.nxv1i16.iXLen(iXLen, <1 x i16>, <1 x i16>, <1 x i16>, iXLen)

define <2 x i16> @test_sf_vc_v_vvv_e16mf2(<2 x i16> %vd, <2 x i16> %vs2, <2 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvv_e16mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, tu, ma
; CHECK-NEXT:    sf.vc.v.vvv 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <2 x i16> @llvm.riscv.sf.vc.v.vvv.nxv2i16.iXLen.nxv2i16.iXLen(iXLen 3, <2 x i16> %vd, <2 x i16> %vs2, <2 x i16> %vs1, iXLen %vl)
  ret <2 x i16> %0
}

declare <2 x i16> @llvm.riscv.sf.vc.v.vvv.nxv2i16.iXLen.nxv2i16.iXLen(iXLen, <2 x i16>, <2 x i16>, <2 x i16>, iXLen)

define <4 x i16> @test_sf_vc_v_vvv_e16m1(<4 x i16> %vd, <4 x i16> %vs2, <4 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvv_e16m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf2, tu, ma
; CHECK-NEXT:    sf.vc.v.vvv 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <4 x i16> @llvm.riscv.sf.vc.v.vvv.nxv4i16.iXLen.nxv4i16.iXLen(iXLen 3, <4 x i16> %vd, <4 x i16> %vs2, <4 x i16> %vs1, iXLen %vl)
  ret <4 x i16> %0
}

declare <4 x i16> @llvm.riscv.sf.vc.v.vvv.nxv4i16.iXLen.nxv4i16.iXLen(iXLen, <4 x i16>, <4 x i16>, <4 x i16>, iXLen)

define <8 x i16> @test_sf_vc_v_vvv_e16m2(<8 x i16> %vd, <8 x i16> %vs2, <8 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvv_e16m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, tu, ma
; CHECK-NEXT:    sf.vc.v.vvv 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <8 x i16> @llvm.riscv.sf.vc.v.vvv.nxv8i16.iXLen.nxv8i16.iXLen(iXLen 3, <8 x i16> %vd, <8 x i16> %vs2, <8 x i16> %vs1, iXLen %vl)
  ret <8 x i16> %0
}

declare <8 x i16> @llvm.riscv.sf.vc.v.vvv.nxv8i16.iXLen.nxv8i16.iXLen(iXLen, <8 x i16>, <8 x i16>, <8 x i16>, iXLen)

define <16 x i16> @test_sf_vc_v_vvv_e16m4(<16 x i16> %vd, <16 x i16> %vs2, <16 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvv_e16m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m2, tu, ma
; CHECK-NEXT:    sf.vc.v.vvv 3, v8, v10, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call <16 x i16> @llvm.riscv.sf.vc.v.vvv.nxv16i16.iXLen.nxv16i16.iXLen(iXLen 3, <16 x i16> %vd, <16 x i16> %vs2, <16 x i16> %vs1, iXLen %vl)
  ret <16 x i16> %0
}

declare <16 x i16> @llvm.riscv.sf.vc.v.vvv.nxv16i16.iXLen.nxv16i16.iXLen(iXLen, <16 x i16>, <16 x i16>, <16 x i16>, iXLen)

define <32 x i16> @test_sf_vc_v_vvv_e16m8(<32 x i16> %vd, <32 x i16> %vs2, <32 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvv_e16m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, tu, ma
; CHECK-NEXT:    sf.vc.v.vvv 3, v8, v12, v16
; CHECK-NEXT:    ret
entry:
  %0 = tail call <32 x i16> @llvm.riscv.sf.vc.v.vvv.nxv32i16.iXLen.nxv32i16.iXLen(iXLen 3, <32 x i16> %vd, <32 x i16> %vs2, <32 x i16> %vs1, iXLen %vl)
  ret <32 x i16> %0
}

declare <32 x i16> @llvm.riscv.sf.vc.v.vvv.nxv32i16.iXLen.nxv32i16.iXLen(iXLen, <32 x i16>, <32 x i16>, <32 x i16>, iXLen)

define <1 x i32> @test_sf_vc_v_vvv_e32mf2(<1 x i32> %vd, <1 x i32> %vs2, <1 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvv_e32mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, tu, ma
; CHECK-NEXT:    sf.vc.v.vvv 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <1 x i32> @llvm.riscv.sf.vc.v.vvv.nxv1i32.iXLen.nxv1i32.iXLen(iXLen 3, <1 x i32> %vd, <1 x i32> %vs2, <1 x i32> %vs1, iXLen %vl)
  ret <1 x i32> %0
}

declare <1 x i32> @llvm.riscv.sf.vc.v.vvv.nxv1i32.iXLen.nxv1i32.iXLen(iXLen, <1 x i32>, <1 x i32>, <1 x i32>, iXLen)

define <2 x i32> @test_sf_vc_v_vvv_e32m1(<2 x i32> %vd, <2 x i32> %vs2, <2 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvv_e32m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, tu, ma
; CHECK-NEXT:    sf.vc.v.vvv 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <2 x i32> @llvm.riscv.sf.vc.v.vvv.nxv2i32.iXLen.nxv2i32.iXLen(iXLen 3, <2 x i32> %vd, <2 x i32> %vs2, <2 x i32> %vs1, iXLen %vl)
  ret <2 x i32> %0
}

declare <2 x i32> @llvm.riscv.sf.vc.v.vvv.nxv2i32.iXLen.nxv2i32.iXLen(iXLen, <2 x i32>, <2 x i32>, <2 x i32>, iXLen)

define <4 x i32> @test_sf_vc_v_vvv_e32m2(<4 x i32> %vd, <4 x i32> %vs2, <4 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvv_e32m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m1, tu, ma
; CHECK-NEXT:    sf.vc.v.vvv 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <4 x i32> @llvm.riscv.sf.vc.v.vvv.nxv4i32.iXLen.nxv4i32.iXLen(iXLen 3, <4 x i32> %vd, <4 x i32> %vs2, <4 x i32> %vs1, iXLen %vl)
  ret <4 x i32> %0
}

declare <4 x i32> @llvm.riscv.sf.vc.v.vvv.nxv4i32.iXLen.nxv4i32.iXLen(iXLen, <4 x i32>, <4 x i32>, <4 x i32>, iXLen)

define <8 x i32> @test_sf_vc_v_vvv_e32m4(<8 x i32> %vd, <8 x i32> %vs2, <8 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvv_e32m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, tu, ma
; CHECK-NEXT:    sf.vc.v.vvv 3, v8, v10, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call <8 x i32> @llvm.riscv.sf.vc.v.vvv.nxv8i32.iXLen.nxv8i32.iXLen(iXLen 3, <8 x i32> %vd, <8 x i32> %vs2, <8 x i32> %vs1, iXLen %vl)
  ret <8 x i32> %0
}

declare <8 x i32> @llvm.riscv.sf.vc.v.vvv.nxv8i32.iXLen.nxv8i32.iXLen(iXLen, <8 x i32>, <8 x i32>, <8 x i32>, iXLen)

define <16 x i32> @test_sf_vc_v_vvv_e32m8(<16 x i32> %vd, <16 x i32> %vs2, <16 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvv_e32m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, tu, ma
; CHECK-NEXT:    sf.vc.v.vvv 3, v8, v12, v16
; CHECK-NEXT:    ret
entry:
  %0 = tail call <16 x i32> @llvm.riscv.sf.vc.v.vvv.nxv16i32.iXLen.nxv16i32.iXLen(iXLen 3, <16 x i32> %vd, <16 x i32> %vs2, <16 x i32> %vs1, iXLen %vl)
  ret <16 x i32> %0
}

declare <16 x i32> @llvm.riscv.sf.vc.v.vvv.nxv16i32.iXLen.nxv16i32.iXLen(iXLen, <16 x i32>, <16 x i32>, <16 x i32>, iXLen)

define <1 x i64> @test_sf_vc_v_vvv_e64m1(<1 x i64> %vd, <1 x i64> %vs2, <1 x i64> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvv_e64m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, tu, ma
; CHECK-NEXT:    sf.vc.v.vvv 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <1 x i64> @llvm.riscv.sf.vc.v.vvv.nxv1i64.iXLen.nxv1i64.iXLen(iXLen 3, <1 x i64> %vd, <1 x i64> %vs2, <1 x i64> %vs1, iXLen %vl)
  ret <1 x i64> %0
}

declare <1 x i64> @llvm.riscv.sf.vc.v.vvv.nxv1i64.iXLen.nxv1i64.iXLen(iXLen, <1 x i64>, <1 x i64>, <1 x i64>, iXLen)

define <2 x i64> @test_sf_vc_v_vvv_e64m2(<2 x i64> %vd, <2 x i64> %vs2, <2 x i64> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvv_e64m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, tu, ma
; CHECK-NEXT:    sf.vc.v.vvv 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <2 x i64> @llvm.riscv.sf.vc.v.vvv.nxv2i64.iXLen.nxv2i64.iXLen(iXLen 3, <2 x i64> %vd, <2 x i64> %vs2, <2 x i64> %vs1, iXLen %vl)
  ret <2 x i64> %0
}

declare <2 x i64> @llvm.riscv.sf.vc.v.vvv.nxv2i64.iXLen.nxv2i64.iXLen(iXLen, <2 x i64>, <2 x i64>, <2 x i64>, iXLen)

define <4 x i64> @test_sf_vc_v_vvv_e64m4(<4 x i64> %vd, <4 x i64> %vs2, <4 x i64> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvv_e64m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m2, tu, ma
; CHECK-NEXT:    sf.vc.v.vvv 3, v8, v10, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call <4 x i64> @llvm.riscv.sf.vc.v.vvv.nxv4i64.iXLen.nxv4i64.iXLen(iXLen 3, <4 x i64> %vd, <4 x i64> %vs2, <4 x i64> %vs1, iXLen %vl)
  ret <4 x i64> %0
}

declare <4 x i64> @llvm.riscv.sf.vc.v.vvv.nxv4i64.iXLen.nxv4i64.iXLen(iXLen, <4 x i64>, <4 x i64>, <4 x i64>, iXLen)

define <8 x i64> @test_sf_vc_v_vvv_e64m8(<8 x i64> %vd, <8 x i64> %vs2, <8 x i64> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvv_e64m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, tu, ma
; CHECK-NEXT:    sf.vc.v.vvv 3, v8, v12, v16
; CHECK-NEXT:    ret
entry:
  %0 = tail call <8 x i64> @llvm.riscv.sf.vc.v.vvv.nxv8i64.iXLen.nxv8i64.iXLen(iXLen 3, <8 x i64> %vd, <8 x i64> %vs2, <8 x i64> %vs1, iXLen %vl)
  ret <8 x i64> %0
}

declare <8 x i64> @llvm.riscv.sf.vc.v.vvv.nxv8i64.iXLen.nxv8i64.iXLen(iXLen, <8 x i64>, <8 x i64>, <8 x i64>, iXLen)

define void @test_sf_vc_xvv_se_e8mf8(<1 x i8> %vd, <1 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_xvv_se_e8mf8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    sf.vc.xvv 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xvv.se.iXLen.nxv1i8.i8.iXLen(iXLen 3, <1 x i8> %vd, <1 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xvv.se.iXLen.nxv1i8.i8.iXLen(iXLen, <1 x i8>, <1 x i8>, i8, iXLen)

define void @test_sf_vc_xvv_se_e8mf4(<2 x i8> %vd, <2 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_xvv_se_e8mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    sf.vc.xvv 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xvv.se.iXLen.nxv2i8.i8.iXLen(iXLen 3, <2 x i8> %vd, <2 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xvv.se.iXLen.nxv2i8.i8.iXLen(iXLen, <2 x i8>, <2 x i8>, i8, iXLen)

define void @test_sf_vc_xvv_se_e8mf2(<4 x i8> %vd, <4 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_xvv_se_e8mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    sf.vc.xvv 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xvv.se.iXLen.nxv4i8.i8.iXLen(iXLen 3, <4 x i8> %vd, <4 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xvv.se.iXLen.nxv4i8.i8.iXLen(iXLen, <4 x i8>, <4 x i8>, i8, iXLen)

define void @test_sf_vc_xvv_se_e8m1(<8 x i8> %vd, <8 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_xvv_se_e8m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    sf.vc.xvv 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xvv.se.iXLen.nxv8i8.i8.iXLen(iXLen 3, <8 x i8> %vd, <8 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xvv.se.iXLen.nxv8i8.i8.iXLen(iXLen, <8 x i8>, <8 x i8>, i8, iXLen)

define void @test_sf_vc_xvv_se_e8m2(<16 x i8> %vd, <16 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_xvv_se_e8m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    sf.vc.xvv 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xvv.se.iXLen.nxv16i8.i8.iXLen(iXLen 3, <16 x i8> %vd, <16 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xvv.se.iXLen.nxv16i8.i8.iXLen(iXLen, <16 x i8>, <16 x i8>, i8, iXLen)

define void @test_sf_vc_xvv_se_e8m4(<32 x i8> %vd, <32 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_xvv_se_e8m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, ta, ma
; CHECK-NEXT:    sf.vc.xvv 3, v8, v10, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xvv.se.iXLen.nxv32i8.i8.iXLen(iXLen 3, <32 x i8> %vd, <32 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xvv.se.iXLen.nxv32i8.i8.iXLen(iXLen, <32 x i8>, <32 x i8>, i8, iXLen)

define void @test_sf_vc_xvv_se_e8m8(<64 x i8> %vd, <64 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_xvv_se_e8m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m4, ta, ma
; CHECK-NEXT:    sf.vc.xvv 3, v8, v12, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xvv.se.iXLen.nxv64i8.i8.iXLen(iXLen 3, <64 x i8> %vd, <64 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xvv.se.iXLen.nxv64i8.i8.iXLen(iXLen, <64 x i8>, <64 x i8>, i8, iXLen)

define void @test_sf_vc_xvv_se_e16mf4(<1 x i16> %vd, <1 x i16> %vs2, i16 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_xvv_se_e16mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    sf.vc.xvv 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xvv.se.iXLen.nxv1i16.i16.iXLen(iXLen 3, <1 x i16> %vd, <1 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xvv.se.iXLen.nxv1i16.i16.iXLen(iXLen, <1 x i16>, <1 x i16>, i16, iXLen)

define void @test_sf_vc_xvv_se_e16mf2(<2 x i16> %vd, <2 x i16> %vs2, i16 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_xvv_se_e16mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    sf.vc.xvv 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xvv.se.iXLen.nxv2i16.i16.iXLen(iXLen 3, <2 x i16> %vd, <2 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xvv.se.iXLen.nxv2i16.i16.iXLen(iXLen, <2 x i16>, <2 x i16>, i16, iXLen)

define void @test_sf_vc_xvv_se_e16m1(<4 x i16> %vd, <4 x i16> %vs2, i16 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_xvv_se_e16m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    sf.vc.xvv 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xvv.se.iXLen.nxv4i16.i16.iXLen(iXLen 3, <4 x i16> %vd, <4 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xvv.se.iXLen.nxv4i16.i16.iXLen(iXLen, <4 x i16>, <4 x i16>, i16, iXLen)

define void @test_sf_vc_xvv_se_e16m2(<8 x i16> %vd, <8 x i16> %vs2, i16 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_xvv_se_e16m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    sf.vc.xvv 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xvv.se.iXLen.nxv8i16.i16.iXLen(iXLen 3, <8 x i16> %vd, <8 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xvv.se.iXLen.nxv8i16.i16.iXLen(iXLen, <8 x i16>, <8 x i16>, i16, iXLen)

define void @test_sf_vc_xvv_se_e16m4(<16 x i16> %vd, <16 x i16> %vs2, i16 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_xvv_se_e16m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    sf.vc.xvv 3, v8, v10, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xvv.se.iXLen.nxv16i16.i16.iXLen(iXLen 3, <16 x i16> %vd, <16 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xvv.se.iXLen.nxv16i16.i16.iXLen(iXLen, <16 x i16>, <16 x i16>, i16, iXLen)

define void @test_sf_vc_xvv_se_e16m8(<32 x i16> %vd, <32 x i16> %vs2, i16 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_xvv_se_e16m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, ma
; CHECK-NEXT:    sf.vc.xvv 3, v8, v12, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xvv.se.iXLen.nxv32i16.i16.iXLen(iXLen 3, <32 x i16> %vd, <32 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xvv.se.iXLen.nxv32i16.i16.iXLen(iXLen, <32 x i16>, <32 x i16>, i16, iXLen)

define void @test_sf_vc_xvv_se_e32mf2(<1 x i32> %vd, <1 x i32> %vs2, i32 signext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_xvv_se_e32mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    sf.vc.xvv 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xvv.se.i32.nxv1i32.iXLen.iXLen(iXLen 3, <1 x i32> %vd, <1 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xvv.se.i32.nxv1i32.iXLen.iXLen(iXLen, <1 x i32>, <1 x i32>, i32, iXLen)

define void @test_sf_vc_xvv_se_e32m1(<2 x i32> %vd, <2 x i32> %vs2, i32 signext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_xvv_se_e32m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    sf.vc.xvv 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xvv.se.i32.nxv2i32.iXLen.iXLen(iXLen 3, <2 x i32> %vd, <2 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xvv.se.i32.nxv2i32.iXLen.iXLen(iXLen, <2 x i32>, <2 x i32>, i32, iXLen)

define void @test_sf_vc_xvv_se_e32m2(<4 x i32> %vd, <4 x i32> %vs2, i32 signext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_xvv_se_e32m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    sf.vc.xvv 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xvv.se.i32.nxv4i32.iXLen.iXLen(iXLen 3, <4 x i32> %vd, <4 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xvv.se.i32.nxv4i32.iXLen.iXLen(iXLen, <4 x i32>, <4 x i32>, i32, iXLen)

define void @test_sf_vc_xvv_se_e32m4(<8 x i32> %vd, <8 x i32> %vs2, i32 signext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_xvv_se_e32m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    sf.vc.xvv 3, v8, v10, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xvv.se.i32.nxv8i32.iXLen.iXLen(iXLen 3, <8 x i32> %vd, <8 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xvv.se.i32.nxv8i32.iXLen.iXLen(iXLen, <8 x i32>, <8 x i32>, i32, iXLen)

define void @test_sf_vc_xvv_se_e32m8(<16 x i32> %vd, <16 x i32> %vs2, i32 signext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_xvv_se_e32m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    sf.vc.xvv 3, v8, v12, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xvv.se.i32.nxv16i32.iXLen.iXLen(iXLen 3, <16 x i32> %vd, <16 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xvv.se.i32.nxv16i32.iXLen.iXLen(iXLen, <16 x i32>, <16 x i32>, i32, iXLen)

define <1 x i8> @test_sf_vc_v_xvv_se_e8mf8(<1 x i8> %vd, <1 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xvv_se_e8mf8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, tu, ma
; CHECK-NEXT:    sf.vc.v.xvv 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <1 x i8> @llvm.riscv.sf.vc.v.xvv.se.nxv1i8.iXLen.i8.iXLen(iXLen 3, <1 x i8> %vd, <1 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret <1 x i8> %0
}

declare <1 x i8> @llvm.riscv.sf.vc.v.xvv.se.nxv1i8.iXLen.i8.iXLen(iXLen, <1 x i8>, <1 x i8>, i8, iXLen)

define <2 x i8> @test_sf_vc_v_xvv_se_e8mf4(<2 x i8> %vd, <2 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xvv_se_e8mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, tu, ma
; CHECK-NEXT:    sf.vc.v.xvv 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <2 x i8> @llvm.riscv.sf.vc.v.xvv.se.nxv2i8.iXLen.i8.iXLen(iXLen 3, <2 x i8> %vd, <2 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret <2 x i8> %0
}

declare <2 x i8> @llvm.riscv.sf.vc.v.xvv.se.nxv2i8.iXLen.i8.iXLen(iXLen, <2 x i8>, <2 x i8>, i8, iXLen)

define <4 x i8> @test_sf_vc_v_xvv_se_e8mf2(<4 x i8> %vd, <4 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xvv_se_e8mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, tu, ma
; CHECK-NEXT:    sf.vc.v.xvv 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <4 x i8> @llvm.riscv.sf.vc.v.xvv.se.nxv4i8.iXLen.i8.iXLen(iXLen 3, <4 x i8> %vd, <4 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret <4 x i8> %0
}

declare <4 x i8> @llvm.riscv.sf.vc.v.xvv.se.nxv4i8.iXLen.i8.iXLen(iXLen, <4 x i8>, <4 x i8>, i8, iXLen)

define <8 x i8> @test_sf_vc_v_xvv_se_e8m1(<8 x i8> %vd, <8 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xvv_se_e8m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, tu, ma
; CHECK-NEXT:    sf.vc.v.xvv 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <8 x i8> @llvm.riscv.sf.vc.v.xvv.se.nxv8i8.iXLen.i8.iXLen(iXLen 3, <8 x i8> %vd, <8 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret <8 x i8> %0
}

declare <8 x i8> @llvm.riscv.sf.vc.v.xvv.se.nxv8i8.iXLen.i8.iXLen(iXLen, <8 x i8>, <8 x i8>, i8, iXLen)

define <16 x i8> @test_sf_vc_v_xvv_se_e8m2(<16 x i8> %vd, <16 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xvv_se_e8m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, tu, ma
; CHECK-NEXT:    sf.vc.v.xvv 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <16 x i8> @llvm.riscv.sf.vc.v.xvv.se.nxv16i8.iXLen.i8.iXLen(iXLen 3, <16 x i8> %vd, <16 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret <16 x i8> %0
}

declare <16 x i8> @llvm.riscv.sf.vc.v.xvv.se.nxv16i8.iXLen.i8.iXLen(iXLen, <16 x i8>, <16 x i8>, i8, iXLen)

define <32 x i8> @test_sf_vc_v_xvv_se_e8m4(<32 x i8> %vd, <32 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xvv_se_e8m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, tu, ma
; CHECK-NEXT:    sf.vc.v.xvv 3, v8, v10, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <32 x i8> @llvm.riscv.sf.vc.v.xvv.se.nxv32i8.iXLen.i8.iXLen(iXLen 3, <32 x i8> %vd, <32 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret <32 x i8> %0
}

declare <32 x i8> @llvm.riscv.sf.vc.v.xvv.se.nxv32i8.iXLen.i8.iXLen(iXLen, <32 x i8>, <32 x i8>, i8, iXLen)

define <64 x i8> @test_sf_vc_v_xvv_se_e8m8(<64 x i8> %vd, <64 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xvv_se_e8m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m4, tu, ma
; CHECK-NEXT:    sf.vc.v.xvv 3, v8, v12, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <64 x i8> @llvm.riscv.sf.vc.v.xvv.se.nxv64i8.iXLen.i8.iXLen(iXLen 3, <64 x i8> %vd, <64 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret <64 x i8> %0
}

declare <64 x i8> @llvm.riscv.sf.vc.v.xvv.se.nxv64i8.iXLen.i8.iXLen(iXLen, <64 x i8>, <64 x i8>, i8, iXLen)

define <1 x i16> @test_sf_vc_v_xvv_se_e16mf4(<1 x i16> %vd, <1 x i16> %vs2, i16 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xvv_se_e16mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, tu, ma
; CHECK-NEXT:    sf.vc.v.xvv 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <1 x i16> @llvm.riscv.sf.vc.v.xvv.se.nxv1i16.iXLen.i16.iXLen(iXLen 3, <1 x i16> %vd, <1 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret <1 x i16> %0
}

declare <1 x i16> @llvm.riscv.sf.vc.v.xvv.se.nxv1i16.iXLen.i16.iXLen(iXLen, <1 x i16>, <1 x i16>, i16, iXLen)

define <2 x i16> @test_sf_vc_v_xvv_se_e16mf2(<2 x i16> %vd, <2 x i16> %vs2, i16 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xvv_se_e16mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, tu, ma
; CHECK-NEXT:    sf.vc.v.xvv 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <2 x i16> @llvm.riscv.sf.vc.v.xvv.se.nxv2i16.iXLen.i16.iXLen(iXLen 3, <2 x i16> %vd, <2 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret <2 x i16> %0
}

declare <2 x i16> @llvm.riscv.sf.vc.v.xvv.se.nxv2i16.iXLen.i16.iXLen(iXLen, <2 x i16>, <2 x i16>, i16, iXLen)

define <4 x i16> @test_sf_vc_v_xvv_se_e16m1(<4 x i16> %vd, <4 x i16> %vs2, i16 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xvv_se_e16m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, tu, ma
; CHECK-NEXT:    sf.vc.v.xvv 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <4 x i16> @llvm.riscv.sf.vc.v.xvv.se.nxv4i16.iXLen.i16.iXLen(iXLen 3, <4 x i16> %vd, <4 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret <4 x i16> %0
}

declare <4 x i16> @llvm.riscv.sf.vc.v.xvv.se.nxv4i16.iXLen.i16.iXLen(iXLen, <4 x i16>, <4 x i16>, i16, iXLen)

define <8 x i16> @test_sf_vc_v_xvv_se_e16m2(<8 x i16> %vd, <8 x i16> %vs2, i16 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xvv_se_e16m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, tu, ma
; CHECK-NEXT:    sf.vc.v.xvv 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <8 x i16> @llvm.riscv.sf.vc.v.xvv.se.nxv8i16.iXLen.i16.iXLen(iXLen 3, <8 x i16> %vd, <8 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret <8 x i16> %0
}

declare <8 x i16> @llvm.riscv.sf.vc.v.xvv.se.nxv8i16.iXLen.i16.iXLen(iXLen, <8 x i16>, <8 x i16>, i16, iXLen)

define <16 x i16> @test_sf_vc_v_xvv_se_e16m4(<16 x i16> %vd, <16 x i16> %vs2, i16 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xvv_se_e16m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, tu, ma
; CHECK-NEXT:    sf.vc.v.xvv 3, v8, v10, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <16 x i16> @llvm.riscv.sf.vc.v.xvv.se.nxv16i16.iXLen.i16.iXLen(iXLen 3, <16 x i16> %vd, <16 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret <16 x i16> %0
}

declare <16 x i16> @llvm.riscv.sf.vc.v.xvv.se.nxv16i16.iXLen.i16.iXLen(iXLen, <16 x i16>, <16 x i16>, i16, iXLen)

define <32 x i16> @test_sf_vc_v_xvv_se_e16m8(<32 x i16> %vd, <32 x i16> %vs2, i16 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xvv_se_e16m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, tu, ma
; CHECK-NEXT:    sf.vc.v.xvv 3, v8, v12, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <32 x i16> @llvm.riscv.sf.vc.v.xvv.se.nxv32i16.iXLen.i16.iXLen(iXLen 3, <32 x i16> %vd, <32 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret <32 x i16> %0
}

declare <32 x i16> @llvm.riscv.sf.vc.v.xvv.se.nxv32i16.iXLen.i16.iXLen(iXLen, <32 x i16>, <32 x i16>, i16, iXLen)

define <1 x i32> @test_sf_vc_v_xvv_se_e32mf2(<1 x i32> %vd, <1 x i32> %vs2, i32 signext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xvv_se_e32mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, tu, ma
; CHECK-NEXT:    sf.vc.v.xvv 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <1 x i32> @llvm.riscv.sf.vc.v.xvv.se.nxv1i32.iXLen.i32.iXLen(iXLen 3, <1 x i32> %vd, <1 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret <1 x i32> %0
}

declare <1 x i32> @llvm.riscv.sf.vc.v.xvv.se.nxv1i32.iXLen.i32.iXLen(iXLen, <1 x i32>, <1 x i32>, i32, iXLen)

define <2 x i32> @test_sf_vc_v_xvv_se_e32m1(<2 x i32> %vd, <2 x i32> %vs2, i32 signext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xvv_se_e32m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, tu, ma
; CHECK-NEXT:    sf.vc.v.xvv 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <2 x i32> @llvm.riscv.sf.vc.v.xvv.se.nxv2i32.iXLen.i32.iXLen(iXLen 3, <2 x i32> %vd, <2 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret <2 x i32> %0
}

declare <2 x i32> @llvm.riscv.sf.vc.v.xvv.se.nxv2i32.iXLen.i32.iXLen(iXLen, <2 x i32>, <2 x i32>, i32, iXLen)

define <4 x i32> @test_sf_vc_v_xvv_se_e32m2(<4 x i32> %vd, <4 x i32> %vs2, i32 signext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xvv_se_e32m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, tu, ma
; CHECK-NEXT:    sf.vc.v.xvv 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <4 x i32> @llvm.riscv.sf.vc.v.xvv.se.nxv4i32.iXLen.i32.iXLen(iXLen 3, <4 x i32> %vd, <4 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret <4 x i32> %0
}

declare <4 x i32> @llvm.riscv.sf.vc.v.xvv.se.nxv4i32.iXLen.i32.iXLen(iXLen, <4 x i32>, <4 x i32>, i32, iXLen)

define <8 x i32> @test_sf_vc_v_xvv_se_e32m4(<8 x i32> %vd, <8 x i32> %vs2, i32 signext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xvv_se_e32m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, tu, ma
; CHECK-NEXT:    sf.vc.v.xvv 3, v8, v10, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <8 x i32> @llvm.riscv.sf.vc.v.xvv.se.nxv8i32.iXLen.i32.iXLen(iXLen 3, <8 x i32> %vd, <8 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret <8 x i32> %0
}

declare <8 x i32> @llvm.riscv.sf.vc.v.xvv.se.nxv8i32.iXLen.i32.iXLen(iXLen, <8 x i32>, <8 x i32>, i32, iXLen)

define <16 x i32> @test_sf_vc_v_xvv_se_e32m8(<16 x i32> %vd, <16 x i32> %vs2, i32 signext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xvv_se_e32m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, tu, ma
; CHECK-NEXT:    sf.vc.v.xvv 3, v8, v12, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <16 x i32> @llvm.riscv.sf.vc.v.xvv.se.nxv16i32.iXLen.i32.iXLen(iXLen 3, <16 x i32> %vd, <16 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret <16 x i32> %0
}

declare <16 x i32> @llvm.riscv.sf.vc.v.xvv.se.nxv16i32.iXLen.i32.iXLen(iXLen, <16 x i32>, <16 x i32>, i32, iXLen)

define <1 x i8> @test_sf_vc_v_xvv_e8mf8(<1 x i8> %vd, <1 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xvv_e8mf8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, tu, ma
; CHECK-NEXT:    sf.vc.v.xvv 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <1 x i8> @llvm.riscv.sf.vc.v.xvv.nxv1i8.iXLen.i8.iXLen(iXLen 3, <1 x i8> %vd, <1 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret <1 x i8> %0
}

declare <1 x i8> @llvm.riscv.sf.vc.v.xvv.nxv1i8.iXLen.i8.iXLen(iXLen, <1 x i8>, <1 x i8>, i8, iXLen)

define <2 x i8> @test_sf_vc_v_xvv_e8mf4(<2 x i8> %vd, <2 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xvv_e8mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, tu, ma
; CHECK-NEXT:    sf.vc.v.xvv 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <2 x i8> @llvm.riscv.sf.vc.v.xvv.nxv2i8.iXLen.i8.iXLen(iXLen 3, <2 x i8> %vd, <2 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret <2 x i8> %0
}

declare <2 x i8> @llvm.riscv.sf.vc.v.xvv.nxv2i8.iXLen.i8.iXLen(iXLen, <2 x i8>, <2 x i8>, i8, iXLen)

define <4 x i8> @test_sf_vc_v_xvv_e8mf2(<4 x i8> %vd, <4 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xvv_e8mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, tu, ma
; CHECK-NEXT:    sf.vc.v.xvv 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <4 x i8> @llvm.riscv.sf.vc.v.xvv.nxv4i8.iXLen.i8.iXLen(iXLen 3, <4 x i8> %vd, <4 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret <4 x i8> %0
}

declare <4 x i8> @llvm.riscv.sf.vc.v.xvv.nxv4i8.iXLen.i8.iXLen(iXLen, <4 x i8>, <4 x i8>, i8, iXLen)

define <8 x i8> @test_sf_vc_v_xvv_e8m1(<8 x i8> %vd, <8 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xvv_e8m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, tu, ma
; CHECK-NEXT:    sf.vc.v.xvv 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <8 x i8> @llvm.riscv.sf.vc.v.xvv.nxv8i8.iXLen.i8.iXLen(iXLen 3, <8 x i8> %vd, <8 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret <8 x i8> %0
}

declare <8 x i8> @llvm.riscv.sf.vc.v.xvv.nxv8i8.iXLen.i8.iXLen(iXLen, <8 x i8>, <8 x i8>, i8, iXLen)

define <16 x i8> @test_sf_vc_v_xvv_e8m2(<16 x i8> %vd, <16 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xvv_e8m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, tu, ma
; CHECK-NEXT:    sf.vc.v.xvv 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <16 x i8> @llvm.riscv.sf.vc.v.xvv.nxv16i8.iXLen.i8.iXLen(iXLen 3, <16 x i8> %vd, <16 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret <16 x i8> %0
}

declare <16 x i8> @llvm.riscv.sf.vc.v.xvv.nxv16i8.iXLen.i8.iXLen(iXLen, <16 x i8>, <16 x i8>, i8, iXLen)

define <32 x i8> @test_sf_vc_v_xvv_e8m4(<32 x i8> %vd, <32 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xvv_e8m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, tu, ma
; CHECK-NEXT:    sf.vc.v.xvv 3, v8, v10, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <32 x i8> @llvm.riscv.sf.vc.v.xvv.nxv32i8.iXLen.i8.iXLen(iXLen 3, <32 x i8> %vd, <32 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret <32 x i8> %0
}

declare <32 x i8> @llvm.riscv.sf.vc.v.xvv.nxv32i8.iXLen.i8.iXLen(iXLen, <32 x i8>, <32 x i8>, i8, iXLen)

define <64 x i8> @test_sf_vc_v_xvv_e8m8(<64 x i8> %vd, <64 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xvv_e8m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m4, tu, ma
; CHECK-NEXT:    sf.vc.v.xvv 3, v8, v12, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <64 x i8> @llvm.riscv.sf.vc.v.xvv.nxv64i8.iXLen.i8.iXLen(iXLen 3, <64 x i8> %vd, <64 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret <64 x i8> %0
}

declare <64 x i8> @llvm.riscv.sf.vc.v.xvv.nxv64i8.iXLen.i8.iXLen(iXLen, <64 x i8>, <64 x i8>, i8, iXLen)

define <1 x i16> @test_sf_vc_v_xvv_e16mf4(<1 x i16> %vd, <1 x i16> %vs2, i16 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xvv_e16mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, tu, ma
; CHECK-NEXT:    sf.vc.v.xvv 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <1 x i16> @llvm.riscv.sf.vc.v.xvv.nxv1i16.iXLen.i16.iXLen(iXLen 3, <1 x i16> %vd, <1 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret <1 x i16> %0
}

declare <1 x i16> @llvm.riscv.sf.vc.v.xvv.nxv1i16.iXLen.i16.iXLen(iXLen, <1 x i16>, <1 x i16>, i16, iXLen)

define <2 x i16> @test_sf_vc_v_xvv_e16mf2(<2 x i16> %vd, <2 x i16> %vs2, i16 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xvv_e16mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, tu, ma
; CHECK-NEXT:    sf.vc.v.xvv 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <2 x i16> @llvm.riscv.sf.vc.v.xvv.nxv2i16.iXLen.i16.iXLen(iXLen 3, <2 x i16> %vd, <2 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret <2 x i16> %0
}

declare <2 x i16> @llvm.riscv.sf.vc.v.xvv.nxv2i16.iXLen.i16.iXLen(iXLen, <2 x i16>, <2 x i16>, i16, iXLen)

define <4 x i16> @test_sf_vc_v_xvv_e16m1(<4 x i16> %vd, <4 x i16> %vs2, i16 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xvv_e16m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, tu, ma
; CHECK-NEXT:    sf.vc.v.xvv 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <4 x i16> @llvm.riscv.sf.vc.v.xvv.nxv4i16.iXLen.i16.iXLen(iXLen 3, <4 x i16> %vd, <4 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret <4 x i16> %0
}

declare <4 x i16> @llvm.riscv.sf.vc.v.xvv.nxv4i16.iXLen.i16.iXLen(iXLen, <4 x i16>, <4 x i16>, i16, iXLen)

define <8 x i16> @test_sf_vc_v_xvv_e16m2(<8 x i16> %vd, <8 x i16> %vs2, i16 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xvv_e16m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, tu, ma
; CHECK-NEXT:    sf.vc.v.xvv 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <8 x i16> @llvm.riscv.sf.vc.v.xvv.nxv8i16.iXLen.i16.iXLen(iXLen 3, <8 x i16> %vd, <8 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret <8 x i16> %0
}

declare <8 x i16> @llvm.riscv.sf.vc.v.xvv.nxv8i16.iXLen.i16.iXLen(iXLen, <8 x i16>, <8 x i16>, i16, iXLen)

define <16 x i16> @test_sf_vc_v_xvv_e16m4(<16 x i16> %vd, <16 x i16> %vs2, i16 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xvv_e16m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, tu, ma
; CHECK-NEXT:    sf.vc.v.xvv 3, v8, v10, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <16 x i16> @llvm.riscv.sf.vc.v.xvv.nxv16i16.iXLen.i16.iXLen(iXLen 3, <16 x i16> %vd, <16 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret <16 x i16> %0
}

declare <16 x i16> @llvm.riscv.sf.vc.v.xvv.nxv16i16.iXLen.i16.iXLen(iXLen, <16 x i16>, <16 x i16>, i16, iXLen)

define <32 x i16> @test_sf_vc_v_xvv_e16m8(<32 x i16> %vd, <32 x i16> %vs2, i16 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xvv_e16m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, tu, ma
; CHECK-NEXT:    sf.vc.v.xvv 3, v8, v12, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <32 x i16> @llvm.riscv.sf.vc.v.xvv.nxv32i16.iXLen.i16.iXLen(iXLen 3, <32 x i16> %vd, <32 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret <32 x i16> %0
}

declare <32 x i16> @llvm.riscv.sf.vc.v.xvv.nxv32i16.iXLen.i16.iXLen(iXLen, <32 x i16>, <32 x i16>, i16, iXLen)

define <1 x i32> @test_sf_vc_v_xvv_e32mf2(<1 x i32> %vd, <1 x i32> %vs2, i32 signext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xvv_e32mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, tu, ma
; CHECK-NEXT:    sf.vc.v.xvv 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <1 x i32> @llvm.riscv.sf.vc.v.xvv.nxv1i32.iXLen.i32.iXLen(iXLen 3, <1 x i32> %vd, <1 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret <1 x i32> %0
}

declare <1 x i32> @llvm.riscv.sf.vc.v.xvv.nxv1i32.iXLen.i32.iXLen(iXLen, <1 x i32>, <1 x i32>, i32, iXLen)

define <2 x i32> @test_sf_vc_v_xvv_e32m1(<2 x i32> %vd, <2 x i32> %vs2, i32 signext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xvv_e32m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, tu, ma
; CHECK-NEXT:    sf.vc.v.xvv 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <2 x i32> @llvm.riscv.sf.vc.v.xvv.nxv2i32.iXLen.i32.iXLen(iXLen 3, <2 x i32> %vd, <2 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret <2 x i32> %0
}

declare <2 x i32> @llvm.riscv.sf.vc.v.xvv.nxv2i32.iXLen.i32.iXLen(iXLen, <2 x i32>, <2 x i32>, i32, iXLen)

define <4 x i32> @test_sf_vc_v_xvv_e32m2(<4 x i32> %vd, <4 x i32> %vs2, i32 signext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xvv_e32m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, tu, ma
; CHECK-NEXT:    sf.vc.v.xvv 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <4 x i32> @llvm.riscv.sf.vc.v.xvv.nxv4i32.iXLen.i32.iXLen(iXLen 3, <4 x i32> %vd, <4 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret <4 x i32> %0
}

declare <4 x i32> @llvm.riscv.sf.vc.v.xvv.nxv4i32.iXLen.i32.iXLen(iXLen, <4 x i32>, <4 x i32>, i32, iXLen)

define <8 x i32> @test_sf_vc_v_xvv_e32m4(<8 x i32> %vd, <8 x i32> %vs2, i32 signext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xvv_e32m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, tu, ma
; CHECK-NEXT:    sf.vc.v.xvv 3, v8, v10, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <8 x i32> @llvm.riscv.sf.vc.v.xvv.nxv8i32.iXLen.i32.iXLen(iXLen 3, <8 x i32> %vd, <8 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret <8 x i32> %0
}

declare <8 x i32> @llvm.riscv.sf.vc.v.xvv.nxv8i32.iXLen.i32.iXLen(iXLen, <8 x i32>, <8 x i32>, i32, iXLen)

define <16 x i32> @test_sf_vc_v_xvv_e32m8(<16 x i32> %vd, <16 x i32> %vs2, i32 signext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xvv_e32m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, tu, ma
; CHECK-NEXT:    sf.vc.v.xvv 3, v8, v12, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <16 x i32> @llvm.riscv.sf.vc.v.xvv.nxv16i32.iXLen.i32.iXLen(iXLen 3, <16 x i32> %vd, <16 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret <16 x i32> %0
}

declare <16 x i32> @llvm.riscv.sf.vc.v.xvv.nxv16i32.iXLen.i32.iXLen(iXLen, <16 x i32>, <16 x i32>, i32, iXLen)

define void @test_sf_vc_ivv_se_e8mf8(<1 x i8> %vd, <1 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_ivv_se_e8mf8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    sf.vc.ivv 3, v8, v9, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.ivv.se.iXLen.nxv1i8.iXLen.iXLen(iXLen 3, <1 x i8> %vd, <1 x i8> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.ivv.se.iXLen.nxv1i8.iXLen.iXLen(iXLen, <1 x i8>, <1 x i8>, iXLen, iXLen)

define void @test_sf_vc_ivv_se_e8mf4(<2 x i8> %vd, <2 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_ivv_se_e8mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    sf.vc.ivv 3, v8, v9, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.ivv.se.iXLen.nxv2i8.iXLen.iXLen(iXLen 3, <2 x i8> %vd, <2 x i8> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.ivv.se.iXLen.nxv2i8.iXLen.iXLen(iXLen, <2 x i8>, <2 x i8>, iXLen, iXLen)

define void @test_sf_vc_ivv_se_e8mf2(<4 x i8> %vd, <4 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_ivv_se_e8mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf4, ta, ma
; CHECK-NEXT:    sf.vc.ivv 3, v8, v9, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.ivv.se.iXLen.nxv4i8.iXLen.iXLen(iXLen 3, <4 x i8> %vd, <4 x i8> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.ivv.se.iXLen.nxv4i8.iXLen.iXLen(iXLen, <4 x i8>, <4 x i8>, iXLen, iXLen)

define void @test_sf_vc_ivv_se_e8m1(<8 x i8> %vd, <8 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_ivv_se_e8m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; CHECK-NEXT:    sf.vc.ivv 3, v8, v9, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.ivv.se.iXLen.nxv8i8.iXLen.iXLen(iXLen 3, <8 x i8> %vd, <8 x i8> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.ivv.se.iXLen.nxv8i8.iXLen.iXLen(iXLen, <8 x i8>, <8 x i8>, iXLen, iXLen)

define void @test_sf_vc_ivv_se_e8m2(<16 x i8> %vd, <16 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_ivv_se_e8m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    sf.vc.ivv 3, v8, v9, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.ivv.se.iXLen.nxv16i8.iXLen.iXLen(iXLen 3, <16 x i8> %vd, <16 x i8> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.ivv.se.iXLen.nxv16i8.iXLen.iXLen(iXLen, <16 x i8>, <16 x i8>, iXLen, iXLen)

define void @test_sf_vc_ivv_se_e8m4(<32 x i8> %vd, <32 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_ivv_se_e8m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m2, ta, ma
; CHECK-NEXT:    sf.vc.ivv 3, v8, v10, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.ivv.se.iXLen.nxv32i8.iXLen.iXLen(iXLen 3, <32 x i8> %vd, <32 x i8> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.ivv.se.iXLen.nxv32i8.iXLen.iXLen(iXLen, <32 x i8>, <32 x i8>, iXLen, iXLen)

define void @test_sf_vc_ivv_se_e8m8(<64 x i8> %vd, <64 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_ivv_se_e8m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m4, ta, ma
; CHECK-NEXT:    sf.vc.ivv 3, v8, v12, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.ivv.se.iXLen.nxv64i8.iXLen.iXLen(iXLen 3, <64 x i8> %vd, <64 x i8> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.ivv.se.iXLen.nxv64i8.iXLen.iXLen(iXLen, <64 x i8>, <64 x i8>, iXLen, iXLen)

define void @test_sf_vc_ivv_se_e16mf4(<1 x i16> %vd, <1 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_ivv_se_e16mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-NEXT:    sf.vc.ivv 3, v8, v9, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.ivv.se.iXLen.nxv1i16.iXLen.iXLen(iXLen 3, <1 x i16> %vd, <1 x i16> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.ivv.se.iXLen.nxv1i16.iXLen.iXLen(iXLen, <1 x i16>, <1 x i16>, iXLen, iXLen)

define void @test_sf_vc_ivv_se_e16mf2(<2 x i16> %vd, <2 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_ivv_se_e16mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-NEXT:    sf.vc.ivv 3, v8, v9, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.ivv.se.iXLen.nxv2i16.iXLen.iXLen(iXLen 3, <2 x i16> %vd, <2 x i16> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.ivv.se.iXLen.nxv2i16.iXLen.iXLen(iXLen, <2 x i16>, <2 x i16>, iXLen, iXLen)

define void @test_sf_vc_ivv_se_e16m1(<4 x i16> %vd, <4 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_ivv_se_e16m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; CHECK-NEXT:    sf.vc.ivv 3, v8, v9, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.ivv.se.iXLen.nxv4i16.iXLen.iXLen(iXLen 3, <4 x i16> %vd, <4 x i16> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.ivv.se.iXLen.nxv4i16.iXLen.iXLen(iXLen, <4 x i16>, <4 x i16>, iXLen, iXLen)

define void @test_sf_vc_ivv_se_e16m2(<8 x i16> %vd, <8 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_ivv_se_e16m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    sf.vc.ivv 3, v8, v9, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.ivv.se.iXLen.nxv8i16.iXLen.iXLen(iXLen 3, <8 x i16> %vd, <8 x i16> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.ivv.se.iXLen.nxv8i16.iXLen.iXLen(iXLen, <8 x i16>, <8 x i16>, iXLen, iXLen)

define void @test_sf_vc_ivv_se_e16m4(<16 x i16> %vd, <16 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_ivv_se_e16m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; CHECK-NEXT:    sf.vc.ivv 3, v8, v10, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.ivv.se.iXLen.nxv16i16.iXLen.iXLen(iXLen 3, <16 x i16> %vd, <16 x i16> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.ivv.se.iXLen.nxv16i16.iXLen.iXLen(iXLen, <16 x i16>, <16 x i16>, iXLen, iXLen)

define void @test_sf_vc_ivv_se_e16m8(<32 x i16> %vd, <32 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_ivv_se_e16m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    sf.vc.ivv 3, v8, v12, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.ivv.se.iXLen.nxv32i16.iXLen.iXLen(iXLen 3, <32 x i16> %vd, <32 x i16> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.ivv.se.iXLen.nxv32i16.iXLen.iXLen(iXLen, <32 x i16>, <32 x i16>, iXLen, iXLen)

define void @test_sf_vc_ivv_se_e32mf2(<1 x i32> %vd, <1 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_ivv_se_e32mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    sf.vc.ivv 3, v8, v9, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.ivv.se.iXLen.nxv1i32.iXLen.iXLen(iXLen 3, <1 x i32> %vd, <1 x i32> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.ivv.se.iXLen.nxv1i32.iXLen.iXLen(iXLen, <1 x i32>, <1 x i32>, iXLen, iXLen)

define void @test_sf_vc_ivv_se_e32m1(<2 x i32> %vd, <2 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_ivv_se_e32m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    sf.vc.ivv 3, v8, v9, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.ivv.se.iXLen.nxv2i32.iXLen.iXLen(iXLen 3, <2 x i32> %vd, <2 x i32> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.ivv.se.iXLen.nxv2i32.iXLen.iXLen(iXLen, <2 x i32>, <2 x i32>, iXLen, iXLen)

define void @test_sf_vc_ivv_se_e32m2(<4 x i32> %vd, <4 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_ivv_se_e32m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; CHECK-NEXT:    sf.vc.ivv 3, v8, v9, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.ivv.se.iXLen.nxv4i32.iXLen.iXLen(iXLen 3, <4 x i32> %vd, <4 x i32> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.ivv.se.iXLen.nxv4i32.iXLen.iXLen(iXLen, <4 x i32>, <4 x i32>, iXLen, iXLen)

define void @test_sf_vc_ivv_se_e32m4(<8 x i32> %vd, <8 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_ivv_se_e32m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; CHECK-NEXT:    sf.vc.ivv 3, v8, v10, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.ivv.se.iXLen.nxv8i32.iXLen.iXLen(iXLen 3, <8 x i32> %vd, <8 x i32> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.ivv.se.iXLen.nxv8i32.iXLen.iXLen(iXLen, <8 x i32>, <8 x i32>, iXLen, iXLen)

define void @test_sf_vc_ivv_se_e32m8(<16 x i32> %vd, <16 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_ivv_se_e32m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    sf.vc.ivv 3, v8, v12, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.ivv.se.iXLen.nxv16i32.iXLen.iXLen(iXLen 3, <16 x i32> %vd, <16 x i32> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.ivv.se.iXLen.nxv16i32.iXLen.iXLen(iXLen, <16 x i32>, <16 x i32>, iXLen, iXLen)

define void @test_sf_vc_ivv_se_e64m1(<1 x i64> %vd, <1 x i64> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_ivv_se_e64m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    sf.vc.ivv 3, v8, v9, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.ivv.se.iXLen.nxv1i64.iXLen.iXLen(iXLen 3, <1 x i64> %vd, <1 x i64> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.ivv.se.iXLen.nxv1i64.iXLen.iXLen(iXLen, <1 x i64>, <1 x i64>, iXLen, iXLen)

define void @test_sf_vc_ivv_se_e64m2(<2 x i64> %vd, <2 x i64> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_ivv_se_e64m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    sf.vc.ivv 3, v8, v9, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.ivv.se.iXLen.nxv2i64.iXLen.iXLen(iXLen 3, <2 x i64> %vd, <2 x i64> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.ivv.se.iXLen.nxv2i64.iXLen.iXLen(iXLen, <2 x i64>, <2 x i64>, iXLen, iXLen)

define void @test_sf_vc_ivv_se_e64m4(<4 x i64> %vd, <4 x i64> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_ivv_se_e64m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; CHECK-NEXT:    sf.vc.ivv 3, v8, v10, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.ivv.se.iXLen.nxv4i64.iXLen.iXLen(iXLen 3, <4 x i64> %vd, <4 x i64> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.ivv.se.iXLen.nxv4i64.iXLen.iXLen(iXLen, <4 x i64>, <4 x i64>, iXLen, iXLen)

define void @test_sf_vc_ivv_se_e64m8(<8 x i64> %vd, <8 x i64> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_ivv_se_e64m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    sf.vc.ivv 3, v8, v12, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.ivv.se.iXLen.nxv8i64.iXLen.iXLen(iXLen 3, <8 x i64> %vd, <8 x i64> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.ivv.se.iXLen.nxv8i64.iXLen.iXLen(iXLen, <8 x i64>, <8 x i64>, iXLen, iXLen)

define <1 x i8> @test_sf_vc_v_ivv_se_e8mf8(<1 x i8> %vd, <1 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivv_se_e8mf8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, tu, ma
; CHECK-NEXT:    sf.vc.v.ivv 3, v8, v9, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <1 x i8> @llvm.riscv.sf.vc.v.ivv.se.nxv1i8.iXLen.iXLen.iXLen(iXLen 3, <1 x i8> %vd, <1 x i8> %vs2, iXLen 10, iXLen %vl)
  ret <1 x i8> %0
}

declare <1 x i8> @llvm.riscv.sf.vc.v.ivv.se.nxv1i8.iXLen.iXLen.iXLen(iXLen, <1 x i8>, <1 x i8>, iXLen, iXLen)

define <2 x i8> @test_sf_vc_v_ivv_se_e8mf4(<2 x i8> %vd, <2 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivv_se_e8mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, tu, ma
; CHECK-NEXT:    sf.vc.v.ivv 3, v8, v9, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <2 x i8> @llvm.riscv.sf.vc.v.ivv.se.nxv2i8.iXLen.iXLen.iXLen(iXLen 3, <2 x i8> %vd, <2 x i8> %vs2, iXLen 10, iXLen %vl)
  ret <2 x i8> %0
}

declare <2 x i8> @llvm.riscv.sf.vc.v.ivv.se.nxv2i8.iXLen.iXLen.iXLen(iXLen, <2 x i8>, <2 x i8>, iXLen, iXLen)

define <4 x i8> @test_sf_vc_v_ivv_se_e8mf2(<4 x i8> %vd, <4 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivv_se_e8mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf4, tu, ma
; CHECK-NEXT:    sf.vc.v.ivv 3, v8, v9, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <4 x i8> @llvm.riscv.sf.vc.v.ivv.se.nxv4i8.iXLen.iXLen.iXLen(iXLen 3, <4 x i8> %vd, <4 x i8> %vs2, iXLen 10, iXLen %vl)
  ret <4 x i8> %0
}

declare <4 x i8> @llvm.riscv.sf.vc.v.ivv.se.nxv4i8.iXLen.iXLen.iXLen(iXLen, <4 x i8>, <4 x i8>, iXLen, iXLen)

define <8 x i8> @test_sf_vc_v_ivv_se_e8m1(<8 x i8> %vd, <8 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivv_se_e8m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf2, tu, ma
; CHECK-NEXT:    sf.vc.v.ivv 3, v8, v9, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <8 x i8> @llvm.riscv.sf.vc.v.ivv.se.nxv8i8.iXLen.iXLen.iXLen(iXLen 3, <8 x i8> %vd, <8 x i8> %vs2, iXLen 10, iXLen %vl)
  ret <8 x i8> %0
}

declare <8 x i8> @llvm.riscv.sf.vc.v.ivv.se.nxv8i8.iXLen.iXLen.iXLen(iXLen, <8 x i8>, <8 x i8>, iXLen, iXLen)

define <16 x i8> @test_sf_vc_v_ivv_se_e8m2(<16 x i8> %vd, <16 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivv_se_e8m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, tu, ma
; CHECK-NEXT:    sf.vc.v.ivv 3, v8, v9, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <16 x i8> @llvm.riscv.sf.vc.v.ivv.se.nxv16i8.iXLen.iXLen.iXLen(iXLen 3, <16 x i8> %vd, <16 x i8> %vs2, iXLen 10, iXLen %vl)
  ret <16 x i8> %0
}

declare <16 x i8> @llvm.riscv.sf.vc.v.ivv.se.nxv16i8.iXLen.iXLen.iXLen(iXLen, <16 x i8>, <16 x i8>, iXLen, iXLen)

define <32 x i8> @test_sf_vc_v_ivv_se_e8m4(<32 x i8> %vd, <32 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivv_se_e8m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m2, tu, ma
; CHECK-NEXT:    sf.vc.v.ivv 3, v8, v10, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <32 x i8> @llvm.riscv.sf.vc.v.ivv.se.nxv32i8.iXLen.iXLen.iXLen(iXLen 3, <32 x i8> %vd, <32 x i8> %vs2, iXLen 10, iXLen %vl)
  ret <32 x i8> %0
}

declare <32 x i8> @llvm.riscv.sf.vc.v.ivv.se.nxv32i8.iXLen.iXLen.iXLen(iXLen, <32 x i8>, <32 x i8>, iXLen, iXLen)

define <64 x i8> @test_sf_vc_v_ivv_se_e8m8(<64 x i8> %vd, <64 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivv_se_e8m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m4, tu, ma
; CHECK-NEXT:    sf.vc.v.ivv 3, v8, v12, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <64 x i8> @llvm.riscv.sf.vc.v.ivv.se.nxv64i8.iXLen.iXLen.iXLen(iXLen 3, <64 x i8> %vd, <64 x i8> %vs2, iXLen 10, iXLen %vl)
  ret <64 x i8> %0
}

declare <64 x i8> @llvm.riscv.sf.vc.v.ivv.se.nxv64i8.iXLen.iXLen.iXLen(iXLen, <64 x i8>, <64 x i8>, iXLen, iXLen)

define <1 x i16> @test_sf_vc_v_ivv_se_e16mf4(<1 x i16> %vd, <1 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivv_se_e16mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, tu, ma
; CHECK-NEXT:    sf.vc.v.ivv 3, v8, v9, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <1 x i16> @llvm.riscv.sf.vc.v.ivv.se.nxv1i16.iXLen.iXLen.iXLen(iXLen 3, <1 x i16> %vd, <1 x i16> %vs2, iXLen 10, iXLen %vl)
  ret <1 x i16> %0
}

declare <1 x i16> @llvm.riscv.sf.vc.v.ivv.se.nxv1i16.iXLen.iXLen.iXLen(iXLen, <1 x i16>, <1 x i16>, iXLen, iXLen)

define <2 x i16> @test_sf_vc_v_ivv_se_e16mf2(<2 x i16> %vd, <2 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivv_se_e16mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, tu, ma
; CHECK-NEXT:    sf.vc.v.ivv 3, v8, v9, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <2 x i16> @llvm.riscv.sf.vc.v.ivv.se.nxv2i16.iXLen.iXLen.iXLen(iXLen 3, <2 x i16> %vd, <2 x i16> %vs2, iXLen 10, iXLen %vl)
  ret <2 x i16> %0
}

declare <2 x i16> @llvm.riscv.sf.vc.v.ivv.se.nxv2i16.iXLen.iXLen.iXLen(iXLen, <2 x i16>, <2 x i16>, iXLen, iXLen)

define <4 x i16> @test_sf_vc_v_ivv_se_e16m1(<4 x i16> %vd, <4 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivv_se_e16m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf2, tu, ma
; CHECK-NEXT:    sf.vc.v.ivv 3, v8, v9, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <4 x i16> @llvm.riscv.sf.vc.v.ivv.se.nxv4i16.iXLen.iXLen.iXLen(iXLen 3, <4 x i16> %vd, <4 x i16> %vs2, iXLen 10, iXLen %vl)
  ret <4 x i16> %0
}

declare <4 x i16> @llvm.riscv.sf.vc.v.ivv.se.nxv4i16.iXLen.iXLen.iXLen(iXLen, <4 x i16>, <4 x i16>, iXLen, iXLen)

define <8 x i16> @test_sf_vc_v_ivv_se_e16m2(<8 x i16> %vd, <8 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivv_se_e16m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, tu, ma
; CHECK-NEXT:    sf.vc.v.ivv 3, v8, v9, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <8 x i16> @llvm.riscv.sf.vc.v.ivv.se.nxv8i16.iXLen.iXLen.iXLen(iXLen 3, <8 x i16> %vd, <8 x i16> %vs2, iXLen 10, iXLen %vl)
  ret <8 x i16> %0
}

declare <8 x i16> @llvm.riscv.sf.vc.v.ivv.se.nxv8i16.iXLen.iXLen.iXLen(iXLen, <8 x i16>, <8 x i16>, iXLen, iXLen)

define <16 x i16> @test_sf_vc_v_ivv_se_e16m4(<16 x i16> %vd, <16 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivv_se_e16m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m2, tu, ma
; CHECK-NEXT:    sf.vc.v.ivv 3, v8, v10, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <16 x i16> @llvm.riscv.sf.vc.v.ivv.se.nxv16i16.iXLen.iXLen.iXLen(iXLen 3, <16 x i16> %vd, <16 x i16> %vs2, iXLen 10, iXLen %vl)
  ret <16 x i16> %0
}

declare <16 x i16> @llvm.riscv.sf.vc.v.ivv.se.nxv16i16.iXLen.iXLen.iXLen(iXLen, <16 x i16>, <16 x i16>, iXLen, iXLen)

define <32 x i16> @test_sf_vc_v_ivv_se_e16m8(<32 x i16> %vd, <32 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivv_se_e16m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, tu, ma
; CHECK-NEXT:    sf.vc.v.ivv 3, v8, v12, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <32 x i16> @llvm.riscv.sf.vc.v.ivv.se.nxv32i16.iXLen.iXLen.iXLen(iXLen 3, <32 x i16> %vd, <32 x i16> %vs2, iXLen 10, iXLen %vl)
  ret <32 x i16> %0
}

declare <32 x i16> @llvm.riscv.sf.vc.v.ivv.se.nxv32i16.iXLen.iXLen.iXLen(iXLen, <32 x i16>, <32 x i16>, iXLen, iXLen)

define <1 x i32> @test_sf_vc_v_ivv_se_e32mf2(<1 x i32> %vd, <1 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivv_se_e32mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, tu, ma
; CHECK-NEXT:    sf.vc.v.ivv 3, v8, v9, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <1 x i32> @llvm.riscv.sf.vc.v.ivv.se.nxv1i32.iXLen.iXLen.iXLen(iXLen 3, <1 x i32> %vd, <1 x i32> %vs2, iXLen 10, iXLen %vl)
  ret <1 x i32> %0
}

declare <1 x i32> @llvm.riscv.sf.vc.v.ivv.se.nxv1i32.iXLen.iXLen.iXLen(iXLen, <1 x i32>, <1 x i32>, iXLen, iXLen)

define <2 x i32> @test_sf_vc_v_ivv_se_e32m1(<2 x i32> %vd, <2 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivv_se_e32m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, tu, ma
; CHECK-NEXT:    sf.vc.v.ivv 3, v8, v9, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <2 x i32> @llvm.riscv.sf.vc.v.ivv.se.nxv2i32.iXLen.iXLen.iXLen(iXLen 3, <2 x i32> %vd, <2 x i32> %vs2, iXLen 10, iXLen %vl)
  ret <2 x i32> %0
}

declare <2 x i32> @llvm.riscv.sf.vc.v.ivv.se.nxv2i32.iXLen.iXLen.iXLen(iXLen, <2 x i32>, <2 x i32>, iXLen, iXLen)

define <4 x i32> @test_sf_vc_v_ivv_se_e32m2(<4 x i32> %vd, <4 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivv_se_e32m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m1, tu, ma
; CHECK-NEXT:    sf.vc.v.ivv 3, v8, v9, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <4 x i32> @llvm.riscv.sf.vc.v.ivv.se.nxv4i32.iXLen.iXLen.iXLen(iXLen 3, <4 x i32> %vd, <4 x i32> %vs2, iXLen 10, iXLen %vl)
  ret <4 x i32> %0
}

declare <4 x i32> @llvm.riscv.sf.vc.v.ivv.se.nxv4i32.iXLen.iXLen.iXLen(iXLen, <4 x i32>, <4 x i32>, iXLen, iXLen)

define <8 x i32> @test_sf_vc_v_ivv_se_e32m4(<8 x i32> %vd, <8 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivv_se_e32m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, tu, ma
; CHECK-NEXT:    sf.vc.v.ivv 3, v8, v10, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <8 x i32> @llvm.riscv.sf.vc.v.ivv.se.nxv8i32.iXLen.iXLen.iXLen(iXLen 3, <8 x i32> %vd, <8 x i32> %vs2, iXLen 10, iXLen %vl)
  ret <8 x i32> %0
}

declare <8 x i32> @llvm.riscv.sf.vc.v.ivv.se.nxv8i32.iXLen.iXLen.iXLen(iXLen, <8 x i32>, <8 x i32>, iXLen, iXLen)

define <16 x i32> @test_sf_vc_v_ivv_se_e32m8(<16 x i32> %vd, <16 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivv_se_e32m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, tu, ma
; CHECK-NEXT:    sf.vc.v.ivv 3, v8, v12, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <16 x i32> @llvm.riscv.sf.vc.v.ivv.se.nxv16i32.iXLen.iXLen.iXLen(iXLen 3, <16 x i32> %vd, <16 x i32> %vs2, iXLen 10, iXLen %vl)
  ret <16 x i32> %0
}

declare <16 x i32> @llvm.riscv.sf.vc.v.ivv.se.nxv16i32.iXLen.iXLen.iXLen(iXLen, <16 x i32>, <16 x i32>, iXLen, iXLen)

define <1 x i64> @test_sf_vc_v_ivv_se_e64m1(<1 x i64> %vd, <1 x i64> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivv_se_e64m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, tu, ma
; CHECK-NEXT:    sf.vc.v.ivv 3, v8, v9, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <1 x i64> @llvm.riscv.sf.vc.v.ivv.se.nxv1i64.iXLen.iXLen.iXLen(iXLen 3, <1 x i64> %vd, <1 x i64> %vs2, iXLen 10, iXLen %vl)
  ret <1 x i64> %0
}

declare <1 x i64> @llvm.riscv.sf.vc.v.ivv.se.nxv1i64.iXLen.iXLen.iXLen(iXLen, <1 x i64>, <1 x i64>, iXLen, iXLen)

define <2 x i64> @test_sf_vc_v_ivv_se_e64m2(<2 x i64> %vd, <2 x i64> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivv_se_e64m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, tu, ma
; CHECK-NEXT:    sf.vc.v.ivv 3, v8, v9, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <2 x i64> @llvm.riscv.sf.vc.v.ivv.se.nxv2i64.iXLen.iXLen.iXLen(iXLen 3, <2 x i64> %vd, <2 x i64> %vs2, iXLen 10, iXLen %vl)
  ret <2 x i64> %0
}

declare <2 x i64> @llvm.riscv.sf.vc.v.ivv.se.nxv2i64.iXLen.iXLen.iXLen(iXLen, <2 x i64>, <2 x i64>, iXLen, iXLen)

define <4 x i64> @test_sf_vc_v_ivv_se_e64m4(<4 x i64> %vd, <4 x i64> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivv_se_e64m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m2, tu, ma
; CHECK-NEXT:    sf.vc.v.ivv 3, v8, v10, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <4 x i64> @llvm.riscv.sf.vc.v.ivv.se.nxv4i64.iXLen.iXLen.iXLen(iXLen 3, <4 x i64> %vd, <4 x i64> %vs2, iXLen 10, iXLen %vl)
  ret <4 x i64> %0
}

declare <4 x i64> @llvm.riscv.sf.vc.v.ivv.se.nxv4i64.iXLen.iXLen.iXLen(iXLen, <4 x i64>, <4 x i64>, iXLen, iXLen)

define <8 x i64> @test_sf_vc_v_ivv_se_e64m8(<8 x i64> %vd, <8 x i64> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivv_se_e64m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, tu, ma
; CHECK-NEXT:    sf.vc.v.ivv 3, v8, v12, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <8 x i64> @llvm.riscv.sf.vc.v.ivv.se.nxv8i64.iXLen.iXLen.iXLen(iXLen 3, <8 x i64> %vd, <8 x i64> %vs2, iXLen 10, iXLen %vl)
  ret <8 x i64> %0
}

declare <8 x i64> @llvm.riscv.sf.vc.v.ivv.se.nxv8i64.iXLen.iXLen.iXLen(iXLen, <8 x i64>, <8 x i64>, iXLen, iXLen)

define <1 x i8> @test_sf_vc_v_ivv_e8mf8(<1 x i8> %vd, <1 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivv_e8mf8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, tu, ma
; CHECK-NEXT:    sf.vc.v.ivv 3, v8, v9, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <1 x i8> @llvm.riscv.sf.vc.v.ivv.nxv1i8.iXLen.iXLen.iXLen(iXLen 3, <1 x i8> %vd, <1 x i8> %vs2, iXLen 10, iXLen %vl)
  ret <1 x i8> %0
}

declare <1 x i8> @llvm.riscv.sf.vc.v.ivv.nxv1i8.iXLen.iXLen.iXLen(iXLen, <1 x i8>, <1 x i8>, iXLen, iXLen)

define <2 x i8> @test_sf_vc_v_ivv_e8mf4(<2 x i8> %vd, <2 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivv_e8mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, tu, ma
; CHECK-NEXT:    sf.vc.v.ivv 3, v8, v9, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <2 x i8> @llvm.riscv.sf.vc.v.ivv.nxv2i8.iXLen.iXLen.iXLen(iXLen 3, <2 x i8> %vd, <2 x i8> %vs2, iXLen 10, iXLen %vl)
  ret <2 x i8> %0
}

declare <2 x i8> @llvm.riscv.sf.vc.v.ivv.nxv2i8.iXLen.iXLen.iXLen(iXLen, <2 x i8>, <2 x i8>, iXLen, iXLen)

define <4 x i8> @test_sf_vc_v_ivv_e8mf2(<4 x i8> %vd, <4 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivv_e8mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf4, tu, ma
; CHECK-NEXT:    sf.vc.v.ivv 3, v8, v9, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <4 x i8> @llvm.riscv.sf.vc.v.ivv.nxv4i8.iXLen.iXLen.iXLen(iXLen 3, <4 x i8> %vd, <4 x i8> %vs2, iXLen 10, iXLen %vl)
  ret <4 x i8> %0
}

declare <4 x i8> @llvm.riscv.sf.vc.v.ivv.nxv4i8.iXLen.iXLen.iXLen(iXLen, <4 x i8>, <4 x i8>, iXLen, iXLen)

define <8 x i8> @test_sf_vc_v_ivv_e8m1(<8 x i8> %vd, <8 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivv_e8m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf2, tu, ma
; CHECK-NEXT:    sf.vc.v.ivv 3, v8, v9, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <8 x i8> @llvm.riscv.sf.vc.v.ivv.nxv8i8.iXLen.iXLen.iXLen(iXLen 3, <8 x i8> %vd, <8 x i8> %vs2, iXLen 10, iXLen %vl)
  ret <8 x i8> %0
}

declare <8 x i8> @llvm.riscv.sf.vc.v.ivv.nxv8i8.iXLen.iXLen.iXLen(iXLen, <8 x i8>, <8 x i8>, iXLen, iXLen)

define <16 x i8> @test_sf_vc_v_ivv_e8m2(<16 x i8> %vd, <16 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivv_e8m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, tu, ma
; CHECK-NEXT:    sf.vc.v.ivv 3, v8, v9, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <16 x i8> @llvm.riscv.sf.vc.v.ivv.nxv16i8.iXLen.iXLen.iXLen(iXLen 3, <16 x i8> %vd, <16 x i8> %vs2, iXLen 10, iXLen %vl)
  ret <16 x i8> %0
}

declare <16 x i8> @llvm.riscv.sf.vc.v.ivv.nxv16i8.iXLen.iXLen.iXLen(iXLen, <16 x i8>, <16 x i8>, iXLen, iXLen)

define <32 x i8> @test_sf_vc_v_ivv_e8m4(<32 x i8> %vd, <32 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivv_e8m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m2, tu, ma
; CHECK-NEXT:    sf.vc.v.ivv 3, v8, v10, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <32 x i8> @llvm.riscv.sf.vc.v.ivv.nxv32i8.iXLen.iXLen.iXLen(iXLen 3, <32 x i8> %vd, <32 x i8> %vs2, iXLen 10, iXLen %vl)
  ret <32 x i8> %0
}

declare <32 x i8> @llvm.riscv.sf.vc.v.ivv.nxv32i8.iXLen.iXLen.iXLen(iXLen, <32 x i8>, <32 x i8>, iXLen, iXLen)

define <64 x i8> @test_sf_vc_v_ivv_e8m8(<64 x i8> %vd, <64 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivv_e8m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m4, tu, ma
; CHECK-NEXT:    sf.vc.v.ivv 3, v8, v12, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <64 x i8> @llvm.riscv.sf.vc.v.ivv.nxv64i8.iXLen.iXLen.iXLen(iXLen 3, <64 x i8> %vd, <64 x i8> %vs2, iXLen 10, iXLen %vl)
  ret <64 x i8> %0
}

declare <64 x i8> @llvm.riscv.sf.vc.v.ivv.nxv64i8.iXLen.iXLen.iXLen(iXLen, <64 x i8>, <64 x i8>, iXLen, iXLen)

define <1 x i16> @test_sf_vc_v_ivv_e16mf4(<1 x i16> %vd, <1 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivv_e16mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, tu, ma
; CHECK-NEXT:    sf.vc.v.ivv 3, v8, v9, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <1 x i16> @llvm.riscv.sf.vc.v.ivv.nxv1i16.iXLen.iXLen.iXLen(iXLen 3, <1 x i16> %vd, <1 x i16> %vs2, iXLen 10, iXLen %vl)
  ret <1 x i16> %0
}

declare <1 x i16> @llvm.riscv.sf.vc.v.ivv.nxv1i16.iXLen.iXLen.iXLen(iXLen, <1 x i16>, <1 x i16>, iXLen, iXLen)

define <2 x i16> @test_sf_vc_v_ivv_e16mf2(<2 x i16> %vd, <2 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivv_e16mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, tu, ma
; CHECK-NEXT:    sf.vc.v.ivv 3, v8, v9, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <2 x i16> @llvm.riscv.sf.vc.v.ivv.nxv2i16.iXLen.iXLen.iXLen(iXLen 3, <2 x i16> %vd, <2 x i16> %vs2, iXLen 10, iXLen %vl)
  ret <2 x i16> %0
}

declare <2 x i16> @llvm.riscv.sf.vc.v.ivv.nxv2i16.iXLen.iXLen.iXLen(iXLen, <2 x i16>, <2 x i16>, iXLen, iXLen)

define <4 x i16> @test_sf_vc_v_ivv_e16m1(<4 x i16> %vd, <4 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivv_e16m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf2, tu, ma
; CHECK-NEXT:    sf.vc.v.ivv 3, v8, v9, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <4 x i16> @llvm.riscv.sf.vc.v.ivv.nxv4i16.iXLen.iXLen.iXLen(iXLen 3, <4 x i16> %vd, <4 x i16> %vs2, iXLen 10, iXLen %vl)
  ret <4 x i16> %0
}

declare <4 x i16> @llvm.riscv.sf.vc.v.ivv.nxv4i16.iXLen.iXLen.iXLen(iXLen, <4 x i16>, <4 x i16>, iXLen, iXLen)

define <8 x i16> @test_sf_vc_v_ivv_e16m2(<8 x i16> %vd, <8 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivv_e16m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, tu, ma
; CHECK-NEXT:    sf.vc.v.ivv 3, v8, v9, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <8 x i16> @llvm.riscv.sf.vc.v.ivv.nxv8i16.iXLen.iXLen.iXLen(iXLen 3, <8 x i16> %vd, <8 x i16> %vs2, iXLen 10, iXLen %vl)
  ret <8 x i16> %0
}

declare <8 x i16> @llvm.riscv.sf.vc.v.ivv.nxv8i16.iXLen.iXLen.iXLen(iXLen, <8 x i16>, <8 x i16>, iXLen, iXLen)

define <16 x i16> @test_sf_vc_v_ivv_e16m4(<16 x i16> %vd, <16 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivv_e16m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m2, tu, ma
; CHECK-NEXT:    sf.vc.v.ivv 3, v8, v10, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <16 x i16> @llvm.riscv.sf.vc.v.ivv.nxv16i16.iXLen.iXLen.iXLen(iXLen 3, <16 x i16> %vd, <16 x i16> %vs2, iXLen 10, iXLen %vl)
  ret <16 x i16> %0
}

declare <16 x i16> @llvm.riscv.sf.vc.v.ivv.nxv16i16.iXLen.iXLen.iXLen(iXLen, <16 x i16>, <16 x i16>, iXLen, iXLen)

define <32 x i16> @test_sf_vc_v_ivv_e16m8(<32 x i16> %vd, <32 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivv_e16m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, tu, ma
; CHECK-NEXT:    sf.vc.v.ivv 3, v8, v12, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <32 x i16> @llvm.riscv.sf.vc.v.ivv.nxv32i16.iXLen.iXLen.iXLen(iXLen 3, <32 x i16> %vd, <32 x i16> %vs2, iXLen 10, iXLen %vl)
  ret <32 x i16> %0
}

declare <32 x i16> @llvm.riscv.sf.vc.v.ivv.nxv32i16.iXLen.iXLen.iXLen(iXLen, <32 x i16>, <32 x i16>, iXLen, iXLen)

define <1 x i32> @test_sf_vc_v_ivv_e32mf2(<1 x i32> %vd, <1 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivv_e32mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, tu, ma
; CHECK-NEXT:    sf.vc.v.ivv 3, v8, v9, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <1 x i32> @llvm.riscv.sf.vc.v.ivv.nxv1i32.iXLen.iXLen.iXLen(iXLen 3, <1 x i32> %vd, <1 x i32> %vs2, iXLen 10, iXLen %vl)
  ret <1 x i32> %0
}

declare <1 x i32> @llvm.riscv.sf.vc.v.ivv.nxv1i32.iXLen.iXLen.iXLen(iXLen, <1 x i32>, <1 x i32>, iXLen, iXLen)

define <2 x i32> @test_sf_vc_v_ivv_e32m1(<2 x i32> %vd, <2 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivv_e32m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, tu, ma
; CHECK-NEXT:    sf.vc.v.ivv 3, v8, v9, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <2 x i32> @llvm.riscv.sf.vc.v.ivv.nxv2i32.iXLen.iXLen.iXLen(iXLen 3, <2 x i32> %vd, <2 x i32> %vs2, iXLen 10, iXLen %vl)
  ret <2 x i32> %0
}

declare <2 x i32> @llvm.riscv.sf.vc.v.ivv.nxv2i32.iXLen.iXLen.iXLen(iXLen, <2 x i32>, <2 x i32>, iXLen, iXLen)

define <4 x i32> @test_sf_vc_v_ivv_e32m2(<4 x i32> %vd, <4 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivv_e32m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m1, tu, ma
; CHECK-NEXT:    sf.vc.v.ivv 3, v8, v9, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <4 x i32> @llvm.riscv.sf.vc.v.ivv.nxv4i32.iXLen.iXLen.iXLen(iXLen 3, <4 x i32> %vd, <4 x i32> %vs2, iXLen 10, iXLen %vl)
  ret <4 x i32> %0
}

declare <4 x i32> @llvm.riscv.sf.vc.v.ivv.nxv4i32.iXLen.iXLen.iXLen(iXLen, <4 x i32>, <4 x i32>, iXLen, iXLen)

define <8 x i32> @test_sf_vc_v_ivv_e32m4(<8 x i32> %vd, <8 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivv_e32m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, tu, ma
; CHECK-NEXT:    sf.vc.v.ivv 3, v8, v10, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <8 x i32> @llvm.riscv.sf.vc.v.ivv.nxv8i32.iXLen.iXLen.iXLen(iXLen 3, <8 x i32> %vd, <8 x i32> %vs2, iXLen 10, iXLen %vl)
  ret <8 x i32> %0
}

declare <8 x i32> @llvm.riscv.sf.vc.v.ivv.nxv8i32.iXLen.iXLen.iXLen(iXLen, <8 x i32>, <8 x i32>, iXLen, iXLen)

define <16 x i32> @test_sf_vc_v_ivv_e32m8(<16 x i32> %vd, <16 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivv_e32m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, tu, ma
; CHECK-NEXT:    sf.vc.v.ivv 3, v8, v12, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <16 x i32> @llvm.riscv.sf.vc.v.ivv.nxv16i32.iXLen.iXLen.iXLen(iXLen 3, <16 x i32> %vd, <16 x i32> %vs2, iXLen 10, iXLen %vl)
  ret <16 x i32> %0
}

declare <16 x i32> @llvm.riscv.sf.vc.v.ivv.nxv16i32.iXLen.iXLen.iXLen(iXLen, <16 x i32>, <16 x i32>, iXLen, iXLen)

define <1 x i64> @test_sf_vc_v_ivv_e64m1(<1 x i64> %vd, <1 x i64> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivv_e64m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, tu, ma
; CHECK-NEXT:    sf.vc.v.ivv 3, v8, v9, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <1 x i64> @llvm.riscv.sf.vc.v.ivv.nxv1i64.iXLen.iXLen.iXLen(iXLen 3, <1 x i64> %vd, <1 x i64> %vs2, iXLen 10, iXLen %vl)
  ret <1 x i64> %0
}

declare <1 x i64> @llvm.riscv.sf.vc.v.ivv.nxv1i64.iXLen.iXLen.iXLen(iXLen, <1 x i64>, <1 x i64>, iXLen, iXLen)

define <2 x i64> @test_sf_vc_v_ivv_e64m2(<2 x i64> %vd, <2 x i64> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivv_e64m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, tu, ma
; CHECK-NEXT:    sf.vc.v.ivv 3, v8, v9, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <2 x i64> @llvm.riscv.sf.vc.v.ivv.nxv2i64.iXLen.iXLen.iXLen(iXLen 3, <2 x i64> %vd, <2 x i64> %vs2, iXLen 10, iXLen %vl)
  ret <2 x i64> %0
}

declare <2 x i64> @llvm.riscv.sf.vc.v.ivv.nxv2i64.iXLen.iXLen.iXLen(iXLen, <2 x i64>, <2 x i64>, iXLen, iXLen)

define <4 x i64> @test_sf_vc_v_ivv_e64m4(<4 x i64> %vd, <4 x i64> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivv_e64m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m2, tu, ma
; CHECK-NEXT:    sf.vc.v.ivv 3, v8, v10, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <4 x i64> @llvm.riscv.sf.vc.v.ivv.nxv4i64.iXLen.iXLen.iXLen(iXLen 3, <4 x i64> %vd, <4 x i64> %vs2, iXLen 10, iXLen %vl)
  ret <4 x i64> %0
}

declare <4 x i64> @llvm.riscv.sf.vc.v.ivv.nxv4i64.iXLen.iXLen.iXLen(iXLen, <4 x i64>, <4 x i64>, iXLen, iXLen)

define <8 x i64> @test_sf_vc_v_ivv_e64m8(<8 x i64> %vd, <8 x i64> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivv_e64m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, tu, ma
; CHECK-NEXT:    sf.vc.v.ivv 3, v8, v12, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <8 x i64> @llvm.riscv.sf.vc.v.ivv.nxv8i64.iXLen.iXLen.iXLen(iXLen 3, <8 x i64> %vd, <8 x i64> %vs2, iXLen 10, iXLen %vl)
  ret <8 x i64> %0
}

declare <8 x i64> @llvm.riscv.sf.vc.v.ivv.nxv8i64.iXLen.iXLen.iXLen(iXLen, <8 x i64>, <8 x i64>, iXLen, iXLen)

define void @test_sf_vc_fvvv_se_e16mf4(<1 x half> %vd, <1 x i16> %vs2, <1 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvvv_se_e16mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-NEXT:    sf.vc.vvv 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv1f16.nxv1i16.nxv1i16.iXLen(iXLen 3, <1 x half> %vd, <1 x i16> %vs2, <1 x i16> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv1f16.nxv1i16.nxv1i16.iXLen(iXLen, <1 x half>, <1 x i16>, <1 x i16>, iXLen)

define <1 x half> @test_sf_vc_fv_fvv_se_e16mf4(<1 x half> %vd, <1 x i16> %vs2, <1 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fv_fvv_se_e16mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, tu, ma
; CHECK-NEXT:    sf.vc.v.vvv 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <1 x half> @llvm.riscv.sf.vc.v.vvv.se.nxv1f16.nxv1i16.nxv1i16.iXLen(iXLen 3, <1 x half> %vd, <1 x i16> %vs2, <1 x i16> %vs1, iXLen %vl)
  ret <1 x half> %0
}

declare <1 x half> @llvm.riscv.sf.vc.v.vvv.se.nxv1f16.nxv1i16.nxv1i16.iXLen(iXLen, <1 x half>, <1 x i16>, <1 x i16>, iXLen)

define void @test_sf_vc_fvvv_se_e16mf2(<2 x half> %vd, <2 x i16> %vs2, <2 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvvv_se_e16mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-NEXT:    sf.vc.vvv 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv2f16.nxv2i16.nxv2i16.iXLen(iXLen 3, <2 x half> %vd, <2 x i16> %vs2, <2 x i16> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv2f16.nxv2i16.nxv2i16.iXLen(iXLen, <2 x half>, <2 x i16>, <2 x i16>, iXLen)

define <2 x half> @test_sf_vc_fv_fvv_se_e16mf2(<2 x half> %vd, <2 x i16> %vs2, <2 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fv_fvv_se_e16mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, tu, ma
; CHECK-NEXT:    sf.vc.v.vvv 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <2 x half> @llvm.riscv.sf.vc.v.vvv.se.nxv2f16.nxv2i16.nxv2i16.iXLen(iXLen 3, <2 x half> %vd, <2 x i16> %vs2, <2 x i16> %vs1, iXLen %vl)
  ret <2 x half> %0
}

declare <2 x half> @llvm.riscv.sf.vc.v.vvv.se.nxv2f16.nxv2i16.nxv2i16.iXLen(iXLen, <2 x half>, <2 x i16>, <2 x i16>, iXLen)

define void @test_sf_vc_fvvv_se_e16m1(<4 x half> %vd, <4 x i16> %vs2, <4 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvvv_se_e16m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; CHECK-NEXT:    sf.vc.vvv 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv4f16.nxv4i16.nxv4i16.iXLen(iXLen 3, <4 x half> %vd, <4 x i16> %vs2, <4 x i16> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv4f16.nxv4i16.nxv4i16.iXLen(iXLen, <4 x half>, <4 x i16>, <4 x i16>, iXLen)

define <4 x half> @test_sf_vc_fv_fvv_se_e16m1(<4 x half> %vd, <4 x i16> %vs2, <4 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fv_fvv_se_e16m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf2, tu, ma
; CHECK-NEXT:    sf.vc.v.vvv 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <4 x half> @llvm.riscv.sf.vc.v.vvv.se.nxv4f16.nxv4i16.nxv4i16.iXLen(iXLen 3, <4 x half> %vd, <4 x i16> %vs2, <4 x i16> %vs1, iXLen %vl)
  ret <4 x half> %0
}

declare <4 x half> @llvm.riscv.sf.vc.v.vvv.se.nxv4f16.nxv4i16.nxv4i16.iXLen(iXLen, <4 x half>, <4 x i16>, <4 x i16>, iXLen)

define void @test_sf_vc_fvvv_se_e16m2(<8 x half> %vd, <8 x i16> %vs2, <8 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvvv_se_e16m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    sf.vc.vvv 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv8f16.nxv8i16.nxv8i16.iXLen(iXLen 3, <8 x half> %vd, <8 x i16> %vs2, <8 x i16> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv8f16.nxv8i16.nxv8i16.iXLen(iXLen, <8 x half>, <8 x i16>, <8 x i16>, iXLen)

define <8 x half> @test_sf_vc_fv_fvv_se_e16m2(<8 x half> %vd, <8 x i16> %vs2, <8 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fv_fvv_se_e16m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, tu, ma
; CHECK-NEXT:    sf.vc.v.vvv 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <8 x half> @llvm.riscv.sf.vc.v.vvv.se.nxv8f16.nxv8i16.nxv8i16.iXLen(iXLen 3, <8 x half> %vd, <8 x i16> %vs2, <8 x i16> %vs1, iXLen %vl)
  ret <8 x half> %0
}

declare <8 x half> @llvm.riscv.sf.vc.v.vvv.se.nxv8f16.nxv8i16.nxv8i16.iXLen(iXLen, <8 x half>, <8 x i16>, <8 x i16>, iXLen)

define void @test_sf_vc_fvvv_se_e16m4(<16 x half> %vd, <16 x i16> %vs2, <16 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvvv_se_e16m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; CHECK-NEXT:    sf.vc.vvv 3, v8, v10, v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv16f16.nxv16i16.nxv16i16.iXLen(iXLen 3, <16 x half> %vd, <16 x i16> %vs2, <16 x i16> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv16f16.nxv16i16.nxv16i16.iXLen(iXLen, <16 x half>, <16 x i16>, <16 x i16>, iXLen)

define <16 x half> @test_sf_vc_fv_fvv_se_e16m4(<16 x half> %vd, <16 x i16> %vs2, <16 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fv_fvv_se_e16m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m2, tu, ma
; CHECK-NEXT:    sf.vc.v.vvv 3, v8, v10, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call <16 x half> @llvm.riscv.sf.vc.v.vvv.se.nxv16f16.nxv16i16.nxv16i16.iXLen(iXLen 3, <16 x half> %vd, <16 x i16> %vs2, <16 x i16> %vs1, iXLen %vl)
  ret <16 x half> %0
}

declare <16 x half> @llvm.riscv.sf.vc.v.vvv.se.nxv16f16.nxv16i16.nxv16i16.iXLen(iXLen, <16 x half>, <16 x i16>, <16 x i16>, iXLen)

define void @test_sf_vc_fvvv_se_e16m8(<32 x half> %vd, <32 x i16> %vs2, <32 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvvv_se_e16m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    sf.vc.vvv 3, v8, v12, v16
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv32f16.nxv32i16.nxv32i16.iXLen(iXLen 3, <32 x half> %vd, <32 x i16> %vs2, <32 x i16> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv32f16.nxv32i16.nxv32i16.iXLen(iXLen, <32 x half>, <32 x i16>, <32 x i16>, iXLen)

define <32 x half> @test_sf_vc_fv_fvv_se_e16m8(<32 x half> %vd, <32 x i16> %vs2, <32 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fv_fvv_se_e16m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, tu, ma
; CHECK-NEXT:    sf.vc.v.vvv 3, v8, v12, v16
; CHECK-NEXT:    ret
entry:
  %0 = tail call <32 x half> @llvm.riscv.sf.vc.v.vvv.se.nxv32f16.nxv32i16.nxv32i16.iXLen(iXLen 3, <32 x half> %vd, <32 x i16> %vs2, <32 x i16> %vs1, iXLen %vl)
  ret <32 x half> %0
}

declare <32 x half> @llvm.riscv.sf.vc.v.vvv.se.nxv32f16.nxv32i16.nxv32i16.iXLen(iXLen, <32 x half>, <32 x i16>, <32 x i16>, iXLen)

define void @test_sf_vc_fvvv_se_e32mf2(<1 x float> %vd, <1 x i32> %vs2, <1 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvvv_se_e32mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    sf.vc.vvv 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv1f32.nxv1i32.nxv1i32.iXLen(iXLen 3, <1 x float> %vd, <1 x i32> %vs2, <1 x i32> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv1f32.nxv1i32.nxv1i32.iXLen(iXLen, <1 x float>, <1 x i32>, <1 x i32>, iXLen)

define <1 x float> @test_sf_vc_fv_fvv_se_e32mf2(<1 x float> %vd, <1 x i32> %vs2, <1 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fv_fvv_se_e32mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, tu, ma
; CHECK-NEXT:    sf.vc.v.vvv 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <1 x float> @llvm.riscv.sf.vc.v.vvv.se.nxv1f32.nxv1i32.nxv1i32.iXLen(iXLen 3, <1 x float> %vd, <1 x i32> %vs2, <1 x i32> %vs1, iXLen %vl)
  ret <1 x float> %0
}

declare <1 x float> @llvm.riscv.sf.vc.v.vvv.se.nxv1f32.nxv1i32.nxv1i32.iXLen(iXLen, <1 x float>, <1 x i32>, <1 x i32>, iXLen)

define void @test_sf_vc_fvvv_se_e32m1(<2 x float> %vd, <2 x i32> %vs2, <2 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvvv_se_e32m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    sf.vc.vvv 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv2f32.nxv2i32.nxv2i32.iXLen(iXLen 3, <2 x float> %vd, <2 x i32> %vs2, <2 x i32> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv2f32.nxv2i32.nxv2i32.iXLen(iXLen, <2 x float>, <2 x i32>, <2 x i32>, iXLen)

define <2 x float> @test_sf_vc_fv_fvv_se_e32m1(<2 x float> %vd, <2 x i32> %vs2, <2 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fv_fvv_se_e32m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, tu, ma
; CHECK-NEXT:    sf.vc.v.vvv 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <2 x float> @llvm.riscv.sf.vc.v.vvv.se.nxv2f32.nxv2i32.nxv2i32.iXLen(iXLen 3, <2 x float> %vd, <2 x i32> %vs2, <2 x i32> %vs1, iXLen %vl)
  ret <2 x float> %0
}

declare <2 x float> @llvm.riscv.sf.vc.v.vvv.se.nxv2f32.nxv2i32.nxv2i32.iXLen(iXLen, <2 x float>, <2 x i32>, <2 x i32>, iXLen)

define void @test_sf_vc_fvvv_se_e32m2(<4 x float> %vd, <4 x i32> %vs2, <4 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvvv_se_e32m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; CHECK-NEXT:    sf.vc.vvv 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv4f32.nxv4i32.nxv4i32.iXLen(iXLen 3, <4 x float> %vd, <4 x i32> %vs2, <4 x i32> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv4f32.nxv4i32.nxv4i32.iXLen(iXLen, <4 x float>, <4 x i32>, <4 x i32>, iXLen)

define <4 x float> @test_sf_vc_fv_fvv_se_e32m2(<4 x float> %vd, <4 x i32> %vs2, <4 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fv_fvv_se_e32m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m1, tu, ma
; CHECK-NEXT:    sf.vc.v.vvv 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <4 x float> @llvm.riscv.sf.vc.v.vvv.se.nxv4f32.nxv4i32.nxv4i32.iXLen(iXLen 3, <4 x float> %vd, <4 x i32> %vs2, <4 x i32> %vs1, iXLen %vl)
  ret <4 x float> %0
}

declare <4 x float> @llvm.riscv.sf.vc.v.vvv.se.nxv4f32.nxv4i32.nxv4i32.iXLen(iXLen, <4 x float>, <4 x i32>, <4 x i32>, iXLen)

define void @test_sf_vc_fvvv_se_e32m4(<8 x float> %vd, <8 x i32> %vs2, <8 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvvv_se_e32m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; CHECK-NEXT:    sf.vc.vvv 3, v8, v10, v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv8f32.nxv8i32.nxv8i32.iXLen(iXLen 3, <8 x float> %vd, <8 x i32> %vs2, <8 x i32> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv8f32.nxv8i32.nxv8i32.iXLen(iXLen, <8 x float>, <8 x i32>, <8 x i32>, iXLen)

define <8 x float> @test_sf_vc_fv_fvv_se_e32m4(<8 x float> %vd, <8 x i32> %vs2, <8 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fv_fvv_se_e32m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, tu, ma
; CHECK-NEXT:    sf.vc.v.vvv 3, v8, v10, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call <8 x float> @llvm.riscv.sf.vc.v.vvv.se.nxv8f32.nxv8i32.nxv8i32.iXLen(iXLen 3, <8 x float> %vd, <8 x i32> %vs2, <8 x i32> %vs1, iXLen %vl)
  ret <8 x float> %0
}

declare <8 x float> @llvm.riscv.sf.vc.v.vvv.se.nxv8f32.nxv8i32.nxv8i32.iXLen(iXLen, <8 x float>, <8 x i32>, <8 x i32>, iXLen)

define void @test_sf_vc_fvvv_se_e32m8(<16 x float> %vd, <16 x i32> %vs2, <16 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvvv_se_e32m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    sf.vc.vvv 3, v8, v12, v16
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv16f32.nxv16i32.nxv16i32.iXLen(iXLen 3, <16 x float> %vd, <16 x i32> %vs2, <16 x i32> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv16f32.nxv16i32.nxv16i32.iXLen(iXLen, <16 x float>, <16 x i32>, <16 x i32>, iXLen)

define <16 x float> @test_sf_vc_fv_fvv_se_e32m8(<16 x float> %vd, <16 x i32> %vs2, <16 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fv_fvv_se_e32m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, tu, ma
; CHECK-NEXT:    sf.vc.v.vvv 3, v8, v12, v16
; CHECK-NEXT:    ret
entry:
  %0 = tail call <16 x float> @llvm.riscv.sf.vc.v.vvv.se.nxv16f32.nxv16i32.nxv16i32.iXLen(iXLen 3, <16 x float> %vd, <16 x i32> %vs2, <16 x i32> %vs1, iXLen %vl)
  ret <16 x float> %0
}

declare <16 x float> @llvm.riscv.sf.vc.v.vvv.se.nxv16f32.nxv16i32.nxv16i32.iXLen(iXLen, <16 x float>, <16 x i32>, <16 x i32>, iXLen)

define void @test_sf_vc_fvvv_se_e64m1(<1 x double> %vd, <1 x i64> %vs2, <1 x i64> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvvv_se_e64m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    sf.vc.vvv 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv1f64.nxv1i64.nxv1i64.iXLen(iXLen 3, <1 x double> %vd, <1 x i64> %vs2, <1 x i64> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv1f64.nxv1i64.nxv1i64.iXLen(iXLen, <1 x double>, <1 x i64>, <1 x i64>, iXLen)

define <1 x double> @test_sf_vc_fv_fvv_se_e64m1(<1 x double> %vd, <1 x i64> %vs2, <1 x i64> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fv_fvv_se_e64m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, tu, ma
; CHECK-NEXT:    sf.vc.v.vvv 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <1 x double> @llvm.riscv.sf.vc.v.vvv.se.nxv1f64.nxv1i64.nxv1i64.iXLen(iXLen 3, <1 x double> %vd, <1 x i64> %vs2, <1 x i64> %vs1, iXLen %vl)
  ret <1 x double> %0
}

declare <1 x double> @llvm.riscv.sf.vc.v.vvv.se.nxv1f64.nxv1i64.nxv1i64.iXLen(iXLen, <1 x double>, <1 x i64>, <1 x i64>, iXLen)

define void @test_sf_vc_fvvv_se_e64m2(<2 x double> %vd, <2 x i64> %vs2, <2 x i64> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvvv_se_e64m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    sf.vc.vvv 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv2f64.nxv2i64.nxv2i64.iXLen(iXLen 3, <2 x double> %vd, <2 x i64> %vs2, <2 x i64> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv2f64.nxv2i64.nxv2i64.iXLen(iXLen, <2 x double>, <2 x i64>, <2 x i64>, iXLen)

define <2 x double> @test_sf_vc_fv_fvv_se_e64m2(<2 x double> %vd, <2 x i64> %vs2, <2 x i64> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fv_fvv_se_e64m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, tu, ma
; CHECK-NEXT:    sf.vc.v.vvv 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <2 x double> @llvm.riscv.sf.vc.v.vvv.se.nxv2f64.nxv2i64.nxv2i64.iXLen(iXLen 3, <2 x double> %vd, <2 x i64> %vs2, <2 x i64> %vs1, iXLen %vl)
  ret <2 x double> %0
}

declare <2 x double> @llvm.riscv.sf.vc.v.vvv.se.nxv2f64.nxv2i64.nxv2i64.iXLen(iXLen, <2 x double>, <2 x i64>, <2 x i64>, iXLen)

define void @test_sf_vc_fvvv_se_e64m4(<4 x double> %vd, <4 x i64> %vs2, <4 x i64> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvvv_se_e64m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; CHECK-NEXT:    sf.vc.vvv 3, v8, v10, v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv4f64.nxv4i64.nxv4i64.iXLen(iXLen 3, <4 x double> %vd, <4 x i64> %vs2, <4 x i64> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv4f64.nxv4i64.nxv4i64.iXLen(iXLen, <4 x double>, <4 x i64>, <4 x i64>, iXLen)

define <4 x double> @test_sf_vc_fv_fvv_se_e64m4(<4 x double> %vd, <4 x i64> %vs2, <4 x i64> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fv_fvv_se_e64m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m2, tu, ma
; CHECK-NEXT:    sf.vc.v.vvv 3, v8, v10, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call <4 x double> @llvm.riscv.sf.vc.v.vvv.se.nxv4f64.nxv4i64.nxv4i64.iXLen(iXLen 3, <4 x double> %vd, <4 x i64> %vs2, <4 x i64> %vs1, iXLen %vl)
  ret <4 x double> %0
}

declare <4 x double> @llvm.riscv.sf.vc.v.vvv.se.nxv4f64.nxv4i64.nxv4i64.iXLen(iXLen, <4 x double>, <4 x i64>, <4 x i64>, iXLen)

define void @test_sf_vc_fvvv_se_e64m8(<8 x double> %vd, <8 x i64> %vs2, <8 x i64> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvvv_se_e64m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    sf.vc.vvv 3, v8, v12, v16
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv8f64.nxv8i64.nxv8i64.iXLen(iXLen 3, <8 x double> %vd, <8 x i64> %vs2, <8 x i64> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vvv.se.iXLen.nxv8f64.nxv8i64.nxv8i64.iXLen(iXLen, <8 x double>, <8 x i64>, <8 x i64>, iXLen)

define <8 x double> @test_sf_vc_fv_fvv_se_e64m8(<8 x double> %vd, <8 x i64> %vs2, <8 x i64> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fv_fvv_se_e64m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, tu, ma
; CHECK-NEXT:    sf.vc.v.vvv 3, v8, v12, v16
; CHECK-NEXT:    ret
entry:
  %0 = tail call <8 x double> @llvm.riscv.sf.vc.v.vvv.se.nxv8f64.nxv8i64.nxv8i64.iXLen(iXLen 3, <8 x double> %vd, <8 x i64> %vs2, <8 x i64> %vs1, iXLen %vl)
  ret <8 x double> %0
}

declare <8 x double> @llvm.riscv.sf.vc.v.vvv.se.nxv8f64.nxv8i64.nxv8i64.iXLen(iXLen, <8 x double>, <8 x i64>, <8 x i64>, iXLen)

define void @test_sf_vc_fvvx_se_e16mf4(<1 x half> %vd, <1 x i16> %vs2, i16 %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvvx_se_e16mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    sf.vc.xvv 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xvv.se.iXLen.nxv1f16.nxv1i16.i16.iXLen(iXLen 3, <1 x half> %vd, <1 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xvv.se.iXLen.nxv1f16.nxv1i16.i16.iXLen(iXLen, <1 x half>, <1 x i16>, i16, iXLen)

define <1 x half> @test_sf_vc_v_fvvx_se_e16mf4(<1 x half> %vd, <1 x i16> %vs2, i16 %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fvvx_se_e16mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, tu, ma
; CHECK-NEXT:    sf.vc.v.xvv 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <1 x half> @llvm.riscv.sf.vc.v.xvv.se.nxv1f16.nxv1f16.nxv1i16.i16.iXLen(iXLen 3, <1 x half> %vd, <1 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret <1 x half> %0
}

declare <1 x half> @llvm.riscv.sf.vc.v.xvv.se.nxv1f16.nxv1f16.nxv1i16.i16.iXLen(iXLen, <1 x half>, <1 x i16>, i16, iXLen)

define void @test_sf_vc_fvvx_se_e16mf2(<2 x half> %vd, <2 x i16> %vs2, i16 %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvvx_se_e16mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    sf.vc.xvv 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xvv.se.iXLen.nxv2f16.nxv2i16.i16.iXLen(iXLen 3, <2 x half> %vd, <2 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xvv.se.iXLen.nxv2f16.nxv2i16.i16.iXLen(iXLen, <2 x half>, <2 x i16>, i16, iXLen)

define <2 x half> @test_sf_vc_v_fvvx_se_e16mf2(<2 x half> %vd, <2 x i16> %vs2, i16 %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fvvx_se_e16mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, tu, ma
; CHECK-NEXT:    sf.vc.v.xvv 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <2 x half> @llvm.riscv.sf.vc.v.xvv.se.nxv2f16.nxv2f16.nxv2i16.i16.iXLen(iXLen 3, <2 x half> %vd, <2 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret <2 x half> %0
}

declare <2 x half> @llvm.riscv.sf.vc.v.xvv.se.nxv2f16.nxv2f16.nxv2i16.i16.iXLen(iXLen, <2 x half>, <2 x i16>, i16, iXLen)

define void @test_sf_vc_fvvx_se_e16m1(<4 x half> %vd, <4 x i16> %vs2, i16 %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvvx_se_e16m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    sf.vc.xvv 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xvv.se.iXLen.nxv4f16.nxv4i16.i16.iXLen(iXLen 3, <4 x half> %vd, <4 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xvv.se.iXLen.nxv4f16.nxv4i16.i16.iXLen(iXLen, <4 x half>, <4 x i16>, i16, iXLen)

define <4 x half> @test_sf_vc_v_fvvx_se_e16m1(<4 x half> %vd, <4 x i16> %vs2, i16 %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fvvx_se_e16m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, tu, ma
; CHECK-NEXT:    sf.vc.v.xvv 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <4 x half> @llvm.riscv.sf.vc.v.xvv.se.nxv4f16.nxv4f16.nxv4i16.i16.iXLen(iXLen 3, <4 x half> %vd, <4 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret <4 x half> %0
}

declare <4 x half> @llvm.riscv.sf.vc.v.xvv.se.nxv4f16.nxv4f16.nxv4i16.i16.iXLen(iXLen, <4 x half>, <4 x i16>, i16, iXLen)

define void @test_sf_vc_fvvx_se_e16m2(<8 x half> %vd, <8 x i16> %vs2, i16 %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvvx_se_e16m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    sf.vc.xvv 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xvv.se.iXLen.nxv8f16.nxv8i16.i16.iXLen(iXLen 3, <8 x half> %vd, <8 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xvv.se.iXLen.nxv8f16.nxv8i16.i16.iXLen(iXLen, <8 x half>, <8 x i16>, i16, iXLen)

define <8 x half> @test_sf_vc_v_fvvx_se_e16m2(<8 x half> %vd, <8 x i16> %vs2, i16 %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fvvx_se_e16m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, tu, ma
; CHECK-NEXT:    sf.vc.v.xvv 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <8 x half> @llvm.riscv.sf.vc.v.xvv.se.nxv8f16.nxv8f16.nxv8i16.i16.iXLen(iXLen 3, <8 x half> %vd, <8 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret <8 x half> %0
}

declare <8 x half> @llvm.riscv.sf.vc.v.xvv.se.nxv8f16.nxv8f16.nxv8i16.i16.iXLen(iXLen, <8 x half>, <8 x i16>, i16, iXLen)

define void @test_sf_vc_fvvx_se_e16m4(<16 x half> %vd, <16 x i16> %vs2, i16 %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvvx_se_e16m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    sf.vc.xvv 3, v8, v10, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xvv.se.iXLen.nxv16f16.nxv16i16.i16.iXLen(iXLen 3, <16 x half> %vd, <16 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xvv.se.iXLen.nxv16f16.nxv16i16.i16.iXLen(iXLen, <16 x half>, <16 x i16>, i16, iXLen)

define <16 x half> @test_sf_vc_v_fvvx_se_e16m4(<16 x half> %vd, <16 x i16> %vs2, i16 %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fvvx_se_e16m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, tu, ma
; CHECK-NEXT:    sf.vc.v.xvv 3, v8, v10, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <16 x half> @llvm.riscv.sf.vc.v.xvv.se.nxv16f16.nxv16f16.nxv16i16.i16.iXLen(iXLen 3, <16 x half> %vd, <16 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret <16 x half> %0
}

declare <16 x half> @llvm.riscv.sf.vc.v.xvv.se.nxv16f16.nxv16f16.nxv16i16.i16.iXLen(iXLen, <16 x half>, <16 x i16>, i16, iXLen)

define void @test_sf_vc_fvvx_se_e16m8(<32 x half> %vd, <32 x i16> %vs2, i16 %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvvx_se_e16m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, ma
; CHECK-NEXT:    sf.vc.xvv 3, v8, v12, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xvv.se.iXLen.nxv32f16.nxv32i16.i16.iXLen(iXLen 3, <32 x half> %vd, <32 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xvv.se.iXLen.nxv32f16.nxv32i16.i16.iXLen(iXLen, <32 x half>, <32 x i16>, i16, iXLen)

define <32 x half> @test_sf_vc_v_fvvx_se_e16m8(<32 x half> %vd, <32 x i16> %vs2, i16 %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fvvx_se_e16m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, tu, ma
; CHECK-NEXT:    sf.vc.v.xvv 3, v8, v12, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <32 x half> @llvm.riscv.sf.vc.v.xvv.se.nxv32f16.nxv32f16.nxv32i16.i16.iXLen(iXLen 3, <32 x half> %vd, <32 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret <32 x half> %0
}

declare <32 x half> @llvm.riscv.sf.vc.v.xvv.se.nxv32f16.nxv32f16.nxv32i16.i16.iXLen(iXLen, <32 x half>, <32 x i16>, i16, iXLen)

define void @test_sf_vc_fvvx_se_e32mf2(<1 x float> %vd, <1 x i32> %vs2, i32 %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvvx_se_e32mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    sf.vc.xvv 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xvv.se.iXLen.nxv1f32.nxv1i32.i32.iXLen(iXLen 3, <1 x float> %vd, <1 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xvv.se.iXLen.nxv1f32.nxv1i32.i32.iXLen(iXLen, <1 x float>, <1 x i32>, i32, iXLen)

define <1 x float> @test_sf_vc_v_fvvx_se_e32mf2(<1 x float> %vd, <1 x i32> %vs2, i32 %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fvvx_se_e32mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, tu, ma
; CHECK-NEXT:    sf.vc.v.xvv 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <1 x float> @llvm.riscv.sf.vc.v.xvv.se.nxv1f32.nxv1f32.nxv1i32.i32.iXLen(iXLen 3, <1 x float> %vd, <1 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret <1 x float> %0
}

declare <1 x float> @llvm.riscv.sf.vc.v.xvv.se.nxv1f32.nxv1f32.nxv1i32.i32.iXLen(iXLen, <1 x float>, <1 x i32>, i32, iXLen)

define void @test_sf_vc_fvvx_se_e32m1(<2 x float> %vd, <2 x i32> %vs2, i32 %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvvx_se_e32m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    sf.vc.xvv 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xvv.se.iXLen.nxv2f32.nxv2i32.i32.iXLen(iXLen 3, <2 x float> %vd, <2 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xvv.se.iXLen.nxv2f32.nxv2i32.i32.iXLen(iXLen, <2 x float>, <2 x i32>, i32, iXLen)

define <2 x float> @test_sf_vc_v_fvvx_se_e32m1(<2 x float> %vd, <2 x i32> %vs2, i32 %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fvvx_se_e32m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, tu, ma
; CHECK-NEXT:    sf.vc.v.xvv 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <2 x float> @llvm.riscv.sf.vc.v.xvv.se.nxv2f32.nxv2f32.nxv2i32.i32.iXLen(iXLen 3, <2 x float> %vd, <2 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret <2 x float> %0
}

declare <2 x float> @llvm.riscv.sf.vc.v.xvv.se.nxv2f32.nxv2f32.nxv2i32.i32.iXLen(iXLen, <2 x float>, <2 x i32>, i32, iXLen)

define void @test_sf_vc_fvvx_se_e32m2(<4 x float> %vd, <4 x i32> %vs2, i32 %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvvx_se_e32m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    sf.vc.xvv 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xvv.se.iXLen.nxv4f32.nxv4i32.i32.iXLen(iXLen 3, <4 x float> %vd, <4 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xvv.se.iXLen.nxv4f32.nxv4i32.i32.iXLen(iXLen, <4 x float>, <4 x i32>, i32, iXLen)

define <4 x float> @test_sf_vc_v_fvvx_se_e32m2(<4 x float> %vd, <4 x i32> %vs2, i32 %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fvvx_se_e32m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, tu, ma
; CHECK-NEXT:    sf.vc.v.xvv 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <4 x float> @llvm.riscv.sf.vc.v.xvv.se.nxv4f32.nxv4f32.nxv4i32.i32.iXLen(iXLen 3, <4 x float> %vd, <4 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret <4 x float> %0
}

declare <4 x float> @llvm.riscv.sf.vc.v.xvv.se.nxv4f32.nxv4f32.nxv4i32.i32.iXLen(iXLen, <4 x float>, <4 x i32>, i32, iXLen)

define void @test_sf_vc_fvvx_se_e32m4(<8 x float> %vd, <8 x i32> %vs2, i32 %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvvx_se_e32m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    sf.vc.xvv 3, v8, v10, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xvv.se.iXLen.nxv8f32.nxv8i32.i32.iXLen(iXLen 3, <8 x float> %vd, <8 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xvv.se.iXLen.nxv8f32.nxv8i32.i32.iXLen(iXLen, <8 x float>, <8 x i32>, i32, iXLen)

define <8 x float> @test_sf_vc_v_fvvx_se_e32m4(<8 x float> %vd, <8 x i32> %vs2, i32 %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fvvx_se_e32m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, tu, ma
; CHECK-NEXT:    sf.vc.v.xvv 3, v8, v10, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <8 x float> @llvm.riscv.sf.vc.v.xvv.se.nxv8f32.nxv8f32.nxv8i32.i32.iXLen(iXLen 3, <8 x float> %vd, <8 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret <8 x float> %0
}

declare <8 x float> @llvm.riscv.sf.vc.v.xvv.se.nxv8f32.nxv8f32.nxv8i32.i32.iXLen(iXLen, <8 x float>, <8 x i32>, i32, iXLen)

define void @test_sf_vc_fvvx_se_e32m8(<16 x float> %vd, <16 x i32> %vs2, i32 %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvvx_se_e32m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    sf.vc.xvv 3, v8, v12, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xvv.se.iXLen.nxv16f32.nxv16i32.i32.iXLen(iXLen 3, <16 x float> %vd, <16 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xvv.se.iXLen.nxv16f32.nxv16i32.i32.iXLen(iXLen, <16 x float>, <16 x i32>, i32, iXLen)

define <16 x float> @test_sf_vc_v_fvvx_se_e32m8(<16 x float> %vd, <16 x i32> %vs2, i32 %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fvvx_se_e32m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, tu, ma
; CHECK-NEXT:    sf.vc.v.xvv 3, v8, v12, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <16 x float> @llvm.riscv.sf.vc.v.xvv.se.nxv16f32.nxv16f32.nxv16i32.i32.iXLen(iXLen 3, <16 x float> %vd, <16 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret <16 x float> %0
}

declare <16 x float> @llvm.riscv.sf.vc.v.xvv.se.nxv16f32.nxv16f32.nxv16i32.i32.iXLen(iXLen, <16 x float>, <16 x i32>, i32, iXLen)

define void @test_sf_vc_fvvi_se_e16mf4(<1 x half> %vd, <1 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvvi_se_e16mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-NEXT:    sf.vc.ivv 3, v8, v9, 3
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.ivv.se.iXLen.nxv1f16.nxv1i16.iXLen.iXLen(iXLen 3, <1 x half> %vd, <1 x i16> %vs2, iXLen 3, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.ivv.se.iXLen.nxv1f16.nxv1i16.iXLen.iXLen(iXLen, <1 x half>, <1 x i16>, iXLen, iXLen)

define <1 x half> @test_sf_vc_fv_fvvi_se_e16mf4(<1 x half> %vd, <1 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fv_fvvi_se_e16mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, tu, ma
; CHECK-NEXT:    sf.vc.v.ivv 3, v8, v9, 3
; CHECK-NEXT:    ret
entry:
  %0 = tail call <1 x half> @llvm.riscv.sf.vc.v.ivv.se.nxv1f16.nxv1f16.nxv1i16.iXLen.iXLen(iXLen 3, <1 x half> %vd, <1 x i16> %vs2, iXLen 3, iXLen %vl)
  ret <1 x half> %0
}

declare <1 x half> @llvm.riscv.sf.vc.v.ivv.se.nxv1f16.nxv1f16.nxv1i16.iXLen.iXLen(iXLen, <1 x half>, <1 x i16>, iXLen, iXLen)

define void @test_sf_vc_fvvi_se_e16mf2(<2 x half> %vd, <2 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvvi_se_e16mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-NEXT:    sf.vc.ivv 3, v8, v9, 3
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.ivv.se.iXLen.nxv2f16.nxv2i16.iXLen.iXLen(iXLen 3, <2 x half> %vd, <2 x i16> %vs2, iXLen 3, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.ivv.se.iXLen.nxv2f16.nxv2i16.iXLen.iXLen(iXLen, <2 x half>, <2 x i16>, iXLen, iXLen)

define <2 x half> @test_sf_vc_fv_fvvi_se_e16mf2(<2 x half> %vd, <2 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fv_fvvi_se_e16mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, tu, ma
; CHECK-NEXT:    sf.vc.v.ivv 3, v8, v9, 3
; CHECK-NEXT:    ret
entry:
  %0 = tail call <2 x half> @llvm.riscv.sf.vc.v.ivv.se.nxv2f16.nxv2f16.nxv2i16.iXLen.iXLen(iXLen 3, <2 x half> %vd, <2 x i16> %vs2, iXLen 3, iXLen %vl)
  ret <2 x half> %0
}

declare <2 x half> @llvm.riscv.sf.vc.v.ivv.se.nxv2f16.nxv2f16.nxv2i16.iXLen.iXLen(iXLen, <2 x half>, <2 x i16>, iXLen, iXLen)

define void @test_sf_vc_fvvi_se_e16m1(<4 x half> %vd, <4 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvvi_se_e16m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; CHECK-NEXT:    sf.vc.ivv 3, v8, v9, 3
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.ivv.se.iXLen.nxv4f16.nxv4i16.iXLen.iXLen(iXLen 3, <4 x half> %vd, <4 x i16> %vs2, iXLen 3, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.ivv.se.iXLen.nxv4f16.nxv4i16.iXLen.iXLen(iXLen, <4 x half>, <4 x i16>, iXLen, iXLen)

define <4 x half> @test_sf_vc_fv_fvvi_se_e16m1(<4 x half> %vd, <4 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fv_fvvi_se_e16m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf2, tu, ma
; CHECK-NEXT:    sf.vc.v.ivv 3, v8, v9, 3
; CHECK-NEXT:    ret
entry:
  %0 = tail call <4 x half> @llvm.riscv.sf.vc.v.ivv.se.nxv4f16.nxv4f16.nxv4i16.iXLen.iXLen(iXLen 3, <4 x half> %vd, <4 x i16> %vs2, iXLen 3, iXLen %vl)
  ret <4 x half> %0
}

declare <4 x half> @llvm.riscv.sf.vc.v.ivv.se.nxv4f16.nxv4f16.nxv4i16.iXLen.iXLen(iXLen, <4 x half>, <4 x i16>, iXLen, iXLen)

define void @test_sf_vc_fvvi_se_e16m2(<8 x half> %vd, <8 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvvi_se_e16m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    sf.vc.ivv 3, v8, v9, 3
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.ivv.se.iXLen.nxv8f16.nxv8i16.iXLen.iXLen(iXLen 3, <8 x half> %vd, <8 x i16> %vs2, iXLen 3, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.ivv.se.iXLen.nxv8f16.nxv8i16.iXLen.iXLen(iXLen, <8 x half>, <8 x i16>, iXLen, iXLen)

define <8 x half> @test_sf_vc_fv_fvvi_se_e16m2(<8 x half> %vd, <8 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fv_fvvi_se_e16m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, tu, ma
; CHECK-NEXT:    sf.vc.v.ivv 3, v8, v9, 3
; CHECK-NEXT:    ret
entry:
  %0 = tail call <8 x half> @llvm.riscv.sf.vc.v.ivv.se.nxv8f16.nxv8f16.nxv8i16.iXLen.iXLen(iXLen 3, <8 x half> %vd, <8 x i16> %vs2, iXLen 3, iXLen %vl)
  ret <8 x half> %0
}

declare <8 x half> @llvm.riscv.sf.vc.v.ivv.se.nxv8f16.nxv8f16.nxv8i16.iXLen.iXLen(iXLen, <8 x half>, <8 x i16>, iXLen, iXLen)

define void @test_sf_vc_fvvi_se_e16m4(<16 x half> %vd, <16 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvvi_se_e16m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; CHECK-NEXT:    sf.vc.ivv 3, v8, v10, 3
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.ivv.se.iXLen.nxv16f16.nxv16i16.iXLen.iXLen(iXLen 3, <16 x half> %vd, <16 x i16> %vs2, iXLen 3, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.ivv.se.iXLen.nxv16f16.nxv16i16.iXLen.iXLen(iXLen, <16 x half>, <16 x i16>, iXLen, iXLen)

define <16 x half> @test_sf_vc_fv_fvvi_se_e16m4(<16 x half> %vd, <16 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fv_fvvi_se_e16m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m2, tu, ma
; CHECK-NEXT:    sf.vc.v.ivv 3, v8, v10, 3
; CHECK-NEXT:    ret
entry:
  %0 = tail call <16 x half> @llvm.riscv.sf.vc.v.ivv.se.nxv16f16.nxv16f16.nxv16i16.iXLen.iXLen(iXLen 3, <16 x half> %vd, <16 x i16> %vs2, iXLen 3, iXLen %vl)
  ret <16 x half> %0
}

declare <16 x half> @llvm.riscv.sf.vc.v.ivv.se.nxv16f16.nxv16f16.nxv16i16.iXLen.iXLen(iXLen, <16 x half>, <16 x i16>, iXLen, iXLen)

define void @test_sf_vc_fvvi_se_e16m8(<32 x half> %vd, <32 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvvi_se_e16m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    sf.vc.ivv 3, v8, v12, 3
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.ivv.se.iXLen.nxv32f16.nxv32i16.iXLen.iXLen(iXLen 3, <32 x half> %vd, <32 x i16> %vs2, iXLen 3, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.ivv.se.iXLen.nxv32f16.nxv32i16.iXLen.iXLen(iXLen, <32 x half>, <32 x i16>, iXLen, iXLen)

define <32 x half> @test_sf_vc_fv_fvvi_se_e16m8(<32 x half> %vd, <32 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fv_fvvi_se_e16m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, tu, ma
; CHECK-NEXT:    sf.vc.v.ivv 3, v8, v12, 3
; CHECK-NEXT:    ret
entry:
  %0 = tail call <32 x half> @llvm.riscv.sf.vc.v.ivv.se.nxv32f16.nxv32f16.nxv32i16.iXLen.iXLen(iXLen 3, <32 x half> %vd, <32 x i16> %vs2, iXLen 3, iXLen %vl)
  ret <32 x half> %0
}

declare <32 x half> @llvm.riscv.sf.vc.v.ivv.se.nxv32f16.nxv32f16.nxv32i16.iXLen.iXLen(iXLen, <32 x half>, <32 x i16>, iXLen, iXLen)

define void @test_sf_vc_fvvi_se_e32mf2(<1 x float> %vd, <1 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvvi_se_e32mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    sf.vc.ivv 3, v8, v9, 3
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.ivv.se.iXLen.nxv1f32.nxv1i32.iXLen.iXLen(iXLen 3, <1 x float> %vd, <1 x i32> %vs2, iXLen 3, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.ivv.se.iXLen.nxv1f32.nxv1i32.iXLen.iXLen(iXLen, <1 x float>, <1 x i32>, iXLen, iXLen)

define <1 x float> @test_sf_vc_fv_fvvi_se_e32mf2(<1 x float> %vd, <1 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fv_fvvi_se_e32mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, tu, ma
; CHECK-NEXT:    sf.vc.v.ivv 3, v8, v9, 3
; CHECK-NEXT:    ret
entry:
  %0 = tail call <1 x float> @llvm.riscv.sf.vc.v.ivv.se.nxv1f32.nxv1f32.nxv1i32.iXLen.iXLen(iXLen 3, <1 x float> %vd, <1 x i32> %vs2, iXLen 3, iXLen %vl)
  ret <1 x float> %0
}

declare <1 x float> @llvm.riscv.sf.vc.v.ivv.se.nxv1f32.nxv1f32.nxv1i32.iXLen.iXLen(iXLen, <1 x float>, <1 x i32>, iXLen, iXLen)

define void @test_sf_vc_fvvi_se_e32m1(<2 x float> %vd, <2 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvvi_se_e32m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    sf.vc.ivv 3, v8, v9, 3
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.ivv.se.iXLen.nxv2f32.nxv2i32.iXLen.iXLen(iXLen 3, <2 x float> %vd, <2 x i32> %vs2, iXLen 3, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.ivv.se.iXLen.nxv2f32.nxv2i32.iXLen.iXLen(iXLen, <2 x float>, <2 x i32>, iXLen, iXLen)

define <2 x float> @test_sf_vc_fv_fvvi_se_e32m1(<2 x float> %vd, <2 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fv_fvvi_se_e32m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, tu, ma
; CHECK-NEXT:    sf.vc.v.ivv 3, v8, v9, 3
; CHECK-NEXT:    ret
entry:
  %0 = tail call <2 x float> @llvm.riscv.sf.vc.v.ivv.se.nxv2f32.nxv2f32.nxv2i32.iXLen.iXLen(iXLen 3, <2 x float> %vd, <2 x i32> %vs2, iXLen 3, iXLen %vl)
  ret <2 x float> %0
}

declare <2 x float> @llvm.riscv.sf.vc.v.ivv.se.nxv2f32.nxv2f32.nxv2i32.iXLen.iXLen(iXLen, <2 x float>, <2 x i32>, iXLen, iXLen)

define void @test_sf_vc_fvvi_se_e32m2(<4 x float> %vd, <4 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvvi_se_e32m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; CHECK-NEXT:    sf.vc.ivv 3, v8, v9, 3
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.ivv.se.iXLen.nxv4f32.nxv4i32.iXLen.iXLen(iXLen 3, <4 x float> %vd, <4 x i32> %vs2, iXLen 3, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.ivv.se.iXLen.nxv4f32.nxv4i32.iXLen.iXLen(iXLen, <4 x float>, <4 x i32>, iXLen, iXLen)

define <4 x float> @test_sf_vc_fv_fvvi_se_e32m2(<4 x float> %vd, <4 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fv_fvvi_se_e32m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m1, tu, ma
; CHECK-NEXT:    sf.vc.v.ivv 3, v8, v9, 3
; CHECK-NEXT:    ret
entry:
  %0 = tail call <4 x float> @llvm.riscv.sf.vc.v.ivv.se.nxv4f32.nxv4f32.nxv4i32.iXLen.iXLen(iXLen 3, <4 x float> %vd, <4 x i32> %vs2, iXLen 3, iXLen %vl)
  ret <4 x float> %0
}

declare <4 x float> @llvm.riscv.sf.vc.v.ivv.se.nxv4f32.nxv4f32.nxv4i32.iXLen.iXLen(iXLen, <4 x float>, <4 x i32>, iXLen, iXLen)

define void @test_sf_vc_fvvi_se_e32m4(<8 x float> %vd, <8 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvvi_se_e32m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; CHECK-NEXT:    sf.vc.ivv 3, v8, v10, 3
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.ivv.se.iXLen.nxv8f32.nxv8i32.iXLen.iXLen(iXLen 3, <8 x float> %vd, <8 x i32> %vs2, iXLen 3, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.ivv.se.iXLen.nxv8f32.nxv8i32.iXLen.iXLen(iXLen, <8 x float>, <8 x i32>, iXLen, iXLen)

define <8 x float> @test_sf_vc_fv_fvvi_se_e32m4(<8 x float> %vd, <8 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fv_fvvi_se_e32m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, tu, ma
; CHECK-NEXT:    sf.vc.v.ivv 3, v8, v10, 3
; CHECK-NEXT:    ret
entry:
  %0 = tail call <8 x float> @llvm.riscv.sf.vc.v.ivv.se.nxv8f32.nxv8f32.nxv8i32.iXLen.iXLen(iXLen 3, <8 x float> %vd, <8 x i32> %vs2, iXLen 3, iXLen %vl)
  ret <8 x float> %0
}

declare <8 x float> @llvm.riscv.sf.vc.v.ivv.se.nxv8f32.nxv8f32.nxv8i32.iXLen.iXLen(iXLen, <8 x float>, <8 x i32>, iXLen, iXLen)

define void @test_sf_vc_fvvi_se_e32m8(<16 x float> %vd, <16 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvvi_se_e32m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    sf.vc.ivv 3, v8, v12, 3
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.ivv.se.iXLen.nxv16f32.nxv16i32.iXLen.iXLen(iXLen 3, <16 x float> %vd, <16 x i32> %vs2, iXLen 3, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.ivv.se.iXLen.nxv16f32.nxv16i32.iXLen.iXLen(iXLen, <16 x float>, <16 x i32>, iXLen, iXLen)

define <16 x float> @test_sf_vc_fv_fvvi_se_e32m8(<16 x float> %vd, <16 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fv_fvvi_se_e32m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, tu, ma
; CHECK-NEXT:    sf.vc.v.ivv 3, v8, v12, 3
; CHECK-NEXT:    ret
entry:
  %0 = tail call <16 x float> @llvm.riscv.sf.vc.v.ivv.se.nxv16f32.nxv16f32.nxv16i32.iXLen.iXLen(iXLen 3, <16 x float> %vd, <16 x i32> %vs2, iXLen 3, iXLen %vl)
  ret <16 x float> %0
}

declare <16 x float> @llvm.riscv.sf.vc.v.ivv.se.nxv16f32.nxv16f32.nxv16i32.iXLen.iXLen(iXLen, <16 x float>, <16 x i32>, iXLen, iXLen)

define void @test_sf_vc_fvvf_se_e16mf4(<1 x half> %vd, <1 x i16> %vs2, half %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvvf_se_e16mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-NEXT:    sf.vc.fvv 1, v8, v9, fa0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.fvv.se.iXLen.nxv1f16.nxv1i16.f16.iXLen(iXLen 1, <1 x half> %vd, <1 x i16> %vs2, half %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.fvv.se.iXLen.nxv1f16.nxv1i16.f16.iXLen(iXLen, <1 x half>, <1 x i16>, half, iXLen)

define <1 x half> @test_sf_vc_fv_fvvf_se_e16mf4(<1 x half> %vd, <1 x i16> %vs2, half %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fv_fvvf_se_e16mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, tu, ma
; CHECK-NEXT:    sf.vc.v.fvv 1, v8, v9, fa0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <1 x half> @llvm.riscv.sf.vc.v.fvv.se.nxv1f16.nxv1f16.nxv1i16.f16.iXLen(iXLen 1, <1 x half> %vd, <1 x i16> %vs2, half %rs1, iXLen %vl)
  ret <1 x half> %0
}

declare <1 x half> @llvm.riscv.sf.vc.v.fvv.se.nxv1f16.nxv1f16.nxv1i16.f16.iXLen(iXLen, <1 x half>, <1 x i16>, half %rs1, iXLen)

define void @test_sf_vc_fvvf_se_e16mf2(<2 x half> %vd, <2 x i16> %vs2, half %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvvf_se_e16mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-NEXT:    sf.vc.fvv 1, v8, v9, fa0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.fvv.se.iXLen.nxv2f16.nxv2i16.f16.iXLen(iXLen 1, <2 x half> %vd, <2 x i16> %vs2, half %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.fvv.se.iXLen.nxv2f16.nxv2i16.f16.iXLen(iXLen, <2 x half>, <2 x i16>, half, iXLen)

define <2 x half> @test_sf_vc_fv_fvvf_se_e16mf2(<2 x half> %vd, <2 x i16> %vs2, half %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fv_fvvf_se_e16mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, tu, ma
; CHECK-NEXT:    sf.vc.v.fvv 1, v8, v9, fa0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <2 x half> @llvm.riscv.sf.vc.v.fvv.se.nxv2f16.nxv2f16.nxv2i16.f16.iXLen(iXLen 1, <2 x half> %vd, <2 x i16> %vs2, half %rs1, iXLen %vl)
  ret <2 x half> %0
}

declare <2 x half> @llvm.riscv.sf.vc.v.fvv.se.nxv2f16.nxv2f16.nxv2i16.f16.iXLen(iXLen, <2 x half>, <2 x i16>, half %rs1, iXLen)

define void @test_sf_vc_fvvf_se_e16m1(<4 x half> %vd, <4 x i16> %vs2, half %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvvf_se_e16m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; CHECK-NEXT:    sf.vc.fvv 1, v8, v9, fa0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.fvv.se.iXLen.nxv4f16.nxv4i16.f16.iXLen(iXLen 1, <4 x half> %vd, <4 x i16> %vs2, half %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.fvv.se.iXLen.nxv4f16.nxv4i16.f16.iXLen(iXLen, <4 x half>, <4 x i16>, half, iXLen)

define <4 x half> @test_sf_vc_fv_fvvf_se_e16m1(<4 x half> %vd, <4 x i16> %vs2, half %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fv_fvvf_se_e16m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf2, tu, ma
; CHECK-NEXT:    sf.vc.v.fvv 1, v8, v9, fa0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <4 x half> @llvm.riscv.sf.vc.v.fvv.se.nxv4f16.nxv4f16.nxv4i16.f16.iXLen(iXLen 1, <4 x half> %vd, <4 x i16> %vs2, half %rs1, iXLen %vl)
  ret <4 x half> %0
}

declare <4 x half> @llvm.riscv.sf.vc.v.fvv.se.nxv4f16.nxv4f16.nxv4i16.f16.iXLen(iXLen, <4 x half>, <4 x i16>, half %rs1, iXLen)

define void @test_sf_vc_fvvf_se_e16m2(<8 x half> %vd, <8 x i16> %vs2, half %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvvf_se_e16m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    sf.vc.fvv 1, v8, v9, fa0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.fvv.se.iXLen.nxv8f16.nxv8i16.f16.iXLen(iXLen 1, <8 x half> %vd, <8 x i16> %vs2, half %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.fvv.se.iXLen.nxv8f16.nxv8i16.f16.iXLen(iXLen, <8 x half>, <8 x i16>, half, iXLen)

define <8 x half> @test_sf_vc_fv_fvvf_se_e16m2(<8 x half> %vd, <8 x i16> %vs2, half %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fv_fvvf_se_e16m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, tu, ma
; CHECK-NEXT:    sf.vc.v.fvv 1, v8, v9, fa0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <8 x half> @llvm.riscv.sf.vc.v.fvv.se.nxv8f16.nxv8f16.nxv8i16.f16.iXLen(iXLen 1, <8 x half> %vd, <8 x i16> %vs2, half %rs1, iXLen %vl)
  ret <8 x half> %0
}

declare <8 x half> @llvm.riscv.sf.vc.v.fvv.se.nxv8f16.nxv8f16.nxv8i16.f16.iXLen(iXLen, <8 x half>, <8 x i16>, half %rs1, iXLen)

define void @test_sf_vc_fvvf_se_e16m4(<16 x half> %vd, <16 x i16> %vs2, half %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvvf_se_e16m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; CHECK-NEXT:    sf.vc.fvv 1, v8, v10, fa0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.fvv.se.iXLen.nxv16f16.nxv16i16.f16.iXLen(iXLen 1, <16 x half> %vd, <16 x i16> %vs2, half %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.fvv.se.iXLen.nxv16f16.nxv16i16.f16.iXLen(iXLen, <16 x half>, <16 x i16>, half, iXLen)

define <16 x half> @test_sf_vc_fv_fvvf_se_e16m4(<16 x half> %vd, <16 x i16> %vs2, half %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fv_fvvf_se_e16m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m2, tu, ma
; CHECK-NEXT:    sf.vc.v.fvv 1, v8, v10, fa0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <16 x half> @llvm.riscv.sf.vc.v.fvv.se.nxv16f16.nxv16f16.nxv16i16.f16.iXLen(iXLen 1, <16 x half> %vd, <16 x i16> %vs2, half %rs1, iXLen %vl)
  ret <16 x half> %0
}

declare <16 x half> @llvm.riscv.sf.vc.v.fvv.se.nxv16f16.nxv16f16.nxv16i16.f16.iXLen(iXLen, <16 x half>, <16 x i16>, half %rs1, iXLen)

define void @test_sf_vc_fvvf_se_e16m8(<32 x half> %vd, <32 x i16> %vs2, half %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvvf_se_e16m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    sf.vc.fvv 1, v8, v12, fa0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.fvv.se.iXLen.nxv32f16.nxv32i16.f16.iXLen(iXLen 1, <32 x half> %vd, <32 x i16> %vs2, half %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.fvv.se.iXLen.nxv32f16.nxv32i16.f16.iXLen(iXLen, <32 x half>, <32 x i16>, half, iXLen)

define <32 x half> @test_sf_vc_fv_fvvf_se_e16m8(<32 x half> %vd, <32 x i16> %vs2, half %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fv_fvvf_se_e16m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, tu, ma
; CHECK-NEXT:    sf.vc.v.fvv 1, v8, v12, fa0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <32 x half> @llvm.riscv.sf.vc.v.fvv.se.nxv32f16.nxv32f16.nxv32i16.f16.iXLen(iXLen 1, <32 x half> %vd, <32 x i16> %vs2, half %rs1, iXLen %vl)
  ret <32 x half> %0
}

declare <32 x half> @llvm.riscv.sf.vc.v.fvv.se.nxv32f16.nxv32f16.nxv32i16.f16.iXLen(iXLen, <32 x half>, <32 x i16>, half %rs1, iXLen)

define void @test_sf_vc_fvvf_se_e32mf2(<1 x float> %vd, <1 x i32> %vs2, float %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvvf_se_e32mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    sf.vc.fvv 1, v8, v9, fa0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.fvv.se.iXLen.nxv1f32.nxv1i32.f32.iXLen(iXLen 1, <1 x float> %vd, <1 x i32> %vs2, float %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.fvv.se.iXLen.nxv1f32.nxv1i32.f32.iXLen(iXLen, <1 x float>, <1 x i32>, float, iXLen)

define <1 x float> @test_sf_vc_fv_fvvf_se_e32mf2(<1 x float> %vd, <1 x i32> %vs2, float %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fv_fvvf_se_e32mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, tu, ma
; CHECK-NEXT:    sf.vc.v.fvv 1, v8, v9, fa0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <1 x float> @llvm.riscv.sf.vc.v.fvv.se.nxv1f32.nxv1f32.nxv1i32.f32.iXLen(iXLen 1, <1 x float> %vd, <1 x i32> %vs2, float %rs1, iXLen %vl)
  ret <1 x float> %0
}

declare <1 x float> @llvm.riscv.sf.vc.v.fvv.se.nxv1f32.nxv1f32.nxv1i32.f32.iXLen(iXLen, <1 x float>, <1 x i32>, float %rs1, iXLen)

define void @test_sf_vc_fvvf_se_e32m1(<2 x float> %vd, <2 x i32> %vs2, float %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvvf_se_e32m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    sf.vc.fvv 1, v8, v9, fa0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.fvv.se.iXLen.nxv2f32.nxv2i32.f32.iXLen(iXLen 1, <2 x float> %vd, <2 x i32> %vs2, float %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.fvv.se.iXLen.nxv2f32.nxv2i32.f32.iXLen(iXLen, <2 x float>, <2 x i32>, float, iXLen)

define <2 x float> @test_sf_vc_fv_fvvf_se_e32m1(<2 x float> %vd, <2 x i32> %vs2, float %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fv_fvvf_se_e32m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, tu, ma
; CHECK-NEXT:    sf.vc.v.fvv 1, v8, v9, fa0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <2 x float> @llvm.riscv.sf.vc.v.fvv.se.nxv2f32.nxv2f32.nxv2i32.f32.iXLen(iXLen 1, <2 x float> %vd, <2 x i32> %vs2, float %rs1, iXLen %vl)
  ret <2 x float> %0
}

declare <2 x float> @llvm.riscv.sf.vc.v.fvv.se.nxv2f32.nxv2f32.nxv2i32.f32.iXLen(iXLen, <2 x float>, <2 x i32>, float %rs1, iXLen)

define void @test_sf_vc_fvvf_se_e32m2(<4 x float> %vd, <4 x i32> %vs2, float %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvvf_se_e32m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; CHECK-NEXT:    sf.vc.fvv 1, v8, v9, fa0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.fvv.se.iXLen.nxv4f32.nxv4i32.f32.iXLen(iXLen 1, <4 x float> %vd, <4 x i32> %vs2, float %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.fvv.se.iXLen.nxv4f32.nxv4i32.f32.iXLen(iXLen, <4 x float>, <4 x i32>, float, iXLen)

define <4 x float> @test_sf_vc_fv_fvvf_se_e32m2(<4 x float> %vd, <4 x i32> %vs2, float %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fv_fvvf_se_e32m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m1, tu, ma
; CHECK-NEXT:    sf.vc.v.fvv 1, v8, v9, fa0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <4 x float> @llvm.riscv.sf.vc.v.fvv.se.nxv4f32.nxv4f32.nxv4i32.f32.iXLen(iXLen 1, <4 x float> %vd, <4 x i32> %vs2, float %rs1, iXLen %vl)
  ret <4 x float> %0
}

declare <4 x float> @llvm.riscv.sf.vc.v.fvv.se.nxv4f32.nxv4f32.nxv4i32.f32.iXLen(iXLen, <4 x float>, <4 x i32>, float %rs1, iXLen)

define void @test_sf_vc_fvvf_se_e32m4(<8 x float> %vd, <8 x i32> %vs2, float %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvvf_se_e32m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; CHECK-NEXT:    sf.vc.fvv 1, v8, v10, fa0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.fvv.se.iXLen.nxv8f32.nxv8i32.f32.iXLen(iXLen 1, <8 x float> %vd, <8 x i32> %vs2, float %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.fvv.se.iXLen.nxv8f32.nxv8i32.f32.iXLen(iXLen, <8 x float>, <8 x i32>, float, iXLen)

define <8 x float> @test_sf_vc_fv_fvvf_se_e32m4(<8 x float> %vd, <8 x i32> %vs2, float %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fv_fvvf_se_e32m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, tu, ma
; CHECK-NEXT:    sf.vc.v.fvv 1, v8, v10, fa0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <8 x float> @llvm.riscv.sf.vc.v.fvv.se.nxv8f32.nxv8f32.nxv8i32.f32.iXLen(iXLen 1, <8 x float> %vd, <8 x i32> %vs2, float %rs1, iXLen %vl)
  ret <8 x float> %0
}

declare <8 x float> @llvm.riscv.sf.vc.v.fvv.se.nxv8f32.nxv8f32.nxv8i32.f32.iXLen(iXLen, <8 x float>, <8 x i32>, float %rs1, iXLen)

define void @test_sf_vc_fvvf_se_e32m8(<16 x float> %vd, <16 x i32> %vs2, float %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fvvf_se_e32m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    sf.vc.fvv 1, v8, v12, fa0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.fvv.se.iXLen.nxv16f32.nxv16i32.f32.iXLen(iXLen 1, <16 x float> %vd, <16 x i32> %vs2, float %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.fvv.se.iXLen.nxv16f32.nxv16i32.f32.iXLen(iXLen, <16 x float>, <16 x i32>, float, iXLen)

define <16 x float> @test_sf_vc_fv_fvvf_se_e32m8(<16 x float> %vd, <16 x i32> %vs2, float %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fv_fvvf_se_e32m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, tu, ma
; CHECK-NEXT:    sf.vc.v.fvv 1, v8, v12, fa0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <16 x float> @llvm.riscv.sf.vc.v.fvv.se.nxv16f32.nxv16f32.nxv16i32.f32.iXLen(iXLen 1, <16 x float> %vd, <16 x i32> %vs2, float %rs1, iXLen %vl)
  ret <16 x float> %0
}

declare <16 x float> @llvm.riscv.sf.vc.v.fvv.se.nxv16f32.nxv16f32.nxv16i32.f32.iXLen(iXLen, <16 x float>, <16 x i32>, float %rs1, iXLen)
