#include <ctime>
#include <cstdio>
#include <octave/oct.h>

void init_util ()
{
  srand (time (NULL));
}

void scramble_matrix (Matrix &x)
{
  double *x_ptr = x.fortran_vec ();
  for (octave_idx_type i = 0; i < x.numel (); i++)
    {
      octave_idx_type n1 = rand () % x.numel ();
      octave_idx_type n2 = rand () % x.numel ();

      double tmp = x_ptr[n1];
      x_ptr[n1] = x_ptr[n2];
      x_ptr[n2] = tmp;
    }
}

void get_2random_idx (const Matrix &x, octave_idx_type &n1, octave_idx_type &n2)
{
  n1 = rand() % x.rows ();
  n2 = rand() % x.rows ();
    while (n1 == n2)
      n2 = rand() % x.rows ();
}
