##=============================================================================
##
##      vectors.S
##
##      x86 exception vectors
##
##=============================================================================
#####COPYRIGHTBEGIN####
#
# -------------------------------------------
# The contents of this file are subject to the Cygnus eCos Public License
# Version 1.0 (the "License"); you may not use this file except in
# compliance with the License.  You may obtain a copy of the License at
# http://sourceware.cygnus.com/ecos
# 
# Software distributed under the License is distributed on an "AS IS"
# basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the
# License for the specific language governing rights and limitations under
# the License.
# 
# The Original Code is eCos - Embedded Cygnus Operating System, released
# September 30, 1998.
# 
# The Initial Developer of the Original Code is Cygnus.  Portions created
# by Cygnus are Copyright (C) 1998,1999 Cygnus Solutions.  All Rights Reserved.
# -------------------------------------------
#
#####COPYRIGHTEND####
##=============================================================================
#######DESCRIPTIONBEGIN####
##
## Author(s):   jskov
## Contributors:jskov
## Date:        1999-01-07
## Purpose:     x86 exception vectors
## Description: This file defines the code placed into the exception
##              vectors. It also contains the first level default VSRs
##              that save and restore state for both exceptions and
##              interrupts.
##
######DESCRIPTIONEND####
##
##=============================================================================


// pjo, 15 oct 1999
#include <pkgconf/system.h>
#include <pkgconf/hal.h>

#ifdef CYGPKG_KERNEL
#include <pkgconf/kernel.h>
#endif /* CYGPKG_KERNEL */

#include <cyg/hal/arch.inc>


#==============================================================================

    .file   "vectors.S"

# The Linux synthetic target defines its own startup.
#ifdef CYGPKG_HAL_I386_LINUX
    .extern _linux_entry
    .text
    .globl _start

_start:
    jmp   _linux_entry

#else  ## ifdef CYGPKG_HAL_I386_LINUX
#==============================================================================
# Real startup code. We jump here from the various reset vectors to set up the
# world.

    .text
    .globl _start

_start: 
	hal_cpu_init
	hal_diag_init
	hal_mmu_init
	hal_fpu_init
	hal_memc_init
	hal_intc_init
	hal_cache_init
	hal_timer_init

# loading the stack pointer seems appropriate now.
	movl $_start, %esp

	hal_mon_init

	.extern hal_zero_bss
	call hal_zero_bss

	.extern hal_variant_init
	call hal_variant_init

	.extern hal_platform_init
	call hal_platform_init

	.extern cyg_hal_invoke_constructors
	call cyg_hal_invoke_constructors

#ifdef CYGDBG_HAL_DEBUG_GDB_INCLUDE_STUBS
	.extern initialize_stub
	call initialize_stub
#endif /* CYGDBG_HAL_DEBUG_GDB_INCLUDE_STUBS */

	.extern cyg_start
	call cyg_start

# Hmm.  Not expecting to return from cyg_start.
1:	hlt
	jmp 1b


# Add a bit of debugger support.
	.align 4
	.globl _breakinst
_breakinst:
	int $3
	ret


#endif ## ifndef CYGPKG_HAL_I386_LINUX

#------------------------------------------------------------------------------
# end of vectors.S
