// -*- C++ -*- header wrapper.

// Copyright (C) 1998 Cygnus Solutions
//
// This file is part of the libstdc++ version 3 distribution.
//
// This software is a copyrighted work licensed under the terms of the
// Cygnus libstdc++ license. Please consult the file LICENSE.STD for
// details.

//
// ISO C++ draft working paper:	20.4.6  C library
//

#ifndef _CPP_CSTDARG
#define _CPP_CSTDARG 1

  namespace _C_Swamp {
    extern "C" {
#     define _IN_C_SWAMP_
#     include_next <stdarg.h>
    }
    typedef va_list   _CPP_va_list_capture;
#   ifdef __GNUC__

#   elif
      template <class T>
        inline void _CPP_va_start_capture(va_list& __val, T& __v) 
          { va_start(__val, __v); }
      template <class T>
        inline void _CPP_va_arg_capture(va_list& __val, T& __arg) 
          { va_start(__val, __arg); }
      template <class T>
        inline T& _CPP_va_arg_capture(va_list& __val)
          { return va_arg(__val, T); }
      template <class T>
        inline void _CPP_va_end(va_list& __val)
          { va_end(__val); }
#   endif

    // typedef size_t    _CPP_size_t_capture;  // handled in <cstddef>

    namespace _C_Shadow { }
  } // close namespace ::_C_Swamp::

#  ifdef __GNUC__

#    undef va_list
     using _C_Swamp::__gnuc_va_list;

#  elif  /* probably must be tailored for each compiler, as above. */

#    undef va_list
#    undef va_start
#    define va_start(a,b) ::_C_Swamp::_CPP_va_start_capture(a,b)
#    undef va_arg
#    define va_arg(a,b)   ::_C_Swamp::_CPP_va_arg_capture<b>(a)
#    undef va_end
#    define va_end(a)     ::_C_Swamp::_CPP_va_end_capture(a)

#  endif

  namespace _C_Swamp {
    namespace _C_Shadow {
      typedef ::_C_Swamp::_CPP_va_list_capture va_list;
    }
  }
  namespace std {
    using ::_C_Swamp::_C_Shadow::va_list;  
  } // close namespace std::
  
  namespace _C_Swamp {
    namespace _C_Shadow {
    }
  }

# undef _IN_C_SWAMP_

#endif

