/* PR c/102989 */
/* { dg-do run { target bitint } } */
/* { dg-options "-std=c23 -pedantic-errors" } */
/* { dg-skip-if "" { ! run_expensive_tests }  { "*" } { "-O0" "-O2" } } */
/* { dg-skip-if "" { ! run_expensive_tests } { "-flto" } { "" } } */

#if __FLT_MANT_DIG__ == 24
#if __BITINT_MAXWIDTH__ >= 135
__attribute__((noipa)) float
testflt_135 (_BitInt(135) b)
{
  return b;
}

__attribute__((noipa)) float
testfltu_135 (unsigned _BitInt(135) b)
{
  return b;
}
#endif

#if __BITINT_MAXWIDTH__ >= 192
__attribute__((noipa)) float
testflt_192 (_BitInt(192) b)
{
  return b;
}

__attribute__((noipa)) float
testfltu_192 (unsigned _BitInt(192) b)
{
  return b;
}
#endif

#if __BITINT_MAXWIDTH__ >= 575
__attribute__((noipa)) float
testflt_575 (_BitInt(575) b)
{
  return b;
}

__attribute__((noipa)) float
testfltu_575 (unsigned _BitInt(575) b)
{
  return b;
}
#endif
#endif

#if __DBL_MANT_DIG__ == 53
#if __BITINT_MAXWIDTH__ >= 135
__attribute__((noipa)) double
testdbl_135 (_BitInt(135) b)
{
  return b;
}

__attribute__((noipa)) double
testdblu_135 (unsigned _BitInt(135) b)
{
  return b;
}
#endif

#if __BITINT_MAXWIDTH__ >= 192
__attribute__((noipa)) double
testdbl_192 (_BitInt(192) b)
{
  return b;
}

__attribute__((noipa)) double
testdblu_192 (unsigned _BitInt(192) b)
{
  return b;
}
#endif

#if __BITINT_MAXWIDTH__ >= 575
__attribute__((noipa)) double
testdbl_575 (_BitInt(575) b)
{
  return b;
}

__attribute__((noipa)) double
testdblu_575 (unsigned _BitInt(575) b)
{
  return b;
}
#endif
#endif

int
main ()
{
#if __BITINT_MAXWIDTH__ >= 135
  static _BitInt(135) s_135[] = {
    -39242093wb,
    -36246971635108657318127321wb,
    -816440703352wb,
    8409360wb,
    231875wb,
    -1859wb,
    8123250453541347379290840008816194983wb,
    42642091wb,
    -2499664813007708583619356686wb,
    -14022533493907734339644wb,
    737816709430180009697449492wb,
    3094418595787172583521548578719419wb,
    84096wb,
    -3856393637064417wb,
    5494wb,
    -7227655824382622730861wb,
    185250722103742953wb,
    -266695839223233222300219080587185431wb,
    124wb,
    -4540724906728461994579131745203067wb,
    -34474123wb,
    6171186wb,
    -1738448518309495501564259945530043942wb,
    3714wb,
    22759310366655438105064084505115489wb,
    -461wb,
    -1891475049610273521994429918325638525836wb,
    -350wb,
    3721759411106519959861226774340wb,
    -42485872965031409753wb,
    4362279409022137273490486629950wb,
    521928664204421037572709995195346211111wb,
    -50129wb,
    -21525556783117336078661729wb
  };
  static unsigned _BitInt(135) u_135[] = {
    773802493804221964748670742461281016363uwb,
    897485218654369665002411485681173uwb,
    37306898634990773758633uwb,
    3uwb,
    920156uwb,
    15230973698181139105641901258312096uwb,
    1383843491123931387484696uwb,
    143810081711544975903357370071668200uwb,
    83615891310230331473978uwb,
    1239150390uwb,
    39792042288uwb,
    20985035121604uwb,
    3700707uwb,
    14510535740825uwb,
    5675982879048653163399531637816917uwb,
    593909622129190124122830uwb,
    413008891327830587264uwb,
    34694483328uwb,
    592129uwb,
    2649uwb,
    154468451808267466822214091328849uwb,
    8905088171048376399858691570634230197204uwb,
    456uwb,
    12101uwb,
    5879086272uwb,
    115170058487623uwb,
    2274163249406113742515726136586945854500uwb,
    63923152267905666653uwb,
    624302860090054295150365837280525227924uwb,
    9uwb,
    5703520721951508439418uwb,
    44653119094uwb,
    1440439605268989101uwb,
    3496654014361uwb
  };
#endif
#if __BITINT_MAXWIDTH__ >= 192
  static _BitInt(192) s_192[] = {
    81945579384314684613279565479277935940wb,
    1640150770700583136800158704601080wb,
    432402469012491481987292073086668wb,
    -15369197386440508323548800500962985157137866798390wb,
    217705797486262wb,
    1wb,
    -150837356854711044278780637wb,
    1247354027519369533750440146304wb,
    -700073531555662209687924602081wb,
    -441651351073606706893667405889558445894wb,
    -743993151249791392844844248857961054wb,
    1681039wb,
    -170386616439159353410812029301398243129730wb,
    -97703172400304820221345002831889wb,
    9wb,
    7277656199366069102639319241893wb,
    7201222364wb,
    -4671533967546296507223686237333335wb,
    13311155734490577635922550wb,
    76150533189365685907637983428512213977569647wb,
    -283560863483321465221194695455688610811wb,
    6438368552004797088499844257634549000496626110080371wb,
    1122038765213390728664343086041576wb,
    -9541613313421359977755878156940wb,
    21551012076757076795102244535269250wb,
    -4794294047755173531367558272wb,
    -5708612827808554221wb,
    -2649648007071280662902443553973167294046518180wb,
    -35698660478241255546377wb,
    -79587921140918wb,
    469393710173925646wb,
    -261330983098092746969723637867599382044980841179747207wb,
    -115wb,
    -1717706681396wb
  };
  static unsigned _BitInt(192) u_192[] = {
    87197051833867272589618945858714291675632402028uwb,
    175207476610687227705633653396153452205075322355946uwb,
    289472685412214318981767004188uwb,
    58352315342320048378103056601781218026976uwb,
    68512267071922032916894194298300228491490143452269uwb,
    8654067584750856592691725728280108682858075uwb,
    57027948061283099317671673937496946487124629uwb,
    512829256101uwb,
    8815296701808550493421309771596155666520uwb,
    1918805208198312310092547265227uwb,
    99680639255733807uwb,
    313647272226958893709907781719uwb,
    534434342549592762863366619879590694414818uwb,
    1751643652514709uwb,
    24084146046683127013882581681582087uwb,
    1282076uwb,
    13590701668411111769uwb,
    62207549230439503653uwb,
    144040025133692457990548614076288499046uwb,
    11981724905403945793356785358565398049196880116uwb,
    1823479497818478859136796209626920064416489979129893695uwb,
    4649uwb,
    2095541338428713427585867932062430293488017906261402uwb,
    605377488765896342050766363050545164888333863362uwb,
    11488350477184223uwb,
    9492972359709013710789022084605392630683565515935199uwb,
    36826148417259uwb,
    554404239122129842026250702689uwb,
    2804528919100uwb,
    127uwb,
    66823885107232870336040073990324uwb,
    297736625249uwb,
    3701132312864550550157874952341371502832960625370598966uwb,
    107247048428uwb
  };
#endif
#if __BITINT_MAXWIDTH__ >= 575
  static _BitInt(575) s_575[] = {
    822555268170764275096048134868384963633463468104839796862654006268369616wb,
    -960580267694575830808697063169243963045681635800151938720065734940592300657700227419337766780029829446319203wb,
    33504080263976494448954627475165765154890874061543914469206217657999706310163279811015042121096338719830090426757797138233202615461wb,
    275983725374553564148936957707321552749wb,
    5534912144897227754137156977371639235252437172582938580045103986268272085395760563838753817115093434280932847973705994570261258933419373885658991359441723005813683395590541wb,
    1412920302762671055711845665320769771488824036206881359103417821581950493952853265134760513685359011001836948515905971331797139790wb,
    -262974997977953570994865210107604152900839198803859287819970850481583440338320059wb,
    -92488905333378799268618025132022462336176863903734682501838771365453998891689279398wb,
    242604167696163732697906496386839396751068wb,
    -3523803651131338645439245946293wb,
    -5147220779398204849222374563179412010462379234108857688330486391319694172748210918710342389194957287070617133280194810193962683650761347126311504766504260691wb,
    -126995956651641937332005246092202755154992252553028943468563459072746155379181900761169956344678911600wb,
    8137926360495wb,
    -15994393111836746332671329788635258wb,
    -277068516868681202554828866807401284583187899477211188256772654837767448404666578906477389363058609157862574wb,
    12643256666940489874033990964997310860090310878838229112053311027168830831623703103010815387wb,
    197250790460297242975596746662998763328365874997wb,
    2003391279347376998472wb,
    -199877387236416475658211887841938073691092213166438343739wb,
    683783725793437346966376731991835336458591392078548990419792641719902684445391913394174240265031277360362886303597899811253111402611797905136669wb,
    13527430925075101894748577029275389339063875642859674079897983403256wb,
    539267000300803493510458136103246878203019746178696339759252798818676107273127463057162208073142618039409911wb,
    25132435181738021677664552852329012363786311024121402747618663944355967806315928846073722774898wb,
    -24501129715197464074815490290653wb,
    -26621511339033230503491791253914731850253401wb,
    219726795681725191949095808767196099036895435893837474958165415185577738548053399820419849wb,
    142706206515281341916417852232439287400819155237127620529348000437671770471697052705666056232742428920527wb,
    -1272097813202031618710288063584910456400985264371503722255927680393419899507092728461wb,
    104580584066897755717617980935051171929519336855902844943415231226523598033953128466889325153396268078513996620240379420239887wb,
    -10163452549280413821027501723364683075067110986059205073343287754152825761658667193285948456506970145368258900765489010580419998927374372004822965287098902519382wb,
    -1462817702603947401421838547412731208810505797188084686210372939517152226213737422286025118826482655559744680456146694118022879735528111700409wb,
    -1004473459167555639043426932334304398038355185104669wb,
    383945882095471823332216311173956104021530654187057868803605149628498470119801535759629951357637987556377174553957515312582545289930138018wb,
    147266903774875157001493887893421901156259749590403482558013070wb
  };
  static unsigned _BitInt(575) u_575[] = {
    340315902121482071031uwb,
    9193736781349493374149172723522049938732355975055uwb,
    121133456126887617775249483436586396232697894267611535022240817951287068117843073672uwb,
    1253811282917666038992497uwb,
    279807426767721176279253888473522991149118862415710500804613956730247764438409575562386uwb,
    4763192686302836059965684032432862167583119264783uwb,
    19433750446582365356875213925336734177599085624532213292961813424848222698351037862663241858724337375675uwb,
    8615689860907972907203187028321798323548254692780962654211537619771698680316938530412569744897459065621193843349775333790731199245018643579445580816793381624810616262uwb,
    126055589776274659515356020606486923511478187977197128509709117843059226901071386846700207970626608150351060714322162254429913496135590117225450775153364768928781244uwb,
    34636325529158225079379169125604752070369970834816893592982969115088710130160324580864333959889906313467177163564702338046445540uwb,
    2295982750677874548137685137480985649627965059590627454944uwb,
    22288650253829612832302454550260146151077393473uwb,
    61551827uwb,
    948415991495935226718622697967024251064408554619458611515264819726244946850447758605031396753280209023664964305741301009407513619686102uwb,
    7599947921908039117808602805272900633862767543347735124983729771592896283177667324402886239291446uwb,
    3064098671438076295010586583414642866550259610904044948559784636731818131096680869327433283805326015689481397549653557650965154282598345191654721039973597171695049076467uwb,
    26163216482276433755253744705785501134309546797499410671258175352214852627310317854549342428286751107453875459uwb,
    1083530146709801198539441549736949256980046185455966999062614188586191607484611079705240990524552846829821534154580456458426794497253838343299379036578711641930103uwb,
    241446995995054305582384233456322509709013171336859127uwb,
    224319712854uwb,
    1851847735563213275uwb,
    3517907813008404838784133683859253992uwb,
    57026061017409510123542169719303829618100077009666501089739966522905673377916488253uwb,
    218054639772618074096850378810323560503313926757275788155487065187235936858569852576120793613879980uwb,
    1035184782769221379uwb,
    20229959242348674822834301353257599618846169820699281424077697412860273533283192155424030349307384555863768665398854990uwb,
    48688062002166777196074419660880812175599377353811333642743225865182422320253615211852611218169059717666168172585704763331192485699241038689921302806665184uwb,
    38974159722814402881994907079236516884965127718714589284306855526034875317101125387287977578141556918226042568695412232uwb,
    195268331869690963115384309853070889302314974440838447729079592004150231uwb,
    131384791058457562831689753115846222538215620945564207628285200123621656731679644407994773520965uwb,
    1334982489788592107403503927792629194402uwb,
    2146uwb,
    25165296015221802429838428736907886uwb,
    6254uwb
  };
#endif
#if __FLT_MANT_DIG__ == 24
#if __BITINT_MAXWIDTH__ >= 135
  static float flt_135[] = {
    -39242092.0f,
    -36246971272809749294350336.0f,
    -816440672256.0f,
    8409360.0f,
    231875.0f,
    -1859.0f,
    8123250192256220137057345512566423552.0f,
    42642092.0f,
    -2499664867657543876622680064.0f,
    -14022533900570342719488.0f,
    737816710112426075969552384.0f,
    3094418676109759732222008215207936.0f,
    84096.0f,
    -3856393689890816.0f,
    5494.0f,
    -7227655905181068951552.0f,
    185250718389633024.0f,
    -266695840144413128032863408636297216.0f,
    124.0f,
    -4540724759502527537506259606437888.0f,
    -34474124.0f,
    6171186.0f,
    -1738448585705717460364844982721314816.0f,
    3714.0f,
    22759309744814802127092016612376576.0f,
    -461.0f,
    -__builtin_inff (),
    -350.0f,
    3721759435945004998144961806336.0f,
    -42485872567125016576.0f,
    4362279465016690611605542535168.0f,
    __builtin_inff (),
    -50129.0f,
    -21525556388157878481977344.0f
  };
  static float fltu_135[] = {
    __builtin_inff (),
    897485251387475481828390233702400.0f,
    37306898327013391597568.0f,
    3.0f,
    920156.0f,
    15230974228367008360756701604872192.0f,
    1383843467413878101508096.0f,
    143810078160377684059996776503967744.0f,
    83615893330389964423168.0f,
    1239150336.0f,
    39792041984.0f,
    20985036144640.0f,
    3700707.0f,
    14510535475200.0f,
    5675982933774352481468669797335040.0f,
    593909606786098794594304.0f,
    413008901830615236608.0f,
    34694483968.0f,
    592129.0f,
    2649.0f,
    154468455934475733304034734374912.0f,
    __builtin_inff (),
    456.0f,
    12101.0f,
    5879086080.0f,
    115170059747328.0f,
    __builtin_inff (),
    63923151928943443968.0f,
    __builtin_inff (),
    9.0f,
    5703520697688581472256.0f,
    44653117440.0f,
    1440439672101666816.0f,
    3496654143488.0f
  };
  for (int i = 0; i < 34; ++i)
    if (testflt_135 (s_135[i]) != flt_135[i])
      __builtin_abort ();
  for (int i = 0; i < 34; ++i)
    if (testfltu_135 (u_135[i]) != fltu_135[i])
      __builtin_abort ();
#endif
#if __BITINT_MAXWIDTH__ >= 192
  static float flt_192[] = {
    81945579470551984745273979116049137664.0f,
    1640150781354328003699743106531328.0f,
    432402474830816591643797717254144.0f,
    -__builtin_inff (),
    217705802104832.0f,
    1.0f,
    -150837356860384332849610752.0f,
    1247354020200583118196884635648.0f,
    -700073528334631668550369017856.0f,
    -__builtin_inff (),
    -743993169284474461872900775245512704.0f,
    1681039.0f,
    -__builtin_inff (),
    -97703169989152795899105082605568.0f,
    9.0f,
    7277656062827612295463998324736.0f,
    7201222144.0f,
    -4671533860148685993668956641034240.0f,
    13311155535609252557094912.0f,
    __builtin_inff (),
    -283560864177100653079149659746813870080.0f,
    __builtin_inff (),
    1122038754191063555360632711675904.0f,
    -9541613258608657772880016179200.0f,
    21551010941830070997495077018796032.0f,
    -4794294027361853497357107200.0f,
    -5708612694366486528.0f,
    -__builtin_inff (),
    -35698660648279573790720.0f,
    -79587925032960.0f,
    469393711604695040.0f,
    -__builtin_inff (),
    -115.0f,
    -1717706686464.0f
  };
  static float fltu_192[] = {
    __builtin_inff (),
    __builtin_inff (),
    289472678477035675109665275904.0f,
    __builtin_inff (),
    __builtin_inff (),
    __builtin_inff (),
    __builtin_inff (),
    512829259776.0f,
    __builtin_inff (),
    1918805247503610004149880487936.0f,
    99680641842413568.0f,
    313647265860414511058971000832.0f,
    __builtin_inff (),
    1751643624308736.0f,
    24084145747217780385007409962156032.0f,
    1282076.0f,
    13590701491613597696.0f,
    62207548751752462336.0f,
    144040024354059546360660309323802476544.0f,
    __builtin_inff (),
    __builtin_inff (),
    4649.0f,
    __builtin_inff (),
    __builtin_inff (),
    11488350322032640.0f,
    __builtin_inff (),
    36826148503552.0f,
    554404238373758103887118598144.0f,
    2804528971776.0f,
    127.0f,
    66823887263746144234653953818624.0f,
    297736634368.0f,
    __builtin_inff (),
    107247050752.0f
  };
  for (int i = 0; i < 34; ++i)
    if (testflt_192 (s_192[i]) != flt_192[i])
      __builtin_abort ();
  for (int i = 0; i < 34; ++i)
    if (testfltu_192 (u_192[i]) != fltu_192[i])
      __builtin_abort ();
#endif
#if __BITINT_MAXWIDTH__ >= 575
  static float flt_575[] = {
    __builtin_inff (),
    -__builtin_inff (),
    __builtin_inff (),
    275983721032549254738830597716881440768.0f,
    __builtin_inff (),
    __builtin_inff (),
    -__builtin_inff (),
    -__builtin_inff (),
    __builtin_inff (),
    -3523803575380752640275405340672.0f,
    -__builtin_inff (),
    -__builtin_inff (),
    8137926508544.0f,
    -15994393281493713095582868026949632.0f,
    -__builtin_inff (),
    __builtin_inff (),
    __builtin_inff (),
    2003391250601164668928.0f,
    -__builtin_inff (),
    __builtin_inff (),
    __builtin_inff (),
    __builtin_inff (),
    __builtin_inff (),
    -24501130336514943435685610127360.0f,
    -__builtin_inff (),
    __builtin_inff (),
    __builtin_inff (),
    -__builtin_inff (),
    __builtin_inff (),
    -__builtin_inff (),
    -__builtin_inff (),
    -__builtin_inff (),
    __builtin_inff (),
    __builtin_inff ()
  };
  static float fltu_575[] = {
    340315913217135083520.0f,
    __builtin_inff (),
    __builtin_inff (),
    1253811215516794865319936.0f,
    __builtin_inff (),
    __builtin_inff (),
    __builtin_inff (),
    __builtin_inff (),
    __builtin_inff (),
    __builtin_inff (),
    __builtin_inff (),
    __builtin_inff (),
    61551828.0f,
    __builtin_inff (),
    __builtin_inff (),
    __builtin_inff (),
    __builtin_inff (),
    __builtin_inff (),
    __builtin_inff (),
    224319717376.0f,
    1851847786157309952.0f,
    3517907886717368541269560933367152640.0f,
    __builtin_inff (),
    __builtin_inff (),
    1035184768712441856.0f,
    __builtin_inff (),
    __builtin_inff (),
    __builtin_inff (),
    __builtin_inff (),
    __builtin_inff (),
    __builtin_inff (),
    2146.0f,
    25165295728767510106569460506689536.0f,
    6254.0f
  };
  for (int i = 0; i < 34; ++i)
    if (testflt_575 (s_575[i]) != flt_575[i])
      __builtin_abort ();
  for (int i = 0; i < 34; ++i)
    if (testfltu_575 (u_575[i]) != fltu_575[i])
      __builtin_abort ();
#endif
#endif
#if __DBL_MANT_DIG__ == 53
#if __BITINT_MAXWIDTH__ >= 135
  static double dbl_135[] = {
    -39242093.0,
    -36246971635108657531715584.0,
    -816440703352.0,
    8409360.0,
    231875.0,
    -1859.0,
    8123250453541346905042562585110511616.0,
    42642091.0,
    -2499664813007708750469922816.0,
    -14022533493907733348352.0,
    737816709430180073007218688.0,
    3094418595787172340280288631324672.0,
    84096.0,
    -3856393637064417.0,
    5494.0,
    -7227655824382622695424.0,
    185250722103742944.0,
    -266695839223233236177082217685581824.0,
    124.0,
    -4540724906728462124105811223379968.0,
    -34474123.0,
    6171186.0,
    -1738448518309495524665904679484391424.0,
    3714.0,
    22759310366655439518928576500989952.0,
    -461.0,
    -1891475049610273567723258005078180626432.0,
    -350.0,
    3721759411106519834940439265280.0,
    -42485872965031411712.0,
    4362279409022137156015669379072.0,
    521928664204421058633672118513103273984.0,
    -50129.0,
    -21525556783117337240797184.0
  };
  static double dblu_135[] = {
    773802493804221992623001034499154771968.0,
    897485218654369723848104601452544.0,
    37306898634990774386688.0,
    3.0,
    920156.0,
    15230973698181137968871516305096704.0,
    1383843491123931258028032.0,
    143810081711544982658521010624528384.0,
    83615891310230336700416.0,
    1239150390.0,
    39792042288.0,
    20985035121604.0,
    3700707.0,
    14510535740825.0,
    5675982879048652786568565738176512.0,
    593909622129190116524032.0,
    413008891327830556672.0,
    34694483328.0,
    592129.0,
    2649.0,
    154468451808267468485637384962048.0,
    8905088171048376547587929854079236308992.0,
    456.0,
    12101.0,
    5879086272.0,
    115170058487623.0,
    2274163249406113722963963066981556420608.0,
    63923152267905662976.0,
    624302860090054299856857502421553774592.0,
    9.0,
    5703520721951508135936.0,
    44653119094.0,
    1440439605268989184.0,
    3496654014361.0
  };
  for (int i = 0; i < 34; ++i)
    if (testdbl_135 (s_135[i]) != dbl_135[i])
      __builtin_abort ();
  for (int i = 0; i < 34; ++i)
    if (testdblu_135 (u_135[i]) != dblu_135[i])
      __builtin_abort ();
#endif
#if __BITINT_MAXWIDTH__ >= 192
  static double dbl_192[] = {
    81945579384314687557742233571238608896.0,
    1640150770700583037463354142621696.0,
    432402469012491501348574281596928.0,
    -15369197386440508938509968376382119346509732380672.0,
    217705797486262.0,
    1.0,
    -150837356854711041828847616.0,
    1247354027519369502575283929088.0,
    -700073531555662276303601532928.0,
    -441651351073606679519160525300938309632.0,
    -743993151249791396098631688421113856.0,
    1681039.0,
    -170386616439159361826828161968707433660416.0,
    -97703172400304826279491553722368.0,
    9.0,
    7277656199366069333121407385600.0,
    7201222364.0,
    -4671533967546296379435628906938368.0,
    13311155734490577941561344.0,
    76150533189365686624757419076841278552408064.0,
    -283560863483321472582205283908875976704.0,
    6438368552004797730833578371043525700779108699471872.0,
    1122038765213390753205991088586752.0,
    -9541613313421359725756721135616.0,
    21551012076757076520029583197601792.0,
    -4794294047755173506637103104.0,
    -5708612827808553984.0,
    -2649648007071280532341234166535418312753414144.0,
    -35698660478241256505344.0,
    -79587921140918.0,
    469393710173925632.0,
    -261330983098092727670915068943820759127419298070396928.0,
    -115.0,
    -1717706681396.0
  };
  static double dblu_192[] = {
    87197051833867272390202829166908318800909697024.0,
    175207476610687217879860344599290566299997853188096.0,
    289472685412214309690412105728.0,
    58352315342320052737011578650960945217536.0,
    68512267071922037583525562378571212344840731754496.0,
    8654067584750856522039960763727020807946240.0,
    57027948061283101680073163019018106591772672.0,
    512829256101.0,
    8815296701808550079625439512864915193856.0,
    1918805208198312244509799350272.0,
    99680639255733808.0,
    313647272226958910616850399232.0,
    534434342549592748637063994840786615140352.0,
    1751643652514709.0,
    24084146046683127568067882664329216.0,
    1282076.0,
    13590701668411111424.0,
    62207549230439505920.0,
    144040025133692463994664792383004082176.0,
    11981724905403944877595374666928320404518862848.0,
    1823479497818478827998416063488921051624645800235106304.0,
    4649.0,
    2095541338428713553559812835366404384524126144954368.0,
    605377488765896315082607405999750595789425999872.0,
    11488350477184224.0,
    9492972359709013522794710883315474336917948771336192.0,
    36826148417259.0,
    554404239122129838954063593472.0,
    2804528919100.0,
    127.0,
    66823885107232869968562331058176.0,
    297736625249.0,
    3701132312864550589964164920177814261972243111315767296.0,
    107247048428.0
  };
  for (int i = 0; i < 34; ++i)
    if (testdbl_192 (s_192[i]) != dbl_192[i])
      __builtin_abort ();
  for (int i = 0; i < 34; ++i)
    if (testdblu_192 (u_192[i]) != dblu_192[i])
      __builtin_abort ();
#endif
#if __BITINT_MAXWIDTH__ >= 575
  static double dbl_575[] = {
    822555268170764297634225399451759946746992540590809881338557024729825280.0,
    -960580267694575822855611495941585347204287976360447994911667455476231250947192048882720653908949004193890304.0,
    33504080263976494977558165276907141142985667083206076858318677497395449849522674033540660299812700936436629271063580537369602818048.0,
    275983725374553560382241222733294731264.0,
    5534912144897227981721785252365318913099024300479520929615780375858014135428545244514013933284386952701873840884059278413011909801315647098618874845818373456314285330268160.0,
    1412920302762670981724654587829101441064363178039081649317449002875219686863615617096481906597938056255380563207859934619548778496.0,
    -262974997977953547412616819382246513411941636601411079958856272578116216992825344.0,
    -92488905333378800887332041285981414442679115849793894833270926171369794209000194048.0,
    242604167696163745705487164545064266366976.0,
    -3523803651131338905043794395136.0,
    -5147220779398204956062097693667869669268514878983078506579452381903246893001528080183706343394366450560829994902536411900094807055106480897434592050304516096.0,
    -126995956651641932664992814931771424612524306428042763656077526441611704177400372487041993300114407424.0,
    8137926360495.0,
    -15994393111836745817684083180830720.0,
    -277068516868681208843378539444762089120272250101874770818281861285776026097252118136221894703961747524419584.0,
    12643256666940490094502018407000917191440297183002304612995222607645672663994449919572180992.0,
    197250790460297249337611855831853736085011038208.0,
    2003391279347377111040.0,
    -199877387236416487880239440186867935179678108631030562816.0,
    683783725793437376953847532054635915450883103104150353591684114076623183460343349044869993313461680324691804857056989176851941526653681669242880.0,
    13527430925075103137395594360375039920265895975276069404569617039360.0,
    539267000300803467143224409095377978528526384444410994726548852694612047977432378724606879533366903144710144.0,
    25132435181738021158181758368227989609664280796006529821958155232496895580737809559413590065152.0,
    -24501129715197465145324272091136.0,
    -26621511339033229577933593130365525581365248.0,
    219726795681725203086615878008721704050996541338139327356409273606611142342004775592132608.0,
    142706206515281338563561427905630882997359612390115520631287147248801675296196390219660900162069776564224.0,
    -1272097813202031695774673850580967606153271008283204619545732236750677292631566843904.0,
    104580584066897764106493049954563517551311873970918028573957449051117037877644455167894862496406485527470814840408584063287296.0,
    -10163452549280414266636885849517652803498703924514090324303688401722691539656540095676077155202913299163727204412770763270991539282383353646632785170429061890048.0,
    -1462817702603947424514705987528105462111189926351038186632282100495484739291866737828490405005509893174352599206536639203945990323918788886528.0,
    -1004473459167555693379448563952458083163231922159616.0,
    383945882095471809778477642717090299126500715170441296829413124731981221073489411436597060515704853514279862909459893170581511755452645376.0,
    147266903774875160122803299680751368800498930915627484017852416.0
  };
  static double dblu_575[] = {
    340315902121482059776.0,
    9193736781349493621405581031201638729956693377024.0,
    121133456126887614949840563267333164930922114527830924098169755757644187539060293632.0,
    1253811282917665907146752.0,
    279807426767721167224232624903862775521562023356169096523467570552357504424852523581440.0,
    4763192686302836266016084152796744123294035214336.0,
    19433750446582363914783523863519537892469170046699527182095230312993931481088146791402683275534315552768.0,
    8615689860907973684813089916677872622369301590036773127424335682014143120538819857749267776316706246365207593078790418785926108454964638864284607647395585351338688512.0,
    126055589776274664055563357164473926765229686711256362550309370211691455811892471436667901827515295553040869973224666092493870267949222939304809964524921924217733120.0,
    34636325529158225609732004478359404024810355780116436151965488784911880463832346975056353708910319963631363476007842111096356864.0,
    2295982750677874440830690242430022722310395038479306194944.0,
    22288650253829611656582899585105561922738061312.0,
    61551827.0,
    948415991495935277158065207187216102893971687538169358437498088171511819979329197955070708594226287655578579327935243978625908341735424.0,
    7599947921908039201020389523460283262016591366306988284476594385856376859892071911998135440769024.0,
    3064098671438076262631558926659124050612030123593391586289496610357367704588066201089697403929948683093930760302363801622713089626566308942422673109893593769913375260672.0,
    26163216482276434323059552752807045466093212833119225389172469300377369630622147477953596829696868035573317632.0,
    1083530146709801287488575139896111218252634145778954464029109940268038137024528653987999105697728348938546608345738475665376063185384327227976954513446733080428544.0,
    241446995995054294694559180878245213888164982782164992.0,
    224319712854.0,
    1851847735563213312.0,
    3517907813008404560136740290886107136.0,
    57026061017409511227244639666735331364603008817984523485318163959373956415485902848.0,
    218054639772618086702097627512642011917064593803091900409463425864524464099706282773581011770933248.0,
    1035184782769221376.0,
    20229959242348673341261734187831508959698424427160892456742004821954487315365414763816110107652513076773401171962363904.0,
    48688062002166779121886848500298978377358186775166569744218208875095511886249915901603271262547063601222998163903380246886122115788425950691666910366400512.0,
    38974159722814403783188765470424741900583576369459629735378952745201038923704525454001059605107694314700748523810324480.0,
    195268331869690962780067959053006275481517082721312675880802634445094912.0,
    131384791058457555617616111281677184113372650274571562034279153020161645779289769480396688326656.0,
    1334982489788592098527293353260669206528.0,
    2146.0,
    25165296015221801457062319885385728.0,
    6254.0
  };
  for (int i = 0; i < 34; ++i)
    if (testdbl_575 (s_575[i]) != dbl_575[i])
      __builtin_abort ();
  for (int i = 0; i < 34; ++i)
    if (testdblu_575 (u_575[i]) != dblu_575[i])
      __builtin_abort ();
#endif
#endif
}
