#TITLE=T*SQL
#INFO
EditPlus Cliptext Library v1.0  for Sybase Adaptive Server 12.5 T-SQL 
Author: Murali Sivasubramanian 
Date: Mar7 2002
#SORT=n

#T=*** OPERATORS ***
---
#T=desc
 DESC
#T=in clause
 IN
#T=between
 BETWEEN
#T=exists
 EXISTS
#T=disitnct
 DISTINCT
#T=and
 AND
#T=or
 OR
#T=not
 NOT
#T=like
 LIKE
#T=null
 NULL
#T=is
 IS
#T=*** GLOBAL VARIABLES ***
---
#T=@@rowcount
 @@ROWCOUNT
#T=@@options
 @@OPTIONS
#T=@@error
 @@ERROR
#T=*** SYSTEM FUNCTIONS ***
---
#T=col_name (object_id, column_id [, database_id ])
 col_name ( , , )
#T=col_length (object_name, column_name)
 col_length ( , )
#T=convert(datatype, expression [, style] ) 
 convert( ,  , ) 
#T=db_id ([ database_name]) 
 db_id ( ) 
#T=db_name ([database_id ])
 db_name ( )
#T=index_col (object_name, index_id , key_ &num;[, user_id ])
 index_col ( ,  , , )
#T=isnull (expression1, expression2)
 ISNULL (  ,  )
#T=object_id   (object_name) 
 object_id ( ) 
#T=object_name (object_id [, database_id ])
 object_name ( , )
#T=suser_id ([server_user_name])
 suser_id  ( )
#T=suser_name ([server_user_id])
 suser_name ( ) 
#T=user 
 user  
#T=user_id ([user_name]) 
 user_id ( ) 
#T=user_name ([user_id]) 
 user_name ( )  
#T=valid_name  (character_expression) 
 valid_name ( )
#T=valid_user (server_user_id)
 valid_user ( )
#T=*** STRING & TEXT FUNCTIONS ***
---
#T=ascii (char_expr)
 ascii ( )
#T=char (int_expr)
 char ( )
#T=charindex  (expression1, expression2)
 charindex  ( , )
#T=char_length  (char_expr)
 char_length ( )
#T=difference (char_expr1, char_expr2)
 difference ( , )
#T=lower (char_expr)
 lower ( )
#T=ltrim(char_expr)
 ltrim( )
#T=patindex  ("%pattern%", char_expr [using {bytes | chars | characters}])
 patindex  ("%pattern%", )
#T=replicate(char_expr, integer_expr)
 replicate( , )
#T=reverse (expression)
 reverse ( )
#T=right(expression, integer_expr)
 right( ,  )
#T=rtrim(char_expr)
 rtrim( )
#T=soundex(char_expr)
 soundex(char_expr)
#T=space(integer_expr)
 space( )
#T=str(approx_numeric [, length [, decimal] ])
 str(  , , )
#T=stuff(char_expr1, start, length, char_expr2)
 stuff( , , , )
#T=substring(expression, start, length)
 substring( , , )
#T=to_unichar(integer_expr)
 to_unichar( )
#T=upper(char_expr)
 upper( )
#T=uhighsurr(unichar_expr, start)
 uhighsurr( ,  )
#T=ulowsurr(unichar_expr, start)
 ulowsurr( , )
#T=uscalar(unichar_expr)
 uscalar( )
#T=textptr (text_columname)
 textptr ( )
#T=textvalid ("table_name..col_name", textpointer)
 textvalid ( ,  )
#T=*** AGCREGATE FUNCTIONS ***
---
#T=avg( [distinct] col_name | all)
 avg( )
#T=count([distinct] col_name | all) 
 count( )
#T=max(expression)
 max( )
#T=min (expression)
 min( )
#T=sum([distinct] col_name | all)
 sum( )
#T=*** MATH FUNCTIONS ***
---
#T=abs(numeric)
 abs( )
#T=acos(approx_numeric)
 acos( )
#T=asin(approx_numeric)
 asin( )
#T=atan(approx_numeric)
 atan( )
#T=atn2(approx_numeric1, approx_numeric2)
 atn2( , )
#T=ceiling(numeric)
 ceiling( )
#T=cos(approx_numeric)
 cos( )
#T=cot(approx_numeric)
 cot( )
#T=degrees(numeric)
 degrees( )
#T=exp(approx_numeric)
 exp( )
#T=floor(numeric)
 floor( )
#T=log(approx_numeric)
 log( )
#T=log10(approx_numeric)
 log10( )
#T=pi( )
 pi( )
#T=power(numeric, power) 
 power( , )
#T=radians(numeric_expr)
 radians( )
#T=rand([integer])
 rand( )
#T=round(numeric, integer)
 round( )
#T=sign(numeric)
 sign( )
#T=sin(approx_numeric)
 sin( )
#T=sqrt(approx_numeric)
 sqrt( )
#T=tan(approx_numeric)
 tan( )
#T=*** DATE FUNCTIONS ***
---
#T=getdate( )
 getdate( )
#T=datename(datepart, date)
 datename( , )
#T=datepart(datepart, date)
 datepart( , ) 
#T=datediff (datepart, date, date)
 datediff( , , )
#T=dateadd(datepart, number, date)
 dateadd( , , )
#T=*** CONTROL OF FLOW ***
---
#T=if
IF
#T=else 
ELSE
#T=if...else
IF

ELSE
#T=case...when...then
CASE
	WHEN

	THEN
#T=when
WHEN
#T=then
THEN
#T=begin
BEGIN
#T=end
END
#T=begin...end
BEGIN

END
#T=while 
WHILE
#T=break 
BREAK
#T=continue 
CONTINUE
#T=declare <variable>
DECLARE
#T=goto <label> 
GOTO 
#T=return 
RETURN
#T=waitfor 
WAITFOR
#T=print 
PRINT
#T=raiserror 
RAISERROR
#T=*** CURSOR ***
---
#T=declare cursor
DECLARE <name> CURSOR 
FOR 
SELECT 
#T=open cursor
OPEN 
#T=fetch cursor row	
FETCH <cursor> INTO <list>
#T=close cursor
CLOSE <cursor>
#T=deallocate
DEALLOCATE CURSOR <cursor>
#T=get cursor details
sp_cursorinfo <int_level>, <cursor>

#T=*** DDL STATMENTS ***
---
#T=create database
CREATE DATABASE <db_name>
     [ON {default | database_device} [= size]  
           [, database_device [= size]]...] 
     [LOG ON  database_device [= size] 
           [, database_device [= size]]...]
     [WITH OVERRIDE]
     [FOR LOAD]
#T=alter database
ALTER DATABASE <db_name>
     [ON {default | database_device } [= size]
          [, database_device [= size]]...] 
     [LOG ON { default | database_device } [ = size ]
          [ , database_device [= size]]...] 
     [WITH OVERRIDE]
     [FOR LOAD]
#T=drop database
DROP DATABASE <db_name> [, database_name]
#T=create table
CREATE TABLE <table_name>
(<col_name> <datatype>  [{IDENTITY | NULL | NOT NULL}] ...)
#T=alter table
ALTER  TABLE <table_name>
[ADD <col_name> <datatype>  [{IDENTITY | NULL | NOT NULL}] ... ]
[DROP <col_name> [, <col_name>]
[MODIFY <col_name> [<datatype>] [NULL | NOT NULL] ...]
#T=drop table
DROP TABLE [[database.]owner.] <table> [, [[database.]owner.] <table>...]
#T=create index
CREATE [UNIQUE] [CLUSTERED | NONCLUSTERED] INDEX <index>
ON [[database.]owner.] <table_name> ( <col_name>          [, <col_name>]...) 
#T=drop index
DROP INDEX <table_name>.<index_name> [, <table_name>.<index_name> ...]
#T=create procedure 
CREATE PROCEDURE [owner.]<proc_name>
[(	 <@parar_name> <datatype>  [= <default>][OUTPUT] 
	[, <@parar_name> <datatype>  [= <default>][OUTPUT]...]
)] [WITH RECOMPILE]
AS 
BEGIN
	DECLARE
	SELECT
END 
RETURN 
#T=drop procedure
DROP PROCEDURE [owner.]<proc_name>
#T=create trigger
CREATE TRIGGER [owner.]<trigger_name>
ON [owner.]<table_name>
{FOR {INSERT, UPDATE, DELETE}\
AS 

#T=disable trigger
ALTER TABLE <table_name>
{ENABLE | DIABLE } TRIGGER [<trigger_name>]
#T=drop trigger
DROP TRIGGER [owner.]<trigger_name> [, [owner.]<trigger_name>... ]
#T=create view
CREATE VIEW [owner .]<view_name>  
     [(<col_name>  [, <col_name> ]...)] 
AS SELECT ...
[WITH CHECK OPTION]
#T=drop view
DROP VIEW [owner.] <view> [, [owner.] <view>...]
#T=*** DML STATMENTS ***
---
#T=select...from...where
SELECT
FROM 
WHERE
#T=select...into
SELECT
INTO
#T=from
FROM
#T=where
WHERE
#T=order by
ORDER BY
#T=group by
GROUP BY
#T=having
HAVING
#T=insert
INSERT <table> ( )
#T=values 
VALUES ( )
#T=update
UPDATE <table>
SET <col> = <val>
#T=delete
DELETE <table>
#T=*** TRANSACTIONS ***
---
#T=begin tran
BEGIN TRAN <tran_name>
#T=savepoint
SAVE TRAN <savepoint_name>
#T=commit tran
COMMIT TRAN [<tran_name> ]
#T=rollback tran
ROLLBACK TRAN [<tran_name> | <savepoint_name>]
#