#include "cp_types.h"
#include "cp_proto.h"

/* called only by 'add_barys'; put trivalent 
vert in face f; data not updated between calls. */

int add_barycenter(struct p_data *p,int f)
{
  int i,j,v,w,new,indx,*newflower;
  double *newol;
  struct K_data *pK_ptr;
  struct R_data *pR_ptr;
	
  pK_ptr=p->packK_ptr;pR_ptr=p->packR_ptr;
  /* add new vertex */
  new=p->nodecount+1;
  p->nodecount++;
  pK_ptr[new].num=3;
  pK_ptr[new].flower=(int *)calloc((size_t)4,sizeof(int));
  pK_ptr[new].flower[0]=pK_ptr[new].flower[3]=p->faces[f].vert[0];
  pK_ptr[new].flower[1]=p->faces[f].vert[1];
  pK_ptr[new].flower[2]=p->faces[f].vert[2];
  if (p->overlap_status)
    {
      pK_ptr[new].overlaps=(double *)calloc((size_t)4,sizeof(double));
      pK_ptr[new].overlaps[0]=pK_ptr[new].overlaps[1]
	=pK_ptr[new].overlaps[2]=pK_ptr[new].overlaps[3]=1.0;
    }
  pK_ptr[new].bdry_flag=0;
  pK_ptr[new].mark=0;
  pK_ptr[new].color=FG_COLOR;
  pR_ptr[new].rad=pR_ptr[p->faces[f].vert[0]].rad;
  pR_ptr[new].aim=2.0*M_PI;
  /* compute packed radius */
  if (p->hes<0) h_riffle_vert(p,new);
  else if (p->hes>0) s_riffle_vert(p,new);
  else e_riffle_vert(p,new);
  if (p->hes<=0)
    {
      pR_ptr[new].center.re=
	(pR_ptr[p->faces[f].vert[0]].center.re
	 +pR_ptr[p->faces[f].vert[1]].center.re
	 +pR_ptr[p->faces[f].vert[2]].center.re)/3.0;
      pR_ptr[new].center.im=
	(pR_ptr[p->faces[f].vert[0]].center.im
	 +pR_ptr[p->faces[f].vert[1]].center.im
	 +pR_ptr[p->faces[f].vert[2]].center.im)/3.0;
    }
  else {pR_ptr[new].center.re=0.0;pR_ptr[new].center.re=M_PI;}
  /* adjust nghb flowers */
  for (i=0;i<3;i++)
    {
      v=p->faces[f].vert[i];
      w=p->faces[f].vert[(i+1)%3];
      indx=nghb(p,v,w);
      newflower=(int *)calloc((size_t)(pK_ptr[v].num+2),
			      sizeof(int));
      for (j=0;j<=indx;j++) newflower[j]=pK_ptr[v].flower[j];
      for (j=pK_ptr[v].num;j>indx;j--)
	newflower[j+1]=pK_ptr[v].flower[j];
      newflower[indx+1]=new;
      free(pK_ptr[v].flower);
      pK_ptr[v].flower=newflower;
      if (p->overlap_status)
	{
	  newol=(double *)calloc((size_t)(pK_ptr[v].num+2),sizeof(double));
	  for (j=0;j<=indx;j++) newol[j]=pK_ptr[v].overlaps[j];
	  for (j=pK_ptr[v].num;j>indx;j--)
	    newol[j+1]=pK_ptr[v].overlaps[j];
	  newol[indx+1]=1.0;
	  free(pK_ptr[v].overlaps);
	  pK_ptr[v].overlaps=newol;
	}
      pK_ptr[v].num++;
    }
  return 1;
} /* add_barycenter */
