#include "cp_types.h"
#include "cp_proto.h"

extern int **face_org;

int catalog_faces(struct p_data *p)
     /* Build array of ptrs, one for each vertex v. Point 
to list of indices of face v is in. In list for v, 0 entry is
num of faces v has, followed by face 1, face 2, .... 
Eg. face 1 in list contains v, flower[0], and flower[1]. */
{
  int v,j,f,w,n,*face_ptr;
  struct K_data *pK_ptr;

  if (face_org)  /* Note: this orphans the saved space, so 
		    face_org should be cleared before this routine */
    {
      free(face_org);
      sprintf(msgbuf,"Ran 'catalog_faces' with face_org already set.");
      emsg();
    }
  face_org=(void *)calloc((size_t)(p->nodecount+1),sizeof(int *));
  pK_ptr=p->packK_ptr;
  for (v=1;v<=p->nodecount;v++)
    {
      face_org[v]=(int *)
	calloc((size_t)(pK_ptr[v].num+2),sizeof(int));
      *(face_org[v])=pK_ptr[v].num;
    }
  if (!p->faces) alloc_faces_space(p);
  for (f=1;f<=p->facecount;f++)
    for (j=0;j<3;j++)
      {
	v=p->faces[f].vert[j];
	face_ptr=face_org[v];	
	w=p->faces[f].vert[(j+1)%3];
	n=nghb(p,v,w);
	*(face_ptr+(n+1))=f;
      }
  return 1;		
} /* catalog_faces */

int destroy_catalog(int nodecount)
     /* free memory from catalog_faces */
{
  int v;

  if (face_org)
    {
      for (v=1;v<=nodecount;v++)
	if (face_org[v]) free(face_org[v]);
      free(face_org);
      face_org=NULL;
    }
  return 1;
} /* destroy_catalog */
